# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

from enum import Enum

__all__ = [
    'AssessmentStatusCode',
    'AssessmentType',
    'Categories',
    'ImplementationEffort',
    'Protocol',
    'Severity',
    'Source',
    'Status',
    'StatusReason',
    'Threats',
    'UserImpact',
]


class AssessmentStatusCode(str, Enum):
    """
    Programmatic code for the status of the assessment
    """
    HEALTHY = "Healthy"
    """
    The resource is healthy
    """
    UNHEALTHY = "Unhealthy"
    """
    The resource has a security issue that needs to be addressed
    """
    NOT_APPLICABLE = "NotApplicable"
    """
    Assessment for this resource did not happen
    """


class AssessmentType(str, Enum):
    """
    BuiltIn if the assessment based on built-in Azure Policy definition, Custom if the assessment based on custom Azure Policy definition
    """
    BUILT_IN = "BuiltIn"
    """
    Microsoft Defender for Cloud managed assessments
    """
    CUSTOM_POLICY = "CustomPolicy"
    """
    User defined policies that are automatically ingested from Azure Policy to Microsoft Defender for Cloud
    """
    CUSTOMER_MANAGED = "CustomerManaged"
    """
    User assessments pushed directly by the user or other third party to Microsoft Defender for Cloud
    """
    VERIFIED_PARTNER = "VerifiedPartner"
    """
    An assessment that was created by a verified 3rd party if the user connected it to ASC
    """


class Categories(str, Enum):
    """
    The categories of resource that is at risk when the assessment is unhealthy
    """
    COMPUTE = "Compute"
    NETWORKING = "Networking"
    DATA = "Data"
    IDENTITY_AND_ACCESS = "IdentityAndAccess"
    IO_T = "IoT"


class ImplementationEffort(str, Enum):
    """
    The implementation effort required to remediate this assessment
    """
    LOW = "Low"
    MODERATE = "Moderate"
    HIGH = "High"


class Protocol(str, Enum):
    TCP = "TCP"
    UDP = "UDP"
    ALL = "*"


class Severity(str, Enum):
    """
    The severity level of the assessment
    """
    LOW = "Low"
    MEDIUM = "Medium"
    HIGH = "High"


class Source(str, Enum):
    """
    The platform where the assessed resource resides
    """
    AZURE = "Azure"
    """
    Resource is in Azure
    """
    ON_PREMISE = "OnPremise"
    """
    Resource in an on premise machine connected to Azure cloud
    """
    ON_PREMISE_SQL = "OnPremiseSql"
    """
    SQL Resource in an on premise machine connected to Azure cloud
    """


class Status(str, Enum):
    """
    The status of the port
    """
    REVOKED = "Revoked"
    INITIATED = "Initiated"


class StatusReason(str, Enum):
    """
    A description of why the `status` has its value
    """
    EXPIRED = "Expired"
    USER_REQUESTED = "UserRequested"
    NEWER_REQUEST_INITIATED = "NewerRequestInitiated"


class Threats(str, Enum):
    """
    Threats impact of the assessment
    """
    ACCOUNT_BREACH = "accountBreach"
    DATA_EXFILTRATION = "dataExfiltration"
    DATA_SPILLAGE = "dataSpillage"
    MALICIOUS_INSIDER = "maliciousInsider"
    ELEVATION_OF_PRIVILEGE = "elevationOfPrivilege"
    THREAT_RESISTANCE = "threatResistance"
    MISSING_COVERAGE = "missingCoverage"
    DENIAL_OF_SERVICE = "denialOfService"


class UserImpact(str, Enum):
    """
    The user impact of the assessment
    """
    LOW = "Low"
    MODERATE = "Moderate"
    HIGH = "High"
