# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AccountPropertiesResponseEndpoints',
    'AccountPropertiesResponseManagedResources',
    'AccountPropertiesResponseSystemData',
    'AccountResponseSku',
    'CloudConnectorsResponse',
    'IdentityResponse',
    'PrivateEndpointConnectionResponse',
    'PrivateEndpointResponse',
    'PrivateLinkServiceConnectionStateResponse',
]

@pulumi.output_type
class AccountPropertiesResponseEndpoints(dict):
    """
    The URIs that are the public endpoints of the account.
    """
    def __init__(__self__, *,
                 catalog: str,
                 guardian: str,
                 scan: str):
        """
        The URIs that are the public endpoints of the account.
        :param str catalog: Gets the catalog endpoint.
        :param str guardian: Gets the guardian endpoint.
        :param str scan: Gets the scan endpoint.
        """
        pulumi.set(__self__, "catalog", catalog)
        pulumi.set(__self__, "guardian", guardian)
        pulumi.set(__self__, "scan", scan)

    @property
    @pulumi.getter
    def catalog(self) -> str:
        """
        Gets the catalog endpoint.
        """
        return pulumi.get(self, "catalog")

    @property
    @pulumi.getter
    def guardian(self) -> str:
        """
        Gets the guardian endpoint.
        """
        return pulumi.get(self, "guardian")

    @property
    @pulumi.getter
    def scan(self) -> str:
        """
        Gets the scan endpoint.
        """
        return pulumi.get(self, "scan")


@pulumi.output_type
class AccountPropertiesResponseManagedResources(dict):
    """
    Gets the resource identifiers of the managed resources.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "eventHubNamespace":
            suggest = "event_hub_namespace"
        elif key == "resourceGroup":
            suggest = "resource_group"
        elif key == "storageAccount":
            suggest = "storage_account"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccountPropertiesResponseManagedResources. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccountPropertiesResponseManagedResources.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccountPropertiesResponseManagedResources.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 event_hub_namespace: str,
                 resource_group: str,
                 storage_account: str):
        """
        Gets the resource identifiers of the managed resources.
        :param str event_hub_namespace: Gets the managed event hub namespace resource identifier.
        :param str resource_group: Gets the managed resource group resource identifier. This resource group will host resource dependencies for the account.
        :param str storage_account: Gets the managed storage account resource identifier.
        """
        pulumi.set(__self__, "event_hub_namespace", event_hub_namespace)
        pulumi.set(__self__, "resource_group", resource_group)
        pulumi.set(__self__, "storage_account", storage_account)

    @property
    @pulumi.getter(name="eventHubNamespace")
    def event_hub_namespace(self) -> str:
        """
        Gets the managed event hub namespace resource identifier.
        """
        return pulumi.get(self, "event_hub_namespace")

    @property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> str:
        """
        Gets the managed resource group resource identifier. This resource group will host resource dependencies for the account.
        """
        return pulumi.get(self, "resource_group")

    @property
    @pulumi.getter(name="storageAccount")
    def storage_account(self) -> str:
        """
        Gets the managed storage account resource identifier.
        """
        return pulumi.get(self, "storage_account")


@pulumi.output_type
class AccountPropertiesResponseSystemData(dict):
    """
    Metadata pertaining to creation and last modification of the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdAt":
            suggest = "created_at"
        elif key == "createdBy":
            suggest = "created_by"
        elif key == "createdByType":
            suggest = "created_by_type"
        elif key == "lastModifiedAt":
            suggest = "last_modified_at"
        elif key == "lastModifiedBy":
            suggest = "last_modified_by"
        elif key == "lastModifiedByType":
            suggest = "last_modified_by_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccountPropertiesResponseSystemData. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccountPropertiesResponseSystemData.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccountPropertiesResponseSystemData.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_at: str,
                 created_by: str,
                 created_by_type: str,
                 last_modified_at: str,
                 last_modified_by: str,
                 last_modified_by_type: str):
        """
        Metadata pertaining to creation and last modification of the resource.
        :param str created_at: The timestamp of resource creation (UTC).
        :param str created_by: The identity that created the resource.
        :param str created_by_type: The type of identity that created the resource.
        :param str last_modified_at: The timestamp of the last modification the resource (UTC).
        :param str last_modified_by: The identity that last modified the resource.
        :param str last_modified_by_type: The type of identity that last modified the resource.
        """
        pulumi.set(__self__, "created_at", created_at)
        pulumi.set(__self__, "created_by", created_by)
        pulumi.set(__self__, "created_by_type", created_by_type)
        pulumi.set(__self__, "last_modified_at", last_modified_at)
        pulumi.set(__self__, "last_modified_by", last_modified_by)
        pulumi.set(__self__, "last_modified_by_type", last_modified_by_type)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> str:
        """
        The timestamp of resource creation (UTC).
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> str:
        """
        The identity that created the resource.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="createdByType")
    def created_by_type(self) -> str:
        """
        The type of identity that created the resource.
        """
        return pulumi.get(self, "created_by_type")

    @property
    @pulumi.getter(name="lastModifiedAt")
    def last_modified_at(self) -> str:
        """
        The timestamp of the last modification the resource (UTC).
        """
        return pulumi.get(self, "last_modified_at")

    @property
    @pulumi.getter(name="lastModifiedBy")
    def last_modified_by(self) -> str:
        """
        The identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by")

    @property
    @pulumi.getter(name="lastModifiedByType")
    def last_modified_by_type(self) -> str:
        """
        The type of identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by_type")


@pulumi.output_type
class AccountResponseSku(dict):
    """
    Gets or sets the Sku.
    """
    def __init__(__self__, *,
                 capacity: Optional[int] = None,
                 name: Optional[str] = None):
        """
        Gets or sets the Sku.
        :param int capacity: Gets or sets the sku capacity.
        :param str name: Gets or sets the sku name.
        """
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def capacity(self) -> Optional[int]:
        """
        Gets or sets the sku capacity.
        """
        return pulumi.get(self, "capacity")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Gets or sets the sku name.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class CloudConnectorsResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "awsExternalId":
            suggest = "aws_external_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CloudConnectorsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CloudConnectorsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CloudConnectorsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 aws_external_id: str):
        """
        :param str aws_external_id: AWS external identifier.
               Configured in AWS to allow use of the role arn used for scanning
        """
        pulumi.set(__self__, "aws_external_id", aws_external_id)

    @property
    @pulumi.getter(name="awsExternalId")
    def aws_external_id(self) -> str:
        """
        AWS external identifier.
        Configured in AWS to allow use of the role arn used for scanning
        """
        return pulumi.get(self, "aws_external_id")


@pulumi.output_type
class IdentityResponse(dict):
    """
    The Managed Identity of the resource
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IdentityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IdentityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IdentityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 principal_id: str,
                 tenant_id: str,
                 type: Optional[str] = None):
        """
        The Managed Identity of the resource
        :param str principal_id: Service principal object Id
        :param str tenant_id: Tenant Id
        :param str type: Identity Type
        """
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> str:
        """
        Service principal object Id
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> str:
        """
        Tenant Id
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Identity Type
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class PrivateEndpointConnectionResponse(dict):
    """
    A private endpoint connection class.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "privateEndpoint":
            suggest = "private_endpoint"
        elif key == "privateLinkServiceConnectionState":
            suggest = "private_link_service_connection_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrivateEndpointConnectionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrivateEndpointConnectionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrivateEndpointConnectionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: str,
                 name: str,
                 provisioning_state: str,
                 type: str,
                 private_endpoint: Optional['outputs.PrivateEndpointResponse'] = None,
                 private_link_service_connection_state: Optional['outputs.PrivateLinkServiceConnectionStateResponse'] = None):
        """
        A private endpoint connection class.
        :param str id: Gets or sets the identifier.
        :param str name: Gets or sets the name.
        :param str provisioning_state: The provisioning state.
        :param str type: Gets or sets the type.
        :param 'PrivateEndpointResponse' private_endpoint: The private endpoint information.
        :param 'PrivateLinkServiceConnectionStateResponse' private_link_service_connection_state: The private link service connection state.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "type", type)
        if private_endpoint is not None:
            pulumi.set(__self__, "private_endpoint", private_endpoint)
        if private_link_service_connection_state is not None:
            pulumi.set(__self__, "private_link_service_connection_state", private_link_service_connection_state)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Gets or sets the identifier.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Gets or sets the name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Gets or sets the type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="privateEndpoint")
    def private_endpoint(self) -> Optional['outputs.PrivateEndpointResponse']:
        """
        The private endpoint information.
        """
        return pulumi.get(self, "private_endpoint")

    @property
    @pulumi.getter(name="privateLinkServiceConnectionState")
    def private_link_service_connection_state(self) -> Optional['outputs.PrivateLinkServiceConnectionStateResponse']:
        """
        The private link service connection state.
        """
        return pulumi.get(self, "private_link_service_connection_state")


@pulumi.output_type
class PrivateEndpointResponse(dict):
    """
    A private endpoint class.
    """
    def __init__(__self__, *,
                 id: Optional[str] = None):
        """
        A private endpoint class.
        :param str id: The private endpoint identifier.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The private endpoint identifier.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class PrivateLinkServiceConnectionStateResponse(dict):
    """
    The private link service connection state.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "actionsRequired":
            suggest = "actions_required"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrivateLinkServiceConnectionStateResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrivateLinkServiceConnectionStateResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrivateLinkServiceConnectionStateResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 actions_required: Optional[str] = None,
                 description: Optional[str] = None,
                 status: Optional[str] = None):
        """
        The private link service connection state.
        :param str actions_required: The required actions.
        :param str description: The description.
        :param str status: The status.
        """
        if actions_required is not None:
            pulumi.set(__self__, "actions_required", actions_required)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="actionsRequired")
    def actions_required(self) -> Optional[str]:
        """
        The required actions.
        """
        return pulumi.get(self, "actions_required")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        The status.
        """
        return pulumi.get(self, "status")


