# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AddRemoveReplicaScalingMechanismResponse',
    'ApplicationScopedVolumeCreationParametersServiceFabricVolumeDiskResponse',
    'ApplicationScopedVolumeResponse',
    'AutoScalingPolicyResponse',
    'AutoScalingResourceMetricResponse',
    'AverageLoadScalingTriggerResponse',
    'AzureInternalMonitoringPipelineSinkDescriptionResponse',
    'ContainerCodePackagePropertiesResponse',
    'ContainerEventResponse',
    'ContainerInstanceViewResponse',
    'ContainerLabelResponse',
    'ContainerStateResponse',
    'DiagnosticsDescriptionResponse',
    'DiagnosticsRefResponse',
    'EndpointPropertiesResponse',
    'EndpointRefResponse',
    'EnvironmentVariableResponse',
    'GatewayDestinationResponse',
    'HttpConfigResponse',
    'HttpHostConfigResponse',
    'HttpRouteConfigResponse',
    'HttpRouteMatchHeaderResponse',
    'HttpRouteMatchPathResponse',
    'HttpRouteMatchRuleResponse',
    'ImageRegistryCredentialResponse',
    'NetworkRefResponse',
    'NetworkResourcePropertiesResponse',
    'ReliableCollectionsRefResponse',
    'ResourceLimitsResponse',
    'ResourceRequestsResponse',
    'ResourceRequirementsResponse',
    'SecretResourcePropertiesResponse',
    'ServiceResourceDescriptionResponse',
    'SettingResponse',
    'TcpConfigResponse',
    'VolumeProviderParametersAzureFileResponse',
    'VolumeReferenceResponse',
]

@pulumi.output_type
class AddRemoveReplicaScalingMechanismResponse(dict):
    """
    Describes the horizontal auto scaling mechanism that adds or removes replicas (containers or container groups).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxCount":
            suggest = "max_count"
        elif key == "minCount":
            suggest = "min_count"
        elif key == "scaleIncrement":
            suggest = "scale_increment"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AddRemoveReplicaScalingMechanismResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AddRemoveReplicaScalingMechanismResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AddRemoveReplicaScalingMechanismResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kind: str,
                 max_count: int,
                 min_count: int,
                 scale_increment: int):
        """
        Describes the horizontal auto scaling mechanism that adds or removes replicas (containers or container groups).
        :param str kind: Enumerates the mechanisms for auto scaling.
               Expected value is 'AddRemoveReplica'.
        :param int max_count: Maximum number of containers (scale up won't be performed above this number).
        :param int min_count: Minimum number of containers (scale down won't be performed below this number).
        :param int scale_increment: Each time auto scaling is performed, this number of containers will be added or removed.
        """
        pulumi.set(__self__, "kind", 'AddRemoveReplica')
        pulumi.set(__self__, "max_count", max_count)
        pulumi.set(__self__, "min_count", min_count)
        pulumi.set(__self__, "scale_increment", scale_increment)

    @property
    @pulumi.getter
    def kind(self) -> str:
        """
        Enumerates the mechanisms for auto scaling.
        Expected value is 'AddRemoveReplica'.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter(name="maxCount")
    def max_count(self) -> int:
        """
        Maximum number of containers (scale up won't be performed above this number).
        """
        return pulumi.get(self, "max_count")

    @property
    @pulumi.getter(name="minCount")
    def min_count(self) -> int:
        """
        Minimum number of containers (scale down won't be performed below this number).
        """
        return pulumi.get(self, "min_count")

    @property
    @pulumi.getter(name="scaleIncrement")
    def scale_increment(self) -> int:
        """
        Each time auto scaling is performed, this number of containers will be added or removed.
        """
        return pulumi.get(self, "scale_increment")


@pulumi.output_type
class ApplicationScopedVolumeCreationParametersServiceFabricVolumeDiskResponse(dict):
    """
    Describes parameters for creating application-scoped volumes provided by Service Fabric Volume Disks
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sizeDisk":
            suggest = "size_disk"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationScopedVolumeCreationParametersServiceFabricVolumeDiskResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationScopedVolumeCreationParametersServiceFabricVolumeDiskResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationScopedVolumeCreationParametersServiceFabricVolumeDiskResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kind: str,
                 size_disk: str,
                 description: Optional[str] = None):
        """
        Describes parameters for creating application-scoped volumes provided by Service Fabric Volume Disks
        :param str kind: Specifies the application-scoped volume kind.
               Expected value is 'ServiceFabricVolumeDisk'.
        :param str size_disk: Volume size
        :param str description: User readable description of the volume.
        """
        pulumi.set(__self__, "kind", 'ServiceFabricVolumeDisk')
        pulumi.set(__self__, "size_disk", size_disk)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def kind(self) -> str:
        """
        Specifies the application-scoped volume kind.
        Expected value is 'ServiceFabricVolumeDisk'.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter(name="sizeDisk")
    def size_disk(self) -> str:
        """
        Volume size
        """
        return pulumi.get(self, "size_disk")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        User readable description of the volume.
        """
        return pulumi.get(self, "description")


@pulumi.output_type
class ApplicationScopedVolumeResponse(dict):
    """
    Describes a volume whose lifetime is scoped to the application's lifetime.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "creationParameters":
            suggest = "creation_parameters"
        elif key == "destinationPath":
            suggest = "destination_path"
        elif key == "readOnly":
            suggest = "read_only"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationScopedVolumeResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationScopedVolumeResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationScopedVolumeResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 creation_parameters: 'outputs.ApplicationScopedVolumeCreationParametersServiceFabricVolumeDiskResponse',
                 destination_path: str,
                 name: str,
                 read_only: Optional[bool] = None):
        """
        Describes a volume whose lifetime is scoped to the application's lifetime.
        :param 'ApplicationScopedVolumeCreationParametersServiceFabricVolumeDiskResponse' creation_parameters: Describes parameters for creating application-scoped volumes.
        :param str destination_path: The path within the container at which the volume should be mounted. Only valid path characters are allowed.
        :param str name: Name of the volume being referenced.
        :param bool read_only: The flag indicating whether the volume is read only. Default is 'false'.
        """
        pulumi.set(__self__, "creation_parameters", creation_parameters)
        pulumi.set(__self__, "destination_path", destination_path)
        pulumi.set(__self__, "name", name)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)

    @property
    @pulumi.getter(name="creationParameters")
    def creation_parameters(self) -> 'outputs.ApplicationScopedVolumeCreationParametersServiceFabricVolumeDiskResponse':
        """
        Describes parameters for creating application-scoped volumes.
        """
        return pulumi.get(self, "creation_parameters")

    @property
    @pulumi.getter(name="destinationPath")
    def destination_path(self) -> str:
        """
        The path within the container at which the volume should be mounted. Only valid path characters are allowed.
        """
        return pulumi.get(self, "destination_path")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the volume being referenced.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[bool]:
        """
        The flag indicating whether the volume is read only. Default is 'false'.
        """
        return pulumi.get(self, "read_only")


@pulumi.output_type
class AutoScalingPolicyResponse(dict):
    """
    Describes the auto scaling policy
    """
    def __init__(__self__, *,
                 mechanism: 'outputs.AddRemoveReplicaScalingMechanismResponse',
                 name: str,
                 trigger: 'outputs.AverageLoadScalingTriggerResponse'):
        """
        Describes the auto scaling policy
        :param 'AddRemoveReplicaScalingMechanismResponse' mechanism: The mechanism that is used to scale when auto scaling operation is invoked.
        :param str name: The name of the auto scaling policy.
        :param 'AverageLoadScalingTriggerResponse' trigger: Determines when auto scaling operation will be invoked.
        """
        pulumi.set(__self__, "mechanism", mechanism)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "trigger", trigger)

    @property
    @pulumi.getter
    def mechanism(self) -> 'outputs.AddRemoveReplicaScalingMechanismResponse':
        """
        The mechanism that is used to scale when auto scaling operation is invoked.
        """
        return pulumi.get(self, "mechanism")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the auto scaling policy.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def trigger(self) -> 'outputs.AverageLoadScalingTriggerResponse':
        """
        Determines when auto scaling operation will be invoked.
        """
        return pulumi.get(self, "trigger")


@pulumi.output_type
class AutoScalingResourceMetricResponse(dict):
    """
    Describes the resource that is used for triggering auto scaling.
    """
    def __init__(__self__, *,
                 kind: str,
                 name: str):
        """
        Describes the resource that is used for triggering auto scaling.
        :param str kind: Enumerates the metrics that are used for triggering auto scaling.
               Expected value is 'Resource'.
        :param str name: Name of the resource.
        """
        pulumi.set(__self__, "kind", 'Resource')
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def kind(self) -> str:
        """
        Enumerates the metrics that are used for triggering auto scaling.
        Expected value is 'Resource'.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the resource.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class AverageLoadScalingTriggerResponse(dict):
    """
    Describes the average load trigger used for auto scaling.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lowerLoadThreshold":
            suggest = "lower_load_threshold"
        elif key == "scaleIntervalInSeconds":
            suggest = "scale_interval_in_seconds"
        elif key == "upperLoadThreshold":
            suggest = "upper_load_threshold"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AverageLoadScalingTriggerResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AverageLoadScalingTriggerResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AverageLoadScalingTriggerResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kind: str,
                 lower_load_threshold: float,
                 metric: 'outputs.AutoScalingResourceMetricResponse',
                 scale_interval_in_seconds: int,
                 upper_load_threshold: float):
        """
        Describes the average load trigger used for auto scaling.
        :param str kind: Enumerates the triggers for auto scaling.
               Expected value is 'AverageLoad'.
        :param float lower_load_threshold: Lower load threshold (if average load is below this threshold, service will scale down).
        :param 'AutoScalingResourceMetricResponse' metric: Description of the metric that is used for scaling.
        :param int scale_interval_in_seconds: Scale interval that indicates how often will this trigger be checked.
        :param float upper_load_threshold: Upper load threshold (if average load is above this threshold, service will scale up).
        """
        pulumi.set(__self__, "kind", 'AverageLoad')
        pulumi.set(__self__, "lower_load_threshold", lower_load_threshold)
        pulumi.set(__self__, "metric", metric)
        pulumi.set(__self__, "scale_interval_in_seconds", scale_interval_in_seconds)
        pulumi.set(__self__, "upper_load_threshold", upper_load_threshold)

    @property
    @pulumi.getter
    def kind(self) -> str:
        """
        Enumerates the triggers for auto scaling.
        Expected value is 'AverageLoad'.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter(name="lowerLoadThreshold")
    def lower_load_threshold(self) -> float:
        """
        Lower load threshold (if average load is below this threshold, service will scale down).
        """
        return pulumi.get(self, "lower_load_threshold")

    @property
    @pulumi.getter
    def metric(self) -> 'outputs.AutoScalingResourceMetricResponse':
        """
        Description of the metric that is used for scaling.
        """
        return pulumi.get(self, "metric")

    @property
    @pulumi.getter(name="scaleIntervalInSeconds")
    def scale_interval_in_seconds(self) -> int:
        """
        Scale interval that indicates how often will this trigger be checked.
        """
        return pulumi.get(self, "scale_interval_in_seconds")

    @property
    @pulumi.getter(name="upperLoadThreshold")
    def upper_load_threshold(self) -> float:
        """
        Upper load threshold (if average load is above this threshold, service will scale up).
        """
        return pulumi.get(self, "upper_load_threshold")


@pulumi.output_type
class AzureInternalMonitoringPipelineSinkDescriptionResponse(dict):
    """
    Diagnostics settings for Geneva.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accountName":
            suggest = "account_name"
        elif key == "autoKeyConfigUrl":
            suggest = "auto_key_config_url"
        elif key == "fluentdConfigUrl":
            suggest = "fluentd_config_url"
        elif key == "maConfigUrl":
            suggest = "ma_config_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureInternalMonitoringPipelineSinkDescriptionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureInternalMonitoringPipelineSinkDescriptionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureInternalMonitoringPipelineSinkDescriptionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kind: str,
                 account_name: Optional[str] = None,
                 auto_key_config_url: Optional[str] = None,
                 description: Optional[str] = None,
                 fluentd_config_url: Optional[Any] = None,
                 ma_config_url: Optional[str] = None,
                 name: Optional[str] = None,
                 namespace: Optional[str] = None):
        """
        Diagnostics settings for Geneva.
        :param str kind: The kind of DiagnosticsSink.
               Expected value is 'AzureInternalMonitoringPipeline'.
        :param str account_name: Azure Internal monitoring pipeline account.
        :param str auto_key_config_url: Azure Internal monitoring pipeline autokey associated with the certificate.
        :param str description: A description of the sink.
        :param Any fluentd_config_url: Azure Internal monitoring agent fluentd configuration.
        :param str ma_config_url: Azure Internal monitoring agent configuration.
        :param str name: Name of the sink. This value is referenced by DiagnosticsReferenceDescription
        :param str namespace: Azure Internal monitoring pipeline account namespace.
        """
        pulumi.set(__self__, "kind", 'AzureInternalMonitoringPipeline')
        if account_name is not None:
            pulumi.set(__self__, "account_name", account_name)
        if auto_key_config_url is not None:
            pulumi.set(__self__, "auto_key_config_url", auto_key_config_url)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if fluentd_config_url is not None:
            pulumi.set(__self__, "fluentd_config_url", fluentd_config_url)
        if ma_config_url is not None:
            pulumi.set(__self__, "ma_config_url", ma_config_url)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)

    @property
    @pulumi.getter
    def kind(self) -> str:
        """
        The kind of DiagnosticsSink.
        Expected value is 'AzureInternalMonitoringPipeline'.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> Optional[str]:
        """
        Azure Internal monitoring pipeline account.
        """
        return pulumi.get(self, "account_name")

    @property
    @pulumi.getter(name="autoKeyConfigUrl")
    def auto_key_config_url(self) -> Optional[str]:
        """
        Azure Internal monitoring pipeline autokey associated with the certificate.
        """
        return pulumi.get(self, "auto_key_config_url")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        A description of the sink.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="fluentdConfigUrl")
    def fluentd_config_url(self) -> Optional[Any]:
        """
        Azure Internal monitoring agent fluentd configuration.
        """
        return pulumi.get(self, "fluentd_config_url")

    @property
    @pulumi.getter(name="maConfigUrl")
    def ma_config_url(self) -> Optional[str]:
        """
        Azure Internal monitoring agent configuration.
        """
        return pulumi.get(self, "ma_config_url")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the sink. This value is referenced by DiagnosticsReferenceDescription
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def namespace(self) -> Optional[str]:
        """
        Azure Internal monitoring pipeline account namespace.
        """
        return pulumi.get(self, "namespace")


@pulumi.output_type
class ContainerCodePackagePropertiesResponse(dict):
    """
    Describes a container and its runtime properties.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceView":
            suggest = "instance_view"
        elif key == "environmentVariables":
            suggest = "environment_variables"
        elif key == "imageRegistryCredential":
            suggest = "image_registry_credential"
        elif key == "reliableCollectionsRefs":
            suggest = "reliable_collections_refs"
        elif key == "volumeRefs":
            suggest = "volume_refs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerCodePackagePropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerCodePackagePropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerCodePackagePropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 image: str,
                 instance_view: 'outputs.ContainerInstanceViewResponse',
                 name: str,
                 resources: 'outputs.ResourceRequirementsResponse',
                 commands: Optional[Sequence[str]] = None,
                 diagnostics: Optional['outputs.DiagnosticsRefResponse'] = None,
                 endpoints: Optional[Sequence['outputs.EndpointPropertiesResponse']] = None,
                 entrypoint: Optional[str] = None,
                 environment_variables: Optional[Sequence['outputs.EnvironmentVariableResponse']] = None,
                 image_registry_credential: Optional['outputs.ImageRegistryCredentialResponse'] = None,
                 labels: Optional[Sequence['outputs.ContainerLabelResponse']] = None,
                 reliable_collections_refs: Optional[Sequence['outputs.ReliableCollectionsRefResponse']] = None,
                 settings: Optional[Sequence['outputs.SettingResponse']] = None,
                 volume_refs: Optional[Sequence['outputs.VolumeReferenceResponse']] = None,
                 volumes: Optional[Sequence['outputs.ApplicationScopedVolumeResponse']] = None):
        """
        Describes a container and its runtime properties.
        :param str image: The Container image to use.
        :param 'ContainerInstanceViewResponse' instance_view: Runtime information of a container instance.
        :param str name: The name of the code package.
        :param 'ResourceRequirementsResponse' resources: The resources required by this container.
        :param Sequence[str] commands: Command array to execute within the container in exec form.
        :param 'DiagnosticsRefResponse' diagnostics: Reference to sinks in DiagnosticsDescription.
        :param Sequence['EndpointPropertiesResponse'] endpoints: The endpoints exposed by this container.
        :param str entrypoint: Override for the default entry point in the container.
        :param Sequence['EnvironmentVariableResponse'] environment_variables: The environment variables to set in this container
        :param 'ImageRegistryCredentialResponse' image_registry_credential: Image registry credential.
        :param Sequence['ContainerLabelResponse'] labels: The labels to set in this container.
        :param Sequence['ReliableCollectionsRefResponse'] reliable_collections_refs: A list of ReliableCollection resources used by this particular code package. Please refer to ReliableCollectionsRef for more details.
        :param Sequence['SettingResponse'] settings: The settings to set in this container. The setting file path can be fetched from environment variable "Fabric_SettingPath". The path for Windows container is "C:\\\\secrets". The path for Linux container is "/var/secrets".
        :param Sequence['VolumeReferenceResponse'] volume_refs: Volumes to be attached to the container. The lifetime of these volumes is independent of the application's lifetime.
        :param Sequence['ApplicationScopedVolumeResponse'] volumes: Volumes to be attached to the container. The lifetime of these volumes is scoped to the application's lifetime.
        """
        pulumi.set(__self__, "image", image)
        pulumi.set(__self__, "instance_view", instance_view)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "resources", resources)
        if commands is not None:
            pulumi.set(__self__, "commands", commands)
        if diagnostics is not None:
            pulumi.set(__self__, "diagnostics", diagnostics)
        if endpoints is not None:
            pulumi.set(__self__, "endpoints", endpoints)
        if entrypoint is not None:
            pulumi.set(__self__, "entrypoint", entrypoint)
        if environment_variables is not None:
            pulumi.set(__self__, "environment_variables", environment_variables)
        if image_registry_credential is not None:
            pulumi.set(__self__, "image_registry_credential", image_registry_credential)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if reliable_collections_refs is not None:
            pulumi.set(__self__, "reliable_collections_refs", reliable_collections_refs)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)
        if volume_refs is not None:
            pulumi.set(__self__, "volume_refs", volume_refs)
        if volumes is not None:
            pulumi.set(__self__, "volumes", volumes)

    @property
    @pulumi.getter
    def image(self) -> str:
        """
        The Container image to use.
        """
        return pulumi.get(self, "image")

    @property
    @pulumi.getter(name="instanceView")
    def instance_view(self) -> 'outputs.ContainerInstanceViewResponse':
        """
        Runtime information of a container instance.
        """
        return pulumi.get(self, "instance_view")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the code package.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def resources(self) -> 'outputs.ResourceRequirementsResponse':
        """
        The resources required by this container.
        """
        return pulumi.get(self, "resources")

    @property
    @pulumi.getter
    def commands(self) -> Optional[Sequence[str]]:
        """
        Command array to execute within the container in exec form.
        """
        return pulumi.get(self, "commands")

    @property
    @pulumi.getter
    def diagnostics(self) -> Optional['outputs.DiagnosticsRefResponse']:
        """
        Reference to sinks in DiagnosticsDescription.
        """
        return pulumi.get(self, "diagnostics")

    @property
    @pulumi.getter
    def endpoints(self) -> Optional[Sequence['outputs.EndpointPropertiesResponse']]:
        """
        The endpoints exposed by this container.
        """
        return pulumi.get(self, "endpoints")

    @property
    @pulumi.getter
    def entrypoint(self) -> Optional[str]:
        """
        Override for the default entry point in the container.
        """
        return pulumi.get(self, "entrypoint")

    @property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> Optional[Sequence['outputs.EnvironmentVariableResponse']]:
        """
        The environment variables to set in this container
        """
        return pulumi.get(self, "environment_variables")

    @property
    @pulumi.getter(name="imageRegistryCredential")
    def image_registry_credential(self) -> Optional['outputs.ImageRegistryCredentialResponse']:
        """
        Image registry credential.
        """
        return pulumi.get(self, "image_registry_credential")

    @property
    @pulumi.getter
    def labels(self) -> Optional[Sequence['outputs.ContainerLabelResponse']]:
        """
        The labels to set in this container.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="reliableCollectionsRefs")
    def reliable_collections_refs(self) -> Optional[Sequence['outputs.ReliableCollectionsRefResponse']]:
        """
        A list of ReliableCollection resources used by this particular code package. Please refer to ReliableCollectionsRef for more details.
        """
        return pulumi.get(self, "reliable_collections_refs")

    @property
    @pulumi.getter
    def settings(self) -> Optional[Sequence['outputs.SettingResponse']]:
        """
        The settings to set in this container. The setting file path can be fetched from environment variable "Fabric_SettingPath". The path for Windows container is "C:\\\\secrets". The path for Linux container is "/var/secrets".
        """
        return pulumi.get(self, "settings")

    @property
    @pulumi.getter(name="volumeRefs")
    def volume_refs(self) -> Optional[Sequence['outputs.VolumeReferenceResponse']]:
        """
        Volumes to be attached to the container. The lifetime of these volumes is independent of the application's lifetime.
        """
        return pulumi.get(self, "volume_refs")

    @property
    @pulumi.getter
    def volumes(self) -> Optional[Sequence['outputs.ApplicationScopedVolumeResponse']]:
        """
        Volumes to be attached to the container. The lifetime of these volumes is scoped to the application's lifetime.
        """
        return pulumi.get(self, "volumes")


@pulumi.output_type
class ContainerEventResponse(dict):
    """
    A container event.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "firstTimestamp":
            suggest = "first_timestamp"
        elif key == "lastTimestamp":
            suggest = "last_timestamp"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerEventResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerEventResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerEventResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 count: Optional[int] = None,
                 first_timestamp: Optional[str] = None,
                 last_timestamp: Optional[str] = None,
                 message: Optional[str] = None,
                 name: Optional[str] = None,
                 type: Optional[str] = None):
        """
        A container event.
        :param int count: The count of the event.
        :param str first_timestamp: Date/time of the first event.
        :param str last_timestamp: Date/time of the last event.
        :param str message: The event message
        :param str name: The name of the container event.
        :param str type: The event type.
        """
        if count is not None:
            pulumi.set(__self__, "count", count)
        if first_timestamp is not None:
            pulumi.set(__self__, "first_timestamp", first_timestamp)
        if last_timestamp is not None:
            pulumi.set(__self__, "last_timestamp", last_timestamp)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def count(self) -> Optional[int]:
        """
        The count of the event.
        """
        return pulumi.get(self, "count")

    @property
    @pulumi.getter(name="firstTimestamp")
    def first_timestamp(self) -> Optional[str]:
        """
        Date/time of the first event.
        """
        return pulumi.get(self, "first_timestamp")

    @property
    @pulumi.getter(name="lastTimestamp")
    def last_timestamp(self) -> Optional[str]:
        """
        Date/time of the last event.
        """
        return pulumi.get(self, "last_timestamp")

    @property
    @pulumi.getter
    def message(self) -> Optional[str]:
        """
        The event message
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the container event.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The event type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ContainerInstanceViewResponse(dict):
    """
    Runtime information of a container instance.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "currentState":
            suggest = "current_state"
        elif key == "previousState":
            suggest = "previous_state"
        elif key == "restartCount":
            suggest = "restart_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerInstanceViewResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerInstanceViewResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerInstanceViewResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 current_state: Optional['outputs.ContainerStateResponse'] = None,
                 events: Optional[Sequence['outputs.ContainerEventResponse']] = None,
                 previous_state: Optional['outputs.ContainerStateResponse'] = None,
                 restart_count: Optional[int] = None):
        """
        Runtime information of a container instance.
        :param 'ContainerStateResponse' current_state: Current container instance state.
        :param Sequence['ContainerEventResponse'] events: The events of this container instance.
        :param 'ContainerStateResponse' previous_state: Previous container instance state.
        :param int restart_count: The number of times the container has been restarted.
        """
        if current_state is not None:
            pulumi.set(__self__, "current_state", current_state)
        if events is not None:
            pulumi.set(__self__, "events", events)
        if previous_state is not None:
            pulumi.set(__self__, "previous_state", previous_state)
        if restart_count is not None:
            pulumi.set(__self__, "restart_count", restart_count)

    @property
    @pulumi.getter(name="currentState")
    def current_state(self) -> Optional['outputs.ContainerStateResponse']:
        """
        Current container instance state.
        """
        return pulumi.get(self, "current_state")

    @property
    @pulumi.getter
    def events(self) -> Optional[Sequence['outputs.ContainerEventResponse']]:
        """
        The events of this container instance.
        """
        return pulumi.get(self, "events")

    @property
    @pulumi.getter(name="previousState")
    def previous_state(self) -> Optional['outputs.ContainerStateResponse']:
        """
        Previous container instance state.
        """
        return pulumi.get(self, "previous_state")

    @property
    @pulumi.getter(name="restartCount")
    def restart_count(self) -> Optional[int]:
        """
        The number of times the container has been restarted.
        """
        return pulumi.get(self, "restart_count")


@pulumi.output_type
class ContainerLabelResponse(dict):
    """
    Describes a container label.
    """
    def __init__(__self__, *,
                 name: str,
                 value: str):
        """
        Describes a container label.
        :param str name: The name of the container label.
        :param str value: The value of the container label.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the container label.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The value of the container label.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ContainerStateResponse(dict):
    """
    The container state.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "detailStatus":
            suggest = "detail_status"
        elif key == "exitCode":
            suggest = "exit_code"
        elif key == "finishTime":
            suggest = "finish_time"
        elif key == "startTime":
            suggest = "start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerStateResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerStateResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerStateResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 detail_status: Optional[str] = None,
                 exit_code: Optional[str] = None,
                 finish_time: Optional[str] = None,
                 start_time: Optional[str] = None,
                 state: Optional[str] = None):
        """
        The container state.
        :param str detail_status: Human-readable status of this state.
        :param str exit_code: The container exit code.
        :param str finish_time: Date/time when the container state finished.
        :param str start_time: Date/time when the container state started.
        :param str state: The state of this container
        """
        if detail_status is not None:
            pulumi.set(__self__, "detail_status", detail_status)
        if exit_code is not None:
            pulumi.set(__self__, "exit_code", exit_code)
        if finish_time is not None:
            pulumi.set(__self__, "finish_time", finish_time)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="detailStatus")
    def detail_status(self) -> Optional[str]:
        """
        Human-readable status of this state.
        """
        return pulumi.get(self, "detail_status")

    @property
    @pulumi.getter(name="exitCode")
    def exit_code(self) -> Optional[str]:
        """
        The container exit code.
        """
        return pulumi.get(self, "exit_code")

    @property
    @pulumi.getter(name="finishTime")
    def finish_time(self) -> Optional[str]:
        """
        Date/time when the container state finished.
        """
        return pulumi.get(self, "finish_time")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[str]:
        """
        Date/time when the container state started.
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The state of this container
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class DiagnosticsDescriptionResponse(dict):
    """
    Describes the diagnostics options available
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultSinkRefs":
            suggest = "default_sink_refs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DiagnosticsDescriptionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DiagnosticsDescriptionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DiagnosticsDescriptionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_sink_refs: Optional[Sequence[str]] = None,
                 enabled: Optional[bool] = None,
                 sinks: Optional[Sequence['outputs.AzureInternalMonitoringPipelineSinkDescriptionResponse']] = None):
        """
        Describes the diagnostics options available
        :param Sequence[str] default_sink_refs: The sinks to be used if diagnostics is enabled. Sink choices can be overridden at the service and code package level.
        :param bool enabled: Status of whether or not sinks are enabled.
        :param Sequence['AzureInternalMonitoringPipelineSinkDescriptionResponse'] sinks: List of supported sinks that can be referenced.
        """
        if default_sink_refs is not None:
            pulumi.set(__self__, "default_sink_refs", default_sink_refs)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if sinks is not None:
            pulumi.set(__self__, "sinks", sinks)

    @property
    @pulumi.getter(name="defaultSinkRefs")
    def default_sink_refs(self) -> Optional[Sequence[str]]:
        """
        The sinks to be used if diagnostics is enabled. Sink choices can be overridden at the service and code package level.
        """
        return pulumi.get(self, "default_sink_refs")

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        Status of whether or not sinks are enabled.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def sinks(self) -> Optional[Sequence['outputs.AzureInternalMonitoringPipelineSinkDescriptionResponse']]:
        """
        List of supported sinks that can be referenced.
        """
        return pulumi.get(self, "sinks")


@pulumi.output_type
class DiagnosticsRefResponse(dict):
    """
    Reference to sinks in DiagnosticsDescription.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sinkRefs":
            suggest = "sink_refs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DiagnosticsRefResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DiagnosticsRefResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DiagnosticsRefResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: Optional[bool] = None,
                 sink_refs: Optional[Sequence[str]] = None):
        """
        Reference to sinks in DiagnosticsDescription.
        :param bool enabled: Status of whether or not sinks are enabled.
        :param Sequence[str] sink_refs: List of sinks to be used if enabled. References the list of sinks in DiagnosticsDescription.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if sink_refs is not None:
            pulumi.set(__self__, "sink_refs", sink_refs)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        Status of whether or not sinks are enabled.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="sinkRefs")
    def sink_refs(self) -> Optional[Sequence[str]]:
        """
        List of sinks to be used if enabled. References the list of sinks in DiagnosticsDescription.
        """
        return pulumi.get(self, "sink_refs")


@pulumi.output_type
class EndpointPropertiesResponse(dict):
    """
    Describes a container endpoint.
    """
    def __init__(__self__, *,
                 name: str,
                 port: Optional[int] = None):
        """
        Describes a container endpoint.
        :param str name: The name of the endpoint.
        :param int port: Port used by the container.
        """
        pulumi.set(__self__, "name", name)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the endpoint.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        Port used by the container.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class EndpointRefResponse(dict):
    """
    Describes a reference to a service endpoint.
    """
    def __init__(__self__, *,
                 name: Optional[str] = None):
        """
        Describes a reference to a service endpoint.
        :param str name: Name of the endpoint.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the endpoint.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class EnvironmentVariableResponse(dict):
    """
    Describes an environment variable for the container.
    """
    def __init__(__self__, *,
                 name: Optional[str] = None,
                 value: Optional[str] = None):
        """
        Describes an environment variable for the container.
        :param str name: The name of the environment variable.
        :param str value: The value of the environment variable.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the environment variable.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        The value of the environment variable.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GatewayDestinationResponse(dict):
    """
    Describes destination endpoint for routing traffic.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "applicationName":
            suggest = "application_name"
        elif key == "endpointName":
            suggest = "endpoint_name"
        elif key == "serviceName":
            suggest = "service_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GatewayDestinationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GatewayDestinationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GatewayDestinationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 application_name: str,
                 endpoint_name: str,
                 service_name: str):
        """
        Describes destination endpoint for routing traffic.
        :param str application_name: Name of the service fabric Mesh application.
        :param str endpoint_name: name of the endpoint in the service.
        :param str service_name: service that contains the endpoint.
        """
        pulumi.set(__self__, "application_name", application_name)
        pulumi.set(__self__, "endpoint_name", endpoint_name)
        pulumi.set(__self__, "service_name", service_name)

    @property
    @pulumi.getter(name="applicationName")
    def application_name(self) -> str:
        """
        Name of the service fabric Mesh application.
        """
        return pulumi.get(self, "application_name")

    @property
    @pulumi.getter(name="endpointName")
    def endpoint_name(self) -> str:
        """
        name of the endpoint in the service.
        """
        return pulumi.get(self, "endpoint_name")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> str:
        """
        service that contains the endpoint.
        """
        return pulumi.get(self, "service_name")


@pulumi.output_type
class HttpConfigResponse(dict):
    """
    Describes the http configuration for external connectivity for this network.
    """
    def __init__(__self__, *,
                 hosts: Sequence['outputs.HttpHostConfigResponse'],
                 name: str,
                 port: int):
        """
        Describes the http configuration for external connectivity for this network.
        :param Sequence['HttpHostConfigResponse'] hosts: description for routing.
        :param str name: http gateway config name.
        :param int port: Specifies the port at which the service endpoint below needs to be exposed.
        """
        pulumi.set(__self__, "hosts", hosts)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def hosts(self) -> Sequence['outputs.HttpHostConfigResponse']:
        """
        description for routing.
        """
        return pulumi.get(self, "hosts")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        http gateway config name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        Specifies the port at which the service endpoint below needs to be exposed.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class HttpHostConfigResponse(dict):
    """
    Describes the hostname properties for http routing.
    """
    def __init__(__self__, *,
                 name: str,
                 routes: Sequence['outputs.HttpRouteConfigResponse']):
        """
        Describes the hostname properties for http routing.
        :param str name: http hostname config name.
        :param Sequence['HttpRouteConfigResponse'] routes: Route information to use for routing. Routes are processed in the order they are specified. Specify routes that are more specific before routes that can handle general cases.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "routes", routes)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        http hostname config name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def routes(self) -> Sequence['outputs.HttpRouteConfigResponse']:
        """
        Route information to use for routing. Routes are processed in the order they are specified. Specify routes that are more specific before routes that can handle general cases.
        """
        return pulumi.get(self, "routes")


@pulumi.output_type
class HttpRouteConfigResponse(dict):
    """
    Describes the hostname properties for http routing.
    """
    def __init__(__self__, *,
                 destination: 'outputs.GatewayDestinationResponse',
                 match: 'outputs.HttpRouteMatchRuleResponse',
                 name: str):
        """
        Describes the hostname properties for http routing.
        :param 'GatewayDestinationResponse' destination: Describes destination endpoint for routing traffic.
        :param 'HttpRouteMatchRuleResponse' match: Describes a rule for http route matching.
        :param str name: http route name.
        """
        pulumi.set(__self__, "destination", destination)
        pulumi.set(__self__, "match", match)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def destination(self) -> 'outputs.GatewayDestinationResponse':
        """
        Describes destination endpoint for routing traffic.
        """
        return pulumi.get(self, "destination")

    @property
    @pulumi.getter
    def match(self) -> 'outputs.HttpRouteMatchRuleResponse':
        """
        Describes a rule for http route matching.
        """
        return pulumi.get(self, "match")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        http route name.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class HttpRouteMatchHeaderResponse(dict):
    """
    Describes header information for http route matching.
    """
    def __init__(__self__, *,
                 name: str,
                 type: Optional[str] = None,
                 value: Optional[str] = None):
        """
        Describes header information for http route matching.
        :param str name: Name of header to match in request.
        :param str type: how to match header value
        :param str value: Value of header to match in request.
        """
        pulumi.set(__self__, "name", name)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of header to match in request.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        how to match header value
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        Value of header to match in request.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class HttpRouteMatchPathResponse(dict):
    """
    Path to match for routing.
    """
    def __init__(__self__, *,
                 type: str,
                 value: str,
                 rewrite: Optional[str] = None):
        """
        Path to match for routing.
        :param str type: how to match value in the Uri
        :param str value: Uri path to match for request.
        :param str rewrite: replacement string for matched part of the Uri.
        """
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)
        if rewrite is not None:
            pulumi.set(__self__, "rewrite", rewrite)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        how to match value in the Uri
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        Uri path to match for request.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter
    def rewrite(self) -> Optional[str]:
        """
        replacement string for matched part of the Uri.
        """
        return pulumi.get(self, "rewrite")


@pulumi.output_type
class HttpRouteMatchRuleResponse(dict):
    """
    Describes a rule for http route matching.
    """
    def __init__(__self__, *,
                 path: 'outputs.HttpRouteMatchPathResponse',
                 headers: Optional[Sequence['outputs.HttpRouteMatchHeaderResponse']] = None):
        """
        Describes a rule for http route matching.
        :param 'HttpRouteMatchPathResponse' path: Path to match for routing.
        :param Sequence['HttpRouteMatchHeaderResponse'] headers: headers and their values to match in request.
        """
        pulumi.set(__self__, "path", path)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)

    @property
    @pulumi.getter
    def path(self) -> 'outputs.HttpRouteMatchPathResponse':
        """
        Path to match for routing.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def headers(self) -> Optional[Sequence['outputs.HttpRouteMatchHeaderResponse']]:
        """
        headers and their values to match in request.
        """
        return pulumi.get(self, "headers")


@pulumi.output_type
class ImageRegistryCredentialResponse(dict):
    """
    Image registry credential.
    """
    def __init__(__self__, *,
                 server: str,
                 username: str,
                 password: Optional[str] = None):
        """
        Image registry credential.
        :param str server: Docker image registry server, without protocol such as `http` and `https`.
        :param str username: The username for the private registry.
        :param str password: The password for the private registry. The password is required for create or update operations, however it is not returned in the get or list operations.
        """
        pulumi.set(__self__, "server", server)
        pulumi.set(__self__, "username", username)
        if password is not None:
            pulumi.set(__self__, "password", password)

    @property
    @pulumi.getter
    def server(self) -> str:
        """
        Docker image registry server, without protocol such as `http` and `https`.
        """
        return pulumi.get(self, "server")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        The username for the private registry.
        """
        return pulumi.get(self, "username")

    @property
    @pulumi.getter
    def password(self) -> Optional[str]:
        """
        The password for the private registry. The password is required for create or update operations, however it is not returned in the get or list operations.
        """
        return pulumi.get(self, "password")


@pulumi.output_type
class NetworkRefResponse(dict):
    """
    Describes a network reference in a service.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endpointRefs":
            suggest = "endpoint_refs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkRefResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkRefResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkRefResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 endpoint_refs: Optional[Sequence['outputs.EndpointRefResponse']] = None,
                 name: Optional[str] = None):
        """
        Describes a network reference in a service.
        :param Sequence['EndpointRefResponse'] endpoint_refs: A list of endpoints that are exposed on this network.
        :param str name: Name of the network
        """
        if endpoint_refs is not None:
            pulumi.set(__self__, "endpoint_refs", endpoint_refs)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="endpointRefs")
    def endpoint_refs(self) -> Optional[Sequence['outputs.EndpointRefResponse']]:
        """
        A list of endpoints that are exposed on this network.
        """
        return pulumi.get(self, "endpoint_refs")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the network
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class NetworkResourcePropertiesResponse(dict):
    """
    Describes properties of a network resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "statusDetails":
            suggest = "status_details"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkResourcePropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkResourcePropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkResourcePropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kind: str,
                 provisioning_state: str,
                 status: str,
                 status_details: str,
                 description: Optional[str] = None):
        """
        Describes properties of a network resource.
        :param str kind: The type of a Service Fabric container network.
               Expected value is 'NetworkResourceProperties'.
        :param str provisioning_state: State of the resource.
        :param str status: Status of the network.
        :param str status_details: Gives additional information about the current status of the network.
        :param str description: User readable description of the network.
        """
        pulumi.set(__self__, "kind", 'NetworkResourceProperties')
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "status_details", status_details)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def kind(self) -> str:
        """
        The type of a Service Fabric container network.
        Expected value is 'NetworkResourceProperties'.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        State of the resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Status of the network.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="statusDetails")
    def status_details(self) -> str:
        """
        Gives additional information about the current status of the network.
        """
        return pulumi.get(self, "status_details")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        User readable description of the network.
        """
        return pulumi.get(self, "description")


@pulumi.output_type
class ReliableCollectionsRefResponse(dict):
    """
    Specifying this parameter adds support for reliable collections
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "doNotPersistState":
            suggest = "do_not_persist_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ReliableCollectionsRefResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ReliableCollectionsRefResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ReliableCollectionsRefResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 do_not_persist_state: Optional[bool] = None):
        """
        Specifying this parameter adds support for reliable collections
        :param str name: Name of ReliableCollection resource. Right now it's not used and you can use any string.
        :param bool do_not_persist_state: False (the default) if ReliableCollections state is persisted to disk as usual. True if you do not want to persist state, in which case replication is still enabled and you can use ReliableCollections as distributed cache.
        """
        pulumi.set(__self__, "name", name)
        if do_not_persist_state is not None:
            pulumi.set(__self__, "do_not_persist_state", do_not_persist_state)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of ReliableCollection resource. Right now it's not used and you can use any string.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="doNotPersistState")
    def do_not_persist_state(self) -> Optional[bool]:
        """
        False (the default) if ReliableCollections state is persisted to disk as usual. True if you do not want to persist state, in which case replication is still enabled and you can use ReliableCollections as distributed cache.
        """
        return pulumi.get(self, "do_not_persist_state")


@pulumi.output_type
class ResourceLimitsResponse(dict):
    """
    This type describes the resource limits for a given container. It describes the most amount of resources a container is allowed to use before being restarted.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "memoryInGB":
            suggest = "memory_in_gb"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceLimitsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceLimitsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceLimitsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cpu: Optional[float] = None,
                 memory_in_gb: Optional[float] = None):
        """
        This type describes the resource limits for a given container. It describes the most amount of resources a container is allowed to use before being restarted.
        :param float cpu: CPU limits in cores. At present, only full cores are supported.
        :param float memory_in_gb: The memory limit in GB.
        """
        if cpu is not None:
            pulumi.set(__self__, "cpu", cpu)
        if memory_in_gb is not None:
            pulumi.set(__self__, "memory_in_gb", memory_in_gb)

    @property
    @pulumi.getter
    def cpu(self) -> Optional[float]:
        """
        CPU limits in cores. At present, only full cores are supported.
        """
        return pulumi.get(self, "cpu")

    @property
    @pulumi.getter(name="memoryInGB")
    def memory_in_gb(self) -> Optional[float]:
        """
        The memory limit in GB.
        """
        return pulumi.get(self, "memory_in_gb")


@pulumi.output_type
class ResourceRequestsResponse(dict):
    """
    This type describes the requested resources for a given container. It describes the least amount of resources required for the container. A container can consume more than requested resources up to the specified limits before being restarted. Currently, the requested resources are treated as limits.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "memoryInGB":
            suggest = "memory_in_gb"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceRequestsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceRequestsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceRequestsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cpu: float,
                 memory_in_gb: float):
        """
        This type describes the requested resources for a given container. It describes the least amount of resources required for the container. A container can consume more than requested resources up to the specified limits before being restarted. Currently, the requested resources are treated as limits.
        :param float cpu: Requested number of CPU cores. At present, only full cores are supported.
        :param float memory_in_gb: The memory request in GB for this container.
        """
        pulumi.set(__self__, "cpu", cpu)
        pulumi.set(__self__, "memory_in_gb", memory_in_gb)

    @property
    @pulumi.getter
    def cpu(self) -> float:
        """
        Requested number of CPU cores. At present, only full cores are supported.
        """
        return pulumi.get(self, "cpu")

    @property
    @pulumi.getter(name="memoryInGB")
    def memory_in_gb(self) -> float:
        """
        The memory request in GB for this container.
        """
        return pulumi.get(self, "memory_in_gb")


@pulumi.output_type
class ResourceRequirementsResponse(dict):
    """
    This type describes the resource requirements for a container or a service.
    """
    def __init__(__self__, *,
                 requests: 'outputs.ResourceRequestsResponse',
                 limits: Optional['outputs.ResourceLimitsResponse'] = None):
        """
        This type describes the resource requirements for a container or a service.
        :param 'ResourceRequestsResponse' requests: Describes the requested resources for a given container.
        :param 'ResourceLimitsResponse' limits: Describes the maximum limits on the resources for a given container.
        """
        pulumi.set(__self__, "requests", requests)
        if limits is not None:
            pulumi.set(__self__, "limits", limits)

    @property
    @pulumi.getter
    def requests(self) -> 'outputs.ResourceRequestsResponse':
        """
        Describes the requested resources for a given container.
        """
        return pulumi.get(self, "requests")

    @property
    @pulumi.getter
    def limits(self) -> Optional['outputs.ResourceLimitsResponse']:
        """
        Describes the maximum limits on the resources for a given container.
        """
        return pulumi.get(self, "limits")


@pulumi.output_type
class SecretResourcePropertiesResponse(dict):
    """
    Describes the properties of a secret resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "statusDetails":
            suggest = "status_details"
        elif key == "contentType":
            suggest = "content_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecretResourcePropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecretResourcePropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecretResourcePropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kind: str,
                 provisioning_state: str,
                 status: str,
                 status_details: str,
                 content_type: Optional[str] = None,
                 description: Optional[str] = None):
        """
        Describes the properties of a secret resource.
        :param str kind: Describes the kind of secret.
               Expected value is 'SecretResourceProperties'.
        :param str provisioning_state: State of the resource.
        :param str status: Status of the resource.
        :param str status_details: Gives additional information about the current status of the secret.
        :param str content_type: The type of the content stored in the secret value. The value of this property is opaque to Service Fabric. Once set, the value of this property cannot be changed.
        :param str description: User readable description of the secret.
        """
        pulumi.set(__self__, "kind", 'SecretResourceProperties')
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "status_details", status_details)
        if content_type is not None:
            pulumi.set(__self__, "content_type", content_type)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def kind(self) -> str:
        """
        Describes the kind of secret.
        Expected value is 'SecretResourceProperties'.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        State of the resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Status of the resource.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="statusDetails")
    def status_details(self) -> str:
        """
        Gives additional information about the current status of the secret.
        """
        return pulumi.get(self, "status_details")

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> Optional[str]:
        """
        The type of the content stored in the secret value. The value of this property is opaque to Service Fabric. Once set, the value of this property cannot be changed.
        """
        return pulumi.get(self, "content_type")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        User readable description of the secret.
        """
        return pulumi.get(self, "description")


@pulumi.output_type
class ServiceResourceDescriptionResponse(dict):
    """
    This type describes a service resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "codePackages":
            suggest = "code_packages"
        elif key == "healthState":
            suggest = "health_state"
        elif key == "osType":
            suggest = "os_type"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "statusDetails":
            suggest = "status_details"
        elif key == "unhealthyEvaluation":
            suggest = "unhealthy_evaluation"
        elif key == "autoScalingPolicies":
            suggest = "auto_scaling_policies"
        elif key == "networkRefs":
            suggest = "network_refs"
        elif key == "replicaCount":
            suggest = "replica_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceResourceDescriptionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceResourceDescriptionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceResourceDescriptionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 code_packages: Sequence['outputs.ContainerCodePackagePropertiesResponse'],
                 health_state: str,
                 id: str,
                 os_type: str,
                 provisioning_state: str,
                 status: str,
                 status_details: str,
                 type: str,
                 unhealthy_evaluation: str,
                 auto_scaling_policies: Optional[Sequence['outputs.AutoScalingPolicyResponse']] = None,
                 description: Optional[str] = None,
                 diagnostics: Optional['outputs.DiagnosticsRefResponse'] = None,
                 name: Optional[str] = None,
                 network_refs: Optional[Sequence['outputs.NetworkRefResponse']] = None,
                 replica_count: Optional[int] = None):
        """
        This type describes a service resource.
        :param Sequence['ContainerCodePackagePropertiesResponse'] code_packages: Describes the set of code packages that forms the service. A code package describes the container and the properties for running it. All the code packages are started together on the same host and share the same context (network, process etc.).
        :param str health_state: Describes the health state of an application resource.
        :param str id: Fully qualified identifier for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
        :param str os_type: The operation system required by the code in service.
        :param str provisioning_state: State of the resource.
        :param str status: Status of the service.
        :param str status_details: Gives additional information about the current status of the service.
        :param str type: The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
        :param str unhealthy_evaluation: When the service's health state is not 'Ok', this additional details from service fabric Health Manager for the user to know why the service is marked unhealthy.
        :param Sequence['AutoScalingPolicyResponse'] auto_scaling_policies: Auto scaling policies
        :param str description: User readable description of the service.
        :param 'DiagnosticsRefResponse' diagnostics: Reference to sinks in DiagnosticsDescription.
        :param str name: The name of the resource
        :param Sequence['NetworkRefResponse'] network_refs: The names of the private networks that this service needs to be part of.
        :param int replica_count: The number of replicas of the service to create. Defaults to 1 if not specified.
        """
        pulumi.set(__self__, "code_packages", code_packages)
        pulumi.set(__self__, "health_state", health_state)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "os_type", os_type)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "status_details", status_details)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "unhealthy_evaluation", unhealthy_evaluation)
        if auto_scaling_policies is not None:
            pulumi.set(__self__, "auto_scaling_policies", auto_scaling_policies)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if diagnostics is not None:
            pulumi.set(__self__, "diagnostics", diagnostics)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_refs is not None:
            pulumi.set(__self__, "network_refs", network_refs)
        if replica_count is not None:
            pulumi.set(__self__, "replica_count", replica_count)

    @property
    @pulumi.getter(name="codePackages")
    def code_packages(self) -> Sequence['outputs.ContainerCodePackagePropertiesResponse']:
        """
        Describes the set of code packages that forms the service. A code package describes the container and the properties for running it. All the code packages are started together on the same host and share the same context (network, process etc.).
        """
        return pulumi.get(self, "code_packages")

    @property
    @pulumi.getter(name="healthState")
    def health_state(self) -> str:
        """
        Describes the health state of an application resource.
        """
        return pulumi.get(self, "health_state")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Fully qualified identifier for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="osType")
    def os_type(self) -> str:
        """
        The operation system required by the code in service.
        """
        return pulumi.get(self, "os_type")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        State of the resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Status of the service.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="statusDetails")
    def status_details(self) -> str:
        """
        Gives additional information about the current status of the service.
        """
        return pulumi.get(self, "status_details")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="unhealthyEvaluation")
    def unhealthy_evaluation(self) -> str:
        """
        When the service's health state is not 'Ok', this additional details from service fabric Health Manager for the user to know why the service is marked unhealthy.
        """
        return pulumi.get(self, "unhealthy_evaluation")

    @property
    @pulumi.getter(name="autoScalingPolicies")
    def auto_scaling_policies(self) -> Optional[Sequence['outputs.AutoScalingPolicyResponse']]:
        """
        Auto scaling policies
        """
        return pulumi.get(self, "auto_scaling_policies")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        User readable description of the service.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def diagnostics(self) -> Optional['outputs.DiagnosticsRefResponse']:
        """
        Reference to sinks in DiagnosticsDescription.
        """
        return pulumi.get(self, "diagnostics")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkRefs")
    def network_refs(self) -> Optional[Sequence['outputs.NetworkRefResponse']]:
        """
        The names of the private networks that this service needs to be part of.
        """
        return pulumi.get(self, "network_refs")

    @property
    @pulumi.getter(name="replicaCount")
    def replica_count(self) -> Optional[int]:
        """
        The number of replicas of the service to create. Defaults to 1 if not specified.
        """
        return pulumi.get(self, "replica_count")


@pulumi.output_type
class SettingResponse(dict):
    """
    Describes a setting for the container. The setting file path can be fetched from environment variable "Fabric_SettingPath". The path for Windows container is "C:\\\\secrets". The path for Linux container is "/var/secrets".
    """
    def __init__(__self__, *,
                 name: Optional[str] = None,
                 value: Optional[str] = None):
        """
        Describes a setting for the container. The setting file path can be fetched from environment variable "Fabric_SettingPath". The path for Windows container is "C:\\\\secrets". The path for Linux container is "/var/secrets".
        :param str name: The name of the setting.
        :param str value: The value of the setting.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the setting.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        The value of the setting.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class TcpConfigResponse(dict):
    """
    Describes the tcp configuration for external connectivity for this network.
    """
    def __init__(__self__, *,
                 destination: 'outputs.GatewayDestinationResponse',
                 name: str,
                 port: int):
        """
        Describes the tcp configuration for external connectivity for this network.
        :param 'GatewayDestinationResponse' destination: Describes destination endpoint for routing traffic.
        :param str name: tcp gateway config name.
        :param int port: Specifies the port at which the service endpoint below needs to be exposed.
        """
        pulumi.set(__self__, "destination", destination)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def destination(self) -> 'outputs.GatewayDestinationResponse':
        """
        Describes destination endpoint for routing traffic.
        """
        return pulumi.get(self, "destination")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        tcp gateway config name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        Specifies the port at which the service endpoint below needs to be exposed.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class VolumeProviderParametersAzureFileResponse(dict):
    """
    This type describes a volume provided by an Azure Files file share.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accountName":
            suggest = "account_name"
        elif key == "shareName":
            suggest = "share_name"
        elif key == "accountKey":
            suggest = "account_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VolumeProviderParametersAzureFileResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VolumeProviderParametersAzureFileResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VolumeProviderParametersAzureFileResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 account_name: str,
                 share_name: str,
                 account_key: Optional[str] = None):
        """
        This type describes a volume provided by an Azure Files file share.
        :param str account_name: Name of the Azure storage account for the File Share.
        :param str share_name: Name of the Azure Files file share that provides storage for the volume.
        :param str account_key: Access key of the Azure storage account for the File Share.
        """
        pulumi.set(__self__, "account_name", account_name)
        pulumi.set(__self__, "share_name", share_name)
        if account_key is not None:
            pulumi.set(__self__, "account_key", account_key)

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> str:
        """
        Name of the Azure storage account for the File Share.
        """
        return pulumi.get(self, "account_name")

    @property
    @pulumi.getter(name="shareName")
    def share_name(self) -> str:
        """
        Name of the Azure Files file share that provides storage for the volume.
        """
        return pulumi.get(self, "share_name")

    @property
    @pulumi.getter(name="accountKey")
    def account_key(self) -> Optional[str]:
        """
        Access key of the Azure storage account for the File Share.
        """
        return pulumi.get(self, "account_key")


@pulumi.output_type
class VolumeReferenceResponse(dict):
    """
    Describes a reference to a volume resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "destinationPath":
            suggest = "destination_path"
        elif key == "readOnly":
            suggest = "read_only"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VolumeReferenceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VolumeReferenceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VolumeReferenceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 destination_path: str,
                 name: str,
                 read_only: Optional[bool] = None):
        """
        Describes a reference to a volume resource.
        :param str destination_path: The path within the container at which the volume should be mounted. Only valid path characters are allowed.
        :param str name: Name of the volume being referenced.
        :param bool read_only: The flag indicating whether the volume is read only. Default is 'false'.
        """
        pulumi.set(__self__, "destination_path", destination_path)
        pulumi.set(__self__, "name", name)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)

    @property
    @pulumi.getter(name="destinationPath")
    def destination_path(self) -> str:
        """
        The path within the container at which the volume should be mounted. Only valid path characters are allowed.
        """
        return pulumi.get(self, "destination_path")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the volume being referenced.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[bool]:
        """
        The flag indicating whether the volume is read only. Default is 'false'.
        """
        return pulumi.get(self, "read_only")


