# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'AzureInternalMonitoringPipelineSinkDescriptionArgs',
    'ContainerCodePackagePropertiesArgs',
    'ContainerLabelArgs',
    'ContainerVolumeArgs',
    'DiagnosticsDescriptionArgs',
    'DiagnosticsRefArgs',
    'EndpointPropertiesArgs',
    'EnvironmentVariableArgs',
    'ImageRegistryCredentialArgs',
    'IngressConfigArgs',
    'Layer4IngressConfigArgs',
    'NetworkRefArgs',
    'ResourceLimitsArgs',
    'ResourceRequestsArgs',
    'ResourceRequirementsArgs',
    'ServiceResourceDescriptionArgs',
    'SettingArgs',
    'VolumeProviderParametersAzureFileArgs',
]

@pulumi.input_type
class AzureInternalMonitoringPipelineSinkDescriptionArgs:
    def __init__(__self__, *,
                 kind: pulumi.Input[str],
                 account_name: Optional[pulumi.Input[str]] = None,
                 auto_key_config_url: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 fluentd_config_url: Optional[Any] = None,
                 ma_config_url: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None):
        """
        Diagnostics settings for Geneva.
        :param pulumi.Input[str] kind: The kind of DiagnosticsSink.
               Expected value is 'AzureInternalMonitoringPipeline'.
        :param pulumi.Input[str] account_name: Azure Internal monitoring pipeline account.
        :param pulumi.Input[str] auto_key_config_url: Azure Internal monitoring pipeline autokey associated with the certificate.
        :param pulumi.Input[str] description: A description of the sink.
        :param Any fluentd_config_url: Azure Internal monitoring agent fluentd configuration.
        :param pulumi.Input[str] ma_config_url: Azure Internal monitoring agent configuration.
        :param pulumi.Input[str] name: Name of the sink. This value is referenced by DiagnosticsReferenceDescription
        :param pulumi.Input[str] namespace: Azure Internal monitoring pipeline account namespace.
        """
        pulumi.set(__self__, "kind", 'AzureInternalMonitoringPipeline')
        if account_name is not None:
            pulumi.set(__self__, "account_name", account_name)
        if auto_key_config_url is not None:
            pulumi.set(__self__, "auto_key_config_url", auto_key_config_url)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if fluentd_config_url is not None:
            pulumi.set(__self__, "fluentd_config_url", fluentd_config_url)
        if ma_config_url is not None:
            pulumi.set(__self__, "ma_config_url", ma_config_url)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)

    @property
    @pulumi.getter
    def kind(self) -> pulumi.Input[str]:
        """
        The kind of DiagnosticsSink.
        Expected value is 'AzureInternalMonitoringPipeline'.
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: pulumi.Input[str]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> Optional[pulumi.Input[str]]:
        """
        Azure Internal monitoring pipeline account.
        """
        return pulumi.get(self, "account_name")

    @account_name.setter
    def account_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_name", value)

    @property
    @pulumi.getter(name="autoKeyConfigUrl")
    def auto_key_config_url(self) -> Optional[pulumi.Input[str]]:
        """
        Azure Internal monitoring pipeline autokey associated with the certificate.
        """
        return pulumi.get(self, "auto_key_config_url")

    @auto_key_config_url.setter
    def auto_key_config_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auto_key_config_url", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A description of the sink.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="fluentdConfigUrl")
    def fluentd_config_url(self) -> Optional[Any]:
        """
        Azure Internal monitoring agent fluentd configuration.
        """
        return pulumi.get(self, "fluentd_config_url")

    @fluentd_config_url.setter
    def fluentd_config_url(self, value: Optional[Any]):
        pulumi.set(self, "fluentd_config_url", value)

    @property
    @pulumi.getter(name="maConfigUrl")
    def ma_config_url(self) -> Optional[pulumi.Input[str]]:
        """
        Azure Internal monitoring agent configuration.
        """
        return pulumi.get(self, "ma_config_url")

    @ma_config_url.setter
    def ma_config_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ma_config_url", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the sink. This value is referenced by DiagnosticsReferenceDescription
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        Azure Internal monitoring pipeline account namespace.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)


@pulumi.input_type
class ContainerCodePackagePropertiesArgs:
    def __init__(__self__, *,
                 image: pulumi.Input[str],
                 name: pulumi.Input[str],
                 resources: pulumi.Input['ResourceRequirementsArgs'],
                 commands: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 diagnostics: Optional[pulumi.Input['DiagnosticsRefArgs']] = None,
                 endpoints: Optional[pulumi.Input[Sequence[pulumi.Input['EndpointPropertiesArgs']]]] = None,
                 entrypoint: Optional[pulumi.Input[str]] = None,
                 environment_variables: Optional[pulumi.Input[Sequence[pulumi.Input['EnvironmentVariableArgs']]]] = None,
                 image_registry_credential: Optional[pulumi.Input['ImageRegistryCredentialArgs']] = None,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerLabelArgs']]]] = None,
                 settings: Optional[pulumi.Input[Sequence[pulumi.Input['SettingArgs']]]] = None,
                 volume_refs: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerVolumeArgs']]]] = None):
        """
        Describes a container and its runtime properties.
        :param pulumi.Input[str] image: The Container image to use.
        :param pulumi.Input[str] name: The name of the code package.
        :param pulumi.Input['ResourceRequirementsArgs'] resources: This type describes the resource requirements for a container or a service.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] commands: Command array to execute within the container in exec form.
        :param pulumi.Input['DiagnosticsRefArgs'] diagnostics: Reference to sinks in DiagnosticsDescription.
        :param pulumi.Input[Sequence[pulumi.Input['EndpointPropertiesArgs']]] endpoints: The endpoints exposed by this container.
        :param pulumi.Input[str] entrypoint: Override for the default entry point in the container.
        :param pulumi.Input[Sequence[pulumi.Input['EnvironmentVariableArgs']]] environment_variables: The environment variables to set in this container
        :param pulumi.Input['ImageRegistryCredentialArgs'] image_registry_credential: Image registry credential.
        :param pulumi.Input[Sequence[pulumi.Input['ContainerLabelArgs']]] labels: The labels to set in this container.
        :param pulumi.Input[Sequence[pulumi.Input['SettingArgs']]] settings: The settings to set in this container. The setting file path can be fetched from environment variable "Fabric_SettingPath". The path for Windows container is "C:\\\\secrets". The path for Linux container is "/var/secrets".
        :param pulumi.Input[Sequence[pulumi.Input['ContainerVolumeArgs']]] volume_refs: The volumes to be attached to the container.
        """
        pulumi.set(__self__, "image", image)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "resources", resources)
        if commands is not None:
            pulumi.set(__self__, "commands", commands)
        if diagnostics is not None:
            pulumi.set(__self__, "diagnostics", diagnostics)
        if endpoints is not None:
            pulumi.set(__self__, "endpoints", endpoints)
        if entrypoint is not None:
            pulumi.set(__self__, "entrypoint", entrypoint)
        if environment_variables is not None:
            pulumi.set(__self__, "environment_variables", environment_variables)
        if image_registry_credential is not None:
            pulumi.set(__self__, "image_registry_credential", image_registry_credential)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)
        if volume_refs is not None:
            pulumi.set(__self__, "volume_refs", volume_refs)

    @property
    @pulumi.getter
    def image(self) -> pulumi.Input[str]:
        """
        The Container image to use.
        """
        return pulumi.get(self, "image")

    @image.setter
    def image(self, value: pulumi.Input[str]):
        pulumi.set(self, "image", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the code package.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def resources(self) -> pulumi.Input['ResourceRequirementsArgs']:
        """
        This type describes the resource requirements for a container or a service.
        """
        return pulumi.get(self, "resources")

    @resources.setter
    def resources(self, value: pulumi.Input['ResourceRequirementsArgs']):
        pulumi.set(self, "resources", value)

    @property
    @pulumi.getter
    def commands(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Command array to execute within the container in exec form.
        """
        return pulumi.get(self, "commands")

    @commands.setter
    def commands(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "commands", value)

    @property
    @pulumi.getter
    def diagnostics(self) -> Optional[pulumi.Input['DiagnosticsRefArgs']]:
        """
        Reference to sinks in DiagnosticsDescription.
        """
        return pulumi.get(self, "diagnostics")

    @diagnostics.setter
    def diagnostics(self, value: Optional[pulumi.Input['DiagnosticsRefArgs']]):
        pulumi.set(self, "diagnostics", value)

    @property
    @pulumi.getter
    def endpoints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EndpointPropertiesArgs']]]]:
        """
        The endpoints exposed by this container.
        """
        return pulumi.get(self, "endpoints")

    @endpoints.setter
    def endpoints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EndpointPropertiesArgs']]]]):
        pulumi.set(self, "endpoints", value)

    @property
    @pulumi.getter
    def entrypoint(self) -> Optional[pulumi.Input[str]]:
        """
        Override for the default entry point in the container.
        """
        return pulumi.get(self, "entrypoint")

    @entrypoint.setter
    def entrypoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "entrypoint", value)

    @property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EnvironmentVariableArgs']]]]:
        """
        The environment variables to set in this container
        """
        return pulumi.get(self, "environment_variables")

    @environment_variables.setter
    def environment_variables(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EnvironmentVariableArgs']]]]):
        pulumi.set(self, "environment_variables", value)

    @property
    @pulumi.getter(name="imageRegistryCredential")
    def image_registry_credential(self) -> Optional[pulumi.Input['ImageRegistryCredentialArgs']]:
        """
        Image registry credential.
        """
        return pulumi.get(self, "image_registry_credential")

    @image_registry_credential.setter
    def image_registry_credential(self, value: Optional[pulumi.Input['ImageRegistryCredentialArgs']]):
        pulumi.set(self, "image_registry_credential", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContainerLabelArgs']]]]:
        """
        The labels to set in this container.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerLabelArgs']]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def settings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SettingArgs']]]]:
        """
        The settings to set in this container. The setting file path can be fetched from environment variable "Fabric_SettingPath". The path for Windows container is "C:\\\\secrets". The path for Linux container is "/var/secrets".
        """
        return pulumi.get(self, "settings")

    @settings.setter
    def settings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SettingArgs']]]]):
        pulumi.set(self, "settings", value)

    @property
    @pulumi.getter(name="volumeRefs")
    def volume_refs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContainerVolumeArgs']]]]:
        """
        The volumes to be attached to the container.
        """
        return pulumi.get(self, "volume_refs")

    @volume_refs.setter
    def volume_refs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerVolumeArgs']]]]):
        pulumi.set(self, "volume_refs", value)


@pulumi.input_type
class ContainerLabelArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        Describes a container label.
        :param pulumi.Input[str] name: The name of the container label.
        :param pulumi.Input[str] value: The value of the container label.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the container label.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        The value of the container label.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class ContainerVolumeArgs:
    def __init__(__self__, *,
                 destination_path: pulumi.Input[str],
                 name: pulumi.Input[str],
                 read_only: Optional[pulumi.Input[bool]] = None):
        """
        Describes how a volume is attached to a container.
        :param pulumi.Input[str] destination_path: The path within the container at which the volume should be mounted. Only valid path characters are allowed.
        :param pulumi.Input[str] name: Name of the volume.
        :param pulumi.Input[bool] read_only: The flag indicating whether the volume is read only. Default is 'false'.
        """
        pulumi.set(__self__, "destination_path", destination_path)
        pulumi.set(__self__, "name", name)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)

    @property
    @pulumi.getter(name="destinationPath")
    def destination_path(self) -> pulumi.Input[str]:
        """
        The path within the container at which the volume should be mounted. Only valid path characters are allowed.
        """
        return pulumi.get(self, "destination_path")

    @destination_path.setter
    def destination_path(self, value: pulumi.Input[str]):
        pulumi.set(self, "destination_path", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Name of the volume.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[pulumi.Input[bool]]:
        """
        The flag indicating whether the volume is read only. Default is 'false'.
        """
        return pulumi.get(self, "read_only")

    @read_only.setter
    def read_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "read_only", value)


@pulumi.input_type
class DiagnosticsDescriptionArgs:
    def __init__(__self__, *,
                 default_sink_refs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 sinks: Optional[pulumi.Input[Sequence[pulumi.Input['AzureInternalMonitoringPipelineSinkDescriptionArgs']]]] = None):
        """
        Describes the diagnostics options available
        :param pulumi.Input[Sequence[pulumi.Input[str]]] default_sink_refs: The sinks to be used if diagnostics is enabled. Sink choices can be overridden at the service and code package level.
        :param pulumi.Input[bool] enabled: Status of whether or not sinks are enabled.
        :param pulumi.Input[Sequence[pulumi.Input['AzureInternalMonitoringPipelineSinkDescriptionArgs']]] sinks: List of supported sinks that can be referenced.
        """
        if default_sink_refs is not None:
            pulumi.set(__self__, "default_sink_refs", default_sink_refs)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if sinks is not None:
            pulumi.set(__self__, "sinks", sinks)

    @property
    @pulumi.getter(name="defaultSinkRefs")
    def default_sink_refs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The sinks to be used if diagnostics is enabled. Sink choices can be overridden at the service and code package level.
        """
        return pulumi.get(self, "default_sink_refs")

    @default_sink_refs.setter
    def default_sink_refs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "default_sink_refs", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Status of whether or not sinks are enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def sinks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AzureInternalMonitoringPipelineSinkDescriptionArgs']]]]:
        """
        List of supported sinks that can be referenced.
        """
        return pulumi.get(self, "sinks")

    @sinks.setter
    def sinks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AzureInternalMonitoringPipelineSinkDescriptionArgs']]]]):
        pulumi.set(self, "sinks", value)


@pulumi.input_type
class DiagnosticsRefArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 sink_refs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Reference to sinks in DiagnosticsDescription.
        :param pulumi.Input[bool] enabled: Status of whether or not sinks are enabled.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] sink_refs: List of sinks to be used if enabled. References the list of sinks in DiagnosticsDescription.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if sink_refs is not None:
            pulumi.set(__self__, "sink_refs", sink_refs)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Status of whether or not sinks are enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="sinkRefs")
    def sink_refs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of sinks to be used if enabled. References the list of sinks in DiagnosticsDescription.
        """
        return pulumi.get(self, "sink_refs")

    @sink_refs.setter
    def sink_refs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "sink_refs", value)


@pulumi.input_type
class EndpointPropertiesArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 port: Optional[pulumi.Input[int]] = None):
        """
        Describes a container endpoint.
        :param pulumi.Input[str] name: The name of the endpoint.
        :param pulumi.Input[int] port: Port used by the container.
        """
        pulumi.set(__self__, "name", name)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the endpoint.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        Port used by the container.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)


@pulumi.input_type
class EnvironmentVariableArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        Describes an environment variable for the container.
        :param pulumi.Input[str] name: The name of the environment variable.
        :param pulumi.Input[str] value: The value of the environment variable.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the environment variable.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        The value of the environment variable.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class ImageRegistryCredentialArgs:
    def __init__(__self__, *,
                 server: pulumi.Input[str],
                 username: pulumi.Input[str],
                 password: Optional[pulumi.Input[str]] = None):
        """
        Image registry credential.
        :param pulumi.Input[str] server: Docker image registry server, without protocol such as `http` and `https`.
        :param pulumi.Input[str] username: The username for the private registry.
        :param pulumi.Input[str] password: The password for the private registry.
        """
        pulumi.set(__self__, "server", server)
        pulumi.set(__self__, "username", username)
        if password is not None:
            pulumi.set(__self__, "password", password)

    @property
    @pulumi.getter
    def server(self) -> pulumi.Input[str]:
        """
        Docker image registry server, without protocol such as `http` and `https`.
        """
        return pulumi.get(self, "server")

    @server.setter
    def server(self, value: pulumi.Input[str]):
        pulumi.set(self, "server", value)

    @property
    @pulumi.getter
    def username(self) -> pulumi.Input[str]:
        """
        The username for the private registry.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: pulumi.Input[str]):
        pulumi.set(self, "username", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        The password for the private registry.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)


@pulumi.input_type
class IngressConfigArgs:
    def __init__(__self__, *,
                 layer4: Optional[pulumi.Input[Sequence[pulumi.Input['Layer4IngressConfigArgs']]]] = None,
                 qos_level: Optional[pulumi.Input[Union[str, 'IngressQoSLevel']]] = None):
        """
        Describes public connectivity configuration for the network.
        :param pulumi.Input[Sequence[pulumi.Input['Layer4IngressConfigArgs']]] layer4: Configuration for layer4 public connectivity for this network.
        :param pulumi.Input[Union[str, 'IngressQoSLevel']] qos_level: The QoS tier for ingress.
        """
        if layer4 is not None:
            pulumi.set(__self__, "layer4", layer4)
        if qos_level is not None:
            pulumi.set(__self__, "qos_level", qos_level)

    @property
    @pulumi.getter
    def layer4(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['Layer4IngressConfigArgs']]]]:
        """
        Configuration for layer4 public connectivity for this network.
        """
        return pulumi.get(self, "layer4")

    @layer4.setter
    def layer4(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['Layer4IngressConfigArgs']]]]):
        pulumi.set(self, "layer4", value)

    @property
    @pulumi.getter(name="qosLevel")
    def qos_level(self) -> Optional[pulumi.Input[Union[str, 'IngressQoSLevel']]]:
        """
        The QoS tier for ingress.
        """
        return pulumi.get(self, "qos_level")

    @qos_level.setter
    def qos_level(self, value: Optional[pulumi.Input[Union[str, 'IngressQoSLevel']]]):
        pulumi.set(self, "qos_level", value)


@pulumi.input_type
class Layer4IngressConfigArgs:
    def __init__(__self__, *,
                 application_name: Optional[pulumi.Input[str]] = None,
                 endpoint_name: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 public_port: Optional[pulumi.Input[int]] = None,
                 service_name: Optional[pulumi.Input[str]] = None):
        """
        Describes the layer4 configuration for public connectivity for this network.
        :param pulumi.Input[str] application_name: The application name which contains the service to be exposed.
        :param pulumi.Input[str] endpoint_name: The service endpoint that needs to be exposed.
        :param pulumi.Input[str] name: Layer4 ingress config name.
        :param pulumi.Input[int] public_port: Specifies the public port at which the service endpoint below needs to be exposed.
        :param pulumi.Input[str] service_name: The service whose endpoint needs to be exposed at the public port.
        """
        if application_name is not None:
            pulumi.set(__self__, "application_name", application_name)
        if endpoint_name is not None:
            pulumi.set(__self__, "endpoint_name", endpoint_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if public_port is not None:
            pulumi.set(__self__, "public_port", public_port)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)

    @property
    @pulumi.getter(name="applicationName")
    def application_name(self) -> Optional[pulumi.Input[str]]:
        """
        The application name which contains the service to be exposed.
        """
        return pulumi.get(self, "application_name")

    @application_name.setter
    def application_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "application_name", value)

    @property
    @pulumi.getter(name="endpointName")
    def endpoint_name(self) -> Optional[pulumi.Input[str]]:
        """
        The service endpoint that needs to be exposed.
        """
        return pulumi.get(self, "endpoint_name")

    @endpoint_name.setter
    def endpoint_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "endpoint_name", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Layer4 ingress config name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="publicPort")
    def public_port(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the public port at which the service endpoint below needs to be exposed.
        """
        return pulumi.get(self, "public_port")

    @public_port.setter
    def public_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "public_port", value)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[pulumi.Input[str]]:
        """
        The service whose endpoint needs to be exposed at the public port.
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_name", value)


@pulumi.input_type
class NetworkRefArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None):
        """
        Describes a network reference in a service.
        :param pulumi.Input[str] name: Name of the network.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the network.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class ResourceLimitsArgs:
    def __init__(__self__, *,
                 cpu: Optional[pulumi.Input[float]] = None,
                 memory_in_gb: Optional[pulumi.Input[float]] = None):
        """
        This type describes the resource limits for a given container. It describes the most amount of resources a container is allowed to use before being restarted.
        :param pulumi.Input[float] cpu: CPU limits in cores. At present, only full cores are supported.
        :param pulumi.Input[float] memory_in_gb: The memory limit in GB.
        """
        if cpu is not None:
            pulumi.set(__self__, "cpu", cpu)
        if memory_in_gb is not None:
            pulumi.set(__self__, "memory_in_gb", memory_in_gb)

    @property
    @pulumi.getter
    def cpu(self) -> Optional[pulumi.Input[float]]:
        """
        CPU limits in cores. At present, only full cores are supported.
        """
        return pulumi.get(self, "cpu")

    @cpu.setter
    def cpu(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "cpu", value)

    @property
    @pulumi.getter(name="memoryInGB")
    def memory_in_gb(self) -> Optional[pulumi.Input[float]]:
        """
        The memory limit in GB.
        """
        return pulumi.get(self, "memory_in_gb")

    @memory_in_gb.setter
    def memory_in_gb(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "memory_in_gb", value)


@pulumi.input_type
class ResourceRequestsArgs:
    def __init__(__self__, *,
                 cpu: pulumi.Input[float],
                 memory_in_gb: pulumi.Input[float]):
        """
        This type describes the requested resources for a given container. It describes the least amount of resources required for the container. A container can consume more than requested resources up to the specified limits before being restarted. Currently, the requested resources are treated as limits.

        :param pulumi.Input[float] cpu: Requested number of CPU cores. At present, only full cores are supported.
        :param pulumi.Input[float] memory_in_gb: The memory request in GB for this container.
        """
        pulumi.set(__self__, "cpu", cpu)
        pulumi.set(__self__, "memory_in_gb", memory_in_gb)

    @property
    @pulumi.getter
    def cpu(self) -> pulumi.Input[float]:
        """
        Requested number of CPU cores. At present, only full cores are supported.
        """
        return pulumi.get(self, "cpu")

    @cpu.setter
    def cpu(self, value: pulumi.Input[float]):
        pulumi.set(self, "cpu", value)

    @property
    @pulumi.getter(name="memoryInGB")
    def memory_in_gb(self) -> pulumi.Input[float]:
        """
        The memory request in GB for this container.
        """
        return pulumi.get(self, "memory_in_gb")

    @memory_in_gb.setter
    def memory_in_gb(self, value: pulumi.Input[float]):
        pulumi.set(self, "memory_in_gb", value)


@pulumi.input_type
class ResourceRequirementsArgs:
    def __init__(__self__, *,
                 requests: pulumi.Input['ResourceRequestsArgs'],
                 limits: Optional[pulumi.Input['ResourceLimitsArgs']] = None):
        """
        This type describes the resource requirements for a container or a service.
        :param pulumi.Input['ResourceRequestsArgs'] requests: Describes the requested resources for a given container.
        :param pulumi.Input['ResourceLimitsArgs'] limits: Describes the maximum limits on the resources for a given container.
        """
        pulumi.set(__self__, "requests", requests)
        if limits is not None:
            pulumi.set(__self__, "limits", limits)

    @property
    @pulumi.getter
    def requests(self) -> pulumi.Input['ResourceRequestsArgs']:
        """
        Describes the requested resources for a given container.
        """
        return pulumi.get(self, "requests")

    @requests.setter
    def requests(self, value: pulumi.Input['ResourceRequestsArgs']):
        pulumi.set(self, "requests", value)

    @property
    @pulumi.getter
    def limits(self) -> Optional[pulumi.Input['ResourceLimitsArgs']]:
        """
        Describes the maximum limits on the resources for a given container.
        """
        return pulumi.get(self, "limits")

    @limits.setter
    def limits(self, value: Optional[pulumi.Input['ResourceLimitsArgs']]):
        pulumi.set(self, "limits", value)


@pulumi.input_type
class ServiceResourceDescriptionArgs:
    def __init__(__self__, *,
                 code_packages: pulumi.Input[Sequence[pulumi.Input['ContainerCodePackagePropertiesArgs']]],
                 os_type: pulumi.Input[Union[str, 'OperatingSystemTypes']],
                 description: Optional[pulumi.Input[str]] = None,
                 diagnostics: Optional[pulumi.Input['DiagnosticsRefArgs']] = None,
                 health_state: Optional[pulumi.Input[Union[str, 'HealthState']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_refs: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkRefArgs']]]] = None,
                 replica_count: Optional[pulumi.Input[int]] = None):
        """
        This type describes a service resource.
        :param pulumi.Input[Sequence[pulumi.Input['ContainerCodePackagePropertiesArgs']]] code_packages: Describes the set of code packages that forms the service. A code package describes the container and the properties for running it. All the code packages are started together on the same host and share the same context (network, process etc.).
        :param pulumi.Input[Union[str, 'OperatingSystemTypes']] os_type: The Operating system type required by the code in service.
        :param pulumi.Input[str] description: User readable description of the service.
        :param pulumi.Input['DiagnosticsRefArgs'] diagnostics: Reference to sinks in DiagnosticsDescription.
        :param pulumi.Input[Union[str, 'HealthState']] health_state: The health state of a resource such as Application, Service, or Network.
        :param pulumi.Input[str] name: The name of the resource
        :param pulumi.Input[Sequence[pulumi.Input['NetworkRefArgs']]] network_refs: The names of the private networks that this service needs to be part of.
        :param pulumi.Input[int] replica_count: The number of replicas of the service to create. Defaults to 1 if not specified.
        """
        pulumi.set(__self__, "code_packages", code_packages)
        pulumi.set(__self__, "os_type", os_type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if diagnostics is not None:
            pulumi.set(__self__, "diagnostics", diagnostics)
        if health_state is not None:
            pulumi.set(__self__, "health_state", health_state)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_refs is not None:
            pulumi.set(__self__, "network_refs", network_refs)
        if replica_count is not None:
            pulumi.set(__self__, "replica_count", replica_count)

    @property
    @pulumi.getter(name="codePackages")
    def code_packages(self) -> pulumi.Input[Sequence[pulumi.Input['ContainerCodePackagePropertiesArgs']]]:
        """
        Describes the set of code packages that forms the service. A code package describes the container and the properties for running it. All the code packages are started together on the same host and share the same context (network, process etc.).
        """
        return pulumi.get(self, "code_packages")

    @code_packages.setter
    def code_packages(self, value: pulumi.Input[Sequence[pulumi.Input['ContainerCodePackagePropertiesArgs']]]):
        pulumi.set(self, "code_packages", value)

    @property
    @pulumi.getter(name="osType")
    def os_type(self) -> pulumi.Input[Union[str, 'OperatingSystemTypes']]:
        """
        The Operating system type required by the code in service.
        """
        return pulumi.get(self, "os_type")

    @os_type.setter
    def os_type(self, value: pulumi.Input[Union[str, 'OperatingSystemTypes']]):
        pulumi.set(self, "os_type", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        User readable description of the service.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def diagnostics(self) -> Optional[pulumi.Input['DiagnosticsRefArgs']]:
        """
        Reference to sinks in DiagnosticsDescription.
        """
        return pulumi.get(self, "diagnostics")

    @diagnostics.setter
    def diagnostics(self, value: Optional[pulumi.Input['DiagnosticsRefArgs']]):
        pulumi.set(self, "diagnostics", value)

    @property
    @pulumi.getter(name="healthState")
    def health_state(self) -> Optional[pulumi.Input[Union[str, 'HealthState']]]:
        """
        The health state of a resource such as Application, Service, or Network.
        """
        return pulumi.get(self, "health_state")

    @health_state.setter
    def health_state(self, value: Optional[pulumi.Input[Union[str, 'HealthState']]]):
        pulumi.set(self, "health_state", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the resource
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkRefs")
    def network_refs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NetworkRefArgs']]]]:
        """
        The names of the private networks that this service needs to be part of.
        """
        return pulumi.get(self, "network_refs")

    @network_refs.setter
    def network_refs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkRefArgs']]]]):
        pulumi.set(self, "network_refs", value)

    @property
    @pulumi.getter(name="replicaCount")
    def replica_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of replicas of the service to create. Defaults to 1 if not specified.
        """
        return pulumi.get(self, "replica_count")

    @replica_count.setter
    def replica_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "replica_count", value)


@pulumi.input_type
class SettingArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        Describes a setting for the container.
        :param pulumi.Input[str] name: The name of the setting.
        :param pulumi.Input[str] value: The value of the setting.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the setting.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        The value of the setting.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class VolumeProviderParametersAzureFileArgs:
    def __init__(__self__, *,
                 account_name: pulumi.Input[str],
                 share_name: pulumi.Input[str],
                 account_key: Optional[pulumi.Input[str]] = None):
        """
        This type describes a volume provided by an Azure Files file share.
        :param pulumi.Input[str] account_name: Name of the Azure storage account for the File Share.
        :param pulumi.Input[str] share_name: Name of the Azure Files file share that provides storage for the volume.
        :param pulumi.Input[str] account_key: Access key of the Azure storage account for the File Share.
        """
        pulumi.set(__self__, "account_name", account_name)
        pulumi.set(__self__, "share_name", share_name)
        if account_key is not None:
            pulumi.set(__self__, "account_key", account_key)

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> pulumi.Input[str]:
        """
        Name of the Azure storage account for the File Share.
        """
        return pulumi.get(self, "account_name")

    @account_name.setter
    def account_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "account_name", value)

    @property
    @pulumi.getter(name="shareName")
    def share_name(self) -> pulumi.Input[str]:
        """
        Name of the Azure Files file share that provides storage for the volume.
        """
        return pulumi.get(self, "share_name")

    @share_name.setter
    def share_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "share_name", value)

    @property
    @pulumi.getter(name="accountKey")
    def account_key(self) -> Optional[pulumi.Input[str]]:
        """
        Access key of the Azure storage account for the File Share.
        """
        return pulumi.get(self, "account_key")

    @account_key.setter
    def account_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_key", value)


