# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetSchemaRegistryResult',
    'AwaitableGetSchemaRegistryResult',
    'get_schema_registry',
    'get_schema_registry_output',
]

@pulumi.output_type
class GetSchemaRegistryResult:
    """
    Single item in List or Get Schema Group operation
    """
    def __init__(__self__, created_at_utc=None, e_tag=None, group_properties=None, id=None, location=None, name=None, schema_compatibility=None, schema_type=None, system_data=None, type=None, updated_at_utc=None):
        if created_at_utc and not isinstance(created_at_utc, str):
            raise TypeError("Expected argument 'created_at_utc' to be a str")
        pulumi.set(__self__, "created_at_utc", created_at_utc)
        if e_tag and not isinstance(e_tag, str):
            raise TypeError("Expected argument 'e_tag' to be a str")
        pulumi.set(__self__, "e_tag", e_tag)
        if group_properties and not isinstance(group_properties, dict):
            raise TypeError("Expected argument 'group_properties' to be a dict")
        pulumi.set(__self__, "group_properties", group_properties)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if schema_compatibility and not isinstance(schema_compatibility, str):
            raise TypeError("Expected argument 'schema_compatibility' to be a str")
        pulumi.set(__self__, "schema_compatibility", schema_compatibility)
        if schema_type and not isinstance(schema_type, str):
            raise TypeError("Expected argument 'schema_type' to be a str")
        pulumi.set(__self__, "schema_type", schema_type)
        if system_data and not isinstance(system_data, dict):
            raise TypeError("Expected argument 'system_data' to be a dict")
        pulumi.set(__self__, "system_data", system_data)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if updated_at_utc and not isinstance(updated_at_utc, str):
            raise TypeError("Expected argument 'updated_at_utc' to be a str")
        pulumi.set(__self__, "updated_at_utc", updated_at_utc)

    @property
    @pulumi.getter(name="createdAtUtc")
    def created_at_utc(self) -> str:
        """
        Exact time the Schema Group was created.
        """
        return pulumi.get(self, "created_at_utc")

    @property
    @pulumi.getter(name="eTag")
    def e_tag(self) -> str:
        """
        The ETag value.
        """
        return pulumi.get(self, "e_tag")

    @property
    @pulumi.getter(name="groupProperties")
    def group_properties(self) -> Optional[Mapping[str, str]]:
        """
        dictionary object for SchemaGroup group properties
        """
        return pulumi.get(self, "group_properties")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        The geo-location where the resource lives
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="schemaCompatibility")
    def schema_compatibility(self) -> Optional[str]:
        return pulumi.get(self, "schema_compatibility")

    @property
    @pulumi.getter(name="schemaType")
    def schema_type(self) -> Optional[str]:
        return pulumi.get(self, "schema_type")

    @property
    @pulumi.getter(name="systemData")
    def system_data(self) -> 'outputs.SystemDataResponse':
        """
        The system meta data relating to this resource.
        """
        return pulumi.get(self, "system_data")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the resource. E.g. "Microsoft.EventHub/Namespaces" or "Microsoft.EventHub/Namespaces/EventHubs"
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="updatedAtUtc")
    def updated_at_utc(self) -> str:
        """
        Exact time the Schema Group was updated
        """
        return pulumi.get(self, "updated_at_utc")


class AwaitableGetSchemaRegistryResult(GetSchemaRegistryResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSchemaRegistryResult(
            created_at_utc=self.created_at_utc,
            e_tag=self.e_tag,
            group_properties=self.group_properties,
            id=self.id,
            location=self.location,
            name=self.name,
            schema_compatibility=self.schema_compatibility,
            schema_type=self.schema_type,
            system_data=self.system_data,
            type=self.type,
            updated_at_utc=self.updated_at_utc)


def get_schema_registry(namespace_name: Optional[str] = None,
                        resource_group_name: Optional[str] = None,
                        schema_group_name: Optional[str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSchemaRegistryResult:
    """
    Single item in List or Get Schema Group operation


    :param str namespace_name: The Namespace name
    :param str resource_group_name: Name of the resource group within the azure subscription.
    :param str schema_group_name: The Schema Group name 
    """
    __args__ = dict()
    __args__['namespaceName'] = namespace_name
    __args__['resourceGroupName'] = resource_group_name
    __args__['schemaGroupName'] = schema_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure-native:eventhub/v20220101preview:getSchemaRegistry', __args__, opts=opts, typ=GetSchemaRegistryResult).value

    return AwaitableGetSchemaRegistryResult(
        created_at_utc=__ret__.created_at_utc,
        e_tag=__ret__.e_tag,
        group_properties=__ret__.group_properties,
        id=__ret__.id,
        location=__ret__.location,
        name=__ret__.name,
        schema_compatibility=__ret__.schema_compatibility,
        schema_type=__ret__.schema_type,
        system_data=__ret__.system_data,
        type=__ret__.type,
        updated_at_utc=__ret__.updated_at_utc)


@_utilities.lift_output_func(get_schema_registry)
def get_schema_registry_output(namespace_name: Optional[pulumi.Input[str]] = None,
                               resource_group_name: Optional[pulumi.Input[str]] = None,
                               schema_group_name: Optional[pulumi.Input[str]] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetSchemaRegistryResult]:
    """
    Single item in List or Get Schema Group operation


    :param str namespace_name: The Namespace name
    :param str resource_group_name: Name of the resource group within the azure subscription.
    :param str schema_group_name: The Schema Group name 
    """
    ...
