# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ManagedDatabaseVulnerabilityAssessmentRuleBaselineArgs', 'ManagedDatabaseVulnerabilityAssessmentRuleBaseline']

@pulumi.input_type
class ManagedDatabaseVulnerabilityAssessmentRuleBaselineArgs:
    def __init__(__self__, *,
                 baseline_results: pulumi.Input[Sequence[pulumi.Input['DatabaseVulnerabilityAssessmentRuleBaselineItemArgs']]],
                 database_name: pulumi.Input[str],
                 managed_instance_name: pulumi.Input[str],
                 resource_group_name: pulumi.Input[str],
                 rule_id: pulumi.Input[str],
                 vulnerability_assessment_name: pulumi.Input[str],
                 baseline_name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a ManagedDatabaseVulnerabilityAssessmentRuleBaseline resource.
        :param pulumi.Input[Sequence[pulumi.Input['DatabaseVulnerabilityAssessmentRuleBaselineItemArgs']]] baseline_results: The rule baseline result
        :param pulumi.Input[str] database_name: The name of the database for which the vulnerability assessment rule baseline is defined.
        :param pulumi.Input[str] managed_instance_name: The name of the managed instance.
        :param pulumi.Input[str] resource_group_name: The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
        :param pulumi.Input[str] rule_id: The vulnerability assessment rule ID.
        :param pulumi.Input[str] vulnerability_assessment_name: The name of the vulnerability assessment.
        :param pulumi.Input[str] baseline_name: The name of the vulnerability assessment rule baseline (default implies a baseline on a database level rule and master for server level rule).
        """
        pulumi.set(__self__, "baseline_results", baseline_results)
        pulumi.set(__self__, "database_name", database_name)
        pulumi.set(__self__, "managed_instance_name", managed_instance_name)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "rule_id", rule_id)
        pulumi.set(__self__, "vulnerability_assessment_name", vulnerability_assessment_name)
        if baseline_name is not None:
            pulumi.set(__self__, "baseline_name", baseline_name)

    @property
    @pulumi.getter(name="baselineResults")
    def baseline_results(self) -> pulumi.Input[Sequence[pulumi.Input['DatabaseVulnerabilityAssessmentRuleBaselineItemArgs']]]:
        """
        The rule baseline result
        """
        return pulumi.get(self, "baseline_results")

    @baseline_results.setter
    def baseline_results(self, value: pulumi.Input[Sequence[pulumi.Input['DatabaseVulnerabilityAssessmentRuleBaselineItemArgs']]]):
        pulumi.set(self, "baseline_results", value)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> pulumi.Input[str]:
        """
        The name of the database for which the vulnerability assessment rule baseline is defined.
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "database_name", value)

    @property
    @pulumi.getter(name="managedInstanceName")
    def managed_instance_name(self) -> pulumi.Input[str]:
        """
        The name of the managed instance.
        """
        return pulumi.get(self, "managed_instance_name")

    @managed_instance_name.setter
    def managed_instance_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "managed_instance_name", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[str]:
        """
        The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="ruleId")
    def rule_id(self) -> pulumi.Input[str]:
        """
        The vulnerability assessment rule ID.
        """
        return pulumi.get(self, "rule_id")

    @rule_id.setter
    def rule_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "rule_id", value)

    @property
    @pulumi.getter(name="vulnerabilityAssessmentName")
    def vulnerability_assessment_name(self) -> pulumi.Input[str]:
        """
        The name of the vulnerability assessment.
        """
        return pulumi.get(self, "vulnerability_assessment_name")

    @vulnerability_assessment_name.setter
    def vulnerability_assessment_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "vulnerability_assessment_name", value)

    @property
    @pulumi.getter(name="baselineName")
    def baseline_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the vulnerability assessment rule baseline (default implies a baseline on a database level rule and master for server level rule).
        """
        return pulumi.get(self, "baseline_name")

    @baseline_name.setter
    def baseline_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "baseline_name", value)


class ManagedDatabaseVulnerabilityAssessmentRuleBaseline(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 baseline_name: Optional[pulumi.Input[str]] = None,
                 baseline_results: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DatabaseVulnerabilityAssessmentRuleBaselineItemArgs']]]]] = None,
                 database_name: Optional[pulumi.Input[str]] = None,
                 managed_instance_name: Optional[pulumi.Input[str]] = None,
                 resource_group_name: Optional[pulumi.Input[str]] = None,
                 rule_id: Optional[pulumi.Input[str]] = None,
                 vulnerability_assessment_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        A database vulnerability assessment rule baseline.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] baseline_name: The name of the vulnerability assessment rule baseline (default implies a baseline on a database level rule and master for server level rule).
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DatabaseVulnerabilityAssessmentRuleBaselineItemArgs']]]] baseline_results: The rule baseline result
        :param pulumi.Input[str] database_name: The name of the database for which the vulnerability assessment rule baseline is defined.
        :param pulumi.Input[str] managed_instance_name: The name of the managed instance.
        :param pulumi.Input[str] resource_group_name: The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
        :param pulumi.Input[str] rule_id: The vulnerability assessment rule ID.
        :param pulumi.Input[str] vulnerability_assessment_name: The name of the vulnerability assessment.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ManagedDatabaseVulnerabilityAssessmentRuleBaselineArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A database vulnerability assessment rule baseline.

        :param str resource_name: The name of the resource.
        :param ManagedDatabaseVulnerabilityAssessmentRuleBaselineArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ManagedDatabaseVulnerabilityAssessmentRuleBaselineArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 baseline_name: Optional[pulumi.Input[str]] = None,
                 baseline_results: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DatabaseVulnerabilityAssessmentRuleBaselineItemArgs']]]]] = None,
                 database_name: Optional[pulumi.Input[str]] = None,
                 managed_instance_name: Optional[pulumi.Input[str]] = None,
                 resource_group_name: Optional[pulumi.Input[str]] = None,
                 rule_id: Optional[pulumi.Input[str]] = None,
                 vulnerability_assessment_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ManagedDatabaseVulnerabilityAssessmentRuleBaselineArgs.__new__(ManagedDatabaseVulnerabilityAssessmentRuleBaselineArgs)

            __props__.__dict__["baseline_name"] = baseline_name
            if baseline_results is None and not opts.urn:
                raise TypeError("Missing required property 'baseline_results'")
            __props__.__dict__["baseline_results"] = baseline_results
            if database_name is None and not opts.urn:
                raise TypeError("Missing required property 'database_name'")
            __props__.__dict__["database_name"] = database_name
            if managed_instance_name is None and not opts.urn:
                raise TypeError("Missing required property 'managed_instance_name'")
            __props__.__dict__["managed_instance_name"] = managed_instance_name
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            if rule_id is None and not opts.urn:
                raise TypeError("Missing required property 'rule_id'")
            __props__.__dict__["rule_id"] = rule_id
            if vulnerability_assessment_name is None and not opts.urn:
                raise TypeError("Missing required property 'vulnerability_assessment_name'")
            __props__.__dict__["vulnerability_assessment_name"] = vulnerability_assessment_name
            __props__.__dict__["name"] = None
            __props__.__dict__["type"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="azure-native:sql:ManagedDatabaseVulnerabilityAssessmentRuleBaseline"), pulumi.Alias(type_="azure-native:sql/v20171001preview:ManagedDatabaseVulnerabilityAssessmentRuleBaseline"), pulumi.Alias(type_="azure-native:sql/v20200202preview:ManagedDatabaseVulnerabilityAssessmentRuleBaseline"), pulumi.Alias(type_="azure-native:sql/v20200801preview:ManagedDatabaseVulnerabilityAssessmentRuleBaseline"), pulumi.Alias(type_="azure-native:sql/v20201101preview:ManagedDatabaseVulnerabilityAssessmentRuleBaseline"), pulumi.Alias(type_="azure-native:sql/v20210201preview:ManagedDatabaseVulnerabilityAssessmentRuleBaseline"), pulumi.Alias(type_="azure-native:sql/v20210501preview:ManagedDatabaseVulnerabilityAssessmentRuleBaseline"), pulumi.Alias(type_="azure-native:sql/v20210801preview:ManagedDatabaseVulnerabilityAssessmentRuleBaseline"), pulumi.Alias(type_="azure-native:sql/v20211101preview:ManagedDatabaseVulnerabilityAssessmentRuleBaseline"), pulumi.Alias(type_="azure-native:sql/v20220201preview:ManagedDatabaseVulnerabilityAssessmentRuleBaseline")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(ManagedDatabaseVulnerabilityAssessmentRuleBaseline, __self__).__init__(
            'azure-native:sql/v20211101:ManagedDatabaseVulnerabilityAssessmentRuleBaseline',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'ManagedDatabaseVulnerabilityAssessmentRuleBaseline':
        """
        Get an existing ManagedDatabaseVulnerabilityAssessmentRuleBaseline resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = ManagedDatabaseVulnerabilityAssessmentRuleBaselineArgs.__new__(ManagedDatabaseVulnerabilityAssessmentRuleBaselineArgs)

        __props__.__dict__["baseline_results"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["type"] = None
        return ManagedDatabaseVulnerabilityAssessmentRuleBaseline(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="baselineResults")
    def baseline_results(self) -> pulumi.Output[Sequence['outputs.DatabaseVulnerabilityAssessmentRuleBaselineItemResponse']]:
        """
        The rule baseline result
        """
        return pulumi.get(self, "baseline_results")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Resource name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        Resource type.
        """
        return pulumi.get(self, "type")

