# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities

__all__ = [
    'GetChannelResult',
    'AwaitableGetChannelResult',
    'get_channel',
    'get_channel_output',
]

@pulumi.output_type
class GetChannelResult:
    """
    The EngagementFabric channel
    """
    def __init__(__self__, channel_functions=None, channel_type=None, credentials=None, id=None, name=None, type=None):
        if channel_functions and not isinstance(channel_functions, list):
            raise TypeError("Expected argument 'channel_functions' to be a list")
        pulumi.set(__self__, "channel_functions", channel_functions)
        if channel_type and not isinstance(channel_type, str):
            raise TypeError("Expected argument 'channel_type' to be a str")
        pulumi.set(__self__, "channel_type", channel_type)
        if credentials and not isinstance(credentials, dict):
            raise TypeError("Expected argument 'credentials' to be a dict")
        pulumi.set(__self__, "credentials", credentials)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="channelFunctions")
    def channel_functions(self) -> Optional[Sequence[str]]:
        """
        The functions to be enabled for the channel
        """
        return pulumi.get(self, "channel_functions")

    @property
    @pulumi.getter(name="channelType")
    def channel_type(self) -> str:
        """
        The channel type
        """
        return pulumi.get(self, "channel_type")

    @property
    @pulumi.getter
    def credentials(self) -> Optional[Mapping[str, str]]:
        """
        The channel credentials
        """
        return pulumi.get(self, "credentials")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the resource
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The fully qualified type of the resource
        """
        return pulumi.get(self, "type")


class AwaitableGetChannelResult(GetChannelResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetChannelResult(
            channel_functions=self.channel_functions,
            channel_type=self.channel_type,
            credentials=self.credentials,
            id=self.id,
            name=self.name,
            type=self.type)


def get_channel(account_name: Optional[str] = None,
                channel_name: Optional[str] = None,
                resource_group_name: Optional[str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetChannelResult:
    """
    The EngagementFabric channel


    :param str account_name: Account Name
    :param str channel_name: Channel Name
    :param str resource_group_name: Resource Group Name
    """
    __args__ = dict()
    __args__['accountName'] = account_name
    __args__['channelName'] = channel_name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure-native:engagementfabric/v20180901preview:getChannel', __args__, opts=opts, typ=GetChannelResult).value

    return AwaitableGetChannelResult(
        channel_functions=__ret__.channel_functions,
        channel_type=__ret__.channel_type,
        credentials=__ret__.credentials,
        id=__ret__.id,
        name=__ret__.name,
        type=__ret__.type)


@_utilities.lift_output_func(get_channel)
def get_channel_output(account_name: Optional[pulumi.Input[str]] = None,
                       channel_name: Optional[pulumi.Input[str]] = None,
                       resource_group_name: Optional[pulumi.Input[str]] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetChannelResult]:
    """
    The EngagementFabric channel


    :param str account_name: Account Name
    :param str channel_name: Channel Name
    :param str resource_group_name: Resource Group Name
    """
    ...
