# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'ApplicationPackageReferenceResponse',
    'AutoScaleRunErrorResponse',
    'AutoScaleRunResponse',
    'AutoScaleSettingsResponse',
    'AutoStoragePropertiesResponse',
    'AutoUserSpecificationResponse',
    'CertificateReferenceResponse',
    'CloudServiceConfigurationResponse',
    'ContainerConfigurationResponse',
    'ContainerRegistryResponse',
    'DataDiskResponse',
    'DeleteCertificateErrorResponse',
    'DeploymentConfigurationResponse',
    'EnvironmentSettingResponse',
    'FixedScaleSettingsResponse',
    'ImageReferenceResponse',
    'InboundNatPoolResponse',
    'KeyVaultReferenceResponse',
    'LinuxUserConfigurationResponse',
    'MetadataItemResponse',
    'NetworkConfigurationResponse',
    'NetworkSecurityGroupRuleResponse',
    'PoolEndpointConfigurationResponse',
    'ResizeErrorResponse',
    'ResizeOperationStatusResponse',
    'ResourceFileResponse',
    'ScaleSettingsResponse',
    'StartTaskResponse',
    'TaskContainerSettingsResponse',
    'TaskSchedulingPolicyResponse',
    'UserAccountResponse',
    'UserIdentityResponse',
    'VirtualMachineConfigurationResponse',
    'VirtualMachineFamilyCoreQuotaResponse',
    'WindowsConfigurationResponse',
    'WindowsUserConfigurationResponse',
]

@pulumi.output_type
class ApplicationPackageReferenceResponse(dict):
    def __init__(__self__, *,
                 id: str,
                 version: Optional[str] = None):
        """
        :param str version: If this is omitted, and no default version is specified for this application, the request fails with the error code InvalidApplicationPackageReferences. If you are calling the REST API directly, the HTTP status code is 409.
        """
        pulumi.set(__self__, "id", id)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def id(self) -> str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def version(self) -> Optional[str]:
        """
        If this is omitted, and no default version is specified for this application, the request fails with the error code InvalidApplicationPackageReferences. If you are calling the REST API directly, the HTTP status code is 409.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class AutoScaleRunErrorResponse(dict):
    def __init__(__self__, *,
                 code: str,
                 message: str,
                 details: Optional[Sequence['outputs.AutoScaleRunErrorResponse']] = None):
        """
        :param str code: An identifier for the error. Codes are invariant and are intended to be consumed programmatically.
        :param str message: A message describing the error, intended to be suitable for display in a user interface.
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "message", message)
        if details is not None:
            pulumi.set(__self__, "details", details)

    @property
    @pulumi.getter
    def code(self) -> str:
        """
        An identifier for the error. Codes are invariant and are intended to be consumed programmatically.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        A message describing the error, intended to be suitable for display in a user interface.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def details(self) -> Optional[Sequence['outputs.AutoScaleRunErrorResponse']]:
        return pulumi.get(self, "details")


@pulumi.output_type
class AutoScaleRunResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "evaluationTime":
            suggest = "evaluation_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AutoScaleRunResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AutoScaleRunResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AutoScaleRunResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 evaluation_time: str,
                 error: Optional['outputs.AutoScaleRunErrorResponse'] = None,
                 results: Optional[str] = None):
        """
        :param str results: Each variable value is returned in the form $variable=value, and variables are separated by semicolons.
        """
        pulumi.set(__self__, "evaluation_time", evaluation_time)
        if error is not None:
            pulumi.set(__self__, "error", error)
        if results is not None:
            pulumi.set(__self__, "results", results)

    @property
    @pulumi.getter(name="evaluationTime")
    def evaluation_time(self) -> str:
        return pulumi.get(self, "evaluation_time")

    @property
    @pulumi.getter
    def error(self) -> Optional['outputs.AutoScaleRunErrorResponse']:
        return pulumi.get(self, "error")

    @property
    @pulumi.getter
    def results(self) -> Optional[str]:
        """
        Each variable value is returned in the form $variable=value, and variables are separated by semicolons.
        """
        return pulumi.get(self, "results")


@pulumi.output_type
class AutoScaleSettingsResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "evaluationInterval":
            suggest = "evaluation_interval"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AutoScaleSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AutoScaleSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AutoScaleSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 formula: str,
                 evaluation_interval: Optional[str] = None):
        """
        :param str evaluation_interval: If omitted, the default value is 15 minutes (PT15M).
        """
        pulumi.set(__self__, "formula", formula)
        if evaluation_interval is not None:
            pulumi.set(__self__, "evaluation_interval", evaluation_interval)

    @property
    @pulumi.getter
    def formula(self) -> str:
        return pulumi.get(self, "formula")

    @property
    @pulumi.getter(name="evaluationInterval")
    def evaluation_interval(self) -> Optional[str]:
        """
        If omitted, the default value is 15 minutes (PT15M).
        """
        return pulumi.get(self, "evaluation_interval")


@pulumi.output_type
class AutoStoragePropertiesResponse(dict):
    """
    Contains information about the auto-storage account associated with a Batch account.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lastKeySync":
            suggest = "last_key_sync"
        elif key == "storageAccountId":
            suggest = "storage_account_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AutoStoragePropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AutoStoragePropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AutoStoragePropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 last_key_sync: str,
                 storage_account_id: str):
        """
        Contains information about the auto-storage account associated with a Batch account.
        :param str last_key_sync: The UTC time at which storage keys were last synchronized with the Batch account.
        :param str storage_account_id: The resource ID of the storage account to be used for auto-storage account.
        """
        pulumi.set(__self__, "last_key_sync", last_key_sync)
        pulumi.set(__self__, "storage_account_id", storage_account_id)

    @property
    @pulumi.getter(name="lastKeySync")
    def last_key_sync(self) -> str:
        """
        The UTC time at which storage keys were last synchronized with the Batch account.
        """
        return pulumi.get(self, "last_key_sync")

    @property
    @pulumi.getter(name="storageAccountId")
    def storage_account_id(self) -> str:
        """
        The resource ID of the storage account to be used for auto-storage account.
        """
        return pulumi.get(self, "storage_account_id")


@pulumi.output_type
class AutoUserSpecificationResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "elevationLevel":
            suggest = "elevation_level"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AutoUserSpecificationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AutoUserSpecificationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AutoUserSpecificationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 elevation_level: Optional[str] = None,
                 scope: Optional[str] = None):
        """
        :param str elevation_level: nonAdmin - The auto user is a standard user without elevated access. admin - The auto user is a user with elevated access and operates with full Administrator permissions. The default value is nonAdmin.
        :param str scope: The default value is task.
        """
        if elevation_level is not None:
            pulumi.set(__self__, "elevation_level", elevation_level)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)

    @property
    @pulumi.getter(name="elevationLevel")
    def elevation_level(self) -> Optional[str]:
        """
        nonAdmin - The auto user is a standard user without elevated access. admin - The auto user is a user with elevated access and operates with full Administrator permissions. The default value is nonAdmin.
        """
        return pulumi.get(self, "elevation_level")

    @property
    @pulumi.getter
    def scope(self) -> Optional[str]:
        """
        The default value is task.
        """
        return pulumi.get(self, "scope")


@pulumi.output_type
class CertificateReferenceResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "storeLocation":
            suggest = "store_location"
        elif key == "storeName":
            suggest = "store_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateReferenceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateReferenceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateReferenceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: str,
                 store_location: Optional[str] = None,
                 store_name: Optional[str] = None,
                 visibility: Optional[Sequence[str]] = None):
        """
        :param str store_location: The default value is currentUser. This property is applicable only for pools configured with Windows nodes (that is, created with cloudServiceConfiguration, or with virtualMachineConfiguration using a Windows image reference). For Linux compute nodes, the certificates are stored in a directory inside the task working directory and an environment variable AZ_BATCH_CERTIFICATES_DIR is supplied to the task to query for this location. For certificates with visibility of 'remoteUser', a 'certs' directory is created in the user's home directory (e.g., /home/{user-name}/certs) and certificates are placed in that directory.
        :param str store_name: This property is applicable only for pools configured with Windows nodes (that is, created with cloudServiceConfiguration, or with virtualMachineConfiguration using a Windows image reference). Common store names include: My, Root, CA, Trust, Disallowed, TrustedPeople, TrustedPublisher, AuthRoot, AddressBook, but any custom store name can also be used. The default value is My.
        """
        pulumi.set(__self__, "id", id)
        if store_location is not None:
            pulumi.set(__self__, "store_location", store_location)
        if store_name is not None:
            pulumi.set(__self__, "store_name", store_name)
        if visibility is not None:
            pulumi.set(__self__, "visibility", visibility)

    @property
    @pulumi.getter
    def id(self) -> str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="storeLocation")
    def store_location(self) -> Optional[str]:
        """
        The default value is currentUser. This property is applicable only for pools configured with Windows nodes (that is, created with cloudServiceConfiguration, or with virtualMachineConfiguration using a Windows image reference). For Linux compute nodes, the certificates are stored in a directory inside the task working directory and an environment variable AZ_BATCH_CERTIFICATES_DIR is supplied to the task to query for this location. For certificates with visibility of 'remoteUser', a 'certs' directory is created in the user's home directory (e.g., /home/{user-name}/certs) and certificates are placed in that directory.
        """
        return pulumi.get(self, "store_location")

    @property
    @pulumi.getter(name="storeName")
    def store_name(self) -> Optional[str]:
        """
        This property is applicable only for pools configured with Windows nodes (that is, created with cloudServiceConfiguration, or with virtualMachineConfiguration using a Windows image reference). Common store names include: My, Root, CA, Trust, Disallowed, TrustedPeople, TrustedPublisher, AuthRoot, AddressBook, but any custom store name can also be used. The default value is My.
        """
        return pulumi.get(self, "store_name")

    @property
    @pulumi.getter
    def visibility(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "visibility")


@pulumi.output_type
class CloudServiceConfigurationResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "osFamily":
            suggest = "os_family"
        elif key == "osVersion":
            suggest = "os_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CloudServiceConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CloudServiceConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CloudServiceConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 os_family: str,
                 os_version: Optional[str] = None):
        """
        :param str os_family: Possible values are: 2 - OS Family 2, equivalent to Windows Server 2008 R2 SP1. 3 - OS Family 3, equivalent to Windows Server 2012. 4 - OS Family 4, equivalent to Windows Server 2012 R2. 5 - OS Family 5, equivalent to Windows Server 2016. 6 - OS Family 6, equivalent to Windows Server 2019. For more information, see Azure Guest OS Releases (https://azure.microsoft.com/documentation/articles/cloud-services-guestos-update-matrix/#releases).
        :param str os_version: The default value is * which specifies the latest operating system version for the specified OS family.
        """
        pulumi.set(__self__, "os_family", os_family)
        if os_version is not None:
            pulumi.set(__self__, "os_version", os_version)

    @property
    @pulumi.getter(name="osFamily")
    def os_family(self) -> str:
        """
        Possible values are: 2 - OS Family 2, equivalent to Windows Server 2008 R2 SP1. 3 - OS Family 3, equivalent to Windows Server 2012. 4 - OS Family 4, equivalent to Windows Server 2012 R2. 5 - OS Family 5, equivalent to Windows Server 2016. 6 - OS Family 6, equivalent to Windows Server 2019. For more information, see Azure Guest OS Releases (https://azure.microsoft.com/documentation/articles/cloud-services-guestos-update-matrix/#releases).
        """
        return pulumi.get(self, "os_family")

    @property
    @pulumi.getter(name="osVersion")
    def os_version(self) -> Optional[str]:
        """
        The default value is * which specifies the latest operating system version for the specified OS family.
        """
        return pulumi.get(self, "os_version")


@pulumi.output_type
class ContainerConfigurationResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerImageNames":
            suggest = "container_image_names"
        elif key == "containerRegistries":
            suggest = "container_registries"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 container_image_names: Optional[Sequence[str]] = None,
                 container_registries: Optional[Sequence['outputs.ContainerRegistryResponse']] = None):
        """
        :param Sequence[str] container_image_names: This is the full image reference, as would be specified to "docker pull". An image will be sourced from the default Docker registry unless the image is fully qualified with an alternative registry.
        :param Sequence['ContainerRegistryResponse'] container_registries: If any images must be downloaded from a private registry which requires credentials, then those credentials must be provided here.
        """
        pulumi.set(__self__, "type", type)
        if container_image_names is not None:
            pulumi.set(__self__, "container_image_names", container_image_names)
        if container_registries is not None:
            pulumi.set(__self__, "container_registries", container_registries)

    @property
    @pulumi.getter
    def type(self) -> str:
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="containerImageNames")
    def container_image_names(self) -> Optional[Sequence[str]]:
        """
        This is the full image reference, as would be specified to "docker pull". An image will be sourced from the default Docker registry unless the image is fully qualified with an alternative registry.
        """
        return pulumi.get(self, "container_image_names")

    @property
    @pulumi.getter(name="containerRegistries")
    def container_registries(self) -> Optional[Sequence['outputs.ContainerRegistryResponse']]:
        """
        If any images must be downloaded from a private registry which requires credentials, then those credentials must be provided here.
        """
        return pulumi.get(self, "container_registries")


@pulumi.output_type
class ContainerRegistryResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "userName":
            suggest = "user_name"
        elif key == "registryServer":
            suggest = "registry_server"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerRegistryResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerRegistryResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerRegistryResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 password: str,
                 user_name: str,
                 registry_server: Optional[str] = None):
        """
        :param str registry_server: If omitted, the default is "docker.io".
        """
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "user_name", user_name)
        if registry_server is not None:
            pulumi.set(__self__, "registry_server", registry_server)

    @property
    @pulumi.getter
    def password(self) -> str:
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> str:
        return pulumi.get(self, "user_name")

    @property
    @pulumi.getter(name="registryServer")
    def registry_server(self) -> Optional[str]:
        """
        If omitted, the default is "docker.io".
        """
        return pulumi.get(self, "registry_server")


@pulumi.output_type
class DataDiskResponse(dict):
    """
    Data Disk settings which will be used by the data disks associated to Compute Nodes in the pool.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "diskSizeGB":
            suggest = "disk_size_gb"
        elif key == "storageAccountType":
            suggest = "storage_account_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataDiskResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataDiskResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataDiskResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disk_size_gb: int,
                 lun: int,
                 caching: Optional[str] = None,
                 storage_account_type: Optional[str] = None):
        """
        Data Disk settings which will be used by the data disks associated to Compute Nodes in the pool.
        :param int lun: The lun is used to uniquely identify each data disk. If attaching multiple disks, each should have a distinct lun.
        :param str caching: Values are:
               
                none - The caching mode for the disk is not enabled.
                readOnly - The caching mode for the disk is read only.
                readWrite - The caching mode for the disk is read and write.
               
                The default value for caching is none. For information about the caching options see: https://blogs.msdn.microsoft.com/windowsazurestorage/2012/06/27/exploring-windows-azure-drives-disks-and-images/.
        :param str storage_account_type: If omitted, the default is "Standard_LRS". Values are:
               
                Standard_LRS - The data disk should use standard locally redundant storage.
                Premium_LRS - The data disk should use premium locally redundant storage.
        """
        pulumi.set(__self__, "disk_size_gb", disk_size_gb)
        pulumi.set(__self__, "lun", lun)
        if caching is not None:
            pulumi.set(__self__, "caching", caching)
        if storage_account_type is not None:
            pulumi.set(__self__, "storage_account_type", storage_account_type)

    @property
    @pulumi.getter(name="diskSizeGB")
    def disk_size_gb(self) -> int:
        return pulumi.get(self, "disk_size_gb")

    @property
    @pulumi.getter
    def lun(self) -> int:
        """
        The lun is used to uniquely identify each data disk. If attaching multiple disks, each should have a distinct lun.
        """
        return pulumi.get(self, "lun")

    @property
    @pulumi.getter
    def caching(self) -> Optional[str]:
        """
        Values are:

         none - The caching mode for the disk is not enabled.
         readOnly - The caching mode for the disk is read only.
         readWrite - The caching mode for the disk is read and write.

         The default value for caching is none. For information about the caching options see: https://blogs.msdn.microsoft.com/windowsazurestorage/2012/06/27/exploring-windows-azure-drives-disks-and-images/.
        """
        return pulumi.get(self, "caching")

    @property
    @pulumi.getter(name="storageAccountType")
    def storage_account_type(self) -> Optional[str]:
        """
        If omitted, the default is "Standard_LRS". Values are:

         Standard_LRS - The data disk should use standard locally redundant storage.
         Premium_LRS - The data disk should use premium locally redundant storage.
        """
        return pulumi.get(self, "storage_account_type")


@pulumi.output_type
class DeleteCertificateErrorResponse(dict):
    """
    An error response from the Batch service.
    """
    def __init__(__self__, *,
                 code: str,
                 message: str,
                 details: Optional[Sequence['outputs.DeleteCertificateErrorResponse']] = None,
                 target: Optional[str] = None):
        """
        An error response from the Batch service.
        :param str code: An identifier for the error. Codes are invariant and are intended to be consumed programmatically.
        :param str message: A message describing the error, intended to be suitable for display in a user interface.
        :param Sequence['DeleteCertificateErrorResponse'] details: A list of additional details about the error.
        :param str target: The target of the particular error. For example, the name of the property in error.
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "message", message)
        if details is not None:
            pulumi.set(__self__, "details", details)
        if target is not None:
            pulumi.set(__self__, "target", target)

    @property
    @pulumi.getter
    def code(self) -> str:
        """
        An identifier for the error. Codes are invariant and are intended to be consumed programmatically.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        A message describing the error, intended to be suitable for display in a user interface.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def details(self) -> Optional[Sequence['outputs.DeleteCertificateErrorResponse']]:
        """
        A list of additional details about the error.
        """
        return pulumi.get(self, "details")

    @property
    @pulumi.getter
    def target(self) -> Optional[str]:
        """
        The target of the particular error. For example, the name of the property in error.
        """
        return pulumi.get(self, "target")


@pulumi.output_type
class DeploymentConfigurationResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cloudServiceConfiguration":
            suggest = "cloud_service_configuration"
        elif key == "virtualMachineConfiguration":
            suggest = "virtual_machine_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cloud_service_configuration: Optional['outputs.CloudServiceConfigurationResponse'] = None,
                 virtual_machine_configuration: Optional['outputs.VirtualMachineConfigurationResponse'] = None):
        """
        :param 'CloudServiceConfigurationResponse' cloud_service_configuration: This property and virtualMachineConfiguration are mutually exclusive and one of the properties must be specified. This property cannot be specified if the Batch account was created with its poolAllocationMode property set to 'UserSubscription'.
        :param 'VirtualMachineConfigurationResponse' virtual_machine_configuration: This property and cloudServiceConfiguration are mutually exclusive and one of the properties must be specified.
        """
        if cloud_service_configuration is not None:
            pulumi.set(__self__, "cloud_service_configuration", cloud_service_configuration)
        if virtual_machine_configuration is not None:
            pulumi.set(__self__, "virtual_machine_configuration", virtual_machine_configuration)

    @property
    @pulumi.getter(name="cloudServiceConfiguration")
    def cloud_service_configuration(self) -> Optional['outputs.CloudServiceConfigurationResponse']:
        """
        This property and virtualMachineConfiguration are mutually exclusive and one of the properties must be specified. This property cannot be specified if the Batch account was created with its poolAllocationMode property set to 'UserSubscription'.
        """
        return pulumi.get(self, "cloud_service_configuration")

    @property
    @pulumi.getter(name="virtualMachineConfiguration")
    def virtual_machine_configuration(self) -> Optional['outputs.VirtualMachineConfigurationResponse']:
        """
        This property and cloudServiceConfiguration are mutually exclusive and one of the properties must be specified.
        """
        return pulumi.get(self, "virtual_machine_configuration")


@pulumi.output_type
class EnvironmentSettingResponse(dict):
    def __init__(__self__, *,
                 name: str,
                 value: Optional[str] = None):
        pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        return pulumi.get(self, "value")


@pulumi.output_type
class FixedScaleSettingsResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nodeDeallocationOption":
            suggest = "node_deallocation_option"
        elif key == "resizeTimeout":
            suggest = "resize_timeout"
        elif key == "targetDedicatedNodes":
            suggest = "target_dedicated_nodes"
        elif key == "targetLowPriorityNodes":
            suggest = "target_low_priority_nodes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FixedScaleSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FixedScaleSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FixedScaleSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 node_deallocation_option: Optional[str] = None,
                 resize_timeout: Optional[str] = None,
                 target_dedicated_nodes: Optional[int] = None,
                 target_low_priority_nodes: Optional[int] = None):
        """
        :param str node_deallocation_option: If omitted, the default value is Requeue.
        :param str resize_timeout: The default value is 15 minutes. Timeout values use ISO 8601 format. For example, use PT10M for 10 minutes. The minimum value is 5 minutes. If you specify a value less than 5 minutes, the Batch service rejects the request with an error; if you are calling the REST API directly, the HTTP status code is 400 (Bad Request).
        :param int target_dedicated_nodes: At least one of targetDedicatedNodes, targetLowPriority nodes must be set.
        :param int target_low_priority_nodes: At least one of targetDedicatedNodes, targetLowPriority nodes must be set.
        """
        if node_deallocation_option is not None:
            pulumi.set(__self__, "node_deallocation_option", node_deallocation_option)
        if resize_timeout is not None:
            pulumi.set(__self__, "resize_timeout", resize_timeout)
        if target_dedicated_nodes is not None:
            pulumi.set(__self__, "target_dedicated_nodes", target_dedicated_nodes)
        if target_low_priority_nodes is not None:
            pulumi.set(__self__, "target_low_priority_nodes", target_low_priority_nodes)

    @property
    @pulumi.getter(name="nodeDeallocationOption")
    def node_deallocation_option(self) -> Optional[str]:
        """
        If omitted, the default value is Requeue.
        """
        return pulumi.get(self, "node_deallocation_option")

    @property
    @pulumi.getter(name="resizeTimeout")
    def resize_timeout(self) -> Optional[str]:
        """
        The default value is 15 minutes. Timeout values use ISO 8601 format. For example, use PT10M for 10 minutes. The minimum value is 5 minutes. If you specify a value less than 5 minutes, the Batch service rejects the request with an error; if you are calling the REST API directly, the HTTP status code is 400 (Bad Request).
        """
        return pulumi.get(self, "resize_timeout")

    @property
    @pulumi.getter(name="targetDedicatedNodes")
    def target_dedicated_nodes(self) -> Optional[int]:
        """
        At least one of targetDedicatedNodes, targetLowPriority nodes must be set.
        """
        return pulumi.get(self, "target_dedicated_nodes")

    @property
    @pulumi.getter(name="targetLowPriorityNodes")
    def target_low_priority_nodes(self) -> Optional[int]:
        """
        At least one of targetDedicatedNodes, targetLowPriority nodes must be set.
        """
        return pulumi.get(self, "target_low_priority_nodes")


@pulumi.output_type
class ImageReferenceResponse(dict):
    def __init__(__self__, *,
                 id: Optional[str] = None,
                 offer: Optional[str] = None,
                 publisher: Optional[str] = None,
                 sku: Optional[str] = None,
                 version: Optional[str] = None):
        """
        :param str id: This property is mutually exclusive with other properties. The virtual machine image must be in the same region and subscription as the Azure Batch account. For information about the firewall settings for Batch node agent to communicate with Batch service see https://docs.microsoft.com/en-us/azure/batch/batch-api-basics#virtual-network-vnet-and-firewall-configuration .
        :param str offer: For example, UbuntuServer or WindowsServer.
        :param str publisher: For example, Canonical or MicrosoftWindowsServer.
        :param str sku: For example, 14.04.0-LTS or 2012-R2-Datacenter.
        :param str version: A value of 'latest' can be specified to select the latest version of an image. If omitted, the default is 'latest'.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if offer is not None:
            pulumi.set(__self__, "offer", offer)
        if publisher is not None:
            pulumi.set(__self__, "publisher", publisher)
        if sku is not None:
            pulumi.set(__self__, "sku", sku)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        This property is mutually exclusive with other properties. The virtual machine image must be in the same region and subscription as the Azure Batch account. For information about the firewall settings for Batch node agent to communicate with Batch service see https://docs.microsoft.com/en-us/azure/batch/batch-api-basics#virtual-network-vnet-and-firewall-configuration .
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def offer(self) -> Optional[str]:
        """
        For example, UbuntuServer or WindowsServer.
        """
        return pulumi.get(self, "offer")

    @property
    @pulumi.getter
    def publisher(self) -> Optional[str]:
        """
        For example, Canonical or MicrosoftWindowsServer.
        """
        return pulumi.get(self, "publisher")

    @property
    @pulumi.getter
    def sku(self) -> Optional[str]:
        """
        For example, 14.04.0-LTS or 2012-R2-Datacenter.
        """
        return pulumi.get(self, "sku")

    @property
    @pulumi.getter
    def version(self) -> Optional[str]:
        """
        A value of 'latest' can be specified to select the latest version of an image. If omitted, the default is 'latest'.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class InboundNatPoolResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backendPort":
            suggest = "backend_port"
        elif key == "frontendPortRangeEnd":
            suggest = "frontend_port_range_end"
        elif key == "frontendPortRangeStart":
            suggest = "frontend_port_range_start"
        elif key == "networkSecurityGroupRules":
            suggest = "network_security_group_rules"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InboundNatPoolResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InboundNatPoolResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InboundNatPoolResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backend_port: int,
                 frontend_port_range_end: int,
                 frontend_port_range_start: int,
                 name: str,
                 protocol: str,
                 network_security_group_rules: Optional[Sequence['outputs.NetworkSecurityGroupRuleResponse']] = None):
        """
        :param int backend_port: This must be unique within a Batch pool. Acceptable values are between 1 and 65535 except for 22, 3389, 29876 and 29877 as these are reserved. If any reserved values are provided the request fails with HTTP status code 400.
        :param int frontend_port_range_end: Acceptable values range between 1 and 65534 except ports from 50000 to 55000 which are reserved by the Batch service. All ranges within a pool must be distinct and cannot overlap. If any reserved or overlapping values are provided the request fails with HTTP status code 400.
        :param int frontend_port_range_start: Acceptable values range between 1 and 65534 except ports from 50000 to 55000 which are reserved. All ranges within a pool must be distinct and cannot overlap. If any reserved or overlapping values are provided the request fails with HTTP status code 400.
        :param str name: The name must be unique within a Batch pool, can contain letters, numbers, underscores, periods, and hyphens. Names must start with a letter or number, must end with a letter, number, or underscore, and cannot exceed 77 characters.  If any invalid values are provided the request fails with HTTP status code 400.
        :param Sequence['NetworkSecurityGroupRuleResponse'] network_security_group_rules: The maximum number of rules that can be specified across all the endpoints on a Batch pool is 25. If no network security group rules are specified, a default rule will be created to allow inbound access to the specified backendPort. If the maximum number of network security group rules is exceeded the request fails with HTTP status code 400.
        """
        pulumi.set(__self__, "backend_port", backend_port)
        pulumi.set(__self__, "frontend_port_range_end", frontend_port_range_end)
        pulumi.set(__self__, "frontend_port_range_start", frontend_port_range_start)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "protocol", protocol)
        if network_security_group_rules is not None:
            pulumi.set(__self__, "network_security_group_rules", network_security_group_rules)

    @property
    @pulumi.getter(name="backendPort")
    def backend_port(self) -> int:
        """
        This must be unique within a Batch pool. Acceptable values are between 1 and 65535 except for 22, 3389, 29876 and 29877 as these are reserved. If any reserved values are provided the request fails with HTTP status code 400.
        """
        return pulumi.get(self, "backend_port")

    @property
    @pulumi.getter(name="frontendPortRangeEnd")
    def frontend_port_range_end(self) -> int:
        """
        Acceptable values range between 1 and 65534 except ports from 50000 to 55000 which are reserved by the Batch service. All ranges within a pool must be distinct and cannot overlap. If any reserved or overlapping values are provided the request fails with HTTP status code 400.
        """
        return pulumi.get(self, "frontend_port_range_end")

    @property
    @pulumi.getter(name="frontendPortRangeStart")
    def frontend_port_range_start(self) -> int:
        """
        Acceptable values range between 1 and 65534 except ports from 50000 to 55000 which are reserved. All ranges within a pool must be distinct and cannot overlap. If any reserved or overlapping values are provided the request fails with HTTP status code 400.
        """
        return pulumi.get(self, "frontend_port_range_start")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name must be unique within a Batch pool, can contain letters, numbers, underscores, periods, and hyphens. Names must start with a letter or number, must end with a letter, number, or underscore, and cannot exceed 77 characters.  If any invalid values are provided the request fails with HTTP status code 400.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def protocol(self) -> str:
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="networkSecurityGroupRules")
    def network_security_group_rules(self) -> Optional[Sequence['outputs.NetworkSecurityGroupRuleResponse']]:
        """
        The maximum number of rules that can be specified across all the endpoints on a Batch pool is 25. If no network security group rules are specified, a default rule will be created to allow inbound access to the specified backendPort. If the maximum number of network security group rules is exceeded the request fails with HTTP status code 400.
        """
        return pulumi.get(self, "network_security_group_rules")


@pulumi.output_type
class KeyVaultReferenceResponse(dict):
    """
    Identifies the Azure key vault associated with a Batch account.
    """
    def __init__(__self__, *,
                 id: str,
                 url: str):
        """
        Identifies the Azure key vault associated with a Batch account.
        :param str id: The resource ID of the Azure key vault associated with the Batch account.
        :param str url: The URL of the Azure key vault associated with the Batch account.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The resource ID of the Azure key vault associated with the Batch account.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        The URL of the Azure key vault associated with the Batch account.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class LinuxUserConfigurationResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sshPrivateKey":
            suggest = "ssh_private_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LinuxUserConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LinuxUserConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LinuxUserConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 gid: Optional[int] = None,
                 ssh_private_key: Optional[str] = None,
                 uid: Optional[int] = None):
        """
        :param int gid: The uid and gid properties must be specified together or not at all. If not specified the underlying operating system picks the gid.
        :param str ssh_private_key: The private key must not be password protected. The private key is used to automatically configure asymmetric-key based authentication for SSH between nodes in a Linux pool when the pool's enableInterNodeCommunication property is true (it is ignored if enableInterNodeCommunication is false). It does this by placing the key pair into the user's .ssh directory. If not specified, password-less SSH is not configured between nodes (no modification of the user's .ssh directory is done).
        :param int uid: The uid and gid properties must be specified together or not at all. If not specified the underlying operating system picks the uid.
        """
        if gid is not None:
            pulumi.set(__self__, "gid", gid)
        if ssh_private_key is not None:
            pulumi.set(__self__, "ssh_private_key", ssh_private_key)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)

    @property
    @pulumi.getter
    def gid(self) -> Optional[int]:
        """
        The uid and gid properties must be specified together or not at all. If not specified the underlying operating system picks the gid.
        """
        return pulumi.get(self, "gid")

    @property
    @pulumi.getter(name="sshPrivateKey")
    def ssh_private_key(self) -> Optional[str]:
        """
        The private key must not be password protected. The private key is used to automatically configure asymmetric-key based authentication for SSH between nodes in a Linux pool when the pool's enableInterNodeCommunication property is true (it is ignored if enableInterNodeCommunication is false). It does this by placing the key pair into the user's .ssh directory. If not specified, password-less SSH is not configured between nodes (no modification of the user's .ssh directory is done).
        """
        return pulumi.get(self, "ssh_private_key")

    @property
    @pulumi.getter
    def uid(self) -> Optional[int]:
        """
        The uid and gid properties must be specified together or not at all. If not specified the underlying operating system picks the uid.
        """
        return pulumi.get(self, "uid")


@pulumi.output_type
class MetadataItemResponse(dict):
    """
    The Batch service does not assign any meaning to this metadata; it is solely for the use of user code.
    """
    def __init__(__self__, *,
                 name: str,
                 value: str):
        """
        The Batch service does not assign any meaning to this metadata; it is solely for the use of user code.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        return pulumi.get(self, "value")


@pulumi.output_type
class NetworkConfigurationResponse(dict):
    """
    The network configuration for a pool.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endpointConfiguration":
            suggest = "endpoint_configuration"
        elif key == "subnetId":
            suggest = "subnet_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 endpoint_configuration: Optional['outputs.PoolEndpointConfigurationResponse'] = None,
                 subnet_id: Optional[str] = None):
        """
        The network configuration for a pool.
        :param 'PoolEndpointConfigurationResponse' endpoint_configuration: Pool endpoint configuration is only supported on pools with the virtualMachineConfiguration property.
        :param str subnet_id: The virtual network must be in the same region and subscription as the Azure Batch account. The specified subnet should have enough free IP addresses to accommodate the number of nodes in the pool. If the subnet doesn't have enough free IP addresses, the pool will partially allocate compute nodes, and a resize error will occur. The 'MicrosoftAzureBatch' service principal must have the 'Classic Virtual Machine Contributor' Role-Based Access Control (RBAC) role for the specified VNet. The specified subnet must allow communication from the Azure Batch service to be able to schedule tasks on the compute nodes. This can be verified by checking if the specified VNet has any associated Network Security Groups (NSG). If communication to the compute nodes in the specified subnet is denied by an NSG, then the Batch service will set the state of the compute nodes to unusable. For pools created via virtualMachineConfiguration the Batch account must have poolAllocationMode userSubscription in order to use a VNet. If the specified VNet has any associated Network Security Groups (NSG), then a few reserved system ports must be enabled for inbound communication. For pools created with a virtual machine configuration, enable ports 29876 and 29877, as well as port 22 for Linux and port 3389 for Windows. For pools created with a cloud service configuration, enable ports 10100, 20100, and 30100. Also enable outbound connections to Azure Storage on port 443. For more details see: https://docs.microsoft.com/en-us/azure/batch/batch-api-basics#virtual-network-vnet-and-firewall-configuration
        """
        if endpoint_configuration is not None:
            pulumi.set(__self__, "endpoint_configuration", endpoint_configuration)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)

    @property
    @pulumi.getter(name="endpointConfiguration")
    def endpoint_configuration(self) -> Optional['outputs.PoolEndpointConfigurationResponse']:
        """
        Pool endpoint configuration is only supported on pools with the virtualMachineConfiguration property.
        """
        return pulumi.get(self, "endpoint_configuration")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[str]:
        """
        The virtual network must be in the same region and subscription as the Azure Batch account. The specified subnet should have enough free IP addresses to accommodate the number of nodes in the pool. If the subnet doesn't have enough free IP addresses, the pool will partially allocate compute nodes, and a resize error will occur. The 'MicrosoftAzureBatch' service principal must have the 'Classic Virtual Machine Contributor' Role-Based Access Control (RBAC) role for the specified VNet. The specified subnet must allow communication from the Azure Batch service to be able to schedule tasks on the compute nodes. This can be verified by checking if the specified VNet has any associated Network Security Groups (NSG). If communication to the compute nodes in the specified subnet is denied by an NSG, then the Batch service will set the state of the compute nodes to unusable. For pools created via virtualMachineConfiguration the Batch account must have poolAllocationMode userSubscription in order to use a VNet. If the specified VNet has any associated Network Security Groups (NSG), then a few reserved system ports must be enabled for inbound communication. For pools created with a virtual machine configuration, enable ports 29876 and 29877, as well as port 22 for Linux and port 3389 for Windows. For pools created with a cloud service configuration, enable ports 10100, 20100, and 30100. Also enable outbound connections to Azure Storage on port 443. For more details see: https://docs.microsoft.com/en-us/azure/batch/batch-api-basics#virtual-network-vnet-and-firewall-configuration
        """
        return pulumi.get(self, "subnet_id")


@pulumi.output_type
class NetworkSecurityGroupRuleResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceAddressPrefix":
            suggest = "source_address_prefix"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkSecurityGroupRuleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkSecurityGroupRuleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkSecurityGroupRuleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access: str,
                 priority: int,
                 source_address_prefix: str):
        """
        :param int priority: Priorities within a pool must be unique and are evaluated in order of priority. The lower the number the higher the priority. For example, rules could be specified with order numbers of 150, 250, and 350. The rule with the order number of 150 takes precedence over the rule that has an order of 250. Allowed priorities are 150 to 3500. If any reserved or duplicate values are provided the request fails with HTTP status code 400.
        :param str source_address_prefix: Valid values are a single IP address (i.e. 10.10.10.10), IP subnet (i.e. 192.168.1.0/24), default tag, or * (for all addresses).  If any other values are provided the request fails with HTTP status code 400.
        """
        pulumi.set(__self__, "access", access)
        pulumi.set(__self__, "priority", priority)
        pulumi.set(__self__, "source_address_prefix", source_address_prefix)

    @property
    @pulumi.getter
    def access(self) -> str:
        return pulumi.get(self, "access")

    @property
    @pulumi.getter
    def priority(self) -> int:
        """
        Priorities within a pool must be unique and are evaluated in order of priority. The lower the number the higher the priority. For example, rules could be specified with order numbers of 150, 250, and 350. The rule with the order number of 150 takes precedence over the rule that has an order of 250. Allowed priorities are 150 to 3500. If any reserved or duplicate values are provided the request fails with HTTP status code 400.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter(name="sourceAddressPrefix")
    def source_address_prefix(self) -> str:
        """
        Valid values are a single IP address (i.e. 10.10.10.10), IP subnet (i.e. 192.168.1.0/24), default tag, or * (for all addresses).  If any other values are provided the request fails with HTTP status code 400.
        """
        return pulumi.get(self, "source_address_prefix")


@pulumi.output_type
class PoolEndpointConfigurationResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "inboundNatPools":
            suggest = "inbound_nat_pools"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PoolEndpointConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PoolEndpointConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PoolEndpointConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 inbound_nat_pools: Sequence['outputs.InboundNatPoolResponse']):
        """
        :param Sequence['InboundNatPoolResponse'] inbound_nat_pools: The maximum number of inbound NAT pools per Batch pool is 5. If the maximum number of inbound NAT pools is exceeded the request fails with HTTP status code 400.
        """
        pulumi.set(__self__, "inbound_nat_pools", inbound_nat_pools)

    @property
    @pulumi.getter(name="inboundNatPools")
    def inbound_nat_pools(self) -> Sequence['outputs.InboundNatPoolResponse']:
        """
        The maximum number of inbound NAT pools per Batch pool is 5. If the maximum number of inbound NAT pools is exceeded the request fails with HTTP status code 400.
        """
        return pulumi.get(self, "inbound_nat_pools")


@pulumi.output_type
class ResizeErrorResponse(dict):
    def __init__(__self__, *,
                 code: str,
                 message: str,
                 details: Optional[Sequence['outputs.ResizeErrorResponse']] = None):
        """
        :param str code: An identifier for the error. Codes are invariant and are intended to be consumed programmatically.
        :param str message: A message describing the error, intended to be suitable for display in a user interface.
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "message", message)
        if details is not None:
            pulumi.set(__self__, "details", details)

    @property
    @pulumi.getter
    def code(self) -> str:
        """
        An identifier for the error. Codes are invariant and are intended to be consumed programmatically.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        A message describing the error, intended to be suitable for display in a user interface.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def details(self) -> Optional[Sequence['outputs.ResizeErrorResponse']]:
        return pulumi.get(self, "details")


@pulumi.output_type
class ResizeOperationStatusResponse(dict):
    """
    Describes either the current operation (if the pool AllocationState is Resizing) or the previously completed operation (if the AllocationState is Steady).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nodeDeallocationOption":
            suggest = "node_deallocation_option"
        elif key == "resizeTimeout":
            suggest = "resize_timeout"
        elif key == "startTime":
            suggest = "start_time"
        elif key == "targetDedicatedNodes":
            suggest = "target_dedicated_nodes"
        elif key == "targetLowPriorityNodes":
            suggest = "target_low_priority_nodes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResizeOperationStatusResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResizeOperationStatusResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResizeOperationStatusResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 errors: Optional[Sequence['outputs.ResizeErrorResponse']] = None,
                 node_deallocation_option: Optional[str] = None,
                 resize_timeout: Optional[str] = None,
                 start_time: Optional[str] = None,
                 target_dedicated_nodes: Optional[int] = None,
                 target_low_priority_nodes: Optional[int] = None):
        """
        Describes either the current operation (if the pool AllocationState is Resizing) or the previously completed operation (if the AllocationState is Steady).
        :param Sequence['ResizeErrorResponse'] errors: This property is set only if an error occurred during the last pool resize, and only when the pool allocationState is Steady.
        :param str node_deallocation_option: The default value is requeue.
        :param str resize_timeout: The default value is 15 minutes. The minimum value is 5 minutes. If you specify a value less than 5 minutes, the Batch service returns an error; if you are calling the REST API directly, the HTTP status code is 400 (Bad Request).
        """
        if errors is not None:
            pulumi.set(__self__, "errors", errors)
        if node_deallocation_option is not None:
            pulumi.set(__self__, "node_deallocation_option", node_deallocation_option)
        if resize_timeout is not None:
            pulumi.set(__self__, "resize_timeout", resize_timeout)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)
        if target_dedicated_nodes is not None:
            pulumi.set(__self__, "target_dedicated_nodes", target_dedicated_nodes)
        if target_low_priority_nodes is not None:
            pulumi.set(__self__, "target_low_priority_nodes", target_low_priority_nodes)

    @property
    @pulumi.getter
    def errors(self) -> Optional[Sequence['outputs.ResizeErrorResponse']]:
        """
        This property is set only if an error occurred during the last pool resize, and only when the pool allocationState is Steady.
        """
        return pulumi.get(self, "errors")

    @property
    @pulumi.getter(name="nodeDeallocationOption")
    def node_deallocation_option(self) -> Optional[str]:
        """
        The default value is requeue.
        """
        return pulumi.get(self, "node_deallocation_option")

    @property
    @pulumi.getter(name="resizeTimeout")
    def resize_timeout(self) -> Optional[str]:
        """
        The default value is 15 minutes. The minimum value is 5 minutes. If you specify a value less than 5 minutes, the Batch service returns an error; if you are calling the REST API directly, the HTTP status code is 400 (Bad Request).
        """
        return pulumi.get(self, "resize_timeout")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[str]:
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter(name="targetDedicatedNodes")
    def target_dedicated_nodes(self) -> Optional[int]:
        return pulumi.get(self, "target_dedicated_nodes")

    @property
    @pulumi.getter(name="targetLowPriorityNodes")
    def target_low_priority_nodes(self) -> Optional[int]:
        return pulumi.get(self, "target_low_priority_nodes")


@pulumi.output_type
class ResourceFileResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autoStorageContainerName":
            suggest = "auto_storage_container_name"
        elif key == "blobPrefix":
            suggest = "blob_prefix"
        elif key == "fileMode":
            suggest = "file_mode"
        elif key == "filePath":
            suggest = "file_path"
        elif key == "httpUrl":
            suggest = "http_url"
        elif key == "storageContainerUrl":
            suggest = "storage_container_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceFileResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceFileResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceFileResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auto_storage_container_name: Optional[str] = None,
                 blob_prefix: Optional[str] = None,
                 file_mode: Optional[str] = None,
                 file_path: Optional[str] = None,
                 http_url: Optional[str] = None,
                 storage_container_url: Optional[str] = None):
        """
        :param str auto_storage_container_name: The autoStorageContainerName, storageContainerUrl and httpUrl properties are mutually exclusive and one of them must be specified.
        :param str blob_prefix: The property is valid only when autoStorageContainerName or storageContainerUrl is used. This prefix can be a partial filename or a subdirectory. If a prefix is not specified, all the files in the container will be downloaded.
        :param str file_mode: This property applies only to files being downloaded to Linux compute nodes. It will be ignored if it is specified for a resourceFile which will be downloaded to a Windows node. If this property is not specified for a Linux node, then a default value of 0770 is applied to the file.
        :param str file_path: If the httpUrl property is specified, the filePath is required and describes the path which the file will be downloaded to, including the filename. Otherwise, if the autoStorageContainerName or storageContainerUrl property is specified, filePath is optional and is the directory to download the files to. In the case where filePath is used as a directory, any directory structure already associated with the input data will be retained in full and appended to the specified filePath directory. The specified relative path cannot break out of the task's working directory (for example by using '..').
        :param str http_url: The autoStorageContainerName, storageContainerUrl and httpUrl properties are mutually exclusive and one of them must be specified. If the URL is Azure Blob Storage, it must be readable using anonymous access; that is, the Batch service does not present any credentials when downloading the blob. There are two ways to get such a URL for a blob in Azure storage: include a Shared Access Signature (SAS) granting read permissions on the blob, or set the ACL for the blob or its container to allow public access.
        :param str storage_container_url: The autoStorageContainerName, storageContainerUrl and httpUrl properties are mutually exclusive and one of them must be specified. This URL must be readable and listable using anonymous access; that is, the Batch service does not present any credentials when downloading the blob. There are two ways to get such a URL for a blob in Azure storage: include a Shared Access Signature (SAS) granting read and list permissions on the blob, or set the ACL for the blob or its container to allow public access.
        """
        if auto_storage_container_name is not None:
            pulumi.set(__self__, "auto_storage_container_name", auto_storage_container_name)
        if blob_prefix is not None:
            pulumi.set(__self__, "blob_prefix", blob_prefix)
        if file_mode is not None:
            pulumi.set(__self__, "file_mode", file_mode)
        if file_path is not None:
            pulumi.set(__self__, "file_path", file_path)
        if http_url is not None:
            pulumi.set(__self__, "http_url", http_url)
        if storage_container_url is not None:
            pulumi.set(__self__, "storage_container_url", storage_container_url)

    @property
    @pulumi.getter(name="autoStorageContainerName")
    def auto_storage_container_name(self) -> Optional[str]:
        """
        The autoStorageContainerName, storageContainerUrl and httpUrl properties are mutually exclusive and one of them must be specified.
        """
        return pulumi.get(self, "auto_storage_container_name")

    @property
    @pulumi.getter(name="blobPrefix")
    def blob_prefix(self) -> Optional[str]:
        """
        The property is valid only when autoStorageContainerName or storageContainerUrl is used. This prefix can be a partial filename or a subdirectory. If a prefix is not specified, all the files in the container will be downloaded.
        """
        return pulumi.get(self, "blob_prefix")

    @property
    @pulumi.getter(name="fileMode")
    def file_mode(self) -> Optional[str]:
        """
        This property applies only to files being downloaded to Linux compute nodes. It will be ignored if it is specified for a resourceFile which will be downloaded to a Windows node. If this property is not specified for a Linux node, then a default value of 0770 is applied to the file.
        """
        return pulumi.get(self, "file_mode")

    @property
    @pulumi.getter(name="filePath")
    def file_path(self) -> Optional[str]:
        """
        If the httpUrl property is specified, the filePath is required and describes the path which the file will be downloaded to, including the filename. Otherwise, if the autoStorageContainerName or storageContainerUrl property is specified, filePath is optional and is the directory to download the files to. In the case where filePath is used as a directory, any directory structure already associated with the input data will be retained in full and appended to the specified filePath directory. The specified relative path cannot break out of the task's working directory (for example by using '..').
        """
        return pulumi.get(self, "file_path")

    @property
    @pulumi.getter(name="httpUrl")
    def http_url(self) -> Optional[str]:
        """
        The autoStorageContainerName, storageContainerUrl and httpUrl properties are mutually exclusive and one of them must be specified. If the URL is Azure Blob Storage, it must be readable using anonymous access; that is, the Batch service does not present any credentials when downloading the blob. There are two ways to get such a URL for a blob in Azure storage: include a Shared Access Signature (SAS) granting read permissions on the blob, or set the ACL for the blob or its container to allow public access.
        """
        return pulumi.get(self, "http_url")

    @property
    @pulumi.getter(name="storageContainerUrl")
    def storage_container_url(self) -> Optional[str]:
        """
        The autoStorageContainerName, storageContainerUrl and httpUrl properties are mutually exclusive and one of them must be specified. This URL must be readable and listable using anonymous access; that is, the Batch service does not present any credentials when downloading the blob. There are two ways to get such a URL for a blob in Azure storage: include a Shared Access Signature (SAS) granting read and list permissions on the blob, or set the ACL for the blob or its container to allow public access.
        """
        return pulumi.get(self, "storage_container_url")


@pulumi.output_type
class ScaleSettingsResponse(dict):
    """
    Defines the desired size of the pool. This can either be 'fixedScale' where the requested targetDedicatedNodes is specified, or 'autoScale' which defines a formula which is periodically reevaluated. If this property is not specified, the pool will have a fixed scale with 0 targetDedicatedNodes.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autoScale":
            suggest = "auto_scale"
        elif key == "fixedScale":
            suggest = "fixed_scale"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScaleSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScaleSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScaleSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auto_scale: Optional['outputs.AutoScaleSettingsResponse'] = None,
                 fixed_scale: Optional['outputs.FixedScaleSettingsResponse'] = None):
        """
        Defines the desired size of the pool. This can either be 'fixedScale' where the requested targetDedicatedNodes is specified, or 'autoScale' which defines a formula which is periodically reevaluated. If this property is not specified, the pool will have a fixed scale with 0 targetDedicatedNodes.
        :param 'AutoScaleSettingsResponse' auto_scale: This property and fixedScale are mutually exclusive and one of the properties must be specified.
        :param 'FixedScaleSettingsResponse' fixed_scale: This property and autoScale are mutually exclusive and one of the properties must be specified.
        """
        if auto_scale is not None:
            pulumi.set(__self__, "auto_scale", auto_scale)
        if fixed_scale is not None:
            pulumi.set(__self__, "fixed_scale", fixed_scale)

    @property
    @pulumi.getter(name="autoScale")
    def auto_scale(self) -> Optional['outputs.AutoScaleSettingsResponse']:
        """
        This property and fixedScale are mutually exclusive and one of the properties must be specified.
        """
        return pulumi.get(self, "auto_scale")

    @property
    @pulumi.getter(name="fixedScale")
    def fixed_scale(self) -> Optional['outputs.FixedScaleSettingsResponse']:
        """
        This property and autoScale are mutually exclusive and one of the properties must be specified.
        """
        return pulumi.get(self, "fixed_scale")


@pulumi.output_type
class StartTaskResponse(dict):
    """
    In some cases the start task may be re-run even though the node was not rebooted. Due to this, start tasks should be idempotent and exit gracefully if the setup they're performing has already been done. Special care should be taken to avoid start tasks which create breakaway process or install/launch services from the start task working directory, as this will block Batch from being able to re-run the start task.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "commandLine":
            suggest = "command_line"
        elif key == "containerSettings":
            suggest = "container_settings"
        elif key == "environmentSettings":
            suggest = "environment_settings"
        elif key == "maxTaskRetryCount":
            suggest = "max_task_retry_count"
        elif key == "resourceFiles":
            suggest = "resource_files"
        elif key == "userIdentity":
            suggest = "user_identity"
        elif key == "waitForSuccess":
            suggest = "wait_for_success"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StartTaskResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StartTaskResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StartTaskResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 command_line: Optional[str] = None,
                 container_settings: Optional['outputs.TaskContainerSettingsResponse'] = None,
                 environment_settings: Optional[Sequence['outputs.EnvironmentSettingResponse']] = None,
                 max_task_retry_count: Optional[int] = None,
                 resource_files: Optional[Sequence['outputs.ResourceFileResponse']] = None,
                 user_identity: Optional['outputs.UserIdentityResponse'] = None,
                 wait_for_success: Optional[bool] = None):
        """
        In some cases the start task may be re-run even though the node was not rebooted. Due to this, start tasks should be idempotent and exit gracefully if the setup they're performing has already been done. Special care should be taken to avoid start tasks which create breakaway process or install/launch services from the start task working directory, as this will block Batch from being able to re-run the start task.
        :param str command_line: The command line does not run under a shell, and therefore cannot take advantage of shell features such as environment variable expansion. If you want to take advantage of such features, you should invoke the shell in the command line, for example using "cmd /c MyCommand" in Windows or "/bin/sh -c MyCommand" in Linux. Required if any other properties of the startTask are specified.
        :param 'TaskContainerSettingsResponse' container_settings: When this is specified, all directories recursively below the AZ_BATCH_NODE_ROOT_DIR (the root of Azure Batch directories on the node) are mapped into the container, all task environment variables are mapped into the container, and the task command line is executed in the container.
        :param int max_task_retry_count: The Batch service retries a task if its exit code is nonzero. Note that this value specifically controls the number of retries. The Batch service will try the task once, and may then retry up to this limit. For example, if the maximum retry count is 3, Batch tries the task up to 4 times (one initial try and 3 retries). If the maximum retry count is 0, the Batch service does not retry the task. If the maximum retry count is -1, the Batch service retries the task without limit.
        :param 'UserIdentityResponse' user_identity: If omitted, the task runs as a non-administrative user unique to the task.
        :param bool wait_for_success: If true and the start task fails on a compute node, the Batch service retries the start task up to its maximum retry count (maxTaskRetryCount). If the task has still not completed successfully after all retries, then the Batch service marks the compute node unusable, and will not schedule tasks to it. This condition can be detected via the node state and scheduling error detail. If false, the Batch service will not wait for the start task to complete. In this case, other tasks can start executing on the compute node while the start task is still running; and even if the start task fails, new tasks will continue to be scheduled on the node. The default is false.
        """
        if command_line is not None:
            pulumi.set(__self__, "command_line", command_line)
        if container_settings is not None:
            pulumi.set(__self__, "container_settings", container_settings)
        if environment_settings is not None:
            pulumi.set(__self__, "environment_settings", environment_settings)
        if max_task_retry_count is not None:
            pulumi.set(__self__, "max_task_retry_count", max_task_retry_count)
        if resource_files is not None:
            pulumi.set(__self__, "resource_files", resource_files)
        if user_identity is not None:
            pulumi.set(__self__, "user_identity", user_identity)
        if wait_for_success is not None:
            pulumi.set(__self__, "wait_for_success", wait_for_success)

    @property
    @pulumi.getter(name="commandLine")
    def command_line(self) -> Optional[str]:
        """
        The command line does not run under a shell, and therefore cannot take advantage of shell features such as environment variable expansion. If you want to take advantage of such features, you should invoke the shell in the command line, for example using "cmd /c MyCommand" in Windows or "/bin/sh -c MyCommand" in Linux. Required if any other properties of the startTask are specified.
        """
        return pulumi.get(self, "command_line")

    @property
    @pulumi.getter(name="containerSettings")
    def container_settings(self) -> Optional['outputs.TaskContainerSettingsResponse']:
        """
        When this is specified, all directories recursively below the AZ_BATCH_NODE_ROOT_DIR (the root of Azure Batch directories on the node) are mapped into the container, all task environment variables are mapped into the container, and the task command line is executed in the container.
        """
        return pulumi.get(self, "container_settings")

    @property
    @pulumi.getter(name="environmentSettings")
    def environment_settings(self) -> Optional[Sequence['outputs.EnvironmentSettingResponse']]:
        return pulumi.get(self, "environment_settings")

    @property
    @pulumi.getter(name="maxTaskRetryCount")
    def max_task_retry_count(self) -> Optional[int]:
        """
        The Batch service retries a task if its exit code is nonzero. Note that this value specifically controls the number of retries. The Batch service will try the task once, and may then retry up to this limit. For example, if the maximum retry count is 3, Batch tries the task up to 4 times (one initial try and 3 retries). If the maximum retry count is 0, the Batch service does not retry the task. If the maximum retry count is -1, the Batch service retries the task without limit.
        """
        return pulumi.get(self, "max_task_retry_count")

    @property
    @pulumi.getter(name="resourceFiles")
    def resource_files(self) -> Optional[Sequence['outputs.ResourceFileResponse']]:
        return pulumi.get(self, "resource_files")

    @property
    @pulumi.getter(name="userIdentity")
    def user_identity(self) -> Optional['outputs.UserIdentityResponse']:
        """
        If omitted, the task runs as a non-administrative user unique to the task.
        """
        return pulumi.get(self, "user_identity")

    @property
    @pulumi.getter(name="waitForSuccess")
    def wait_for_success(self) -> Optional[bool]:
        """
        If true and the start task fails on a compute node, the Batch service retries the start task up to its maximum retry count (maxTaskRetryCount). If the task has still not completed successfully after all retries, then the Batch service marks the compute node unusable, and will not schedule tasks to it. This condition can be detected via the node state and scheduling error detail. If false, the Batch service will not wait for the start task to complete. In this case, other tasks can start executing on the compute node while the start task is still running; and even if the start task fails, new tasks will continue to be scheduled on the node. The default is false.
        """
        return pulumi.get(self, "wait_for_success")


@pulumi.output_type
class TaskContainerSettingsResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "imageName":
            suggest = "image_name"
        elif key == "containerRunOptions":
            suggest = "container_run_options"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TaskContainerSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TaskContainerSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TaskContainerSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 image_name: str,
                 container_run_options: Optional[str] = None,
                 registry: Optional['outputs.ContainerRegistryResponse'] = None):
        """
        :param str image_name: This is the full image reference, as would be specified to "docker pull". If no tag is provided as part of the image name, the tag ":latest" is used as a default.
        :param str container_run_options: These additional options are supplied as arguments to the "docker create" command, in addition to those controlled by the Batch Service.
        :param 'ContainerRegistryResponse' registry: This setting can be omitted if was already provided at pool creation.
        """
        pulumi.set(__self__, "image_name", image_name)
        if container_run_options is not None:
            pulumi.set(__self__, "container_run_options", container_run_options)
        if registry is not None:
            pulumi.set(__self__, "registry", registry)

    @property
    @pulumi.getter(name="imageName")
    def image_name(self) -> str:
        """
        This is the full image reference, as would be specified to "docker pull". If no tag is provided as part of the image name, the tag ":latest" is used as a default.
        """
        return pulumi.get(self, "image_name")

    @property
    @pulumi.getter(name="containerRunOptions")
    def container_run_options(self) -> Optional[str]:
        """
        These additional options are supplied as arguments to the "docker create" command, in addition to those controlled by the Batch Service.
        """
        return pulumi.get(self, "container_run_options")

    @property
    @pulumi.getter
    def registry(self) -> Optional['outputs.ContainerRegistryResponse']:
        """
        This setting can be omitted if was already provided at pool creation.
        """
        return pulumi.get(self, "registry")


@pulumi.output_type
class TaskSchedulingPolicyResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nodeFillType":
            suggest = "node_fill_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TaskSchedulingPolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TaskSchedulingPolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TaskSchedulingPolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 node_fill_type: str):
        pulumi.set(__self__, "node_fill_type", node_fill_type)

    @property
    @pulumi.getter(name="nodeFillType")
    def node_fill_type(self) -> str:
        return pulumi.get(self, "node_fill_type")


@pulumi.output_type
class UserAccountResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "elevationLevel":
            suggest = "elevation_level"
        elif key == "linuxUserConfiguration":
            suggest = "linux_user_configuration"
        elif key == "windowsUserConfiguration":
            suggest = "windows_user_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserAccountResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserAccountResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserAccountResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 password: str,
                 elevation_level: Optional[str] = None,
                 linux_user_configuration: Optional['outputs.LinuxUserConfigurationResponse'] = None,
                 windows_user_configuration: Optional['outputs.WindowsUserConfigurationResponse'] = None):
        """
        :param str elevation_level: nonAdmin - The auto user is a standard user without elevated access. admin - The auto user is a user with elevated access and operates with full Administrator permissions. The default value is nonAdmin.
        :param 'LinuxUserConfigurationResponse' linux_user_configuration: This property is ignored if specified on a Windows pool. If not specified, the user is created with the default options.
        :param 'WindowsUserConfigurationResponse' windows_user_configuration: This property can only be specified if the user is on a Windows pool. If not specified and on a Windows pool, the user is created with the default options.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "password", password)
        if elevation_level is not None:
            pulumi.set(__self__, "elevation_level", elevation_level)
        if linux_user_configuration is not None:
            pulumi.set(__self__, "linux_user_configuration", linux_user_configuration)
        if windows_user_configuration is not None:
            pulumi.set(__self__, "windows_user_configuration", windows_user_configuration)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def password(self) -> str:
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="elevationLevel")
    def elevation_level(self) -> Optional[str]:
        """
        nonAdmin - The auto user is a standard user without elevated access. admin - The auto user is a user with elevated access and operates with full Administrator permissions. The default value is nonAdmin.
        """
        return pulumi.get(self, "elevation_level")

    @property
    @pulumi.getter(name="linuxUserConfiguration")
    def linux_user_configuration(self) -> Optional['outputs.LinuxUserConfigurationResponse']:
        """
        This property is ignored if specified on a Windows pool. If not specified, the user is created with the default options.
        """
        return pulumi.get(self, "linux_user_configuration")

    @property
    @pulumi.getter(name="windowsUserConfiguration")
    def windows_user_configuration(self) -> Optional['outputs.WindowsUserConfigurationResponse']:
        """
        This property can only be specified if the user is on a Windows pool. If not specified and on a Windows pool, the user is created with the default options.
        """
        return pulumi.get(self, "windows_user_configuration")


@pulumi.output_type
class UserIdentityResponse(dict):
    """
    Specify either the userName or autoUser property, but not both.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autoUser":
            suggest = "auto_user"
        elif key == "userName":
            suggest = "user_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserIdentityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserIdentityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserIdentityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auto_user: Optional['outputs.AutoUserSpecificationResponse'] = None,
                 user_name: Optional[str] = None):
        """
        Specify either the userName or autoUser property, but not both.
        :param 'AutoUserSpecificationResponse' auto_user: The userName and autoUser properties are mutually exclusive; you must specify one but not both.
        :param str user_name: The userName and autoUser properties are mutually exclusive; you must specify one but not both.
        """
        if auto_user is not None:
            pulumi.set(__self__, "auto_user", auto_user)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)

    @property
    @pulumi.getter(name="autoUser")
    def auto_user(self) -> Optional['outputs.AutoUserSpecificationResponse']:
        """
        The userName and autoUser properties are mutually exclusive; you must specify one but not both.
        """
        return pulumi.get(self, "auto_user")

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[str]:
        """
        The userName and autoUser properties are mutually exclusive; you must specify one but not both.
        """
        return pulumi.get(self, "user_name")


@pulumi.output_type
class VirtualMachineConfigurationResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "imageReference":
            suggest = "image_reference"
        elif key == "nodeAgentSkuId":
            suggest = "node_agent_sku_id"
        elif key == "containerConfiguration":
            suggest = "container_configuration"
        elif key == "dataDisks":
            suggest = "data_disks"
        elif key == "licenseType":
            suggest = "license_type"
        elif key == "windowsConfiguration":
            suggest = "windows_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 image_reference: 'outputs.ImageReferenceResponse',
                 node_agent_sku_id: str,
                 container_configuration: Optional['outputs.ContainerConfigurationResponse'] = None,
                 data_disks: Optional[Sequence['outputs.DataDiskResponse']] = None,
                 license_type: Optional[str] = None,
                 windows_configuration: Optional['outputs.WindowsConfigurationResponse'] = None):
        """
        :param str node_agent_sku_id: The Batch node agent is a program that runs on each node in the pool, and provides the command-and-control interface between the node and the Batch service. There are different implementations of the node agent, known as SKUs, for different operating systems. You must specify a node agent SKU which matches the selected image reference. To get the list of supported node agent SKUs along with their list of verified image references, see the 'List supported node agent SKUs' operation.
        :param 'ContainerConfigurationResponse' container_configuration: If specified, setup is performed on each node in the pool to allow tasks to run in containers. All regular tasks and job manager tasks run on this pool must specify the containerSettings property, and all other tasks may specify it.
        :param Sequence['DataDiskResponse'] data_disks: This property must be specified if the compute nodes in the pool need to have empty data disks attached to them.
        :param str license_type: This only applies to images that contain the Windows operating system, and should only be used when you hold valid on-premises licenses for the nodes which will be deployed. If omitted, no on-premises licensing discount is applied. Values are:
               
                Windows_Server - The on-premises license is for Windows Server.
                Windows_Client - The on-premises license is for Windows Client.
        :param 'WindowsConfigurationResponse' windows_configuration: This property must not be specified if the imageReference specifies a Linux OS image.
        """
        pulumi.set(__self__, "image_reference", image_reference)
        pulumi.set(__self__, "node_agent_sku_id", node_agent_sku_id)
        if container_configuration is not None:
            pulumi.set(__self__, "container_configuration", container_configuration)
        if data_disks is not None:
            pulumi.set(__self__, "data_disks", data_disks)
        if license_type is not None:
            pulumi.set(__self__, "license_type", license_type)
        if windows_configuration is not None:
            pulumi.set(__self__, "windows_configuration", windows_configuration)

    @property
    @pulumi.getter(name="imageReference")
    def image_reference(self) -> 'outputs.ImageReferenceResponse':
        return pulumi.get(self, "image_reference")

    @property
    @pulumi.getter(name="nodeAgentSkuId")
    def node_agent_sku_id(self) -> str:
        """
        The Batch node agent is a program that runs on each node in the pool, and provides the command-and-control interface between the node and the Batch service. There are different implementations of the node agent, known as SKUs, for different operating systems. You must specify a node agent SKU which matches the selected image reference. To get the list of supported node agent SKUs along with their list of verified image references, see the 'List supported node agent SKUs' operation.
        """
        return pulumi.get(self, "node_agent_sku_id")

    @property
    @pulumi.getter(name="containerConfiguration")
    def container_configuration(self) -> Optional['outputs.ContainerConfigurationResponse']:
        """
        If specified, setup is performed on each node in the pool to allow tasks to run in containers. All regular tasks and job manager tasks run on this pool must specify the containerSettings property, and all other tasks may specify it.
        """
        return pulumi.get(self, "container_configuration")

    @property
    @pulumi.getter(name="dataDisks")
    def data_disks(self) -> Optional[Sequence['outputs.DataDiskResponse']]:
        """
        This property must be specified if the compute nodes in the pool need to have empty data disks attached to them.
        """
        return pulumi.get(self, "data_disks")

    @property
    @pulumi.getter(name="licenseType")
    def license_type(self) -> Optional[str]:
        """
        This only applies to images that contain the Windows operating system, and should only be used when you hold valid on-premises licenses for the nodes which will be deployed. If omitted, no on-premises licensing discount is applied. Values are:

         Windows_Server - The on-premises license is for Windows Server.
         Windows_Client - The on-premises license is for Windows Client.
        """
        return pulumi.get(self, "license_type")

    @property
    @pulumi.getter(name="windowsConfiguration")
    def windows_configuration(self) -> Optional['outputs.WindowsConfigurationResponse']:
        """
        This property must not be specified if the imageReference specifies a Linux OS image.
        """
        return pulumi.get(self, "windows_configuration")


@pulumi.output_type
class VirtualMachineFamilyCoreQuotaResponse(dict):
    """
    A VM Family and its associated core quota for the Batch account.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "coreQuota":
            suggest = "core_quota"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineFamilyCoreQuotaResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineFamilyCoreQuotaResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineFamilyCoreQuotaResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 core_quota: int,
                 name: str):
        """
        A VM Family and its associated core quota for the Batch account.
        :param int core_quota: The core quota for the VM family for the Batch account.
        :param str name: The Virtual Machine family name.
        """
        pulumi.set(__self__, "core_quota", core_quota)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="coreQuota")
    def core_quota(self) -> int:
        """
        The core quota for the VM family for the Batch account.
        """
        return pulumi.get(self, "core_quota")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The Virtual Machine family name.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class WindowsConfigurationResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enableAutomaticUpdates":
            suggest = "enable_automatic_updates"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WindowsConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WindowsConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WindowsConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable_automatic_updates: Optional[bool] = None):
        """
        :param bool enable_automatic_updates: If omitted, the default value is true.
        """
        if enable_automatic_updates is not None:
            pulumi.set(__self__, "enable_automatic_updates", enable_automatic_updates)

    @property
    @pulumi.getter(name="enableAutomaticUpdates")
    def enable_automatic_updates(self) -> Optional[bool]:
        """
        If omitted, the default value is true.
        """
        return pulumi.get(self, "enable_automatic_updates")


@pulumi.output_type
class WindowsUserConfigurationResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "loginMode":
            suggest = "login_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WindowsUserConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WindowsUserConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WindowsUserConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 login_mode: Optional[str] = None):
        """
        :param str login_mode: Specifies login mode for the user. The default value for VirtualMachineConfiguration pools is interactive mode and for CloudServiceConfiguration pools is batch mode.
        """
        if login_mode is not None:
            pulumi.set(__self__, "login_mode", login_mode)

    @property
    @pulumi.getter(name="loginMode")
    def login_mode(self) -> Optional[str]:
        """
        Specifies login mode for the user. The default value for VirtualMachineConfiguration pools is interactive mode and for CloudServiceConfiguration pools is batch mode.
        """
        return pulumi.get(self, "login_mode")


