# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'A2ACrossClusterMigrationReplicationDetailsResponse',
    'A2APolicyDetailsResponse',
    'A2AProtectedDiskDetailsResponse',
    'A2AProtectedManagedDiskDetailsResponse',
    'A2AProtectionContainerMappingDetailsResponse',
    'A2AReplicationDetailsResponse',
    'A2AUnprotectedDiskDetailsResponse',
    'A2AZoneDetailsResponse',
    'AgentDetailsResponse',
    'AgentDiskDetailsResponse',
    'AzureFabricSpecificDetailsResponse',
    'AzureMonitorAlertSettingsResponse',
    'AzureToAzureNetworkMappingSettingsResponse',
    'AzureToAzureVmSyncedConfigDetailsResponse',
    'AzureVmDiskDetailsResponse',
    'ClassicAlertSettingsResponse',
    'CmkKekIdentityResponse',
    'CmkKeyVaultPropertiesResponse',
    'CurrentJobDetailsResponse',
    'CurrentScenarioDetailsResponse',
    'DataStoreResponse',
    'DiskDetailsResponse',
    'DraDetailsResponse',
    'EncryptionDetailsResponse',
    'ExtendedLocationResponse',
    'FabricPropertiesResponse',
    'HealthErrorResponse',
    'HyperVHostDetailsResponse',
    'HyperVReplicaAzureManagedDiskDetailsResponse',
    'HyperVReplicaAzurePolicyDetailsResponse',
    'HyperVReplicaAzureReplicationDetailsResponse',
    'HyperVReplicaBasePolicyDetailsResponse',
    'HyperVReplicaBaseReplicationDetailsResponse',
    'HyperVReplicaBluePolicyDetailsResponse',
    'HyperVReplicaBlueReplicationDetailsResponse',
    'HyperVReplicaPolicyDetailsResponse',
    'HyperVReplicaReplicationDetailsResponse',
    'HyperVSiteDetailsResponse',
    'IPConfigDetailsResponse',
    'IdentityDataResponse',
    'IdentityProviderDetailsResponse',
    'InMageAgentDetailsResponse',
    'InMageAzureV2ManagedDiskDetailsResponse',
    'InMageAzureV2PolicyDetailsResponse',
    'InMageAzureV2ProtectedDiskDetailsResponse',
    'InMageAzureV2ReplicationDetailsResponse',
    'InMageAzureV2SwitchProviderBlockingErrorDetailsResponse',
    'InMageAzureV2SwitchProviderDetailsResponse',
    'InMageBasePolicyDetailsResponse',
    'InMageFabricSwitchProviderBlockingErrorDetailsResponse',
    'InMagePolicyDetailsResponse',
    'InMageProtectedDiskDetailsResponse',
    'InMageRcmAgentUpgradeBlockingErrorDetailsResponse',
    'InMageRcmDiscoveredProtectedVmDetailsResponse',
    'InMageRcmFabricSpecificDetailsResponse',
    'InMageRcmFailbackDiscoveredProtectedVmDetailsResponse',
    'InMageRcmFailbackMobilityAgentDetailsResponse',
    'InMageRcmFailbackNicDetailsResponse',
    'InMageRcmFailbackPolicyDetailsResponse',
    'InMageRcmFailbackProtectedDiskDetailsResponse',
    'InMageRcmFailbackReplicationDetailsResponse',
    'InMageRcmFailbackSyncDetailsResponse',
    'InMageRcmLastAgentUpgradeErrorDetailsResponse',
    'InMageRcmMobilityAgentDetailsResponse',
    'InMageRcmNicDetailsResponse',
    'InMageRcmPolicyDetailsResponse',
    'InMageRcmProtectedDiskDetailsResponse',
    'InMageRcmProtectionContainerMappingDetailsResponse',
    'InMageRcmReplicationDetailsResponse',
    'InMageRcmSyncDetailsResponse',
    'InMageReplicationDetailsResponse',
    'InitialReplicationDetailsResponse',
    'InnerHealthErrorResponse',
    'InputEndpointResponse',
    'MarsAgentDetailsResponse',
    'MasterTargetServerResponse',
    'MigrationItemPropertiesResponse',
    'MobilityServiceUpdateResponse',
    'MonitoringSettingsResponse',
    'NetworkMappingPropertiesResponse',
    'OSDetailsResponse',
    'OSDiskDetailsResponse',
    'PolicyPropertiesResponse',
    'PrivateEndpointConnectionVaultPropertiesResponse',
    'PrivateEndpointResponse',
    'ProcessServerDetailsResponse',
    'ProcessServerResponse',
    'ProtectionContainerMappingPropertiesResponse',
    'PushInstallerDetailsResponse',
    'RcmProxyDetailsResponse',
    'RecoveryPlanA2ADetailsResponse',
    'RecoveryPlanActionResponse',
    'RecoveryPlanAutomationRunbookActionDetailsResponse',
    'RecoveryPlanGroupResponse',
    'RecoveryPlanManualActionDetailsResponse',
    'RecoveryPlanPropertiesResponse',
    'RecoveryPlanProtectedItemResponse',
    'RecoveryPlanScriptActionDetailsResponse',
    'RecoveryServicesProviderPropertiesResponse',
    'ReplicationAgentDetailsResponse',
    'ReplicationProtectedItemPropertiesResponse',
    'ReprotectAgentDetailsResponse',
    'RetentionVolumeResponse',
    'RunAsAccountResponse',
    'SkuResponse',
    'StorageClassificationMappingPropertiesResponse',
    'SystemDataResponse',
    'UpgradeDetailsResponse',
    'UserIdentityResponse',
    'VCenterPropertiesResponse',
    'VMNicDetailsResponse',
    'VMwareCbtMigrationDetailsResponse',
    'VMwareCbtNicDetailsResponse',
    'VMwareCbtProtectedDiskDetailsResponse',
    'VMwareCbtProtectionContainerMappingDetailsResponse',
    'VMwareDetailsResponse',
    'VMwareV2FabricSpecificDetailsResponse',
    'VaultPrivateEndpointConnectionResponse',
    'VaultPrivateLinkServiceConnectionStateResponse',
    'VaultPropertiesResponse',
    'VaultPropertiesResponseEncryption',
    'VaultPropertiesResponseMoveDetails',
    'VaultPropertiesResponseRedundancySettings',
    'VersionDetailsResponse',
    'VmmDetailsResponse',
    'VmmToAzureNetworkMappingSettingsResponse',
    'VmmToVmmNetworkMappingSettingsResponse',
    'VmwareCbtPolicyDetailsResponse',
]

@pulumi.output_type
class A2ACrossClusterMigrationReplicationDetailsResponse(dict):
    """
    A2A provider specific settings.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceType":
            suggest = "instance_type"
        elif key == "fabricObjectId":
            suggest = "fabric_object_id"
        elif key == "lifecycleId":
            suggest = "lifecycle_id"
        elif key == "osType":
            suggest = "os_type"
        elif key == "primaryFabricLocation":
            suggest = "primary_fabric_location"
        elif key == "vmProtectionState":
            suggest = "vm_protection_state"
        elif key == "vmProtectionStateDescription":
            suggest = "vm_protection_state_description"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in A2ACrossClusterMigrationReplicationDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        A2ACrossClusterMigrationReplicationDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        A2ACrossClusterMigrationReplicationDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_type: str,
                 fabric_object_id: Optional[str] = None,
                 lifecycle_id: Optional[str] = None,
                 os_type: Optional[str] = None,
                 primary_fabric_location: Optional[str] = None,
                 vm_protection_state: Optional[str] = None,
                 vm_protection_state_description: Optional[str] = None):
        """
        A2A provider specific settings.
        :param str instance_type: Gets the Instance type.
               Expected value is 'A2ACrossClusterMigration'.
        :param str fabric_object_id: The fabric specific object Id of the virtual machine.
        :param str lifecycle_id: An id associated with the PE that survives actions like switch protection which change the backing PE/CPE objects internally.The lifecycle id gets carried forward to have a link/continuity in being able to have an Id that denotes the "same" protected item even though other internal Ids/ARM Id might be changing.
        :param str os_type: The type of operating system.
        :param str primary_fabric_location: Primary fabric location.
        :param str vm_protection_state: The protection state for the vm.
        :param str vm_protection_state_description: The protection state description for the vm.
        """
        pulumi.set(__self__, "instance_type", 'A2ACrossClusterMigration')
        if fabric_object_id is not None:
            pulumi.set(__self__, "fabric_object_id", fabric_object_id)
        if lifecycle_id is not None:
            pulumi.set(__self__, "lifecycle_id", lifecycle_id)
        if os_type is not None:
            pulumi.set(__self__, "os_type", os_type)
        if primary_fabric_location is not None:
            pulumi.set(__self__, "primary_fabric_location", primary_fabric_location)
        if vm_protection_state is not None:
            pulumi.set(__self__, "vm_protection_state", vm_protection_state)
        if vm_protection_state_description is not None:
            pulumi.set(__self__, "vm_protection_state_description", vm_protection_state_description)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> str:
        """
        Gets the Instance type.
        Expected value is 'A2ACrossClusterMigration'.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="fabricObjectId")
    def fabric_object_id(self) -> Optional[str]:
        """
        The fabric specific object Id of the virtual machine.
        """
        return pulumi.get(self, "fabric_object_id")

    @property
    @pulumi.getter(name="lifecycleId")
    def lifecycle_id(self) -> Optional[str]:
        """
        An id associated with the PE that survives actions like switch protection which change the backing PE/CPE objects internally.The lifecycle id gets carried forward to have a link/continuity in being able to have an Id that denotes the "same" protected item even though other internal Ids/ARM Id might be changing.
        """
        return pulumi.get(self, "lifecycle_id")

    @property
    @pulumi.getter(name="osType")
    def os_type(self) -> Optional[str]:
        """
        The type of operating system.
        """
        return pulumi.get(self, "os_type")

    @property
    @pulumi.getter(name="primaryFabricLocation")
    def primary_fabric_location(self) -> Optional[str]:
        """
        Primary fabric location.
        """
        return pulumi.get(self, "primary_fabric_location")

    @property
    @pulumi.getter(name="vmProtectionState")
    def vm_protection_state(self) -> Optional[str]:
        """
        The protection state for the vm.
        """
        return pulumi.get(self, "vm_protection_state")

    @property
    @pulumi.getter(name="vmProtectionStateDescription")
    def vm_protection_state_description(self) -> Optional[str]:
        """
        The protection state description for the vm.
        """
        return pulumi.get(self, "vm_protection_state_description")


@pulumi.output_type
class A2APolicyDetailsResponse(dict):
    """
    A2A specific policy details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceType":
            suggest = "instance_type"
        elif key == "appConsistentFrequencyInMinutes":
            suggest = "app_consistent_frequency_in_minutes"
        elif key == "crashConsistentFrequencyInMinutes":
            suggest = "crash_consistent_frequency_in_minutes"
        elif key == "multiVmSyncStatus":
            suggest = "multi_vm_sync_status"
        elif key == "recoveryPointHistory":
            suggest = "recovery_point_history"
        elif key == "recoveryPointThresholdInMinutes":
            suggest = "recovery_point_threshold_in_minutes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in A2APolicyDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        A2APolicyDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        A2APolicyDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_type: str,
                 app_consistent_frequency_in_minutes: Optional[int] = None,
                 crash_consistent_frequency_in_minutes: Optional[int] = None,
                 multi_vm_sync_status: Optional[str] = None,
                 recovery_point_history: Optional[int] = None,
                 recovery_point_threshold_in_minutes: Optional[int] = None):
        """
        A2A specific policy details.
        :param str instance_type: Gets the class type. Overridden in derived classes.
               Expected value is 'A2A'.
        :param int app_consistent_frequency_in_minutes: The app consistent snapshot frequency in minutes.
        :param int crash_consistent_frequency_in_minutes: The crash consistent snapshot frequency in minutes.
        :param str multi_vm_sync_status: A value indicating whether multi-VM sync has to be enabled.
        :param int recovery_point_history: The duration in minutes until which the recovery points need to be stored.
        :param int recovery_point_threshold_in_minutes: The recovery point threshold in minutes.
        """
        pulumi.set(__self__, "instance_type", 'A2A')
        if app_consistent_frequency_in_minutes is not None:
            pulumi.set(__self__, "app_consistent_frequency_in_minutes", app_consistent_frequency_in_minutes)
        if crash_consistent_frequency_in_minutes is not None:
            pulumi.set(__self__, "crash_consistent_frequency_in_minutes", crash_consistent_frequency_in_minutes)
        if multi_vm_sync_status is not None:
            pulumi.set(__self__, "multi_vm_sync_status", multi_vm_sync_status)
        if recovery_point_history is not None:
            pulumi.set(__self__, "recovery_point_history", recovery_point_history)
        if recovery_point_threshold_in_minutes is not None:
            pulumi.set(__self__, "recovery_point_threshold_in_minutes", recovery_point_threshold_in_minutes)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> str:
        """
        Gets the class type. Overridden in derived classes.
        Expected value is 'A2A'.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="appConsistentFrequencyInMinutes")
    def app_consistent_frequency_in_minutes(self) -> Optional[int]:
        """
        The app consistent snapshot frequency in minutes.
        """
        return pulumi.get(self, "app_consistent_frequency_in_minutes")

    @property
    @pulumi.getter(name="crashConsistentFrequencyInMinutes")
    def crash_consistent_frequency_in_minutes(self) -> Optional[int]:
        """
        The crash consistent snapshot frequency in minutes.
        """
        return pulumi.get(self, "crash_consistent_frequency_in_minutes")

    @property
    @pulumi.getter(name="multiVmSyncStatus")
    def multi_vm_sync_status(self) -> Optional[str]:
        """
        A value indicating whether multi-VM sync has to be enabled.
        """
        return pulumi.get(self, "multi_vm_sync_status")

    @property
    @pulumi.getter(name="recoveryPointHistory")
    def recovery_point_history(self) -> Optional[int]:
        """
        The duration in minutes until which the recovery points need to be stored.
        """
        return pulumi.get(self, "recovery_point_history")

    @property
    @pulumi.getter(name="recoveryPointThresholdInMinutes")
    def recovery_point_threshold_in_minutes(self) -> Optional[int]:
        """
        The recovery point threshold in minutes.
        """
        return pulumi.get(self, "recovery_point_threshold_in_minutes")


@pulumi.output_type
class A2AProtectedDiskDetailsResponse(dict):
    """
    A2A protected disk details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedDiskLevelOperation":
            suggest = "allowed_disk_level_operation"
        elif key == "dataPendingAtSourceAgentInMB":
            suggest = "data_pending_at_source_agent_in_mb"
        elif key == "dataPendingInStagingStorageAccountInMB":
            suggest = "data_pending_in_staging_storage_account_in_mb"
        elif key == "dekKeyVaultArmId":
            suggest = "dek_key_vault_arm_id"
        elif key == "diskCapacityInBytes":
            suggest = "disk_capacity_in_bytes"
        elif key == "diskName":
            suggest = "disk_name"
        elif key == "diskState":
            suggest = "disk_state"
        elif key == "diskType":
            suggest = "disk_type"
        elif key == "diskUri":
            suggest = "disk_uri"
        elif key == "failoverDiskName":
            suggest = "failover_disk_name"
        elif key == "isDiskEncrypted":
            suggest = "is_disk_encrypted"
        elif key == "isDiskKeyEncrypted":
            suggest = "is_disk_key_encrypted"
        elif key == "kekKeyVaultArmId":
            suggest = "kek_key_vault_arm_id"
        elif key == "keyIdentifier":
            suggest = "key_identifier"
        elif key == "monitoringJobType":
            suggest = "monitoring_job_type"
        elif key == "monitoringPercentageCompletion":
            suggest = "monitoring_percentage_completion"
        elif key == "primaryDiskAzureStorageAccountId":
            suggest = "primary_disk_azure_storage_account_id"
        elif key == "primaryStagingAzureStorageAccountId":
            suggest = "primary_staging_azure_storage_account_id"
        elif key == "recoveryAzureStorageAccountId":
            suggest = "recovery_azure_storage_account_id"
        elif key == "recoveryDiskUri":
            suggest = "recovery_disk_uri"
        elif key == "resyncRequired":
            suggest = "resync_required"
        elif key == "secretIdentifier":
            suggest = "secret_identifier"
        elif key == "tfoDiskName":
            suggest = "tfo_disk_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in A2AProtectedDiskDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        A2AProtectedDiskDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        A2AProtectedDiskDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_disk_level_operation: Optional[Sequence[str]] = None,
                 data_pending_at_source_agent_in_mb: Optional[float] = None,
                 data_pending_in_staging_storage_account_in_mb: Optional[float] = None,
                 dek_key_vault_arm_id: Optional[str] = None,
                 disk_capacity_in_bytes: Optional[float] = None,
                 disk_name: Optional[str] = None,
                 disk_state: Optional[str] = None,
                 disk_type: Optional[str] = None,
                 disk_uri: Optional[str] = None,
                 failover_disk_name: Optional[str] = None,
                 is_disk_encrypted: Optional[bool] = None,
                 is_disk_key_encrypted: Optional[bool] = None,
                 kek_key_vault_arm_id: Optional[str] = None,
                 key_identifier: Optional[str] = None,
                 monitoring_job_type: Optional[str] = None,
                 monitoring_percentage_completion: Optional[int] = None,
                 primary_disk_azure_storage_account_id: Optional[str] = None,
                 primary_staging_azure_storage_account_id: Optional[str] = None,
                 recovery_azure_storage_account_id: Optional[str] = None,
                 recovery_disk_uri: Optional[str] = None,
                 resync_required: Optional[bool] = None,
                 secret_identifier: Optional[str] = None,
                 tfo_disk_name: Optional[str] = None):
        """
        A2A protected disk details.
        :param Sequence[str] allowed_disk_level_operation: The disk level operations list.
        :param float data_pending_at_source_agent_in_mb: The data pending at source virtual machine in MB.
        :param float data_pending_in_staging_storage_account_in_mb: The data pending for replication in MB at staging account.
        :param str dek_key_vault_arm_id: The KeyVault resource id for secret (BEK).
        :param float disk_capacity_in_bytes: The disk capacity in bytes.
        :param str disk_name: The disk name.
        :param str disk_state: The disk state.
        :param str disk_type: The type of disk.
        :param str disk_uri: The disk uri.
        :param str failover_disk_name: The failover name for the managed disk.
        :param bool is_disk_encrypted: A value indicating whether vm has encrypted os disk or not.
        :param bool is_disk_key_encrypted: A value indicating whether disk key got encrypted or not.
        :param str kek_key_vault_arm_id: The KeyVault resource id for key (KEK).
        :param str key_identifier: The key URL / identifier (KEK).
        :param str monitoring_job_type: The type of the monitoring job. The progress is contained in MonitoringPercentageCompletion property.
        :param int monitoring_percentage_completion: The percentage of the monitoring job. The type of the monitoring job is defined by MonitoringJobType property.
        :param str primary_disk_azure_storage_account_id: The primary disk storage account.
        :param str primary_staging_azure_storage_account_id: The primary staging storage account.
        :param str recovery_azure_storage_account_id: The recovery disk storage account.
        :param str recovery_disk_uri: Recovery disk uri.
        :param bool resync_required: A value indicating whether resync is required for this disk.
        :param str secret_identifier: The secret URL / identifier (BEK).
        :param str tfo_disk_name: The test failover name for the managed disk.
        """
        if allowed_disk_level_operation is not None:
            pulumi.set(__self__, "allowed_disk_level_operation", allowed_disk_level_operation)
        if data_pending_at_source_agent_in_mb is not None:
            pulumi.set(__self__, "data_pending_at_source_agent_in_mb", data_pending_at_source_agent_in_mb)
        if data_pending_in_staging_storage_account_in_mb is not None:
            pulumi.set(__self__, "data_pending_in_staging_storage_account_in_mb", data_pending_in_staging_storage_account_in_mb)
        if dek_key_vault_arm_id is not None:
            pulumi.set(__self__, "dek_key_vault_arm_id", dek_key_vault_arm_id)
        if disk_capacity_in_bytes is not None:
            pulumi.set(__self__, "disk_capacity_in_bytes", disk_capacity_in_bytes)
        if disk_name is not None:
            pulumi.set(__self__, "disk_name", disk_name)
        if disk_state is not None:
            pulumi.set(__self__, "disk_state", disk_state)
        if disk_type is not None:
            pulumi.set(__self__, "disk_type", disk_type)
        if disk_uri is not None:
            pulumi.set(__self__, "disk_uri", disk_uri)
        if failover_disk_name is not None:
            pulumi.set(__self__, "failover_disk_name", failover_disk_name)
        if is_disk_encrypted is not None:
            pulumi.set(__self__, "is_disk_encrypted", is_disk_encrypted)
        if is_disk_key_encrypted is not None:
            pulumi.set(__self__, "is_disk_key_encrypted", is_disk_key_encrypted)
        if kek_key_vault_arm_id is not None:
            pulumi.set(__self__, "kek_key_vault_arm_id", kek_key_vault_arm_id)
        if key_identifier is not None:
            pulumi.set(__self__, "key_identifier", key_identifier)
        if monitoring_job_type is not None:
            pulumi.set(__self__, "monitoring_job_type", monitoring_job_type)
        if monitoring_percentage_completion is not None:
            pulumi.set(__self__, "monitoring_percentage_completion", monitoring_percentage_completion)
        if primary_disk_azure_storage_account_id is not None:
            pulumi.set(__self__, "primary_disk_azure_storage_account_id", primary_disk_azure_storage_account_id)
        if primary_staging_azure_storage_account_id is not None:
            pulumi.set(__self__, "primary_staging_azure_storage_account_id", primary_staging_azure_storage_account_id)
        if recovery_azure_storage_account_id is not None:
            pulumi.set(__self__, "recovery_azure_storage_account_id", recovery_azure_storage_account_id)
        if recovery_disk_uri is not None:
            pulumi.set(__self__, "recovery_disk_uri", recovery_disk_uri)
        if resync_required is not None:
            pulumi.set(__self__, "resync_required", resync_required)
        if secret_identifier is not None:
            pulumi.set(__self__, "secret_identifier", secret_identifier)
        if tfo_disk_name is not None:
            pulumi.set(__self__, "tfo_disk_name", tfo_disk_name)

    @property
    @pulumi.getter(name="allowedDiskLevelOperation")
    def allowed_disk_level_operation(self) -> Optional[Sequence[str]]:
        """
        The disk level operations list.
        """
        return pulumi.get(self, "allowed_disk_level_operation")

    @property
    @pulumi.getter(name="dataPendingAtSourceAgentInMB")
    def data_pending_at_source_agent_in_mb(self) -> Optional[float]:
        """
        The data pending at source virtual machine in MB.
        """
        return pulumi.get(self, "data_pending_at_source_agent_in_mb")

    @property
    @pulumi.getter(name="dataPendingInStagingStorageAccountInMB")
    def data_pending_in_staging_storage_account_in_mb(self) -> Optional[float]:
        """
        The data pending for replication in MB at staging account.
        """
        return pulumi.get(self, "data_pending_in_staging_storage_account_in_mb")

    @property
    @pulumi.getter(name="dekKeyVaultArmId")
    def dek_key_vault_arm_id(self) -> Optional[str]:
        """
        The KeyVault resource id for secret (BEK).
        """
        return pulumi.get(self, "dek_key_vault_arm_id")

    @property
    @pulumi.getter(name="diskCapacityInBytes")
    def disk_capacity_in_bytes(self) -> Optional[float]:
        """
        The disk capacity in bytes.
        """
        return pulumi.get(self, "disk_capacity_in_bytes")

    @property
    @pulumi.getter(name="diskName")
    def disk_name(self) -> Optional[str]:
        """
        The disk name.
        """
        return pulumi.get(self, "disk_name")

    @property
    @pulumi.getter(name="diskState")
    def disk_state(self) -> Optional[str]:
        """
        The disk state.
        """
        return pulumi.get(self, "disk_state")

    @property
    @pulumi.getter(name="diskType")
    def disk_type(self) -> Optional[str]:
        """
        The type of disk.
        """
        return pulumi.get(self, "disk_type")

    @property
    @pulumi.getter(name="diskUri")
    def disk_uri(self) -> Optional[str]:
        """
        The disk uri.
        """
        return pulumi.get(self, "disk_uri")

    @property
    @pulumi.getter(name="failoverDiskName")
    def failover_disk_name(self) -> Optional[str]:
        """
        The failover name for the managed disk.
        """
        return pulumi.get(self, "failover_disk_name")

    @property
    @pulumi.getter(name="isDiskEncrypted")
    def is_disk_encrypted(self) -> Optional[bool]:
        """
        A value indicating whether vm has encrypted os disk or not.
        """
        return pulumi.get(self, "is_disk_encrypted")

    @property
    @pulumi.getter(name="isDiskKeyEncrypted")
    def is_disk_key_encrypted(self) -> Optional[bool]:
        """
        A value indicating whether disk key got encrypted or not.
        """
        return pulumi.get(self, "is_disk_key_encrypted")

    @property
    @pulumi.getter(name="kekKeyVaultArmId")
    def kek_key_vault_arm_id(self) -> Optional[str]:
        """
        The KeyVault resource id for key (KEK).
        """
        return pulumi.get(self, "kek_key_vault_arm_id")

    @property
    @pulumi.getter(name="keyIdentifier")
    def key_identifier(self) -> Optional[str]:
        """
        The key URL / identifier (KEK).
        """
        return pulumi.get(self, "key_identifier")

    @property
    @pulumi.getter(name="monitoringJobType")
    def monitoring_job_type(self) -> Optional[str]:
        """
        The type of the monitoring job. The progress is contained in MonitoringPercentageCompletion property.
        """
        return pulumi.get(self, "monitoring_job_type")

    @property
    @pulumi.getter(name="monitoringPercentageCompletion")
    def monitoring_percentage_completion(self) -> Optional[int]:
        """
        The percentage of the monitoring job. The type of the monitoring job is defined by MonitoringJobType property.
        """
        return pulumi.get(self, "monitoring_percentage_completion")

    @property
    @pulumi.getter(name="primaryDiskAzureStorageAccountId")
    def primary_disk_azure_storage_account_id(self) -> Optional[str]:
        """
        The primary disk storage account.
        """
        return pulumi.get(self, "primary_disk_azure_storage_account_id")

    @property
    @pulumi.getter(name="primaryStagingAzureStorageAccountId")
    def primary_staging_azure_storage_account_id(self) -> Optional[str]:
        """
        The primary staging storage account.
        """
        return pulumi.get(self, "primary_staging_azure_storage_account_id")

    @property
    @pulumi.getter(name="recoveryAzureStorageAccountId")
    def recovery_azure_storage_account_id(self) -> Optional[str]:
        """
        The recovery disk storage account.
        """
        return pulumi.get(self, "recovery_azure_storage_account_id")

    @property
    @pulumi.getter(name="recoveryDiskUri")
    def recovery_disk_uri(self) -> Optional[str]:
        """
        Recovery disk uri.
        """
        return pulumi.get(self, "recovery_disk_uri")

    @property
    @pulumi.getter(name="resyncRequired")
    def resync_required(self) -> Optional[bool]:
        """
        A value indicating whether resync is required for this disk.
        """
        return pulumi.get(self, "resync_required")

    @property
    @pulumi.getter(name="secretIdentifier")
    def secret_identifier(self) -> Optional[str]:
        """
        The secret URL / identifier (BEK).
        """
        return pulumi.get(self, "secret_identifier")

    @property
    @pulumi.getter(name="tfoDiskName")
    def tfo_disk_name(self) -> Optional[str]:
        """
        The test failover name for the managed disk.
        """
        return pulumi.get(self, "tfo_disk_name")


@pulumi.output_type
class A2AProtectedManagedDiskDetailsResponse(dict):
    """
    A2A protected managed disk details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedDiskLevelOperation":
            suggest = "allowed_disk_level_operation"
        elif key == "dataPendingAtSourceAgentInMB":
            suggest = "data_pending_at_source_agent_in_mb"
        elif key == "dataPendingInStagingStorageAccountInMB":
            suggest = "data_pending_in_staging_storage_account_in_mb"
        elif key == "dekKeyVaultArmId":
            suggest = "dek_key_vault_arm_id"
        elif key == "diskCapacityInBytes":
            suggest = "disk_capacity_in_bytes"
        elif key == "diskId":
            suggest = "disk_id"
        elif key == "diskName":
            suggest = "disk_name"
        elif key == "diskState":
            suggest = "disk_state"
        elif key == "diskType":
            suggest = "disk_type"
        elif key == "failoverDiskName":
            suggest = "failover_disk_name"
        elif key == "isDiskEncrypted":
            suggest = "is_disk_encrypted"
        elif key == "isDiskKeyEncrypted":
            suggest = "is_disk_key_encrypted"
        elif key == "kekKeyVaultArmId":
            suggest = "kek_key_vault_arm_id"
        elif key == "keyIdentifier":
            suggest = "key_identifier"
        elif key == "monitoringJobType":
            suggest = "monitoring_job_type"
        elif key == "monitoringPercentageCompletion":
            suggest = "monitoring_percentage_completion"
        elif key == "primaryDiskEncryptionSetId":
            suggest = "primary_disk_encryption_set_id"
        elif key == "primaryStagingAzureStorageAccountId":
            suggest = "primary_staging_azure_storage_account_id"
        elif key == "recoveryDiskEncryptionSetId":
            suggest = "recovery_disk_encryption_set_id"
        elif key == "recoveryOrignalTargetDiskId":
            suggest = "recovery_orignal_target_disk_id"
        elif key == "recoveryReplicaDiskAccountType":
            suggest = "recovery_replica_disk_account_type"
        elif key == "recoveryReplicaDiskId":
            suggest = "recovery_replica_disk_id"
        elif key == "recoveryResourceGroupId":
            suggest = "recovery_resource_group_id"
        elif key == "recoveryTargetDiskAccountType":
            suggest = "recovery_target_disk_account_type"
        elif key == "recoveryTargetDiskId":
            suggest = "recovery_target_disk_id"
        elif key == "resyncRequired":
            suggest = "resync_required"
        elif key == "secretIdentifier":
            suggest = "secret_identifier"
        elif key == "tfoDiskName":
            suggest = "tfo_disk_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in A2AProtectedManagedDiskDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        A2AProtectedManagedDiskDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        A2AProtectedManagedDiskDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_disk_level_operation: Optional[Sequence[str]] = None,
                 data_pending_at_source_agent_in_mb: Optional[float] = None,
                 data_pending_in_staging_storage_account_in_mb: Optional[float] = None,
                 dek_key_vault_arm_id: Optional[str] = None,
                 disk_capacity_in_bytes: Optional[float] = None,
                 disk_id: Optional[str] = None,
                 disk_name: Optional[str] = None,
                 disk_state: Optional[str] = None,
                 disk_type: Optional[str] = None,
                 failover_disk_name: Optional[str] = None,
                 is_disk_encrypted: Optional[bool] = None,
                 is_disk_key_encrypted: Optional[bool] = None,
                 kek_key_vault_arm_id: Optional[str] = None,
                 key_identifier: Optional[str] = None,
                 monitoring_job_type: Optional[str] = None,
                 monitoring_percentage_completion: Optional[int] = None,
                 primary_disk_encryption_set_id: Optional[str] = None,
                 primary_staging_azure_storage_account_id: Optional[str] = None,
                 recovery_disk_encryption_set_id: Optional[str] = None,
                 recovery_orignal_target_disk_id: Optional[str] = None,
                 recovery_replica_disk_account_type: Optional[str] = None,
                 recovery_replica_disk_id: Optional[str] = None,
                 recovery_resource_group_id: Optional[str] = None,
                 recovery_target_disk_account_type: Optional[str] = None,
                 recovery_target_disk_id: Optional[str] = None,
                 resync_required: Optional[bool] = None,
                 secret_identifier: Optional[str] = None,
                 tfo_disk_name: Optional[str] = None):
        """
        A2A protected managed disk details.
        :param Sequence[str] allowed_disk_level_operation: The disk level operations list.
        :param float data_pending_at_source_agent_in_mb: The data pending at source virtual machine in MB.
        :param float data_pending_in_staging_storage_account_in_mb: The data pending for replication in MB at staging account.
        :param str dek_key_vault_arm_id: The KeyVault resource id for secret (BEK).
        :param float disk_capacity_in_bytes: The disk capacity in bytes.
        :param str disk_id: The managed disk Arm id.
        :param str disk_name: The disk name.
        :param str disk_state: The disk state.
        :param str disk_type: The type of disk.
        :param str failover_disk_name: The failover name for the managed disk.
        :param bool is_disk_encrypted: A value indicating whether vm has encrypted os disk or not.
        :param bool is_disk_key_encrypted: A value indicating whether disk key got encrypted or not.
        :param str kek_key_vault_arm_id: The KeyVault resource id for key (KEK).
        :param str key_identifier: The key URL / identifier (KEK).
        :param str monitoring_job_type: The type of the monitoring job. The progress is contained in MonitoringPercentageCompletion property.
        :param int monitoring_percentage_completion: The percentage of the monitoring job. The type of the monitoring job is defined by MonitoringJobType property.
        :param str primary_disk_encryption_set_id: The primary disk encryption set Id.
        :param str primary_staging_azure_storage_account_id: The primary staging storage account.
        :param str recovery_disk_encryption_set_id: The recovery disk encryption set Id.
        :param str recovery_orignal_target_disk_id: Recovery original target disk Arm Id.
        :param str recovery_replica_disk_account_type: The replica disk type. Its an optional value and will be same as source disk type if not user provided.
        :param str recovery_replica_disk_id: Recovery replica disk Arm Id.
        :param str recovery_resource_group_id: The recovery disk resource group Arm Id.
        :param str recovery_target_disk_account_type: The target disk type after failover. Its an optional value and will be same as source disk type if not user provided.
        :param str recovery_target_disk_id: Recovery target disk Arm Id.
        :param bool resync_required: A value indicating whether resync is required for this disk.
        :param str secret_identifier: The secret URL / identifier (BEK).
        :param str tfo_disk_name: The test failover name for the managed disk.
        """
        if allowed_disk_level_operation is not None:
            pulumi.set(__self__, "allowed_disk_level_operation", allowed_disk_level_operation)
        if data_pending_at_source_agent_in_mb is not None:
            pulumi.set(__self__, "data_pending_at_source_agent_in_mb", data_pending_at_source_agent_in_mb)
        if data_pending_in_staging_storage_account_in_mb is not None:
            pulumi.set(__self__, "data_pending_in_staging_storage_account_in_mb", data_pending_in_staging_storage_account_in_mb)
        if dek_key_vault_arm_id is not None:
            pulumi.set(__self__, "dek_key_vault_arm_id", dek_key_vault_arm_id)
        if disk_capacity_in_bytes is not None:
            pulumi.set(__self__, "disk_capacity_in_bytes", disk_capacity_in_bytes)
        if disk_id is not None:
            pulumi.set(__self__, "disk_id", disk_id)
        if disk_name is not None:
            pulumi.set(__self__, "disk_name", disk_name)
        if disk_state is not None:
            pulumi.set(__self__, "disk_state", disk_state)
        if disk_type is not None:
            pulumi.set(__self__, "disk_type", disk_type)
        if failover_disk_name is not None:
            pulumi.set(__self__, "failover_disk_name", failover_disk_name)
        if is_disk_encrypted is not None:
            pulumi.set(__self__, "is_disk_encrypted", is_disk_encrypted)
        if is_disk_key_encrypted is not None:
            pulumi.set(__self__, "is_disk_key_encrypted", is_disk_key_encrypted)
        if kek_key_vault_arm_id is not None:
            pulumi.set(__self__, "kek_key_vault_arm_id", kek_key_vault_arm_id)
        if key_identifier is not None:
            pulumi.set(__self__, "key_identifier", key_identifier)
        if monitoring_job_type is not None:
            pulumi.set(__self__, "monitoring_job_type", monitoring_job_type)
        if monitoring_percentage_completion is not None:
            pulumi.set(__self__, "monitoring_percentage_completion", monitoring_percentage_completion)
        if primary_disk_encryption_set_id is not None:
            pulumi.set(__self__, "primary_disk_encryption_set_id", primary_disk_encryption_set_id)
        if primary_staging_azure_storage_account_id is not None:
            pulumi.set(__self__, "primary_staging_azure_storage_account_id", primary_staging_azure_storage_account_id)
        if recovery_disk_encryption_set_id is not None:
            pulumi.set(__self__, "recovery_disk_encryption_set_id", recovery_disk_encryption_set_id)
        if recovery_orignal_target_disk_id is not None:
            pulumi.set(__self__, "recovery_orignal_target_disk_id", recovery_orignal_target_disk_id)
        if recovery_replica_disk_account_type is not None:
            pulumi.set(__self__, "recovery_replica_disk_account_type", recovery_replica_disk_account_type)
        if recovery_replica_disk_id is not None:
            pulumi.set(__self__, "recovery_replica_disk_id", recovery_replica_disk_id)
        if recovery_resource_group_id is not None:
            pulumi.set(__self__, "recovery_resource_group_id", recovery_resource_group_id)
        if recovery_target_disk_account_type is not None:
            pulumi.set(__self__, "recovery_target_disk_account_type", recovery_target_disk_account_type)
        if recovery_target_disk_id is not None:
            pulumi.set(__self__, "recovery_target_disk_id", recovery_target_disk_id)
        if resync_required is not None:
            pulumi.set(__self__, "resync_required", resync_required)
        if secret_identifier is not None:
            pulumi.set(__self__, "secret_identifier", secret_identifier)
        if tfo_disk_name is not None:
            pulumi.set(__self__, "tfo_disk_name", tfo_disk_name)

    @property
    @pulumi.getter(name="allowedDiskLevelOperation")
    def allowed_disk_level_operation(self) -> Optional[Sequence[str]]:
        """
        The disk level operations list.
        """
        return pulumi.get(self, "allowed_disk_level_operation")

    @property
    @pulumi.getter(name="dataPendingAtSourceAgentInMB")
    def data_pending_at_source_agent_in_mb(self) -> Optional[float]:
        """
        The data pending at source virtual machine in MB.
        """
        return pulumi.get(self, "data_pending_at_source_agent_in_mb")

    @property
    @pulumi.getter(name="dataPendingInStagingStorageAccountInMB")
    def data_pending_in_staging_storage_account_in_mb(self) -> Optional[float]:
        """
        The data pending for replication in MB at staging account.
        """
        return pulumi.get(self, "data_pending_in_staging_storage_account_in_mb")

    @property
    @pulumi.getter(name="dekKeyVaultArmId")
    def dek_key_vault_arm_id(self) -> Optional[str]:
        """
        The KeyVault resource id for secret (BEK).
        """
        return pulumi.get(self, "dek_key_vault_arm_id")

    @property
    @pulumi.getter(name="diskCapacityInBytes")
    def disk_capacity_in_bytes(self) -> Optional[float]:
        """
        The disk capacity in bytes.
        """
        return pulumi.get(self, "disk_capacity_in_bytes")

    @property
    @pulumi.getter(name="diskId")
    def disk_id(self) -> Optional[str]:
        """
        The managed disk Arm id.
        """
        return pulumi.get(self, "disk_id")

    @property
    @pulumi.getter(name="diskName")
    def disk_name(self) -> Optional[str]:
        """
        The disk name.
        """
        return pulumi.get(self, "disk_name")

    @property
    @pulumi.getter(name="diskState")
    def disk_state(self) -> Optional[str]:
        """
        The disk state.
        """
        return pulumi.get(self, "disk_state")

    @property
    @pulumi.getter(name="diskType")
    def disk_type(self) -> Optional[str]:
        """
        The type of disk.
        """
        return pulumi.get(self, "disk_type")

    @property
    @pulumi.getter(name="failoverDiskName")
    def failover_disk_name(self) -> Optional[str]:
        """
        The failover name for the managed disk.
        """
        return pulumi.get(self, "failover_disk_name")

    @property
    @pulumi.getter(name="isDiskEncrypted")
    def is_disk_encrypted(self) -> Optional[bool]:
        """
        A value indicating whether vm has encrypted os disk or not.
        """
        return pulumi.get(self, "is_disk_encrypted")

    @property
    @pulumi.getter(name="isDiskKeyEncrypted")
    def is_disk_key_encrypted(self) -> Optional[bool]:
        """
        A value indicating whether disk key got encrypted or not.
        """
        return pulumi.get(self, "is_disk_key_encrypted")

    @property
    @pulumi.getter(name="kekKeyVaultArmId")
    def kek_key_vault_arm_id(self) -> Optional[str]:
        """
        The KeyVault resource id for key (KEK).
        """
        return pulumi.get(self, "kek_key_vault_arm_id")

    @property
    @pulumi.getter(name="keyIdentifier")
    def key_identifier(self) -> Optional[str]:
        """
        The key URL / identifier (KEK).
        """
        return pulumi.get(self, "key_identifier")

    @property
    @pulumi.getter(name="monitoringJobType")
    def monitoring_job_type(self) -> Optional[str]:
        """
        The type of the monitoring job. The progress is contained in MonitoringPercentageCompletion property.
        """
        return pulumi.get(self, "monitoring_job_type")

    @property
    @pulumi.getter(name="monitoringPercentageCompletion")
    def monitoring_percentage_completion(self) -> Optional[int]:
        """
        The percentage of the monitoring job. The type of the monitoring job is defined by MonitoringJobType property.
        """
        return pulumi.get(self, "monitoring_percentage_completion")

    @property
    @pulumi.getter(name="primaryDiskEncryptionSetId")
    def primary_disk_encryption_set_id(self) -> Optional[str]:
        """
        The primary disk encryption set Id.
        """
        return pulumi.get(self, "primary_disk_encryption_set_id")

    @property
    @pulumi.getter(name="primaryStagingAzureStorageAccountId")
    def primary_staging_azure_storage_account_id(self) -> Optional[str]:
        """
        The primary staging storage account.
        """
        return pulumi.get(self, "primary_staging_azure_storage_account_id")

    @property
    @pulumi.getter(name="recoveryDiskEncryptionSetId")
    def recovery_disk_encryption_set_id(self) -> Optional[str]:
        """
        The recovery disk encryption set Id.
        """
        return pulumi.get(self, "recovery_disk_encryption_set_id")

    @property
    @pulumi.getter(name="recoveryOrignalTargetDiskId")
    def recovery_orignal_target_disk_id(self) -> Optional[str]:
        """
        Recovery original target disk Arm Id.
        """
        return pulumi.get(self, "recovery_orignal_target_disk_id")

    @property
    @pulumi.getter(name="recoveryReplicaDiskAccountType")
    def recovery_replica_disk_account_type(self) -> Optional[str]:
        """
        The replica disk type. Its an optional value and will be same as source disk type if not user provided.
        """
        return pulumi.get(self, "recovery_replica_disk_account_type")

    @property
    @pulumi.getter(name="recoveryReplicaDiskId")
    def recovery_replica_disk_id(self) -> Optional[str]:
        """
        Recovery replica disk Arm Id.
        """
        return pulumi.get(self, "recovery_replica_disk_id")

    @property
    @pulumi.getter(name="recoveryResourceGroupId")
    def recovery_resource_group_id(self) -> Optional[str]:
        """
        The recovery disk resource group Arm Id.
        """
        return pulumi.get(self, "recovery_resource_group_id")

    @property
    @pulumi.getter(name="recoveryTargetDiskAccountType")
    def recovery_target_disk_account_type(self) -> Optional[str]:
        """
        The target disk type after failover. Its an optional value and will be same as source disk type if not user provided.
        """
        return pulumi.get(self, "recovery_target_disk_account_type")

    @property
    @pulumi.getter(name="recoveryTargetDiskId")
    def recovery_target_disk_id(self) -> Optional[str]:
        """
        Recovery target disk Arm Id.
        """
        return pulumi.get(self, "recovery_target_disk_id")

    @property
    @pulumi.getter(name="resyncRequired")
    def resync_required(self) -> Optional[bool]:
        """
        A value indicating whether resync is required for this disk.
        """
        return pulumi.get(self, "resync_required")

    @property
    @pulumi.getter(name="secretIdentifier")
    def secret_identifier(self) -> Optional[str]:
        """
        The secret URL / identifier (BEK).
        """
        return pulumi.get(self, "secret_identifier")

    @property
    @pulumi.getter(name="tfoDiskName")
    def tfo_disk_name(self) -> Optional[str]:
        """
        The test failover name for the managed disk.
        """
        return pulumi.get(self, "tfo_disk_name")


@pulumi.output_type
class A2AProtectionContainerMappingDetailsResponse(dict):
    """
    A2A provider specific settings.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceType":
            suggest = "instance_type"
        elif key == "agentAutoUpdateStatus":
            suggest = "agent_auto_update_status"
        elif key == "automationAccountArmId":
            suggest = "automation_account_arm_id"
        elif key == "automationAccountAuthenticationType":
            suggest = "automation_account_authentication_type"
        elif key == "jobScheduleName":
            suggest = "job_schedule_name"
        elif key == "scheduleName":
            suggest = "schedule_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in A2AProtectionContainerMappingDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        A2AProtectionContainerMappingDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        A2AProtectionContainerMappingDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_type: str,
                 agent_auto_update_status: Optional[str] = None,
                 automation_account_arm_id: Optional[str] = None,
                 automation_account_authentication_type: Optional[str] = None,
                 job_schedule_name: Optional[str] = None,
                 schedule_name: Optional[str] = None):
        """
        A2A provider specific settings.
        :param str instance_type: Gets the class type. Overridden in derived classes.
               Expected value is 'A2A'.
        :param str agent_auto_update_status: A value indicating whether the auto update is enabled.
        :param str automation_account_arm_id: The automation account arm id.
        :param str automation_account_authentication_type: A value indicating the type authentication to use for automation Account.
        :param str job_schedule_name: The job schedule arm name.
        :param str schedule_name: The schedule arm name.
        """
        pulumi.set(__self__, "instance_type", 'A2A')
        if agent_auto_update_status is not None:
            pulumi.set(__self__, "agent_auto_update_status", agent_auto_update_status)
        if automation_account_arm_id is not None:
            pulumi.set(__self__, "automation_account_arm_id", automation_account_arm_id)
        if automation_account_authentication_type is None:
            automation_account_authentication_type = 'RunAsAccount'
        if automation_account_authentication_type is not None:
            pulumi.set(__self__, "automation_account_authentication_type", automation_account_authentication_type)
        if job_schedule_name is not None:
            pulumi.set(__self__, "job_schedule_name", job_schedule_name)
        if schedule_name is not None:
            pulumi.set(__self__, "schedule_name", schedule_name)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> str:
        """
        Gets the class type. Overridden in derived classes.
        Expected value is 'A2A'.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="agentAutoUpdateStatus")
    def agent_auto_update_status(self) -> Optional[str]:
        """
        A value indicating whether the auto update is enabled.
        """
        return pulumi.get(self, "agent_auto_update_status")

    @property
    @pulumi.getter(name="automationAccountArmId")
    def automation_account_arm_id(self) -> Optional[str]:
        """
        The automation account arm id.
        """
        return pulumi.get(self, "automation_account_arm_id")

    @property
    @pulumi.getter(name="automationAccountAuthenticationType")
    def automation_account_authentication_type(self) -> Optional[str]:
        """
        A value indicating the type authentication to use for automation Account.
        """
        return pulumi.get(self, "automation_account_authentication_type")

    @property
    @pulumi.getter(name="jobScheduleName")
    def job_schedule_name(self) -> Optional[str]:
        """
        The job schedule arm name.
        """
        return pulumi.get(self, "job_schedule_name")

    @property
    @pulumi.getter(name="scheduleName")
    def schedule_name(self) -> Optional[str]:
        """
        The schedule arm name.
        """
        return pulumi.get(self, "schedule_name")


@pulumi.output_type
class A2AReplicationDetailsResponse(dict):
    """
    A2A provider specific settings.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "agentCertificateExpiryDate":
            suggest = "agent_certificate_expiry_date"
        elif key == "initialPrimaryFabricLocation":
            suggest = "initial_primary_fabric_location"
        elif key == "initialPrimaryZone":
            suggest = "initial_primary_zone"
        elif key == "initialRecoveryFabricLocation":
            suggest = "initial_recovery_fabric_location"
        elif key == "initialRecoveryZone":
            suggest = "initial_recovery_zone"
        elif key == "instanceType":
            suggest = "instance_type"
        elif key == "recoveryAzureGeneration":
            suggest = "recovery_azure_generation"
        elif key == "vmEncryptionType":
            suggest = "vm_encryption_type"
        elif key == "agentExpiryDate":
            suggest = "agent_expiry_date"
        elif key == "agentVersion":
            suggest = "agent_version"
        elif key == "autoProtectionOfDataDisk":
            suggest = "auto_protection_of_data_disk"
        elif key == "fabricObjectId":
            suggest = "fabric_object_id"
        elif key == "initialPrimaryExtendedLocation":
            suggest = "initial_primary_extended_location"
        elif key == "initialRecoveryExtendedLocation":
            suggest = "initial_recovery_extended_location"
        elif key == "isReplicationAgentCertificateUpdateRequired":
            suggest = "is_replication_agent_certificate_update_required"
        elif key == "isReplicationAgentUpdateRequired":
            suggest = "is_replication_agent_update_required"
        elif key == "lastHeartbeat":
            suggest = "last_heartbeat"
        elif key == "lastRpoCalculatedTime":
            suggest = "last_rpo_calculated_time"
        elif key == "lifecycleId":
            suggest = "lifecycle_id"
        elif key == "managementId":
            suggest = "management_id"
        elif key == "monitoringJobType":
            suggest = "monitoring_job_type"
        elif key == "monitoringPercentageCompletion":
            suggest = "monitoring_percentage_completion"
        elif key == "multiVmGroupCreateOption":
            suggest = "multi_vm_group_create_option"
        elif key == "multiVmGroupId":
            suggest = "multi_vm_group_id"
        elif key == "multiVmGroupName":
            suggest = "multi_vm_group_name"
        elif key == "osType":
            suggest = "os_type"
        elif key == "primaryAvailabilityZone":
            suggest = "primary_availability_zone"
        elif key == "primaryExtendedLocation":
            suggest = "primary_extended_location"
        elif key == "primaryFabricLocation":
            suggest = "primary_fabric_location"
        elif key == "protectedDisks":
            suggest = "protected_disks"
        elif key == "protectedManagedDisks":
            suggest = "protected_managed_disks"
        elif key == "recoveryAvailabilitySet":
            suggest = "recovery_availability_set"
        elif key == "recoveryAvailabilityZone":
            suggest = "recovery_availability_zone"
        elif key == "recoveryAzureResourceGroupId":
            suggest = "recovery_azure_resource_group_id"
        elif key == "recoveryAzureVMName":
            suggest = "recovery_azure_vm_name"
        elif key == "recoveryAzureVMSize":
            suggest = "recovery_azure_vm_size"
        elif key == "recoveryBootDiagStorageAccountId":
            suggest = "recovery_boot_diag_storage_account_id"
        elif key == "recoveryCapacityReservationGroupId":
            suggest = "recovery_capacity_reservation_group_id"
        elif key == "recoveryCloudService":
            suggest = "recovery_cloud_service"
        elif key == "recoveryExtendedLocation":
            suggest = "recovery_extended_location"
        elif key == "recoveryFabricLocation":
            suggest = "recovery_fabric_location"
        elif key == "recoveryFabricObjectId":
            suggest = "recovery_fabric_object_id"
        elif key == "recoveryProximityPlacementGroupId":
            suggest = "recovery_proximity_placement_group_id"
        elif key == "recoveryVirtualMachineScaleSetId":
            suggest = "recovery_virtual_machine_scale_set_id"
        elif key == "rpoInSeconds":
            suggest = "rpo_in_seconds"
        elif key == "selectedRecoveryAzureNetworkId":
            suggest = "selected_recovery_azure_network_id"
        elif key == "selectedTfoAzureNetworkId":
            suggest = "selected_tfo_azure_network_id"
        elif key == "testFailoverRecoveryFabricObjectId":
            suggest = "test_failover_recovery_fabric_object_id"
        elif key == "tfoAzureVMName":
            suggest = "tfo_azure_vm_name"
        elif key == "unprotectedDisks":
            suggest = "unprotected_disks"
        elif key == "vmNics":
            suggest = "vm_nics"
        elif key == "vmProtectionState":
            suggest = "vm_protection_state"
        elif key == "vmProtectionStateDescription":
            suggest = "vm_protection_state_description"
        elif key == "vmSyncedConfigDetails":
            suggest = "vm_synced_config_details"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in A2AReplicationDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        A2AReplicationDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        A2AReplicationDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 agent_certificate_expiry_date: str,
                 initial_primary_fabric_location: str,
                 initial_primary_zone: str,
                 initial_recovery_fabric_location: str,
                 initial_recovery_zone: str,
                 instance_type: str,
                 recovery_azure_generation: str,
                 vm_encryption_type: str,
                 agent_expiry_date: Optional[str] = None,
                 agent_version: Optional[str] = None,
                 auto_protection_of_data_disk: Optional[str] = None,
                 fabric_object_id: Optional[str] = None,
                 initial_primary_extended_location: Optional['outputs.ExtendedLocationResponse'] = None,
                 initial_recovery_extended_location: Optional['outputs.ExtendedLocationResponse'] = None,
                 is_replication_agent_certificate_update_required: Optional[bool] = None,
                 is_replication_agent_update_required: Optional[bool] = None,
                 last_heartbeat: Optional[str] = None,
                 last_rpo_calculated_time: Optional[str] = None,
                 lifecycle_id: Optional[str] = None,
                 management_id: Optional[str] = None,
                 monitoring_job_type: Optional[str] = None,
                 monitoring_percentage_completion: Optional[int] = None,
                 multi_vm_group_create_option: Optional[str] = None,
                 multi_vm_group_id: Optional[str] = None,
                 multi_vm_group_name: Optional[str] = None,
                 os_type: Optional[str] = None,
                 primary_availability_zone: Optional[str] = None,
                 primary_extended_location: Optional['outputs.ExtendedLocationResponse'] = None,
                 primary_fabric_location: Optional[str] = None,
                 protected_disks: Optional[Sequence['outputs.A2AProtectedDiskDetailsResponse']] = None,
                 protected_managed_disks: Optional[Sequence['outputs.A2AProtectedManagedDiskDetailsResponse']] = None,
                 recovery_availability_set: Optional[str] = None,
                 recovery_availability_zone: Optional[str] = None,
                 recovery_azure_resource_group_id: Optional[str] = None,
                 recovery_azure_vm_name: Optional[str] = None,
                 recovery_azure_vm_size: Optional[str] = None,
                 recovery_boot_diag_storage_account_id: Optional[str] = None,
                 recovery_capacity_reservation_group_id: Optional[str] = None,
                 recovery_cloud_service: Optional[str] = None,
                 recovery_extended_location: Optional['outputs.ExtendedLocationResponse'] = None,
                 recovery_fabric_location: Optional[str] = None,
                 recovery_fabric_object_id: Optional[str] = None,
                 recovery_proximity_placement_group_id: Optional[str] = None,
                 recovery_virtual_machine_scale_set_id: Optional[str] = None,
                 rpo_in_seconds: Optional[float] = None,
                 selected_recovery_azure_network_id: Optional[str] = None,
                 selected_tfo_azure_network_id: Optional[str] = None,
                 test_failover_recovery_fabric_object_id: Optional[str] = None,
                 tfo_azure_vm_name: Optional[str] = None,
                 unprotected_disks: Optional[Sequence['outputs.A2AUnprotectedDiskDetailsResponse']] = None,
                 vm_nics: Optional[Sequence['outputs.VMNicDetailsResponse']] = None,
                 vm_protection_state: Optional[str] = None,
                 vm_protection_state_description: Optional[str] = None,
                 vm_synced_config_details: Optional['outputs.AzureToAzureVmSyncedConfigDetailsResponse'] = None):
        """
        A2A provider specific settings.
        :param str agent_certificate_expiry_date: Agent certificate expiry date.
        :param str initial_primary_fabric_location: The initial primary fabric location.
        :param str initial_primary_zone: The initial primary availability zone.
        :param str initial_recovery_fabric_location: The initial recovery fabric location.
        :param str initial_recovery_zone: The initial recovery availability zone.
        :param str instance_type: Gets the Instance type.
               Expected value is 'A2A'.
        :param str recovery_azure_generation: The recovery azure generation.
        :param str vm_encryption_type: The encryption type of the VM.
        :param str agent_expiry_date: Agent expiry date.
        :param str agent_version: The agent version.
        :param str auto_protection_of_data_disk: A value indicating whether the auto protection is enabled.
        :param str fabric_object_id: The fabric specific object Id of the virtual machine.
        :param 'ExtendedLocationResponse' initial_primary_extended_location: The initial primary extended location.
        :param 'ExtendedLocationResponse' initial_recovery_extended_location: The initial recovery extended location.
        :param bool is_replication_agent_certificate_update_required: A value indicating whether agent certificate update is required.
        :param bool is_replication_agent_update_required: A value indicating whether replication agent update is required.
        :param str last_heartbeat: The last heartbeat received from the source server.
        :param str last_rpo_calculated_time: The time (in UTC) when the last RPO value was calculated by Protection Service.
        :param str lifecycle_id: An id associated with the PE that survives actions like switch protection which change the backing PE/CPE objects internally.The lifecycle id gets carried forward to have a link/continuity in being able to have an Id that denotes the "same" protected item even though other internal Ids/ARM Id might be changing.
        :param str management_id: The management Id.
        :param str monitoring_job_type: The type of the monitoring job. The progress is contained in MonitoringPercentageCompletion property.
        :param int monitoring_percentage_completion: The percentage of the monitoring job. The type of the monitoring job is defined by MonitoringJobType property.
        :param str multi_vm_group_create_option: Whether Multi VM group is auto created or specified by user.
        :param str multi_vm_group_id: The multi vm group Id.
        :param str multi_vm_group_name: The multi vm group name.
        :param str os_type: The type of operating system.
        :param str primary_availability_zone: The primary availability zone.
        :param 'ExtendedLocationResponse' primary_extended_location: The primary Extended Location.
        :param str primary_fabric_location: Primary fabric location.
        :param Sequence['A2AProtectedDiskDetailsResponse'] protected_disks: The list of protected disks.
        :param Sequence['A2AProtectedManagedDiskDetailsResponse'] protected_managed_disks: The list of protected managed disks.
        :param str recovery_availability_set: The recovery availability set.
        :param str recovery_availability_zone: The recovery availability zone.
        :param str recovery_azure_resource_group_id: The recovery resource group.
        :param str recovery_azure_vm_name: The name of recovery virtual machine.
        :param str recovery_azure_vm_size: The size of recovery virtual machine.
        :param str recovery_boot_diag_storage_account_id: The recovery boot diagnostic storage account Arm Id.
        :param str recovery_capacity_reservation_group_id: The recovery capacity reservation group Id.
        :param str recovery_cloud_service: The recovery cloud service.
        :param 'ExtendedLocationResponse' recovery_extended_location: The recovery Extended Location.
        :param str recovery_fabric_location: The recovery fabric location.
        :param str recovery_fabric_object_id: The recovery fabric object Id.
        :param str recovery_proximity_placement_group_id: The recovery proximity placement group Id.
        :param str recovery_virtual_machine_scale_set_id: The recovery virtual machine scale set id.
        :param float rpo_in_seconds: The last RPO value in seconds.
        :param str selected_recovery_azure_network_id: The recovery virtual network.
        :param str selected_tfo_azure_network_id: The test failover virtual network.
        :param str test_failover_recovery_fabric_object_id: The test failover fabric object Id.
        :param str tfo_azure_vm_name: The test failover vm name.
        :param Sequence['A2AUnprotectedDiskDetailsResponse'] unprotected_disks: The list of unprotected disks.
        :param Sequence['VMNicDetailsResponse'] vm_nics: The virtual machine nic details.
        :param str vm_protection_state: The protection state for the vm.
        :param str vm_protection_state_description: The protection state description for the vm.
        :param 'AzureToAzureVmSyncedConfigDetailsResponse' vm_synced_config_details: The synced configuration details.
        """
        pulumi.set(__self__, "agent_certificate_expiry_date", agent_certificate_expiry_date)
        pulumi.set(__self__, "initial_primary_fabric_location", initial_primary_fabric_location)
        pulumi.set(__self__, "initial_primary_zone", initial_primary_zone)
        pulumi.set(__self__, "initial_recovery_fabric_location", initial_recovery_fabric_location)
        pulumi.set(__self__, "initial_recovery_zone", initial_recovery_zone)
        pulumi.set(__self__, "instance_type", 'A2A')
        pulumi.set(__self__, "recovery_azure_generation", recovery_azure_generation)
        pulumi.set(__self__, "vm_encryption_type", vm_encryption_type)
        if agent_expiry_date is not None:
            pulumi.set(__self__, "agent_expiry_date", agent_expiry_date)
        if agent_version is not None:
            pulumi.set(__self__, "agent_version", agent_version)
        if auto_protection_of_data_disk is not None:
            pulumi.set(__self__, "auto_protection_of_data_disk", auto_protection_of_data_disk)
        if fabric_object_id is not None:
            pulumi.set(__self__, "fabric_object_id", fabric_object_id)
        if initial_primary_extended_location is not None:
            pulumi.set(__self__, "initial_primary_extended_location", initial_primary_extended_location)
        if initial_recovery_extended_location is not None:
            pulumi.set(__self__, "initial_recovery_extended_location", initial_recovery_extended_location)
        if is_replication_agent_certificate_update_required is not None:
            pulumi.set(__self__, "is_replication_agent_certificate_update_required", is_replication_agent_certificate_update_required)
        if is_replication_agent_update_required is not None:
            pulumi.set(__self__, "is_replication_agent_update_required", is_replication_agent_update_required)
        if last_heartbeat is not None:
            pulumi.set(__self__, "last_heartbeat", last_heartbeat)
        if last_rpo_calculated_time is not None:
            pulumi.set(__self__, "last_rpo_calculated_time", last_rpo_calculated_time)
        if lifecycle_id is not None:
            pulumi.set(__self__, "lifecycle_id", lifecycle_id)
        if management_id is not None:
            pulumi.set(__self__, "management_id", management_id)
        if monitoring_job_type is not None:
            pulumi.set(__self__, "monitoring_job_type", monitoring_job_type)
        if monitoring_percentage_completion is not None:
            pulumi.set(__self__, "monitoring_percentage_completion", monitoring_percentage_completion)
        if multi_vm_group_create_option is not None:
            pulumi.set(__self__, "multi_vm_group_create_option", multi_vm_group_create_option)
        if multi_vm_group_id is not None:
            pulumi.set(__self__, "multi_vm_group_id", multi_vm_group_id)
        if multi_vm_group_name is not None:
            pulumi.set(__self__, "multi_vm_group_name", multi_vm_group_name)
        if os_type is not None:
            pulumi.set(__self__, "os_type", os_type)
        if primary_availability_zone is not None:
            pulumi.set(__self__, "primary_availability_zone", primary_availability_zone)
        if primary_extended_location is not None:
            pulumi.set(__self__, "primary_extended_location", primary_extended_location)
        if primary_fabric_location is not None:
            pulumi.set(__self__, "primary_fabric_location", primary_fabric_location)
        if protected_disks is not None:
            pulumi.set(__self__, "protected_disks", protected_disks)
        if protected_managed_disks is not None:
            pulumi.set(__self__, "protected_managed_disks", protected_managed_disks)
        if recovery_availability_set is not None:
            pulumi.set(__self__, "recovery_availability_set", recovery_availability_set)
        if recovery_availability_zone is not None:
            pulumi.set(__self__, "recovery_availability_zone", recovery_availability_zone)
        if recovery_azure_resource_group_id is not None:
            pulumi.set(__self__, "recovery_azure_resource_group_id", recovery_azure_resource_group_id)
        if recovery_azure_vm_name is not None:
            pulumi.set(__self__, "recovery_azure_vm_name", recovery_azure_vm_name)
        if recovery_azure_vm_size is not None:
            pulumi.set(__self__, "recovery_azure_vm_size", recovery_azure_vm_size)
        if recovery_boot_diag_storage_account_id is not None:
            pulumi.set(__self__, "recovery_boot_diag_storage_account_id", recovery_boot_diag_storage_account_id)
        if recovery_capacity_reservation_group_id is not None:
            pulumi.set(__self__, "recovery_capacity_reservation_group_id", recovery_capacity_reservation_group_id)
        if recovery_cloud_service is not None:
            pulumi.set(__self__, "recovery_cloud_service", recovery_cloud_service)
        if recovery_extended_location is not None:
            pulumi.set(__self__, "recovery_extended_location", recovery_extended_location)
        if recovery_fabric_location is not None:
            pulumi.set(__self__, "recovery_fabric_location", recovery_fabric_location)
        if recovery_fabric_object_id is not None:
            pulumi.set(__self__, "recovery_fabric_object_id", recovery_fabric_object_id)
        if recovery_proximity_placement_group_id is not None:
            pulumi.set(__self__, "recovery_proximity_placement_group_id", recovery_proximity_placement_group_id)
        if recovery_virtual_machine_scale_set_id is not None:
            pulumi.set(__self__, "recovery_virtual_machine_scale_set_id", recovery_virtual_machine_scale_set_id)
        if rpo_in_seconds is not None:
            pulumi.set(__self__, "rpo_in_seconds", rpo_in_seconds)
        if selected_recovery_azure_network_id is not None:
            pulumi.set(__self__, "selected_recovery_azure_network_id", selected_recovery_azure_network_id)
        if selected_tfo_azure_network_id is not None:
            pulumi.set(__self__, "selected_tfo_azure_network_id", selected_tfo_azure_network_id)
        if test_failover_recovery_fabric_object_id is not None:
            pulumi.set(__self__, "test_failover_recovery_fabric_object_id", test_failover_recovery_fabric_object_id)
        if tfo_azure_vm_name is not None:
            pulumi.set(__self__, "tfo_azure_vm_name", tfo_azure_vm_name)
        if unprotected_disks is not None:
            pulumi.set(__self__, "unprotected_disks", unprotected_disks)
        if vm_nics is not None:
            pulumi.set(__self__, "vm_nics", vm_nics)
        if vm_protection_state is not None:
            pulumi.set(__self__, "vm_protection_state", vm_protection_state)
        if vm_protection_state_description is not None:
            pulumi.set(__self__, "vm_protection_state_description", vm_protection_state_description)
        if vm_synced_config_details is not None:
            pulumi.set(__self__, "vm_synced_config_details", vm_synced_config_details)

    @property
    @pulumi.getter(name="agentCertificateExpiryDate")
    def agent_certificate_expiry_date(self) -> str:
        """
        Agent certificate expiry date.
        """
        return pulumi.get(self, "agent_certificate_expiry_date")

    @property
    @pulumi.getter(name="initialPrimaryFabricLocation")
    def initial_primary_fabric_location(self) -> str:
        """
        The initial primary fabric location.
        """
        return pulumi.get(self, "initial_primary_fabric_location")

    @property
    @pulumi.getter(name="initialPrimaryZone")
    def initial_primary_zone(self) -> str:
        """
        The initial primary availability zone.
        """
        return pulumi.get(self, "initial_primary_zone")

    @property
    @pulumi.getter(name="initialRecoveryFabricLocation")
    def initial_recovery_fabric_location(self) -> str:
        """
        The initial recovery fabric location.
        """
        return pulumi.get(self, "initial_recovery_fabric_location")

    @property
    @pulumi.getter(name="initialRecoveryZone")
    def initial_recovery_zone(self) -> str:
        """
        The initial recovery availability zone.
        """
        return pulumi.get(self, "initial_recovery_zone")

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> str:
        """
        Gets the Instance type.
        Expected value is 'A2A'.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="recoveryAzureGeneration")
    def recovery_azure_generation(self) -> str:
        """
        The recovery azure generation.
        """
        return pulumi.get(self, "recovery_azure_generation")

    @property
    @pulumi.getter(name="vmEncryptionType")
    def vm_encryption_type(self) -> str:
        """
        The encryption type of the VM.
        """
        return pulumi.get(self, "vm_encryption_type")

    @property
    @pulumi.getter(name="agentExpiryDate")
    def agent_expiry_date(self) -> Optional[str]:
        """
        Agent expiry date.
        """
        return pulumi.get(self, "agent_expiry_date")

    @property
    @pulumi.getter(name="agentVersion")
    def agent_version(self) -> Optional[str]:
        """
        The agent version.
        """
        return pulumi.get(self, "agent_version")

    @property
    @pulumi.getter(name="autoProtectionOfDataDisk")
    def auto_protection_of_data_disk(self) -> Optional[str]:
        """
        A value indicating whether the auto protection is enabled.
        """
        return pulumi.get(self, "auto_protection_of_data_disk")

    @property
    @pulumi.getter(name="fabricObjectId")
    def fabric_object_id(self) -> Optional[str]:
        """
        The fabric specific object Id of the virtual machine.
        """
        return pulumi.get(self, "fabric_object_id")

    @property
    @pulumi.getter(name="initialPrimaryExtendedLocation")
    def initial_primary_extended_location(self) -> Optional['outputs.ExtendedLocationResponse']:
        """
        The initial primary extended location.
        """
        return pulumi.get(self, "initial_primary_extended_location")

    @property
    @pulumi.getter(name="initialRecoveryExtendedLocation")
    def initial_recovery_extended_location(self) -> Optional['outputs.ExtendedLocationResponse']:
        """
        The initial recovery extended location.
        """
        return pulumi.get(self, "initial_recovery_extended_location")

    @property
    @pulumi.getter(name="isReplicationAgentCertificateUpdateRequired")
    def is_replication_agent_certificate_update_required(self) -> Optional[bool]:
        """
        A value indicating whether agent certificate update is required.
        """
        return pulumi.get(self, "is_replication_agent_certificate_update_required")

    @property
    @pulumi.getter(name="isReplicationAgentUpdateRequired")
    def is_replication_agent_update_required(self) -> Optional[bool]:
        """
        A value indicating whether replication agent update is required.
        """
        return pulumi.get(self, "is_replication_agent_update_required")

    @property
    @pulumi.getter(name="lastHeartbeat")
    def last_heartbeat(self) -> Optional[str]:
        """
        The last heartbeat received from the source server.
        """
        return pulumi.get(self, "last_heartbeat")

    @property
    @pulumi.getter(name="lastRpoCalculatedTime")
    def last_rpo_calculated_time(self) -> Optional[str]:
        """
        The time (in UTC) when the last RPO value was calculated by Protection Service.
        """
        return pulumi.get(self, "last_rpo_calculated_time")

    @property
    @pulumi.getter(name="lifecycleId")
    def lifecycle_id(self) -> Optional[str]:
        """
        An id associated with the PE that survives actions like switch protection which change the backing PE/CPE objects internally.The lifecycle id gets carried forward to have a link/continuity in being able to have an Id that denotes the "same" protected item even though other internal Ids/ARM Id might be changing.
        """
        return pulumi.get(self, "lifecycle_id")

    @property
    @pulumi.getter(name="managementId")
    def management_id(self) -> Optional[str]:
        """
        The management Id.
        """
        return pulumi.get(self, "management_id")

    @property
    @pulumi.getter(name="monitoringJobType")
    def monitoring_job_type(self) -> Optional[str]:
        """
        The type of the monitoring job. The progress is contained in MonitoringPercentageCompletion property.
        """
        return pulumi.get(self, "monitoring_job_type")

    @property
    @pulumi.getter(name="monitoringPercentageCompletion")
    def monitoring_percentage_completion(self) -> Optional[int]:
        """
        The percentage of the monitoring job. The type of the monitoring job is defined by MonitoringJobType property.
        """
        return pulumi.get(self, "monitoring_percentage_completion")

    @property
    @pulumi.getter(name="multiVmGroupCreateOption")
    def multi_vm_group_create_option(self) -> Optional[str]:
        """
        Whether Multi VM group is auto created or specified by user.
        """
        return pulumi.get(self, "multi_vm_group_create_option")

    @property
    @pulumi.getter(name="multiVmGroupId")
    def multi_vm_group_id(self) -> Optional[str]:
        """
        The multi vm group Id.
        """
        return pulumi.get(self, "multi_vm_group_id")

    @property
    @pulumi.getter(name="multiVmGroupName")
    def multi_vm_group_name(self) -> Optional[str]:
        """
        The multi vm group name.
        """
        return pulumi.get(self, "multi_vm_group_name")

    @property
    @pulumi.getter(name="osType")
    def os_type(self) -> Optional[str]:
        """
        The type of operating system.
        """
        return pulumi.get(self, "os_type")

    @property
    @pulumi.getter(name="primaryAvailabilityZone")
    def primary_availability_zone(self) -> Optional[str]:
        """
        The primary availability zone.
        """
        return pulumi.get(self, "primary_availability_zone")

    @property
    @pulumi.getter(name="primaryExtendedLocation")
    def primary_extended_location(self) -> Optional['outputs.ExtendedLocationResponse']:
        """
        The primary Extended Location.
        """
        return pulumi.get(self, "primary_extended_location")

    @property
    @pulumi.getter(name="primaryFabricLocation")
    def primary_fabric_location(self) -> Optional[str]:
        """
        Primary fabric location.
        """
        return pulumi.get(self, "primary_fabric_location")

    @property
    @pulumi.getter(name="protectedDisks")
    def protected_disks(self) -> Optional[Sequence['outputs.A2AProtectedDiskDetailsResponse']]:
        """
        The list of protected disks.
        """
        return pulumi.get(self, "protected_disks")

    @property
    @pulumi.getter(name="protectedManagedDisks")
    def protected_managed_disks(self) -> Optional[Sequence['outputs.A2AProtectedManagedDiskDetailsResponse']]:
        """
        The list of protected managed disks.
        """
        return pulumi.get(self, "protected_managed_disks")

    @property
    @pulumi.getter(name="recoveryAvailabilitySet")
    def recovery_availability_set(self) -> Optional[str]:
        """
        The recovery availability set.
        """
        return pulumi.get(self, "recovery_availability_set")

    @property
    @pulumi.getter(name="recoveryAvailabilityZone")
    def recovery_availability_zone(self) -> Optional[str]:
        """
        The recovery availability zone.
        """
        return pulumi.get(self, "recovery_availability_zone")

    @property
    @pulumi.getter(name="recoveryAzureResourceGroupId")
    def recovery_azure_resource_group_id(self) -> Optional[str]:
        """
        The recovery resource group.
        """
        return pulumi.get(self, "recovery_azure_resource_group_id")

    @property
    @pulumi.getter(name="recoveryAzureVMName")
    def recovery_azure_vm_name(self) -> Optional[str]:
        """
        The name of recovery virtual machine.
        """
        return pulumi.get(self, "recovery_azure_vm_name")

    @property
    @pulumi.getter(name="recoveryAzureVMSize")
    def recovery_azure_vm_size(self) -> Optional[str]:
        """
        The size of recovery virtual machine.
        """
        return pulumi.get(self, "recovery_azure_vm_size")

    @property
    @pulumi.getter(name="recoveryBootDiagStorageAccountId")
    def recovery_boot_diag_storage_account_id(self) -> Optional[str]:
        """
        The recovery boot diagnostic storage account Arm Id.
        """
        return pulumi.get(self, "recovery_boot_diag_storage_account_id")

    @property
    @pulumi.getter(name="recoveryCapacityReservationGroupId")
    def recovery_capacity_reservation_group_id(self) -> Optional[str]:
        """
        The recovery capacity reservation group Id.
        """
        return pulumi.get(self, "recovery_capacity_reservation_group_id")

    @property
    @pulumi.getter(name="recoveryCloudService")
    def recovery_cloud_service(self) -> Optional[str]:
        """
        The recovery cloud service.
        """
        return pulumi.get(self, "recovery_cloud_service")

    @property
    @pulumi.getter(name="recoveryExtendedLocation")
    def recovery_extended_location(self) -> Optional['outputs.ExtendedLocationResponse']:
        """
        The recovery Extended Location.
        """
        return pulumi.get(self, "recovery_extended_location")

    @property
    @pulumi.getter(name="recoveryFabricLocation")
    def recovery_fabric_location(self) -> Optional[str]:
        """
        The recovery fabric location.
        """
        return pulumi.get(self, "recovery_fabric_location")

    @property
    @pulumi.getter(name="recoveryFabricObjectId")
    def recovery_fabric_object_id(self) -> Optional[str]:
        """
        The recovery fabric object Id.
        """
        return pulumi.get(self, "recovery_fabric_object_id")

    @property
    @pulumi.getter(name="recoveryProximityPlacementGroupId")
    def recovery_proximity_placement_group_id(self) -> Optional[str]:
        """
        The recovery proximity placement group Id.
        """
        return pulumi.get(self, "recovery_proximity_placement_group_id")

    @property
    @pulumi.getter(name="recoveryVirtualMachineScaleSetId")
    def recovery_virtual_machine_scale_set_id(self) -> Optional[str]:
        """
        The recovery virtual machine scale set id.
        """
        return pulumi.get(self, "recovery_virtual_machine_scale_set_id")

    @property
    @pulumi.getter(name="rpoInSeconds")
    def rpo_in_seconds(self) -> Optional[float]:
        """
        The last RPO value in seconds.
        """
        return pulumi.get(self, "rpo_in_seconds")

    @property
    @pulumi.getter(name="selectedRecoveryAzureNetworkId")
    def selected_recovery_azure_network_id(self) -> Optional[str]:
        """
        The recovery virtual network.
        """
        return pulumi.get(self, "selected_recovery_azure_network_id")

    @property
    @pulumi.getter(name="selectedTfoAzureNetworkId")
    def selected_tfo_azure_network_id(self) -> Optional[str]:
        """
        The test failover virtual network.
        """
        return pulumi.get(self, "selected_tfo_azure_network_id")

    @property
    @pulumi.getter(name="testFailoverRecoveryFabricObjectId")
    def test_failover_recovery_fabric_object_id(self) -> Optional[str]:
        """
        The test failover fabric object Id.
        """
        return pulumi.get(self, "test_failover_recovery_fabric_object_id")

    @property
    @pulumi.getter(name="tfoAzureVMName")
    def tfo_azure_vm_name(self) -> Optional[str]:
        """
        The test failover vm name.
        """
        return pulumi.get(self, "tfo_azure_vm_name")

    @property
    @pulumi.getter(name="unprotectedDisks")
    def unprotected_disks(self) -> Optional[Sequence['outputs.A2AUnprotectedDiskDetailsResponse']]:
        """
        The list of unprotected disks.
        """
        return pulumi.get(self, "unprotected_disks")

    @property
    @pulumi.getter(name="vmNics")
    def vm_nics(self) -> Optional[Sequence['outputs.VMNicDetailsResponse']]:
        """
        The virtual machine nic details.
        """
        return pulumi.get(self, "vm_nics")

    @property
    @pulumi.getter(name="vmProtectionState")
    def vm_protection_state(self) -> Optional[str]:
        """
        The protection state for the vm.
        """
        return pulumi.get(self, "vm_protection_state")

    @property
    @pulumi.getter(name="vmProtectionStateDescription")
    def vm_protection_state_description(self) -> Optional[str]:
        """
        The protection state description for the vm.
        """
        return pulumi.get(self, "vm_protection_state_description")

    @property
    @pulumi.getter(name="vmSyncedConfigDetails")
    def vm_synced_config_details(self) -> Optional['outputs.AzureToAzureVmSyncedConfigDetailsResponse']:
        """
        The synced configuration details.
        """
        return pulumi.get(self, "vm_synced_config_details")


@pulumi.output_type
class A2AUnprotectedDiskDetailsResponse(dict):
    """
    A2A unprotected disk details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "diskAutoProtectionStatus":
            suggest = "disk_auto_protection_status"
        elif key == "diskLunId":
            suggest = "disk_lun_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in A2AUnprotectedDiskDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        A2AUnprotectedDiskDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        A2AUnprotectedDiskDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disk_auto_protection_status: Optional[str] = None,
                 disk_lun_id: Optional[int] = None):
        """
        A2A unprotected disk details.
        :param str disk_auto_protection_status: A value indicating whether the disk auto protection is enabled.
        :param int disk_lun_id: The source lun Id for the data disk.
        """
        if disk_auto_protection_status is not None:
            pulumi.set(__self__, "disk_auto_protection_status", disk_auto_protection_status)
        if disk_lun_id is not None:
            pulumi.set(__self__, "disk_lun_id", disk_lun_id)

    @property
    @pulumi.getter(name="diskAutoProtectionStatus")
    def disk_auto_protection_status(self) -> Optional[str]:
        """
        A value indicating whether the disk auto protection is enabled.
        """
        return pulumi.get(self, "disk_auto_protection_status")

    @property
    @pulumi.getter(name="diskLunId")
    def disk_lun_id(self) -> Optional[int]:
        """
        The source lun Id for the data disk.
        """
        return pulumi.get(self, "disk_lun_id")


@pulumi.output_type
class A2AZoneDetailsResponse(dict):
    """
    Zone details data.
    """
    def __init__(__self__, *,
                 source: Optional[str] = None,
                 target: Optional[str] = None):
        """
        Zone details data.
        :param str source: Source zone info.
        :param str target: The target zone info.
        """
        if source is not None:
            pulumi.set(__self__, "source", source)
        if target is not None:
            pulumi.set(__self__, "target", target)

    @property
    @pulumi.getter
    def source(self) -> Optional[str]:
        """
        Source zone info.
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter
    def target(self) -> Optional[str]:
        """
        The target zone info.
        """
        return pulumi.get(self, "target")


@pulumi.output_type
class AgentDetailsResponse(dict):
    """
    Agent details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "agentId":
            suggest = "agent_id"
        elif key == "biosId":
            suggest = "bios_id"
        elif key == "machineId":
            suggest = "machine_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AgentDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AgentDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AgentDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 agent_id: str,
                 bios_id: str,
                 disks: Sequence['outputs.AgentDiskDetailsResponse'],
                 fqdn: str,
                 machine_id: str):
        """
        Agent details.
        :param str agent_id: The Id of the agent running on the server.
        :param str bios_id: The machine BIOS Id.
        :param Sequence['AgentDiskDetailsResponse'] disks: The disks.
        :param str fqdn: The machine FQDN.
        :param str machine_id: The Id of the machine to which the agent is registered.
        """
        pulumi.set(__self__, "agent_id", agent_id)
        pulumi.set(__self__, "bios_id", bios_id)
        pulumi.set(__self__, "disks", disks)
        pulumi.set(__self__, "fqdn", fqdn)
        pulumi.set(__self__, "machine_id", machine_id)

    @property
    @pulumi.getter(name="agentId")
    def agent_id(self) -> str:
        """
        The Id of the agent running on the server.
        """
        return pulumi.get(self, "agent_id")

    @property
    @pulumi.getter(name="biosId")
    def bios_id(self) -> str:
        """
        The machine BIOS Id.
        """
        return pulumi.get(self, "bios_id")

    @property
    @pulumi.getter
    def disks(self) -> Sequence['outputs.AgentDiskDetailsResponse']:
        """
        The disks.
        """
        return pulumi.get(self, "disks")

    @property
    @pulumi.getter
    def fqdn(self) -> str:
        """
        The machine FQDN.
        """
        return pulumi.get(self, "fqdn")

    @property
    @pulumi.getter(name="machineId")
    def machine_id(self) -> str:
        """
        The Id of the machine to which the agent is registered.
        """
        return pulumi.get(self, "machine_id")


@pulumi.output_type
class AgentDiskDetailsResponse(dict):
    """
    Agent disk details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "capacityInBytes":
            suggest = "capacity_in_bytes"
        elif key == "diskId":
            suggest = "disk_id"
        elif key == "diskName":
            suggest = "disk_name"
        elif key == "isOSDisk":
            suggest = "is_os_disk"
        elif key == "lunId":
            suggest = "lun_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AgentDiskDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AgentDiskDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AgentDiskDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 capacity_in_bytes: float,
                 disk_id: str,
                 disk_name: str,
                 is_os_disk: str,
                 lun_id: int):
        """
        Agent disk details.
        :param float capacity_in_bytes: The disk capacity in bytes.
        :param str disk_id: The disk Id.
        :param str disk_name: The disk name.
        :param str is_os_disk: A value indicating whether the disk is the OS disk.
        :param int lun_id: The lun of disk.
        """
        pulumi.set(__self__, "capacity_in_bytes", capacity_in_bytes)
        pulumi.set(__self__, "disk_id", disk_id)
        pulumi.set(__self__, "disk_name", disk_name)
        pulumi.set(__self__, "is_os_disk", is_os_disk)
        pulumi.set(__self__, "lun_id", lun_id)

    @property
    @pulumi.getter(name="capacityInBytes")
    def capacity_in_bytes(self) -> float:
        """
        The disk capacity in bytes.
        """
        return pulumi.get(self, "capacity_in_bytes")

    @property
    @pulumi.getter(name="diskId")
    def disk_id(self) -> str:
        """
        The disk Id.
        """
        return pulumi.get(self, "disk_id")

    @property
    @pulumi.getter(name="diskName")
    def disk_name(self) -> str:
        """
        The disk name.
        """
        return pulumi.get(self, "disk_name")

    @property
    @pulumi.getter(name="isOSDisk")
    def is_os_disk(self) -> str:
        """
        A value indicating whether the disk is the OS disk.
        """
        return pulumi.get(self, "is_os_disk")

    @property
    @pulumi.getter(name="lunId")
    def lun_id(self) -> int:
        """
        The lun of disk.
        """
        return pulumi.get(self, "lun_id")


@pulumi.output_type
class AzureFabricSpecificDetailsResponse(dict):
    """
    Azure Fabric Specific Details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceType":
            suggest = "instance_type"
        elif key == "containerIds":
            suggest = "container_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureFabricSpecificDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureFabricSpecificDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureFabricSpecificDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_type: str,
                 container_ids: Optional[Sequence[str]] = None,
                 location: Optional[str] = None,
                 zones: Optional[Sequence['outputs.A2AZoneDetailsResponse']] = None):
        """
        Azure Fabric Specific Details.
        :param str instance_type: Gets the class type. Overridden in derived classes.
               Expected value is 'Azure'.
        :param Sequence[str] container_ids: The container Ids for the Azure fabric.
        :param str location: The Location for the Azure fabric.
        :param Sequence['A2AZoneDetailsResponse'] zones: The zones.
        """
        pulumi.set(__self__, "instance_type", 'Azure')
        if container_ids is not None:
            pulumi.set(__self__, "container_ids", container_ids)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if zones is not None:
            pulumi.set(__self__, "zones", zones)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> str:
        """
        Gets the class type. Overridden in derived classes.
        Expected value is 'Azure'.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="containerIds")
    def container_ids(self) -> Optional[Sequence[str]]:
        """
        The container Ids for the Azure fabric.
        """
        return pulumi.get(self, "container_ids")

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        The Location for the Azure fabric.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def zones(self) -> Optional[Sequence['outputs.A2AZoneDetailsResponse']]:
        """
        The zones.
        """
        return pulumi.get(self, "zones")


@pulumi.output_type
class AzureMonitorAlertSettingsResponse(dict):
    """
    Settings for Azure Monitor based alerts
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "alertsForAllJobFailures":
            suggest = "alerts_for_all_job_failures"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureMonitorAlertSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureMonitorAlertSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureMonitorAlertSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 alerts_for_all_job_failures: Optional[str] = None):
        """
        Settings for Azure Monitor based alerts
        """
        if alerts_for_all_job_failures is not None:
            pulumi.set(__self__, "alerts_for_all_job_failures", alerts_for_all_job_failures)

    @property
    @pulumi.getter(name="alertsForAllJobFailures")
    def alerts_for_all_job_failures(self) -> Optional[str]:
        return pulumi.get(self, "alerts_for_all_job_failures")


@pulumi.output_type
class AzureToAzureNetworkMappingSettingsResponse(dict):
    """
    A2A Network Mapping fabric specific settings.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceType":
            suggest = "instance_type"
        elif key == "primaryFabricLocation":
            suggest = "primary_fabric_location"
        elif key == "recoveryFabricLocation":
            suggest = "recovery_fabric_location"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureToAzureNetworkMappingSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureToAzureNetworkMappingSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureToAzureNetworkMappingSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_type: str,
                 primary_fabric_location: Optional[str] = None,
                 recovery_fabric_location: Optional[str] = None):
        """
        A2A Network Mapping fabric specific settings.
        :param str instance_type: Gets the Instance type.
               Expected value is 'AzureToAzure'.
        :param str primary_fabric_location: The primary fabric location.
        :param str recovery_fabric_location: The recovery fabric location.
        """
        pulumi.set(__self__, "instance_type", 'AzureToAzure')
        if primary_fabric_location is not None:
            pulumi.set(__self__, "primary_fabric_location", primary_fabric_location)
        if recovery_fabric_location is not None:
            pulumi.set(__self__, "recovery_fabric_location", recovery_fabric_location)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> str:
        """
        Gets the Instance type.
        Expected value is 'AzureToAzure'.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="primaryFabricLocation")
    def primary_fabric_location(self) -> Optional[str]:
        """
        The primary fabric location.
        """
        return pulumi.get(self, "primary_fabric_location")

    @property
    @pulumi.getter(name="recoveryFabricLocation")
    def recovery_fabric_location(self) -> Optional[str]:
        """
        The recovery fabric location.
        """
        return pulumi.get(self, "recovery_fabric_location")


@pulumi.output_type
class AzureToAzureVmSyncedConfigDetailsResponse(dict):
    """
    Azure to Azure VM synced configuration details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "inputEndpoints":
            suggest = "input_endpoints"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureToAzureVmSyncedConfigDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureToAzureVmSyncedConfigDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureToAzureVmSyncedConfigDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 input_endpoints: Optional[Sequence['outputs.InputEndpointResponse']] = None,
                 tags: Optional[Mapping[str, str]] = None):
        """
        Azure to Azure VM synced configuration details.
        :param Sequence['InputEndpointResponse'] input_endpoints: The Azure VM input endpoints.
        :param Mapping[str, str] tags: The Azure VM tags.
        """
        if input_endpoints is not None:
            pulumi.set(__self__, "input_endpoints", input_endpoints)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="inputEndpoints")
    def input_endpoints(self) -> Optional[Sequence['outputs.InputEndpointResponse']]:
        """
        The Azure VM input endpoints.
        """
        return pulumi.get(self, "input_endpoints")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        The Azure VM tags.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class AzureVmDiskDetailsResponse(dict):
    """
    Disk details for E2A provider.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customTargetDiskName":
            suggest = "custom_target_disk_name"
        elif key == "diskEncryptionSetId":
            suggest = "disk_encryption_set_id"
        elif key == "diskId":
            suggest = "disk_id"
        elif key == "lunId":
            suggest = "lun_id"
        elif key == "maxSizeMB":
            suggest = "max_size_mb"
        elif key == "targetDiskLocation":
            suggest = "target_disk_location"
        elif key == "targetDiskName":
            suggest = "target_disk_name"
        elif key == "vhdId":
            suggest = "vhd_id"
        elif key == "vhdName":
            suggest = "vhd_name"
        elif key == "vhdType":
            suggest = "vhd_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureVmDiskDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureVmDiskDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureVmDiskDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 custom_target_disk_name: Optional[str] = None,
                 disk_encryption_set_id: Optional[str] = None,
                 disk_id: Optional[str] = None,
                 lun_id: Optional[str] = None,
                 max_size_mb: Optional[str] = None,
                 target_disk_location: Optional[str] = None,
                 target_disk_name: Optional[str] = None,
                 vhd_id: Optional[str] = None,
                 vhd_name: Optional[str] = None,
                 vhd_type: Optional[str] = None):
        """
        Disk details for E2A provider.
        :param str custom_target_disk_name: The custom target Azure disk name.
        :param str disk_encryption_set_id: The DiskEncryptionSet ARM ID.
        :param str disk_id: The disk resource id.
        :param str lun_id: Ordinal\\LunId of the disk for the Azure VM.
        :param str max_size_mb: Max side in MB.
        :param str target_disk_location: Blob uri of the Azure disk.
        :param str target_disk_name: The target Azure disk name.
        :param str vhd_id: The VHD id.
        :param str vhd_name: VHD name.
        :param str vhd_type: VHD type.
        """
        if custom_target_disk_name is not None:
            pulumi.set(__self__, "custom_target_disk_name", custom_target_disk_name)
        if disk_encryption_set_id is not None:
            pulumi.set(__self__, "disk_encryption_set_id", disk_encryption_set_id)
        if disk_id is not None:
            pulumi.set(__self__, "disk_id", disk_id)
        if lun_id is not None:
            pulumi.set(__self__, "lun_id", lun_id)
        if max_size_mb is not None:
            pulumi.set(__self__, "max_size_mb", max_size_mb)
        if target_disk_location is not None:
            pulumi.set(__self__, "target_disk_location", target_disk_location)
        if target_disk_name is not None:
            pulumi.set(__self__, "target_disk_name", target_disk_name)
        if vhd_id is not None:
            pulumi.set(__self__, "vhd_id", vhd_id)
        if vhd_name is not None:
            pulumi.set(__self__, "vhd_name", vhd_name)
        if vhd_type is not None:
            pulumi.set(__self__, "vhd_type", vhd_type)

    @property
    @pulumi.getter(name="customTargetDiskName")
    def custom_target_disk_name(self) -> Optional[str]:
        """
        The custom target Azure disk name.
        """
        return pulumi.get(self, "custom_target_disk_name")

    @property
    @pulumi.getter(name="diskEncryptionSetId")
    def disk_encryption_set_id(self) -> Optional[str]:
        """
        The DiskEncryptionSet ARM ID.
        """
        return pulumi.get(self, "disk_encryption_set_id")

    @property
    @pulumi.getter(name="diskId")
    def disk_id(self) -> Optional[str]:
        """
        The disk resource id.
        """
        return pulumi.get(self, "disk_id")

    @property
    @pulumi.getter(name="lunId")
    def lun_id(self) -> Optional[str]:
        """
        Ordinal\\LunId of the disk for the Azure VM.
        """
        return pulumi.get(self, "lun_id")

    @property
    @pulumi.getter(name="maxSizeMB")
    def max_size_mb(self) -> Optional[str]:
        """
        Max side in MB.
        """
        return pulumi.get(self, "max_size_mb")

    @property
    @pulumi.getter(name="targetDiskLocation")
    def target_disk_location(self) -> Optional[str]:
        """
        Blob uri of the Azure disk.
        """
        return pulumi.get(self, "target_disk_location")

    @property
    @pulumi.getter(name="targetDiskName")
    def target_disk_name(self) -> Optional[str]:
        """
        The target Azure disk name.
        """
        return pulumi.get(self, "target_disk_name")

    @property
    @pulumi.getter(name="vhdId")
    def vhd_id(self) -> Optional[str]:
        """
        The VHD id.
        """
        return pulumi.get(self, "vhd_id")

    @property
    @pulumi.getter(name="vhdName")
    def vhd_name(self) -> Optional[str]:
        """
        VHD name.
        """
        return pulumi.get(self, "vhd_name")

    @property
    @pulumi.getter(name="vhdType")
    def vhd_type(self) -> Optional[str]:
        """
        VHD type.
        """
        return pulumi.get(self, "vhd_type")


@pulumi.output_type
class ClassicAlertSettingsResponse(dict):
    """
    Settings for classic alerts
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "alertsForCriticalOperations":
            suggest = "alerts_for_critical_operations"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClassicAlertSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClassicAlertSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClassicAlertSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 alerts_for_critical_operations: Optional[str] = None):
        """
        Settings for classic alerts
        """
        if alerts_for_critical_operations is not None:
            pulumi.set(__self__, "alerts_for_critical_operations", alerts_for_critical_operations)

    @property
    @pulumi.getter(name="alertsForCriticalOperations")
    def alerts_for_critical_operations(self) -> Optional[str]:
        return pulumi.get(self, "alerts_for_critical_operations")


@pulumi.output_type
class CmkKekIdentityResponse(dict):
    """
    The details of the identity used for CMK
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "useSystemAssignedIdentity":
            suggest = "use_system_assigned_identity"
        elif key == "userAssignedIdentity":
            suggest = "user_assigned_identity"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CmkKekIdentityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CmkKekIdentityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CmkKekIdentityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 use_system_assigned_identity: Optional[bool] = None,
                 user_assigned_identity: Optional[str] = None):
        """
        The details of the identity used for CMK
        :param bool use_system_assigned_identity: Indicate that system assigned identity should be used. Mutually exclusive with 'userAssignedIdentity' field
        :param str user_assigned_identity: The user assigned identity to be used to grant permissions in case the type of identity used is UserAssigned
        """
        if use_system_assigned_identity is not None:
            pulumi.set(__self__, "use_system_assigned_identity", use_system_assigned_identity)
        if user_assigned_identity is not None:
            pulumi.set(__self__, "user_assigned_identity", user_assigned_identity)

    @property
    @pulumi.getter(name="useSystemAssignedIdentity")
    def use_system_assigned_identity(self) -> Optional[bool]:
        """
        Indicate that system assigned identity should be used. Mutually exclusive with 'userAssignedIdentity' field
        """
        return pulumi.get(self, "use_system_assigned_identity")

    @property
    @pulumi.getter(name="userAssignedIdentity")
    def user_assigned_identity(self) -> Optional[str]:
        """
        The user assigned identity to be used to grant permissions in case the type of identity used is UserAssigned
        """
        return pulumi.get(self, "user_assigned_identity")


@pulumi.output_type
class CmkKeyVaultPropertiesResponse(dict):
    """
    The properties of the Key Vault which hosts CMK
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyUri":
            suggest = "key_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CmkKeyVaultPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CmkKeyVaultPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CmkKeyVaultPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_uri: Optional[str] = None):
        """
        The properties of the Key Vault which hosts CMK
        :param str key_uri: The key uri of the Customer Managed Key
        """
        if key_uri is not None:
            pulumi.set(__self__, "key_uri", key_uri)

    @property
    @pulumi.getter(name="keyUri")
    def key_uri(self) -> Optional[str]:
        """
        The key uri of the Customer Managed Key
        """
        return pulumi.get(self, "key_uri")


@pulumi.output_type
class CurrentJobDetailsResponse(dict):
    """
    Current job details of the migration item.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "jobId":
            suggest = "job_id"
        elif key == "jobName":
            suggest = "job_name"
        elif key == "startTime":
            suggest = "start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CurrentJobDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CurrentJobDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CurrentJobDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 job_id: str,
                 job_name: str,
                 start_time: str):
        """
        Current job details of the migration item.
        :param str job_id: The ARM Id of the job being executed.
        :param str job_name: The job name.
        :param str start_time: The start time of the job.
        """
        pulumi.set(__self__, "job_id", job_id)
        pulumi.set(__self__, "job_name", job_name)
        pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter(name="jobId")
    def job_id(self) -> str:
        """
        The ARM Id of the job being executed.
        """
        return pulumi.get(self, "job_id")

    @property
    @pulumi.getter(name="jobName")
    def job_name(self) -> str:
        """
        The job name.
        """
        return pulumi.get(self, "job_name")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> str:
        """
        The start time of the job.
        """
        return pulumi.get(self, "start_time")


@pulumi.output_type
class CurrentScenarioDetailsResponse(dict):
    """
    Current scenario details of the protected entity.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "jobId":
            suggest = "job_id"
        elif key == "scenarioName":
            suggest = "scenario_name"
        elif key == "startTime":
            suggest = "start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CurrentScenarioDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CurrentScenarioDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CurrentScenarioDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 job_id: Optional[str] = None,
                 scenario_name: Optional[str] = None,
                 start_time: Optional[str] = None):
        """
        Current scenario details of the protected entity.
        :param str job_id: ARM Id of the job being executed.
        :param str scenario_name: Scenario name.
        :param str start_time: Start time of the workflow.
        """
        if job_id is not None:
            pulumi.set(__self__, "job_id", job_id)
        if scenario_name is not None:
            pulumi.set(__self__, "scenario_name", scenario_name)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter(name="jobId")
    def job_id(self) -> Optional[str]:
        """
        ARM Id of the job being executed.
        """
        return pulumi.get(self, "job_id")

    @property
    @pulumi.getter(name="scenarioName")
    def scenario_name(self) -> Optional[str]:
        """
        Scenario name.
        """
        return pulumi.get(self, "scenario_name")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[str]:
        """
        Start time of the workflow.
        """
        return pulumi.get(self, "start_time")


@pulumi.output_type
class DataStoreResponse(dict):
    """
    The datastore details of the MT.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "freeSpace":
            suggest = "free_space"
        elif key == "symbolicName":
            suggest = "symbolic_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataStoreResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataStoreResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataStoreResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 capacity: Optional[str] = None,
                 free_space: Optional[str] = None,
                 symbolic_name: Optional[str] = None,
                 type: Optional[str] = None,
                 uuid: Optional[str] = None):
        """
        The datastore details of the MT.
        :param str capacity: The capacity of data store in GBs.
        :param str free_space: The free space of data store in GBs.
        :param str symbolic_name: The symbolic name of data store.
        :param str type: The type of data store.
        :param str uuid: The uuid of data store.
        """
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if free_space is not None:
            pulumi.set(__self__, "free_space", free_space)
        if symbolic_name is not None:
            pulumi.set(__self__, "symbolic_name", symbolic_name)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if uuid is not None:
            pulumi.set(__self__, "uuid", uuid)

    @property
    @pulumi.getter
    def capacity(self) -> Optional[str]:
        """
        The capacity of data store in GBs.
        """
        return pulumi.get(self, "capacity")

    @property
    @pulumi.getter(name="freeSpace")
    def free_space(self) -> Optional[str]:
        """
        The free space of data store in GBs.
        """
        return pulumi.get(self, "free_space")

    @property
    @pulumi.getter(name="symbolicName")
    def symbolic_name(self) -> Optional[str]:
        """
        The symbolic name of data store.
        """
        return pulumi.get(self, "symbolic_name")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of data store.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def uuid(self) -> Optional[str]:
        """
        The uuid of data store.
        """
        return pulumi.get(self, "uuid")


@pulumi.output_type
class DiskDetailsResponse(dict):
    """
    Onprem disk details data.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxSizeMB":
            suggest = "max_size_mb"
        elif key == "vhdId":
            suggest = "vhd_id"
        elif key == "vhdName":
            suggest = "vhd_name"
        elif key == "vhdType":
            suggest = "vhd_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DiskDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DiskDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DiskDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_size_mb: Optional[float] = None,
                 vhd_id: Optional[str] = None,
                 vhd_name: Optional[str] = None,
                 vhd_type: Optional[str] = None):
        """
        Onprem disk details data.
        :param float max_size_mb: The hard disk max size in MB.
        :param str vhd_id: The VHD Id.
        :param str vhd_name: The VHD name.
        :param str vhd_type: The type of the volume.
        """
        if max_size_mb is not None:
            pulumi.set(__self__, "max_size_mb", max_size_mb)
        if vhd_id is not None:
            pulumi.set(__self__, "vhd_id", vhd_id)
        if vhd_name is not None:
            pulumi.set(__self__, "vhd_name", vhd_name)
        if vhd_type is not None:
            pulumi.set(__self__, "vhd_type", vhd_type)

    @property
    @pulumi.getter(name="maxSizeMB")
    def max_size_mb(self) -> Optional[float]:
        """
        The hard disk max size in MB.
        """
        return pulumi.get(self, "max_size_mb")

    @property
    @pulumi.getter(name="vhdId")
    def vhd_id(self) -> Optional[str]:
        """
        The VHD Id.
        """
        return pulumi.get(self, "vhd_id")

    @property
    @pulumi.getter(name="vhdName")
    def vhd_name(self) -> Optional[str]:
        """
        The VHD name.
        """
        return pulumi.get(self, "vhd_name")

    @property
    @pulumi.getter(name="vhdType")
    def vhd_type(self) -> Optional[str]:
        """
        The type of the volume.
        """
        return pulumi.get(self, "vhd_type")


@pulumi.output_type
class DraDetailsResponse(dict):
    """
    DRA details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "biosId":
            suggest = "bios_id"
        elif key == "forwardProtectedItemCount":
            suggest = "forward_protected_item_count"
        elif key == "healthErrors":
            suggest = "health_errors"
        elif key == "lastHeartbeatUtc":
            suggest = "last_heartbeat_utc"
        elif key == "reverseProtectedItemCount":
            suggest = "reverse_protected_item_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DraDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DraDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DraDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bios_id: str,
                 forward_protected_item_count: int,
                 health: str,
                 health_errors: Sequence['outputs.HealthErrorResponse'],
                 id: str,
                 last_heartbeat_utc: str,
                 name: str,
                 reverse_protected_item_count: int,
                 version: str):
        """
        DRA details.
        :param str bios_id: The DRA Bios Id.
        :param int forward_protected_item_count: The count of protected items which are protected in forward direction.
        :param str health: The health.
        :param Sequence['HealthErrorResponse'] health_errors: The health errors.
        :param str id: The DRA Id.
        :param str last_heartbeat_utc: The last heartbeat received from the DRA.
        :param str name: The DRA name.
        :param int reverse_protected_item_count: The count of protected items which are protected in reverse direction.
        :param str version: The version.
        """
        pulumi.set(__self__, "bios_id", bios_id)
        pulumi.set(__self__, "forward_protected_item_count", forward_protected_item_count)
        pulumi.set(__self__, "health", health)
        pulumi.set(__self__, "health_errors", health_errors)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "last_heartbeat_utc", last_heartbeat_utc)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "reverse_protected_item_count", reverse_protected_item_count)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="biosId")
    def bios_id(self) -> str:
        """
        The DRA Bios Id.
        """
        return pulumi.get(self, "bios_id")

    @property
    @pulumi.getter(name="forwardProtectedItemCount")
    def forward_protected_item_count(self) -> int:
        """
        The count of protected items which are protected in forward direction.
        """
        return pulumi.get(self, "forward_protected_item_count")

    @property
    @pulumi.getter
    def health(self) -> str:
        """
        The health.
        """
        return pulumi.get(self, "health")

    @property
    @pulumi.getter(name="healthErrors")
    def health_errors(self) -> Sequence['outputs.HealthErrorResponse']:
        """
        The health errors.
        """
        return pulumi.get(self, "health_errors")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The DRA Id.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lastHeartbeatUtc")
    def last_heartbeat_utc(self) -> str:
        """
        The last heartbeat received from the DRA.
        """
        return pulumi.get(self, "last_heartbeat_utc")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The DRA name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="reverseProtectedItemCount")
    def reverse_protected_item_count(self) -> int:
        """
        The count of protected items which are protected in reverse direction.
        """
        return pulumi.get(self, "reverse_protected_item_count")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        The version.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class EncryptionDetailsResponse(dict):
    """
    Encryption details for the fabric.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kekCertExpiryDate":
            suggest = "kek_cert_expiry_date"
        elif key == "kekCertThumbprint":
            suggest = "kek_cert_thumbprint"
        elif key == "kekState":
            suggest = "kek_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EncryptionDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EncryptionDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EncryptionDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kek_cert_expiry_date: Optional[str] = None,
                 kek_cert_thumbprint: Optional[str] = None,
                 kek_state: Optional[str] = None):
        """
        Encryption details for the fabric.
        :param str kek_cert_expiry_date: The key encryption key certificate expiry date.
        :param str kek_cert_thumbprint: The key encryption key certificate thumbprint.
        :param str kek_state: The key encryption key state for the Vmm.
        """
        if kek_cert_expiry_date is not None:
            pulumi.set(__self__, "kek_cert_expiry_date", kek_cert_expiry_date)
        if kek_cert_thumbprint is not None:
            pulumi.set(__self__, "kek_cert_thumbprint", kek_cert_thumbprint)
        if kek_state is not None:
            pulumi.set(__self__, "kek_state", kek_state)

    @property
    @pulumi.getter(name="kekCertExpiryDate")
    def kek_cert_expiry_date(self) -> Optional[str]:
        """
        The key encryption key certificate expiry date.
        """
        return pulumi.get(self, "kek_cert_expiry_date")

    @property
    @pulumi.getter(name="kekCertThumbprint")
    def kek_cert_thumbprint(self) -> Optional[str]:
        """
        The key encryption key certificate thumbprint.
        """
        return pulumi.get(self, "kek_cert_thumbprint")

    @property
    @pulumi.getter(name="kekState")
    def kek_state(self) -> Optional[str]:
        """
        The key encryption key state for the Vmm.
        """
        return pulumi.get(self, "kek_state")


@pulumi.output_type
class ExtendedLocationResponse(dict):
    """
    Extended location of the resource.
    """
    def __init__(__self__, *,
                 name: str,
                 type: str):
        """
        Extended location of the resource.
        :param str name: The name of the extended location.
        :param str type: The extended location type.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the extended location.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The extended location type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class FabricPropertiesResponse(dict):
    """
    Fabric properties.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bcdrState":
            suggest = "bcdr_state"
        elif key == "customDetails":
            suggest = "custom_details"
        elif key == "encryptionDetails":
            suggest = "encryption_details"
        elif key == "friendlyName":
            suggest = "friendly_name"
        elif key == "healthErrorDetails":
            suggest = "health_error_details"
        elif key == "internalIdentifier":
            suggest = "internal_identifier"
        elif key == "rolloverEncryptionDetails":
            suggest = "rollover_encryption_details"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FabricPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FabricPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FabricPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bcdr_state: Optional[str] = None,
                 custom_details: Optional[Any] = None,
                 encryption_details: Optional['outputs.EncryptionDetailsResponse'] = None,
                 friendly_name: Optional[str] = None,
                 health: Optional[str] = None,
                 health_error_details: Optional[Sequence['outputs.HealthErrorResponse']] = None,
                 internal_identifier: Optional[str] = None,
                 rollover_encryption_details: Optional['outputs.EncryptionDetailsResponse'] = None):
        """
        Fabric properties.
        :param str bcdr_state: BCDR state of the fabric.
        :param Union['AzureFabricSpecificDetailsResponse', 'HyperVSiteDetailsResponse', 'InMageRcmFabricSpecificDetailsResponse', 'VMwareDetailsResponse', 'VMwareV2FabricSpecificDetailsResponse', 'VmmDetailsResponse'] custom_details: Fabric specific settings.
        :param 'EncryptionDetailsResponse' encryption_details: Encryption details for the fabric.
        :param str friendly_name: Friendly name of the fabric.
        :param str health: Health of fabric.
        :param Sequence['HealthErrorResponse'] health_error_details: Fabric health error details.
        :param str internal_identifier: Dra Registration Id.
        :param 'EncryptionDetailsResponse' rollover_encryption_details: Rollover encryption details for the fabric.
        """
        if bcdr_state is not None:
            pulumi.set(__self__, "bcdr_state", bcdr_state)
        if custom_details is not None:
            pulumi.set(__self__, "custom_details", custom_details)
        if encryption_details is not None:
            pulumi.set(__self__, "encryption_details", encryption_details)
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if health is not None:
            pulumi.set(__self__, "health", health)
        if health_error_details is not None:
            pulumi.set(__self__, "health_error_details", health_error_details)
        if internal_identifier is not None:
            pulumi.set(__self__, "internal_identifier", internal_identifier)
        if rollover_encryption_details is not None:
            pulumi.set(__self__, "rollover_encryption_details", rollover_encryption_details)

    @property
    @pulumi.getter(name="bcdrState")
    def bcdr_state(self) -> Optional[str]:
        """
        BCDR state of the fabric.
        """
        return pulumi.get(self, "bcdr_state")

    @property
    @pulumi.getter(name="customDetails")
    def custom_details(self) -> Optional[Any]:
        """
        Fabric specific settings.
        """
        return pulumi.get(self, "custom_details")

    @property
    @pulumi.getter(name="encryptionDetails")
    def encryption_details(self) -> Optional['outputs.EncryptionDetailsResponse']:
        """
        Encryption details for the fabric.
        """
        return pulumi.get(self, "encryption_details")

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[str]:
        """
        Friendly name of the fabric.
        """
        return pulumi.get(self, "friendly_name")

    @property
    @pulumi.getter
    def health(self) -> Optional[str]:
        """
        Health of fabric.
        """
        return pulumi.get(self, "health")

    @property
    @pulumi.getter(name="healthErrorDetails")
    def health_error_details(self) -> Optional[Sequence['outputs.HealthErrorResponse']]:
        """
        Fabric health error details.
        """
        return pulumi.get(self, "health_error_details")

    @property
    @pulumi.getter(name="internalIdentifier")
    def internal_identifier(self) -> Optional[str]:
        """
        Dra Registration Id.
        """
        return pulumi.get(self, "internal_identifier")

    @property
    @pulumi.getter(name="rolloverEncryptionDetails")
    def rollover_encryption_details(self) -> Optional['outputs.EncryptionDetailsResponse']:
        """
        Rollover encryption details for the fabric.
        """
        return pulumi.get(self, "rollover_encryption_details")


@pulumi.output_type
class HealthErrorResponse(dict):
    """
    Health Error.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "creationTimeUtc":
            suggest = "creation_time_utc"
        elif key == "customerResolvability":
            suggest = "customer_resolvability"
        elif key == "entityId":
            suggest = "entity_id"
        elif key == "errorCategory":
            suggest = "error_category"
        elif key == "errorCode":
            suggest = "error_code"
        elif key == "errorId":
            suggest = "error_id"
        elif key == "errorLevel":
            suggest = "error_level"
        elif key == "errorMessage":
            suggest = "error_message"
        elif key == "errorSource":
            suggest = "error_source"
        elif key == "errorType":
            suggest = "error_type"
        elif key == "innerHealthErrors":
            suggest = "inner_health_errors"
        elif key == "possibleCauses":
            suggest = "possible_causes"
        elif key == "recommendedAction":
            suggest = "recommended_action"
        elif key == "recoveryProviderErrorMessage":
            suggest = "recovery_provider_error_message"
        elif key == "summaryMessage":
            suggest = "summary_message"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HealthErrorResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HealthErrorResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HealthErrorResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 creation_time_utc: Optional[str] = None,
                 customer_resolvability: Optional[str] = None,
                 entity_id: Optional[str] = None,
                 error_category: Optional[str] = None,
                 error_code: Optional[str] = None,
                 error_id: Optional[str] = None,
                 error_level: Optional[str] = None,
                 error_message: Optional[str] = None,
                 error_source: Optional[str] = None,
                 error_type: Optional[str] = None,
                 inner_health_errors: Optional[Sequence['outputs.InnerHealthErrorResponse']] = None,
                 possible_causes: Optional[str] = None,
                 recommended_action: Optional[str] = None,
                 recovery_provider_error_message: Optional[str] = None,
                 summary_message: Optional[str] = None):
        """
        Health Error.
        :param str creation_time_utc: Error creation time (UTC).
        :param str customer_resolvability: Value indicating whether the health error is customer resolvable.
        :param str entity_id: ID of the entity.
        :param str error_category: Category of error.
        :param str error_code: Error code.
        :param str error_id: The health error unique id.
        :param str error_level: Level of error.
        :param str error_message: Error message.
        :param str error_source: Source of error.
        :param str error_type: Type of error.
        :param Sequence['InnerHealthErrorResponse'] inner_health_errors: The inner health errors. HealthError having a list of HealthError as child errors is problematic. InnerHealthError is used because this will prevent an infinite loop of structures when Hydra tries to auto-generate the contract. We are exposing the related health errors as inner health errors and all API consumers can utilize this in the same fashion as Exception -&gt; InnerException.
        :param str possible_causes: Possible causes of error.
        :param str recommended_action: Recommended action to resolve error.
        :param str recovery_provider_error_message: DRA error message.
        :param str summary_message: Summary message of the entity.
        """
        if creation_time_utc is not None:
            pulumi.set(__self__, "creation_time_utc", creation_time_utc)
        if customer_resolvability is not None:
            pulumi.set(__self__, "customer_resolvability", customer_resolvability)
        if entity_id is not None:
            pulumi.set(__self__, "entity_id", entity_id)
        if error_category is not None:
            pulumi.set(__self__, "error_category", error_category)
        if error_code is not None:
            pulumi.set(__self__, "error_code", error_code)
        if error_id is not None:
            pulumi.set(__self__, "error_id", error_id)
        if error_level is not None:
            pulumi.set(__self__, "error_level", error_level)
        if error_message is not None:
            pulumi.set(__self__, "error_message", error_message)
        if error_source is not None:
            pulumi.set(__self__, "error_source", error_source)
        if error_type is not None:
            pulumi.set(__self__, "error_type", error_type)
        if inner_health_errors is not None:
            pulumi.set(__self__, "inner_health_errors", inner_health_errors)
        if possible_causes is not None:
            pulumi.set(__self__, "possible_causes", possible_causes)
        if recommended_action is not None:
            pulumi.set(__self__, "recommended_action", recommended_action)
        if recovery_provider_error_message is not None:
            pulumi.set(__self__, "recovery_provider_error_message", recovery_provider_error_message)
        if summary_message is not None:
            pulumi.set(__self__, "summary_message", summary_message)

    @property
    @pulumi.getter(name="creationTimeUtc")
    def creation_time_utc(self) -> Optional[str]:
        """
        Error creation time (UTC).
        """
        return pulumi.get(self, "creation_time_utc")

    @property
    @pulumi.getter(name="customerResolvability")
    def customer_resolvability(self) -> Optional[str]:
        """
        Value indicating whether the health error is customer resolvable.
        """
        return pulumi.get(self, "customer_resolvability")

    @property
    @pulumi.getter(name="entityId")
    def entity_id(self) -> Optional[str]:
        """
        ID of the entity.
        """
        return pulumi.get(self, "entity_id")

    @property
    @pulumi.getter(name="errorCategory")
    def error_category(self) -> Optional[str]:
        """
        Category of error.
        """
        return pulumi.get(self, "error_category")

    @property
    @pulumi.getter(name="errorCode")
    def error_code(self) -> Optional[str]:
        """
        Error code.
        """
        return pulumi.get(self, "error_code")

    @property
    @pulumi.getter(name="errorId")
    def error_id(self) -> Optional[str]:
        """
        The health error unique id.
        """
        return pulumi.get(self, "error_id")

    @property
    @pulumi.getter(name="errorLevel")
    def error_level(self) -> Optional[str]:
        """
        Level of error.
        """
        return pulumi.get(self, "error_level")

    @property
    @pulumi.getter(name="errorMessage")
    def error_message(self) -> Optional[str]:
        """
        Error message.
        """
        return pulumi.get(self, "error_message")

    @property
    @pulumi.getter(name="errorSource")
    def error_source(self) -> Optional[str]:
        """
        Source of error.
        """
        return pulumi.get(self, "error_source")

    @property
    @pulumi.getter(name="errorType")
    def error_type(self) -> Optional[str]:
        """
        Type of error.
        """
        return pulumi.get(self, "error_type")

    @property
    @pulumi.getter(name="innerHealthErrors")
    def inner_health_errors(self) -> Optional[Sequence['outputs.InnerHealthErrorResponse']]:
        """
        The inner health errors. HealthError having a list of HealthError as child errors is problematic. InnerHealthError is used because this will prevent an infinite loop of structures when Hydra tries to auto-generate the contract. We are exposing the related health errors as inner health errors and all API consumers can utilize this in the same fashion as Exception -&gt; InnerException.
        """
        return pulumi.get(self, "inner_health_errors")

    @property
    @pulumi.getter(name="possibleCauses")
    def possible_causes(self) -> Optional[str]:
        """
        Possible causes of error.
        """
        return pulumi.get(self, "possible_causes")

    @property
    @pulumi.getter(name="recommendedAction")
    def recommended_action(self) -> Optional[str]:
        """
        Recommended action to resolve error.
        """
        return pulumi.get(self, "recommended_action")

    @property
    @pulumi.getter(name="recoveryProviderErrorMessage")
    def recovery_provider_error_message(self) -> Optional[str]:
        """
        DRA error message.
        """
        return pulumi.get(self, "recovery_provider_error_message")

    @property
    @pulumi.getter(name="summaryMessage")
    def summary_message(self) -> Optional[str]:
        """
        Summary message of the entity.
        """
        return pulumi.get(self, "summary_message")


@pulumi.output_type
class HyperVHostDetailsResponse(dict):
    """
    Hyper-V host details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "marsAgentVersion":
            suggest = "mars_agent_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HyperVHostDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HyperVHostDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HyperVHostDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: str,
                 mars_agent_version: str,
                 name: str):
        """
        Hyper-V host details.
        :param str id: The Hyper-V host Id.
        :param str mars_agent_version: The Mars agent version.
        :param str name: The Hyper-V host name.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "mars_agent_version", mars_agent_version)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The Hyper-V host Id.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="marsAgentVersion")
    def mars_agent_version(self) -> str:
        """
        The Mars agent version.
        """
        return pulumi.get(self, "mars_agent_version")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The Hyper-V host name.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class HyperVReplicaAzureManagedDiskDetailsResponse(dict):
    """
    Hyper-V Managed disk details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "diskEncryptionSetId":
            suggest = "disk_encryption_set_id"
        elif key == "diskId":
            suggest = "disk_id"
        elif key == "replicaDiskType":
            suggest = "replica_disk_type"
        elif key == "seedManagedDiskId":
            suggest = "seed_managed_disk_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HyperVReplicaAzureManagedDiskDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HyperVReplicaAzureManagedDiskDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HyperVReplicaAzureManagedDiskDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disk_encryption_set_id: Optional[str] = None,
                 disk_id: Optional[str] = None,
                 replica_disk_type: Optional[str] = None,
                 seed_managed_disk_id: Optional[str] = None):
        """
        Hyper-V Managed disk details.
        :param str disk_encryption_set_id: The disk encryption set ARM Id.
        :param str disk_id: The disk Id.
        :param str replica_disk_type: The replica disk type.
        :param str seed_managed_disk_id: Seed managed disk Id.
        """
        if disk_encryption_set_id is not None:
            pulumi.set(__self__, "disk_encryption_set_id", disk_encryption_set_id)
        if disk_id is not None:
            pulumi.set(__self__, "disk_id", disk_id)
        if replica_disk_type is not None:
            pulumi.set(__self__, "replica_disk_type", replica_disk_type)
        if seed_managed_disk_id is not None:
            pulumi.set(__self__, "seed_managed_disk_id", seed_managed_disk_id)

    @property
    @pulumi.getter(name="diskEncryptionSetId")
    def disk_encryption_set_id(self) -> Optional[str]:
        """
        The disk encryption set ARM Id.
        """
        return pulumi.get(self, "disk_encryption_set_id")

    @property
    @pulumi.getter(name="diskId")
    def disk_id(self) -> Optional[str]:
        """
        The disk Id.
        """
        return pulumi.get(self, "disk_id")

    @property
    @pulumi.getter(name="replicaDiskType")
    def replica_disk_type(self) -> Optional[str]:
        """
        The replica disk type.
        """
        return pulumi.get(self, "replica_disk_type")

    @property
    @pulumi.getter(name="seedManagedDiskId")
    def seed_managed_disk_id(self) -> Optional[str]:
        """
        Seed managed disk Id.
        """
        return pulumi.get(self, "seed_managed_disk_id")


@pulumi.output_type
class HyperVReplicaAzurePolicyDetailsResponse(dict):
    """
    Hyper-V Replica Azure specific protection profile details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceType":
            suggest = "instance_type"
        elif key == "activeStorageAccountId":
            suggest = "active_storage_account_id"
        elif key == "applicationConsistentSnapshotFrequencyInHours":
            suggest = "application_consistent_snapshot_frequency_in_hours"
        elif key == "onlineReplicationStartTime":
            suggest = "online_replication_start_time"
        elif key == "recoveryPointHistoryDurationInHours":
            suggest = "recovery_point_history_duration_in_hours"
        elif key == "replicationInterval":
            suggest = "replication_interval"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HyperVReplicaAzurePolicyDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HyperVReplicaAzurePolicyDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HyperVReplicaAzurePolicyDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_type: str,
                 active_storage_account_id: Optional[str] = None,
                 application_consistent_snapshot_frequency_in_hours: Optional[int] = None,
                 encryption: Optional[str] = None,
                 online_replication_start_time: Optional[str] = None,
                 recovery_point_history_duration_in_hours: Optional[int] = None,
                 replication_interval: Optional[int] = None):
        """
        Hyper-V Replica Azure specific protection profile details.
        :param str instance_type: Gets the class type. Overridden in derived classes.
               Expected value is 'HyperVReplicaAzure'.
        :param str active_storage_account_id: The active storage account Id.
        :param int application_consistent_snapshot_frequency_in_hours: The interval (in hours) at which Hyper-V Replica should create an application consistent snapshot within the VM.
        :param str encryption: A value indicating whether encryption is enabled for virtual machines in this cloud.
        :param str online_replication_start_time: The scheduled start time for the initial replication. If this parameter is Null, the initial replication starts immediately.
        :param int recovery_point_history_duration_in_hours: The duration (in hours) to which point the recovery history needs to be maintained.
        :param int replication_interval: The replication interval.
        """
        pulumi.set(__self__, "instance_type", 'HyperVReplicaAzure')
        if active_storage_account_id is not None:
            pulumi.set(__self__, "active_storage_account_id", active_storage_account_id)
        if application_consistent_snapshot_frequency_in_hours is not None:
            pulumi.set(__self__, "application_consistent_snapshot_frequency_in_hours", application_consistent_snapshot_frequency_in_hours)
        if encryption is not None:
            pulumi.set(__self__, "encryption", encryption)
        if online_replication_start_time is not None:
            pulumi.set(__self__, "online_replication_start_time", online_replication_start_time)
        if recovery_point_history_duration_in_hours is not None:
            pulumi.set(__self__, "recovery_point_history_duration_in_hours", recovery_point_history_duration_in_hours)
        if replication_interval is not None:
            pulumi.set(__self__, "replication_interval", replication_interval)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> str:
        """
        Gets the class type. Overridden in derived classes.
        Expected value is 'HyperVReplicaAzure'.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="activeStorageAccountId")
    def active_storage_account_id(self) -> Optional[str]:
        """
        The active storage account Id.
        """
        return pulumi.get(self, "active_storage_account_id")

    @property
    @pulumi.getter(name="applicationConsistentSnapshotFrequencyInHours")
    def application_consistent_snapshot_frequency_in_hours(self) -> Optional[int]:
        """
        The interval (in hours) at which Hyper-V Replica should create an application consistent snapshot within the VM.
        """
        return pulumi.get(self, "application_consistent_snapshot_frequency_in_hours")

    @property
    @pulumi.getter
    def encryption(self) -> Optional[str]:
        """
        A value indicating whether encryption is enabled for virtual machines in this cloud.
        """
        return pulumi.get(self, "encryption")

    @property
    @pulumi.getter(name="onlineReplicationStartTime")
    def online_replication_start_time(self) -> Optional[str]:
        """
        The scheduled start time for the initial replication. If this parameter is Null, the initial replication starts immediately.
        """
        return pulumi.get(self, "online_replication_start_time")

    @property
    @pulumi.getter(name="recoveryPointHistoryDurationInHours")
    def recovery_point_history_duration_in_hours(self) -> Optional[int]:
        """
        The duration (in hours) to which point the recovery history needs to be maintained.
        """
        return pulumi.get(self, "recovery_point_history_duration_in_hours")

    @property
    @pulumi.getter(name="replicationInterval")
    def replication_interval(self) -> Optional[int]:
        """
        The replication interval.
        """
        return pulumi.get(self, "replication_interval")


@pulumi.output_type
class HyperVReplicaAzureReplicationDetailsResponse(dict):
    """
    Hyper V Replica Azure provider specific settings.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceType":
            suggest = "instance_type"
        elif key == "lastRecoveryPointReceived":
            suggest = "last_recovery_point_received"
        elif key == "azureVmDiskDetails":
            suggest = "azure_vm_disk_details"
        elif key == "enableRdpOnTargetOption":
            suggest = "enable_rdp_on_target_option"
        elif key == "initialReplicationDetails":
            suggest = "initial_replication_details"
        elif key == "lastReplicatedTime":
            suggest = "last_replicated_time"
        elif key == "lastRpoCalculatedTime":
            suggest = "last_rpo_calculated_time"
        elif key == "licenseType":
            suggest = "license_type"
        elif key == "oSDetails":
            suggest = "o_s_details"
        elif key == "protectedManagedDisks":
            suggest = "protected_managed_disks"
        elif key == "recoveryAvailabilitySetId":
            suggest = "recovery_availability_set_id"
        elif key == "recoveryAzureLogStorageAccountId":
            suggest = "recovery_azure_log_storage_account_id"
        elif key == "recoveryAzureResourceGroupId":
            suggest = "recovery_azure_resource_group_id"
        elif key == "recoveryAzureStorageAccount":
            suggest = "recovery_azure_storage_account"
        elif key == "recoveryAzureVMSize":
            suggest = "recovery_azure_vm_size"
        elif key == "recoveryAzureVmName":
            suggest = "recovery_azure_vm_name"
        elif key == "rpoInSeconds":
            suggest = "rpo_in_seconds"
        elif key == "seedManagedDiskTags":
            suggest = "seed_managed_disk_tags"
        elif key == "selectedRecoveryAzureNetworkId":
            suggest = "selected_recovery_azure_network_id"
        elif key == "selectedSourceNicId":
            suggest = "selected_source_nic_id"
        elif key == "sourceVmCpuCount":
            suggest = "source_vm_cpu_count"
        elif key == "sourceVmRamSizeInMB":
            suggest = "source_vm_ram_size_in_mb"
        elif key == "sqlServerLicenseType":
            suggest = "sql_server_license_type"
        elif key == "targetAvailabilityZone":
            suggest = "target_availability_zone"
        elif key == "targetManagedDiskTags":
            suggest = "target_managed_disk_tags"
        elif key == "targetNicTags":
            suggest = "target_nic_tags"
        elif key == "targetProximityPlacementGroupId":
            suggest = "target_proximity_placement_group_id"
        elif key == "targetVmTags":
            suggest = "target_vm_tags"
        elif key == "useManagedDisks":
            suggest = "use_managed_disks"
        elif key == "vmId":
            suggest = "vm_id"
        elif key == "vmNics":
            suggest = "vm_nics"
        elif key == "vmProtectionState":
            suggest = "vm_protection_state"
        elif key == "vmProtectionStateDescription":
            suggest = "vm_protection_state_description"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HyperVReplicaAzureReplicationDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HyperVReplicaAzureReplicationDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HyperVReplicaAzureReplicationDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_type: str,
                 last_recovery_point_received: str,
                 azure_vm_disk_details: Optional[Sequence['outputs.AzureVmDiskDetailsResponse']] = None,
                 enable_rdp_on_target_option: Optional[str] = None,
                 encryption: Optional[str] = None,
                 initial_replication_details: Optional['outputs.InitialReplicationDetailsResponse'] = None,
                 last_replicated_time: Optional[str] = None,
                 last_rpo_calculated_time: Optional[str] = None,
                 license_type: Optional[str] = None,
                 o_s_details: Optional['outputs.OSDetailsResponse'] = None,
                 protected_managed_disks: Optional[Sequence['outputs.HyperVReplicaAzureManagedDiskDetailsResponse']] = None,
                 recovery_availability_set_id: Optional[str] = None,
                 recovery_azure_log_storage_account_id: Optional[str] = None,
                 recovery_azure_resource_group_id: Optional[str] = None,
                 recovery_azure_storage_account: Optional[str] = None,
                 recovery_azure_vm_size: Optional[str] = None,
                 recovery_azure_vm_name: Optional[str] = None,
                 rpo_in_seconds: Optional[float] = None,
                 seed_managed_disk_tags: Optional[Mapping[str, str]] = None,
                 selected_recovery_azure_network_id: Optional[str] = None,
                 selected_source_nic_id: Optional[str] = None,
                 source_vm_cpu_count: Optional[int] = None,
                 source_vm_ram_size_in_mb: Optional[int] = None,
                 sql_server_license_type: Optional[str] = None,
                 target_availability_zone: Optional[str] = None,
                 target_managed_disk_tags: Optional[Mapping[str, str]] = None,
                 target_nic_tags: Optional[Mapping[str, str]] = None,
                 target_proximity_placement_group_id: Optional[str] = None,
                 target_vm_tags: Optional[Mapping[str, str]] = None,
                 use_managed_disks: Optional[str] = None,
                 vm_id: Optional[str] = None,
                 vm_nics: Optional[Sequence['outputs.VMNicDetailsResponse']] = None,
                 vm_protection_state: Optional[str] = None,
                 vm_protection_state_description: Optional[str] = None):
        """
        Hyper V Replica Azure provider specific settings.
        :param str instance_type: Gets the Instance type.
               Expected value is 'HyperVReplicaAzure'.
        :param str last_recovery_point_received: The last recovery point received time.
        :param Sequence['AzureVmDiskDetailsResponse'] azure_vm_disk_details: Azure VM Disk details.
        :param str enable_rdp_on_target_option: The selected option to enable RDP\\SSH on target vm after failover. String value of SrsDataContract.EnableRDPOnTargetOption enum.
        :param str encryption: The encryption info.
        :param 'InitialReplicationDetailsResponse' initial_replication_details: Initial replication details.
        :param str last_replicated_time: The Last replication time.
        :param str last_rpo_calculated_time: The last RPO calculated time.
        :param str license_type: License Type of the VM to be used.
        :param 'OSDetailsResponse' o_s_details: The operating system info.
        :param Sequence['HyperVReplicaAzureManagedDiskDetailsResponse'] protected_managed_disks: The list of protected managed disks.
        :param str recovery_availability_set_id: The recovery availability set Id.
        :param str recovery_azure_log_storage_account_id: The ARM id of the log storage account used for replication. This will be set to null if no log storage account was provided during enable protection.
        :param str recovery_azure_resource_group_id: The target resource group Id.
        :param str recovery_azure_storage_account: The recovery Azure storage account.
        :param str recovery_azure_vm_size: The Recovery Azure VM size.
        :param str recovery_azure_vm_name: Recovery Azure given name.
        :param float rpo_in_seconds: Last RPO value.
        :param Mapping[str, str] seed_managed_disk_tags: The tags for the seed managed disks.
        :param str selected_recovery_azure_network_id: The selected recovery azure network Id.
        :param str selected_source_nic_id: The selected source nic Id which will be used as the primary nic during failover.
        :param int source_vm_cpu_count: The CPU count of the VM on the primary side.
        :param int source_vm_ram_size_in_mb: The RAM size of the VM on the primary side.
        :param str sql_server_license_type: The SQL Server license type.
        :param str target_availability_zone: The target availability zone.
        :param Mapping[str, str] target_managed_disk_tags: The tags for the target managed disks.
        :param Mapping[str, str] target_nic_tags: The tags for the target NICs.
        :param str target_proximity_placement_group_id: The target proximity placement group Id.
        :param Mapping[str, str] target_vm_tags: The target VM tags.
        :param str use_managed_disks: A value indicating whether managed disks should be used during failover.
        :param str vm_id: The virtual machine Id.
        :param Sequence['VMNicDetailsResponse'] vm_nics: The PE Network details.
        :param str vm_protection_state: The protection state for the vm.
        :param str vm_protection_state_description: The protection state description for the vm.
        """
        pulumi.set(__self__, "instance_type", 'HyperVReplicaAzure')
        pulumi.set(__self__, "last_recovery_point_received", last_recovery_point_received)
        if azure_vm_disk_details is not None:
            pulumi.set(__self__, "azure_vm_disk_details", azure_vm_disk_details)
        if enable_rdp_on_target_option is not None:
            pulumi.set(__self__, "enable_rdp_on_target_option", enable_rdp_on_target_option)
        if encryption is not None:
            pulumi.set(__self__, "encryption", encryption)
        if initial_replication_details is not None:
            pulumi.set(__self__, "initial_replication_details", initial_replication_details)
        if last_replicated_time is not None:
            pulumi.set(__self__, "last_replicated_time", last_replicated_time)
        if last_rpo_calculated_time is not None:
            pulumi.set(__self__, "last_rpo_calculated_time", last_rpo_calculated_time)
        if license_type is not None:
            pulumi.set(__self__, "license_type", license_type)
        if o_s_details is not None:
            pulumi.set(__self__, "o_s_details", o_s_details)
        if protected_managed_disks is not None:
            pulumi.set(__self__, "protected_managed_disks", protected_managed_disks)
        if recovery_availability_set_id is not None:
            pulumi.set(__self__, "recovery_availability_set_id", recovery_availability_set_id)
        if recovery_azure_log_storage_account_id is not None:
            pulumi.set(__self__, "recovery_azure_log_storage_account_id", recovery_azure_log_storage_account_id)
        if recovery_azure_resource_group_id is not None:
            pulumi.set(__self__, "recovery_azure_resource_group_id", recovery_azure_resource_group_id)
        if recovery_azure_storage_account is not None:
            pulumi.set(__self__, "recovery_azure_storage_account", recovery_azure_storage_account)
        if recovery_azure_vm_size is not None:
            pulumi.set(__self__, "recovery_azure_vm_size", recovery_azure_vm_size)
        if recovery_azure_vm_name is not None:
            pulumi.set(__self__, "recovery_azure_vm_name", recovery_azure_vm_name)
        if rpo_in_seconds is not None:
            pulumi.set(__self__, "rpo_in_seconds", rpo_in_seconds)
        if seed_managed_disk_tags is not None:
            pulumi.set(__self__, "seed_managed_disk_tags", seed_managed_disk_tags)
        if selected_recovery_azure_network_id is not None:
            pulumi.set(__self__, "selected_recovery_azure_network_id", selected_recovery_azure_network_id)
        if selected_source_nic_id is not None:
            pulumi.set(__self__, "selected_source_nic_id", selected_source_nic_id)
        if source_vm_cpu_count is not None:
            pulumi.set(__self__, "source_vm_cpu_count", source_vm_cpu_count)
        if source_vm_ram_size_in_mb is not None:
            pulumi.set(__self__, "source_vm_ram_size_in_mb", source_vm_ram_size_in_mb)
        if sql_server_license_type is not None:
            pulumi.set(__self__, "sql_server_license_type", sql_server_license_type)
        if target_availability_zone is not None:
            pulumi.set(__self__, "target_availability_zone", target_availability_zone)
        if target_managed_disk_tags is not None:
            pulumi.set(__self__, "target_managed_disk_tags", target_managed_disk_tags)
        if target_nic_tags is not None:
            pulumi.set(__self__, "target_nic_tags", target_nic_tags)
        if target_proximity_placement_group_id is not None:
            pulumi.set(__self__, "target_proximity_placement_group_id", target_proximity_placement_group_id)
        if target_vm_tags is not None:
            pulumi.set(__self__, "target_vm_tags", target_vm_tags)
        if use_managed_disks is not None:
            pulumi.set(__self__, "use_managed_disks", use_managed_disks)
        if vm_id is not None:
            pulumi.set(__self__, "vm_id", vm_id)
        if vm_nics is not None:
            pulumi.set(__self__, "vm_nics", vm_nics)
        if vm_protection_state is not None:
            pulumi.set(__self__, "vm_protection_state", vm_protection_state)
        if vm_protection_state_description is not None:
            pulumi.set(__self__, "vm_protection_state_description", vm_protection_state_description)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> str:
        """
        Gets the Instance type.
        Expected value is 'HyperVReplicaAzure'.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="lastRecoveryPointReceived")
    def last_recovery_point_received(self) -> str:
        """
        The last recovery point received time.
        """
        return pulumi.get(self, "last_recovery_point_received")

    @property
    @pulumi.getter(name="azureVmDiskDetails")
    def azure_vm_disk_details(self) -> Optional[Sequence['outputs.AzureVmDiskDetailsResponse']]:
        """
        Azure VM Disk details.
        """
        return pulumi.get(self, "azure_vm_disk_details")

    @property
    @pulumi.getter(name="enableRdpOnTargetOption")
    def enable_rdp_on_target_option(self) -> Optional[str]:
        """
        The selected option to enable RDP\\SSH on target vm after failover. String value of SrsDataContract.EnableRDPOnTargetOption enum.
        """
        return pulumi.get(self, "enable_rdp_on_target_option")

    @property
    @pulumi.getter
    def encryption(self) -> Optional[str]:
        """
        The encryption info.
        """
        return pulumi.get(self, "encryption")

    @property
    @pulumi.getter(name="initialReplicationDetails")
    def initial_replication_details(self) -> Optional['outputs.InitialReplicationDetailsResponse']:
        """
        Initial replication details.
        """
        return pulumi.get(self, "initial_replication_details")

    @property
    @pulumi.getter(name="lastReplicatedTime")
    def last_replicated_time(self) -> Optional[str]:
        """
        The Last replication time.
        """
        return pulumi.get(self, "last_replicated_time")

    @property
    @pulumi.getter(name="lastRpoCalculatedTime")
    def last_rpo_calculated_time(self) -> Optional[str]:
        """
        The last RPO calculated time.
        """
        return pulumi.get(self, "last_rpo_calculated_time")

    @property
    @pulumi.getter(name="licenseType")
    def license_type(self) -> Optional[str]:
        """
        License Type of the VM to be used.
        """
        return pulumi.get(self, "license_type")

    @property
    @pulumi.getter(name="oSDetails")
    def o_s_details(self) -> Optional['outputs.OSDetailsResponse']:
        """
        The operating system info.
        """
        return pulumi.get(self, "o_s_details")

    @property
    @pulumi.getter(name="protectedManagedDisks")
    def protected_managed_disks(self) -> Optional[Sequence['outputs.HyperVReplicaAzureManagedDiskDetailsResponse']]:
        """
        The list of protected managed disks.
        """
        return pulumi.get(self, "protected_managed_disks")

    @property
    @pulumi.getter(name="recoveryAvailabilitySetId")
    def recovery_availability_set_id(self) -> Optional[str]:
        """
        The recovery availability set Id.
        """
        return pulumi.get(self, "recovery_availability_set_id")

    @property
    @pulumi.getter(name="recoveryAzureLogStorageAccountId")
    def recovery_azure_log_storage_account_id(self) -> Optional[str]:
        """
        The ARM id of the log storage account used for replication. This will be set to null if no log storage account was provided during enable protection.
        """
        return pulumi.get(self, "recovery_azure_log_storage_account_id")

    @property
    @pulumi.getter(name="recoveryAzureResourceGroupId")
    def recovery_azure_resource_group_id(self) -> Optional[str]:
        """
        The target resource group Id.
        """
        return pulumi.get(self, "recovery_azure_resource_group_id")

    @property
    @pulumi.getter(name="recoveryAzureStorageAccount")
    def recovery_azure_storage_account(self) -> Optional[str]:
        """
        The recovery Azure storage account.
        """
        return pulumi.get(self, "recovery_azure_storage_account")

    @property
    @pulumi.getter(name="recoveryAzureVMSize")
    def recovery_azure_vm_size(self) -> Optional[str]:
        """
        The Recovery Azure VM size.
        """
        return pulumi.get(self, "recovery_azure_vm_size")

    @property
    @pulumi.getter(name="recoveryAzureVmName")
    def recovery_azure_vm_name(self) -> Optional[str]:
        """
        Recovery Azure given name.
        """
        return pulumi.get(self, "recovery_azure_vm_name")

    @property
    @pulumi.getter(name="rpoInSeconds")
    def rpo_in_seconds(self) -> Optional[float]:
        """
        Last RPO value.
        """
        return pulumi.get(self, "rpo_in_seconds")

    @property
    @pulumi.getter(name="seedManagedDiskTags")
    def seed_managed_disk_tags(self) -> Optional[Mapping[str, str]]:
        """
        The tags for the seed managed disks.
        """
        return pulumi.get(self, "seed_managed_disk_tags")

    @property
    @pulumi.getter(name="selectedRecoveryAzureNetworkId")
    def selected_recovery_azure_network_id(self) -> Optional[str]:
        """
        The selected recovery azure network Id.
        """
        return pulumi.get(self, "selected_recovery_azure_network_id")

    @property
    @pulumi.getter(name="selectedSourceNicId")
    def selected_source_nic_id(self) -> Optional[str]:
        """
        The selected source nic Id which will be used as the primary nic during failover.
        """
        return pulumi.get(self, "selected_source_nic_id")

    @property
    @pulumi.getter(name="sourceVmCpuCount")
    def source_vm_cpu_count(self) -> Optional[int]:
        """
        The CPU count of the VM on the primary side.
        """
        return pulumi.get(self, "source_vm_cpu_count")

    @property
    @pulumi.getter(name="sourceVmRamSizeInMB")
    def source_vm_ram_size_in_mb(self) -> Optional[int]:
        """
        The RAM size of the VM on the primary side.
        """
        return pulumi.get(self, "source_vm_ram_size_in_mb")

    @property
    @pulumi.getter(name="sqlServerLicenseType")
    def sql_server_license_type(self) -> Optional[str]:
        """
        The SQL Server license type.
        """
        return pulumi.get(self, "sql_server_license_type")

    @property
    @pulumi.getter(name="targetAvailabilityZone")
    def target_availability_zone(self) -> Optional[str]:
        """
        The target availability zone.
        """
        return pulumi.get(self, "target_availability_zone")

    @property
    @pulumi.getter(name="targetManagedDiskTags")
    def target_managed_disk_tags(self) -> Optional[Mapping[str, str]]:
        """
        The tags for the target managed disks.
        """
        return pulumi.get(self, "target_managed_disk_tags")

    @property
    @pulumi.getter(name="targetNicTags")
    def target_nic_tags(self) -> Optional[Mapping[str, str]]:
        """
        The tags for the target NICs.
        """
        return pulumi.get(self, "target_nic_tags")

    @property
    @pulumi.getter(name="targetProximityPlacementGroupId")
    def target_proximity_placement_group_id(self) -> Optional[str]:
        """
        The target proximity placement group Id.
        """
        return pulumi.get(self, "target_proximity_placement_group_id")

    @property
    @pulumi.getter(name="targetVmTags")
    def target_vm_tags(self) -> Optional[Mapping[str, str]]:
        """
        The target VM tags.
        """
        return pulumi.get(self, "target_vm_tags")

    @property
    @pulumi.getter(name="useManagedDisks")
    def use_managed_disks(self) -> Optional[str]:
        """
        A value indicating whether managed disks should be used during failover.
        """
        return pulumi.get(self, "use_managed_disks")

    @property
    @pulumi.getter(name="vmId")
    def vm_id(self) -> Optional[str]:
        """
        The virtual machine Id.
        """
        return pulumi.get(self, "vm_id")

    @property
    @pulumi.getter(name="vmNics")
    def vm_nics(self) -> Optional[Sequence['outputs.VMNicDetailsResponse']]:
        """
        The PE Network details.
        """
        return pulumi.get(self, "vm_nics")

    @property
    @pulumi.getter(name="vmProtectionState")
    def vm_protection_state(self) -> Optional[str]:
        """
        The protection state for the vm.
        """
        return pulumi.get(self, "vm_protection_state")

    @property
    @pulumi.getter(name="vmProtectionStateDescription")
    def vm_protection_state_description(self) -> Optional[str]:
        """
        The protection state description for the vm.
        """
        return pulumi.get(self, "vm_protection_state_description")


@pulumi.output_type
class HyperVReplicaBasePolicyDetailsResponse(dict):
    """
    Base class for HyperVReplica policy details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceType":
            suggest = "instance_type"
        elif key == "allowedAuthenticationType":
            suggest = "allowed_authentication_type"
        elif key == "applicationConsistentSnapshotFrequencyInHours":
            suggest = "application_consistent_snapshot_frequency_in_hours"
        elif key == "initialReplicationMethod":
            suggest = "initial_replication_method"
        elif key == "offlineReplicationExportPath":
            suggest = "offline_replication_export_path"
        elif key == "offlineReplicationImportPath":
            suggest = "offline_replication_import_path"
        elif key == "onlineReplicationStartTime":
            suggest = "online_replication_start_time"
        elif key == "recoveryPoints":
            suggest = "recovery_points"
        elif key == "replicaDeletionOption":
            suggest = "replica_deletion_option"
        elif key == "replicationPort":
            suggest = "replication_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HyperVReplicaBasePolicyDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HyperVReplicaBasePolicyDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HyperVReplicaBasePolicyDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_type: str,
                 allowed_authentication_type: Optional[int] = None,
                 application_consistent_snapshot_frequency_in_hours: Optional[int] = None,
                 compression: Optional[str] = None,
                 initial_replication_method: Optional[str] = None,
                 offline_replication_export_path: Optional[str] = None,
                 offline_replication_import_path: Optional[str] = None,
                 online_replication_start_time: Optional[str] = None,
                 recovery_points: Optional[int] = None,
                 replica_deletion_option: Optional[str] = None,
                 replication_port: Optional[int] = None):
        """
        Base class for HyperVReplica policy details.
        :param str instance_type: Gets the class type. Overridden in derived classes.
               Expected value is 'HyperVReplicaBasePolicyDetails'.
        :param int allowed_authentication_type: A value indicating the authentication type.
        :param int application_consistent_snapshot_frequency_in_hours: A value indicating the application consistent frequency.
        :param str compression: A value indicating whether compression has to be enabled.
        :param str initial_replication_method: A value indicating whether IR is online.
        :param str offline_replication_export_path: A value indicating the offline IR export path.
        :param str offline_replication_import_path: A value indicating the offline IR import path.
        :param str online_replication_start_time: A value indicating the online IR start time.
        :param int recovery_points: A value indicating the number of recovery points.
        :param str replica_deletion_option: A value indicating whether the VM has to be auto deleted. Supported Values: String.Empty, None, OnRecoveryCloud.
        :param int replication_port: A value indicating the recovery HTTPS port.
        """
        pulumi.set(__self__, "instance_type", 'HyperVReplicaBasePolicyDetails')
        if allowed_authentication_type is not None:
            pulumi.set(__self__, "allowed_authentication_type", allowed_authentication_type)
        if application_consistent_snapshot_frequency_in_hours is not None:
            pulumi.set(__self__, "application_consistent_snapshot_frequency_in_hours", application_consistent_snapshot_frequency_in_hours)
        if compression is not None:
            pulumi.set(__self__, "compression", compression)
        if initial_replication_method is not None:
            pulumi.set(__self__, "initial_replication_method", initial_replication_method)
        if offline_replication_export_path is not None:
            pulumi.set(__self__, "offline_replication_export_path", offline_replication_export_path)
        if offline_replication_import_path is not None:
            pulumi.set(__self__, "offline_replication_import_path", offline_replication_import_path)
        if online_replication_start_time is not None:
            pulumi.set(__self__, "online_replication_start_time", online_replication_start_time)
        if recovery_points is not None:
            pulumi.set(__self__, "recovery_points", recovery_points)
        if replica_deletion_option is not None:
            pulumi.set(__self__, "replica_deletion_option", replica_deletion_option)
        if replication_port is not None:
            pulumi.set(__self__, "replication_port", replication_port)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> str:
        """
        Gets the class type. Overridden in derived classes.
        Expected value is 'HyperVReplicaBasePolicyDetails'.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="allowedAuthenticationType")
    def allowed_authentication_type(self) -> Optional[int]:
        """
        A value indicating the authentication type.
        """
        return pulumi.get(self, "allowed_authentication_type")

    @property
    @pulumi.getter(name="applicationConsistentSnapshotFrequencyInHours")
    def application_consistent_snapshot_frequency_in_hours(self) -> Optional[int]:
        """
        A value indicating the application consistent frequency.
        """
        return pulumi.get(self, "application_consistent_snapshot_frequency_in_hours")

    @property
    @pulumi.getter
    def compression(self) -> Optional[str]:
        """
        A value indicating whether compression has to be enabled.
        """
        return pulumi.get(self, "compression")

    @property
    @pulumi.getter(name="initialReplicationMethod")
    def initial_replication_method(self) -> Optional[str]:
        """
        A value indicating whether IR is online.
        """
        return pulumi.get(self, "initial_replication_method")

    @property
    @pulumi.getter(name="offlineReplicationExportPath")
    def offline_replication_export_path(self) -> Optional[str]:
        """
        A value indicating the offline IR export path.
        """
        return pulumi.get(self, "offline_replication_export_path")

    @property
    @pulumi.getter(name="offlineReplicationImportPath")
    def offline_replication_import_path(self) -> Optional[str]:
        """
        A value indicating the offline IR import path.
        """
        return pulumi.get(self, "offline_replication_import_path")

    @property
    @pulumi.getter(name="onlineReplicationStartTime")
    def online_replication_start_time(self) -> Optional[str]:
        """
        A value indicating the online IR start time.
        """
        return pulumi.get(self, "online_replication_start_time")

    @property
    @pulumi.getter(name="recoveryPoints")
    def recovery_points(self) -> Optional[int]:
        """
        A value indicating the number of recovery points.
        """
        return pulumi.get(self, "recovery_points")

    @property
    @pulumi.getter(name="replicaDeletionOption")
    def replica_deletion_option(self) -> Optional[str]:
        """
        A value indicating whether the VM has to be auto deleted. Supported Values: String.Empty, None, OnRecoveryCloud.
        """
        return pulumi.get(self, "replica_deletion_option")

    @property
    @pulumi.getter(name="replicationPort")
    def replication_port(self) -> Optional[int]:
        """
        A value indicating the recovery HTTPS port.
        """
        return pulumi.get(self, "replication_port")


@pulumi.output_type
class HyperVReplicaBaseReplicationDetailsResponse(dict):
    """
    Hyper V replica provider specific settings base class.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceType":
            suggest = "instance_type"
        elif key == "initialReplicationDetails":
            suggest = "initial_replication_details"
        elif key == "lastReplicatedTime":
            suggest = "last_replicated_time"
        elif key == "vMDiskDetails":
            suggest = "v_m_disk_details"
        elif key == "vmId":
            suggest = "vm_id"
        elif key == "vmNics":
            suggest = "vm_nics"
        elif key == "vmProtectionState":
            suggest = "vm_protection_state"
        elif key == "vmProtectionStateDescription":
            suggest = "vm_protection_state_description"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HyperVReplicaBaseReplicationDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HyperVReplicaBaseReplicationDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HyperVReplicaBaseReplicationDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_type: str,
                 initial_replication_details: Optional['outputs.InitialReplicationDetailsResponse'] = None,
                 last_replicated_time: Optional[str] = None,
                 v_m_disk_details: Optional[Sequence['outputs.DiskDetailsResponse']] = None,
                 vm_id: Optional[str] = None,
                 vm_nics: Optional[Sequence['outputs.VMNicDetailsResponse']] = None,
                 vm_protection_state: Optional[str] = None,
                 vm_protection_state_description: Optional[str] = None):
        """
        Hyper V replica provider specific settings base class.
        :param str instance_type: Gets the Instance type.
               Expected value is 'HyperVReplicaBaseReplicationDetails'.
        :param 'InitialReplicationDetailsResponse' initial_replication_details: Initial replication details.
        :param str last_replicated_time: The Last replication time.
        :param Sequence['DiskDetailsResponse'] v_m_disk_details: VM disk details.
        :param str vm_id: The virtual machine Id.
        :param Sequence['VMNicDetailsResponse'] vm_nics: The PE Network details.
        :param str vm_protection_state: The protection state for the vm.
        :param str vm_protection_state_description: The protection state description for the vm.
        """
        pulumi.set(__self__, "instance_type", 'HyperVReplicaBaseReplicationDetails')
        if initial_replication_details is not None:
            pulumi.set(__self__, "initial_replication_details", initial_replication_details)
        if last_replicated_time is not None:
            pulumi.set(__self__, "last_replicated_time", last_replicated_time)
        if v_m_disk_details is not None:
            pulumi.set(__self__, "v_m_disk_details", v_m_disk_details)
        if vm_id is not None:
            pulumi.set(__self__, "vm_id", vm_id)
        if vm_nics is not None:
            pulumi.set(__self__, "vm_nics", vm_nics)
        if vm_protection_state is not None:
            pulumi.set(__self__, "vm_protection_state", vm_protection_state)
        if vm_protection_state_description is not None:
            pulumi.set(__self__, "vm_protection_state_description", vm_protection_state_description)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> str:
        """
        Gets the Instance type.
        Expected value is 'HyperVReplicaBaseReplicationDetails'.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="initialReplicationDetails")
    def initial_replication_details(self) -> Optional['outputs.InitialReplicationDetailsResponse']:
        """
        Initial replication details.
        """
        return pulumi.get(self, "initial_replication_details")

    @property
    @pulumi.getter(name="lastReplicatedTime")
    def last_replicated_time(self) -> Optional[str]:
        """
        The Last replication time.
        """
        return pulumi.get(self, "last_replicated_time")

    @property
    @pulumi.getter(name="vMDiskDetails")
    def v_m_disk_details(self) -> Optional[Sequence['outputs.DiskDetailsResponse']]:
        """
        VM disk details.
        """
        return pulumi.get(self, "v_m_disk_details")

    @property
    @pulumi.getter(name="vmId")
    def vm_id(self) -> Optional[str]:
        """
        The virtual machine Id.
        """
        return pulumi.get(self, "vm_id")

    @property
    @pulumi.getter(name="vmNics")
    def vm_nics(self) -> Optional[Sequence['outputs.VMNicDetailsResponse']]:
        """
        The PE Network details.
        """
        return pulumi.get(self, "vm_nics")

    @property
    @pulumi.getter(name="vmProtectionState")
    def vm_protection_state(self) -> Optional[str]:
        """
        The protection state for the vm.
        """
        return pulumi.get(self, "vm_protection_state")

    @property
    @pulumi.getter(name="vmProtectionStateDescription")
    def vm_protection_state_description(self) -> Optional[str]:
        """
        The protection state description for the vm.
        """
        return pulumi.get(self, "vm_protection_state_description")


@pulumi.output_type
class HyperVReplicaBluePolicyDetailsResponse(dict):
    """
    Hyper-V Replica Blue specific protection profile details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceType":
            suggest = "instance_type"
        elif key == "allowedAuthenticationType":
            suggest = "allowed_authentication_type"
        elif key == "applicationConsistentSnapshotFrequencyInHours":
            suggest = "application_consistent_snapshot_frequency_in_hours"
        elif key == "initialReplicationMethod":
            suggest = "initial_replication_method"
        elif key == "offlineReplicationExportPath":
            suggest = "offline_replication_export_path"
        elif key == "offlineReplicationImportPath":
            suggest = "offline_replication_import_path"
        elif key == "onlineReplicationStartTime":
            suggest = "online_replication_start_time"
        elif key == "recoveryPoints":
            suggest = "recovery_points"
        elif key == "replicaDeletionOption":
            suggest = "replica_deletion_option"
        elif key == "replicationFrequencyInSeconds":
            suggest = "replication_frequency_in_seconds"
        elif key == "replicationPort":
            suggest = "replication_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HyperVReplicaBluePolicyDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HyperVReplicaBluePolicyDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HyperVReplicaBluePolicyDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_type: str,
                 allowed_authentication_type: Optional[int] = None,
                 application_consistent_snapshot_frequency_in_hours: Optional[int] = None,
                 compression: Optional[str] = None,
                 initial_replication_method: Optional[str] = None,
                 offline_replication_export_path: Optional[str] = None,
                 offline_replication_import_path: Optional[str] = None,
                 online_replication_start_time: Optional[str] = None,
                 recovery_points: Optional[int] = None,
                 replica_deletion_option: Optional[str] = None,
                 replication_frequency_in_seconds: Optional[int] = None,
                 replication_port: Optional[int] = None):
        """
        Hyper-V Replica Blue specific protection profile details.
        :param str instance_type: Gets the class type. Overridden in derived classes.
               Expected value is 'HyperVReplica2012R2'.
        :param int allowed_authentication_type: A value indicating the authentication type.
        :param int application_consistent_snapshot_frequency_in_hours: A value indicating the application consistent frequency.
        :param str compression: A value indicating whether compression has to be enabled.
        :param str initial_replication_method: A value indicating whether IR is online.
        :param str offline_replication_export_path: A value indicating the offline IR export path.
        :param str offline_replication_import_path: A value indicating the offline IR import path.
        :param str online_replication_start_time: A value indicating the online IR start time.
        :param int recovery_points: A value indicating the number of recovery points.
        :param str replica_deletion_option: A value indicating whether the VM has to be auto deleted. Supported Values: String.Empty, None, OnRecoveryCloud
        :param int replication_frequency_in_seconds: A value indicating the replication interval.
        :param int replication_port: A value indicating the recovery HTTPS port.
        """
        pulumi.set(__self__, "instance_type", 'HyperVReplica2012R2')
        if allowed_authentication_type is not None:
            pulumi.set(__self__, "allowed_authentication_type", allowed_authentication_type)
        if application_consistent_snapshot_frequency_in_hours is not None:
            pulumi.set(__self__, "application_consistent_snapshot_frequency_in_hours", application_consistent_snapshot_frequency_in_hours)
        if compression is not None:
            pulumi.set(__self__, "compression", compression)
        if initial_replication_method is not None:
            pulumi.set(__self__, "initial_replication_method", initial_replication_method)
        if offline_replication_export_path is not None:
            pulumi.set(__self__, "offline_replication_export_path", offline_replication_export_path)
        if offline_replication_import_path is not None:
            pulumi.set(__self__, "offline_replication_import_path", offline_replication_import_path)
        if online_replication_start_time is not None:
            pulumi.set(__self__, "online_replication_start_time", online_replication_start_time)
        if recovery_points is not None:
            pulumi.set(__self__, "recovery_points", recovery_points)
        if replica_deletion_option is not None:
            pulumi.set(__self__, "replica_deletion_option", replica_deletion_option)
        if replication_frequency_in_seconds is not None:
            pulumi.set(__self__, "replication_frequency_in_seconds", replication_frequency_in_seconds)
        if replication_port is not None:
            pulumi.set(__self__, "replication_port", replication_port)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> str:
        """
        Gets the class type. Overridden in derived classes.
        Expected value is 'HyperVReplica2012R2'.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="allowedAuthenticationType")
    def allowed_authentication_type(self) -> Optional[int]:
        """
        A value indicating the authentication type.
        """
        return pulumi.get(self, "allowed_authentication_type")

    @property
    @pulumi.getter(name="applicationConsistentSnapshotFrequencyInHours")
    def application_consistent_snapshot_frequency_in_hours(self) -> Optional[int]:
        """
        A value indicating the application consistent frequency.
        """
        return pulumi.get(self, "application_consistent_snapshot_frequency_in_hours")

    @property
    @pulumi.getter
    def compression(self) -> Optional[str]:
        """
        A value indicating whether compression has to be enabled.
        """
        return pulumi.get(self, "compression")

    @property
    @pulumi.getter(name="initialReplicationMethod")
    def initial_replication_method(self) -> Optional[str]:
        """
        A value indicating whether IR is online.
        """
        return pulumi.get(self, "initial_replication_method")

    @property
    @pulumi.getter(name="offlineReplicationExportPath")
    def offline_replication_export_path(self) -> Optional[str]:
        """
        A value indicating the offline IR export path.
        """
        return pulumi.get(self, "offline_replication_export_path")

    @property
    @pulumi.getter(name="offlineReplicationImportPath")
    def offline_replication_import_path(self) -> Optional[str]:
        """
        A value indicating the offline IR import path.
        """
        return pulumi.get(self, "offline_replication_import_path")

    @property
    @pulumi.getter(name="onlineReplicationStartTime")
    def online_replication_start_time(self) -> Optional[str]:
        """
        A value indicating the online IR start time.
        """
        return pulumi.get(self, "online_replication_start_time")

    @property
    @pulumi.getter(name="recoveryPoints")
    def recovery_points(self) -> Optional[int]:
        """
        A value indicating the number of recovery points.
        """
        return pulumi.get(self, "recovery_points")

    @property
    @pulumi.getter(name="replicaDeletionOption")
    def replica_deletion_option(self) -> Optional[str]:
        """
        A value indicating whether the VM has to be auto deleted. Supported Values: String.Empty, None, OnRecoveryCloud
        """
        return pulumi.get(self, "replica_deletion_option")

    @property
    @pulumi.getter(name="replicationFrequencyInSeconds")
    def replication_frequency_in_seconds(self) -> Optional[int]:
        """
        A value indicating the replication interval.
        """
        return pulumi.get(self, "replication_frequency_in_seconds")

    @property
    @pulumi.getter(name="replicationPort")
    def replication_port(self) -> Optional[int]:
        """
        A value indicating the recovery HTTPS port.
        """
        return pulumi.get(self, "replication_port")


@pulumi.output_type
class HyperVReplicaBlueReplicationDetailsResponse(dict):
    """
    HyperV replica 2012 R2 (Blue) replication details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceType":
            suggest = "instance_type"
        elif key == "initialReplicationDetails":
            suggest = "initial_replication_details"
        elif key == "lastReplicatedTime":
            suggest = "last_replicated_time"
        elif key == "vMDiskDetails":
            suggest = "v_m_disk_details"
        elif key == "vmId":
            suggest = "vm_id"
        elif key == "vmNics":
            suggest = "vm_nics"
        elif key == "vmProtectionState":
            suggest = "vm_protection_state"
        elif key == "vmProtectionStateDescription":
            suggest = "vm_protection_state_description"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HyperVReplicaBlueReplicationDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HyperVReplicaBlueReplicationDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HyperVReplicaBlueReplicationDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_type: str,
                 initial_replication_details: Optional['outputs.InitialReplicationDetailsResponse'] = None,
                 last_replicated_time: Optional[str] = None,
                 v_m_disk_details: Optional[Sequence['outputs.DiskDetailsResponse']] = None,
                 vm_id: Optional[str] = None,
                 vm_nics: Optional[Sequence['outputs.VMNicDetailsResponse']] = None,
                 vm_protection_state: Optional[str] = None,
                 vm_protection_state_description: Optional[str] = None):
        """
        HyperV replica 2012 R2 (Blue) replication details.
        :param str instance_type: Gets the Instance type.
               Expected value is 'HyperVReplica2012R2'.
        :param 'InitialReplicationDetailsResponse' initial_replication_details: Initial replication details.
        :param str last_replicated_time: The Last replication time.
        :param Sequence['DiskDetailsResponse'] v_m_disk_details: VM disk details.
        :param str vm_id: The virtual machine Id.
        :param Sequence['VMNicDetailsResponse'] vm_nics: The PE Network details.
        :param str vm_protection_state: The protection state for the vm.
        :param str vm_protection_state_description: The protection state description for the vm.
        """
        pulumi.set(__self__, "instance_type", 'HyperVReplica2012R2')
        if initial_replication_details is not None:
            pulumi.set(__self__, "initial_replication_details", initial_replication_details)
        if last_replicated_time is not None:
            pulumi.set(__self__, "last_replicated_time", last_replicated_time)
        if v_m_disk_details is not None:
            pulumi.set(__self__, "v_m_disk_details", v_m_disk_details)
        if vm_id is not None:
            pulumi.set(__self__, "vm_id", vm_id)
        if vm_nics is not None:
            pulumi.set(__self__, "vm_nics", vm_nics)
        if vm_protection_state is not None:
            pulumi.set(__self__, "vm_protection_state", vm_protection_state)
        if vm_protection_state_description is not None:
            pulumi.set(__self__, "vm_protection_state_description", vm_protection_state_description)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> str:
        """
        Gets the Instance type.
        Expected value is 'HyperVReplica2012R2'.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="initialReplicationDetails")
    def initial_replication_details(self) -> Optional['outputs.InitialReplicationDetailsResponse']:
        """
        Initial replication details.
        """
        return pulumi.get(self, "initial_replication_details")

    @property
    @pulumi.getter(name="lastReplicatedTime")
    def last_replicated_time(self) -> Optional[str]:
        """
        The Last replication time.
        """
        return pulumi.get(self, "last_replicated_time")

    @property
    @pulumi.getter(name="vMDiskDetails")
    def v_m_disk_details(self) -> Optional[Sequence['outputs.DiskDetailsResponse']]:
        """
        VM disk details.
        """
        return pulumi.get(self, "v_m_disk_details")

    @property
    @pulumi.getter(name="vmId")
    def vm_id(self) -> Optional[str]:
        """
        The virtual machine Id.
        """
        return pulumi.get(self, "vm_id")

    @property
    @pulumi.getter(name="vmNics")
    def vm_nics(self) -> Optional[Sequence['outputs.VMNicDetailsResponse']]:
        """
        The PE Network details.
        """
        return pulumi.get(self, "vm_nics")

    @property
    @pulumi.getter(name="vmProtectionState")
    def vm_protection_state(self) -> Optional[str]:
        """
        The protection state for the vm.
        """
        return pulumi.get(self, "vm_protection_state")

    @property
    @pulumi.getter(name="vmProtectionStateDescription")
    def vm_protection_state_description(self) -> Optional[str]:
        """
        The protection state description for the vm.
        """
        return pulumi.get(self, "vm_protection_state_description")


@pulumi.output_type
class HyperVReplicaPolicyDetailsResponse(dict):
    """
    Hyper-V Replica Blue specific protection profile details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceType":
            suggest = "instance_type"
        elif key == "allowedAuthenticationType":
            suggest = "allowed_authentication_type"
        elif key == "applicationConsistentSnapshotFrequencyInHours":
            suggest = "application_consistent_snapshot_frequency_in_hours"
        elif key == "initialReplicationMethod":
            suggest = "initial_replication_method"
        elif key == "offlineReplicationExportPath":
            suggest = "offline_replication_export_path"
        elif key == "offlineReplicationImportPath":
            suggest = "offline_replication_import_path"
        elif key == "onlineReplicationStartTime":
            suggest = "online_replication_start_time"
        elif key == "recoveryPoints":
            suggest = "recovery_points"
        elif key == "replicaDeletionOption":
            suggest = "replica_deletion_option"
        elif key == "replicationPort":
            suggest = "replication_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HyperVReplicaPolicyDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HyperVReplicaPolicyDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HyperVReplicaPolicyDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_type: str,
                 allowed_authentication_type: Optional[int] = None,
                 application_consistent_snapshot_frequency_in_hours: Optional[int] = None,
                 compression: Optional[str] = None,
                 initial_replication_method: Optional[str] = None,
                 offline_replication_export_path: Optional[str] = None,
                 offline_replication_import_path: Optional[str] = None,
                 online_replication_start_time: Optional[str] = None,
                 recovery_points: Optional[int] = None,
                 replica_deletion_option: Optional[str] = None,
                 replication_port: Optional[int] = None):
        """
        Hyper-V Replica Blue specific protection profile details.
        :param str instance_type: Gets the class type. Overridden in derived classes.
               Expected value is 'HyperVReplica2012'.
        :param int allowed_authentication_type: A value indicating the authentication type.
        :param int application_consistent_snapshot_frequency_in_hours: A value indicating the application consistent frequency.
        :param str compression: A value indicating whether compression has to be enabled.
        :param str initial_replication_method: A value indicating whether IR is online.
        :param str offline_replication_export_path: A value indicating the offline IR export path.
        :param str offline_replication_import_path: A value indicating the offline IR import path.
        :param str online_replication_start_time: A value indicating the online IR start time.
        :param int recovery_points: A value indicating the number of recovery points.
        :param str replica_deletion_option: A value indicating whether the VM has to be auto deleted. Supported Values: String.Empty, None, OnRecoveryCloud
        :param int replication_port: A value indicating the recovery HTTPS port.
        """
        pulumi.set(__self__, "instance_type", 'HyperVReplica2012')
        if allowed_authentication_type is not None:
            pulumi.set(__self__, "allowed_authentication_type", allowed_authentication_type)
        if application_consistent_snapshot_frequency_in_hours is not None:
            pulumi.set(__self__, "application_consistent_snapshot_frequency_in_hours", application_consistent_snapshot_frequency_in_hours)
        if compression is not None:
            pulumi.set(__self__, "compression", compression)
        if initial_replication_method is not None:
            pulumi.set(__self__, "initial_replication_method", initial_replication_method)
        if offline_replication_export_path is not None:
            pulumi.set(__self__, "offline_replication_export_path", offline_replication_export_path)
        if offline_replication_import_path is not None:
            pulumi.set(__self__, "offline_replication_import_path", offline_replication_import_path)
        if online_replication_start_time is not None:
            pulumi.set(__self__, "online_replication_start_time", online_replication_start_time)
        if recovery_points is not None:
            pulumi.set(__self__, "recovery_points", recovery_points)
        if replica_deletion_option is not None:
            pulumi.set(__self__, "replica_deletion_option", replica_deletion_option)
        if replication_port is not None:
            pulumi.set(__self__, "replication_port", replication_port)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> str:
        """
        Gets the class type. Overridden in derived classes.
        Expected value is 'HyperVReplica2012'.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="allowedAuthenticationType")
    def allowed_authentication_type(self) -> Optional[int]:
        """
        A value indicating the authentication type.
        """
        return pulumi.get(self, "allowed_authentication_type")

    @property
    @pulumi.getter(name="applicationConsistentSnapshotFrequencyInHours")
    def application_consistent_snapshot_frequency_in_hours(self) -> Optional[int]:
        """
        A value indicating the application consistent frequency.
        """
        return pulumi.get(self, "application_consistent_snapshot_frequency_in_hours")

    @property
    @pulumi.getter
    def compression(self) -> Optional[str]:
        """
        A value indicating whether compression has to be enabled.
        """
        return pulumi.get(self, "compression")

    @property
    @pulumi.getter(name="initialReplicationMethod")
    def initial_replication_method(self) -> Optional[str]:
        """
        A value indicating whether IR is online.
        """
        return pulumi.get(self, "initial_replication_method")

    @property
    @pulumi.getter(name="offlineReplicationExportPath")
    def offline_replication_export_path(self) -> Optional[str]:
        """
        A value indicating the offline IR export path.
        """
        return pulumi.get(self, "offline_replication_export_path")

    @property
    @pulumi.getter(name="offlineReplicationImportPath")
    def offline_replication_import_path(self) -> Optional[str]:
        """
        A value indicating the offline IR import path.
        """
        return pulumi.get(self, "offline_replication_import_path")

    @property
    @pulumi.getter(name="onlineReplicationStartTime")
    def online_replication_start_time(self) -> Optional[str]:
        """
        A value indicating the online IR start time.
        """
        return pulumi.get(self, "online_replication_start_time")

    @property
    @pulumi.getter(name="recoveryPoints")
    def recovery_points(self) -> Optional[int]:
        """
        A value indicating the number of recovery points.
        """
        return pulumi.get(self, "recovery_points")

    @property
    @pulumi.getter(name="replicaDeletionOption")
    def replica_deletion_option(self) -> Optional[str]:
        """
        A value indicating whether the VM has to be auto deleted. Supported Values: String.Empty, None, OnRecoveryCloud
        """
        return pulumi.get(self, "replica_deletion_option")

    @property
    @pulumi.getter(name="replicationPort")
    def replication_port(self) -> Optional[int]:
        """
        A value indicating the recovery HTTPS port.
        """
        return pulumi.get(self, "replication_port")


@pulumi.output_type
class HyperVReplicaReplicationDetailsResponse(dict):
    """
    HyperV replica 2012 replication details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceType":
            suggest = "instance_type"
        elif key == "initialReplicationDetails":
            suggest = "initial_replication_details"
        elif key == "lastReplicatedTime":
            suggest = "last_replicated_time"
        elif key == "vMDiskDetails":
            suggest = "v_m_disk_details"
        elif key == "vmId":
            suggest = "vm_id"
        elif key == "vmNics":
            suggest = "vm_nics"
        elif key == "vmProtectionState":
            suggest = "vm_protection_state"
        elif key == "vmProtectionStateDescription":
            suggest = "vm_protection_state_description"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HyperVReplicaReplicationDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HyperVReplicaReplicationDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HyperVReplicaReplicationDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_type: str,
                 initial_replication_details: Optional['outputs.InitialReplicationDetailsResponse'] = None,
                 last_replicated_time: Optional[str] = None,
                 v_m_disk_details: Optional[Sequence['outputs.DiskDetailsResponse']] = None,
                 vm_id: Optional[str] = None,
                 vm_nics: Optional[Sequence['outputs.VMNicDetailsResponse']] = None,
                 vm_protection_state: Optional[str] = None,
                 vm_protection_state_description: Optional[str] = None):
        """
        HyperV replica 2012 replication details.
        :param str instance_type: Gets the Instance type.
               Expected value is 'HyperVReplica2012'.
        :param 'InitialReplicationDetailsResponse' initial_replication_details: Initial replication details.
        :param str last_replicated_time: The Last replication time.
        :param Sequence['DiskDetailsResponse'] v_m_disk_details: VM disk details.
        :param str vm_id: The virtual machine Id.
        :param Sequence['VMNicDetailsResponse'] vm_nics: The PE Network details.
        :param str vm_protection_state: The protection state for the vm.
        :param str vm_protection_state_description: The protection state description for the vm.
        """
        pulumi.set(__self__, "instance_type", 'HyperVReplica2012')
        if initial_replication_details is not None:
            pulumi.set(__self__, "initial_replication_details", initial_replication_details)
        if last_replicated_time is not None:
            pulumi.set(__self__, "last_replicated_time", last_replicated_time)
        if v_m_disk_details is not None:
            pulumi.set(__self__, "v_m_disk_details", v_m_disk_details)
        if vm_id is not None:
            pulumi.set(__self__, "vm_id", vm_id)
        if vm_nics is not None:
            pulumi.set(__self__, "vm_nics", vm_nics)
        if vm_protection_state is not None:
            pulumi.set(__self__, "vm_protection_state", vm_protection_state)
        if vm_protection_state_description is not None:
            pulumi.set(__self__, "vm_protection_state_description", vm_protection_state_description)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> str:
        """
        Gets the Instance type.
        Expected value is 'HyperVReplica2012'.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="initialReplicationDetails")
    def initial_replication_details(self) -> Optional['outputs.InitialReplicationDetailsResponse']:
        """
        Initial replication details.
        """
        return pulumi.get(self, "initial_replication_details")

    @property
    @pulumi.getter(name="lastReplicatedTime")
    def last_replicated_time(self) -> Optional[str]:
        """
        The Last replication time.
        """
        return pulumi.get(self, "last_replicated_time")

    @property
    @pulumi.getter(name="vMDiskDetails")
    def v_m_disk_details(self) -> Optional[Sequence['outputs.DiskDetailsResponse']]:
        """
        VM disk details.
        """
        return pulumi.get(self, "v_m_disk_details")

    @property
    @pulumi.getter(name="vmId")
    def vm_id(self) -> Optional[str]:
        """
        The virtual machine Id.
        """
        return pulumi.get(self, "vm_id")

    @property
    @pulumi.getter(name="vmNics")
    def vm_nics(self) -> Optional[Sequence['outputs.VMNicDetailsResponse']]:
        """
        The PE Network details.
        """
        return pulumi.get(self, "vm_nics")

    @property
    @pulumi.getter(name="vmProtectionState")
    def vm_protection_state(self) -> Optional[str]:
        """
        The protection state for the vm.
        """
        return pulumi.get(self, "vm_protection_state")

    @property
    @pulumi.getter(name="vmProtectionStateDescription")
    def vm_protection_state_description(self) -> Optional[str]:
        """
        The protection state description for the vm.
        """
        return pulumi.get(self, "vm_protection_state_description")


@pulumi.output_type
class HyperVSiteDetailsResponse(dict):
    """
    HyperVSite fabric specific details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceType":
            suggest = "instance_type"
        elif key == "hyperVHosts":
            suggest = "hyper_v_hosts"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HyperVSiteDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HyperVSiteDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HyperVSiteDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_type: str,
                 hyper_v_hosts: Optional[Sequence['outputs.HyperVHostDetailsResponse']] = None):
        """
        HyperVSite fabric specific details.
        :param str instance_type: Gets the class type. Overridden in derived classes.
               Expected value is 'HyperVSite'.
        :param Sequence['HyperVHostDetailsResponse'] hyper_v_hosts: The list of Hyper-V hosts associated with the fabric.
        """
        pulumi.set(__self__, "instance_type", 'HyperVSite')
        if hyper_v_hosts is not None:
            pulumi.set(__self__, "hyper_v_hosts", hyper_v_hosts)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> str:
        """
        Gets the class type. Overridden in derived classes.
        Expected value is 'HyperVSite'.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="hyperVHosts")
    def hyper_v_hosts(self) -> Optional[Sequence['outputs.HyperVHostDetailsResponse']]:
        """
        The list of Hyper-V hosts associated with the fabric.
        """
        return pulumi.get(self, "hyper_v_hosts")


@pulumi.output_type
class IPConfigDetailsResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipAddressType":
            suggest = "ip_address_type"
        elif key == "isPrimary":
            suggest = "is_primary"
        elif key == "isSeletedForFailover":
            suggest = "is_seleted_for_failover"
        elif key == "recoveryIPAddressType":
            suggest = "recovery_ip_address_type"
        elif key == "recoveryLBBackendAddressPoolIds":
            suggest = "recovery_lb_backend_address_pool_ids"
        elif key == "recoveryPublicIPAddressId":
            suggest = "recovery_public_ip_address_id"
        elif key == "recoveryStaticIPAddress":
            suggest = "recovery_static_ip_address"
        elif key == "recoverySubnetName":
            suggest = "recovery_subnet_name"
        elif key == "staticIPAddress":
            suggest = "static_ip_address"
        elif key == "subnetName":
            suggest = "subnet_name"
        elif key == "tfoLBBackendAddressPoolIds":
            suggest = "tfo_lb_backend_address_pool_ids"
        elif key == "tfoPublicIPAddressId":
            suggest = "tfo_public_ip_address_id"
        elif key == "tfoStaticIPAddress":
            suggest = "tfo_static_ip_address"
        elif key == "tfoSubnetName":
            suggest = "tfo_subnet_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IPConfigDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IPConfigDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IPConfigDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ip_address_type: Optional[str] = None,
                 is_primary: Optional[bool] = None,
                 is_seleted_for_failover: Optional[bool] = None,
                 name: Optional[str] = None,
                 recovery_ip_address_type: Optional[str] = None,
                 recovery_lb_backend_address_pool_ids: Optional[Sequence[str]] = None,
                 recovery_public_ip_address_id: Optional[str] = None,
                 recovery_static_ip_address: Optional[str] = None,
                 recovery_subnet_name: Optional[str] = None,
                 static_ip_address: Optional[str] = None,
                 subnet_name: Optional[str] = None,
                 tfo_lb_backend_address_pool_ids: Optional[Sequence[str]] = None,
                 tfo_public_ip_address_id: Optional[str] = None,
                 tfo_static_ip_address: Optional[str] = None,
                 tfo_subnet_name: Optional[str] = None):
        if ip_address_type is not None:
            pulumi.set(__self__, "ip_address_type", ip_address_type)
        if is_primary is not None:
            pulumi.set(__self__, "is_primary", is_primary)
        if is_seleted_for_failover is not None:
            pulumi.set(__self__, "is_seleted_for_failover", is_seleted_for_failover)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if recovery_ip_address_type is not None:
            pulumi.set(__self__, "recovery_ip_address_type", recovery_ip_address_type)
        if recovery_lb_backend_address_pool_ids is not None:
            pulumi.set(__self__, "recovery_lb_backend_address_pool_ids", recovery_lb_backend_address_pool_ids)
        if recovery_public_ip_address_id is not None:
            pulumi.set(__self__, "recovery_public_ip_address_id", recovery_public_ip_address_id)
        if recovery_static_ip_address is not None:
            pulumi.set(__self__, "recovery_static_ip_address", recovery_static_ip_address)
        if recovery_subnet_name is not None:
            pulumi.set(__self__, "recovery_subnet_name", recovery_subnet_name)
        if static_ip_address is not None:
            pulumi.set(__self__, "static_ip_address", static_ip_address)
        if subnet_name is not None:
            pulumi.set(__self__, "subnet_name", subnet_name)
        if tfo_lb_backend_address_pool_ids is not None:
            pulumi.set(__self__, "tfo_lb_backend_address_pool_ids", tfo_lb_backend_address_pool_ids)
        if tfo_public_ip_address_id is not None:
            pulumi.set(__self__, "tfo_public_ip_address_id", tfo_public_ip_address_id)
        if tfo_static_ip_address is not None:
            pulumi.set(__self__, "tfo_static_ip_address", tfo_static_ip_address)
        if tfo_subnet_name is not None:
            pulumi.set(__self__, "tfo_subnet_name", tfo_subnet_name)

    @property
    @pulumi.getter(name="ipAddressType")
    def ip_address_type(self) -> Optional[str]:
        return pulumi.get(self, "ip_address_type")

    @property
    @pulumi.getter(name="isPrimary")
    def is_primary(self) -> Optional[bool]:
        return pulumi.get(self, "is_primary")

    @property
    @pulumi.getter(name="isSeletedForFailover")
    def is_seleted_for_failover(self) -> Optional[bool]:
        return pulumi.get(self, "is_seleted_for_failover")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="recoveryIPAddressType")
    def recovery_ip_address_type(self) -> Optional[str]:
        return pulumi.get(self, "recovery_ip_address_type")

    @property
    @pulumi.getter(name="recoveryLBBackendAddressPoolIds")
    def recovery_lb_backend_address_pool_ids(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "recovery_lb_backend_address_pool_ids")

    @property
    @pulumi.getter(name="recoveryPublicIPAddressId")
    def recovery_public_ip_address_id(self) -> Optional[str]:
        return pulumi.get(self, "recovery_public_ip_address_id")

    @property
    @pulumi.getter(name="recoveryStaticIPAddress")
    def recovery_static_ip_address(self) -> Optional[str]:
        return pulumi.get(self, "recovery_static_ip_address")

    @property
    @pulumi.getter(name="recoverySubnetName")
    def recovery_subnet_name(self) -> Optional[str]:
        return pulumi.get(self, "recovery_subnet_name")

    @property
    @pulumi.getter(name="staticIPAddress")
    def static_ip_address(self) -> Optional[str]:
        return pulumi.get(self, "static_ip_address")

    @property
    @pulumi.getter(name="subnetName")
    def subnet_name(self) -> Optional[str]:
        return pulumi.get(self, "subnet_name")

    @property
    @pulumi.getter(name="tfoLBBackendAddressPoolIds")
    def tfo_lb_backend_address_pool_ids(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "tfo_lb_backend_address_pool_ids")

    @property
    @pulumi.getter(name="tfoPublicIPAddressId")
    def tfo_public_ip_address_id(self) -> Optional[str]:
        return pulumi.get(self, "tfo_public_ip_address_id")

    @property
    @pulumi.getter(name="tfoStaticIPAddress")
    def tfo_static_ip_address(self) -> Optional[str]:
        return pulumi.get(self, "tfo_static_ip_address")

    @property
    @pulumi.getter(name="tfoSubnetName")
    def tfo_subnet_name(self) -> Optional[str]:
        return pulumi.get(self, "tfo_subnet_name")


@pulumi.output_type
class IdentityDataResponse(dict):
    """
    Identity for the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"
        elif key == "userAssignedIdentities":
            suggest = "user_assigned_identities"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IdentityDataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IdentityDataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IdentityDataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 principal_id: str,
                 tenant_id: str,
                 type: str,
                 user_assigned_identities: Optional[Mapping[str, 'outputs.UserIdentityResponse']] = None):
        """
        Identity for the resource.
        :param str principal_id: The principal ID of resource identity.
        :param str tenant_id: The tenant ID of resource.
        :param str type: The type of managed identity used. The type 'SystemAssigned, UserAssigned' includes both an implicitly created identity and a set of user-assigned identities. The type 'None' will remove any identities.
        :param Mapping[str, 'UserIdentityResponse'] user_assigned_identities: The list of user-assigned identities associated with the resource. The user-assigned identity dictionary keys will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
        """
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        pulumi.set(__self__, "type", type)
        if user_assigned_identities is not None:
            pulumi.set(__self__, "user_assigned_identities", user_assigned_identities)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> str:
        """
        The principal ID of resource identity.
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> str:
        """
        The tenant ID of resource.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of managed identity used. The type 'SystemAssigned, UserAssigned' includes both an implicitly created identity and a set of user-assigned identities. The type 'None' will remove any identities.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="userAssignedIdentities")
    def user_assigned_identities(self) -> Optional[Mapping[str, 'outputs.UserIdentityResponse']]:
        """
        The list of user-assigned identities associated with the resource. The user-assigned identity dictionary keys will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
        """
        return pulumi.get(self, "user_assigned_identities")


@pulumi.output_type
class IdentityProviderDetailsResponse(dict):
    """
    Identity provider details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "aadAuthority":
            suggest = "aad_authority"
        elif key == "applicationId":
            suggest = "application_id"
        elif key == "objectId":
            suggest = "object_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IdentityProviderDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IdentityProviderDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IdentityProviderDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 aad_authority: Optional[str] = None,
                 application_id: Optional[str] = None,
                 audience: Optional[str] = None,
                 object_id: Optional[str] = None,
                 tenant_id: Optional[str] = None):
        """
        Identity provider details.
        :param str aad_authority: The base authority for Azure Active Directory authentication.
        :param str application_id: The application/client Id for the service principal with which the on-premise management/data plane components would communicate with our Azure services.
        :param str audience: The intended Audience of the service principal with which the on-premise management/data plane components would communicate with our Azure services.
        :param str object_id: The object Id of the service principal with which the on-premise management/data plane components would communicate with our Azure services.
        :param str tenant_id: The tenant Id for the service principal with which the on-premise management/data plane components would communicate with our Azure services.
        """
        if aad_authority is not None:
            pulumi.set(__self__, "aad_authority", aad_authority)
        if application_id is not None:
            pulumi.set(__self__, "application_id", application_id)
        if audience is not None:
            pulumi.set(__self__, "audience", audience)
        if object_id is not None:
            pulumi.set(__self__, "object_id", object_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter(name="aadAuthority")
    def aad_authority(self) -> Optional[str]:
        """
        The base authority for Azure Active Directory authentication.
        """
        return pulumi.get(self, "aad_authority")

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> Optional[str]:
        """
        The application/client Id for the service principal with which the on-premise management/data plane components would communicate with our Azure services.
        """
        return pulumi.get(self, "application_id")

    @property
    @pulumi.getter
    def audience(self) -> Optional[str]:
        """
        The intended Audience of the service principal with which the on-premise management/data plane components would communicate with our Azure services.
        """
        return pulumi.get(self, "audience")

    @property
    @pulumi.getter(name="objectId")
    def object_id(self) -> Optional[str]:
        """
        The object Id of the service principal with which the on-premise management/data plane components would communicate with our Azure services.
        """
        return pulumi.get(self, "object_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[str]:
        """
        The tenant Id for the service principal with which the on-premise management/data plane components would communicate with our Azure services.
        """
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class InMageAgentDetailsResponse(dict):
    """
    The details of the InMage agent.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "agentExpiryDate":
            suggest = "agent_expiry_date"
        elif key == "agentUpdateStatus":
            suggest = "agent_update_status"
        elif key == "agentVersion":
            suggest = "agent_version"
        elif key == "postUpdateRebootStatus":
            suggest = "post_update_reboot_status"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InMageAgentDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InMageAgentDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InMageAgentDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 agent_expiry_date: Optional[str] = None,
                 agent_update_status: Optional[str] = None,
                 agent_version: Optional[str] = None,
                 post_update_reboot_status: Optional[str] = None):
        """
        The details of the InMage agent.
        :param str agent_expiry_date: Agent expiry date.
        :param str agent_update_status: A value indicating whether installed agent needs to be updated.
        :param str agent_version: The agent version.
        :param str post_update_reboot_status: A value indicating whether reboot is required after update is applied.
        """
        if agent_expiry_date is not None:
            pulumi.set(__self__, "agent_expiry_date", agent_expiry_date)
        if agent_update_status is not None:
            pulumi.set(__self__, "agent_update_status", agent_update_status)
        if agent_version is not None:
            pulumi.set(__self__, "agent_version", agent_version)
        if post_update_reboot_status is not None:
            pulumi.set(__self__, "post_update_reboot_status", post_update_reboot_status)

    @property
    @pulumi.getter(name="agentExpiryDate")
    def agent_expiry_date(self) -> Optional[str]:
        """
        Agent expiry date.
        """
        return pulumi.get(self, "agent_expiry_date")

    @property
    @pulumi.getter(name="agentUpdateStatus")
    def agent_update_status(self) -> Optional[str]:
        """
        A value indicating whether installed agent needs to be updated.
        """
        return pulumi.get(self, "agent_update_status")

    @property
    @pulumi.getter(name="agentVersion")
    def agent_version(self) -> Optional[str]:
        """
        The agent version.
        """
        return pulumi.get(self, "agent_version")

    @property
    @pulumi.getter(name="postUpdateRebootStatus")
    def post_update_reboot_status(self) -> Optional[str]:
        """
        A value indicating whether reboot is required after update is applied.
        """
        return pulumi.get(self, "post_update_reboot_status")


@pulumi.output_type
class InMageAzureV2ManagedDiskDetailsResponse(dict):
    """
    InMageAzureV2 Managed disk details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "diskEncryptionSetId":
            suggest = "disk_encryption_set_id"
        elif key == "diskId":
            suggest = "disk_id"
        elif key == "replicaDiskType":
            suggest = "replica_disk_type"
        elif key == "seedManagedDiskId":
            suggest = "seed_managed_disk_id"
        elif key == "targetDiskName":
            suggest = "target_disk_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InMageAzureV2ManagedDiskDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InMageAzureV2ManagedDiskDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InMageAzureV2ManagedDiskDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disk_encryption_set_id: Optional[str] = None,
                 disk_id: Optional[str] = None,
                 replica_disk_type: Optional[str] = None,
                 seed_managed_disk_id: Optional[str] = None,
                 target_disk_name: Optional[str] = None):
        """
        InMageAzureV2 Managed disk details.
        :param str disk_encryption_set_id: The DiskEncryptionSet ARM ID.
        :param str disk_id: The disk id.
        :param str replica_disk_type: The replica disk type.
        :param str seed_managed_disk_id: Seed managed disk Id.
        :param str target_disk_name: The target disk name.
        """
        if disk_encryption_set_id is not None:
            pulumi.set(__self__, "disk_encryption_set_id", disk_encryption_set_id)
        if disk_id is not None:
            pulumi.set(__self__, "disk_id", disk_id)
        if replica_disk_type is not None:
            pulumi.set(__self__, "replica_disk_type", replica_disk_type)
        if seed_managed_disk_id is not None:
            pulumi.set(__self__, "seed_managed_disk_id", seed_managed_disk_id)
        if target_disk_name is not None:
            pulumi.set(__self__, "target_disk_name", target_disk_name)

    @property
    @pulumi.getter(name="diskEncryptionSetId")
    def disk_encryption_set_id(self) -> Optional[str]:
        """
        The DiskEncryptionSet ARM ID.
        """
        return pulumi.get(self, "disk_encryption_set_id")

    @property
    @pulumi.getter(name="diskId")
    def disk_id(self) -> Optional[str]:
        """
        The disk id.
        """
        return pulumi.get(self, "disk_id")

    @property
    @pulumi.getter(name="replicaDiskType")
    def replica_disk_type(self) -> Optional[str]:
        """
        The replica disk type.
        """
        return pulumi.get(self, "replica_disk_type")

    @property
    @pulumi.getter(name="seedManagedDiskId")
    def seed_managed_disk_id(self) -> Optional[str]:
        """
        Seed managed disk Id.
        """
        return pulumi.get(self, "seed_managed_disk_id")

    @property
    @pulumi.getter(name="targetDiskName")
    def target_disk_name(self) -> Optional[str]:
        """
        The target disk name.
        """
        return pulumi.get(self, "target_disk_name")


@pulumi.output_type
class InMageAzureV2PolicyDetailsResponse(dict):
    """
    InMage Azure v2 specific protection profile details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceType":
            suggest = "instance_type"
        elif key == "appConsistentFrequencyInMinutes":
            suggest = "app_consistent_frequency_in_minutes"
        elif key == "crashConsistentFrequencyInMinutes":
            suggest = "crash_consistent_frequency_in_minutes"
        elif key == "multiVmSyncStatus":
            suggest = "multi_vm_sync_status"
        elif key == "recoveryPointHistory":
            suggest = "recovery_point_history"
        elif key == "recoveryPointThresholdInMinutes":
            suggest = "recovery_point_threshold_in_minutes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InMageAzureV2PolicyDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InMageAzureV2PolicyDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InMageAzureV2PolicyDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_type: str,
                 app_consistent_frequency_in_minutes: Optional[int] = None,
                 crash_consistent_frequency_in_minutes: Optional[int] = None,
                 multi_vm_sync_status: Optional[str] = None,
                 recovery_point_history: Optional[int] = None,
                 recovery_point_threshold_in_minutes: Optional[int] = None):
        """
        InMage Azure v2 specific protection profile details.
        :param str instance_type: Gets the class type. Overridden in derived classes.
               Expected value is 'InMageAzureV2'.
        :param int app_consistent_frequency_in_minutes: The app consistent snapshot frequency in minutes.
        :param int crash_consistent_frequency_in_minutes: The crash consistent snapshot frequency in minutes.
        :param str multi_vm_sync_status: A value indicating whether multi-VM sync has to be enabled.
        :param int recovery_point_history: The duration in minutes until which the recovery points need to be stored.
        :param int recovery_point_threshold_in_minutes: The recovery point threshold in minutes.
        """
        pulumi.set(__self__, "instance_type", 'InMageAzureV2')
        if app_consistent_frequency_in_minutes is not None:
            pulumi.set(__self__, "app_consistent_frequency_in_minutes", app_consistent_frequency_in_minutes)
        if crash_consistent_frequency_in_minutes is not None:
            pulumi.set(__self__, "crash_consistent_frequency_in_minutes", crash_consistent_frequency_in_minutes)
        if multi_vm_sync_status is not None:
            pulumi.set(__self__, "multi_vm_sync_status", multi_vm_sync_status)
        if recovery_point_history is not None:
            pulumi.set(__self__, "recovery_point_history", recovery_point_history)
        if recovery_point_threshold_in_minutes is not None:
            pulumi.set(__self__, "recovery_point_threshold_in_minutes", recovery_point_threshold_in_minutes)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> str:
        """
        Gets the class type. Overridden in derived classes.
        Expected value is 'InMageAzureV2'.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="appConsistentFrequencyInMinutes")
    def app_consistent_frequency_in_minutes(self) -> Optional[int]:
        """
        The app consistent snapshot frequency in minutes.
        """
        return pulumi.get(self, "app_consistent_frequency_in_minutes")

    @property
    @pulumi.getter(name="crashConsistentFrequencyInMinutes")
    def crash_consistent_frequency_in_minutes(self) -> Optional[int]:
        """
        The crash consistent snapshot frequency in minutes.
        """
        return pulumi.get(self, "crash_consistent_frequency_in_minutes")

    @property
    @pulumi.getter(name="multiVmSyncStatus")
    def multi_vm_sync_status(self) -> Optional[str]:
        """
        A value indicating whether multi-VM sync has to be enabled.
        """
        return pulumi.get(self, "multi_vm_sync_status")

    @property
    @pulumi.getter(name="recoveryPointHistory")
    def recovery_point_history(self) -> Optional[int]:
        """
        The duration in minutes until which the recovery points need to be stored.
        """
        return pulumi.get(self, "recovery_point_history")

    @property
    @pulumi.getter(name="recoveryPointThresholdInMinutes")
    def recovery_point_threshold_in_minutes(self) -> Optional[int]:
        """
        The recovery point threshold in minutes.
        """
        return pulumi.get(self, "recovery_point_threshold_in_minutes")


@pulumi.output_type
class InMageAzureV2ProtectedDiskDetailsResponse(dict):
    """
    InMageAzureV2 protected disk details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "diskCapacityInBytes":
            suggest = "disk_capacity_in_bytes"
        elif key == "diskId":
            suggest = "disk_id"
        elif key == "diskName":
            suggest = "disk_name"
        elif key == "diskResized":
            suggest = "disk_resized"
        elif key == "fileSystemCapacityInBytes":
            suggest = "file_system_capacity_in_bytes"
        elif key == "healthErrorCode":
            suggest = "health_error_code"
        elif key == "lastRpoCalculatedTime":
            suggest = "last_rpo_calculated_time"
        elif key == "progressHealth":
            suggest = "progress_health"
        elif key == "progressStatus":
            suggest = "progress_status"
        elif key == "protectionStage":
            suggest = "protection_stage"
        elif key == "psDataInMegaBytes":
            suggest = "ps_data_in_mega_bytes"
        elif key == "resyncDurationInSeconds":
            suggest = "resync_duration_in_seconds"
        elif key == "resyncLast15MinutesTransferredBytes":
            suggest = "resync_last15_minutes_transferred_bytes"
        elif key == "resyncLastDataTransferTimeUTC":
            suggest = "resync_last_data_transfer_time_utc"
        elif key == "resyncProcessedBytes":
            suggest = "resync_processed_bytes"
        elif key == "resyncProgressPercentage":
            suggest = "resync_progress_percentage"
        elif key == "resyncRequired":
            suggest = "resync_required"
        elif key == "resyncStartTime":
            suggest = "resync_start_time"
        elif key == "resyncTotalTransferredBytes":
            suggest = "resync_total_transferred_bytes"
        elif key == "rpoInSeconds":
            suggest = "rpo_in_seconds"
        elif key == "secondsToTakeSwitchProvider":
            suggest = "seconds_to_take_switch_provider"
        elif key == "sourceDataInMegaBytes":
            suggest = "source_data_in_mega_bytes"
        elif key == "targetDataInMegaBytes":
            suggest = "target_data_in_mega_bytes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InMageAzureV2ProtectedDiskDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InMageAzureV2ProtectedDiskDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InMageAzureV2ProtectedDiskDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disk_capacity_in_bytes: Optional[float] = None,
                 disk_id: Optional[str] = None,
                 disk_name: Optional[str] = None,
                 disk_resized: Optional[str] = None,
                 file_system_capacity_in_bytes: Optional[float] = None,
                 health_error_code: Optional[str] = None,
                 last_rpo_calculated_time: Optional[str] = None,
                 progress_health: Optional[str] = None,
                 progress_status: Optional[str] = None,
                 protection_stage: Optional[str] = None,
                 ps_data_in_mega_bytes: Optional[float] = None,
                 resync_duration_in_seconds: Optional[float] = None,
                 resync_last15_minutes_transferred_bytes: Optional[float] = None,
                 resync_last_data_transfer_time_utc: Optional[str] = None,
                 resync_processed_bytes: Optional[float] = None,
                 resync_progress_percentage: Optional[int] = None,
                 resync_required: Optional[str] = None,
                 resync_start_time: Optional[str] = None,
                 resync_total_transferred_bytes: Optional[float] = None,
                 rpo_in_seconds: Optional[float] = None,
                 seconds_to_take_switch_provider: Optional[float] = None,
                 source_data_in_mega_bytes: Optional[float] = None,
                 target_data_in_mega_bytes: Optional[float] = None):
        """
        InMageAzureV2 protected disk details.
        :param float disk_capacity_in_bytes: The disk capacity in bytes.
        :param str disk_id: The disk id.
        :param str disk_name: The disk name.
        :param str disk_resized: A value indicating whether disk is resized.
        :param float file_system_capacity_in_bytes: The disk file system capacity in bytes.
        :param str health_error_code: The health error code for the disk.
        :param str last_rpo_calculated_time: The last RPO calculated time.
        :param str progress_health: The Progress Health.
        :param str progress_status: The Progress Status.
        :param str protection_stage: The protection stage.
        :param float ps_data_in_mega_bytes: The PS data transit in MB.
        :param float resync_duration_in_seconds: The resync duration in seconds.
        :param float resync_last15_minutes_transferred_bytes: The resync last 15 minutes transferred bytes.
        :param str resync_last_data_transfer_time_utc: The last data transfer time in UTC.
        :param float resync_processed_bytes: The resync processed bytes.
        :param int resync_progress_percentage: The resync progress percentage.
        :param str resync_required: A value indicating whether resync is required for this disk.
        :param str resync_start_time: The resync start time.
        :param float resync_total_transferred_bytes: The resync total transferred bytes.
        :param float rpo_in_seconds: The RPO in seconds.
        :param float seconds_to_take_switch_provider: The seconds to take for switch provider.
        :param float source_data_in_mega_bytes: The source data transit in MB.
        :param float target_data_in_mega_bytes: The target data transit in MB.
        """
        if disk_capacity_in_bytes is not None:
            pulumi.set(__self__, "disk_capacity_in_bytes", disk_capacity_in_bytes)
        if disk_id is not None:
            pulumi.set(__self__, "disk_id", disk_id)
        if disk_name is not None:
            pulumi.set(__self__, "disk_name", disk_name)
        if disk_resized is not None:
            pulumi.set(__self__, "disk_resized", disk_resized)
        if file_system_capacity_in_bytes is not None:
            pulumi.set(__self__, "file_system_capacity_in_bytes", file_system_capacity_in_bytes)
        if health_error_code is not None:
            pulumi.set(__self__, "health_error_code", health_error_code)
        if last_rpo_calculated_time is not None:
            pulumi.set(__self__, "last_rpo_calculated_time", last_rpo_calculated_time)
        if progress_health is not None:
            pulumi.set(__self__, "progress_health", progress_health)
        if progress_status is not None:
            pulumi.set(__self__, "progress_status", progress_status)
        if protection_stage is not None:
            pulumi.set(__self__, "protection_stage", protection_stage)
        if ps_data_in_mega_bytes is not None:
            pulumi.set(__self__, "ps_data_in_mega_bytes", ps_data_in_mega_bytes)
        if resync_duration_in_seconds is not None:
            pulumi.set(__self__, "resync_duration_in_seconds", resync_duration_in_seconds)
        if resync_last15_minutes_transferred_bytes is not None:
            pulumi.set(__self__, "resync_last15_minutes_transferred_bytes", resync_last15_minutes_transferred_bytes)
        if resync_last_data_transfer_time_utc is not None:
            pulumi.set(__self__, "resync_last_data_transfer_time_utc", resync_last_data_transfer_time_utc)
        if resync_processed_bytes is not None:
            pulumi.set(__self__, "resync_processed_bytes", resync_processed_bytes)
        if resync_progress_percentage is not None:
            pulumi.set(__self__, "resync_progress_percentage", resync_progress_percentage)
        if resync_required is not None:
            pulumi.set(__self__, "resync_required", resync_required)
        if resync_start_time is not None:
            pulumi.set(__self__, "resync_start_time", resync_start_time)
        if resync_total_transferred_bytes is not None:
            pulumi.set(__self__, "resync_total_transferred_bytes", resync_total_transferred_bytes)
        if rpo_in_seconds is not None:
            pulumi.set(__self__, "rpo_in_seconds", rpo_in_seconds)
        if seconds_to_take_switch_provider is not None:
            pulumi.set(__self__, "seconds_to_take_switch_provider", seconds_to_take_switch_provider)
        if source_data_in_mega_bytes is not None:
            pulumi.set(__self__, "source_data_in_mega_bytes", source_data_in_mega_bytes)
        if target_data_in_mega_bytes is not None:
            pulumi.set(__self__, "target_data_in_mega_bytes", target_data_in_mega_bytes)

    @property
    @pulumi.getter(name="diskCapacityInBytes")
    def disk_capacity_in_bytes(self) -> Optional[float]:
        """
        The disk capacity in bytes.
        """
        return pulumi.get(self, "disk_capacity_in_bytes")

    @property
    @pulumi.getter(name="diskId")
    def disk_id(self) -> Optional[str]:
        """
        The disk id.
        """
        return pulumi.get(self, "disk_id")

    @property
    @pulumi.getter(name="diskName")
    def disk_name(self) -> Optional[str]:
        """
        The disk name.
        """
        return pulumi.get(self, "disk_name")

    @property
    @pulumi.getter(name="diskResized")
    def disk_resized(self) -> Optional[str]:
        """
        A value indicating whether disk is resized.
        """
        return pulumi.get(self, "disk_resized")

    @property
    @pulumi.getter(name="fileSystemCapacityInBytes")
    def file_system_capacity_in_bytes(self) -> Optional[float]:
        """
        The disk file system capacity in bytes.
        """
        return pulumi.get(self, "file_system_capacity_in_bytes")

    @property
    @pulumi.getter(name="healthErrorCode")
    def health_error_code(self) -> Optional[str]:
        """
        The health error code for the disk.
        """
        return pulumi.get(self, "health_error_code")

    @property
    @pulumi.getter(name="lastRpoCalculatedTime")
    def last_rpo_calculated_time(self) -> Optional[str]:
        """
        The last RPO calculated time.
        """
        return pulumi.get(self, "last_rpo_calculated_time")

    @property
    @pulumi.getter(name="progressHealth")
    def progress_health(self) -> Optional[str]:
        """
        The Progress Health.
        """
        return pulumi.get(self, "progress_health")

    @property
    @pulumi.getter(name="progressStatus")
    def progress_status(self) -> Optional[str]:
        """
        The Progress Status.
        """
        return pulumi.get(self, "progress_status")

    @property
    @pulumi.getter(name="protectionStage")
    def protection_stage(self) -> Optional[str]:
        """
        The protection stage.
        """
        return pulumi.get(self, "protection_stage")

    @property
    @pulumi.getter(name="psDataInMegaBytes")
    def ps_data_in_mega_bytes(self) -> Optional[float]:
        """
        The PS data transit in MB.
        """
        return pulumi.get(self, "ps_data_in_mega_bytes")

    @property
    @pulumi.getter(name="resyncDurationInSeconds")
    def resync_duration_in_seconds(self) -> Optional[float]:
        """
        The resync duration in seconds.
        """
        return pulumi.get(self, "resync_duration_in_seconds")

    @property
    @pulumi.getter(name="resyncLast15MinutesTransferredBytes")
    def resync_last15_minutes_transferred_bytes(self) -> Optional[float]:
        """
        The resync last 15 minutes transferred bytes.
        """
        return pulumi.get(self, "resync_last15_minutes_transferred_bytes")

    @property
    @pulumi.getter(name="resyncLastDataTransferTimeUTC")
    def resync_last_data_transfer_time_utc(self) -> Optional[str]:
        """
        The last data transfer time in UTC.
        """
        return pulumi.get(self, "resync_last_data_transfer_time_utc")

    @property
    @pulumi.getter(name="resyncProcessedBytes")
    def resync_processed_bytes(self) -> Optional[float]:
        """
        The resync processed bytes.
        """
        return pulumi.get(self, "resync_processed_bytes")

    @property
    @pulumi.getter(name="resyncProgressPercentage")
    def resync_progress_percentage(self) -> Optional[int]:
        """
        The resync progress percentage.
        """
        return pulumi.get(self, "resync_progress_percentage")

    @property
    @pulumi.getter(name="resyncRequired")
    def resync_required(self) -> Optional[str]:
        """
        A value indicating whether resync is required for this disk.
        """
        return pulumi.get(self, "resync_required")

    @property
    @pulumi.getter(name="resyncStartTime")
    def resync_start_time(self) -> Optional[str]:
        """
        The resync start time.
        """
        return pulumi.get(self, "resync_start_time")

    @property
    @pulumi.getter(name="resyncTotalTransferredBytes")
    def resync_total_transferred_bytes(self) -> Optional[float]:
        """
        The resync total transferred bytes.
        """
        return pulumi.get(self, "resync_total_transferred_bytes")

    @property
    @pulumi.getter(name="rpoInSeconds")
    def rpo_in_seconds(self) -> Optional[float]:
        """
        The RPO in seconds.
        """
        return pulumi.get(self, "rpo_in_seconds")

    @property
    @pulumi.getter(name="secondsToTakeSwitchProvider")
    def seconds_to_take_switch_provider(self) -> Optional[float]:
        """
        The seconds to take for switch provider.
        """
        return pulumi.get(self, "seconds_to_take_switch_provider")

    @property
    @pulumi.getter(name="sourceDataInMegaBytes")
    def source_data_in_mega_bytes(self) -> Optional[float]:
        """
        The source data transit in MB.
        """
        return pulumi.get(self, "source_data_in_mega_bytes")

    @property
    @pulumi.getter(name="targetDataInMegaBytes")
    def target_data_in_mega_bytes(self) -> Optional[float]:
        """
        The target data transit in MB.
        """
        return pulumi.get(self, "target_data_in_mega_bytes")


@pulumi.output_type
class InMageAzureV2ReplicationDetailsResponse(dict):
    """
    InMageAzureV2 provider specific settings.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceType":
            suggest = "instance_type"
        elif key == "lastRecoveryPointReceived":
            suggest = "last_recovery_point_received"
        elif key == "agentExpiryDate":
            suggest = "agent_expiry_date"
        elif key == "agentVersion":
            suggest = "agent_version"
        elif key == "azureVMDiskDetails":
            suggest = "azure_vm_disk_details"
        elif key == "azureVmGeneration":
            suggest = "azure_vm_generation"
        elif key == "compressedDataRateInMB":
            suggest = "compressed_data_rate_in_mb"
        elif key == "discoveryType":
            suggest = "discovery_type"
        elif key == "diskResized":
            suggest = "disk_resized"
        elif key == "enableRdpOnTargetOption":
            suggest = "enable_rdp_on_target_option"
        elif key == "firmwareType":
            suggest = "firmware_type"
        elif key == "infrastructureVmId":
            suggest = "infrastructure_vm_id"
        elif key == "ipAddress":
            suggest = "ip_address"
        elif key == "isAdditionalStatsAvailable":
            suggest = "is_additional_stats_available"
        elif key == "isAgentUpdateRequired":
            suggest = "is_agent_update_required"
        elif key == "isRebootAfterUpdateRequired":
            suggest = "is_reboot_after_update_required"
        elif key == "lastHeartbeat":
            suggest = "last_heartbeat"
        elif key == "lastRpoCalculatedTime":
            suggest = "last_rpo_calculated_time"
        elif key == "lastUpdateReceivedTime":
            suggest = "last_update_received_time"
        elif key == "licenseType":
            suggest = "license_type"
        elif key == "masterTargetId":
            suggest = "master_target_id"
        elif key == "multiVmGroupId":
            suggest = "multi_vm_group_id"
        elif key == "multiVmGroupName":
            suggest = "multi_vm_group_name"
        elif key == "multiVmSyncStatus":
            suggest = "multi_vm_sync_status"
        elif key == "osDiskId":
            suggest = "os_disk_id"
        elif key == "osType":
            suggest = "os_type"
        elif key == "osVersion":
            suggest = "os_version"
        elif key == "processServerId":
            suggest = "process_server_id"
        elif key == "processServerName":
            suggest = "process_server_name"
        elif key == "protectedDisks":
            suggest = "protected_disks"
        elif key == "protectedManagedDisks":
            suggest = "protected_managed_disks"
        elif key == "protectionStage":
            suggest = "protection_stage"
        elif key == "recoveryAvailabilitySetId":
            suggest = "recovery_availability_set_id"
        elif key == "recoveryAzureLogStorageAccountId":
            suggest = "recovery_azure_log_storage_account_id"
        elif key == "recoveryAzureResourceGroupId":
            suggest = "recovery_azure_resource_group_id"
        elif key == "recoveryAzureStorageAccount":
            suggest = "recovery_azure_storage_account"
        elif key == "recoveryAzureVMName":
            suggest = "recovery_azure_vm_name"
        elif key == "recoveryAzureVMSize":
            suggest = "recovery_azure_vm_size"
        elif key == "replicaId":
            suggest = "replica_id"
        elif key == "resyncProgressPercentage":
            suggest = "resync_progress_percentage"
        elif key == "rpoInSeconds":
            suggest = "rpo_in_seconds"
        elif key == "seedManagedDiskTags":
            suggest = "seed_managed_disk_tags"
        elif key == "selectedRecoveryAzureNetworkId":
            suggest = "selected_recovery_azure_network_id"
        elif key == "selectedSourceNicId":
            suggest = "selected_source_nic_id"
        elif key == "selectedTfoAzureNetworkId":
            suggest = "selected_tfo_azure_network_id"
        elif key == "sourceVmCpuCount":
            suggest = "source_vm_cpu_count"
        elif key == "sourceVmRamSizeInMB":
            suggest = "source_vm_ram_size_in_mb"
        elif key == "sqlServerLicenseType":
            suggest = "sql_server_license_type"
        elif key == "switchProviderBlockingErrorDetails":
            suggest = "switch_provider_blocking_error_details"
        elif key == "switchProviderDetails":
            suggest = "switch_provider_details"
        elif key == "targetAvailabilityZone":
            suggest = "target_availability_zone"
        elif key == "targetManagedDiskTags":
            suggest = "target_managed_disk_tags"
        elif key == "targetNicTags":
            suggest = "target_nic_tags"
        elif key == "targetProximityPlacementGroupId":
            suggest = "target_proximity_placement_group_id"
        elif key == "targetVmId":
            suggest = "target_vm_id"
        elif key == "targetVmTags":
            suggest = "target_vm_tags"
        elif key == "totalDataTransferred":
            suggest = "total_data_transferred"
        elif key == "totalProgressHealth":
            suggest = "total_progress_health"
        elif key == "uncompressedDataRateInMB":
            suggest = "uncompressed_data_rate_in_mb"
        elif key == "useManagedDisks":
            suggest = "use_managed_disks"
        elif key == "vCenterInfrastructureId":
            suggest = "v_center_infrastructure_id"
        elif key == "validationErrors":
            suggest = "validation_errors"
        elif key == "vhdName":
            suggest = "vhd_name"
        elif key == "vmId":
            suggest = "vm_id"
        elif key == "vmNics":
            suggest = "vm_nics"
        elif key == "vmProtectionState":
            suggest = "vm_protection_state"
        elif key == "vmProtectionStateDescription":
            suggest = "vm_protection_state_description"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InMageAzureV2ReplicationDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InMageAzureV2ReplicationDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InMageAzureV2ReplicationDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_type: str,
                 last_recovery_point_received: str,
                 agent_expiry_date: Optional[str] = None,
                 agent_version: Optional[str] = None,
                 azure_vm_disk_details: Optional[Sequence['outputs.AzureVmDiskDetailsResponse']] = None,
                 azure_vm_generation: Optional[str] = None,
                 compressed_data_rate_in_mb: Optional[float] = None,
                 datastores: Optional[Sequence[str]] = None,
                 discovery_type: Optional[str] = None,
                 disk_resized: Optional[str] = None,
                 enable_rdp_on_target_option: Optional[str] = None,
                 firmware_type: Optional[str] = None,
                 infrastructure_vm_id: Optional[str] = None,
                 ip_address: Optional[str] = None,
                 is_additional_stats_available: Optional[bool] = None,
                 is_agent_update_required: Optional[str] = None,
                 is_reboot_after_update_required: Optional[str] = None,
                 last_heartbeat: Optional[str] = None,
                 last_rpo_calculated_time: Optional[str] = None,
                 last_update_received_time: Optional[str] = None,
                 license_type: Optional[str] = None,
                 master_target_id: Optional[str] = None,
                 multi_vm_group_id: Optional[str] = None,
                 multi_vm_group_name: Optional[str] = None,
                 multi_vm_sync_status: Optional[str] = None,
                 os_disk_id: Optional[str] = None,
                 os_type: Optional[str] = None,
                 os_version: Optional[str] = None,
                 process_server_id: Optional[str] = None,
                 process_server_name: Optional[str] = None,
                 protected_disks: Optional[Sequence['outputs.InMageAzureV2ProtectedDiskDetailsResponse']] = None,
                 protected_managed_disks: Optional[Sequence['outputs.InMageAzureV2ManagedDiskDetailsResponse']] = None,
                 protection_stage: Optional[str] = None,
                 recovery_availability_set_id: Optional[str] = None,
                 recovery_azure_log_storage_account_id: Optional[str] = None,
                 recovery_azure_resource_group_id: Optional[str] = None,
                 recovery_azure_storage_account: Optional[str] = None,
                 recovery_azure_vm_name: Optional[str] = None,
                 recovery_azure_vm_size: Optional[str] = None,
                 replica_id: Optional[str] = None,
                 resync_progress_percentage: Optional[int] = None,
                 rpo_in_seconds: Optional[float] = None,
                 seed_managed_disk_tags: Optional[Mapping[str, str]] = None,
                 selected_recovery_azure_network_id: Optional[str] = None,
                 selected_source_nic_id: Optional[str] = None,
                 selected_tfo_azure_network_id: Optional[str] = None,
                 source_vm_cpu_count: Optional[int] = None,
                 source_vm_ram_size_in_mb: Optional[int] = None,
                 sql_server_license_type: Optional[str] = None,
                 switch_provider_blocking_error_details: Optional[Sequence['outputs.InMageAzureV2SwitchProviderBlockingErrorDetailsResponse']] = None,
                 switch_provider_details: Optional['outputs.InMageAzureV2SwitchProviderDetailsResponse'] = None,
                 target_availability_zone: Optional[str] = None,
                 target_managed_disk_tags: Optional[Mapping[str, str]] = None,
                 target_nic_tags: Optional[Mapping[str, str]] = None,
                 target_proximity_placement_group_id: Optional[str] = None,
                 target_vm_id: Optional[str] = None,
                 target_vm_tags: Optional[Mapping[str, str]] = None,
                 total_data_transferred: Optional[float] = None,
                 total_progress_health: Optional[str] = None,
                 uncompressed_data_rate_in_mb: Optional[float] = None,
                 use_managed_disks: Optional[str] = None,
                 v_center_infrastructure_id: Optional[str] = None,
                 validation_errors: Optional[Sequence['outputs.HealthErrorResponse']] = None,
                 vhd_name: Optional[str] = None,
                 vm_id: Optional[str] = None,
                 vm_nics: Optional[Sequence['outputs.VMNicDetailsResponse']] = None,
                 vm_protection_state: Optional[str] = None,
                 vm_protection_state_description: Optional[str] = None):
        """
        InMageAzureV2 provider specific settings.
        :param str instance_type: Gets the Instance type.
               Expected value is 'InMageAzureV2'.
        :param str last_recovery_point_received: The last recovery point received time.
        :param str agent_expiry_date: Agent expiry date.
        :param str agent_version: The agent version.
        :param Sequence['AzureVmDiskDetailsResponse'] azure_vm_disk_details: Azure VM Disk details.
        :param str azure_vm_generation: The target generation for this protected item.
        :param float compressed_data_rate_in_mb: The compressed data change rate in MB.
        :param Sequence[str] datastores: The datastores of the on-premise machine. Value can be list of strings that contain datastore names.
        :param str discovery_type: A value indicating the discovery type of the machine. Value can be vCenter or physical.
        :param str disk_resized: A value indicating whether any disk is resized for this VM.
        :param str enable_rdp_on_target_option: The selected option to enable RDP\\SSH on target vm after failover. String value of SrsDataContract.EnableRDPOnTargetOption enum.
        :param str firmware_type: The firmware type of this protected item.
        :param str infrastructure_vm_id: The infrastructure VM Id.
        :param str ip_address: The source IP address.
        :param bool is_additional_stats_available: A value indicating whether additional IR stats are available or not.
        :param str is_agent_update_required: A value indicating whether installed agent needs to be updated.
        :param str is_reboot_after_update_required: A value indicating whether the source server requires a restart after update.
        :param str last_heartbeat: The last heartbeat received from the source server.
        :param str last_rpo_calculated_time: The last RPO calculated time.
        :param str last_update_received_time: The last update time received from on-prem components.
        :param str license_type: License Type of the VM to be used.
        :param str master_target_id: The master target Id.
        :param str multi_vm_group_id: The multi vm group Id.
        :param str multi_vm_group_name: The multi vm group name.
        :param str multi_vm_sync_status: A value indicating whether multi vm sync is enabled or disabled.
        :param str os_disk_id: The id of the disk containing the OS.
        :param str os_type: The type of the OS on the VM.
        :param str os_version: The OS Version of the protected item.
        :param str process_server_id: The process server Id.
        :param str process_server_name: The process server name.
        :param Sequence['InMageAzureV2ProtectedDiskDetailsResponse'] protected_disks: The list of protected disks.
        :param Sequence['InMageAzureV2ManagedDiskDetailsResponse'] protected_managed_disks: The list of protected managed disks.
        :param str protection_stage: The protection stage.
        :param str recovery_availability_set_id: The recovery availability set Id.
        :param str recovery_azure_log_storage_account_id: The ARM id of the log storage account used for replication. This will be set to null if no log storage account was provided during enable protection.
        :param str recovery_azure_resource_group_id: The target resource group Id.
        :param str recovery_azure_storage_account: The recovery Azure storage account.
        :param str recovery_azure_vm_name: Recovery Azure given name.
        :param str recovery_azure_vm_size: The Recovery Azure VM size.
        :param str replica_id: The replica id of the protected item.
        :param int resync_progress_percentage: The resync progress percentage.
        :param float rpo_in_seconds: The RPO in seconds.
        :param Mapping[str, str] seed_managed_disk_tags: The tags for the seed managed disks.
        :param str selected_recovery_azure_network_id: The selected recovery azure network Id.
        :param str selected_source_nic_id: The selected source nic Id which will be used as the primary nic during failover.
        :param str selected_tfo_azure_network_id: The test failover virtual network.
        :param int source_vm_cpu_count: The CPU count of the VM on the primary side.
        :param int source_vm_ram_size_in_mb: The RAM size of the VM on the primary side.
        :param str sql_server_license_type: The SQL Server license type.
        :param Sequence['InMageAzureV2SwitchProviderBlockingErrorDetailsResponse'] switch_provider_blocking_error_details: The switch provider blocking error information.
        :param 'InMageAzureV2SwitchProviderDetailsResponse' switch_provider_details: The switch provider blocking error information.
        :param str target_availability_zone: The target availability zone.
        :param Mapping[str, str] target_managed_disk_tags: The tags for the target managed disks.
        :param Mapping[str, str] target_nic_tags: The tags for the target NICs.
        :param str target_proximity_placement_group_id: The target proximity placement group Id.
        :param str target_vm_id: The ARM Id of the target Azure VM. This value will be null until the VM is failed over. Only after failure it will be populated with the ARM Id of the Azure VM.
        :param Mapping[str, str] target_vm_tags: The target VM tags.
        :param float total_data_transferred: The total transferred data in bytes.
        :param str total_progress_health: The progress health.
        :param float uncompressed_data_rate_in_mb: The uncompressed data change rate in MB.
        :param str use_managed_disks: A value indicating whether managed disks should be used during failover.
        :param str v_center_infrastructure_id: The vCenter infrastructure Id.
        :param Sequence['HealthErrorResponse'] validation_errors: The validation errors of the on-premise machine Value can be list of validation errors.
        :param str vhd_name: The OS disk VHD name.
        :param str vm_id: The virtual machine Id.
        :param Sequence['VMNicDetailsResponse'] vm_nics: The PE Network details.
        :param str vm_protection_state: The protection state for the vm.
        :param str vm_protection_state_description: The protection state description for the vm.
        """
        pulumi.set(__self__, "instance_type", 'InMageAzureV2')
        pulumi.set(__self__, "last_recovery_point_received", last_recovery_point_received)
        if agent_expiry_date is not None:
            pulumi.set(__self__, "agent_expiry_date", agent_expiry_date)
        if agent_version is not None:
            pulumi.set(__self__, "agent_version", agent_version)
        if azure_vm_disk_details is not None:
            pulumi.set(__self__, "azure_vm_disk_details", azure_vm_disk_details)
        if azure_vm_generation is not None:
            pulumi.set(__self__, "azure_vm_generation", azure_vm_generation)
        if compressed_data_rate_in_mb is not None:
            pulumi.set(__self__, "compressed_data_rate_in_mb", compressed_data_rate_in_mb)
        if datastores is not None:
            pulumi.set(__self__, "datastores", datastores)
        if discovery_type is not None:
            pulumi.set(__self__, "discovery_type", discovery_type)
        if disk_resized is not None:
            pulumi.set(__self__, "disk_resized", disk_resized)
        if enable_rdp_on_target_option is not None:
            pulumi.set(__self__, "enable_rdp_on_target_option", enable_rdp_on_target_option)
        if firmware_type is not None:
            pulumi.set(__self__, "firmware_type", firmware_type)
        if infrastructure_vm_id is not None:
            pulumi.set(__self__, "infrastructure_vm_id", infrastructure_vm_id)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if is_additional_stats_available is not None:
            pulumi.set(__self__, "is_additional_stats_available", is_additional_stats_available)
        if is_agent_update_required is not None:
            pulumi.set(__self__, "is_agent_update_required", is_agent_update_required)
        if is_reboot_after_update_required is not None:
            pulumi.set(__self__, "is_reboot_after_update_required", is_reboot_after_update_required)
        if last_heartbeat is not None:
            pulumi.set(__self__, "last_heartbeat", last_heartbeat)
        if last_rpo_calculated_time is not None:
            pulumi.set(__self__, "last_rpo_calculated_time", last_rpo_calculated_time)
        if last_update_received_time is not None:
            pulumi.set(__self__, "last_update_received_time", last_update_received_time)
        if license_type is not None:
            pulumi.set(__self__, "license_type", license_type)
        if master_target_id is not None:
            pulumi.set(__self__, "master_target_id", master_target_id)
        if multi_vm_group_id is not None:
            pulumi.set(__self__, "multi_vm_group_id", multi_vm_group_id)
        if multi_vm_group_name is not None:
            pulumi.set(__self__, "multi_vm_group_name", multi_vm_group_name)
        if multi_vm_sync_status is not None:
            pulumi.set(__self__, "multi_vm_sync_status", multi_vm_sync_status)
        if os_disk_id is not None:
            pulumi.set(__self__, "os_disk_id", os_disk_id)
        if os_type is not None:
            pulumi.set(__self__, "os_type", os_type)
        if os_version is not None:
            pulumi.set(__self__, "os_version", os_version)
        if process_server_id is not None:
            pulumi.set(__self__, "process_server_id", process_server_id)
        if process_server_name is not None:
            pulumi.set(__self__, "process_server_name", process_server_name)
        if protected_disks is not None:
            pulumi.set(__self__, "protected_disks", protected_disks)
        if protected_managed_disks is not None:
            pulumi.set(__self__, "protected_managed_disks", protected_managed_disks)
        if protection_stage is not None:
            pulumi.set(__self__, "protection_stage", protection_stage)
        if recovery_availability_set_id is not None:
            pulumi.set(__self__, "recovery_availability_set_id", recovery_availability_set_id)
        if recovery_azure_log_storage_account_id is not None:
            pulumi.set(__self__, "recovery_azure_log_storage_account_id", recovery_azure_log_storage_account_id)
        if recovery_azure_resource_group_id is not None:
            pulumi.set(__self__, "recovery_azure_resource_group_id", recovery_azure_resource_group_id)
        if recovery_azure_storage_account is not None:
            pulumi.set(__self__, "recovery_azure_storage_account", recovery_azure_storage_account)
        if recovery_azure_vm_name is not None:
            pulumi.set(__self__, "recovery_azure_vm_name", recovery_azure_vm_name)
        if recovery_azure_vm_size is not None:
            pulumi.set(__self__, "recovery_azure_vm_size", recovery_azure_vm_size)
        if replica_id is not None:
            pulumi.set(__self__, "replica_id", replica_id)
        if resync_progress_percentage is not None:
            pulumi.set(__self__, "resync_progress_percentage", resync_progress_percentage)
        if rpo_in_seconds is not None:
            pulumi.set(__self__, "rpo_in_seconds", rpo_in_seconds)
        if seed_managed_disk_tags is not None:
            pulumi.set(__self__, "seed_managed_disk_tags", seed_managed_disk_tags)
        if selected_recovery_azure_network_id is not None:
            pulumi.set(__self__, "selected_recovery_azure_network_id", selected_recovery_azure_network_id)
        if selected_source_nic_id is not None:
            pulumi.set(__self__, "selected_source_nic_id", selected_source_nic_id)
        if selected_tfo_azure_network_id is not None:
            pulumi.set(__self__, "selected_tfo_azure_network_id", selected_tfo_azure_network_id)
        if source_vm_cpu_count is not None:
            pulumi.set(__self__, "source_vm_cpu_count", source_vm_cpu_count)
        if source_vm_ram_size_in_mb is not None:
            pulumi.set(__self__, "source_vm_ram_size_in_mb", source_vm_ram_size_in_mb)
        if sql_server_license_type is not None:
            pulumi.set(__self__, "sql_server_license_type", sql_server_license_type)
        if switch_provider_blocking_error_details is not None:
            pulumi.set(__self__, "switch_provider_blocking_error_details", switch_provider_blocking_error_details)
        if switch_provider_details is not None:
            pulumi.set(__self__, "switch_provider_details", switch_provider_details)
        if target_availability_zone is not None:
            pulumi.set(__self__, "target_availability_zone", target_availability_zone)
        if target_managed_disk_tags is not None:
            pulumi.set(__self__, "target_managed_disk_tags", target_managed_disk_tags)
        if target_nic_tags is not None:
            pulumi.set(__self__, "target_nic_tags", target_nic_tags)
        if target_proximity_placement_group_id is not None:
            pulumi.set(__self__, "target_proximity_placement_group_id", target_proximity_placement_group_id)
        if target_vm_id is not None:
            pulumi.set(__self__, "target_vm_id", target_vm_id)
        if target_vm_tags is not None:
            pulumi.set(__self__, "target_vm_tags", target_vm_tags)
        if total_data_transferred is not None:
            pulumi.set(__self__, "total_data_transferred", total_data_transferred)
        if total_progress_health is not None:
            pulumi.set(__self__, "total_progress_health", total_progress_health)
        if uncompressed_data_rate_in_mb is not None:
            pulumi.set(__self__, "uncompressed_data_rate_in_mb", uncompressed_data_rate_in_mb)
        if use_managed_disks is not None:
            pulumi.set(__self__, "use_managed_disks", use_managed_disks)
        if v_center_infrastructure_id is not None:
            pulumi.set(__self__, "v_center_infrastructure_id", v_center_infrastructure_id)
        if validation_errors is not None:
            pulumi.set(__self__, "validation_errors", validation_errors)
        if vhd_name is not None:
            pulumi.set(__self__, "vhd_name", vhd_name)
        if vm_id is not None:
            pulumi.set(__self__, "vm_id", vm_id)
        if vm_nics is not None:
            pulumi.set(__self__, "vm_nics", vm_nics)
        if vm_protection_state is not None:
            pulumi.set(__self__, "vm_protection_state", vm_protection_state)
        if vm_protection_state_description is not None:
            pulumi.set(__self__, "vm_protection_state_description", vm_protection_state_description)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> str:
        """
        Gets the Instance type.
        Expected value is 'InMageAzureV2'.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="lastRecoveryPointReceived")
    def last_recovery_point_received(self) -> str:
        """
        The last recovery point received time.
        """
        return pulumi.get(self, "last_recovery_point_received")

    @property
    @pulumi.getter(name="agentExpiryDate")
    def agent_expiry_date(self) -> Optional[str]:
        """
        Agent expiry date.
        """
        return pulumi.get(self, "agent_expiry_date")

    @property
    @pulumi.getter(name="agentVersion")
    def agent_version(self) -> Optional[str]:
        """
        The agent version.
        """
        return pulumi.get(self, "agent_version")

    @property
    @pulumi.getter(name="azureVMDiskDetails")
    def azure_vm_disk_details(self) -> Optional[Sequence['outputs.AzureVmDiskDetailsResponse']]:
        """
        Azure VM Disk details.
        """
        return pulumi.get(self, "azure_vm_disk_details")

    @property
    @pulumi.getter(name="azureVmGeneration")
    def azure_vm_generation(self) -> Optional[str]:
        """
        The target generation for this protected item.
        """
        return pulumi.get(self, "azure_vm_generation")

    @property
    @pulumi.getter(name="compressedDataRateInMB")
    def compressed_data_rate_in_mb(self) -> Optional[float]:
        """
        The compressed data change rate in MB.
        """
        return pulumi.get(self, "compressed_data_rate_in_mb")

    @property
    @pulumi.getter
    def datastores(self) -> Optional[Sequence[str]]:
        """
        The datastores of the on-premise machine. Value can be list of strings that contain datastore names.
        """
        return pulumi.get(self, "datastores")

    @property
    @pulumi.getter(name="discoveryType")
    def discovery_type(self) -> Optional[str]:
        """
        A value indicating the discovery type of the machine. Value can be vCenter or physical.
        """
        return pulumi.get(self, "discovery_type")

    @property
    @pulumi.getter(name="diskResized")
    def disk_resized(self) -> Optional[str]:
        """
        A value indicating whether any disk is resized for this VM.
        """
        return pulumi.get(self, "disk_resized")

    @property
    @pulumi.getter(name="enableRdpOnTargetOption")
    def enable_rdp_on_target_option(self) -> Optional[str]:
        """
        The selected option to enable RDP\\SSH on target vm after failover. String value of SrsDataContract.EnableRDPOnTargetOption enum.
        """
        return pulumi.get(self, "enable_rdp_on_target_option")

    @property
    @pulumi.getter(name="firmwareType")
    def firmware_type(self) -> Optional[str]:
        """
        The firmware type of this protected item.
        """
        return pulumi.get(self, "firmware_type")

    @property
    @pulumi.getter(name="infrastructureVmId")
    def infrastructure_vm_id(self) -> Optional[str]:
        """
        The infrastructure VM Id.
        """
        return pulumi.get(self, "infrastructure_vm_id")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[str]:
        """
        The source IP address.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter(name="isAdditionalStatsAvailable")
    def is_additional_stats_available(self) -> Optional[bool]:
        """
        A value indicating whether additional IR stats are available or not.
        """
        return pulumi.get(self, "is_additional_stats_available")

    @property
    @pulumi.getter(name="isAgentUpdateRequired")
    def is_agent_update_required(self) -> Optional[str]:
        """
        A value indicating whether installed agent needs to be updated.
        """
        return pulumi.get(self, "is_agent_update_required")

    @property
    @pulumi.getter(name="isRebootAfterUpdateRequired")
    def is_reboot_after_update_required(self) -> Optional[str]:
        """
        A value indicating whether the source server requires a restart after update.
        """
        return pulumi.get(self, "is_reboot_after_update_required")

    @property
    @pulumi.getter(name="lastHeartbeat")
    def last_heartbeat(self) -> Optional[str]:
        """
        The last heartbeat received from the source server.
        """
        return pulumi.get(self, "last_heartbeat")

    @property
    @pulumi.getter(name="lastRpoCalculatedTime")
    def last_rpo_calculated_time(self) -> Optional[str]:
        """
        The last RPO calculated time.
        """
        return pulumi.get(self, "last_rpo_calculated_time")

    @property
    @pulumi.getter(name="lastUpdateReceivedTime")
    def last_update_received_time(self) -> Optional[str]:
        """
        The last update time received from on-prem components.
        """
        return pulumi.get(self, "last_update_received_time")

    @property
    @pulumi.getter(name="licenseType")
    def license_type(self) -> Optional[str]:
        """
        License Type of the VM to be used.
        """
        return pulumi.get(self, "license_type")

    @property
    @pulumi.getter(name="masterTargetId")
    def master_target_id(self) -> Optional[str]:
        """
        The master target Id.
        """
        return pulumi.get(self, "master_target_id")

    @property
    @pulumi.getter(name="multiVmGroupId")
    def multi_vm_group_id(self) -> Optional[str]:
        """
        The multi vm group Id.
        """
        return pulumi.get(self, "multi_vm_group_id")

    @property
    @pulumi.getter(name="multiVmGroupName")
    def multi_vm_group_name(self) -> Optional[str]:
        """
        The multi vm group name.
        """
        return pulumi.get(self, "multi_vm_group_name")

    @property
    @pulumi.getter(name="multiVmSyncStatus")
    def multi_vm_sync_status(self) -> Optional[str]:
        """
        A value indicating whether multi vm sync is enabled or disabled.
        """
        return pulumi.get(self, "multi_vm_sync_status")

    @property
    @pulumi.getter(name="osDiskId")
    def os_disk_id(self) -> Optional[str]:
        """
        The id of the disk containing the OS.
        """
        return pulumi.get(self, "os_disk_id")

    @property
    @pulumi.getter(name="osType")
    def os_type(self) -> Optional[str]:
        """
        The type of the OS on the VM.
        """
        return pulumi.get(self, "os_type")

    @property
    @pulumi.getter(name="osVersion")
    def os_version(self) -> Optional[str]:
        """
        The OS Version of the protected item.
        """
        return pulumi.get(self, "os_version")

    @property
    @pulumi.getter(name="processServerId")
    def process_server_id(self) -> Optional[str]:
        """
        The process server Id.
        """
        return pulumi.get(self, "process_server_id")

    @property
    @pulumi.getter(name="processServerName")
    def process_server_name(self) -> Optional[str]:
        """
        The process server name.
        """
        return pulumi.get(self, "process_server_name")

    @property
    @pulumi.getter(name="protectedDisks")
    def protected_disks(self) -> Optional[Sequence['outputs.InMageAzureV2ProtectedDiskDetailsResponse']]:
        """
        The list of protected disks.
        """
        return pulumi.get(self, "protected_disks")

    @property
    @pulumi.getter(name="protectedManagedDisks")
    def protected_managed_disks(self) -> Optional[Sequence['outputs.InMageAzureV2ManagedDiskDetailsResponse']]:
        """
        The list of protected managed disks.
        """
        return pulumi.get(self, "protected_managed_disks")

    @property
    @pulumi.getter(name="protectionStage")
    def protection_stage(self) -> Optional[str]:
        """
        The protection stage.
        """
        return pulumi.get(self, "protection_stage")

    @property
    @pulumi.getter(name="recoveryAvailabilitySetId")
    def recovery_availability_set_id(self) -> Optional[str]:
        """
        The recovery availability set Id.
        """
        return pulumi.get(self, "recovery_availability_set_id")

    @property
    @pulumi.getter(name="recoveryAzureLogStorageAccountId")
    def recovery_azure_log_storage_account_id(self) -> Optional[str]:
        """
        The ARM id of the log storage account used for replication. This will be set to null if no log storage account was provided during enable protection.
        """
        return pulumi.get(self, "recovery_azure_log_storage_account_id")

    @property
    @pulumi.getter(name="recoveryAzureResourceGroupId")
    def recovery_azure_resource_group_id(self) -> Optional[str]:
        """
        The target resource group Id.
        """
        return pulumi.get(self, "recovery_azure_resource_group_id")

    @property
    @pulumi.getter(name="recoveryAzureStorageAccount")
    def recovery_azure_storage_account(self) -> Optional[str]:
        """
        The recovery Azure storage account.
        """
        return pulumi.get(self, "recovery_azure_storage_account")

    @property
    @pulumi.getter(name="recoveryAzureVMName")
    def recovery_azure_vm_name(self) -> Optional[str]:
        """
        Recovery Azure given name.
        """
        return pulumi.get(self, "recovery_azure_vm_name")

    @property
    @pulumi.getter(name="recoveryAzureVMSize")
    def recovery_azure_vm_size(self) -> Optional[str]:
        """
        The Recovery Azure VM size.
        """
        return pulumi.get(self, "recovery_azure_vm_size")

    @property
    @pulumi.getter(name="replicaId")
    def replica_id(self) -> Optional[str]:
        """
        The replica id of the protected item.
        """
        return pulumi.get(self, "replica_id")

    @property
    @pulumi.getter(name="resyncProgressPercentage")
    def resync_progress_percentage(self) -> Optional[int]:
        """
        The resync progress percentage.
        """
        return pulumi.get(self, "resync_progress_percentage")

    @property
    @pulumi.getter(name="rpoInSeconds")
    def rpo_in_seconds(self) -> Optional[float]:
        """
        The RPO in seconds.
        """
        return pulumi.get(self, "rpo_in_seconds")

    @property
    @pulumi.getter(name="seedManagedDiskTags")
    def seed_managed_disk_tags(self) -> Optional[Mapping[str, str]]:
        """
        The tags for the seed managed disks.
        """
        return pulumi.get(self, "seed_managed_disk_tags")

    @property
    @pulumi.getter(name="selectedRecoveryAzureNetworkId")
    def selected_recovery_azure_network_id(self) -> Optional[str]:
        """
        The selected recovery azure network Id.
        """
        return pulumi.get(self, "selected_recovery_azure_network_id")

    @property
    @pulumi.getter(name="selectedSourceNicId")
    def selected_source_nic_id(self) -> Optional[str]:
        """
        The selected source nic Id which will be used as the primary nic during failover.
        """
        return pulumi.get(self, "selected_source_nic_id")

    @property
    @pulumi.getter(name="selectedTfoAzureNetworkId")
    def selected_tfo_azure_network_id(self) -> Optional[str]:
        """
        The test failover virtual network.
        """
        return pulumi.get(self, "selected_tfo_azure_network_id")

    @property
    @pulumi.getter(name="sourceVmCpuCount")
    def source_vm_cpu_count(self) -> Optional[int]:
        """
        The CPU count of the VM on the primary side.
        """
        return pulumi.get(self, "source_vm_cpu_count")

    @property
    @pulumi.getter(name="sourceVmRamSizeInMB")
    def source_vm_ram_size_in_mb(self) -> Optional[int]:
        """
        The RAM size of the VM on the primary side.
        """
        return pulumi.get(self, "source_vm_ram_size_in_mb")

    @property
    @pulumi.getter(name="sqlServerLicenseType")
    def sql_server_license_type(self) -> Optional[str]:
        """
        The SQL Server license type.
        """
        return pulumi.get(self, "sql_server_license_type")

    @property
    @pulumi.getter(name="switchProviderBlockingErrorDetails")
    def switch_provider_blocking_error_details(self) -> Optional[Sequence['outputs.InMageAzureV2SwitchProviderBlockingErrorDetailsResponse']]:
        """
        The switch provider blocking error information.
        """
        return pulumi.get(self, "switch_provider_blocking_error_details")

    @property
    @pulumi.getter(name="switchProviderDetails")
    def switch_provider_details(self) -> Optional['outputs.InMageAzureV2SwitchProviderDetailsResponse']:
        """
        The switch provider blocking error information.
        """
        return pulumi.get(self, "switch_provider_details")

    @property
    @pulumi.getter(name="targetAvailabilityZone")
    def target_availability_zone(self) -> Optional[str]:
        """
        The target availability zone.
        """
        return pulumi.get(self, "target_availability_zone")

    @property
    @pulumi.getter(name="targetManagedDiskTags")
    def target_managed_disk_tags(self) -> Optional[Mapping[str, str]]:
        """
        The tags for the target managed disks.
        """
        return pulumi.get(self, "target_managed_disk_tags")

    @property
    @pulumi.getter(name="targetNicTags")
    def target_nic_tags(self) -> Optional[Mapping[str, str]]:
        """
        The tags for the target NICs.
        """
        return pulumi.get(self, "target_nic_tags")

    @property
    @pulumi.getter(name="targetProximityPlacementGroupId")
    def target_proximity_placement_group_id(self) -> Optional[str]:
        """
        The target proximity placement group Id.
        """
        return pulumi.get(self, "target_proximity_placement_group_id")

    @property
    @pulumi.getter(name="targetVmId")
    def target_vm_id(self) -> Optional[str]:
        """
        The ARM Id of the target Azure VM. This value will be null until the VM is failed over. Only after failure it will be populated with the ARM Id of the Azure VM.
        """
        return pulumi.get(self, "target_vm_id")

    @property
    @pulumi.getter(name="targetVmTags")
    def target_vm_tags(self) -> Optional[Mapping[str, str]]:
        """
        The target VM tags.
        """
        return pulumi.get(self, "target_vm_tags")

    @property
    @pulumi.getter(name="totalDataTransferred")
    def total_data_transferred(self) -> Optional[float]:
        """
        The total transferred data in bytes.
        """
        return pulumi.get(self, "total_data_transferred")

    @property
    @pulumi.getter(name="totalProgressHealth")
    def total_progress_health(self) -> Optional[str]:
        """
        The progress health.
        """
        return pulumi.get(self, "total_progress_health")

    @property
    @pulumi.getter(name="uncompressedDataRateInMB")
    def uncompressed_data_rate_in_mb(self) -> Optional[float]:
        """
        The uncompressed data change rate in MB.
        """
        return pulumi.get(self, "uncompressed_data_rate_in_mb")

    @property
    @pulumi.getter(name="useManagedDisks")
    def use_managed_disks(self) -> Optional[str]:
        """
        A value indicating whether managed disks should be used during failover.
        """
        return pulumi.get(self, "use_managed_disks")

    @property
    @pulumi.getter(name="vCenterInfrastructureId")
    def v_center_infrastructure_id(self) -> Optional[str]:
        """
        The vCenter infrastructure Id.
        """
        return pulumi.get(self, "v_center_infrastructure_id")

    @property
    @pulumi.getter(name="validationErrors")
    def validation_errors(self) -> Optional[Sequence['outputs.HealthErrorResponse']]:
        """
        The validation errors of the on-premise machine Value can be list of validation errors.
        """
        return pulumi.get(self, "validation_errors")

    @property
    @pulumi.getter(name="vhdName")
    def vhd_name(self) -> Optional[str]:
        """
        The OS disk VHD name.
        """
        return pulumi.get(self, "vhd_name")

    @property
    @pulumi.getter(name="vmId")
    def vm_id(self) -> Optional[str]:
        """
        The virtual machine Id.
        """
        return pulumi.get(self, "vm_id")

    @property
    @pulumi.getter(name="vmNics")
    def vm_nics(self) -> Optional[Sequence['outputs.VMNicDetailsResponse']]:
        """
        The PE Network details.
        """
        return pulumi.get(self, "vm_nics")

    @property
    @pulumi.getter(name="vmProtectionState")
    def vm_protection_state(self) -> Optional[str]:
        """
        The protection state for the vm.
        """
        return pulumi.get(self, "vm_protection_state")

    @property
    @pulumi.getter(name="vmProtectionStateDescription")
    def vm_protection_state_description(self) -> Optional[str]:
        """
        The protection state description for the vm.
        """
        return pulumi.get(self, "vm_protection_state_description")


@pulumi.output_type
class InMageAzureV2SwitchProviderBlockingErrorDetailsResponse(dict):
    """
    InMageAzureV2 switch provider blocking error details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "errorCode":
            suggest = "error_code"
        elif key == "errorMessage":
            suggest = "error_message"
        elif key == "errorMessageParameters":
            suggest = "error_message_parameters"
        elif key == "errorTags":
            suggest = "error_tags"
        elif key == "possibleCauses":
            suggest = "possible_causes"
        elif key == "recommendedAction":
            suggest = "recommended_action"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InMageAzureV2SwitchProviderBlockingErrorDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InMageAzureV2SwitchProviderBlockingErrorDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InMageAzureV2SwitchProviderBlockingErrorDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 error_code: str,
                 error_message: str,
                 error_message_parameters: Mapping[str, str],
                 error_tags: Mapping[str, str],
                 possible_causes: str,
                 recommended_action: str):
        """
        InMageAzureV2 switch provider blocking error details.
        :param str error_code: The error code.
        :param str error_message: The error message.
        :param Mapping[str, str] error_message_parameters: The error message parameters.
        :param Mapping[str, str] error_tags: The error tags.
        :param str possible_causes: The possible causes.
        :param str recommended_action: The recommended action.
        """
        pulumi.set(__self__, "error_code", error_code)
        pulumi.set(__self__, "error_message", error_message)
        pulumi.set(__self__, "error_message_parameters", error_message_parameters)
        pulumi.set(__self__, "error_tags", error_tags)
        pulumi.set(__self__, "possible_causes", possible_causes)
        pulumi.set(__self__, "recommended_action", recommended_action)

    @property
    @pulumi.getter(name="errorCode")
    def error_code(self) -> str:
        """
        The error code.
        """
        return pulumi.get(self, "error_code")

    @property
    @pulumi.getter(name="errorMessage")
    def error_message(self) -> str:
        """
        The error message.
        """
        return pulumi.get(self, "error_message")

    @property
    @pulumi.getter(name="errorMessageParameters")
    def error_message_parameters(self) -> Mapping[str, str]:
        """
        The error message parameters.
        """
        return pulumi.get(self, "error_message_parameters")

    @property
    @pulumi.getter(name="errorTags")
    def error_tags(self) -> Mapping[str, str]:
        """
        The error tags.
        """
        return pulumi.get(self, "error_tags")

    @property
    @pulumi.getter(name="possibleCauses")
    def possible_causes(self) -> str:
        """
        The possible causes.
        """
        return pulumi.get(self, "possible_causes")

    @property
    @pulumi.getter(name="recommendedAction")
    def recommended_action(self) -> str:
        """
        The recommended action.
        """
        return pulumi.get(self, "recommended_action")


@pulumi.output_type
class InMageAzureV2SwitchProviderDetailsResponse(dict):
    """
    InMageAzureV2 switch provider details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetApplianceId":
            suggest = "target_appliance_id"
        elif key == "targetFabricId":
            suggest = "target_fabric_id"
        elif key == "targetResourceId":
            suggest = "target_resource_id"
        elif key == "targetVaultId":
            suggest = "target_vault_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InMageAzureV2SwitchProviderDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InMageAzureV2SwitchProviderDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InMageAzureV2SwitchProviderDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 target_appliance_id: str,
                 target_fabric_id: str,
                 target_resource_id: str,
                 target_vault_id: str):
        """
        InMageAzureV2 switch provider details.
        :param str target_appliance_id: The target appliance Id.
        :param str target_fabric_id: The target fabric Id.
        :param str target_resource_id: The target resource Id.
        :param str target_vault_id: The target vault Id.
        """
        pulumi.set(__self__, "target_appliance_id", target_appliance_id)
        pulumi.set(__self__, "target_fabric_id", target_fabric_id)
        pulumi.set(__self__, "target_resource_id", target_resource_id)
        pulumi.set(__self__, "target_vault_id", target_vault_id)

    @property
    @pulumi.getter(name="targetApplianceId")
    def target_appliance_id(self) -> str:
        """
        The target appliance Id.
        """
        return pulumi.get(self, "target_appliance_id")

    @property
    @pulumi.getter(name="targetFabricId")
    def target_fabric_id(self) -> str:
        """
        The target fabric Id.
        """
        return pulumi.get(self, "target_fabric_id")

    @property
    @pulumi.getter(name="targetResourceId")
    def target_resource_id(self) -> str:
        """
        The target resource Id.
        """
        return pulumi.get(self, "target_resource_id")

    @property
    @pulumi.getter(name="targetVaultId")
    def target_vault_id(self) -> str:
        """
        The target vault Id.
        """
        return pulumi.get(self, "target_vault_id")


@pulumi.output_type
class InMageBasePolicyDetailsResponse(dict):
    """
    Base class for the policies of providers using InMage replication.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceType":
            suggest = "instance_type"
        elif key == "appConsistentFrequencyInMinutes":
            suggest = "app_consistent_frequency_in_minutes"
        elif key == "multiVmSyncStatus":
            suggest = "multi_vm_sync_status"
        elif key == "recoveryPointHistory":
            suggest = "recovery_point_history"
        elif key == "recoveryPointThresholdInMinutes":
            suggest = "recovery_point_threshold_in_minutes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InMageBasePolicyDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InMageBasePolicyDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InMageBasePolicyDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_type: str,
                 app_consistent_frequency_in_minutes: Optional[int] = None,
                 multi_vm_sync_status: Optional[str] = None,
                 recovery_point_history: Optional[int] = None,
                 recovery_point_threshold_in_minutes: Optional[int] = None):
        """
        Base class for the policies of providers using InMage replication.
        :param str instance_type: Gets the class type. Overridden in derived classes.
               Expected value is 'InMageBasePolicyDetails'.
        :param int app_consistent_frequency_in_minutes: The app consistent snapshot frequency in minutes.
        :param str multi_vm_sync_status: A value indicating whether multi-VM sync has to be enabled.
        :param int recovery_point_history: The duration in minutes until which the recovery points need to be stored.
        :param int recovery_point_threshold_in_minutes: The recovery point threshold in minutes.
        """
        pulumi.set(__self__, "instance_type", 'InMageBasePolicyDetails')
        if app_consistent_frequency_in_minutes is not None:
            pulumi.set(__self__, "app_consistent_frequency_in_minutes", app_consistent_frequency_in_minutes)
        if multi_vm_sync_status is not None:
            pulumi.set(__self__, "multi_vm_sync_status", multi_vm_sync_status)
        if recovery_point_history is not None:
            pulumi.set(__self__, "recovery_point_history", recovery_point_history)
        if recovery_point_threshold_in_minutes is not None:
            pulumi.set(__self__, "recovery_point_threshold_in_minutes", recovery_point_threshold_in_minutes)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> str:
        """
        Gets the class type. Overridden in derived classes.
        Expected value is 'InMageBasePolicyDetails'.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="appConsistentFrequencyInMinutes")
    def app_consistent_frequency_in_minutes(self) -> Optional[int]:
        """
        The app consistent snapshot frequency in minutes.
        """
        return pulumi.get(self, "app_consistent_frequency_in_minutes")

    @property
    @pulumi.getter(name="multiVmSyncStatus")
    def multi_vm_sync_status(self) -> Optional[str]:
        """
        A value indicating whether multi-VM sync has to be enabled.
        """
        return pulumi.get(self, "multi_vm_sync_status")

    @property
    @pulumi.getter(name="recoveryPointHistory")
    def recovery_point_history(self) -> Optional[int]:
        """
        The duration in minutes until which the recovery points need to be stored.
        """
        return pulumi.get(self, "recovery_point_history")

    @property
    @pulumi.getter(name="recoveryPointThresholdInMinutes")
    def recovery_point_threshold_in_minutes(self) -> Optional[int]:
        """
        The recovery point threshold in minutes.
        """
        return pulumi.get(self, "recovery_point_threshold_in_minutes")


@pulumi.output_type
class InMageFabricSwitchProviderBlockingErrorDetailsResponse(dict):
    """
    InMageFabric switch provider blocking error details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "errorCode":
            suggest = "error_code"
        elif key == "errorMessage":
            suggest = "error_message"
        elif key == "errorMessageParameters":
            suggest = "error_message_parameters"
        elif key == "errorTags":
            suggest = "error_tags"
        elif key == "possibleCauses":
            suggest = "possible_causes"
        elif key == "recommendedAction":
            suggest = "recommended_action"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InMageFabricSwitchProviderBlockingErrorDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InMageFabricSwitchProviderBlockingErrorDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InMageFabricSwitchProviderBlockingErrorDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 error_code: str,
                 error_message: str,
                 error_message_parameters: Mapping[str, str],
                 error_tags: Mapping[str, str],
                 possible_causes: str,
                 recommended_action: str):
        """
        InMageFabric switch provider blocking error details.
        :param str error_code: The error code.
        :param str error_message: The error message.
        :param Mapping[str, str] error_message_parameters: The error message parameters.
        :param Mapping[str, str] error_tags: The error tags.
        :param str possible_causes: The possible causes.
        :param str recommended_action: The recommended action.
        """
        pulumi.set(__self__, "error_code", error_code)
        pulumi.set(__self__, "error_message", error_message)
        pulumi.set(__self__, "error_message_parameters", error_message_parameters)
        pulumi.set(__self__, "error_tags", error_tags)
        pulumi.set(__self__, "possible_causes", possible_causes)
        pulumi.set(__self__, "recommended_action", recommended_action)

    @property
    @pulumi.getter(name="errorCode")
    def error_code(self) -> str:
        """
        The error code.
        """
        return pulumi.get(self, "error_code")

    @property
    @pulumi.getter(name="errorMessage")
    def error_message(self) -> str:
        """
        The error message.
        """
        return pulumi.get(self, "error_message")

    @property
    @pulumi.getter(name="errorMessageParameters")
    def error_message_parameters(self) -> Mapping[str, str]:
        """
        The error message parameters.
        """
        return pulumi.get(self, "error_message_parameters")

    @property
    @pulumi.getter(name="errorTags")
    def error_tags(self) -> Mapping[str, str]:
        """
        The error tags.
        """
        return pulumi.get(self, "error_tags")

    @property
    @pulumi.getter(name="possibleCauses")
    def possible_causes(self) -> str:
        """
        The possible causes.
        """
        return pulumi.get(self, "possible_causes")

    @property
    @pulumi.getter(name="recommendedAction")
    def recommended_action(self) -> str:
        """
        The recommended action.
        """
        return pulumi.get(self, "recommended_action")


@pulumi.output_type
class InMagePolicyDetailsResponse(dict):
    """
    InMage specific protection profile details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceType":
            suggest = "instance_type"
        elif key == "appConsistentFrequencyInMinutes":
            suggest = "app_consistent_frequency_in_minutes"
        elif key == "multiVmSyncStatus":
            suggest = "multi_vm_sync_status"
        elif key == "recoveryPointHistory":
            suggest = "recovery_point_history"
        elif key == "recoveryPointThresholdInMinutes":
            suggest = "recovery_point_threshold_in_minutes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InMagePolicyDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InMagePolicyDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InMagePolicyDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_type: str,
                 app_consistent_frequency_in_minutes: Optional[int] = None,
                 multi_vm_sync_status: Optional[str] = None,
                 recovery_point_history: Optional[int] = None,
                 recovery_point_threshold_in_minutes: Optional[int] = None):
        """
        InMage specific protection profile details.
        :param str instance_type: Gets the class type. Overridden in derived classes.
               Expected value is 'InMage'.
        :param int app_consistent_frequency_in_minutes: The app consistent snapshot frequency in minutes.
        :param str multi_vm_sync_status: A value indicating whether multi-VM sync has to be enabled.
        :param int recovery_point_history: The duration in minutes until which the recovery points need to be stored.
        :param int recovery_point_threshold_in_minutes: The recovery point threshold in minutes.
        """
        pulumi.set(__self__, "instance_type", 'InMage')
        if app_consistent_frequency_in_minutes is not None:
            pulumi.set(__self__, "app_consistent_frequency_in_minutes", app_consistent_frequency_in_minutes)
        if multi_vm_sync_status is not None:
            pulumi.set(__self__, "multi_vm_sync_status", multi_vm_sync_status)
        if recovery_point_history is not None:
            pulumi.set(__self__, "recovery_point_history", recovery_point_history)
        if recovery_point_threshold_in_minutes is not None:
            pulumi.set(__self__, "recovery_point_threshold_in_minutes", recovery_point_threshold_in_minutes)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> str:
        """
        Gets the class type. Overridden in derived classes.
        Expected value is 'InMage'.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="appConsistentFrequencyInMinutes")
    def app_consistent_frequency_in_minutes(self) -> Optional[int]:
        """
        The app consistent snapshot frequency in minutes.
        """
        return pulumi.get(self, "app_consistent_frequency_in_minutes")

    @property
    @pulumi.getter(name="multiVmSyncStatus")
    def multi_vm_sync_status(self) -> Optional[str]:
        """
        A value indicating whether multi-VM sync has to be enabled.
        """
        return pulumi.get(self, "multi_vm_sync_status")

    @property
    @pulumi.getter(name="recoveryPointHistory")
    def recovery_point_history(self) -> Optional[int]:
        """
        The duration in minutes until which the recovery points need to be stored.
        """
        return pulumi.get(self, "recovery_point_history")

    @property
    @pulumi.getter(name="recoveryPointThresholdInMinutes")
    def recovery_point_threshold_in_minutes(self) -> Optional[int]:
        """
        The recovery point threshold in minutes.
        """
        return pulumi.get(self, "recovery_point_threshold_in_minutes")


@pulumi.output_type
class InMageProtectedDiskDetailsResponse(dict):
    """
    InMage protected disk details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "diskCapacityInBytes":
            suggest = "disk_capacity_in_bytes"
        elif key == "diskId":
            suggest = "disk_id"
        elif key == "diskName":
            suggest = "disk_name"
        elif key == "diskResized":
            suggest = "disk_resized"
        elif key == "fileSystemCapacityInBytes":
            suggest = "file_system_capacity_in_bytes"
        elif key == "healthErrorCode":
            suggest = "health_error_code"
        elif key == "lastRpoCalculatedTime":
            suggest = "last_rpo_calculated_time"
        elif key == "progressHealth":
            suggest = "progress_health"
        elif key == "progressStatus":
            suggest = "progress_status"
        elif key == "protectionStage":
            suggest = "protection_stage"
        elif key == "psDataInMB":
            suggest = "ps_data_in_mb"
        elif key == "resyncDurationInSeconds":
            suggest = "resync_duration_in_seconds"
        elif key == "resyncLast15MinutesTransferredBytes":
            suggest = "resync_last15_minutes_transferred_bytes"
        elif key == "resyncLastDataTransferTimeUTC":
            suggest = "resync_last_data_transfer_time_utc"
        elif key == "resyncProcessedBytes":
            suggest = "resync_processed_bytes"
        elif key == "resyncProgressPercentage":
            suggest = "resync_progress_percentage"
        elif key == "resyncRequired":
            suggest = "resync_required"
        elif key == "resyncStartTime":
            suggest = "resync_start_time"
        elif key == "resyncTotalTransferredBytes":
            suggest = "resync_total_transferred_bytes"
        elif key == "rpoInSeconds":
            suggest = "rpo_in_seconds"
        elif key == "sourceDataInMB":
            suggest = "source_data_in_mb"
        elif key == "targetDataInMB":
            suggest = "target_data_in_mb"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InMageProtectedDiskDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InMageProtectedDiskDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InMageProtectedDiskDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disk_capacity_in_bytes: Optional[float] = None,
                 disk_id: Optional[str] = None,
                 disk_name: Optional[str] = None,
                 disk_resized: Optional[str] = None,
                 file_system_capacity_in_bytes: Optional[float] = None,
                 health_error_code: Optional[str] = None,
                 last_rpo_calculated_time: Optional[str] = None,
                 progress_health: Optional[str] = None,
                 progress_status: Optional[str] = None,
                 protection_stage: Optional[str] = None,
                 ps_data_in_mb: Optional[float] = None,
                 resync_duration_in_seconds: Optional[float] = None,
                 resync_last15_minutes_transferred_bytes: Optional[float] = None,
                 resync_last_data_transfer_time_utc: Optional[str] = None,
                 resync_processed_bytes: Optional[float] = None,
                 resync_progress_percentage: Optional[int] = None,
                 resync_required: Optional[str] = None,
                 resync_start_time: Optional[str] = None,
                 resync_total_transferred_bytes: Optional[float] = None,
                 rpo_in_seconds: Optional[float] = None,
                 source_data_in_mb: Optional[float] = None,
                 target_data_in_mb: Optional[float] = None):
        """
        InMage protected disk details.
        :param float disk_capacity_in_bytes: The disk capacity in bytes.
        :param str disk_id: The disk id.
        :param str disk_name: The disk name.
        :param str disk_resized: A value indicating whether disk is resized.
        :param float file_system_capacity_in_bytes: The file system capacity in bytes.
        :param str health_error_code: The health error code for the disk.
        :param str last_rpo_calculated_time: The last RPO calculated time.
        :param str progress_health: The Progress Health.
        :param str progress_status: The Progress Status.
        :param str protection_stage: The protection stage.
        :param float ps_data_in_mb: The PS data transit in MB.
        :param float resync_duration_in_seconds: The resync duration in seconds.
        :param float resync_last15_minutes_transferred_bytes: The resync last 15 minutes transferred bytes.
        :param str resync_last_data_transfer_time_utc: The last data transfer time in UTC.
        :param float resync_processed_bytes: The resync processed bytes.
        :param int resync_progress_percentage: The resync progress percentage.
        :param str resync_required: A value indicating whether resync is required for this disk.
        :param str resync_start_time: The resync start time.
        :param float resync_total_transferred_bytes: The resync total transferred bytes.
        :param float rpo_in_seconds: The RPO in seconds.
        :param float source_data_in_mb: The source data transit in MB.
        :param float target_data_in_mb: The target data transit in MB.
        """
        if disk_capacity_in_bytes is not None:
            pulumi.set(__self__, "disk_capacity_in_bytes", disk_capacity_in_bytes)
        if disk_id is not None:
            pulumi.set(__self__, "disk_id", disk_id)
        if disk_name is not None:
            pulumi.set(__self__, "disk_name", disk_name)
        if disk_resized is not None:
            pulumi.set(__self__, "disk_resized", disk_resized)
        if file_system_capacity_in_bytes is not None:
            pulumi.set(__self__, "file_system_capacity_in_bytes", file_system_capacity_in_bytes)
        if health_error_code is not None:
            pulumi.set(__self__, "health_error_code", health_error_code)
        if last_rpo_calculated_time is not None:
            pulumi.set(__self__, "last_rpo_calculated_time", last_rpo_calculated_time)
        if progress_health is not None:
            pulumi.set(__self__, "progress_health", progress_health)
        if progress_status is not None:
            pulumi.set(__self__, "progress_status", progress_status)
        if protection_stage is not None:
            pulumi.set(__self__, "protection_stage", protection_stage)
        if ps_data_in_mb is not None:
            pulumi.set(__self__, "ps_data_in_mb", ps_data_in_mb)
        if resync_duration_in_seconds is not None:
            pulumi.set(__self__, "resync_duration_in_seconds", resync_duration_in_seconds)
        if resync_last15_minutes_transferred_bytes is not None:
            pulumi.set(__self__, "resync_last15_minutes_transferred_bytes", resync_last15_minutes_transferred_bytes)
        if resync_last_data_transfer_time_utc is not None:
            pulumi.set(__self__, "resync_last_data_transfer_time_utc", resync_last_data_transfer_time_utc)
        if resync_processed_bytes is not None:
            pulumi.set(__self__, "resync_processed_bytes", resync_processed_bytes)
        if resync_progress_percentage is not None:
            pulumi.set(__self__, "resync_progress_percentage", resync_progress_percentage)
        if resync_required is not None:
            pulumi.set(__self__, "resync_required", resync_required)
        if resync_start_time is not None:
            pulumi.set(__self__, "resync_start_time", resync_start_time)
        if resync_total_transferred_bytes is not None:
            pulumi.set(__self__, "resync_total_transferred_bytes", resync_total_transferred_bytes)
        if rpo_in_seconds is not None:
            pulumi.set(__self__, "rpo_in_seconds", rpo_in_seconds)
        if source_data_in_mb is not None:
            pulumi.set(__self__, "source_data_in_mb", source_data_in_mb)
        if target_data_in_mb is not None:
            pulumi.set(__self__, "target_data_in_mb", target_data_in_mb)

    @property
    @pulumi.getter(name="diskCapacityInBytes")
    def disk_capacity_in_bytes(self) -> Optional[float]:
        """
        The disk capacity in bytes.
        """
        return pulumi.get(self, "disk_capacity_in_bytes")

    @property
    @pulumi.getter(name="diskId")
    def disk_id(self) -> Optional[str]:
        """
        The disk id.
        """
        return pulumi.get(self, "disk_id")

    @property
    @pulumi.getter(name="diskName")
    def disk_name(self) -> Optional[str]:
        """
        The disk name.
        """
        return pulumi.get(self, "disk_name")

    @property
    @pulumi.getter(name="diskResized")
    def disk_resized(self) -> Optional[str]:
        """
        A value indicating whether disk is resized.
        """
        return pulumi.get(self, "disk_resized")

    @property
    @pulumi.getter(name="fileSystemCapacityInBytes")
    def file_system_capacity_in_bytes(self) -> Optional[float]:
        """
        The file system capacity in bytes.
        """
        return pulumi.get(self, "file_system_capacity_in_bytes")

    @property
    @pulumi.getter(name="healthErrorCode")
    def health_error_code(self) -> Optional[str]:
        """
        The health error code for the disk.
        """
        return pulumi.get(self, "health_error_code")

    @property
    @pulumi.getter(name="lastRpoCalculatedTime")
    def last_rpo_calculated_time(self) -> Optional[str]:
        """
        The last RPO calculated time.
        """
        return pulumi.get(self, "last_rpo_calculated_time")

    @property
    @pulumi.getter(name="progressHealth")
    def progress_health(self) -> Optional[str]:
        """
        The Progress Health.
        """
        return pulumi.get(self, "progress_health")

    @property
    @pulumi.getter(name="progressStatus")
    def progress_status(self) -> Optional[str]:
        """
        The Progress Status.
        """
        return pulumi.get(self, "progress_status")

    @property
    @pulumi.getter(name="protectionStage")
    def protection_stage(self) -> Optional[str]:
        """
        The protection stage.
        """
        return pulumi.get(self, "protection_stage")

    @property
    @pulumi.getter(name="psDataInMB")
    def ps_data_in_mb(self) -> Optional[float]:
        """
        The PS data transit in MB.
        """
        return pulumi.get(self, "ps_data_in_mb")

    @property
    @pulumi.getter(name="resyncDurationInSeconds")
    def resync_duration_in_seconds(self) -> Optional[float]:
        """
        The resync duration in seconds.
        """
        return pulumi.get(self, "resync_duration_in_seconds")

    @property
    @pulumi.getter(name="resyncLast15MinutesTransferredBytes")
    def resync_last15_minutes_transferred_bytes(self) -> Optional[float]:
        """
        The resync last 15 minutes transferred bytes.
        """
        return pulumi.get(self, "resync_last15_minutes_transferred_bytes")

    @property
    @pulumi.getter(name="resyncLastDataTransferTimeUTC")
    def resync_last_data_transfer_time_utc(self) -> Optional[str]:
        """
        The last data transfer time in UTC.
        """
        return pulumi.get(self, "resync_last_data_transfer_time_utc")

    @property
    @pulumi.getter(name="resyncProcessedBytes")
    def resync_processed_bytes(self) -> Optional[float]:
        """
        The resync processed bytes.
        """
        return pulumi.get(self, "resync_processed_bytes")

    @property
    @pulumi.getter(name="resyncProgressPercentage")
    def resync_progress_percentage(self) -> Optional[int]:
        """
        The resync progress percentage.
        """
        return pulumi.get(self, "resync_progress_percentage")

    @property
    @pulumi.getter(name="resyncRequired")
    def resync_required(self) -> Optional[str]:
        """
        A value indicating whether resync is required for this disk.
        """
        return pulumi.get(self, "resync_required")

    @property
    @pulumi.getter(name="resyncStartTime")
    def resync_start_time(self) -> Optional[str]:
        """
        The resync start time.
        """
        return pulumi.get(self, "resync_start_time")

    @property
    @pulumi.getter(name="resyncTotalTransferredBytes")
    def resync_total_transferred_bytes(self) -> Optional[float]:
        """
        The resync total transferred bytes.
        """
        return pulumi.get(self, "resync_total_transferred_bytes")

    @property
    @pulumi.getter(name="rpoInSeconds")
    def rpo_in_seconds(self) -> Optional[float]:
        """
        The RPO in seconds.
        """
        return pulumi.get(self, "rpo_in_seconds")

    @property
    @pulumi.getter(name="sourceDataInMB")
    def source_data_in_mb(self) -> Optional[float]:
        """
        The source data transit in MB.
        """
        return pulumi.get(self, "source_data_in_mb")

    @property
    @pulumi.getter(name="targetDataInMB")
    def target_data_in_mb(self) -> Optional[float]:
        """
        The target data transit in MB.
        """
        return pulumi.get(self, "target_data_in_mb")


@pulumi.output_type
class InMageRcmAgentUpgradeBlockingErrorDetailsResponse(dict):
    """
    InMageRcm source agent upgrade blocking error details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "errorCode":
            suggest = "error_code"
        elif key == "errorMessage":
            suggest = "error_message"
        elif key == "errorMessageParameters":
            suggest = "error_message_parameters"
        elif key == "errorTags":
            suggest = "error_tags"
        elif key == "possibleCauses":
            suggest = "possible_causes"
        elif key == "recommendedAction":
            suggest = "recommended_action"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InMageRcmAgentUpgradeBlockingErrorDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InMageRcmAgentUpgradeBlockingErrorDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InMageRcmAgentUpgradeBlockingErrorDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 error_code: str,
                 error_message: str,
                 error_message_parameters: Mapping[str, str],
                 error_tags: Mapping[str, str],
                 possible_causes: str,
                 recommended_action: str):
        """
        InMageRcm source agent upgrade blocking error details.
        :param str error_code: The error code.
        :param str error_message: The error message.
        :param Mapping[str, str] error_message_parameters: The error message parameters.
        :param Mapping[str, str] error_tags: The error tags.
        :param str possible_causes: The possible causes.
        :param str recommended_action: The recommended action.
        """
        pulumi.set(__self__, "error_code", error_code)
        pulumi.set(__self__, "error_message", error_message)
        pulumi.set(__self__, "error_message_parameters", error_message_parameters)
        pulumi.set(__self__, "error_tags", error_tags)
        pulumi.set(__self__, "possible_causes", possible_causes)
        pulumi.set(__self__, "recommended_action", recommended_action)

    @property
    @pulumi.getter(name="errorCode")
    def error_code(self) -> str:
        """
        The error code.
        """
        return pulumi.get(self, "error_code")

    @property
    @pulumi.getter(name="errorMessage")
    def error_message(self) -> str:
        """
        The error message.
        """
        return pulumi.get(self, "error_message")

    @property
    @pulumi.getter(name="errorMessageParameters")
    def error_message_parameters(self) -> Mapping[str, str]:
        """
        The error message parameters.
        """
        return pulumi.get(self, "error_message_parameters")

    @property
    @pulumi.getter(name="errorTags")
    def error_tags(self) -> Mapping[str, str]:
        """
        The error tags.
        """
        return pulumi.get(self, "error_tags")

    @property
    @pulumi.getter(name="possibleCauses")
    def possible_causes(self) -> str:
        """
        The possible causes.
        """
        return pulumi.get(self, "possible_causes")

    @property
    @pulumi.getter(name="recommendedAction")
    def recommended_action(self) -> str:
        """
        The recommended action.
        """
        return pulumi.get(self, "recommended_action")


@pulumi.output_type
class InMageRcmDiscoveredProtectedVmDetailsResponse(dict):
    """
    InMageRcm discovered protected VM details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdTimestamp":
            suggest = "created_timestamp"
        elif key == "ipAddresses":
            suggest = "ip_addresses"
        elif key == "isDeleted":
            suggest = "is_deleted"
        elif key == "lastDiscoveryTimeInUtc":
            suggest = "last_discovery_time_in_utc"
        elif key == "osName":
            suggest = "os_name"
        elif key == "powerStatus":
            suggest = "power_status"
        elif key == "updatedTimestamp":
            suggest = "updated_timestamp"
        elif key == "vCenterFqdn":
            suggest = "v_center_fqdn"
        elif key == "vCenterId":
            suggest = "v_center_id"
        elif key == "vmFqdn":
            suggest = "vm_fqdn"
        elif key == "vmwareToolsStatus":
            suggest = "vmware_tools_status"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InMageRcmDiscoveredProtectedVmDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InMageRcmDiscoveredProtectedVmDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InMageRcmDiscoveredProtectedVmDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_timestamp: str,
                 datastores: Sequence[str],
                 ip_addresses: Sequence[str],
                 is_deleted: bool,
                 last_discovery_time_in_utc: str,
                 os_name: str,
                 power_status: str,
                 updated_timestamp: str,
                 v_center_fqdn: str,
                 v_center_id: str,
                 vm_fqdn: str,
                 vmware_tools_status: str):
        """
        InMageRcm discovered protected VM details.
        :param str created_timestamp: The SDS created timestamp.
        :param Sequence[str] datastores: The list of datastores.
        :param Sequence[str] ip_addresses: The list of IP addresses.
        :param bool is_deleted: A value indicating whether the VM is deleted.
        :param str last_discovery_time_in_utc: The last time when SDS information discovered in SRS.
        :param str os_name: The VM's OS name.
        :param str power_status: The VM power status.
        :param str updated_timestamp: The SDS updated timestamp.
        :param str v_center_fqdn: The VCenter fqdn.
        :param str v_center_id: The VCenter Id.
        :param str vm_fqdn: The VM fqdn.
        :param str vmware_tools_status: The VMware tools status.
        """
        pulumi.set(__self__, "created_timestamp", created_timestamp)
        pulumi.set(__self__, "datastores", datastores)
        pulumi.set(__self__, "ip_addresses", ip_addresses)
        pulumi.set(__self__, "is_deleted", is_deleted)
        pulumi.set(__self__, "last_discovery_time_in_utc", last_discovery_time_in_utc)
        pulumi.set(__self__, "os_name", os_name)
        pulumi.set(__self__, "power_status", power_status)
        pulumi.set(__self__, "updated_timestamp", updated_timestamp)
        pulumi.set(__self__, "v_center_fqdn", v_center_fqdn)
        pulumi.set(__self__, "v_center_id", v_center_id)
        pulumi.set(__self__, "vm_fqdn", vm_fqdn)
        pulumi.set(__self__, "vmware_tools_status", vmware_tools_status)

    @property
    @pulumi.getter(name="createdTimestamp")
    def created_timestamp(self) -> str:
        """
        The SDS created timestamp.
        """
        return pulumi.get(self, "created_timestamp")

    @property
    @pulumi.getter
    def datastores(self) -> Sequence[str]:
        """
        The list of datastores.
        """
        return pulumi.get(self, "datastores")

    @property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> Sequence[str]:
        """
        The list of IP addresses.
        """
        return pulumi.get(self, "ip_addresses")

    @property
    @pulumi.getter(name="isDeleted")
    def is_deleted(self) -> bool:
        """
        A value indicating whether the VM is deleted.
        """
        return pulumi.get(self, "is_deleted")

    @property
    @pulumi.getter(name="lastDiscoveryTimeInUtc")
    def last_discovery_time_in_utc(self) -> str:
        """
        The last time when SDS information discovered in SRS.
        """
        return pulumi.get(self, "last_discovery_time_in_utc")

    @property
    @pulumi.getter(name="osName")
    def os_name(self) -> str:
        """
        The VM's OS name.
        """
        return pulumi.get(self, "os_name")

    @property
    @pulumi.getter(name="powerStatus")
    def power_status(self) -> str:
        """
        The VM power status.
        """
        return pulumi.get(self, "power_status")

    @property
    @pulumi.getter(name="updatedTimestamp")
    def updated_timestamp(self) -> str:
        """
        The SDS updated timestamp.
        """
        return pulumi.get(self, "updated_timestamp")

    @property
    @pulumi.getter(name="vCenterFqdn")
    def v_center_fqdn(self) -> str:
        """
        The VCenter fqdn.
        """
        return pulumi.get(self, "v_center_fqdn")

    @property
    @pulumi.getter(name="vCenterId")
    def v_center_id(self) -> str:
        """
        The VCenter Id.
        """
        return pulumi.get(self, "v_center_id")

    @property
    @pulumi.getter(name="vmFqdn")
    def vm_fqdn(self) -> str:
        """
        The VM fqdn.
        """
        return pulumi.get(self, "vm_fqdn")

    @property
    @pulumi.getter(name="vmwareToolsStatus")
    def vmware_tools_status(self) -> str:
        """
        The VMware tools status.
        """
        return pulumi.get(self, "vmware_tools_status")


@pulumi.output_type
class InMageRcmFabricSpecificDetailsResponse(dict):
    """
    InMageRcm fabric specific details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "agentDetails":
            suggest = "agent_details"
        elif key == "controlPlaneUri":
            suggest = "control_plane_uri"
        elif key == "dataPlaneUri":
            suggest = "data_plane_uri"
        elif key == "instanceType":
            suggest = "instance_type"
        elif key == "marsAgents":
            suggest = "mars_agents"
        elif key == "physicalSiteId":
            suggest = "physical_site_id"
        elif key == "processServers":
            suggest = "process_servers"
        elif key == "pushInstallers":
            suggest = "push_installers"
        elif key == "rcmProxies":
            suggest = "rcm_proxies"
        elif key == "replicationAgents":
            suggest = "replication_agents"
        elif key == "reprotectAgents":
            suggest = "reprotect_agents"
        elif key == "serviceContainerId":
            suggest = "service_container_id"
        elif key == "serviceEndpoint":
            suggest = "service_endpoint"
        elif key == "serviceResourceId":
            suggest = "service_resource_id"
        elif key == "vmwareSiteId":
            suggest = "vmware_site_id"
        elif key == "sourceAgentIdentityDetails":
            suggest = "source_agent_identity_details"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InMageRcmFabricSpecificDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InMageRcmFabricSpecificDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InMageRcmFabricSpecificDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 agent_details: Sequence['outputs.AgentDetailsResponse'],
                 control_plane_uri: str,
                 data_plane_uri: str,
                 dras: Sequence['outputs.DraDetailsResponse'],
                 instance_type: str,
                 mars_agents: Sequence['outputs.MarsAgentDetailsResponse'],
                 physical_site_id: str,
                 process_servers: Sequence['outputs.ProcessServerDetailsResponse'],
                 push_installers: Sequence['outputs.PushInstallerDetailsResponse'],
                 rcm_proxies: Sequence['outputs.RcmProxyDetailsResponse'],
                 replication_agents: Sequence['outputs.ReplicationAgentDetailsResponse'],
                 reprotect_agents: Sequence['outputs.ReprotectAgentDetailsResponse'],
                 service_container_id: str,
                 service_endpoint: str,
                 service_resource_id: str,
                 vmware_site_id: str,
                 source_agent_identity_details: Optional['outputs.IdentityProviderDetailsResponse'] = None):
        """
        InMageRcm fabric specific details.
        :param Sequence['AgentDetailsResponse'] agent_details: The list of agent details.
        :param str control_plane_uri: The control plane Uri.
        :param str data_plane_uri: The data plane Uri.
        :param Sequence['DraDetailsResponse'] dras: The list of DRAs.
        :param str instance_type: Gets the class type. Overridden in derived classes.
               Expected value is 'InMageRcm'.
        :param Sequence['MarsAgentDetailsResponse'] mars_agents: The list of Mars agents.
        :param str physical_site_id: The ARM Id of the physical site.
        :param Sequence['ProcessServerDetailsResponse'] process_servers: The list of process servers.
        :param Sequence['PushInstallerDetailsResponse'] push_installers: The list of push installers.
        :param Sequence['RcmProxyDetailsResponse'] rcm_proxies: The list of RCM proxies.
        :param Sequence['ReplicationAgentDetailsResponse'] replication_agents: The list of replication agents.
        :param Sequence['ReprotectAgentDetailsResponse'] reprotect_agents: The list of reprotect agents.
        :param str service_container_id: The service container Id.
        :param str service_endpoint: The service endpoint.
        :param str service_resource_id: The service resource Id.
        :param str vmware_site_id: The ARM Id of the VMware site.
        :param 'IdentityProviderDetailsResponse' source_agent_identity_details: The source agent identity details.
        """
        pulumi.set(__self__, "agent_details", agent_details)
        pulumi.set(__self__, "control_plane_uri", control_plane_uri)
        pulumi.set(__self__, "data_plane_uri", data_plane_uri)
        pulumi.set(__self__, "dras", dras)
        pulumi.set(__self__, "instance_type", 'InMageRcm')
        pulumi.set(__self__, "mars_agents", mars_agents)
        pulumi.set(__self__, "physical_site_id", physical_site_id)
        pulumi.set(__self__, "process_servers", process_servers)
        pulumi.set(__self__, "push_installers", push_installers)
        pulumi.set(__self__, "rcm_proxies", rcm_proxies)
        pulumi.set(__self__, "replication_agents", replication_agents)
        pulumi.set(__self__, "reprotect_agents", reprotect_agents)
        pulumi.set(__self__, "service_container_id", service_container_id)
        pulumi.set(__self__, "service_endpoint", service_endpoint)
        pulumi.set(__self__, "service_resource_id", service_resource_id)
        pulumi.set(__self__, "vmware_site_id", vmware_site_id)
        if source_agent_identity_details is not None:
            pulumi.set(__self__, "source_agent_identity_details", source_agent_identity_details)

    @property
    @pulumi.getter(name="agentDetails")
    def agent_details(self) -> Sequence['outputs.AgentDetailsResponse']:
        """
        The list of agent details.
        """
        return pulumi.get(self, "agent_details")

    @property
    @pulumi.getter(name="controlPlaneUri")
    def control_plane_uri(self) -> str:
        """
        The control plane Uri.
        """
        return pulumi.get(self, "control_plane_uri")

    @property
    @pulumi.getter(name="dataPlaneUri")
    def data_plane_uri(self) -> str:
        """
        The data plane Uri.
        """
        return pulumi.get(self, "data_plane_uri")

    @property
    @pulumi.getter
    def dras(self) -> Sequence['outputs.DraDetailsResponse']:
        """
        The list of DRAs.
        """
        return pulumi.get(self, "dras")

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> str:
        """
        Gets the class type. Overridden in derived classes.
        Expected value is 'InMageRcm'.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="marsAgents")
    def mars_agents(self) -> Sequence['outputs.MarsAgentDetailsResponse']:
        """
        The list of Mars agents.
        """
        return pulumi.get(self, "mars_agents")

    @property
    @pulumi.getter(name="physicalSiteId")
    def physical_site_id(self) -> str:
        """
        The ARM Id of the physical site.
        """
        return pulumi.get(self, "physical_site_id")

    @property
    @pulumi.getter(name="processServers")
    def process_servers(self) -> Sequence['outputs.ProcessServerDetailsResponse']:
        """
        The list of process servers.
        """
        return pulumi.get(self, "process_servers")

    @property
    @pulumi.getter(name="pushInstallers")
    def push_installers(self) -> Sequence['outputs.PushInstallerDetailsResponse']:
        """
        The list of push installers.
        """
        return pulumi.get(self, "push_installers")

    @property
    @pulumi.getter(name="rcmProxies")
    def rcm_proxies(self) -> Sequence['outputs.RcmProxyDetailsResponse']:
        """
        The list of RCM proxies.
        """
        return pulumi.get(self, "rcm_proxies")

    @property
    @pulumi.getter(name="replicationAgents")
    def replication_agents(self) -> Sequence['outputs.ReplicationAgentDetailsResponse']:
        """
        The list of replication agents.
        """
        return pulumi.get(self, "replication_agents")

    @property
    @pulumi.getter(name="reprotectAgents")
    def reprotect_agents(self) -> Sequence['outputs.ReprotectAgentDetailsResponse']:
        """
        The list of reprotect agents.
        """
        return pulumi.get(self, "reprotect_agents")

    @property
    @pulumi.getter(name="serviceContainerId")
    def service_container_id(self) -> str:
        """
        The service container Id.
        """
        return pulumi.get(self, "service_container_id")

    @property
    @pulumi.getter(name="serviceEndpoint")
    def service_endpoint(self) -> str:
        """
        The service endpoint.
        """
        return pulumi.get(self, "service_endpoint")

    @property
    @pulumi.getter(name="serviceResourceId")
    def service_resource_id(self) -> str:
        """
        The service resource Id.
        """
        return pulumi.get(self, "service_resource_id")

    @property
    @pulumi.getter(name="vmwareSiteId")
    def vmware_site_id(self) -> str:
        """
        The ARM Id of the VMware site.
        """
        return pulumi.get(self, "vmware_site_id")

    @property
    @pulumi.getter(name="sourceAgentIdentityDetails")
    def source_agent_identity_details(self) -> Optional['outputs.IdentityProviderDetailsResponse']:
        """
        The source agent identity details.
        """
        return pulumi.get(self, "source_agent_identity_details")


@pulumi.output_type
class InMageRcmFailbackDiscoveredProtectedVmDetailsResponse(dict):
    """
    InMageRcmFailback discovered VM details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdTimestamp":
            suggest = "created_timestamp"
        elif key == "ipAddresses":
            suggest = "ip_addresses"
        elif key == "isDeleted":
            suggest = "is_deleted"
        elif key == "lastDiscoveryTimeInUtc":
            suggest = "last_discovery_time_in_utc"
        elif key == "osName":
            suggest = "os_name"
        elif key == "powerStatus":
            suggest = "power_status"
        elif key == "updatedTimestamp":
            suggest = "updated_timestamp"
        elif key == "vCenterFqdn":
            suggest = "v_center_fqdn"
        elif key == "vCenterId":
            suggest = "v_center_id"
        elif key == "vmFqdn":
            suggest = "vm_fqdn"
        elif key == "vmwareToolsStatus":
            suggest = "vmware_tools_status"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InMageRcmFailbackDiscoveredProtectedVmDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InMageRcmFailbackDiscoveredProtectedVmDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InMageRcmFailbackDiscoveredProtectedVmDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_timestamp: str,
                 datastores: Sequence[str],
                 ip_addresses: Sequence[str],
                 is_deleted: bool,
                 last_discovery_time_in_utc: str,
                 os_name: str,
                 power_status: str,
                 updated_timestamp: str,
                 v_center_fqdn: str,
                 v_center_id: str,
                 vm_fqdn: str,
                 vmware_tools_status: str):
        """
        InMageRcmFailback discovered VM details.
        :param str created_timestamp: The SDS created timestamp.
        :param Sequence[str] datastores: The list of datastores.
        :param Sequence[str] ip_addresses: The list of IP addresses.
        :param bool is_deleted: A value indicating whether the VM is deleted.
        :param str last_discovery_time_in_utc: The last time when SDS information discovered in SRS.
        :param str os_name: The VM's OS name.
        :param str power_status: The VM power status.
        :param str updated_timestamp: The SDS updated timestamp.
        :param str v_center_fqdn: The VCenter fqdn.
        :param str v_center_id: The VCenter Id.
        :param str vm_fqdn: The VM fqdn.
        :param str vmware_tools_status: The VMware tools status.
        """
        pulumi.set(__self__, "created_timestamp", created_timestamp)
        pulumi.set(__self__, "datastores", datastores)
        pulumi.set(__self__, "ip_addresses", ip_addresses)
        pulumi.set(__self__, "is_deleted", is_deleted)
        pulumi.set(__self__, "last_discovery_time_in_utc", last_discovery_time_in_utc)
        pulumi.set(__self__, "os_name", os_name)
        pulumi.set(__self__, "power_status", power_status)
        pulumi.set(__self__, "updated_timestamp", updated_timestamp)
        pulumi.set(__self__, "v_center_fqdn", v_center_fqdn)
        pulumi.set(__self__, "v_center_id", v_center_id)
        pulumi.set(__self__, "vm_fqdn", vm_fqdn)
        pulumi.set(__self__, "vmware_tools_status", vmware_tools_status)

    @property
    @pulumi.getter(name="createdTimestamp")
    def created_timestamp(self) -> str:
        """
        The SDS created timestamp.
        """
        return pulumi.get(self, "created_timestamp")

    @property
    @pulumi.getter
    def datastores(self) -> Sequence[str]:
        """
        The list of datastores.
        """
        return pulumi.get(self, "datastores")

    @property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> Sequence[str]:
        """
        The list of IP addresses.
        """
        return pulumi.get(self, "ip_addresses")

    @property
    @pulumi.getter(name="isDeleted")
    def is_deleted(self) -> bool:
        """
        A value indicating whether the VM is deleted.
        """
        return pulumi.get(self, "is_deleted")

    @property
    @pulumi.getter(name="lastDiscoveryTimeInUtc")
    def last_discovery_time_in_utc(self) -> str:
        """
        The last time when SDS information discovered in SRS.
        """
        return pulumi.get(self, "last_discovery_time_in_utc")

    @property
    @pulumi.getter(name="osName")
    def os_name(self) -> str:
        """
        The VM's OS name.
        """
        return pulumi.get(self, "os_name")

    @property
    @pulumi.getter(name="powerStatus")
    def power_status(self) -> str:
        """
        The VM power status.
        """
        return pulumi.get(self, "power_status")

    @property
    @pulumi.getter(name="updatedTimestamp")
    def updated_timestamp(self) -> str:
        """
        The SDS updated timestamp.
        """
        return pulumi.get(self, "updated_timestamp")

    @property
    @pulumi.getter(name="vCenterFqdn")
    def v_center_fqdn(self) -> str:
        """
        The VCenter fqdn.
        """
        return pulumi.get(self, "v_center_fqdn")

    @property
    @pulumi.getter(name="vCenterId")
    def v_center_id(self) -> str:
        """
        The VCenter Id.
        """
        return pulumi.get(self, "v_center_id")

    @property
    @pulumi.getter(name="vmFqdn")
    def vm_fqdn(self) -> str:
        """
        The VM fqdn.
        """
        return pulumi.get(self, "vm_fqdn")

    @property
    @pulumi.getter(name="vmwareToolsStatus")
    def vmware_tools_status(self) -> str:
        """
        The VMware tools status.
        """
        return pulumi.get(self, "vmware_tools_status")


@pulumi.output_type
class InMageRcmFailbackMobilityAgentDetailsResponse(dict):
    """
    InMageRcmFailback mobility agent details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "agentVersionExpiryDate":
            suggest = "agent_version_expiry_date"
        elif key == "driverVersion":
            suggest = "driver_version"
        elif key == "driverVersionExpiryDate":
            suggest = "driver_version_expiry_date"
        elif key == "isUpgradeable":
            suggest = "is_upgradeable"
        elif key == "lastHeartbeatUtc":
            suggest = "last_heartbeat_utc"
        elif key == "latestUpgradableVersionWithoutReboot":
            suggest = "latest_upgradable_version_without_reboot"
        elif key == "latestVersion":
            suggest = "latest_version"
        elif key == "reasonsBlockingUpgrade":
            suggest = "reasons_blocking_upgrade"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InMageRcmFailbackMobilityAgentDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InMageRcmFailbackMobilityAgentDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InMageRcmFailbackMobilityAgentDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 agent_version_expiry_date: str,
                 driver_version: str,
                 driver_version_expiry_date: str,
                 is_upgradeable: str,
                 last_heartbeat_utc: str,
                 latest_upgradable_version_without_reboot: str,
                 latest_version: str,
                 reasons_blocking_upgrade: Sequence[str],
                 version: str):
        """
        InMageRcmFailback mobility agent details.
        :param str agent_version_expiry_date: The agent version expiry date.
        :param str driver_version: The driver version.
        :param str driver_version_expiry_date: The driver version expiry date.
        :param str is_upgradeable: A value indicating whether agent is upgradeable or not.
        :param str last_heartbeat_utc: The time of the last heartbeat received from the agent.
        :param str latest_upgradable_version_without_reboot: The latest upgradeable version available without reboot.
        :param str latest_version: The latest agent version available.
        :param Sequence[str] reasons_blocking_upgrade: The whether update is possible or not.
        :param str version: The agent version.
        """
        pulumi.set(__self__, "agent_version_expiry_date", agent_version_expiry_date)
        pulumi.set(__self__, "driver_version", driver_version)
        pulumi.set(__self__, "driver_version_expiry_date", driver_version_expiry_date)
        pulumi.set(__self__, "is_upgradeable", is_upgradeable)
        pulumi.set(__self__, "last_heartbeat_utc", last_heartbeat_utc)
        pulumi.set(__self__, "latest_upgradable_version_without_reboot", latest_upgradable_version_without_reboot)
        pulumi.set(__self__, "latest_version", latest_version)
        pulumi.set(__self__, "reasons_blocking_upgrade", reasons_blocking_upgrade)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="agentVersionExpiryDate")
    def agent_version_expiry_date(self) -> str:
        """
        The agent version expiry date.
        """
        return pulumi.get(self, "agent_version_expiry_date")

    @property
    @pulumi.getter(name="driverVersion")
    def driver_version(self) -> str:
        """
        The driver version.
        """
        return pulumi.get(self, "driver_version")

    @property
    @pulumi.getter(name="driverVersionExpiryDate")
    def driver_version_expiry_date(self) -> str:
        """
        The driver version expiry date.
        """
        return pulumi.get(self, "driver_version_expiry_date")

    @property
    @pulumi.getter(name="isUpgradeable")
    def is_upgradeable(self) -> str:
        """
        A value indicating whether agent is upgradeable or not.
        """
        return pulumi.get(self, "is_upgradeable")

    @property
    @pulumi.getter(name="lastHeartbeatUtc")
    def last_heartbeat_utc(self) -> str:
        """
        The time of the last heartbeat received from the agent.
        """
        return pulumi.get(self, "last_heartbeat_utc")

    @property
    @pulumi.getter(name="latestUpgradableVersionWithoutReboot")
    def latest_upgradable_version_without_reboot(self) -> str:
        """
        The latest upgradeable version available without reboot.
        """
        return pulumi.get(self, "latest_upgradable_version_without_reboot")

    @property
    @pulumi.getter(name="latestVersion")
    def latest_version(self) -> str:
        """
        The latest agent version available.
        """
        return pulumi.get(self, "latest_version")

    @property
    @pulumi.getter(name="reasonsBlockingUpgrade")
    def reasons_blocking_upgrade(self) -> Sequence[str]:
        """
        The whether update is possible or not.
        """
        return pulumi.get(self, "reasons_blocking_upgrade")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        The agent version.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class InMageRcmFailbackNicDetailsResponse(dict):
    """
    InMageRcmFailback NIC details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "adapterType":
            suggest = "adapter_type"
        elif key == "macAddress":
            suggest = "mac_address"
        elif key == "networkName":
            suggest = "network_name"
        elif key == "sourceIpAddress":
            suggest = "source_ip_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InMageRcmFailbackNicDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InMageRcmFailbackNicDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InMageRcmFailbackNicDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 adapter_type: str,
                 mac_address: str,
                 network_name: str,
                 source_ip_address: str):
        """
        InMageRcmFailback NIC details.
        :param str adapter_type: The adapter type.
        :param str mac_address: The mac address.
        :param str network_name: The network name.
        :param str source_ip_address: The IP address.
        """
        pulumi.set(__self__, "adapter_type", adapter_type)
        pulumi.set(__self__, "mac_address", mac_address)
        pulumi.set(__self__, "network_name", network_name)
        pulumi.set(__self__, "source_ip_address", source_ip_address)

    @property
    @pulumi.getter(name="adapterType")
    def adapter_type(self) -> str:
        """
        The adapter type.
        """
        return pulumi.get(self, "adapter_type")

    @property
    @pulumi.getter(name="macAddress")
    def mac_address(self) -> str:
        """
        The mac address.
        """
        return pulumi.get(self, "mac_address")

    @property
    @pulumi.getter(name="networkName")
    def network_name(self) -> str:
        """
        The network name.
        """
        return pulumi.get(self, "network_name")

    @property
    @pulumi.getter(name="sourceIpAddress")
    def source_ip_address(self) -> str:
        """
        The IP address.
        """
        return pulumi.get(self, "source_ip_address")


@pulumi.output_type
class InMageRcmFailbackPolicyDetailsResponse(dict):
    """
    InMageRcm failback specific policy details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceType":
            suggest = "instance_type"
        elif key == "appConsistentFrequencyInMinutes":
            suggest = "app_consistent_frequency_in_minutes"
        elif key == "crashConsistentFrequencyInMinutes":
            suggest = "crash_consistent_frequency_in_minutes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InMageRcmFailbackPolicyDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InMageRcmFailbackPolicyDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InMageRcmFailbackPolicyDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_type: str,
                 app_consistent_frequency_in_minutes: Optional[int] = None,
                 crash_consistent_frequency_in_minutes: Optional[int] = None):
        """
        InMageRcm failback specific policy details.
        :param str instance_type: Gets the class type. Overridden in derived classes.
               Expected value is 'InMageRcmFailback'.
        :param int app_consistent_frequency_in_minutes: The app consistent snapshot frequency in minutes.
        :param int crash_consistent_frequency_in_minutes: The crash consistent snapshot frequency in minutes.
        """
        pulumi.set(__self__, "instance_type", 'InMageRcmFailback')
        if app_consistent_frequency_in_minutes is not None:
            pulumi.set(__self__, "app_consistent_frequency_in_minutes", app_consistent_frequency_in_minutes)
        if crash_consistent_frequency_in_minutes is not None:
            pulumi.set(__self__, "crash_consistent_frequency_in_minutes", crash_consistent_frequency_in_minutes)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> str:
        """
        Gets the class type. Overridden in derived classes.
        Expected value is 'InMageRcmFailback'.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="appConsistentFrequencyInMinutes")
    def app_consistent_frequency_in_minutes(self) -> Optional[int]:
        """
        The app consistent snapshot frequency in minutes.
        """
        return pulumi.get(self, "app_consistent_frequency_in_minutes")

    @property
    @pulumi.getter(name="crashConsistentFrequencyInMinutes")
    def crash_consistent_frequency_in_minutes(self) -> Optional[int]:
        """
        The crash consistent snapshot frequency in minutes.
        """
        return pulumi.get(self, "crash_consistent_frequency_in_minutes")


@pulumi.output_type
class InMageRcmFailbackProtectedDiskDetailsResponse(dict):
    """
    InMageRcmFailback protected disk details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "capacityInBytes":
            suggest = "capacity_in_bytes"
        elif key == "dataPendingAtSourceAgentInMB":
            suggest = "data_pending_at_source_agent_in_mb"
        elif key == "dataPendingInLogDataStoreInMB":
            suggest = "data_pending_in_log_data_store_in_mb"
        elif key == "diskId":
            suggest = "disk_id"
        elif key == "diskName":
            suggest = "disk_name"
        elif key == "diskUuid":
            suggest = "disk_uuid"
        elif key == "isInitialReplicationComplete":
            suggest = "is_initial_replication_complete"
        elif key == "isOSDisk":
            suggest = "is_os_disk"
        elif key == "lastSyncTime":
            suggest = "last_sync_time"
        elif key == "irDetails":
            suggest = "ir_details"
        elif key == "resyncDetails":
            suggest = "resync_details"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InMageRcmFailbackProtectedDiskDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InMageRcmFailbackProtectedDiskDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InMageRcmFailbackProtectedDiskDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 capacity_in_bytes: float,
                 data_pending_at_source_agent_in_mb: float,
                 data_pending_in_log_data_store_in_mb: float,
                 disk_id: str,
                 disk_name: str,
                 disk_uuid: str,
                 is_initial_replication_complete: str,
                 is_os_disk: str,
                 last_sync_time: str,
                 ir_details: Optional['outputs.InMageRcmFailbackSyncDetailsResponse'] = None,
                 resync_details: Optional['outputs.InMageRcmFailbackSyncDetailsResponse'] = None):
        """
        InMageRcmFailback protected disk details.
        :param float capacity_in_bytes: The disk capacity in bytes.
        :param float data_pending_at_source_agent_in_mb: The data pending at source agent in MB.
        :param float data_pending_in_log_data_store_in_mb: The data pending in log data store in MB.
        :param str disk_id: The disk Id (reported by source agent).
        :param str disk_name: The disk name.
        :param str disk_uuid: The disk Uuid (reported by vCenter).
        :param str is_initial_replication_complete: A value indicating whether initial replication is complete or not.
        :param str is_os_disk: A value indicating whether the disk is the OS disk.
        :param str last_sync_time: The last sync time.
        :param 'InMageRcmFailbackSyncDetailsResponse' ir_details: The initial replication details.
        :param 'InMageRcmFailbackSyncDetailsResponse' resync_details: The resync details.
        """
        pulumi.set(__self__, "capacity_in_bytes", capacity_in_bytes)
        pulumi.set(__self__, "data_pending_at_source_agent_in_mb", data_pending_at_source_agent_in_mb)
        pulumi.set(__self__, "data_pending_in_log_data_store_in_mb", data_pending_in_log_data_store_in_mb)
        pulumi.set(__self__, "disk_id", disk_id)
        pulumi.set(__self__, "disk_name", disk_name)
        pulumi.set(__self__, "disk_uuid", disk_uuid)
        pulumi.set(__self__, "is_initial_replication_complete", is_initial_replication_complete)
        pulumi.set(__self__, "is_os_disk", is_os_disk)
        pulumi.set(__self__, "last_sync_time", last_sync_time)
        if ir_details is not None:
            pulumi.set(__self__, "ir_details", ir_details)
        if resync_details is not None:
            pulumi.set(__self__, "resync_details", resync_details)

    @property
    @pulumi.getter(name="capacityInBytes")
    def capacity_in_bytes(self) -> float:
        """
        The disk capacity in bytes.
        """
        return pulumi.get(self, "capacity_in_bytes")

    @property
    @pulumi.getter(name="dataPendingAtSourceAgentInMB")
    def data_pending_at_source_agent_in_mb(self) -> float:
        """
        The data pending at source agent in MB.
        """
        return pulumi.get(self, "data_pending_at_source_agent_in_mb")

    @property
    @pulumi.getter(name="dataPendingInLogDataStoreInMB")
    def data_pending_in_log_data_store_in_mb(self) -> float:
        """
        The data pending in log data store in MB.
        """
        return pulumi.get(self, "data_pending_in_log_data_store_in_mb")

    @property
    @pulumi.getter(name="diskId")
    def disk_id(self) -> str:
        """
        The disk Id (reported by source agent).
        """
        return pulumi.get(self, "disk_id")

    @property
    @pulumi.getter(name="diskName")
    def disk_name(self) -> str:
        """
        The disk name.
        """
        return pulumi.get(self, "disk_name")

    @property
    @pulumi.getter(name="diskUuid")
    def disk_uuid(self) -> str:
        """
        The disk Uuid (reported by vCenter).
        """
        return pulumi.get(self, "disk_uuid")

    @property
    @pulumi.getter(name="isInitialReplicationComplete")
    def is_initial_replication_complete(self) -> str:
        """
        A value indicating whether initial replication is complete or not.
        """
        return pulumi.get(self, "is_initial_replication_complete")

    @property
    @pulumi.getter(name="isOSDisk")
    def is_os_disk(self) -> str:
        """
        A value indicating whether the disk is the OS disk.
        """
        return pulumi.get(self, "is_os_disk")

    @property
    @pulumi.getter(name="lastSyncTime")
    def last_sync_time(self) -> str:
        """
        The last sync time.
        """
        return pulumi.get(self, "last_sync_time")

    @property
    @pulumi.getter(name="irDetails")
    def ir_details(self) -> Optional['outputs.InMageRcmFailbackSyncDetailsResponse']:
        """
        The initial replication details.
        """
        return pulumi.get(self, "ir_details")

    @property
    @pulumi.getter(name="resyncDetails")
    def resync_details(self) -> Optional['outputs.InMageRcmFailbackSyncDetailsResponse']:
        """
        The resync details.
        """
        return pulumi.get(self, "resync_details")


@pulumi.output_type
class InMageRcmFailbackReplicationDetailsResponse(dict):
    """
    InMageRcmFailback provider specific details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "azureVirtualMachineId":
            suggest = "azure_virtual_machine_id"
        elif key == "initialReplicationProcessedBytes":
            suggest = "initial_replication_processed_bytes"
        elif key == "initialReplicationProgressHealth":
            suggest = "initial_replication_progress_health"
        elif key == "initialReplicationProgressPercentage":
            suggest = "initial_replication_progress_percentage"
        elif key == "initialReplicationTransferredBytes":
            suggest = "initial_replication_transferred_bytes"
        elif key == "instanceType":
            suggest = "instance_type"
        elif key == "internalIdentifier":
            suggest = "internal_identifier"
        elif key == "isAgentRegistrationSuccessfulAfterFailover":
            suggest = "is_agent_registration_successful_after_failover"
        elif key == "lastPlannedFailoverStartTime":
            suggest = "last_planned_failover_start_time"
        elif key == "lastPlannedFailoverStatus":
            suggest = "last_planned_failover_status"
        elif key == "lastUsedPolicyFriendlyName":
            suggest = "last_used_policy_friendly_name"
        elif key == "lastUsedPolicyId":
            suggest = "last_used_policy_id"
        elif key == "logStorageAccountId":
            suggest = "log_storage_account_id"
        elif key == "multiVmGroupName":
            suggest = "multi_vm_group_name"
        elif key == "osType":
            suggest = "os_type"
        elif key == "reprotectAgentId":
            suggest = "reprotect_agent_id"
        elif key == "reprotectAgentName":
            suggest = "reprotect_agent_name"
        elif key == "resyncProcessedBytes":
            suggest = "resync_processed_bytes"
        elif key == "resyncProgressHealth":
            suggest = "resync_progress_health"
        elif key == "resyncProgressPercentage":
            suggest = "resync_progress_percentage"
        elif key == "resyncRequired":
            suggest = "resync_required"
        elif key == "resyncState":
            suggest = "resync_state"
        elif key == "resyncTransferredBytes":
            suggest = "resync_transferred_bytes"
        elif key == "targetDataStoreName":
            suggest = "target_data_store_name"
        elif key == "targetVmName":
            suggest = "target_vm_name"
        elif key == "targetvCenterId":
            suggest = "targetv_center_id"
        elif key == "discoveredVmDetails":
            suggest = "discovered_vm_details"
        elif key == "mobilityAgentDetails":
            suggest = "mobility_agent_details"
        elif key == "protectedDisks":
            suggest = "protected_disks"
        elif key == "vmNics":
            suggest = "vm_nics"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InMageRcmFailbackReplicationDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InMageRcmFailbackReplicationDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InMageRcmFailbackReplicationDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 azure_virtual_machine_id: str,
                 initial_replication_processed_bytes: float,
                 initial_replication_progress_health: str,
                 initial_replication_progress_percentage: int,
                 initial_replication_transferred_bytes: float,
                 instance_type: str,
                 internal_identifier: str,
                 is_agent_registration_successful_after_failover: bool,
                 last_planned_failover_start_time: str,
                 last_planned_failover_status: str,
                 last_used_policy_friendly_name: str,
                 last_used_policy_id: str,
                 log_storage_account_id: str,
                 multi_vm_group_name: str,
                 os_type: str,
                 reprotect_agent_id: str,
                 reprotect_agent_name: str,
                 resync_processed_bytes: float,
                 resync_progress_health: str,
                 resync_progress_percentage: int,
                 resync_required: str,
                 resync_state: str,
                 resync_transferred_bytes: float,
                 target_data_store_name: str,
                 target_vm_name: str,
                 targetv_center_id: str,
                 discovered_vm_details: Optional['outputs.InMageRcmFailbackDiscoveredProtectedVmDetailsResponse'] = None,
                 mobility_agent_details: Optional['outputs.InMageRcmFailbackMobilityAgentDetailsResponse'] = None,
                 protected_disks: Optional[Sequence['outputs.InMageRcmFailbackProtectedDiskDetailsResponse']] = None,
                 vm_nics: Optional[Sequence['outputs.InMageRcmFailbackNicDetailsResponse']] = None):
        """
        InMageRcmFailback provider specific details.
        :param str azure_virtual_machine_id: The ARM Id of the azure VM.
        :param float initial_replication_processed_bytes: The initial replication processed bytes. This includes sum of total bytes transferred and matched bytes on all selected disks in source VM.
        :param str initial_replication_progress_health: The initial replication progress health.
        :param int initial_replication_progress_percentage: The initial replication progress percentage.
        :param float initial_replication_transferred_bytes: The initial replication transferred bytes from source VM to target for all selected disks on source VM.
        :param str instance_type: Gets the Instance type.
               Expected value is 'InMageRcmFailback'.
        :param str internal_identifier: The virtual machine internal identifier.
        :param bool is_agent_registration_successful_after_failover: A value indicating whether agent registration was successful after failover.
        :param str last_planned_failover_start_time: The last planned failover start time.
        :param str last_planned_failover_status: The last planned failover status.
        :param str last_used_policy_friendly_name: The policy friendly name used by the forward replication.
        :param str last_used_policy_id: The policy Id used by the forward replication.
        :param str log_storage_account_id: The log storage account ARM Id.
        :param str multi_vm_group_name: The multi VM group name.
        :param str os_type: The type of the OS on the VM.
        :param str reprotect_agent_id: The reprotect agent Id.
        :param str reprotect_agent_name: The reprotect agent name.
        :param float resync_processed_bytes: The resync processed bytes. This includes sum of total bytes transferred and matched bytes on all selected disks in source VM.
        :param str resync_progress_health: The resync progress health.
        :param int resync_progress_percentage: The resync progress percentage.
        :param str resync_required: A value indicating whether resync is required.
        :param str resync_state: The resync state.
        :param float resync_transferred_bytes: The resync transferred bytes from source VM to target for all selected disks on source VM.
        :param str target_data_store_name: The target datastore name.
        :param str target_vm_name: The target VM name.
        :param str targetv_center_id: The target vCenter Id.
        :param 'InMageRcmFailbackDiscoveredProtectedVmDetailsResponse' discovered_vm_details: The discovered VM information.
        :param 'InMageRcmFailbackMobilityAgentDetailsResponse' mobility_agent_details: The mobility agent information.
        :param Sequence['InMageRcmFailbackProtectedDiskDetailsResponse'] protected_disks: The list of protected disks.
        :param Sequence['InMageRcmFailbackNicDetailsResponse'] vm_nics: The network details.
        """
        pulumi.set(__self__, "azure_virtual_machine_id", azure_virtual_machine_id)
        pulumi.set(__self__, "initial_replication_processed_bytes", initial_replication_processed_bytes)
        pulumi.set(__self__, "initial_replication_progress_health", initial_replication_progress_health)
        pulumi.set(__self__, "initial_replication_progress_percentage", initial_replication_progress_percentage)
        pulumi.set(__self__, "initial_replication_transferred_bytes", initial_replication_transferred_bytes)
        pulumi.set(__self__, "instance_type", 'InMageRcmFailback')
        pulumi.set(__self__, "internal_identifier", internal_identifier)
        pulumi.set(__self__, "is_agent_registration_successful_after_failover", is_agent_registration_successful_after_failover)
        pulumi.set(__self__, "last_planned_failover_start_time", last_planned_failover_start_time)
        pulumi.set(__self__, "last_planned_failover_status", last_planned_failover_status)
        pulumi.set(__self__, "last_used_policy_friendly_name", last_used_policy_friendly_name)
        pulumi.set(__self__, "last_used_policy_id", last_used_policy_id)
        pulumi.set(__self__, "log_storage_account_id", log_storage_account_id)
        pulumi.set(__self__, "multi_vm_group_name", multi_vm_group_name)
        pulumi.set(__self__, "os_type", os_type)
        pulumi.set(__self__, "reprotect_agent_id", reprotect_agent_id)
        pulumi.set(__self__, "reprotect_agent_name", reprotect_agent_name)
        pulumi.set(__self__, "resync_processed_bytes", resync_processed_bytes)
        pulumi.set(__self__, "resync_progress_health", resync_progress_health)
        pulumi.set(__self__, "resync_progress_percentage", resync_progress_percentage)
        pulumi.set(__self__, "resync_required", resync_required)
        pulumi.set(__self__, "resync_state", resync_state)
        pulumi.set(__self__, "resync_transferred_bytes", resync_transferred_bytes)
        pulumi.set(__self__, "target_data_store_name", target_data_store_name)
        pulumi.set(__self__, "target_vm_name", target_vm_name)
        pulumi.set(__self__, "targetv_center_id", targetv_center_id)
        if discovered_vm_details is not None:
            pulumi.set(__self__, "discovered_vm_details", discovered_vm_details)
        if mobility_agent_details is not None:
            pulumi.set(__self__, "mobility_agent_details", mobility_agent_details)
        if protected_disks is not None:
            pulumi.set(__self__, "protected_disks", protected_disks)
        if vm_nics is not None:
            pulumi.set(__self__, "vm_nics", vm_nics)

    @property
    @pulumi.getter(name="azureVirtualMachineId")
    def azure_virtual_machine_id(self) -> str:
        """
        The ARM Id of the azure VM.
        """
        return pulumi.get(self, "azure_virtual_machine_id")

    @property
    @pulumi.getter(name="initialReplicationProcessedBytes")
    def initial_replication_processed_bytes(self) -> float:
        """
        The initial replication processed bytes. This includes sum of total bytes transferred and matched bytes on all selected disks in source VM.
        """
        return pulumi.get(self, "initial_replication_processed_bytes")

    @property
    @pulumi.getter(name="initialReplicationProgressHealth")
    def initial_replication_progress_health(self) -> str:
        """
        The initial replication progress health.
        """
        return pulumi.get(self, "initial_replication_progress_health")

    @property
    @pulumi.getter(name="initialReplicationProgressPercentage")
    def initial_replication_progress_percentage(self) -> int:
        """
        The initial replication progress percentage.
        """
        return pulumi.get(self, "initial_replication_progress_percentage")

    @property
    @pulumi.getter(name="initialReplicationTransferredBytes")
    def initial_replication_transferred_bytes(self) -> float:
        """
        The initial replication transferred bytes from source VM to target for all selected disks on source VM.
        """
        return pulumi.get(self, "initial_replication_transferred_bytes")

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> str:
        """
        Gets the Instance type.
        Expected value is 'InMageRcmFailback'.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="internalIdentifier")
    def internal_identifier(self) -> str:
        """
        The virtual machine internal identifier.
        """
        return pulumi.get(self, "internal_identifier")

    @property
    @pulumi.getter(name="isAgentRegistrationSuccessfulAfterFailover")
    def is_agent_registration_successful_after_failover(self) -> bool:
        """
        A value indicating whether agent registration was successful after failover.
        """
        return pulumi.get(self, "is_agent_registration_successful_after_failover")

    @property
    @pulumi.getter(name="lastPlannedFailoverStartTime")
    def last_planned_failover_start_time(self) -> str:
        """
        The last planned failover start time.
        """
        return pulumi.get(self, "last_planned_failover_start_time")

    @property
    @pulumi.getter(name="lastPlannedFailoverStatus")
    def last_planned_failover_status(self) -> str:
        """
        The last planned failover status.
        """
        return pulumi.get(self, "last_planned_failover_status")

    @property
    @pulumi.getter(name="lastUsedPolicyFriendlyName")
    def last_used_policy_friendly_name(self) -> str:
        """
        The policy friendly name used by the forward replication.
        """
        return pulumi.get(self, "last_used_policy_friendly_name")

    @property
    @pulumi.getter(name="lastUsedPolicyId")
    def last_used_policy_id(self) -> str:
        """
        The policy Id used by the forward replication.
        """
        return pulumi.get(self, "last_used_policy_id")

    @property
    @pulumi.getter(name="logStorageAccountId")
    def log_storage_account_id(self) -> str:
        """
        The log storage account ARM Id.
        """
        return pulumi.get(self, "log_storage_account_id")

    @property
    @pulumi.getter(name="multiVmGroupName")
    def multi_vm_group_name(self) -> str:
        """
        The multi VM group name.
        """
        return pulumi.get(self, "multi_vm_group_name")

    @property
    @pulumi.getter(name="osType")
    def os_type(self) -> str:
        """
        The type of the OS on the VM.
        """
        return pulumi.get(self, "os_type")

    @property
    @pulumi.getter(name="reprotectAgentId")
    def reprotect_agent_id(self) -> str:
        """
        The reprotect agent Id.
        """
        return pulumi.get(self, "reprotect_agent_id")

    @property
    @pulumi.getter(name="reprotectAgentName")
    def reprotect_agent_name(self) -> str:
        """
        The reprotect agent name.
        """
        return pulumi.get(self, "reprotect_agent_name")

    @property
    @pulumi.getter(name="resyncProcessedBytes")
    def resync_processed_bytes(self) -> float:
        """
        The resync processed bytes. This includes sum of total bytes transferred and matched bytes on all selected disks in source VM.
        """
        return pulumi.get(self, "resync_processed_bytes")

    @property
    @pulumi.getter(name="resyncProgressHealth")
    def resync_progress_health(self) -> str:
        """
        The resync progress health.
        """
        return pulumi.get(self, "resync_progress_health")

    @property
    @pulumi.getter(name="resyncProgressPercentage")
    def resync_progress_percentage(self) -> int:
        """
        The resync progress percentage.
        """
        return pulumi.get(self, "resync_progress_percentage")

    @property
    @pulumi.getter(name="resyncRequired")
    def resync_required(self) -> str:
        """
        A value indicating whether resync is required.
        """
        return pulumi.get(self, "resync_required")

    @property
    @pulumi.getter(name="resyncState")
    def resync_state(self) -> str:
        """
        The resync state.
        """
        return pulumi.get(self, "resync_state")

    @property
    @pulumi.getter(name="resyncTransferredBytes")
    def resync_transferred_bytes(self) -> float:
        """
        The resync transferred bytes from source VM to target for all selected disks on source VM.
        """
        return pulumi.get(self, "resync_transferred_bytes")

    @property
    @pulumi.getter(name="targetDataStoreName")
    def target_data_store_name(self) -> str:
        """
        The target datastore name.
        """
        return pulumi.get(self, "target_data_store_name")

    @property
    @pulumi.getter(name="targetVmName")
    def target_vm_name(self) -> str:
        """
        The target VM name.
        """
        return pulumi.get(self, "target_vm_name")

    @property
    @pulumi.getter(name="targetvCenterId")
    def targetv_center_id(self) -> str:
        """
        The target vCenter Id.
        """
        return pulumi.get(self, "targetv_center_id")

    @property
    @pulumi.getter(name="discoveredVmDetails")
    def discovered_vm_details(self) -> Optional['outputs.InMageRcmFailbackDiscoveredProtectedVmDetailsResponse']:
        """
        The discovered VM information.
        """
        return pulumi.get(self, "discovered_vm_details")

    @property
    @pulumi.getter(name="mobilityAgentDetails")
    def mobility_agent_details(self) -> Optional['outputs.InMageRcmFailbackMobilityAgentDetailsResponse']:
        """
        The mobility agent information.
        """
        return pulumi.get(self, "mobility_agent_details")

    @property
    @pulumi.getter(name="protectedDisks")
    def protected_disks(self) -> Optional[Sequence['outputs.InMageRcmFailbackProtectedDiskDetailsResponse']]:
        """
        The list of protected disks.
        """
        return pulumi.get(self, "protected_disks")

    @property
    @pulumi.getter(name="vmNics")
    def vm_nics(self) -> Optional[Sequence['outputs.InMageRcmFailbackNicDetailsResponse']]:
        """
        The network details.
        """
        return pulumi.get(self, "vm_nics")


@pulumi.output_type
class InMageRcmFailbackSyncDetailsResponse(dict):
    """
    InMageRcmFailback disk level sync details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "last15MinutesTransferredBytes":
            suggest = "last15_minutes_transferred_bytes"
        elif key == "lastDataTransferTimeUtc":
            suggest = "last_data_transfer_time_utc"
        elif key == "lastRefreshTime":
            suggest = "last_refresh_time"
        elif key == "processedBytes":
            suggest = "processed_bytes"
        elif key == "progressHealth":
            suggest = "progress_health"
        elif key == "progressPercentage":
            suggest = "progress_percentage"
        elif key == "startTime":
            suggest = "start_time"
        elif key == "transferredBytes":
            suggest = "transferred_bytes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InMageRcmFailbackSyncDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InMageRcmFailbackSyncDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InMageRcmFailbackSyncDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 last15_minutes_transferred_bytes: float,
                 last_data_transfer_time_utc: str,
                 last_refresh_time: str,
                 processed_bytes: float,
                 progress_health: str,
                 progress_percentage: int,
                 start_time: str,
                 transferred_bytes: float):
        """
        InMageRcmFailback disk level sync details.
        :param float last15_minutes_transferred_bytes: The bytes transferred in last 15 minutes from source VM to target.
        :param str last_data_transfer_time_utc: The time of the last data transfer from source VM to target.
        :param str last_refresh_time: The last refresh time.
        :param float processed_bytes: The total processed bytes. This includes bytes that are transferred from source VM to target and matched bytes.
        :param str progress_health: The progress health.
        :param int progress_percentage: Progress in percentage. Progress percentage is calculated based on processed bytes.
        :param str start_time: The start time.
        :param float transferred_bytes: The transferred bytes from source VM to azure for the disk.
        """
        pulumi.set(__self__, "last15_minutes_transferred_bytes", last15_minutes_transferred_bytes)
        pulumi.set(__self__, "last_data_transfer_time_utc", last_data_transfer_time_utc)
        pulumi.set(__self__, "last_refresh_time", last_refresh_time)
        pulumi.set(__self__, "processed_bytes", processed_bytes)
        pulumi.set(__self__, "progress_health", progress_health)
        pulumi.set(__self__, "progress_percentage", progress_percentage)
        pulumi.set(__self__, "start_time", start_time)
        pulumi.set(__self__, "transferred_bytes", transferred_bytes)

    @property
    @pulumi.getter(name="last15MinutesTransferredBytes")
    def last15_minutes_transferred_bytes(self) -> float:
        """
        The bytes transferred in last 15 minutes from source VM to target.
        """
        return pulumi.get(self, "last15_minutes_transferred_bytes")

    @property
    @pulumi.getter(name="lastDataTransferTimeUtc")
    def last_data_transfer_time_utc(self) -> str:
        """
        The time of the last data transfer from source VM to target.
        """
        return pulumi.get(self, "last_data_transfer_time_utc")

    @property
    @pulumi.getter(name="lastRefreshTime")
    def last_refresh_time(self) -> str:
        """
        The last refresh time.
        """
        return pulumi.get(self, "last_refresh_time")

    @property
    @pulumi.getter(name="processedBytes")
    def processed_bytes(self) -> float:
        """
        The total processed bytes. This includes bytes that are transferred from source VM to target and matched bytes.
        """
        return pulumi.get(self, "processed_bytes")

    @property
    @pulumi.getter(name="progressHealth")
    def progress_health(self) -> str:
        """
        The progress health.
        """
        return pulumi.get(self, "progress_health")

    @property
    @pulumi.getter(name="progressPercentage")
    def progress_percentage(self) -> int:
        """
        Progress in percentage. Progress percentage is calculated based on processed bytes.
        """
        return pulumi.get(self, "progress_percentage")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> str:
        """
        The start time.
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter(name="transferredBytes")
    def transferred_bytes(self) -> float:
        """
        The transferred bytes from source VM to azure for the disk.
        """
        return pulumi.get(self, "transferred_bytes")


@pulumi.output_type
class InMageRcmLastAgentUpgradeErrorDetailsResponse(dict):
    """
    InMageRcm last source agent upgrade error details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "errorCode":
            suggest = "error_code"
        elif key == "errorMessage":
            suggest = "error_message"
        elif key == "errorMessageParameters":
            suggest = "error_message_parameters"
        elif key == "errorTags":
            suggest = "error_tags"
        elif key == "possibleCauses":
            suggest = "possible_causes"
        elif key == "recommendedAction":
            suggest = "recommended_action"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InMageRcmLastAgentUpgradeErrorDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InMageRcmLastAgentUpgradeErrorDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InMageRcmLastAgentUpgradeErrorDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 error_code: str,
                 error_message: str,
                 error_message_parameters: Mapping[str, str],
                 error_tags: Mapping[str, str],
                 possible_causes: str,
                 recommended_action: str):
        """
        InMageRcm last source agent upgrade error details.
        :param str error_code: The error code.
        :param str error_message: The error message.
        :param Mapping[str, str] error_message_parameters: The error message parameters.
        :param Mapping[str, str] error_tags: The error tags.
        :param str possible_causes: The possible causes.
        :param str recommended_action: The recommended action.
        """
        pulumi.set(__self__, "error_code", error_code)
        pulumi.set(__self__, "error_message", error_message)
        pulumi.set(__self__, "error_message_parameters", error_message_parameters)
        pulumi.set(__self__, "error_tags", error_tags)
        pulumi.set(__self__, "possible_causes", possible_causes)
        pulumi.set(__self__, "recommended_action", recommended_action)

    @property
    @pulumi.getter(name="errorCode")
    def error_code(self) -> str:
        """
        The error code.
        """
        return pulumi.get(self, "error_code")

    @property
    @pulumi.getter(name="errorMessage")
    def error_message(self) -> str:
        """
        The error message.
        """
        return pulumi.get(self, "error_message")

    @property
    @pulumi.getter(name="errorMessageParameters")
    def error_message_parameters(self) -> Mapping[str, str]:
        """
        The error message parameters.
        """
        return pulumi.get(self, "error_message_parameters")

    @property
    @pulumi.getter(name="errorTags")
    def error_tags(self) -> Mapping[str, str]:
        """
        The error tags.
        """
        return pulumi.get(self, "error_tags")

    @property
    @pulumi.getter(name="possibleCauses")
    def possible_causes(self) -> str:
        """
        The possible causes.
        """
        return pulumi.get(self, "possible_causes")

    @property
    @pulumi.getter(name="recommendedAction")
    def recommended_action(self) -> str:
        """
        The recommended action.
        """
        return pulumi.get(self, "recommended_action")


@pulumi.output_type
class InMageRcmMobilityAgentDetailsResponse(dict):
    """
    InMageRcm mobility agent details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "agentVersionExpiryDate":
            suggest = "agent_version_expiry_date"
        elif key == "driverVersion":
            suggest = "driver_version"
        elif key == "driverVersionExpiryDate":
            suggest = "driver_version_expiry_date"
        elif key == "isUpgradeable":
            suggest = "is_upgradeable"
        elif key == "lastHeartbeatUtc":
            suggest = "last_heartbeat_utc"
        elif key == "latestAgentReleaseDate":
            suggest = "latest_agent_release_date"
        elif key == "latestUpgradableVersionWithoutReboot":
            suggest = "latest_upgradable_version_without_reboot"
        elif key == "latestVersion":
            suggest = "latest_version"
        elif key == "reasonsBlockingUpgrade":
            suggest = "reasons_blocking_upgrade"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InMageRcmMobilityAgentDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InMageRcmMobilityAgentDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InMageRcmMobilityAgentDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 agent_version_expiry_date: str,
                 driver_version: str,
                 driver_version_expiry_date: str,
                 is_upgradeable: str,
                 last_heartbeat_utc: str,
                 latest_agent_release_date: str,
                 latest_upgradable_version_without_reboot: str,
                 latest_version: str,
                 reasons_blocking_upgrade: Sequence[str],
                 version: str):
        """
        InMageRcm mobility agent details.
        :param str agent_version_expiry_date: The agent version expiry date.
        :param str driver_version: The driver version.
        :param str driver_version_expiry_date: The driver version expiry date.
        :param str is_upgradeable: A value indicating whether agent is upgradeable or not.
        :param str last_heartbeat_utc: The time of the last heartbeat received from the agent.
        :param str latest_agent_release_date: The latest agent version release date.
        :param str latest_upgradable_version_without_reboot: The latest upgradeable version available without reboot.
        :param str latest_version: The latest agent version available.
        :param Sequence[str] reasons_blocking_upgrade: The whether update is possible or not.
        :param str version: The agent version.
        """
        pulumi.set(__self__, "agent_version_expiry_date", agent_version_expiry_date)
        pulumi.set(__self__, "driver_version", driver_version)
        pulumi.set(__self__, "driver_version_expiry_date", driver_version_expiry_date)
        pulumi.set(__self__, "is_upgradeable", is_upgradeable)
        pulumi.set(__self__, "last_heartbeat_utc", last_heartbeat_utc)
        pulumi.set(__self__, "latest_agent_release_date", latest_agent_release_date)
        pulumi.set(__self__, "latest_upgradable_version_without_reboot", latest_upgradable_version_without_reboot)
        pulumi.set(__self__, "latest_version", latest_version)
        pulumi.set(__self__, "reasons_blocking_upgrade", reasons_blocking_upgrade)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="agentVersionExpiryDate")
    def agent_version_expiry_date(self) -> str:
        """
        The agent version expiry date.
        """
        return pulumi.get(self, "agent_version_expiry_date")

    @property
    @pulumi.getter(name="driverVersion")
    def driver_version(self) -> str:
        """
        The driver version.
        """
        return pulumi.get(self, "driver_version")

    @property
    @pulumi.getter(name="driverVersionExpiryDate")
    def driver_version_expiry_date(self) -> str:
        """
        The driver version expiry date.
        """
        return pulumi.get(self, "driver_version_expiry_date")

    @property
    @pulumi.getter(name="isUpgradeable")
    def is_upgradeable(self) -> str:
        """
        A value indicating whether agent is upgradeable or not.
        """
        return pulumi.get(self, "is_upgradeable")

    @property
    @pulumi.getter(name="lastHeartbeatUtc")
    def last_heartbeat_utc(self) -> str:
        """
        The time of the last heartbeat received from the agent.
        """
        return pulumi.get(self, "last_heartbeat_utc")

    @property
    @pulumi.getter(name="latestAgentReleaseDate")
    def latest_agent_release_date(self) -> str:
        """
        The latest agent version release date.
        """
        return pulumi.get(self, "latest_agent_release_date")

    @property
    @pulumi.getter(name="latestUpgradableVersionWithoutReboot")
    def latest_upgradable_version_without_reboot(self) -> str:
        """
        The latest upgradeable version available without reboot.
        """
        return pulumi.get(self, "latest_upgradable_version_without_reboot")

    @property
    @pulumi.getter(name="latestVersion")
    def latest_version(self) -> str:
        """
        The latest agent version available.
        """
        return pulumi.get(self, "latest_version")

    @property
    @pulumi.getter(name="reasonsBlockingUpgrade")
    def reasons_blocking_upgrade(self) -> Sequence[str]:
        """
        The whether update is possible or not.
        """
        return pulumi.get(self, "reasons_blocking_upgrade")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        The agent version.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class InMageRcmNicDetailsResponse(dict):
    """
    InMageRcm NIC details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nicId":
            suggest = "nic_id"
        elif key == "sourceIPAddress":
            suggest = "source_ip_address"
        elif key == "sourceIPAddressType":
            suggest = "source_ip_address_type"
        elif key == "sourceNetworkId":
            suggest = "source_network_id"
        elif key == "sourceSubnetName":
            suggest = "source_subnet_name"
        elif key == "isPrimaryNic":
            suggest = "is_primary_nic"
        elif key == "isSelectedForFailover":
            suggest = "is_selected_for_failover"
        elif key == "targetIPAddress":
            suggest = "target_ip_address"
        elif key == "targetIPAddressType":
            suggest = "target_ip_address_type"
        elif key == "targetSubnetName":
            suggest = "target_subnet_name"
        elif key == "testIPAddress":
            suggest = "test_ip_address"
        elif key == "testIPAddressType":
            suggest = "test_ip_address_type"
        elif key == "testSubnetName":
            suggest = "test_subnet_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InMageRcmNicDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InMageRcmNicDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InMageRcmNicDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 nic_id: str,
                 source_ip_address: str,
                 source_ip_address_type: str,
                 source_network_id: str,
                 source_subnet_name: str,
                 is_primary_nic: Optional[str] = None,
                 is_selected_for_failover: Optional[str] = None,
                 target_ip_address: Optional[str] = None,
                 target_ip_address_type: Optional[str] = None,
                 target_subnet_name: Optional[str] = None,
                 test_ip_address: Optional[str] = None,
                 test_ip_address_type: Optional[str] = None,
                 test_subnet_name: Optional[str] = None):
        """
        InMageRcm NIC details.
        :param str nic_id: The NIC Id.
        :param str source_ip_address: The source IP address.
        :param str source_ip_address_type: The source IP address type.
        :param str source_network_id: Source network Id.
        :param str source_subnet_name: Source subnet name.
        :param str is_primary_nic: A value indicating whether this is the primary NIC.
        :param str is_selected_for_failover: A value indicating whether this NIC is selected for failover.
        :param str target_ip_address: The target IP address.
        :param str target_ip_address_type: The target IP address type.
        :param str target_subnet_name: Target subnet name.
        :param str test_ip_address: The test IP address.
        :param str test_ip_address_type: The test IP address type.
        :param str test_subnet_name: Test subnet name.
        """
        pulumi.set(__self__, "nic_id", nic_id)
        pulumi.set(__self__, "source_ip_address", source_ip_address)
        pulumi.set(__self__, "source_ip_address_type", source_ip_address_type)
        pulumi.set(__self__, "source_network_id", source_network_id)
        pulumi.set(__self__, "source_subnet_name", source_subnet_name)
        if is_primary_nic is not None:
            pulumi.set(__self__, "is_primary_nic", is_primary_nic)
        if is_selected_for_failover is not None:
            pulumi.set(__self__, "is_selected_for_failover", is_selected_for_failover)
        if target_ip_address is not None:
            pulumi.set(__self__, "target_ip_address", target_ip_address)
        if target_ip_address_type is not None:
            pulumi.set(__self__, "target_ip_address_type", target_ip_address_type)
        if target_subnet_name is not None:
            pulumi.set(__self__, "target_subnet_name", target_subnet_name)
        if test_ip_address is not None:
            pulumi.set(__self__, "test_ip_address", test_ip_address)
        if test_ip_address_type is not None:
            pulumi.set(__self__, "test_ip_address_type", test_ip_address_type)
        if test_subnet_name is not None:
            pulumi.set(__self__, "test_subnet_name", test_subnet_name)

    @property
    @pulumi.getter(name="nicId")
    def nic_id(self) -> str:
        """
        The NIC Id.
        """
        return pulumi.get(self, "nic_id")

    @property
    @pulumi.getter(name="sourceIPAddress")
    def source_ip_address(self) -> str:
        """
        The source IP address.
        """
        return pulumi.get(self, "source_ip_address")

    @property
    @pulumi.getter(name="sourceIPAddressType")
    def source_ip_address_type(self) -> str:
        """
        The source IP address type.
        """
        return pulumi.get(self, "source_ip_address_type")

    @property
    @pulumi.getter(name="sourceNetworkId")
    def source_network_id(self) -> str:
        """
        Source network Id.
        """
        return pulumi.get(self, "source_network_id")

    @property
    @pulumi.getter(name="sourceSubnetName")
    def source_subnet_name(self) -> str:
        """
        Source subnet name.
        """
        return pulumi.get(self, "source_subnet_name")

    @property
    @pulumi.getter(name="isPrimaryNic")
    def is_primary_nic(self) -> Optional[str]:
        """
        A value indicating whether this is the primary NIC.
        """
        return pulumi.get(self, "is_primary_nic")

    @property
    @pulumi.getter(name="isSelectedForFailover")
    def is_selected_for_failover(self) -> Optional[str]:
        """
        A value indicating whether this NIC is selected for failover.
        """
        return pulumi.get(self, "is_selected_for_failover")

    @property
    @pulumi.getter(name="targetIPAddress")
    def target_ip_address(self) -> Optional[str]:
        """
        The target IP address.
        """
        return pulumi.get(self, "target_ip_address")

    @property
    @pulumi.getter(name="targetIPAddressType")
    def target_ip_address_type(self) -> Optional[str]:
        """
        The target IP address type.
        """
        return pulumi.get(self, "target_ip_address_type")

    @property
    @pulumi.getter(name="targetSubnetName")
    def target_subnet_name(self) -> Optional[str]:
        """
        Target subnet name.
        """
        return pulumi.get(self, "target_subnet_name")

    @property
    @pulumi.getter(name="testIPAddress")
    def test_ip_address(self) -> Optional[str]:
        """
        The test IP address.
        """
        return pulumi.get(self, "test_ip_address")

    @property
    @pulumi.getter(name="testIPAddressType")
    def test_ip_address_type(self) -> Optional[str]:
        """
        The test IP address type.
        """
        return pulumi.get(self, "test_ip_address_type")

    @property
    @pulumi.getter(name="testSubnetName")
    def test_subnet_name(self) -> Optional[str]:
        """
        Test subnet name.
        """
        return pulumi.get(self, "test_subnet_name")


@pulumi.output_type
class InMageRcmPolicyDetailsResponse(dict):
    """
    InMageRcm specific policy details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceType":
            suggest = "instance_type"
        elif key == "appConsistentFrequencyInMinutes":
            suggest = "app_consistent_frequency_in_minutes"
        elif key == "crashConsistentFrequencyInMinutes":
            suggest = "crash_consistent_frequency_in_minutes"
        elif key == "enableMultiVmSync":
            suggest = "enable_multi_vm_sync"
        elif key == "recoveryPointHistoryInMinutes":
            suggest = "recovery_point_history_in_minutes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InMageRcmPolicyDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InMageRcmPolicyDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InMageRcmPolicyDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_type: str,
                 app_consistent_frequency_in_minutes: Optional[int] = None,
                 crash_consistent_frequency_in_minutes: Optional[int] = None,
                 enable_multi_vm_sync: Optional[str] = None,
                 recovery_point_history_in_minutes: Optional[int] = None):
        """
        InMageRcm specific policy details.
        :param str instance_type: Gets the class type. Overridden in derived classes.
               Expected value is 'InMageRcm'.
        :param int app_consistent_frequency_in_minutes: The app consistent snapshot frequency in minutes.
        :param int crash_consistent_frequency_in_minutes: The crash consistent snapshot frequency in minutes.
        :param str enable_multi_vm_sync: A value indicating whether multi-VM sync has to be enabled.
        :param int recovery_point_history_in_minutes: The duration in minutes until which the recovery points need to be stored.
        """
        pulumi.set(__self__, "instance_type", 'InMageRcm')
        if app_consistent_frequency_in_minutes is not None:
            pulumi.set(__self__, "app_consistent_frequency_in_minutes", app_consistent_frequency_in_minutes)
        if crash_consistent_frequency_in_minutes is not None:
            pulumi.set(__self__, "crash_consistent_frequency_in_minutes", crash_consistent_frequency_in_minutes)
        if enable_multi_vm_sync is not None:
            pulumi.set(__self__, "enable_multi_vm_sync", enable_multi_vm_sync)
        if recovery_point_history_in_minutes is not None:
            pulumi.set(__self__, "recovery_point_history_in_minutes", recovery_point_history_in_minutes)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> str:
        """
        Gets the class type. Overridden in derived classes.
        Expected value is 'InMageRcm'.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="appConsistentFrequencyInMinutes")
    def app_consistent_frequency_in_minutes(self) -> Optional[int]:
        """
        The app consistent snapshot frequency in minutes.
        """
        return pulumi.get(self, "app_consistent_frequency_in_minutes")

    @property
    @pulumi.getter(name="crashConsistentFrequencyInMinutes")
    def crash_consistent_frequency_in_minutes(self) -> Optional[int]:
        """
        The crash consistent snapshot frequency in minutes.
        """
        return pulumi.get(self, "crash_consistent_frequency_in_minutes")

    @property
    @pulumi.getter(name="enableMultiVmSync")
    def enable_multi_vm_sync(self) -> Optional[str]:
        """
        A value indicating whether multi-VM sync has to be enabled.
        """
        return pulumi.get(self, "enable_multi_vm_sync")

    @property
    @pulumi.getter(name="recoveryPointHistoryInMinutes")
    def recovery_point_history_in_minutes(self) -> Optional[int]:
        """
        The duration in minutes until which the recovery points need to be stored.
        """
        return pulumi.get(self, "recovery_point_history_in_minutes")


@pulumi.output_type
class InMageRcmProtectedDiskDetailsResponse(dict):
    """
    InMageRcm protected disk details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "capacityInBytes":
            suggest = "capacity_in_bytes"
        elif key == "dataPendingAtSourceAgentInMB":
            suggest = "data_pending_at_source_agent_in_mb"
        elif key == "dataPendingInLogDataStoreInMB":
            suggest = "data_pending_in_log_data_store_in_mb"
        elif key == "diskEncryptionSetId":
            suggest = "disk_encryption_set_id"
        elif key == "diskId":
            suggest = "disk_id"
        elif key == "diskName":
            suggest = "disk_name"
        elif key == "isInitialReplicationComplete":
            suggest = "is_initial_replication_complete"
        elif key == "isOSDisk":
            suggest = "is_os_disk"
        elif key == "logStorageAccountId":
            suggest = "log_storage_account_id"
        elif key == "seedManagedDiskId":
            suggest = "seed_managed_disk_id"
        elif key == "targetManagedDiskId":
            suggest = "target_managed_disk_id"
        elif key == "diskType":
            suggest = "disk_type"
        elif key == "irDetails":
            suggest = "ir_details"
        elif key == "resyncDetails":
            suggest = "resync_details"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InMageRcmProtectedDiskDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InMageRcmProtectedDiskDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InMageRcmProtectedDiskDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 capacity_in_bytes: float,
                 data_pending_at_source_agent_in_mb: float,
                 data_pending_in_log_data_store_in_mb: float,
                 disk_encryption_set_id: str,
                 disk_id: str,
                 disk_name: str,
                 is_initial_replication_complete: str,
                 is_os_disk: str,
                 log_storage_account_id: str,
                 seed_managed_disk_id: str,
                 target_managed_disk_id: str,
                 disk_type: Optional[str] = None,
                 ir_details: Optional['outputs.InMageRcmSyncDetailsResponse'] = None,
                 resync_details: Optional['outputs.InMageRcmSyncDetailsResponse'] = None):
        """
        InMageRcm protected disk details.
        :param float capacity_in_bytes: The disk capacity in bytes.
        :param float data_pending_at_source_agent_in_mb: The data pending at source agent in MB.
        :param float data_pending_in_log_data_store_in_mb: The data pending in log data store in MB.
        :param str disk_encryption_set_id: The DiskEncryptionSet ARM Id.
        :param str disk_id: The disk Id.
        :param str disk_name: The disk name.
        :param str is_initial_replication_complete: A value indicating whether initial replication is complete or not.
        :param str is_os_disk: A value indicating whether the disk is the OS disk.
        :param str log_storage_account_id: The log storage account ARM Id.
        :param str seed_managed_disk_id: The ARM Id of the seed managed disk.
        :param str target_managed_disk_id: The ARM Id of the target managed disk.
        :param str disk_type: The disk type.
        :param 'InMageRcmSyncDetailsResponse' ir_details: The initial replication details.
        :param 'InMageRcmSyncDetailsResponse' resync_details: The resync details.
        """
        pulumi.set(__self__, "capacity_in_bytes", capacity_in_bytes)
        pulumi.set(__self__, "data_pending_at_source_agent_in_mb", data_pending_at_source_agent_in_mb)
        pulumi.set(__self__, "data_pending_in_log_data_store_in_mb", data_pending_in_log_data_store_in_mb)
        pulumi.set(__self__, "disk_encryption_set_id", disk_encryption_set_id)
        pulumi.set(__self__, "disk_id", disk_id)
        pulumi.set(__self__, "disk_name", disk_name)
        pulumi.set(__self__, "is_initial_replication_complete", is_initial_replication_complete)
        pulumi.set(__self__, "is_os_disk", is_os_disk)
        pulumi.set(__self__, "log_storage_account_id", log_storage_account_id)
        pulumi.set(__self__, "seed_managed_disk_id", seed_managed_disk_id)
        pulumi.set(__self__, "target_managed_disk_id", target_managed_disk_id)
        if disk_type is not None:
            pulumi.set(__self__, "disk_type", disk_type)
        if ir_details is not None:
            pulumi.set(__self__, "ir_details", ir_details)
        if resync_details is not None:
            pulumi.set(__self__, "resync_details", resync_details)

    @property
    @pulumi.getter(name="capacityInBytes")
    def capacity_in_bytes(self) -> float:
        """
        The disk capacity in bytes.
        """
        return pulumi.get(self, "capacity_in_bytes")

    @property
    @pulumi.getter(name="dataPendingAtSourceAgentInMB")
    def data_pending_at_source_agent_in_mb(self) -> float:
        """
        The data pending at source agent in MB.
        """
        return pulumi.get(self, "data_pending_at_source_agent_in_mb")

    @property
    @pulumi.getter(name="dataPendingInLogDataStoreInMB")
    def data_pending_in_log_data_store_in_mb(self) -> float:
        """
        The data pending in log data store in MB.
        """
        return pulumi.get(self, "data_pending_in_log_data_store_in_mb")

    @property
    @pulumi.getter(name="diskEncryptionSetId")
    def disk_encryption_set_id(self) -> str:
        """
        The DiskEncryptionSet ARM Id.
        """
        return pulumi.get(self, "disk_encryption_set_id")

    @property
    @pulumi.getter(name="diskId")
    def disk_id(self) -> str:
        """
        The disk Id.
        """
        return pulumi.get(self, "disk_id")

    @property
    @pulumi.getter(name="diskName")
    def disk_name(self) -> str:
        """
        The disk name.
        """
        return pulumi.get(self, "disk_name")

    @property
    @pulumi.getter(name="isInitialReplicationComplete")
    def is_initial_replication_complete(self) -> str:
        """
        A value indicating whether initial replication is complete or not.
        """
        return pulumi.get(self, "is_initial_replication_complete")

    @property
    @pulumi.getter(name="isOSDisk")
    def is_os_disk(self) -> str:
        """
        A value indicating whether the disk is the OS disk.
        """
        return pulumi.get(self, "is_os_disk")

    @property
    @pulumi.getter(name="logStorageAccountId")
    def log_storage_account_id(self) -> str:
        """
        The log storage account ARM Id.
        """
        return pulumi.get(self, "log_storage_account_id")

    @property
    @pulumi.getter(name="seedManagedDiskId")
    def seed_managed_disk_id(self) -> str:
        """
        The ARM Id of the seed managed disk.
        """
        return pulumi.get(self, "seed_managed_disk_id")

    @property
    @pulumi.getter(name="targetManagedDiskId")
    def target_managed_disk_id(self) -> str:
        """
        The ARM Id of the target managed disk.
        """
        return pulumi.get(self, "target_managed_disk_id")

    @property
    @pulumi.getter(name="diskType")
    def disk_type(self) -> Optional[str]:
        """
        The disk type.
        """
        return pulumi.get(self, "disk_type")

    @property
    @pulumi.getter(name="irDetails")
    def ir_details(self) -> Optional['outputs.InMageRcmSyncDetailsResponse']:
        """
        The initial replication details.
        """
        return pulumi.get(self, "ir_details")

    @property
    @pulumi.getter(name="resyncDetails")
    def resync_details(self) -> Optional['outputs.InMageRcmSyncDetailsResponse']:
        """
        The resync details.
        """
        return pulumi.get(self, "resync_details")


@pulumi.output_type
class InMageRcmProtectionContainerMappingDetailsResponse(dict):
    """
    InMageRcm provider specific container mapping details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enableAgentAutoUpgrade":
            suggest = "enable_agent_auto_upgrade"
        elif key == "instanceType":
            suggest = "instance_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InMageRcmProtectionContainerMappingDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InMageRcmProtectionContainerMappingDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InMageRcmProtectionContainerMappingDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable_agent_auto_upgrade: str,
                 instance_type: str):
        """
        InMageRcm provider specific container mapping details.
        :param str enable_agent_auto_upgrade: A value indicating whether the flag for enable agent auto upgrade.
        :param str instance_type: Gets the class type. Overridden in derived classes.
               Expected value is 'InMageRcm'.
        """
        pulumi.set(__self__, "enable_agent_auto_upgrade", enable_agent_auto_upgrade)
        pulumi.set(__self__, "instance_type", 'InMageRcm')

    @property
    @pulumi.getter(name="enableAgentAutoUpgrade")
    def enable_agent_auto_upgrade(self) -> str:
        """
        A value indicating whether the flag for enable agent auto upgrade.
        """
        return pulumi.get(self, "enable_agent_auto_upgrade")

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> str:
        """
        Gets the class type. Overridden in derived classes.
        Expected value is 'InMageRcm'.
        """
        return pulumi.get(self, "instance_type")


@pulumi.output_type
class InMageRcmReplicationDetailsResponse(dict):
    """
    InMageRcm provider specific details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "agentUpgradeAttemptToVersion":
            suggest = "agent_upgrade_attempt_to_version"
        elif key == "agentUpgradeJobId":
            suggest = "agent_upgrade_job_id"
        elif key == "agentUpgradeState":
            suggest = "agent_upgrade_state"
        elif key == "allocatedMemoryInMB":
            suggest = "allocated_memory_in_mb"
        elif key == "discoveryType":
            suggest = "discovery_type"
        elif key == "fabricDiscoveryMachineId":
            suggest = "fabric_discovery_machine_id"
        elif key == "failoverRecoveryPointId":
            suggest = "failover_recovery_point_id"
        elif key == "firmwareType":
            suggest = "firmware_type"
        elif key == "initialReplicationProcessedBytes":
            suggest = "initial_replication_processed_bytes"
        elif key == "initialReplicationProgressHealth":
            suggest = "initial_replication_progress_health"
        elif key == "initialReplicationProgressPercentage":
            suggest = "initial_replication_progress_percentage"
        elif key == "initialReplicationTransferredBytes":
            suggest = "initial_replication_transferred_bytes"
        elif key == "instanceType":
            suggest = "instance_type"
        elif key == "internalIdentifier":
            suggest = "internal_identifier"
        elif key == "isAgentRegistrationSuccessfulAfterFailover":
            suggest = "is_agent_registration_successful_after_failover"
        elif key == "isLastUpgradeSuccessful":
            suggest = "is_last_upgrade_successful"
        elif key == "lastAgentUpgradeType":
            suggest = "last_agent_upgrade_type"
        elif key == "lastRecoveryPointId":
            suggest = "last_recovery_point_id"
        elif key == "lastRecoveryPointReceived":
            suggest = "last_recovery_point_received"
        elif key == "lastRpoCalculatedTime":
            suggest = "last_rpo_calculated_time"
        elif key == "lastRpoInSeconds":
            suggest = "last_rpo_in_seconds"
        elif key == "multiVmGroupName":
            suggest = "multi_vm_group_name"
        elif key == "osType":
            suggest = "os_type"
        elif key == "primaryNicIpAddress":
            suggest = "primary_nic_ip_address"
        elif key == "processServerId":
            suggest = "process_server_id"
        elif key == "processServerName":
            suggest = "process_server_name"
        elif key == "processorCoreCount":
            suggest = "processor_core_count"
        elif key == "resyncProcessedBytes":
            suggest = "resync_processed_bytes"
        elif key == "resyncProgressHealth":
            suggest = "resync_progress_health"
        elif key == "resyncProgressPercentage":
            suggest = "resync_progress_percentage"
        elif key == "resyncRequired":
            suggest = "resync_required"
        elif key == "resyncState":
            suggest = "resync_state"
        elif key == "resyncTransferredBytes":
            suggest = "resync_transferred_bytes"
        elif key == "runAsAccountId":
            suggest = "run_as_account_id"
        elif key == "targetGeneration":
            suggest = "target_generation"
        elif key == "agentUpgradeBlockingErrorDetails":
            suggest = "agent_upgrade_blocking_error_details"
        elif key == "discoveredVmDetails":
            suggest = "discovered_vm_details"
        elif key == "lastAgentUpgradeErrorDetails":
            suggest = "last_agent_upgrade_error_details"
        elif key == "licenseType":
            suggest = "license_type"
        elif key == "mobilityAgentDetails":
            suggest = "mobility_agent_details"
        elif key == "protectedDisks":
            suggest = "protected_disks"
        elif key == "targetAvailabilitySetId":
            suggest = "target_availability_set_id"
        elif key == "targetAvailabilityZone":
            suggest = "target_availability_zone"
        elif key == "targetBootDiagnosticsStorageAccountId":
            suggest = "target_boot_diagnostics_storage_account_id"
        elif key == "targetLocation":
            suggest = "target_location"
        elif key == "targetNetworkId":
            suggest = "target_network_id"
        elif key == "targetProximityPlacementGroupId":
            suggest = "target_proximity_placement_group_id"
        elif key == "targetResourceGroupId":
            suggest = "target_resource_group_id"
        elif key == "targetVmName":
            suggest = "target_vm_name"
        elif key == "targetVmSize":
            suggest = "target_vm_size"
        elif key == "testNetworkId":
            suggest = "test_network_id"
        elif key == "vmNics":
            suggest = "vm_nics"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InMageRcmReplicationDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InMageRcmReplicationDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InMageRcmReplicationDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 agent_upgrade_attempt_to_version: str,
                 agent_upgrade_job_id: str,
                 agent_upgrade_state: str,
                 allocated_memory_in_mb: float,
                 discovery_type: str,
                 fabric_discovery_machine_id: str,
                 failover_recovery_point_id: str,
                 firmware_type: str,
                 initial_replication_processed_bytes: float,
                 initial_replication_progress_health: str,
                 initial_replication_progress_percentage: int,
                 initial_replication_transferred_bytes: float,
                 instance_type: str,
                 internal_identifier: str,
                 is_agent_registration_successful_after_failover: bool,
                 is_last_upgrade_successful: str,
                 last_agent_upgrade_type: str,
                 last_recovery_point_id: str,
                 last_recovery_point_received: str,
                 last_rpo_calculated_time: str,
                 last_rpo_in_seconds: float,
                 multi_vm_group_name: str,
                 os_type: str,
                 primary_nic_ip_address: str,
                 process_server_id: str,
                 process_server_name: str,
                 processor_core_count: int,
                 resync_processed_bytes: float,
                 resync_progress_health: str,
                 resync_progress_percentage: int,
                 resync_required: str,
                 resync_state: str,
                 resync_transferred_bytes: float,
                 run_as_account_id: str,
                 target_generation: str,
                 agent_upgrade_blocking_error_details: Optional[Sequence['outputs.InMageRcmAgentUpgradeBlockingErrorDetailsResponse']] = None,
                 discovered_vm_details: Optional['outputs.InMageRcmDiscoveredProtectedVmDetailsResponse'] = None,
                 last_agent_upgrade_error_details: Optional[Sequence['outputs.InMageRcmLastAgentUpgradeErrorDetailsResponse']] = None,
                 license_type: Optional[str] = None,
                 mobility_agent_details: Optional['outputs.InMageRcmMobilityAgentDetailsResponse'] = None,
                 protected_disks: Optional[Sequence['outputs.InMageRcmProtectedDiskDetailsResponse']] = None,
                 target_availability_set_id: Optional[str] = None,
                 target_availability_zone: Optional[str] = None,
                 target_boot_diagnostics_storage_account_id: Optional[str] = None,
                 target_location: Optional[str] = None,
                 target_network_id: Optional[str] = None,
                 target_proximity_placement_group_id: Optional[str] = None,
                 target_resource_group_id: Optional[str] = None,
                 target_vm_name: Optional[str] = None,
                 target_vm_size: Optional[str] = None,
                 test_network_id: Optional[str] = None,
                 vm_nics: Optional[Sequence['outputs.InMageRcmNicDetailsResponse']] = None):
        """
        InMageRcm provider specific details.
        :param str agent_upgrade_attempt_to_version: The agent version to which last agent upgrade was attempted.
        :param str agent_upgrade_job_id: The agent upgrade job Id.
        :param str agent_upgrade_state: The agent auto upgrade state.
        :param float allocated_memory_in_mb: The allocated memory in MB.
        :param str discovery_type: The type of the discovered VM.
        :param str fabric_discovery_machine_id: The ARM Id of the discovered VM.
        :param str failover_recovery_point_id: The recovery point Id to which the VM was failed over.
        :param str firmware_type: The firmware type.
        :param float initial_replication_processed_bytes: The initial replication processed bytes. This includes sum of total bytes transferred and matched bytes on all selected disks in source VM.
        :param str initial_replication_progress_health: The initial replication progress health.
        :param int initial_replication_progress_percentage: The initial replication progress percentage. This is calculated based on total bytes processed for all disks in the source VM.
        :param float initial_replication_transferred_bytes: The initial replication transferred bytes from source VM to azure for all selected disks on source VM.
        :param str instance_type: Gets the Instance type.
               Expected value is 'InMageRcm'.
        :param str internal_identifier: The virtual machine internal identifier.
        :param bool is_agent_registration_successful_after_failover: A value indicating whether agent registration was successful after failover.
        :param str is_last_upgrade_successful: A value indicating whether last agent upgrade was successful or not.
        :param str last_agent_upgrade_type: The last agent upgrade type.
        :param str last_recovery_point_id: The last recovery point Id.
        :param str last_recovery_point_received: The last recovery point received time.
        :param str last_rpo_calculated_time: The last recovery point objective calculated time.
        :param float last_rpo_in_seconds: The last recovery point objective value.
        :param str multi_vm_group_name: The multi VM group name.
        :param str os_type: The type of the OS on the VM.
        :param str primary_nic_ip_address: The IP address of the primary network interface.
        :param str process_server_id: The process server Id.
        :param str process_server_name: The process server name.
        :param int processor_core_count: The processor core count.
        :param float resync_processed_bytes: The resync processed bytes. This includes sum of total bytes transferred and matched bytes on all selected disks in source VM.
        :param str resync_progress_health: The resync progress health.
        :param int resync_progress_percentage: The resync progress percentage. This is calculated based on total bytes processed for all disks in the source VM.
        :param str resync_required: A value indicating whether resync is required.
        :param str resync_state: The resync state.
        :param float resync_transferred_bytes: The resync transferred bytes from source VM to azure for all selected disks on source VM.
        :param str run_as_account_id: The run-as account Id.
        :param str target_generation: The target generation.
        :param Sequence['InMageRcmAgentUpgradeBlockingErrorDetailsResponse'] agent_upgrade_blocking_error_details: The agent upgrade blocking error information.
        :param 'InMageRcmDiscoveredProtectedVmDetailsResponse' discovered_vm_details: The discovered VM details.
        :param Sequence['InMageRcmLastAgentUpgradeErrorDetailsResponse'] last_agent_upgrade_error_details: The last agent upgrade error information.
        :param str license_type: License Type of the VM to be used.
        :param 'InMageRcmMobilityAgentDetailsResponse' mobility_agent_details: The mobility agent information.
        :param Sequence['InMageRcmProtectedDiskDetailsResponse'] protected_disks: The list of protected disks.
        :param str target_availability_set_id: The target availability set Id.
        :param str target_availability_zone: The target availability zone.
        :param str target_boot_diagnostics_storage_account_id: The target boot diagnostics storage account ARM Id.
        :param str target_location: The target location.
        :param str target_network_id: The target network Id.
        :param str target_proximity_placement_group_id: The target proximity placement group Id.
        :param str target_resource_group_id: The target resource group Id.
        :param str target_vm_name: Target VM name.
        :param str target_vm_size: The target VM size.
        :param str test_network_id: The test network Id.
        :param Sequence['InMageRcmNicDetailsResponse'] vm_nics: The network details.
        """
        pulumi.set(__self__, "agent_upgrade_attempt_to_version", agent_upgrade_attempt_to_version)
        pulumi.set(__self__, "agent_upgrade_job_id", agent_upgrade_job_id)
        pulumi.set(__self__, "agent_upgrade_state", agent_upgrade_state)
        pulumi.set(__self__, "allocated_memory_in_mb", allocated_memory_in_mb)
        pulumi.set(__self__, "discovery_type", discovery_type)
        pulumi.set(__self__, "fabric_discovery_machine_id", fabric_discovery_machine_id)
        pulumi.set(__self__, "failover_recovery_point_id", failover_recovery_point_id)
        pulumi.set(__self__, "firmware_type", firmware_type)
        pulumi.set(__self__, "initial_replication_processed_bytes", initial_replication_processed_bytes)
        pulumi.set(__self__, "initial_replication_progress_health", initial_replication_progress_health)
        pulumi.set(__self__, "initial_replication_progress_percentage", initial_replication_progress_percentage)
        pulumi.set(__self__, "initial_replication_transferred_bytes", initial_replication_transferred_bytes)
        pulumi.set(__self__, "instance_type", 'InMageRcm')
        pulumi.set(__self__, "internal_identifier", internal_identifier)
        pulumi.set(__self__, "is_agent_registration_successful_after_failover", is_agent_registration_successful_after_failover)
        pulumi.set(__self__, "is_last_upgrade_successful", is_last_upgrade_successful)
        pulumi.set(__self__, "last_agent_upgrade_type", last_agent_upgrade_type)
        pulumi.set(__self__, "last_recovery_point_id", last_recovery_point_id)
        pulumi.set(__self__, "last_recovery_point_received", last_recovery_point_received)
        pulumi.set(__self__, "last_rpo_calculated_time", last_rpo_calculated_time)
        pulumi.set(__self__, "last_rpo_in_seconds", last_rpo_in_seconds)
        pulumi.set(__self__, "multi_vm_group_name", multi_vm_group_name)
        pulumi.set(__self__, "os_type", os_type)
        pulumi.set(__self__, "primary_nic_ip_address", primary_nic_ip_address)
        pulumi.set(__self__, "process_server_id", process_server_id)
        pulumi.set(__self__, "process_server_name", process_server_name)
        pulumi.set(__self__, "processor_core_count", processor_core_count)
        pulumi.set(__self__, "resync_processed_bytes", resync_processed_bytes)
        pulumi.set(__self__, "resync_progress_health", resync_progress_health)
        pulumi.set(__self__, "resync_progress_percentage", resync_progress_percentage)
        pulumi.set(__self__, "resync_required", resync_required)
        pulumi.set(__self__, "resync_state", resync_state)
        pulumi.set(__self__, "resync_transferred_bytes", resync_transferred_bytes)
        pulumi.set(__self__, "run_as_account_id", run_as_account_id)
        pulumi.set(__self__, "target_generation", target_generation)
        if agent_upgrade_blocking_error_details is not None:
            pulumi.set(__self__, "agent_upgrade_blocking_error_details", agent_upgrade_blocking_error_details)
        if discovered_vm_details is not None:
            pulumi.set(__self__, "discovered_vm_details", discovered_vm_details)
        if last_agent_upgrade_error_details is not None:
            pulumi.set(__self__, "last_agent_upgrade_error_details", last_agent_upgrade_error_details)
        if license_type is not None:
            pulumi.set(__self__, "license_type", license_type)
        if mobility_agent_details is not None:
            pulumi.set(__self__, "mobility_agent_details", mobility_agent_details)
        if protected_disks is not None:
            pulumi.set(__self__, "protected_disks", protected_disks)
        if target_availability_set_id is not None:
            pulumi.set(__self__, "target_availability_set_id", target_availability_set_id)
        if target_availability_zone is not None:
            pulumi.set(__self__, "target_availability_zone", target_availability_zone)
        if target_boot_diagnostics_storage_account_id is not None:
            pulumi.set(__self__, "target_boot_diagnostics_storage_account_id", target_boot_diagnostics_storage_account_id)
        if target_location is not None:
            pulumi.set(__self__, "target_location", target_location)
        if target_network_id is not None:
            pulumi.set(__self__, "target_network_id", target_network_id)
        if target_proximity_placement_group_id is not None:
            pulumi.set(__self__, "target_proximity_placement_group_id", target_proximity_placement_group_id)
        if target_resource_group_id is not None:
            pulumi.set(__self__, "target_resource_group_id", target_resource_group_id)
        if target_vm_name is not None:
            pulumi.set(__self__, "target_vm_name", target_vm_name)
        if target_vm_size is not None:
            pulumi.set(__self__, "target_vm_size", target_vm_size)
        if test_network_id is not None:
            pulumi.set(__self__, "test_network_id", test_network_id)
        if vm_nics is not None:
            pulumi.set(__self__, "vm_nics", vm_nics)

    @property
    @pulumi.getter(name="agentUpgradeAttemptToVersion")
    def agent_upgrade_attempt_to_version(self) -> str:
        """
        The agent version to which last agent upgrade was attempted.
        """
        return pulumi.get(self, "agent_upgrade_attempt_to_version")

    @property
    @pulumi.getter(name="agentUpgradeJobId")
    def agent_upgrade_job_id(self) -> str:
        """
        The agent upgrade job Id.
        """
        return pulumi.get(self, "agent_upgrade_job_id")

    @property
    @pulumi.getter(name="agentUpgradeState")
    def agent_upgrade_state(self) -> str:
        """
        The agent auto upgrade state.
        """
        return pulumi.get(self, "agent_upgrade_state")

    @property
    @pulumi.getter(name="allocatedMemoryInMB")
    def allocated_memory_in_mb(self) -> float:
        """
        The allocated memory in MB.
        """
        return pulumi.get(self, "allocated_memory_in_mb")

    @property
    @pulumi.getter(name="discoveryType")
    def discovery_type(self) -> str:
        """
        The type of the discovered VM.
        """
        return pulumi.get(self, "discovery_type")

    @property
    @pulumi.getter(name="fabricDiscoveryMachineId")
    def fabric_discovery_machine_id(self) -> str:
        """
        The ARM Id of the discovered VM.
        """
        return pulumi.get(self, "fabric_discovery_machine_id")

    @property
    @pulumi.getter(name="failoverRecoveryPointId")
    def failover_recovery_point_id(self) -> str:
        """
        The recovery point Id to which the VM was failed over.
        """
        return pulumi.get(self, "failover_recovery_point_id")

    @property
    @pulumi.getter(name="firmwareType")
    def firmware_type(self) -> str:
        """
        The firmware type.
        """
        return pulumi.get(self, "firmware_type")

    @property
    @pulumi.getter(name="initialReplicationProcessedBytes")
    def initial_replication_processed_bytes(self) -> float:
        """
        The initial replication processed bytes. This includes sum of total bytes transferred and matched bytes on all selected disks in source VM.
        """
        return pulumi.get(self, "initial_replication_processed_bytes")

    @property
    @pulumi.getter(name="initialReplicationProgressHealth")
    def initial_replication_progress_health(self) -> str:
        """
        The initial replication progress health.
        """
        return pulumi.get(self, "initial_replication_progress_health")

    @property
    @pulumi.getter(name="initialReplicationProgressPercentage")
    def initial_replication_progress_percentage(self) -> int:
        """
        The initial replication progress percentage. This is calculated based on total bytes processed for all disks in the source VM.
        """
        return pulumi.get(self, "initial_replication_progress_percentage")

    @property
    @pulumi.getter(name="initialReplicationTransferredBytes")
    def initial_replication_transferred_bytes(self) -> float:
        """
        The initial replication transferred bytes from source VM to azure for all selected disks on source VM.
        """
        return pulumi.get(self, "initial_replication_transferred_bytes")

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> str:
        """
        Gets the Instance type.
        Expected value is 'InMageRcm'.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="internalIdentifier")
    def internal_identifier(self) -> str:
        """
        The virtual machine internal identifier.
        """
        return pulumi.get(self, "internal_identifier")

    @property
    @pulumi.getter(name="isAgentRegistrationSuccessfulAfterFailover")
    def is_agent_registration_successful_after_failover(self) -> bool:
        """
        A value indicating whether agent registration was successful after failover.
        """
        return pulumi.get(self, "is_agent_registration_successful_after_failover")

    @property
    @pulumi.getter(name="isLastUpgradeSuccessful")
    def is_last_upgrade_successful(self) -> str:
        """
        A value indicating whether last agent upgrade was successful or not.
        """
        return pulumi.get(self, "is_last_upgrade_successful")

    @property
    @pulumi.getter(name="lastAgentUpgradeType")
    def last_agent_upgrade_type(self) -> str:
        """
        The last agent upgrade type.
        """
        return pulumi.get(self, "last_agent_upgrade_type")

    @property
    @pulumi.getter(name="lastRecoveryPointId")
    def last_recovery_point_id(self) -> str:
        """
        The last recovery point Id.
        """
        return pulumi.get(self, "last_recovery_point_id")

    @property
    @pulumi.getter(name="lastRecoveryPointReceived")
    def last_recovery_point_received(self) -> str:
        """
        The last recovery point received time.
        """
        return pulumi.get(self, "last_recovery_point_received")

    @property
    @pulumi.getter(name="lastRpoCalculatedTime")
    def last_rpo_calculated_time(self) -> str:
        """
        The last recovery point objective calculated time.
        """
        return pulumi.get(self, "last_rpo_calculated_time")

    @property
    @pulumi.getter(name="lastRpoInSeconds")
    def last_rpo_in_seconds(self) -> float:
        """
        The last recovery point objective value.
        """
        return pulumi.get(self, "last_rpo_in_seconds")

    @property
    @pulumi.getter(name="multiVmGroupName")
    def multi_vm_group_name(self) -> str:
        """
        The multi VM group name.
        """
        return pulumi.get(self, "multi_vm_group_name")

    @property
    @pulumi.getter(name="osType")
    def os_type(self) -> str:
        """
        The type of the OS on the VM.
        """
        return pulumi.get(self, "os_type")

    @property
    @pulumi.getter(name="primaryNicIpAddress")
    def primary_nic_ip_address(self) -> str:
        """
        The IP address of the primary network interface.
        """
        return pulumi.get(self, "primary_nic_ip_address")

    @property
    @pulumi.getter(name="processServerId")
    def process_server_id(self) -> str:
        """
        The process server Id.
        """
        return pulumi.get(self, "process_server_id")

    @property
    @pulumi.getter(name="processServerName")
    def process_server_name(self) -> str:
        """
        The process server name.
        """
        return pulumi.get(self, "process_server_name")

    @property
    @pulumi.getter(name="processorCoreCount")
    def processor_core_count(self) -> int:
        """
        The processor core count.
        """
        return pulumi.get(self, "processor_core_count")

    @property
    @pulumi.getter(name="resyncProcessedBytes")
    def resync_processed_bytes(self) -> float:
        """
        The resync processed bytes. This includes sum of total bytes transferred and matched bytes on all selected disks in source VM.
        """
        return pulumi.get(self, "resync_processed_bytes")

    @property
    @pulumi.getter(name="resyncProgressHealth")
    def resync_progress_health(self) -> str:
        """
        The resync progress health.
        """
        return pulumi.get(self, "resync_progress_health")

    @property
    @pulumi.getter(name="resyncProgressPercentage")
    def resync_progress_percentage(self) -> int:
        """
        The resync progress percentage. This is calculated based on total bytes processed for all disks in the source VM.
        """
        return pulumi.get(self, "resync_progress_percentage")

    @property
    @pulumi.getter(name="resyncRequired")
    def resync_required(self) -> str:
        """
        A value indicating whether resync is required.
        """
        return pulumi.get(self, "resync_required")

    @property
    @pulumi.getter(name="resyncState")
    def resync_state(self) -> str:
        """
        The resync state.
        """
        return pulumi.get(self, "resync_state")

    @property
    @pulumi.getter(name="resyncTransferredBytes")
    def resync_transferred_bytes(self) -> float:
        """
        The resync transferred bytes from source VM to azure for all selected disks on source VM.
        """
        return pulumi.get(self, "resync_transferred_bytes")

    @property
    @pulumi.getter(name="runAsAccountId")
    def run_as_account_id(self) -> str:
        """
        The run-as account Id.
        """
        return pulumi.get(self, "run_as_account_id")

    @property
    @pulumi.getter(name="targetGeneration")
    def target_generation(self) -> str:
        """
        The target generation.
        """
        return pulumi.get(self, "target_generation")

    @property
    @pulumi.getter(name="agentUpgradeBlockingErrorDetails")
    def agent_upgrade_blocking_error_details(self) -> Optional[Sequence['outputs.InMageRcmAgentUpgradeBlockingErrorDetailsResponse']]:
        """
        The agent upgrade blocking error information.
        """
        return pulumi.get(self, "agent_upgrade_blocking_error_details")

    @property
    @pulumi.getter(name="discoveredVmDetails")
    def discovered_vm_details(self) -> Optional['outputs.InMageRcmDiscoveredProtectedVmDetailsResponse']:
        """
        The discovered VM details.
        """
        return pulumi.get(self, "discovered_vm_details")

    @property
    @pulumi.getter(name="lastAgentUpgradeErrorDetails")
    def last_agent_upgrade_error_details(self) -> Optional[Sequence['outputs.InMageRcmLastAgentUpgradeErrorDetailsResponse']]:
        """
        The last agent upgrade error information.
        """
        return pulumi.get(self, "last_agent_upgrade_error_details")

    @property
    @pulumi.getter(name="licenseType")
    def license_type(self) -> Optional[str]:
        """
        License Type of the VM to be used.
        """
        return pulumi.get(self, "license_type")

    @property
    @pulumi.getter(name="mobilityAgentDetails")
    def mobility_agent_details(self) -> Optional['outputs.InMageRcmMobilityAgentDetailsResponse']:
        """
        The mobility agent information.
        """
        return pulumi.get(self, "mobility_agent_details")

    @property
    @pulumi.getter(name="protectedDisks")
    def protected_disks(self) -> Optional[Sequence['outputs.InMageRcmProtectedDiskDetailsResponse']]:
        """
        The list of protected disks.
        """
        return pulumi.get(self, "protected_disks")

    @property
    @pulumi.getter(name="targetAvailabilitySetId")
    def target_availability_set_id(self) -> Optional[str]:
        """
        The target availability set Id.
        """
        return pulumi.get(self, "target_availability_set_id")

    @property
    @pulumi.getter(name="targetAvailabilityZone")
    def target_availability_zone(self) -> Optional[str]:
        """
        The target availability zone.
        """
        return pulumi.get(self, "target_availability_zone")

    @property
    @pulumi.getter(name="targetBootDiagnosticsStorageAccountId")
    def target_boot_diagnostics_storage_account_id(self) -> Optional[str]:
        """
        The target boot diagnostics storage account ARM Id.
        """
        return pulumi.get(self, "target_boot_diagnostics_storage_account_id")

    @property
    @pulumi.getter(name="targetLocation")
    def target_location(self) -> Optional[str]:
        """
        The target location.
        """
        return pulumi.get(self, "target_location")

    @property
    @pulumi.getter(name="targetNetworkId")
    def target_network_id(self) -> Optional[str]:
        """
        The target network Id.
        """
        return pulumi.get(self, "target_network_id")

    @property
    @pulumi.getter(name="targetProximityPlacementGroupId")
    def target_proximity_placement_group_id(self) -> Optional[str]:
        """
        The target proximity placement group Id.
        """
        return pulumi.get(self, "target_proximity_placement_group_id")

    @property
    @pulumi.getter(name="targetResourceGroupId")
    def target_resource_group_id(self) -> Optional[str]:
        """
        The target resource group Id.
        """
        return pulumi.get(self, "target_resource_group_id")

    @property
    @pulumi.getter(name="targetVmName")
    def target_vm_name(self) -> Optional[str]:
        """
        Target VM name.
        """
        return pulumi.get(self, "target_vm_name")

    @property
    @pulumi.getter(name="targetVmSize")
    def target_vm_size(self) -> Optional[str]:
        """
        The target VM size.
        """
        return pulumi.get(self, "target_vm_size")

    @property
    @pulumi.getter(name="testNetworkId")
    def test_network_id(self) -> Optional[str]:
        """
        The test network Id.
        """
        return pulumi.get(self, "test_network_id")

    @property
    @pulumi.getter(name="vmNics")
    def vm_nics(self) -> Optional[Sequence['outputs.InMageRcmNicDetailsResponse']]:
        """
        The network details.
        """
        return pulumi.get(self, "vm_nics")


@pulumi.output_type
class InMageRcmSyncDetailsResponse(dict):
    """
    InMageRcm disk level sync details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "last15MinutesTransferredBytes":
            suggest = "last15_minutes_transferred_bytes"
        elif key == "lastDataTransferTimeUtc":
            suggest = "last_data_transfer_time_utc"
        elif key == "lastRefreshTime":
            suggest = "last_refresh_time"
        elif key == "processedBytes":
            suggest = "processed_bytes"
        elif key == "progressHealth":
            suggest = "progress_health"
        elif key == "progressPercentage":
            suggest = "progress_percentage"
        elif key == "startTime":
            suggest = "start_time"
        elif key == "transferredBytes":
            suggest = "transferred_bytes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InMageRcmSyncDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InMageRcmSyncDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InMageRcmSyncDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 last15_minutes_transferred_bytes: float,
                 last_data_transfer_time_utc: str,
                 last_refresh_time: str,
                 processed_bytes: float,
                 progress_health: str,
                 progress_percentage: int,
                 start_time: str,
                 transferred_bytes: float):
        """
        InMageRcm disk level sync details.
        :param float last15_minutes_transferred_bytes: The bytes transferred in last 15 minutes from source VM to azure.
        :param str last_data_transfer_time_utc: The time of the last data transfer from source VM to azure.
        :param str last_refresh_time: The last refresh time.
        :param float processed_bytes: The total processed bytes. This includes bytes that are transferred from source VM to azure and matched bytes.
        :param str progress_health: The progress health.
        :param int progress_percentage: Progress in percentage. Progress percentage is calculated based on processed bytes.
        :param str start_time: The start time.
        :param float transferred_bytes: The transferred bytes from source VM to azure for the disk.
        """
        pulumi.set(__self__, "last15_minutes_transferred_bytes", last15_minutes_transferred_bytes)
        pulumi.set(__self__, "last_data_transfer_time_utc", last_data_transfer_time_utc)
        pulumi.set(__self__, "last_refresh_time", last_refresh_time)
        pulumi.set(__self__, "processed_bytes", processed_bytes)
        pulumi.set(__self__, "progress_health", progress_health)
        pulumi.set(__self__, "progress_percentage", progress_percentage)
        pulumi.set(__self__, "start_time", start_time)
        pulumi.set(__self__, "transferred_bytes", transferred_bytes)

    @property
    @pulumi.getter(name="last15MinutesTransferredBytes")
    def last15_minutes_transferred_bytes(self) -> float:
        """
        The bytes transferred in last 15 minutes from source VM to azure.
        """
        return pulumi.get(self, "last15_minutes_transferred_bytes")

    @property
    @pulumi.getter(name="lastDataTransferTimeUtc")
    def last_data_transfer_time_utc(self) -> str:
        """
        The time of the last data transfer from source VM to azure.
        """
        return pulumi.get(self, "last_data_transfer_time_utc")

    @property
    @pulumi.getter(name="lastRefreshTime")
    def last_refresh_time(self) -> str:
        """
        The last refresh time.
        """
        return pulumi.get(self, "last_refresh_time")

    @property
    @pulumi.getter(name="processedBytes")
    def processed_bytes(self) -> float:
        """
        The total processed bytes. This includes bytes that are transferred from source VM to azure and matched bytes.
        """
        return pulumi.get(self, "processed_bytes")

    @property
    @pulumi.getter(name="progressHealth")
    def progress_health(self) -> str:
        """
        The progress health.
        """
        return pulumi.get(self, "progress_health")

    @property
    @pulumi.getter(name="progressPercentage")
    def progress_percentage(self) -> int:
        """
        Progress in percentage. Progress percentage is calculated based on processed bytes.
        """
        return pulumi.get(self, "progress_percentage")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> str:
        """
        The start time.
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter(name="transferredBytes")
    def transferred_bytes(self) -> float:
        """
        The transferred bytes from source VM to azure for the disk.
        """
        return pulumi.get(self, "transferred_bytes")


@pulumi.output_type
class InMageReplicationDetailsResponse(dict):
    """
    InMage provider specific settings.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceType":
            suggest = "instance_type"
        elif key == "activeSiteType":
            suggest = "active_site_type"
        elif key == "agentDetails":
            suggest = "agent_details"
        elif key == "azureStorageAccountId":
            suggest = "azure_storage_account_id"
        elif key == "compressedDataRateInMB":
            suggest = "compressed_data_rate_in_mb"
        elif key == "consistencyPoints":
            suggest = "consistency_points"
        elif key == "discoveryType":
            suggest = "discovery_type"
        elif key == "diskResized":
            suggest = "disk_resized"
        elif key == "infrastructureVmId":
            suggest = "infrastructure_vm_id"
        elif key == "ipAddress":
            suggest = "ip_address"
        elif key == "isAdditionalStatsAvailable":
            suggest = "is_additional_stats_available"
        elif key == "lastHeartbeat":
            suggest = "last_heartbeat"
        elif key == "lastRpoCalculatedTime":
            suggest = "last_rpo_calculated_time"
        elif key == "lastUpdateReceivedTime":
            suggest = "last_update_received_time"
        elif key == "masterTargetId":
            suggest = "master_target_id"
        elif key == "multiVmGroupId":
            suggest = "multi_vm_group_id"
        elif key == "multiVmGroupName":
            suggest = "multi_vm_group_name"
        elif key == "multiVmSyncStatus":
            suggest = "multi_vm_sync_status"
        elif key == "osDetails":
            suggest = "os_details"
        elif key == "osVersion":
            suggest = "os_version"
        elif key == "processServerId":
            suggest = "process_server_id"
        elif key == "protectedDisks":
            suggest = "protected_disks"
        elif key == "protectionStage":
            suggest = "protection_stage"
        elif key == "rebootAfterUpdateStatus":
            suggest = "reboot_after_update_status"
        elif key == "replicaId":
            suggest = "replica_id"
        elif key == "resyncDetails":
            suggest = "resync_details"
        elif key == "retentionWindowEnd":
            suggest = "retention_window_end"
        elif key == "retentionWindowStart":
            suggest = "retention_window_start"
        elif key == "rpoInSeconds":
            suggest = "rpo_in_seconds"
        elif key == "sourceVmCpuCount":
            suggest = "source_vm_cpu_count"
        elif key == "sourceVmRamSizeInMB":
            suggest = "source_vm_ram_size_in_mb"
        elif key == "totalDataTransferred":
            suggest = "total_data_transferred"
        elif key == "totalProgressHealth":
            suggest = "total_progress_health"
        elif key == "uncompressedDataRateInMB":
            suggest = "uncompressed_data_rate_in_mb"
        elif key == "vCenterInfrastructureId":
            suggest = "v_center_infrastructure_id"
        elif key == "validationErrors":
            suggest = "validation_errors"
        elif key == "vmId":
            suggest = "vm_id"
        elif key == "vmNics":
            suggest = "vm_nics"
        elif key == "vmProtectionState":
            suggest = "vm_protection_state"
        elif key == "vmProtectionStateDescription":
            suggest = "vm_protection_state_description"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InMageReplicationDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InMageReplicationDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InMageReplicationDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_type: str,
                 active_site_type: Optional[str] = None,
                 agent_details: Optional['outputs.InMageAgentDetailsResponse'] = None,
                 azure_storage_account_id: Optional[str] = None,
                 compressed_data_rate_in_mb: Optional[float] = None,
                 consistency_points: Optional[Mapping[str, str]] = None,
                 datastores: Optional[Sequence[str]] = None,
                 discovery_type: Optional[str] = None,
                 disk_resized: Optional[str] = None,
                 infrastructure_vm_id: Optional[str] = None,
                 ip_address: Optional[str] = None,
                 is_additional_stats_available: Optional[bool] = None,
                 last_heartbeat: Optional[str] = None,
                 last_rpo_calculated_time: Optional[str] = None,
                 last_update_received_time: Optional[str] = None,
                 master_target_id: Optional[str] = None,
                 multi_vm_group_id: Optional[str] = None,
                 multi_vm_group_name: Optional[str] = None,
                 multi_vm_sync_status: Optional[str] = None,
                 os_details: Optional['outputs.OSDiskDetailsResponse'] = None,
                 os_version: Optional[str] = None,
                 process_server_id: Optional[str] = None,
                 protected_disks: Optional[Sequence['outputs.InMageProtectedDiskDetailsResponse']] = None,
                 protection_stage: Optional[str] = None,
                 reboot_after_update_status: Optional[str] = None,
                 replica_id: Optional[str] = None,
                 resync_details: Optional['outputs.InitialReplicationDetailsResponse'] = None,
                 retention_window_end: Optional[str] = None,
                 retention_window_start: Optional[str] = None,
                 rpo_in_seconds: Optional[float] = None,
                 source_vm_cpu_count: Optional[int] = None,
                 source_vm_ram_size_in_mb: Optional[int] = None,
                 total_data_transferred: Optional[float] = None,
                 total_progress_health: Optional[str] = None,
                 uncompressed_data_rate_in_mb: Optional[float] = None,
                 v_center_infrastructure_id: Optional[str] = None,
                 validation_errors: Optional[Sequence['outputs.HealthErrorResponse']] = None,
                 vm_id: Optional[str] = None,
                 vm_nics: Optional[Sequence['outputs.VMNicDetailsResponse']] = None,
                 vm_protection_state: Optional[str] = None,
                 vm_protection_state_description: Optional[str] = None):
        """
        InMage provider specific settings.
        :param str instance_type: Gets the Instance type.
               Expected value is 'InMage'.
        :param str active_site_type: The active location of the VM. If the VM is being protected from Azure, this field will take values from { Azure, OnPrem }. If the VM is being protected between two data-centers, this field will be OnPrem always.
        :param 'InMageAgentDetailsResponse' agent_details: The agent details.
        :param str azure_storage_account_id: A value indicating the underlying Azure storage account. If the VM is not running in Azure, this value shall be set to null.
        :param float compressed_data_rate_in_mb: The compressed data change rate in MB.
        :param Mapping[str, str] consistency_points: The collection of Consistency points.
        :param Sequence[str] datastores: The datastores of the on-premise machine Value can be list of strings that contain datastore names.
        :param str discovery_type: A value indicating the discovery type of the machine.
        :param str disk_resized: A value indicating whether any disk is resized for this VM.
        :param str infrastructure_vm_id: The infrastructure VM Id.
        :param str ip_address: The source IP address.
        :param bool is_additional_stats_available: A value indicating whether additional IR stats are available or not.
        :param str last_heartbeat: The last heartbeat received from the source server.
        :param str last_rpo_calculated_time: The last RPO calculated time.
        :param str last_update_received_time: The last update time received from on-prem components.
        :param str master_target_id: The master target Id.
        :param str multi_vm_group_id: The multi vm group Id, if any.
        :param str multi_vm_group_name: The multi vm group name, if any.
        :param str multi_vm_sync_status: A value indicating whether the multi vm sync is enabled or disabled.
        :param 'OSDiskDetailsResponse' os_details: The OS details.
        :param str os_version: The OS Version of the protected item.
        :param str process_server_id: The process server Id.
        :param Sequence['InMageProtectedDiskDetailsResponse'] protected_disks: The list of protected disks.
        :param str protection_stage: The protection stage.
        :param str reboot_after_update_status: A value indicating whether the source server requires a restart after update.
        :param str replica_id: The replica id of the protected item.
        :param 'InitialReplicationDetailsResponse' resync_details: The resync details of the machine.
        :param str retention_window_end: The retention window end time.
        :param str retention_window_start: The retention window start time.
        :param float rpo_in_seconds: The RPO in seconds.
        :param int source_vm_cpu_count: The CPU count of the VM on the primary side.
        :param int source_vm_ram_size_in_mb: The RAM size of the VM on the primary side.
        :param float total_data_transferred: The total transferred data in bytes.
        :param str total_progress_health: The progress health.
        :param float uncompressed_data_rate_in_mb: The uncompressed data change rate in MB.
        :param str v_center_infrastructure_id: The vCenter infrastructure Id.
        :param Sequence['HealthErrorResponse'] validation_errors: The validation errors of the on-premise machine Value can be list of validation errors.
        :param str vm_id: The virtual machine Id.
        :param Sequence['VMNicDetailsResponse'] vm_nics: The PE Network details.
        :param str vm_protection_state: The protection state for the vm.
        :param str vm_protection_state_description: The protection state description for the vm.
        """
        pulumi.set(__self__, "instance_type", 'InMage')
        if active_site_type is not None:
            pulumi.set(__self__, "active_site_type", active_site_type)
        if agent_details is not None:
            pulumi.set(__self__, "agent_details", agent_details)
        if azure_storage_account_id is not None:
            pulumi.set(__self__, "azure_storage_account_id", azure_storage_account_id)
        if compressed_data_rate_in_mb is not None:
            pulumi.set(__self__, "compressed_data_rate_in_mb", compressed_data_rate_in_mb)
        if consistency_points is not None:
            pulumi.set(__self__, "consistency_points", consistency_points)
        if datastores is not None:
            pulumi.set(__self__, "datastores", datastores)
        if discovery_type is not None:
            pulumi.set(__self__, "discovery_type", discovery_type)
        if disk_resized is not None:
            pulumi.set(__self__, "disk_resized", disk_resized)
        if infrastructure_vm_id is not None:
            pulumi.set(__self__, "infrastructure_vm_id", infrastructure_vm_id)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if is_additional_stats_available is not None:
            pulumi.set(__self__, "is_additional_stats_available", is_additional_stats_available)
        if last_heartbeat is not None:
            pulumi.set(__self__, "last_heartbeat", last_heartbeat)
        if last_rpo_calculated_time is not None:
            pulumi.set(__self__, "last_rpo_calculated_time", last_rpo_calculated_time)
        if last_update_received_time is not None:
            pulumi.set(__self__, "last_update_received_time", last_update_received_time)
        if master_target_id is not None:
            pulumi.set(__self__, "master_target_id", master_target_id)
        if multi_vm_group_id is not None:
            pulumi.set(__self__, "multi_vm_group_id", multi_vm_group_id)
        if multi_vm_group_name is not None:
            pulumi.set(__self__, "multi_vm_group_name", multi_vm_group_name)
        if multi_vm_sync_status is not None:
            pulumi.set(__self__, "multi_vm_sync_status", multi_vm_sync_status)
        if os_details is not None:
            pulumi.set(__self__, "os_details", os_details)
        if os_version is not None:
            pulumi.set(__self__, "os_version", os_version)
        if process_server_id is not None:
            pulumi.set(__self__, "process_server_id", process_server_id)
        if protected_disks is not None:
            pulumi.set(__self__, "protected_disks", protected_disks)
        if protection_stage is not None:
            pulumi.set(__self__, "protection_stage", protection_stage)
        if reboot_after_update_status is not None:
            pulumi.set(__self__, "reboot_after_update_status", reboot_after_update_status)
        if replica_id is not None:
            pulumi.set(__self__, "replica_id", replica_id)
        if resync_details is not None:
            pulumi.set(__self__, "resync_details", resync_details)
        if retention_window_end is not None:
            pulumi.set(__self__, "retention_window_end", retention_window_end)
        if retention_window_start is not None:
            pulumi.set(__self__, "retention_window_start", retention_window_start)
        if rpo_in_seconds is not None:
            pulumi.set(__self__, "rpo_in_seconds", rpo_in_seconds)
        if source_vm_cpu_count is not None:
            pulumi.set(__self__, "source_vm_cpu_count", source_vm_cpu_count)
        if source_vm_ram_size_in_mb is not None:
            pulumi.set(__self__, "source_vm_ram_size_in_mb", source_vm_ram_size_in_mb)
        if total_data_transferred is not None:
            pulumi.set(__self__, "total_data_transferred", total_data_transferred)
        if total_progress_health is not None:
            pulumi.set(__self__, "total_progress_health", total_progress_health)
        if uncompressed_data_rate_in_mb is not None:
            pulumi.set(__self__, "uncompressed_data_rate_in_mb", uncompressed_data_rate_in_mb)
        if v_center_infrastructure_id is not None:
            pulumi.set(__self__, "v_center_infrastructure_id", v_center_infrastructure_id)
        if validation_errors is not None:
            pulumi.set(__self__, "validation_errors", validation_errors)
        if vm_id is not None:
            pulumi.set(__self__, "vm_id", vm_id)
        if vm_nics is not None:
            pulumi.set(__self__, "vm_nics", vm_nics)
        if vm_protection_state is not None:
            pulumi.set(__self__, "vm_protection_state", vm_protection_state)
        if vm_protection_state_description is not None:
            pulumi.set(__self__, "vm_protection_state_description", vm_protection_state_description)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> str:
        """
        Gets the Instance type.
        Expected value is 'InMage'.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="activeSiteType")
    def active_site_type(self) -> Optional[str]:
        """
        The active location of the VM. If the VM is being protected from Azure, this field will take values from { Azure, OnPrem }. If the VM is being protected between two data-centers, this field will be OnPrem always.
        """
        return pulumi.get(self, "active_site_type")

    @property
    @pulumi.getter(name="agentDetails")
    def agent_details(self) -> Optional['outputs.InMageAgentDetailsResponse']:
        """
        The agent details.
        """
        return pulumi.get(self, "agent_details")

    @property
    @pulumi.getter(name="azureStorageAccountId")
    def azure_storage_account_id(self) -> Optional[str]:
        """
        A value indicating the underlying Azure storage account. If the VM is not running in Azure, this value shall be set to null.
        """
        return pulumi.get(self, "azure_storage_account_id")

    @property
    @pulumi.getter(name="compressedDataRateInMB")
    def compressed_data_rate_in_mb(self) -> Optional[float]:
        """
        The compressed data change rate in MB.
        """
        return pulumi.get(self, "compressed_data_rate_in_mb")

    @property
    @pulumi.getter(name="consistencyPoints")
    def consistency_points(self) -> Optional[Mapping[str, str]]:
        """
        The collection of Consistency points.
        """
        return pulumi.get(self, "consistency_points")

    @property
    @pulumi.getter
    def datastores(self) -> Optional[Sequence[str]]:
        """
        The datastores of the on-premise machine Value can be list of strings that contain datastore names.
        """
        return pulumi.get(self, "datastores")

    @property
    @pulumi.getter(name="discoveryType")
    def discovery_type(self) -> Optional[str]:
        """
        A value indicating the discovery type of the machine.
        """
        return pulumi.get(self, "discovery_type")

    @property
    @pulumi.getter(name="diskResized")
    def disk_resized(self) -> Optional[str]:
        """
        A value indicating whether any disk is resized for this VM.
        """
        return pulumi.get(self, "disk_resized")

    @property
    @pulumi.getter(name="infrastructureVmId")
    def infrastructure_vm_id(self) -> Optional[str]:
        """
        The infrastructure VM Id.
        """
        return pulumi.get(self, "infrastructure_vm_id")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[str]:
        """
        The source IP address.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter(name="isAdditionalStatsAvailable")
    def is_additional_stats_available(self) -> Optional[bool]:
        """
        A value indicating whether additional IR stats are available or not.
        """
        return pulumi.get(self, "is_additional_stats_available")

    @property
    @pulumi.getter(name="lastHeartbeat")
    def last_heartbeat(self) -> Optional[str]:
        """
        The last heartbeat received from the source server.
        """
        return pulumi.get(self, "last_heartbeat")

    @property
    @pulumi.getter(name="lastRpoCalculatedTime")
    def last_rpo_calculated_time(self) -> Optional[str]:
        """
        The last RPO calculated time.
        """
        return pulumi.get(self, "last_rpo_calculated_time")

    @property
    @pulumi.getter(name="lastUpdateReceivedTime")
    def last_update_received_time(self) -> Optional[str]:
        """
        The last update time received from on-prem components.
        """
        return pulumi.get(self, "last_update_received_time")

    @property
    @pulumi.getter(name="masterTargetId")
    def master_target_id(self) -> Optional[str]:
        """
        The master target Id.
        """
        return pulumi.get(self, "master_target_id")

    @property
    @pulumi.getter(name="multiVmGroupId")
    def multi_vm_group_id(self) -> Optional[str]:
        """
        The multi vm group Id, if any.
        """
        return pulumi.get(self, "multi_vm_group_id")

    @property
    @pulumi.getter(name="multiVmGroupName")
    def multi_vm_group_name(self) -> Optional[str]:
        """
        The multi vm group name, if any.
        """
        return pulumi.get(self, "multi_vm_group_name")

    @property
    @pulumi.getter(name="multiVmSyncStatus")
    def multi_vm_sync_status(self) -> Optional[str]:
        """
        A value indicating whether the multi vm sync is enabled or disabled.
        """
        return pulumi.get(self, "multi_vm_sync_status")

    @property
    @pulumi.getter(name="osDetails")
    def os_details(self) -> Optional['outputs.OSDiskDetailsResponse']:
        """
        The OS details.
        """
        return pulumi.get(self, "os_details")

    @property
    @pulumi.getter(name="osVersion")
    def os_version(self) -> Optional[str]:
        """
        The OS Version of the protected item.
        """
        return pulumi.get(self, "os_version")

    @property
    @pulumi.getter(name="processServerId")
    def process_server_id(self) -> Optional[str]:
        """
        The process server Id.
        """
        return pulumi.get(self, "process_server_id")

    @property
    @pulumi.getter(name="protectedDisks")
    def protected_disks(self) -> Optional[Sequence['outputs.InMageProtectedDiskDetailsResponse']]:
        """
        The list of protected disks.
        """
        return pulumi.get(self, "protected_disks")

    @property
    @pulumi.getter(name="protectionStage")
    def protection_stage(self) -> Optional[str]:
        """
        The protection stage.
        """
        return pulumi.get(self, "protection_stage")

    @property
    @pulumi.getter(name="rebootAfterUpdateStatus")
    def reboot_after_update_status(self) -> Optional[str]:
        """
        A value indicating whether the source server requires a restart after update.
        """
        return pulumi.get(self, "reboot_after_update_status")

    @property
    @pulumi.getter(name="replicaId")
    def replica_id(self) -> Optional[str]:
        """
        The replica id of the protected item.
        """
        return pulumi.get(self, "replica_id")

    @property
    @pulumi.getter(name="resyncDetails")
    def resync_details(self) -> Optional['outputs.InitialReplicationDetailsResponse']:
        """
        The resync details of the machine.
        """
        return pulumi.get(self, "resync_details")

    @property
    @pulumi.getter(name="retentionWindowEnd")
    def retention_window_end(self) -> Optional[str]:
        """
        The retention window end time.
        """
        return pulumi.get(self, "retention_window_end")

    @property
    @pulumi.getter(name="retentionWindowStart")
    def retention_window_start(self) -> Optional[str]:
        """
        The retention window start time.
        """
        return pulumi.get(self, "retention_window_start")

    @property
    @pulumi.getter(name="rpoInSeconds")
    def rpo_in_seconds(self) -> Optional[float]:
        """
        The RPO in seconds.
        """
        return pulumi.get(self, "rpo_in_seconds")

    @property
    @pulumi.getter(name="sourceVmCpuCount")
    def source_vm_cpu_count(self) -> Optional[int]:
        """
        The CPU count of the VM on the primary side.
        """
        return pulumi.get(self, "source_vm_cpu_count")

    @property
    @pulumi.getter(name="sourceVmRamSizeInMB")
    def source_vm_ram_size_in_mb(self) -> Optional[int]:
        """
        The RAM size of the VM on the primary side.
        """
        return pulumi.get(self, "source_vm_ram_size_in_mb")

    @property
    @pulumi.getter(name="totalDataTransferred")
    def total_data_transferred(self) -> Optional[float]:
        """
        The total transferred data in bytes.
        """
        return pulumi.get(self, "total_data_transferred")

    @property
    @pulumi.getter(name="totalProgressHealth")
    def total_progress_health(self) -> Optional[str]:
        """
        The progress health.
        """
        return pulumi.get(self, "total_progress_health")

    @property
    @pulumi.getter(name="uncompressedDataRateInMB")
    def uncompressed_data_rate_in_mb(self) -> Optional[float]:
        """
        The uncompressed data change rate in MB.
        """
        return pulumi.get(self, "uncompressed_data_rate_in_mb")

    @property
    @pulumi.getter(name="vCenterInfrastructureId")
    def v_center_infrastructure_id(self) -> Optional[str]:
        """
        The vCenter infrastructure Id.
        """
        return pulumi.get(self, "v_center_infrastructure_id")

    @property
    @pulumi.getter(name="validationErrors")
    def validation_errors(self) -> Optional[Sequence['outputs.HealthErrorResponse']]:
        """
        The validation errors of the on-premise machine Value can be list of validation errors.
        """
        return pulumi.get(self, "validation_errors")

    @property
    @pulumi.getter(name="vmId")
    def vm_id(self) -> Optional[str]:
        """
        The virtual machine Id.
        """
        return pulumi.get(self, "vm_id")

    @property
    @pulumi.getter(name="vmNics")
    def vm_nics(self) -> Optional[Sequence['outputs.VMNicDetailsResponse']]:
        """
        The PE Network details.
        """
        return pulumi.get(self, "vm_nics")

    @property
    @pulumi.getter(name="vmProtectionState")
    def vm_protection_state(self) -> Optional[str]:
        """
        The protection state for the vm.
        """
        return pulumi.get(self, "vm_protection_state")

    @property
    @pulumi.getter(name="vmProtectionStateDescription")
    def vm_protection_state_description(self) -> Optional[str]:
        """
        The protection state description for the vm.
        """
        return pulumi.get(self, "vm_protection_state_description")


@pulumi.output_type
class InitialReplicationDetailsResponse(dict):
    """
    Initial replication details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "initialReplicationProgressPercentage":
            suggest = "initial_replication_progress_percentage"
        elif key == "initialReplicationType":
            suggest = "initial_replication_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InitialReplicationDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InitialReplicationDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InitialReplicationDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 initial_replication_progress_percentage: Optional[str] = None,
                 initial_replication_type: Optional[str] = None):
        """
        Initial replication details.
        :param str initial_replication_progress_percentage: The initial replication progress percentage.
        :param str initial_replication_type: Initial replication type.
        """
        if initial_replication_progress_percentage is not None:
            pulumi.set(__self__, "initial_replication_progress_percentage", initial_replication_progress_percentage)
        if initial_replication_type is not None:
            pulumi.set(__self__, "initial_replication_type", initial_replication_type)

    @property
    @pulumi.getter(name="initialReplicationProgressPercentage")
    def initial_replication_progress_percentage(self) -> Optional[str]:
        """
        The initial replication progress percentage.
        """
        return pulumi.get(self, "initial_replication_progress_percentage")

    @property
    @pulumi.getter(name="initialReplicationType")
    def initial_replication_type(self) -> Optional[str]:
        """
        Initial replication type.
        """
        return pulumi.get(self, "initial_replication_type")


@pulumi.output_type
class InnerHealthErrorResponse(dict):
    """
    Implements InnerHealthError class. HealthError object has a list of InnerHealthErrors as child errors. InnerHealthError is used because this will prevent an infinite loop of structures when Hydra tries to auto-generate the contract. We are exposing the related health errors as inner health errors and all API consumers can utilize this in the same fashion as Exception -&gt; InnerException.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "creationTimeUtc":
            suggest = "creation_time_utc"
        elif key == "customerResolvability":
            suggest = "customer_resolvability"
        elif key == "entityId":
            suggest = "entity_id"
        elif key == "errorCategory":
            suggest = "error_category"
        elif key == "errorCode":
            suggest = "error_code"
        elif key == "errorId":
            suggest = "error_id"
        elif key == "errorLevel":
            suggest = "error_level"
        elif key == "errorMessage":
            suggest = "error_message"
        elif key == "errorSource":
            suggest = "error_source"
        elif key == "errorType":
            suggest = "error_type"
        elif key == "possibleCauses":
            suggest = "possible_causes"
        elif key == "recommendedAction":
            suggest = "recommended_action"
        elif key == "recoveryProviderErrorMessage":
            suggest = "recovery_provider_error_message"
        elif key == "summaryMessage":
            suggest = "summary_message"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InnerHealthErrorResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InnerHealthErrorResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InnerHealthErrorResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 creation_time_utc: Optional[str] = None,
                 customer_resolvability: Optional[str] = None,
                 entity_id: Optional[str] = None,
                 error_category: Optional[str] = None,
                 error_code: Optional[str] = None,
                 error_id: Optional[str] = None,
                 error_level: Optional[str] = None,
                 error_message: Optional[str] = None,
                 error_source: Optional[str] = None,
                 error_type: Optional[str] = None,
                 possible_causes: Optional[str] = None,
                 recommended_action: Optional[str] = None,
                 recovery_provider_error_message: Optional[str] = None,
                 summary_message: Optional[str] = None):
        """
        Implements InnerHealthError class. HealthError object has a list of InnerHealthErrors as child errors. InnerHealthError is used because this will prevent an infinite loop of structures when Hydra tries to auto-generate the contract. We are exposing the related health errors as inner health errors and all API consumers can utilize this in the same fashion as Exception -&gt; InnerException.
        :param str creation_time_utc: Error creation time (UTC).
        :param str customer_resolvability: Value indicating whether the health error is customer resolvable.
        :param str entity_id: ID of the entity.
        :param str error_category: Category of error.
        :param str error_code: Error code.
        :param str error_id: The health error unique id.
        :param str error_level: Level of error.
        :param str error_message: Error message.
        :param str error_source: Source of error.
        :param str error_type: Type of error.
        :param str possible_causes: Possible causes of error.
        :param str recommended_action: Recommended action to resolve error.
        :param str recovery_provider_error_message: DRA error message.
        :param str summary_message: Summary message of the entity.
        """
        if creation_time_utc is not None:
            pulumi.set(__self__, "creation_time_utc", creation_time_utc)
        if customer_resolvability is not None:
            pulumi.set(__self__, "customer_resolvability", customer_resolvability)
        if entity_id is not None:
            pulumi.set(__self__, "entity_id", entity_id)
        if error_category is not None:
            pulumi.set(__self__, "error_category", error_category)
        if error_code is not None:
            pulumi.set(__self__, "error_code", error_code)
        if error_id is not None:
            pulumi.set(__self__, "error_id", error_id)
        if error_level is not None:
            pulumi.set(__self__, "error_level", error_level)
        if error_message is not None:
            pulumi.set(__self__, "error_message", error_message)
        if error_source is not None:
            pulumi.set(__self__, "error_source", error_source)
        if error_type is not None:
            pulumi.set(__self__, "error_type", error_type)
        if possible_causes is not None:
            pulumi.set(__self__, "possible_causes", possible_causes)
        if recommended_action is not None:
            pulumi.set(__self__, "recommended_action", recommended_action)
        if recovery_provider_error_message is not None:
            pulumi.set(__self__, "recovery_provider_error_message", recovery_provider_error_message)
        if summary_message is not None:
            pulumi.set(__self__, "summary_message", summary_message)

    @property
    @pulumi.getter(name="creationTimeUtc")
    def creation_time_utc(self) -> Optional[str]:
        """
        Error creation time (UTC).
        """
        return pulumi.get(self, "creation_time_utc")

    @property
    @pulumi.getter(name="customerResolvability")
    def customer_resolvability(self) -> Optional[str]:
        """
        Value indicating whether the health error is customer resolvable.
        """
        return pulumi.get(self, "customer_resolvability")

    @property
    @pulumi.getter(name="entityId")
    def entity_id(self) -> Optional[str]:
        """
        ID of the entity.
        """
        return pulumi.get(self, "entity_id")

    @property
    @pulumi.getter(name="errorCategory")
    def error_category(self) -> Optional[str]:
        """
        Category of error.
        """
        return pulumi.get(self, "error_category")

    @property
    @pulumi.getter(name="errorCode")
    def error_code(self) -> Optional[str]:
        """
        Error code.
        """
        return pulumi.get(self, "error_code")

    @property
    @pulumi.getter(name="errorId")
    def error_id(self) -> Optional[str]:
        """
        The health error unique id.
        """
        return pulumi.get(self, "error_id")

    @property
    @pulumi.getter(name="errorLevel")
    def error_level(self) -> Optional[str]:
        """
        Level of error.
        """
        return pulumi.get(self, "error_level")

    @property
    @pulumi.getter(name="errorMessage")
    def error_message(self) -> Optional[str]:
        """
        Error message.
        """
        return pulumi.get(self, "error_message")

    @property
    @pulumi.getter(name="errorSource")
    def error_source(self) -> Optional[str]:
        """
        Source of error.
        """
        return pulumi.get(self, "error_source")

    @property
    @pulumi.getter(name="errorType")
    def error_type(self) -> Optional[str]:
        """
        Type of error.
        """
        return pulumi.get(self, "error_type")

    @property
    @pulumi.getter(name="possibleCauses")
    def possible_causes(self) -> Optional[str]:
        """
        Possible causes of error.
        """
        return pulumi.get(self, "possible_causes")

    @property
    @pulumi.getter(name="recommendedAction")
    def recommended_action(self) -> Optional[str]:
        """
        Recommended action to resolve error.
        """
        return pulumi.get(self, "recommended_action")

    @property
    @pulumi.getter(name="recoveryProviderErrorMessage")
    def recovery_provider_error_message(self) -> Optional[str]:
        """
        DRA error message.
        """
        return pulumi.get(self, "recovery_provider_error_message")

    @property
    @pulumi.getter(name="summaryMessage")
    def summary_message(self) -> Optional[str]:
        """
        Summary message of the entity.
        """
        return pulumi.get(self, "summary_message")


@pulumi.output_type
class InputEndpointResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endpointName":
            suggest = "endpoint_name"
        elif key == "privatePort":
            suggest = "private_port"
        elif key == "publicPort":
            suggest = "public_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InputEndpointResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InputEndpointResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InputEndpointResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 endpoint_name: Optional[str] = None,
                 private_port: Optional[int] = None,
                 protocol: Optional[str] = None,
                 public_port: Optional[int] = None):
        if endpoint_name is not None:
            pulumi.set(__self__, "endpoint_name", endpoint_name)
        if private_port is not None:
            pulumi.set(__self__, "private_port", private_port)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if public_port is not None:
            pulumi.set(__self__, "public_port", public_port)

    @property
    @pulumi.getter(name="endpointName")
    def endpoint_name(self) -> Optional[str]:
        return pulumi.get(self, "endpoint_name")

    @property
    @pulumi.getter(name="privatePort")
    def private_port(self) -> Optional[int]:
        return pulumi.get(self, "private_port")

    @property
    @pulumi.getter
    def protocol(self) -> Optional[str]:
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="publicPort")
    def public_port(self) -> Optional[int]:
        return pulumi.get(self, "public_port")


@pulumi.output_type
class MarsAgentDetailsResponse(dict):
    """
    Mars agent details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "biosId":
            suggest = "bios_id"
        elif key == "fabricObjectId":
            suggest = "fabric_object_id"
        elif key == "healthErrors":
            suggest = "health_errors"
        elif key == "lastHeartbeatUtc":
            suggest = "last_heartbeat_utc"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MarsAgentDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MarsAgentDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MarsAgentDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bios_id: str,
                 fabric_object_id: str,
                 fqdn: str,
                 health: str,
                 health_errors: Sequence['outputs.HealthErrorResponse'],
                 id: str,
                 last_heartbeat_utc: str,
                 name: str,
                 version: str):
        """
        Mars agent details.
        :param str bios_id: The Mars agent Bios Id.
        :param str fabric_object_id: The fabric object Id.
        :param str fqdn: The Mars agent Fqdn.
        :param str health: The health of the Mars agent.
        :param Sequence['HealthErrorResponse'] health_errors: The health errors.
        :param str id: The Mars agent Id.
        :param str last_heartbeat_utc: The last heartbeat received from the Mars agent.
        :param str name: The Mars agent name.
        :param str version: The version.
        """
        pulumi.set(__self__, "bios_id", bios_id)
        pulumi.set(__self__, "fabric_object_id", fabric_object_id)
        pulumi.set(__self__, "fqdn", fqdn)
        pulumi.set(__self__, "health", health)
        pulumi.set(__self__, "health_errors", health_errors)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "last_heartbeat_utc", last_heartbeat_utc)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="biosId")
    def bios_id(self) -> str:
        """
        The Mars agent Bios Id.
        """
        return pulumi.get(self, "bios_id")

    @property
    @pulumi.getter(name="fabricObjectId")
    def fabric_object_id(self) -> str:
        """
        The fabric object Id.
        """
        return pulumi.get(self, "fabric_object_id")

    @property
    @pulumi.getter
    def fqdn(self) -> str:
        """
        The Mars agent Fqdn.
        """
        return pulumi.get(self, "fqdn")

    @property
    @pulumi.getter
    def health(self) -> str:
        """
        The health of the Mars agent.
        """
        return pulumi.get(self, "health")

    @property
    @pulumi.getter(name="healthErrors")
    def health_errors(self) -> Sequence['outputs.HealthErrorResponse']:
        """
        The health errors.
        """
        return pulumi.get(self, "health_errors")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The Mars agent Id.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lastHeartbeatUtc")
    def last_heartbeat_utc(self) -> str:
        """
        The last heartbeat received from the Mars agent.
        """
        return pulumi.get(self, "last_heartbeat_utc")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The Mars agent name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        The version.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class MasterTargetServerResponse(dict):
    """
    Details of a Master Target Server.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "agentExpiryDate":
            suggest = "agent_expiry_date"
        elif key == "agentVersion":
            suggest = "agent_version"
        elif key == "agentVersionDetails":
            suggest = "agent_version_details"
        elif key == "dataStores":
            suggest = "data_stores"
        elif key == "diskCount":
            suggest = "disk_count"
        elif key == "healthErrors":
            suggest = "health_errors"
        elif key == "ipAddress":
            suggest = "ip_address"
        elif key == "lastHeartbeat":
            suggest = "last_heartbeat"
        elif key == "marsAgentExpiryDate":
            suggest = "mars_agent_expiry_date"
        elif key == "marsAgentVersion":
            suggest = "mars_agent_version"
        elif key == "marsAgentVersionDetails":
            suggest = "mars_agent_version_details"
        elif key == "osType":
            suggest = "os_type"
        elif key == "osVersion":
            suggest = "os_version"
        elif key == "retentionVolumes":
            suggest = "retention_volumes"
        elif key == "validationErrors":
            suggest = "validation_errors"
        elif key == "versionStatus":
            suggest = "version_status"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MasterTargetServerResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MasterTargetServerResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MasterTargetServerResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 agent_expiry_date: Optional[str] = None,
                 agent_version: Optional[str] = None,
                 agent_version_details: Optional['outputs.VersionDetailsResponse'] = None,
                 data_stores: Optional[Sequence['outputs.DataStoreResponse']] = None,
                 disk_count: Optional[int] = None,
                 health_errors: Optional[Sequence['outputs.HealthErrorResponse']] = None,
                 id: Optional[str] = None,
                 ip_address: Optional[str] = None,
                 last_heartbeat: Optional[str] = None,
                 mars_agent_expiry_date: Optional[str] = None,
                 mars_agent_version: Optional[str] = None,
                 mars_agent_version_details: Optional['outputs.VersionDetailsResponse'] = None,
                 name: Optional[str] = None,
                 os_type: Optional[str] = None,
                 os_version: Optional[str] = None,
                 retention_volumes: Optional[Sequence['outputs.RetentionVolumeResponse']] = None,
                 validation_errors: Optional[Sequence['outputs.HealthErrorResponse']] = None,
                 version_status: Optional[str] = None):
        """
        Details of a Master Target Server.
        :param str agent_expiry_date: Agent expiry date.
        :param str agent_version: The version of the scout component on the server.
        :param 'VersionDetailsResponse' agent_version_details: Agent version details.
        :param Sequence['DataStoreResponse'] data_stores: The list of data stores in the fabric.
        :param int disk_count: Disk count of the master target.
        :param Sequence['HealthErrorResponse'] health_errors: Health errors.
        :param str id: The server Id.
        :param str ip_address: The IP address of the server.
        :param str last_heartbeat: The last heartbeat received from the server.
        :param str mars_agent_expiry_date: MARS agent expiry date.
        :param str mars_agent_version: MARS agent version.
        :param 'VersionDetailsResponse' mars_agent_version_details: Mars agent version details.
        :param str name: The server name.
        :param str os_type: The OS type of the server.
        :param str os_version: OS Version of the master target.
        :param Sequence['RetentionVolumeResponse'] retention_volumes: The retention volumes of Master target Server.
        :param Sequence['HealthErrorResponse'] validation_errors: Validation errors.
        :param str version_status: Version status.
        """
        if agent_expiry_date is not None:
            pulumi.set(__self__, "agent_expiry_date", agent_expiry_date)
        if agent_version is not None:
            pulumi.set(__self__, "agent_version", agent_version)
        if agent_version_details is not None:
            pulumi.set(__self__, "agent_version_details", agent_version_details)
        if data_stores is not None:
            pulumi.set(__self__, "data_stores", data_stores)
        if disk_count is not None:
            pulumi.set(__self__, "disk_count", disk_count)
        if health_errors is not None:
            pulumi.set(__self__, "health_errors", health_errors)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if last_heartbeat is not None:
            pulumi.set(__self__, "last_heartbeat", last_heartbeat)
        if mars_agent_expiry_date is not None:
            pulumi.set(__self__, "mars_agent_expiry_date", mars_agent_expiry_date)
        if mars_agent_version is not None:
            pulumi.set(__self__, "mars_agent_version", mars_agent_version)
        if mars_agent_version_details is not None:
            pulumi.set(__self__, "mars_agent_version_details", mars_agent_version_details)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if os_type is not None:
            pulumi.set(__self__, "os_type", os_type)
        if os_version is not None:
            pulumi.set(__self__, "os_version", os_version)
        if retention_volumes is not None:
            pulumi.set(__self__, "retention_volumes", retention_volumes)
        if validation_errors is not None:
            pulumi.set(__self__, "validation_errors", validation_errors)
        if version_status is not None:
            pulumi.set(__self__, "version_status", version_status)

    @property
    @pulumi.getter(name="agentExpiryDate")
    def agent_expiry_date(self) -> Optional[str]:
        """
        Agent expiry date.
        """
        return pulumi.get(self, "agent_expiry_date")

    @property
    @pulumi.getter(name="agentVersion")
    def agent_version(self) -> Optional[str]:
        """
        The version of the scout component on the server.
        """
        return pulumi.get(self, "agent_version")

    @property
    @pulumi.getter(name="agentVersionDetails")
    def agent_version_details(self) -> Optional['outputs.VersionDetailsResponse']:
        """
        Agent version details.
        """
        return pulumi.get(self, "agent_version_details")

    @property
    @pulumi.getter(name="dataStores")
    def data_stores(self) -> Optional[Sequence['outputs.DataStoreResponse']]:
        """
        The list of data stores in the fabric.
        """
        return pulumi.get(self, "data_stores")

    @property
    @pulumi.getter(name="diskCount")
    def disk_count(self) -> Optional[int]:
        """
        Disk count of the master target.
        """
        return pulumi.get(self, "disk_count")

    @property
    @pulumi.getter(name="healthErrors")
    def health_errors(self) -> Optional[Sequence['outputs.HealthErrorResponse']]:
        """
        Health errors.
        """
        return pulumi.get(self, "health_errors")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The server Id.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[str]:
        """
        The IP address of the server.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter(name="lastHeartbeat")
    def last_heartbeat(self) -> Optional[str]:
        """
        The last heartbeat received from the server.
        """
        return pulumi.get(self, "last_heartbeat")

    @property
    @pulumi.getter(name="marsAgentExpiryDate")
    def mars_agent_expiry_date(self) -> Optional[str]:
        """
        MARS agent expiry date.
        """
        return pulumi.get(self, "mars_agent_expiry_date")

    @property
    @pulumi.getter(name="marsAgentVersion")
    def mars_agent_version(self) -> Optional[str]:
        """
        MARS agent version.
        """
        return pulumi.get(self, "mars_agent_version")

    @property
    @pulumi.getter(name="marsAgentVersionDetails")
    def mars_agent_version_details(self) -> Optional['outputs.VersionDetailsResponse']:
        """
        Mars agent version details.
        """
        return pulumi.get(self, "mars_agent_version_details")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The server name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="osType")
    def os_type(self) -> Optional[str]:
        """
        The OS type of the server.
        """
        return pulumi.get(self, "os_type")

    @property
    @pulumi.getter(name="osVersion")
    def os_version(self) -> Optional[str]:
        """
        OS Version of the master target.
        """
        return pulumi.get(self, "os_version")

    @property
    @pulumi.getter(name="retentionVolumes")
    def retention_volumes(self) -> Optional[Sequence['outputs.RetentionVolumeResponse']]:
        """
        The retention volumes of Master target Server.
        """
        return pulumi.get(self, "retention_volumes")

    @property
    @pulumi.getter(name="validationErrors")
    def validation_errors(self) -> Optional[Sequence['outputs.HealthErrorResponse']]:
        """
        Validation errors.
        """
        return pulumi.get(self, "validation_errors")

    @property
    @pulumi.getter(name="versionStatus")
    def version_status(self) -> Optional[str]:
        """
        Version status.
        """
        return pulumi.get(self, "version_status")


@pulumi.output_type
class MigrationItemPropertiesResponse(dict):
    """
    Migration item properties.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedOperations":
            suggest = "allowed_operations"
        elif key == "currentJob":
            suggest = "current_job"
        elif key == "eventCorrelationId":
            suggest = "event_correlation_id"
        elif key == "healthErrors":
            suggest = "health_errors"
        elif key == "lastTestMigrationStatus":
            suggest = "last_test_migration_status"
        elif key == "lastTestMigrationTime":
            suggest = "last_test_migration_time"
        elif key == "machineName":
            suggest = "machine_name"
        elif key == "migrationState":
            suggest = "migration_state"
        elif key == "migrationStateDescription":
            suggest = "migration_state_description"
        elif key == "policyFriendlyName":
            suggest = "policy_friendly_name"
        elif key == "policyId":
            suggest = "policy_id"
        elif key == "testMigrateState":
            suggest = "test_migrate_state"
        elif key == "testMigrateStateDescription":
            suggest = "test_migrate_state_description"
        elif key == "providerSpecificDetails":
            suggest = "provider_specific_details"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MigrationItemPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MigrationItemPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MigrationItemPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_operations: Sequence[str],
                 current_job: 'outputs.CurrentJobDetailsResponse',
                 event_correlation_id: str,
                 health: str,
                 health_errors: Sequence['outputs.HealthErrorResponse'],
                 last_test_migration_status: str,
                 last_test_migration_time: str,
                 machine_name: str,
                 migration_state: str,
                 migration_state_description: str,
                 policy_friendly_name: str,
                 policy_id: str,
                 test_migrate_state: str,
                 test_migrate_state_description: str,
                 provider_specific_details: Optional['outputs.VMwareCbtMigrationDetailsResponse'] = None):
        """
        Migration item properties.
        :param Sequence[str] allowed_operations: The allowed operations on the migration item based on the current migration state of the item.
        :param 'CurrentJobDetailsResponse' current_job: The current job details.
        :param str event_correlation_id: The correlation Id for events associated with this migration item.
        :param str health: The consolidated health.
        :param Sequence['HealthErrorResponse'] health_errors: The list of health errors.
        :param str last_test_migration_status: The status of the last test migration.
        :param str last_test_migration_time: The last test migration time.
        :param str machine_name: The on-premise virtual machine name.
        :param str migration_state: The migration status.
        :param str migration_state_description: The migration state description.
        :param str policy_friendly_name: The name of policy governing this item.
        :param str policy_id: The ARM Id of policy governing this item.
        :param str test_migrate_state: The test migrate state.
        :param str test_migrate_state_description: The test migrate state description.
        :param 'VMwareCbtMigrationDetailsResponse' provider_specific_details: The migration provider custom settings.
        """
        pulumi.set(__self__, "allowed_operations", allowed_operations)
        pulumi.set(__self__, "current_job", current_job)
        pulumi.set(__self__, "event_correlation_id", event_correlation_id)
        pulumi.set(__self__, "health", health)
        pulumi.set(__self__, "health_errors", health_errors)
        pulumi.set(__self__, "last_test_migration_status", last_test_migration_status)
        pulumi.set(__self__, "last_test_migration_time", last_test_migration_time)
        pulumi.set(__self__, "machine_name", machine_name)
        pulumi.set(__self__, "migration_state", migration_state)
        pulumi.set(__self__, "migration_state_description", migration_state_description)
        pulumi.set(__self__, "policy_friendly_name", policy_friendly_name)
        pulumi.set(__self__, "policy_id", policy_id)
        pulumi.set(__self__, "test_migrate_state", test_migrate_state)
        pulumi.set(__self__, "test_migrate_state_description", test_migrate_state_description)
        if provider_specific_details is not None:
            pulumi.set(__self__, "provider_specific_details", provider_specific_details)

    @property
    @pulumi.getter(name="allowedOperations")
    def allowed_operations(self) -> Sequence[str]:
        """
        The allowed operations on the migration item based on the current migration state of the item.
        """
        return pulumi.get(self, "allowed_operations")

    @property
    @pulumi.getter(name="currentJob")
    def current_job(self) -> 'outputs.CurrentJobDetailsResponse':
        """
        The current job details.
        """
        return pulumi.get(self, "current_job")

    @property
    @pulumi.getter(name="eventCorrelationId")
    def event_correlation_id(self) -> str:
        """
        The correlation Id for events associated with this migration item.
        """
        return pulumi.get(self, "event_correlation_id")

    @property
    @pulumi.getter
    def health(self) -> str:
        """
        The consolidated health.
        """
        return pulumi.get(self, "health")

    @property
    @pulumi.getter(name="healthErrors")
    def health_errors(self) -> Sequence['outputs.HealthErrorResponse']:
        """
        The list of health errors.
        """
        return pulumi.get(self, "health_errors")

    @property
    @pulumi.getter(name="lastTestMigrationStatus")
    def last_test_migration_status(self) -> str:
        """
        The status of the last test migration.
        """
        return pulumi.get(self, "last_test_migration_status")

    @property
    @pulumi.getter(name="lastTestMigrationTime")
    def last_test_migration_time(self) -> str:
        """
        The last test migration time.
        """
        return pulumi.get(self, "last_test_migration_time")

    @property
    @pulumi.getter(name="machineName")
    def machine_name(self) -> str:
        """
        The on-premise virtual machine name.
        """
        return pulumi.get(self, "machine_name")

    @property
    @pulumi.getter(name="migrationState")
    def migration_state(self) -> str:
        """
        The migration status.
        """
        return pulumi.get(self, "migration_state")

    @property
    @pulumi.getter(name="migrationStateDescription")
    def migration_state_description(self) -> str:
        """
        The migration state description.
        """
        return pulumi.get(self, "migration_state_description")

    @property
    @pulumi.getter(name="policyFriendlyName")
    def policy_friendly_name(self) -> str:
        """
        The name of policy governing this item.
        """
        return pulumi.get(self, "policy_friendly_name")

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> str:
        """
        The ARM Id of policy governing this item.
        """
        return pulumi.get(self, "policy_id")

    @property
    @pulumi.getter(name="testMigrateState")
    def test_migrate_state(self) -> str:
        """
        The test migrate state.
        """
        return pulumi.get(self, "test_migrate_state")

    @property
    @pulumi.getter(name="testMigrateStateDescription")
    def test_migrate_state_description(self) -> str:
        """
        The test migrate state description.
        """
        return pulumi.get(self, "test_migrate_state_description")

    @property
    @pulumi.getter(name="providerSpecificDetails")
    def provider_specific_details(self) -> Optional['outputs.VMwareCbtMigrationDetailsResponse']:
        """
        The migration provider custom settings.
        """
        return pulumi.get(self, "provider_specific_details")


@pulumi.output_type
class MobilityServiceUpdateResponse(dict):
    """
    The Mobility Service update details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "osType":
            suggest = "os_type"
        elif key == "rebootStatus":
            suggest = "reboot_status"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MobilityServiceUpdateResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MobilityServiceUpdateResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MobilityServiceUpdateResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 os_type: Optional[str] = None,
                 reboot_status: Optional[str] = None,
                 version: Optional[str] = None):
        """
        The Mobility Service update details.
        :param str os_type: The OS type.
        :param str reboot_status: The reboot status of the update - whether it is required or not.
        :param str version: The version of the latest update.
        """
        if os_type is not None:
            pulumi.set(__self__, "os_type", os_type)
        if reboot_status is not None:
            pulumi.set(__self__, "reboot_status", reboot_status)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="osType")
    def os_type(self) -> Optional[str]:
        """
        The OS type.
        """
        return pulumi.get(self, "os_type")

    @property
    @pulumi.getter(name="rebootStatus")
    def reboot_status(self) -> Optional[str]:
        """
        The reboot status of the update - whether it is required or not.
        """
        return pulumi.get(self, "reboot_status")

    @property
    @pulumi.getter
    def version(self) -> Optional[str]:
        """
        The version of the latest update.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class MonitoringSettingsResponse(dict):
    """
    Monitoring Settings of the vault
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "azureMonitorAlertSettings":
            suggest = "azure_monitor_alert_settings"
        elif key == "classicAlertSettings":
            suggest = "classic_alert_settings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MonitoringSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MonitoringSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MonitoringSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 azure_monitor_alert_settings: Optional['outputs.AzureMonitorAlertSettingsResponse'] = None,
                 classic_alert_settings: Optional['outputs.ClassicAlertSettingsResponse'] = None):
        """
        Monitoring Settings of the vault
        :param 'AzureMonitorAlertSettingsResponse' azure_monitor_alert_settings: Settings for Azure Monitor based alerts
        :param 'ClassicAlertSettingsResponse' classic_alert_settings: Settings for classic alerts
        """
        if azure_monitor_alert_settings is not None:
            pulumi.set(__self__, "azure_monitor_alert_settings", azure_monitor_alert_settings)
        if classic_alert_settings is not None:
            pulumi.set(__self__, "classic_alert_settings", classic_alert_settings)

    @property
    @pulumi.getter(name="azureMonitorAlertSettings")
    def azure_monitor_alert_settings(self) -> Optional['outputs.AzureMonitorAlertSettingsResponse']:
        """
        Settings for Azure Monitor based alerts
        """
        return pulumi.get(self, "azure_monitor_alert_settings")

    @property
    @pulumi.getter(name="classicAlertSettings")
    def classic_alert_settings(self) -> Optional['outputs.ClassicAlertSettingsResponse']:
        """
        Settings for classic alerts
        """
        return pulumi.get(self, "classic_alert_settings")


@pulumi.output_type
class NetworkMappingPropertiesResponse(dict):
    """
    Network Mapping Properties.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fabricSpecificSettings":
            suggest = "fabric_specific_settings"
        elif key == "primaryFabricFriendlyName":
            suggest = "primary_fabric_friendly_name"
        elif key == "primaryNetworkFriendlyName":
            suggest = "primary_network_friendly_name"
        elif key == "primaryNetworkId":
            suggest = "primary_network_id"
        elif key == "recoveryFabricArmId":
            suggest = "recovery_fabric_arm_id"
        elif key == "recoveryFabricFriendlyName":
            suggest = "recovery_fabric_friendly_name"
        elif key == "recoveryNetworkFriendlyName":
            suggest = "recovery_network_friendly_name"
        elif key == "recoveryNetworkId":
            suggest = "recovery_network_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkMappingPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkMappingPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkMappingPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fabric_specific_settings: Optional[Any] = None,
                 primary_fabric_friendly_name: Optional[str] = None,
                 primary_network_friendly_name: Optional[str] = None,
                 primary_network_id: Optional[str] = None,
                 recovery_fabric_arm_id: Optional[str] = None,
                 recovery_fabric_friendly_name: Optional[str] = None,
                 recovery_network_friendly_name: Optional[str] = None,
                 recovery_network_id: Optional[str] = None,
                 state: Optional[str] = None):
        """
        Network Mapping Properties.
        :param Union['AzureToAzureNetworkMappingSettingsResponse', 'VmmToAzureNetworkMappingSettingsResponse', 'VmmToVmmNetworkMappingSettingsResponse'] fabric_specific_settings: The fabric specific settings.
        :param str primary_fabric_friendly_name: The primary fabric friendly name.
        :param str primary_network_friendly_name: The primary network friendly name.
        :param str primary_network_id: The primary network id for network mapping.
        :param str recovery_fabric_arm_id: The recovery fabric ARM id.
        :param str recovery_fabric_friendly_name: The recovery fabric friendly name.
        :param str recovery_network_friendly_name: The recovery network friendly name.
        :param str recovery_network_id: The recovery network id for network mapping.
        :param str state: The pairing state for network mapping.
        """
        if fabric_specific_settings is not None:
            pulumi.set(__self__, "fabric_specific_settings", fabric_specific_settings)
        if primary_fabric_friendly_name is not None:
            pulumi.set(__self__, "primary_fabric_friendly_name", primary_fabric_friendly_name)
        if primary_network_friendly_name is not None:
            pulumi.set(__self__, "primary_network_friendly_name", primary_network_friendly_name)
        if primary_network_id is not None:
            pulumi.set(__self__, "primary_network_id", primary_network_id)
        if recovery_fabric_arm_id is not None:
            pulumi.set(__self__, "recovery_fabric_arm_id", recovery_fabric_arm_id)
        if recovery_fabric_friendly_name is not None:
            pulumi.set(__self__, "recovery_fabric_friendly_name", recovery_fabric_friendly_name)
        if recovery_network_friendly_name is not None:
            pulumi.set(__self__, "recovery_network_friendly_name", recovery_network_friendly_name)
        if recovery_network_id is not None:
            pulumi.set(__self__, "recovery_network_id", recovery_network_id)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="fabricSpecificSettings")
    def fabric_specific_settings(self) -> Optional[Any]:
        """
        The fabric specific settings.
        """
        return pulumi.get(self, "fabric_specific_settings")

    @property
    @pulumi.getter(name="primaryFabricFriendlyName")
    def primary_fabric_friendly_name(self) -> Optional[str]:
        """
        The primary fabric friendly name.
        """
        return pulumi.get(self, "primary_fabric_friendly_name")

    @property
    @pulumi.getter(name="primaryNetworkFriendlyName")
    def primary_network_friendly_name(self) -> Optional[str]:
        """
        The primary network friendly name.
        """
        return pulumi.get(self, "primary_network_friendly_name")

    @property
    @pulumi.getter(name="primaryNetworkId")
    def primary_network_id(self) -> Optional[str]:
        """
        The primary network id for network mapping.
        """
        return pulumi.get(self, "primary_network_id")

    @property
    @pulumi.getter(name="recoveryFabricArmId")
    def recovery_fabric_arm_id(self) -> Optional[str]:
        """
        The recovery fabric ARM id.
        """
        return pulumi.get(self, "recovery_fabric_arm_id")

    @property
    @pulumi.getter(name="recoveryFabricFriendlyName")
    def recovery_fabric_friendly_name(self) -> Optional[str]:
        """
        The recovery fabric friendly name.
        """
        return pulumi.get(self, "recovery_fabric_friendly_name")

    @property
    @pulumi.getter(name="recoveryNetworkFriendlyName")
    def recovery_network_friendly_name(self) -> Optional[str]:
        """
        The recovery network friendly name.
        """
        return pulumi.get(self, "recovery_network_friendly_name")

    @property
    @pulumi.getter(name="recoveryNetworkId")
    def recovery_network_id(self) -> Optional[str]:
        """
        The recovery network id for network mapping.
        """
        return pulumi.get(self, "recovery_network_id")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The pairing state for network mapping.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class OSDetailsResponse(dict):
    """
    Disk Details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "oSMajorVersion":
            suggest = "o_s_major_version"
        elif key == "oSMinorVersion":
            suggest = "o_s_minor_version"
        elif key == "oSVersion":
            suggest = "o_s_version"
        elif key == "osEdition":
            suggest = "os_edition"
        elif key == "osType":
            suggest = "os_type"
        elif key == "productType":
            suggest = "product_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OSDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OSDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OSDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 o_s_major_version: Optional[str] = None,
                 o_s_minor_version: Optional[str] = None,
                 o_s_version: Optional[str] = None,
                 os_edition: Optional[str] = None,
                 os_type: Optional[str] = None,
                 product_type: Optional[str] = None):
        """
        Disk Details.
        :param str o_s_major_version: The OS Major Version.
        :param str o_s_minor_version: The OS Minor Version.
        :param str o_s_version: The OS Version.
        :param str os_edition: The OSEdition.
        :param str os_type: VM Disk details.
        :param str product_type: Product type.
        """
        if o_s_major_version is not None:
            pulumi.set(__self__, "o_s_major_version", o_s_major_version)
        if o_s_minor_version is not None:
            pulumi.set(__self__, "o_s_minor_version", o_s_minor_version)
        if o_s_version is not None:
            pulumi.set(__self__, "o_s_version", o_s_version)
        if os_edition is not None:
            pulumi.set(__self__, "os_edition", os_edition)
        if os_type is not None:
            pulumi.set(__self__, "os_type", os_type)
        if product_type is not None:
            pulumi.set(__self__, "product_type", product_type)

    @property
    @pulumi.getter(name="oSMajorVersion")
    def o_s_major_version(self) -> Optional[str]:
        """
        The OS Major Version.
        """
        return pulumi.get(self, "o_s_major_version")

    @property
    @pulumi.getter(name="oSMinorVersion")
    def o_s_minor_version(self) -> Optional[str]:
        """
        The OS Minor Version.
        """
        return pulumi.get(self, "o_s_minor_version")

    @property
    @pulumi.getter(name="oSVersion")
    def o_s_version(self) -> Optional[str]:
        """
        The OS Version.
        """
        return pulumi.get(self, "o_s_version")

    @property
    @pulumi.getter(name="osEdition")
    def os_edition(self) -> Optional[str]:
        """
        The OSEdition.
        """
        return pulumi.get(self, "os_edition")

    @property
    @pulumi.getter(name="osType")
    def os_type(self) -> Optional[str]:
        """
        VM Disk details.
        """
        return pulumi.get(self, "os_type")

    @property
    @pulumi.getter(name="productType")
    def product_type(self) -> Optional[str]:
        """
        Product type.
        """
        return pulumi.get(self, "product_type")


@pulumi.output_type
class OSDiskDetailsResponse(dict):
    """
    Details of the OS Disk.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "osType":
            suggest = "os_type"
        elif key == "osVhdId":
            suggest = "os_vhd_id"
        elif key == "vhdName":
            suggest = "vhd_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OSDiskDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OSDiskDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OSDiskDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 os_type: Optional[str] = None,
                 os_vhd_id: Optional[str] = None,
                 vhd_name: Optional[str] = None):
        """
        Details of the OS Disk.
        :param str os_type: The type of the OS on the VM.
        :param str os_vhd_id: The id of the disk containing the OS.
        :param str vhd_name: The OS disk VHD name.
        """
        if os_type is not None:
            pulumi.set(__self__, "os_type", os_type)
        if os_vhd_id is not None:
            pulumi.set(__self__, "os_vhd_id", os_vhd_id)
        if vhd_name is not None:
            pulumi.set(__self__, "vhd_name", vhd_name)

    @property
    @pulumi.getter(name="osType")
    def os_type(self) -> Optional[str]:
        """
        The type of the OS on the VM.
        """
        return pulumi.get(self, "os_type")

    @property
    @pulumi.getter(name="osVhdId")
    def os_vhd_id(self) -> Optional[str]:
        """
        The id of the disk containing the OS.
        """
        return pulumi.get(self, "os_vhd_id")

    @property
    @pulumi.getter(name="vhdName")
    def vhd_name(self) -> Optional[str]:
        """
        The OS disk VHD name.
        """
        return pulumi.get(self, "vhd_name")


@pulumi.output_type
class PolicyPropertiesResponse(dict):
    """
    Protection profile custom data details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "friendlyName":
            suggest = "friendly_name"
        elif key == "providerSpecificDetails":
            suggest = "provider_specific_details"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PolicyPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PolicyPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PolicyPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 friendly_name: Optional[str] = None,
                 provider_specific_details: Optional[Any] = None):
        """
        Protection profile custom data details.
        :param str friendly_name: The FriendlyName.
        :param Union['A2APolicyDetailsResponse', 'HyperVReplicaAzurePolicyDetailsResponse', 'HyperVReplicaBasePolicyDetailsResponse', 'HyperVReplicaBluePolicyDetailsResponse', 'HyperVReplicaPolicyDetailsResponse', 'InMageAzureV2PolicyDetailsResponse', 'InMageBasePolicyDetailsResponse', 'InMagePolicyDetailsResponse', 'InMageRcmFailbackPolicyDetailsResponse', 'InMageRcmPolicyDetailsResponse', 'VmwareCbtPolicyDetailsResponse'] provider_specific_details: The ReplicationChannelSetting.
        """
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if provider_specific_details is not None:
            pulumi.set(__self__, "provider_specific_details", provider_specific_details)

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[str]:
        """
        The FriendlyName.
        """
        return pulumi.get(self, "friendly_name")

    @property
    @pulumi.getter(name="providerSpecificDetails")
    def provider_specific_details(self) -> Optional[Any]:
        """
        The ReplicationChannelSetting.
        """
        return pulumi.get(self, "provider_specific_details")


@pulumi.output_type
class PrivateEndpointConnectionVaultPropertiesResponse(dict):
    """
    Information to be stored in Vault properties as an element of privateEndpointConnections List.
    """
    def __init__(__self__, *,
                 id: str,
                 location: str,
                 name: str,
                 properties: 'outputs.VaultPrivateEndpointConnectionResponse',
                 type: str):
        """
        Information to be stored in Vault properties as an element of privateEndpointConnections List.
        :param str id: Format of id subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.[Service]/{resource}/{resourceName}/privateEndpointConnections/{connectionName}.
        :param str location: The location of the private Endpoint connection
        :param str name: The name of the private Endpoint Connection
        :param 'VaultPrivateEndpointConnectionResponse' properties: Private Endpoint Connection Response Properties.
        :param str type: The type, which will be of the format, Microsoft.RecoveryServices/vaults/privateEndpointConnections
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "properties", properties)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Format of id subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.[Service]/{resource}/{resourceName}/privateEndpointConnections/{connectionName}.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        The location of the private Endpoint connection
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the private Endpoint Connection
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def properties(self) -> 'outputs.VaultPrivateEndpointConnectionResponse':
        """
        Private Endpoint Connection Response Properties.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type, which will be of the format, Microsoft.RecoveryServices/vaults/privateEndpointConnections
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class PrivateEndpointResponse(dict):
    """
    The Private Endpoint network resource that is linked to the Private Endpoint connection.
    """
    def __init__(__self__, *,
                 id: str):
        """
        The Private Endpoint network resource that is linked to the Private Endpoint connection.
        :param str id: Gets or sets id.
        """
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Gets or sets id.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class ProcessServerDetailsResponse(dict):
    """
    Process server details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "availableMemoryInBytes":
            suggest = "available_memory_in_bytes"
        elif key == "availableSpaceInBytes":
            suggest = "available_space_in_bytes"
        elif key == "biosId":
            suggest = "bios_id"
        elif key == "diskUsageStatus":
            suggest = "disk_usage_status"
        elif key == "fabricObjectId":
            suggest = "fabric_object_id"
        elif key == "freeSpacePercentage":
            suggest = "free_space_percentage"
        elif key == "healthErrors":
            suggest = "health_errors"
        elif key == "historicHealth":
            suggest = "historic_health"
        elif key == "ipAddresses":
            suggest = "ip_addresses"
        elif key == "lastHeartbeatUtc":
            suggest = "last_heartbeat_utc"
        elif key == "memoryUsagePercentage":
            suggest = "memory_usage_percentage"
        elif key == "memoryUsageStatus":
            suggest = "memory_usage_status"
        elif key == "processorUsagePercentage":
            suggest = "processor_usage_percentage"
        elif key == "processorUsageStatus":
            suggest = "processor_usage_status"
        elif key == "protectedItemCount":
            suggest = "protected_item_count"
        elif key == "systemLoad":
            suggest = "system_load"
        elif key == "systemLoadStatus":
            suggest = "system_load_status"
        elif key == "throughputInBytes":
            suggest = "throughput_in_bytes"
        elif key == "throughputStatus":
            suggest = "throughput_status"
        elif key == "throughputUploadPendingDataInBytes":
            suggest = "throughput_upload_pending_data_in_bytes"
        elif key == "totalMemoryInBytes":
            suggest = "total_memory_in_bytes"
        elif key == "totalSpaceInBytes":
            suggest = "total_space_in_bytes"
        elif key == "usedMemoryInBytes":
            suggest = "used_memory_in_bytes"
        elif key == "usedSpaceInBytes":
            suggest = "used_space_in_bytes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProcessServerDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProcessServerDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProcessServerDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 available_memory_in_bytes: float,
                 available_space_in_bytes: float,
                 bios_id: str,
                 disk_usage_status: str,
                 fabric_object_id: str,
                 fqdn: str,
                 free_space_percentage: float,
                 health: str,
                 health_errors: Sequence['outputs.HealthErrorResponse'],
                 historic_health: str,
                 id: str,
                 ip_addresses: Sequence[str],
                 last_heartbeat_utc: str,
                 memory_usage_percentage: float,
                 memory_usage_status: str,
                 name: str,
                 processor_usage_percentage: float,
                 processor_usage_status: str,
                 protected_item_count: int,
                 system_load: float,
                 system_load_status: str,
                 throughput_in_bytes: float,
                 throughput_status: str,
                 throughput_upload_pending_data_in_bytes: float,
                 total_memory_in_bytes: float,
                 total_space_in_bytes: float,
                 used_memory_in_bytes: float,
                 used_space_in_bytes: float,
                 version: str):
        """
        Process server details.
        :param float available_memory_in_bytes: The available memory.
        :param float available_space_in_bytes: The available disk space.
        :param str bios_id: The process server Bios Id.
        :param str disk_usage_status: The disk usage status.
        :param str fabric_object_id: The fabric object Id.
        :param str fqdn: The process server Fqdn.
        :param float free_space_percentage: The free disk space percentage.
        :param str health: The health of the process server.
        :param Sequence['HealthErrorResponse'] health_errors: The health errors.
        :param str historic_health: The historic health of the process server based on the health in last 24 hours.
        :param str id: The process server Id.
        :param Sequence[str] ip_addresses: The list of IP addresses for communicating with the RCM component.
        :param str last_heartbeat_utc: The last heartbeat received from the process server.
        :param float memory_usage_percentage: The memory usage percentage.
        :param str memory_usage_status: The memory usage status.
        :param str name: The process server name.
        :param float processor_usage_percentage: The processor usage percentage.
        :param str processor_usage_status: The processor usage status.
        :param int protected_item_count: The protected item count.
        :param float system_load: The system load.
        :param str system_load_status: The system load status.
        :param float throughput_in_bytes: The throughput in bytes.
        :param str throughput_status: The throughput status.
        :param float throughput_upload_pending_data_in_bytes: The uploading pending data in bytes.
        :param float total_memory_in_bytes: The total memory.
        :param float total_space_in_bytes: The total disk space.
        :param float used_memory_in_bytes: The used memory.
        :param float used_space_in_bytes: The used disk space.
        :param str version: The version.
        """
        pulumi.set(__self__, "available_memory_in_bytes", available_memory_in_bytes)
        pulumi.set(__self__, "available_space_in_bytes", available_space_in_bytes)
        pulumi.set(__self__, "bios_id", bios_id)
        pulumi.set(__self__, "disk_usage_status", disk_usage_status)
        pulumi.set(__self__, "fabric_object_id", fabric_object_id)
        pulumi.set(__self__, "fqdn", fqdn)
        pulumi.set(__self__, "free_space_percentage", free_space_percentage)
        pulumi.set(__self__, "health", health)
        pulumi.set(__self__, "health_errors", health_errors)
        pulumi.set(__self__, "historic_health", historic_health)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ip_addresses", ip_addresses)
        pulumi.set(__self__, "last_heartbeat_utc", last_heartbeat_utc)
        pulumi.set(__self__, "memory_usage_percentage", memory_usage_percentage)
        pulumi.set(__self__, "memory_usage_status", memory_usage_status)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "processor_usage_percentage", processor_usage_percentage)
        pulumi.set(__self__, "processor_usage_status", processor_usage_status)
        pulumi.set(__self__, "protected_item_count", protected_item_count)
        pulumi.set(__self__, "system_load", system_load)
        pulumi.set(__self__, "system_load_status", system_load_status)
        pulumi.set(__self__, "throughput_in_bytes", throughput_in_bytes)
        pulumi.set(__self__, "throughput_status", throughput_status)
        pulumi.set(__self__, "throughput_upload_pending_data_in_bytes", throughput_upload_pending_data_in_bytes)
        pulumi.set(__self__, "total_memory_in_bytes", total_memory_in_bytes)
        pulumi.set(__self__, "total_space_in_bytes", total_space_in_bytes)
        pulumi.set(__self__, "used_memory_in_bytes", used_memory_in_bytes)
        pulumi.set(__self__, "used_space_in_bytes", used_space_in_bytes)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="availableMemoryInBytes")
    def available_memory_in_bytes(self) -> float:
        """
        The available memory.
        """
        return pulumi.get(self, "available_memory_in_bytes")

    @property
    @pulumi.getter(name="availableSpaceInBytes")
    def available_space_in_bytes(self) -> float:
        """
        The available disk space.
        """
        return pulumi.get(self, "available_space_in_bytes")

    @property
    @pulumi.getter(name="biosId")
    def bios_id(self) -> str:
        """
        The process server Bios Id.
        """
        return pulumi.get(self, "bios_id")

    @property
    @pulumi.getter(name="diskUsageStatus")
    def disk_usage_status(self) -> str:
        """
        The disk usage status.
        """
        return pulumi.get(self, "disk_usage_status")

    @property
    @pulumi.getter(name="fabricObjectId")
    def fabric_object_id(self) -> str:
        """
        The fabric object Id.
        """
        return pulumi.get(self, "fabric_object_id")

    @property
    @pulumi.getter
    def fqdn(self) -> str:
        """
        The process server Fqdn.
        """
        return pulumi.get(self, "fqdn")

    @property
    @pulumi.getter(name="freeSpacePercentage")
    def free_space_percentage(self) -> float:
        """
        The free disk space percentage.
        """
        return pulumi.get(self, "free_space_percentage")

    @property
    @pulumi.getter
    def health(self) -> str:
        """
        The health of the process server.
        """
        return pulumi.get(self, "health")

    @property
    @pulumi.getter(name="healthErrors")
    def health_errors(self) -> Sequence['outputs.HealthErrorResponse']:
        """
        The health errors.
        """
        return pulumi.get(self, "health_errors")

    @property
    @pulumi.getter(name="historicHealth")
    def historic_health(self) -> str:
        """
        The historic health of the process server based on the health in last 24 hours.
        """
        return pulumi.get(self, "historic_health")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The process server Id.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> Sequence[str]:
        """
        The list of IP addresses for communicating with the RCM component.
        """
        return pulumi.get(self, "ip_addresses")

    @property
    @pulumi.getter(name="lastHeartbeatUtc")
    def last_heartbeat_utc(self) -> str:
        """
        The last heartbeat received from the process server.
        """
        return pulumi.get(self, "last_heartbeat_utc")

    @property
    @pulumi.getter(name="memoryUsagePercentage")
    def memory_usage_percentage(self) -> float:
        """
        The memory usage percentage.
        """
        return pulumi.get(self, "memory_usage_percentage")

    @property
    @pulumi.getter(name="memoryUsageStatus")
    def memory_usage_status(self) -> str:
        """
        The memory usage status.
        """
        return pulumi.get(self, "memory_usage_status")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The process server name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="processorUsagePercentage")
    def processor_usage_percentage(self) -> float:
        """
        The processor usage percentage.
        """
        return pulumi.get(self, "processor_usage_percentage")

    @property
    @pulumi.getter(name="processorUsageStatus")
    def processor_usage_status(self) -> str:
        """
        The processor usage status.
        """
        return pulumi.get(self, "processor_usage_status")

    @property
    @pulumi.getter(name="protectedItemCount")
    def protected_item_count(self) -> int:
        """
        The protected item count.
        """
        return pulumi.get(self, "protected_item_count")

    @property
    @pulumi.getter(name="systemLoad")
    def system_load(self) -> float:
        """
        The system load.
        """
        return pulumi.get(self, "system_load")

    @property
    @pulumi.getter(name="systemLoadStatus")
    def system_load_status(self) -> str:
        """
        The system load status.
        """
        return pulumi.get(self, "system_load_status")

    @property
    @pulumi.getter(name="throughputInBytes")
    def throughput_in_bytes(self) -> float:
        """
        The throughput in bytes.
        """
        return pulumi.get(self, "throughput_in_bytes")

    @property
    @pulumi.getter(name="throughputStatus")
    def throughput_status(self) -> str:
        """
        The throughput status.
        """
        return pulumi.get(self, "throughput_status")

    @property
    @pulumi.getter(name="throughputUploadPendingDataInBytes")
    def throughput_upload_pending_data_in_bytes(self) -> float:
        """
        The uploading pending data in bytes.
        """
        return pulumi.get(self, "throughput_upload_pending_data_in_bytes")

    @property
    @pulumi.getter(name="totalMemoryInBytes")
    def total_memory_in_bytes(self) -> float:
        """
        The total memory.
        """
        return pulumi.get(self, "total_memory_in_bytes")

    @property
    @pulumi.getter(name="totalSpaceInBytes")
    def total_space_in_bytes(self) -> float:
        """
        The total disk space.
        """
        return pulumi.get(self, "total_space_in_bytes")

    @property
    @pulumi.getter(name="usedMemoryInBytes")
    def used_memory_in_bytes(self) -> float:
        """
        The used memory.
        """
        return pulumi.get(self, "used_memory_in_bytes")

    @property
    @pulumi.getter(name="usedSpaceInBytes")
    def used_space_in_bytes(self) -> float:
        """
        The used disk space.
        """
        return pulumi.get(self, "used_space_in_bytes")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        The version.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class ProcessServerResponse(dict):
    """
    Details of the Process Server.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "marsCommunicationStatus":
            suggest = "mars_communication_status"
        elif key == "marsRegistrationStatus":
            suggest = "mars_registration_status"
        elif key == "psStatsRefreshTime":
            suggest = "ps_stats_refresh_time"
        elif key == "throughputInBytes":
            suggest = "throughput_in_bytes"
        elif key == "throughputInMBps":
            suggest = "throughput_in_m_bps"
        elif key == "throughputStatus":
            suggest = "throughput_status"
        elif key == "throughputUploadPendingDataInBytes":
            suggest = "throughput_upload_pending_data_in_bytes"
        elif key == "agentExpiryDate":
            suggest = "agent_expiry_date"
        elif key == "agentVersion":
            suggest = "agent_version"
        elif key == "agentVersionDetails":
            suggest = "agent_version_details"
        elif key == "availableMemoryInBytes":
            suggest = "available_memory_in_bytes"
        elif key == "availableSpaceInBytes":
            suggest = "available_space_in_bytes"
        elif key == "cpuLoad":
            suggest = "cpu_load"
        elif key == "cpuLoadStatus":
            suggest = "cpu_load_status"
        elif key == "friendlyName":
            suggest = "friendly_name"
        elif key == "healthErrors":
            suggest = "health_errors"
        elif key == "hostId":
            suggest = "host_id"
        elif key == "ipAddress":
            suggest = "ip_address"
        elif key == "lastHeartbeat":
            suggest = "last_heartbeat"
        elif key == "machineCount":
            suggest = "machine_count"
        elif key == "memoryUsageStatus":
            suggest = "memory_usage_status"
        elif key == "mobilityServiceUpdates":
            suggest = "mobility_service_updates"
        elif key == "osType":
            suggest = "os_type"
        elif key == "osVersion":
            suggest = "os_version"
        elif key == "psServiceStatus":
            suggest = "ps_service_status"
        elif key == "replicationPairCount":
            suggest = "replication_pair_count"
        elif key == "spaceUsageStatus":
            suggest = "space_usage_status"
        elif key == "sslCertExpiryDate":
            suggest = "ssl_cert_expiry_date"
        elif key == "sslCertExpiryRemainingDays":
            suggest = "ssl_cert_expiry_remaining_days"
        elif key == "systemLoad":
            suggest = "system_load"
        elif key == "systemLoadStatus":
            suggest = "system_load_status"
        elif key == "totalMemoryInBytes":
            suggest = "total_memory_in_bytes"
        elif key == "totalSpaceInBytes":
            suggest = "total_space_in_bytes"
        elif key == "versionStatus":
            suggest = "version_status"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProcessServerResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProcessServerResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProcessServerResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 health: str,
                 mars_communication_status: str,
                 mars_registration_status: str,
                 ps_stats_refresh_time: str,
                 throughput_in_bytes: float,
                 throughput_in_m_bps: float,
                 throughput_status: str,
                 throughput_upload_pending_data_in_bytes: float,
                 agent_expiry_date: Optional[str] = None,
                 agent_version: Optional[str] = None,
                 agent_version_details: Optional['outputs.VersionDetailsResponse'] = None,
                 available_memory_in_bytes: Optional[float] = None,
                 available_space_in_bytes: Optional[float] = None,
                 cpu_load: Optional[str] = None,
                 cpu_load_status: Optional[str] = None,
                 friendly_name: Optional[str] = None,
                 health_errors: Optional[Sequence['outputs.HealthErrorResponse']] = None,
                 host_id: Optional[str] = None,
                 id: Optional[str] = None,
                 ip_address: Optional[str] = None,
                 last_heartbeat: Optional[str] = None,
                 machine_count: Optional[str] = None,
                 memory_usage_status: Optional[str] = None,
                 mobility_service_updates: Optional[Sequence['outputs.MobilityServiceUpdateResponse']] = None,
                 os_type: Optional[str] = None,
                 os_version: Optional[str] = None,
                 ps_service_status: Optional[str] = None,
                 replication_pair_count: Optional[str] = None,
                 space_usage_status: Optional[str] = None,
                 ssl_cert_expiry_date: Optional[str] = None,
                 ssl_cert_expiry_remaining_days: Optional[int] = None,
                 system_load: Optional[str] = None,
                 system_load_status: Optional[str] = None,
                 total_memory_in_bytes: Optional[float] = None,
                 total_space_in_bytes: Optional[float] = None,
                 version_status: Optional[str] = None):
        """
        Details of the Process Server.
        :param str health: The health of Process Server.
        :param str mars_communication_status: The MARS communication status.
        :param str mars_registration_status: The MARS registration status.
        :param str ps_stats_refresh_time: The process server stats refresh time.
        :param float throughput_in_bytes: The throughput in bytes.
        :param float throughput_in_m_bps: The throughput in MBps.
        :param str throughput_status: The throughput status.
        :param float throughput_upload_pending_data_in_bytes: The uploading pending data in bytes.
        :param str agent_expiry_date: Agent expiry date.
        :param str agent_version: The version of the scout component on the server.
        :param 'VersionDetailsResponse' agent_version_details: The agent version details.
        :param float available_memory_in_bytes: The available memory.
        :param float available_space_in_bytes: The available space.
        :param str cpu_load: The percentage of the CPU load.
        :param str cpu_load_status: The CPU load status.
        :param str friendly_name: The Process Server's friendly name.
        :param Sequence['HealthErrorResponse'] health_errors: Health errors.
        :param str host_id: The agent generated Id.
        :param str id: The Process Server Id.
        :param str ip_address: The IP address of the server.
        :param str last_heartbeat: The last heartbeat received from the server.
        :param str machine_count: The servers configured with this PS.
        :param str memory_usage_status: The memory usage status.
        :param Sequence['MobilityServiceUpdateResponse'] mobility_service_updates: The list of the mobility service updates available on the Process Server.
        :param str os_type: The OS type of the server.
        :param str os_version: OS Version of the process server. Note: This will get populated if user has CS version greater than 9.12.0.0.
        :param str ps_service_status: The PS service status.
        :param str replication_pair_count: The number of replication pairs configured in this PS.
        :param str space_usage_status: The space usage status.
        :param str ssl_cert_expiry_date: The PS SSL cert expiry date.
        :param int ssl_cert_expiry_remaining_days: CS SSL cert expiry date.
        :param str system_load: The percentage of the system load.
        :param str system_load_status: The system load status.
        :param float total_memory_in_bytes: The total memory.
        :param float total_space_in_bytes: The total space.
        :param str version_status: Version status.
        """
        pulumi.set(__self__, "health", health)
        pulumi.set(__self__, "mars_communication_status", mars_communication_status)
        pulumi.set(__self__, "mars_registration_status", mars_registration_status)
        pulumi.set(__self__, "ps_stats_refresh_time", ps_stats_refresh_time)
        pulumi.set(__self__, "throughput_in_bytes", throughput_in_bytes)
        pulumi.set(__self__, "throughput_in_m_bps", throughput_in_m_bps)
        pulumi.set(__self__, "throughput_status", throughput_status)
        pulumi.set(__self__, "throughput_upload_pending_data_in_bytes", throughput_upload_pending_data_in_bytes)
        if agent_expiry_date is not None:
            pulumi.set(__self__, "agent_expiry_date", agent_expiry_date)
        if agent_version is not None:
            pulumi.set(__self__, "agent_version", agent_version)
        if agent_version_details is not None:
            pulumi.set(__self__, "agent_version_details", agent_version_details)
        if available_memory_in_bytes is not None:
            pulumi.set(__self__, "available_memory_in_bytes", available_memory_in_bytes)
        if available_space_in_bytes is not None:
            pulumi.set(__self__, "available_space_in_bytes", available_space_in_bytes)
        if cpu_load is not None:
            pulumi.set(__self__, "cpu_load", cpu_load)
        if cpu_load_status is not None:
            pulumi.set(__self__, "cpu_load_status", cpu_load_status)
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if health_errors is not None:
            pulumi.set(__self__, "health_errors", health_errors)
        if host_id is not None:
            pulumi.set(__self__, "host_id", host_id)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if last_heartbeat is not None:
            pulumi.set(__self__, "last_heartbeat", last_heartbeat)
        if machine_count is not None:
            pulumi.set(__self__, "machine_count", machine_count)
        if memory_usage_status is not None:
            pulumi.set(__self__, "memory_usage_status", memory_usage_status)
        if mobility_service_updates is not None:
            pulumi.set(__self__, "mobility_service_updates", mobility_service_updates)
        if os_type is not None:
            pulumi.set(__self__, "os_type", os_type)
        if os_version is not None:
            pulumi.set(__self__, "os_version", os_version)
        if ps_service_status is not None:
            pulumi.set(__self__, "ps_service_status", ps_service_status)
        if replication_pair_count is not None:
            pulumi.set(__self__, "replication_pair_count", replication_pair_count)
        if space_usage_status is not None:
            pulumi.set(__self__, "space_usage_status", space_usage_status)
        if ssl_cert_expiry_date is not None:
            pulumi.set(__self__, "ssl_cert_expiry_date", ssl_cert_expiry_date)
        if ssl_cert_expiry_remaining_days is not None:
            pulumi.set(__self__, "ssl_cert_expiry_remaining_days", ssl_cert_expiry_remaining_days)
        if system_load is not None:
            pulumi.set(__self__, "system_load", system_load)
        if system_load_status is not None:
            pulumi.set(__self__, "system_load_status", system_load_status)
        if total_memory_in_bytes is not None:
            pulumi.set(__self__, "total_memory_in_bytes", total_memory_in_bytes)
        if total_space_in_bytes is not None:
            pulumi.set(__self__, "total_space_in_bytes", total_space_in_bytes)
        if version_status is not None:
            pulumi.set(__self__, "version_status", version_status)

    @property
    @pulumi.getter
    def health(self) -> str:
        """
        The health of Process Server.
        """
        return pulumi.get(self, "health")

    @property
    @pulumi.getter(name="marsCommunicationStatus")
    def mars_communication_status(self) -> str:
        """
        The MARS communication status.
        """
        return pulumi.get(self, "mars_communication_status")

    @property
    @pulumi.getter(name="marsRegistrationStatus")
    def mars_registration_status(self) -> str:
        """
        The MARS registration status.
        """
        return pulumi.get(self, "mars_registration_status")

    @property
    @pulumi.getter(name="psStatsRefreshTime")
    def ps_stats_refresh_time(self) -> str:
        """
        The process server stats refresh time.
        """
        return pulumi.get(self, "ps_stats_refresh_time")

    @property
    @pulumi.getter(name="throughputInBytes")
    def throughput_in_bytes(self) -> float:
        """
        The throughput in bytes.
        """
        return pulumi.get(self, "throughput_in_bytes")

    @property
    @pulumi.getter(name="throughputInMBps")
    def throughput_in_m_bps(self) -> float:
        """
        The throughput in MBps.
        """
        return pulumi.get(self, "throughput_in_m_bps")

    @property
    @pulumi.getter(name="throughputStatus")
    def throughput_status(self) -> str:
        """
        The throughput status.
        """
        return pulumi.get(self, "throughput_status")

    @property
    @pulumi.getter(name="throughputUploadPendingDataInBytes")
    def throughput_upload_pending_data_in_bytes(self) -> float:
        """
        The uploading pending data in bytes.
        """
        return pulumi.get(self, "throughput_upload_pending_data_in_bytes")

    @property
    @pulumi.getter(name="agentExpiryDate")
    def agent_expiry_date(self) -> Optional[str]:
        """
        Agent expiry date.
        """
        return pulumi.get(self, "agent_expiry_date")

    @property
    @pulumi.getter(name="agentVersion")
    def agent_version(self) -> Optional[str]:
        """
        The version of the scout component on the server.
        """
        return pulumi.get(self, "agent_version")

    @property
    @pulumi.getter(name="agentVersionDetails")
    def agent_version_details(self) -> Optional['outputs.VersionDetailsResponse']:
        """
        The agent version details.
        """
        return pulumi.get(self, "agent_version_details")

    @property
    @pulumi.getter(name="availableMemoryInBytes")
    def available_memory_in_bytes(self) -> Optional[float]:
        """
        The available memory.
        """
        return pulumi.get(self, "available_memory_in_bytes")

    @property
    @pulumi.getter(name="availableSpaceInBytes")
    def available_space_in_bytes(self) -> Optional[float]:
        """
        The available space.
        """
        return pulumi.get(self, "available_space_in_bytes")

    @property
    @pulumi.getter(name="cpuLoad")
    def cpu_load(self) -> Optional[str]:
        """
        The percentage of the CPU load.
        """
        return pulumi.get(self, "cpu_load")

    @property
    @pulumi.getter(name="cpuLoadStatus")
    def cpu_load_status(self) -> Optional[str]:
        """
        The CPU load status.
        """
        return pulumi.get(self, "cpu_load_status")

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[str]:
        """
        The Process Server's friendly name.
        """
        return pulumi.get(self, "friendly_name")

    @property
    @pulumi.getter(name="healthErrors")
    def health_errors(self) -> Optional[Sequence['outputs.HealthErrorResponse']]:
        """
        Health errors.
        """
        return pulumi.get(self, "health_errors")

    @property
    @pulumi.getter(name="hostId")
    def host_id(self) -> Optional[str]:
        """
        The agent generated Id.
        """
        return pulumi.get(self, "host_id")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The Process Server Id.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[str]:
        """
        The IP address of the server.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter(name="lastHeartbeat")
    def last_heartbeat(self) -> Optional[str]:
        """
        The last heartbeat received from the server.
        """
        return pulumi.get(self, "last_heartbeat")

    @property
    @pulumi.getter(name="machineCount")
    def machine_count(self) -> Optional[str]:
        """
        The servers configured with this PS.
        """
        return pulumi.get(self, "machine_count")

    @property
    @pulumi.getter(name="memoryUsageStatus")
    def memory_usage_status(self) -> Optional[str]:
        """
        The memory usage status.
        """
        return pulumi.get(self, "memory_usage_status")

    @property
    @pulumi.getter(name="mobilityServiceUpdates")
    def mobility_service_updates(self) -> Optional[Sequence['outputs.MobilityServiceUpdateResponse']]:
        """
        The list of the mobility service updates available on the Process Server.
        """
        return pulumi.get(self, "mobility_service_updates")

    @property
    @pulumi.getter(name="osType")
    def os_type(self) -> Optional[str]:
        """
        The OS type of the server.
        """
        return pulumi.get(self, "os_type")

    @property
    @pulumi.getter(name="osVersion")
    def os_version(self) -> Optional[str]:
        """
        OS Version of the process server. Note: This will get populated if user has CS version greater than 9.12.0.0.
        """
        return pulumi.get(self, "os_version")

    @property
    @pulumi.getter(name="psServiceStatus")
    def ps_service_status(self) -> Optional[str]:
        """
        The PS service status.
        """
        return pulumi.get(self, "ps_service_status")

    @property
    @pulumi.getter(name="replicationPairCount")
    def replication_pair_count(self) -> Optional[str]:
        """
        The number of replication pairs configured in this PS.
        """
        return pulumi.get(self, "replication_pair_count")

    @property
    @pulumi.getter(name="spaceUsageStatus")
    def space_usage_status(self) -> Optional[str]:
        """
        The space usage status.
        """
        return pulumi.get(self, "space_usage_status")

    @property
    @pulumi.getter(name="sslCertExpiryDate")
    def ssl_cert_expiry_date(self) -> Optional[str]:
        """
        The PS SSL cert expiry date.
        """
        return pulumi.get(self, "ssl_cert_expiry_date")

    @property
    @pulumi.getter(name="sslCertExpiryRemainingDays")
    def ssl_cert_expiry_remaining_days(self) -> Optional[int]:
        """
        CS SSL cert expiry date.
        """
        return pulumi.get(self, "ssl_cert_expiry_remaining_days")

    @property
    @pulumi.getter(name="systemLoad")
    def system_load(self) -> Optional[str]:
        """
        The percentage of the system load.
        """
        return pulumi.get(self, "system_load")

    @property
    @pulumi.getter(name="systemLoadStatus")
    def system_load_status(self) -> Optional[str]:
        """
        The system load status.
        """
        return pulumi.get(self, "system_load_status")

    @property
    @pulumi.getter(name="totalMemoryInBytes")
    def total_memory_in_bytes(self) -> Optional[float]:
        """
        The total memory.
        """
        return pulumi.get(self, "total_memory_in_bytes")

    @property
    @pulumi.getter(name="totalSpaceInBytes")
    def total_space_in_bytes(self) -> Optional[float]:
        """
        The total space.
        """
        return pulumi.get(self, "total_space_in_bytes")

    @property
    @pulumi.getter(name="versionStatus")
    def version_status(self) -> Optional[str]:
        """
        Version status.
        """
        return pulumi.get(self, "version_status")


@pulumi.output_type
class ProtectionContainerMappingPropertiesResponse(dict):
    """
    Protection container mapping properties.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "healthErrorDetails":
            suggest = "health_error_details"
        elif key == "policyFriendlyName":
            suggest = "policy_friendly_name"
        elif key == "policyId":
            suggest = "policy_id"
        elif key == "providerSpecificDetails":
            suggest = "provider_specific_details"
        elif key == "sourceFabricFriendlyName":
            suggest = "source_fabric_friendly_name"
        elif key == "sourceProtectionContainerFriendlyName":
            suggest = "source_protection_container_friendly_name"
        elif key == "targetFabricFriendlyName":
            suggest = "target_fabric_friendly_name"
        elif key == "targetProtectionContainerFriendlyName":
            suggest = "target_protection_container_friendly_name"
        elif key == "targetProtectionContainerId":
            suggest = "target_protection_container_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProtectionContainerMappingPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProtectionContainerMappingPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProtectionContainerMappingPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 health: Optional[str] = None,
                 health_error_details: Optional[Sequence['outputs.HealthErrorResponse']] = None,
                 policy_friendly_name: Optional[str] = None,
                 policy_id: Optional[str] = None,
                 provider_specific_details: Optional[Any] = None,
                 source_fabric_friendly_name: Optional[str] = None,
                 source_protection_container_friendly_name: Optional[str] = None,
                 state: Optional[str] = None,
                 target_fabric_friendly_name: Optional[str] = None,
                 target_protection_container_friendly_name: Optional[str] = None,
                 target_protection_container_id: Optional[str] = None):
        """
        Protection container mapping properties.
        :param str health: Health of pairing.
        :param Sequence['HealthErrorResponse'] health_error_details: Health error.
        :param str policy_friendly_name: Friendly name of replication policy.
        :param str policy_id: Policy ARM Id.
        :param Union['A2AProtectionContainerMappingDetailsResponse', 'InMageRcmProtectionContainerMappingDetailsResponse', 'VMwareCbtProtectionContainerMappingDetailsResponse'] provider_specific_details: Provider specific provider details.
        :param str source_fabric_friendly_name: Friendly name of source fabric.
        :param str source_protection_container_friendly_name: Friendly name of source protection container.
        :param str state: Association Status.
        :param str target_fabric_friendly_name: Friendly name of target fabric.
        :param str target_protection_container_friendly_name: Friendly name of paired container.
        :param str target_protection_container_id: Paired protection container ARM ID.
        """
        if health is not None:
            pulumi.set(__self__, "health", health)
        if health_error_details is not None:
            pulumi.set(__self__, "health_error_details", health_error_details)
        if policy_friendly_name is not None:
            pulumi.set(__self__, "policy_friendly_name", policy_friendly_name)
        if policy_id is not None:
            pulumi.set(__self__, "policy_id", policy_id)
        if provider_specific_details is not None:
            pulumi.set(__self__, "provider_specific_details", provider_specific_details)
        if source_fabric_friendly_name is not None:
            pulumi.set(__self__, "source_fabric_friendly_name", source_fabric_friendly_name)
        if source_protection_container_friendly_name is not None:
            pulumi.set(__self__, "source_protection_container_friendly_name", source_protection_container_friendly_name)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if target_fabric_friendly_name is not None:
            pulumi.set(__self__, "target_fabric_friendly_name", target_fabric_friendly_name)
        if target_protection_container_friendly_name is not None:
            pulumi.set(__self__, "target_protection_container_friendly_name", target_protection_container_friendly_name)
        if target_protection_container_id is not None:
            pulumi.set(__self__, "target_protection_container_id", target_protection_container_id)

    @property
    @pulumi.getter
    def health(self) -> Optional[str]:
        """
        Health of pairing.
        """
        return pulumi.get(self, "health")

    @property
    @pulumi.getter(name="healthErrorDetails")
    def health_error_details(self) -> Optional[Sequence['outputs.HealthErrorResponse']]:
        """
        Health error.
        """
        return pulumi.get(self, "health_error_details")

    @property
    @pulumi.getter(name="policyFriendlyName")
    def policy_friendly_name(self) -> Optional[str]:
        """
        Friendly name of replication policy.
        """
        return pulumi.get(self, "policy_friendly_name")

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> Optional[str]:
        """
        Policy ARM Id.
        """
        return pulumi.get(self, "policy_id")

    @property
    @pulumi.getter(name="providerSpecificDetails")
    def provider_specific_details(self) -> Optional[Any]:
        """
        Provider specific provider details.
        """
        return pulumi.get(self, "provider_specific_details")

    @property
    @pulumi.getter(name="sourceFabricFriendlyName")
    def source_fabric_friendly_name(self) -> Optional[str]:
        """
        Friendly name of source fabric.
        """
        return pulumi.get(self, "source_fabric_friendly_name")

    @property
    @pulumi.getter(name="sourceProtectionContainerFriendlyName")
    def source_protection_container_friendly_name(self) -> Optional[str]:
        """
        Friendly name of source protection container.
        """
        return pulumi.get(self, "source_protection_container_friendly_name")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        Association Status.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="targetFabricFriendlyName")
    def target_fabric_friendly_name(self) -> Optional[str]:
        """
        Friendly name of target fabric.
        """
        return pulumi.get(self, "target_fabric_friendly_name")

    @property
    @pulumi.getter(name="targetProtectionContainerFriendlyName")
    def target_protection_container_friendly_name(self) -> Optional[str]:
        """
        Friendly name of paired container.
        """
        return pulumi.get(self, "target_protection_container_friendly_name")

    @property
    @pulumi.getter(name="targetProtectionContainerId")
    def target_protection_container_id(self) -> Optional[str]:
        """
        Paired protection container ARM ID.
        """
        return pulumi.get(self, "target_protection_container_id")


@pulumi.output_type
class PushInstallerDetailsResponse(dict):
    """
    Push installer details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "biosId":
            suggest = "bios_id"
        elif key == "fabricObjectId":
            suggest = "fabric_object_id"
        elif key == "healthErrors":
            suggest = "health_errors"
        elif key == "lastHeartbeatUtc":
            suggest = "last_heartbeat_utc"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PushInstallerDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PushInstallerDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PushInstallerDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bios_id: str,
                 fabric_object_id: str,
                 fqdn: str,
                 health: str,
                 health_errors: Sequence['outputs.HealthErrorResponse'],
                 id: str,
                 last_heartbeat_utc: str,
                 name: str,
                 version: str):
        """
        Push installer details.
        :param str bios_id: The push installer Bios Id.
        :param str fabric_object_id: The fabric object Id.
        :param str fqdn: The push installer Fqdn.
        :param str health: The health of the push installer.
        :param Sequence['HealthErrorResponse'] health_errors: The health errors.
        :param str id: The push installer Id.
        :param str last_heartbeat_utc: The last heartbeat received from the push installer.
        :param str name: The push installer name.
        :param str version: The version.
        """
        pulumi.set(__self__, "bios_id", bios_id)
        pulumi.set(__self__, "fabric_object_id", fabric_object_id)
        pulumi.set(__self__, "fqdn", fqdn)
        pulumi.set(__self__, "health", health)
        pulumi.set(__self__, "health_errors", health_errors)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "last_heartbeat_utc", last_heartbeat_utc)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="biosId")
    def bios_id(self) -> str:
        """
        The push installer Bios Id.
        """
        return pulumi.get(self, "bios_id")

    @property
    @pulumi.getter(name="fabricObjectId")
    def fabric_object_id(self) -> str:
        """
        The fabric object Id.
        """
        return pulumi.get(self, "fabric_object_id")

    @property
    @pulumi.getter
    def fqdn(self) -> str:
        """
        The push installer Fqdn.
        """
        return pulumi.get(self, "fqdn")

    @property
    @pulumi.getter
    def health(self) -> str:
        """
        The health of the push installer.
        """
        return pulumi.get(self, "health")

    @property
    @pulumi.getter(name="healthErrors")
    def health_errors(self) -> Sequence['outputs.HealthErrorResponse']:
        """
        The health errors.
        """
        return pulumi.get(self, "health_errors")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The push installer Id.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lastHeartbeatUtc")
    def last_heartbeat_utc(self) -> str:
        """
        The last heartbeat received from the push installer.
        """
        return pulumi.get(self, "last_heartbeat_utc")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The push installer name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        The version.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class RcmProxyDetailsResponse(dict):
    """
    RCM proxy details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "biosId":
            suggest = "bios_id"
        elif key == "clientAuthenticationType":
            suggest = "client_authentication_type"
        elif key == "fabricObjectId":
            suggest = "fabric_object_id"
        elif key == "healthErrors":
            suggest = "health_errors"
        elif key == "lastHeartbeatUtc":
            suggest = "last_heartbeat_utc"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RcmProxyDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RcmProxyDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RcmProxyDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bios_id: str,
                 client_authentication_type: str,
                 fabric_object_id: str,
                 fqdn: str,
                 health: str,
                 health_errors: Sequence['outputs.HealthErrorResponse'],
                 id: str,
                 last_heartbeat_utc: str,
                 name: str,
                 version: str):
        """
        RCM proxy details.
        :param str bios_id: The RCM proxy Bios Id.
        :param str client_authentication_type: The client authentication type.
        :param str fabric_object_id: The fabric object Id.
        :param str fqdn: The RCM proxy Fqdn.
        :param str health: The health of the RCM proxy.
        :param Sequence['HealthErrorResponse'] health_errors: The health errors.
        :param str id: The RCM proxy Id.
        :param str last_heartbeat_utc: The last heartbeat received from the RCM proxy.
        :param str name: The RCM proxy name.
        :param str version: The version.
        """
        pulumi.set(__self__, "bios_id", bios_id)
        pulumi.set(__self__, "client_authentication_type", client_authentication_type)
        pulumi.set(__self__, "fabric_object_id", fabric_object_id)
        pulumi.set(__self__, "fqdn", fqdn)
        pulumi.set(__self__, "health", health)
        pulumi.set(__self__, "health_errors", health_errors)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "last_heartbeat_utc", last_heartbeat_utc)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="biosId")
    def bios_id(self) -> str:
        """
        The RCM proxy Bios Id.
        """
        return pulumi.get(self, "bios_id")

    @property
    @pulumi.getter(name="clientAuthenticationType")
    def client_authentication_type(self) -> str:
        """
        The client authentication type.
        """
        return pulumi.get(self, "client_authentication_type")

    @property
    @pulumi.getter(name="fabricObjectId")
    def fabric_object_id(self) -> str:
        """
        The fabric object Id.
        """
        return pulumi.get(self, "fabric_object_id")

    @property
    @pulumi.getter
    def fqdn(self) -> str:
        """
        The RCM proxy Fqdn.
        """
        return pulumi.get(self, "fqdn")

    @property
    @pulumi.getter
    def health(self) -> str:
        """
        The health of the RCM proxy.
        """
        return pulumi.get(self, "health")

    @property
    @pulumi.getter(name="healthErrors")
    def health_errors(self) -> Sequence['outputs.HealthErrorResponse']:
        """
        The health errors.
        """
        return pulumi.get(self, "health_errors")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The RCM proxy Id.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lastHeartbeatUtc")
    def last_heartbeat_utc(self) -> str:
        """
        The last heartbeat received from the RCM proxy.
        """
        return pulumi.get(self, "last_heartbeat_utc")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The RCM proxy name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        The version.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class RecoveryPlanA2ADetailsResponse(dict):
    """
    Recovery plan A2A specific details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceType":
            suggest = "instance_type"
        elif key == "primaryZone":
            suggest = "primary_zone"
        elif key == "recoveryZone":
            suggest = "recovery_zone"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RecoveryPlanA2ADetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RecoveryPlanA2ADetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RecoveryPlanA2ADetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_type: str,
                 primary_zone: Optional[str] = None,
                 recovery_zone: Optional[str] = None):
        """
        Recovery plan A2A specific details.
        :param str instance_type: Gets the Instance type.
               Expected value is 'A2A'.
        :param str primary_zone: The primary zone.
        :param str recovery_zone: The recovery zone.
        """
        pulumi.set(__self__, "instance_type", 'A2A')
        if primary_zone is not None:
            pulumi.set(__self__, "primary_zone", primary_zone)
        if recovery_zone is not None:
            pulumi.set(__self__, "recovery_zone", recovery_zone)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> str:
        """
        Gets the Instance type.
        Expected value is 'A2A'.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="primaryZone")
    def primary_zone(self) -> Optional[str]:
        """
        The primary zone.
        """
        return pulumi.get(self, "primary_zone")

    @property
    @pulumi.getter(name="recoveryZone")
    def recovery_zone(self) -> Optional[str]:
        """
        The recovery zone.
        """
        return pulumi.get(self, "recovery_zone")


@pulumi.output_type
class RecoveryPlanActionResponse(dict):
    """
    Recovery plan action details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "actionName":
            suggest = "action_name"
        elif key == "customDetails":
            suggest = "custom_details"
        elif key == "failoverDirections":
            suggest = "failover_directions"
        elif key == "failoverTypes":
            suggest = "failover_types"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RecoveryPlanActionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RecoveryPlanActionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RecoveryPlanActionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action_name: str,
                 custom_details: Any,
                 failover_directions: Sequence[str],
                 failover_types: Sequence[str]):
        """
        Recovery plan action details.
        :param str action_name: The action name.
        :param Union['RecoveryPlanAutomationRunbookActionDetailsResponse', 'RecoveryPlanManualActionDetailsResponse', 'RecoveryPlanScriptActionDetailsResponse'] custom_details: The custom details.
        :param Sequence[str] failover_directions: The list of failover directions.
        :param Sequence[str] failover_types: The list of failover types.
        """
        pulumi.set(__self__, "action_name", action_name)
        pulumi.set(__self__, "custom_details", custom_details)
        pulumi.set(__self__, "failover_directions", failover_directions)
        pulumi.set(__self__, "failover_types", failover_types)

    @property
    @pulumi.getter(name="actionName")
    def action_name(self) -> str:
        """
        The action name.
        """
        return pulumi.get(self, "action_name")

    @property
    @pulumi.getter(name="customDetails")
    def custom_details(self) -> Any:
        """
        The custom details.
        """
        return pulumi.get(self, "custom_details")

    @property
    @pulumi.getter(name="failoverDirections")
    def failover_directions(self) -> Sequence[str]:
        """
        The list of failover directions.
        """
        return pulumi.get(self, "failover_directions")

    @property
    @pulumi.getter(name="failoverTypes")
    def failover_types(self) -> Sequence[str]:
        """
        The list of failover types.
        """
        return pulumi.get(self, "failover_types")


@pulumi.output_type
class RecoveryPlanAutomationRunbookActionDetailsResponse(dict):
    """
    Recovery plan Automation runbook action details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fabricLocation":
            suggest = "fabric_location"
        elif key == "instanceType":
            suggest = "instance_type"
        elif key == "runbookId":
            suggest = "runbook_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RecoveryPlanAutomationRunbookActionDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RecoveryPlanAutomationRunbookActionDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RecoveryPlanAutomationRunbookActionDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fabric_location: str,
                 instance_type: str,
                 runbook_id: Optional[str] = None,
                 timeout: Optional[str] = None):
        """
        Recovery plan Automation runbook action details.
        :param str fabric_location: The fabric location.
        :param str instance_type: Gets the type of action details (see RecoveryPlanActionDetailsTypes enum for possible values).
               Expected value is 'AutomationRunbookActionDetails'.
        :param str runbook_id: The runbook ARM Id.
        :param str timeout: The runbook timeout.
        """
        pulumi.set(__self__, "fabric_location", fabric_location)
        pulumi.set(__self__, "instance_type", 'AutomationRunbookActionDetails')
        if runbook_id is not None:
            pulumi.set(__self__, "runbook_id", runbook_id)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @property
    @pulumi.getter(name="fabricLocation")
    def fabric_location(self) -> str:
        """
        The fabric location.
        """
        return pulumi.get(self, "fabric_location")

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> str:
        """
        Gets the type of action details (see RecoveryPlanActionDetailsTypes enum for possible values).
        Expected value is 'AutomationRunbookActionDetails'.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="runbookId")
    def runbook_id(self) -> Optional[str]:
        """
        The runbook ARM Id.
        """
        return pulumi.get(self, "runbook_id")

    @property
    @pulumi.getter
    def timeout(self) -> Optional[str]:
        """
        The runbook timeout.
        """
        return pulumi.get(self, "timeout")


@pulumi.output_type
class RecoveryPlanGroupResponse(dict):
    """
    Recovery plan group details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "groupType":
            suggest = "group_type"
        elif key == "endGroupActions":
            suggest = "end_group_actions"
        elif key == "replicationProtectedItems":
            suggest = "replication_protected_items"
        elif key == "startGroupActions":
            suggest = "start_group_actions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RecoveryPlanGroupResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RecoveryPlanGroupResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RecoveryPlanGroupResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 group_type: str,
                 end_group_actions: Optional[Sequence['outputs.RecoveryPlanActionResponse']] = None,
                 replication_protected_items: Optional[Sequence['outputs.RecoveryPlanProtectedItemResponse']] = None,
                 start_group_actions: Optional[Sequence['outputs.RecoveryPlanActionResponse']] = None):
        """
        Recovery plan group details.
        :param str group_type: The group type.
        :param Sequence['RecoveryPlanActionResponse'] end_group_actions: The end group actions.
        :param Sequence['RecoveryPlanProtectedItemResponse'] replication_protected_items: The list of protected items.
        :param Sequence['RecoveryPlanActionResponse'] start_group_actions: The start group actions.
        """
        pulumi.set(__self__, "group_type", group_type)
        if end_group_actions is not None:
            pulumi.set(__self__, "end_group_actions", end_group_actions)
        if replication_protected_items is not None:
            pulumi.set(__self__, "replication_protected_items", replication_protected_items)
        if start_group_actions is not None:
            pulumi.set(__self__, "start_group_actions", start_group_actions)

    @property
    @pulumi.getter(name="groupType")
    def group_type(self) -> str:
        """
        The group type.
        """
        return pulumi.get(self, "group_type")

    @property
    @pulumi.getter(name="endGroupActions")
    def end_group_actions(self) -> Optional[Sequence['outputs.RecoveryPlanActionResponse']]:
        """
        The end group actions.
        """
        return pulumi.get(self, "end_group_actions")

    @property
    @pulumi.getter(name="replicationProtectedItems")
    def replication_protected_items(self) -> Optional[Sequence['outputs.RecoveryPlanProtectedItemResponse']]:
        """
        The list of protected items.
        """
        return pulumi.get(self, "replication_protected_items")

    @property
    @pulumi.getter(name="startGroupActions")
    def start_group_actions(self) -> Optional[Sequence['outputs.RecoveryPlanActionResponse']]:
        """
        The start group actions.
        """
        return pulumi.get(self, "start_group_actions")


@pulumi.output_type
class RecoveryPlanManualActionDetailsResponse(dict):
    """
    Recovery plan manual action details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceType":
            suggest = "instance_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RecoveryPlanManualActionDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RecoveryPlanManualActionDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RecoveryPlanManualActionDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_type: str,
                 description: Optional[str] = None):
        """
        Recovery plan manual action details.
        :param str instance_type: Gets the type of action details (see RecoveryPlanActionDetailsTypes enum for possible values).
               Expected value is 'ManualActionDetails'.
        :param str description: The manual action description.
        """
        pulumi.set(__self__, "instance_type", 'ManualActionDetails')
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> str:
        """
        Gets the type of action details (see RecoveryPlanActionDetailsTypes enum for possible values).
        Expected value is 'ManualActionDetails'.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The manual action description.
        """
        return pulumi.get(self, "description")


@pulumi.output_type
class RecoveryPlanPropertiesResponse(dict):
    """
    Recovery plan properties.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedOperations":
            suggest = "allowed_operations"
        elif key == "currentScenario":
            suggest = "current_scenario"
        elif key == "currentScenarioStatus":
            suggest = "current_scenario_status"
        elif key == "currentScenarioStatusDescription":
            suggest = "current_scenario_status_description"
        elif key == "failoverDeploymentModel":
            suggest = "failover_deployment_model"
        elif key == "friendlyName":
            suggest = "friendly_name"
        elif key == "lastPlannedFailoverTime":
            suggest = "last_planned_failover_time"
        elif key == "lastTestFailoverTime":
            suggest = "last_test_failover_time"
        elif key == "lastUnplannedFailoverTime":
            suggest = "last_unplanned_failover_time"
        elif key == "primaryFabricFriendlyName":
            suggest = "primary_fabric_friendly_name"
        elif key == "primaryFabricId":
            suggest = "primary_fabric_id"
        elif key == "providerSpecificDetails":
            suggest = "provider_specific_details"
        elif key == "recoveryFabricFriendlyName":
            suggest = "recovery_fabric_friendly_name"
        elif key == "recoveryFabricId":
            suggest = "recovery_fabric_id"
        elif key == "replicationProviders":
            suggest = "replication_providers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RecoveryPlanPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RecoveryPlanPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RecoveryPlanPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_operations: Optional[Sequence[str]] = None,
                 current_scenario: Optional['outputs.CurrentScenarioDetailsResponse'] = None,
                 current_scenario_status: Optional[str] = None,
                 current_scenario_status_description: Optional[str] = None,
                 failover_deployment_model: Optional[str] = None,
                 friendly_name: Optional[str] = None,
                 groups: Optional[Sequence['outputs.RecoveryPlanGroupResponse']] = None,
                 last_planned_failover_time: Optional[str] = None,
                 last_test_failover_time: Optional[str] = None,
                 last_unplanned_failover_time: Optional[str] = None,
                 primary_fabric_friendly_name: Optional[str] = None,
                 primary_fabric_id: Optional[str] = None,
                 provider_specific_details: Optional[Sequence['outputs.RecoveryPlanA2ADetailsResponse']] = None,
                 recovery_fabric_friendly_name: Optional[str] = None,
                 recovery_fabric_id: Optional[str] = None,
                 replication_providers: Optional[Sequence[str]] = None):
        """
        Recovery plan properties.
        :param Sequence[str] allowed_operations: The list of allowed operations.
        :param 'CurrentScenarioDetailsResponse' current_scenario: The current scenario details.
        :param str current_scenario_status: The recovery plan status.
        :param str current_scenario_status_description: The recovery plan status description.
        :param str failover_deployment_model: The failover deployment model.
        :param str friendly_name: The friendly name.
        :param Sequence['RecoveryPlanGroupResponse'] groups: The recovery plan groups.
        :param str last_planned_failover_time: The start time of the last planned failover.
        :param str last_test_failover_time: The start time of the last test failover.
        :param str last_unplanned_failover_time: The start time of the last unplanned failover.
        :param str primary_fabric_friendly_name: The primary fabric friendly name.
        :param str primary_fabric_id: The primary fabric Id.
        :param Sequence['RecoveryPlanA2ADetailsResponse'] provider_specific_details: The provider id and provider specific details.
        :param str recovery_fabric_friendly_name: The recovery fabric friendly name.
        :param str recovery_fabric_id: The recovery fabric Id.
        :param Sequence[str] replication_providers: The list of replication providers.
        """
        if allowed_operations is not None:
            pulumi.set(__self__, "allowed_operations", allowed_operations)
        if current_scenario is not None:
            pulumi.set(__self__, "current_scenario", current_scenario)
        if current_scenario_status is not None:
            pulumi.set(__self__, "current_scenario_status", current_scenario_status)
        if current_scenario_status_description is not None:
            pulumi.set(__self__, "current_scenario_status_description", current_scenario_status_description)
        if failover_deployment_model is not None:
            pulumi.set(__self__, "failover_deployment_model", failover_deployment_model)
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if groups is not None:
            pulumi.set(__self__, "groups", groups)
        if last_planned_failover_time is not None:
            pulumi.set(__self__, "last_planned_failover_time", last_planned_failover_time)
        if last_test_failover_time is not None:
            pulumi.set(__self__, "last_test_failover_time", last_test_failover_time)
        if last_unplanned_failover_time is not None:
            pulumi.set(__self__, "last_unplanned_failover_time", last_unplanned_failover_time)
        if primary_fabric_friendly_name is not None:
            pulumi.set(__self__, "primary_fabric_friendly_name", primary_fabric_friendly_name)
        if primary_fabric_id is not None:
            pulumi.set(__self__, "primary_fabric_id", primary_fabric_id)
        if provider_specific_details is not None:
            pulumi.set(__self__, "provider_specific_details", provider_specific_details)
        if recovery_fabric_friendly_name is not None:
            pulumi.set(__self__, "recovery_fabric_friendly_name", recovery_fabric_friendly_name)
        if recovery_fabric_id is not None:
            pulumi.set(__self__, "recovery_fabric_id", recovery_fabric_id)
        if replication_providers is not None:
            pulumi.set(__self__, "replication_providers", replication_providers)

    @property
    @pulumi.getter(name="allowedOperations")
    def allowed_operations(self) -> Optional[Sequence[str]]:
        """
        The list of allowed operations.
        """
        return pulumi.get(self, "allowed_operations")

    @property
    @pulumi.getter(name="currentScenario")
    def current_scenario(self) -> Optional['outputs.CurrentScenarioDetailsResponse']:
        """
        The current scenario details.
        """
        return pulumi.get(self, "current_scenario")

    @property
    @pulumi.getter(name="currentScenarioStatus")
    def current_scenario_status(self) -> Optional[str]:
        """
        The recovery plan status.
        """
        return pulumi.get(self, "current_scenario_status")

    @property
    @pulumi.getter(name="currentScenarioStatusDescription")
    def current_scenario_status_description(self) -> Optional[str]:
        """
        The recovery plan status description.
        """
        return pulumi.get(self, "current_scenario_status_description")

    @property
    @pulumi.getter(name="failoverDeploymentModel")
    def failover_deployment_model(self) -> Optional[str]:
        """
        The failover deployment model.
        """
        return pulumi.get(self, "failover_deployment_model")

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[str]:
        """
        The friendly name.
        """
        return pulumi.get(self, "friendly_name")

    @property
    @pulumi.getter
    def groups(self) -> Optional[Sequence['outputs.RecoveryPlanGroupResponse']]:
        """
        The recovery plan groups.
        """
        return pulumi.get(self, "groups")

    @property
    @pulumi.getter(name="lastPlannedFailoverTime")
    def last_planned_failover_time(self) -> Optional[str]:
        """
        The start time of the last planned failover.
        """
        return pulumi.get(self, "last_planned_failover_time")

    @property
    @pulumi.getter(name="lastTestFailoverTime")
    def last_test_failover_time(self) -> Optional[str]:
        """
        The start time of the last test failover.
        """
        return pulumi.get(self, "last_test_failover_time")

    @property
    @pulumi.getter(name="lastUnplannedFailoverTime")
    def last_unplanned_failover_time(self) -> Optional[str]:
        """
        The start time of the last unplanned failover.
        """
        return pulumi.get(self, "last_unplanned_failover_time")

    @property
    @pulumi.getter(name="primaryFabricFriendlyName")
    def primary_fabric_friendly_name(self) -> Optional[str]:
        """
        The primary fabric friendly name.
        """
        return pulumi.get(self, "primary_fabric_friendly_name")

    @property
    @pulumi.getter(name="primaryFabricId")
    def primary_fabric_id(self) -> Optional[str]:
        """
        The primary fabric Id.
        """
        return pulumi.get(self, "primary_fabric_id")

    @property
    @pulumi.getter(name="providerSpecificDetails")
    def provider_specific_details(self) -> Optional[Sequence['outputs.RecoveryPlanA2ADetailsResponse']]:
        """
        The provider id and provider specific details.
        """
        return pulumi.get(self, "provider_specific_details")

    @property
    @pulumi.getter(name="recoveryFabricFriendlyName")
    def recovery_fabric_friendly_name(self) -> Optional[str]:
        """
        The recovery fabric friendly name.
        """
        return pulumi.get(self, "recovery_fabric_friendly_name")

    @property
    @pulumi.getter(name="recoveryFabricId")
    def recovery_fabric_id(self) -> Optional[str]:
        """
        The recovery fabric Id.
        """
        return pulumi.get(self, "recovery_fabric_id")

    @property
    @pulumi.getter(name="replicationProviders")
    def replication_providers(self) -> Optional[Sequence[str]]:
        """
        The list of replication providers.
        """
        return pulumi.get(self, "replication_providers")


@pulumi.output_type
class RecoveryPlanProtectedItemResponse(dict):
    """
    Recovery plan protected item.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "virtualMachineId":
            suggest = "virtual_machine_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RecoveryPlanProtectedItemResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RecoveryPlanProtectedItemResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RecoveryPlanProtectedItemResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: Optional[str] = None,
                 virtual_machine_id: Optional[str] = None):
        """
        Recovery plan protected item.
        :param str id: The ARM Id of the recovery plan protected item.
        :param str virtual_machine_id: The virtual machine Id.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if virtual_machine_id is not None:
            pulumi.set(__self__, "virtual_machine_id", virtual_machine_id)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The ARM Id of the recovery plan protected item.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="virtualMachineId")
    def virtual_machine_id(self) -> Optional[str]:
        """
        The virtual machine Id.
        """
        return pulumi.get(self, "virtual_machine_id")


@pulumi.output_type
class RecoveryPlanScriptActionDetailsResponse(dict):
    """
    Recovery plan script action details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fabricLocation":
            suggest = "fabric_location"
        elif key == "instanceType":
            suggest = "instance_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RecoveryPlanScriptActionDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RecoveryPlanScriptActionDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RecoveryPlanScriptActionDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fabric_location: str,
                 instance_type: str,
                 path: str,
                 timeout: Optional[str] = None):
        """
        Recovery plan script action details.
        :param str fabric_location: The fabric location.
        :param str instance_type: Gets the type of action details (see RecoveryPlanActionDetailsTypes enum for possible values).
               Expected value is 'ScriptActionDetails'.
        :param str path: The script path.
        :param str timeout: The script timeout.
        """
        pulumi.set(__self__, "fabric_location", fabric_location)
        pulumi.set(__self__, "instance_type", 'ScriptActionDetails')
        pulumi.set(__self__, "path", path)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @property
    @pulumi.getter(name="fabricLocation")
    def fabric_location(self) -> str:
        """
        The fabric location.
        """
        return pulumi.get(self, "fabric_location")

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> str:
        """
        Gets the type of action details (see RecoveryPlanActionDetailsTypes enum for possible values).
        Expected value is 'ScriptActionDetails'.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        The script path.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def timeout(self) -> Optional[str]:
        """
        The script timeout.
        """
        return pulumi.get(self, "timeout")


@pulumi.output_type
class RecoveryServicesProviderPropertiesResponse(dict):
    """
    Recovery services provider properties.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedScenarios":
            suggest = "allowed_scenarios"
        elif key == "authenticationIdentityDetails":
            suggest = "authentication_identity_details"
        elif key == "biosId":
            suggest = "bios_id"
        elif key == "connectionStatus":
            suggest = "connection_status"
        elif key == "dataPlaneAuthenticationIdentityDetails":
            suggest = "data_plane_authentication_identity_details"
        elif key == "draIdentifier":
            suggest = "dra_identifier"
        elif key == "fabricFriendlyName":
            suggest = "fabric_friendly_name"
        elif key == "fabricType":
            suggest = "fabric_type"
        elif key == "friendlyName":
            suggest = "friendly_name"
        elif key == "healthErrorDetails":
            suggest = "health_error_details"
        elif key == "lastHeartBeat":
            suggest = "last_heart_beat"
        elif key == "machineId":
            suggest = "machine_id"
        elif key == "machineName":
            suggest = "machine_name"
        elif key == "protectedItemCount":
            suggest = "protected_item_count"
        elif key == "providerVersion":
            suggest = "provider_version"
        elif key == "providerVersionDetails":
            suggest = "provider_version_details"
        elif key == "providerVersionExpiryDate":
            suggest = "provider_version_expiry_date"
        elif key == "providerVersionState":
            suggest = "provider_version_state"
        elif key == "resourceAccessIdentityDetails":
            suggest = "resource_access_identity_details"
        elif key == "serverVersion":
            suggest = "server_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RecoveryServicesProviderPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RecoveryServicesProviderPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RecoveryServicesProviderPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_scenarios: Optional[Sequence[str]] = None,
                 authentication_identity_details: Optional['outputs.IdentityProviderDetailsResponse'] = None,
                 bios_id: Optional[str] = None,
                 connection_status: Optional[str] = None,
                 data_plane_authentication_identity_details: Optional['outputs.IdentityProviderDetailsResponse'] = None,
                 dra_identifier: Optional[str] = None,
                 fabric_friendly_name: Optional[str] = None,
                 fabric_type: Optional[str] = None,
                 friendly_name: Optional[str] = None,
                 health_error_details: Optional[Sequence['outputs.HealthErrorResponse']] = None,
                 last_heart_beat: Optional[str] = None,
                 machine_id: Optional[str] = None,
                 machine_name: Optional[str] = None,
                 protected_item_count: Optional[int] = None,
                 provider_version: Optional[str] = None,
                 provider_version_details: Optional['outputs.VersionDetailsResponse'] = None,
                 provider_version_expiry_date: Optional[str] = None,
                 provider_version_state: Optional[str] = None,
                 resource_access_identity_details: Optional['outputs.IdentityProviderDetailsResponse'] = None,
                 server_version: Optional[str] = None):
        """
        Recovery services provider properties.
        :param Sequence[str] allowed_scenarios: The scenarios allowed on this provider.
        :param 'IdentityProviderDetailsResponse' authentication_identity_details: The authentication identity details.
        :param str bios_id: The Bios Id.
        :param str connection_status: A value indicating whether DRA is responsive.
        :param 'IdentityProviderDetailsResponse' data_plane_authentication_identity_details: The data plane authentication identity details.
        :param str dra_identifier: The DRA Id.
        :param str fabric_friendly_name: The fabric friendly name.
        :param str fabric_type: Type of the site.
        :param str friendly_name: Friendly name of the DRA.
        :param Sequence['HealthErrorResponse'] health_error_details: The recovery services provider health error details.
        :param str last_heart_beat: Time when last heartbeat was sent by the DRA.
        :param str machine_id: The machine Id.
        :param str machine_name: The machine name.
        :param int protected_item_count: Number of protected VMs currently managed by the DRA.
        :param str provider_version: The provider version.
        :param 'VersionDetailsResponse' provider_version_details: The provider version details.
        :param str provider_version_expiry_date: Expiry date of the version.
        :param str provider_version_state: DRA version status.
        :param 'IdentityProviderDetailsResponse' resource_access_identity_details: The resource access identity details.
        :param str server_version: The fabric provider.
        """
        if allowed_scenarios is not None:
            pulumi.set(__self__, "allowed_scenarios", allowed_scenarios)
        if authentication_identity_details is not None:
            pulumi.set(__self__, "authentication_identity_details", authentication_identity_details)
        if bios_id is not None:
            pulumi.set(__self__, "bios_id", bios_id)
        if connection_status is not None:
            pulumi.set(__self__, "connection_status", connection_status)
        if data_plane_authentication_identity_details is not None:
            pulumi.set(__self__, "data_plane_authentication_identity_details", data_plane_authentication_identity_details)
        if dra_identifier is not None:
            pulumi.set(__self__, "dra_identifier", dra_identifier)
        if fabric_friendly_name is not None:
            pulumi.set(__self__, "fabric_friendly_name", fabric_friendly_name)
        if fabric_type is not None:
            pulumi.set(__self__, "fabric_type", fabric_type)
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if health_error_details is not None:
            pulumi.set(__self__, "health_error_details", health_error_details)
        if last_heart_beat is not None:
            pulumi.set(__self__, "last_heart_beat", last_heart_beat)
        if machine_id is not None:
            pulumi.set(__self__, "machine_id", machine_id)
        if machine_name is not None:
            pulumi.set(__self__, "machine_name", machine_name)
        if protected_item_count is not None:
            pulumi.set(__self__, "protected_item_count", protected_item_count)
        if provider_version is not None:
            pulumi.set(__self__, "provider_version", provider_version)
        if provider_version_details is not None:
            pulumi.set(__self__, "provider_version_details", provider_version_details)
        if provider_version_expiry_date is not None:
            pulumi.set(__self__, "provider_version_expiry_date", provider_version_expiry_date)
        if provider_version_state is not None:
            pulumi.set(__self__, "provider_version_state", provider_version_state)
        if resource_access_identity_details is not None:
            pulumi.set(__self__, "resource_access_identity_details", resource_access_identity_details)
        if server_version is not None:
            pulumi.set(__self__, "server_version", server_version)

    @property
    @pulumi.getter(name="allowedScenarios")
    def allowed_scenarios(self) -> Optional[Sequence[str]]:
        """
        The scenarios allowed on this provider.
        """
        return pulumi.get(self, "allowed_scenarios")

    @property
    @pulumi.getter(name="authenticationIdentityDetails")
    def authentication_identity_details(self) -> Optional['outputs.IdentityProviderDetailsResponse']:
        """
        The authentication identity details.
        """
        return pulumi.get(self, "authentication_identity_details")

    @property
    @pulumi.getter(name="biosId")
    def bios_id(self) -> Optional[str]:
        """
        The Bios Id.
        """
        return pulumi.get(self, "bios_id")

    @property
    @pulumi.getter(name="connectionStatus")
    def connection_status(self) -> Optional[str]:
        """
        A value indicating whether DRA is responsive.
        """
        return pulumi.get(self, "connection_status")

    @property
    @pulumi.getter(name="dataPlaneAuthenticationIdentityDetails")
    def data_plane_authentication_identity_details(self) -> Optional['outputs.IdentityProviderDetailsResponse']:
        """
        The data plane authentication identity details.
        """
        return pulumi.get(self, "data_plane_authentication_identity_details")

    @property
    @pulumi.getter(name="draIdentifier")
    def dra_identifier(self) -> Optional[str]:
        """
        The DRA Id.
        """
        return pulumi.get(self, "dra_identifier")

    @property
    @pulumi.getter(name="fabricFriendlyName")
    def fabric_friendly_name(self) -> Optional[str]:
        """
        The fabric friendly name.
        """
        return pulumi.get(self, "fabric_friendly_name")

    @property
    @pulumi.getter(name="fabricType")
    def fabric_type(self) -> Optional[str]:
        """
        Type of the site.
        """
        return pulumi.get(self, "fabric_type")

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[str]:
        """
        Friendly name of the DRA.
        """
        return pulumi.get(self, "friendly_name")

    @property
    @pulumi.getter(name="healthErrorDetails")
    def health_error_details(self) -> Optional[Sequence['outputs.HealthErrorResponse']]:
        """
        The recovery services provider health error details.
        """
        return pulumi.get(self, "health_error_details")

    @property
    @pulumi.getter(name="lastHeartBeat")
    def last_heart_beat(self) -> Optional[str]:
        """
        Time when last heartbeat was sent by the DRA.
        """
        return pulumi.get(self, "last_heart_beat")

    @property
    @pulumi.getter(name="machineId")
    def machine_id(self) -> Optional[str]:
        """
        The machine Id.
        """
        return pulumi.get(self, "machine_id")

    @property
    @pulumi.getter(name="machineName")
    def machine_name(self) -> Optional[str]:
        """
        The machine name.
        """
        return pulumi.get(self, "machine_name")

    @property
    @pulumi.getter(name="protectedItemCount")
    def protected_item_count(self) -> Optional[int]:
        """
        Number of protected VMs currently managed by the DRA.
        """
        return pulumi.get(self, "protected_item_count")

    @property
    @pulumi.getter(name="providerVersion")
    def provider_version(self) -> Optional[str]:
        """
        The provider version.
        """
        return pulumi.get(self, "provider_version")

    @property
    @pulumi.getter(name="providerVersionDetails")
    def provider_version_details(self) -> Optional['outputs.VersionDetailsResponse']:
        """
        The provider version details.
        """
        return pulumi.get(self, "provider_version_details")

    @property
    @pulumi.getter(name="providerVersionExpiryDate")
    def provider_version_expiry_date(self) -> Optional[str]:
        """
        Expiry date of the version.
        """
        return pulumi.get(self, "provider_version_expiry_date")

    @property
    @pulumi.getter(name="providerVersionState")
    def provider_version_state(self) -> Optional[str]:
        """
        DRA version status.
        """
        return pulumi.get(self, "provider_version_state")

    @property
    @pulumi.getter(name="resourceAccessIdentityDetails")
    def resource_access_identity_details(self) -> Optional['outputs.IdentityProviderDetailsResponse']:
        """
        The resource access identity details.
        """
        return pulumi.get(self, "resource_access_identity_details")

    @property
    @pulumi.getter(name="serverVersion")
    def server_version(self) -> Optional[str]:
        """
        The fabric provider.
        """
        return pulumi.get(self, "server_version")


@pulumi.output_type
class ReplicationAgentDetailsResponse(dict):
    """
    Replication agent details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "biosId":
            suggest = "bios_id"
        elif key == "fabricObjectId":
            suggest = "fabric_object_id"
        elif key == "healthErrors":
            suggest = "health_errors"
        elif key == "lastHeartbeatUtc":
            suggest = "last_heartbeat_utc"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ReplicationAgentDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ReplicationAgentDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ReplicationAgentDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bios_id: str,
                 fabric_object_id: str,
                 fqdn: str,
                 health: str,
                 health_errors: Sequence['outputs.HealthErrorResponse'],
                 id: str,
                 last_heartbeat_utc: str,
                 name: str,
                 version: str):
        """
        Replication agent details.
        :param str bios_id: The replication agent Bios Id.
        :param str fabric_object_id: The fabric object Id.
        :param str fqdn: The replication agent Fqdn.
        :param str health: The health of the replication agent.
        :param Sequence['HealthErrorResponse'] health_errors: The health errors.
        :param str id: The replication agent Id.
        :param str last_heartbeat_utc: The last heartbeat received from the replication agent.
        :param str name: The replication agent name.
        :param str version: The version.
        """
        pulumi.set(__self__, "bios_id", bios_id)
        pulumi.set(__self__, "fabric_object_id", fabric_object_id)
        pulumi.set(__self__, "fqdn", fqdn)
        pulumi.set(__self__, "health", health)
        pulumi.set(__self__, "health_errors", health_errors)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "last_heartbeat_utc", last_heartbeat_utc)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="biosId")
    def bios_id(self) -> str:
        """
        The replication agent Bios Id.
        """
        return pulumi.get(self, "bios_id")

    @property
    @pulumi.getter(name="fabricObjectId")
    def fabric_object_id(self) -> str:
        """
        The fabric object Id.
        """
        return pulumi.get(self, "fabric_object_id")

    @property
    @pulumi.getter
    def fqdn(self) -> str:
        """
        The replication agent Fqdn.
        """
        return pulumi.get(self, "fqdn")

    @property
    @pulumi.getter
    def health(self) -> str:
        """
        The health of the replication agent.
        """
        return pulumi.get(self, "health")

    @property
    @pulumi.getter(name="healthErrors")
    def health_errors(self) -> Sequence['outputs.HealthErrorResponse']:
        """
        The health errors.
        """
        return pulumi.get(self, "health_errors")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The replication agent Id.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lastHeartbeatUtc")
    def last_heartbeat_utc(self) -> str:
        """
        The last heartbeat received from the replication agent.
        """
        return pulumi.get(self, "last_heartbeat_utc")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The replication agent name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        The version.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class ReplicationProtectedItemPropertiesResponse(dict):
    """
    Replication protected item custom data details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "activeLocation":
            suggest = "active_location"
        elif key == "allowedOperations":
            suggest = "allowed_operations"
        elif key == "currentScenario":
            suggest = "current_scenario"
        elif key == "eventCorrelationId":
            suggest = "event_correlation_id"
        elif key == "failoverHealth":
            suggest = "failover_health"
        elif key == "failoverRecoveryPointId":
            suggest = "failover_recovery_point_id"
        elif key == "friendlyName":
            suggest = "friendly_name"
        elif key == "healthErrors":
            suggest = "health_errors"
        elif key == "lastSuccessfulFailoverTime":
            suggest = "last_successful_failover_time"
        elif key == "lastSuccessfulTestFailoverTime":
            suggest = "last_successful_test_failover_time"
        elif key == "policyFriendlyName":
            suggest = "policy_friendly_name"
        elif key == "policyId":
            suggest = "policy_id"
        elif key == "primaryFabricFriendlyName":
            suggest = "primary_fabric_friendly_name"
        elif key == "primaryFabricProvider":
            suggest = "primary_fabric_provider"
        elif key == "primaryProtectionContainerFriendlyName":
            suggest = "primary_protection_container_friendly_name"
        elif key == "protectableItemId":
            suggest = "protectable_item_id"
        elif key == "protectedItemType":
            suggest = "protected_item_type"
        elif key == "protectionState":
            suggest = "protection_state"
        elif key == "protectionStateDescription":
            suggest = "protection_state_description"
        elif key == "providerSpecificDetails":
            suggest = "provider_specific_details"
        elif key == "recoveryContainerId":
            suggest = "recovery_container_id"
        elif key == "recoveryFabricFriendlyName":
            suggest = "recovery_fabric_friendly_name"
        elif key == "recoveryFabricId":
            suggest = "recovery_fabric_id"
        elif key == "recoveryProtectionContainerFriendlyName":
            suggest = "recovery_protection_container_friendly_name"
        elif key == "recoveryServicesProviderId":
            suggest = "recovery_services_provider_id"
        elif key == "replicationHealth":
            suggest = "replication_health"
        elif key == "switchProviderState":
            suggest = "switch_provider_state"
        elif key == "switchProviderStateDescription":
            suggest = "switch_provider_state_description"
        elif key == "testFailoverState":
            suggest = "test_failover_state"
        elif key == "testFailoverStateDescription":
            suggest = "test_failover_state_description"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ReplicationProtectedItemPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ReplicationProtectedItemPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ReplicationProtectedItemPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 active_location: Optional[str] = None,
                 allowed_operations: Optional[Sequence[str]] = None,
                 current_scenario: Optional['outputs.CurrentScenarioDetailsResponse'] = None,
                 event_correlation_id: Optional[str] = None,
                 failover_health: Optional[str] = None,
                 failover_recovery_point_id: Optional[str] = None,
                 friendly_name: Optional[str] = None,
                 health_errors: Optional[Sequence['outputs.HealthErrorResponse']] = None,
                 last_successful_failover_time: Optional[str] = None,
                 last_successful_test_failover_time: Optional[str] = None,
                 policy_friendly_name: Optional[str] = None,
                 policy_id: Optional[str] = None,
                 primary_fabric_friendly_name: Optional[str] = None,
                 primary_fabric_provider: Optional[str] = None,
                 primary_protection_container_friendly_name: Optional[str] = None,
                 protectable_item_id: Optional[str] = None,
                 protected_item_type: Optional[str] = None,
                 protection_state: Optional[str] = None,
                 protection_state_description: Optional[str] = None,
                 provider_specific_details: Optional[Any] = None,
                 recovery_container_id: Optional[str] = None,
                 recovery_fabric_friendly_name: Optional[str] = None,
                 recovery_fabric_id: Optional[str] = None,
                 recovery_protection_container_friendly_name: Optional[str] = None,
                 recovery_services_provider_id: Optional[str] = None,
                 replication_health: Optional[str] = None,
                 switch_provider_state: Optional[str] = None,
                 switch_provider_state_description: Optional[str] = None,
                 test_failover_state: Optional[str] = None,
                 test_failover_state_description: Optional[str] = None):
        """
        Replication protected item custom data details.
        :param str active_location: The Current active location of the PE.
        :param Sequence[str] allowed_operations: The allowed operations on the Replication protected item.
        :param 'CurrentScenarioDetailsResponse' current_scenario: The current scenario.
        :param str event_correlation_id: The correlation Id for events associated with this protected item.
        :param str failover_health: The consolidated failover health for the VM.
        :param str failover_recovery_point_id: The recovery point ARM Id to which the Vm was failed over.
        :param str friendly_name: The name.
        :param Sequence['HealthErrorResponse'] health_errors: List of health errors.
        :param str last_successful_failover_time: The Last successful failover time.
        :param str last_successful_test_failover_time: The Last successful test failover time.
        :param str policy_friendly_name: The name of Policy governing this PE.
        :param str policy_id: The ID of Policy governing this PE.
        :param str primary_fabric_friendly_name: The friendly name of the primary fabric.
        :param str primary_fabric_provider: The fabric provider of the primary fabric.
        :param str primary_protection_container_friendly_name: The name of primary protection container friendly name.
        :param str protectable_item_id: The protected item ARM Id.
        :param str protected_item_type: The type of protected item type.
        :param str protection_state: The protection status.
        :param str protection_state_description: The protection state description.
        :param Union['A2ACrossClusterMigrationReplicationDetailsResponse', 'A2AReplicationDetailsResponse', 'HyperVReplicaAzureReplicationDetailsResponse', 'HyperVReplicaBaseReplicationDetailsResponse', 'HyperVReplicaBlueReplicationDetailsResponse', 'HyperVReplicaReplicationDetailsResponse', 'InMageAzureV2ReplicationDetailsResponse', 'InMageRcmFailbackReplicationDetailsResponse', 'InMageRcmReplicationDetailsResponse', 'InMageReplicationDetailsResponse'] provider_specific_details: The Replication provider custom settings.
        :param str recovery_container_id: The recovery container Id.
        :param str recovery_fabric_friendly_name: The friendly name of recovery fabric.
        :param str recovery_fabric_id: The Arm Id of recovery fabric.
        :param str recovery_protection_container_friendly_name: The name of recovery container friendly name.
        :param str recovery_services_provider_id: The recovery provider ARM Id.
        :param str replication_health: The consolidated protection health for the VM taking any issues with SRS as well as all the replication units associated with the VM's replication group into account. This is a string representation of the ProtectionHealth enumeration.
        :param str switch_provider_state: The switch provider state.
        :param str switch_provider_state_description: The switch provider state description.
        :param str test_failover_state: The Test failover state.
        :param str test_failover_state_description: The Test failover state description.
        """
        if active_location is not None:
            pulumi.set(__self__, "active_location", active_location)
        if allowed_operations is not None:
            pulumi.set(__self__, "allowed_operations", allowed_operations)
        if current_scenario is not None:
            pulumi.set(__self__, "current_scenario", current_scenario)
        if event_correlation_id is not None:
            pulumi.set(__self__, "event_correlation_id", event_correlation_id)
        if failover_health is not None:
            pulumi.set(__self__, "failover_health", failover_health)
        if failover_recovery_point_id is not None:
            pulumi.set(__self__, "failover_recovery_point_id", failover_recovery_point_id)
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if health_errors is not None:
            pulumi.set(__self__, "health_errors", health_errors)
        if last_successful_failover_time is not None:
            pulumi.set(__self__, "last_successful_failover_time", last_successful_failover_time)
        if last_successful_test_failover_time is not None:
            pulumi.set(__self__, "last_successful_test_failover_time", last_successful_test_failover_time)
        if policy_friendly_name is not None:
            pulumi.set(__self__, "policy_friendly_name", policy_friendly_name)
        if policy_id is not None:
            pulumi.set(__self__, "policy_id", policy_id)
        if primary_fabric_friendly_name is not None:
            pulumi.set(__self__, "primary_fabric_friendly_name", primary_fabric_friendly_name)
        if primary_fabric_provider is not None:
            pulumi.set(__self__, "primary_fabric_provider", primary_fabric_provider)
        if primary_protection_container_friendly_name is not None:
            pulumi.set(__self__, "primary_protection_container_friendly_name", primary_protection_container_friendly_name)
        if protectable_item_id is not None:
            pulumi.set(__self__, "protectable_item_id", protectable_item_id)
        if protected_item_type is not None:
            pulumi.set(__self__, "protected_item_type", protected_item_type)
        if protection_state is not None:
            pulumi.set(__self__, "protection_state", protection_state)
        if protection_state_description is not None:
            pulumi.set(__self__, "protection_state_description", protection_state_description)
        if provider_specific_details is not None:
            pulumi.set(__self__, "provider_specific_details", provider_specific_details)
        if recovery_container_id is not None:
            pulumi.set(__self__, "recovery_container_id", recovery_container_id)
        if recovery_fabric_friendly_name is not None:
            pulumi.set(__self__, "recovery_fabric_friendly_name", recovery_fabric_friendly_name)
        if recovery_fabric_id is not None:
            pulumi.set(__self__, "recovery_fabric_id", recovery_fabric_id)
        if recovery_protection_container_friendly_name is not None:
            pulumi.set(__self__, "recovery_protection_container_friendly_name", recovery_protection_container_friendly_name)
        if recovery_services_provider_id is not None:
            pulumi.set(__self__, "recovery_services_provider_id", recovery_services_provider_id)
        if replication_health is not None:
            pulumi.set(__self__, "replication_health", replication_health)
        if switch_provider_state is not None:
            pulumi.set(__self__, "switch_provider_state", switch_provider_state)
        if switch_provider_state_description is not None:
            pulumi.set(__self__, "switch_provider_state_description", switch_provider_state_description)
        if test_failover_state is not None:
            pulumi.set(__self__, "test_failover_state", test_failover_state)
        if test_failover_state_description is not None:
            pulumi.set(__self__, "test_failover_state_description", test_failover_state_description)

    @property
    @pulumi.getter(name="activeLocation")
    def active_location(self) -> Optional[str]:
        """
        The Current active location of the PE.
        """
        return pulumi.get(self, "active_location")

    @property
    @pulumi.getter(name="allowedOperations")
    def allowed_operations(self) -> Optional[Sequence[str]]:
        """
        The allowed operations on the Replication protected item.
        """
        return pulumi.get(self, "allowed_operations")

    @property
    @pulumi.getter(name="currentScenario")
    def current_scenario(self) -> Optional['outputs.CurrentScenarioDetailsResponse']:
        """
        The current scenario.
        """
        return pulumi.get(self, "current_scenario")

    @property
    @pulumi.getter(name="eventCorrelationId")
    def event_correlation_id(self) -> Optional[str]:
        """
        The correlation Id for events associated with this protected item.
        """
        return pulumi.get(self, "event_correlation_id")

    @property
    @pulumi.getter(name="failoverHealth")
    def failover_health(self) -> Optional[str]:
        """
        The consolidated failover health for the VM.
        """
        return pulumi.get(self, "failover_health")

    @property
    @pulumi.getter(name="failoverRecoveryPointId")
    def failover_recovery_point_id(self) -> Optional[str]:
        """
        The recovery point ARM Id to which the Vm was failed over.
        """
        return pulumi.get(self, "failover_recovery_point_id")

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[str]:
        """
        The name.
        """
        return pulumi.get(self, "friendly_name")

    @property
    @pulumi.getter(name="healthErrors")
    def health_errors(self) -> Optional[Sequence['outputs.HealthErrorResponse']]:
        """
        List of health errors.
        """
        return pulumi.get(self, "health_errors")

    @property
    @pulumi.getter(name="lastSuccessfulFailoverTime")
    def last_successful_failover_time(self) -> Optional[str]:
        """
        The Last successful failover time.
        """
        return pulumi.get(self, "last_successful_failover_time")

    @property
    @pulumi.getter(name="lastSuccessfulTestFailoverTime")
    def last_successful_test_failover_time(self) -> Optional[str]:
        """
        The Last successful test failover time.
        """
        return pulumi.get(self, "last_successful_test_failover_time")

    @property
    @pulumi.getter(name="policyFriendlyName")
    def policy_friendly_name(self) -> Optional[str]:
        """
        The name of Policy governing this PE.
        """
        return pulumi.get(self, "policy_friendly_name")

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> Optional[str]:
        """
        The ID of Policy governing this PE.
        """
        return pulumi.get(self, "policy_id")

    @property
    @pulumi.getter(name="primaryFabricFriendlyName")
    def primary_fabric_friendly_name(self) -> Optional[str]:
        """
        The friendly name of the primary fabric.
        """
        return pulumi.get(self, "primary_fabric_friendly_name")

    @property
    @pulumi.getter(name="primaryFabricProvider")
    def primary_fabric_provider(self) -> Optional[str]:
        """
        The fabric provider of the primary fabric.
        """
        return pulumi.get(self, "primary_fabric_provider")

    @property
    @pulumi.getter(name="primaryProtectionContainerFriendlyName")
    def primary_protection_container_friendly_name(self) -> Optional[str]:
        """
        The name of primary protection container friendly name.
        """
        return pulumi.get(self, "primary_protection_container_friendly_name")

    @property
    @pulumi.getter(name="protectableItemId")
    def protectable_item_id(self) -> Optional[str]:
        """
        The protected item ARM Id.
        """
        return pulumi.get(self, "protectable_item_id")

    @property
    @pulumi.getter(name="protectedItemType")
    def protected_item_type(self) -> Optional[str]:
        """
        The type of protected item type.
        """
        return pulumi.get(self, "protected_item_type")

    @property
    @pulumi.getter(name="protectionState")
    def protection_state(self) -> Optional[str]:
        """
        The protection status.
        """
        return pulumi.get(self, "protection_state")

    @property
    @pulumi.getter(name="protectionStateDescription")
    def protection_state_description(self) -> Optional[str]:
        """
        The protection state description.
        """
        return pulumi.get(self, "protection_state_description")

    @property
    @pulumi.getter(name="providerSpecificDetails")
    def provider_specific_details(self) -> Optional[Any]:
        """
        The Replication provider custom settings.
        """
        return pulumi.get(self, "provider_specific_details")

    @property
    @pulumi.getter(name="recoveryContainerId")
    def recovery_container_id(self) -> Optional[str]:
        """
        The recovery container Id.
        """
        return pulumi.get(self, "recovery_container_id")

    @property
    @pulumi.getter(name="recoveryFabricFriendlyName")
    def recovery_fabric_friendly_name(self) -> Optional[str]:
        """
        The friendly name of recovery fabric.
        """
        return pulumi.get(self, "recovery_fabric_friendly_name")

    @property
    @pulumi.getter(name="recoveryFabricId")
    def recovery_fabric_id(self) -> Optional[str]:
        """
        The Arm Id of recovery fabric.
        """
        return pulumi.get(self, "recovery_fabric_id")

    @property
    @pulumi.getter(name="recoveryProtectionContainerFriendlyName")
    def recovery_protection_container_friendly_name(self) -> Optional[str]:
        """
        The name of recovery container friendly name.
        """
        return pulumi.get(self, "recovery_protection_container_friendly_name")

    @property
    @pulumi.getter(name="recoveryServicesProviderId")
    def recovery_services_provider_id(self) -> Optional[str]:
        """
        The recovery provider ARM Id.
        """
        return pulumi.get(self, "recovery_services_provider_id")

    @property
    @pulumi.getter(name="replicationHealth")
    def replication_health(self) -> Optional[str]:
        """
        The consolidated protection health for the VM taking any issues with SRS as well as all the replication units associated with the VM's replication group into account. This is a string representation of the ProtectionHealth enumeration.
        """
        return pulumi.get(self, "replication_health")

    @property
    @pulumi.getter(name="switchProviderState")
    def switch_provider_state(self) -> Optional[str]:
        """
        The switch provider state.
        """
        return pulumi.get(self, "switch_provider_state")

    @property
    @pulumi.getter(name="switchProviderStateDescription")
    def switch_provider_state_description(self) -> Optional[str]:
        """
        The switch provider state description.
        """
        return pulumi.get(self, "switch_provider_state_description")

    @property
    @pulumi.getter(name="testFailoverState")
    def test_failover_state(self) -> Optional[str]:
        """
        The Test failover state.
        """
        return pulumi.get(self, "test_failover_state")

    @property
    @pulumi.getter(name="testFailoverStateDescription")
    def test_failover_state_description(self) -> Optional[str]:
        """
        The Test failover state description.
        """
        return pulumi.get(self, "test_failover_state_description")


@pulumi.output_type
class ReprotectAgentDetailsResponse(dict):
    """
    Reprotect agent details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessibleDatastores":
            suggest = "accessible_datastores"
        elif key == "biosId":
            suggest = "bios_id"
        elif key == "fabricObjectId":
            suggest = "fabric_object_id"
        elif key == "healthErrors":
            suggest = "health_errors"
        elif key == "lastDiscoveryInUtc":
            suggest = "last_discovery_in_utc"
        elif key == "lastHeartbeatUtc":
            suggest = "last_heartbeat_utc"
        elif key == "protectedItemCount":
            suggest = "protected_item_count"
        elif key == "vcenterId":
            suggest = "vcenter_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ReprotectAgentDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ReprotectAgentDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ReprotectAgentDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 accessible_datastores: Sequence[str],
                 bios_id: str,
                 fabric_object_id: str,
                 fqdn: str,
                 health: str,
                 health_errors: Sequence['outputs.HealthErrorResponse'],
                 id: str,
                 last_discovery_in_utc: str,
                 last_heartbeat_utc: str,
                 name: str,
                 protected_item_count: int,
                 vcenter_id: str,
                 version: str):
        """
        Reprotect agent details.
        :param Sequence[str] accessible_datastores: The list of accessible datastores fetched from discovery.
        :param str bios_id: The reprotect agent Bios Id.
        :param str fabric_object_id: The fabric object Id.
        :param str fqdn: The reprotect agent Fqdn.
        :param str health: The health of the reprotect agent.
        :param Sequence['HealthErrorResponse'] health_errors: The health errors.
        :param str id: The reprotect agent Id.
        :param str last_discovery_in_utc: The last time when SDS information discovered in SRS.
        :param str last_heartbeat_utc: The last heartbeat received from the reprotect agent.
        :param str name: The reprotect agent name.
        :param int protected_item_count: The protected item count.
        :param str vcenter_id: The Vcenter Id.
        :param str version: The version.
        """
        pulumi.set(__self__, "accessible_datastores", accessible_datastores)
        pulumi.set(__self__, "bios_id", bios_id)
        pulumi.set(__self__, "fabric_object_id", fabric_object_id)
        pulumi.set(__self__, "fqdn", fqdn)
        pulumi.set(__self__, "health", health)
        pulumi.set(__self__, "health_errors", health_errors)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "last_discovery_in_utc", last_discovery_in_utc)
        pulumi.set(__self__, "last_heartbeat_utc", last_heartbeat_utc)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "protected_item_count", protected_item_count)
        pulumi.set(__self__, "vcenter_id", vcenter_id)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="accessibleDatastores")
    def accessible_datastores(self) -> Sequence[str]:
        """
        The list of accessible datastores fetched from discovery.
        """
        return pulumi.get(self, "accessible_datastores")

    @property
    @pulumi.getter(name="biosId")
    def bios_id(self) -> str:
        """
        The reprotect agent Bios Id.
        """
        return pulumi.get(self, "bios_id")

    @property
    @pulumi.getter(name="fabricObjectId")
    def fabric_object_id(self) -> str:
        """
        The fabric object Id.
        """
        return pulumi.get(self, "fabric_object_id")

    @property
    @pulumi.getter
    def fqdn(self) -> str:
        """
        The reprotect agent Fqdn.
        """
        return pulumi.get(self, "fqdn")

    @property
    @pulumi.getter
    def health(self) -> str:
        """
        The health of the reprotect agent.
        """
        return pulumi.get(self, "health")

    @property
    @pulumi.getter(name="healthErrors")
    def health_errors(self) -> Sequence['outputs.HealthErrorResponse']:
        """
        The health errors.
        """
        return pulumi.get(self, "health_errors")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The reprotect agent Id.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lastDiscoveryInUtc")
    def last_discovery_in_utc(self) -> str:
        """
        The last time when SDS information discovered in SRS.
        """
        return pulumi.get(self, "last_discovery_in_utc")

    @property
    @pulumi.getter(name="lastHeartbeatUtc")
    def last_heartbeat_utc(self) -> str:
        """
        The last heartbeat received from the reprotect agent.
        """
        return pulumi.get(self, "last_heartbeat_utc")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The reprotect agent name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="protectedItemCount")
    def protected_item_count(self) -> int:
        """
        The protected item count.
        """
        return pulumi.get(self, "protected_item_count")

    @property
    @pulumi.getter(name="vcenterId")
    def vcenter_id(self) -> str:
        """
        The Vcenter Id.
        """
        return pulumi.get(self, "vcenter_id")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        The version.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class RetentionVolumeResponse(dict):
    """
    The retention details of the MT.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "capacityInBytes":
            suggest = "capacity_in_bytes"
        elif key == "freeSpaceInBytes":
            suggest = "free_space_in_bytes"
        elif key == "thresholdPercentage":
            suggest = "threshold_percentage"
        elif key == "volumeName":
            suggest = "volume_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RetentionVolumeResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RetentionVolumeResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RetentionVolumeResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 capacity_in_bytes: Optional[float] = None,
                 free_space_in_bytes: Optional[float] = None,
                 threshold_percentage: Optional[int] = None,
                 volume_name: Optional[str] = None):
        """
        The retention details of the MT.
        :param float capacity_in_bytes: The volume capacity.
        :param float free_space_in_bytes: The free space available in this volume.
        :param int threshold_percentage: The threshold percentage.
        :param str volume_name: The volume name.
        """
        if capacity_in_bytes is not None:
            pulumi.set(__self__, "capacity_in_bytes", capacity_in_bytes)
        if free_space_in_bytes is not None:
            pulumi.set(__self__, "free_space_in_bytes", free_space_in_bytes)
        if threshold_percentage is not None:
            pulumi.set(__self__, "threshold_percentage", threshold_percentage)
        if volume_name is not None:
            pulumi.set(__self__, "volume_name", volume_name)

    @property
    @pulumi.getter(name="capacityInBytes")
    def capacity_in_bytes(self) -> Optional[float]:
        """
        The volume capacity.
        """
        return pulumi.get(self, "capacity_in_bytes")

    @property
    @pulumi.getter(name="freeSpaceInBytes")
    def free_space_in_bytes(self) -> Optional[float]:
        """
        The free space available in this volume.
        """
        return pulumi.get(self, "free_space_in_bytes")

    @property
    @pulumi.getter(name="thresholdPercentage")
    def threshold_percentage(self) -> Optional[int]:
        """
        The threshold percentage.
        """
        return pulumi.get(self, "threshold_percentage")

    @property
    @pulumi.getter(name="volumeName")
    def volume_name(self) -> Optional[str]:
        """
        The volume name.
        """
        return pulumi.get(self, "volume_name")


@pulumi.output_type
class RunAsAccountResponse(dict):
    """
    CS Accounts Details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accountId":
            suggest = "account_id"
        elif key == "accountName":
            suggest = "account_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RunAsAccountResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RunAsAccountResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RunAsAccountResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 account_id: Optional[str] = None,
                 account_name: Optional[str] = None):
        """
        CS Accounts Details.
        :param str account_id: The CS RunAs account Id.
        :param str account_name: The CS RunAs account name.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if account_name is not None:
            pulumi.set(__self__, "account_name", account_name)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[str]:
        """
        The CS RunAs account Id.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> Optional[str]:
        """
        The CS RunAs account name.
        """
        return pulumi.get(self, "account_name")


@pulumi.output_type
class SkuResponse(dict):
    """
    Identifies the unique system identifier for each Azure resource.
    """
    def __init__(__self__, *,
                 name: str,
                 capacity: Optional[str] = None,
                 family: Optional[str] = None,
                 size: Optional[str] = None,
                 tier: Optional[str] = None):
        """
        Identifies the unique system identifier for each Azure resource.
        :param str name: Name of SKU is RS0 (Recovery Services 0th version) and the tier is standard tier. They do not have affect on backend storage redundancy or any other vault settings. To manage storage redundancy, use the backupstorageconfig
        :param str capacity: The sku capacity
        :param str family: The sku family
        :param str size: The sku size
        :param str tier: The Sku tier.
        """
        pulumi.set(__self__, "name", name)
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if family is not None:
            pulumi.set(__self__, "family", family)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if tier is not None:
            pulumi.set(__self__, "tier", tier)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of SKU is RS0 (Recovery Services 0th version) and the tier is standard tier. They do not have affect on backend storage redundancy or any other vault settings. To manage storage redundancy, use the backupstorageconfig
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def capacity(self) -> Optional[str]:
        """
        The sku capacity
        """
        return pulumi.get(self, "capacity")

    @property
    @pulumi.getter
    def family(self) -> Optional[str]:
        """
        The sku family
        """
        return pulumi.get(self, "family")

    @property
    @pulumi.getter
    def size(self) -> Optional[str]:
        """
        The sku size
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter
    def tier(self) -> Optional[str]:
        """
        The Sku tier.
        """
        return pulumi.get(self, "tier")


@pulumi.output_type
class StorageClassificationMappingPropertiesResponse(dict):
    """
    Storage mapping properties.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetStorageClassificationId":
            suggest = "target_storage_classification_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StorageClassificationMappingPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StorageClassificationMappingPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StorageClassificationMappingPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 target_storage_classification_id: Optional[str] = None):
        """
        Storage mapping properties.
        :param str target_storage_classification_id: Target storage object Id.
        """
        if target_storage_classification_id is not None:
            pulumi.set(__self__, "target_storage_classification_id", target_storage_classification_id)

    @property
    @pulumi.getter(name="targetStorageClassificationId")
    def target_storage_classification_id(self) -> Optional[str]:
        """
        Target storage object Id.
        """
        return pulumi.get(self, "target_storage_classification_id")


@pulumi.output_type
class SystemDataResponse(dict):
    """
    Metadata pertaining to creation and last modification of the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdAt":
            suggest = "created_at"
        elif key == "createdBy":
            suggest = "created_by"
        elif key == "createdByType":
            suggest = "created_by_type"
        elif key == "lastModifiedAt":
            suggest = "last_modified_at"
        elif key == "lastModifiedBy":
            suggest = "last_modified_by"
        elif key == "lastModifiedByType":
            suggest = "last_modified_by_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SystemDataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_at: Optional[str] = None,
                 created_by: Optional[str] = None,
                 created_by_type: Optional[str] = None,
                 last_modified_at: Optional[str] = None,
                 last_modified_by: Optional[str] = None,
                 last_modified_by_type: Optional[str] = None):
        """
        Metadata pertaining to creation and last modification of the resource.
        :param str created_at: The timestamp of resource creation (UTC).
        :param str created_by: The identity that created the resource.
        :param str created_by_type: The type of identity that created the resource.
        :param str last_modified_at: The type of identity that last modified the resource.
        :param str last_modified_by: The identity that last modified the resource.
        :param str last_modified_by_type: The type of identity that last modified the resource.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if created_by_type is not None:
            pulumi.set(__self__, "created_by_type", created_by_type)
        if last_modified_at is not None:
            pulumi.set(__self__, "last_modified_at", last_modified_at)
        if last_modified_by is not None:
            pulumi.set(__self__, "last_modified_by", last_modified_by)
        if last_modified_by_type is not None:
            pulumi.set(__self__, "last_modified_by_type", last_modified_by_type)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[str]:
        """
        The timestamp of resource creation (UTC).
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[str]:
        """
        The identity that created the resource.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="createdByType")
    def created_by_type(self) -> Optional[str]:
        """
        The type of identity that created the resource.
        """
        return pulumi.get(self, "created_by_type")

    @property
    @pulumi.getter(name="lastModifiedAt")
    def last_modified_at(self) -> Optional[str]:
        """
        The type of identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_at")

    @property
    @pulumi.getter(name="lastModifiedBy")
    def last_modified_by(self) -> Optional[str]:
        """
        The identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by")

    @property
    @pulumi.getter(name="lastModifiedByType")
    def last_modified_by_type(self) -> Optional[str]:
        """
        The type of identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by_type")


@pulumi.output_type
class UpgradeDetailsResponse(dict):
    """
    Details for upgrading vault.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endTimeUtc":
            suggest = "end_time_utc"
        elif key == "lastUpdatedTimeUtc":
            suggest = "last_updated_time_utc"
        elif key == "operationId":
            suggest = "operation_id"
        elif key == "previousResourceId":
            suggest = "previous_resource_id"
        elif key == "startTimeUtc":
            suggest = "start_time_utc"
        elif key == "triggerType":
            suggest = "trigger_type"
        elif key == "upgradedResourceId":
            suggest = "upgraded_resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UpgradeDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UpgradeDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UpgradeDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 end_time_utc: str,
                 last_updated_time_utc: str,
                 message: str,
                 operation_id: str,
                 previous_resource_id: str,
                 start_time_utc: str,
                 status: str,
                 trigger_type: str,
                 upgraded_resource_id: str):
        """
        Details for upgrading vault.
        :param str end_time_utc: UTC time at which the upgrade operation has ended.
        :param str last_updated_time_utc: UTC time at which the upgrade operation status was last updated.
        :param str message: Message to the user containing information about the upgrade operation.
        :param str operation_id: ID of the vault upgrade operation.
        :param str previous_resource_id: Resource ID of the vault before the upgrade.
        :param str start_time_utc: UTC time at which the upgrade operation has started.
        :param str status: Status of the vault upgrade operation.
        :param str trigger_type: The way the vault upgrade was triggered.
        :param str upgraded_resource_id: Resource ID of the upgraded vault.
        """
        pulumi.set(__self__, "end_time_utc", end_time_utc)
        pulumi.set(__self__, "last_updated_time_utc", last_updated_time_utc)
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "operation_id", operation_id)
        pulumi.set(__self__, "previous_resource_id", previous_resource_id)
        pulumi.set(__self__, "start_time_utc", start_time_utc)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "trigger_type", trigger_type)
        pulumi.set(__self__, "upgraded_resource_id", upgraded_resource_id)

    @property
    @pulumi.getter(name="endTimeUtc")
    def end_time_utc(self) -> str:
        """
        UTC time at which the upgrade operation has ended.
        """
        return pulumi.get(self, "end_time_utc")

    @property
    @pulumi.getter(name="lastUpdatedTimeUtc")
    def last_updated_time_utc(self) -> str:
        """
        UTC time at which the upgrade operation status was last updated.
        """
        return pulumi.get(self, "last_updated_time_utc")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        Message to the user containing information about the upgrade operation.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter(name="operationId")
    def operation_id(self) -> str:
        """
        ID of the vault upgrade operation.
        """
        return pulumi.get(self, "operation_id")

    @property
    @pulumi.getter(name="previousResourceId")
    def previous_resource_id(self) -> str:
        """
        Resource ID of the vault before the upgrade.
        """
        return pulumi.get(self, "previous_resource_id")

    @property
    @pulumi.getter(name="startTimeUtc")
    def start_time_utc(self) -> str:
        """
        UTC time at which the upgrade operation has started.
        """
        return pulumi.get(self, "start_time_utc")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Status of the vault upgrade operation.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="triggerType")
    def trigger_type(self) -> str:
        """
        The way the vault upgrade was triggered.
        """
        return pulumi.get(self, "trigger_type")

    @property
    @pulumi.getter(name="upgradedResourceId")
    def upgraded_resource_id(self) -> str:
        """
        Resource ID of the upgraded vault.
        """
        return pulumi.get(self, "upgraded_resource_id")


@pulumi.output_type
class UserIdentityResponse(dict):
    """
    A resource identity that is managed by the user of the service.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientId":
            suggest = "client_id"
        elif key == "principalId":
            suggest = "principal_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserIdentityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserIdentityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserIdentityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_id: str,
                 principal_id: str):
        """
        A resource identity that is managed by the user of the service.
        :param str client_id: The client ID of the user-assigned identity.
        :param str principal_id: The principal ID of the user-assigned identity.
        """
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "principal_id", principal_id)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> str:
        """
        The client ID of the user-assigned identity.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> str:
        """
        The principal ID of the user-assigned identity.
        """
        return pulumi.get(self, "principal_id")


@pulumi.output_type
class VCenterPropertiesResponse(dict):
    """
    vCenter properties.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "discoveryStatus":
            suggest = "discovery_status"
        elif key == "fabricArmResourceName":
            suggest = "fabric_arm_resource_name"
        elif key == "friendlyName":
            suggest = "friendly_name"
        elif key == "healthErrors":
            suggest = "health_errors"
        elif key == "infrastructureId":
            suggest = "infrastructure_id"
        elif key == "internalId":
            suggest = "internal_id"
        elif key == "ipAddress":
            suggest = "ip_address"
        elif key == "lastHeartbeat":
            suggest = "last_heartbeat"
        elif key == "processServerId":
            suggest = "process_server_id"
        elif key == "runAsAccountId":
            suggest = "run_as_account_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VCenterPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VCenterPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VCenterPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 discovery_status: Optional[str] = None,
                 fabric_arm_resource_name: Optional[str] = None,
                 friendly_name: Optional[str] = None,
                 health_errors: Optional[Sequence['outputs.HealthErrorResponse']] = None,
                 infrastructure_id: Optional[str] = None,
                 internal_id: Optional[str] = None,
                 ip_address: Optional[str] = None,
                 last_heartbeat: Optional[str] = None,
                 port: Optional[str] = None,
                 process_server_id: Optional[str] = None,
                 run_as_account_id: Optional[str] = None):
        """
        vCenter properties.
        :param str discovery_status: The VCenter discovery status.
        :param str fabric_arm_resource_name: The ARM resource name of the fabric containing this VCenter.
        :param str friendly_name: Friendly name of the vCenter.
        :param Sequence['HealthErrorResponse'] health_errors: The health errors for this VCenter.
        :param str infrastructure_id: The infrastructure Id of vCenter.
        :param str internal_id: VCenter internal ID.
        :param str ip_address: The IP address of the vCenter.
        :param str last_heartbeat: The time when the last heartbeat was received by vCenter.
        :param str port: The port number for discovery.
        :param str process_server_id: The process server Id.
        :param str run_as_account_id: The account Id which has privileges to discover the vCenter.
        """
        if discovery_status is not None:
            pulumi.set(__self__, "discovery_status", discovery_status)
        if fabric_arm_resource_name is not None:
            pulumi.set(__self__, "fabric_arm_resource_name", fabric_arm_resource_name)
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if health_errors is not None:
            pulumi.set(__self__, "health_errors", health_errors)
        if infrastructure_id is not None:
            pulumi.set(__self__, "infrastructure_id", infrastructure_id)
        if internal_id is not None:
            pulumi.set(__self__, "internal_id", internal_id)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if last_heartbeat is not None:
            pulumi.set(__self__, "last_heartbeat", last_heartbeat)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if process_server_id is not None:
            pulumi.set(__self__, "process_server_id", process_server_id)
        if run_as_account_id is not None:
            pulumi.set(__self__, "run_as_account_id", run_as_account_id)

    @property
    @pulumi.getter(name="discoveryStatus")
    def discovery_status(self) -> Optional[str]:
        """
        The VCenter discovery status.
        """
        return pulumi.get(self, "discovery_status")

    @property
    @pulumi.getter(name="fabricArmResourceName")
    def fabric_arm_resource_name(self) -> Optional[str]:
        """
        The ARM resource name of the fabric containing this VCenter.
        """
        return pulumi.get(self, "fabric_arm_resource_name")

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[str]:
        """
        Friendly name of the vCenter.
        """
        return pulumi.get(self, "friendly_name")

    @property
    @pulumi.getter(name="healthErrors")
    def health_errors(self) -> Optional[Sequence['outputs.HealthErrorResponse']]:
        """
        The health errors for this VCenter.
        """
        return pulumi.get(self, "health_errors")

    @property
    @pulumi.getter(name="infrastructureId")
    def infrastructure_id(self) -> Optional[str]:
        """
        The infrastructure Id of vCenter.
        """
        return pulumi.get(self, "infrastructure_id")

    @property
    @pulumi.getter(name="internalId")
    def internal_id(self) -> Optional[str]:
        """
        VCenter internal ID.
        """
        return pulumi.get(self, "internal_id")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[str]:
        """
        The IP address of the vCenter.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter(name="lastHeartbeat")
    def last_heartbeat(self) -> Optional[str]:
        """
        The time when the last heartbeat was received by vCenter.
        """
        return pulumi.get(self, "last_heartbeat")

    @property
    @pulumi.getter
    def port(self) -> Optional[str]:
        """
        The port number for discovery.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="processServerId")
    def process_server_id(self) -> Optional[str]:
        """
        The process server Id.
        """
        return pulumi.get(self, "process_server_id")

    @property
    @pulumi.getter(name="runAsAccountId")
    def run_as_account_id(self) -> Optional[str]:
        """
        The account Id which has privileges to discover the vCenter.
        """
        return pulumi.get(self, "run_as_account_id")


@pulumi.output_type
class VMNicDetailsResponse(dict):
    """
    Hyper V VM network details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enableAcceleratedNetworkingOnRecovery":
            suggest = "enable_accelerated_networking_on_recovery"
        elif key == "enableAcceleratedNetworkingOnTfo":
            suggest = "enable_accelerated_networking_on_tfo"
        elif key == "ipConfigs":
            suggest = "ip_configs"
        elif key == "nicId":
            suggest = "nic_id"
        elif key == "recoveryNetworkSecurityGroupId":
            suggest = "recovery_network_security_group_id"
        elif key == "recoveryNicName":
            suggest = "recovery_nic_name"
        elif key == "recoveryNicResourceGroupName":
            suggest = "recovery_nic_resource_group_name"
        elif key == "recoveryVMNetworkId":
            suggest = "recovery_vm_network_id"
        elif key == "replicaNicId":
            suggest = "replica_nic_id"
        elif key == "reuseExistingNic":
            suggest = "reuse_existing_nic"
        elif key == "selectionType":
            suggest = "selection_type"
        elif key == "sourceNicArmId":
            suggest = "source_nic_arm_id"
        elif key == "targetNicName":
            suggest = "target_nic_name"
        elif key == "tfoNetworkSecurityGroupId":
            suggest = "tfo_network_security_group_id"
        elif key == "tfoRecoveryNicName":
            suggest = "tfo_recovery_nic_name"
        elif key == "tfoRecoveryNicResourceGroupName":
            suggest = "tfo_recovery_nic_resource_group_name"
        elif key == "tfoReuseExistingNic":
            suggest = "tfo_reuse_existing_nic"
        elif key == "tfoVMNetworkId":
            suggest = "tfo_vm_network_id"
        elif key == "vMNetworkName":
            suggest = "v_m_network_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VMNicDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VMNicDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VMNicDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable_accelerated_networking_on_recovery: Optional[bool] = None,
                 enable_accelerated_networking_on_tfo: Optional[bool] = None,
                 ip_configs: Optional[Sequence['outputs.IPConfigDetailsResponse']] = None,
                 nic_id: Optional[str] = None,
                 recovery_network_security_group_id: Optional[str] = None,
                 recovery_nic_name: Optional[str] = None,
                 recovery_nic_resource_group_name: Optional[str] = None,
                 recovery_vm_network_id: Optional[str] = None,
                 replica_nic_id: Optional[str] = None,
                 reuse_existing_nic: Optional[bool] = None,
                 selection_type: Optional[str] = None,
                 source_nic_arm_id: Optional[str] = None,
                 target_nic_name: Optional[str] = None,
                 tfo_network_security_group_id: Optional[str] = None,
                 tfo_recovery_nic_name: Optional[str] = None,
                 tfo_recovery_nic_resource_group_name: Optional[str] = None,
                 tfo_reuse_existing_nic: Optional[bool] = None,
                 tfo_vm_network_id: Optional[str] = None,
                 v_m_network_name: Optional[str] = None):
        """
        Hyper V VM network details.
        :param bool enable_accelerated_networking_on_recovery: A value indicating whether the NIC has accelerated networking enabled.
        :param bool enable_accelerated_networking_on_tfo: Whether the TFO NIC has accelerated networking enabled.
        :param Sequence['IPConfigDetailsResponse'] ip_configs: The IP configurations of the NIC.
        :param str nic_id: The nic Id.
        :param str recovery_network_security_group_id: The id of the NSG associated with the NIC.
        :param str recovery_nic_name: The name of the NIC to be used when creating target NICs.
        :param str recovery_nic_resource_group_name: The resource group of the NIC to be used when creating target NICs.
        :param str recovery_vm_network_id: Recovery VM network Id.
        :param str replica_nic_id: The replica nic Id.
        :param bool reuse_existing_nic: A value indicating whether an existing NIC is allowed to be reused during failover subject to availability.
        :param str selection_type: Selection type for failover.
        :param str source_nic_arm_id: The source nic ARM Id.
        :param str target_nic_name: Target NIC name.
        :param str tfo_network_security_group_id: The NSG to be used by NIC during test failover.
        :param str tfo_recovery_nic_name: The name of the NIC to be used when creating target NICs in TFO.
        :param str tfo_recovery_nic_resource_group_name: The resource group of the NIC to be used when creating target NICs in TFO.
        :param bool tfo_reuse_existing_nic: A value indicating whether an existing NIC is allowed to be reused during test failover subject to availability.
        :param str tfo_vm_network_id: The network to be used by NIC during test failover.
        :param str v_m_network_name: VM network name.
        """
        if enable_accelerated_networking_on_recovery is not None:
            pulumi.set(__self__, "enable_accelerated_networking_on_recovery", enable_accelerated_networking_on_recovery)
        if enable_accelerated_networking_on_tfo is not None:
            pulumi.set(__self__, "enable_accelerated_networking_on_tfo", enable_accelerated_networking_on_tfo)
        if ip_configs is not None:
            pulumi.set(__self__, "ip_configs", ip_configs)
        if nic_id is not None:
            pulumi.set(__self__, "nic_id", nic_id)
        if recovery_network_security_group_id is not None:
            pulumi.set(__self__, "recovery_network_security_group_id", recovery_network_security_group_id)
        if recovery_nic_name is not None:
            pulumi.set(__self__, "recovery_nic_name", recovery_nic_name)
        if recovery_nic_resource_group_name is not None:
            pulumi.set(__self__, "recovery_nic_resource_group_name", recovery_nic_resource_group_name)
        if recovery_vm_network_id is not None:
            pulumi.set(__self__, "recovery_vm_network_id", recovery_vm_network_id)
        if replica_nic_id is not None:
            pulumi.set(__self__, "replica_nic_id", replica_nic_id)
        if reuse_existing_nic is None:
            reuse_existing_nic = False
        if reuse_existing_nic is not None:
            pulumi.set(__self__, "reuse_existing_nic", reuse_existing_nic)
        if selection_type is not None:
            pulumi.set(__self__, "selection_type", selection_type)
        if source_nic_arm_id is not None:
            pulumi.set(__self__, "source_nic_arm_id", source_nic_arm_id)
        if target_nic_name is not None:
            pulumi.set(__self__, "target_nic_name", target_nic_name)
        if tfo_network_security_group_id is not None:
            pulumi.set(__self__, "tfo_network_security_group_id", tfo_network_security_group_id)
        if tfo_recovery_nic_name is not None:
            pulumi.set(__self__, "tfo_recovery_nic_name", tfo_recovery_nic_name)
        if tfo_recovery_nic_resource_group_name is not None:
            pulumi.set(__self__, "tfo_recovery_nic_resource_group_name", tfo_recovery_nic_resource_group_name)
        if tfo_reuse_existing_nic is None:
            tfo_reuse_existing_nic = False
        if tfo_reuse_existing_nic is not None:
            pulumi.set(__self__, "tfo_reuse_existing_nic", tfo_reuse_existing_nic)
        if tfo_vm_network_id is not None:
            pulumi.set(__self__, "tfo_vm_network_id", tfo_vm_network_id)
        if v_m_network_name is not None:
            pulumi.set(__self__, "v_m_network_name", v_m_network_name)

    @property
    @pulumi.getter(name="enableAcceleratedNetworkingOnRecovery")
    def enable_accelerated_networking_on_recovery(self) -> Optional[bool]:
        """
        A value indicating whether the NIC has accelerated networking enabled.
        """
        return pulumi.get(self, "enable_accelerated_networking_on_recovery")

    @property
    @pulumi.getter(name="enableAcceleratedNetworkingOnTfo")
    def enable_accelerated_networking_on_tfo(self) -> Optional[bool]:
        """
        Whether the TFO NIC has accelerated networking enabled.
        """
        return pulumi.get(self, "enable_accelerated_networking_on_tfo")

    @property
    @pulumi.getter(name="ipConfigs")
    def ip_configs(self) -> Optional[Sequence['outputs.IPConfigDetailsResponse']]:
        """
        The IP configurations of the NIC.
        """
        return pulumi.get(self, "ip_configs")

    @property
    @pulumi.getter(name="nicId")
    def nic_id(self) -> Optional[str]:
        """
        The nic Id.
        """
        return pulumi.get(self, "nic_id")

    @property
    @pulumi.getter(name="recoveryNetworkSecurityGroupId")
    def recovery_network_security_group_id(self) -> Optional[str]:
        """
        The id of the NSG associated with the NIC.
        """
        return pulumi.get(self, "recovery_network_security_group_id")

    @property
    @pulumi.getter(name="recoveryNicName")
    def recovery_nic_name(self) -> Optional[str]:
        """
        The name of the NIC to be used when creating target NICs.
        """
        return pulumi.get(self, "recovery_nic_name")

    @property
    @pulumi.getter(name="recoveryNicResourceGroupName")
    def recovery_nic_resource_group_name(self) -> Optional[str]:
        """
        The resource group of the NIC to be used when creating target NICs.
        """
        return pulumi.get(self, "recovery_nic_resource_group_name")

    @property
    @pulumi.getter(name="recoveryVMNetworkId")
    def recovery_vm_network_id(self) -> Optional[str]:
        """
        Recovery VM network Id.
        """
        return pulumi.get(self, "recovery_vm_network_id")

    @property
    @pulumi.getter(name="replicaNicId")
    def replica_nic_id(self) -> Optional[str]:
        """
        The replica nic Id.
        """
        return pulumi.get(self, "replica_nic_id")

    @property
    @pulumi.getter(name="reuseExistingNic")
    def reuse_existing_nic(self) -> Optional[bool]:
        """
        A value indicating whether an existing NIC is allowed to be reused during failover subject to availability.
        """
        return pulumi.get(self, "reuse_existing_nic")

    @property
    @pulumi.getter(name="selectionType")
    def selection_type(self) -> Optional[str]:
        """
        Selection type for failover.
        """
        return pulumi.get(self, "selection_type")

    @property
    @pulumi.getter(name="sourceNicArmId")
    def source_nic_arm_id(self) -> Optional[str]:
        """
        The source nic ARM Id.
        """
        return pulumi.get(self, "source_nic_arm_id")

    @property
    @pulumi.getter(name="targetNicName")
    def target_nic_name(self) -> Optional[str]:
        """
        Target NIC name.
        """
        return pulumi.get(self, "target_nic_name")

    @property
    @pulumi.getter(name="tfoNetworkSecurityGroupId")
    def tfo_network_security_group_id(self) -> Optional[str]:
        """
        The NSG to be used by NIC during test failover.
        """
        return pulumi.get(self, "tfo_network_security_group_id")

    @property
    @pulumi.getter(name="tfoRecoveryNicName")
    def tfo_recovery_nic_name(self) -> Optional[str]:
        """
        The name of the NIC to be used when creating target NICs in TFO.
        """
        return pulumi.get(self, "tfo_recovery_nic_name")

    @property
    @pulumi.getter(name="tfoRecoveryNicResourceGroupName")
    def tfo_recovery_nic_resource_group_name(self) -> Optional[str]:
        """
        The resource group of the NIC to be used when creating target NICs in TFO.
        """
        return pulumi.get(self, "tfo_recovery_nic_resource_group_name")

    @property
    @pulumi.getter(name="tfoReuseExistingNic")
    def tfo_reuse_existing_nic(self) -> Optional[bool]:
        """
        A value indicating whether an existing NIC is allowed to be reused during test failover subject to availability.
        """
        return pulumi.get(self, "tfo_reuse_existing_nic")

    @property
    @pulumi.getter(name="tfoVMNetworkId")
    def tfo_vm_network_id(self) -> Optional[str]:
        """
        The network to be used by NIC during test failover.
        """
        return pulumi.get(self, "tfo_vm_network_id")

    @property
    @pulumi.getter(name="vMNetworkName")
    def v_m_network_name(self) -> Optional[str]:
        """
        VM network name.
        """
        return pulumi.get(self, "v_m_network_name")


@pulumi.output_type
class VMwareCbtMigrationDetailsResponse(dict):
    """
    VMwareCbt provider specific settings.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataMoverRunAsAccountId":
            suggest = "data_mover_run_as_account_id"
        elif key == "firmwareType":
            suggest = "firmware_type"
        elif key == "initialSeedingProgressPercentage":
            suggest = "initial_seeding_progress_percentage"
        elif key == "initialSeedingRetryCount":
            suggest = "initial_seeding_retry_count"
        elif key == "instanceType":
            suggest = "instance_type"
        elif key == "lastRecoveryPointId":
            suggest = "last_recovery_point_id"
        elif key == "lastRecoveryPointReceived":
            suggest = "last_recovery_point_received"
        elif key == "migrationProgressPercentage":
            suggest = "migration_progress_percentage"
        elif key == "migrationRecoveryPointId":
            suggest = "migration_recovery_point_id"
        elif key == "osType":
            suggest = "os_type"
        elif key == "resyncProgressPercentage":
            suggest = "resync_progress_percentage"
        elif key == "resyncRequired":
            suggest = "resync_required"
        elif key == "resyncRetryCount":
            suggest = "resync_retry_count"
        elif key == "resyncState":
            suggest = "resync_state"
        elif key == "snapshotRunAsAccountId":
            suggest = "snapshot_run_as_account_id"
        elif key == "targetGeneration":
            suggest = "target_generation"
        elif key == "targetLocation":
            suggest = "target_location"
        elif key == "vmwareMachineId":
            suggest = "vmware_machine_id"
        elif key == "licenseType":
            suggest = "license_type"
        elif key == "performAutoResync":
            suggest = "perform_auto_resync"
        elif key == "protectedDisks":
            suggest = "protected_disks"
        elif key == "seedDiskTags":
            suggest = "seed_disk_tags"
        elif key == "sqlServerLicenseType":
            suggest = "sql_server_license_type"
        elif key == "targetAvailabilitySetId":
            suggest = "target_availability_set_id"
        elif key == "targetAvailabilityZone":
            suggest = "target_availability_zone"
        elif key == "targetBootDiagnosticsStorageAccountId":
            suggest = "target_boot_diagnostics_storage_account_id"
        elif key == "targetDiskTags":
            suggest = "target_disk_tags"
        elif key == "targetNetworkId":
            suggest = "target_network_id"
        elif key == "targetNicTags":
            suggest = "target_nic_tags"
        elif key == "targetProximityPlacementGroupId":
            suggest = "target_proximity_placement_group_id"
        elif key == "targetResourceGroupId":
            suggest = "target_resource_group_id"
        elif key == "targetVmName":
            suggest = "target_vm_name"
        elif key == "targetVmSize":
            suggest = "target_vm_size"
        elif key == "targetVmTags":
            suggest = "target_vm_tags"
        elif key == "vmNics":
            suggest = "vm_nics"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VMwareCbtMigrationDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VMwareCbtMigrationDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VMwareCbtMigrationDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_mover_run_as_account_id: str,
                 firmware_type: str,
                 initial_seeding_progress_percentage: int,
                 initial_seeding_retry_count: float,
                 instance_type: str,
                 last_recovery_point_id: str,
                 last_recovery_point_received: str,
                 migration_progress_percentage: int,
                 migration_recovery_point_id: str,
                 os_type: str,
                 resync_progress_percentage: int,
                 resync_required: str,
                 resync_retry_count: float,
                 resync_state: str,
                 snapshot_run_as_account_id: str,
                 target_generation: str,
                 target_location: str,
                 vmware_machine_id: str,
                 license_type: Optional[str] = None,
                 perform_auto_resync: Optional[str] = None,
                 protected_disks: Optional[Sequence['outputs.VMwareCbtProtectedDiskDetailsResponse']] = None,
                 seed_disk_tags: Optional[Mapping[str, str]] = None,
                 sql_server_license_type: Optional[str] = None,
                 target_availability_set_id: Optional[str] = None,
                 target_availability_zone: Optional[str] = None,
                 target_boot_diagnostics_storage_account_id: Optional[str] = None,
                 target_disk_tags: Optional[Mapping[str, str]] = None,
                 target_network_id: Optional[str] = None,
                 target_nic_tags: Optional[Mapping[str, str]] = None,
                 target_proximity_placement_group_id: Optional[str] = None,
                 target_resource_group_id: Optional[str] = None,
                 target_vm_name: Optional[str] = None,
                 target_vm_size: Optional[str] = None,
                 target_vm_tags: Optional[Mapping[str, str]] = None,
                 vm_nics: Optional[Sequence['outputs.VMwareCbtNicDetailsResponse']] = None):
        """
        VMwareCbt provider specific settings.
        :param str data_mover_run_as_account_id: The data mover run as account Id.
        :param str firmware_type: The firmware type.
        :param int initial_seeding_progress_percentage: The initial seeding progress percentage.
        :param float initial_seeding_retry_count: The initial seeding retry count.
        :param str instance_type: Gets the instance type.
               Expected value is 'VMwareCbt'.
        :param str last_recovery_point_id: The last recovery point Id.
        :param str last_recovery_point_received: The last recovery point received time.
        :param int migration_progress_percentage: The migration progress percentage.
        :param str migration_recovery_point_id: The recovery point Id to which the VM was migrated.
        :param str os_type: The type of the OS on the VM.
        :param int resync_progress_percentage: The resync progress percentage.
        :param str resync_required: A value indicating whether resync is required.
        :param float resync_retry_count: The resync retry count.
        :param str resync_state: The resync state.
        :param str snapshot_run_as_account_id: The snapshot run as account Id.
        :param str target_generation: The target generation.
        :param str target_location: The target location.
        :param str vmware_machine_id: The ARM Id of the VM discovered in VMware.
        :param str license_type: License Type of the VM to be used.
        :param str perform_auto_resync: A value indicating whether auto resync is to be done.
        :param Sequence['VMwareCbtProtectedDiskDetailsResponse'] protected_disks: The list of protected disks.
        :param Mapping[str, str] seed_disk_tags: The tags for the seed disks.
        :param str sql_server_license_type: The SQL Server license type.
        :param str target_availability_set_id: The target availability set Id.
        :param str target_availability_zone: The target availability zone.
        :param str target_boot_diagnostics_storage_account_id: The target boot diagnostics storage account ARM Id.
        :param Mapping[str, str] target_disk_tags: The tags for the target disks.
        :param str target_network_id: The target network Id.
        :param Mapping[str, str] target_nic_tags: The tags for the target NICs.
        :param str target_proximity_placement_group_id: The target proximity placement group Id.
        :param str target_resource_group_id: The target resource group Id.
        :param str target_vm_name: Target VM name.
        :param str target_vm_size: The target VM size.
        :param Mapping[str, str] target_vm_tags: The target VM tags.
        :param Sequence['VMwareCbtNicDetailsResponse'] vm_nics: The network details.
        """
        pulumi.set(__self__, "data_mover_run_as_account_id", data_mover_run_as_account_id)
        pulumi.set(__self__, "firmware_type", firmware_type)
        pulumi.set(__self__, "initial_seeding_progress_percentage", initial_seeding_progress_percentage)
        pulumi.set(__self__, "initial_seeding_retry_count", initial_seeding_retry_count)
        pulumi.set(__self__, "instance_type", 'VMwareCbt')
        pulumi.set(__self__, "last_recovery_point_id", last_recovery_point_id)
        pulumi.set(__self__, "last_recovery_point_received", last_recovery_point_received)
        pulumi.set(__self__, "migration_progress_percentage", migration_progress_percentage)
        pulumi.set(__self__, "migration_recovery_point_id", migration_recovery_point_id)
        pulumi.set(__self__, "os_type", os_type)
        pulumi.set(__self__, "resync_progress_percentage", resync_progress_percentage)
        pulumi.set(__self__, "resync_required", resync_required)
        pulumi.set(__self__, "resync_retry_count", resync_retry_count)
        pulumi.set(__self__, "resync_state", resync_state)
        pulumi.set(__self__, "snapshot_run_as_account_id", snapshot_run_as_account_id)
        pulumi.set(__self__, "target_generation", target_generation)
        pulumi.set(__self__, "target_location", target_location)
        pulumi.set(__self__, "vmware_machine_id", vmware_machine_id)
        if license_type is not None:
            pulumi.set(__self__, "license_type", license_type)
        if perform_auto_resync is not None:
            pulumi.set(__self__, "perform_auto_resync", perform_auto_resync)
        if protected_disks is not None:
            pulumi.set(__self__, "protected_disks", protected_disks)
        if seed_disk_tags is not None:
            pulumi.set(__self__, "seed_disk_tags", seed_disk_tags)
        if sql_server_license_type is not None:
            pulumi.set(__self__, "sql_server_license_type", sql_server_license_type)
        if target_availability_set_id is not None:
            pulumi.set(__self__, "target_availability_set_id", target_availability_set_id)
        if target_availability_zone is not None:
            pulumi.set(__self__, "target_availability_zone", target_availability_zone)
        if target_boot_diagnostics_storage_account_id is not None:
            pulumi.set(__self__, "target_boot_diagnostics_storage_account_id", target_boot_diagnostics_storage_account_id)
        if target_disk_tags is not None:
            pulumi.set(__self__, "target_disk_tags", target_disk_tags)
        if target_network_id is not None:
            pulumi.set(__self__, "target_network_id", target_network_id)
        if target_nic_tags is not None:
            pulumi.set(__self__, "target_nic_tags", target_nic_tags)
        if target_proximity_placement_group_id is not None:
            pulumi.set(__self__, "target_proximity_placement_group_id", target_proximity_placement_group_id)
        if target_resource_group_id is not None:
            pulumi.set(__self__, "target_resource_group_id", target_resource_group_id)
        if target_vm_name is not None:
            pulumi.set(__self__, "target_vm_name", target_vm_name)
        if target_vm_size is not None:
            pulumi.set(__self__, "target_vm_size", target_vm_size)
        if target_vm_tags is not None:
            pulumi.set(__self__, "target_vm_tags", target_vm_tags)
        if vm_nics is not None:
            pulumi.set(__self__, "vm_nics", vm_nics)

    @property
    @pulumi.getter(name="dataMoverRunAsAccountId")
    def data_mover_run_as_account_id(self) -> str:
        """
        The data mover run as account Id.
        """
        return pulumi.get(self, "data_mover_run_as_account_id")

    @property
    @pulumi.getter(name="firmwareType")
    def firmware_type(self) -> str:
        """
        The firmware type.
        """
        return pulumi.get(self, "firmware_type")

    @property
    @pulumi.getter(name="initialSeedingProgressPercentage")
    def initial_seeding_progress_percentage(self) -> int:
        """
        The initial seeding progress percentage.
        """
        return pulumi.get(self, "initial_seeding_progress_percentage")

    @property
    @pulumi.getter(name="initialSeedingRetryCount")
    def initial_seeding_retry_count(self) -> float:
        """
        The initial seeding retry count.
        """
        return pulumi.get(self, "initial_seeding_retry_count")

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> str:
        """
        Gets the instance type.
        Expected value is 'VMwareCbt'.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="lastRecoveryPointId")
    def last_recovery_point_id(self) -> str:
        """
        The last recovery point Id.
        """
        return pulumi.get(self, "last_recovery_point_id")

    @property
    @pulumi.getter(name="lastRecoveryPointReceived")
    def last_recovery_point_received(self) -> str:
        """
        The last recovery point received time.
        """
        return pulumi.get(self, "last_recovery_point_received")

    @property
    @pulumi.getter(name="migrationProgressPercentage")
    def migration_progress_percentage(self) -> int:
        """
        The migration progress percentage.
        """
        return pulumi.get(self, "migration_progress_percentage")

    @property
    @pulumi.getter(name="migrationRecoveryPointId")
    def migration_recovery_point_id(self) -> str:
        """
        The recovery point Id to which the VM was migrated.
        """
        return pulumi.get(self, "migration_recovery_point_id")

    @property
    @pulumi.getter(name="osType")
    def os_type(self) -> str:
        """
        The type of the OS on the VM.
        """
        return pulumi.get(self, "os_type")

    @property
    @pulumi.getter(name="resyncProgressPercentage")
    def resync_progress_percentage(self) -> int:
        """
        The resync progress percentage.
        """
        return pulumi.get(self, "resync_progress_percentage")

    @property
    @pulumi.getter(name="resyncRequired")
    def resync_required(self) -> str:
        """
        A value indicating whether resync is required.
        """
        return pulumi.get(self, "resync_required")

    @property
    @pulumi.getter(name="resyncRetryCount")
    def resync_retry_count(self) -> float:
        """
        The resync retry count.
        """
        return pulumi.get(self, "resync_retry_count")

    @property
    @pulumi.getter(name="resyncState")
    def resync_state(self) -> str:
        """
        The resync state.
        """
        return pulumi.get(self, "resync_state")

    @property
    @pulumi.getter(name="snapshotRunAsAccountId")
    def snapshot_run_as_account_id(self) -> str:
        """
        The snapshot run as account Id.
        """
        return pulumi.get(self, "snapshot_run_as_account_id")

    @property
    @pulumi.getter(name="targetGeneration")
    def target_generation(self) -> str:
        """
        The target generation.
        """
        return pulumi.get(self, "target_generation")

    @property
    @pulumi.getter(name="targetLocation")
    def target_location(self) -> str:
        """
        The target location.
        """
        return pulumi.get(self, "target_location")

    @property
    @pulumi.getter(name="vmwareMachineId")
    def vmware_machine_id(self) -> str:
        """
        The ARM Id of the VM discovered in VMware.
        """
        return pulumi.get(self, "vmware_machine_id")

    @property
    @pulumi.getter(name="licenseType")
    def license_type(self) -> Optional[str]:
        """
        License Type of the VM to be used.
        """
        return pulumi.get(self, "license_type")

    @property
    @pulumi.getter(name="performAutoResync")
    def perform_auto_resync(self) -> Optional[str]:
        """
        A value indicating whether auto resync is to be done.
        """
        return pulumi.get(self, "perform_auto_resync")

    @property
    @pulumi.getter(name="protectedDisks")
    def protected_disks(self) -> Optional[Sequence['outputs.VMwareCbtProtectedDiskDetailsResponse']]:
        """
        The list of protected disks.
        """
        return pulumi.get(self, "protected_disks")

    @property
    @pulumi.getter(name="seedDiskTags")
    def seed_disk_tags(self) -> Optional[Mapping[str, str]]:
        """
        The tags for the seed disks.
        """
        return pulumi.get(self, "seed_disk_tags")

    @property
    @pulumi.getter(name="sqlServerLicenseType")
    def sql_server_license_type(self) -> Optional[str]:
        """
        The SQL Server license type.
        """
        return pulumi.get(self, "sql_server_license_type")

    @property
    @pulumi.getter(name="targetAvailabilitySetId")
    def target_availability_set_id(self) -> Optional[str]:
        """
        The target availability set Id.
        """
        return pulumi.get(self, "target_availability_set_id")

    @property
    @pulumi.getter(name="targetAvailabilityZone")
    def target_availability_zone(self) -> Optional[str]:
        """
        The target availability zone.
        """
        return pulumi.get(self, "target_availability_zone")

    @property
    @pulumi.getter(name="targetBootDiagnosticsStorageAccountId")
    def target_boot_diagnostics_storage_account_id(self) -> Optional[str]:
        """
        The target boot diagnostics storage account ARM Id.
        """
        return pulumi.get(self, "target_boot_diagnostics_storage_account_id")

    @property
    @pulumi.getter(name="targetDiskTags")
    def target_disk_tags(self) -> Optional[Mapping[str, str]]:
        """
        The tags for the target disks.
        """
        return pulumi.get(self, "target_disk_tags")

    @property
    @pulumi.getter(name="targetNetworkId")
    def target_network_id(self) -> Optional[str]:
        """
        The target network Id.
        """
        return pulumi.get(self, "target_network_id")

    @property
    @pulumi.getter(name="targetNicTags")
    def target_nic_tags(self) -> Optional[Mapping[str, str]]:
        """
        The tags for the target NICs.
        """
        return pulumi.get(self, "target_nic_tags")

    @property
    @pulumi.getter(name="targetProximityPlacementGroupId")
    def target_proximity_placement_group_id(self) -> Optional[str]:
        """
        The target proximity placement group Id.
        """
        return pulumi.get(self, "target_proximity_placement_group_id")

    @property
    @pulumi.getter(name="targetResourceGroupId")
    def target_resource_group_id(self) -> Optional[str]:
        """
        The target resource group Id.
        """
        return pulumi.get(self, "target_resource_group_id")

    @property
    @pulumi.getter(name="targetVmName")
    def target_vm_name(self) -> Optional[str]:
        """
        Target VM name.
        """
        return pulumi.get(self, "target_vm_name")

    @property
    @pulumi.getter(name="targetVmSize")
    def target_vm_size(self) -> Optional[str]:
        """
        The target VM size.
        """
        return pulumi.get(self, "target_vm_size")

    @property
    @pulumi.getter(name="targetVmTags")
    def target_vm_tags(self) -> Optional[Mapping[str, str]]:
        """
        The target VM tags.
        """
        return pulumi.get(self, "target_vm_tags")

    @property
    @pulumi.getter(name="vmNics")
    def vm_nics(self) -> Optional[Sequence['outputs.VMwareCbtNicDetailsResponse']]:
        """
        The network details.
        """
        return pulumi.get(self, "vm_nics")


@pulumi.output_type
class VMwareCbtNicDetailsResponse(dict):
    """
    VMwareCbt NIC details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nicId":
            suggest = "nic_id"
        elif key == "sourceIPAddress":
            suggest = "source_ip_address"
        elif key == "sourceIPAddressType":
            suggest = "source_ip_address_type"
        elif key == "sourceNetworkId":
            suggest = "source_network_id"
        elif key == "isPrimaryNic":
            suggest = "is_primary_nic"
        elif key == "isSelectedForMigration":
            suggest = "is_selected_for_migration"
        elif key == "targetIPAddress":
            suggest = "target_ip_address"
        elif key == "targetIPAddressType":
            suggest = "target_ip_address_type"
        elif key == "targetNicName":
            suggest = "target_nic_name"
        elif key == "targetSubnetName":
            suggest = "target_subnet_name"
        elif key == "testIPAddress":
            suggest = "test_ip_address"
        elif key == "testIPAddressType":
            suggest = "test_ip_address_type"
        elif key == "testNetworkId":
            suggest = "test_network_id"
        elif key == "testSubnetName":
            suggest = "test_subnet_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VMwareCbtNicDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VMwareCbtNicDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VMwareCbtNicDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 nic_id: str,
                 source_ip_address: str,
                 source_ip_address_type: str,
                 source_network_id: str,
                 is_primary_nic: Optional[str] = None,
                 is_selected_for_migration: Optional[str] = None,
                 target_ip_address: Optional[str] = None,
                 target_ip_address_type: Optional[str] = None,
                 target_nic_name: Optional[str] = None,
                 target_subnet_name: Optional[str] = None,
                 test_ip_address: Optional[str] = None,
                 test_ip_address_type: Optional[str] = None,
                 test_network_id: Optional[str] = None,
                 test_subnet_name: Optional[str] = None):
        """
        VMwareCbt NIC details.
        :param str nic_id: The NIC Id.
        :param str source_ip_address: The source IP address.
        :param str source_ip_address_type: The source IP address type.
        :param str source_network_id: Source network Id.
        :param str is_primary_nic: A value indicating whether this is the primary NIC.
        :param str is_selected_for_migration: A value indicating whether this NIC is selected for migration.
        :param str target_ip_address: The target IP address.
        :param str target_ip_address_type: The target IP address type.
        :param str target_nic_name: Target NIC name.
        :param str target_subnet_name: Target subnet name.
        :param str test_ip_address: The test IP address.
        :param str test_ip_address_type: The test IP address type.
        :param str test_network_id: Source network Id.
        :param str test_subnet_name: Test subnet name.
        """
        pulumi.set(__self__, "nic_id", nic_id)
        pulumi.set(__self__, "source_ip_address", source_ip_address)
        pulumi.set(__self__, "source_ip_address_type", source_ip_address_type)
        pulumi.set(__self__, "source_network_id", source_network_id)
        if is_primary_nic is not None:
            pulumi.set(__self__, "is_primary_nic", is_primary_nic)
        if is_selected_for_migration is not None:
            pulumi.set(__self__, "is_selected_for_migration", is_selected_for_migration)
        if target_ip_address is not None:
            pulumi.set(__self__, "target_ip_address", target_ip_address)
        if target_ip_address_type is not None:
            pulumi.set(__self__, "target_ip_address_type", target_ip_address_type)
        if target_nic_name is not None:
            pulumi.set(__self__, "target_nic_name", target_nic_name)
        if target_subnet_name is not None:
            pulumi.set(__self__, "target_subnet_name", target_subnet_name)
        if test_ip_address is not None:
            pulumi.set(__self__, "test_ip_address", test_ip_address)
        if test_ip_address_type is not None:
            pulumi.set(__self__, "test_ip_address_type", test_ip_address_type)
        if test_network_id is not None:
            pulumi.set(__self__, "test_network_id", test_network_id)
        if test_subnet_name is not None:
            pulumi.set(__self__, "test_subnet_name", test_subnet_name)

    @property
    @pulumi.getter(name="nicId")
    def nic_id(self) -> str:
        """
        The NIC Id.
        """
        return pulumi.get(self, "nic_id")

    @property
    @pulumi.getter(name="sourceIPAddress")
    def source_ip_address(self) -> str:
        """
        The source IP address.
        """
        return pulumi.get(self, "source_ip_address")

    @property
    @pulumi.getter(name="sourceIPAddressType")
    def source_ip_address_type(self) -> str:
        """
        The source IP address type.
        """
        return pulumi.get(self, "source_ip_address_type")

    @property
    @pulumi.getter(name="sourceNetworkId")
    def source_network_id(self) -> str:
        """
        Source network Id.
        """
        return pulumi.get(self, "source_network_id")

    @property
    @pulumi.getter(name="isPrimaryNic")
    def is_primary_nic(self) -> Optional[str]:
        """
        A value indicating whether this is the primary NIC.
        """
        return pulumi.get(self, "is_primary_nic")

    @property
    @pulumi.getter(name="isSelectedForMigration")
    def is_selected_for_migration(self) -> Optional[str]:
        """
        A value indicating whether this NIC is selected for migration.
        """
        return pulumi.get(self, "is_selected_for_migration")

    @property
    @pulumi.getter(name="targetIPAddress")
    def target_ip_address(self) -> Optional[str]:
        """
        The target IP address.
        """
        return pulumi.get(self, "target_ip_address")

    @property
    @pulumi.getter(name="targetIPAddressType")
    def target_ip_address_type(self) -> Optional[str]:
        """
        The target IP address type.
        """
        return pulumi.get(self, "target_ip_address_type")

    @property
    @pulumi.getter(name="targetNicName")
    def target_nic_name(self) -> Optional[str]:
        """
        Target NIC name.
        """
        return pulumi.get(self, "target_nic_name")

    @property
    @pulumi.getter(name="targetSubnetName")
    def target_subnet_name(self) -> Optional[str]:
        """
        Target subnet name.
        """
        return pulumi.get(self, "target_subnet_name")

    @property
    @pulumi.getter(name="testIPAddress")
    def test_ip_address(self) -> Optional[str]:
        """
        The test IP address.
        """
        return pulumi.get(self, "test_ip_address")

    @property
    @pulumi.getter(name="testIPAddressType")
    def test_ip_address_type(self) -> Optional[str]:
        """
        The test IP address type.
        """
        return pulumi.get(self, "test_ip_address_type")

    @property
    @pulumi.getter(name="testNetworkId")
    def test_network_id(self) -> Optional[str]:
        """
        Source network Id.
        """
        return pulumi.get(self, "test_network_id")

    @property
    @pulumi.getter(name="testSubnetName")
    def test_subnet_name(self) -> Optional[str]:
        """
        Test subnet name.
        """
        return pulumi.get(self, "test_subnet_name")


@pulumi.output_type
class VMwareCbtProtectedDiskDetailsResponse(dict):
    """
    VMwareCbt protected disk details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "capacityInBytes":
            suggest = "capacity_in_bytes"
        elif key == "diskEncryptionSetId":
            suggest = "disk_encryption_set_id"
        elif key == "diskId":
            suggest = "disk_id"
        elif key == "diskName":
            suggest = "disk_name"
        elif key == "diskPath":
            suggest = "disk_path"
        elif key == "isOSDisk":
            suggest = "is_os_disk"
        elif key == "logStorageAccountId":
            suggest = "log_storage_account_id"
        elif key == "logStorageAccountSasSecretName":
            suggest = "log_storage_account_sas_secret_name"
        elif key == "seedManagedDiskId":
            suggest = "seed_managed_disk_id"
        elif key == "targetManagedDiskId":
            suggest = "target_managed_disk_id"
        elif key == "diskType":
            suggest = "disk_type"
        elif key == "targetDiskName":
            suggest = "target_disk_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VMwareCbtProtectedDiskDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VMwareCbtProtectedDiskDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VMwareCbtProtectedDiskDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 capacity_in_bytes: float,
                 disk_encryption_set_id: str,
                 disk_id: str,
                 disk_name: str,
                 disk_path: str,
                 is_os_disk: str,
                 log_storage_account_id: str,
                 log_storage_account_sas_secret_name: str,
                 seed_managed_disk_id: str,
                 target_managed_disk_id: str,
                 disk_type: Optional[str] = None,
                 target_disk_name: Optional[str] = None):
        """
        VMwareCbt protected disk details.
        :param float capacity_in_bytes: The disk capacity in bytes.
        :param str disk_encryption_set_id: The DiskEncryptionSet ARM Id.
        :param str disk_id: The disk id.
        :param str disk_name: The disk name.
        :param str disk_path: The disk path.
        :param str is_os_disk: A value indicating whether the disk is the OS disk.
        :param str log_storage_account_id: The log storage account ARM Id.
        :param str log_storage_account_sas_secret_name: The key vault secret name of the log storage account.
        :param str seed_managed_disk_id: The ARM Id of the seed managed disk.
        :param str target_managed_disk_id: The ARM Id of the target managed disk.
        :param str disk_type: The disk type.
        :param str target_disk_name: The name for the target managed disk.
        """
        pulumi.set(__self__, "capacity_in_bytes", capacity_in_bytes)
        pulumi.set(__self__, "disk_encryption_set_id", disk_encryption_set_id)
        pulumi.set(__self__, "disk_id", disk_id)
        pulumi.set(__self__, "disk_name", disk_name)
        pulumi.set(__self__, "disk_path", disk_path)
        pulumi.set(__self__, "is_os_disk", is_os_disk)
        pulumi.set(__self__, "log_storage_account_id", log_storage_account_id)
        pulumi.set(__self__, "log_storage_account_sas_secret_name", log_storage_account_sas_secret_name)
        pulumi.set(__self__, "seed_managed_disk_id", seed_managed_disk_id)
        pulumi.set(__self__, "target_managed_disk_id", target_managed_disk_id)
        if disk_type is not None:
            pulumi.set(__self__, "disk_type", disk_type)
        if target_disk_name is not None:
            pulumi.set(__self__, "target_disk_name", target_disk_name)

    @property
    @pulumi.getter(name="capacityInBytes")
    def capacity_in_bytes(self) -> float:
        """
        The disk capacity in bytes.
        """
        return pulumi.get(self, "capacity_in_bytes")

    @property
    @pulumi.getter(name="diskEncryptionSetId")
    def disk_encryption_set_id(self) -> str:
        """
        The DiskEncryptionSet ARM Id.
        """
        return pulumi.get(self, "disk_encryption_set_id")

    @property
    @pulumi.getter(name="diskId")
    def disk_id(self) -> str:
        """
        The disk id.
        """
        return pulumi.get(self, "disk_id")

    @property
    @pulumi.getter(name="diskName")
    def disk_name(self) -> str:
        """
        The disk name.
        """
        return pulumi.get(self, "disk_name")

    @property
    @pulumi.getter(name="diskPath")
    def disk_path(self) -> str:
        """
        The disk path.
        """
        return pulumi.get(self, "disk_path")

    @property
    @pulumi.getter(name="isOSDisk")
    def is_os_disk(self) -> str:
        """
        A value indicating whether the disk is the OS disk.
        """
        return pulumi.get(self, "is_os_disk")

    @property
    @pulumi.getter(name="logStorageAccountId")
    def log_storage_account_id(self) -> str:
        """
        The log storage account ARM Id.
        """
        return pulumi.get(self, "log_storage_account_id")

    @property
    @pulumi.getter(name="logStorageAccountSasSecretName")
    def log_storage_account_sas_secret_name(self) -> str:
        """
        The key vault secret name of the log storage account.
        """
        return pulumi.get(self, "log_storage_account_sas_secret_name")

    @property
    @pulumi.getter(name="seedManagedDiskId")
    def seed_managed_disk_id(self) -> str:
        """
        The ARM Id of the seed managed disk.
        """
        return pulumi.get(self, "seed_managed_disk_id")

    @property
    @pulumi.getter(name="targetManagedDiskId")
    def target_managed_disk_id(self) -> str:
        """
        The ARM Id of the target managed disk.
        """
        return pulumi.get(self, "target_managed_disk_id")

    @property
    @pulumi.getter(name="diskType")
    def disk_type(self) -> Optional[str]:
        """
        The disk type.
        """
        return pulumi.get(self, "disk_type")

    @property
    @pulumi.getter(name="targetDiskName")
    def target_disk_name(self) -> Optional[str]:
        """
        The name for the target managed disk.
        """
        return pulumi.get(self, "target_disk_name")


@pulumi.output_type
class VMwareCbtProtectionContainerMappingDetailsResponse(dict):
    """
    VMwareCbt provider specific container mapping details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceType":
            suggest = "instance_type"
        elif key == "keyVaultId":
            suggest = "key_vault_id"
        elif key == "keyVaultUri":
            suggest = "key_vault_uri"
        elif key == "serviceBusConnectionStringSecretName":
            suggest = "service_bus_connection_string_secret_name"
        elif key == "storageAccountId":
            suggest = "storage_account_id"
        elif key == "storageAccountSasSecretName":
            suggest = "storage_account_sas_secret_name"
        elif key == "targetLocation":
            suggest = "target_location"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VMwareCbtProtectionContainerMappingDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VMwareCbtProtectionContainerMappingDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VMwareCbtProtectionContainerMappingDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_type: str,
                 key_vault_id: str,
                 key_vault_uri: str,
                 service_bus_connection_string_secret_name: str,
                 storage_account_id: str,
                 storage_account_sas_secret_name: str,
                 target_location: str):
        """
        VMwareCbt provider specific container mapping details.
        :param str instance_type: Gets the class type. Overridden in derived classes.
               Expected value is 'VMwareCbt'.
        :param str key_vault_id: The target key vault ARM Id.
        :param str key_vault_uri: The target key vault URI.
        :param str service_bus_connection_string_secret_name: The secret name of the service bus connection string.
        :param str storage_account_id: The storage account ARM Id.
        :param str storage_account_sas_secret_name: The secret name of the storage account.
        :param str target_location: The target location.
        """
        pulumi.set(__self__, "instance_type", 'VMwareCbt')
        pulumi.set(__self__, "key_vault_id", key_vault_id)
        pulumi.set(__self__, "key_vault_uri", key_vault_uri)
        pulumi.set(__self__, "service_bus_connection_string_secret_name", service_bus_connection_string_secret_name)
        pulumi.set(__self__, "storage_account_id", storage_account_id)
        pulumi.set(__self__, "storage_account_sas_secret_name", storage_account_sas_secret_name)
        pulumi.set(__self__, "target_location", target_location)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> str:
        """
        Gets the class type. Overridden in derived classes.
        Expected value is 'VMwareCbt'.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="keyVaultId")
    def key_vault_id(self) -> str:
        """
        The target key vault ARM Id.
        """
        return pulumi.get(self, "key_vault_id")

    @property
    @pulumi.getter(name="keyVaultUri")
    def key_vault_uri(self) -> str:
        """
        The target key vault URI.
        """
        return pulumi.get(self, "key_vault_uri")

    @property
    @pulumi.getter(name="serviceBusConnectionStringSecretName")
    def service_bus_connection_string_secret_name(self) -> str:
        """
        The secret name of the service bus connection string.
        """
        return pulumi.get(self, "service_bus_connection_string_secret_name")

    @property
    @pulumi.getter(name="storageAccountId")
    def storage_account_id(self) -> str:
        """
        The storage account ARM Id.
        """
        return pulumi.get(self, "storage_account_id")

    @property
    @pulumi.getter(name="storageAccountSasSecretName")
    def storage_account_sas_secret_name(self) -> str:
        """
        The secret name of the storage account.
        """
        return pulumi.get(self, "storage_account_sas_secret_name")

    @property
    @pulumi.getter(name="targetLocation")
    def target_location(self) -> str:
        """
        The target location.
        """
        return pulumi.get(self, "target_location")


@pulumi.output_type
class VMwareDetailsResponse(dict):
    """
    Store the fabric details specific to the VMware fabric.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceType":
            suggest = "instance_type"
        elif key == "agentCount":
            suggest = "agent_count"
        elif key == "agentExpiryDate":
            suggest = "agent_expiry_date"
        elif key == "agentVersion":
            suggest = "agent_version"
        elif key == "agentVersionDetails":
            suggest = "agent_version_details"
        elif key == "availableMemoryInBytes":
            suggest = "available_memory_in_bytes"
        elif key == "availableSpaceInBytes":
            suggest = "available_space_in_bytes"
        elif key == "cpuLoad":
            suggest = "cpu_load"
        elif key == "cpuLoadStatus":
            suggest = "cpu_load_status"
        elif key == "csServiceStatus":
            suggest = "cs_service_status"
        elif key == "databaseServerLoad":
            suggest = "database_server_load"
        elif key == "databaseServerLoadStatus":
            suggest = "database_server_load_status"
        elif key == "hostName":
            suggest = "host_name"
        elif key == "ipAddress":
            suggest = "ip_address"
        elif key == "lastHeartbeat":
            suggest = "last_heartbeat"
        elif key == "masterTargetServers":
            suggest = "master_target_servers"
        elif key == "memoryUsageStatus":
            suggest = "memory_usage_status"
        elif key == "processServerCount":
            suggest = "process_server_count"
        elif key == "processServers":
            suggest = "process_servers"
        elif key == "protectedServers":
            suggest = "protected_servers"
        elif key == "psTemplateVersion":
            suggest = "ps_template_version"
        elif key == "replicationPairCount":
            suggest = "replication_pair_count"
        elif key == "runAsAccounts":
            suggest = "run_as_accounts"
        elif key == "spaceUsageStatus":
            suggest = "space_usage_status"
        elif key == "sslCertExpiryDate":
            suggest = "ssl_cert_expiry_date"
        elif key == "sslCertExpiryRemainingDays":
            suggest = "ssl_cert_expiry_remaining_days"
        elif key == "switchProviderBlockingErrorDetails":
            suggest = "switch_provider_blocking_error_details"
        elif key == "systemLoad":
            suggest = "system_load"
        elif key == "systemLoadStatus":
            suggest = "system_load_status"
        elif key == "totalMemoryInBytes":
            suggest = "total_memory_in_bytes"
        elif key == "totalSpaceInBytes":
            suggest = "total_space_in_bytes"
        elif key == "versionStatus":
            suggest = "version_status"
        elif key == "webLoad":
            suggest = "web_load"
        elif key == "webLoadStatus":
            suggest = "web_load_status"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VMwareDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VMwareDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VMwareDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_type: str,
                 agent_count: Optional[str] = None,
                 agent_expiry_date: Optional[str] = None,
                 agent_version: Optional[str] = None,
                 agent_version_details: Optional['outputs.VersionDetailsResponse'] = None,
                 available_memory_in_bytes: Optional[float] = None,
                 available_space_in_bytes: Optional[float] = None,
                 cpu_load: Optional[str] = None,
                 cpu_load_status: Optional[str] = None,
                 cs_service_status: Optional[str] = None,
                 database_server_load: Optional[str] = None,
                 database_server_load_status: Optional[str] = None,
                 host_name: Optional[str] = None,
                 ip_address: Optional[str] = None,
                 last_heartbeat: Optional[str] = None,
                 master_target_servers: Optional[Sequence['outputs.MasterTargetServerResponse']] = None,
                 memory_usage_status: Optional[str] = None,
                 process_server_count: Optional[str] = None,
                 process_servers: Optional[Sequence['outputs.ProcessServerResponse']] = None,
                 protected_servers: Optional[str] = None,
                 ps_template_version: Optional[str] = None,
                 replication_pair_count: Optional[str] = None,
                 run_as_accounts: Optional[Sequence['outputs.RunAsAccountResponse']] = None,
                 space_usage_status: Optional[str] = None,
                 ssl_cert_expiry_date: Optional[str] = None,
                 ssl_cert_expiry_remaining_days: Optional[int] = None,
                 switch_provider_blocking_error_details: Optional[Sequence['outputs.InMageFabricSwitchProviderBlockingErrorDetailsResponse']] = None,
                 system_load: Optional[str] = None,
                 system_load_status: Optional[str] = None,
                 total_memory_in_bytes: Optional[float] = None,
                 total_space_in_bytes: Optional[float] = None,
                 version_status: Optional[str] = None,
                 web_load: Optional[str] = None,
                 web_load_status: Optional[str] = None):
        """
        Store the fabric details specific to the VMware fabric.
        :param str instance_type: Gets the class type. Overridden in derived classes.
               Expected value is 'VMware'.
        :param str agent_count: The number of source and target servers configured to talk to this CS.
        :param str agent_expiry_date: Agent expiry date.
        :param str agent_version: The agent Version.
        :param 'VersionDetailsResponse' agent_version_details: The agent version details.
        :param float available_memory_in_bytes: The available memory.
        :param float available_space_in_bytes: The available space.
        :param str cpu_load: The percentage of the CPU load.
        :param str cpu_load_status: The CPU load status.
        :param str cs_service_status: The CS service status.
        :param str database_server_load: The database server load.
        :param str database_server_load_status: The database server load status.
        :param str host_name: The host name.
        :param str ip_address: The IP address.
        :param str last_heartbeat: The last heartbeat received from CS server.
        :param Sequence['MasterTargetServerResponse'] master_target_servers: The list of Master Target servers associated with the fabric.
        :param str memory_usage_status: The memory usage status.
        :param str process_server_count: The number of process servers.
        :param Sequence['ProcessServerResponse'] process_servers: The list of Process Servers associated with the fabric.
        :param str protected_servers: The number of protected servers.
        :param str ps_template_version: PS template version.
        :param str replication_pair_count: The number of replication pairs configured in this CS.
        :param Sequence['RunAsAccountResponse'] run_as_accounts: The list of run as accounts created on the server.
        :param str space_usage_status: The space usage status.
        :param str ssl_cert_expiry_date: CS SSL cert expiry date.
        :param int ssl_cert_expiry_remaining_days: CS SSL cert expiry date.
        :param Sequence['InMageFabricSwitchProviderBlockingErrorDetailsResponse'] switch_provider_blocking_error_details: The switch provider blocking error information.
        :param str system_load: The percentage of the system load.
        :param str system_load_status: The system load status.
        :param float total_memory_in_bytes: The total memory.
        :param float total_space_in_bytes: The total space.
        :param str version_status: Version status.
        :param str web_load: The web load.
        :param str web_load_status: The web load status.
        """
        pulumi.set(__self__, "instance_type", 'VMware')
        if agent_count is not None:
            pulumi.set(__self__, "agent_count", agent_count)
        if agent_expiry_date is not None:
            pulumi.set(__self__, "agent_expiry_date", agent_expiry_date)
        if agent_version is not None:
            pulumi.set(__self__, "agent_version", agent_version)
        if agent_version_details is not None:
            pulumi.set(__self__, "agent_version_details", agent_version_details)
        if available_memory_in_bytes is not None:
            pulumi.set(__self__, "available_memory_in_bytes", available_memory_in_bytes)
        if available_space_in_bytes is not None:
            pulumi.set(__self__, "available_space_in_bytes", available_space_in_bytes)
        if cpu_load is not None:
            pulumi.set(__self__, "cpu_load", cpu_load)
        if cpu_load_status is not None:
            pulumi.set(__self__, "cpu_load_status", cpu_load_status)
        if cs_service_status is not None:
            pulumi.set(__self__, "cs_service_status", cs_service_status)
        if database_server_load is not None:
            pulumi.set(__self__, "database_server_load", database_server_load)
        if database_server_load_status is not None:
            pulumi.set(__self__, "database_server_load_status", database_server_load_status)
        if host_name is not None:
            pulumi.set(__self__, "host_name", host_name)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if last_heartbeat is not None:
            pulumi.set(__self__, "last_heartbeat", last_heartbeat)
        if master_target_servers is not None:
            pulumi.set(__self__, "master_target_servers", master_target_servers)
        if memory_usage_status is not None:
            pulumi.set(__self__, "memory_usage_status", memory_usage_status)
        if process_server_count is not None:
            pulumi.set(__self__, "process_server_count", process_server_count)
        if process_servers is not None:
            pulumi.set(__self__, "process_servers", process_servers)
        if protected_servers is not None:
            pulumi.set(__self__, "protected_servers", protected_servers)
        if ps_template_version is not None:
            pulumi.set(__self__, "ps_template_version", ps_template_version)
        if replication_pair_count is not None:
            pulumi.set(__self__, "replication_pair_count", replication_pair_count)
        if run_as_accounts is not None:
            pulumi.set(__self__, "run_as_accounts", run_as_accounts)
        if space_usage_status is not None:
            pulumi.set(__self__, "space_usage_status", space_usage_status)
        if ssl_cert_expiry_date is not None:
            pulumi.set(__self__, "ssl_cert_expiry_date", ssl_cert_expiry_date)
        if ssl_cert_expiry_remaining_days is not None:
            pulumi.set(__self__, "ssl_cert_expiry_remaining_days", ssl_cert_expiry_remaining_days)
        if switch_provider_blocking_error_details is not None:
            pulumi.set(__self__, "switch_provider_blocking_error_details", switch_provider_blocking_error_details)
        if system_load is not None:
            pulumi.set(__self__, "system_load", system_load)
        if system_load_status is not None:
            pulumi.set(__self__, "system_load_status", system_load_status)
        if total_memory_in_bytes is not None:
            pulumi.set(__self__, "total_memory_in_bytes", total_memory_in_bytes)
        if total_space_in_bytes is not None:
            pulumi.set(__self__, "total_space_in_bytes", total_space_in_bytes)
        if version_status is not None:
            pulumi.set(__self__, "version_status", version_status)
        if web_load is not None:
            pulumi.set(__self__, "web_load", web_load)
        if web_load_status is not None:
            pulumi.set(__self__, "web_load_status", web_load_status)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> str:
        """
        Gets the class type. Overridden in derived classes.
        Expected value is 'VMware'.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="agentCount")
    def agent_count(self) -> Optional[str]:
        """
        The number of source and target servers configured to talk to this CS.
        """
        return pulumi.get(self, "agent_count")

    @property
    @pulumi.getter(name="agentExpiryDate")
    def agent_expiry_date(self) -> Optional[str]:
        """
        Agent expiry date.
        """
        return pulumi.get(self, "agent_expiry_date")

    @property
    @pulumi.getter(name="agentVersion")
    def agent_version(self) -> Optional[str]:
        """
        The agent Version.
        """
        return pulumi.get(self, "agent_version")

    @property
    @pulumi.getter(name="agentVersionDetails")
    def agent_version_details(self) -> Optional['outputs.VersionDetailsResponse']:
        """
        The agent version details.
        """
        return pulumi.get(self, "agent_version_details")

    @property
    @pulumi.getter(name="availableMemoryInBytes")
    def available_memory_in_bytes(self) -> Optional[float]:
        """
        The available memory.
        """
        return pulumi.get(self, "available_memory_in_bytes")

    @property
    @pulumi.getter(name="availableSpaceInBytes")
    def available_space_in_bytes(self) -> Optional[float]:
        """
        The available space.
        """
        return pulumi.get(self, "available_space_in_bytes")

    @property
    @pulumi.getter(name="cpuLoad")
    def cpu_load(self) -> Optional[str]:
        """
        The percentage of the CPU load.
        """
        return pulumi.get(self, "cpu_load")

    @property
    @pulumi.getter(name="cpuLoadStatus")
    def cpu_load_status(self) -> Optional[str]:
        """
        The CPU load status.
        """
        return pulumi.get(self, "cpu_load_status")

    @property
    @pulumi.getter(name="csServiceStatus")
    def cs_service_status(self) -> Optional[str]:
        """
        The CS service status.
        """
        return pulumi.get(self, "cs_service_status")

    @property
    @pulumi.getter(name="databaseServerLoad")
    def database_server_load(self) -> Optional[str]:
        """
        The database server load.
        """
        return pulumi.get(self, "database_server_load")

    @property
    @pulumi.getter(name="databaseServerLoadStatus")
    def database_server_load_status(self) -> Optional[str]:
        """
        The database server load status.
        """
        return pulumi.get(self, "database_server_load_status")

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> Optional[str]:
        """
        The host name.
        """
        return pulumi.get(self, "host_name")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[str]:
        """
        The IP address.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter(name="lastHeartbeat")
    def last_heartbeat(self) -> Optional[str]:
        """
        The last heartbeat received from CS server.
        """
        return pulumi.get(self, "last_heartbeat")

    @property
    @pulumi.getter(name="masterTargetServers")
    def master_target_servers(self) -> Optional[Sequence['outputs.MasterTargetServerResponse']]:
        """
        The list of Master Target servers associated with the fabric.
        """
        return pulumi.get(self, "master_target_servers")

    @property
    @pulumi.getter(name="memoryUsageStatus")
    def memory_usage_status(self) -> Optional[str]:
        """
        The memory usage status.
        """
        return pulumi.get(self, "memory_usage_status")

    @property
    @pulumi.getter(name="processServerCount")
    def process_server_count(self) -> Optional[str]:
        """
        The number of process servers.
        """
        return pulumi.get(self, "process_server_count")

    @property
    @pulumi.getter(name="processServers")
    def process_servers(self) -> Optional[Sequence['outputs.ProcessServerResponse']]:
        """
        The list of Process Servers associated with the fabric.
        """
        return pulumi.get(self, "process_servers")

    @property
    @pulumi.getter(name="protectedServers")
    def protected_servers(self) -> Optional[str]:
        """
        The number of protected servers.
        """
        return pulumi.get(self, "protected_servers")

    @property
    @pulumi.getter(name="psTemplateVersion")
    def ps_template_version(self) -> Optional[str]:
        """
        PS template version.
        """
        return pulumi.get(self, "ps_template_version")

    @property
    @pulumi.getter(name="replicationPairCount")
    def replication_pair_count(self) -> Optional[str]:
        """
        The number of replication pairs configured in this CS.
        """
        return pulumi.get(self, "replication_pair_count")

    @property
    @pulumi.getter(name="runAsAccounts")
    def run_as_accounts(self) -> Optional[Sequence['outputs.RunAsAccountResponse']]:
        """
        The list of run as accounts created on the server.
        """
        return pulumi.get(self, "run_as_accounts")

    @property
    @pulumi.getter(name="spaceUsageStatus")
    def space_usage_status(self) -> Optional[str]:
        """
        The space usage status.
        """
        return pulumi.get(self, "space_usage_status")

    @property
    @pulumi.getter(name="sslCertExpiryDate")
    def ssl_cert_expiry_date(self) -> Optional[str]:
        """
        CS SSL cert expiry date.
        """
        return pulumi.get(self, "ssl_cert_expiry_date")

    @property
    @pulumi.getter(name="sslCertExpiryRemainingDays")
    def ssl_cert_expiry_remaining_days(self) -> Optional[int]:
        """
        CS SSL cert expiry date.
        """
        return pulumi.get(self, "ssl_cert_expiry_remaining_days")

    @property
    @pulumi.getter(name="switchProviderBlockingErrorDetails")
    def switch_provider_blocking_error_details(self) -> Optional[Sequence['outputs.InMageFabricSwitchProviderBlockingErrorDetailsResponse']]:
        """
        The switch provider blocking error information.
        """
        return pulumi.get(self, "switch_provider_blocking_error_details")

    @property
    @pulumi.getter(name="systemLoad")
    def system_load(self) -> Optional[str]:
        """
        The percentage of the system load.
        """
        return pulumi.get(self, "system_load")

    @property
    @pulumi.getter(name="systemLoadStatus")
    def system_load_status(self) -> Optional[str]:
        """
        The system load status.
        """
        return pulumi.get(self, "system_load_status")

    @property
    @pulumi.getter(name="totalMemoryInBytes")
    def total_memory_in_bytes(self) -> Optional[float]:
        """
        The total memory.
        """
        return pulumi.get(self, "total_memory_in_bytes")

    @property
    @pulumi.getter(name="totalSpaceInBytes")
    def total_space_in_bytes(self) -> Optional[float]:
        """
        The total space.
        """
        return pulumi.get(self, "total_space_in_bytes")

    @property
    @pulumi.getter(name="versionStatus")
    def version_status(self) -> Optional[str]:
        """
        Version status.
        """
        return pulumi.get(self, "version_status")

    @property
    @pulumi.getter(name="webLoad")
    def web_load(self) -> Optional[str]:
        """
        The web load.
        """
        return pulumi.get(self, "web_load")

    @property
    @pulumi.getter(name="webLoadStatus")
    def web_load_status(self) -> Optional[str]:
        """
        The web load status.
        """
        return pulumi.get(self, "web_load_status")


@pulumi.output_type
class VMwareV2FabricSpecificDetailsResponse(dict):
    """
    VMwareV2 fabric specific details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceType":
            suggest = "instance_type"
        elif key == "migrationSolutionId":
            suggest = "migration_solution_id"
        elif key == "physicalSiteId":
            suggest = "physical_site_id"
        elif key == "processServers":
            suggest = "process_servers"
        elif key == "serviceContainerId":
            suggest = "service_container_id"
        elif key == "serviceEndpoint":
            suggest = "service_endpoint"
        elif key == "serviceResourceId":
            suggest = "service_resource_id"
        elif key == "vmwareSiteId":
            suggest = "vmware_site_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VMwareV2FabricSpecificDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VMwareV2FabricSpecificDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VMwareV2FabricSpecificDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_type: str,
                 migration_solution_id: str,
                 physical_site_id: str,
                 process_servers: Sequence['outputs.ProcessServerDetailsResponse'],
                 service_container_id: str,
                 service_endpoint: str,
                 service_resource_id: str,
                 vmware_site_id: str):
        """
        VMwareV2 fabric specific details.
        :param str instance_type: Gets the class type. Overridden in derived classes.
               Expected value is 'VMwareV2'.
        :param str migration_solution_id: The Migration solution ARM Id.
        :param str physical_site_id: The ARM Id of the physical site.
        :param Sequence['ProcessServerDetailsResponse'] process_servers: The list of process servers.
        :param str service_container_id: The service container Id.
        :param str service_endpoint: The service endpoint.
        :param str service_resource_id: The service resource Id.
        :param str vmware_site_id: The ARM Id of the VMware site.
        """
        pulumi.set(__self__, "instance_type", 'VMwareV2')
        pulumi.set(__self__, "migration_solution_id", migration_solution_id)
        pulumi.set(__self__, "physical_site_id", physical_site_id)
        pulumi.set(__self__, "process_servers", process_servers)
        pulumi.set(__self__, "service_container_id", service_container_id)
        pulumi.set(__self__, "service_endpoint", service_endpoint)
        pulumi.set(__self__, "service_resource_id", service_resource_id)
        pulumi.set(__self__, "vmware_site_id", vmware_site_id)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> str:
        """
        Gets the class type. Overridden in derived classes.
        Expected value is 'VMwareV2'.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="migrationSolutionId")
    def migration_solution_id(self) -> str:
        """
        The Migration solution ARM Id.
        """
        return pulumi.get(self, "migration_solution_id")

    @property
    @pulumi.getter(name="physicalSiteId")
    def physical_site_id(self) -> str:
        """
        The ARM Id of the physical site.
        """
        return pulumi.get(self, "physical_site_id")

    @property
    @pulumi.getter(name="processServers")
    def process_servers(self) -> Sequence['outputs.ProcessServerDetailsResponse']:
        """
        The list of process servers.
        """
        return pulumi.get(self, "process_servers")

    @property
    @pulumi.getter(name="serviceContainerId")
    def service_container_id(self) -> str:
        """
        The service container Id.
        """
        return pulumi.get(self, "service_container_id")

    @property
    @pulumi.getter(name="serviceEndpoint")
    def service_endpoint(self) -> str:
        """
        The service endpoint.
        """
        return pulumi.get(self, "service_endpoint")

    @property
    @pulumi.getter(name="serviceResourceId")
    def service_resource_id(self) -> str:
        """
        The service resource Id.
        """
        return pulumi.get(self, "service_resource_id")

    @property
    @pulumi.getter(name="vmwareSiteId")
    def vmware_site_id(self) -> str:
        """
        The ARM Id of the VMware site.
        """
        return pulumi.get(self, "vmware_site_id")


@pulumi.output_type
class VaultPrivateEndpointConnectionResponse(dict):
    """
    Private Endpoint Connection Response Properties.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "privateEndpoint":
            suggest = "private_endpoint"
        elif key == "privateLinkServiceConnectionState":
            suggest = "private_link_service_connection_state"
        elif key == "provisioningState":
            suggest = "provisioning_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VaultPrivateEndpointConnectionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VaultPrivateEndpointConnectionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VaultPrivateEndpointConnectionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 private_endpoint: 'outputs.PrivateEndpointResponse',
                 private_link_service_connection_state: 'outputs.VaultPrivateLinkServiceConnectionStateResponse',
                 provisioning_state: str):
        """
        Private Endpoint Connection Response Properties.
        :param 'PrivateEndpointResponse' private_endpoint: The Private Endpoint network resource that is linked to the Private Endpoint connection.
        :param 'VaultPrivateLinkServiceConnectionStateResponse' private_link_service_connection_state: Gets or sets private link service connection state.
        :param str provisioning_state: Gets or sets provisioning state of the private endpoint connection.
        """
        pulumi.set(__self__, "private_endpoint", private_endpoint)
        pulumi.set(__self__, "private_link_service_connection_state", private_link_service_connection_state)
        pulumi.set(__self__, "provisioning_state", provisioning_state)

    @property
    @pulumi.getter(name="privateEndpoint")
    def private_endpoint(self) -> 'outputs.PrivateEndpointResponse':
        """
        The Private Endpoint network resource that is linked to the Private Endpoint connection.
        """
        return pulumi.get(self, "private_endpoint")

    @property
    @pulumi.getter(name="privateLinkServiceConnectionState")
    def private_link_service_connection_state(self) -> 'outputs.VaultPrivateLinkServiceConnectionStateResponse':
        """
        Gets or sets private link service connection state.
        """
        return pulumi.get(self, "private_link_service_connection_state")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        Gets or sets provisioning state of the private endpoint connection.
        """
        return pulumi.get(self, "provisioning_state")


@pulumi.output_type
class VaultPrivateLinkServiceConnectionStateResponse(dict):
    """
    Gets or sets private link service connection state.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "actionsRequired":
            suggest = "actions_required"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VaultPrivateLinkServiceConnectionStateResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VaultPrivateLinkServiceConnectionStateResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VaultPrivateLinkServiceConnectionStateResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 actions_required: str,
                 description: str,
                 status: str):
        """
        Gets or sets private link service connection state.
        :param str actions_required: Gets or sets actions required.
        :param str description: Gets or sets description.
        :param str status: Gets or sets the status.
        """
        pulumi.set(__self__, "actions_required", actions_required)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="actionsRequired")
    def actions_required(self) -> str:
        """
        Gets or sets actions required.
        """
        return pulumi.get(self, "actions_required")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Gets or sets description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Gets or sets the status.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class VaultPropertiesResponse(dict):
    """
    Properties of the vault.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backupStorageVersion":
            suggest = "backup_storage_version"
        elif key == "moveState":
            suggest = "move_state"
        elif key == "privateEndpointConnections":
            suggest = "private_endpoint_connections"
        elif key == "privateEndpointStateForBackup":
            suggest = "private_endpoint_state_for_backup"
        elif key == "privateEndpointStateForSiteRecovery":
            suggest = "private_endpoint_state_for_site_recovery"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "monitoringSettings":
            suggest = "monitoring_settings"
        elif key == "moveDetails":
            suggest = "move_details"
        elif key == "redundancySettings":
            suggest = "redundancy_settings"
        elif key == "upgradeDetails":
            suggest = "upgrade_details"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VaultPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VaultPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VaultPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backup_storage_version: str,
                 move_state: str,
                 private_endpoint_connections: Sequence['outputs.PrivateEndpointConnectionVaultPropertiesResponse'],
                 private_endpoint_state_for_backup: str,
                 private_endpoint_state_for_site_recovery: str,
                 provisioning_state: str,
                 encryption: Optional['outputs.VaultPropertiesResponseEncryption'] = None,
                 monitoring_settings: Optional['outputs.MonitoringSettingsResponse'] = None,
                 move_details: Optional['outputs.VaultPropertiesResponseMoveDetails'] = None,
                 redundancy_settings: Optional['outputs.VaultPropertiesResponseRedundancySettings'] = None,
                 upgrade_details: Optional['outputs.UpgradeDetailsResponse'] = None):
        """
        Properties of the vault.
        :param str backup_storage_version: Backup storage version
        :param str move_state: The State of the Resource after the move operation
        :param Sequence['PrivateEndpointConnectionVaultPropertiesResponse'] private_endpoint_connections: List of private endpoint connection.
        :param str private_endpoint_state_for_backup: Private endpoint state for backup.
        :param str private_endpoint_state_for_site_recovery: Private endpoint state for site recovery.
        :param str provisioning_state: Provisioning State.
        :param 'VaultPropertiesResponseEncryption' encryption: Customer Managed Key details of the resource.
        :param 'MonitoringSettingsResponse' monitoring_settings: Monitoring Settings of the vault
        :param 'VaultPropertiesResponseMoveDetails' move_details: The details of the latest move operation performed on the Azure Resource
        :param 'VaultPropertiesResponseRedundancySettings' redundancy_settings: The redundancy Settings of a Vault
        :param 'UpgradeDetailsResponse' upgrade_details: Details for upgrading vault.
        """
        pulumi.set(__self__, "backup_storage_version", backup_storage_version)
        pulumi.set(__self__, "move_state", move_state)
        pulumi.set(__self__, "private_endpoint_connections", private_endpoint_connections)
        pulumi.set(__self__, "private_endpoint_state_for_backup", private_endpoint_state_for_backup)
        pulumi.set(__self__, "private_endpoint_state_for_site_recovery", private_endpoint_state_for_site_recovery)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if encryption is not None:
            pulumi.set(__self__, "encryption", encryption)
        if monitoring_settings is not None:
            pulumi.set(__self__, "monitoring_settings", monitoring_settings)
        if move_details is not None:
            pulumi.set(__self__, "move_details", move_details)
        if redundancy_settings is not None:
            pulumi.set(__self__, "redundancy_settings", redundancy_settings)
        if upgrade_details is not None:
            pulumi.set(__self__, "upgrade_details", upgrade_details)

    @property
    @pulumi.getter(name="backupStorageVersion")
    def backup_storage_version(self) -> str:
        """
        Backup storage version
        """
        return pulumi.get(self, "backup_storage_version")

    @property
    @pulumi.getter(name="moveState")
    def move_state(self) -> str:
        """
        The State of the Resource after the move operation
        """
        return pulumi.get(self, "move_state")

    @property
    @pulumi.getter(name="privateEndpointConnections")
    def private_endpoint_connections(self) -> Sequence['outputs.PrivateEndpointConnectionVaultPropertiesResponse']:
        """
        List of private endpoint connection.
        """
        return pulumi.get(self, "private_endpoint_connections")

    @property
    @pulumi.getter(name="privateEndpointStateForBackup")
    def private_endpoint_state_for_backup(self) -> str:
        """
        Private endpoint state for backup.
        """
        return pulumi.get(self, "private_endpoint_state_for_backup")

    @property
    @pulumi.getter(name="privateEndpointStateForSiteRecovery")
    def private_endpoint_state_for_site_recovery(self) -> str:
        """
        Private endpoint state for site recovery.
        """
        return pulumi.get(self, "private_endpoint_state_for_site_recovery")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        Provisioning State.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def encryption(self) -> Optional['outputs.VaultPropertiesResponseEncryption']:
        """
        Customer Managed Key details of the resource.
        """
        return pulumi.get(self, "encryption")

    @property
    @pulumi.getter(name="monitoringSettings")
    def monitoring_settings(self) -> Optional['outputs.MonitoringSettingsResponse']:
        """
        Monitoring Settings of the vault
        """
        return pulumi.get(self, "monitoring_settings")

    @property
    @pulumi.getter(name="moveDetails")
    def move_details(self) -> Optional['outputs.VaultPropertiesResponseMoveDetails']:
        """
        The details of the latest move operation performed on the Azure Resource
        """
        return pulumi.get(self, "move_details")

    @property
    @pulumi.getter(name="redundancySettings")
    def redundancy_settings(self) -> Optional['outputs.VaultPropertiesResponseRedundancySettings']:
        """
        The redundancy Settings of a Vault
        """
        return pulumi.get(self, "redundancy_settings")

    @property
    @pulumi.getter(name="upgradeDetails")
    def upgrade_details(self) -> Optional['outputs.UpgradeDetailsResponse']:
        """
        Details for upgrading vault.
        """
        return pulumi.get(self, "upgrade_details")


@pulumi.output_type
class VaultPropertiesResponseEncryption(dict):
    """
    Customer Managed Key details of the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "infrastructureEncryption":
            suggest = "infrastructure_encryption"
        elif key == "kekIdentity":
            suggest = "kek_identity"
        elif key == "keyVaultProperties":
            suggest = "key_vault_properties"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VaultPropertiesResponseEncryption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VaultPropertiesResponseEncryption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VaultPropertiesResponseEncryption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 infrastructure_encryption: Optional[str] = None,
                 kek_identity: Optional['outputs.CmkKekIdentityResponse'] = None,
                 key_vault_properties: Optional['outputs.CmkKeyVaultPropertiesResponse'] = None):
        """
        Customer Managed Key details of the resource.
        :param str infrastructure_encryption: Enabling/Disabling the Double Encryption state
        :param 'CmkKekIdentityResponse' kek_identity: The details of the identity used for CMK
        :param 'CmkKeyVaultPropertiesResponse' key_vault_properties: The properties of the Key Vault which hosts CMK
        """
        if infrastructure_encryption is not None:
            pulumi.set(__self__, "infrastructure_encryption", infrastructure_encryption)
        if kek_identity is not None:
            pulumi.set(__self__, "kek_identity", kek_identity)
        if key_vault_properties is not None:
            pulumi.set(__self__, "key_vault_properties", key_vault_properties)

    @property
    @pulumi.getter(name="infrastructureEncryption")
    def infrastructure_encryption(self) -> Optional[str]:
        """
        Enabling/Disabling the Double Encryption state
        """
        return pulumi.get(self, "infrastructure_encryption")

    @property
    @pulumi.getter(name="kekIdentity")
    def kek_identity(self) -> Optional['outputs.CmkKekIdentityResponse']:
        """
        The details of the identity used for CMK
        """
        return pulumi.get(self, "kek_identity")

    @property
    @pulumi.getter(name="keyVaultProperties")
    def key_vault_properties(self) -> Optional['outputs.CmkKeyVaultPropertiesResponse']:
        """
        The properties of the Key Vault which hosts CMK
        """
        return pulumi.get(self, "key_vault_properties")


@pulumi.output_type
class VaultPropertiesResponseMoveDetails(dict):
    """
    The details of the latest move operation performed on the Azure Resource
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "completionTimeUtc":
            suggest = "completion_time_utc"
        elif key == "operationId":
            suggest = "operation_id"
        elif key == "sourceResourceId":
            suggest = "source_resource_id"
        elif key == "startTimeUtc":
            suggest = "start_time_utc"
        elif key == "targetResourceId":
            suggest = "target_resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VaultPropertiesResponseMoveDetails. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VaultPropertiesResponseMoveDetails.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VaultPropertiesResponseMoveDetails.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 completion_time_utc: str,
                 operation_id: str,
                 source_resource_id: str,
                 start_time_utc: str,
                 target_resource_id: str):
        """
        The details of the latest move operation performed on the Azure Resource
        :param str completion_time_utc: End Time of the Resource Move Operation
        :param str operation_id: OperationId of the Resource Move Operation
        :param str source_resource_id: Source Resource of the Resource Move Operation
        :param str start_time_utc: Start Time of the Resource Move Operation
        :param str target_resource_id: Target Resource of the Resource Move Operation
        """
        pulumi.set(__self__, "completion_time_utc", completion_time_utc)
        pulumi.set(__self__, "operation_id", operation_id)
        pulumi.set(__self__, "source_resource_id", source_resource_id)
        pulumi.set(__self__, "start_time_utc", start_time_utc)
        pulumi.set(__self__, "target_resource_id", target_resource_id)

    @property
    @pulumi.getter(name="completionTimeUtc")
    def completion_time_utc(self) -> str:
        """
        End Time of the Resource Move Operation
        """
        return pulumi.get(self, "completion_time_utc")

    @property
    @pulumi.getter(name="operationId")
    def operation_id(self) -> str:
        """
        OperationId of the Resource Move Operation
        """
        return pulumi.get(self, "operation_id")

    @property
    @pulumi.getter(name="sourceResourceId")
    def source_resource_id(self) -> str:
        """
        Source Resource of the Resource Move Operation
        """
        return pulumi.get(self, "source_resource_id")

    @property
    @pulumi.getter(name="startTimeUtc")
    def start_time_utc(self) -> str:
        """
        Start Time of the Resource Move Operation
        """
        return pulumi.get(self, "start_time_utc")

    @property
    @pulumi.getter(name="targetResourceId")
    def target_resource_id(self) -> str:
        """
        Target Resource of the Resource Move Operation
        """
        return pulumi.get(self, "target_resource_id")


@pulumi.output_type
class VaultPropertiesResponseRedundancySettings(dict):
    """
    The redundancy Settings of a Vault
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "crossRegionRestore":
            suggest = "cross_region_restore"
        elif key == "standardTierStorageRedundancy":
            suggest = "standard_tier_storage_redundancy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VaultPropertiesResponseRedundancySettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VaultPropertiesResponseRedundancySettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VaultPropertiesResponseRedundancySettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cross_region_restore: str,
                 standard_tier_storage_redundancy: str):
        """
        The redundancy Settings of a Vault
        :param str cross_region_restore: Flag to show if Cross Region Restore is enabled on the Vault or not
        :param str standard_tier_storage_redundancy: The storage redundancy setting of a vault
        """
        pulumi.set(__self__, "cross_region_restore", cross_region_restore)
        pulumi.set(__self__, "standard_tier_storage_redundancy", standard_tier_storage_redundancy)

    @property
    @pulumi.getter(name="crossRegionRestore")
    def cross_region_restore(self) -> str:
        """
        Flag to show if Cross Region Restore is enabled on the Vault or not
        """
        return pulumi.get(self, "cross_region_restore")

    @property
    @pulumi.getter(name="standardTierStorageRedundancy")
    def standard_tier_storage_redundancy(self) -> str:
        """
        The storage redundancy setting of a vault
        """
        return pulumi.get(self, "standard_tier_storage_redundancy")


@pulumi.output_type
class VersionDetailsResponse(dict):
    """
    Version related details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "expiryDate":
            suggest = "expiry_date"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VersionDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VersionDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VersionDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 expiry_date: Optional[str] = None,
                 status: Optional[str] = None,
                 version: Optional[str] = None):
        """
        Version related details.
        :param str expiry_date: Version expiry date.
        :param str status: A value indicating whether security update required.
        :param str version: The agent version.
        """
        if expiry_date is not None:
            pulumi.set(__self__, "expiry_date", expiry_date)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="expiryDate")
    def expiry_date(self) -> Optional[str]:
        """
        Version expiry date.
        """
        return pulumi.get(self, "expiry_date")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        A value indicating whether security update required.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def version(self) -> Optional[str]:
        """
        The agent version.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class VmmDetailsResponse(dict):
    """
    VMM fabric specific details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceType":
            suggest = "instance_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VmmDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VmmDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VmmDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_type: str):
        """
        VMM fabric specific details.
        :param str instance_type: Gets the class type. Overridden in derived classes.
               Expected value is 'VMM'.
        """
        pulumi.set(__self__, "instance_type", 'VMM')

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> str:
        """
        Gets the class type. Overridden in derived classes.
        Expected value is 'VMM'.
        """
        return pulumi.get(self, "instance_type")


@pulumi.output_type
class VmmToAzureNetworkMappingSettingsResponse(dict):
    """
    E2A Network Mapping fabric specific settings.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceType":
            suggest = "instance_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VmmToAzureNetworkMappingSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VmmToAzureNetworkMappingSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VmmToAzureNetworkMappingSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_type: str):
        """
        E2A Network Mapping fabric specific settings.
        :param str instance_type: Gets the Instance type.
               Expected value is 'VmmToAzure'.
        """
        pulumi.set(__self__, "instance_type", 'VmmToAzure')

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> str:
        """
        Gets the Instance type.
        Expected value is 'VmmToAzure'.
        """
        return pulumi.get(self, "instance_type")


@pulumi.output_type
class VmmToVmmNetworkMappingSettingsResponse(dict):
    """
    E2E Network Mapping fabric specific settings.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceType":
            suggest = "instance_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VmmToVmmNetworkMappingSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VmmToVmmNetworkMappingSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VmmToVmmNetworkMappingSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_type: str):
        """
        E2E Network Mapping fabric specific settings.
        :param str instance_type: Gets the Instance type.
               Expected value is 'VmmToVmm'.
        """
        pulumi.set(__self__, "instance_type", 'VmmToVmm')

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> str:
        """
        Gets the Instance type.
        Expected value is 'VmmToVmm'.
        """
        return pulumi.get(self, "instance_type")


@pulumi.output_type
class VmwareCbtPolicyDetailsResponse(dict):
    """
    VMware Cbt specific policy details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceType":
            suggest = "instance_type"
        elif key == "appConsistentFrequencyInMinutes":
            suggest = "app_consistent_frequency_in_minutes"
        elif key == "crashConsistentFrequencyInMinutes":
            suggest = "crash_consistent_frequency_in_minutes"
        elif key == "recoveryPointHistoryInMinutes":
            suggest = "recovery_point_history_in_minutes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VmwareCbtPolicyDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VmwareCbtPolicyDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VmwareCbtPolicyDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_type: str,
                 app_consistent_frequency_in_minutes: Optional[int] = None,
                 crash_consistent_frequency_in_minutes: Optional[int] = None,
                 recovery_point_history_in_minutes: Optional[int] = None):
        """
        VMware Cbt specific policy details.
        :param str instance_type: Gets the class type. Overridden in derived classes.
               Expected value is 'VMwareCbt'.
        :param int app_consistent_frequency_in_minutes: The app consistent snapshot frequency in minutes.
        :param int crash_consistent_frequency_in_minutes: The crash consistent snapshot frequency in minutes.
        :param int recovery_point_history_in_minutes: The duration in minutes until which the recovery points need to be stored.
        """
        pulumi.set(__self__, "instance_type", 'VMwareCbt')
        if app_consistent_frequency_in_minutes is not None:
            pulumi.set(__self__, "app_consistent_frequency_in_minutes", app_consistent_frequency_in_minutes)
        if crash_consistent_frequency_in_minutes is not None:
            pulumi.set(__self__, "crash_consistent_frequency_in_minutes", crash_consistent_frequency_in_minutes)
        if recovery_point_history_in_minutes is not None:
            pulumi.set(__self__, "recovery_point_history_in_minutes", recovery_point_history_in_minutes)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> str:
        """
        Gets the class type. Overridden in derived classes.
        Expected value is 'VMwareCbt'.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="appConsistentFrequencyInMinutes")
    def app_consistent_frequency_in_minutes(self) -> Optional[int]:
        """
        The app consistent snapshot frequency in minutes.
        """
        return pulumi.get(self, "app_consistent_frequency_in_minutes")

    @property
    @pulumi.getter(name="crashConsistentFrequencyInMinutes")
    def crash_consistent_frequency_in_minutes(self) -> Optional[int]:
        """
        The crash consistent snapshot frequency in minutes.
        """
        return pulumi.get(self, "crash_consistent_frequency_in_minutes")

    @property
    @pulumi.getter(name="recoveryPointHistoryInMinutes")
    def recovery_point_history_in_minutes(self) -> Optional[int]:
        """
        The duration in minutes until which the recovery points need to be stored.
        """
        return pulumi.get(self, "recovery_point_history_in_minutes")


