# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'ApplicationGetEndpointResponse',
    'ApplicationGetHttpsEndpointResponse',
    'ApplicationPropertiesResponse',
    'AutoscaleCapacityResponse',
    'AutoscaleRecurrenceResponse',
    'AutoscaleResponse',
    'AutoscaleScheduleResponse',
    'AutoscaleTimeAndCapacityResponse',
    'ClientGroupInfoResponse',
    'ClusterDefinitionResponse',
    'ClusterGetPropertiesResponse',
    'ClusterIdentityResponse',
    'ComputeIsolationPropertiesResponse',
    'ComputeProfileResponse',
    'ConnectivityEndpointResponse',
    'DataDisksGroupsResponse',
    'DiskEncryptionPropertiesResponse',
    'EncryptionInTransitPropertiesResponse',
    'ErrorsResponse',
    'ExcludedServicesConfigResponse',
    'HardwareProfileResponse',
    'IPConfigurationResponse',
    'KafkaRestPropertiesResponse',
    'LinuxOperatingSystemProfileResponse',
    'NetworkPropertiesResponse',
    'OsProfileResponse',
    'PrivateEndpointConnectionResponse',
    'PrivateEndpointResponse',
    'PrivateLinkConfigurationResponse',
    'PrivateLinkServiceConnectionStateResponse',
    'QuotaInfoResponse',
    'ResourceIdResponse',
    'RoleResponse',
    'RuntimeScriptActionResponse',
    'ScriptActionResponse',
    'SecurityProfileResponse',
    'SshProfileResponse',
    'SshPublicKeyResponse',
    'StorageAccountResponse',
    'StorageProfileResponse',
    'SystemDataResponse',
    'UserAssignedIdentityResponse',
    'VirtualNetworkProfileResponse',
]

@pulumi.output_type
class ApplicationGetEndpointResponse(dict):
    """
    Gets the application SSH endpoint
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "destinationPort":
            suggest = "destination_port"
        elif key == "privateIPAddress":
            suggest = "private_ip_address"
        elif key == "publicPort":
            suggest = "public_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationGetEndpointResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationGetEndpointResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationGetEndpointResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 destination_port: Optional[int] = None,
                 location: Optional[str] = None,
                 private_ip_address: Optional[str] = None,
                 public_port: Optional[int] = None):
        """
        Gets the application SSH endpoint
        :param int destination_port: The destination port to connect to.
        :param str location: The location of the endpoint.
        :param str private_ip_address: The private ip address of the endpoint.
        :param int public_port: The public port to connect to.
        """
        if destination_port is not None:
            pulumi.set(__self__, "destination_port", destination_port)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if private_ip_address is not None:
            pulumi.set(__self__, "private_ip_address", private_ip_address)
        if public_port is not None:
            pulumi.set(__self__, "public_port", public_port)

    @property
    @pulumi.getter(name="destinationPort")
    def destination_port(self) -> Optional[int]:
        """
        The destination port to connect to.
        """
        return pulumi.get(self, "destination_port")

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        The location of the endpoint.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="privateIPAddress")
    def private_ip_address(self) -> Optional[str]:
        """
        The private ip address of the endpoint.
        """
        return pulumi.get(self, "private_ip_address")

    @property
    @pulumi.getter(name="publicPort")
    def public_port(self) -> Optional[int]:
        """
        The public port to connect to.
        """
        return pulumi.get(self, "public_port")


@pulumi.output_type
class ApplicationGetHttpsEndpointResponse(dict):
    """
    Gets the application HTTP endpoints.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "publicPort":
            suggest = "public_port"
        elif key == "accessModes":
            suggest = "access_modes"
        elif key == "destinationPort":
            suggest = "destination_port"
        elif key == "disableGatewayAuth":
            suggest = "disable_gateway_auth"
        elif key == "privateIPAddress":
            suggest = "private_ip_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationGetHttpsEndpointResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationGetHttpsEndpointResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationGetHttpsEndpointResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 location: str,
                 public_port: int,
                 access_modes: Optional[Sequence[str]] = None,
                 destination_port: Optional[int] = None,
                 disable_gateway_auth: Optional[bool] = None,
                 private_ip_address: Optional[str] = None):
        """
        Gets the application HTTP endpoints.
        :param str location: The location of the endpoint.
        :param int public_port: The public port to connect to.
        :param Sequence[str] access_modes: The list of access modes for the application.
        :param int destination_port: The destination port to connect to.
        :param bool disable_gateway_auth: The value indicates whether to disable GatewayAuth.
        :param str private_ip_address: The private ip address of the endpoint.
        """
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "public_port", public_port)
        if access_modes is not None:
            pulumi.set(__self__, "access_modes", access_modes)
        if destination_port is not None:
            pulumi.set(__self__, "destination_port", destination_port)
        if disable_gateway_auth is not None:
            pulumi.set(__self__, "disable_gateway_auth", disable_gateway_auth)
        if private_ip_address is not None:
            pulumi.set(__self__, "private_ip_address", private_ip_address)

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        The location of the endpoint.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="publicPort")
    def public_port(self) -> int:
        """
        The public port to connect to.
        """
        return pulumi.get(self, "public_port")

    @property
    @pulumi.getter(name="accessModes")
    def access_modes(self) -> Optional[Sequence[str]]:
        """
        The list of access modes for the application.
        """
        return pulumi.get(self, "access_modes")

    @property
    @pulumi.getter(name="destinationPort")
    def destination_port(self) -> Optional[int]:
        """
        The destination port to connect to.
        """
        return pulumi.get(self, "destination_port")

    @property
    @pulumi.getter(name="disableGatewayAuth")
    def disable_gateway_auth(self) -> Optional[bool]:
        """
        The value indicates whether to disable GatewayAuth.
        """
        return pulumi.get(self, "disable_gateway_auth")

    @property
    @pulumi.getter(name="privateIPAddress")
    def private_ip_address(self) -> Optional[str]:
        """
        The private ip address of the endpoint.
        """
        return pulumi.get(self, "private_ip_address")


@pulumi.output_type
class ApplicationPropertiesResponse(dict):
    """
    The HDInsight cluster application GET response.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "applicationState":
            suggest = "application_state"
        elif key == "createdDate":
            suggest = "created_date"
        elif key == "marketplaceIdentifier":
            suggest = "marketplace_identifier"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "applicationType":
            suggest = "application_type"
        elif key == "computeProfile":
            suggest = "compute_profile"
        elif key == "httpsEndpoints":
            suggest = "https_endpoints"
        elif key == "installScriptActions":
            suggest = "install_script_actions"
        elif key == "privateLinkConfigurations":
            suggest = "private_link_configurations"
        elif key == "sshEndpoints":
            suggest = "ssh_endpoints"
        elif key == "uninstallScriptActions":
            suggest = "uninstall_script_actions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 application_state: str,
                 created_date: str,
                 marketplace_identifier: str,
                 provisioning_state: str,
                 application_type: Optional[str] = None,
                 compute_profile: Optional['outputs.ComputeProfileResponse'] = None,
                 errors: Optional[Sequence['outputs.ErrorsResponse']] = None,
                 https_endpoints: Optional[Sequence['outputs.ApplicationGetHttpsEndpointResponse']] = None,
                 install_script_actions: Optional[Sequence['outputs.RuntimeScriptActionResponse']] = None,
                 private_link_configurations: Optional[Sequence['outputs.PrivateLinkConfigurationResponse']] = None,
                 ssh_endpoints: Optional[Sequence['outputs.ApplicationGetEndpointResponse']] = None,
                 uninstall_script_actions: Optional[Sequence['outputs.RuntimeScriptActionResponse']] = None):
        """
        The HDInsight cluster application GET response.
        :param str application_state: The application state.
        :param str created_date: The application create date time.
        :param str marketplace_identifier: The marketplace identifier.
        :param str provisioning_state: The provisioning state of the application.
        :param str application_type: The application type.
        :param 'ComputeProfileResponse' compute_profile: The list of roles in the cluster.
        :param Sequence['ErrorsResponse'] errors: The list of errors.
        :param Sequence['ApplicationGetHttpsEndpointResponse'] https_endpoints: The list of application HTTPS endpoints.
        :param Sequence['RuntimeScriptActionResponse'] install_script_actions: The list of install script actions.
        :param Sequence['PrivateLinkConfigurationResponse'] private_link_configurations: The private link configurations.
        :param Sequence['ApplicationGetEndpointResponse'] ssh_endpoints: The list of application SSH endpoints.
        :param Sequence['RuntimeScriptActionResponse'] uninstall_script_actions: The list of uninstall script actions.
        """
        pulumi.set(__self__, "application_state", application_state)
        pulumi.set(__self__, "created_date", created_date)
        pulumi.set(__self__, "marketplace_identifier", marketplace_identifier)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if application_type is not None:
            pulumi.set(__self__, "application_type", application_type)
        if compute_profile is not None:
            pulumi.set(__self__, "compute_profile", compute_profile)
        if errors is not None:
            pulumi.set(__self__, "errors", errors)
        if https_endpoints is not None:
            pulumi.set(__self__, "https_endpoints", https_endpoints)
        if install_script_actions is not None:
            pulumi.set(__self__, "install_script_actions", install_script_actions)
        if private_link_configurations is not None:
            pulumi.set(__self__, "private_link_configurations", private_link_configurations)
        if ssh_endpoints is not None:
            pulumi.set(__self__, "ssh_endpoints", ssh_endpoints)
        if uninstall_script_actions is not None:
            pulumi.set(__self__, "uninstall_script_actions", uninstall_script_actions)

    @property
    @pulumi.getter(name="applicationState")
    def application_state(self) -> str:
        """
        The application state.
        """
        return pulumi.get(self, "application_state")

    @property
    @pulumi.getter(name="createdDate")
    def created_date(self) -> str:
        """
        The application create date time.
        """
        return pulumi.get(self, "created_date")

    @property
    @pulumi.getter(name="marketplaceIdentifier")
    def marketplace_identifier(self) -> str:
        """
        The marketplace identifier.
        """
        return pulumi.get(self, "marketplace_identifier")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the application.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="applicationType")
    def application_type(self) -> Optional[str]:
        """
        The application type.
        """
        return pulumi.get(self, "application_type")

    @property
    @pulumi.getter(name="computeProfile")
    def compute_profile(self) -> Optional['outputs.ComputeProfileResponse']:
        """
        The list of roles in the cluster.
        """
        return pulumi.get(self, "compute_profile")

    @property
    @pulumi.getter
    def errors(self) -> Optional[Sequence['outputs.ErrorsResponse']]:
        """
        The list of errors.
        """
        return pulumi.get(self, "errors")

    @property
    @pulumi.getter(name="httpsEndpoints")
    def https_endpoints(self) -> Optional[Sequence['outputs.ApplicationGetHttpsEndpointResponse']]:
        """
        The list of application HTTPS endpoints.
        """
        return pulumi.get(self, "https_endpoints")

    @property
    @pulumi.getter(name="installScriptActions")
    def install_script_actions(self) -> Optional[Sequence['outputs.RuntimeScriptActionResponse']]:
        """
        The list of install script actions.
        """
        return pulumi.get(self, "install_script_actions")

    @property
    @pulumi.getter(name="privateLinkConfigurations")
    def private_link_configurations(self) -> Optional[Sequence['outputs.PrivateLinkConfigurationResponse']]:
        """
        The private link configurations.
        """
        return pulumi.get(self, "private_link_configurations")

    @property
    @pulumi.getter(name="sshEndpoints")
    def ssh_endpoints(self) -> Optional[Sequence['outputs.ApplicationGetEndpointResponse']]:
        """
        The list of application SSH endpoints.
        """
        return pulumi.get(self, "ssh_endpoints")

    @property
    @pulumi.getter(name="uninstallScriptActions")
    def uninstall_script_actions(self) -> Optional[Sequence['outputs.RuntimeScriptActionResponse']]:
        """
        The list of uninstall script actions.
        """
        return pulumi.get(self, "uninstall_script_actions")


@pulumi.output_type
class AutoscaleCapacityResponse(dict):
    """
    The load-based autoscale request parameters
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxInstanceCount":
            suggest = "max_instance_count"
        elif key == "minInstanceCount":
            suggest = "min_instance_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AutoscaleCapacityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AutoscaleCapacityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AutoscaleCapacityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_instance_count: Optional[int] = None,
                 min_instance_count: Optional[int] = None):
        """
        The load-based autoscale request parameters
        :param int max_instance_count: The maximum instance count of the cluster
        :param int min_instance_count: The minimum instance count of the cluster
        """
        if max_instance_count is not None:
            pulumi.set(__self__, "max_instance_count", max_instance_count)
        if min_instance_count is not None:
            pulumi.set(__self__, "min_instance_count", min_instance_count)

    @property
    @pulumi.getter(name="maxInstanceCount")
    def max_instance_count(self) -> Optional[int]:
        """
        The maximum instance count of the cluster
        """
        return pulumi.get(self, "max_instance_count")

    @property
    @pulumi.getter(name="minInstanceCount")
    def min_instance_count(self) -> Optional[int]:
        """
        The minimum instance count of the cluster
        """
        return pulumi.get(self, "min_instance_count")


@pulumi.output_type
class AutoscaleRecurrenceResponse(dict):
    """
    Schedule-based autoscale request parameters
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "timeZone":
            suggest = "time_zone"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AutoscaleRecurrenceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AutoscaleRecurrenceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AutoscaleRecurrenceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 schedule: Optional[Sequence['outputs.AutoscaleScheduleResponse']] = None,
                 time_zone: Optional[str] = None):
        """
        Schedule-based autoscale request parameters
        :param Sequence['AutoscaleScheduleResponse'] schedule: Array of schedule-based autoscale rules
        :param str time_zone: The time zone for the autoscale schedule times
        """
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)

    @property
    @pulumi.getter
    def schedule(self) -> Optional[Sequence['outputs.AutoscaleScheduleResponse']]:
        """
        Array of schedule-based autoscale rules
        """
        return pulumi.get(self, "schedule")

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[str]:
        """
        The time zone for the autoscale schedule times
        """
        return pulumi.get(self, "time_zone")


@pulumi.output_type
class AutoscaleResponse(dict):
    """
    The autoscale request parameters
    """
    def __init__(__self__, *,
                 capacity: Optional['outputs.AutoscaleCapacityResponse'] = None,
                 recurrence: Optional['outputs.AutoscaleRecurrenceResponse'] = None):
        """
        The autoscale request parameters
        :param 'AutoscaleCapacityResponse' capacity: Parameters for load-based autoscale
        :param 'AutoscaleRecurrenceResponse' recurrence: Parameters for schedule-based autoscale
        """
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if recurrence is not None:
            pulumi.set(__self__, "recurrence", recurrence)

    @property
    @pulumi.getter
    def capacity(self) -> Optional['outputs.AutoscaleCapacityResponse']:
        """
        Parameters for load-based autoscale
        """
        return pulumi.get(self, "capacity")

    @property
    @pulumi.getter
    def recurrence(self) -> Optional['outputs.AutoscaleRecurrenceResponse']:
        """
        Parameters for schedule-based autoscale
        """
        return pulumi.get(self, "recurrence")


@pulumi.output_type
class AutoscaleScheduleResponse(dict):
    """
    Parameters for a schedule-based autoscale rule, consisting of an array of days + a time and capacity
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "timeAndCapacity":
            suggest = "time_and_capacity"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AutoscaleScheduleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AutoscaleScheduleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AutoscaleScheduleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 days: Optional[Sequence[str]] = None,
                 time_and_capacity: Optional['outputs.AutoscaleTimeAndCapacityResponse'] = None):
        """
        Parameters for a schedule-based autoscale rule, consisting of an array of days + a time and capacity
        :param Sequence[str] days: Days of the week for a schedule-based autoscale rule
        :param 'AutoscaleTimeAndCapacityResponse' time_and_capacity: Time and capacity for a schedule-based autoscale rule
        """
        if days is not None:
            pulumi.set(__self__, "days", days)
        if time_and_capacity is not None:
            pulumi.set(__self__, "time_and_capacity", time_and_capacity)

    @property
    @pulumi.getter
    def days(self) -> Optional[Sequence[str]]:
        """
        Days of the week for a schedule-based autoscale rule
        """
        return pulumi.get(self, "days")

    @property
    @pulumi.getter(name="timeAndCapacity")
    def time_and_capacity(self) -> Optional['outputs.AutoscaleTimeAndCapacityResponse']:
        """
        Time and capacity for a schedule-based autoscale rule
        """
        return pulumi.get(self, "time_and_capacity")


@pulumi.output_type
class AutoscaleTimeAndCapacityResponse(dict):
    """
    Time and capacity request parameters
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxInstanceCount":
            suggest = "max_instance_count"
        elif key == "minInstanceCount":
            suggest = "min_instance_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AutoscaleTimeAndCapacityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AutoscaleTimeAndCapacityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AutoscaleTimeAndCapacityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_instance_count: Optional[int] = None,
                 min_instance_count: Optional[int] = None,
                 time: Optional[str] = None):
        """
        Time and capacity request parameters
        :param int max_instance_count: The maximum instance count of the cluster
        :param int min_instance_count: The minimum instance count of the cluster
        :param str time: 24-hour time in the form xx:xx
        """
        if max_instance_count is not None:
            pulumi.set(__self__, "max_instance_count", max_instance_count)
        if min_instance_count is not None:
            pulumi.set(__self__, "min_instance_count", min_instance_count)
        if time is not None:
            pulumi.set(__self__, "time", time)

    @property
    @pulumi.getter(name="maxInstanceCount")
    def max_instance_count(self) -> Optional[int]:
        """
        The maximum instance count of the cluster
        """
        return pulumi.get(self, "max_instance_count")

    @property
    @pulumi.getter(name="minInstanceCount")
    def min_instance_count(self) -> Optional[int]:
        """
        The minimum instance count of the cluster
        """
        return pulumi.get(self, "min_instance_count")

    @property
    @pulumi.getter
    def time(self) -> Optional[str]:
        """
        24-hour time in the form xx:xx
        """
        return pulumi.get(self, "time")


@pulumi.output_type
class ClientGroupInfoResponse(dict):
    """
    The information of AAD security group.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "groupId":
            suggest = "group_id"
        elif key == "groupName":
            suggest = "group_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClientGroupInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClientGroupInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClientGroupInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 group_id: Optional[str] = None,
                 group_name: Optional[str] = None):
        """
        The information of AAD security group.
        :param str group_id: The AAD security group id.
        :param str group_name: The AAD security group name.
        """
        if group_id is not None:
            pulumi.set(__self__, "group_id", group_id)
        if group_name is not None:
            pulumi.set(__self__, "group_name", group_name)

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> Optional[str]:
        """
        The AAD security group id.
        """
        return pulumi.get(self, "group_id")

    @property
    @pulumi.getter(name="groupName")
    def group_name(self) -> Optional[str]:
        """
        The AAD security group name.
        """
        return pulumi.get(self, "group_name")


@pulumi.output_type
class ClusterDefinitionResponse(dict):
    """
    The cluster definition.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "componentVersion":
            suggest = "component_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterDefinitionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterDefinitionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterDefinitionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 blueprint: Optional[str] = None,
                 component_version: Optional[Mapping[str, str]] = None,
                 configurations: Optional[Any] = None,
                 kind: Optional[str] = None):
        """
        The cluster definition.
        :param str blueprint: The link to the blueprint.
        :param Mapping[str, str] component_version: The versions of different services in the cluster.
        :param Any configurations: The cluster configurations.
        :param str kind: The type of cluster.
        """
        if blueprint is not None:
            pulumi.set(__self__, "blueprint", blueprint)
        if component_version is not None:
            pulumi.set(__self__, "component_version", component_version)
        if configurations is not None:
            pulumi.set(__self__, "configurations", configurations)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)

    @property
    @pulumi.getter
    def blueprint(self) -> Optional[str]:
        """
        The link to the blueprint.
        """
        return pulumi.get(self, "blueprint")

    @property
    @pulumi.getter(name="componentVersion")
    def component_version(self) -> Optional[Mapping[str, str]]:
        """
        The versions of different services in the cluster.
        """
        return pulumi.get(self, "component_version")

    @property
    @pulumi.getter
    def configurations(self) -> Optional[Any]:
        """
        The cluster configurations.
        """
        return pulumi.get(self, "configurations")

    @property
    @pulumi.getter
    def kind(self) -> Optional[str]:
        """
        The type of cluster.
        """
        return pulumi.get(self, "kind")


@pulumi.output_type
class ClusterGetPropertiesResponse(dict):
    """
    The properties of cluster.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clusterDefinition":
            suggest = "cluster_definition"
        elif key == "privateEndpointConnections":
            suggest = "private_endpoint_connections"
        elif key == "clusterHdpVersion":
            suggest = "cluster_hdp_version"
        elif key == "clusterId":
            suggest = "cluster_id"
        elif key == "clusterState":
            suggest = "cluster_state"
        elif key == "clusterVersion":
            suggest = "cluster_version"
        elif key == "computeIsolationProperties":
            suggest = "compute_isolation_properties"
        elif key == "computeProfile":
            suggest = "compute_profile"
        elif key == "connectivityEndpoints":
            suggest = "connectivity_endpoints"
        elif key == "createdDate":
            suggest = "created_date"
        elif key == "diskEncryptionProperties":
            suggest = "disk_encryption_properties"
        elif key == "encryptionInTransitProperties":
            suggest = "encryption_in_transit_properties"
        elif key == "excludedServicesConfig":
            suggest = "excluded_services_config"
        elif key == "kafkaRestProperties":
            suggest = "kafka_rest_properties"
        elif key == "minSupportedTlsVersion":
            suggest = "min_supported_tls_version"
        elif key == "networkProperties":
            suggest = "network_properties"
        elif key == "osType":
            suggest = "os_type"
        elif key == "privateLinkConfigurations":
            suggest = "private_link_configurations"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "quotaInfo":
            suggest = "quota_info"
        elif key == "securityProfile":
            suggest = "security_profile"
        elif key == "storageProfile":
            suggest = "storage_profile"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterGetPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterGetPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterGetPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cluster_definition: 'outputs.ClusterDefinitionResponse',
                 private_endpoint_connections: Sequence['outputs.PrivateEndpointConnectionResponse'],
                 cluster_hdp_version: Optional[str] = None,
                 cluster_id: Optional[str] = None,
                 cluster_state: Optional[str] = None,
                 cluster_version: Optional[str] = None,
                 compute_isolation_properties: Optional['outputs.ComputeIsolationPropertiesResponse'] = None,
                 compute_profile: Optional['outputs.ComputeProfileResponse'] = None,
                 connectivity_endpoints: Optional[Sequence['outputs.ConnectivityEndpointResponse']] = None,
                 created_date: Optional[str] = None,
                 disk_encryption_properties: Optional['outputs.DiskEncryptionPropertiesResponse'] = None,
                 encryption_in_transit_properties: Optional['outputs.EncryptionInTransitPropertiesResponse'] = None,
                 errors: Optional[Sequence['outputs.ErrorsResponse']] = None,
                 excluded_services_config: Optional['outputs.ExcludedServicesConfigResponse'] = None,
                 kafka_rest_properties: Optional['outputs.KafkaRestPropertiesResponse'] = None,
                 min_supported_tls_version: Optional[str] = None,
                 network_properties: Optional['outputs.NetworkPropertiesResponse'] = None,
                 os_type: Optional[str] = None,
                 private_link_configurations: Optional[Sequence['outputs.PrivateLinkConfigurationResponse']] = None,
                 provisioning_state: Optional[str] = None,
                 quota_info: Optional['outputs.QuotaInfoResponse'] = None,
                 security_profile: Optional['outputs.SecurityProfileResponse'] = None,
                 storage_profile: Optional['outputs.StorageProfileResponse'] = None,
                 tier: Optional[str] = None):
        """
        The properties of cluster.
        :param 'ClusterDefinitionResponse' cluster_definition: The cluster definition.
        :param Sequence['PrivateEndpointConnectionResponse'] private_endpoint_connections: The list of private endpoint connections.
        :param str cluster_hdp_version: The hdp version of the cluster.
        :param str cluster_id: The cluster id.
        :param str cluster_state: The state of the cluster.
        :param str cluster_version: The version of the cluster.
        :param 'ComputeIsolationPropertiesResponse' compute_isolation_properties: The compute isolation properties.
        :param 'ComputeProfileResponse' compute_profile: The compute profile.
        :param Sequence['ConnectivityEndpointResponse'] connectivity_endpoints: The list of connectivity endpoints.
        :param str created_date: The date on which the cluster was created.
        :param 'DiskEncryptionPropertiesResponse' disk_encryption_properties: The disk encryption properties.
        :param 'EncryptionInTransitPropertiesResponse' encryption_in_transit_properties: The encryption-in-transit properties.
        :param Sequence['ErrorsResponse'] errors: The list of errors.
        :param 'ExcludedServicesConfigResponse' excluded_services_config: The excluded services config.
        :param 'KafkaRestPropertiesResponse' kafka_rest_properties: The cluster kafka rest proxy configuration.
        :param str min_supported_tls_version: The minimal supported tls version.
        :param 'NetworkPropertiesResponse' network_properties: The network properties.
        :param str os_type: The type of operating system.
        :param Sequence['PrivateLinkConfigurationResponse'] private_link_configurations: The private link configurations.
        :param str provisioning_state: The provisioning state, which only appears in the response.
        :param 'QuotaInfoResponse' quota_info: The quota information.
        :param 'SecurityProfileResponse' security_profile: The security profile.
        :param 'StorageProfileResponse' storage_profile: The storage profile.
        :param str tier: The cluster tier.
        """
        pulumi.set(__self__, "cluster_definition", cluster_definition)
        pulumi.set(__self__, "private_endpoint_connections", private_endpoint_connections)
        if cluster_hdp_version is not None:
            pulumi.set(__self__, "cluster_hdp_version", cluster_hdp_version)
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)
        if cluster_state is not None:
            pulumi.set(__self__, "cluster_state", cluster_state)
        if cluster_version is not None:
            pulumi.set(__self__, "cluster_version", cluster_version)
        if compute_isolation_properties is not None:
            pulumi.set(__self__, "compute_isolation_properties", compute_isolation_properties)
        if compute_profile is not None:
            pulumi.set(__self__, "compute_profile", compute_profile)
        if connectivity_endpoints is not None:
            pulumi.set(__self__, "connectivity_endpoints", connectivity_endpoints)
        if created_date is not None:
            pulumi.set(__self__, "created_date", created_date)
        if disk_encryption_properties is not None:
            pulumi.set(__self__, "disk_encryption_properties", disk_encryption_properties)
        if encryption_in_transit_properties is not None:
            pulumi.set(__self__, "encryption_in_transit_properties", encryption_in_transit_properties)
        if errors is not None:
            pulumi.set(__self__, "errors", errors)
        if excluded_services_config is not None:
            pulumi.set(__self__, "excluded_services_config", excluded_services_config)
        if kafka_rest_properties is not None:
            pulumi.set(__self__, "kafka_rest_properties", kafka_rest_properties)
        if min_supported_tls_version is not None:
            pulumi.set(__self__, "min_supported_tls_version", min_supported_tls_version)
        if network_properties is not None:
            pulumi.set(__self__, "network_properties", network_properties)
        if os_type is not None:
            pulumi.set(__self__, "os_type", os_type)
        if private_link_configurations is not None:
            pulumi.set(__self__, "private_link_configurations", private_link_configurations)
        if provisioning_state is not None:
            pulumi.set(__self__, "provisioning_state", provisioning_state)
        if quota_info is not None:
            pulumi.set(__self__, "quota_info", quota_info)
        if security_profile is not None:
            pulumi.set(__self__, "security_profile", security_profile)
        if storage_profile is not None:
            pulumi.set(__self__, "storage_profile", storage_profile)
        if tier is not None:
            pulumi.set(__self__, "tier", tier)

    @property
    @pulumi.getter(name="clusterDefinition")
    def cluster_definition(self) -> 'outputs.ClusterDefinitionResponse':
        """
        The cluster definition.
        """
        return pulumi.get(self, "cluster_definition")

    @property
    @pulumi.getter(name="privateEndpointConnections")
    def private_endpoint_connections(self) -> Sequence['outputs.PrivateEndpointConnectionResponse']:
        """
        The list of private endpoint connections.
        """
        return pulumi.get(self, "private_endpoint_connections")

    @property
    @pulumi.getter(name="clusterHdpVersion")
    def cluster_hdp_version(self) -> Optional[str]:
        """
        The hdp version of the cluster.
        """
        return pulumi.get(self, "cluster_hdp_version")

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[str]:
        """
        The cluster id.
        """
        return pulumi.get(self, "cluster_id")

    @property
    @pulumi.getter(name="clusterState")
    def cluster_state(self) -> Optional[str]:
        """
        The state of the cluster.
        """
        return pulumi.get(self, "cluster_state")

    @property
    @pulumi.getter(name="clusterVersion")
    def cluster_version(self) -> Optional[str]:
        """
        The version of the cluster.
        """
        return pulumi.get(self, "cluster_version")

    @property
    @pulumi.getter(name="computeIsolationProperties")
    def compute_isolation_properties(self) -> Optional['outputs.ComputeIsolationPropertiesResponse']:
        """
        The compute isolation properties.
        """
        return pulumi.get(self, "compute_isolation_properties")

    @property
    @pulumi.getter(name="computeProfile")
    def compute_profile(self) -> Optional['outputs.ComputeProfileResponse']:
        """
        The compute profile.
        """
        return pulumi.get(self, "compute_profile")

    @property
    @pulumi.getter(name="connectivityEndpoints")
    def connectivity_endpoints(self) -> Optional[Sequence['outputs.ConnectivityEndpointResponse']]:
        """
        The list of connectivity endpoints.
        """
        return pulumi.get(self, "connectivity_endpoints")

    @property
    @pulumi.getter(name="createdDate")
    def created_date(self) -> Optional[str]:
        """
        The date on which the cluster was created.
        """
        return pulumi.get(self, "created_date")

    @property
    @pulumi.getter(name="diskEncryptionProperties")
    def disk_encryption_properties(self) -> Optional['outputs.DiskEncryptionPropertiesResponse']:
        """
        The disk encryption properties.
        """
        return pulumi.get(self, "disk_encryption_properties")

    @property
    @pulumi.getter(name="encryptionInTransitProperties")
    def encryption_in_transit_properties(self) -> Optional['outputs.EncryptionInTransitPropertiesResponse']:
        """
        The encryption-in-transit properties.
        """
        return pulumi.get(self, "encryption_in_transit_properties")

    @property
    @pulumi.getter
    def errors(self) -> Optional[Sequence['outputs.ErrorsResponse']]:
        """
        The list of errors.
        """
        return pulumi.get(self, "errors")

    @property
    @pulumi.getter(name="excludedServicesConfig")
    def excluded_services_config(self) -> Optional['outputs.ExcludedServicesConfigResponse']:
        """
        The excluded services config.
        """
        return pulumi.get(self, "excluded_services_config")

    @property
    @pulumi.getter(name="kafkaRestProperties")
    def kafka_rest_properties(self) -> Optional['outputs.KafkaRestPropertiesResponse']:
        """
        The cluster kafka rest proxy configuration.
        """
        return pulumi.get(self, "kafka_rest_properties")

    @property
    @pulumi.getter(name="minSupportedTlsVersion")
    def min_supported_tls_version(self) -> Optional[str]:
        """
        The minimal supported tls version.
        """
        return pulumi.get(self, "min_supported_tls_version")

    @property
    @pulumi.getter(name="networkProperties")
    def network_properties(self) -> Optional['outputs.NetworkPropertiesResponse']:
        """
        The network properties.
        """
        return pulumi.get(self, "network_properties")

    @property
    @pulumi.getter(name="osType")
    def os_type(self) -> Optional[str]:
        """
        The type of operating system.
        """
        return pulumi.get(self, "os_type")

    @property
    @pulumi.getter(name="privateLinkConfigurations")
    def private_link_configurations(self) -> Optional[Sequence['outputs.PrivateLinkConfigurationResponse']]:
        """
        The private link configurations.
        """
        return pulumi.get(self, "private_link_configurations")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> Optional[str]:
        """
        The provisioning state, which only appears in the response.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="quotaInfo")
    def quota_info(self) -> Optional['outputs.QuotaInfoResponse']:
        """
        The quota information.
        """
        return pulumi.get(self, "quota_info")

    @property
    @pulumi.getter(name="securityProfile")
    def security_profile(self) -> Optional['outputs.SecurityProfileResponse']:
        """
        The security profile.
        """
        return pulumi.get(self, "security_profile")

    @property
    @pulumi.getter(name="storageProfile")
    def storage_profile(self) -> Optional['outputs.StorageProfileResponse']:
        """
        The storage profile.
        """
        return pulumi.get(self, "storage_profile")

    @property
    @pulumi.getter
    def tier(self) -> Optional[str]:
        """
        The cluster tier.
        """
        return pulumi.get(self, "tier")


@pulumi.output_type
class ClusterIdentityResponse(dict):
    """
    Identity for the cluster.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"
        elif key == "userAssignedIdentities":
            suggest = "user_assigned_identities"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterIdentityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterIdentityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterIdentityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 principal_id: str,
                 tenant_id: str,
                 type: Optional[str] = None,
                 user_assigned_identities: Optional[Mapping[str, 'outputs.UserAssignedIdentityResponse']] = None):
        """
        Identity for the cluster.
        :param str principal_id: The principal id of cluster identity. This property will only be provided for a system assigned identity.
        :param str tenant_id: The tenant id associated with the cluster. This property will only be provided for a system assigned identity.
        :param str type: The type of identity used for the cluster. The type 'SystemAssigned, UserAssigned' includes both an implicitly created identity and a set of user assigned identities.
        :param Mapping[str, 'UserAssignedIdentityResponse'] user_assigned_identities: The list of user identities associated with the cluster. The user identity dictionary key references will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
        """
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if user_assigned_identities is not None:
            pulumi.set(__self__, "user_assigned_identities", user_assigned_identities)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> str:
        """
        The principal id of cluster identity. This property will only be provided for a system assigned identity.
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> str:
        """
        The tenant id associated with the cluster. This property will only be provided for a system assigned identity.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of identity used for the cluster. The type 'SystemAssigned, UserAssigned' includes both an implicitly created identity and a set of user assigned identities.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="userAssignedIdentities")
    def user_assigned_identities(self) -> Optional[Mapping[str, 'outputs.UserAssignedIdentityResponse']]:
        """
        The list of user identities associated with the cluster. The user identity dictionary key references will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
        """
        return pulumi.get(self, "user_assigned_identities")


@pulumi.output_type
class ComputeIsolationPropertiesResponse(dict):
    """
    The compute isolation properties.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enableComputeIsolation":
            suggest = "enable_compute_isolation"
        elif key == "hostSku":
            suggest = "host_sku"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ComputeIsolationPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ComputeIsolationPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ComputeIsolationPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable_compute_isolation: Optional[bool] = None,
                 host_sku: Optional[str] = None):
        """
        The compute isolation properties.
        :param bool enable_compute_isolation: The flag indicates whether enable compute isolation or not.
        :param str host_sku: The host sku.
        """
        if enable_compute_isolation is None:
            enable_compute_isolation = False
        if enable_compute_isolation is not None:
            pulumi.set(__self__, "enable_compute_isolation", enable_compute_isolation)
        if host_sku is not None:
            pulumi.set(__self__, "host_sku", host_sku)

    @property
    @pulumi.getter(name="enableComputeIsolation")
    def enable_compute_isolation(self) -> Optional[bool]:
        """
        The flag indicates whether enable compute isolation or not.
        """
        return pulumi.get(self, "enable_compute_isolation")

    @property
    @pulumi.getter(name="hostSku")
    def host_sku(self) -> Optional[str]:
        """
        The host sku.
        """
        return pulumi.get(self, "host_sku")


@pulumi.output_type
class ComputeProfileResponse(dict):
    """
    Describes the compute profile.
    """
    def __init__(__self__, *,
                 roles: Optional[Sequence['outputs.RoleResponse']] = None):
        """
        Describes the compute profile.
        :param Sequence['RoleResponse'] roles: The list of roles in the cluster.
        """
        if roles is not None:
            pulumi.set(__self__, "roles", roles)

    @property
    @pulumi.getter
    def roles(self) -> Optional[Sequence['outputs.RoleResponse']]:
        """
        The list of roles in the cluster.
        """
        return pulumi.get(self, "roles")


@pulumi.output_type
class ConnectivityEndpointResponse(dict):
    """
    The connectivity properties
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "privateIPAddress":
            suggest = "private_ip_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectivityEndpointResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectivityEndpointResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectivityEndpointResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 location: Optional[str] = None,
                 name: Optional[str] = None,
                 port: Optional[int] = None,
                 private_ip_address: Optional[str] = None,
                 protocol: Optional[str] = None):
        """
        The connectivity properties
        :param str location: The location of the endpoint.
        :param str name: The name of the endpoint.
        :param int port: The port to connect to.
        :param str private_ip_address: The private ip address of the endpoint.
        :param str protocol: The protocol of the endpoint.
        """
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if private_ip_address is not None:
            pulumi.set(__self__, "private_ip_address", private_ip_address)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        The location of the endpoint.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the endpoint.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        The port to connect to.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="privateIPAddress")
    def private_ip_address(self) -> Optional[str]:
        """
        The private ip address of the endpoint.
        """
        return pulumi.get(self, "private_ip_address")

    @property
    @pulumi.getter
    def protocol(self) -> Optional[str]:
        """
        The protocol of the endpoint.
        """
        return pulumi.get(self, "protocol")


@pulumi.output_type
class DataDisksGroupsResponse(dict):
    """
    The data disks groups for the role.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "diskSizeGB":
            suggest = "disk_size_gb"
        elif key == "storageAccountType":
            suggest = "storage_account_type"
        elif key == "disksPerNode":
            suggest = "disks_per_node"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataDisksGroupsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataDisksGroupsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataDisksGroupsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disk_size_gb: int,
                 storage_account_type: str,
                 disks_per_node: Optional[int] = None):
        """
        The data disks groups for the role.
        :param int disk_size_gb: ReadOnly. The DiskSize in GB. Do not set this value.
        :param str storage_account_type: ReadOnly. The storage account type. Do not set this value.
        :param int disks_per_node: The number of disks per node.
        """
        pulumi.set(__self__, "disk_size_gb", disk_size_gb)
        pulumi.set(__self__, "storage_account_type", storage_account_type)
        if disks_per_node is not None:
            pulumi.set(__self__, "disks_per_node", disks_per_node)

    @property
    @pulumi.getter(name="diskSizeGB")
    def disk_size_gb(self) -> int:
        """
        ReadOnly. The DiskSize in GB. Do not set this value.
        """
        return pulumi.get(self, "disk_size_gb")

    @property
    @pulumi.getter(name="storageAccountType")
    def storage_account_type(self) -> str:
        """
        ReadOnly. The storage account type. Do not set this value.
        """
        return pulumi.get(self, "storage_account_type")

    @property
    @pulumi.getter(name="disksPerNode")
    def disks_per_node(self) -> Optional[int]:
        """
        The number of disks per node.
        """
        return pulumi.get(self, "disks_per_node")


@pulumi.output_type
class DiskEncryptionPropertiesResponse(dict):
    """
    The disk encryption properties
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "encryptionAlgorithm":
            suggest = "encryption_algorithm"
        elif key == "encryptionAtHost":
            suggest = "encryption_at_host"
        elif key == "keyName":
            suggest = "key_name"
        elif key == "keyVersion":
            suggest = "key_version"
        elif key == "msiResourceId":
            suggest = "msi_resource_id"
        elif key == "vaultUri":
            suggest = "vault_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DiskEncryptionPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DiskEncryptionPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DiskEncryptionPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 encryption_algorithm: Optional[str] = None,
                 encryption_at_host: Optional[bool] = None,
                 key_name: Optional[str] = None,
                 key_version: Optional[str] = None,
                 msi_resource_id: Optional[str] = None,
                 vault_uri: Optional[str] = None):
        """
        The disk encryption properties
        :param str encryption_algorithm: Algorithm identifier for encryption, default RSA-OAEP.
        :param bool encryption_at_host: Indicates whether or not resource disk encryption is enabled.
        :param str key_name: Key name that is used for enabling disk encryption.
        :param str key_version: Specific key version that is used for enabling disk encryption.
        :param str msi_resource_id: Resource ID of Managed Identity that is used to access the key vault.
        :param str vault_uri: Base key vault URI where the customers key is located eg. https://myvault.vault.azure.net
        """
        if encryption_algorithm is not None:
            pulumi.set(__self__, "encryption_algorithm", encryption_algorithm)
        if encryption_at_host is None:
            encryption_at_host = False
        if encryption_at_host is not None:
            pulumi.set(__self__, "encryption_at_host", encryption_at_host)
        if key_name is not None:
            pulumi.set(__self__, "key_name", key_name)
        if key_version is not None:
            pulumi.set(__self__, "key_version", key_version)
        if msi_resource_id is not None:
            pulumi.set(__self__, "msi_resource_id", msi_resource_id)
        if vault_uri is not None:
            pulumi.set(__self__, "vault_uri", vault_uri)

    @property
    @pulumi.getter(name="encryptionAlgorithm")
    def encryption_algorithm(self) -> Optional[str]:
        """
        Algorithm identifier for encryption, default RSA-OAEP.
        """
        return pulumi.get(self, "encryption_algorithm")

    @property
    @pulumi.getter(name="encryptionAtHost")
    def encryption_at_host(self) -> Optional[bool]:
        """
        Indicates whether or not resource disk encryption is enabled.
        """
        return pulumi.get(self, "encryption_at_host")

    @property
    @pulumi.getter(name="keyName")
    def key_name(self) -> Optional[str]:
        """
        Key name that is used for enabling disk encryption.
        """
        return pulumi.get(self, "key_name")

    @property
    @pulumi.getter(name="keyVersion")
    def key_version(self) -> Optional[str]:
        """
        Specific key version that is used for enabling disk encryption.
        """
        return pulumi.get(self, "key_version")

    @property
    @pulumi.getter(name="msiResourceId")
    def msi_resource_id(self) -> Optional[str]:
        """
        Resource ID of Managed Identity that is used to access the key vault.
        """
        return pulumi.get(self, "msi_resource_id")

    @property
    @pulumi.getter(name="vaultUri")
    def vault_uri(self) -> Optional[str]:
        """
        Base key vault URI where the customers key is located eg. https://myvault.vault.azure.net
        """
        return pulumi.get(self, "vault_uri")


@pulumi.output_type
class EncryptionInTransitPropertiesResponse(dict):
    """
    The encryption-in-transit properties.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isEncryptionInTransitEnabled":
            suggest = "is_encryption_in_transit_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EncryptionInTransitPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EncryptionInTransitPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EncryptionInTransitPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 is_encryption_in_transit_enabled: Optional[bool] = None):
        """
        The encryption-in-transit properties.
        :param bool is_encryption_in_transit_enabled: Indicates whether or not inter cluster node communication is encrypted in transit.
        """
        if is_encryption_in_transit_enabled is None:
            is_encryption_in_transit_enabled = False
        if is_encryption_in_transit_enabled is not None:
            pulumi.set(__self__, "is_encryption_in_transit_enabled", is_encryption_in_transit_enabled)

    @property
    @pulumi.getter(name="isEncryptionInTransitEnabled")
    def is_encryption_in_transit_enabled(self) -> Optional[bool]:
        """
        Indicates whether or not inter cluster node communication is encrypted in transit.
        """
        return pulumi.get(self, "is_encryption_in_transit_enabled")


@pulumi.output_type
class ErrorsResponse(dict):
    """
    The error message associated with the cluster creation.
    """
    def __init__(__self__, *,
                 code: Optional[str] = None,
                 message: Optional[str] = None):
        """
        The error message associated with the cluster creation.
        :param str code: The error code.
        :param str message: The error message.
        """
        if code is not None:
            pulumi.set(__self__, "code", code)
        if message is not None:
            pulumi.set(__self__, "message", message)

    @property
    @pulumi.getter
    def code(self) -> Optional[str]:
        """
        The error code.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def message(self) -> Optional[str]:
        """
        The error message.
        """
        return pulumi.get(self, "message")


@pulumi.output_type
class ExcludedServicesConfigResponse(dict):
    """
    The configuration that services will be excluded when creating cluster.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "excludedServicesConfigId":
            suggest = "excluded_services_config_id"
        elif key == "excludedServicesList":
            suggest = "excluded_services_list"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExcludedServicesConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExcludedServicesConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExcludedServicesConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 excluded_services_config_id: Optional[str] = None,
                 excluded_services_list: Optional[str] = None):
        """
        The configuration that services will be excluded when creating cluster.
        :param str excluded_services_config_id: The config id of excluded services.
        :param str excluded_services_list: The list of excluded services.
        """
        if excluded_services_config_id is not None:
            pulumi.set(__self__, "excluded_services_config_id", excluded_services_config_id)
        if excluded_services_list is not None:
            pulumi.set(__self__, "excluded_services_list", excluded_services_list)

    @property
    @pulumi.getter(name="excludedServicesConfigId")
    def excluded_services_config_id(self) -> Optional[str]:
        """
        The config id of excluded services.
        """
        return pulumi.get(self, "excluded_services_config_id")

    @property
    @pulumi.getter(name="excludedServicesList")
    def excluded_services_list(self) -> Optional[str]:
        """
        The list of excluded services.
        """
        return pulumi.get(self, "excluded_services_list")


@pulumi.output_type
class HardwareProfileResponse(dict):
    """
    The hardware profile.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "vmSize":
            suggest = "vm_size"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HardwareProfileResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HardwareProfileResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HardwareProfileResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 vm_size: Optional[str] = None):
        """
        The hardware profile.
        :param str vm_size: The size of the VM
        """
        if vm_size is not None:
            pulumi.set(__self__, "vm_size", vm_size)

    @property
    @pulumi.getter(name="vmSize")
    def vm_size(self) -> Optional[str]:
        """
        The size of the VM
        """
        return pulumi.get(self, "vm_size")


@pulumi.output_type
class IPConfigurationResponse(dict):
    """
    The ip configurations for the private link service.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "privateIPAddress":
            suggest = "private_ip_address"
        elif key == "privateIPAllocationMethod":
            suggest = "private_ip_allocation_method"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IPConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IPConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IPConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: str,
                 name: str,
                 provisioning_state: str,
                 type: str,
                 primary: Optional[bool] = None,
                 private_ip_address: Optional[str] = None,
                 private_ip_allocation_method: Optional[str] = None,
                 subnet: Optional['outputs.ResourceIdResponse'] = None):
        """
        The ip configurations for the private link service.
        :param str id: The private link IP configuration id.
        :param str name: The name of private link IP configuration.
        :param str provisioning_state: The private link configuration provisioning state, which only appears in the response.
        :param str type: The type of the private link IP configuration.
        :param bool primary: Indicates whether this IP configuration is primary for the corresponding NIC.
        :param str private_ip_address: The IP address.
        :param str private_ip_allocation_method: The method that private IP address is allocated.
        :param 'ResourceIdResponse' subnet: The subnet resource id.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "type", type)
        if primary is not None:
            pulumi.set(__self__, "primary", primary)
        if private_ip_address is not None:
            pulumi.set(__self__, "private_ip_address", private_ip_address)
        if private_ip_allocation_method is not None:
            pulumi.set(__self__, "private_ip_allocation_method", private_ip_allocation_method)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The private link IP configuration id.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of private link IP configuration.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The private link configuration provisioning state, which only appears in the response.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the private link IP configuration.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def primary(self) -> Optional[bool]:
        """
        Indicates whether this IP configuration is primary for the corresponding NIC.
        """
        return pulumi.get(self, "primary")

    @property
    @pulumi.getter(name="privateIPAddress")
    def private_ip_address(self) -> Optional[str]:
        """
        The IP address.
        """
        return pulumi.get(self, "private_ip_address")

    @property
    @pulumi.getter(name="privateIPAllocationMethod")
    def private_ip_allocation_method(self) -> Optional[str]:
        """
        The method that private IP address is allocated.
        """
        return pulumi.get(self, "private_ip_allocation_method")

    @property
    @pulumi.getter
    def subnet(self) -> Optional['outputs.ResourceIdResponse']:
        """
        The subnet resource id.
        """
        return pulumi.get(self, "subnet")


@pulumi.output_type
class KafkaRestPropertiesResponse(dict):
    """
    The kafka rest proxy configuration which contains AAD security group information.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientGroupInfo":
            suggest = "client_group_info"
        elif key == "configurationOverride":
            suggest = "configuration_override"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KafkaRestPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KafkaRestPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KafkaRestPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_group_info: Optional['outputs.ClientGroupInfoResponse'] = None,
                 configuration_override: Optional[Mapping[str, str]] = None):
        """
        The kafka rest proxy configuration which contains AAD security group information.
        :param 'ClientGroupInfoResponse' client_group_info: The information of AAD security group.
        :param Mapping[str, str] configuration_override: The configurations that need to be overriden.
        """
        if client_group_info is not None:
            pulumi.set(__self__, "client_group_info", client_group_info)
        if configuration_override is not None:
            pulumi.set(__self__, "configuration_override", configuration_override)

    @property
    @pulumi.getter(name="clientGroupInfo")
    def client_group_info(self) -> Optional['outputs.ClientGroupInfoResponse']:
        """
        The information of AAD security group.
        """
        return pulumi.get(self, "client_group_info")

    @property
    @pulumi.getter(name="configurationOverride")
    def configuration_override(self) -> Optional[Mapping[str, str]]:
        """
        The configurations that need to be overriden.
        """
        return pulumi.get(self, "configuration_override")


@pulumi.output_type
class LinuxOperatingSystemProfileResponse(dict):
    """
    The ssh username, password, and ssh public key.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sshProfile":
            suggest = "ssh_profile"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LinuxOperatingSystemProfileResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LinuxOperatingSystemProfileResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LinuxOperatingSystemProfileResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 password: Optional[str] = None,
                 ssh_profile: Optional['outputs.SshProfileResponse'] = None,
                 username: Optional[str] = None):
        """
        The ssh username, password, and ssh public key.
        :param str password: The password.
        :param 'SshProfileResponse' ssh_profile: The SSH profile.
        :param str username: The username.
        """
        if password is not None:
            pulumi.set(__self__, "password", password)
        if ssh_profile is not None:
            pulumi.set(__self__, "ssh_profile", ssh_profile)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def password(self) -> Optional[str]:
        """
        The password.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="sshProfile")
    def ssh_profile(self) -> Optional['outputs.SshProfileResponse']:
        """
        The SSH profile.
        """
        return pulumi.get(self, "ssh_profile")

    @property
    @pulumi.getter
    def username(self) -> Optional[str]:
        """
        The username.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class NetworkPropertiesResponse(dict):
    """
    The network properties.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "privateLink":
            suggest = "private_link"
        elif key == "resourceProviderConnection":
            suggest = "resource_provider_connection"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 private_link: Optional[str] = None,
                 resource_provider_connection: Optional[str] = None):
        """
        The network properties.
        :param str private_link: Indicates whether or not private link is enabled.
        :param str resource_provider_connection: The direction for the resource provider connection.
        """
        if private_link is not None:
            pulumi.set(__self__, "private_link", private_link)
        if resource_provider_connection is not None:
            pulumi.set(__self__, "resource_provider_connection", resource_provider_connection)

    @property
    @pulumi.getter(name="privateLink")
    def private_link(self) -> Optional[str]:
        """
        Indicates whether or not private link is enabled.
        """
        return pulumi.get(self, "private_link")

    @property
    @pulumi.getter(name="resourceProviderConnection")
    def resource_provider_connection(self) -> Optional[str]:
        """
        The direction for the resource provider connection.
        """
        return pulumi.get(self, "resource_provider_connection")


@pulumi.output_type
class OsProfileResponse(dict):
    """
    The Linux operation systems profile.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "linuxOperatingSystemProfile":
            suggest = "linux_operating_system_profile"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OsProfileResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OsProfileResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OsProfileResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 linux_operating_system_profile: Optional['outputs.LinuxOperatingSystemProfileResponse'] = None):
        """
        The Linux operation systems profile.
        :param 'LinuxOperatingSystemProfileResponse' linux_operating_system_profile: The Linux OS profile.
        """
        if linux_operating_system_profile is not None:
            pulumi.set(__self__, "linux_operating_system_profile", linux_operating_system_profile)

    @property
    @pulumi.getter(name="linuxOperatingSystemProfile")
    def linux_operating_system_profile(self) -> Optional['outputs.LinuxOperatingSystemProfileResponse']:
        """
        The Linux OS profile.
        """
        return pulumi.get(self, "linux_operating_system_profile")


@pulumi.output_type
class PrivateEndpointConnectionResponse(dict):
    """
    The private endpoint connection.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "linkIdentifier":
            suggest = "link_identifier"
        elif key == "privateEndpoint":
            suggest = "private_endpoint"
        elif key == "privateLinkServiceConnectionState":
            suggest = "private_link_service_connection_state"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "systemData":
            suggest = "system_data"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrivateEndpointConnectionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrivateEndpointConnectionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrivateEndpointConnectionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: str,
                 link_identifier: str,
                 name: str,
                 private_endpoint: 'outputs.PrivateEndpointResponse',
                 private_link_service_connection_state: 'outputs.PrivateLinkServiceConnectionStateResponse',
                 provisioning_state: str,
                 system_data: 'outputs.SystemDataResponse',
                 type: str):
        """
        The private endpoint connection.
        :param str id: Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
        :param str link_identifier: The link identifier.
        :param str name: The name of the resource
        :param 'PrivateEndpointResponse' private_endpoint: The private endpoint of the private endpoint connection
        :param 'PrivateLinkServiceConnectionStateResponse' private_link_service_connection_state: The private link service connection state.
        :param str provisioning_state: The provisioning state, which only appears in the response.
        :param 'SystemDataResponse' system_data: Metadata pertaining to creation and last modification of the resource.
        :param str type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "link_identifier", link_identifier)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "private_endpoint", private_endpoint)
        pulumi.set(__self__, "private_link_service_connection_state", private_link_service_connection_state)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "system_data", system_data)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="linkIdentifier")
    def link_identifier(self) -> str:
        """
        The link identifier.
        """
        return pulumi.get(self, "link_identifier")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="privateEndpoint")
    def private_endpoint(self) -> 'outputs.PrivateEndpointResponse':
        """
        The private endpoint of the private endpoint connection
        """
        return pulumi.get(self, "private_endpoint")

    @property
    @pulumi.getter(name="privateLinkServiceConnectionState")
    def private_link_service_connection_state(self) -> 'outputs.PrivateLinkServiceConnectionStateResponse':
        """
        The private link service connection state.
        """
        return pulumi.get(self, "private_link_service_connection_state")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state, which only appears in the response.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="systemData")
    def system_data(self) -> 'outputs.SystemDataResponse':
        """
        Metadata pertaining to creation and last modification of the resource.
        """
        return pulumi.get(self, "system_data")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class PrivateEndpointResponse(dict):
    """
    The private endpoint.
    """
    def __init__(__self__, *,
                 id: Optional[str] = None):
        """
        The private endpoint.
        :param str id: The private endpoint id.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The private endpoint id.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class PrivateLinkConfigurationResponse(dict):
    """
    The private link configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "groupId":
            suggest = "group_id"
        elif key == "ipConfigurations":
            suggest = "ip_configurations"
        elif key == "provisioningState":
            suggest = "provisioning_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrivateLinkConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrivateLinkConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrivateLinkConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 group_id: str,
                 id: str,
                 ip_configurations: Sequence['outputs.IPConfigurationResponse'],
                 name: str,
                 provisioning_state: str,
                 type: str):
        """
        The private link configuration.
        :param str group_id: The HDInsight private linkable sub-resource name to apply the private link configuration to. For example, 'headnode', 'gateway', 'edgenode'.
        :param str id: The private link configuration id.
        :param Sequence['IPConfigurationResponse'] ip_configurations: The IP configurations for the private link service.
        :param str name: The name of private link configuration.
        :param str provisioning_state: The private link configuration provisioning state, which only appears in the response.
        :param str type: The type of the private link configuration.
        """
        pulumi.set(__self__, "group_id", group_id)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ip_configurations", ip_configurations)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> str:
        """
        The HDInsight private linkable sub-resource name to apply the private link configuration to. For example, 'headnode', 'gateway', 'edgenode'.
        """
        return pulumi.get(self, "group_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The private link configuration id.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ipConfigurations")
    def ip_configurations(self) -> Sequence['outputs.IPConfigurationResponse']:
        """
        The IP configurations for the private link service.
        """
        return pulumi.get(self, "ip_configurations")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of private link configuration.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The private link configuration provisioning state, which only appears in the response.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the private link configuration.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class PrivateLinkServiceConnectionStateResponse(dict):
    """
    The private link service connection state.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "actionsRequired":
            suggest = "actions_required"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrivateLinkServiceConnectionStateResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrivateLinkServiceConnectionStateResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrivateLinkServiceConnectionStateResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 status: str,
                 actions_required: Optional[str] = None,
                 description: Optional[str] = None):
        """
        The private link service connection state.
        :param str status: The concrete private link service connection.
        :param str actions_required: Whether there is further actions.
        :param str description: The optional description of the status.
        """
        pulumi.set(__self__, "status", status)
        if actions_required is not None:
            pulumi.set(__self__, "actions_required", actions_required)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The concrete private link service connection.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="actionsRequired")
    def actions_required(self) -> Optional[str]:
        """
        Whether there is further actions.
        """
        return pulumi.get(self, "actions_required")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The optional description of the status.
        """
        return pulumi.get(self, "description")


@pulumi.output_type
class QuotaInfoResponse(dict):
    """
    The quota properties for the cluster.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "coresUsed":
            suggest = "cores_used"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in QuotaInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        QuotaInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        QuotaInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cores_used: Optional[int] = None):
        """
        The quota properties for the cluster.
        :param int cores_used: The cores used by the cluster.
        """
        if cores_used is not None:
            pulumi.set(__self__, "cores_used", cores_used)

    @property
    @pulumi.getter(name="coresUsed")
    def cores_used(self) -> Optional[int]:
        """
        The cores used by the cluster.
        """
        return pulumi.get(self, "cores_used")


@pulumi.output_type
class ResourceIdResponse(dict):
    """
    The azure resource id.
    """
    def __init__(__self__, *,
                 id: Optional[str] = None):
        """
        The azure resource id.
        :param str id: The azure resource id.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The azure resource id.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class RoleResponse(dict):
    """
    Describes a role on the cluster.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autoscaleConfiguration":
            suggest = "autoscale_configuration"
        elif key == "dataDisksGroups":
            suggest = "data_disks_groups"
        elif key == "encryptDataDisks":
            suggest = "encrypt_data_disks"
        elif key == "hardwareProfile":
            suggest = "hardware_profile"
        elif key == "minInstanceCount":
            suggest = "min_instance_count"
        elif key == "osProfile":
            suggest = "os_profile"
        elif key == "scriptActions":
            suggest = "script_actions"
        elif key == "targetInstanceCount":
            suggest = "target_instance_count"
        elif key == "vMGroupName":
            suggest = "v_m_group_name"
        elif key == "virtualNetworkProfile":
            suggest = "virtual_network_profile"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RoleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RoleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RoleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 autoscale_configuration: Optional['outputs.AutoscaleResponse'] = None,
                 data_disks_groups: Optional[Sequence['outputs.DataDisksGroupsResponse']] = None,
                 encrypt_data_disks: Optional[bool] = None,
                 hardware_profile: Optional['outputs.HardwareProfileResponse'] = None,
                 min_instance_count: Optional[int] = None,
                 name: Optional[str] = None,
                 os_profile: Optional['outputs.OsProfileResponse'] = None,
                 script_actions: Optional[Sequence['outputs.ScriptActionResponse']] = None,
                 target_instance_count: Optional[int] = None,
                 v_m_group_name: Optional[str] = None,
                 virtual_network_profile: Optional['outputs.VirtualNetworkProfileResponse'] = None):
        """
        Describes a role on the cluster.
        :param 'AutoscaleResponse' autoscale_configuration: The autoscale configurations.
        :param Sequence['DataDisksGroupsResponse'] data_disks_groups: The data disks groups for the role.
        :param bool encrypt_data_disks: Indicates whether encrypt the data disks.
        :param 'HardwareProfileResponse' hardware_profile: The hardware profile.
        :param int min_instance_count: The minimum instance count of the cluster.
        :param str name: The name of the role.
        :param 'OsProfileResponse' os_profile: The operating system profile.
        :param Sequence['ScriptActionResponse'] script_actions: The list of script actions on the role.
        :param int target_instance_count: The instance count of the cluster.
        :param str v_m_group_name: The name of the virtual machine group.
        :param 'VirtualNetworkProfileResponse' virtual_network_profile: The virtual network profile.
        """
        if autoscale_configuration is not None:
            pulumi.set(__self__, "autoscale_configuration", autoscale_configuration)
        if data_disks_groups is not None:
            pulumi.set(__self__, "data_disks_groups", data_disks_groups)
        if encrypt_data_disks is None:
            encrypt_data_disks = False
        if encrypt_data_disks is not None:
            pulumi.set(__self__, "encrypt_data_disks", encrypt_data_disks)
        if hardware_profile is not None:
            pulumi.set(__self__, "hardware_profile", hardware_profile)
        if min_instance_count is not None:
            pulumi.set(__self__, "min_instance_count", min_instance_count)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if os_profile is not None:
            pulumi.set(__self__, "os_profile", os_profile)
        if script_actions is not None:
            pulumi.set(__self__, "script_actions", script_actions)
        if target_instance_count is not None:
            pulumi.set(__self__, "target_instance_count", target_instance_count)
        if v_m_group_name is not None:
            pulumi.set(__self__, "v_m_group_name", v_m_group_name)
        if virtual_network_profile is not None:
            pulumi.set(__self__, "virtual_network_profile", virtual_network_profile)

    @property
    @pulumi.getter(name="autoscaleConfiguration")
    def autoscale_configuration(self) -> Optional['outputs.AutoscaleResponse']:
        """
        The autoscale configurations.
        """
        return pulumi.get(self, "autoscale_configuration")

    @property
    @pulumi.getter(name="dataDisksGroups")
    def data_disks_groups(self) -> Optional[Sequence['outputs.DataDisksGroupsResponse']]:
        """
        The data disks groups for the role.
        """
        return pulumi.get(self, "data_disks_groups")

    @property
    @pulumi.getter(name="encryptDataDisks")
    def encrypt_data_disks(self) -> Optional[bool]:
        """
        Indicates whether encrypt the data disks.
        """
        return pulumi.get(self, "encrypt_data_disks")

    @property
    @pulumi.getter(name="hardwareProfile")
    def hardware_profile(self) -> Optional['outputs.HardwareProfileResponse']:
        """
        The hardware profile.
        """
        return pulumi.get(self, "hardware_profile")

    @property
    @pulumi.getter(name="minInstanceCount")
    def min_instance_count(self) -> Optional[int]:
        """
        The minimum instance count of the cluster.
        """
        return pulumi.get(self, "min_instance_count")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the role.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="osProfile")
    def os_profile(self) -> Optional['outputs.OsProfileResponse']:
        """
        The operating system profile.
        """
        return pulumi.get(self, "os_profile")

    @property
    @pulumi.getter(name="scriptActions")
    def script_actions(self) -> Optional[Sequence['outputs.ScriptActionResponse']]:
        """
        The list of script actions on the role.
        """
        return pulumi.get(self, "script_actions")

    @property
    @pulumi.getter(name="targetInstanceCount")
    def target_instance_count(self) -> Optional[int]:
        """
        The instance count of the cluster.
        """
        return pulumi.get(self, "target_instance_count")

    @property
    @pulumi.getter(name="vMGroupName")
    def v_m_group_name(self) -> Optional[str]:
        """
        The name of the virtual machine group.
        """
        return pulumi.get(self, "v_m_group_name")

    @property
    @pulumi.getter(name="virtualNetworkProfile")
    def virtual_network_profile(self) -> Optional['outputs.VirtualNetworkProfileResponse']:
        """
        The virtual network profile.
        """
        return pulumi.get(self, "virtual_network_profile")


@pulumi.output_type
class RuntimeScriptActionResponse(dict):
    """
    Describes a script action on a running cluster.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "applicationName":
            suggest = "application_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuntimeScriptActionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuntimeScriptActionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuntimeScriptActionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 application_name: str,
                 name: str,
                 roles: Sequence[str],
                 uri: str):
        """
        Describes a script action on a running cluster.
        :param str application_name: The application name of the script action, if any.
        :param str name: The name of the script action.
        :param Sequence[str] roles: The list of roles where script will be executed.
        :param str uri: The URI to the script.
        """
        pulumi.set(__self__, "application_name", application_name)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "roles", roles)
        pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter(name="applicationName")
    def application_name(self) -> str:
        """
        The application name of the script action, if any.
        """
        return pulumi.get(self, "application_name")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the script action.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def roles(self) -> Sequence[str]:
        """
        The list of roles where script will be executed.
        """
        return pulumi.get(self, "roles")

    @property
    @pulumi.getter
    def uri(self) -> str:
        """
        The URI to the script.
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class ScriptActionResponse(dict):
    """
    Describes a script action on role on the cluster.
    """
    def __init__(__self__, *,
                 name: str,
                 parameters: str,
                 uri: str):
        """
        Describes a script action on role on the cluster.
        :param str name: The name of the script action.
        :param str parameters: The parameters for the script provided.
        :param str uri: The URI to the script.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "parameters", parameters)
        pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the script action.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def parameters(self) -> str:
        """
        The parameters for the script provided.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter
    def uri(self) -> str:
        """
        The URI to the script.
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class SecurityProfileResponse(dict):
    """
    The security profile which contains Ssh public key for the HDInsight cluster.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "aaddsResourceId":
            suggest = "aadds_resource_id"
        elif key == "clusterUsersGroupDNs":
            suggest = "cluster_users_group_dns"
        elif key == "directoryType":
            suggest = "directory_type"
        elif key == "domainUserPassword":
            suggest = "domain_user_password"
        elif key == "domainUsername":
            suggest = "domain_username"
        elif key == "ldapsUrls":
            suggest = "ldaps_urls"
        elif key == "msiResourceId":
            suggest = "msi_resource_id"
        elif key == "organizationalUnitDN":
            suggest = "organizational_unit_dn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecurityProfileResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecurityProfileResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecurityProfileResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 aadds_resource_id: Optional[str] = None,
                 cluster_users_group_dns: Optional[Sequence[str]] = None,
                 directory_type: Optional[str] = None,
                 domain: Optional[str] = None,
                 domain_user_password: Optional[str] = None,
                 domain_username: Optional[str] = None,
                 ldaps_urls: Optional[Sequence[str]] = None,
                 msi_resource_id: Optional[str] = None,
                 organizational_unit_dn: Optional[str] = None):
        """
        The security profile which contains Ssh public key for the HDInsight cluster.
        :param str aadds_resource_id: The resource ID of the user's Azure Active Directory Domain Service.
        :param Sequence[str] cluster_users_group_dns: Optional. The Distinguished Names for cluster user groups
        :param str directory_type: The directory type.
        :param str domain: The organization's active directory domain.
        :param str domain_user_password: The domain admin password.
        :param str domain_username: The domain user account that will have admin privileges on the cluster.
        :param Sequence[str] ldaps_urls: The LDAPS protocol URLs to communicate with the Active Directory.
        :param str msi_resource_id: User assigned identity that has permissions to read and create cluster-related artifacts in the user's AADDS.
        :param str organizational_unit_dn: The organizational unit within the Active Directory to place the cluster and service accounts.
        """
        if aadds_resource_id is not None:
            pulumi.set(__self__, "aadds_resource_id", aadds_resource_id)
        if cluster_users_group_dns is not None:
            pulumi.set(__self__, "cluster_users_group_dns", cluster_users_group_dns)
        if directory_type is not None:
            pulumi.set(__self__, "directory_type", directory_type)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if domain_user_password is not None:
            pulumi.set(__self__, "domain_user_password", domain_user_password)
        if domain_username is not None:
            pulumi.set(__self__, "domain_username", domain_username)
        if ldaps_urls is not None:
            pulumi.set(__self__, "ldaps_urls", ldaps_urls)
        if msi_resource_id is not None:
            pulumi.set(__self__, "msi_resource_id", msi_resource_id)
        if organizational_unit_dn is not None:
            pulumi.set(__self__, "organizational_unit_dn", organizational_unit_dn)

    @property
    @pulumi.getter(name="aaddsResourceId")
    def aadds_resource_id(self) -> Optional[str]:
        """
        The resource ID of the user's Azure Active Directory Domain Service.
        """
        return pulumi.get(self, "aadds_resource_id")

    @property
    @pulumi.getter(name="clusterUsersGroupDNs")
    def cluster_users_group_dns(self) -> Optional[Sequence[str]]:
        """
        Optional. The Distinguished Names for cluster user groups
        """
        return pulumi.get(self, "cluster_users_group_dns")

    @property
    @pulumi.getter(name="directoryType")
    def directory_type(self) -> Optional[str]:
        """
        The directory type.
        """
        return pulumi.get(self, "directory_type")

    @property
    @pulumi.getter
    def domain(self) -> Optional[str]:
        """
        The organization's active directory domain.
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter(name="domainUserPassword")
    def domain_user_password(self) -> Optional[str]:
        """
        The domain admin password.
        """
        return pulumi.get(self, "domain_user_password")

    @property
    @pulumi.getter(name="domainUsername")
    def domain_username(self) -> Optional[str]:
        """
        The domain user account that will have admin privileges on the cluster.
        """
        return pulumi.get(self, "domain_username")

    @property
    @pulumi.getter(name="ldapsUrls")
    def ldaps_urls(self) -> Optional[Sequence[str]]:
        """
        The LDAPS protocol URLs to communicate with the Active Directory.
        """
        return pulumi.get(self, "ldaps_urls")

    @property
    @pulumi.getter(name="msiResourceId")
    def msi_resource_id(self) -> Optional[str]:
        """
        User assigned identity that has permissions to read and create cluster-related artifacts in the user's AADDS.
        """
        return pulumi.get(self, "msi_resource_id")

    @property
    @pulumi.getter(name="organizationalUnitDN")
    def organizational_unit_dn(self) -> Optional[str]:
        """
        The organizational unit within the Active Directory to place the cluster and service accounts.
        """
        return pulumi.get(self, "organizational_unit_dn")


@pulumi.output_type
class SshProfileResponse(dict):
    """
    The list of SSH public keys.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "publicKeys":
            suggest = "public_keys"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SshProfileResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SshProfileResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SshProfileResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 public_keys: Optional[Sequence['outputs.SshPublicKeyResponse']] = None):
        """
        The list of SSH public keys.
        :param Sequence['SshPublicKeyResponse'] public_keys: The list of SSH public keys.
        """
        if public_keys is not None:
            pulumi.set(__self__, "public_keys", public_keys)

    @property
    @pulumi.getter(name="publicKeys")
    def public_keys(self) -> Optional[Sequence['outputs.SshPublicKeyResponse']]:
        """
        The list of SSH public keys.
        """
        return pulumi.get(self, "public_keys")


@pulumi.output_type
class SshPublicKeyResponse(dict):
    """
    The SSH public key for the cluster nodes.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certificateData":
            suggest = "certificate_data"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SshPublicKeyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SshPublicKeyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SshPublicKeyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 certificate_data: Optional[str] = None):
        """
        The SSH public key for the cluster nodes.
        :param str certificate_data: The certificate for SSH.
        """
        if certificate_data is not None:
            pulumi.set(__self__, "certificate_data", certificate_data)

    @property
    @pulumi.getter(name="certificateData")
    def certificate_data(self) -> Optional[str]:
        """
        The certificate for SSH.
        """
        return pulumi.get(self, "certificate_data")


@pulumi.output_type
class StorageAccountResponse(dict):
    """
    The storage Account.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fileSystem":
            suggest = "file_system"
        elif key == "isDefault":
            suggest = "is_default"
        elif key == "msiResourceId":
            suggest = "msi_resource_id"
        elif key == "resourceId":
            suggest = "resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StorageAccountResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StorageAccountResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StorageAccountResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 container: Optional[str] = None,
                 file_system: Optional[str] = None,
                 fileshare: Optional[str] = None,
                 is_default: Optional[bool] = None,
                 key: Optional[str] = None,
                 msi_resource_id: Optional[str] = None,
                 name: Optional[str] = None,
                 resource_id: Optional[str] = None,
                 saskey: Optional[str] = None):
        """
        The storage Account.
        :param str container: The container in the storage account, only to be specified for WASB storage accounts.
        :param str file_system: The filesystem, only to be specified for Azure Data Lake Storage Gen 2.
        :param str fileshare: The file share name.
        :param bool is_default: Whether or not the storage account is the default storage account.
        :param str key: The storage account access key.
        :param str msi_resource_id: The managed identity (MSI) that is allowed to access the storage account, only to be specified for Azure Data Lake Storage Gen 2.
        :param str name: The name of the storage account.
        :param str resource_id: The resource ID of storage account, only to be specified for Azure Data Lake Storage Gen 2.
        :param str saskey: The shared access signature key.
        """
        if container is not None:
            pulumi.set(__self__, "container", container)
        if file_system is not None:
            pulumi.set(__self__, "file_system", file_system)
        if fileshare is not None:
            pulumi.set(__self__, "fileshare", fileshare)
        if is_default is not None:
            pulumi.set(__self__, "is_default", is_default)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if msi_resource_id is not None:
            pulumi.set(__self__, "msi_resource_id", msi_resource_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)
        if saskey is not None:
            pulumi.set(__self__, "saskey", saskey)

    @property
    @pulumi.getter
    def container(self) -> Optional[str]:
        """
        The container in the storage account, only to be specified for WASB storage accounts.
        """
        return pulumi.get(self, "container")

    @property
    @pulumi.getter(name="fileSystem")
    def file_system(self) -> Optional[str]:
        """
        The filesystem, only to be specified for Azure Data Lake Storage Gen 2.
        """
        return pulumi.get(self, "file_system")

    @property
    @pulumi.getter
    def fileshare(self) -> Optional[str]:
        """
        The file share name.
        """
        return pulumi.get(self, "fileshare")

    @property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> Optional[bool]:
        """
        Whether or not the storage account is the default storage account.
        """
        return pulumi.get(self, "is_default")

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        """
        The storage account access key.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter(name="msiResourceId")
    def msi_resource_id(self) -> Optional[str]:
        """
        The managed identity (MSI) that is allowed to access the storage account, only to be specified for Azure Data Lake Storage Gen 2.
        """
        return pulumi.get(self, "msi_resource_id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the storage account.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[str]:
        """
        The resource ID of storage account, only to be specified for Azure Data Lake Storage Gen 2.
        """
        return pulumi.get(self, "resource_id")

    @property
    @pulumi.getter
    def saskey(self) -> Optional[str]:
        """
        The shared access signature key.
        """
        return pulumi.get(self, "saskey")


@pulumi.output_type
class StorageProfileResponse(dict):
    """
    The storage profile.
    """
    def __init__(__self__, *,
                 storageaccounts: Optional[Sequence['outputs.StorageAccountResponse']] = None):
        """
        The storage profile.
        :param Sequence['StorageAccountResponse'] storageaccounts: The list of storage accounts in the cluster.
        """
        if storageaccounts is not None:
            pulumi.set(__self__, "storageaccounts", storageaccounts)

    @property
    @pulumi.getter
    def storageaccounts(self) -> Optional[Sequence['outputs.StorageAccountResponse']]:
        """
        The list of storage accounts in the cluster.
        """
        return pulumi.get(self, "storageaccounts")


@pulumi.output_type
class SystemDataResponse(dict):
    """
    Metadata pertaining to creation and last modification of the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdAt":
            suggest = "created_at"
        elif key == "createdBy":
            suggest = "created_by"
        elif key == "createdByType":
            suggest = "created_by_type"
        elif key == "lastModifiedAt":
            suggest = "last_modified_at"
        elif key == "lastModifiedBy":
            suggest = "last_modified_by"
        elif key == "lastModifiedByType":
            suggest = "last_modified_by_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SystemDataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_at: Optional[str] = None,
                 created_by: Optional[str] = None,
                 created_by_type: Optional[str] = None,
                 last_modified_at: Optional[str] = None,
                 last_modified_by: Optional[str] = None,
                 last_modified_by_type: Optional[str] = None):
        """
        Metadata pertaining to creation and last modification of the resource.
        :param str created_at: The timestamp of resource creation (UTC).
        :param str created_by: The identity that created the resource.
        :param str created_by_type: The type of identity that created the resource.
        :param str last_modified_at: The timestamp of resource last modification (UTC)
        :param str last_modified_by: The identity that last modified the resource.
        :param str last_modified_by_type: The type of identity that last modified the resource.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if created_by_type is not None:
            pulumi.set(__self__, "created_by_type", created_by_type)
        if last_modified_at is not None:
            pulumi.set(__self__, "last_modified_at", last_modified_at)
        if last_modified_by is not None:
            pulumi.set(__self__, "last_modified_by", last_modified_by)
        if last_modified_by_type is not None:
            pulumi.set(__self__, "last_modified_by_type", last_modified_by_type)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[str]:
        """
        The timestamp of resource creation (UTC).
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[str]:
        """
        The identity that created the resource.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="createdByType")
    def created_by_type(self) -> Optional[str]:
        """
        The type of identity that created the resource.
        """
        return pulumi.get(self, "created_by_type")

    @property
    @pulumi.getter(name="lastModifiedAt")
    def last_modified_at(self) -> Optional[str]:
        """
        The timestamp of resource last modification (UTC)
        """
        return pulumi.get(self, "last_modified_at")

    @property
    @pulumi.getter(name="lastModifiedBy")
    def last_modified_by(self) -> Optional[str]:
        """
        The identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by")

    @property
    @pulumi.getter(name="lastModifiedByType")
    def last_modified_by_type(self) -> Optional[str]:
        """
        The type of identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by_type")


@pulumi.output_type
class UserAssignedIdentityResponse(dict):
    """
    The User Assigned Identity
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientId":
            suggest = "client_id"
        elif key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserAssignedIdentityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserAssignedIdentityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserAssignedIdentityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_id: str,
                 principal_id: str,
                 tenant_id: Optional[str] = None):
        """
        The User Assigned Identity
        :param str client_id: The client id of user assigned identity.
        :param str principal_id: The principal id of user assigned identity.
        :param str tenant_id: The tenant id of user assigned identity.
        """
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> str:
        """
        The client id of user assigned identity.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> str:
        """
        The principal id of user assigned identity.
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[str]:
        """
        The tenant id of user assigned identity.
        """
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class VirtualNetworkProfileResponse(dict):
    """
    The virtual network properties.
    """
    def __init__(__self__, *,
                 id: Optional[str] = None,
                 subnet: Optional[str] = None):
        """
        The virtual network properties.
        :param str id: The ID of the virtual network.
        :param str subnet: The name of the subnet.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The ID of the virtual network.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def subnet(self) -> Optional[str]:
        """
        The name of the subnet.
        """
        return pulumi.get(self, "subnet")


