# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AuthorizationResponse',
    'BootstrapConfigurationResponse',
    'CodeRepositoryResponse',
    'OrganizationReferenceResponse',
    'PipelineTemplateResponse',
    'ProjectReferenceResponse',
]

@pulumi.output_type
class AuthorizationResponse(dict):
    """
    Authorization info used to access a resource (like code repository).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authorizationType":
            suggest = "authorization_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AuthorizationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AuthorizationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AuthorizationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 authorization_type: str,
                 parameters: Optional[Mapping[str, str]] = None):
        """
        Authorization info used to access a resource (like code repository).
        :param str authorization_type: Type of authorization.
        :param Mapping[str, str] parameters: Authorization parameters corresponding to the authorization type.
        """
        pulumi.set(__self__, "authorization_type", authorization_type)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter(name="authorizationType")
    def authorization_type(self) -> str:
        """
        Type of authorization.
        """
        return pulumi.get(self, "authorization_type")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, str]]:
        """
        Authorization parameters corresponding to the authorization type.
        """
        return pulumi.get(self, "parameters")


@pulumi.output_type
class BootstrapConfigurationResponse(dict):
    """
    Configuration used to bootstrap a Pipeline.
    """
    def __init__(__self__, *,
                 template: 'outputs.PipelineTemplateResponse',
                 repository: Optional['outputs.CodeRepositoryResponse'] = None):
        """
        Configuration used to bootstrap a Pipeline.
        :param 'PipelineTemplateResponse' template: Template used to bootstrap the pipeline.
        :param 'CodeRepositoryResponse' repository: Repository containing the source code for the pipeline.
        """
        pulumi.set(__self__, "template", template)
        if repository is not None:
            pulumi.set(__self__, "repository", repository)

    @property
    @pulumi.getter
    def template(self) -> 'outputs.PipelineTemplateResponse':
        """
        Template used to bootstrap the pipeline.
        """
        return pulumi.get(self, "template")

    @property
    @pulumi.getter
    def repository(self) -> Optional['outputs.CodeRepositoryResponse']:
        """
        Repository containing the source code for the pipeline.
        """
        return pulumi.get(self, "repository")


@pulumi.output_type
class CodeRepositoryResponse(dict):
    """
    Repository containing the source code for a pipeline.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultBranch":
            suggest = "default_branch"
        elif key == "repositoryType":
            suggest = "repository_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CodeRepositoryResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CodeRepositoryResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CodeRepositoryResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_branch: str,
                 id: str,
                 repository_type: str,
                 authorization: Optional['outputs.AuthorizationResponse'] = None,
                 properties: Optional[Mapping[str, str]] = None):
        """
        Repository containing the source code for a pipeline.
        :param str default_branch: Default branch used to configure Continuous Integration (CI) in the pipeline.
        :param str id: Unique immutable identifier of the code repository.
        :param str repository_type: Type of code repository.
        :param 'AuthorizationResponse' authorization: Authorization info to access the code repository.
        :param Mapping[str, str] properties: Repository-specific properties.
        """
        pulumi.set(__self__, "default_branch", default_branch)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "repository_type", repository_type)
        if authorization is not None:
            pulumi.set(__self__, "authorization", authorization)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter(name="defaultBranch")
    def default_branch(self) -> str:
        """
        Default branch used to configure Continuous Integration (CI) in the pipeline.
        """
        return pulumi.get(self, "default_branch")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Unique immutable identifier of the code repository.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="repositoryType")
    def repository_type(self) -> str:
        """
        Type of code repository.
        """
        return pulumi.get(self, "repository_type")

    @property
    @pulumi.getter
    def authorization(self) -> Optional['outputs.AuthorizationResponse']:
        """
        Authorization info to access the code repository.
        """
        return pulumi.get(self, "authorization")

    @property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, str]]:
        """
        Repository-specific properties.
        """
        return pulumi.get(self, "properties")


@pulumi.output_type
class OrganizationReferenceResponse(dict):
    """
    Reference to an Azure DevOps Organization.
    """
    def __init__(__self__, *,
                 id: str,
                 name: str):
        """
        Reference to an Azure DevOps Organization.
        :param str id: Unique immutable identifier for the Azure DevOps Organization.
        :param str name: Name of the Azure DevOps Organization.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Unique immutable identifier for the Azure DevOps Organization.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the Azure DevOps Organization.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class PipelineTemplateResponse(dict):
    """
    Template used to bootstrap the pipeline.
    """
    def __init__(__self__, *,
                 id: str,
                 parameters: Optional[Mapping[str, str]] = None):
        """
        Template used to bootstrap the pipeline.
        :param str id: Unique identifier of the pipeline template.
        :param Mapping[str, str] parameters: Dictionary of input parameters used in the pipeline template.
        """
        pulumi.set(__self__, "id", id)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Unique identifier of the pipeline template.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, str]]:
        """
        Dictionary of input parameters used in the pipeline template.
        """
        return pulumi.get(self, "parameters")


@pulumi.output_type
class ProjectReferenceResponse(dict):
    """
    Reference to an Azure DevOps Project.
    """
    def __init__(__self__, *,
                 id: str,
                 name: str):
        """
        Reference to an Azure DevOps Project.
        :param str id: Unique immutable identifier of the Azure DevOps Project.
        :param str name: Name of the Azure DevOps Project.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Unique immutable identifier of the Azure DevOps Project.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the Azure DevOps Project.
        """
        return pulumi.get(self, "name")


