# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

from enum import Enum

__all__ = [
    'AccessMode',
    'ActiveRevisionsMode',
    'AppProtocol',
    'BindingType',
    'ClientCredentialMethod',
    'CookieExpirationConvention',
    'ForwardProxyConvention',
    'IngressTransportMethod',
    'ManagedServiceIdentityType',
    'Scheme',
    'StorageType',
    'Type',
    'UnauthenticatedClientActionV2',
]


class AccessMode(str, Enum):
    """
    Access mode for storage
    """
    READ_ONLY = "ReadOnly"
    READ_WRITE = "ReadWrite"


class ActiveRevisionsMode(str, Enum):
    """
    ActiveRevisionsMode controls how active revisions are handled for the Container app:
    <list><item>Multiple: multiple revisions can be active.</item><item>Single: Only one revision can be active at a time. Revision weights can not be used in this mode. If no value if provided, this is the default.</item></list>
    """
    MULTIPLE = "Multiple"
    SINGLE = "Single"


class AppProtocol(str, Enum):
    """
    Tells Dapr which protocol your application is using. Valid options are http and grpc. Default is http
    """
    HTTP = "http"
    GRPC = "grpc"


class BindingType(str, Enum):
    """
    Custom Domain binding type.
    """
    DISABLED = "Disabled"
    SNI_ENABLED = "SniEnabled"


class ClientCredentialMethod(str, Enum):
    """
    The method that should be used to authenticate the user.
    """
    CLIENT_SECRET_POST = "ClientSecretPost"


class CookieExpirationConvention(str, Enum):
    """
    The convention used when determining the session cookie's expiration.
    """
    FIXED_TIME = "FixedTime"
    IDENTITY_PROVIDER_DERIVED = "IdentityProviderDerived"


class ForwardProxyConvention(str, Enum):
    """
    The convention used to determine the url of the request made.
    """
    NO_PROXY = "NoProxy"
    STANDARD = "Standard"
    CUSTOM = "Custom"


class IngressTransportMethod(str, Enum):
    """
    Ingress transport protocol
    """
    AUTO = "auto"
    HTTP = "http"
    HTTP2 = "http2"


class ManagedServiceIdentityType(str, Enum):
    """
    Type of managed service identity (where both SystemAssigned and UserAssigned types are allowed).
    """
    NONE = "None"
    SYSTEM_ASSIGNED = "SystemAssigned"
    USER_ASSIGNED = "UserAssigned"
    SYSTEM_ASSIGNED_USER_ASSIGNED = "SystemAssigned,UserAssigned"


class Scheme(str, Enum):
    """
    Scheme to use for connecting to the host. Defaults to HTTP.
    """
    HTTP = "HTTP"
    HTTPS = "HTTPS"


class StorageType(str, Enum):
    """
    Storage type for the volume. If not provided, use EmptyDir.
    """
    AZURE_FILE = "AzureFile"
    EMPTY_DIR = "EmptyDir"


class Type(str, Enum):
    """
    The type of probe.
    """
    LIVENESS = "Liveness"
    READINESS = "Readiness"
    STARTUP = "Startup"


class UnauthenticatedClientActionV2(str, Enum):
    """
    The action to take when an unauthenticated client attempts to access the app.
    """
    REDIRECT_TO_LOGIN_PAGE = "RedirectToLoginPage"
    ALLOW_ANONYMOUS = "AllowAnonymous"
    RETURN401 = "Return401"
    RETURN403 = "Return403"
