# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = ['DatabaseSqlVulnerabilityAssessmentRuleBaselineArgs', 'DatabaseSqlVulnerabilityAssessmentRuleBaseline']

@pulumi.input_type
class DatabaseSqlVulnerabilityAssessmentRuleBaselineArgs:
    def __init__(__self__, *,
                 baseline_name: pulumi.Input[str],
                 database_name: pulumi.Input[str],
                 latest_scan: pulumi.Input[bool],
                 resource_group_name: pulumi.Input[str],
                 results: pulumi.Input[Sequence[pulumi.Input[Sequence[pulumi.Input[str]]]]],
                 server_name: pulumi.Input[str],
                 vulnerability_assessment_name: pulumi.Input[str],
                 rule_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a DatabaseSqlVulnerabilityAssessmentRuleBaseline resource.
        :param pulumi.Input[str] database_name: The name of the database.
        :param pulumi.Input[bool] latest_scan: The latest scan flag
        :param pulumi.Input[str] resource_group_name: The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
        :param pulumi.Input[Sequence[pulumi.Input[Sequence[pulumi.Input[str]]]]] results: The rule baseline result
        :param pulumi.Input[str] server_name: The name of the server.
        :param pulumi.Input[str] vulnerability_assessment_name: The name of the vulnerability assessment.
        :param pulumi.Input[str] rule_id: The vulnerability assessment rule ID.
        """
        pulumi.set(__self__, "baseline_name", baseline_name)
        pulumi.set(__self__, "database_name", database_name)
        pulumi.set(__self__, "latest_scan", latest_scan)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "results", results)
        pulumi.set(__self__, "server_name", server_name)
        pulumi.set(__self__, "vulnerability_assessment_name", vulnerability_assessment_name)
        if rule_id is not None:
            pulumi.set(__self__, "rule_id", rule_id)

    @property
    @pulumi.getter(name="baselineName")
    def baseline_name(self) -> pulumi.Input[str]:
        return pulumi.get(self, "baseline_name")

    @baseline_name.setter
    def baseline_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "baseline_name", value)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> pulumi.Input[str]:
        """
        The name of the database.
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "database_name", value)

    @property
    @pulumi.getter(name="latestScan")
    def latest_scan(self) -> pulumi.Input[bool]:
        """
        The latest scan flag
        """
        return pulumi.get(self, "latest_scan")

    @latest_scan.setter
    def latest_scan(self, value: pulumi.Input[bool]):
        pulumi.set(self, "latest_scan", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[str]:
        """
        The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter
    def results(self) -> pulumi.Input[Sequence[pulumi.Input[Sequence[pulumi.Input[str]]]]]:
        """
        The rule baseline result
        """
        return pulumi.get(self, "results")

    @results.setter
    def results(self, value: pulumi.Input[Sequence[pulumi.Input[Sequence[pulumi.Input[str]]]]]):
        pulumi.set(self, "results", value)

    @property
    @pulumi.getter(name="serverName")
    def server_name(self) -> pulumi.Input[str]:
        """
        The name of the server.
        """
        return pulumi.get(self, "server_name")

    @server_name.setter
    def server_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "server_name", value)

    @property
    @pulumi.getter(name="vulnerabilityAssessmentName")
    def vulnerability_assessment_name(self) -> pulumi.Input[str]:
        """
        The name of the vulnerability assessment.
        """
        return pulumi.get(self, "vulnerability_assessment_name")

    @vulnerability_assessment_name.setter
    def vulnerability_assessment_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "vulnerability_assessment_name", value)

    @property
    @pulumi.getter(name="ruleId")
    def rule_id(self) -> Optional[pulumi.Input[str]]:
        """
        The vulnerability assessment rule ID.
        """
        return pulumi.get(self, "rule_id")

    @rule_id.setter
    def rule_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "rule_id", value)


class DatabaseSqlVulnerabilityAssessmentRuleBaseline(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 baseline_name: Optional[pulumi.Input[str]] = None,
                 database_name: Optional[pulumi.Input[str]] = None,
                 latest_scan: Optional[pulumi.Input[bool]] = None,
                 resource_group_name: Optional[pulumi.Input[str]] = None,
                 results: Optional[pulumi.Input[Sequence[pulumi.Input[Sequence[pulumi.Input[str]]]]]] = None,
                 rule_id: Optional[pulumi.Input[str]] = None,
                 server_name: Optional[pulumi.Input[str]] = None,
                 vulnerability_assessment_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        A database sql vulnerability assessment rule baseline.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] database_name: The name of the database.
        :param pulumi.Input[bool] latest_scan: The latest scan flag
        :param pulumi.Input[str] resource_group_name: The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
        :param pulumi.Input[Sequence[pulumi.Input[Sequence[pulumi.Input[str]]]]] results: The rule baseline result
        :param pulumi.Input[str] rule_id: The vulnerability assessment rule ID.
        :param pulumi.Input[str] server_name: The name of the server.
        :param pulumi.Input[str] vulnerability_assessment_name: The name of the vulnerability assessment.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DatabaseSqlVulnerabilityAssessmentRuleBaselineArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A database sql vulnerability assessment rule baseline.

        :param str resource_name: The name of the resource.
        :param DatabaseSqlVulnerabilityAssessmentRuleBaselineArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DatabaseSqlVulnerabilityAssessmentRuleBaselineArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 baseline_name: Optional[pulumi.Input[str]] = None,
                 database_name: Optional[pulumi.Input[str]] = None,
                 latest_scan: Optional[pulumi.Input[bool]] = None,
                 resource_group_name: Optional[pulumi.Input[str]] = None,
                 results: Optional[pulumi.Input[Sequence[pulumi.Input[Sequence[pulumi.Input[str]]]]]] = None,
                 rule_id: Optional[pulumi.Input[str]] = None,
                 server_name: Optional[pulumi.Input[str]] = None,
                 vulnerability_assessment_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DatabaseSqlVulnerabilityAssessmentRuleBaselineArgs.__new__(DatabaseSqlVulnerabilityAssessmentRuleBaselineArgs)

            if baseline_name is None and not opts.urn:
                raise TypeError("Missing required property 'baseline_name'")
            __props__.__dict__["baseline_name"] = baseline_name
            if database_name is None and not opts.urn:
                raise TypeError("Missing required property 'database_name'")
            __props__.__dict__["database_name"] = database_name
            if latest_scan is None and not opts.urn:
                raise TypeError("Missing required property 'latest_scan'")
            __props__.__dict__["latest_scan"] = latest_scan
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            if results is None and not opts.urn:
                raise TypeError("Missing required property 'results'")
            __props__.__dict__["results"] = results
            __props__.__dict__["rule_id"] = rule_id
            if server_name is None and not opts.urn:
                raise TypeError("Missing required property 'server_name'")
            __props__.__dict__["server_name"] = server_name
            if vulnerability_assessment_name is None and not opts.urn:
                raise TypeError("Missing required property 'vulnerability_assessment_name'")
            __props__.__dict__["vulnerability_assessment_name"] = vulnerability_assessment_name
            __props__.__dict__["name"] = None
            __props__.__dict__["system_data"] = None
            __props__.__dict__["type"] = None
        super(DatabaseSqlVulnerabilityAssessmentRuleBaseline, __self__).__init__(
            'azure-native:sql/v20220201preview:DatabaseSqlVulnerabilityAssessmentRuleBaseline',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'DatabaseSqlVulnerabilityAssessmentRuleBaseline':
        """
        Get an existing DatabaseSqlVulnerabilityAssessmentRuleBaseline resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = DatabaseSqlVulnerabilityAssessmentRuleBaselineArgs.__new__(DatabaseSqlVulnerabilityAssessmentRuleBaselineArgs)

        __props__.__dict__["name"] = None
        __props__.__dict__["results"] = None
        __props__.__dict__["system_data"] = None
        __props__.__dict__["type"] = None
        return DatabaseSqlVulnerabilityAssessmentRuleBaseline(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Resource name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def results(self) -> pulumi.Output[Sequence[Sequence[str]]]:
        """
        The rule baseline result
        """
        return pulumi.get(self, "results")

    @property
    @pulumi.getter(name="systemData")
    def system_data(self) -> pulumi.Output['outputs.SystemDataResponse']:
        """
        SystemData of DatabaseSqlVulnerabilityAssessmentRuleBaselineResource.
        """
        return pulumi.get(self, "system_data")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        Resource type.
        """
        return pulumi.get(self, "type")

