# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetVirtualNetworkLinkResult',
    'AwaitableGetVirtualNetworkLinkResult',
    'get_virtual_network_link',
    'get_virtual_network_link_output',
]

@pulumi.output_type
class GetVirtualNetworkLinkResult:
    """
    Describes a virtual network link.
    """
    def __init__(__self__, etag=None, id=None, metadata=None, name=None, provisioning_state=None, system_data=None, type=None, virtual_network=None):
        if etag and not isinstance(etag, str):
            raise TypeError("Expected argument 'etag' to be a str")
        pulumi.set(__self__, "etag", etag)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if metadata and not isinstance(metadata, dict):
            raise TypeError("Expected argument 'metadata' to be a dict")
        pulumi.set(__self__, "metadata", metadata)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if provisioning_state and not isinstance(provisioning_state, str):
            raise TypeError("Expected argument 'provisioning_state' to be a str")
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if system_data and not isinstance(system_data, dict):
            raise TypeError("Expected argument 'system_data' to be a dict")
        pulumi.set(__self__, "system_data", system_data)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if virtual_network and not isinstance(virtual_network, dict):
            raise TypeError("Expected argument 'virtual_network' to be a dict")
        pulumi.set(__self__, "virtual_network", virtual_network)

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        ETag of the virtual network link.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def metadata(self) -> Optional[Mapping[str, str]]:
        """
        Metadata attached to the virtual network link.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The current provisioning state of the virtual network link. This is a read-only property and any attempt to set this value will be ignored.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="systemData")
    def system_data(self) -> 'outputs.SystemDataResponse':
        """
        Metadata pertaining to creation and last modification of the resource.
        """
        return pulumi.get(self, "system_data")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="virtualNetwork")
    def virtual_network(self) -> 'outputs.SubResourceResponse':
        """
        The reference to the virtual network. This cannot be changed after creation.
        """
        return pulumi.get(self, "virtual_network")


class AwaitableGetVirtualNetworkLinkResult(GetVirtualNetworkLinkResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVirtualNetworkLinkResult(
            etag=self.etag,
            id=self.id,
            metadata=self.metadata,
            name=self.name,
            provisioning_state=self.provisioning_state,
            system_data=self.system_data,
            type=self.type,
            virtual_network=self.virtual_network)


def get_virtual_network_link(dns_forwarding_ruleset_name: Optional[str] = None,
                             resource_group_name: Optional[str] = None,
                             virtual_network_link_name: Optional[str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVirtualNetworkLinkResult:
    """
    Describes a virtual network link.


    :param str dns_forwarding_ruleset_name: The name of the DNS forwarding ruleset.
    :param str resource_group_name: The name of the resource group. The name is case insensitive.
    :param str virtual_network_link_name: The name of the virtual network link.
    """
    __args__ = dict()
    __args__['dnsForwardingRulesetName'] = dns_forwarding_ruleset_name
    __args__['resourceGroupName'] = resource_group_name
    __args__['virtualNetworkLinkName'] = virtual_network_link_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure-native:network/v20220701:getVirtualNetworkLink', __args__, opts=opts, typ=GetVirtualNetworkLinkResult).value

    return AwaitableGetVirtualNetworkLinkResult(
        etag=__ret__.etag,
        id=__ret__.id,
        metadata=__ret__.metadata,
        name=__ret__.name,
        provisioning_state=__ret__.provisioning_state,
        system_data=__ret__.system_data,
        type=__ret__.type,
        virtual_network=__ret__.virtual_network)


@_utilities.lift_output_func(get_virtual_network_link)
def get_virtual_network_link_output(dns_forwarding_ruleset_name: Optional[pulumi.Input[str]] = None,
                                    resource_group_name: Optional[pulumi.Input[str]] = None,
                                    virtual_network_link_name: Optional[pulumi.Input[str]] = None,
                                    opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetVirtualNetworkLinkResult]:
    """
    Describes a virtual network link.


    :param str dns_forwarding_ruleset_name: The name of the DNS forwarding ruleset.
    :param str resource_group_name: The name of the resource group. The name is case insensitive.
    :param str virtual_network_link_name: The name of the virtual network link.
    """
    ...
