# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetWorkflowResult',
    'AwaitableGetWorkflowResult',
    'get_workflow',
    'get_workflow_output',
]

@pulumi.output_type
class GetWorkflowResult:
    """
    Resource representation of a workflow
    """
    def __init__(__self__, acr=None, aks_resource_id=None, auth_status=None, branch_name=None, deployment_properties=None, docker_build_context=None, dockerfile=None, id=None, last_workflow_run=None, location=None, name=None, namespace=None, oidc_credentials=None, pr_status=None, pr_url=None, pull_number=None, repository_name=None, repository_owner=None, system_data=None, tags=None, type=None):
        if acr and not isinstance(acr, dict):
            raise TypeError("Expected argument 'acr' to be a dict")
        pulumi.set(__self__, "acr", acr)
        if aks_resource_id and not isinstance(aks_resource_id, str):
            raise TypeError("Expected argument 'aks_resource_id' to be a str")
        pulumi.set(__self__, "aks_resource_id", aks_resource_id)
        if auth_status and not isinstance(auth_status, str):
            raise TypeError("Expected argument 'auth_status' to be a str")
        pulumi.set(__self__, "auth_status", auth_status)
        if branch_name and not isinstance(branch_name, str):
            raise TypeError("Expected argument 'branch_name' to be a str")
        pulumi.set(__self__, "branch_name", branch_name)
        if deployment_properties and not isinstance(deployment_properties, dict):
            raise TypeError("Expected argument 'deployment_properties' to be a dict")
        pulumi.set(__self__, "deployment_properties", deployment_properties)
        if docker_build_context and not isinstance(docker_build_context, str):
            raise TypeError("Expected argument 'docker_build_context' to be a str")
        pulumi.set(__self__, "docker_build_context", docker_build_context)
        if dockerfile and not isinstance(dockerfile, str):
            raise TypeError("Expected argument 'dockerfile' to be a str")
        pulumi.set(__self__, "dockerfile", dockerfile)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if last_workflow_run and not isinstance(last_workflow_run, dict):
            raise TypeError("Expected argument 'last_workflow_run' to be a dict")
        pulumi.set(__self__, "last_workflow_run", last_workflow_run)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if namespace and not isinstance(namespace, str):
            raise TypeError("Expected argument 'namespace' to be a str")
        pulumi.set(__self__, "namespace", namespace)
        if oidc_credentials and not isinstance(oidc_credentials, dict):
            raise TypeError("Expected argument 'oidc_credentials' to be a dict")
        pulumi.set(__self__, "oidc_credentials", oidc_credentials)
        if pr_status and not isinstance(pr_status, str):
            raise TypeError("Expected argument 'pr_status' to be a str")
        pulumi.set(__self__, "pr_status", pr_status)
        if pr_url and not isinstance(pr_url, str):
            raise TypeError("Expected argument 'pr_url' to be a str")
        pulumi.set(__self__, "pr_url", pr_url)
        if pull_number and not isinstance(pull_number, int):
            raise TypeError("Expected argument 'pull_number' to be a int")
        pulumi.set(__self__, "pull_number", pull_number)
        if repository_name and not isinstance(repository_name, str):
            raise TypeError("Expected argument 'repository_name' to be a str")
        pulumi.set(__self__, "repository_name", repository_name)
        if repository_owner and not isinstance(repository_owner, str):
            raise TypeError("Expected argument 'repository_owner' to be a str")
        pulumi.set(__self__, "repository_owner", repository_owner)
        if system_data and not isinstance(system_data, dict):
            raise TypeError("Expected argument 'system_data' to be a dict")
        pulumi.set(__self__, "system_data", system_data)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def acr(self) -> Optional['outputs.ACRResponse']:
        """
        Information on the azure container registry
        """
        return pulumi.get(self, "acr")

    @property
    @pulumi.getter(name="aksResourceId")
    def aks_resource_id(self) -> Optional[str]:
        """
        The Azure Kubernetes Cluster Resource the application will be deployed to.
        """
        return pulumi.get(self, "aks_resource_id")

    @property
    @pulumi.getter(name="authStatus")
    def auth_status(self) -> str:
        """
        Determines the authorization status of requests.
        """
        return pulumi.get(self, "auth_status")

    @property
    @pulumi.getter(name="branchName")
    def branch_name(self) -> Optional[str]:
        """
        Repository Branch Name
        """
        return pulumi.get(self, "branch_name")

    @property
    @pulumi.getter(name="deploymentProperties")
    def deployment_properties(self) -> Optional['outputs.DeploymentPropertiesResponse']:
        return pulumi.get(self, "deployment_properties")

    @property
    @pulumi.getter(name="dockerBuildContext")
    def docker_build_context(self) -> Optional[str]:
        """
        Path to Dockerfile Build Context within the repository.
        """
        return pulumi.get(self, "docker_build_context")

    @property
    @pulumi.getter
    def dockerfile(self) -> Optional[str]:
        """
        Path to the Dockerfile within the repository.
        """
        return pulumi.get(self, "dockerfile")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lastWorkflowRun")
    def last_workflow_run(self) -> Optional['outputs.WorkflowRunResponse']:
        return pulumi.get(self, "last_workflow_run")

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        The geo-location where the resource lives
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def namespace(self) -> Optional[str]:
        """
        Kubernetes namespace the application is deployed to.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="oidcCredentials")
    def oidc_credentials(self) -> Optional['outputs.GitHubWorkflowProfileResponseOidcCredentials']:
        """
        The fields needed for OIDC with GitHub.
        """
        return pulumi.get(self, "oidc_credentials")

    @property
    @pulumi.getter(name="prStatus")
    def pr_status(self) -> str:
        """
        The status of the Pull Request submitted against the users repository.
        """
        return pulumi.get(self, "pr_status")

    @property
    @pulumi.getter(name="prURL")
    def pr_url(self) -> str:
        """
        The URL to the Pull Request submitted against the users repository.
        """
        return pulumi.get(self, "pr_url")

    @property
    @pulumi.getter(name="pullNumber")
    def pull_number(self) -> int:
        """
        The number associated with the submitted pull request.
        """
        return pulumi.get(self, "pull_number")

    @property
    @pulumi.getter(name="repositoryName")
    def repository_name(self) -> Optional[str]:
        """
        Repository Name
        """
        return pulumi.get(self, "repository_name")

    @property
    @pulumi.getter(name="repositoryOwner")
    def repository_owner(self) -> Optional[str]:
        """
        Repository Owner
        """
        return pulumi.get(self, "repository_owner")

    @property
    @pulumi.getter(name="systemData")
    def system_data(self) -> 'outputs.SystemDataResponse':
        """
        Azure Resource Manager metadata containing createdBy and modifiedBy information.
        """
        return pulumi.get(self, "system_data")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Resource tags.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
        """
        return pulumi.get(self, "type")


class AwaitableGetWorkflowResult(GetWorkflowResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetWorkflowResult(
            acr=self.acr,
            aks_resource_id=self.aks_resource_id,
            auth_status=self.auth_status,
            branch_name=self.branch_name,
            deployment_properties=self.deployment_properties,
            docker_build_context=self.docker_build_context,
            dockerfile=self.dockerfile,
            id=self.id,
            last_workflow_run=self.last_workflow_run,
            location=self.location,
            name=self.name,
            namespace=self.namespace,
            oidc_credentials=self.oidc_credentials,
            pr_status=self.pr_status,
            pr_url=self.pr_url,
            pull_number=self.pull_number,
            repository_name=self.repository_name,
            repository_owner=self.repository_owner,
            system_data=self.system_data,
            tags=self.tags,
            type=self.type)


def get_workflow(resource_group_name: Optional[str] = None,
                 workflow_name: Optional[str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetWorkflowResult:
    """
    Resource representation of a workflow


    :param str resource_group_name: The name of the resource group. The name is case insensitive.
    :param str workflow_name: The name of the workflow resource.
    """
    __args__ = dict()
    __args__['resourceGroupName'] = resource_group_name
    __args__['workflowName'] = workflow_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure-native:devhub/v20220401preview:getWorkflow', __args__, opts=opts, typ=GetWorkflowResult).value

    return AwaitableGetWorkflowResult(
        acr=__ret__.acr,
        aks_resource_id=__ret__.aks_resource_id,
        auth_status=__ret__.auth_status,
        branch_name=__ret__.branch_name,
        deployment_properties=__ret__.deployment_properties,
        docker_build_context=__ret__.docker_build_context,
        dockerfile=__ret__.dockerfile,
        id=__ret__.id,
        last_workflow_run=__ret__.last_workflow_run,
        location=__ret__.location,
        name=__ret__.name,
        namespace=__ret__.namespace,
        oidc_credentials=__ret__.oidc_credentials,
        pr_status=__ret__.pr_status,
        pr_url=__ret__.pr_url,
        pull_number=__ret__.pull_number,
        repository_name=__ret__.repository_name,
        repository_owner=__ret__.repository_owner,
        system_data=__ret__.system_data,
        tags=__ret__.tags,
        type=__ret__.type)


@_utilities.lift_output_func(get_workflow)
def get_workflow_output(resource_group_name: Optional[pulumi.Input[str]] = None,
                        workflow_name: Optional[pulumi.Input[str]] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetWorkflowResult]:
    """
    Resource representation of a workflow


    :param str resource_group_name: The name of the resource group. The name is case insensitive.
    :param str workflow_name: The name of the workflow resource.
    """
    ...
