# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'ActivityEntityQueriesPropertiesResponseQueryDefinitions',
    'ActivityTimelineItemResponse',
    'AlertDetailsOverrideResponse',
    'AlertsDataTypeOfDataConnectorResponse',
    'AutomationRuleModifyPropertiesActionResponse',
    'AutomationRulePropertyValuesConditionResponse',
    'AutomationRuleRunPlaybookActionResponse',
    'AutomationRuleTriggeringLogicResponse',
    'AvailabilityResponse',
    'AwsCloudTrailDataConnectorDataTypesResponse',
    'AwsCloudTrailDataConnectorDataTypesResponseLogs',
    'AwsS3DataConnectorDataTypesResponse',
    'AwsS3DataConnectorDataTypesResponseLogs',
    'BookmarkEntityMappingsResponse',
    'BookmarkTimelineItemResponse',
    'ClientInfoResponse',
    'CodelessConnectorPollingAuthPropertiesResponse',
    'CodelessConnectorPollingConfigPropertiesResponse',
    'CodelessConnectorPollingPagingPropertiesResponse',
    'CodelessConnectorPollingRequestPropertiesResponse',
    'CodelessConnectorPollingResponsePropertiesResponse',
    'CodelessUiConnectorConfigPropertiesResponse',
    'CodelessUiConnectorConfigPropertiesResponseConnectivityCriteria',
    'CodelessUiConnectorConfigPropertiesResponseDataTypes',
    'CodelessUiConnectorConfigPropertiesResponseGraphQueries',
    'CodelessUiConnectorConfigPropertiesResponseInstructionSteps',
    'CodelessUiConnectorConfigPropertiesResponseSampleQueries',
    'ContentPathMapResponse',
    'DataConnectorDataTypeCommonResponse',
    'Dynamics365DataConnectorDataTypesResponse',
    'Dynamics365DataConnectorDataTypesResponseDynamics365CdsActivities',
    'EntityFieldMappingResponse',
    'EntityInsightItemResponse',
    'EntityInsightItemResponseQueryTimeInterval',
    'EntityMappingResponse',
    'EventGroupingSettingsResponse',
    'FieldMappingResponse',
    'FusionScenarioExclusionPatternResponse',
    'FusionSourceSettingsResponse',
    'FusionSourceSubTypeSettingResponse',
    'FusionSubTypeSeverityFilterResponse',
    'FusionSubTypeSeverityFiltersItemResponse',
    'GetInsightsErrorResponse',
    'GetInsightsResultsMetadataResponse',
    'GroupingConfigurationResponse',
    'IncidentAdditionalDataResponse',
    'IncidentConfigurationResponse',
    'IncidentInfoResponse',
    'IncidentLabelResponse',
    'IncidentOwnerInfoResponse',
    'IncidentPropertiesActionResponse',
    'InsightsTableResultResponse',
    'InsightsTableResultResponseColumns',
    'InstructionStepsResponseInstructions',
    'MCASDataConnectorDataTypesResponse',
    'MSTIDataConnectorDataTypesResponse',
    'MSTIDataConnectorDataTypesResponseBingSafetyPhishingURL',
    'MSTIDataConnectorDataTypesResponseMicrosoftEmergingThreatFeed',
    'MTPDataConnectorDataTypesResponse',
    'MTPDataConnectorDataTypesResponseIncidents',
    'MetadataAuthorResponse',
    'MetadataCategoriesResponse',
    'MetadataDependenciesResponse',
    'MetadataSourceResponse',
    'MetadataSupportResponse',
    'Office365ProjectConnectorDataTypesResponse',
    'Office365ProjectConnectorDataTypesResponseLogs',
    'OfficeDataConnectorDataTypesResponse',
    'OfficeDataConnectorDataTypesResponseExchange',
    'OfficeDataConnectorDataTypesResponseSharePoint',
    'OfficeDataConnectorDataTypesResponseTeams',
    'OfficePowerBIConnectorDataTypesResponse',
    'OfficePowerBIConnectorDataTypesResponseLogs',
    'PermissionsResponse',
    'PermissionsResponseCustoms',
    'PermissionsResponseResourceProvider',
    'PlaybookActionPropertiesResponse',
    'PropertyConditionPropertiesResponse',
    'RepoResponse',
    'RepositoryResponse',
    'RequiredPermissionsResponse',
    'SecurityAlertTimelineItemResponse',
    'SystemDataResponse',
    'TIDataConnectorDataTypesResponse',
    'TIDataConnectorDataTypesResponseIndicators',
    'TeamInformationResponse',
    'TiTaxiiDataConnectorDataTypesResponse',
    'TiTaxiiDataConnectorDataTypesResponseTaxiiClient',
    'TimelineAggregationResponse',
    'TimelineErrorResponse',
    'TimelineResultsMetadataResponse',
    'UserInfoResponse',
    'WatchlistUserInfoResponse',
]

@pulumi.output_type
class ActivityEntityQueriesPropertiesResponseQueryDefinitions(dict):
    """
    The Activity query definitions
    """
    def __init__(__self__, *,
                 query: Optional[str] = None):
        """
        The Activity query definitions
        :param str query: The Activity query to run on a given entity
        """
        if query is not None:
            pulumi.set(__self__, "query", query)

    @property
    @pulumi.getter
    def query(self) -> Optional[str]:
        """
        The Activity query to run on a given entity
        """
        return pulumi.get(self, "query")


@pulumi.output_type
class ActivityTimelineItemResponse(dict):
    """
    Represents Activity timeline item.
    """
    def __init__(__self__, *,
                 bucket_end_time_utc: str,
                 bucket_start_time_utc: str,
                 content: str,
                 first_activity_time_utc: str,
                 kind: str,
                 last_activity_time_utc: str,
                 query_id: str,
                 title: str):
        """
        Represents Activity timeline item.
        :param str bucket_end_time_utc: The grouping bucket end time.
        :param str bucket_start_time_utc: The grouping bucket start time.
        :param str content: The activity timeline content.
        :param str first_activity_time_utc: The time of the first activity in the grouping bucket.
        :param str kind: The entity query kind
               Expected value is 'Activity'.
        :param str last_activity_time_utc: The time of the last activity in the grouping bucket.
        :param str query_id: The activity query id.
        :param str title: The activity timeline title.
        """
        pulumi.set(__self__, "bucket_end_time_utc", bucket_end_time_utc)
        pulumi.set(__self__, "bucket_start_time_utc", bucket_start_time_utc)
        pulumi.set(__self__, "content", content)
        pulumi.set(__self__, "first_activity_time_utc", first_activity_time_utc)
        pulumi.set(__self__, "kind", 'Activity')
        pulumi.set(__self__, "last_activity_time_utc", last_activity_time_utc)
        pulumi.set(__self__, "query_id", query_id)
        pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter(name="bucketEndTimeUTC")
    def bucket_end_time_utc(self) -> str:
        """
        The grouping bucket end time.
        """
        return pulumi.get(self, "bucket_end_time_utc")

    @property
    @pulumi.getter(name="bucketStartTimeUTC")
    def bucket_start_time_utc(self) -> str:
        """
        The grouping bucket start time.
        """
        return pulumi.get(self, "bucket_start_time_utc")

    @property
    @pulumi.getter
    def content(self) -> str:
        """
        The activity timeline content.
        """
        return pulumi.get(self, "content")

    @property
    @pulumi.getter(name="firstActivityTimeUTC")
    def first_activity_time_utc(self) -> str:
        """
        The time of the first activity in the grouping bucket.
        """
        return pulumi.get(self, "first_activity_time_utc")

    @property
    @pulumi.getter
    def kind(self) -> str:
        """
        The entity query kind
        Expected value is 'Activity'.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter(name="lastActivityTimeUTC")
    def last_activity_time_utc(self) -> str:
        """
        The time of the last activity in the grouping bucket.
        """
        return pulumi.get(self, "last_activity_time_utc")

    @property
    @pulumi.getter(name="queryId")
    def query_id(self) -> str:
        """
        The activity query id.
        """
        return pulumi.get(self, "query_id")

    @property
    @pulumi.getter
    def title(self) -> str:
        """
        The activity timeline title.
        """
        return pulumi.get(self, "title")


@pulumi.output_type
class AlertDetailsOverrideResponse(dict):
    """
    Settings for how to dynamically override alert static details
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "alertDescriptionFormat":
            suggest = "alert_description_format"
        elif key == "alertDisplayNameFormat":
            suggest = "alert_display_name_format"
        elif key == "alertSeverityColumnName":
            suggest = "alert_severity_column_name"
        elif key == "alertTacticsColumnName":
            suggest = "alert_tactics_column_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AlertDetailsOverrideResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AlertDetailsOverrideResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AlertDetailsOverrideResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 alert_description_format: Optional[str] = None,
                 alert_display_name_format: Optional[str] = None,
                 alert_severity_column_name: Optional[str] = None,
                 alert_tactics_column_name: Optional[str] = None):
        """
        Settings for how to dynamically override alert static details
        :param str alert_description_format: the format containing columns name(s) to override the alert description
        :param str alert_display_name_format: the format containing columns name(s) to override the alert name
        :param str alert_severity_column_name: the column name to take the alert severity from
        :param str alert_tactics_column_name: the column name to take the alert tactics from
        """
        if alert_description_format is not None:
            pulumi.set(__self__, "alert_description_format", alert_description_format)
        if alert_display_name_format is not None:
            pulumi.set(__self__, "alert_display_name_format", alert_display_name_format)
        if alert_severity_column_name is not None:
            pulumi.set(__self__, "alert_severity_column_name", alert_severity_column_name)
        if alert_tactics_column_name is not None:
            pulumi.set(__self__, "alert_tactics_column_name", alert_tactics_column_name)

    @property
    @pulumi.getter(name="alertDescriptionFormat")
    def alert_description_format(self) -> Optional[str]:
        """
        the format containing columns name(s) to override the alert description
        """
        return pulumi.get(self, "alert_description_format")

    @property
    @pulumi.getter(name="alertDisplayNameFormat")
    def alert_display_name_format(self) -> Optional[str]:
        """
        the format containing columns name(s) to override the alert name
        """
        return pulumi.get(self, "alert_display_name_format")

    @property
    @pulumi.getter(name="alertSeverityColumnName")
    def alert_severity_column_name(self) -> Optional[str]:
        """
        the column name to take the alert severity from
        """
        return pulumi.get(self, "alert_severity_column_name")

    @property
    @pulumi.getter(name="alertTacticsColumnName")
    def alert_tactics_column_name(self) -> Optional[str]:
        """
        the column name to take the alert tactics from
        """
        return pulumi.get(self, "alert_tactics_column_name")


@pulumi.output_type
class AlertsDataTypeOfDataConnectorResponse(dict):
    """
    Alerts data type for data connectors.
    """
    def __init__(__self__, *,
                 alerts: 'outputs.DataConnectorDataTypeCommonResponse'):
        """
        Alerts data type for data connectors.
        :param 'DataConnectorDataTypeCommonResponse' alerts: Alerts data type connection.
        """
        pulumi.set(__self__, "alerts", alerts)

    @property
    @pulumi.getter
    def alerts(self) -> 'outputs.DataConnectorDataTypeCommonResponse':
        """
        Alerts data type connection.
        """
        return pulumi.get(self, "alerts")


@pulumi.output_type
class AutomationRuleModifyPropertiesActionResponse(dict):
    """
    Describes an automation rule action to modify an object's properties
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "actionType":
            suggest = "action_type"
        elif key == "actionConfiguration":
            suggest = "action_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AutomationRuleModifyPropertiesActionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AutomationRuleModifyPropertiesActionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AutomationRuleModifyPropertiesActionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action_type: str,
                 order: int,
                 action_configuration: Optional['outputs.IncidentPropertiesActionResponse'] = None):
        """
        Describes an automation rule action to modify an object's properties
        :param str action_type: The type of the automation rule action
               Expected value is 'ModifyProperties'.
        """
        pulumi.set(__self__, "action_type", 'ModifyProperties')
        pulumi.set(__self__, "order", order)
        if action_configuration is not None:
            pulumi.set(__self__, "action_configuration", action_configuration)

    @property
    @pulumi.getter(name="actionType")
    def action_type(self) -> str:
        """
        The type of the automation rule action
        Expected value is 'ModifyProperties'.
        """
        return pulumi.get(self, "action_type")

    @property
    @pulumi.getter
    def order(self) -> int:
        return pulumi.get(self, "order")

    @property
    @pulumi.getter(name="actionConfiguration")
    def action_configuration(self) -> Optional['outputs.IncidentPropertiesActionResponse']:
        return pulumi.get(self, "action_configuration")


@pulumi.output_type
class AutomationRulePropertyValuesConditionResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "propertyName":
            suggest = "property_name"
        elif key == "propertyValues":
            suggest = "property_values"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AutomationRulePropertyValuesConditionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AutomationRulePropertyValuesConditionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AutomationRulePropertyValuesConditionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 operator: Optional[str] = None,
                 property_name: Optional[str] = None,
                 property_values: Optional[Sequence[str]] = None):
        """
        :param str property_name: The property to evaluate in an automation rule property condition
        """
        if operator is not None:
            pulumi.set(__self__, "operator", operator)
        if property_name is not None:
            pulumi.set(__self__, "property_name", property_name)
        if property_values is not None:
            pulumi.set(__self__, "property_values", property_values)

    @property
    @pulumi.getter
    def operator(self) -> Optional[str]:
        return pulumi.get(self, "operator")

    @property
    @pulumi.getter(name="propertyName")
    def property_name(self) -> Optional[str]:
        """
        The property to evaluate in an automation rule property condition
        """
        return pulumi.get(self, "property_name")

    @property
    @pulumi.getter(name="propertyValues")
    def property_values(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "property_values")


@pulumi.output_type
class AutomationRuleRunPlaybookActionResponse(dict):
    """
    Describes an automation rule action to run a playbook
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "actionType":
            suggest = "action_type"
        elif key == "actionConfiguration":
            suggest = "action_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AutomationRuleRunPlaybookActionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AutomationRuleRunPlaybookActionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AutomationRuleRunPlaybookActionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action_type: str,
                 order: int,
                 action_configuration: Optional['outputs.PlaybookActionPropertiesResponse'] = None):
        """
        Describes an automation rule action to run a playbook
        :param str action_type: The type of the automation rule action
               Expected value is 'RunPlaybook'.
        """
        pulumi.set(__self__, "action_type", 'RunPlaybook')
        pulumi.set(__self__, "order", order)
        if action_configuration is not None:
            pulumi.set(__self__, "action_configuration", action_configuration)

    @property
    @pulumi.getter(name="actionType")
    def action_type(self) -> str:
        """
        The type of the automation rule action
        Expected value is 'RunPlaybook'.
        """
        return pulumi.get(self, "action_type")

    @property
    @pulumi.getter
    def order(self) -> int:
        return pulumi.get(self, "order")

    @property
    @pulumi.getter(name="actionConfiguration")
    def action_configuration(self) -> Optional['outputs.PlaybookActionPropertiesResponse']:
        return pulumi.get(self, "action_configuration")


@pulumi.output_type
class AutomationRuleTriggeringLogicResponse(dict):
    """
    Describes automation rule triggering logic
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isEnabled":
            suggest = "is_enabled"
        elif key == "triggersOn":
            suggest = "triggers_on"
        elif key == "triggersWhen":
            suggest = "triggers_when"
        elif key == "expirationTimeUtc":
            suggest = "expiration_time_utc"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AutomationRuleTriggeringLogicResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AutomationRuleTriggeringLogicResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AutomationRuleTriggeringLogicResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 is_enabled: bool,
                 triggers_on: str,
                 triggers_when: str,
                 conditions: Optional[Sequence['outputs.PropertyConditionPropertiesResponse']] = None,
                 expiration_time_utc: Optional[str] = None):
        """
        Describes automation rule triggering logic
        :param bool is_enabled: Determines whether the automation rule is enabled or disabled
        :param Sequence['PropertyConditionPropertiesResponse'] conditions: The conditions to evaluate to determine if the automation rule should be triggered on a given object
        :param str expiration_time_utc: Determines when the automation rule should automatically expire and be disabled.
        """
        pulumi.set(__self__, "is_enabled", is_enabled)
        pulumi.set(__self__, "triggers_on", triggers_on)
        pulumi.set(__self__, "triggers_when", triggers_when)
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if expiration_time_utc is not None:
            pulumi.set(__self__, "expiration_time_utc", expiration_time_utc)

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> bool:
        """
        Determines whether the automation rule is enabled or disabled
        """
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter(name="triggersOn")
    def triggers_on(self) -> str:
        return pulumi.get(self, "triggers_on")

    @property
    @pulumi.getter(name="triggersWhen")
    def triggers_when(self) -> str:
        return pulumi.get(self, "triggers_when")

    @property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['outputs.PropertyConditionPropertiesResponse']]:
        """
        The conditions to evaluate to determine if the automation rule should be triggered on a given object
        """
        return pulumi.get(self, "conditions")

    @property
    @pulumi.getter(name="expirationTimeUtc")
    def expiration_time_utc(self) -> Optional[str]:
        """
        Determines when the automation rule should automatically expire and be disabled.
        """
        return pulumi.get(self, "expiration_time_utc")


@pulumi.output_type
class AvailabilityResponse(dict):
    """
    Connector Availability Status
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isPreview":
            suggest = "is_preview"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AvailabilityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AvailabilityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AvailabilityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 is_preview: Optional[bool] = None,
                 status: Optional[int] = None):
        """
        Connector Availability Status
        :param bool is_preview: Set connector as preview
        :param int status: The connector Availability Status
        """
        if is_preview is not None:
            pulumi.set(__self__, "is_preview", is_preview)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="isPreview")
    def is_preview(self) -> Optional[bool]:
        """
        Set connector as preview
        """
        return pulumi.get(self, "is_preview")

    @property
    @pulumi.getter
    def status(self) -> Optional[int]:
        """
        The connector Availability Status
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class AwsCloudTrailDataConnectorDataTypesResponse(dict):
    """
    The available data types for Amazon Web Services CloudTrail data connector.
    """
    def __init__(__self__, *,
                 logs: 'outputs.AwsCloudTrailDataConnectorDataTypesResponseLogs'):
        """
        The available data types for Amazon Web Services CloudTrail data connector.
        :param 'AwsCloudTrailDataConnectorDataTypesResponseLogs' logs: Logs data type.
        """
        pulumi.set(__self__, "logs", logs)

    @property
    @pulumi.getter
    def logs(self) -> 'outputs.AwsCloudTrailDataConnectorDataTypesResponseLogs':
        """
        Logs data type.
        """
        return pulumi.get(self, "logs")


@pulumi.output_type
class AwsCloudTrailDataConnectorDataTypesResponseLogs(dict):
    """
    Logs data type.
    """
    def __init__(__self__, *,
                 state: str):
        """
        Logs data type.
        :param str state: Describe whether this data type connection is enabled or not.
        """
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        Describe whether this data type connection is enabled or not.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class AwsS3DataConnectorDataTypesResponse(dict):
    """
    The available data types for Amazon Web Services S3 data connector.
    """
    def __init__(__self__, *,
                 logs: 'outputs.AwsS3DataConnectorDataTypesResponseLogs'):
        """
        The available data types for Amazon Web Services S3 data connector.
        :param 'AwsS3DataConnectorDataTypesResponseLogs' logs: Logs data type.
        """
        pulumi.set(__self__, "logs", logs)

    @property
    @pulumi.getter
    def logs(self) -> 'outputs.AwsS3DataConnectorDataTypesResponseLogs':
        """
        Logs data type.
        """
        return pulumi.get(self, "logs")


@pulumi.output_type
class AwsS3DataConnectorDataTypesResponseLogs(dict):
    """
    Logs data type.
    """
    def __init__(__self__, *,
                 state: str):
        """
        Logs data type.
        :param str state: Describe whether this data type connection is enabled or not.
        """
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        Describe whether this data type connection is enabled or not.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class BookmarkEntityMappingsResponse(dict):
    """
    Describes the entity mappings of a single entity
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "entityType":
            suggest = "entity_type"
        elif key == "fieldMappings":
            suggest = "field_mappings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BookmarkEntityMappingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BookmarkEntityMappingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BookmarkEntityMappingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 entity_type: Optional[str] = None,
                 field_mappings: Optional[Sequence['outputs.EntityFieldMappingResponse']] = None):
        """
        Describes the entity mappings of a single entity
        :param str entity_type: The entity type
        :param Sequence['EntityFieldMappingResponse'] field_mappings: Array of fields mapping for that entity type
        """
        if entity_type is not None:
            pulumi.set(__self__, "entity_type", entity_type)
        if field_mappings is not None:
            pulumi.set(__self__, "field_mappings", field_mappings)

    @property
    @pulumi.getter(name="entityType")
    def entity_type(self) -> Optional[str]:
        """
        The entity type
        """
        return pulumi.get(self, "entity_type")

    @property
    @pulumi.getter(name="fieldMappings")
    def field_mappings(self) -> Optional[Sequence['outputs.EntityFieldMappingResponse']]:
        """
        Array of fields mapping for that entity type
        """
        return pulumi.get(self, "field_mappings")


@pulumi.output_type
class BookmarkTimelineItemResponse(dict):
    """
    Represents bookmark timeline item.
    """
    def __init__(__self__, *,
                 azure_resource_id: str,
                 kind: str,
                 created_by: Optional['outputs.UserInfoResponse'] = None,
                 display_name: Optional[str] = None,
                 end_time_utc: Optional[str] = None,
                 event_time: Optional[str] = None,
                 labels: Optional[Sequence[str]] = None,
                 notes: Optional[str] = None,
                 start_time_utc: Optional[str] = None):
        """
        Represents bookmark timeline item.
        :param str azure_resource_id: The bookmark azure resource id.
        :param str kind: The entity query kind
               Expected value is 'Bookmark'.
        :param 'UserInfoResponse' created_by: Describes a user that created the bookmark
        :param str display_name: The bookmark display name.
        :param str end_time_utc: The bookmark end time.
        :param str event_time: The bookmark event time.
        :param Sequence[str] labels: List of labels relevant to this bookmark
        :param str notes: The notes of the bookmark
        :param str start_time_utc: The bookmark start time.
        """
        pulumi.set(__self__, "azure_resource_id", azure_resource_id)
        pulumi.set(__self__, "kind", 'Bookmark')
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if end_time_utc is not None:
            pulumi.set(__self__, "end_time_utc", end_time_utc)
        if event_time is not None:
            pulumi.set(__self__, "event_time", event_time)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if notes is not None:
            pulumi.set(__self__, "notes", notes)
        if start_time_utc is not None:
            pulumi.set(__self__, "start_time_utc", start_time_utc)

    @property
    @pulumi.getter(name="azureResourceId")
    def azure_resource_id(self) -> str:
        """
        The bookmark azure resource id.
        """
        return pulumi.get(self, "azure_resource_id")

    @property
    @pulumi.getter
    def kind(self) -> str:
        """
        The entity query kind
        Expected value is 'Bookmark'.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional['outputs.UserInfoResponse']:
        """
        Describes a user that created the bookmark
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        The bookmark display name.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="endTimeUtc")
    def end_time_utc(self) -> Optional[str]:
        """
        The bookmark end time.
        """
        return pulumi.get(self, "end_time_utc")

    @property
    @pulumi.getter(name="eventTime")
    def event_time(self) -> Optional[str]:
        """
        The bookmark event time.
        """
        return pulumi.get(self, "event_time")

    @property
    @pulumi.getter
    def labels(self) -> Optional[Sequence[str]]:
        """
        List of labels relevant to this bookmark
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def notes(self) -> Optional[str]:
        """
        The notes of the bookmark
        """
        return pulumi.get(self, "notes")

    @property
    @pulumi.getter(name="startTimeUtc")
    def start_time_utc(self) -> Optional[str]:
        """
        The bookmark start time.
        """
        return pulumi.get(self, "start_time_utc")


@pulumi.output_type
class ClientInfoResponse(dict):
    """
    Information on the client (user or application) that made some action
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "objectId":
            suggest = "object_id"
        elif key == "userPrincipalName":
            suggest = "user_principal_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClientInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClientInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClientInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 email: Optional[str] = None,
                 name: Optional[str] = None,
                 object_id: Optional[str] = None,
                 user_principal_name: Optional[str] = None):
        """
        Information on the client (user or application) that made some action
        :param str email: The email of the client.
        :param str name: The name of the client.
        :param str object_id: The object id of the client.
        :param str user_principal_name: The user principal name of the client.
        """
        if email is not None:
            pulumi.set(__self__, "email", email)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if object_id is not None:
            pulumi.set(__self__, "object_id", object_id)
        if user_principal_name is not None:
            pulumi.set(__self__, "user_principal_name", user_principal_name)

    @property
    @pulumi.getter
    def email(self) -> Optional[str]:
        """
        The email of the client.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the client.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="objectId")
    def object_id(self) -> Optional[str]:
        """
        The object id of the client.
        """
        return pulumi.get(self, "object_id")

    @property
    @pulumi.getter(name="userPrincipalName")
    def user_principal_name(self) -> Optional[str]:
        """
        The user principal name of the client.
        """
        return pulumi.get(self, "user_principal_name")


@pulumi.output_type
class CodelessConnectorPollingAuthPropertiesResponse(dict):
    """
    Describe the authentication properties needed to successfully authenticate with the server
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authType":
            suggest = "auth_type"
        elif key == "apiKeyIdentifier":
            suggest = "api_key_identifier"
        elif key == "apiKeyName":
            suggest = "api_key_name"
        elif key == "authorizationEndpoint":
            suggest = "authorization_endpoint"
        elif key == "authorizationEndpointQueryParameters":
            suggest = "authorization_endpoint_query_parameters"
        elif key == "flowName":
            suggest = "flow_name"
        elif key == "isApiKeyInPostPayload":
            suggest = "is_api_key_in_post_payload"
        elif key == "isClientSecretInHeader":
            suggest = "is_client_secret_in_header"
        elif key == "redirectionEndpoint":
            suggest = "redirection_endpoint"
        elif key == "tokenEndpoint":
            suggest = "token_endpoint"
        elif key == "tokenEndpointHeaders":
            suggest = "token_endpoint_headers"
        elif key == "tokenEndpointQueryParameters":
            suggest = "token_endpoint_query_parameters"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CodelessConnectorPollingAuthPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CodelessConnectorPollingAuthPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CodelessConnectorPollingAuthPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auth_type: str,
                 api_key_identifier: Optional[str] = None,
                 api_key_name: Optional[str] = None,
                 authorization_endpoint: Optional[str] = None,
                 authorization_endpoint_query_parameters: Optional[Any] = None,
                 flow_name: Optional[str] = None,
                 is_api_key_in_post_payload: Optional[str] = None,
                 is_client_secret_in_header: Optional[bool] = None,
                 redirection_endpoint: Optional[str] = None,
                 scope: Optional[str] = None,
                 token_endpoint: Optional[str] = None,
                 token_endpoint_headers: Optional[Any] = None,
                 token_endpoint_query_parameters: Optional[Any] = None):
        """
        Describe the authentication properties needed to successfully authenticate with the server
        :param str auth_type: The authentication type
        :param str api_key_identifier: A prefix send in the header before the actual token
        :param str api_key_name: The header name which the token is sent with
        :param str authorization_endpoint: The endpoint used to authorize the user, used in Oauth 2.0 flow
        :param Any authorization_endpoint_query_parameters: The query parameters used in authorization request, used in Oauth 2.0 flow
        :param str flow_name: Describes the flow name, for example 'AuthCode' for Oauth 2.0
        :param str is_api_key_in_post_payload: Marks if the key should sent in header
        :param bool is_client_secret_in_header: Marks if we should send the client secret in header or payload, used in Oauth 2.0 flow
        :param str redirection_endpoint: The redirect endpoint where we will get the authorization code, used in Oauth 2.0 flow
        :param str scope: The OAuth token scope
        :param str token_endpoint: The endpoint used to issue a token, used in Oauth 2.0 flow
        :param Any token_endpoint_headers: The query headers used in token request, used in Oauth 2.0 flow
        :param Any token_endpoint_query_parameters: The query parameters used in token request, used in Oauth 2.0 flow
        """
        pulumi.set(__self__, "auth_type", auth_type)
        if api_key_identifier is not None:
            pulumi.set(__self__, "api_key_identifier", api_key_identifier)
        if api_key_name is not None:
            pulumi.set(__self__, "api_key_name", api_key_name)
        if authorization_endpoint is not None:
            pulumi.set(__self__, "authorization_endpoint", authorization_endpoint)
        if authorization_endpoint_query_parameters is not None:
            pulumi.set(__self__, "authorization_endpoint_query_parameters", authorization_endpoint_query_parameters)
        if flow_name is not None:
            pulumi.set(__self__, "flow_name", flow_name)
        if is_api_key_in_post_payload is not None:
            pulumi.set(__self__, "is_api_key_in_post_payload", is_api_key_in_post_payload)
        if is_client_secret_in_header is not None:
            pulumi.set(__self__, "is_client_secret_in_header", is_client_secret_in_header)
        if redirection_endpoint is not None:
            pulumi.set(__self__, "redirection_endpoint", redirection_endpoint)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if token_endpoint is not None:
            pulumi.set(__self__, "token_endpoint", token_endpoint)
        if token_endpoint_headers is not None:
            pulumi.set(__self__, "token_endpoint_headers", token_endpoint_headers)
        if token_endpoint_query_parameters is not None:
            pulumi.set(__self__, "token_endpoint_query_parameters", token_endpoint_query_parameters)

    @property
    @pulumi.getter(name="authType")
    def auth_type(self) -> str:
        """
        The authentication type
        """
        return pulumi.get(self, "auth_type")

    @property
    @pulumi.getter(name="apiKeyIdentifier")
    def api_key_identifier(self) -> Optional[str]:
        """
        A prefix send in the header before the actual token
        """
        return pulumi.get(self, "api_key_identifier")

    @property
    @pulumi.getter(name="apiKeyName")
    def api_key_name(self) -> Optional[str]:
        """
        The header name which the token is sent with
        """
        return pulumi.get(self, "api_key_name")

    @property
    @pulumi.getter(name="authorizationEndpoint")
    def authorization_endpoint(self) -> Optional[str]:
        """
        The endpoint used to authorize the user, used in Oauth 2.0 flow
        """
        return pulumi.get(self, "authorization_endpoint")

    @property
    @pulumi.getter(name="authorizationEndpointQueryParameters")
    def authorization_endpoint_query_parameters(self) -> Optional[Any]:
        """
        The query parameters used in authorization request, used in Oauth 2.0 flow
        """
        return pulumi.get(self, "authorization_endpoint_query_parameters")

    @property
    @pulumi.getter(name="flowName")
    def flow_name(self) -> Optional[str]:
        """
        Describes the flow name, for example 'AuthCode' for Oauth 2.0
        """
        return pulumi.get(self, "flow_name")

    @property
    @pulumi.getter(name="isApiKeyInPostPayload")
    def is_api_key_in_post_payload(self) -> Optional[str]:
        """
        Marks if the key should sent in header
        """
        return pulumi.get(self, "is_api_key_in_post_payload")

    @property
    @pulumi.getter(name="isClientSecretInHeader")
    def is_client_secret_in_header(self) -> Optional[bool]:
        """
        Marks if we should send the client secret in header or payload, used in Oauth 2.0 flow
        """
        return pulumi.get(self, "is_client_secret_in_header")

    @property
    @pulumi.getter(name="redirectionEndpoint")
    def redirection_endpoint(self) -> Optional[str]:
        """
        The redirect endpoint where we will get the authorization code, used in Oauth 2.0 flow
        """
        return pulumi.get(self, "redirection_endpoint")

    @property
    @pulumi.getter
    def scope(self) -> Optional[str]:
        """
        The OAuth token scope
        """
        return pulumi.get(self, "scope")

    @property
    @pulumi.getter(name="tokenEndpoint")
    def token_endpoint(self) -> Optional[str]:
        """
        The endpoint used to issue a token, used in Oauth 2.0 flow
        """
        return pulumi.get(self, "token_endpoint")

    @property
    @pulumi.getter(name="tokenEndpointHeaders")
    def token_endpoint_headers(self) -> Optional[Any]:
        """
        The query headers used in token request, used in Oauth 2.0 flow
        """
        return pulumi.get(self, "token_endpoint_headers")

    @property
    @pulumi.getter(name="tokenEndpointQueryParameters")
    def token_endpoint_query_parameters(self) -> Optional[Any]:
        """
        The query parameters used in token request, used in Oauth 2.0 flow
        """
        return pulumi.get(self, "token_endpoint_query_parameters")


@pulumi.output_type
class CodelessConnectorPollingConfigPropertiesResponse(dict):
    """
    Config to describe the polling config for API poller connector
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isActive":
            suggest = "is_active"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CodelessConnectorPollingConfigPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CodelessConnectorPollingConfigPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CodelessConnectorPollingConfigPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auth: 'outputs.CodelessConnectorPollingAuthPropertiesResponse',
                 request: 'outputs.CodelessConnectorPollingRequestPropertiesResponse',
                 is_active: Optional[bool] = None,
                 paging: Optional['outputs.CodelessConnectorPollingPagingPropertiesResponse'] = None,
                 response: Optional['outputs.CodelessConnectorPollingResponsePropertiesResponse'] = None):
        """
        Config to describe the polling config for API poller connector
        :param 'CodelessConnectorPollingAuthPropertiesResponse' auth: Describe the authentication type of the poller
        :param 'CodelessConnectorPollingRequestPropertiesResponse' request: Describe the poll request config parameters of the poller
        :param bool is_active: The poller active status
        :param 'CodelessConnectorPollingPagingPropertiesResponse' paging: Describe the poll request paging config of the poller
        :param 'CodelessConnectorPollingResponsePropertiesResponse' response: Describe the response config parameters of the poller
        """
        pulumi.set(__self__, "auth", auth)
        pulumi.set(__self__, "request", request)
        if is_active is not None:
            pulumi.set(__self__, "is_active", is_active)
        if paging is not None:
            pulumi.set(__self__, "paging", paging)
        if response is not None:
            pulumi.set(__self__, "response", response)

    @property
    @pulumi.getter
    def auth(self) -> 'outputs.CodelessConnectorPollingAuthPropertiesResponse':
        """
        Describe the authentication type of the poller
        """
        return pulumi.get(self, "auth")

    @property
    @pulumi.getter
    def request(self) -> 'outputs.CodelessConnectorPollingRequestPropertiesResponse':
        """
        Describe the poll request config parameters of the poller
        """
        return pulumi.get(self, "request")

    @property
    @pulumi.getter(name="isActive")
    def is_active(self) -> Optional[bool]:
        """
        The poller active status
        """
        return pulumi.get(self, "is_active")

    @property
    @pulumi.getter
    def paging(self) -> Optional['outputs.CodelessConnectorPollingPagingPropertiesResponse']:
        """
        Describe the poll request paging config of the poller
        """
        return pulumi.get(self, "paging")

    @property
    @pulumi.getter
    def response(self) -> Optional['outputs.CodelessConnectorPollingResponsePropertiesResponse']:
        """
        Describe the response config parameters of the poller
        """
        return pulumi.get(self, "response")


@pulumi.output_type
class CodelessConnectorPollingPagingPropertiesResponse(dict):
    """
    Describe the properties needed to make a pagination call
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pagingType":
            suggest = "paging_type"
        elif key == "nextPageParaName":
            suggest = "next_page_para_name"
        elif key == "nextPageTokenJsonPath":
            suggest = "next_page_token_json_path"
        elif key == "pageCountAttributePath":
            suggest = "page_count_attribute_path"
        elif key == "pageSize":
            suggest = "page_size"
        elif key == "pageSizeParaName":
            suggest = "page_size_para_name"
        elif key == "pageTimeStampAttributePath":
            suggest = "page_time_stamp_attribute_path"
        elif key == "pageTotalCountAttributePath":
            suggest = "page_total_count_attribute_path"
        elif key == "searchTheLatestTimeStampFromEventsList":
            suggest = "search_the_latest_time_stamp_from_events_list"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CodelessConnectorPollingPagingPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CodelessConnectorPollingPagingPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CodelessConnectorPollingPagingPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 paging_type: str,
                 next_page_para_name: Optional[str] = None,
                 next_page_token_json_path: Optional[str] = None,
                 page_count_attribute_path: Optional[str] = None,
                 page_size: Optional[int] = None,
                 page_size_para_name: Optional[str] = None,
                 page_time_stamp_attribute_path: Optional[str] = None,
                 page_total_count_attribute_path: Optional[str] = None,
                 search_the_latest_time_stamp_from_events_list: Optional[str] = None):
        """
        Describe the properties needed to make a pagination call
        :param str paging_type: Describes the type. could be 'None', 'PageToken', 'PageCount', 'TimeStamp'
        :param str next_page_para_name: Defines the name of a next page attribute
        :param str next_page_token_json_path: Defines the path to a next page token JSON
        :param str page_count_attribute_path: Defines the path to a page count attribute
        :param int page_size: Defines the paging size
        :param str page_size_para_name: Defines the name of the page size parameter
        :param str page_time_stamp_attribute_path: Defines the path to a paging time stamp attribute
        :param str page_total_count_attribute_path: Defines the path to a page total count attribute
        :param str search_the_latest_time_stamp_from_events_list: Determines whether to search for the latest time stamp in the events list
        """
        pulumi.set(__self__, "paging_type", paging_type)
        if next_page_para_name is not None:
            pulumi.set(__self__, "next_page_para_name", next_page_para_name)
        if next_page_token_json_path is not None:
            pulumi.set(__self__, "next_page_token_json_path", next_page_token_json_path)
        if page_count_attribute_path is not None:
            pulumi.set(__self__, "page_count_attribute_path", page_count_attribute_path)
        if page_size is not None:
            pulumi.set(__self__, "page_size", page_size)
        if page_size_para_name is not None:
            pulumi.set(__self__, "page_size_para_name", page_size_para_name)
        if page_time_stamp_attribute_path is not None:
            pulumi.set(__self__, "page_time_stamp_attribute_path", page_time_stamp_attribute_path)
        if page_total_count_attribute_path is not None:
            pulumi.set(__self__, "page_total_count_attribute_path", page_total_count_attribute_path)
        if search_the_latest_time_stamp_from_events_list is not None:
            pulumi.set(__self__, "search_the_latest_time_stamp_from_events_list", search_the_latest_time_stamp_from_events_list)

    @property
    @pulumi.getter(name="pagingType")
    def paging_type(self) -> str:
        """
        Describes the type. could be 'None', 'PageToken', 'PageCount', 'TimeStamp'
        """
        return pulumi.get(self, "paging_type")

    @property
    @pulumi.getter(name="nextPageParaName")
    def next_page_para_name(self) -> Optional[str]:
        """
        Defines the name of a next page attribute
        """
        return pulumi.get(self, "next_page_para_name")

    @property
    @pulumi.getter(name="nextPageTokenJsonPath")
    def next_page_token_json_path(self) -> Optional[str]:
        """
        Defines the path to a next page token JSON
        """
        return pulumi.get(self, "next_page_token_json_path")

    @property
    @pulumi.getter(name="pageCountAttributePath")
    def page_count_attribute_path(self) -> Optional[str]:
        """
        Defines the path to a page count attribute
        """
        return pulumi.get(self, "page_count_attribute_path")

    @property
    @pulumi.getter(name="pageSize")
    def page_size(self) -> Optional[int]:
        """
        Defines the paging size
        """
        return pulumi.get(self, "page_size")

    @property
    @pulumi.getter(name="pageSizeParaName")
    def page_size_para_name(self) -> Optional[str]:
        """
        Defines the name of the page size parameter
        """
        return pulumi.get(self, "page_size_para_name")

    @property
    @pulumi.getter(name="pageTimeStampAttributePath")
    def page_time_stamp_attribute_path(self) -> Optional[str]:
        """
        Defines the path to a paging time stamp attribute
        """
        return pulumi.get(self, "page_time_stamp_attribute_path")

    @property
    @pulumi.getter(name="pageTotalCountAttributePath")
    def page_total_count_attribute_path(self) -> Optional[str]:
        """
        Defines the path to a page total count attribute
        """
        return pulumi.get(self, "page_total_count_attribute_path")

    @property
    @pulumi.getter(name="searchTheLatestTimeStampFromEventsList")
    def search_the_latest_time_stamp_from_events_list(self) -> Optional[str]:
        """
        Determines whether to search for the latest time stamp in the events list
        """
        return pulumi.get(self, "search_the_latest_time_stamp_from_events_list")


@pulumi.output_type
class CodelessConnectorPollingRequestPropertiesResponse(dict):
    """
    Describe the request properties needed to successfully pull from the server
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiEndpoint":
            suggest = "api_endpoint"
        elif key == "httpMethod":
            suggest = "http_method"
        elif key == "queryTimeFormat":
            suggest = "query_time_format"
        elif key == "queryWindowInMin":
            suggest = "query_window_in_min"
        elif key == "endTimeAttributeName":
            suggest = "end_time_attribute_name"
        elif key == "queryParameters":
            suggest = "query_parameters"
        elif key == "queryParametersTemplate":
            suggest = "query_parameters_template"
        elif key == "rateLimitQps":
            suggest = "rate_limit_qps"
        elif key == "retryCount":
            suggest = "retry_count"
        elif key == "startTimeAttributeName":
            suggest = "start_time_attribute_name"
        elif key == "timeoutInSeconds":
            suggest = "timeout_in_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CodelessConnectorPollingRequestPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CodelessConnectorPollingRequestPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CodelessConnectorPollingRequestPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_endpoint: str,
                 http_method: str,
                 query_time_format: str,
                 query_window_in_min: int,
                 end_time_attribute_name: Optional[str] = None,
                 headers: Optional[Any] = None,
                 query_parameters: Optional[Any] = None,
                 query_parameters_template: Optional[str] = None,
                 rate_limit_qps: Optional[int] = None,
                 retry_count: Optional[int] = None,
                 start_time_attribute_name: Optional[str] = None,
                 timeout_in_seconds: Optional[int] = None):
        """
        Describe the request properties needed to successfully pull from the server
        :param str api_endpoint: Describe the endpoint we should pull the data from
        :param str http_method: The http method type we will use in the poll request, GET or POST
        :param str query_time_format: The time format will be used the query events in a specific window
        :param int query_window_in_min: The window interval we will use the pull the data
        :param str end_time_attribute_name: This will be used the query events from the end of the time window
        :param Any headers: Describe the headers sent in the poll request
        :param Any query_parameters: Describe the query parameters sent in the poll request
        :param str query_parameters_template: For advanced scenarios for example user name/password embedded in nested JSON payload
        :param int rate_limit_qps: Defines the rate limit QPS
        :param int retry_count: Describe the amount of time we should try and poll the data in case of failure
        :param str start_time_attribute_name: This will be used the query events from a start of the time window
        :param int timeout_in_seconds: The number of seconds we will consider as a request timeout
        """
        pulumi.set(__self__, "api_endpoint", api_endpoint)
        pulumi.set(__self__, "http_method", http_method)
        pulumi.set(__self__, "query_time_format", query_time_format)
        pulumi.set(__self__, "query_window_in_min", query_window_in_min)
        if end_time_attribute_name is not None:
            pulumi.set(__self__, "end_time_attribute_name", end_time_attribute_name)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)
        if query_parameters is not None:
            pulumi.set(__self__, "query_parameters", query_parameters)
        if query_parameters_template is not None:
            pulumi.set(__self__, "query_parameters_template", query_parameters_template)
        if rate_limit_qps is not None:
            pulumi.set(__self__, "rate_limit_qps", rate_limit_qps)
        if retry_count is not None:
            pulumi.set(__self__, "retry_count", retry_count)
        if start_time_attribute_name is not None:
            pulumi.set(__self__, "start_time_attribute_name", start_time_attribute_name)
        if timeout_in_seconds is not None:
            pulumi.set(__self__, "timeout_in_seconds", timeout_in_seconds)

    @property
    @pulumi.getter(name="apiEndpoint")
    def api_endpoint(self) -> str:
        """
        Describe the endpoint we should pull the data from
        """
        return pulumi.get(self, "api_endpoint")

    @property
    @pulumi.getter(name="httpMethod")
    def http_method(self) -> str:
        """
        The http method type we will use in the poll request, GET or POST
        """
        return pulumi.get(self, "http_method")

    @property
    @pulumi.getter(name="queryTimeFormat")
    def query_time_format(self) -> str:
        """
        The time format will be used the query events in a specific window
        """
        return pulumi.get(self, "query_time_format")

    @property
    @pulumi.getter(name="queryWindowInMin")
    def query_window_in_min(self) -> int:
        """
        The window interval we will use the pull the data
        """
        return pulumi.get(self, "query_window_in_min")

    @property
    @pulumi.getter(name="endTimeAttributeName")
    def end_time_attribute_name(self) -> Optional[str]:
        """
        This will be used the query events from the end of the time window
        """
        return pulumi.get(self, "end_time_attribute_name")

    @property
    @pulumi.getter
    def headers(self) -> Optional[Any]:
        """
        Describe the headers sent in the poll request
        """
        return pulumi.get(self, "headers")

    @property
    @pulumi.getter(name="queryParameters")
    def query_parameters(self) -> Optional[Any]:
        """
        Describe the query parameters sent in the poll request
        """
        return pulumi.get(self, "query_parameters")

    @property
    @pulumi.getter(name="queryParametersTemplate")
    def query_parameters_template(self) -> Optional[str]:
        """
        For advanced scenarios for example user name/password embedded in nested JSON payload
        """
        return pulumi.get(self, "query_parameters_template")

    @property
    @pulumi.getter(name="rateLimitQps")
    def rate_limit_qps(self) -> Optional[int]:
        """
        Defines the rate limit QPS
        """
        return pulumi.get(self, "rate_limit_qps")

    @property
    @pulumi.getter(name="retryCount")
    def retry_count(self) -> Optional[int]:
        """
        Describe the amount of time we should try and poll the data in case of failure
        """
        return pulumi.get(self, "retry_count")

    @property
    @pulumi.getter(name="startTimeAttributeName")
    def start_time_attribute_name(self) -> Optional[str]:
        """
        This will be used the query events from a start of the time window
        """
        return pulumi.get(self, "start_time_attribute_name")

    @property
    @pulumi.getter(name="timeoutInSeconds")
    def timeout_in_seconds(self) -> Optional[int]:
        """
        The number of seconds we will consider as a request timeout
        """
        return pulumi.get(self, "timeout_in_seconds")


@pulumi.output_type
class CodelessConnectorPollingResponsePropertiesResponse(dict):
    """
    Describes the response from the external server
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "eventsJsonPaths":
            suggest = "events_json_paths"
        elif key == "isGzipCompressed":
            suggest = "is_gzip_compressed"
        elif key == "successStatusJsonPath":
            suggest = "success_status_json_path"
        elif key == "successStatusValue":
            suggest = "success_status_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CodelessConnectorPollingResponsePropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CodelessConnectorPollingResponsePropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CodelessConnectorPollingResponsePropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 events_json_paths: Sequence[str],
                 is_gzip_compressed: Optional[bool] = None,
                 success_status_json_path: Optional[str] = None,
                 success_status_value: Optional[str] = None):
        """
        Describes the response from the external server
        :param Sequence[str] events_json_paths: Describes the path we should extract the data in the response
        :param bool is_gzip_compressed: Describes if the data in the response is Gzip
        :param str success_status_json_path: Describes the path we should extract the status code in the response
        :param str success_status_value: Describes the path we should extract the status value in the response
        """
        pulumi.set(__self__, "events_json_paths", events_json_paths)
        if is_gzip_compressed is not None:
            pulumi.set(__self__, "is_gzip_compressed", is_gzip_compressed)
        if success_status_json_path is not None:
            pulumi.set(__self__, "success_status_json_path", success_status_json_path)
        if success_status_value is not None:
            pulumi.set(__self__, "success_status_value", success_status_value)

    @property
    @pulumi.getter(name="eventsJsonPaths")
    def events_json_paths(self) -> Sequence[str]:
        """
        Describes the path we should extract the data in the response
        """
        return pulumi.get(self, "events_json_paths")

    @property
    @pulumi.getter(name="isGzipCompressed")
    def is_gzip_compressed(self) -> Optional[bool]:
        """
        Describes if the data in the response is Gzip
        """
        return pulumi.get(self, "is_gzip_compressed")

    @property
    @pulumi.getter(name="successStatusJsonPath")
    def success_status_json_path(self) -> Optional[str]:
        """
        Describes the path we should extract the status code in the response
        """
        return pulumi.get(self, "success_status_json_path")

    @property
    @pulumi.getter(name="successStatusValue")
    def success_status_value(self) -> Optional[str]:
        """
        Describes the path we should extract the status value in the response
        """
        return pulumi.get(self, "success_status_value")


@pulumi.output_type
class CodelessUiConnectorConfigPropertiesResponse(dict):
    """
    Config to describe the instructions blade
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectivityCriteria":
            suggest = "connectivity_criteria"
        elif key == "dataTypes":
            suggest = "data_types"
        elif key == "descriptionMarkdown":
            suggest = "description_markdown"
        elif key == "graphQueries":
            suggest = "graph_queries"
        elif key == "graphQueriesTableName":
            suggest = "graph_queries_table_name"
        elif key == "instructionSteps":
            suggest = "instruction_steps"
        elif key == "sampleQueries":
            suggest = "sample_queries"
        elif key == "customImage":
            suggest = "custom_image"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CodelessUiConnectorConfigPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CodelessUiConnectorConfigPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CodelessUiConnectorConfigPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 availability: 'outputs.AvailabilityResponse',
                 connectivity_criteria: Sequence['outputs.CodelessUiConnectorConfigPropertiesResponseConnectivityCriteria'],
                 data_types: Sequence['outputs.CodelessUiConnectorConfigPropertiesResponseDataTypes'],
                 description_markdown: str,
                 graph_queries: Sequence['outputs.CodelessUiConnectorConfigPropertiesResponseGraphQueries'],
                 graph_queries_table_name: str,
                 instruction_steps: Sequence['outputs.CodelessUiConnectorConfigPropertiesResponseInstructionSteps'],
                 permissions: 'outputs.PermissionsResponse',
                 publisher: str,
                 sample_queries: Sequence['outputs.CodelessUiConnectorConfigPropertiesResponseSampleQueries'],
                 title: str,
                 custom_image: Optional[str] = None):
        """
        Config to describe the instructions blade
        :param 'AvailabilityResponse' availability: Connector Availability Status
        :param Sequence['CodelessUiConnectorConfigPropertiesResponseConnectivityCriteria'] connectivity_criteria: Define the way the connector check connectivity
        :param Sequence['CodelessUiConnectorConfigPropertiesResponseDataTypes'] data_types: Data types to check for last data received
        :param str description_markdown: Connector description
        :param Sequence['CodelessUiConnectorConfigPropertiesResponseGraphQueries'] graph_queries: The graph query to show the current data status
        :param str graph_queries_table_name: Name of the table the connector will insert the data to
        :param Sequence['CodelessUiConnectorConfigPropertiesResponseInstructionSteps'] instruction_steps: Instruction steps to enable the connector
        :param 'PermissionsResponse' permissions: Permissions required for the connector
        :param str publisher: Connector publisher name
        :param Sequence['CodelessUiConnectorConfigPropertiesResponseSampleQueries'] sample_queries: The sample queries for the connector
        :param str title: Connector blade title
        :param str custom_image: An optional custom image to be used when displaying the connector within Azure Sentinel's connector's gallery
        """
        pulumi.set(__self__, "availability", availability)
        pulumi.set(__self__, "connectivity_criteria", connectivity_criteria)
        pulumi.set(__self__, "data_types", data_types)
        pulumi.set(__self__, "description_markdown", description_markdown)
        pulumi.set(__self__, "graph_queries", graph_queries)
        pulumi.set(__self__, "graph_queries_table_name", graph_queries_table_name)
        pulumi.set(__self__, "instruction_steps", instruction_steps)
        pulumi.set(__self__, "permissions", permissions)
        pulumi.set(__self__, "publisher", publisher)
        pulumi.set(__self__, "sample_queries", sample_queries)
        pulumi.set(__self__, "title", title)
        if custom_image is not None:
            pulumi.set(__self__, "custom_image", custom_image)

    @property
    @pulumi.getter
    def availability(self) -> 'outputs.AvailabilityResponse':
        """
        Connector Availability Status
        """
        return pulumi.get(self, "availability")

    @property
    @pulumi.getter(name="connectivityCriteria")
    def connectivity_criteria(self) -> Sequence['outputs.CodelessUiConnectorConfigPropertiesResponseConnectivityCriteria']:
        """
        Define the way the connector check connectivity
        """
        return pulumi.get(self, "connectivity_criteria")

    @property
    @pulumi.getter(name="dataTypes")
    def data_types(self) -> Sequence['outputs.CodelessUiConnectorConfigPropertiesResponseDataTypes']:
        """
        Data types to check for last data received
        """
        return pulumi.get(self, "data_types")

    @property
    @pulumi.getter(name="descriptionMarkdown")
    def description_markdown(self) -> str:
        """
        Connector description
        """
        return pulumi.get(self, "description_markdown")

    @property
    @pulumi.getter(name="graphQueries")
    def graph_queries(self) -> Sequence['outputs.CodelessUiConnectorConfigPropertiesResponseGraphQueries']:
        """
        The graph query to show the current data status
        """
        return pulumi.get(self, "graph_queries")

    @property
    @pulumi.getter(name="graphQueriesTableName")
    def graph_queries_table_name(self) -> str:
        """
        Name of the table the connector will insert the data to
        """
        return pulumi.get(self, "graph_queries_table_name")

    @property
    @pulumi.getter(name="instructionSteps")
    def instruction_steps(self) -> Sequence['outputs.CodelessUiConnectorConfigPropertiesResponseInstructionSteps']:
        """
        Instruction steps to enable the connector
        """
        return pulumi.get(self, "instruction_steps")

    @property
    @pulumi.getter
    def permissions(self) -> 'outputs.PermissionsResponse':
        """
        Permissions required for the connector
        """
        return pulumi.get(self, "permissions")

    @property
    @pulumi.getter
    def publisher(self) -> str:
        """
        Connector publisher name
        """
        return pulumi.get(self, "publisher")

    @property
    @pulumi.getter(name="sampleQueries")
    def sample_queries(self) -> Sequence['outputs.CodelessUiConnectorConfigPropertiesResponseSampleQueries']:
        """
        The sample queries for the connector
        """
        return pulumi.get(self, "sample_queries")

    @property
    @pulumi.getter
    def title(self) -> str:
        """
        Connector blade title
        """
        return pulumi.get(self, "title")

    @property
    @pulumi.getter(name="customImage")
    def custom_image(self) -> Optional[str]:
        """
        An optional custom image to be used when displaying the connector within Azure Sentinel's connector's gallery
        """
        return pulumi.get(self, "custom_image")


@pulumi.output_type
class CodelessUiConnectorConfigPropertiesResponseConnectivityCriteria(dict):
    def __init__(__self__, *,
                 type: Optional[str] = None,
                 value: Optional[Sequence[str]] = None):
        """
        :param str type: type of connectivity
        :param Sequence[str] value: Queries for checking connectivity
        """
        if type is not None:
            pulumi.set(__self__, "type", type)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        type of connectivity
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> Optional[Sequence[str]]:
        """
        Queries for checking connectivity
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class CodelessUiConnectorConfigPropertiesResponseDataTypes(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lastDataReceivedQuery":
            suggest = "last_data_received_query"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CodelessUiConnectorConfigPropertiesResponseDataTypes. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CodelessUiConnectorConfigPropertiesResponseDataTypes.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CodelessUiConnectorConfigPropertiesResponseDataTypes.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 last_data_received_query: Optional[str] = None,
                 name: Optional[str] = None):
        """
        :param str last_data_received_query: Query for indicate last data received
        :param str name: Name of the data type to show in the graph. can be use with {{graphQueriesTableName}} placeholder
        """
        if last_data_received_query is not None:
            pulumi.set(__self__, "last_data_received_query", last_data_received_query)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="lastDataReceivedQuery")
    def last_data_received_query(self) -> Optional[str]:
        """
        Query for indicate last data received
        """
        return pulumi.get(self, "last_data_received_query")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the data type to show in the graph. can be use with {{graphQueriesTableName}} placeholder
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class CodelessUiConnectorConfigPropertiesResponseGraphQueries(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "baseQuery":
            suggest = "base_query"
        elif key == "metricName":
            suggest = "metric_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CodelessUiConnectorConfigPropertiesResponseGraphQueries. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CodelessUiConnectorConfigPropertiesResponseGraphQueries.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CodelessUiConnectorConfigPropertiesResponseGraphQueries.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 base_query: Optional[str] = None,
                 legend: Optional[str] = None,
                 metric_name: Optional[str] = None):
        """
        :param str base_query: The base query for the graph
        :param str legend: The legend for the graph
        :param str metric_name: the metric that the query is checking
        """
        if base_query is not None:
            pulumi.set(__self__, "base_query", base_query)
        if legend is not None:
            pulumi.set(__self__, "legend", legend)
        if metric_name is not None:
            pulumi.set(__self__, "metric_name", metric_name)

    @property
    @pulumi.getter(name="baseQuery")
    def base_query(self) -> Optional[str]:
        """
        The base query for the graph
        """
        return pulumi.get(self, "base_query")

    @property
    @pulumi.getter
    def legend(self) -> Optional[str]:
        """
        The legend for the graph
        """
        return pulumi.get(self, "legend")

    @property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> Optional[str]:
        """
        the metric that the query is checking
        """
        return pulumi.get(self, "metric_name")


@pulumi.output_type
class CodelessUiConnectorConfigPropertiesResponseInstructionSteps(dict):
    def __init__(__self__, *,
                 description: Optional[str] = None,
                 instructions: Optional[Sequence['outputs.InstructionStepsResponseInstructions']] = None,
                 title: Optional[str] = None):
        """
        :param str description: Instruction step description
        :param Sequence['InstructionStepsResponseInstructions'] instructions: Instruction step details
        :param str title: Instruction step title
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if instructions is not None:
            pulumi.set(__self__, "instructions", instructions)
        if title is not None:
            pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Instruction step description
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def instructions(self) -> Optional[Sequence['outputs.InstructionStepsResponseInstructions']]:
        """
        Instruction step details
        """
        return pulumi.get(self, "instructions")

    @property
    @pulumi.getter
    def title(self) -> Optional[str]:
        """
        Instruction step title
        """
        return pulumi.get(self, "title")


@pulumi.output_type
class CodelessUiConnectorConfigPropertiesResponseSampleQueries(dict):
    def __init__(__self__, *,
                 description: Optional[str] = None,
                 query: Optional[str] = None):
        """
        :param str description: The sample query description
        :param str query: the sample query
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if query is not None:
            pulumi.set(__self__, "query", query)

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The sample query description
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def query(self) -> Optional[str]:
        """
        the sample query
        """
        return pulumi.get(self, "query")


@pulumi.output_type
class ContentPathMapResponse(dict):
    """
    The mapping of content type to a repo path.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "contentType":
            suggest = "content_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContentPathMapResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContentPathMapResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContentPathMapResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 content_type: Optional[str] = None,
                 path: Optional[str] = None):
        """
        The mapping of content type to a repo path.
        :param str content_type: Content type.
        :param str path: The path to the content.
        """
        if content_type is not None:
            pulumi.set(__self__, "content_type", content_type)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> Optional[str]:
        """
        Content type.
        """
        return pulumi.get(self, "content_type")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        The path to the content.
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class DataConnectorDataTypeCommonResponse(dict):
    """
    Common field for data type in data connectors.
    """
    def __init__(__self__, *,
                 state: str):
        """
        Common field for data type in data connectors.
        :param str state: Describe whether this data type connection is enabled or not.
        """
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        Describe whether this data type connection is enabled or not.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class Dynamics365DataConnectorDataTypesResponse(dict):
    """
    The available data types for Dynamics365 data connector.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dynamics365CdsActivities":
            suggest = "dynamics365_cds_activities"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Dynamics365DataConnectorDataTypesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Dynamics365DataConnectorDataTypesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Dynamics365DataConnectorDataTypesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dynamics365_cds_activities: 'outputs.Dynamics365DataConnectorDataTypesResponseDynamics365CdsActivities'):
        """
        The available data types for Dynamics365 data connector.
        :param 'Dynamics365DataConnectorDataTypesResponseDynamics365CdsActivities' dynamics365_cds_activities: Common Data Service data type connection.
        """
        pulumi.set(__self__, "dynamics365_cds_activities", dynamics365_cds_activities)

    @property
    @pulumi.getter(name="dynamics365CdsActivities")
    def dynamics365_cds_activities(self) -> 'outputs.Dynamics365DataConnectorDataTypesResponseDynamics365CdsActivities':
        """
        Common Data Service data type connection.
        """
        return pulumi.get(self, "dynamics365_cds_activities")


@pulumi.output_type
class Dynamics365DataConnectorDataTypesResponseDynamics365CdsActivities(dict):
    """
    Common Data Service data type connection.
    """
    def __init__(__self__, *,
                 state: str):
        """
        Common Data Service data type connection.
        :param str state: Describe whether this data type connection is enabled or not.
        """
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        Describe whether this data type connection is enabled or not.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class EntityFieldMappingResponse(dict):
    """
    Map identifiers of a single entity
    """
    def __init__(__self__, *,
                 identifier: Optional[str] = None,
                 value: Optional[str] = None):
        """
        Map identifiers of a single entity
        :param str identifier: Alert V3 identifier
        :param str value: The value of the identifier
        """
        if identifier is not None:
            pulumi.set(__self__, "identifier", identifier)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def identifier(self) -> Optional[str]:
        """
        Alert V3 identifier
        """
        return pulumi.get(self, "identifier")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        The value of the identifier
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class EntityInsightItemResponse(dict):
    """
    Entity insight Item.
    """
    def __init__(__self__, *,
                 chart_query_results: Optional[Sequence['outputs.InsightsTableResultResponse']] = None,
                 query_id: Optional[str] = None,
                 query_time_interval: Optional['outputs.EntityInsightItemResponseQueryTimeInterval'] = None,
                 table_query_results: Optional['outputs.InsightsTableResultResponse'] = None):
        """
        Entity insight Item.
        :param Sequence['InsightsTableResultResponse'] chart_query_results: Query results for table insights query.
        :param str query_id: The query id of the insight
        :param 'EntityInsightItemResponseQueryTimeInterval' query_time_interval: The Time interval that the query actually executed on.
        :param 'InsightsTableResultResponse' table_query_results: Query results for table insights query.
        """
        if chart_query_results is not None:
            pulumi.set(__self__, "chart_query_results", chart_query_results)
        if query_id is not None:
            pulumi.set(__self__, "query_id", query_id)
        if query_time_interval is not None:
            pulumi.set(__self__, "query_time_interval", query_time_interval)
        if table_query_results is not None:
            pulumi.set(__self__, "table_query_results", table_query_results)

    @property
    @pulumi.getter(name="chartQueryResults")
    def chart_query_results(self) -> Optional[Sequence['outputs.InsightsTableResultResponse']]:
        """
        Query results for table insights query.
        """
        return pulumi.get(self, "chart_query_results")

    @property
    @pulumi.getter(name="queryId")
    def query_id(self) -> Optional[str]:
        """
        The query id of the insight
        """
        return pulumi.get(self, "query_id")

    @property
    @pulumi.getter(name="queryTimeInterval")
    def query_time_interval(self) -> Optional['outputs.EntityInsightItemResponseQueryTimeInterval']:
        """
        The Time interval that the query actually executed on.
        """
        return pulumi.get(self, "query_time_interval")

    @property
    @pulumi.getter(name="tableQueryResults")
    def table_query_results(self) -> Optional['outputs.InsightsTableResultResponse']:
        """
        Query results for table insights query.
        """
        return pulumi.get(self, "table_query_results")


@pulumi.output_type
class EntityInsightItemResponseQueryTimeInterval(dict):
    """
    The Time interval that the query actually executed on.
    """
    def __init__(__self__, *,
                 end_time: Optional[str] = None,
                 start_time: Optional[str] = None):
        """
        The Time interval that the query actually executed on.
        :param str end_time: Insight query end time
        :param str start_time: Insight query start time
        """
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[str]:
        """
        Insight query end time
        """
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[str]:
        """
        Insight query start time
        """
        return pulumi.get(self, "start_time")


@pulumi.output_type
class EntityMappingResponse(dict):
    """
    Single entity mapping for the alert rule
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "entityType":
            suggest = "entity_type"
        elif key == "fieldMappings":
            suggest = "field_mappings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EntityMappingResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EntityMappingResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EntityMappingResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 entity_type: Optional[str] = None,
                 field_mappings: Optional[Sequence['outputs.FieldMappingResponse']] = None):
        """
        Single entity mapping for the alert rule
        :param str entity_type: The V3 type of the mapped entity
        :param Sequence['FieldMappingResponse'] field_mappings: array of field mappings for the given entity mapping
        """
        if entity_type is not None:
            pulumi.set(__self__, "entity_type", entity_type)
        if field_mappings is not None:
            pulumi.set(__self__, "field_mappings", field_mappings)

    @property
    @pulumi.getter(name="entityType")
    def entity_type(self) -> Optional[str]:
        """
        The V3 type of the mapped entity
        """
        return pulumi.get(self, "entity_type")

    @property
    @pulumi.getter(name="fieldMappings")
    def field_mappings(self) -> Optional[Sequence['outputs.FieldMappingResponse']]:
        """
        array of field mappings for the given entity mapping
        """
        return pulumi.get(self, "field_mappings")


@pulumi.output_type
class EventGroupingSettingsResponse(dict):
    """
    Event grouping settings property bag.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "aggregationKind":
            suggest = "aggregation_kind"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EventGroupingSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EventGroupingSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EventGroupingSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 aggregation_kind: Optional[str] = None):
        """
        Event grouping settings property bag.
        :param str aggregation_kind: The event grouping aggregation kinds
        """
        if aggregation_kind is not None:
            pulumi.set(__self__, "aggregation_kind", aggregation_kind)

    @property
    @pulumi.getter(name="aggregationKind")
    def aggregation_kind(self) -> Optional[str]:
        """
        The event grouping aggregation kinds
        """
        return pulumi.get(self, "aggregation_kind")


@pulumi.output_type
class FieldMappingResponse(dict):
    """
    A single field mapping of the mapped entity
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "columnName":
            suggest = "column_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FieldMappingResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FieldMappingResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FieldMappingResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 column_name: Optional[str] = None,
                 identifier: Optional[str] = None):
        """
        A single field mapping of the mapped entity
        :param str column_name: the column name to be mapped to the identifier
        :param str identifier: the V3 identifier of the entity
        """
        if column_name is not None:
            pulumi.set(__self__, "column_name", column_name)
        if identifier is not None:
            pulumi.set(__self__, "identifier", identifier)

    @property
    @pulumi.getter(name="columnName")
    def column_name(self) -> Optional[str]:
        """
        the column name to be mapped to the identifier
        """
        return pulumi.get(self, "column_name")

    @property
    @pulumi.getter
    def identifier(self) -> Optional[str]:
        """
        the V3 identifier of the entity
        """
        return pulumi.get(self, "identifier")


@pulumi.output_type
class FusionScenarioExclusionPatternResponse(dict):
    """
    Represents a Fusion scenario exclusion patterns in Fusion detection.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dateAddedInUTC":
            suggest = "date_added_in_utc"
        elif key == "exclusionPattern":
            suggest = "exclusion_pattern"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FusionScenarioExclusionPatternResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FusionScenarioExclusionPatternResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FusionScenarioExclusionPatternResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 date_added_in_utc: str,
                 exclusion_pattern: str):
        """
        Represents a Fusion scenario exclusion patterns in Fusion detection.
        :param str date_added_in_utc: DateTime when scenario exclusion pattern is added in UTC.
        :param str exclusion_pattern: Scenario exclusion pattern.
        """
        pulumi.set(__self__, "date_added_in_utc", date_added_in_utc)
        pulumi.set(__self__, "exclusion_pattern", exclusion_pattern)

    @property
    @pulumi.getter(name="dateAddedInUTC")
    def date_added_in_utc(self) -> str:
        """
        DateTime when scenario exclusion pattern is added in UTC.
        """
        return pulumi.get(self, "date_added_in_utc")

    @property
    @pulumi.getter(name="exclusionPattern")
    def exclusion_pattern(self) -> str:
        """
        Scenario exclusion pattern.
        """
        return pulumi.get(self, "exclusion_pattern")


@pulumi.output_type
class FusionSourceSettingsResponse(dict):
    """
    Represents a supported source signal configuration in Fusion detection.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceName":
            suggest = "source_name"
        elif key == "sourceSubTypes":
            suggest = "source_sub_types"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FusionSourceSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FusionSourceSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FusionSourceSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: bool,
                 source_name: str,
                 source_sub_types: Optional[Sequence['outputs.FusionSourceSubTypeSettingResponse']] = None):
        """
        Represents a supported source signal configuration in Fusion detection.
        :param bool enabled: Determines whether this source signal is enabled or disabled in Fusion detection.
        :param str source_name: Name of the Fusion source signal. Refer to Fusion alert rule template for supported values.
        :param Sequence['FusionSourceSubTypeSettingResponse'] source_sub_types: Configuration for all source subtypes under this source signal consumed in fusion detection.
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "source_name", source_name)
        if source_sub_types is not None:
            pulumi.set(__self__, "source_sub_types", source_sub_types)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Determines whether this source signal is enabled or disabled in Fusion detection.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="sourceName")
    def source_name(self) -> str:
        """
        Name of the Fusion source signal. Refer to Fusion alert rule template for supported values.
        """
        return pulumi.get(self, "source_name")

    @property
    @pulumi.getter(name="sourceSubTypes")
    def source_sub_types(self) -> Optional[Sequence['outputs.FusionSourceSubTypeSettingResponse']]:
        """
        Configuration for all source subtypes under this source signal consumed in fusion detection.
        """
        return pulumi.get(self, "source_sub_types")


@pulumi.output_type
class FusionSourceSubTypeSettingResponse(dict):
    """
    Represents a supported source subtype configuration under a source signal in Fusion detection.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "severityFilters":
            suggest = "severity_filters"
        elif key == "sourceSubTypeDisplayName":
            suggest = "source_sub_type_display_name"
        elif key == "sourceSubTypeName":
            suggest = "source_sub_type_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FusionSourceSubTypeSettingResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FusionSourceSubTypeSettingResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FusionSourceSubTypeSettingResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: bool,
                 severity_filters: 'outputs.FusionSubTypeSeverityFilterResponse',
                 source_sub_type_display_name: str,
                 source_sub_type_name: str):
        """
        Represents a supported source subtype configuration under a source signal in Fusion detection.
        :param bool enabled: Determines whether this source subtype under source signal is enabled or disabled in Fusion detection.
        :param 'FusionSubTypeSeverityFilterResponse' severity_filters: Severity configuration for a source subtype consumed in fusion detection.
        :param str source_sub_type_display_name: The display name of source subtype under a source signal consumed in Fusion detection.
        :param str source_sub_type_name: The Name of the source subtype under a given source signal in Fusion detection. Refer to Fusion alert rule template for supported values.
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "severity_filters", severity_filters)
        pulumi.set(__self__, "source_sub_type_display_name", source_sub_type_display_name)
        pulumi.set(__self__, "source_sub_type_name", source_sub_type_name)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Determines whether this source subtype under source signal is enabled or disabled in Fusion detection.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="severityFilters")
    def severity_filters(self) -> 'outputs.FusionSubTypeSeverityFilterResponse':
        """
        Severity configuration for a source subtype consumed in fusion detection.
        """
        return pulumi.get(self, "severity_filters")

    @property
    @pulumi.getter(name="sourceSubTypeDisplayName")
    def source_sub_type_display_name(self) -> str:
        """
        The display name of source subtype under a source signal consumed in Fusion detection.
        """
        return pulumi.get(self, "source_sub_type_display_name")

    @property
    @pulumi.getter(name="sourceSubTypeName")
    def source_sub_type_name(self) -> str:
        """
        The Name of the source subtype under a given source signal in Fusion detection. Refer to Fusion alert rule template for supported values.
        """
        return pulumi.get(self, "source_sub_type_name")


@pulumi.output_type
class FusionSubTypeSeverityFilterResponse(dict):
    """
    Represents severity configuration for a source subtype consumed in Fusion detection.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isSupported":
            suggest = "is_supported"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FusionSubTypeSeverityFilterResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FusionSubTypeSeverityFilterResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FusionSubTypeSeverityFilterResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 is_supported: bool,
                 filters: Optional[Sequence['outputs.FusionSubTypeSeverityFiltersItemResponse']] = None):
        """
        Represents severity configuration for a source subtype consumed in Fusion detection.
        :param bool is_supported: Determines whether this source subtype supports severity configuration or not.
        :param Sequence['FusionSubTypeSeverityFiltersItemResponse'] filters: Individual Severity configuration settings for a given source subtype consumed in Fusion detection.
        """
        pulumi.set(__self__, "is_supported", is_supported)
        if filters is not None:
            pulumi.set(__self__, "filters", filters)

    @property
    @pulumi.getter(name="isSupported")
    def is_supported(self) -> bool:
        """
        Determines whether this source subtype supports severity configuration or not.
        """
        return pulumi.get(self, "is_supported")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.FusionSubTypeSeverityFiltersItemResponse']]:
        """
        Individual Severity configuration settings for a given source subtype consumed in Fusion detection.
        """
        return pulumi.get(self, "filters")


@pulumi.output_type
class FusionSubTypeSeverityFiltersItemResponse(dict):
    """
    Represents a Severity filter setting for a given source subtype consumed in Fusion detection.
    """
    def __init__(__self__, *,
                 enabled: bool,
                 severity: str):
        """
        Represents a Severity filter setting for a given source subtype consumed in Fusion detection.
        :param bool enabled: Determines whether this severity is enabled or disabled for this source subtype consumed in Fusion detection.
        :param str severity: The Severity for a given source subtype consumed in Fusion detection.
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "severity", severity)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Determines whether this severity is enabled or disabled for this source subtype consumed in Fusion detection.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def severity(self) -> str:
        """
        The Severity for a given source subtype consumed in Fusion detection.
        """
        return pulumi.get(self, "severity")


@pulumi.output_type
class GetInsightsErrorResponse(dict):
    """
    GetInsights Query Errors.
    """
    def __init__(__self__, *,
                 error_message: str,
                 kind: str,
                 query_id: Optional[str] = None):
        """
        GetInsights Query Errors.
        :param str error_message: the error message
        :param str kind: the query kind
        :param str query_id: the query id
        """
        pulumi.set(__self__, "error_message", error_message)
        pulumi.set(__self__, "kind", kind)
        if query_id is not None:
            pulumi.set(__self__, "query_id", query_id)

    @property
    @pulumi.getter(name="errorMessage")
    def error_message(self) -> str:
        """
        the error message
        """
        return pulumi.get(self, "error_message")

    @property
    @pulumi.getter
    def kind(self) -> str:
        """
        the query kind
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter(name="queryId")
    def query_id(self) -> Optional[str]:
        """
        the query id
        """
        return pulumi.get(self, "query_id")


@pulumi.output_type
class GetInsightsResultsMetadataResponse(dict):
    """
    Get Insights result metadata.
    """
    def __init__(__self__, *,
                 total_count: int,
                 errors: Optional[Sequence['outputs.GetInsightsErrorResponse']] = None):
        """
        Get Insights result metadata.
        :param int total_count: the total items found for the insights request
        :param Sequence['GetInsightsErrorResponse'] errors: information about the failed queries
        """
        pulumi.set(__self__, "total_count", total_count)
        if errors is not None:
            pulumi.set(__self__, "errors", errors)

    @property
    @pulumi.getter(name="totalCount")
    def total_count(self) -> int:
        """
        the total items found for the insights request
        """
        return pulumi.get(self, "total_count")

    @property
    @pulumi.getter
    def errors(self) -> Optional[Sequence['outputs.GetInsightsErrorResponse']]:
        """
        information about the failed queries
        """
        return pulumi.get(self, "errors")


@pulumi.output_type
class GroupingConfigurationResponse(dict):
    """
    Grouping configuration property bag.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lookbackDuration":
            suggest = "lookback_duration"
        elif key == "matchingMethod":
            suggest = "matching_method"
        elif key == "reopenClosedIncident":
            suggest = "reopen_closed_incident"
        elif key == "groupByAlertDetails":
            suggest = "group_by_alert_details"
        elif key == "groupByCustomDetails":
            suggest = "group_by_custom_details"
        elif key == "groupByEntities":
            suggest = "group_by_entities"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GroupingConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GroupingConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GroupingConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: bool,
                 lookback_duration: str,
                 matching_method: str,
                 reopen_closed_incident: bool,
                 group_by_alert_details: Optional[Sequence[str]] = None,
                 group_by_custom_details: Optional[Sequence[str]] = None,
                 group_by_entities: Optional[Sequence[str]] = None):
        """
        Grouping configuration property bag.
        :param bool enabled: Grouping enabled
        :param str lookback_duration: Limit the group to alerts created within the lookback duration (in ISO 8601 duration format)
        :param str matching_method: Grouping matching method. When method is Selected at least one of groupByEntities, groupByAlertDetails, groupByCustomDetails must be provided and not empty.
        :param bool reopen_closed_incident: Re-open closed matching incidents
        :param Sequence[str] group_by_alert_details: A list of alert details to group by (when matchingMethod is Selected)
        :param Sequence[str] group_by_custom_details: A list of custom details keys to group by (when matchingMethod is Selected). Only keys defined in the current alert rule may be used.
        :param Sequence[str] group_by_entities: A list of entity types to group by (when matchingMethod is Selected). Only entities defined in the current alert rule may be used.
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "lookback_duration", lookback_duration)
        pulumi.set(__self__, "matching_method", matching_method)
        pulumi.set(__self__, "reopen_closed_incident", reopen_closed_incident)
        if group_by_alert_details is not None:
            pulumi.set(__self__, "group_by_alert_details", group_by_alert_details)
        if group_by_custom_details is not None:
            pulumi.set(__self__, "group_by_custom_details", group_by_custom_details)
        if group_by_entities is not None:
            pulumi.set(__self__, "group_by_entities", group_by_entities)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Grouping enabled
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="lookbackDuration")
    def lookback_duration(self) -> str:
        """
        Limit the group to alerts created within the lookback duration (in ISO 8601 duration format)
        """
        return pulumi.get(self, "lookback_duration")

    @property
    @pulumi.getter(name="matchingMethod")
    def matching_method(self) -> str:
        """
        Grouping matching method. When method is Selected at least one of groupByEntities, groupByAlertDetails, groupByCustomDetails must be provided and not empty.
        """
        return pulumi.get(self, "matching_method")

    @property
    @pulumi.getter(name="reopenClosedIncident")
    def reopen_closed_incident(self) -> bool:
        """
        Re-open closed matching incidents
        """
        return pulumi.get(self, "reopen_closed_incident")

    @property
    @pulumi.getter(name="groupByAlertDetails")
    def group_by_alert_details(self) -> Optional[Sequence[str]]:
        """
        A list of alert details to group by (when matchingMethod is Selected)
        """
        return pulumi.get(self, "group_by_alert_details")

    @property
    @pulumi.getter(name="groupByCustomDetails")
    def group_by_custom_details(self) -> Optional[Sequence[str]]:
        """
        A list of custom details keys to group by (when matchingMethod is Selected). Only keys defined in the current alert rule may be used.
        """
        return pulumi.get(self, "group_by_custom_details")

    @property
    @pulumi.getter(name="groupByEntities")
    def group_by_entities(self) -> Optional[Sequence[str]]:
        """
        A list of entity types to group by (when matchingMethod is Selected). Only entities defined in the current alert rule may be used.
        """
        return pulumi.get(self, "group_by_entities")


@pulumi.output_type
class IncidentAdditionalDataResponse(dict):
    """
    Incident additional data property bag.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "alertProductNames":
            suggest = "alert_product_names"
        elif key == "alertsCount":
            suggest = "alerts_count"
        elif key == "bookmarksCount":
            suggest = "bookmarks_count"
        elif key == "commentsCount":
            suggest = "comments_count"
        elif key == "providerIncidentUrl":
            suggest = "provider_incident_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IncidentAdditionalDataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IncidentAdditionalDataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IncidentAdditionalDataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 alert_product_names: Sequence[str],
                 alerts_count: int,
                 bookmarks_count: int,
                 comments_count: int,
                 provider_incident_url: str,
                 tactics: Sequence[str],
                 techniques: Sequence[str]):
        """
        Incident additional data property bag.
        :param Sequence[str] alert_product_names: List of product names of alerts in the incident
        :param int alerts_count: The number of alerts in the incident
        :param int bookmarks_count: The number of bookmarks in the incident
        :param int comments_count: The number of comments in the incident
        :param str provider_incident_url: The provider incident url to the incident in Microsoft 365 Defender portal
        :param Sequence[str] tactics: The tactics associated with incident
        :param Sequence[str] techniques: The techniques associated with incident's tactics'
        """
        pulumi.set(__self__, "alert_product_names", alert_product_names)
        pulumi.set(__self__, "alerts_count", alerts_count)
        pulumi.set(__self__, "bookmarks_count", bookmarks_count)
        pulumi.set(__self__, "comments_count", comments_count)
        pulumi.set(__self__, "provider_incident_url", provider_incident_url)
        pulumi.set(__self__, "tactics", tactics)
        pulumi.set(__self__, "techniques", techniques)

    @property
    @pulumi.getter(name="alertProductNames")
    def alert_product_names(self) -> Sequence[str]:
        """
        List of product names of alerts in the incident
        """
        return pulumi.get(self, "alert_product_names")

    @property
    @pulumi.getter(name="alertsCount")
    def alerts_count(self) -> int:
        """
        The number of alerts in the incident
        """
        return pulumi.get(self, "alerts_count")

    @property
    @pulumi.getter(name="bookmarksCount")
    def bookmarks_count(self) -> int:
        """
        The number of bookmarks in the incident
        """
        return pulumi.get(self, "bookmarks_count")

    @property
    @pulumi.getter(name="commentsCount")
    def comments_count(self) -> int:
        """
        The number of comments in the incident
        """
        return pulumi.get(self, "comments_count")

    @property
    @pulumi.getter(name="providerIncidentUrl")
    def provider_incident_url(self) -> str:
        """
        The provider incident url to the incident in Microsoft 365 Defender portal
        """
        return pulumi.get(self, "provider_incident_url")

    @property
    @pulumi.getter
    def tactics(self) -> Sequence[str]:
        """
        The tactics associated with incident
        """
        return pulumi.get(self, "tactics")

    @property
    @pulumi.getter
    def techniques(self) -> Sequence[str]:
        """
        The techniques associated with incident's tactics'
        """
        return pulumi.get(self, "techniques")


@pulumi.output_type
class IncidentConfigurationResponse(dict):
    """
    Incident Configuration property bag.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createIncident":
            suggest = "create_incident"
        elif key == "groupingConfiguration":
            suggest = "grouping_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IncidentConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IncidentConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IncidentConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 create_incident: bool,
                 grouping_configuration: Optional['outputs.GroupingConfigurationResponse'] = None):
        """
        Incident Configuration property bag.
        :param bool create_incident: Create incidents from alerts triggered by this analytics rule
        :param 'GroupingConfigurationResponse' grouping_configuration: Set how the alerts that are triggered by this analytics rule, are grouped into incidents
        """
        pulumi.set(__self__, "create_incident", create_incident)
        if grouping_configuration is not None:
            pulumi.set(__self__, "grouping_configuration", grouping_configuration)

    @property
    @pulumi.getter(name="createIncident")
    def create_incident(self) -> bool:
        """
        Create incidents from alerts triggered by this analytics rule
        """
        return pulumi.get(self, "create_incident")

    @property
    @pulumi.getter(name="groupingConfiguration")
    def grouping_configuration(self) -> Optional['outputs.GroupingConfigurationResponse']:
        """
        Set how the alerts that are triggered by this analytics rule, are grouped into incidents
        """
        return pulumi.get(self, "grouping_configuration")


@pulumi.output_type
class IncidentInfoResponse(dict):
    """
    Describes related incident information for the bookmark
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "incidentId":
            suggest = "incident_id"
        elif key == "relationName":
            suggest = "relation_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IncidentInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IncidentInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IncidentInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 incident_id: Optional[str] = None,
                 relation_name: Optional[str] = None,
                 severity: Optional[str] = None,
                 title: Optional[str] = None):
        """
        Describes related incident information for the bookmark
        :param str incident_id: Incident Id
        :param str relation_name: Relation Name
        :param str severity: The severity of the incident
        :param str title: The title of the incident
        """
        if incident_id is not None:
            pulumi.set(__self__, "incident_id", incident_id)
        if relation_name is not None:
            pulumi.set(__self__, "relation_name", relation_name)
        if severity is not None:
            pulumi.set(__self__, "severity", severity)
        if title is not None:
            pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter(name="incidentId")
    def incident_id(self) -> Optional[str]:
        """
        Incident Id
        """
        return pulumi.get(self, "incident_id")

    @property
    @pulumi.getter(name="relationName")
    def relation_name(self) -> Optional[str]:
        """
        Relation Name
        """
        return pulumi.get(self, "relation_name")

    @property
    @pulumi.getter
    def severity(self) -> Optional[str]:
        """
        The severity of the incident
        """
        return pulumi.get(self, "severity")

    @property
    @pulumi.getter
    def title(self) -> Optional[str]:
        """
        The title of the incident
        """
        return pulumi.get(self, "title")


@pulumi.output_type
class IncidentLabelResponse(dict):
    """
    Represents an incident label
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "labelName":
            suggest = "label_name"
        elif key == "labelType":
            suggest = "label_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IncidentLabelResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IncidentLabelResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IncidentLabelResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 label_name: str,
                 label_type: str):
        """
        Represents an incident label
        :param str label_name: The name of the label
        :param str label_type: The type of the label
        """
        pulumi.set(__self__, "label_name", label_name)
        pulumi.set(__self__, "label_type", label_type)

    @property
    @pulumi.getter(name="labelName")
    def label_name(self) -> str:
        """
        The name of the label
        """
        return pulumi.get(self, "label_name")

    @property
    @pulumi.getter(name="labelType")
    def label_type(self) -> str:
        """
        The type of the label
        """
        return pulumi.get(self, "label_type")


@pulumi.output_type
class IncidentOwnerInfoResponse(dict):
    """
    Information on the user an incident is assigned to
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ownerType":
            suggest = "owner_type"
        elif key == "assignedTo":
            suggest = "assigned_to"
        elif key == "objectId":
            suggest = "object_id"
        elif key == "userPrincipalName":
            suggest = "user_principal_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IncidentOwnerInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IncidentOwnerInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IncidentOwnerInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 owner_type: str,
                 assigned_to: Optional[str] = None,
                 email: Optional[str] = None,
                 object_id: Optional[str] = None,
                 user_principal_name: Optional[str] = None):
        """
        Information on the user an incident is assigned to
        :param str owner_type: The type of the owner the incident is assigned to.
        :param str assigned_to: The name of the user the incident is assigned to.
        :param str email: The email of the user the incident is assigned to.
        :param str object_id: The object id of the user the incident is assigned to.
        :param str user_principal_name: The user principal name of the user the incident is assigned to.
        """
        pulumi.set(__self__, "owner_type", owner_type)
        if assigned_to is not None:
            pulumi.set(__self__, "assigned_to", assigned_to)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if object_id is not None:
            pulumi.set(__self__, "object_id", object_id)
        if user_principal_name is not None:
            pulumi.set(__self__, "user_principal_name", user_principal_name)

    @property
    @pulumi.getter(name="ownerType")
    def owner_type(self) -> str:
        """
        The type of the owner the incident is assigned to.
        """
        return pulumi.get(self, "owner_type")

    @property
    @pulumi.getter(name="assignedTo")
    def assigned_to(self) -> Optional[str]:
        """
        The name of the user the incident is assigned to.
        """
        return pulumi.get(self, "assigned_to")

    @property
    @pulumi.getter
    def email(self) -> Optional[str]:
        """
        The email of the user the incident is assigned to.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter(name="objectId")
    def object_id(self) -> Optional[str]:
        """
        The object id of the user the incident is assigned to.
        """
        return pulumi.get(self, "object_id")

    @property
    @pulumi.getter(name="userPrincipalName")
    def user_principal_name(self) -> Optional[str]:
        """
        The user principal name of the user the incident is assigned to.
        """
        return pulumi.get(self, "user_principal_name")


@pulumi.output_type
class IncidentPropertiesActionResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "classificationComment":
            suggest = "classification_comment"
        elif key == "classificationReason":
            suggest = "classification_reason"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IncidentPropertiesActionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IncidentPropertiesActionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IncidentPropertiesActionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 classification: Optional[str] = None,
                 classification_comment: Optional[str] = None,
                 classification_reason: Optional[str] = None,
                 labels: Optional[Sequence['outputs.IncidentLabelResponse']] = None,
                 owner: Optional['outputs.IncidentOwnerInfoResponse'] = None,
                 severity: Optional[str] = None,
                 status: Optional[str] = None):
        """
        :param str classification: The reason the incident was closed
        :param str classification_comment: Describes the reason the incident was closed
        :param str classification_reason: The classification reason the incident was closed with
        :param Sequence['IncidentLabelResponse'] labels: List of labels to add to the incident
        :param 'IncidentOwnerInfoResponse' owner: Information on the user an incident is assigned to
        :param str severity: The severity of the incident
        :param str status: The status of the incident
        """
        if classification is not None:
            pulumi.set(__self__, "classification", classification)
        if classification_comment is not None:
            pulumi.set(__self__, "classification_comment", classification_comment)
        if classification_reason is not None:
            pulumi.set(__self__, "classification_reason", classification_reason)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if owner is not None:
            pulumi.set(__self__, "owner", owner)
        if severity is not None:
            pulumi.set(__self__, "severity", severity)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def classification(self) -> Optional[str]:
        """
        The reason the incident was closed
        """
        return pulumi.get(self, "classification")

    @property
    @pulumi.getter(name="classificationComment")
    def classification_comment(self) -> Optional[str]:
        """
        Describes the reason the incident was closed
        """
        return pulumi.get(self, "classification_comment")

    @property
    @pulumi.getter(name="classificationReason")
    def classification_reason(self) -> Optional[str]:
        """
        The classification reason the incident was closed with
        """
        return pulumi.get(self, "classification_reason")

    @property
    @pulumi.getter
    def labels(self) -> Optional[Sequence['outputs.IncidentLabelResponse']]:
        """
        List of labels to add to the incident
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def owner(self) -> Optional['outputs.IncidentOwnerInfoResponse']:
        """
        Information on the user an incident is assigned to
        """
        return pulumi.get(self, "owner")

    @property
    @pulumi.getter
    def severity(self) -> Optional[str]:
        """
        The severity of the incident
        """
        return pulumi.get(self, "severity")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        The status of the incident
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class InsightsTableResultResponse(dict):
    """
    Query results for table insights query.
    """
    def __init__(__self__, *,
                 columns: Optional[Sequence['outputs.InsightsTableResultResponseColumns']] = None,
                 rows: Optional[Sequence[Sequence[str]]] = None):
        """
        Query results for table insights query.
        :param Sequence['InsightsTableResultResponseColumns'] columns: Columns Metadata of the table
        :param Sequence[Sequence[str]] rows: Rows data of the table
        """
        if columns is not None:
            pulumi.set(__self__, "columns", columns)
        if rows is not None:
            pulumi.set(__self__, "rows", rows)

    @property
    @pulumi.getter
    def columns(self) -> Optional[Sequence['outputs.InsightsTableResultResponseColumns']]:
        """
        Columns Metadata of the table
        """
        return pulumi.get(self, "columns")

    @property
    @pulumi.getter
    def rows(self) -> Optional[Sequence[Sequence[str]]]:
        """
        Rows data of the table
        """
        return pulumi.get(self, "rows")


@pulumi.output_type
class InsightsTableResultResponseColumns(dict):
    def __init__(__self__, *,
                 name: Optional[str] = None,
                 type: Optional[str] = None):
        """
        :param str name: the name of the colum
        :param str type: the type of the colum
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        the name of the colum
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        the type of the colum
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class InstructionStepsResponseInstructions(dict):
    def __init__(__self__, *,
                 type: str,
                 parameters: Optional[Any] = None):
        """
        :param str type: The kind of the setting
        :param Any parameters: The parameters for the setting
        """
        pulumi.set(__self__, "type", type)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The kind of the setting
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Any]:
        """
        The parameters for the setting
        """
        return pulumi.get(self, "parameters")


@pulumi.output_type
class MCASDataConnectorDataTypesResponse(dict):
    """
    The available data types for MCAS (Microsoft Cloud App Security) data connector.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "discoveryLogs":
            suggest = "discovery_logs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MCASDataConnectorDataTypesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MCASDataConnectorDataTypesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MCASDataConnectorDataTypesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 alerts: 'outputs.DataConnectorDataTypeCommonResponse',
                 discovery_logs: Optional['outputs.DataConnectorDataTypeCommonResponse'] = None):
        """
        The available data types for MCAS (Microsoft Cloud App Security) data connector.
        :param 'DataConnectorDataTypeCommonResponse' alerts: Alerts data type connection.
        :param 'DataConnectorDataTypeCommonResponse' discovery_logs: Discovery log data type connection.
        """
        pulumi.set(__self__, "alerts", alerts)
        if discovery_logs is not None:
            pulumi.set(__self__, "discovery_logs", discovery_logs)

    @property
    @pulumi.getter
    def alerts(self) -> 'outputs.DataConnectorDataTypeCommonResponse':
        """
        Alerts data type connection.
        """
        return pulumi.get(self, "alerts")

    @property
    @pulumi.getter(name="discoveryLogs")
    def discovery_logs(self) -> Optional['outputs.DataConnectorDataTypeCommonResponse']:
        """
        Discovery log data type connection.
        """
        return pulumi.get(self, "discovery_logs")


@pulumi.output_type
class MSTIDataConnectorDataTypesResponse(dict):
    """
    The available data types for Microsoft Threat Intelligence Platforms data connector.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bingSafetyPhishingURL":
            suggest = "bing_safety_phishing_url"
        elif key == "microsoftEmergingThreatFeed":
            suggest = "microsoft_emerging_threat_feed"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MSTIDataConnectorDataTypesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MSTIDataConnectorDataTypesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MSTIDataConnectorDataTypesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bing_safety_phishing_url: 'outputs.MSTIDataConnectorDataTypesResponseBingSafetyPhishingURL',
                 microsoft_emerging_threat_feed: 'outputs.MSTIDataConnectorDataTypesResponseMicrosoftEmergingThreatFeed'):
        """
        The available data types for Microsoft Threat Intelligence Platforms data connector.
        :param 'MSTIDataConnectorDataTypesResponseBingSafetyPhishingURL' bing_safety_phishing_url: Data type for Microsoft Threat Intelligence Platforms data connector.
        :param 'MSTIDataConnectorDataTypesResponseMicrosoftEmergingThreatFeed' microsoft_emerging_threat_feed: Data type for Microsoft Threat Intelligence Platforms data connector.
        """
        pulumi.set(__self__, "bing_safety_phishing_url", bing_safety_phishing_url)
        pulumi.set(__self__, "microsoft_emerging_threat_feed", microsoft_emerging_threat_feed)

    @property
    @pulumi.getter(name="bingSafetyPhishingURL")
    def bing_safety_phishing_url(self) -> 'outputs.MSTIDataConnectorDataTypesResponseBingSafetyPhishingURL':
        """
        Data type for Microsoft Threat Intelligence Platforms data connector.
        """
        return pulumi.get(self, "bing_safety_phishing_url")

    @property
    @pulumi.getter(name="microsoftEmergingThreatFeed")
    def microsoft_emerging_threat_feed(self) -> 'outputs.MSTIDataConnectorDataTypesResponseMicrosoftEmergingThreatFeed':
        """
        Data type for Microsoft Threat Intelligence Platforms data connector.
        """
        return pulumi.get(self, "microsoft_emerging_threat_feed")


@pulumi.output_type
class MSTIDataConnectorDataTypesResponseBingSafetyPhishingURL(dict):
    """
    Data type for Microsoft Threat Intelligence Platforms data connector.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lookbackPeriod":
            suggest = "lookback_period"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MSTIDataConnectorDataTypesResponseBingSafetyPhishingURL. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MSTIDataConnectorDataTypesResponseBingSafetyPhishingURL.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MSTIDataConnectorDataTypesResponseBingSafetyPhishingURL.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 lookback_period: str,
                 state: str):
        """
        Data type for Microsoft Threat Intelligence Platforms data connector.
        :param str lookback_period: lookback period
        :param str state: Describe whether this data type connection is enabled or not.
        """
        pulumi.set(__self__, "lookback_period", lookback_period)
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="lookbackPeriod")
    def lookback_period(self) -> str:
        """
        lookback period
        """
        return pulumi.get(self, "lookback_period")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        Describe whether this data type connection is enabled or not.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class MSTIDataConnectorDataTypesResponseMicrosoftEmergingThreatFeed(dict):
    """
    Data type for Microsoft Threat Intelligence Platforms data connector.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lookbackPeriod":
            suggest = "lookback_period"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MSTIDataConnectorDataTypesResponseMicrosoftEmergingThreatFeed. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MSTIDataConnectorDataTypesResponseMicrosoftEmergingThreatFeed.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MSTIDataConnectorDataTypesResponseMicrosoftEmergingThreatFeed.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 lookback_period: str,
                 state: str):
        """
        Data type for Microsoft Threat Intelligence Platforms data connector.
        :param str lookback_period: lookback period
        :param str state: Describe whether this data type connection is enabled or not.
        """
        pulumi.set(__self__, "lookback_period", lookback_period)
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="lookbackPeriod")
    def lookback_period(self) -> str:
        """
        lookback period
        """
        return pulumi.get(self, "lookback_period")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        Describe whether this data type connection is enabled or not.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class MTPDataConnectorDataTypesResponse(dict):
    """
    The available data types for Microsoft Threat Protection Platforms data connector.
    """
    def __init__(__self__, *,
                 incidents: 'outputs.MTPDataConnectorDataTypesResponseIncidents'):
        """
        The available data types for Microsoft Threat Protection Platforms data connector.
        :param 'MTPDataConnectorDataTypesResponseIncidents' incidents: Data type for Microsoft Threat Protection Platforms data connector.
        """
        pulumi.set(__self__, "incidents", incidents)

    @property
    @pulumi.getter
    def incidents(self) -> 'outputs.MTPDataConnectorDataTypesResponseIncidents':
        """
        Data type for Microsoft Threat Protection Platforms data connector.
        """
        return pulumi.get(self, "incidents")


@pulumi.output_type
class MTPDataConnectorDataTypesResponseIncidents(dict):
    """
    Data type for Microsoft Threat Protection Platforms data connector.
    """
    def __init__(__self__, *,
                 state: str):
        """
        Data type for Microsoft Threat Protection Platforms data connector.
        :param str state: Describe whether this data type connection is enabled or not.
        """
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        Describe whether this data type connection is enabled or not.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class MetadataAuthorResponse(dict):
    """
    Publisher or creator of the content item.
    """
    def __init__(__self__, *,
                 email: Optional[str] = None,
                 link: Optional[str] = None,
                 name: Optional[str] = None):
        """
        Publisher or creator of the content item.
        :param str email: Email of author contact
        :param str link: Link for author/vendor page
        :param str name: Name of the author. Company or person.
        """
        if email is not None:
            pulumi.set(__self__, "email", email)
        if link is not None:
            pulumi.set(__self__, "link", link)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def email(self) -> Optional[str]:
        """
        Email of author contact
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter
    def link(self) -> Optional[str]:
        """
        Link for author/vendor page
        """
        return pulumi.get(self, "link")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the author. Company or person.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class MetadataCategoriesResponse(dict):
    """
    ies for the solution content item
    """
    def __init__(__self__, *,
                 domains: Optional[Sequence[str]] = None,
                 verticals: Optional[Sequence[str]] = None):
        """
        ies for the solution content item
        :param Sequence[str] domains: domain for the solution content item
        :param Sequence[str] verticals: Industry verticals for the solution content item
        """
        if domains is not None:
            pulumi.set(__self__, "domains", domains)
        if verticals is not None:
            pulumi.set(__self__, "verticals", verticals)

    @property
    @pulumi.getter
    def domains(self) -> Optional[Sequence[str]]:
        """
        domain for the solution content item
        """
        return pulumi.get(self, "domains")

    @property
    @pulumi.getter
    def verticals(self) -> Optional[Sequence[str]]:
        """
        Industry verticals for the solution content item
        """
        return pulumi.get(self, "verticals")


@pulumi.output_type
class MetadataDependenciesResponse(dict):
    """
    Dependencies for the content item, what other content items it requires to work.  Can describe more complex dependencies using a recursive/nested structure. For a single dependency an id/kind/version can be supplied or operator/criteria for complex dependencies.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "contentId":
            suggest = "content_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MetadataDependenciesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MetadataDependenciesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MetadataDependenciesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 content_id: Optional[str] = None,
                 criteria: Optional[Sequence['outputs.MetadataDependenciesResponse']] = None,
                 kind: Optional[str] = None,
                 name: Optional[str] = None,
                 operator: Optional[str] = None,
                 version: Optional[str] = None):
        """
        Dependencies for the content item, what other content items it requires to work.  Can describe more complex dependencies using a recursive/nested structure. For a single dependency an id/kind/version can be supplied or operator/criteria for complex dependencies.
        :param str content_id: Id of the content item we depend on
        :param Sequence['MetadataDependenciesResponse'] criteria: This is the list of dependencies we must fulfill, according to the AND/OR operator
        :param str kind: Type of the content item we depend on
        :param str name: Name of the content item
        :param str operator: Operator used for list of dependencies in criteria array.
        :param str version: Version of the the content item we depend on.  Can be blank, * or missing to indicate any version fulfills the dependency.  If version does not match our defined numeric format then an exact match is required.
        """
        if content_id is not None:
            pulumi.set(__self__, "content_id", content_id)
        if criteria is not None:
            pulumi.set(__self__, "criteria", criteria)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if operator is not None:
            pulumi.set(__self__, "operator", operator)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="contentId")
    def content_id(self) -> Optional[str]:
        """
        Id of the content item we depend on
        """
        return pulumi.get(self, "content_id")

    @property
    @pulumi.getter
    def criteria(self) -> Optional[Sequence['outputs.MetadataDependenciesResponse']]:
        """
        This is the list of dependencies we must fulfill, according to the AND/OR operator
        """
        return pulumi.get(self, "criteria")

    @property
    @pulumi.getter
    def kind(self) -> Optional[str]:
        """
        Type of the content item we depend on
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the content item
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def operator(self) -> Optional[str]:
        """
        Operator used for list of dependencies in criteria array.
        """
        return pulumi.get(self, "operator")

    @property
    @pulumi.getter
    def version(self) -> Optional[str]:
        """
        Version of the the content item we depend on.  Can be blank, * or missing to indicate any version fulfills the dependency.  If version does not match our defined numeric format then an exact match is required.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class MetadataSourceResponse(dict):
    """
    The original source of the content item, where it comes from.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceId":
            suggest = "source_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MetadataSourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MetadataSourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MetadataSourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kind: str,
                 name: Optional[str] = None,
                 source_id: Optional[str] = None):
        """
        The original source of the content item, where it comes from.
        :param str kind: Source type of the content
        :param str name: Name of the content source.  The repo name, solution name, LA workspace name etc.
        :param str source_id: ID of the content source.  The solution ID, workspace ID, etc
        """
        pulumi.set(__self__, "kind", kind)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if source_id is not None:
            pulumi.set(__self__, "source_id", source_id)

    @property
    @pulumi.getter
    def kind(self) -> str:
        """
        Source type of the content
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the content source.  The repo name, solution name, LA workspace name etc.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="sourceId")
    def source_id(self) -> Optional[str]:
        """
        ID of the content source.  The solution ID, workspace ID, etc
        """
        return pulumi.get(self, "source_id")


@pulumi.output_type
class MetadataSupportResponse(dict):
    """
    Support information for the content item.
    """
    def __init__(__self__, *,
                 tier: str,
                 email: Optional[str] = None,
                 link: Optional[str] = None,
                 name: Optional[str] = None):
        """
        Support information for the content item.
        :param str tier: Type of support for content item
        :param str email: Email of support contact
        :param str link: Link for support help, like to support page to open a ticket etc.
        :param str name: Name of the support contact. Company or person.
        """
        pulumi.set(__self__, "tier", tier)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if link is not None:
            pulumi.set(__self__, "link", link)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def tier(self) -> str:
        """
        Type of support for content item
        """
        return pulumi.get(self, "tier")

    @property
    @pulumi.getter
    def email(self) -> Optional[str]:
        """
        Email of support contact
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter
    def link(self) -> Optional[str]:
        """
        Link for support help, like to support page to open a ticket etc.
        """
        return pulumi.get(self, "link")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the support contact. Company or person.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class Office365ProjectConnectorDataTypesResponse(dict):
    """
    The available data types for Office Microsoft Project data connector.
    """
    def __init__(__self__, *,
                 logs: 'outputs.Office365ProjectConnectorDataTypesResponseLogs'):
        """
        The available data types for Office Microsoft Project data connector.
        :param 'Office365ProjectConnectorDataTypesResponseLogs' logs: Logs data type.
        """
        pulumi.set(__self__, "logs", logs)

    @property
    @pulumi.getter
    def logs(self) -> 'outputs.Office365ProjectConnectorDataTypesResponseLogs':
        """
        Logs data type.
        """
        return pulumi.get(self, "logs")


@pulumi.output_type
class Office365ProjectConnectorDataTypesResponseLogs(dict):
    """
    Logs data type.
    """
    def __init__(__self__, *,
                 state: str):
        """
        Logs data type.
        :param str state: Describe whether this data type connection is enabled or not.
        """
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        Describe whether this data type connection is enabled or not.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class OfficeDataConnectorDataTypesResponse(dict):
    """
    The available data types for office data connector.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sharePoint":
            suggest = "share_point"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OfficeDataConnectorDataTypesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OfficeDataConnectorDataTypesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OfficeDataConnectorDataTypesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 exchange: 'outputs.OfficeDataConnectorDataTypesResponseExchange',
                 share_point: 'outputs.OfficeDataConnectorDataTypesResponseSharePoint',
                 teams: 'outputs.OfficeDataConnectorDataTypesResponseTeams'):
        """
        The available data types for office data connector.
        :param 'OfficeDataConnectorDataTypesResponseExchange' exchange: Exchange data type connection.
        :param 'OfficeDataConnectorDataTypesResponseSharePoint' share_point: SharePoint data type connection.
        :param 'OfficeDataConnectorDataTypesResponseTeams' teams: Teams data type connection.
        """
        pulumi.set(__self__, "exchange", exchange)
        pulumi.set(__self__, "share_point", share_point)
        pulumi.set(__self__, "teams", teams)

    @property
    @pulumi.getter
    def exchange(self) -> 'outputs.OfficeDataConnectorDataTypesResponseExchange':
        """
        Exchange data type connection.
        """
        return pulumi.get(self, "exchange")

    @property
    @pulumi.getter(name="sharePoint")
    def share_point(self) -> 'outputs.OfficeDataConnectorDataTypesResponseSharePoint':
        """
        SharePoint data type connection.
        """
        return pulumi.get(self, "share_point")

    @property
    @pulumi.getter
    def teams(self) -> 'outputs.OfficeDataConnectorDataTypesResponseTeams':
        """
        Teams data type connection.
        """
        return pulumi.get(self, "teams")


@pulumi.output_type
class OfficeDataConnectorDataTypesResponseExchange(dict):
    """
    Exchange data type connection.
    """
    def __init__(__self__, *,
                 state: str):
        """
        Exchange data type connection.
        :param str state: Describe whether this data type connection is enabled or not.
        """
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        Describe whether this data type connection is enabled or not.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class OfficeDataConnectorDataTypesResponseSharePoint(dict):
    """
    SharePoint data type connection.
    """
    def __init__(__self__, *,
                 state: str):
        """
        SharePoint data type connection.
        :param str state: Describe whether this data type connection is enabled or not.
        """
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        Describe whether this data type connection is enabled or not.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class OfficeDataConnectorDataTypesResponseTeams(dict):
    """
    Teams data type connection.
    """
    def __init__(__self__, *,
                 state: str):
        """
        Teams data type connection.
        :param str state: Describe whether this data type connection is enabled or not.
        """
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        Describe whether this data type connection is enabled or not.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class OfficePowerBIConnectorDataTypesResponse(dict):
    """
    The available data types for Office Microsoft PowerBI data connector.
    """
    def __init__(__self__, *,
                 logs: 'outputs.OfficePowerBIConnectorDataTypesResponseLogs'):
        """
        The available data types for Office Microsoft PowerBI data connector.
        :param 'OfficePowerBIConnectorDataTypesResponseLogs' logs: Logs data type.
        """
        pulumi.set(__self__, "logs", logs)

    @property
    @pulumi.getter
    def logs(self) -> 'outputs.OfficePowerBIConnectorDataTypesResponseLogs':
        """
        Logs data type.
        """
        return pulumi.get(self, "logs")


@pulumi.output_type
class OfficePowerBIConnectorDataTypesResponseLogs(dict):
    """
    Logs data type.
    """
    def __init__(__self__, *,
                 state: str):
        """
        Logs data type.
        :param str state: Describe whether this data type connection is enabled or not.
        """
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        Describe whether this data type connection is enabled or not.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class PermissionsResponse(dict):
    """
    Permissions required for the connector
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceProvider":
            suggest = "resource_provider"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PermissionsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PermissionsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PermissionsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 customs: Optional[Sequence['outputs.PermissionsResponseCustoms']] = None,
                 resource_provider: Optional[Sequence['outputs.PermissionsResponseResourceProvider']] = None):
        """
        Permissions required for the connector
        :param Sequence['PermissionsResponseCustoms'] customs: Customs permissions required for the connector
        :param Sequence['PermissionsResponseResourceProvider'] resource_provider: Resource provider permissions required for the connector
        """
        if customs is not None:
            pulumi.set(__self__, "customs", customs)
        if resource_provider is not None:
            pulumi.set(__self__, "resource_provider", resource_provider)

    @property
    @pulumi.getter
    def customs(self) -> Optional[Sequence['outputs.PermissionsResponseCustoms']]:
        """
        Customs permissions required for the connector
        """
        return pulumi.get(self, "customs")

    @property
    @pulumi.getter(name="resourceProvider")
    def resource_provider(self) -> Optional[Sequence['outputs.PermissionsResponseResourceProvider']]:
        """
        Resource provider permissions required for the connector
        """
        return pulumi.get(self, "resource_provider")


@pulumi.output_type
class PermissionsResponseCustoms(dict):
    def __init__(__self__, *,
                 description: Optional[str] = None,
                 name: Optional[str] = None):
        """
        :param str description: Customs permissions description
        :param str name: Customs permissions name
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Customs permissions description
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Customs permissions name
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class PermissionsResponseResourceProvider(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "permissionsDisplayText":
            suggest = "permissions_display_text"
        elif key == "providerDisplayName":
            suggest = "provider_display_name"
        elif key == "requiredPermissions":
            suggest = "required_permissions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PermissionsResponseResourceProvider. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PermissionsResponseResourceProvider.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PermissionsResponseResourceProvider.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 permissions_display_text: Optional[str] = None,
                 provider: Optional[str] = None,
                 provider_display_name: Optional[str] = None,
                 required_permissions: Optional['outputs.RequiredPermissionsResponse'] = None,
                 scope: Optional[str] = None):
        """
        :param str permissions_display_text: Permission description text
        :param str provider: Provider name
        :param str provider_display_name: Permission provider display name
        :param 'RequiredPermissionsResponse' required_permissions: Required permissions for the connector
        :param str scope: Permission provider scope
        """
        if permissions_display_text is not None:
            pulumi.set(__self__, "permissions_display_text", permissions_display_text)
        if provider is not None:
            pulumi.set(__self__, "provider", provider)
        if provider_display_name is not None:
            pulumi.set(__self__, "provider_display_name", provider_display_name)
        if required_permissions is not None:
            pulumi.set(__self__, "required_permissions", required_permissions)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)

    @property
    @pulumi.getter(name="permissionsDisplayText")
    def permissions_display_text(self) -> Optional[str]:
        """
        Permission description text
        """
        return pulumi.get(self, "permissions_display_text")

    @property
    @pulumi.getter
    def provider(self) -> Optional[str]:
        """
        Provider name
        """
        return pulumi.get(self, "provider")

    @property
    @pulumi.getter(name="providerDisplayName")
    def provider_display_name(self) -> Optional[str]:
        """
        Permission provider display name
        """
        return pulumi.get(self, "provider_display_name")

    @property
    @pulumi.getter(name="requiredPermissions")
    def required_permissions(self) -> Optional['outputs.RequiredPermissionsResponse']:
        """
        Required permissions for the connector
        """
        return pulumi.get(self, "required_permissions")

    @property
    @pulumi.getter
    def scope(self) -> Optional[str]:
        """
        Permission provider scope
        """
        return pulumi.get(self, "scope")


@pulumi.output_type
class PlaybookActionPropertiesResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "logicAppResourceId":
            suggest = "logic_app_resource_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PlaybookActionPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PlaybookActionPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PlaybookActionPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 logic_app_resource_id: Optional[str] = None,
                 tenant_id: Optional[str] = None):
        """
        :param str logic_app_resource_id: The resource id of the playbook resource
        :param str tenant_id: The tenant id of the playbook resource
        """
        if logic_app_resource_id is not None:
            pulumi.set(__self__, "logic_app_resource_id", logic_app_resource_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter(name="logicAppResourceId")
    def logic_app_resource_id(self) -> Optional[str]:
        """
        The resource id of the playbook resource
        """
        return pulumi.get(self, "logic_app_resource_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[str]:
        """
        The tenant id of the playbook resource
        """
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class PropertyConditionPropertiesResponse(dict):
    """
    Describes an automation rule condition that evaluates a property's value
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "conditionType":
            suggest = "condition_type"
        elif key == "conditionProperties":
            suggest = "condition_properties"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PropertyConditionPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PropertyConditionPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PropertyConditionPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 condition_type: str,
                 condition_properties: Optional['outputs.AutomationRulePropertyValuesConditionResponse'] = None):
        """
        Describes an automation rule condition that evaluates a property's value
        :param str condition_type: 
               Expected value is 'Property'.
        """
        pulumi.set(__self__, "condition_type", 'Property')
        if condition_properties is not None:
            pulumi.set(__self__, "condition_properties", condition_properties)

    @property
    @pulumi.getter(name="conditionType")
    def condition_type(self) -> str:
        """

        Expected value is 'Property'.
        """
        return pulumi.get(self, "condition_type")

    @property
    @pulumi.getter(name="conditionProperties")
    def condition_properties(self) -> Optional['outputs.AutomationRulePropertyValuesConditionResponse']:
        return pulumi.get(self, "condition_properties")


@pulumi.output_type
class RepoResponse(dict):
    """
    Represents a repository.
    """
    def __init__(__self__, *,
                 branches: Optional[Sequence[str]] = None,
                 full_name: Optional[str] = None,
                 url: Optional[str] = None):
        """
        Represents a repository.
        :param Sequence[str] branches: Array of branches.
        :param str full_name: The name of the repository.
        :param str url: The url to access the repository.
        """
        if branches is not None:
            pulumi.set(__self__, "branches", branches)
        if full_name is not None:
            pulumi.set(__self__, "full_name", full_name)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def branches(self) -> Optional[Sequence[str]]:
        """
        Array of branches.
        """
        return pulumi.get(self, "branches")

    @property
    @pulumi.getter(name="fullName")
    def full_name(self) -> Optional[str]:
        """
        The name of the repository.
        """
        return pulumi.get(self, "full_name")

    @property
    @pulumi.getter
    def url(self) -> Optional[str]:
        """
        The url to access the repository.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class RepositoryResponse(dict):
    """
    metadata of a repository.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deploymentLogsUrl":
            suggest = "deployment_logs_url"
        elif key == "displayUrl":
            suggest = "display_url"
        elif key == "pathMapping":
            suggest = "path_mapping"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RepositoryResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RepositoryResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RepositoryResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 branch: Optional[str] = None,
                 deployment_logs_url: Optional[str] = None,
                 display_url: Optional[str] = None,
                 path_mapping: Optional[Sequence['outputs.ContentPathMapResponse']] = None,
                 url: Optional[str] = None):
        """
        metadata of a repository.
        :param str branch: Branch name of repository.
        :param str deployment_logs_url: Url to access repository action logs.
        :param str display_url: Display url of repository.
        :param Sequence['ContentPathMapResponse'] path_mapping: Dictionary of source control content type and path mapping.
        :param str url: Url of repository.
        """
        if branch is not None:
            pulumi.set(__self__, "branch", branch)
        if deployment_logs_url is not None:
            pulumi.set(__self__, "deployment_logs_url", deployment_logs_url)
        if display_url is not None:
            pulumi.set(__self__, "display_url", display_url)
        if path_mapping is not None:
            pulumi.set(__self__, "path_mapping", path_mapping)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def branch(self) -> Optional[str]:
        """
        Branch name of repository.
        """
        return pulumi.get(self, "branch")

    @property
    @pulumi.getter(name="deploymentLogsUrl")
    def deployment_logs_url(self) -> Optional[str]:
        """
        Url to access repository action logs.
        """
        return pulumi.get(self, "deployment_logs_url")

    @property
    @pulumi.getter(name="displayUrl")
    def display_url(self) -> Optional[str]:
        """
        Display url of repository.
        """
        return pulumi.get(self, "display_url")

    @property
    @pulumi.getter(name="pathMapping")
    def path_mapping(self) -> Optional[Sequence['outputs.ContentPathMapResponse']]:
        """
        Dictionary of source control content type and path mapping.
        """
        return pulumi.get(self, "path_mapping")

    @property
    @pulumi.getter
    def url(self) -> Optional[str]:
        """
        Url of repository.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class RequiredPermissionsResponse(dict):
    """
    Required permissions for the connector
    """
    def __init__(__self__, *,
                 action: Optional[bool] = None,
                 delete: Optional[bool] = None,
                 read: Optional[bool] = None,
                 write: Optional[bool] = None):
        """
        Required permissions for the connector
        :param bool action: action permission
        :param bool delete: delete permission
        :param bool read: read permission
        :param bool write: write permission
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if delete is not None:
            pulumi.set(__self__, "delete", delete)
        if read is not None:
            pulumi.set(__self__, "read", read)
        if write is not None:
            pulumi.set(__self__, "write", write)

    @property
    @pulumi.getter
    def action(self) -> Optional[bool]:
        """
        action permission
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def delete(self) -> Optional[bool]:
        """
        delete permission
        """
        return pulumi.get(self, "delete")

    @property
    @pulumi.getter
    def read(self) -> Optional[bool]:
        """
        read permission
        """
        return pulumi.get(self, "read")

    @property
    @pulumi.getter
    def write(self) -> Optional[bool]:
        """
        write permission
        """
        return pulumi.get(self, "write")


@pulumi.output_type
class SecurityAlertTimelineItemResponse(dict):
    """
    Represents security alert timeline item.
    """
    def __init__(__self__, *,
                 alert_type: str,
                 azure_resource_id: str,
                 display_name: str,
                 end_time_utc: str,
                 kind: str,
                 severity: str,
                 start_time_utc: str,
                 time_generated: str,
                 description: Optional[str] = None,
                 product_name: Optional[str] = None):
        """
        Represents security alert timeline item.
        :param str alert_type: The name of the alert type.
        :param str azure_resource_id: The alert azure resource id.
        :param str display_name: The alert name.
        :param str end_time_utc: The alert end time.
        :param str kind: The entity query kind
               Expected value is 'SecurityAlert'.
        :param str severity: The alert severity.
        :param str start_time_utc: The alert start time.
        :param str time_generated: The alert generated time.
        :param str description: The alert description.
        :param str product_name: The alert product name.
        """
        pulumi.set(__self__, "alert_type", alert_type)
        pulumi.set(__self__, "azure_resource_id", azure_resource_id)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "end_time_utc", end_time_utc)
        pulumi.set(__self__, "kind", 'SecurityAlert')
        pulumi.set(__self__, "severity", severity)
        pulumi.set(__self__, "start_time_utc", start_time_utc)
        pulumi.set(__self__, "time_generated", time_generated)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if product_name is not None:
            pulumi.set(__self__, "product_name", product_name)

    @property
    @pulumi.getter(name="alertType")
    def alert_type(self) -> str:
        """
        The name of the alert type.
        """
        return pulumi.get(self, "alert_type")

    @property
    @pulumi.getter(name="azureResourceId")
    def azure_resource_id(self) -> str:
        """
        The alert azure resource id.
        """
        return pulumi.get(self, "azure_resource_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The alert name.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="endTimeUtc")
    def end_time_utc(self) -> str:
        """
        The alert end time.
        """
        return pulumi.get(self, "end_time_utc")

    @property
    @pulumi.getter
    def kind(self) -> str:
        """
        The entity query kind
        Expected value is 'SecurityAlert'.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def severity(self) -> str:
        """
        The alert severity.
        """
        return pulumi.get(self, "severity")

    @property
    @pulumi.getter(name="startTimeUtc")
    def start_time_utc(self) -> str:
        """
        The alert start time.
        """
        return pulumi.get(self, "start_time_utc")

    @property
    @pulumi.getter(name="timeGenerated")
    def time_generated(self) -> str:
        """
        The alert generated time.
        """
        return pulumi.get(self, "time_generated")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The alert description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="productName")
    def product_name(self) -> Optional[str]:
        """
        The alert product name.
        """
        return pulumi.get(self, "product_name")


@pulumi.output_type
class SystemDataResponse(dict):
    """
    Metadata pertaining to creation and last modification of the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdAt":
            suggest = "created_at"
        elif key == "createdBy":
            suggest = "created_by"
        elif key == "createdByType":
            suggest = "created_by_type"
        elif key == "lastModifiedAt":
            suggest = "last_modified_at"
        elif key == "lastModifiedBy":
            suggest = "last_modified_by"
        elif key == "lastModifiedByType":
            suggest = "last_modified_by_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SystemDataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_at: Optional[str] = None,
                 created_by: Optional[str] = None,
                 created_by_type: Optional[str] = None,
                 last_modified_at: Optional[str] = None,
                 last_modified_by: Optional[str] = None,
                 last_modified_by_type: Optional[str] = None):
        """
        Metadata pertaining to creation and last modification of the resource.
        :param str created_at: The timestamp of resource creation (UTC).
        :param str created_by: The identity that created the resource.
        :param str created_by_type: The type of identity that created the resource.
        :param str last_modified_at: The timestamp of resource last modification (UTC)
        :param str last_modified_by: The identity that last modified the resource.
        :param str last_modified_by_type: The type of identity that last modified the resource.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if created_by_type is not None:
            pulumi.set(__self__, "created_by_type", created_by_type)
        if last_modified_at is not None:
            pulumi.set(__self__, "last_modified_at", last_modified_at)
        if last_modified_by is not None:
            pulumi.set(__self__, "last_modified_by", last_modified_by)
        if last_modified_by_type is not None:
            pulumi.set(__self__, "last_modified_by_type", last_modified_by_type)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[str]:
        """
        The timestamp of resource creation (UTC).
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[str]:
        """
        The identity that created the resource.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="createdByType")
    def created_by_type(self) -> Optional[str]:
        """
        The type of identity that created the resource.
        """
        return pulumi.get(self, "created_by_type")

    @property
    @pulumi.getter(name="lastModifiedAt")
    def last_modified_at(self) -> Optional[str]:
        """
        The timestamp of resource last modification (UTC)
        """
        return pulumi.get(self, "last_modified_at")

    @property
    @pulumi.getter(name="lastModifiedBy")
    def last_modified_by(self) -> Optional[str]:
        """
        The identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by")

    @property
    @pulumi.getter(name="lastModifiedByType")
    def last_modified_by_type(self) -> Optional[str]:
        """
        The type of identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by_type")


@pulumi.output_type
class TIDataConnectorDataTypesResponse(dict):
    """
    The available data types for TI (Threat Intelligence) data connector.
    """
    def __init__(__self__, *,
                 indicators: 'outputs.TIDataConnectorDataTypesResponseIndicators'):
        """
        The available data types for TI (Threat Intelligence) data connector.
        :param 'TIDataConnectorDataTypesResponseIndicators' indicators: Data type for indicators connection.
        """
        pulumi.set(__self__, "indicators", indicators)

    @property
    @pulumi.getter
    def indicators(self) -> 'outputs.TIDataConnectorDataTypesResponseIndicators':
        """
        Data type for indicators connection.
        """
        return pulumi.get(self, "indicators")


@pulumi.output_type
class TIDataConnectorDataTypesResponseIndicators(dict):
    """
    Data type for indicators connection.
    """
    def __init__(__self__, *,
                 state: str):
        """
        Data type for indicators connection.
        :param str state: Describe whether this data type connection is enabled or not.
        """
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        Describe whether this data type connection is enabled or not.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class TeamInformationResponse(dict):
    """
    Describes team information
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "primaryChannelUrl":
            suggest = "primary_channel_url"
        elif key == "teamCreationTimeUtc":
            suggest = "team_creation_time_utc"
        elif key == "teamId":
            suggest = "team_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TeamInformationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TeamInformationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TeamInformationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 description: str,
                 name: str,
                 primary_channel_url: str,
                 team_creation_time_utc: str,
                 team_id: str):
        """
        Describes team information
        :param str description: The description of the team
        :param str name: The name of the team
        :param str primary_channel_url: The primary channel URL of the team
        :param str team_creation_time_utc: The time the team was created
        :param str team_id: Team ID
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "primary_channel_url", primary_channel_url)
        pulumi.set(__self__, "team_creation_time_utc", team_creation_time_utc)
        pulumi.set(__self__, "team_id", team_id)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the team
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the team
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="primaryChannelUrl")
    def primary_channel_url(self) -> str:
        """
        The primary channel URL of the team
        """
        return pulumi.get(self, "primary_channel_url")

    @property
    @pulumi.getter(name="teamCreationTimeUtc")
    def team_creation_time_utc(self) -> str:
        """
        The time the team was created
        """
        return pulumi.get(self, "team_creation_time_utc")

    @property
    @pulumi.getter(name="teamId")
    def team_id(self) -> str:
        """
        Team ID
        """
        return pulumi.get(self, "team_id")


@pulumi.output_type
class TiTaxiiDataConnectorDataTypesResponse(dict):
    """
    The available data types for Threat Intelligence TAXII data connector.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "taxiiClient":
            suggest = "taxii_client"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TiTaxiiDataConnectorDataTypesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TiTaxiiDataConnectorDataTypesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TiTaxiiDataConnectorDataTypesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 taxii_client: 'outputs.TiTaxiiDataConnectorDataTypesResponseTaxiiClient'):
        """
        The available data types for Threat Intelligence TAXII data connector.
        :param 'TiTaxiiDataConnectorDataTypesResponseTaxiiClient' taxii_client: Data type for TAXII connector.
        """
        pulumi.set(__self__, "taxii_client", taxii_client)

    @property
    @pulumi.getter(name="taxiiClient")
    def taxii_client(self) -> 'outputs.TiTaxiiDataConnectorDataTypesResponseTaxiiClient':
        """
        Data type for TAXII connector.
        """
        return pulumi.get(self, "taxii_client")


@pulumi.output_type
class TiTaxiiDataConnectorDataTypesResponseTaxiiClient(dict):
    """
    Data type for TAXII connector.
    """
    def __init__(__self__, *,
                 state: str):
        """
        Data type for TAXII connector.
        :param str state: Describe whether this data type connection is enabled or not.
        """
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        Describe whether this data type connection is enabled or not.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class TimelineAggregationResponse(dict):
    """
    timeline aggregation information per kind
    """
    def __init__(__self__, *,
                 count: int,
                 kind: str):
        """
        timeline aggregation information per kind
        :param int count: the total items found for a kind
        :param str kind: the query kind
        """
        pulumi.set(__self__, "count", count)
        pulumi.set(__self__, "kind", kind)

    @property
    @pulumi.getter
    def count(self) -> int:
        """
        the total items found for a kind
        """
        return pulumi.get(self, "count")

    @property
    @pulumi.getter
    def kind(self) -> str:
        """
        the query kind
        """
        return pulumi.get(self, "kind")


@pulumi.output_type
class TimelineErrorResponse(dict):
    """
    Timeline Query Errors.
    """
    def __init__(__self__, *,
                 error_message: str,
                 kind: str,
                 query_id: Optional[str] = None):
        """
        Timeline Query Errors.
        :param str error_message: the error message
        :param str kind: the query kind
        :param str query_id: the query id
        """
        pulumi.set(__self__, "error_message", error_message)
        pulumi.set(__self__, "kind", kind)
        if query_id is not None:
            pulumi.set(__self__, "query_id", query_id)

    @property
    @pulumi.getter(name="errorMessage")
    def error_message(self) -> str:
        """
        the error message
        """
        return pulumi.get(self, "error_message")

    @property
    @pulumi.getter
    def kind(self) -> str:
        """
        the query kind
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter(name="queryId")
    def query_id(self) -> Optional[str]:
        """
        the query id
        """
        return pulumi.get(self, "query_id")


@pulumi.output_type
class TimelineResultsMetadataResponse(dict):
    """
    Expansion result metadata.
    """
    def __init__(__self__, *,
                 aggregations: Sequence['outputs.TimelineAggregationResponse'],
                 total_count: int,
                 errors: Optional[Sequence['outputs.TimelineErrorResponse']] = None):
        """
        Expansion result metadata.
        :param Sequence['TimelineAggregationResponse'] aggregations: timeline aggregation per kind
        :param int total_count: the total items found for the timeline request
        :param Sequence['TimelineErrorResponse'] errors: information about the failure queries
        """
        pulumi.set(__self__, "aggregations", aggregations)
        pulumi.set(__self__, "total_count", total_count)
        if errors is not None:
            pulumi.set(__self__, "errors", errors)

    @property
    @pulumi.getter
    def aggregations(self) -> Sequence['outputs.TimelineAggregationResponse']:
        """
        timeline aggregation per kind
        """
        return pulumi.get(self, "aggregations")

    @property
    @pulumi.getter(name="totalCount")
    def total_count(self) -> int:
        """
        the total items found for the timeline request
        """
        return pulumi.get(self, "total_count")

    @property
    @pulumi.getter
    def errors(self) -> Optional[Sequence['outputs.TimelineErrorResponse']]:
        """
        information about the failure queries
        """
        return pulumi.get(self, "errors")


@pulumi.output_type
class UserInfoResponse(dict):
    """
    User information that made some action
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "objectId":
            suggest = "object_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 email: str,
                 name: str,
                 object_id: Optional[str] = None):
        """
        User information that made some action
        :param str email: The email of the user.
        :param str name: The name of the user.
        :param str object_id: The object id of the user.
        """
        pulumi.set(__self__, "email", email)
        pulumi.set(__self__, "name", name)
        if object_id is not None:
            pulumi.set(__self__, "object_id", object_id)

    @property
    @pulumi.getter
    def email(self) -> str:
        """
        The email of the user.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the user.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="objectId")
    def object_id(self) -> Optional[str]:
        """
        The object id of the user.
        """
        return pulumi.get(self, "object_id")


@pulumi.output_type
class WatchlistUserInfoResponse(dict):
    """
    User information that made some action
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "objectId":
            suggest = "object_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WatchlistUserInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WatchlistUserInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WatchlistUserInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 email: str,
                 name: str,
                 object_id: Optional[str] = None):
        """
        User information that made some action
        :param str email: The email of the user.
        :param str name: The name of the user.
        :param str object_id: The object id of the user.
        """
        pulumi.set(__self__, "email", email)
        pulumi.set(__self__, "name", name)
        if object_id is not None:
            pulumi.set(__self__, "object_id", object_id)

    @property
    @pulumi.getter
    def email(self) -> str:
        """
        The email of the user.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the user.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="objectId")
    def object_id(self) -> Optional[str]:
        """
        The object id of the user.
        """
        return pulumi.get(self, "object_id")


