# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AkamaiAccessControlResponse',
    'AkamaiSignatureHeaderAuthenticationKeyResponse',
    'ArmStreamingEndpointCurrentSkuResponse',
    'AssetFileEncryptionMetadataResponse',
    'AssetStreamingLocatorResponse',
    'AudioTrackResponse',
    'CbcsDrmConfigurationResponse',
    'CencDrmConfigurationResponse',
    'ClearKeyEncryptionConfigurationResponse',
    'CommonEncryptionCbcsResponse',
    'CommonEncryptionCencResponse',
    'ContentKeyPolicyClearKeyConfigurationResponse',
    'ContentKeyPolicyFairPlayConfigurationResponse',
    'ContentKeyPolicyFairPlayOfflineRentalConfigurationResponse',
    'ContentKeyPolicyOpenRestrictionResponse',
    'ContentKeyPolicyOptionResponse',
    'ContentKeyPolicyPlayReadyConfigurationResponse',
    'ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeaderResponse',
    'ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifierResponse',
    'ContentKeyPolicyPlayReadyExplicitAnalogTelevisionRestrictionResponse',
    'ContentKeyPolicyPlayReadyLicenseResponse',
    'ContentKeyPolicyPlayReadyPlayRightResponse',
    'ContentKeyPolicyRsaTokenKeyResponse',
    'ContentKeyPolicySymmetricTokenKeyResponse',
    'ContentKeyPolicyTokenClaimResponse',
    'ContentKeyPolicyTokenRestrictionResponse',
    'ContentKeyPolicyUnknownConfigurationResponse',
    'ContentKeyPolicyUnknownRestrictionResponse',
    'ContentKeyPolicyWidevineConfigurationResponse',
    'ContentKeyPolicyX509CertificateTokenKeyResponse',
    'CrossSiteAccessPoliciesResponse',
    'DashSettingsResponse',
    'DefaultKeyResponse',
    'EnabledProtocolsResponse',
    'EnvelopeEncryptionResponse',
    'FilterTrackPropertyConditionResponse',
    'FilterTrackSelectionResponse',
    'FirstQualityResponse',
    'HlsResponse',
    'HlsSettingsResponse',
    'IPAccessControlResponse',
    'IPRangeResponse',
    'LiveEventEncodingResponse',
    'LiveEventEndpointResponse',
    'LiveEventInputAccessControlResponse',
    'LiveEventInputResponse',
    'LiveEventInputTrackSelectionResponse',
    'LiveEventOutputTranscriptionTrackResponse',
    'LiveEventPreviewAccessControlResponse',
    'LiveEventPreviewResponse',
    'LiveEventTranscriptionResponse',
    'NoEncryptionResponse',
    'PresentationTimeRangeResponse',
    'StreamingEndpointAccessControlResponse',
    'StreamingLocatorContentKeyResponse',
    'StreamingPathResponse',
    'StreamingPolicyContentKeyResponse',
    'StreamingPolicyContentKeysResponse',
    'StreamingPolicyFairPlayConfigurationResponse',
    'StreamingPolicyPlayReadyConfigurationResponse',
    'StreamingPolicyWidevineConfigurationResponse',
    'SystemDataResponse',
    'TextTrackResponse',
    'TrackPropertyConditionResponse',
    'TrackSelectionResponse',
    'VideoTrackResponse',
]

@pulumi.output_type
class AkamaiAccessControlResponse(dict):
    """
    Akamai access control
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "akamaiSignatureHeaderAuthenticationKeyList":
            suggest = "akamai_signature_header_authentication_key_list"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AkamaiAccessControlResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AkamaiAccessControlResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AkamaiAccessControlResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 akamai_signature_header_authentication_key_list: Optional[Sequence['outputs.AkamaiSignatureHeaderAuthenticationKeyResponse']] = None):
        """
        Akamai access control
        :param Sequence['AkamaiSignatureHeaderAuthenticationKeyResponse'] akamai_signature_header_authentication_key_list: authentication key list
        """
        if akamai_signature_header_authentication_key_list is not None:
            pulumi.set(__self__, "akamai_signature_header_authentication_key_list", akamai_signature_header_authentication_key_list)

    @property
    @pulumi.getter(name="akamaiSignatureHeaderAuthenticationKeyList")
    def akamai_signature_header_authentication_key_list(self) -> Optional[Sequence['outputs.AkamaiSignatureHeaderAuthenticationKeyResponse']]:
        """
        authentication key list
        """
        return pulumi.get(self, "akamai_signature_header_authentication_key_list")


@pulumi.output_type
class AkamaiSignatureHeaderAuthenticationKeyResponse(dict):
    """
    Akamai Signature Header authentication key.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "base64Key":
            suggest = "base64_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AkamaiSignatureHeaderAuthenticationKeyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AkamaiSignatureHeaderAuthenticationKeyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AkamaiSignatureHeaderAuthenticationKeyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 base64_key: Optional[str] = None,
                 expiration: Optional[str] = None,
                 identifier: Optional[str] = None):
        """
        Akamai Signature Header authentication key.
        :param str base64_key: authentication key
        :param str expiration: The expiration time of the authentication key.
        :param str identifier: identifier of the key
        """
        if base64_key is not None:
            pulumi.set(__self__, "base64_key", base64_key)
        if expiration is not None:
            pulumi.set(__self__, "expiration", expiration)
        if identifier is not None:
            pulumi.set(__self__, "identifier", identifier)

    @property
    @pulumi.getter(name="base64Key")
    def base64_key(self) -> Optional[str]:
        """
        authentication key
        """
        return pulumi.get(self, "base64_key")

    @property
    @pulumi.getter
    def expiration(self) -> Optional[str]:
        """
        The expiration time of the authentication key.
        """
        return pulumi.get(self, "expiration")

    @property
    @pulumi.getter
    def identifier(self) -> Optional[str]:
        """
        identifier of the key
        """
        return pulumi.get(self, "identifier")


@pulumi.output_type
class ArmStreamingEndpointCurrentSkuResponse(dict):
    """
    The streaming endpoint current sku.
    """
    def __init__(__self__, *,
                 name: str,
                 capacity: Optional[int] = None):
        """
        The streaming endpoint current sku.
        :param str name: The streaming endpoint sku name.
        :param int capacity: The streaming endpoint sku capacity.
        """
        pulumi.set(__self__, "name", name)
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The streaming endpoint sku name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def capacity(self) -> Optional[int]:
        """
        The streaming endpoint sku capacity.
        """
        return pulumi.get(self, "capacity")


@pulumi.output_type
class AssetFileEncryptionMetadataResponse(dict):
    """
    The Asset File Storage encryption metadata.
    """
    def __init__(__self__, *,
                 asset_file_id: str,
                 asset_file_name: Optional[str] = None,
                 initialization_vector: Optional[str] = None):
        """
        The Asset File Storage encryption metadata.
        :param str asset_file_id: The Asset File Id.
        :param str asset_file_name: The Asset File name.
        :param str initialization_vector: The Asset File initialization vector.
        """
        pulumi.set(__self__, "asset_file_id", asset_file_id)
        if asset_file_name is not None:
            pulumi.set(__self__, "asset_file_name", asset_file_name)
        if initialization_vector is not None:
            pulumi.set(__self__, "initialization_vector", initialization_vector)

    @property
    @pulumi.getter(name="assetFileId")
    def asset_file_id(self) -> str:
        """
        The Asset File Id.
        """
        return pulumi.get(self, "asset_file_id")

    @property
    @pulumi.getter(name="assetFileName")
    def asset_file_name(self) -> Optional[str]:
        """
        The Asset File name.
        """
        return pulumi.get(self, "asset_file_name")

    @property
    @pulumi.getter(name="initializationVector")
    def initialization_vector(self) -> Optional[str]:
        """
        The Asset File initialization vector.
        """
        return pulumi.get(self, "initialization_vector")


@pulumi.output_type
class AssetStreamingLocatorResponse(dict):
    """
    Properties of the Streaming Locator.
    """
    def __init__(__self__, *,
                 asset_name: str,
                 created: str,
                 default_content_key_policy_name: str,
                 end_time: str,
                 name: str,
                 start_time: str,
                 streaming_locator_id: str,
                 streaming_policy_name: str):
        """
        Properties of the Streaming Locator.
        :param str asset_name: Asset Name.
        :param str created: The creation time of the Streaming Locator.
        :param str default_content_key_policy_name: Name of the default ContentKeyPolicy used by this Streaming Locator.
        :param str end_time: The end time of the Streaming Locator.
        :param str name: Streaming Locator name.
        :param str start_time: The start time of the Streaming Locator.
        :param str streaming_locator_id: StreamingLocatorId of the Streaming Locator.
        :param str streaming_policy_name: Name of the Streaming Policy used by this Streaming Locator.
        """
        pulumi.set(__self__, "asset_name", asset_name)
        pulumi.set(__self__, "created", created)
        pulumi.set(__self__, "default_content_key_policy_name", default_content_key_policy_name)
        pulumi.set(__self__, "end_time", end_time)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "start_time", start_time)
        pulumi.set(__self__, "streaming_locator_id", streaming_locator_id)
        pulumi.set(__self__, "streaming_policy_name", streaming_policy_name)

    @property
    @pulumi.getter(name="assetName")
    def asset_name(self) -> str:
        """
        Asset Name.
        """
        return pulumi.get(self, "asset_name")

    @property
    @pulumi.getter
    def created(self) -> str:
        """
        The creation time of the Streaming Locator.
        """
        return pulumi.get(self, "created")

    @property
    @pulumi.getter(name="defaultContentKeyPolicyName")
    def default_content_key_policy_name(self) -> str:
        """
        Name of the default ContentKeyPolicy used by this Streaming Locator.
        """
        return pulumi.get(self, "default_content_key_policy_name")

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> str:
        """
        The end time of the Streaming Locator.
        """
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Streaming Locator name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> str:
        """
        The start time of the Streaming Locator.
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter(name="streamingLocatorId")
    def streaming_locator_id(self) -> str:
        """
        StreamingLocatorId of the Streaming Locator.
        """
        return pulumi.get(self, "streaming_locator_id")

    @property
    @pulumi.getter(name="streamingPolicyName")
    def streaming_policy_name(self) -> str:
        """
        Name of the Streaming Policy used by this Streaming Locator.
        """
        return pulumi.get(self, "streaming_policy_name")


@pulumi.output_type
class AudioTrackResponse(dict):
    """
    Represents an audio track in the asset.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bitRate":
            suggest = "bit_rate"
        elif key == "odataType":
            suggest = "odata_type"
        elif key == "dashSettings":
            suggest = "dash_settings"
        elif key == "displayName":
            suggest = "display_name"
        elif key == "fileName":
            suggest = "file_name"
        elif key == "hlsSettings":
            suggest = "hls_settings"
        elif key == "languageCode":
            suggest = "language_code"
        elif key == "mpeg4TrackId":
            suggest = "mpeg4_track_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AudioTrackResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AudioTrackResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AudioTrackResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bit_rate: int,
                 odata_type: str,
                 dash_settings: Optional['outputs.DashSettingsResponse'] = None,
                 display_name: Optional[str] = None,
                 file_name: Optional[str] = None,
                 hls_settings: Optional['outputs.HlsSettingsResponse'] = None,
                 language_code: Optional[str] = None,
                 mpeg4_track_id: Optional[int] = None):
        """
        Represents an audio track in the asset.
        :param int bit_rate: The stream bit rate for the audio track.
        :param str odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.AudioTrack'.
        :param 'DashSettingsResponse' dash_settings: The DASH specific setting for the audio track.
        :param str display_name: The display name of the audio track on a video player. In HLS, this maps to the NAME attribute of EXT-X-MEDIA.
        :param str file_name: The file name to the source file. This file is located in the storage container of the asset.
        :param 'HlsSettingsResponse' hls_settings: The HLS specific setting for the audio track.
        :param str language_code: The RFC5646 language code for the audio track.
        :param int mpeg4_track_id: The MPEG-4 audio track ID for the audio track.
        """
        pulumi.set(__self__, "bit_rate", bit_rate)
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.AudioTrack')
        if dash_settings is not None:
            pulumi.set(__self__, "dash_settings", dash_settings)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if file_name is not None:
            pulumi.set(__self__, "file_name", file_name)
        if hls_settings is not None:
            pulumi.set(__self__, "hls_settings", hls_settings)
        if language_code is not None:
            pulumi.set(__self__, "language_code", language_code)
        if mpeg4_track_id is not None:
            pulumi.set(__self__, "mpeg4_track_id", mpeg4_track_id)

    @property
    @pulumi.getter(name="bitRate")
    def bit_rate(self) -> int:
        """
        The stream bit rate for the audio track.
        """
        return pulumi.get(self, "bit_rate")

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.AudioTrack'.
        """
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter(name="dashSettings")
    def dash_settings(self) -> Optional['outputs.DashSettingsResponse']:
        """
        The DASH specific setting for the audio track.
        """
        return pulumi.get(self, "dash_settings")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        The display name of the audio track on a video player. In HLS, this maps to the NAME attribute of EXT-X-MEDIA.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="fileName")
    def file_name(self) -> Optional[str]:
        """
        The file name to the source file. This file is located in the storage container of the asset.
        """
        return pulumi.get(self, "file_name")

    @property
    @pulumi.getter(name="hlsSettings")
    def hls_settings(self) -> Optional['outputs.HlsSettingsResponse']:
        """
        The HLS specific setting for the audio track.
        """
        return pulumi.get(self, "hls_settings")

    @property
    @pulumi.getter(name="languageCode")
    def language_code(self) -> Optional[str]:
        """
        The RFC5646 language code for the audio track.
        """
        return pulumi.get(self, "language_code")

    @property
    @pulumi.getter(name="mpeg4TrackId")
    def mpeg4_track_id(self) -> Optional[int]:
        """
        The MPEG-4 audio track ID for the audio track.
        """
        return pulumi.get(self, "mpeg4_track_id")


@pulumi.output_type
class CbcsDrmConfigurationResponse(dict):
    """
    Class to specify DRM configurations of CommonEncryptionCbcs scheme in Streaming Policy
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fairPlay":
            suggest = "fair_play"
        elif key == "playReady":
            suggest = "play_ready"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CbcsDrmConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CbcsDrmConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CbcsDrmConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fair_play: Optional['outputs.StreamingPolicyFairPlayConfigurationResponse'] = None,
                 play_ready: Optional['outputs.StreamingPolicyPlayReadyConfigurationResponse'] = None,
                 widevine: Optional['outputs.StreamingPolicyWidevineConfigurationResponse'] = None):
        """
        Class to specify DRM configurations of CommonEncryptionCbcs scheme in Streaming Policy
        :param 'StreamingPolicyFairPlayConfigurationResponse' fair_play: FairPlay configurations
        :param 'StreamingPolicyPlayReadyConfigurationResponse' play_ready: PlayReady configurations
        :param 'StreamingPolicyWidevineConfigurationResponse' widevine: Widevine configurations
        """
        if fair_play is not None:
            pulumi.set(__self__, "fair_play", fair_play)
        if play_ready is not None:
            pulumi.set(__self__, "play_ready", play_ready)
        if widevine is not None:
            pulumi.set(__self__, "widevine", widevine)

    @property
    @pulumi.getter(name="fairPlay")
    def fair_play(self) -> Optional['outputs.StreamingPolicyFairPlayConfigurationResponse']:
        """
        FairPlay configurations
        """
        return pulumi.get(self, "fair_play")

    @property
    @pulumi.getter(name="playReady")
    def play_ready(self) -> Optional['outputs.StreamingPolicyPlayReadyConfigurationResponse']:
        """
        PlayReady configurations
        """
        return pulumi.get(self, "play_ready")

    @property
    @pulumi.getter
    def widevine(self) -> Optional['outputs.StreamingPolicyWidevineConfigurationResponse']:
        """
        Widevine configurations
        """
        return pulumi.get(self, "widevine")


@pulumi.output_type
class CencDrmConfigurationResponse(dict):
    """
    Class to specify DRM configurations of CommonEncryptionCenc scheme in Streaming Policy
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "playReady":
            suggest = "play_ready"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CencDrmConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CencDrmConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CencDrmConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 play_ready: Optional['outputs.StreamingPolicyPlayReadyConfigurationResponse'] = None,
                 widevine: Optional['outputs.StreamingPolicyWidevineConfigurationResponse'] = None):
        """
        Class to specify DRM configurations of CommonEncryptionCenc scheme in Streaming Policy
        :param 'StreamingPolicyPlayReadyConfigurationResponse' play_ready: PlayReady configurations
        :param 'StreamingPolicyWidevineConfigurationResponse' widevine: Widevine configurations
        """
        if play_ready is not None:
            pulumi.set(__self__, "play_ready", play_ready)
        if widevine is not None:
            pulumi.set(__self__, "widevine", widevine)

    @property
    @pulumi.getter(name="playReady")
    def play_ready(self) -> Optional['outputs.StreamingPolicyPlayReadyConfigurationResponse']:
        """
        PlayReady configurations
        """
        return pulumi.get(self, "play_ready")

    @property
    @pulumi.getter
    def widevine(self) -> Optional['outputs.StreamingPolicyWidevineConfigurationResponse']:
        """
        Widevine configurations
        """
        return pulumi.get(self, "widevine")


@pulumi.output_type
class ClearKeyEncryptionConfigurationResponse(dict):
    """
    Class to specify ClearKey configuration of common encryption schemes in Streaming Policy
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customKeysAcquisitionUrlTemplate":
            suggest = "custom_keys_acquisition_url_template"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClearKeyEncryptionConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClearKeyEncryptionConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClearKeyEncryptionConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 custom_keys_acquisition_url_template: Optional[str] = None):
        """
        Class to specify ClearKey configuration of common encryption schemes in Streaming Policy
        :param str custom_keys_acquisition_url_template: Template for the URL of the custom service delivering content keys to end user players. Not required when using Azure Media Services for issuing licenses. The template supports replaceable tokens that the service will update at runtime with the value specific to the request.  The currently supported token value is {AlternativeMediaId}, which is replaced with the value of StreamingLocatorId.AlternativeMediaId.
        """
        if custom_keys_acquisition_url_template is not None:
            pulumi.set(__self__, "custom_keys_acquisition_url_template", custom_keys_acquisition_url_template)

    @property
    @pulumi.getter(name="customKeysAcquisitionUrlTemplate")
    def custom_keys_acquisition_url_template(self) -> Optional[str]:
        """
        Template for the URL of the custom service delivering content keys to end user players. Not required when using Azure Media Services for issuing licenses. The template supports replaceable tokens that the service will update at runtime with the value specific to the request.  The currently supported token value is {AlternativeMediaId}, which is replaced with the value of StreamingLocatorId.AlternativeMediaId.
        """
        return pulumi.get(self, "custom_keys_acquisition_url_template")


@pulumi.output_type
class CommonEncryptionCbcsResponse(dict):
    """
    Class for CommonEncryptionCbcs encryption scheme
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clearKeyEncryptionConfiguration":
            suggest = "clear_key_encryption_configuration"
        elif key == "clearTracks":
            suggest = "clear_tracks"
        elif key == "contentKeys":
            suggest = "content_keys"
        elif key == "enabledProtocols":
            suggest = "enabled_protocols"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CommonEncryptionCbcsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CommonEncryptionCbcsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CommonEncryptionCbcsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 clear_key_encryption_configuration: Optional['outputs.ClearKeyEncryptionConfigurationResponse'] = None,
                 clear_tracks: Optional[Sequence['outputs.TrackSelectionResponse']] = None,
                 content_keys: Optional['outputs.StreamingPolicyContentKeysResponse'] = None,
                 drm: Optional['outputs.CbcsDrmConfigurationResponse'] = None,
                 enabled_protocols: Optional['outputs.EnabledProtocolsResponse'] = None):
        """
        Class for CommonEncryptionCbcs encryption scheme
        :param 'ClearKeyEncryptionConfigurationResponse' clear_key_encryption_configuration: Optional configuration supporting ClearKey in CommonEncryptionCbcs encryption scheme.
        :param Sequence['TrackSelectionResponse'] clear_tracks: Representing which tracks should not be encrypted
        :param 'StreamingPolicyContentKeysResponse' content_keys: Representing default content key for each encryption scheme and separate content keys for specific tracks
        :param 'CbcsDrmConfigurationResponse' drm: Configuration of DRMs for current encryption scheme
        :param 'EnabledProtocolsResponse' enabled_protocols: Representing supported protocols
        """
        if clear_key_encryption_configuration is not None:
            pulumi.set(__self__, "clear_key_encryption_configuration", clear_key_encryption_configuration)
        if clear_tracks is not None:
            pulumi.set(__self__, "clear_tracks", clear_tracks)
        if content_keys is not None:
            pulumi.set(__self__, "content_keys", content_keys)
        if drm is not None:
            pulumi.set(__self__, "drm", drm)
        if enabled_protocols is not None:
            pulumi.set(__self__, "enabled_protocols", enabled_protocols)

    @property
    @pulumi.getter(name="clearKeyEncryptionConfiguration")
    def clear_key_encryption_configuration(self) -> Optional['outputs.ClearKeyEncryptionConfigurationResponse']:
        """
        Optional configuration supporting ClearKey in CommonEncryptionCbcs encryption scheme.
        """
        return pulumi.get(self, "clear_key_encryption_configuration")

    @property
    @pulumi.getter(name="clearTracks")
    def clear_tracks(self) -> Optional[Sequence['outputs.TrackSelectionResponse']]:
        """
        Representing which tracks should not be encrypted
        """
        return pulumi.get(self, "clear_tracks")

    @property
    @pulumi.getter(name="contentKeys")
    def content_keys(self) -> Optional['outputs.StreamingPolicyContentKeysResponse']:
        """
        Representing default content key for each encryption scheme and separate content keys for specific tracks
        """
        return pulumi.get(self, "content_keys")

    @property
    @pulumi.getter
    def drm(self) -> Optional['outputs.CbcsDrmConfigurationResponse']:
        """
        Configuration of DRMs for current encryption scheme
        """
        return pulumi.get(self, "drm")

    @property
    @pulumi.getter(name="enabledProtocols")
    def enabled_protocols(self) -> Optional['outputs.EnabledProtocolsResponse']:
        """
        Representing supported protocols
        """
        return pulumi.get(self, "enabled_protocols")


@pulumi.output_type
class CommonEncryptionCencResponse(dict):
    """
    Class for envelope encryption scheme
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clearKeyEncryptionConfiguration":
            suggest = "clear_key_encryption_configuration"
        elif key == "clearTracks":
            suggest = "clear_tracks"
        elif key == "contentKeys":
            suggest = "content_keys"
        elif key == "enabledProtocols":
            suggest = "enabled_protocols"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CommonEncryptionCencResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CommonEncryptionCencResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CommonEncryptionCencResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 clear_key_encryption_configuration: Optional['outputs.ClearKeyEncryptionConfigurationResponse'] = None,
                 clear_tracks: Optional[Sequence['outputs.TrackSelectionResponse']] = None,
                 content_keys: Optional['outputs.StreamingPolicyContentKeysResponse'] = None,
                 drm: Optional['outputs.CencDrmConfigurationResponse'] = None,
                 enabled_protocols: Optional['outputs.EnabledProtocolsResponse'] = None):
        """
        Class for envelope encryption scheme
        :param 'ClearKeyEncryptionConfigurationResponse' clear_key_encryption_configuration: Optional configuration supporting ClearKey in CommonEncryptionCenc encryption scheme.
        :param Sequence['TrackSelectionResponse'] clear_tracks: Representing which tracks should not be encrypted
        :param 'StreamingPolicyContentKeysResponse' content_keys: Representing default content key for each encryption scheme and separate content keys for specific tracks
        :param 'CencDrmConfigurationResponse' drm: Configuration of DRMs for CommonEncryptionCenc encryption scheme
        :param 'EnabledProtocolsResponse' enabled_protocols: Representing supported protocols
        """
        if clear_key_encryption_configuration is not None:
            pulumi.set(__self__, "clear_key_encryption_configuration", clear_key_encryption_configuration)
        if clear_tracks is not None:
            pulumi.set(__self__, "clear_tracks", clear_tracks)
        if content_keys is not None:
            pulumi.set(__self__, "content_keys", content_keys)
        if drm is not None:
            pulumi.set(__self__, "drm", drm)
        if enabled_protocols is not None:
            pulumi.set(__self__, "enabled_protocols", enabled_protocols)

    @property
    @pulumi.getter(name="clearKeyEncryptionConfiguration")
    def clear_key_encryption_configuration(self) -> Optional['outputs.ClearKeyEncryptionConfigurationResponse']:
        """
        Optional configuration supporting ClearKey in CommonEncryptionCenc encryption scheme.
        """
        return pulumi.get(self, "clear_key_encryption_configuration")

    @property
    @pulumi.getter(name="clearTracks")
    def clear_tracks(self) -> Optional[Sequence['outputs.TrackSelectionResponse']]:
        """
        Representing which tracks should not be encrypted
        """
        return pulumi.get(self, "clear_tracks")

    @property
    @pulumi.getter(name="contentKeys")
    def content_keys(self) -> Optional['outputs.StreamingPolicyContentKeysResponse']:
        """
        Representing default content key for each encryption scheme and separate content keys for specific tracks
        """
        return pulumi.get(self, "content_keys")

    @property
    @pulumi.getter
    def drm(self) -> Optional['outputs.CencDrmConfigurationResponse']:
        """
        Configuration of DRMs for CommonEncryptionCenc encryption scheme
        """
        return pulumi.get(self, "drm")

    @property
    @pulumi.getter(name="enabledProtocols")
    def enabled_protocols(self) -> Optional['outputs.EnabledProtocolsResponse']:
        """
        Representing supported protocols
        """
        return pulumi.get(self, "enabled_protocols")


@pulumi.output_type
class ContentKeyPolicyClearKeyConfigurationResponse(dict):
    """
    Represents a configuration for non-DRM keys.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContentKeyPolicyClearKeyConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContentKeyPolicyClearKeyConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContentKeyPolicyClearKeyConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str):
        """
        Represents a configuration for non-DRM keys.
        :param str odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.ContentKeyPolicyClearKeyConfiguration'.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.ContentKeyPolicyClearKeyConfiguration')

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.ContentKeyPolicyClearKeyConfiguration'.
        """
        return pulumi.get(self, "odata_type")


@pulumi.output_type
class ContentKeyPolicyFairPlayConfigurationResponse(dict):
    """
    Specifies a configuration for FairPlay licenses.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fairPlayPfx":
            suggest = "fair_play_pfx"
        elif key == "fairPlayPfxPassword":
            suggest = "fair_play_pfx_password"
        elif key == "odataType":
            suggest = "odata_type"
        elif key == "rentalAndLeaseKeyType":
            suggest = "rental_and_lease_key_type"
        elif key == "rentalDuration":
            suggest = "rental_duration"
        elif key == "offlineRentalConfiguration":
            suggest = "offline_rental_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContentKeyPolicyFairPlayConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContentKeyPolicyFairPlayConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContentKeyPolicyFairPlayConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ask: str,
                 fair_play_pfx: str,
                 fair_play_pfx_password: str,
                 odata_type: str,
                 rental_and_lease_key_type: str,
                 rental_duration: float,
                 offline_rental_configuration: Optional['outputs.ContentKeyPolicyFairPlayOfflineRentalConfigurationResponse'] = None):
        """
        Specifies a configuration for FairPlay licenses.
        :param str ask: The key that must be used as FairPlay Application Secret key.
        :param str fair_play_pfx: The Base64 representation of FairPlay certificate in PKCS 12 (pfx) format (including private key).
        :param str fair_play_pfx_password: The password encrypting FairPlay certificate in PKCS 12 (pfx) format.
        :param str odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.ContentKeyPolicyFairPlayConfiguration'.
        :param str rental_and_lease_key_type: The rental and lease key type.
        :param float rental_duration: The rental duration. Must be greater than or equal to 0.
        :param 'ContentKeyPolicyFairPlayOfflineRentalConfigurationResponse' offline_rental_configuration: Offline rental policy
        """
        pulumi.set(__self__, "ask", ask)
        pulumi.set(__self__, "fair_play_pfx", fair_play_pfx)
        pulumi.set(__self__, "fair_play_pfx_password", fair_play_pfx_password)
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.ContentKeyPolicyFairPlayConfiguration')
        pulumi.set(__self__, "rental_and_lease_key_type", rental_and_lease_key_type)
        pulumi.set(__self__, "rental_duration", rental_duration)
        if offline_rental_configuration is not None:
            pulumi.set(__self__, "offline_rental_configuration", offline_rental_configuration)

    @property
    @pulumi.getter
    def ask(self) -> str:
        """
        The key that must be used as FairPlay Application Secret key.
        """
        return pulumi.get(self, "ask")

    @property
    @pulumi.getter(name="fairPlayPfx")
    def fair_play_pfx(self) -> str:
        """
        The Base64 representation of FairPlay certificate in PKCS 12 (pfx) format (including private key).
        """
        return pulumi.get(self, "fair_play_pfx")

    @property
    @pulumi.getter(name="fairPlayPfxPassword")
    def fair_play_pfx_password(self) -> str:
        """
        The password encrypting FairPlay certificate in PKCS 12 (pfx) format.
        """
        return pulumi.get(self, "fair_play_pfx_password")

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.ContentKeyPolicyFairPlayConfiguration'.
        """
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter(name="rentalAndLeaseKeyType")
    def rental_and_lease_key_type(self) -> str:
        """
        The rental and lease key type.
        """
        return pulumi.get(self, "rental_and_lease_key_type")

    @property
    @pulumi.getter(name="rentalDuration")
    def rental_duration(self) -> float:
        """
        The rental duration. Must be greater than or equal to 0.
        """
        return pulumi.get(self, "rental_duration")

    @property
    @pulumi.getter(name="offlineRentalConfiguration")
    def offline_rental_configuration(self) -> Optional['outputs.ContentKeyPolicyFairPlayOfflineRentalConfigurationResponse']:
        """
        Offline rental policy
        """
        return pulumi.get(self, "offline_rental_configuration")


@pulumi.output_type
class ContentKeyPolicyFairPlayOfflineRentalConfigurationResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "playbackDurationSeconds":
            suggest = "playback_duration_seconds"
        elif key == "storageDurationSeconds":
            suggest = "storage_duration_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContentKeyPolicyFairPlayOfflineRentalConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContentKeyPolicyFairPlayOfflineRentalConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContentKeyPolicyFairPlayOfflineRentalConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 playback_duration_seconds: float,
                 storage_duration_seconds: float):
        """
        :param float playback_duration_seconds: Playback duration
        :param float storage_duration_seconds: Storage duration
        """
        pulumi.set(__self__, "playback_duration_seconds", playback_duration_seconds)
        pulumi.set(__self__, "storage_duration_seconds", storage_duration_seconds)

    @property
    @pulumi.getter(name="playbackDurationSeconds")
    def playback_duration_seconds(self) -> float:
        """
        Playback duration
        """
        return pulumi.get(self, "playback_duration_seconds")

    @property
    @pulumi.getter(name="storageDurationSeconds")
    def storage_duration_seconds(self) -> float:
        """
        Storage duration
        """
        return pulumi.get(self, "storage_duration_seconds")


@pulumi.output_type
class ContentKeyPolicyOpenRestrictionResponse(dict):
    """
    Represents an open restriction. License or key will be delivered on every request.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContentKeyPolicyOpenRestrictionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContentKeyPolicyOpenRestrictionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContentKeyPolicyOpenRestrictionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str):
        """
        Represents an open restriction. License or key will be delivered on every request.
        :param str odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.ContentKeyPolicyOpenRestriction'.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.ContentKeyPolicyOpenRestriction')

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.ContentKeyPolicyOpenRestriction'.
        """
        return pulumi.get(self, "odata_type")


@pulumi.output_type
class ContentKeyPolicyOptionResponse(dict):
    """
    Represents a policy option.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "policyOptionId":
            suggest = "policy_option_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContentKeyPolicyOptionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContentKeyPolicyOptionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContentKeyPolicyOptionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 configuration: Any,
                 policy_option_id: str,
                 restriction: Any,
                 name: Optional[str] = None):
        """
        Represents a policy option.
        :param Union['ContentKeyPolicyClearKeyConfigurationResponse', 'ContentKeyPolicyFairPlayConfigurationResponse', 'ContentKeyPolicyPlayReadyConfigurationResponse', 'ContentKeyPolicyUnknownConfigurationResponse', 'ContentKeyPolicyWidevineConfigurationResponse'] configuration: The key delivery configuration.
        :param str policy_option_id: The legacy Policy Option ID.
        :param Union['ContentKeyPolicyOpenRestrictionResponse', 'ContentKeyPolicyTokenRestrictionResponse', 'ContentKeyPolicyUnknownRestrictionResponse'] restriction: The requirements that must be met to deliver keys with this configuration
        :param str name: The Policy Option description.
        """
        pulumi.set(__self__, "configuration", configuration)
        pulumi.set(__self__, "policy_option_id", policy_option_id)
        pulumi.set(__self__, "restriction", restriction)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def configuration(self) -> Any:
        """
        The key delivery configuration.
        """
        return pulumi.get(self, "configuration")

    @property
    @pulumi.getter(name="policyOptionId")
    def policy_option_id(self) -> str:
        """
        The legacy Policy Option ID.
        """
        return pulumi.get(self, "policy_option_id")

    @property
    @pulumi.getter
    def restriction(self) -> Any:
        """
        The requirements that must be met to deliver keys with this configuration
        """
        return pulumi.get(self, "restriction")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The Policy Option description.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class ContentKeyPolicyPlayReadyConfigurationResponse(dict):
    """
    Specifies a configuration for PlayReady licenses.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"
        elif key == "responseCustomData":
            suggest = "response_custom_data"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContentKeyPolicyPlayReadyConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContentKeyPolicyPlayReadyConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContentKeyPolicyPlayReadyConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 licenses: Sequence['outputs.ContentKeyPolicyPlayReadyLicenseResponse'],
                 odata_type: str,
                 response_custom_data: Optional[str] = None):
        """
        Specifies a configuration for PlayReady licenses.
        :param Sequence['ContentKeyPolicyPlayReadyLicenseResponse'] licenses: The PlayReady licenses.
        :param str odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.ContentKeyPolicyPlayReadyConfiguration'.
        :param str response_custom_data: The custom response data.
        """
        pulumi.set(__self__, "licenses", licenses)
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.ContentKeyPolicyPlayReadyConfiguration')
        if response_custom_data is not None:
            pulumi.set(__self__, "response_custom_data", response_custom_data)

    @property
    @pulumi.getter
    def licenses(self) -> Sequence['outputs.ContentKeyPolicyPlayReadyLicenseResponse']:
        """
        The PlayReady licenses.
        """
        return pulumi.get(self, "licenses")

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.ContentKeyPolicyPlayReadyConfiguration'.
        """
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter(name="responseCustomData")
    def response_custom_data(self) -> Optional[str]:
        """
        The custom response data.
        """
        return pulumi.get(self, "response_custom_data")


@pulumi.output_type
class ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeaderResponse(dict):
    """
    Specifies that the content key ID is in the PlayReady header.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeaderResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeaderResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeaderResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str):
        """
        Specifies that the content key ID is in the PlayReady header.
        :param str odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeader'.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeader')

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeader'.
        """
        return pulumi.get(self, "odata_type")


@pulumi.output_type
class ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifierResponse(dict):
    """
    Specifies that the content key ID is specified in the PlayReady configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyId":
            suggest = "key_id"
        elif key == "odataType":
            suggest = "odata_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifierResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifierResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifierResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_id: str,
                 odata_type: str):
        """
        Specifies that the content key ID is specified in the PlayReady configuration.
        :param str key_id: The content key ID.
        :param str odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifier'.
        """
        pulumi.set(__self__, "key_id", key_id)
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifier')

    @property
    @pulumi.getter(name="keyId")
    def key_id(self) -> str:
        """
        The content key ID.
        """
        return pulumi.get(self, "key_id")

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifier'.
        """
        return pulumi.get(self, "odata_type")


@pulumi.output_type
class ContentKeyPolicyPlayReadyExplicitAnalogTelevisionRestrictionResponse(dict):
    """
    Configures the Explicit Analog Television Output Restriction control bits. For further details see the PlayReady Compliance Rules.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bestEffort":
            suggest = "best_effort"
        elif key == "configurationData":
            suggest = "configuration_data"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContentKeyPolicyPlayReadyExplicitAnalogTelevisionRestrictionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContentKeyPolicyPlayReadyExplicitAnalogTelevisionRestrictionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContentKeyPolicyPlayReadyExplicitAnalogTelevisionRestrictionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 best_effort: bool,
                 configuration_data: int):
        """
        Configures the Explicit Analog Television Output Restriction control bits. For further details see the PlayReady Compliance Rules.
        :param bool best_effort: Indicates whether this restriction is enforced on a Best Effort basis.
        :param int configuration_data: Configures the restriction control bits. Must be between 0 and 3 inclusive.
        """
        pulumi.set(__self__, "best_effort", best_effort)
        pulumi.set(__self__, "configuration_data", configuration_data)

    @property
    @pulumi.getter(name="bestEffort")
    def best_effort(self) -> bool:
        """
        Indicates whether this restriction is enforced on a Best Effort basis.
        """
        return pulumi.get(self, "best_effort")

    @property
    @pulumi.getter(name="configurationData")
    def configuration_data(self) -> int:
        """
        Configures the restriction control bits. Must be between 0 and 3 inclusive.
        """
        return pulumi.get(self, "configuration_data")


@pulumi.output_type
class ContentKeyPolicyPlayReadyLicenseResponse(dict):
    """
    The PlayReady license
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowTestDevices":
            suggest = "allow_test_devices"
        elif key == "contentKeyLocation":
            suggest = "content_key_location"
        elif key == "contentType":
            suggest = "content_type"
        elif key == "licenseType":
            suggest = "license_type"
        elif key == "beginDate":
            suggest = "begin_date"
        elif key == "expirationDate":
            suggest = "expiration_date"
        elif key == "gracePeriod":
            suggest = "grace_period"
        elif key == "playRight":
            suggest = "play_right"
        elif key == "relativeBeginDate":
            suggest = "relative_begin_date"
        elif key == "relativeExpirationDate":
            suggest = "relative_expiration_date"
        elif key == "securityLevel":
            suggest = "security_level"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContentKeyPolicyPlayReadyLicenseResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContentKeyPolicyPlayReadyLicenseResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContentKeyPolicyPlayReadyLicenseResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allow_test_devices: bool,
                 content_key_location: Any,
                 content_type: str,
                 license_type: str,
                 begin_date: Optional[str] = None,
                 expiration_date: Optional[str] = None,
                 grace_period: Optional[str] = None,
                 play_right: Optional['outputs.ContentKeyPolicyPlayReadyPlayRightResponse'] = None,
                 relative_begin_date: Optional[str] = None,
                 relative_expiration_date: Optional[str] = None,
                 security_level: Optional[str] = None):
        """
        The PlayReady license
        :param bool allow_test_devices: A flag indicating whether test devices can use the license.
        :param Union['ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeaderResponse', 'ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifierResponse'] content_key_location: The content key location.
        :param str content_type: The PlayReady content type.
        :param str license_type: The license type.
        :param str begin_date: The begin date of license
        :param str expiration_date: The expiration date of license.
        :param str grace_period: The grace period of license.
        :param 'ContentKeyPolicyPlayReadyPlayRightResponse' play_right: The license PlayRight
        :param str relative_begin_date: The relative begin date of license.
        :param str relative_expiration_date: The relative expiration date of license.
        :param str security_level: The security level.
        """
        pulumi.set(__self__, "allow_test_devices", allow_test_devices)
        pulumi.set(__self__, "content_key_location", content_key_location)
        pulumi.set(__self__, "content_type", content_type)
        pulumi.set(__self__, "license_type", license_type)
        if begin_date is not None:
            pulumi.set(__self__, "begin_date", begin_date)
        if expiration_date is not None:
            pulumi.set(__self__, "expiration_date", expiration_date)
        if grace_period is not None:
            pulumi.set(__self__, "grace_period", grace_period)
        if play_right is not None:
            pulumi.set(__self__, "play_right", play_right)
        if relative_begin_date is not None:
            pulumi.set(__self__, "relative_begin_date", relative_begin_date)
        if relative_expiration_date is not None:
            pulumi.set(__self__, "relative_expiration_date", relative_expiration_date)
        if security_level is not None:
            pulumi.set(__self__, "security_level", security_level)

    @property
    @pulumi.getter(name="allowTestDevices")
    def allow_test_devices(self) -> bool:
        """
        A flag indicating whether test devices can use the license.
        """
        return pulumi.get(self, "allow_test_devices")

    @property
    @pulumi.getter(name="contentKeyLocation")
    def content_key_location(self) -> Any:
        """
        The content key location.
        """
        return pulumi.get(self, "content_key_location")

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> str:
        """
        The PlayReady content type.
        """
        return pulumi.get(self, "content_type")

    @property
    @pulumi.getter(name="licenseType")
    def license_type(self) -> str:
        """
        The license type.
        """
        return pulumi.get(self, "license_type")

    @property
    @pulumi.getter(name="beginDate")
    def begin_date(self) -> Optional[str]:
        """
        The begin date of license
        """
        return pulumi.get(self, "begin_date")

    @property
    @pulumi.getter(name="expirationDate")
    def expiration_date(self) -> Optional[str]:
        """
        The expiration date of license.
        """
        return pulumi.get(self, "expiration_date")

    @property
    @pulumi.getter(name="gracePeriod")
    def grace_period(self) -> Optional[str]:
        """
        The grace period of license.
        """
        return pulumi.get(self, "grace_period")

    @property
    @pulumi.getter(name="playRight")
    def play_right(self) -> Optional['outputs.ContentKeyPolicyPlayReadyPlayRightResponse']:
        """
        The license PlayRight
        """
        return pulumi.get(self, "play_right")

    @property
    @pulumi.getter(name="relativeBeginDate")
    def relative_begin_date(self) -> Optional[str]:
        """
        The relative begin date of license.
        """
        return pulumi.get(self, "relative_begin_date")

    @property
    @pulumi.getter(name="relativeExpirationDate")
    def relative_expiration_date(self) -> Optional[str]:
        """
        The relative expiration date of license.
        """
        return pulumi.get(self, "relative_expiration_date")

    @property
    @pulumi.getter(name="securityLevel")
    def security_level(self) -> Optional[str]:
        """
        The security level.
        """
        return pulumi.get(self, "security_level")


@pulumi.output_type
class ContentKeyPolicyPlayReadyPlayRightResponse(dict):
    """
    Configures the Play Right in the PlayReady license.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowPassingVideoContentToUnknownOutput":
            suggest = "allow_passing_video_content_to_unknown_output"
        elif key == "digitalVideoOnlyContentRestriction":
            suggest = "digital_video_only_content_restriction"
        elif key == "imageConstraintForAnalogComponentVideoRestriction":
            suggest = "image_constraint_for_analog_component_video_restriction"
        elif key == "imageConstraintForAnalogComputerMonitorRestriction":
            suggest = "image_constraint_for_analog_computer_monitor_restriction"
        elif key == "agcAndColorStripeRestriction":
            suggest = "agc_and_color_stripe_restriction"
        elif key == "analogVideoOpl":
            suggest = "analog_video_opl"
        elif key == "compressedDigitalAudioOpl":
            suggest = "compressed_digital_audio_opl"
        elif key == "compressedDigitalVideoOpl":
            suggest = "compressed_digital_video_opl"
        elif key == "explicitAnalogTelevisionOutputRestriction":
            suggest = "explicit_analog_television_output_restriction"
        elif key == "firstPlayExpiration":
            suggest = "first_play_expiration"
        elif key == "scmsRestriction":
            suggest = "scms_restriction"
        elif key == "uncompressedDigitalAudioOpl":
            suggest = "uncompressed_digital_audio_opl"
        elif key == "uncompressedDigitalVideoOpl":
            suggest = "uncompressed_digital_video_opl"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContentKeyPolicyPlayReadyPlayRightResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContentKeyPolicyPlayReadyPlayRightResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContentKeyPolicyPlayReadyPlayRightResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allow_passing_video_content_to_unknown_output: str,
                 digital_video_only_content_restriction: bool,
                 image_constraint_for_analog_component_video_restriction: bool,
                 image_constraint_for_analog_computer_monitor_restriction: bool,
                 agc_and_color_stripe_restriction: Optional[int] = None,
                 analog_video_opl: Optional[int] = None,
                 compressed_digital_audio_opl: Optional[int] = None,
                 compressed_digital_video_opl: Optional[int] = None,
                 explicit_analog_television_output_restriction: Optional['outputs.ContentKeyPolicyPlayReadyExplicitAnalogTelevisionRestrictionResponse'] = None,
                 first_play_expiration: Optional[str] = None,
                 scms_restriction: Optional[int] = None,
                 uncompressed_digital_audio_opl: Optional[int] = None,
                 uncompressed_digital_video_opl: Optional[int] = None):
        """
        Configures the Play Right in the PlayReady license.
        :param str allow_passing_video_content_to_unknown_output: Configures Unknown output handling settings of the license.
        :param bool digital_video_only_content_restriction: Enables the Image Constraint For Analog Component Video Restriction in the license.
        :param bool image_constraint_for_analog_component_video_restriction: Enables the Image Constraint For Analog Component Video Restriction in the license.
        :param bool image_constraint_for_analog_computer_monitor_restriction: Enables the Image Constraint For Analog Component Video Restriction in the license.
        :param int agc_and_color_stripe_restriction: Configures Automatic Gain Control (AGC) and Color Stripe in the license. Must be between 0 and 3 inclusive.
        :param int analog_video_opl: Specifies the output protection level for compressed digital audio.
        :param int compressed_digital_audio_opl: Specifies the output protection level for compressed digital audio.
        :param int compressed_digital_video_opl: Specifies the output protection level for compressed digital video.
        :param 'ContentKeyPolicyPlayReadyExplicitAnalogTelevisionRestrictionResponse' explicit_analog_television_output_restriction: Configures the Explicit Analog Television Output Restriction in the license. Configuration data must be between 0 and 3 inclusive.
        :param str first_play_expiration: The amount of time that the license is valid after the license is first used to play content.
        :param int scms_restriction: Configures the Serial Copy Management System (SCMS) in the license. Must be between 0 and 3 inclusive.
        :param int uncompressed_digital_audio_opl: Specifies the output protection level for uncompressed digital audio.
        :param int uncompressed_digital_video_opl: Specifies the output protection level for uncompressed digital video.
        """
        pulumi.set(__self__, "allow_passing_video_content_to_unknown_output", allow_passing_video_content_to_unknown_output)
        pulumi.set(__self__, "digital_video_only_content_restriction", digital_video_only_content_restriction)
        pulumi.set(__self__, "image_constraint_for_analog_component_video_restriction", image_constraint_for_analog_component_video_restriction)
        pulumi.set(__self__, "image_constraint_for_analog_computer_monitor_restriction", image_constraint_for_analog_computer_monitor_restriction)
        if agc_and_color_stripe_restriction is not None:
            pulumi.set(__self__, "agc_and_color_stripe_restriction", agc_and_color_stripe_restriction)
        if analog_video_opl is not None:
            pulumi.set(__self__, "analog_video_opl", analog_video_opl)
        if compressed_digital_audio_opl is not None:
            pulumi.set(__self__, "compressed_digital_audio_opl", compressed_digital_audio_opl)
        if compressed_digital_video_opl is not None:
            pulumi.set(__self__, "compressed_digital_video_opl", compressed_digital_video_opl)
        if explicit_analog_television_output_restriction is not None:
            pulumi.set(__self__, "explicit_analog_television_output_restriction", explicit_analog_television_output_restriction)
        if first_play_expiration is not None:
            pulumi.set(__self__, "first_play_expiration", first_play_expiration)
        if scms_restriction is not None:
            pulumi.set(__self__, "scms_restriction", scms_restriction)
        if uncompressed_digital_audio_opl is not None:
            pulumi.set(__self__, "uncompressed_digital_audio_opl", uncompressed_digital_audio_opl)
        if uncompressed_digital_video_opl is not None:
            pulumi.set(__self__, "uncompressed_digital_video_opl", uncompressed_digital_video_opl)

    @property
    @pulumi.getter(name="allowPassingVideoContentToUnknownOutput")
    def allow_passing_video_content_to_unknown_output(self) -> str:
        """
        Configures Unknown output handling settings of the license.
        """
        return pulumi.get(self, "allow_passing_video_content_to_unknown_output")

    @property
    @pulumi.getter(name="digitalVideoOnlyContentRestriction")
    def digital_video_only_content_restriction(self) -> bool:
        """
        Enables the Image Constraint For Analog Component Video Restriction in the license.
        """
        return pulumi.get(self, "digital_video_only_content_restriction")

    @property
    @pulumi.getter(name="imageConstraintForAnalogComponentVideoRestriction")
    def image_constraint_for_analog_component_video_restriction(self) -> bool:
        """
        Enables the Image Constraint For Analog Component Video Restriction in the license.
        """
        return pulumi.get(self, "image_constraint_for_analog_component_video_restriction")

    @property
    @pulumi.getter(name="imageConstraintForAnalogComputerMonitorRestriction")
    def image_constraint_for_analog_computer_monitor_restriction(self) -> bool:
        """
        Enables the Image Constraint For Analog Component Video Restriction in the license.
        """
        return pulumi.get(self, "image_constraint_for_analog_computer_monitor_restriction")

    @property
    @pulumi.getter(name="agcAndColorStripeRestriction")
    def agc_and_color_stripe_restriction(self) -> Optional[int]:
        """
        Configures Automatic Gain Control (AGC) and Color Stripe in the license. Must be between 0 and 3 inclusive.
        """
        return pulumi.get(self, "agc_and_color_stripe_restriction")

    @property
    @pulumi.getter(name="analogVideoOpl")
    def analog_video_opl(self) -> Optional[int]:
        """
        Specifies the output protection level for compressed digital audio.
        """
        return pulumi.get(self, "analog_video_opl")

    @property
    @pulumi.getter(name="compressedDigitalAudioOpl")
    def compressed_digital_audio_opl(self) -> Optional[int]:
        """
        Specifies the output protection level for compressed digital audio.
        """
        return pulumi.get(self, "compressed_digital_audio_opl")

    @property
    @pulumi.getter(name="compressedDigitalVideoOpl")
    def compressed_digital_video_opl(self) -> Optional[int]:
        """
        Specifies the output protection level for compressed digital video.
        """
        return pulumi.get(self, "compressed_digital_video_opl")

    @property
    @pulumi.getter(name="explicitAnalogTelevisionOutputRestriction")
    def explicit_analog_television_output_restriction(self) -> Optional['outputs.ContentKeyPolicyPlayReadyExplicitAnalogTelevisionRestrictionResponse']:
        """
        Configures the Explicit Analog Television Output Restriction in the license. Configuration data must be between 0 and 3 inclusive.
        """
        return pulumi.get(self, "explicit_analog_television_output_restriction")

    @property
    @pulumi.getter(name="firstPlayExpiration")
    def first_play_expiration(self) -> Optional[str]:
        """
        The amount of time that the license is valid after the license is first used to play content.
        """
        return pulumi.get(self, "first_play_expiration")

    @property
    @pulumi.getter(name="scmsRestriction")
    def scms_restriction(self) -> Optional[int]:
        """
        Configures the Serial Copy Management System (SCMS) in the license. Must be between 0 and 3 inclusive.
        """
        return pulumi.get(self, "scms_restriction")

    @property
    @pulumi.getter(name="uncompressedDigitalAudioOpl")
    def uncompressed_digital_audio_opl(self) -> Optional[int]:
        """
        Specifies the output protection level for uncompressed digital audio.
        """
        return pulumi.get(self, "uncompressed_digital_audio_opl")

    @property
    @pulumi.getter(name="uncompressedDigitalVideoOpl")
    def uncompressed_digital_video_opl(self) -> Optional[int]:
        """
        Specifies the output protection level for uncompressed digital video.
        """
        return pulumi.get(self, "uncompressed_digital_video_opl")


@pulumi.output_type
class ContentKeyPolicyRsaTokenKeyResponse(dict):
    """
    Specifies a RSA key for token validation
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContentKeyPolicyRsaTokenKeyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContentKeyPolicyRsaTokenKeyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContentKeyPolicyRsaTokenKeyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 exponent: str,
                 modulus: str,
                 odata_type: str):
        """
        Specifies a RSA key for token validation
        :param str exponent: The RSA Parameter exponent
        :param str modulus: The RSA Parameter modulus
        :param str odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.ContentKeyPolicyRsaTokenKey'.
        """
        pulumi.set(__self__, "exponent", exponent)
        pulumi.set(__self__, "modulus", modulus)
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.ContentKeyPolicyRsaTokenKey')

    @property
    @pulumi.getter
    def exponent(self) -> str:
        """
        The RSA Parameter exponent
        """
        return pulumi.get(self, "exponent")

    @property
    @pulumi.getter
    def modulus(self) -> str:
        """
        The RSA Parameter modulus
        """
        return pulumi.get(self, "modulus")

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.ContentKeyPolicyRsaTokenKey'.
        """
        return pulumi.get(self, "odata_type")


@pulumi.output_type
class ContentKeyPolicySymmetricTokenKeyResponse(dict):
    """
    Specifies a symmetric key for token validation.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyValue":
            suggest = "key_value"
        elif key == "odataType":
            suggest = "odata_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContentKeyPolicySymmetricTokenKeyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContentKeyPolicySymmetricTokenKeyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContentKeyPolicySymmetricTokenKeyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_value: str,
                 odata_type: str):
        """
        Specifies a symmetric key for token validation.
        :param str key_value: The key value of the key
        :param str odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.ContentKeyPolicySymmetricTokenKey'.
        """
        pulumi.set(__self__, "key_value", key_value)
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.ContentKeyPolicySymmetricTokenKey')

    @property
    @pulumi.getter(name="keyValue")
    def key_value(self) -> str:
        """
        The key value of the key
        """
        return pulumi.get(self, "key_value")

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.ContentKeyPolicySymmetricTokenKey'.
        """
        return pulumi.get(self, "odata_type")


@pulumi.output_type
class ContentKeyPolicyTokenClaimResponse(dict):
    """
    Represents a token claim.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "claimType":
            suggest = "claim_type"
        elif key == "claimValue":
            suggest = "claim_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContentKeyPolicyTokenClaimResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContentKeyPolicyTokenClaimResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContentKeyPolicyTokenClaimResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 claim_type: Optional[str] = None,
                 claim_value: Optional[str] = None):
        """
        Represents a token claim.
        :param str claim_type: Token claim type.
        :param str claim_value: Token claim value.
        """
        if claim_type is not None:
            pulumi.set(__self__, "claim_type", claim_type)
        if claim_value is not None:
            pulumi.set(__self__, "claim_value", claim_value)

    @property
    @pulumi.getter(name="claimType")
    def claim_type(self) -> Optional[str]:
        """
        Token claim type.
        """
        return pulumi.get(self, "claim_type")

    @property
    @pulumi.getter(name="claimValue")
    def claim_value(self) -> Optional[str]:
        """
        Token claim value.
        """
        return pulumi.get(self, "claim_value")


@pulumi.output_type
class ContentKeyPolicyTokenRestrictionResponse(dict):
    """
    Represents a token restriction. Provided token must match these requirements for successful license or key delivery.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"
        elif key == "primaryVerificationKey":
            suggest = "primary_verification_key"
        elif key == "restrictionTokenType":
            suggest = "restriction_token_type"
        elif key == "alternateVerificationKeys":
            suggest = "alternate_verification_keys"
        elif key == "openIdConnectDiscoveryDocument":
            suggest = "open_id_connect_discovery_document"
        elif key == "requiredClaims":
            suggest = "required_claims"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContentKeyPolicyTokenRestrictionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContentKeyPolicyTokenRestrictionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContentKeyPolicyTokenRestrictionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 audience: str,
                 issuer: str,
                 odata_type: str,
                 primary_verification_key: Any,
                 restriction_token_type: str,
                 alternate_verification_keys: Optional[Sequence[Any]] = None,
                 open_id_connect_discovery_document: Optional[str] = None,
                 required_claims: Optional[Sequence['outputs.ContentKeyPolicyTokenClaimResponse']] = None):
        """
        Represents a token restriction. Provided token must match these requirements for successful license or key delivery.
        :param str audience: The audience for the token.
        :param str issuer: The token issuer.
        :param str odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.ContentKeyPolicyTokenRestriction'.
        :param Union['ContentKeyPolicyRsaTokenKeyResponse', 'ContentKeyPolicySymmetricTokenKeyResponse', 'ContentKeyPolicyX509CertificateTokenKeyResponse'] primary_verification_key: The primary verification key.
        :param str restriction_token_type: The type of token.
        :param Sequence[Union['ContentKeyPolicyRsaTokenKeyResponse', 'ContentKeyPolicySymmetricTokenKeyResponse', 'ContentKeyPolicyX509CertificateTokenKeyResponse']] alternate_verification_keys: A list of alternative verification keys.
        :param str open_id_connect_discovery_document: The OpenID connect discovery document.
        :param Sequence['ContentKeyPolicyTokenClaimResponse'] required_claims: A list of required token claims.
        """
        pulumi.set(__self__, "audience", audience)
        pulumi.set(__self__, "issuer", issuer)
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.ContentKeyPolicyTokenRestriction')
        pulumi.set(__self__, "primary_verification_key", primary_verification_key)
        pulumi.set(__self__, "restriction_token_type", restriction_token_type)
        if alternate_verification_keys is not None:
            pulumi.set(__self__, "alternate_verification_keys", alternate_verification_keys)
        if open_id_connect_discovery_document is not None:
            pulumi.set(__self__, "open_id_connect_discovery_document", open_id_connect_discovery_document)
        if required_claims is not None:
            pulumi.set(__self__, "required_claims", required_claims)

    @property
    @pulumi.getter
    def audience(self) -> str:
        """
        The audience for the token.
        """
        return pulumi.get(self, "audience")

    @property
    @pulumi.getter
    def issuer(self) -> str:
        """
        The token issuer.
        """
        return pulumi.get(self, "issuer")

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.ContentKeyPolicyTokenRestriction'.
        """
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter(name="primaryVerificationKey")
    def primary_verification_key(self) -> Any:
        """
        The primary verification key.
        """
        return pulumi.get(self, "primary_verification_key")

    @property
    @pulumi.getter(name="restrictionTokenType")
    def restriction_token_type(self) -> str:
        """
        The type of token.
        """
        return pulumi.get(self, "restriction_token_type")

    @property
    @pulumi.getter(name="alternateVerificationKeys")
    def alternate_verification_keys(self) -> Optional[Sequence[Any]]:
        """
        A list of alternative verification keys.
        """
        return pulumi.get(self, "alternate_verification_keys")

    @property
    @pulumi.getter(name="openIdConnectDiscoveryDocument")
    def open_id_connect_discovery_document(self) -> Optional[str]:
        """
        The OpenID connect discovery document.
        """
        return pulumi.get(self, "open_id_connect_discovery_document")

    @property
    @pulumi.getter(name="requiredClaims")
    def required_claims(self) -> Optional[Sequence['outputs.ContentKeyPolicyTokenClaimResponse']]:
        """
        A list of required token claims.
        """
        return pulumi.get(self, "required_claims")


@pulumi.output_type
class ContentKeyPolicyUnknownConfigurationResponse(dict):
    """
    Represents a ContentKeyPolicyConfiguration that is unavailable in the current API version.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContentKeyPolicyUnknownConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContentKeyPolicyUnknownConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContentKeyPolicyUnknownConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str):
        """
        Represents a ContentKeyPolicyConfiguration that is unavailable in the current API version.
        :param str odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.ContentKeyPolicyUnknownConfiguration'.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.ContentKeyPolicyUnknownConfiguration')

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.ContentKeyPolicyUnknownConfiguration'.
        """
        return pulumi.get(self, "odata_type")


@pulumi.output_type
class ContentKeyPolicyUnknownRestrictionResponse(dict):
    """
    Represents a ContentKeyPolicyRestriction that is unavailable in the current API version.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContentKeyPolicyUnknownRestrictionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContentKeyPolicyUnknownRestrictionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContentKeyPolicyUnknownRestrictionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str):
        """
        Represents a ContentKeyPolicyRestriction that is unavailable in the current API version.
        :param str odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.ContentKeyPolicyUnknownRestriction'.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.ContentKeyPolicyUnknownRestriction')

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.ContentKeyPolicyUnknownRestriction'.
        """
        return pulumi.get(self, "odata_type")


@pulumi.output_type
class ContentKeyPolicyWidevineConfigurationResponse(dict):
    """
    Specifies a configuration for Widevine licenses.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"
        elif key == "widevineTemplate":
            suggest = "widevine_template"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContentKeyPolicyWidevineConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContentKeyPolicyWidevineConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContentKeyPolicyWidevineConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str,
                 widevine_template: str):
        """
        Specifies a configuration for Widevine licenses.
        :param str odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.ContentKeyPolicyWidevineConfiguration'.
        :param str widevine_template: The Widevine template.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.ContentKeyPolicyWidevineConfiguration')
        pulumi.set(__self__, "widevine_template", widevine_template)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.ContentKeyPolicyWidevineConfiguration'.
        """
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter(name="widevineTemplate")
    def widevine_template(self) -> str:
        """
        The Widevine template.
        """
        return pulumi.get(self, "widevine_template")


@pulumi.output_type
class ContentKeyPolicyX509CertificateTokenKeyResponse(dict):
    """
    Specifies a certificate for token validation.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"
        elif key == "rawBody":
            suggest = "raw_body"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContentKeyPolicyX509CertificateTokenKeyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContentKeyPolicyX509CertificateTokenKeyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContentKeyPolicyX509CertificateTokenKeyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str,
                 raw_body: str):
        """
        Specifies a certificate for token validation.
        :param str odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.ContentKeyPolicyX509CertificateTokenKey'.
        :param str raw_body: The raw data field of a certificate in PKCS 12 format (X509Certificate2 in .NET)
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.ContentKeyPolicyX509CertificateTokenKey')
        pulumi.set(__self__, "raw_body", raw_body)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.ContentKeyPolicyX509CertificateTokenKey'.
        """
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter(name="rawBody")
    def raw_body(self) -> str:
        """
        The raw data field of a certificate in PKCS 12 format (X509Certificate2 in .NET)
        """
        return pulumi.get(self, "raw_body")


@pulumi.output_type
class CrossSiteAccessPoliciesResponse(dict):
    """
    The client access policy.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientAccessPolicy":
            suggest = "client_access_policy"
        elif key == "crossDomainPolicy":
            suggest = "cross_domain_policy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CrossSiteAccessPoliciesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CrossSiteAccessPoliciesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CrossSiteAccessPoliciesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_access_policy: Optional[str] = None,
                 cross_domain_policy: Optional[str] = None):
        """
        The client access policy.
        :param str client_access_policy: The content of clientaccesspolicy.xml used by Silverlight.
        :param str cross_domain_policy: The content of crossdomain.xml used by Silverlight.
        """
        if client_access_policy is not None:
            pulumi.set(__self__, "client_access_policy", client_access_policy)
        if cross_domain_policy is not None:
            pulumi.set(__self__, "cross_domain_policy", cross_domain_policy)

    @property
    @pulumi.getter(name="clientAccessPolicy")
    def client_access_policy(self) -> Optional[str]:
        """
        The content of clientaccesspolicy.xml used by Silverlight.
        """
        return pulumi.get(self, "client_access_policy")

    @property
    @pulumi.getter(name="crossDomainPolicy")
    def cross_domain_policy(self) -> Optional[str]:
        """
        The content of crossdomain.xml used by Silverlight.
        """
        return pulumi.get(self, "cross_domain_policy")


@pulumi.output_type
class DashSettingsResponse(dict):
    """
    The DASH setting for a track.
    """
    def __init__(__self__, *,
                 role: Optional[str] = None):
        """
        The DASH setting for a track.
        :param str role: The role for the DASH setting.
        """
        if role is not None:
            pulumi.set(__self__, "role", role)

    @property
    @pulumi.getter
    def role(self) -> Optional[str]:
        """
        The role for the DASH setting.
        """
        return pulumi.get(self, "role")


@pulumi.output_type
class DefaultKeyResponse(dict):
    """
    Class to specify properties of default content key for each encryption scheme
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "policyName":
            suggest = "policy_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DefaultKeyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DefaultKeyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DefaultKeyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 label: Optional[str] = None,
                 policy_name: Optional[str] = None):
        """
        Class to specify properties of default content key for each encryption scheme
        :param str label: Label can be used to specify Content Key when creating a Streaming Locator
        :param str policy_name: Policy used by Default Key
        """
        if label is not None:
            pulumi.set(__self__, "label", label)
        if policy_name is not None:
            pulumi.set(__self__, "policy_name", policy_name)

    @property
    @pulumi.getter
    def label(self) -> Optional[str]:
        """
        Label can be used to specify Content Key when creating a Streaming Locator
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter(name="policyName")
    def policy_name(self) -> Optional[str]:
        """
        Policy used by Default Key
        """
        return pulumi.get(self, "policy_name")


@pulumi.output_type
class EnabledProtocolsResponse(dict):
    """
    Class to specify which protocols are enabled
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "smoothStreaming":
            suggest = "smooth_streaming"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EnabledProtocolsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EnabledProtocolsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EnabledProtocolsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dash: bool,
                 download: bool,
                 hls: bool,
                 smooth_streaming: bool):
        """
        Class to specify which protocols are enabled
        :param bool dash: Enable DASH protocol or not
        :param bool download: Enable Download protocol or not
        :param bool hls: Enable HLS protocol or not
        :param bool smooth_streaming: Enable SmoothStreaming protocol or not
        """
        pulumi.set(__self__, "dash", dash)
        pulumi.set(__self__, "download", download)
        pulumi.set(__self__, "hls", hls)
        pulumi.set(__self__, "smooth_streaming", smooth_streaming)

    @property
    @pulumi.getter
    def dash(self) -> bool:
        """
        Enable DASH protocol or not
        """
        return pulumi.get(self, "dash")

    @property
    @pulumi.getter
    def download(self) -> bool:
        """
        Enable Download protocol or not
        """
        return pulumi.get(self, "download")

    @property
    @pulumi.getter
    def hls(self) -> bool:
        """
        Enable HLS protocol or not
        """
        return pulumi.get(self, "hls")

    @property
    @pulumi.getter(name="smoothStreaming")
    def smooth_streaming(self) -> bool:
        """
        Enable SmoothStreaming protocol or not
        """
        return pulumi.get(self, "smooth_streaming")


@pulumi.output_type
class EnvelopeEncryptionResponse(dict):
    """
    Class for EnvelopeEncryption encryption scheme
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clearTracks":
            suggest = "clear_tracks"
        elif key == "contentKeys":
            suggest = "content_keys"
        elif key == "customKeyAcquisitionUrlTemplate":
            suggest = "custom_key_acquisition_url_template"
        elif key == "enabledProtocols":
            suggest = "enabled_protocols"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EnvelopeEncryptionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EnvelopeEncryptionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EnvelopeEncryptionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 clear_tracks: Optional[Sequence['outputs.TrackSelectionResponse']] = None,
                 content_keys: Optional['outputs.StreamingPolicyContentKeysResponse'] = None,
                 custom_key_acquisition_url_template: Optional[str] = None,
                 enabled_protocols: Optional['outputs.EnabledProtocolsResponse'] = None):
        """
        Class for EnvelopeEncryption encryption scheme
        :param Sequence['TrackSelectionResponse'] clear_tracks: Representing which tracks should not be encrypted
        :param 'StreamingPolicyContentKeysResponse' content_keys: Representing default content key for each encryption scheme and separate content keys for specific tracks
        :param str custom_key_acquisition_url_template: Template for the URL of the custom service delivering keys to end user players.  Not required when using Azure Media Services for issuing keys.  The template supports replaceable tokens that the service will update at runtime with the value specific to the request.  The currently supported token values are {AlternativeMediaId}, which is replaced with the value of StreamingLocatorId.AlternativeMediaId, and {ContentKeyId}, which is replaced with the value of identifier of the key being requested.
        :param 'EnabledProtocolsResponse' enabled_protocols: Representing supported protocols
        """
        if clear_tracks is not None:
            pulumi.set(__self__, "clear_tracks", clear_tracks)
        if content_keys is not None:
            pulumi.set(__self__, "content_keys", content_keys)
        if custom_key_acquisition_url_template is not None:
            pulumi.set(__self__, "custom_key_acquisition_url_template", custom_key_acquisition_url_template)
        if enabled_protocols is not None:
            pulumi.set(__self__, "enabled_protocols", enabled_protocols)

    @property
    @pulumi.getter(name="clearTracks")
    def clear_tracks(self) -> Optional[Sequence['outputs.TrackSelectionResponse']]:
        """
        Representing which tracks should not be encrypted
        """
        return pulumi.get(self, "clear_tracks")

    @property
    @pulumi.getter(name="contentKeys")
    def content_keys(self) -> Optional['outputs.StreamingPolicyContentKeysResponse']:
        """
        Representing default content key for each encryption scheme and separate content keys for specific tracks
        """
        return pulumi.get(self, "content_keys")

    @property
    @pulumi.getter(name="customKeyAcquisitionUrlTemplate")
    def custom_key_acquisition_url_template(self) -> Optional[str]:
        """
        Template for the URL of the custom service delivering keys to end user players.  Not required when using Azure Media Services for issuing keys.  The template supports replaceable tokens that the service will update at runtime with the value specific to the request.  The currently supported token values are {AlternativeMediaId}, which is replaced with the value of StreamingLocatorId.AlternativeMediaId, and {ContentKeyId}, which is replaced with the value of identifier of the key being requested.
        """
        return pulumi.get(self, "custom_key_acquisition_url_template")

    @property
    @pulumi.getter(name="enabledProtocols")
    def enabled_protocols(self) -> Optional['outputs.EnabledProtocolsResponse']:
        """
        Representing supported protocols
        """
        return pulumi.get(self, "enabled_protocols")


@pulumi.output_type
class FilterTrackPropertyConditionResponse(dict):
    """
    The class to specify one track property condition.
    """
    def __init__(__self__, *,
                 operation: str,
                 property: str,
                 value: str):
        """
        The class to specify one track property condition.
        :param str operation: The track property condition operation.
        :param str property: The track property type.
        :param str value: The track property value.
        """
        pulumi.set(__self__, "operation", operation)
        pulumi.set(__self__, "property", property)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def operation(self) -> str:
        """
        The track property condition operation.
        """
        return pulumi.get(self, "operation")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The track property value.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter
    def property(self) -> str:
        """
        The track property type.
        """
        return pulumi.get(self, "property")


@pulumi.output_type
class FilterTrackSelectionResponse(dict):
    """
    Representing a list of FilterTrackPropertyConditions to select a track.  The filters are combined using a logical AND operation.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "trackSelections":
            suggest = "track_selections"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FilterTrackSelectionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FilterTrackSelectionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FilterTrackSelectionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 track_selections: Sequence['outputs.FilterTrackPropertyConditionResponse']):
        """
        Representing a list of FilterTrackPropertyConditions to select a track.  The filters are combined using a logical AND operation.
        :param Sequence['FilterTrackPropertyConditionResponse'] track_selections: The track selections.
        """
        pulumi.set(__self__, "track_selections", track_selections)

    @property
    @pulumi.getter(name="trackSelections")
    def track_selections(self) -> Sequence['outputs.FilterTrackPropertyConditionResponse']:
        """
        The track selections.
        """
        return pulumi.get(self, "track_selections")


@pulumi.output_type
class FirstQualityResponse(dict):
    """
    Filter First Quality
    """
    def __init__(__self__, *,
                 bitrate: int):
        """
        Filter First Quality
        :param int bitrate: The first quality bitrate.
        """
        pulumi.set(__self__, "bitrate", bitrate)

    @property
    @pulumi.getter
    def bitrate(self) -> int:
        """
        The first quality bitrate.
        """
        return pulumi.get(self, "bitrate")


@pulumi.output_type
class HlsResponse(dict):
    """
    HTTP Live Streaming (HLS) packing setting for the live output.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fragmentsPerTsSegment":
            suggest = "fragments_per_ts_segment"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HlsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HlsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HlsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fragments_per_ts_segment: Optional[int] = None):
        """
        HTTP Live Streaming (HLS) packing setting for the live output.
        :param int fragments_per_ts_segment: The number of fragments in an HTTP Live Streaming (HLS) TS segment in the output of the live event. This value does not affect the packing ratio for HLS CMAF output.
        """
        if fragments_per_ts_segment is not None:
            pulumi.set(__self__, "fragments_per_ts_segment", fragments_per_ts_segment)

    @property
    @pulumi.getter(name="fragmentsPerTsSegment")
    def fragments_per_ts_segment(self) -> Optional[int]:
        """
        The number of fragments in an HTTP Live Streaming (HLS) TS segment in the output of the live event. This value does not affect the packing ratio for HLS CMAF output.
        """
        return pulumi.get(self, "fragments_per_ts_segment")


@pulumi.output_type
class HlsSettingsResponse(dict):
    """
    The HLS setting for a track.
    """
    def __init__(__self__, *,
                 characteristics: Optional[str] = None,
                 default: Optional[bool] = None,
                 forced: Optional[bool] = None):
        """
        The HLS setting for a track.
        :param str characteristics: The characteristics for the HLS setting.
        :param bool default: The default for the HLS setting.
        :param bool forced: The forced for the HLS setting.
        """
        if characteristics is not None:
            pulumi.set(__self__, "characteristics", characteristics)
        if default is not None:
            pulumi.set(__self__, "default", default)
        if forced is not None:
            pulumi.set(__self__, "forced", forced)

    @property
    @pulumi.getter
    def characteristics(self) -> Optional[str]:
        """
        The characteristics for the HLS setting.
        """
        return pulumi.get(self, "characteristics")

    @property
    @pulumi.getter
    def default(self) -> Optional[bool]:
        """
        The default for the HLS setting.
        """
        return pulumi.get(self, "default")

    @property
    @pulumi.getter
    def forced(self) -> Optional[bool]:
        """
        The forced for the HLS setting.
        """
        return pulumi.get(self, "forced")


@pulumi.output_type
class IPAccessControlResponse(dict):
    """
    The IP access control.
    """
    def __init__(__self__, *,
                 allow: Optional[Sequence['outputs.IPRangeResponse']] = None):
        """
        The IP access control.
        :param Sequence['IPRangeResponse'] allow: The IP allow list.
        """
        if allow is not None:
            pulumi.set(__self__, "allow", allow)

    @property
    @pulumi.getter
    def allow(self) -> Optional[Sequence['outputs.IPRangeResponse']]:
        """
        The IP allow list.
        """
        return pulumi.get(self, "allow")


@pulumi.output_type
class IPRangeResponse(dict):
    """
    The IP address range in the CIDR scheme.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "subnetPrefixLength":
            suggest = "subnet_prefix_length"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IPRangeResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IPRangeResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IPRangeResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address: Optional[str] = None,
                 name: Optional[str] = None,
                 subnet_prefix_length: Optional[int] = None):
        """
        The IP address range in the CIDR scheme.
        :param str address: The IP address.
        :param str name: The friendly name for the IP address range.
        :param int subnet_prefix_length: The subnet mask prefix length (see CIDR notation).
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if subnet_prefix_length is not None:
            pulumi.set(__self__, "subnet_prefix_length", subnet_prefix_length)

    @property
    @pulumi.getter
    def address(self) -> Optional[str]:
        """
        The IP address.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The friendly name for the IP address range.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="subnetPrefixLength")
    def subnet_prefix_length(self) -> Optional[int]:
        """
        The subnet mask prefix length (see CIDR notation).
        """
        return pulumi.get(self, "subnet_prefix_length")


@pulumi.output_type
class LiveEventEncodingResponse(dict):
    """
    Specifies the live event type and optional encoding settings for encoding live events.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "encodingType":
            suggest = "encoding_type"
        elif key == "keyFrameInterval":
            suggest = "key_frame_interval"
        elif key == "presetName":
            suggest = "preset_name"
        elif key == "stretchMode":
            suggest = "stretch_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LiveEventEncodingResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LiveEventEncodingResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LiveEventEncodingResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 encoding_type: Optional[str] = None,
                 key_frame_interval: Optional[str] = None,
                 preset_name: Optional[str] = None,
                 stretch_mode: Optional[str] = None):
        """
        Specifies the live event type and optional encoding settings for encoding live events.
        :param str encoding_type: Live event type. When encodingType is set to PassthroughBasic or PassthroughStandard, the service simply passes through the incoming video and audio layer(s) to the output. When encodingType is set to Standard or Premium1080p, a live encoder transcodes the incoming stream into multiple bitrates or layers. See https://go.microsoft.com/fwlink/?linkid=2095101 for more information. This property cannot be modified after the live event is created.
        :param str key_frame_interval: Use an ISO 8601 time value between 0.5 to 20 seconds to specify the output fragment length for the video and audio tracks of an encoding live event. For example, use PT2S to indicate 2 seconds. For the video track it also defines the key frame interval, or the length of a GoP (group of pictures).   If this value is not set for an encoding live event, the fragment duration defaults to 2 seconds. The value cannot be set for pass-through live events.
        :param str preset_name: The optional encoding preset name, used when encodingType is not None. This value is specified at creation time and cannot be updated. If the encodingType is set to Standard, then the default preset name is ‘Default720p’. Else if the encodingType is set to Premium1080p, the default preset is ‘Default1080p’.
        :param str stretch_mode: Specifies how the input video will be resized to fit the desired output resolution(s). Default is None
        """
        if encoding_type is not None:
            pulumi.set(__self__, "encoding_type", encoding_type)
        if key_frame_interval is not None:
            pulumi.set(__self__, "key_frame_interval", key_frame_interval)
        if preset_name is not None:
            pulumi.set(__self__, "preset_name", preset_name)
        if stretch_mode is not None:
            pulumi.set(__self__, "stretch_mode", stretch_mode)

    @property
    @pulumi.getter(name="encodingType")
    def encoding_type(self) -> Optional[str]:
        """
        Live event type. When encodingType is set to PassthroughBasic or PassthroughStandard, the service simply passes through the incoming video and audio layer(s) to the output. When encodingType is set to Standard or Premium1080p, a live encoder transcodes the incoming stream into multiple bitrates or layers. See https://go.microsoft.com/fwlink/?linkid=2095101 for more information. This property cannot be modified after the live event is created.
        """
        return pulumi.get(self, "encoding_type")

    @property
    @pulumi.getter(name="keyFrameInterval")
    def key_frame_interval(self) -> Optional[str]:
        """
        Use an ISO 8601 time value between 0.5 to 20 seconds to specify the output fragment length for the video and audio tracks of an encoding live event. For example, use PT2S to indicate 2 seconds. For the video track it also defines the key frame interval, or the length of a GoP (group of pictures).   If this value is not set for an encoding live event, the fragment duration defaults to 2 seconds. The value cannot be set for pass-through live events.
        """
        return pulumi.get(self, "key_frame_interval")

    @property
    @pulumi.getter(name="presetName")
    def preset_name(self) -> Optional[str]:
        """
        The optional encoding preset name, used when encodingType is not None. This value is specified at creation time and cannot be updated. If the encodingType is set to Standard, then the default preset name is ‘Default720p’. Else if the encodingType is set to Premium1080p, the default preset is ‘Default1080p’.
        """
        return pulumi.get(self, "preset_name")

    @property
    @pulumi.getter(name="stretchMode")
    def stretch_mode(self) -> Optional[str]:
        """
        Specifies how the input video will be resized to fit the desired output resolution(s). Default is None
        """
        return pulumi.get(self, "stretch_mode")


@pulumi.output_type
class LiveEventEndpointResponse(dict):
    """
    The live event endpoint.
    """
    def __init__(__self__, *,
                 protocol: Optional[str] = None,
                 url: Optional[str] = None):
        """
        The live event endpoint.
        :param str protocol: The endpoint protocol.
        :param str url: The endpoint URL.
        """
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[str]:
        """
        The endpoint protocol.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter
    def url(self) -> Optional[str]:
        """
        The endpoint URL.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class LiveEventInputAccessControlResponse(dict):
    """
    The IP access control for live event input.
    """
    def __init__(__self__, *,
                 ip: Optional['outputs.IPAccessControlResponse'] = None):
        """
        The IP access control for live event input.
        :param 'IPAccessControlResponse' ip: The IP access control properties.
        """
        if ip is not None:
            pulumi.set(__self__, "ip", ip)

    @property
    @pulumi.getter
    def ip(self) -> Optional['outputs.IPAccessControlResponse']:
        """
        The IP access control properties.
        """
        return pulumi.get(self, "ip")


@pulumi.output_type
class LiveEventInputResponse(dict):
    """
    The live event input.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "streamingProtocol":
            suggest = "streaming_protocol"
        elif key == "accessControl":
            suggest = "access_control"
        elif key == "accessToken":
            suggest = "access_token"
        elif key == "keyFrameIntervalDuration":
            suggest = "key_frame_interval_duration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LiveEventInputResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LiveEventInputResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LiveEventInputResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 streaming_protocol: str,
                 access_control: Optional['outputs.LiveEventInputAccessControlResponse'] = None,
                 access_token: Optional[str] = None,
                 endpoints: Optional[Sequence['outputs.LiveEventEndpointResponse']] = None,
                 key_frame_interval_duration: Optional[str] = None):
        """
        The live event input.
        :param str streaming_protocol: The input protocol for the live event. This is specified at creation time and cannot be updated.
        :param 'LiveEventInputAccessControlResponse' access_control: Access control for live event input.
        :param str access_token: A UUID in string form to uniquely identify the stream. This can be specified at creation time but cannot be updated. If omitted, the service will generate a unique value.
        :param Sequence['LiveEventEndpointResponse'] endpoints: The input endpoints for the live event.
        :param str key_frame_interval_duration: ISO 8601 time duration of the key frame interval duration of the input. This value sets the EXT-X-TARGETDURATION property in the HLS output. For example, use PT2S to indicate 2 seconds. Leave the value empty for encoding live events.
        """
        pulumi.set(__self__, "streaming_protocol", streaming_protocol)
        if access_control is not None:
            pulumi.set(__self__, "access_control", access_control)
        if access_token is not None:
            pulumi.set(__self__, "access_token", access_token)
        if endpoints is not None:
            pulumi.set(__self__, "endpoints", endpoints)
        if key_frame_interval_duration is not None:
            pulumi.set(__self__, "key_frame_interval_duration", key_frame_interval_duration)

    @property
    @pulumi.getter(name="streamingProtocol")
    def streaming_protocol(self) -> str:
        """
        The input protocol for the live event. This is specified at creation time and cannot be updated.
        """
        return pulumi.get(self, "streaming_protocol")

    @property
    @pulumi.getter(name="accessControl")
    def access_control(self) -> Optional['outputs.LiveEventInputAccessControlResponse']:
        """
        Access control for live event input.
        """
        return pulumi.get(self, "access_control")

    @property
    @pulumi.getter(name="accessToken")
    def access_token(self) -> Optional[str]:
        """
        A UUID in string form to uniquely identify the stream. This can be specified at creation time but cannot be updated. If omitted, the service will generate a unique value.
        """
        return pulumi.get(self, "access_token")

    @property
    @pulumi.getter
    def endpoints(self) -> Optional[Sequence['outputs.LiveEventEndpointResponse']]:
        """
        The input endpoints for the live event.
        """
        return pulumi.get(self, "endpoints")

    @property
    @pulumi.getter(name="keyFrameIntervalDuration")
    def key_frame_interval_duration(self) -> Optional[str]:
        """
        ISO 8601 time duration of the key frame interval duration of the input. This value sets the EXT-X-TARGETDURATION property in the HLS output. For example, use PT2S to indicate 2 seconds. Leave the value empty for encoding live events.
        """
        return pulumi.get(self, "key_frame_interval_duration")


@pulumi.output_type
class LiveEventInputTrackSelectionResponse(dict):
    """
    A track selection condition. This property is reserved for future use, any value set on this property will be ignored.
    """
    def __init__(__self__, *,
                 operation: Optional[str] = None,
                 property: Optional[str] = None,
                 value: Optional[str] = None):
        """
        A track selection condition. This property is reserved for future use, any value set on this property will be ignored.
        :param str operation: Comparing operation. This property is reserved for future use, any value set on this property will be ignored.
        :param str property: Property name to select. This property is reserved for future use, any value set on this property will be ignored.
        :param str value: Property value to select. This property is reserved for future use, any value set on this property will be ignored.
        """
        if operation is not None:
            pulumi.set(__self__, "operation", operation)
        if property is not None:
            pulumi.set(__self__, "property", property)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def operation(self) -> Optional[str]:
        """
        Comparing operation. This property is reserved for future use, any value set on this property will be ignored.
        """
        return pulumi.get(self, "operation")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        Property value to select. This property is reserved for future use, any value set on this property will be ignored.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter
    def property(self) -> Optional[str]:
        """
        Property name to select. This property is reserved for future use, any value set on this property will be ignored.
        """
        return pulumi.get(self, "property")


@pulumi.output_type
class LiveEventOutputTranscriptionTrackResponse(dict):
    """
    Describes a transcription track in the output of a live event, generated using speech-to-text transcription. This property is reserved for future use, any value set on this property will be ignored.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "trackName":
            suggest = "track_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LiveEventOutputTranscriptionTrackResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LiveEventOutputTranscriptionTrackResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LiveEventOutputTranscriptionTrackResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 track_name: str):
        """
        Describes a transcription track in the output of a live event, generated using speech-to-text transcription. This property is reserved for future use, any value set on this property will be ignored.
        :param str track_name: The output track name. This property is reserved for future use, any value set on this property will be ignored.
        """
        pulumi.set(__self__, "track_name", track_name)

    @property
    @pulumi.getter(name="trackName")
    def track_name(self) -> str:
        """
        The output track name. This property is reserved for future use, any value set on this property will be ignored.
        """
        return pulumi.get(self, "track_name")


@pulumi.output_type
class LiveEventPreviewAccessControlResponse(dict):
    """
    The IP access control for the live event preview endpoint.
    """
    def __init__(__self__, *,
                 ip: Optional['outputs.IPAccessControlResponse'] = None):
        """
        The IP access control for the live event preview endpoint.
        :param 'IPAccessControlResponse' ip: The IP access control properties.
        """
        if ip is not None:
            pulumi.set(__self__, "ip", ip)

    @property
    @pulumi.getter
    def ip(self) -> Optional['outputs.IPAccessControlResponse']:
        """
        The IP access control properties.
        """
        return pulumi.get(self, "ip")


@pulumi.output_type
class LiveEventPreviewResponse(dict):
    """
    Live event preview settings.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessControl":
            suggest = "access_control"
        elif key == "alternativeMediaId":
            suggest = "alternative_media_id"
        elif key == "previewLocator":
            suggest = "preview_locator"
        elif key == "streamingPolicyName":
            suggest = "streaming_policy_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LiveEventPreviewResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LiveEventPreviewResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LiveEventPreviewResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_control: Optional['outputs.LiveEventPreviewAccessControlResponse'] = None,
                 alternative_media_id: Optional[str] = None,
                 endpoints: Optional[Sequence['outputs.LiveEventEndpointResponse']] = None,
                 preview_locator: Optional[str] = None,
                 streaming_policy_name: Optional[str] = None):
        """
        Live event preview settings.
        :param 'LiveEventPreviewAccessControlResponse' access_control: The access control for live event preview.
        :param str alternative_media_id: An alternative media identifier associated with the streaming locator created for the preview. This value is specified at creation time and cannot be updated. The identifier can be used in the CustomLicenseAcquisitionUrlTemplate or the CustomKeyAcquisitionUrlTemplate of the StreamingPolicy specified in the StreamingPolicyName field.
        :param Sequence['LiveEventEndpointResponse'] endpoints: The endpoints for preview. Do not share the preview URL with the live event audience.
        :param str preview_locator: The identifier of the preview locator in Guid format. Specifying this at creation time allows the caller to know the preview locator url before the event is created. If omitted, the service will generate a random identifier. This value cannot be updated once the live event is created.
        :param str streaming_policy_name: The name of streaming policy used for the live event preview. This value is specified at creation time and cannot be updated.
        """
        if access_control is not None:
            pulumi.set(__self__, "access_control", access_control)
        if alternative_media_id is not None:
            pulumi.set(__self__, "alternative_media_id", alternative_media_id)
        if endpoints is not None:
            pulumi.set(__self__, "endpoints", endpoints)
        if preview_locator is not None:
            pulumi.set(__self__, "preview_locator", preview_locator)
        if streaming_policy_name is not None:
            pulumi.set(__self__, "streaming_policy_name", streaming_policy_name)

    @property
    @pulumi.getter(name="accessControl")
    def access_control(self) -> Optional['outputs.LiveEventPreviewAccessControlResponse']:
        """
        The access control for live event preview.
        """
        return pulumi.get(self, "access_control")

    @property
    @pulumi.getter(name="alternativeMediaId")
    def alternative_media_id(self) -> Optional[str]:
        """
        An alternative media identifier associated with the streaming locator created for the preview. This value is specified at creation time and cannot be updated. The identifier can be used in the CustomLicenseAcquisitionUrlTemplate or the CustomKeyAcquisitionUrlTemplate of the StreamingPolicy specified in the StreamingPolicyName field.
        """
        return pulumi.get(self, "alternative_media_id")

    @property
    @pulumi.getter
    def endpoints(self) -> Optional[Sequence['outputs.LiveEventEndpointResponse']]:
        """
        The endpoints for preview. Do not share the preview URL with the live event audience.
        """
        return pulumi.get(self, "endpoints")

    @property
    @pulumi.getter(name="previewLocator")
    def preview_locator(self) -> Optional[str]:
        """
        The identifier of the preview locator in Guid format. Specifying this at creation time allows the caller to know the preview locator url before the event is created. If omitted, the service will generate a random identifier. This value cannot be updated once the live event is created.
        """
        return pulumi.get(self, "preview_locator")

    @property
    @pulumi.getter(name="streamingPolicyName")
    def streaming_policy_name(self) -> Optional[str]:
        """
        The name of streaming policy used for the live event preview. This value is specified at creation time and cannot be updated.
        """
        return pulumi.get(self, "streaming_policy_name")


@pulumi.output_type
class LiveEventTranscriptionResponse(dict):
    """
    Describes the transcription tracks in the output of a live event, generated using speech-to-text transcription. This property is reserved for future use, any value set on this property will be ignored.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "inputTrackSelection":
            suggest = "input_track_selection"
        elif key == "outputTranscriptionTrack":
            suggest = "output_transcription_track"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LiveEventTranscriptionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LiveEventTranscriptionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LiveEventTranscriptionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 input_track_selection: Optional[Sequence['outputs.LiveEventInputTrackSelectionResponse']] = None,
                 language: Optional[str] = None,
                 output_transcription_track: Optional['outputs.LiveEventOutputTranscriptionTrackResponse'] = None):
        """
        Describes the transcription tracks in the output of a live event, generated using speech-to-text transcription. This property is reserved for future use, any value set on this property will be ignored.
        :param Sequence['LiveEventInputTrackSelectionResponse'] input_track_selection: Provides a mechanism to select the audio track in the input live feed, to which speech-to-text transcription is applied. This property is reserved for future use, any value set on this property will be ignored.
        :param str language: Specifies the language (locale) to be used for speech-to-text transcription – it should match the spoken language in the audio track. The value should be in BCP-47 format (e.g: 'en-US'). See https://go.microsoft.com/fwlink/?linkid=2133742 for more information about the live transcription feature and the list of supported languages.
        :param 'LiveEventOutputTranscriptionTrackResponse' output_transcription_track: Describes a transcription track in the output of a live event, generated using speech-to-text transcription. This property is reserved for future use, any value set on this property will be ignored.
        """
        if input_track_selection is not None:
            pulumi.set(__self__, "input_track_selection", input_track_selection)
        if language is not None:
            pulumi.set(__self__, "language", language)
        if output_transcription_track is not None:
            pulumi.set(__self__, "output_transcription_track", output_transcription_track)

    @property
    @pulumi.getter(name="inputTrackSelection")
    def input_track_selection(self) -> Optional[Sequence['outputs.LiveEventInputTrackSelectionResponse']]:
        """
        Provides a mechanism to select the audio track in the input live feed, to which speech-to-text transcription is applied. This property is reserved for future use, any value set on this property will be ignored.
        """
        return pulumi.get(self, "input_track_selection")

    @property
    @pulumi.getter
    def language(self) -> Optional[str]:
        """
        Specifies the language (locale) to be used for speech-to-text transcription – it should match the spoken language in the audio track. The value should be in BCP-47 format (e.g: 'en-US'). See https://go.microsoft.com/fwlink/?linkid=2133742 for more information about the live transcription feature and the list of supported languages.
        """
        return pulumi.get(self, "language")

    @property
    @pulumi.getter(name="outputTranscriptionTrack")
    def output_transcription_track(self) -> Optional['outputs.LiveEventOutputTranscriptionTrackResponse']:
        """
        Describes a transcription track in the output of a live event, generated using speech-to-text transcription. This property is reserved for future use, any value set on this property will be ignored.
        """
        return pulumi.get(self, "output_transcription_track")


@pulumi.output_type
class NoEncryptionResponse(dict):
    """
    Class for NoEncryption scheme
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enabledProtocols":
            suggest = "enabled_protocols"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NoEncryptionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NoEncryptionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NoEncryptionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled_protocols: Optional['outputs.EnabledProtocolsResponse'] = None):
        """
        Class for NoEncryption scheme
        :param 'EnabledProtocolsResponse' enabled_protocols: Representing supported protocols
        """
        if enabled_protocols is not None:
            pulumi.set(__self__, "enabled_protocols", enabled_protocols)

    @property
    @pulumi.getter(name="enabledProtocols")
    def enabled_protocols(self) -> Optional['outputs.EnabledProtocolsResponse']:
        """
        Representing supported protocols
        """
        return pulumi.get(self, "enabled_protocols")


@pulumi.output_type
class PresentationTimeRangeResponse(dict):
    """
    The presentation time range, this is asset related and not recommended for Account Filter.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endTimestamp":
            suggest = "end_timestamp"
        elif key == "forceEndTimestamp":
            suggest = "force_end_timestamp"
        elif key == "liveBackoffDuration":
            suggest = "live_backoff_duration"
        elif key == "presentationWindowDuration":
            suggest = "presentation_window_duration"
        elif key == "startTimestamp":
            suggest = "start_timestamp"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PresentationTimeRangeResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PresentationTimeRangeResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PresentationTimeRangeResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 end_timestamp: Optional[float] = None,
                 force_end_timestamp: Optional[bool] = None,
                 live_backoff_duration: Optional[float] = None,
                 presentation_window_duration: Optional[float] = None,
                 start_timestamp: Optional[float] = None,
                 timescale: Optional[float] = None):
        """
        The presentation time range, this is asset related and not recommended for Account Filter.
        :param float end_timestamp: The absolute end time boundary.
        :param bool force_end_timestamp: The indicator of forcing existing of end time stamp.
        :param float live_backoff_duration: The relative to end right edge.
        :param float presentation_window_duration: The relative to end sliding window.
        :param float start_timestamp: The absolute start time boundary.
        :param float timescale: The time scale of time stamps.
        """
        if end_timestamp is not None:
            pulumi.set(__self__, "end_timestamp", end_timestamp)
        if force_end_timestamp is not None:
            pulumi.set(__self__, "force_end_timestamp", force_end_timestamp)
        if live_backoff_duration is not None:
            pulumi.set(__self__, "live_backoff_duration", live_backoff_duration)
        if presentation_window_duration is not None:
            pulumi.set(__self__, "presentation_window_duration", presentation_window_duration)
        if start_timestamp is not None:
            pulumi.set(__self__, "start_timestamp", start_timestamp)
        if timescale is not None:
            pulumi.set(__self__, "timescale", timescale)

    @property
    @pulumi.getter(name="endTimestamp")
    def end_timestamp(self) -> Optional[float]:
        """
        The absolute end time boundary.
        """
        return pulumi.get(self, "end_timestamp")

    @property
    @pulumi.getter(name="forceEndTimestamp")
    def force_end_timestamp(self) -> Optional[bool]:
        """
        The indicator of forcing existing of end time stamp.
        """
        return pulumi.get(self, "force_end_timestamp")

    @property
    @pulumi.getter(name="liveBackoffDuration")
    def live_backoff_duration(self) -> Optional[float]:
        """
        The relative to end right edge.
        """
        return pulumi.get(self, "live_backoff_duration")

    @property
    @pulumi.getter(name="presentationWindowDuration")
    def presentation_window_duration(self) -> Optional[float]:
        """
        The relative to end sliding window.
        """
        return pulumi.get(self, "presentation_window_duration")

    @property
    @pulumi.getter(name="startTimestamp")
    def start_timestamp(self) -> Optional[float]:
        """
        The absolute start time boundary.
        """
        return pulumi.get(self, "start_timestamp")

    @property
    @pulumi.getter
    def timescale(self) -> Optional[float]:
        """
        The time scale of time stamps.
        """
        return pulumi.get(self, "timescale")


@pulumi.output_type
class StreamingEndpointAccessControlResponse(dict):
    """
    Streaming endpoint access control definition.
    """
    def __init__(__self__, *,
                 akamai: Optional['outputs.AkamaiAccessControlResponse'] = None,
                 ip: Optional['outputs.IPAccessControlResponse'] = None):
        """
        Streaming endpoint access control definition.
        :param 'AkamaiAccessControlResponse' akamai: The access control of Akamai
        :param 'IPAccessControlResponse' ip: The IP access control of the streaming endpoint.
        """
        if akamai is not None:
            pulumi.set(__self__, "akamai", akamai)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)

    @property
    @pulumi.getter
    def akamai(self) -> Optional['outputs.AkamaiAccessControlResponse']:
        """
        The access control of Akamai
        """
        return pulumi.get(self, "akamai")

    @property
    @pulumi.getter
    def ip(self) -> Optional['outputs.IPAccessControlResponse']:
        """
        The IP access control of the streaming endpoint.
        """
        return pulumi.get(self, "ip")


@pulumi.output_type
class StreamingLocatorContentKeyResponse(dict):
    """
    Class for content key in Streaming Locator
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "policyName":
            suggest = "policy_name"
        elif key == "labelReferenceInStreamingPolicy":
            suggest = "label_reference_in_streaming_policy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StreamingLocatorContentKeyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StreamingLocatorContentKeyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StreamingLocatorContentKeyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: str,
                 policy_name: str,
                 tracks: Sequence['outputs.TrackSelectionResponse'],
                 type: str,
                 label_reference_in_streaming_policy: Optional[str] = None,
                 value: Optional[str] = None):
        """
        Class for content key in Streaming Locator
        :param str id: ID of Content Key
        :param str policy_name: ContentKeyPolicy used by Content Key
        :param Sequence['TrackSelectionResponse'] tracks: Tracks which use this Content Key
        :param str type: Encryption type of Content Key
        :param str label_reference_in_streaming_policy: Label of Content Key as specified in the Streaming Policy
        :param str value: Value of Content Key
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "policy_name", policy_name)
        pulumi.set(__self__, "tracks", tracks)
        pulumi.set(__self__, "type", type)
        if label_reference_in_streaming_policy is not None:
            pulumi.set(__self__, "label_reference_in_streaming_policy", label_reference_in_streaming_policy)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        ID of Content Key
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="policyName")
    def policy_name(self) -> str:
        """
        ContentKeyPolicy used by Content Key
        """
        return pulumi.get(self, "policy_name")

    @property
    @pulumi.getter
    def tracks(self) -> Sequence['outputs.TrackSelectionResponse']:
        """
        Tracks which use this Content Key
        """
        return pulumi.get(self, "tracks")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Encryption type of Content Key
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="labelReferenceInStreamingPolicy")
    def label_reference_in_streaming_policy(self) -> Optional[str]:
        """
        Label of Content Key as specified in the Streaming Policy
        """
        return pulumi.get(self, "label_reference_in_streaming_policy")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        Value of Content Key
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class StreamingPathResponse(dict):
    """
    Class of paths for streaming
    """
    def __init__(__self__, *,
                 encryption_scheme: str,
                 streaming_protocol: str,
                 paths: Optional[Sequence[str]] = None):
        """
        Class of paths for streaming
        :param str encryption_scheme: Encryption scheme
        :param str streaming_protocol: Streaming protocol
        :param Sequence[str] paths: Streaming paths for each protocol and encryptionScheme pair
        """
        pulumi.set(__self__, "encryption_scheme", encryption_scheme)
        pulumi.set(__self__, "streaming_protocol", streaming_protocol)
        if paths is not None:
            pulumi.set(__self__, "paths", paths)

    @property
    @pulumi.getter(name="encryptionScheme")
    def encryption_scheme(self) -> str:
        """
        Encryption scheme
        """
        return pulumi.get(self, "encryption_scheme")

    @property
    @pulumi.getter(name="streamingProtocol")
    def streaming_protocol(self) -> str:
        """
        Streaming protocol
        """
        return pulumi.get(self, "streaming_protocol")

    @property
    @pulumi.getter
    def paths(self) -> Optional[Sequence[str]]:
        """
        Streaming paths for each protocol and encryptionScheme pair
        """
        return pulumi.get(self, "paths")


@pulumi.output_type
class StreamingPolicyContentKeyResponse(dict):
    """
    Class to specify properties of content key
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "policyName":
            suggest = "policy_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StreamingPolicyContentKeyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StreamingPolicyContentKeyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StreamingPolicyContentKeyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 label: Optional[str] = None,
                 policy_name: Optional[str] = None,
                 tracks: Optional[Sequence['outputs.TrackSelectionResponse']] = None):
        """
        Class to specify properties of content key
        :param str label: Label can be used to specify Content Key when creating a Streaming Locator
        :param str policy_name: Policy used by Content Key
        :param Sequence['TrackSelectionResponse'] tracks: Tracks which use this content key
        """
        if label is not None:
            pulumi.set(__self__, "label", label)
        if policy_name is not None:
            pulumi.set(__self__, "policy_name", policy_name)
        if tracks is not None:
            pulumi.set(__self__, "tracks", tracks)

    @property
    @pulumi.getter
    def label(self) -> Optional[str]:
        """
        Label can be used to specify Content Key when creating a Streaming Locator
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter(name="policyName")
    def policy_name(self) -> Optional[str]:
        """
        Policy used by Content Key
        """
        return pulumi.get(self, "policy_name")

    @property
    @pulumi.getter
    def tracks(self) -> Optional[Sequence['outputs.TrackSelectionResponse']]:
        """
        Tracks which use this content key
        """
        return pulumi.get(self, "tracks")


@pulumi.output_type
class StreamingPolicyContentKeysResponse(dict):
    """
    Class to specify properties of all content keys in Streaming Policy
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultKey":
            suggest = "default_key"
        elif key == "keyToTrackMappings":
            suggest = "key_to_track_mappings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StreamingPolicyContentKeysResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StreamingPolicyContentKeysResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StreamingPolicyContentKeysResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_key: Optional['outputs.DefaultKeyResponse'] = None,
                 key_to_track_mappings: Optional[Sequence['outputs.StreamingPolicyContentKeyResponse']] = None):
        """
        Class to specify properties of all content keys in Streaming Policy
        :param 'DefaultKeyResponse' default_key: Default content key for an encryption scheme
        :param Sequence['StreamingPolicyContentKeyResponse'] key_to_track_mappings: Representing tracks needs separate content key
        """
        if default_key is not None:
            pulumi.set(__self__, "default_key", default_key)
        if key_to_track_mappings is not None:
            pulumi.set(__self__, "key_to_track_mappings", key_to_track_mappings)

    @property
    @pulumi.getter(name="defaultKey")
    def default_key(self) -> Optional['outputs.DefaultKeyResponse']:
        """
        Default content key for an encryption scheme
        """
        return pulumi.get(self, "default_key")

    @property
    @pulumi.getter(name="keyToTrackMappings")
    def key_to_track_mappings(self) -> Optional[Sequence['outputs.StreamingPolicyContentKeyResponse']]:
        """
        Representing tracks needs separate content key
        """
        return pulumi.get(self, "key_to_track_mappings")


@pulumi.output_type
class StreamingPolicyFairPlayConfigurationResponse(dict):
    """
    Class to specify configurations of FairPlay in Streaming Policy
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowPersistentLicense":
            suggest = "allow_persistent_license"
        elif key == "customLicenseAcquisitionUrlTemplate":
            suggest = "custom_license_acquisition_url_template"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StreamingPolicyFairPlayConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StreamingPolicyFairPlayConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StreamingPolicyFairPlayConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allow_persistent_license: bool,
                 custom_license_acquisition_url_template: Optional[str] = None):
        """
        Class to specify configurations of FairPlay in Streaming Policy
        :param bool allow_persistent_license: All license to be persistent or not
        :param str custom_license_acquisition_url_template: Template for the URL of the custom service delivering licenses to end user players.  Not required when using Azure Media Services for issuing licenses.  The template supports replaceable tokens that the service will update at runtime with the value specific to the request.  The currently supported token values are {AlternativeMediaId}, which is replaced with the value of StreamingLocatorId.AlternativeMediaId, and {ContentKeyId}, which is replaced with the value of identifier of the key being requested.
        """
        pulumi.set(__self__, "allow_persistent_license", allow_persistent_license)
        if custom_license_acquisition_url_template is not None:
            pulumi.set(__self__, "custom_license_acquisition_url_template", custom_license_acquisition_url_template)

    @property
    @pulumi.getter(name="allowPersistentLicense")
    def allow_persistent_license(self) -> bool:
        """
        All license to be persistent or not
        """
        return pulumi.get(self, "allow_persistent_license")

    @property
    @pulumi.getter(name="customLicenseAcquisitionUrlTemplate")
    def custom_license_acquisition_url_template(self) -> Optional[str]:
        """
        Template for the URL of the custom service delivering licenses to end user players.  Not required when using Azure Media Services for issuing licenses.  The template supports replaceable tokens that the service will update at runtime with the value specific to the request.  The currently supported token values are {AlternativeMediaId}, which is replaced with the value of StreamingLocatorId.AlternativeMediaId, and {ContentKeyId}, which is replaced with the value of identifier of the key being requested.
        """
        return pulumi.get(self, "custom_license_acquisition_url_template")


@pulumi.output_type
class StreamingPolicyPlayReadyConfigurationResponse(dict):
    """
    Class to specify configurations of PlayReady in Streaming Policy
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customLicenseAcquisitionUrlTemplate":
            suggest = "custom_license_acquisition_url_template"
        elif key == "playReadyCustomAttributes":
            suggest = "play_ready_custom_attributes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StreamingPolicyPlayReadyConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StreamingPolicyPlayReadyConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StreamingPolicyPlayReadyConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 custom_license_acquisition_url_template: Optional[str] = None,
                 play_ready_custom_attributes: Optional[str] = None):
        """
        Class to specify configurations of PlayReady in Streaming Policy
        :param str custom_license_acquisition_url_template: Template for the URL of the custom service delivering licenses to end user players.  Not required when using Azure Media Services for issuing licenses.  The template supports replaceable tokens that the service will update at runtime with the value specific to the request.  The currently supported token values are {AlternativeMediaId}, which is replaced with the value of StreamingLocatorId.AlternativeMediaId, and {ContentKeyId}, which is replaced with the value of identifier of the key being requested.
        :param str play_ready_custom_attributes: Custom attributes for PlayReady
        """
        if custom_license_acquisition_url_template is not None:
            pulumi.set(__self__, "custom_license_acquisition_url_template", custom_license_acquisition_url_template)
        if play_ready_custom_attributes is not None:
            pulumi.set(__self__, "play_ready_custom_attributes", play_ready_custom_attributes)

    @property
    @pulumi.getter(name="customLicenseAcquisitionUrlTemplate")
    def custom_license_acquisition_url_template(self) -> Optional[str]:
        """
        Template for the URL of the custom service delivering licenses to end user players.  Not required when using Azure Media Services for issuing licenses.  The template supports replaceable tokens that the service will update at runtime with the value specific to the request.  The currently supported token values are {AlternativeMediaId}, which is replaced with the value of StreamingLocatorId.AlternativeMediaId, and {ContentKeyId}, which is replaced with the value of identifier of the key being requested.
        """
        return pulumi.get(self, "custom_license_acquisition_url_template")

    @property
    @pulumi.getter(name="playReadyCustomAttributes")
    def play_ready_custom_attributes(self) -> Optional[str]:
        """
        Custom attributes for PlayReady
        """
        return pulumi.get(self, "play_ready_custom_attributes")


@pulumi.output_type
class StreamingPolicyWidevineConfigurationResponse(dict):
    """
    Class to specify configurations of Widevine in Streaming Policy
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customLicenseAcquisitionUrlTemplate":
            suggest = "custom_license_acquisition_url_template"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StreamingPolicyWidevineConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StreamingPolicyWidevineConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StreamingPolicyWidevineConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 custom_license_acquisition_url_template: Optional[str] = None):
        """
        Class to specify configurations of Widevine in Streaming Policy
        :param str custom_license_acquisition_url_template: Template for the URL of the custom service delivering licenses to end user players.  Not required when using Azure Media Services for issuing licenses.  The template supports replaceable tokens that the service will update at runtime with the value specific to the request.  The currently supported token values are {AlternativeMediaId}, which is replaced with the value of StreamingLocatorId.AlternativeMediaId, and {ContentKeyId}, which is replaced with the value of identifier of the key being requested.
        """
        if custom_license_acquisition_url_template is not None:
            pulumi.set(__self__, "custom_license_acquisition_url_template", custom_license_acquisition_url_template)

    @property
    @pulumi.getter(name="customLicenseAcquisitionUrlTemplate")
    def custom_license_acquisition_url_template(self) -> Optional[str]:
        """
        Template for the URL of the custom service delivering licenses to end user players.  Not required when using Azure Media Services for issuing licenses.  The template supports replaceable tokens that the service will update at runtime with the value specific to the request.  The currently supported token values are {AlternativeMediaId}, which is replaced with the value of StreamingLocatorId.AlternativeMediaId, and {ContentKeyId}, which is replaced with the value of identifier of the key being requested.
        """
        return pulumi.get(self, "custom_license_acquisition_url_template")


@pulumi.output_type
class SystemDataResponse(dict):
    """
    Metadata pertaining to creation and last modification of the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdAt":
            suggest = "created_at"
        elif key == "createdBy":
            suggest = "created_by"
        elif key == "createdByType":
            suggest = "created_by_type"
        elif key == "lastModifiedAt":
            suggest = "last_modified_at"
        elif key == "lastModifiedBy":
            suggest = "last_modified_by"
        elif key == "lastModifiedByType":
            suggest = "last_modified_by_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SystemDataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_at: Optional[str] = None,
                 created_by: Optional[str] = None,
                 created_by_type: Optional[str] = None,
                 last_modified_at: Optional[str] = None,
                 last_modified_by: Optional[str] = None,
                 last_modified_by_type: Optional[str] = None):
        """
        Metadata pertaining to creation and last modification of the resource.
        :param str created_at: The timestamp of resource creation (UTC).
        :param str created_by: The identity that created the resource.
        :param str created_by_type: The type of identity that created the resource.
        :param str last_modified_at: The timestamp of resource last modification (UTC)
        :param str last_modified_by: The identity that last modified the resource.
        :param str last_modified_by_type: The type of identity that last modified the resource.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if created_by_type is not None:
            pulumi.set(__self__, "created_by_type", created_by_type)
        if last_modified_at is not None:
            pulumi.set(__self__, "last_modified_at", last_modified_at)
        if last_modified_by is not None:
            pulumi.set(__self__, "last_modified_by", last_modified_by)
        if last_modified_by_type is not None:
            pulumi.set(__self__, "last_modified_by_type", last_modified_by_type)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[str]:
        """
        The timestamp of resource creation (UTC).
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[str]:
        """
        The identity that created the resource.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="createdByType")
    def created_by_type(self) -> Optional[str]:
        """
        The type of identity that created the resource.
        """
        return pulumi.get(self, "created_by_type")

    @property
    @pulumi.getter(name="lastModifiedAt")
    def last_modified_at(self) -> Optional[str]:
        """
        The timestamp of resource last modification (UTC)
        """
        return pulumi.get(self, "last_modified_at")

    @property
    @pulumi.getter(name="lastModifiedBy")
    def last_modified_by(self) -> Optional[str]:
        """
        The identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by")

    @property
    @pulumi.getter(name="lastModifiedByType")
    def last_modified_by_type(self) -> Optional[str]:
        """
        The type of identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by_type")


@pulumi.output_type
class TextTrackResponse(dict):
    """
    Represents a text track in an asset. A text track is usually used for sparse data related to the audio or video tracks.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "languageCode":
            suggest = "language_code"
        elif key == "odataType":
            suggest = "odata_type"
        elif key == "displayName":
            suggest = "display_name"
        elif key == "fileName":
            suggest = "file_name"
        elif key == "hlsSettings":
            suggest = "hls_settings"
        elif key == "playerVisibility":
            suggest = "player_visibility"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TextTrackResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TextTrackResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TextTrackResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 language_code: str,
                 odata_type: str,
                 display_name: Optional[str] = None,
                 file_name: Optional[str] = None,
                 hls_settings: Optional['outputs.HlsSettingsResponse'] = None,
                 player_visibility: Optional[str] = None):
        """
        Represents a text track in an asset. A text track is usually used for sparse data related to the audio or video tracks.
        :param str language_code: The RFC5646 language code for the text track.
        :param str odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.TextTrack'.
        :param str display_name: The display name of the text track on a video player. In HLS, this maps to the NAME attribute of EXT-X-MEDIA.
        :param str file_name: The file name to the source file. This file is located in the storage container of the asset.
        :param 'HlsSettingsResponse' hls_settings: The HLS specific setting for the text track.
        :param str player_visibility: When PlayerVisibility is set to "Visible", the text track will be present in the DASH manifest or HLS playlist when requested by a client. When the PlayerVisibility is set to "Hidden", the text will not be available to the client. The default value is "Visible".
        """
        pulumi.set(__self__, "language_code", language_code)
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.TextTrack')
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if file_name is not None:
            pulumi.set(__self__, "file_name", file_name)
        if hls_settings is not None:
            pulumi.set(__self__, "hls_settings", hls_settings)
        if player_visibility is not None:
            pulumi.set(__self__, "player_visibility", player_visibility)

    @property
    @pulumi.getter(name="languageCode")
    def language_code(self) -> str:
        """
        The RFC5646 language code for the text track.
        """
        return pulumi.get(self, "language_code")

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.TextTrack'.
        """
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        The display name of the text track on a video player. In HLS, this maps to the NAME attribute of EXT-X-MEDIA.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="fileName")
    def file_name(self) -> Optional[str]:
        """
        The file name to the source file. This file is located in the storage container of the asset.
        """
        return pulumi.get(self, "file_name")

    @property
    @pulumi.getter(name="hlsSettings")
    def hls_settings(self) -> Optional['outputs.HlsSettingsResponse']:
        """
        The HLS specific setting for the text track.
        """
        return pulumi.get(self, "hls_settings")

    @property
    @pulumi.getter(name="playerVisibility")
    def player_visibility(self) -> Optional[str]:
        """
        When PlayerVisibility is set to "Visible", the text track will be present in the DASH manifest or HLS playlist when requested by a client. When the PlayerVisibility is set to "Hidden", the text will not be available to the client. The default value is "Visible".
        """
        return pulumi.get(self, "player_visibility")


@pulumi.output_type
class TrackPropertyConditionResponse(dict):
    """
    Class to specify one track property condition
    """
    def __init__(__self__, *,
                 operation: str,
                 property: str,
                 value: Optional[str] = None):
        """
        Class to specify one track property condition
        :param str operation: Track property condition operation
        :param str property: Track property type
        :param str value: Track property value
        """
        pulumi.set(__self__, "operation", operation)
        pulumi.set(__self__, "property", property)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def operation(self) -> str:
        """
        Track property condition operation
        """
        return pulumi.get(self, "operation")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        Track property value
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter
    def property(self) -> str:
        """
        Track property type
        """
        return pulumi.get(self, "property")


@pulumi.output_type
class TrackSelectionResponse(dict):
    """
    Class to select a track
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "trackSelections":
            suggest = "track_selections"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TrackSelectionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TrackSelectionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TrackSelectionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 track_selections: Optional[Sequence['outputs.TrackPropertyConditionResponse']] = None):
        """
        Class to select a track
        :param Sequence['TrackPropertyConditionResponse'] track_selections: TrackSelections is a track property condition list which can specify track(s)
        """
        if track_selections is not None:
            pulumi.set(__self__, "track_selections", track_selections)

    @property
    @pulumi.getter(name="trackSelections")
    def track_selections(self) -> Optional[Sequence['outputs.TrackPropertyConditionResponse']]:
        """
        TrackSelections is a track property condition list which can specify track(s)
        """
        return pulumi.get(self, "track_selections")


@pulumi.output_type
class VideoTrackResponse(dict):
    """
    Represents a video track in the asset.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VideoTrackResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VideoTrackResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VideoTrackResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str):
        """
        Represents a video track in the asset.
        :param str odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.VideoTrack'.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.VideoTrack')

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.VideoTrack'.
        """
        return pulumi.get(self, "odata_type")


