# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities

__all__ = ['WatcherArgs', 'Watcher']

@pulumi.input_type
class WatcherArgs:
    def __init__(__self__, *,
                 automation_account_name: pulumi.Input[str],
                 resource_group_name: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 execution_frequency_in_seconds: Optional[pulumi.Input[float]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 script_name: Optional[pulumi.Input[str]] = None,
                 script_parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 script_run_on: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 watcher_name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Watcher resource.
        :param pulumi.Input[str] automation_account_name: The name of the automation account.
        :param pulumi.Input[str] resource_group_name: Name of an Azure Resource group.
        :param pulumi.Input[str] description: Gets or sets the description.
        :param pulumi.Input[float] execution_frequency_in_seconds: Gets or sets the frequency at which the watcher is invoked.
        :param pulumi.Input[str] location: The Azure Region where the resource lives
        :param pulumi.Input[str] script_name: Gets or sets the name of the script the watcher is attached to, i.e. the name of an existing runbook.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] script_parameters: Gets or sets the parameters of the script.
        :param pulumi.Input[str] script_run_on: Gets or sets the name of the hybrid worker group the watcher will run on.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Resource tags.
        :param pulumi.Input[str] watcher_name: The watcher name.
        """
        pulumi.set(__self__, "automation_account_name", automation_account_name)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if execution_frequency_in_seconds is not None:
            pulumi.set(__self__, "execution_frequency_in_seconds", execution_frequency_in_seconds)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if script_name is not None:
            pulumi.set(__self__, "script_name", script_name)
        if script_parameters is not None:
            pulumi.set(__self__, "script_parameters", script_parameters)
        if script_run_on is not None:
            pulumi.set(__self__, "script_run_on", script_run_on)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if watcher_name is not None:
            pulumi.set(__self__, "watcher_name", watcher_name)

    @property
    @pulumi.getter(name="automationAccountName")
    def automation_account_name(self) -> pulumi.Input[str]:
        """
        The name of the automation account.
        """
        return pulumi.get(self, "automation_account_name")

    @automation_account_name.setter
    def automation_account_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "automation_account_name", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[str]:
        """
        Name of an Azure Resource group.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="executionFrequencyInSeconds")
    def execution_frequency_in_seconds(self) -> Optional[pulumi.Input[float]]:
        """
        Gets or sets the frequency at which the watcher is invoked.
        """
        return pulumi.get(self, "execution_frequency_in_seconds")

    @execution_frequency_in_seconds.setter
    def execution_frequency_in_seconds(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "execution_frequency_in_seconds", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        The Azure Region where the resource lives
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="scriptName")
    def script_name(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the name of the script the watcher is attached to, i.e. the name of an existing runbook.
        """
        return pulumi.get(self, "script_name")

    @script_name.setter
    def script_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "script_name", value)

    @property
    @pulumi.getter(name="scriptParameters")
    def script_parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Gets or sets the parameters of the script.
        """
        return pulumi.get(self, "script_parameters")

    @script_parameters.setter
    def script_parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "script_parameters", value)

    @property
    @pulumi.getter(name="scriptRunOn")
    def script_run_on(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the name of the hybrid worker group the watcher will run on.
        """
        return pulumi.get(self, "script_run_on")

    @script_run_on.setter
    def script_run_on(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "script_run_on", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Resource tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="watcherName")
    def watcher_name(self) -> Optional[pulumi.Input[str]]:
        """
        The watcher name.
        """
        return pulumi.get(self, "watcher_name")

    @watcher_name.setter
    def watcher_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "watcher_name", value)


class Watcher(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 automation_account_name: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 execution_frequency_in_seconds: Optional[pulumi.Input[float]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 resource_group_name: Optional[pulumi.Input[str]] = None,
                 script_name: Optional[pulumi.Input[str]] = None,
                 script_parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 script_run_on: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 watcher_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Definition of the watcher type.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] automation_account_name: The name of the automation account.
        :param pulumi.Input[str] description: Gets or sets the description.
        :param pulumi.Input[float] execution_frequency_in_seconds: Gets or sets the frequency at which the watcher is invoked.
        :param pulumi.Input[str] location: The Azure Region where the resource lives
        :param pulumi.Input[str] resource_group_name: Name of an Azure Resource group.
        :param pulumi.Input[str] script_name: Gets or sets the name of the script the watcher is attached to, i.e. the name of an existing runbook.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] script_parameters: Gets or sets the parameters of the script.
        :param pulumi.Input[str] script_run_on: Gets or sets the name of the hybrid worker group the watcher will run on.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Resource tags.
        :param pulumi.Input[str] watcher_name: The watcher name.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WatcherArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Definition of the watcher type.

        :param str resource_name: The name of the resource.
        :param WatcherArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WatcherArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 automation_account_name: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 execution_frequency_in_seconds: Optional[pulumi.Input[float]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 resource_group_name: Optional[pulumi.Input[str]] = None,
                 script_name: Optional[pulumi.Input[str]] = None,
                 script_parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 script_run_on: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 watcher_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WatcherArgs.__new__(WatcherArgs)

            if automation_account_name is None and not opts.urn:
                raise TypeError("Missing required property 'automation_account_name'")
            __props__.__dict__["automation_account_name"] = automation_account_name
            __props__.__dict__["description"] = description
            __props__.__dict__["execution_frequency_in_seconds"] = execution_frequency_in_seconds
            __props__.__dict__["location"] = location
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["script_name"] = script_name
            __props__.__dict__["script_parameters"] = script_parameters
            __props__.__dict__["script_run_on"] = script_run_on
            __props__.__dict__["tags"] = tags
            __props__.__dict__["watcher_name"] = watcher_name
            __props__.__dict__["creation_time"] = None
            __props__.__dict__["etag"] = None
            __props__.__dict__["last_modified_by"] = None
            __props__.__dict__["last_modified_time"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["type"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="azure-native:automation:Watcher"), pulumi.Alias(type_="azure-native:automation/v20190601:Watcher"), pulumi.Alias(type_="azure-native:automation/v20200113preview:Watcher")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(Watcher, __self__).__init__(
            'azure-native:automation/v20151031:Watcher',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Watcher':
        """
        Get an existing Watcher resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = WatcherArgs.__new__(WatcherArgs)

        __props__.__dict__["creation_time"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["etag"] = None
        __props__.__dict__["execution_frequency_in_seconds"] = None
        __props__.__dict__["last_modified_by"] = None
        __props__.__dict__["last_modified_time"] = None
        __props__.__dict__["location"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["script_name"] = None
        __props__.__dict__["script_parameters"] = None
        __props__.__dict__["script_run_on"] = None
        __props__.__dict__["status"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["type"] = None
        return Watcher(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> pulumi.Output[str]:
        """
        Gets or sets the creation time.
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Gets or sets the description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def etag(self) -> pulumi.Output[Optional[str]]:
        """
        Gets or sets the etag of the resource.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="executionFrequencyInSeconds")
    def execution_frequency_in_seconds(self) -> pulumi.Output[Optional[float]]:
        """
        Gets or sets the frequency at which the watcher is invoked.
        """
        return pulumi.get(self, "execution_frequency_in_seconds")

    @property
    @pulumi.getter(name="lastModifiedBy")
    def last_modified_by(self) -> pulumi.Output[str]:
        """
        Details of the user who last modified the watcher.
        """
        return pulumi.get(self, "last_modified_by")

    @property
    @pulumi.getter(name="lastModifiedTime")
    def last_modified_time(self) -> pulumi.Output[str]:
        """
        Gets or sets the last modified time.
        """
        return pulumi.get(self, "last_modified_time")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[Optional[str]]:
        """
        The Azure Region where the resource lives
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="scriptName")
    def script_name(self) -> pulumi.Output[Optional[str]]:
        """
        Gets or sets the name of the script the watcher is attached to, i.e. the name of an existing runbook.
        """
        return pulumi.get(self, "script_name")

    @property
    @pulumi.getter(name="scriptParameters")
    def script_parameters(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Gets or sets the parameters of the script.
        """
        return pulumi.get(self, "script_parameters")

    @property
    @pulumi.getter(name="scriptRunOn")
    def script_run_on(self) -> pulumi.Output[Optional[str]]:
        """
        Gets or sets the name of the hybrid worker group the watcher will run on.
        """
        return pulumi.get(self, "script_run_on")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        Gets the current status of the watcher.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Resource tags.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The type of the resource.
        """
        return pulumi.get(self, "type")

