# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'ConnectionDetailsResponse',
    'DiagnosticStoragePropertiesResponse',
    'GroupConnectivityInformationResponse',
    'IotHubSettingsResponse',
    'ManagedServiceIdentityResponse',
    'PrivateEndpointConnectionResponse',
    'PrivateEndpointResponse',
    'PrivateLinkServiceConnectionResponse',
    'PrivateLinkServiceConnectionStateResponse',
    'PrivateLinkServiceProxyResponse',
    'PrivateLinkServiceProxyResponseRemotePrivateEndpointConnection',
    'RemotePrivateEndpointResponse',
    'SystemDataResponse',
    'UserAssignedIdentityResponse',
]

@pulumi.output_type
class ConnectionDetailsResponse(dict):
    """
    Private endpoint connection proxy object properties.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "groupId":
            suggest = "group_id"
        elif key == "linkIdentifier":
            suggest = "link_identifier"
        elif key == "memberName":
            suggest = "member_name"
        elif key == "privateIpAddress":
            suggest = "private_ip_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 group_id: str,
                 id: str,
                 link_identifier: str,
                 member_name: str,
                 private_ip_address: str):
        """
        Private endpoint connection proxy object properties.
        :param str group_id: Group ID.
        :param str id: Connection details ID.
        :param str link_identifier: Link ID.
        :param str member_name: Member name.
        :param str private_ip_address: Private IP address.
        """
        pulumi.set(__self__, "group_id", group_id)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "link_identifier", link_identifier)
        pulumi.set(__self__, "member_name", member_name)
        pulumi.set(__self__, "private_ip_address", private_ip_address)

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> str:
        """
        Group ID.
        """
        return pulumi.get(self, "group_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Connection details ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="linkIdentifier")
    def link_identifier(self) -> str:
        """
        Link ID.
        """
        return pulumi.get(self, "link_identifier")

    @property
    @pulumi.getter(name="memberName")
    def member_name(self) -> str:
        """
        Member name.
        """
        return pulumi.get(self, "member_name")

    @property
    @pulumi.getter(name="privateIpAddress")
    def private_ip_address(self) -> str:
        """
        Private IP address.
        """
        return pulumi.get(self, "private_ip_address")


@pulumi.output_type
class DiagnosticStoragePropertiesResponse(dict):
    """
    Customer-initiated diagnostic log collection storage properties
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authenticationType":
            suggest = "authentication_type"
        elif key == "resourceId":
            suggest = "resource_id"
        elif key == "connectionString":
            suggest = "connection_string"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DiagnosticStoragePropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DiagnosticStoragePropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DiagnosticStoragePropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 authentication_type: str,
                 resource_id: str,
                 connection_string: Optional[str] = None):
        """
        Customer-initiated diagnostic log collection storage properties
        :param str authentication_type: Authentication Type
        :param str resource_id: ResourceId of the diagnostic storage account
        :param str connection_string: ConnectionString of the diagnostic storage account
        """
        pulumi.set(__self__, "authentication_type", authentication_type)
        pulumi.set(__self__, "resource_id", resource_id)
        if connection_string is not None:
            pulumi.set(__self__, "connection_string", connection_string)

    @property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> str:
        """
        Authentication Type
        """
        return pulumi.get(self, "authentication_type")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> str:
        """
        ResourceId of the diagnostic storage account
        """
        return pulumi.get(self, "resource_id")

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> Optional[str]:
        """
        ConnectionString of the diagnostic storage account
        """
        return pulumi.get(self, "connection_string")


@pulumi.output_type
class GroupConnectivityInformationResponse(dict):
    """
    Group connectivity details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "groupId":
            suggest = "group_id"
        elif key == "internalFqdn":
            suggest = "internal_fqdn"
        elif key == "memberName":
            suggest = "member_name"
        elif key == "customerVisibleFqdns":
            suggest = "customer_visible_fqdns"
        elif key == "privateLinkServiceArmRegion":
            suggest = "private_link_service_arm_region"
        elif key == "redirectMapId":
            suggest = "redirect_map_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GroupConnectivityInformationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GroupConnectivityInformationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GroupConnectivityInformationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 group_id: str,
                 internal_fqdn: str,
                 member_name: str,
                 customer_visible_fqdns: Optional[Sequence[str]] = None,
                 private_link_service_arm_region: Optional[str] = None,
                 redirect_map_id: Optional[str] = None):
        """
        Group connectivity details.
        :param str group_id: Group ID.
        :param str internal_fqdn: Internal FQDN.
        :param str member_name: Member name.
        :param Sequence[str] customer_visible_fqdns: List of customer visible FQDNs.
        :param str private_link_service_arm_region: PrivateLinkService ARM region.
        :param str redirect_map_id: Redirect map ID.
        """
        pulumi.set(__self__, "group_id", group_id)
        pulumi.set(__self__, "internal_fqdn", internal_fqdn)
        pulumi.set(__self__, "member_name", member_name)
        if customer_visible_fqdns is not None:
            pulumi.set(__self__, "customer_visible_fqdns", customer_visible_fqdns)
        if private_link_service_arm_region is not None:
            pulumi.set(__self__, "private_link_service_arm_region", private_link_service_arm_region)
        if redirect_map_id is not None:
            pulumi.set(__self__, "redirect_map_id", redirect_map_id)

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> str:
        """
        Group ID.
        """
        return pulumi.get(self, "group_id")

    @property
    @pulumi.getter(name="internalFqdn")
    def internal_fqdn(self) -> str:
        """
        Internal FQDN.
        """
        return pulumi.get(self, "internal_fqdn")

    @property
    @pulumi.getter(name="memberName")
    def member_name(self) -> str:
        """
        Member name.
        """
        return pulumi.get(self, "member_name")

    @property
    @pulumi.getter(name="customerVisibleFqdns")
    def customer_visible_fqdns(self) -> Optional[Sequence[str]]:
        """
        List of customer visible FQDNs.
        """
        return pulumi.get(self, "customer_visible_fqdns")

    @property
    @pulumi.getter(name="privateLinkServiceArmRegion")
    def private_link_service_arm_region(self) -> Optional[str]:
        """
        PrivateLinkService ARM region.
        """
        return pulumi.get(self, "private_link_service_arm_region")

    @property
    @pulumi.getter(name="redirectMapId")
    def redirect_map_id(self) -> Optional[str]:
        """
        Redirect map ID.
        """
        return pulumi.get(self, "redirect_map_id")


@pulumi.output_type
class IotHubSettingsResponse(dict):
    """
    Device Update account integration with IoT Hub settings.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceId":
            suggest = "resource_id"
        elif key == "eventHubConnectionString":
            suggest = "event_hub_connection_string"
        elif key == "ioTHubConnectionString":
            suggest = "io_t_hub_connection_string"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IotHubSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IotHubSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IotHubSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resource_id: str,
                 event_hub_connection_string: Optional[str] = None,
                 io_t_hub_connection_string: Optional[str] = None):
        """
        Device Update account integration with IoT Hub settings.
        :param str resource_id: IoTHub resource ID
        :param str event_hub_connection_string: EventHub connection string.
        :param str io_t_hub_connection_string: IoTHub connection string.
        """
        pulumi.set(__self__, "resource_id", resource_id)
        if event_hub_connection_string is not None:
            pulumi.set(__self__, "event_hub_connection_string", event_hub_connection_string)
        if io_t_hub_connection_string is not None:
            pulumi.set(__self__, "io_t_hub_connection_string", io_t_hub_connection_string)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> str:
        """
        IoTHub resource ID
        """
        return pulumi.get(self, "resource_id")

    @property
    @pulumi.getter(name="eventHubConnectionString")
    def event_hub_connection_string(self) -> Optional[str]:
        """
        EventHub connection string.
        """
        return pulumi.get(self, "event_hub_connection_string")

    @property
    @pulumi.getter(name="ioTHubConnectionString")
    def io_t_hub_connection_string(self) -> Optional[str]:
        """
        IoTHub connection string.
        """
        return pulumi.get(self, "io_t_hub_connection_string")


@pulumi.output_type
class ManagedServiceIdentityResponse(dict):
    """
    Managed service identity (system assigned and/or user assigned identities)
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"
        elif key == "userAssignedIdentities":
            suggest = "user_assigned_identities"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedServiceIdentityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedServiceIdentityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedServiceIdentityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 principal_id: str,
                 tenant_id: str,
                 type: str,
                 user_assigned_identities: Optional[Mapping[str, 'outputs.UserAssignedIdentityResponse']] = None):
        """
        Managed service identity (system assigned and/or user assigned identities)
        :param str principal_id: The service principal ID of the system assigned identity. This property will only be provided for a system assigned identity.
        :param str tenant_id: The tenant ID of the system assigned identity. This property will only be provided for a system assigned identity.
        :param str type: Type of managed service identity (where both SystemAssigned and UserAssigned types are allowed).
        :param Mapping[str, 'UserAssignedIdentityResponse'] user_assigned_identities: The set of user assigned identities associated with the resource. The userAssignedIdentities dictionary keys will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}. The dictionary values can be empty objects ({}) in requests.
        """
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        pulumi.set(__self__, "type", type)
        if user_assigned_identities is not None:
            pulumi.set(__self__, "user_assigned_identities", user_assigned_identities)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> str:
        """
        The service principal ID of the system assigned identity. This property will only be provided for a system assigned identity.
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> str:
        """
        The tenant ID of the system assigned identity. This property will only be provided for a system assigned identity.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of managed service identity (where both SystemAssigned and UserAssigned types are allowed).
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="userAssignedIdentities")
    def user_assigned_identities(self) -> Optional[Mapping[str, 'outputs.UserAssignedIdentityResponse']]:
        """
        The set of user assigned identities associated with the resource. The userAssignedIdentities dictionary keys will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}. The dictionary values can be empty objects ({}) in requests.
        """
        return pulumi.get(self, "user_assigned_identities")


@pulumi.output_type
class PrivateEndpointConnectionResponse(dict):
    """
    The Private Endpoint Connection resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "privateLinkServiceConnectionState":
            suggest = "private_link_service_connection_state"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "systemData":
            suggest = "system_data"
        elif key == "groupIds":
            suggest = "group_ids"
        elif key == "privateEndpoint":
            suggest = "private_endpoint"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrivateEndpointConnectionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrivateEndpointConnectionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrivateEndpointConnectionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: str,
                 name: str,
                 private_link_service_connection_state: 'outputs.PrivateLinkServiceConnectionStateResponse',
                 provisioning_state: str,
                 system_data: 'outputs.SystemDataResponse',
                 type: str,
                 group_ids: Optional[Sequence[str]] = None,
                 private_endpoint: Optional['outputs.PrivateEndpointResponse'] = None):
        """
        The Private Endpoint Connection resource.
        :param str id: Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
        :param str name: The name of the resource
        :param 'PrivateLinkServiceConnectionStateResponse' private_link_service_connection_state: A collection of information about the state of the connection between service consumer and provider.
        :param str provisioning_state: The provisioning state of the private endpoint connection resource.
        :param 'SystemDataResponse' system_data: Azure Resource Manager metadata containing createdBy and modifiedBy information.
        :param str type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
        :param Sequence[str] group_ids: Array of group IDs.
        :param 'PrivateEndpointResponse' private_endpoint: The resource of private end point.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "private_link_service_connection_state", private_link_service_connection_state)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "system_data", system_data)
        pulumi.set(__self__, "type", type)
        if group_ids is not None:
            pulumi.set(__self__, "group_ids", group_ids)
        if private_endpoint is not None:
            pulumi.set(__self__, "private_endpoint", private_endpoint)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="privateLinkServiceConnectionState")
    def private_link_service_connection_state(self) -> 'outputs.PrivateLinkServiceConnectionStateResponse':
        """
        A collection of information about the state of the connection between service consumer and provider.
        """
        return pulumi.get(self, "private_link_service_connection_state")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the private endpoint connection resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="systemData")
    def system_data(self) -> 'outputs.SystemDataResponse':
        """
        Azure Resource Manager metadata containing createdBy and modifiedBy information.
        """
        return pulumi.get(self, "system_data")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="groupIds")
    def group_ids(self) -> Optional[Sequence[str]]:
        """
        Array of group IDs.
        """
        return pulumi.get(self, "group_ids")

    @property
    @pulumi.getter(name="privateEndpoint")
    def private_endpoint(self) -> Optional['outputs.PrivateEndpointResponse']:
        """
        The resource of private end point.
        """
        return pulumi.get(self, "private_endpoint")


@pulumi.output_type
class PrivateEndpointResponse(dict):
    """
    The Private Endpoint resource.
    """
    def __init__(__self__, *,
                 id: str):
        """
        The Private Endpoint resource.
        :param str id: The ARM identifier for Private Endpoint
        """
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ARM identifier for Private Endpoint
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class PrivateLinkServiceConnectionResponse(dict):
    """
    Private link service connection details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "groupIds":
            suggest = "group_ids"
        elif key == "requestMessage":
            suggest = "request_message"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrivateLinkServiceConnectionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrivateLinkServiceConnectionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrivateLinkServiceConnectionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 group_ids: Optional[Sequence[str]] = None,
                 name: Optional[str] = None,
                 request_message: Optional[str] = None):
        """
        Private link service connection details.
        :param Sequence[str] group_ids: List of group IDs.
        :param str name: Private link service connection name.
        :param str request_message: Request message.
        """
        if group_ids is not None:
            pulumi.set(__self__, "group_ids", group_ids)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if request_message is not None:
            pulumi.set(__self__, "request_message", request_message)

    @property
    @pulumi.getter(name="groupIds")
    def group_ids(self) -> Optional[Sequence[str]]:
        """
        List of group IDs.
        """
        return pulumi.get(self, "group_ids")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Private link service connection name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="requestMessage")
    def request_message(self) -> Optional[str]:
        """
        Request message.
        """
        return pulumi.get(self, "request_message")


@pulumi.output_type
class PrivateLinkServiceConnectionStateResponse(dict):
    """
    A collection of information about the state of the connection between service consumer and provider.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "actionsRequired":
            suggest = "actions_required"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrivateLinkServiceConnectionStateResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrivateLinkServiceConnectionStateResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrivateLinkServiceConnectionStateResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 actions_required: Optional[str] = None,
                 description: Optional[str] = None,
                 status: Optional[str] = None):
        """
        A collection of information about the state of the connection between service consumer and provider.
        :param str actions_required: A message indicating if changes on the service provider require any updates on the consumer.
        :param str description: The reason for approval/rejection of the connection.
        :param str status: Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
        """
        if actions_required is not None:
            pulumi.set(__self__, "actions_required", actions_required)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="actionsRequired")
    def actions_required(self) -> Optional[str]:
        """
        A message indicating if changes on the service provider require any updates on the consumer.
        """
        return pulumi.get(self, "actions_required")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The reason for approval/rejection of the connection.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class PrivateLinkServiceProxyResponse(dict):
    """
    Private link service proxy details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "groupConnectivityInformation":
            suggest = "group_connectivity_information"
        elif key == "remotePrivateEndpointConnection":
            suggest = "remote_private_endpoint_connection"
        elif key == "remotePrivateLinkServiceConnectionState":
            suggest = "remote_private_link_service_connection_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrivateLinkServiceProxyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrivateLinkServiceProxyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrivateLinkServiceProxyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 group_connectivity_information: Optional[Sequence['outputs.GroupConnectivityInformationResponse']] = None,
                 id: Optional[str] = None,
                 remote_private_endpoint_connection: Optional['outputs.PrivateLinkServiceProxyResponseRemotePrivateEndpointConnection'] = None,
                 remote_private_link_service_connection_state: Optional['outputs.PrivateLinkServiceConnectionStateResponse'] = None):
        """
        Private link service proxy details.
        :param Sequence['GroupConnectivityInformationResponse'] group_connectivity_information: Group connectivity information.
        :param str id: NRP resource ID.
        :param 'PrivateLinkServiceProxyResponseRemotePrivateEndpointConnection' remote_private_endpoint_connection: Remote private endpoint connection details.
        :param 'PrivateLinkServiceConnectionStateResponse' remote_private_link_service_connection_state: Remote private link service connection state
        """
        if group_connectivity_information is not None:
            pulumi.set(__self__, "group_connectivity_information", group_connectivity_information)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if remote_private_endpoint_connection is not None:
            pulumi.set(__self__, "remote_private_endpoint_connection", remote_private_endpoint_connection)
        if remote_private_link_service_connection_state is not None:
            pulumi.set(__self__, "remote_private_link_service_connection_state", remote_private_link_service_connection_state)

    @property
    @pulumi.getter(name="groupConnectivityInformation")
    def group_connectivity_information(self) -> Optional[Sequence['outputs.GroupConnectivityInformationResponse']]:
        """
        Group connectivity information.
        """
        return pulumi.get(self, "group_connectivity_information")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        NRP resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="remotePrivateEndpointConnection")
    def remote_private_endpoint_connection(self) -> Optional['outputs.PrivateLinkServiceProxyResponseRemotePrivateEndpointConnection']:
        """
        Remote private endpoint connection details.
        """
        return pulumi.get(self, "remote_private_endpoint_connection")

    @property
    @pulumi.getter(name="remotePrivateLinkServiceConnectionState")
    def remote_private_link_service_connection_state(self) -> Optional['outputs.PrivateLinkServiceConnectionStateResponse']:
        """
        Remote private link service connection state
        """
        return pulumi.get(self, "remote_private_link_service_connection_state")


@pulumi.output_type
class PrivateLinkServiceProxyResponseRemotePrivateEndpointConnection(dict):
    """
    Remote private endpoint connection details.
    """
    def __init__(__self__, *,
                 id: str):
        """
        Remote private endpoint connection details.
        :param str id: Remote private endpoint connection ID.
        """
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Remote private endpoint connection ID.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class RemotePrivateEndpointResponse(dict):
    """
    Remote private endpoint details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectionDetails":
            suggest = "connection_details"
        elif key == "immutableResourceId":
            suggest = "immutable_resource_id"
        elif key == "immutableSubscriptionId":
            suggest = "immutable_subscription_id"
        elif key == "manualPrivateLinkServiceConnections":
            suggest = "manual_private_link_service_connections"
        elif key == "privateLinkServiceConnections":
            suggest = "private_link_service_connections"
        elif key == "privateLinkServiceProxies":
            suggest = "private_link_service_proxies"
        elif key == "vnetTrafficTag":
            suggest = "vnet_traffic_tag"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RemotePrivateEndpointResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RemotePrivateEndpointResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RemotePrivateEndpointResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connection_details: Optional[Sequence['outputs.ConnectionDetailsResponse']] = None,
                 id: Optional[str] = None,
                 immutable_resource_id: Optional[str] = None,
                 immutable_subscription_id: Optional[str] = None,
                 location: Optional[str] = None,
                 manual_private_link_service_connections: Optional[Sequence['outputs.PrivateLinkServiceConnectionResponse']] = None,
                 private_link_service_connections: Optional[Sequence['outputs.PrivateLinkServiceConnectionResponse']] = None,
                 private_link_service_proxies: Optional[Sequence['outputs.PrivateLinkServiceProxyResponse']] = None,
                 vnet_traffic_tag: Optional[str] = None):
        """
        Remote private endpoint details.
        :param Sequence['ConnectionDetailsResponse'] connection_details: List of connection details.
        :param str id: Remote endpoint resource ID.
        :param str immutable_resource_id: Original resource ID needed by Microsoft.Network.
        :param str immutable_subscription_id: Original subscription ID needed by Microsoft.Network.
        :param str location: ARM location of the remote private endpoint.
        :param Sequence['PrivateLinkServiceConnectionResponse'] manual_private_link_service_connections: List of private link service connections that need manual approval.
        :param Sequence['PrivateLinkServiceConnectionResponse'] private_link_service_connections: List of automatically approved private link service connections.
        :param Sequence['PrivateLinkServiceProxyResponse'] private_link_service_proxies: List of private link service proxies.
        :param str vnet_traffic_tag: Virtual network traffic tag.
        """
        if connection_details is not None:
            pulumi.set(__self__, "connection_details", connection_details)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if immutable_resource_id is not None:
            pulumi.set(__self__, "immutable_resource_id", immutable_resource_id)
        if immutable_subscription_id is not None:
            pulumi.set(__self__, "immutable_subscription_id", immutable_subscription_id)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if manual_private_link_service_connections is not None:
            pulumi.set(__self__, "manual_private_link_service_connections", manual_private_link_service_connections)
        if private_link_service_connections is not None:
            pulumi.set(__self__, "private_link_service_connections", private_link_service_connections)
        if private_link_service_proxies is not None:
            pulumi.set(__self__, "private_link_service_proxies", private_link_service_proxies)
        if vnet_traffic_tag is not None:
            pulumi.set(__self__, "vnet_traffic_tag", vnet_traffic_tag)

    @property
    @pulumi.getter(name="connectionDetails")
    def connection_details(self) -> Optional[Sequence['outputs.ConnectionDetailsResponse']]:
        """
        List of connection details.
        """
        return pulumi.get(self, "connection_details")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Remote endpoint resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="immutableResourceId")
    def immutable_resource_id(self) -> Optional[str]:
        """
        Original resource ID needed by Microsoft.Network.
        """
        return pulumi.get(self, "immutable_resource_id")

    @property
    @pulumi.getter(name="immutableSubscriptionId")
    def immutable_subscription_id(self) -> Optional[str]:
        """
        Original subscription ID needed by Microsoft.Network.
        """
        return pulumi.get(self, "immutable_subscription_id")

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        ARM location of the remote private endpoint.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="manualPrivateLinkServiceConnections")
    def manual_private_link_service_connections(self) -> Optional[Sequence['outputs.PrivateLinkServiceConnectionResponse']]:
        """
        List of private link service connections that need manual approval.
        """
        return pulumi.get(self, "manual_private_link_service_connections")

    @property
    @pulumi.getter(name="privateLinkServiceConnections")
    def private_link_service_connections(self) -> Optional[Sequence['outputs.PrivateLinkServiceConnectionResponse']]:
        """
        List of automatically approved private link service connections.
        """
        return pulumi.get(self, "private_link_service_connections")

    @property
    @pulumi.getter(name="privateLinkServiceProxies")
    def private_link_service_proxies(self) -> Optional[Sequence['outputs.PrivateLinkServiceProxyResponse']]:
        """
        List of private link service proxies.
        """
        return pulumi.get(self, "private_link_service_proxies")

    @property
    @pulumi.getter(name="vnetTrafficTag")
    def vnet_traffic_tag(self) -> Optional[str]:
        """
        Virtual network traffic tag.
        """
        return pulumi.get(self, "vnet_traffic_tag")


@pulumi.output_type
class SystemDataResponse(dict):
    """
    Metadata pertaining to creation and last modification of the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdAt":
            suggest = "created_at"
        elif key == "createdBy":
            suggest = "created_by"
        elif key == "createdByType":
            suggest = "created_by_type"
        elif key == "lastModifiedAt":
            suggest = "last_modified_at"
        elif key == "lastModifiedBy":
            suggest = "last_modified_by"
        elif key == "lastModifiedByType":
            suggest = "last_modified_by_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SystemDataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_at: Optional[str] = None,
                 created_by: Optional[str] = None,
                 created_by_type: Optional[str] = None,
                 last_modified_at: Optional[str] = None,
                 last_modified_by: Optional[str] = None,
                 last_modified_by_type: Optional[str] = None):
        """
        Metadata pertaining to creation and last modification of the resource.
        :param str created_at: The timestamp of resource creation (UTC).
        :param str created_by: The identity that created the resource.
        :param str created_by_type: The type of identity that created the resource.
        :param str last_modified_at: The timestamp of resource last modification (UTC)
        :param str last_modified_by: The identity that last modified the resource.
        :param str last_modified_by_type: The type of identity that last modified the resource.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if created_by_type is not None:
            pulumi.set(__self__, "created_by_type", created_by_type)
        if last_modified_at is not None:
            pulumi.set(__self__, "last_modified_at", last_modified_at)
        if last_modified_by is not None:
            pulumi.set(__self__, "last_modified_by", last_modified_by)
        if last_modified_by_type is not None:
            pulumi.set(__self__, "last_modified_by_type", last_modified_by_type)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[str]:
        """
        The timestamp of resource creation (UTC).
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[str]:
        """
        The identity that created the resource.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="createdByType")
    def created_by_type(self) -> Optional[str]:
        """
        The type of identity that created the resource.
        """
        return pulumi.get(self, "created_by_type")

    @property
    @pulumi.getter(name="lastModifiedAt")
    def last_modified_at(self) -> Optional[str]:
        """
        The timestamp of resource last modification (UTC)
        """
        return pulumi.get(self, "last_modified_at")

    @property
    @pulumi.getter(name="lastModifiedBy")
    def last_modified_by(self) -> Optional[str]:
        """
        The identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by")

    @property
    @pulumi.getter(name="lastModifiedByType")
    def last_modified_by_type(self) -> Optional[str]:
        """
        The type of identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by_type")


@pulumi.output_type
class UserAssignedIdentityResponse(dict):
    """
    User assigned identity properties
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientId":
            suggest = "client_id"
        elif key == "principalId":
            suggest = "principal_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserAssignedIdentityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserAssignedIdentityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserAssignedIdentityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_id: str,
                 principal_id: str):
        """
        User assigned identity properties
        :param str client_id: The client ID of the assigned identity.
        :param str principal_id: The principal ID of the assigned identity.
        """
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "principal_id", principal_id)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> str:
        """
        The client ID of the assigned identity.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> str:
        """
        The principal ID of the assigned identity.
        """
        return pulumi.get(self, "principal_id")


