# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'MaintenanceWindowArgs',
    'ServerGroupPropertiesDelegatedSubnetArgumentsArgs',
    'ServerGroupPropertiesPrivateDnsZoneArgumentsArgs',
    'ServerRoleGroupArgs',
]

@pulumi.input_type
class MaintenanceWindowArgs:
    def __init__(__self__, *,
                 custom_window: Optional[pulumi.Input[str]] = None,
                 day_of_week: Optional[pulumi.Input[int]] = None,
                 start_hour: Optional[pulumi.Input[int]] = None,
                 start_minute: Optional[pulumi.Input[int]] = None):
        """
        Maintenance window of a server group.
        :param pulumi.Input[str] custom_window: indicates whether custom window is enabled or disabled
        :param pulumi.Input[int] day_of_week: day of week for maintenance window
        :param pulumi.Input[int] start_hour: start hour for maintenance window
        :param pulumi.Input[int] start_minute: start minute for maintenance window
        """
        if custom_window is not None:
            pulumi.set(__self__, "custom_window", custom_window)
        if day_of_week is not None:
            pulumi.set(__self__, "day_of_week", day_of_week)
        if start_hour is not None:
            pulumi.set(__self__, "start_hour", start_hour)
        if start_minute is not None:
            pulumi.set(__self__, "start_minute", start_minute)

    @property
    @pulumi.getter(name="customWindow")
    def custom_window(self) -> Optional[pulumi.Input[str]]:
        """
        indicates whether custom window is enabled or disabled
        """
        return pulumi.get(self, "custom_window")

    @custom_window.setter
    def custom_window(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_window", value)

    @property
    @pulumi.getter(name="dayOfWeek")
    def day_of_week(self) -> Optional[pulumi.Input[int]]:
        """
        day of week for maintenance window
        """
        return pulumi.get(self, "day_of_week")

    @day_of_week.setter
    def day_of_week(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "day_of_week", value)

    @property
    @pulumi.getter(name="startHour")
    def start_hour(self) -> Optional[pulumi.Input[int]]:
        """
        start hour for maintenance window
        """
        return pulumi.get(self, "start_hour")

    @start_hour.setter
    def start_hour(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "start_hour", value)

    @property
    @pulumi.getter(name="startMinute")
    def start_minute(self) -> Optional[pulumi.Input[int]]:
        """
        start minute for maintenance window
        """
        return pulumi.get(self, "start_minute")

    @start_minute.setter
    def start_minute(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "start_minute", value)


@pulumi.input_type
class ServerGroupPropertiesDelegatedSubnetArgumentsArgs:
    def __init__(__self__, *,
                 subnet_arm_resource_id: Optional[pulumi.Input[str]] = None):
        """
        The delegated subnet arguments for a server group.
        :param pulumi.Input[str] subnet_arm_resource_id: delegated subnet arm resource id.
        """
        if subnet_arm_resource_id is not None:
            pulumi.set(__self__, "subnet_arm_resource_id", subnet_arm_resource_id)

    @property
    @pulumi.getter(name="subnetArmResourceId")
    def subnet_arm_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        delegated subnet arm resource id.
        """
        return pulumi.get(self, "subnet_arm_resource_id")

    @subnet_arm_resource_id.setter
    def subnet_arm_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet_arm_resource_id", value)


@pulumi.input_type
class ServerGroupPropertiesPrivateDnsZoneArgumentsArgs:
    def __init__(__self__, *,
                 private_dns_zone_arm_resource_id: Optional[pulumi.Input[str]] = None):
        """
        The private dns zone arguments for a server group.
        :param pulumi.Input[str] private_dns_zone_arm_resource_id: private dns zone arm resource id.
        """
        if private_dns_zone_arm_resource_id is not None:
            pulumi.set(__self__, "private_dns_zone_arm_resource_id", private_dns_zone_arm_resource_id)

    @property
    @pulumi.getter(name="privateDnsZoneArmResourceId")
    def private_dns_zone_arm_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        private dns zone arm resource id.
        """
        return pulumi.get(self, "private_dns_zone_arm_resource_id")

    @private_dns_zone_arm_resource_id.setter
    def private_dns_zone_arm_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_dns_zone_arm_resource_id", value)


@pulumi.input_type
class ServerRoleGroupArgs:
    def __init__(__self__, *,
                 enable_ha: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 role: Optional[pulumi.Input[Union[str, 'ServerRole']]] = None,
                 server_count: Optional[pulumi.Input[int]] = None,
                 server_edition: Optional[pulumi.Input[Union[str, 'ServerEdition']]] = None,
                 storage_quota_in_mb: Optional[pulumi.Input[float]] = None,
                 v_cores: Optional[pulumi.Input[float]] = None):
        """
        Represents a server role group.
        :param pulumi.Input[bool] enable_ha: If high availability is enabled or not for the server.
        :param pulumi.Input[str] name: The name of the server role group.
        :param pulumi.Input[Union[str, 'ServerRole']] role: The role of servers in the server role group.
        :param pulumi.Input[int] server_count: The number of servers in the server role group.
        :param pulumi.Input[Union[str, 'ServerEdition']] server_edition: The edition of a server (default: GeneralPurpose).
        :param pulumi.Input[float] storage_quota_in_mb: The storage of a server in MB (max: 2097152 = 2TiB).
        :param pulumi.Input[float] v_cores: The vCores count of a server (max: 64).
        """
        if enable_ha is not None:
            pulumi.set(__self__, "enable_ha", enable_ha)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if role is not None:
            pulumi.set(__self__, "role", role)
        if server_count is not None:
            pulumi.set(__self__, "server_count", server_count)
        if server_edition is not None:
            pulumi.set(__self__, "server_edition", server_edition)
        if storage_quota_in_mb is not None:
            pulumi.set(__self__, "storage_quota_in_mb", storage_quota_in_mb)
        if v_cores is not None:
            pulumi.set(__self__, "v_cores", v_cores)

    @property
    @pulumi.getter(name="enableHa")
    def enable_ha(self) -> Optional[pulumi.Input[bool]]:
        """
        If high availability is enabled or not for the server.
        """
        return pulumi.get(self, "enable_ha")

    @enable_ha.setter
    def enable_ha(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_ha", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the server role group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[Union[str, 'ServerRole']]]:
        """
        The role of servers in the server role group.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[Union[str, 'ServerRole']]]):
        pulumi.set(self, "role", value)

    @property
    @pulumi.getter(name="serverCount")
    def server_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of servers in the server role group.
        """
        return pulumi.get(self, "server_count")

    @server_count.setter
    def server_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "server_count", value)

    @property
    @pulumi.getter(name="serverEdition")
    def server_edition(self) -> Optional[pulumi.Input[Union[str, 'ServerEdition']]]:
        """
        The edition of a server (default: GeneralPurpose).
        """
        return pulumi.get(self, "server_edition")

    @server_edition.setter
    def server_edition(self, value: Optional[pulumi.Input[Union[str, 'ServerEdition']]]):
        pulumi.set(self, "server_edition", value)

    @property
    @pulumi.getter(name="storageQuotaInMb")
    def storage_quota_in_mb(self) -> Optional[pulumi.Input[float]]:
        """
        The storage of a server in MB (max: 2097152 = 2TiB).
        """
        return pulumi.get(self, "storage_quota_in_mb")

    @storage_quota_in_mb.setter
    def storage_quota_in_mb(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "storage_quota_in_mb", value)

    @property
    @pulumi.getter(name="vCores")
    def v_cores(self) -> Optional[pulumi.Input[float]]:
        """
        The vCores count of a server (max: 64).
        """
        return pulumi.get(self, "v_cores")

    @v_cores.setter
    def v_cores(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "v_cores", value)


