# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'BlobShareResponse',
    'ConnectToSourceSqlServerTaskInputResponse',
    'ConnectToSourceSqlServerTaskOutputAgentJobLevelResponse',
    'ConnectToSourceSqlServerTaskOutputDatabaseLevelResponse',
    'ConnectToSourceSqlServerTaskOutputLoginLevelResponse',
    'ConnectToSourceSqlServerTaskOutputTaskLevelResponse',
    'ConnectToSourceSqlServerTaskPropertiesResponse',
    'ConnectToTargetSqlDbTaskInputResponse',
    'ConnectToTargetSqlDbTaskOutputResponse',
    'ConnectToTargetSqlDbTaskPropertiesResponse',
    'ConnectToTargetSqlMITaskInputResponse',
    'ConnectToTargetSqlMITaskOutputResponse',
    'ConnectToTargetSqlMITaskPropertiesResponse',
    'DataItemMigrationSummaryResultResponse',
    'DatabaseFileInfoResponse',
    'DatabaseInfoResponse',
    'DatabaseSummaryResultResponse',
    'DatabaseTableResponse',
    'FileShareResponse',
    'GetUserTablesSqlTaskInputResponse',
    'GetUserTablesSqlTaskOutputResponse',
    'GetUserTablesSqlTaskPropertiesResponse',
    'MigrateSqlServerSqlDbDatabaseInputResponse',
    'MigrateSqlServerSqlDbTaskInputResponse',
    'MigrateSqlServerSqlDbTaskOutputDatabaseLevelResponse',
    'MigrateSqlServerSqlDbTaskOutputDatabaseLevelValidationResultResponse',
    'MigrateSqlServerSqlDbTaskOutputErrorResponse',
    'MigrateSqlServerSqlDbTaskOutputMigrationLevelResponse',
    'MigrateSqlServerSqlDbTaskOutputTableLevelResponse',
    'MigrateSqlServerSqlDbTaskOutputValidationResultResponse',
    'MigrateSqlServerSqlDbTaskPropertiesResponse',
    'MigrateSqlServerSqlMIDatabaseInputResponse',
    'MigrateSqlServerSqlMITaskInputResponse',
    'MigrateSqlServerSqlMITaskOutputAgentJobLevelResponse',
    'MigrateSqlServerSqlMITaskOutputDatabaseLevelResponse',
    'MigrateSqlServerSqlMITaskOutputErrorResponse',
    'MigrateSqlServerSqlMITaskOutputLoginLevelResponse',
    'MigrateSqlServerSqlMITaskOutputMigrationLevelResponse',
    'MigrateSqlServerSqlMITaskPropertiesResponse',
    'MigrationEligibilityInfoResponse',
    'MigrationReportResultResponse',
    'MigrationValidationOptionsResponse',
    'ODataErrorResponse',
    'ReportableExceptionResponse',
    'ServiceSkuResponse',
    'SqlConnectionInfoResponse',
    'StartMigrationScenarioServerRoleResultResponse',
    'ValidateMigrationInputSqlServerSqlMITaskInputResponse',
    'ValidateMigrationInputSqlServerSqlMITaskOutputResponse',
    'ValidateMigrationInputSqlServerSqlMITaskPropertiesResponse',
]

@pulumi.output_type
class BlobShareResponse(dict):
    """
    Blob container storage information.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sasUri":
            suggest = "sas_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BlobShareResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BlobShareResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BlobShareResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 sas_uri: str):
        """
        Blob container storage information.
        :param str sas_uri: SAS URI of Azure Storage Account Container.
        """
        pulumi.set(__self__, "sas_uri", sas_uri)

    @property
    @pulumi.getter(name="sasUri")
    def sas_uri(self) -> str:
        """
        SAS URI of Azure Storage Account Container.
        """
        return pulumi.get(self, "sas_uri")


@pulumi.output_type
class ConnectToSourceSqlServerTaskInputResponse(dict):
    """
    Input for the task that validates connection to SQL Server and also validates source server requirements
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceConnectionInfo":
            suggest = "source_connection_info"
        elif key == "checkPermissionsGroup":
            suggest = "check_permissions_group"
        elif key == "collectAgentJobs":
            suggest = "collect_agent_jobs"
        elif key == "collectLogins":
            suggest = "collect_logins"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectToSourceSqlServerTaskInputResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectToSourceSqlServerTaskInputResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectToSourceSqlServerTaskInputResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 source_connection_info: 'outputs.SqlConnectionInfoResponse',
                 check_permissions_group: Optional[str] = None,
                 collect_agent_jobs: Optional[bool] = None,
                 collect_logins: Optional[bool] = None):
        """
        Input for the task that validates connection to SQL Server and also validates source server requirements
        :param 'SqlConnectionInfoResponse' source_connection_info: Connection information for Source SQL Server
        :param str check_permissions_group: Permission group for validations
        :param bool collect_agent_jobs: Flag for whether to collect agent jobs from source server.
        :param bool collect_logins: Flag for whether to collect logins from source server.
        """
        pulumi.set(__self__, "source_connection_info", source_connection_info)
        if check_permissions_group is not None:
            pulumi.set(__self__, "check_permissions_group", check_permissions_group)
        if collect_agent_jobs is None:
            collect_agent_jobs = False
        if collect_agent_jobs is not None:
            pulumi.set(__self__, "collect_agent_jobs", collect_agent_jobs)
        if collect_logins is None:
            collect_logins = False
        if collect_logins is not None:
            pulumi.set(__self__, "collect_logins", collect_logins)

    @property
    @pulumi.getter(name="sourceConnectionInfo")
    def source_connection_info(self) -> 'outputs.SqlConnectionInfoResponse':
        """
        Connection information for Source SQL Server
        """
        return pulumi.get(self, "source_connection_info")

    @property
    @pulumi.getter(name="checkPermissionsGroup")
    def check_permissions_group(self) -> Optional[str]:
        """
        Permission group for validations
        """
        return pulumi.get(self, "check_permissions_group")

    @property
    @pulumi.getter(name="collectAgentJobs")
    def collect_agent_jobs(self) -> Optional[bool]:
        """
        Flag for whether to collect agent jobs from source server.
        """
        return pulumi.get(self, "collect_agent_jobs")

    @property
    @pulumi.getter(name="collectLogins")
    def collect_logins(self) -> Optional[bool]:
        """
        Flag for whether to collect logins from source server.
        """
        return pulumi.get(self, "collect_logins")


@pulumi.output_type
class ConnectToSourceSqlServerTaskOutputAgentJobLevelResponse(dict):
    """
    AgentJob level output for the task that validates connection to SQL Server and also validates source server requirements
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isEnabled":
            suggest = "is_enabled"
        elif key == "jobCategory":
            suggest = "job_category"
        elif key == "jobOwner":
            suggest = "job_owner"
        elif key == "lastExecutedOn":
            suggest = "last_executed_on"
        elif key == "migrationEligibility":
            suggest = "migration_eligibility"
        elif key == "resultType":
            suggest = "result_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectToSourceSqlServerTaskOutputAgentJobLevelResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectToSourceSqlServerTaskOutputAgentJobLevelResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectToSourceSqlServerTaskOutputAgentJobLevelResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: str,
                 is_enabled: bool,
                 job_category: str,
                 job_owner: str,
                 last_executed_on: str,
                 migration_eligibility: 'outputs.MigrationEligibilityInfoResponse',
                 name: str,
                 result_type: str):
        """
        AgentJob level output for the task that validates connection to SQL Server and also validates source server requirements
        :param str id: Result identifier
        :param bool is_enabled: The state of the original AgentJob.
        :param str job_category: The type of AgentJob.
        :param str job_owner: The owner of the AgentJob
        :param str last_executed_on: UTC Date and time when the AgentJob was last executed.
        :param 'MigrationEligibilityInfoResponse' migration_eligibility: Information about eligibility of agent job for migration.
        :param str name: AgentJob name
        :param str result_type: Type of result - database level or task level
               Expected value is 'AgentJobLevelOutput'.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_enabled", is_enabled)
        pulumi.set(__self__, "job_category", job_category)
        pulumi.set(__self__, "job_owner", job_owner)
        pulumi.set(__self__, "last_executed_on", last_executed_on)
        pulumi.set(__self__, "migration_eligibility", migration_eligibility)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "result_type", 'AgentJobLevelOutput')

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Result identifier
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> bool:
        """
        The state of the original AgentJob.
        """
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter(name="jobCategory")
    def job_category(self) -> str:
        """
        The type of AgentJob.
        """
        return pulumi.get(self, "job_category")

    @property
    @pulumi.getter(name="jobOwner")
    def job_owner(self) -> str:
        """
        The owner of the AgentJob
        """
        return pulumi.get(self, "job_owner")

    @property
    @pulumi.getter(name="lastExecutedOn")
    def last_executed_on(self) -> str:
        """
        UTC Date and time when the AgentJob was last executed.
        """
        return pulumi.get(self, "last_executed_on")

    @property
    @pulumi.getter(name="migrationEligibility")
    def migration_eligibility(self) -> 'outputs.MigrationEligibilityInfoResponse':
        """
        Information about eligibility of agent job for migration.
        """
        return pulumi.get(self, "migration_eligibility")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        AgentJob name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="resultType")
    def result_type(self) -> str:
        """
        Type of result - database level or task level
        Expected value is 'AgentJobLevelOutput'.
        """
        return pulumi.get(self, "result_type")


@pulumi.output_type
class ConnectToSourceSqlServerTaskOutputDatabaseLevelResponse(dict):
    """
    Database level output for the task that validates connection to SQL Server and also validates source server requirements
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "compatibilityLevel":
            suggest = "compatibility_level"
        elif key == "databaseFiles":
            suggest = "database_files"
        elif key == "databaseState":
            suggest = "database_state"
        elif key == "resultType":
            suggest = "result_type"
        elif key == "sizeMB":
            suggest = "size_mb"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectToSourceSqlServerTaskOutputDatabaseLevelResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectToSourceSqlServerTaskOutputDatabaseLevelResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectToSourceSqlServerTaskOutputDatabaseLevelResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 compatibility_level: str,
                 database_files: Sequence['outputs.DatabaseFileInfoResponse'],
                 database_state: str,
                 id: str,
                 name: str,
                 result_type: str,
                 size_mb: float):
        """
        Database level output for the task that validates connection to SQL Server and also validates source server requirements
        :param str compatibility_level: SQL Server compatibility level of database
        :param Sequence['DatabaseFileInfoResponse'] database_files: The list of database files
        :param str database_state: State of the database
        :param str id: Result identifier
        :param str name: Database name
        :param str result_type: Type of result - database level or task level
               Expected value is 'DatabaseLevelOutput'.
        :param float size_mb: Size of the file in megabytes
        """
        pulumi.set(__self__, "compatibility_level", compatibility_level)
        pulumi.set(__self__, "database_files", database_files)
        pulumi.set(__self__, "database_state", database_state)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "result_type", 'DatabaseLevelOutput')
        pulumi.set(__self__, "size_mb", size_mb)

    @property
    @pulumi.getter(name="compatibilityLevel")
    def compatibility_level(self) -> str:
        """
        SQL Server compatibility level of database
        """
        return pulumi.get(self, "compatibility_level")

    @property
    @pulumi.getter(name="databaseFiles")
    def database_files(self) -> Sequence['outputs.DatabaseFileInfoResponse']:
        """
        The list of database files
        """
        return pulumi.get(self, "database_files")

    @property
    @pulumi.getter(name="databaseState")
    def database_state(self) -> str:
        """
        State of the database
        """
        return pulumi.get(self, "database_state")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Result identifier
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Database name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="resultType")
    def result_type(self) -> str:
        """
        Type of result - database level or task level
        Expected value is 'DatabaseLevelOutput'.
        """
        return pulumi.get(self, "result_type")

    @property
    @pulumi.getter(name="sizeMB")
    def size_mb(self) -> float:
        """
        Size of the file in megabytes
        """
        return pulumi.get(self, "size_mb")


@pulumi.output_type
class ConnectToSourceSqlServerTaskOutputLoginLevelResponse(dict):
    """
    Login level output for the task that validates connection to SQL Server and also validates source server requirements
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultDatabase":
            suggest = "default_database"
        elif key == "isEnabled":
            suggest = "is_enabled"
        elif key == "loginType":
            suggest = "login_type"
        elif key == "migrationEligibility":
            suggest = "migration_eligibility"
        elif key == "resultType":
            suggest = "result_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectToSourceSqlServerTaskOutputLoginLevelResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectToSourceSqlServerTaskOutputLoginLevelResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectToSourceSqlServerTaskOutputLoginLevelResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_database: str,
                 id: str,
                 is_enabled: bool,
                 login_type: str,
                 migration_eligibility: 'outputs.MigrationEligibilityInfoResponse',
                 name: str,
                 result_type: str):
        """
        Login level output for the task that validates connection to SQL Server and also validates source server requirements
        :param str default_database: The default database for the login.
        :param str id: Result identifier
        :param bool is_enabled: The state of the login.
        :param str login_type: The type of login.
        :param 'MigrationEligibilityInfoResponse' migration_eligibility: Information about eligibility of login for migration.
        :param str name: Login name.
        :param str result_type: Type of result - database level or task level
               Expected value is 'LoginLevelOutput'.
        """
        pulumi.set(__self__, "default_database", default_database)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_enabled", is_enabled)
        pulumi.set(__self__, "login_type", login_type)
        pulumi.set(__self__, "migration_eligibility", migration_eligibility)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "result_type", 'LoginLevelOutput')

    @property
    @pulumi.getter(name="defaultDatabase")
    def default_database(self) -> str:
        """
        The default database for the login.
        """
        return pulumi.get(self, "default_database")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Result identifier
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> bool:
        """
        The state of the login.
        """
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter(name="loginType")
    def login_type(self) -> str:
        """
        The type of login.
        """
        return pulumi.get(self, "login_type")

    @property
    @pulumi.getter(name="migrationEligibility")
    def migration_eligibility(self) -> 'outputs.MigrationEligibilityInfoResponse':
        """
        Information about eligibility of login for migration.
        """
        return pulumi.get(self, "migration_eligibility")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Login name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="resultType")
    def result_type(self) -> str:
        """
        Type of result - database level or task level
        Expected value is 'LoginLevelOutput'.
        """
        return pulumi.get(self, "result_type")


@pulumi.output_type
class ConnectToSourceSqlServerTaskOutputTaskLevelResponse(dict):
    """
    Task level output for the task that validates connection to SQL Server and also validates source server requirements
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "agentJobs":
            suggest = "agent_jobs"
        elif key == "resultType":
            suggest = "result_type"
        elif key == "sourceServerBrandVersion":
            suggest = "source_server_brand_version"
        elif key == "sourceServerVersion":
            suggest = "source_server_version"
        elif key == "validationErrors":
            suggest = "validation_errors"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectToSourceSqlServerTaskOutputTaskLevelResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectToSourceSqlServerTaskOutputTaskLevelResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectToSourceSqlServerTaskOutputTaskLevelResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 agent_jobs: Mapping[str, str],
                 databases: Mapping[str, str],
                 id: str,
                 logins: Mapping[str, str],
                 result_type: str,
                 source_server_brand_version: str,
                 source_server_version: str,
                 validation_errors: Sequence['outputs.ReportableExceptionResponse']):
        """
        Task level output for the task that validates connection to SQL Server and also validates source server requirements
        :param Mapping[str, str] agent_jobs: Source agent jobs as a map from agent job name to id.
        :param Mapping[str, str] databases: Source databases as a map from database name to database id
        :param str id: Result identifier
        :param Mapping[str, str] logins: Source logins as a map from login name to login id.
        :param str result_type: Type of result - database level or task level
               Expected value is 'TaskLevelOutput'.
        :param str source_server_brand_version: Source server brand version
        :param str source_server_version: Source server version
        :param Sequence['ReportableExceptionResponse'] validation_errors: Validation errors
        """
        pulumi.set(__self__, "agent_jobs", agent_jobs)
        pulumi.set(__self__, "databases", databases)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "logins", logins)
        pulumi.set(__self__, "result_type", 'TaskLevelOutput')
        pulumi.set(__self__, "source_server_brand_version", source_server_brand_version)
        pulumi.set(__self__, "source_server_version", source_server_version)
        pulumi.set(__self__, "validation_errors", validation_errors)

    @property
    @pulumi.getter(name="agentJobs")
    def agent_jobs(self) -> Mapping[str, str]:
        """
        Source agent jobs as a map from agent job name to id.
        """
        return pulumi.get(self, "agent_jobs")

    @property
    @pulumi.getter
    def databases(self) -> Mapping[str, str]:
        """
        Source databases as a map from database name to database id
        """
        return pulumi.get(self, "databases")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Result identifier
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def logins(self) -> Mapping[str, str]:
        """
        Source logins as a map from login name to login id.
        """
        return pulumi.get(self, "logins")

    @property
    @pulumi.getter(name="resultType")
    def result_type(self) -> str:
        """
        Type of result - database level or task level
        Expected value is 'TaskLevelOutput'.
        """
        return pulumi.get(self, "result_type")

    @property
    @pulumi.getter(name="sourceServerBrandVersion")
    def source_server_brand_version(self) -> str:
        """
        Source server brand version
        """
        return pulumi.get(self, "source_server_brand_version")

    @property
    @pulumi.getter(name="sourceServerVersion")
    def source_server_version(self) -> str:
        """
        Source server version
        """
        return pulumi.get(self, "source_server_version")

    @property
    @pulumi.getter(name="validationErrors")
    def validation_errors(self) -> Sequence['outputs.ReportableExceptionResponse']:
        """
        Validation errors
        """
        return pulumi.get(self, "validation_errors")


@pulumi.output_type
class ConnectToSourceSqlServerTaskPropertiesResponse(dict):
    """
    Properties for the task that validates connection to SQL Server and also validates source server requirements
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "taskType":
            suggest = "task_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectToSourceSqlServerTaskPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectToSourceSqlServerTaskPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectToSourceSqlServerTaskPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 errors: Sequence['outputs.ODataErrorResponse'],
                 output: Sequence[Any],
                 state: str,
                 task_type: str,
                 input: Optional['outputs.ConnectToSourceSqlServerTaskInputResponse'] = None):
        """
        Properties for the task that validates connection to SQL Server and also validates source server requirements
        :param Sequence['ODataErrorResponse'] errors: Array of errors. This is ignored if submitted.
        :param Sequence[Union['ConnectToSourceSqlServerTaskOutputAgentJobLevelResponse', 'ConnectToSourceSqlServerTaskOutputDatabaseLevelResponse', 'ConnectToSourceSqlServerTaskOutputLoginLevelResponse', 'ConnectToSourceSqlServerTaskOutputTaskLevelResponse']] output: Task output. This is ignored if submitted.
        :param str state: The state of the task. This is ignored if submitted.
        :param str task_type: Task type.
               Expected value is 'ConnectToSource.SqlServer'.
        :param 'ConnectToSourceSqlServerTaskInputResponse' input: Task input
        """
        pulumi.set(__self__, "errors", errors)
        pulumi.set(__self__, "output", output)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "task_type", 'ConnectToSource.SqlServer')
        if input is not None:
            pulumi.set(__self__, "input", input)

    @property
    @pulumi.getter
    def errors(self) -> Sequence['outputs.ODataErrorResponse']:
        """
        Array of errors. This is ignored if submitted.
        """
        return pulumi.get(self, "errors")

    @property
    @pulumi.getter
    def output(self) -> Sequence[Any]:
        """
        Task output. This is ignored if submitted.
        """
        return pulumi.get(self, "output")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The state of the task. This is ignored if submitted.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> str:
        """
        Task type.
        Expected value is 'ConnectToSource.SqlServer'.
        """
        return pulumi.get(self, "task_type")

    @property
    @pulumi.getter
    def input(self) -> Optional['outputs.ConnectToSourceSqlServerTaskInputResponse']:
        """
        Task input
        """
        return pulumi.get(self, "input")


@pulumi.output_type
class ConnectToTargetSqlDbTaskInputResponse(dict):
    """
    Input for the task that validates connection to SQL DB and target server requirements
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetConnectionInfo":
            suggest = "target_connection_info"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectToTargetSqlDbTaskInputResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectToTargetSqlDbTaskInputResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectToTargetSqlDbTaskInputResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 target_connection_info: 'outputs.SqlConnectionInfoResponse'):
        """
        Input for the task that validates connection to SQL DB and target server requirements
        :param 'SqlConnectionInfoResponse' target_connection_info: Connection information for target SQL DB
        """
        pulumi.set(__self__, "target_connection_info", target_connection_info)

    @property
    @pulumi.getter(name="targetConnectionInfo")
    def target_connection_info(self) -> 'outputs.SqlConnectionInfoResponse':
        """
        Connection information for target SQL DB
        """
        return pulumi.get(self, "target_connection_info")


@pulumi.output_type
class ConnectToTargetSqlDbTaskOutputResponse(dict):
    """
    Output for the task that validates connection to SQL DB and target server requirements
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetServerBrandVersion":
            suggest = "target_server_brand_version"
        elif key == "targetServerVersion":
            suggest = "target_server_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectToTargetSqlDbTaskOutputResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectToTargetSqlDbTaskOutputResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectToTargetSqlDbTaskOutputResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 databases: Mapping[str, str],
                 id: str,
                 target_server_brand_version: str,
                 target_server_version: str):
        """
        Output for the task that validates connection to SQL DB and target server requirements
        :param Mapping[str, str] databases: Source databases as a map from database name to database id
        :param str id: Result identifier
        :param str target_server_brand_version: Target server brand version
        :param str target_server_version: Version of the target server
        """
        pulumi.set(__self__, "databases", databases)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "target_server_brand_version", target_server_brand_version)
        pulumi.set(__self__, "target_server_version", target_server_version)

    @property
    @pulumi.getter
    def databases(self) -> Mapping[str, str]:
        """
        Source databases as a map from database name to database id
        """
        return pulumi.get(self, "databases")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Result identifier
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="targetServerBrandVersion")
    def target_server_brand_version(self) -> str:
        """
        Target server brand version
        """
        return pulumi.get(self, "target_server_brand_version")

    @property
    @pulumi.getter(name="targetServerVersion")
    def target_server_version(self) -> str:
        """
        Version of the target server
        """
        return pulumi.get(self, "target_server_version")


@pulumi.output_type
class ConnectToTargetSqlDbTaskPropertiesResponse(dict):
    """
    Properties for the task that validates connection to SQL DB and target server requirements
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "taskType":
            suggest = "task_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectToTargetSqlDbTaskPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectToTargetSqlDbTaskPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectToTargetSqlDbTaskPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 errors: Sequence['outputs.ODataErrorResponse'],
                 output: Sequence['outputs.ConnectToTargetSqlDbTaskOutputResponse'],
                 state: str,
                 task_type: str,
                 input: Optional['outputs.ConnectToTargetSqlDbTaskInputResponse'] = None):
        """
        Properties for the task that validates connection to SQL DB and target server requirements
        :param Sequence['ODataErrorResponse'] errors: Array of errors. This is ignored if submitted.
        :param Sequence['ConnectToTargetSqlDbTaskOutputResponse'] output: Task output. This is ignored if submitted.
        :param str state: The state of the task. This is ignored if submitted.
        :param str task_type: Task type.
               Expected value is 'ConnectToTarget.SqlDb'.
        :param 'ConnectToTargetSqlDbTaskInputResponse' input: Task input
        """
        pulumi.set(__self__, "errors", errors)
        pulumi.set(__self__, "output", output)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "task_type", 'ConnectToTarget.SqlDb')
        if input is not None:
            pulumi.set(__self__, "input", input)

    @property
    @pulumi.getter
    def errors(self) -> Sequence['outputs.ODataErrorResponse']:
        """
        Array of errors. This is ignored if submitted.
        """
        return pulumi.get(self, "errors")

    @property
    @pulumi.getter
    def output(self) -> Sequence['outputs.ConnectToTargetSqlDbTaskOutputResponse']:
        """
        Task output. This is ignored if submitted.
        """
        return pulumi.get(self, "output")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The state of the task. This is ignored if submitted.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> str:
        """
        Task type.
        Expected value is 'ConnectToTarget.SqlDb'.
        """
        return pulumi.get(self, "task_type")

    @property
    @pulumi.getter
    def input(self) -> Optional['outputs.ConnectToTargetSqlDbTaskInputResponse']:
        """
        Task input
        """
        return pulumi.get(self, "input")


@pulumi.output_type
class ConnectToTargetSqlMITaskInputResponse(dict):
    """
    Input for the task that validates connection to Azure SQL Database Managed Instance.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetConnectionInfo":
            suggest = "target_connection_info"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectToTargetSqlMITaskInputResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectToTargetSqlMITaskInputResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectToTargetSqlMITaskInputResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 target_connection_info: 'outputs.SqlConnectionInfoResponse'):
        """
        Input for the task that validates connection to Azure SQL Database Managed Instance.
        :param 'SqlConnectionInfoResponse' target_connection_info: Connection information for target SQL Server
        """
        pulumi.set(__self__, "target_connection_info", target_connection_info)

    @property
    @pulumi.getter(name="targetConnectionInfo")
    def target_connection_info(self) -> 'outputs.SqlConnectionInfoResponse':
        """
        Connection information for target SQL Server
        """
        return pulumi.get(self, "target_connection_info")


@pulumi.output_type
class ConnectToTargetSqlMITaskOutputResponse(dict):
    """
    Output for the task that validates connection to Azure SQL Database Managed Instance.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "agentJobs":
            suggest = "agent_jobs"
        elif key == "targetServerBrandVersion":
            suggest = "target_server_brand_version"
        elif key == "targetServerVersion":
            suggest = "target_server_version"
        elif key == "validationErrors":
            suggest = "validation_errors"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectToTargetSqlMITaskOutputResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectToTargetSqlMITaskOutputResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectToTargetSqlMITaskOutputResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 agent_jobs: Sequence[str],
                 id: str,
                 logins: Sequence[str],
                 target_server_brand_version: str,
                 target_server_version: str,
                 validation_errors: Sequence['outputs.ReportableExceptionResponse']):
        """
        Output for the task that validates connection to Azure SQL Database Managed Instance.
        :param Sequence[str] agent_jobs: List of agent jobs on the target server.
        :param str id: Result identifier
        :param Sequence[str] logins: List of logins on the target server.
        :param str target_server_brand_version: Target server brand version
        :param str target_server_version: Target server version
        :param Sequence['ReportableExceptionResponse'] validation_errors: Validation errors
        """
        pulumi.set(__self__, "agent_jobs", agent_jobs)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "logins", logins)
        pulumi.set(__self__, "target_server_brand_version", target_server_brand_version)
        pulumi.set(__self__, "target_server_version", target_server_version)
        pulumi.set(__self__, "validation_errors", validation_errors)

    @property
    @pulumi.getter(name="agentJobs")
    def agent_jobs(self) -> Sequence[str]:
        """
        List of agent jobs on the target server.
        """
        return pulumi.get(self, "agent_jobs")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Result identifier
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def logins(self) -> Sequence[str]:
        """
        List of logins on the target server.
        """
        return pulumi.get(self, "logins")

    @property
    @pulumi.getter(name="targetServerBrandVersion")
    def target_server_brand_version(self) -> str:
        """
        Target server brand version
        """
        return pulumi.get(self, "target_server_brand_version")

    @property
    @pulumi.getter(name="targetServerVersion")
    def target_server_version(self) -> str:
        """
        Target server version
        """
        return pulumi.get(self, "target_server_version")

    @property
    @pulumi.getter(name="validationErrors")
    def validation_errors(self) -> Sequence['outputs.ReportableExceptionResponse']:
        """
        Validation errors
        """
        return pulumi.get(self, "validation_errors")


@pulumi.output_type
class ConnectToTargetSqlMITaskPropertiesResponse(dict):
    """
    Properties for the task that validates connection to Azure SQL Database Managed Instance
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "taskType":
            suggest = "task_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectToTargetSqlMITaskPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectToTargetSqlMITaskPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectToTargetSqlMITaskPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 errors: Sequence['outputs.ODataErrorResponse'],
                 output: Sequence['outputs.ConnectToTargetSqlMITaskOutputResponse'],
                 state: str,
                 task_type: str,
                 input: Optional['outputs.ConnectToTargetSqlMITaskInputResponse'] = None):
        """
        Properties for the task that validates connection to Azure SQL Database Managed Instance
        :param Sequence['ODataErrorResponse'] errors: Array of errors. This is ignored if submitted.
        :param Sequence['ConnectToTargetSqlMITaskOutputResponse'] output: Task output. This is ignored if submitted.
        :param str state: The state of the task. This is ignored if submitted.
        :param str task_type: Task type.
               Expected value is 'ConnectToTarget.AzureSqlDbMI'.
        :param 'ConnectToTargetSqlMITaskInputResponse' input: Task input
        """
        pulumi.set(__self__, "errors", errors)
        pulumi.set(__self__, "output", output)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "task_type", 'ConnectToTarget.AzureSqlDbMI')
        if input is not None:
            pulumi.set(__self__, "input", input)

    @property
    @pulumi.getter
    def errors(self) -> Sequence['outputs.ODataErrorResponse']:
        """
        Array of errors. This is ignored if submitted.
        """
        return pulumi.get(self, "errors")

    @property
    @pulumi.getter
    def output(self) -> Sequence['outputs.ConnectToTargetSqlMITaskOutputResponse']:
        """
        Task output. This is ignored if submitted.
        """
        return pulumi.get(self, "output")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The state of the task. This is ignored if submitted.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> str:
        """
        Task type.
        Expected value is 'ConnectToTarget.AzureSqlDbMI'.
        """
        return pulumi.get(self, "task_type")

    @property
    @pulumi.getter
    def input(self) -> Optional['outputs.ConnectToTargetSqlMITaskInputResponse']:
        """
        Task input
        """
        return pulumi.get(self, "input")


@pulumi.output_type
class DataItemMigrationSummaryResultResponse(dict):
    """
    Basic summary of a data item migration
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endedOn":
            suggest = "ended_on"
        elif key == "errorPrefix":
            suggest = "error_prefix"
        elif key == "itemsCompletedCount":
            suggest = "items_completed_count"
        elif key == "itemsCount":
            suggest = "items_count"
        elif key == "resultPrefix":
            suggest = "result_prefix"
        elif key == "startedOn":
            suggest = "started_on"
        elif key == "statusMessage":
            suggest = "status_message"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataItemMigrationSummaryResultResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataItemMigrationSummaryResultResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataItemMigrationSummaryResultResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ended_on: str,
                 error_prefix: str,
                 items_completed_count: float,
                 items_count: float,
                 name: str,
                 result_prefix: str,
                 started_on: str,
                 state: str,
                 status_message: str):
        """
        Basic summary of a data item migration
        :param str ended_on: Migration end time
        :param str error_prefix: Wildcard string prefix to use for querying all errors of the item
        :param float items_completed_count: Number of successfully completed items
        :param float items_count: Number of items
        :param str name: Name of the item
        :param str result_prefix: Wildcard string prefix to use for querying all sub-tem results of the item
        :param str started_on: Migration start time
        :param str state: Current state of migration
        :param str status_message: Status message
        """
        pulumi.set(__self__, "ended_on", ended_on)
        pulumi.set(__self__, "error_prefix", error_prefix)
        pulumi.set(__self__, "items_completed_count", items_completed_count)
        pulumi.set(__self__, "items_count", items_count)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "result_prefix", result_prefix)
        pulumi.set(__self__, "started_on", started_on)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "status_message", status_message)

    @property
    @pulumi.getter(name="endedOn")
    def ended_on(self) -> str:
        """
        Migration end time
        """
        return pulumi.get(self, "ended_on")

    @property
    @pulumi.getter(name="errorPrefix")
    def error_prefix(self) -> str:
        """
        Wildcard string prefix to use for querying all errors of the item
        """
        return pulumi.get(self, "error_prefix")

    @property
    @pulumi.getter(name="itemsCompletedCount")
    def items_completed_count(self) -> float:
        """
        Number of successfully completed items
        """
        return pulumi.get(self, "items_completed_count")

    @property
    @pulumi.getter(name="itemsCount")
    def items_count(self) -> float:
        """
        Number of items
        """
        return pulumi.get(self, "items_count")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the item
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="resultPrefix")
    def result_prefix(self) -> str:
        """
        Wildcard string prefix to use for querying all sub-tem results of the item
        """
        return pulumi.get(self, "result_prefix")

    @property
    @pulumi.getter(name="startedOn")
    def started_on(self) -> str:
        """
        Migration start time
        """
        return pulumi.get(self, "started_on")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        Current state of migration
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="statusMessage")
    def status_message(self) -> str:
        """
        Status message
        """
        return pulumi.get(self, "status_message")


@pulumi.output_type
class DatabaseFileInfoResponse(dict):
    """
    Database file specific information
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "databaseName":
            suggest = "database_name"
        elif key == "fileType":
            suggest = "file_type"
        elif key == "logicalName":
            suggest = "logical_name"
        elif key == "physicalFullName":
            suggest = "physical_full_name"
        elif key == "restoreFullName":
            suggest = "restore_full_name"
        elif key == "sizeMB":
            suggest = "size_mb"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseFileInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseFileInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseFileInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 database_name: Optional[str] = None,
                 file_type: Optional[str] = None,
                 id: Optional[str] = None,
                 logical_name: Optional[str] = None,
                 physical_full_name: Optional[str] = None,
                 restore_full_name: Optional[str] = None,
                 size_mb: Optional[float] = None):
        """
        Database file specific information
        :param str database_name: Name of the database
        :param str file_type: Database file type
        :param str id: Unique identifier for database file
        :param str logical_name: Logical name of the file
        :param str physical_full_name: Operating-system full path of the file
        :param str restore_full_name: Suggested full path of the file for restoring
        :param float size_mb: Size of the file in megabytes
        """
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)
        if file_type is not None:
            pulumi.set(__self__, "file_type", file_type)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if logical_name is not None:
            pulumi.set(__self__, "logical_name", logical_name)
        if physical_full_name is not None:
            pulumi.set(__self__, "physical_full_name", physical_full_name)
        if restore_full_name is not None:
            pulumi.set(__self__, "restore_full_name", restore_full_name)
        if size_mb is not None:
            pulumi.set(__self__, "size_mb", size_mb)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[str]:
        """
        Name of the database
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter(name="fileType")
    def file_type(self) -> Optional[str]:
        """
        Database file type
        """
        return pulumi.get(self, "file_type")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Unique identifier for database file
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="logicalName")
    def logical_name(self) -> Optional[str]:
        """
        Logical name of the file
        """
        return pulumi.get(self, "logical_name")

    @property
    @pulumi.getter(name="physicalFullName")
    def physical_full_name(self) -> Optional[str]:
        """
        Operating-system full path of the file
        """
        return pulumi.get(self, "physical_full_name")

    @property
    @pulumi.getter(name="restoreFullName")
    def restore_full_name(self) -> Optional[str]:
        """
        Suggested full path of the file for restoring
        """
        return pulumi.get(self, "restore_full_name")

    @property
    @pulumi.getter(name="sizeMB")
    def size_mb(self) -> Optional[float]:
        """
        Size of the file in megabytes
        """
        return pulumi.get(self, "size_mb")


@pulumi.output_type
class DatabaseInfoResponse(dict):
    """
    Project Database Details
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceDatabaseName":
            suggest = "source_database_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 source_database_name: str):
        """
        Project Database Details
        :param str source_database_name: Name of the database
        """
        pulumi.set(__self__, "source_database_name", source_database_name)

    @property
    @pulumi.getter(name="sourceDatabaseName")
    def source_database_name(self) -> str:
        """
        Name of the database
        """
        return pulumi.get(self, "source_database_name")


@pulumi.output_type
class DatabaseSummaryResultResponse(dict):
    """
    Summary of database results in the migration
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endedOn":
            suggest = "ended_on"
        elif key == "errorPrefix":
            suggest = "error_prefix"
        elif key == "itemsCompletedCount":
            suggest = "items_completed_count"
        elif key == "itemsCount":
            suggest = "items_count"
        elif key == "resultPrefix":
            suggest = "result_prefix"
        elif key == "sizeMB":
            suggest = "size_mb"
        elif key == "startedOn":
            suggest = "started_on"
        elif key == "statusMessage":
            suggest = "status_message"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseSummaryResultResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseSummaryResultResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseSummaryResultResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ended_on: str,
                 error_prefix: str,
                 items_completed_count: float,
                 items_count: float,
                 name: str,
                 result_prefix: str,
                 size_mb: float,
                 started_on: str,
                 state: str,
                 status_message: str):
        """
        Summary of database results in the migration
        :param str ended_on: Migration end time
        :param str error_prefix: Wildcard string prefix to use for querying all errors of the item
        :param float items_completed_count: Number of successfully completed items
        :param float items_count: Number of items
        :param str name: Name of the item
        :param str result_prefix: Wildcard string prefix to use for querying all sub-tem results of the item
        :param float size_mb: Size of the database in megabytes
        :param str started_on: Migration start time
        :param str state: Current state of migration
        :param str status_message: Status message
        """
        pulumi.set(__self__, "ended_on", ended_on)
        pulumi.set(__self__, "error_prefix", error_prefix)
        pulumi.set(__self__, "items_completed_count", items_completed_count)
        pulumi.set(__self__, "items_count", items_count)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "result_prefix", result_prefix)
        pulumi.set(__self__, "size_mb", size_mb)
        pulumi.set(__self__, "started_on", started_on)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "status_message", status_message)

    @property
    @pulumi.getter(name="endedOn")
    def ended_on(self) -> str:
        """
        Migration end time
        """
        return pulumi.get(self, "ended_on")

    @property
    @pulumi.getter(name="errorPrefix")
    def error_prefix(self) -> str:
        """
        Wildcard string prefix to use for querying all errors of the item
        """
        return pulumi.get(self, "error_prefix")

    @property
    @pulumi.getter(name="itemsCompletedCount")
    def items_completed_count(self) -> float:
        """
        Number of successfully completed items
        """
        return pulumi.get(self, "items_completed_count")

    @property
    @pulumi.getter(name="itemsCount")
    def items_count(self) -> float:
        """
        Number of items
        """
        return pulumi.get(self, "items_count")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the item
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="resultPrefix")
    def result_prefix(self) -> str:
        """
        Wildcard string prefix to use for querying all sub-tem results of the item
        """
        return pulumi.get(self, "result_prefix")

    @property
    @pulumi.getter(name="sizeMB")
    def size_mb(self) -> float:
        """
        Size of the database in megabytes
        """
        return pulumi.get(self, "size_mb")

    @property
    @pulumi.getter(name="startedOn")
    def started_on(self) -> str:
        """
        Migration start time
        """
        return pulumi.get(self, "started_on")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        Current state of migration
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="statusMessage")
    def status_message(self) -> str:
        """
        Status message
        """
        return pulumi.get(self, "status_message")


@pulumi.output_type
class DatabaseTableResponse(dict):
    """
    Table properties
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hasRows":
            suggest = "has_rows"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseTableResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseTableResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseTableResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 has_rows: bool,
                 name: str):
        """
        Table properties
        :param bool has_rows: Indicates whether table is empty or not
        :param str name: Schema-qualified name of the table
        """
        pulumi.set(__self__, "has_rows", has_rows)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="hasRows")
    def has_rows(self) -> bool:
        """
        Indicates whether table is empty or not
        """
        return pulumi.get(self, "has_rows")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Schema-qualified name of the table
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class FileShareResponse(dict):
    """
    File share information with Path, Username, and Password.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "userName":
            suggest = "user_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FileShareResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FileShareResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FileShareResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 path: str,
                 password: Optional[str] = None,
                 user_name: Optional[str] = None):
        """
        File share information with Path, Username, and Password.
        :param str path: The folder path for this share.
        :param str password: Password credential used to connect to the share location.
        :param str user_name: User name credential to connect to the share location
        """
        pulumi.set(__self__, "path", path)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        The folder path for this share.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def password(self) -> Optional[str]:
        """
        Password credential used to connect to the share location.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[str]:
        """
        User name credential to connect to the share location
        """
        return pulumi.get(self, "user_name")


@pulumi.output_type
class GetUserTablesSqlTaskInputResponse(dict):
    """
    Input for the task that collects user tables for the given list of databases
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectionInfo":
            suggest = "connection_info"
        elif key == "selectedDatabases":
            suggest = "selected_databases"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GetUserTablesSqlTaskInputResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GetUserTablesSqlTaskInputResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GetUserTablesSqlTaskInputResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connection_info: 'outputs.SqlConnectionInfoResponse',
                 selected_databases: Sequence[str]):
        """
        Input for the task that collects user tables for the given list of databases
        :param 'SqlConnectionInfoResponse' connection_info: Connection information for SQL Server
        :param Sequence[str] selected_databases: List of database names to collect tables for
        """
        pulumi.set(__self__, "connection_info", connection_info)
        pulumi.set(__self__, "selected_databases", selected_databases)

    @property
    @pulumi.getter(name="connectionInfo")
    def connection_info(self) -> 'outputs.SqlConnectionInfoResponse':
        """
        Connection information for SQL Server
        """
        return pulumi.get(self, "connection_info")

    @property
    @pulumi.getter(name="selectedDatabases")
    def selected_databases(self) -> Sequence[str]:
        """
        List of database names to collect tables for
        """
        return pulumi.get(self, "selected_databases")


@pulumi.output_type
class GetUserTablesSqlTaskOutputResponse(dict):
    """
    Output of the task that collects user tables for the given list of databases
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "databasesToTables":
            suggest = "databases_to_tables"
        elif key == "validationErrors":
            suggest = "validation_errors"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GetUserTablesSqlTaskOutputResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GetUserTablesSqlTaskOutputResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GetUserTablesSqlTaskOutputResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 databases_to_tables: Mapping[str, Sequence['outputs.DatabaseTableResponse']],
                 id: str,
                 validation_errors: Sequence['outputs.ReportableExceptionResponse']):
        """
        Output of the task that collects user tables for the given list of databases
        :param Mapping[str, Sequence['DatabaseTableResponse']] databases_to_tables: Mapping from database name to list of tables
        :param str id: Result identifier
        :param Sequence['ReportableExceptionResponse'] validation_errors: Validation errors
        """
        pulumi.set(__self__, "databases_to_tables", databases_to_tables)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "validation_errors", validation_errors)

    @property
    @pulumi.getter(name="databasesToTables")
    def databases_to_tables(self) -> Mapping[str, Sequence['outputs.DatabaseTableResponse']]:
        """
        Mapping from database name to list of tables
        """
        return pulumi.get(self, "databases_to_tables")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Result identifier
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="validationErrors")
    def validation_errors(self) -> Sequence['outputs.ReportableExceptionResponse']:
        """
        Validation errors
        """
        return pulumi.get(self, "validation_errors")


@pulumi.output_type
class GetUserTablesSqlTaskPropertiesResponse(dict):
    """
    Properties for the task that collects user tables for the given list of databases
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "taskType":
            suggest = "task_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GetUserTablesSqlTaskPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GetUserTablesSqlTaskPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GetUserTablesSqlTaskPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 errors: Sequence['outputs.ODataErrorResponse'],
                 output: Sequence['outputs.GetUserTablesSqlTaskOutputResponse'],
                 state: str,
                 task_type: str,
                 input: Optional['outputs.GetUserTablesSqlTaskInputResponse'] = None):
        """
        Properties for the task that collects user tables for the given list of databases
        :param Sequence['ODataErrorResponse'] errors: Array of errors. This is ignored if submitted.
        :param Sequence['GetUserTablesSqlTaskOutputResponse'] output: Task output. This is ignored if submitted.
        :param str state: The state of the task. This is ignored if submitted.
        :param str task_type: Task type.
               Expected value is 'GetUserTables.Sql'.
        :param 'GetUserTablesSqlTaskInputResponse' input: Task input
        """
        pulumi.set(__self__, "errors", errors)
        pulumi.set(__self__, "output", output)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "task_type", 'GetUserTables.Sql')
        if input is not None:
            pulumi.set(__self__, "input", input)

    @property
    @pulumi.getter
    def errors(self) -> Sequence['outputs.ODataErrorResponse']:
        """
        Array of errors. This is ignored if submitted.
        """
        return pulumi.get(self, "errors")

    @property
    @pulumi.getter
    def output(self) -> Sequence['outputs.GetUserTablesSqlTaskOutputResponse']:
        """
        Task output. This is ignored if submitted.
        """
        return pulumi.get(self, "output")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The state of the task. This is ignored if submitted.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> str:
        """
        Task type.
        Expected value is 'GetUserTables.Sql'.
        """
        return pulumi.get(self, "task_type")

    @property
    @pulumi.getter
    def input(self) -> Optional['outputs.GetUserTablesSqlTaskInputResponse']:
        """
        Task input
        """
        return pulumi.get(self, "input")


@pulumi.output_type
class MigrateSqlServerSqlDbDatabaseInputResponse(dict):
    """
    Database specific information for SQL to Azure SQL DB migration task inputs
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "makeSourceDbReadOnly":
            suggest = "make_source_db_read_only"
        elif key == "tableMap":
            suggest = "table_map"
        elif key == "targetDatabaseName":
            suggest = "target_database_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MigrateSqlServerSqlDbDatabaseInputResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MigrateSqlServerSqlDbDatabaseInputResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MigrateSqlServerSqlDbDatabaseInputResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 make_source_db_read_only: Optional[bool] = None,
                 name: Optional[str] = None,
                 table_map: Optional[Mapping[str, str]] = None,
                 target_database_name: Optional[str] = None):
        """
        Database specific information for SQL to Azure SQL DB migration task inputs
        :param bool make_source_db_read_only: Whether to set database read only before migration
        :param str name: Name of the database
        :param Mapping[str, str] table_map: Mapping of source to target tables
        :param str target_database_name: Name of target database. Note: Target database will be truncated before starting migration.
        """
        if make_source_db_read_only is not None:
            pulumi.set(__self__, "make_source_db_read_only", make_source_db_read_only)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if table_map is not None:
            pulumi.set(__self__, "table_map", table_map)
        if target_database_name is not None:
            pulumi.set(__self__, "target_database_name", target_database_name)

    @property
    @pulumi.getter(name="makeSourceDbReadOnly")
    def make_source_db_read_only(self) -> Optional[bool]:
        """
        Whether to set database read only before migration
        """
        return pulumi.get(self, "make_source_db_read_only")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the database
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="tableMap")
    def table_map(self) -> Optional[Mapping[str, str]]:
        """
        Mapping of source to target tables
        """
        return pulumi.get(self, "table_map")

    @property
    @pulumi.getter(name="targetDatabaseName")
    def target_database_name(self) -> Optional[str]:
        """
        Name of target database. Note: Target database will be truncated before starting migration.
        """
        return pulumi.get(self, "target_database_name")


@pulumi.output_type
class MigrateSqlServerSqlDbTaskInputResponse(dict):
    """
    Input for the task that migrates on-prem SQL Server databases to Azure SQL Database
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "selectedDatabases":
            suggest = "selected_databases"
        elif key == "sourceConnectionInfo":
            suggest = "source_connection_info"
        elif key == "targetConnectionInfo":
            suggest = "target_connection_info"
        elif key == "validationOptions":
            suggest = "validation_options"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MigrateSqlServerSqlDbTaskInputResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MigrateSqlServerSqlDbTaskInputResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MigrateSqlServerSqlDbTaskInputResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 selected_databases: Sequence['outputs.MigrateSqlServerSqlDbDatabaseInputResponse'],
                 source_connection_info: 'outputs.SqlConnectionInfoResponse',
                 target_connection_info: 'outputs.SqlConnectionInfoResponse',
                 validation_options: Optional['outputs.MigrationValidationOptionsResponse'] = None):
        """
        Input for the task that migrates on-prem SQL Server databases to Azure SQL Database
        :param Sequence['MigrateSqlServerSqlDbDatabaseInputResponse'] selected_databases: Databases to migrate
        :param 'SqlConnectionInfoResponse' source_connection_info: Information for connecting to source
        :param 'SqlConnectionInfoResponse' target_connection_info: Information for connecting to target
        :param 'MigrationValidationOptionsResponse' validation_options: Options for enabling various post migration validations. Available options, 
                1.) Data Integrity Check: Performs a checksum based comparison on source and target tables after the migration to ensure the correctness of the data. 
                2.) Schema Validation: Performs a thorough schema comparison between the source and target tables and provides a list of differences between the source and target database, 3.) Query Analysis: Executes a set of queries picked up automatically either from the Query Plan Cache or Query Store and execute them and compares the execution time between the source and target database.
        """
        pulumi.set(__self__, "selected_databases", selected_databases)
        pulumi.set(__self__, "source_connection_info", source_connection_info)
        pulumi.set(__self__, "target_connection_info", target_connection_info)
        if validation_options is not None:
            pulumi.set(__self__, "validation_options", validation_options)

    @property
    @pulumi.getter(name="selectedDatabases")
    def selected_databases(self) -> Sequence['outputs.MigrateSqlServerSqlDbDatabaseInputResponse']:
        """
        Databases to migrate
        """
        return pulumi.get(self, "selected_databases")

    @property
    @pulumi.getter(name="sourceConnectionInfo")
    def source_connection_info(self) -> 'outputs.SqlConnectionInfoResponse':
        """
        Information for connecting to source
        """
        return pulumi.get(self, "source_connection_info")

    @property
    @pulumi.getter(name="targetConnectionInfo")
    def target_connection_info(self) -> 'outputs.SqlConnectionInfoResponse':
        """
        Information for connecting to target
        """
        return pulumi.get(self, "target_connection_info")

    @property
    @pulumi.getter(name="validationOptions")
    def validation_options(self) -> Optional['outputs.MigrationValidationOptionsResponse']:
        """
        Options for enabling various post migration validations. Available options, 
         1.) Data Integrity Check: Performs a checksum based comparison on source and target tables after the migration to ensure the correctness of the data. 
         2.) Schema Validation: Performs a thorough schema comparison between the source and target tables and provides a list of differences between the source and target database, 3.) Query Analysis: Executes a set of queries picked up automatically either from the Query Plan Cache or Query Store and execute them and compares the execution time between the source and target database.
        """
        return pulumi.get(self, "validation_options")


@pulumi.output_type
class MigrateSqlServerSqlDbTaskOutputDatabaseLevelResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "databaseName":
            suggest = "database_name"
        elif key == "endedOn":
            suggest = "ended_on"
        elif key == "errorCount":
            suggest = "error_count"
        elif key == "errorPrefix":
            suggest = "error_prefix"
        elif key == "exceptionsAndWarnings":
            suggest = "exceptions_and_warnings"
        elif key == "numberOfObjects":
            suggest = "number_of_objects"
        elif key == "numberOfObjectsCompleted":
            suggest = "number_of_objects_completed"
        elif key == "objectSummary":
            suggest = "object_summary"
        elif key == "resultPrefix":
            suggest = "result_prefix"
        elif key == "resultType":
            suggest = "result_type"
        elif key == "startedOn":
            suggest = "started_on"
        elif key == "statusMessage":
            suggest = "status_message"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MigrateSqlServerSqlDbTaskOutputDatabaseLevelResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MigrateSqlServerSqlDbTaskOutputDatabaseLevelResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MigrateSqlServerSqlDbTaskOutputDatabaseLevelResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 database_name: str,
                 ended_on: str,
                 error_count: float,
                 error_prefix: str,
                 exceptions_and_warnings: Sequence['outputs.ReportableExceptionResponse'],
                 id: str,
                 message: str,
                 number_of_objects: float,
                 number_of_objects_completed: float,
                 object_summary: Mapping[str, 'outputs.DataItemMigrationSummaryResultResponse'],
                 result_prefix: str,
                 result_type: str,
                 stage: str,
                 started_on: str,
                 state: str,
                 status_message: str):
        """
        :param str database_name: Name of the item
        :param str ended_on: Migration end time
        :param float error_count: Number of database/object errors.
        :param str error_prefix: Wildcard string prefix to use for querying all errors of the item
        :param Sequence['ReportableExceptionResponse'] exceptions_and_warnings: Migration exceptions and warnings.
        :param str id: Result identifier
        :param str message: Migration progress message
        :param float number_of_objects: Number of objects
        :param float number_of_objects_completed: Number of successfully completed objects
        :param Mapping[str, 'DataItemMigrationSummaryResultResponse'] object_summary: Summary of object results in the migration
        :param str result_prefix: Wildcard string prefix to use for querying all sub-tem results of the item
        :param str result_type: Result type
               Expected value is 'DatabaseLevelOutput'.
        :param str stage: Migration stage that this database is in
        :param str started_on: Migration start time
        :param str state: Current state of migration
        :param str status_message: Status message
        """
        pulumi.set(__self__, "database_name", database_name)
        pulumi.set(__self__, "ended_on", ended_on)
        pulumi.set(__self__, "error_count", error_count)
        pulumi.set(__self__, "error_prefix", error_prefix)
        pulumi.set(__self__, "exceptions_and_warnings", exceptions_and_warnings)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "number_of_objects", number_of_objects)
        pulumi.set(__self__, "number_of_objects_completed", number_of_objects_completed)
        pulumi.set(__self__, "object_summary", object_summary)
        pulumi.set(__self__, "result_prefix", result_prefix)
        pulumi.set(__self__, "result_type", 'DatabaseLevelOutput')
        pulumi.set(__self__, "stage", stage)
        pulumi.set(__self__, "started_on", started_on)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "status_message", status_message)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> str:
        """
        Name of the item
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter(name="endedOn")
    def ended_on(self) -> str:
        """
        Migration end time
        """
        return pulumi.get(self, "ended_on")

    @property
    @pulumi.getter(name="errorCount")
    def error_count(self) -> float:
        """
        Number of database/object errors.
        """
        return pulumi.get(self, "error_count")

    @property
    @pulumi.getter(name="errorPrefix")
    def error_prefix(self) -> str:
        """
        Wildcard string prefix to use for querying all errors of the item
        """
        return pulumi.get(self, "error_prefix")

    @property
    @pulumi.getter(name="exceptionsAndWarnings")
    def exceptions_and_warnings(self) -> Sequence['outputs.ReportableExceptionResponse']:
        """
        Migration exceptions and warnings.
        """
        return pulumi.get(self, "exceptions_and_warnings")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Result identifier
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        Migration progress message
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter(name="numberOfObjects")
    def number_of_objects(self) -> float:
        """
        Number of objects
        """
        return pulumi.get(self, "number_of_objects")

    @property
    @pulumi.getter(name="numberOfObjectsCompleted")
    def number_of_objects_completed(self) -> float:
        """
        Number of successfully completed objects
        """
        return pulumi.get(self, "number_of_objects_completed")

    @property
    @pulumi.getter(name="objectSummary")
    def object_summary(self) -> Mapping[str, 'outputs.DataItemMigrationSummaryResultResponse']:
        """
        Summary of object results in the migration
        """
        return pulumi.get(self, "object_summary")

    @property
    @pulumi.getter(name="resultPrefix")
    def result_prefix(self) -> str:
        """
        Wildcard string prefix to use for querying all sub-tem results of the item
        """
        return pulumi.get(self, "result_prefix")

    @property
    @pulumi.getter(name="resultType")
    def result_type(self) -> str:
        """
        Result type
        Expected value is 'DatabaseLevelOutput'.
        """
        return pulumi.get(self, "result_type")

    @property
    @pulumi.getter
    def stage(self) -> str:
        """
        Migration stage that this database is in
        """
        return pulumi.get(self, "stage")

    @property
    @pulumi.getter(name="startedOn")
    def started_on(self) -> str:
        """
        Migration start time
        """
        return pulumi.get(self, "started_on")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        Current state of migration
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="statusMessage")
    def status_message(self) -> str:
        """
        Status message
        """
        return pulumi.get(self, "status_message")


@pulumi.output_type
class MigrateSqlServerSqlDbTaskOutputDatabaseLevelValidationResultResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resultType":
            suggest = "result_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MigrateSqlServerSqlDbTaskOutputDatabaseLevelValidationResultResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MigrateSqlServerSqlDbTaskOutputDatabaseLevelValidationResultResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MigrateSqlServerSqlDbTaskOutputDatabaseLevelValidationResultResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: str,
                 result_type: str):
        """
        :param str id: Result identifier
        :param str result_type: Result type
               Expected value is 'MigrationDatabaseLevelValidationOutput'.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "result_type", 'MigrationDatabaseLevelValidationOutput')

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Result identifier
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="resultType")
    def result_type(self) -> str:
        """
        Result type
        Expected value is 'MigrationDatabaseLevelValidationOutput'.
        """
        return pulumi.get(self, "result_type")


@pulumi.output_type
class MigrateSqlServerSqlDbTaskOutputErrorResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resultType":
            suggest = "result_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MigrateSqlServerSqlDbTaskOutputErrorResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MigrateSqlServerSqlDbTaskOutputErrorResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MigrateSqlServerSqlDbTaskOutputErrorResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 error: 'outputs.ReportableExceptionResponse',
                 id: str,
                 result_type: str):
        """
        :param 'ReportableExceptionResponse' error: Migration error
        :param str id: Result identifier
        :param str result_type: Result type
               Expected value is 'ErrorOutput'.
        """
        pulumi.set(__self__, "error", error)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "result_type", 'ErrorOutput')

    @property
    @pulumi.getter
    def error(self) -> 'outputs.ReportableExceptionResponse':
        """
        Migration error
        """
        return pulumi.get(self, "error")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Result identifier
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="resultType")
    def result_type(self) -> str:
        """
        Result type
        Expected value is 'ErrorOutput'.
        """
        return pulumi.get(self, "result_type")


@pulumi.output_type
class MigrateSqlServerSqlDbTaskOutputMigrationLevelResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "databaseSummary":
            suggest = "database_summary"
        elif key == "durationInSeconds":
            suggest = "duration_in_seconds"
        elif key == "endedOn":
            suggest = "ended_on"
        elif key == "exceptionsAndWarnings":
            suggest = "exceptions_and_warnings"
        elif key == "resultType":
            suggest = "result_type"
        elif key == "sourceServerBrandVersion":
            suggest = "source_server_brand_version"
        elif key == "sourceServerVersion":
            suggest = "source_server_version"
        elif key == "startedOn":
            suggest = "started_on"
        elif key == "statusMessage":
            suggest = "status_message"
        elif key == "targetServerBrandVersion":
            suggest = "target_server_brand_version"
        elif key == "targetServerVersion":
            suggest = "target_server_version"
        elif key == "migrationReportResult":
            suggest = "migration_report_result"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MigrateSqlServerSqlDbTaskOutputMigrationLevelResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MigrateSqlServerSqlDbTaskOutputMigrationLevelResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MigrateSqlServerSqlDbTaskOutputMigrationLevelResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 database_summary: Mapping[str, 'outputs.DatabaseSummaryResultResponse'],
                 databases: Mapping[str, str],
                 duration_in_seconds: float,
                 ended_on: str,
                 exceptions_and_warnings: Sequence['outputs.ReportableExceptionResponse'],
                 id: str,
                 message: str,
                 result_type: str,
                 source_server_brand_version: str,
                 source_server_version: str,
                 started_on: str,
                 status: str,
                 status_message: str,
                 target_server_brand_version: str,
                 target_server_version: str,
                 migration_report_result: Optional['outputs.MigrationReportResultResponse'] = None):
        """
        :param Mapping[str, 'DatabaseSummaryResultResponse'] database_summary: Summary of database results in the migration
        :param Mapping[str, str] databases: Selected databases as a map from database name to database id
        :param float duration_in_seconds: Duration of task execution in seconds.
        :param str ended_on: Migration end time
        :param Sequence['ReportableExceptionResponse'] exceptions_and_warnings: Migration exceptions and warnings.
        :param str id: Result identifier
        :param str message: Migration progress message
        :param str result_type: Result type
               Expected value is 'MigrationLevelOutput'.
        :param str source_server_brand_version: Source server brand version
        :param str source_server_version: Source server version
        :param str started_on: Migration start time
        :param str status: Current status of migration
        :param str status_message: Migration status message
        :param str target_server_brand_version: Target server brand version
        :param str target_server_version: Target server version
        :param 'MigrationReportResultResponse' migration_report_result: Migration Report Result, provides unique url for downloading your migration report.
        """
        pulumi.set(__self__, "database_summary", database_summary)
        pulumi.set(__self__, "databases", databases)
        pulumi.set(__self__, "duration_in_seconds", duration_in_seconds)
        pulumi.set(__self__, "ended_on", ended_on)
        pulumi.set(__self__, "exceptions_and_warnings", exceptions_and_warnings)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "result_type", 'MigrationLevelOutput')
        pulumi.set(__self__, "source_server_brand_version", source_server_brand_version)
        pulumi.set(__self__, "source_server_version", source_server_version)
        pulumi.set(__self__, "started_on", started_on)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "status_message", status_message)
        pulumi.set(__self__, "target_server_brand_version", target_server_brand_version)
        pulumi.set(__self__, "target_server_version", target_server_version)
        if migration_report_result is not None:
            pulumi.set(__self__, "migration_report_result", migration_report_result)

    @property
    @pulumi.getter(name="databaseSummary")
    def database_summary(self) -> Mapping[str, 'outputs.DatabaseSummaryResultResponse']:
        """
        Summary of database results in the migration
        """
        return pulumi.get(self, "database_summary")

    @property
    @pulumi.getter
    def databases(self) -> Mapping[str, str]:
        """
        Selected databases as a map from database name to database id
        """
        return pulumi.get(self, "databases")

    @property
    @pulumi.getter(name="durationInSeconds")
    def duration_in_seconds(self) -> float:
        """
        Duration of task execution in seconds.
        """
        return pulumi.get(self, "duration_in_seconds")

    @property
    @pulumi.getter(name="endedOn")
    def ended_on(self) -> str:
        """
        Migration end time
        """
        return pulumi.get(self, "ended_on")

    @property
    @pulumi.getter(name="exceptionsAndWarnings")
    def exceptions_and_warnings(self) -> Sequence['outputs.ReportableExceptionResponse']:
        """
        Migration exceptions and warnings.
        """
        return pulumi.get(self, "exceptions_and_warnings")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Result identifier
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        Migration progress message
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter(name="resultType")
    def result_type(self) -> str:
        """
        Result type
        Expected value is 'MigrationLevelOutput'.
        """
        return pulumi.get(self, "result_type")

    @property
    @pulumi.getter(name="sourceServerBrandVersion")
    def source_server_brand_version(self) -> str:
        """
        Source server brand version
        """
        return pulumi.get(self, "source_server_brand_version")

    @property
    @pulumi.getter(name="sourceServerVersion")
    def source_server_version(self) -> str:
        """
        Source server version
        """
        return pulumi.get(self, "source_server_version")

    @property
    @pulumi.getter(name="startedOn")
    def started_on(self) -> str:
        """
        Migration start time
        """
        return pulumi.get(self, "started_on")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Current status of migration
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="statusMessage")
    def status_message(self) -> str:
        """
        Migration status message
        """
        return pulumi.get(self, "status_message")

    @property
    @pulumi.getter(name="targetServerBrandVersion")
    def target_server_brand_version(self) -> str:
        """
        Target server brand version
        """
        return pulumi.get(self, "target_server_brand_version")

    @property
    @pulumi.getter(name="targetServerVersion")
    def target_server_version(self) -> str:
        """
        Target server version
        """
        return pulumi.get(self, "target_server_version")

    @property
    @pulumi.getter(name="migrationReportResult")
    def migration_report_result(self) -> Optional['outputs.MigrationReportResultResponse']:
        """
        Migration Report Result, provides unique url for downloading your migration report.
        """
        return pulumi.get(self, "migration_report_result")


@pulumi.output_type
class MigrateSqlServerSqlDbTaskOutputTableLevelResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endedOn":
            suggest = "ended_on"
        elif key == "errorPrefix":
            suggest = "error_prefix"
        elif key == "itemsCompletedCount":
            suggest = "items_completed_count"
        elif key == "itemsCount":
            suggest = "items_count"
        elif key == "objectName":
            suggest = "object_name"
        elif key == "resultPrefix":
            suggest = "result_prefix"
        elif key == "resultType":
            suggest = "result_type"
        elif key == "startedOn":
            suggest = "started_on"
        elif key == "statusMessage":
            suggest = "status_message"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MigrateSqlServerSqlDbTaskOutputTableLevelResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MigrateSqlServerSqlDbTaskOutputTableLevelResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MigrateSqlServerSqlDbTaskOutputTableLevelResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ended_on: str,
                 error_prefix: str,
                 id: str,
                 items_completed_count: float,
                 items_count: float,
                 object_name: str,
                 result_prefix: str,
                 result_type: str,
                 started_on: str,
                 state: str,
                 status_message: str):
        """
        :param str ended_on: Migration end time
        :param str error_prefix: Wildcard string prefix to use for querying all errors of the item
        :param str id: Result identifier
        :param float items_completed_count: Number of successfully completed items
        :param float items_count: Number of items
        :param str object_name: Name of the item
        :param str result_prefix: Wildcard string prefix to use for querying all sub-tem results of the item
        :param str result_type: Result type
               Expected value is 'TableLevelOutput'.
        :param str started_on: Migration start time
        :param str state: Current state of migration
        :param str status_message: Status message
        """
        pulumi.set(__self__, "ended_on", ended_on)
        pulumi.set(__self__, "error_prefix", error_prefix)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "items_completed_count", items_completed_count)
        pulumi.set(__self__, "items_count", items_count)
        pulumi.set(__self__, "object_name", object_name)
        pulumi.set(__self__, "result_prefix", result_prefix)
        pulumi.set(__self__, "result_type", 'TableLevelOutput')
        pulumi.set(__self__, "started_on", started_on)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "status_message", status_message)

    @property
    @pulumi.getter(name="endedOn")
    def ended_on(self) -> str:
        """
        Migration end time
        """
        return pulumi.get(self, "ended_on")

    @property
    @pulumi.getter(name="errorPrefix")
    def error_prefix(self) -> str:
        """
        Wildcard string prefix to use for querying all errors of the item
        """
        return pulumi.get(self, "error_prefix")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Result identifier
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="itemsCompletedCount")
    def items_completed_count(self) -> float:
        """
        Number of successfully completed items
        """
        return pulumi.get(self, "items_completed_count")

    @property
    @pulumi.getter(name="itemsCount")
    def items_count(self) -> float:
        """
        Number of items
        """
        return pulumi.get(self, "items_count")

    @property
    @pulumi.getter(name="objectName")
    def object_name(self) -> str:
        """
        Name of the item
        """
        return pulumi.get(self, "object_name")

    @property
    @pulumi.getter(name="resultPrefix")
    def result_prefix(self) -> str:
        """
        Wildcard string prefix to use for querying all sub-tem results of the item
        """
        return pulumi.get(self, "result_prefix")

    @property
    @pulumi.getter(name="resultType")
    def result_type(self) -> str:
        """
        Result type
        Expected value is 'TableLevelOutput'.
        """
        return pulumi.get(self, "result_type")

    @property
    @pulumi.getter(name="startedOn")
    def started_on(self) -> str:
        """
        Migration start time
        """
        return pulumi.get(self, "started_on")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        Current state of migration
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="statusMessage")
    def status_message(self) -> str:
        """
        Status message
        """
        return pulumi.get(self, "status_message")


@pulumi.output_type
class MigrateSqlServerSqlDbTaskOutputValidationResultResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resultType":
            suggest = "result_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MigrateSqlServerSqlDbTaskOutputValidationResultResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MigrateSqlServerSqlDbTaskOutputValidationResultResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MigrateSqlServerSqlDbTaskOutputValidationResultResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: str,
                 result_type: str):
        """
        :param str id: Result identifier
        :param str result_type: Result type
               Expected value is 'MigrationValidationOutput'.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "result_type", 'MigrationValidationOutput')

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Result identifier
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="resultType")
    def result_type(self) -> str:
        """
        Result type
        Expected value is 'MigrationValidationOutput'.
        """
        return pulumi.get(self, "result_type")


@pulumi.output_type
class MigrateSqlServerSqlDbTaskPropertiesResponse(dict):
    """
    Properties for the task that migrates on-prem SQL Server databases to Azure SQL Database
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "taskType":
            suggest = "task_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MigrateSqlServerSqlDbTaskPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MigrateSqlServerSqlDbTaskPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MigrateSqlServerSqlDbTaskPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 errors: Sequence['outputs.ODataErrorResponse'],
                 output: Sequence[Any],
                 state: str,
                 task_type: str,
                 input: Optional['outputs.MigrateSqlServerSqlDbTaskInputResponse'] = None):
        """
        Properties for the task that migrates on-prem SQL Server databases to Azure SQL Database
        :param Sequence['ODataErrorResponse'] errors: Array of errors. This is ignored if submitted.
        :param Sequence[Union['MigrateSqlServerSqlDbTaskOutputDatabaseLevelResponse', 'MigrateSqlServerSqlDbTaskOutputDatabaseLevelValidationResultResponse', 'MigrateSqlServerSqlDbTaskOutputErrorResponse', 'MigrateSqlServerSqlDbTaskOutputMigrationLevelResponse', 'MigrateSqlServerSqlDbTaskOutputTableLevelResponse', 'MigrateSqlServerSqlDbTaskOutputValidationResultResponse']] output: Task output. This is ignored if submitted.
        :param str state: The state of the task. This is ignored if submitted.
        :param str task_type: Task type.
               Expected value is 'Migrate.SqlServer.SqlDb'.
        :param 'MigrateSqlServerSqlDbTaskInputResponse' input: Task input
        """
        pulumi.set(__self__, "errors", errors)
        pulumi.set(__self__, "output", output)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "task_type", 'Migrate.SqlServer.SqlDb')
        if input is not None:
            pulumi.set(__self__, "input", input)

    @property
    @pulumi.getter
    def errors(self) -> Sequence['outputs.ODataErrorResponse']:
        """
        Array of errors. This is ignored if submitted.
        """
        return pulumi.get(self, "errors")

    @property
    @pulumi.getter
    def output(self) -> Sequence[Any]:
        """
        Task output. This is ignored if submitted.
        """
        return pulumi.get(self, "output")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The state of the task. This is ignored if submitted.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> str:
        """
        Task type.
        Expected value is 'Migrate.SqlServer.SqlDb'.
        """
        return pulumi.get(self, "task_type")

    @property
    @pulumi.getter
    def input(self) -> Optional['outputs.MigrateSqlServerSqlDbTaskInputResponse']:
        """
        Task input
        """
        return pulumi.get(self, "input")


@pulumi.output_type
class MigrateSqlServerSqlMIDatabaseInputResponse(dict):
    """
    Database specific information for SQL to Azure SQL DB Managed Instance migration task inputs
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "restoreDatabaseName":
            suggest = "restore_database_name"
        elif key == "backupFileShare":
            suggest = "backup_file_share"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MigrateSqlServerSqlMIDatabaseInputResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MigrateSqlServerSqlMIDatabaseInputResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MigrateSqlServerSqlMIDatabaseInputResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 restore_database_name: str,
                 backup_file_share: Optional['outputs.FileShareResponse'] = None):
        """
        Database specific information for SQL to Azure SQL DB Managed Instance migration task inputs
        :param str name: Name of the database
        :param str restore_database_name: Name of the database at destination
        :param 'FileShareResponse' backup_file_share: Backup file share information for backing up this database.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "restore_database_name", restore_database_name)
        if backup_file_share is not None:
            pulumi.set(__self__, "backup_file_share", backup_file_share)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the database
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="restoreDatabaseName")
    def restore_database_name(self) -> str:
        """
        Name of the database at destination
        """
        return pulumi.get(self, "restore_database_name")

    @property
    @pulumi.getter(name="backupFileShare")
    def backup_file_share(self) -> Optional['outputs.FileShareResponse']:
        """
        Backup file share information for backing up this database.
        """
        return pulumi.get(self, "backup_file_share")


@pulumi.output_type
class MigrateSqlServerSqlMITaskInputResponse(dict):
    """
    Input for task that migrates SQL Server databases to Azure SQL Database Managed Instance.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backupBlobShare":
            suggest = "backup_blob_share"
        elif key == "selectedDatabases":
            suggest = "selected_databases"
        elif key == "sourceConnectionInfo":
            suggest = "source_connection_info"
        elif key == "targetConnectionInfo":
            suggest = "target_connection_info"
        elif key == "backupFileShare":
            suggest = "backup_file_share"
        elif key == "selectedAgentJobs":
            suggest = "selected_agent_jobs"
        elif key == "selectedLogins":
            suggest = "selected_logins"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MigrateSqlServerSqlMITaskInputResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MigrateSqlServerSqlMITaskInputResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MigrateSqlServerSqlMITaskInputResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backup_blob_share: 'outputs.BlobShareResponse',
                 selected_databases: Sequence['outputs.MigrateSqlServerSqlMIDatabaseInputResponse'],
                 source_connection_info: 'outputs.SqlConnectionInfoResponse',
                 target_connection_info: 'outputs.SqlConnectionInfoResponse',
                 backup_file_share: Optional['outputs.FileShareResponse'] = None,
                 selected_agent_jobs: Optional[Sequence[str]] = None,
                 selected_logins: Optional[Sequence[str]] = None):
        """
        Input for task that migrates SQL Server databases to Azure SQL Database Managed Instance.
        :param 'BlobShareResponse' backup_blob_share: SAS URI of Azure Storage Account Container to be used for storing backup files.
        :param Sequence['MigrateSqlServerSqlMIDatabaseInputResponse'] selected_databases: Databases to migrate
        :param 'SqlConnectionInfoResponse' source_connection_info: Information for connecting to source
        :param 'SqlConnectionInfoResponse' target_connection_info: Information for connecting to target
        :param 'FileShareResponse' backup_file_share: Backup file share information for all selected databases.
        :param Sequence[str] selected_agent_jobs: Agent Jobs to migrate.
        :param Sequence[str] selected_logins: Logins to migrate.
        """
        pulumi.set(__self__, "backup_blob_share", backup_blob_share)
        pulumi.set(__self__, "selected_databases", selected_databases)
        pulumi.set(__self__, "source_connection_info", source_connection_info)
        pulumi.set(__self__, "target_connection_info", target_connection_info)
        if backup_file_share is not None:
            pulumi.set(__self__, "backup_file_share", backup_file_share)
        if selected_agent_jobs is not None:
            pulumi.set(__self__, "selected_agent_jobs", selected_agent_jobs)
        if selected_logins is not None:
            pulumi.set(__self__, "selected_logins", selected_logins)

    @property
    @pulumi.getter(name="backupBlobShare")
    def backup_blob_share(self) -> 'outputs.BlobShareResponse':
        """
        SAS URI of Azure Storage Account Container to be used for storing backup files.
        """
        return pulumi.get(self, "backup_blob_share")

    @property
    @pulumi.getter(name="selectedDatabases")
    def selected_databases(self) -> Sequence['outputs.MigrateSqlServerSqlMIDatabaseInputResponse']:
        """
        Databases to migrate
        """
        return pulumi.get(self, "selected_databases")

    @property
    @pulumi.getter(name="sourceConnectionInfo")
    def source_connection_info(self) -> 'outputs.SqlConnectionInfoResponse':
        """
        Information for connecting to source
        """
        return pulumi.get(self, "source_connection_info")

    @property
    @pulumi.getter(name="targetConnectionInfo")
    def target_connection_info(self) -> 'outputs.SqlConnectionInfoResponse':
        """
        Information for connecting to target
        """
        return pulumi.get(self, "target_connection_info")

    @property
    @pulumi.getter(name="backupFileShare")
    def backup_file_share(self) -> Optional['outputs.FileShareResponse']:
        """
        Backup file share information for all selected databases.
        """
        return pulumi.get(self, "backup_file_share")

    @property
    @pulumi.getter(name="selectedAgentJobs")
    def selected_agent_jobs(self) -> Optional[Sequence[str]]:
        """
        Agent Jobs to migrate.
        """
        return pulumi.get(self, "selected_agent_jobs")

    @property
    @pulumi.getter(name="selectedLogins")
    def selected_logins(self) -> Optional[Sequence[str]]:
        """
        Logins to migrate.
        """
        return pulumi.get(self, "selected_logins")


@pulumi.output_type
class MigrateSqlServerSqlMITaskOutputAgentJobLevelResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endedOn":
            suggest = "ended_on"
        elif key == "exceptionsAndWarnings":
            suggest = "exceptions_and_warnings"
        elif key == "isEnabled":
            suggest = "is_enabled"
        elif key == "resultType":
            suggest = "result_type"
        elif key == "startedOn":
            suggest = "started_on"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MigrateSqlServerSqlMITaskOutputAgentJobLevelResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MigrateSqlServerSqlMITaskOutputAgentJobLevelResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MigrateSqlServerSqlMITaskOutputAgentJobLevelResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ended_on: str,
                 exceptions_and_warnings: Sequence['outputs.ReportableExceptionResponse'],
                 id: str,
                 is_enabled: bool,
                 message: str,
                 name: str,
                 result_type: str,
                 started_on: str,
                 state: str):
        """
        :param str ended_on: Migration end time
        :param Sequence['ReportableExceptionResponse'] exceptions_and_warnings: Migration errors and warnings per job
        :param str id: Result identifier
        :param bool is_enabled: The state of the original AgentJob.
        :param str message: Migration progress message
        :param str name: AgentJob name.
        :param str result_type: Result type
               Expected value is 'AgentJobLevelOutput'.
        :param str started_on: Migration start time
        :param str state: Current state of migration
        """
        pulumi.set(__self__, "ended_on", ended_on)
        pulumi.set(__self__, "exceptions_and_warnings", exceptions_and_warnings)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_enabled", is_enabled)
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "result_type", 'AgentJobLevelOutput')
        pulumi.set(__self__, "started_on", started_on)
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="endedOn")
    def ended_on(self) -> str:
        """
        Migration end time
        """
        return pulumi.get(self, "ended_on")

    @property
    @pulumi.getter(name="exceptionsAndWarnings")
    def exceptions_and_warnings(self) -> Sequence['outputs.ReportableExceptionResponse']:
        """
        Migration errors and warnings per job
        """
        return pulumi.get(self, "exceptions_and_warnings")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Result identifier
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> bool:
        """
        The state of the original AgentJob.
        """
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        Migration progress message
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        AgentJob name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="resultType")
    def result_type(self) -> str:
        """
        Result type
        Expected value is 'AgentJobLevelOutput'.
        """
        return pulumi.get(self, "result_type")

    @property
    @pulumi.getter(name="startedOn")
    def started_on(self) -> str:
        """
        Migration start time
        """
        return pulumi.get(self, "started_on")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        Current state of migration
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class MigrateSqlServerSqlMITaskOutputDatabaseLevelResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "databaseName":
            suggest = "database_name"
        elif key == "endedOn":
            suggest = "ended_on"
        elif key == "exceptionsAndWarnings":
            suggest = "exceptions_and_warnings"
        elif key == "resultType":
            suggest = "result_type"
        elif key == "sizeMB":
            suggest = "size_mb"
        elif key == "startedOn":
            suggest = "started_on"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MigrateSqlServerSqlMITaskOutputDatabaseLevelResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MigrateSqlServerSqlMITaskOutputDatabaseLevelResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MigrateSqlServerSqlMITaskOutputDatabaseLevelResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 database_name: str,
                 ended_on: str,
                 exceptions_and_warnings: Sequence['outputs.ReportableExceptionResponse'],
                 id: str,
                 message: str,
                 result_type: str,
                 size_mb: float,
                 stage: str,
                 started_on: str,
                 state: str):
        """
        :param str database_name: Name of the database
        :param str ended_on: Migration end time
        :param Sequence['ReportableExceptionResponse'] exceptions_and_warnings: Migration exceptions and warnings
        :param str id: Result identifier
        :param str message: Migration progress message
        :param str result_type: Result type
               Expected value is 'DatabaseLevelOutput'.
        :param float size_mb: Size of the database in megabytes
        :param str stage: Current stage of migration
        :param str started_on: Migration start time
        :param str state: Current state of migration
        """
        pulumi.set(__self__, "database_name", database_name)
        pulumi.set(__self__, "ended_on", ended_on)
        pulumi.set(__self__, "exceptions_and_warnings", exceptions_and_warnings)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "result_type", 'DatabaseLevelOutput')
        pulumi.set(__self__, "size_mb", size_mb)
        pulumi.set(__self__, "stage", stage)
        pulumi.set(__self__, "started_on", started_on)
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> str:
        """
        Name of the database
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter(name="endedOn")
    def ended_on(self) -> str:
        """
        Migration end time
        """
        return pulumi.get(self, "ended_on")

    @property
    @pulumi.getter(name="exceptionsAndWarnings")
    def exceptions_and_warnings(self) -> Sequence['outputs.ReportableExceptionResponse']:
        """
        Migration exceptions and warnings
        """
        return pulumi.get(self, "exceptions_and_warnings")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Result identifier
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        Migration progress message
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter(name="resultType")
    def result_type(self) -> str:
        """
        Result type
        Expected value is 'DatabaseLevelOutput'.
        """
        return pulumi.get(self, "result_type")

    @property
    @pulumi.getter(name="sizeMB")
    def size_mb(self) -> float:
        """
        Size of the database in megabytes
        """
        return pulumi.get(self, "size_mb")

    @property
    @pulumi.getter
    def stage(self) -> str:
        """
        Current stage of migration
        """
        return pulumi.get(self, "stage")

    @property
    @pulumi.getter(name="startedOn")
    def started_on(self) -> str:
        """
        Migration start time
        """
        return pulumi.get(self, "started_on")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        Current state of migration
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class MigrateSqlServerSqlMITaskOutputErrorResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resultType":
            suggest = "result_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MigrateSqlServerSqlMITaskOutputErrorResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MigrateSqlServerSqlMITaskOutputErrorResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MigrateSqlServerSqlMITaskOutputErrorResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 error: 'outputs.ReportableExceptionResponse',
                 id: str,
                 result_type: str):
        """
        :param 'ReportableExceptionResponse' error: Migration error
        :param str id: Result identifier
        :param str result_type: Result type
               Expected value is 'ErrorOutput'.
        """
        pulumi.set(__self__, "error", error)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "result_type", 'ErrorOutput')

    @property
    @pulumi.getter
    def error(self) -> 'outputs.ReportableExceptionResponse':
        """
        Migration error
        """
        return pulumi.get(self, "error")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Result identifier
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="resultType")
    def result_type(self) -> str:
        """
        Result type
        Expected value is 'ErrorOutput'.
        """
        return pulumi.get(self, "result_type")


@pulumi.output_type
class MigrateSqlServerSqlMITaskOutputLoginLevelResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endedOn":
            suggest = "ended_on"
        elif key == "exceptionsAndWarnings":
            suggest = "exceptions_and_warnings"
        elif key == "loginName":
            suggest = "login_name"
        elif key == "resultType":
            suggest = "result_type"
        elif key == "startedOn":
            suggest = "started_on"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MigrateSqlServerSqlMITaskOutputLoginLevelResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MigrateSqlServerSqlMITaskOutputLoginLevelResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MigrateSqlServerSqlMITaskOutputLoginLevelResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ended_on: str,
                 exceptions_and_warnings: Sequence['outputs.ReportableExceptionResponse'],
                 id: str,
                 login_name: str,
                 message: str,
                 result_type: str,
                 stage: str,
                 started_on: str,
                 state: str):
        """
        :param str ended_on: Login migration end time
        :param Sequence['ReportableExceptionResponse'] exceptions_and_warnings: Login migration errors and warnings per login
        :param str id: Result identifier
        :param str login_name: Login name.
        :param str message: Login migration progress message
        :param str result_type: Result type
               Expected value is 'LoginLevelOutput'.
        :param str stage: Current stage of login
        :param str started_on: Login migration start time
        :param str state: Current state of login
        """
        pulumi.set(__self__, "ended_on", ended_on)
        pulumi.set(__self__, "exceptions_and_warnings", exceptions_and_warnings)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "login_name", login_name)
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "result_type", 'LoginLevelOutput')
        pulumi.set(__self__, "stage", stage)
        pulumi.set(__self__, "started_on", started_on)
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="endedOn")
    def ended_on(self) -> str:
        """
        Login migration end time
        """
        return pulumi.get(self, "ended_on")

    @property
    @pulumi.getter(name="exceptionsAndWarnings")
    def exceptions_and_warnings(self) -> Sequence['outputs.ReportableExceptionResponse']:
        """
        Login migration errors and warnings per login
        """
        return pulumi.get(self, "exceptions_and_warnings")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Result identifier
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="loginName")
    def login_name(self) -> str:
        """
        Login name.
        """
        return pulumi.get(self, "login_name")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        Login migration progress message
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter(name="resultType")
    def result_type(self) -> str:
        """
        Result type
        Expected value is 'LoginLevelOutput'.
        """
        return pulumi.get(self, "result_type")

    @property
    @pulumi.getter
    def stage(self) -> str:
        """
        Current stage of login
        """
        return pulumi.get(self, "stage")

    @property
    @pulumi.getter(name="startedOn")
    def started_on(self) -> str:
        """
        Login migration start time
        """
        return pulumi.get(self, "started_on")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        Current state of login
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class MigrateSqlServerSqlMITaskOutputMigrationLevelResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "agentJobs":
            suggest = "agent_jobs"
        elif key == "endedOn":
            suggest = "ended_on"
        elif key == "exceptionsAndWarnings":
            suggest = "exceptions_and_warnings"
        elif key == "orphanedUsers":
            suggest = "orphaned_users"
        elif key == "resultType":
            suggest = "result_type"
        elif key == "serverRoleResults":
            suggest = "server_role_results"
        elif key == "sourceServerBrandVersion":
            suggest = "source_server_brand_version"
        elif key == "sourceServerVersion":
            suggest = "source_server_version"
        elif key == "startedOn":
            suggest = "started_on"
        elif key == "targetServerBrandVersion":
            suggest = "target_server_brand_version"
        elif key == "targetServerVersion":
            suggest = "target_server_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MigrateSqlServerSqlMITaskOutputMigrationLevelResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MigrateSqlServerSqlMITaskOutputMigrationLevelResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MigrateSqlServerSqlMITaskOutputMigrationLevelResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 agent_jobs: Mapping[str, str],
                 databases: Mapping[str, str],
                 ended_on: str,
                 exceptions_and_warnings: Sequence['outputs.ReportableExceptionResponse'],
                 id: str,
                 logins: Mapping[str, str],
                 message: str,
                 orphaned_users: Mapping[str, str],
                 result_type: str,
                 server_role_results: Mapping[str, 'outputs.StartMigrationScenarioServerRoleResultResponse'],
                 source_server_brand_version: str,
                 source_server_version: str,
                 started_on: str,
                 state: str,
                 status: str,
                 target_server_brand_version: str,
                 target_server_version: str):
        """
        :param Mapping[str, str] agent_jobs: Selected agent jobs as a map from name to id
        :param Mapping[str, str] databases: Selected databases as a map from database name to database id
        :param str ended_on: Migration end time
        :param Sequence['ReportableExceptionResponse'] exceptions_and_warnings: Migration exceptions and warnings.
        :param str id: Result identifier
        :param Mapping[str, str] logins: Selected logins as a map from name to id
        :param str message: Migration progress message
        :param Mapping[str, str] orphaned_users: Map of users to database name of orphaned users.
        :param str result_type: Result type
               Expected value is 'MigrationLevelOutput'.
        :param Mapping[str, 'StartMigrationScenarioServerRoleResultResponse'] server_role_results: Map of server role migration results.
        :param str source_server_brand_version: Source server brand version
        :param str source_server_version: Source server version
        :param str started_on: Migration start time
        :param str state: Current state of migration
        :param str status: Current status of migration
        :param str target_server_brand_version: Target server brand version
        :param str target_server_version: Target server version
        """
        pulumi.set(__self__, "agent_jobs", agent_jobs)
        pulumi.set(__self__, "databases", databases)
        pulumi.set(__self__, "ended_on", ended_on)
        pulumi.set(__self__, "exceptions_and_warnings", exceptions_and_warnings)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "logins", logins)
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "orphaned_users", orphaned_users)
        pulumi.set(__self__, "result_type", 'MigrationLevelOutput')
        pulumi.set(__self__, "server_role_results", server_role_results)
        pulumi.set(__self__, "source_server_brand_version", source_server_brand_version)
        pulumi.set(__self__, "source_server_version", source_server_version)
        pulumi.set(__self__, "started_on", started_on)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "target_server_brand_version", target_server_brand_version)
        pulumi.set(__self__, "target_server_version", target_server_version)

    @property
    @pulumi.getter(name="agentJobs")
    def agent_jobs(self) -> Mapping[str, str]:
        """
        Selected agent jobs as a map from name to id
        """
        return pulumi.get(self, "agent_jobs")

    @property
    @pulumi.getter
    def databases(self) -> Mapping[str, str]:
        """
        Selected databases as a map from database name to database id
        """
        return pulumi.get(self, "databases")

    @property
    @pulumi.getter(name="endedOn")
    def ended_on(self) -> str:
        """
        Migration end time
        """
        return pulumi.get(self, "ended_on")

    @property
    @pulumi.getter(name="exceptionsAndWarnings")
    def exceptions_and_warnings(self) -> Sequence['outputs.ReportableExceptionResponse']:
        """
        Migration exceptions and warnings.
        """
        return pulumi.get(self, "exceptions_and_warnings")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Result identifier
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def logins(self) -> Mapping[str, str]:
        """
        Selected logins as a map from name to id
        """
        return pulumi.get(self, "logins")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        Migration progress message
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter(name="orphanedUsers")
    def orphaned_users(self) -> Mapping[str, str]:
        """
        Map of users to database name of orphaned users.
        """
        return pulumi.get(self, "orphaned_users")

    @property
    @pulumi.getter(name="resultType")
    def result_type(self) -> str:
        """
        Result type
        Expected value is 'MigrationLevelOutput'.
        """
        return pulumi.get(self, "result_type")

    @property
    @pulumi.getter(name="serverRoleResults")
    def server_role_results(self) -> Mapping[str, 'outputs.StartMigrationScenarioServerRoleResultResponse']:
        """
        Map of server role migration results.
        """
        return pulumi.get(self, "server_role_results")

    @property
    @pulumi.getter(name="sourceServerBrandVersion")
    def source_server_brand_version(self) -> str:
        """
        Source server brand version
        """
        return pulumi.get(self, "source_server_brand_version")

    @property
    @pulumi.getter(name="sourceServerVersion")
    def source_server_version(self) -> str:
        """
        Source server version
        """
        return pulumi.get(self, "source_server_version")

    @property
    @pulumi.getter(name="startedOn")
    def started_on(self) -> str:
        """
        Migration start time
        """
        return pulumi.get(self, "started_on")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        Current state of migration
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Current status of migration
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="targetServerBrandVersion")
    def target_server_brand_version(self) -> str:
        """
        Target server brand version
        """
        return pulumi.get(self, "target_server_brand_version")

    @property
    @pulumi.getter(name="targetServerVersion")
    def target_server_version(self) -> str:
        """
        Target server version
        """
        return pulumi.get(self, "target_server_version")


@pulumi.output_type
class MigrateSqlServerSqlMITaskPropertiesResponse(dict):
    """
    Properties for task that migrates SQL Server databases to Azure SQL Database Managed Instance
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "taskType":
            suggest = "task_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MigrateSqlServerSqlMITaskPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MigrateSqlServerSqlMITaskPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MigrateSqlServerSqlMITaskPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 errors: Sequence['outputs.ODataErrorResponse'],
                 output: Sequence[Any],
                 state: str,
                 task_type: str,
                 input: Optional['outputs.MigrateSqlServerSqlMITaskInputResponse'] = None):
        """
        Properties for task that migrates SQL Server databases to Azure SQL Database Managed Instance
        :param Sequence['ODataErrorResponse'] errors: Array of errors. This is ignored if submitted.
        :param Sequence[Union['MigrateSqlServerSqlMITaskOutputAgentJobLevelResponse', 'MigrateSqlServerSqlMITaskOutputDatabaseLevelResponse', 'MigrateSqlServerSqlMITaskOutputErrorResponse', 'MigrateSqlServerSqlMITaskOutputLoginLevelResponse', 'MigrateSqlServerSqlMITaskOutputMigrationLevelResponse']] output: Task output. This is ignored if submitted.
        :param str state: The state of the task. This is ignored if submitted.
        :param str task_type: Task type.
               Expected value is 'Migrate.SqlServer.AzureSqlDbMI'.
        :param 'MigrateSqlServerSqlMITaskInputResponse' input: Task input
        """
        pulumi.set(__self__, "errors", errors)
        pulumi.set(__self__, "output", output)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "task_type", 'Migrate.SqlServer.AzureSqlDbMI')
        if input is not None:
            pulumi.set(__self__, "input", input)

    @property
    @pulumi.getter
    def errors(self) -> Sequence['outputs.ODataErrorResponse']:
        """
        Array of errors. This is ignored if submitted.
        """
        return pulumi.get(self, "errors")

    @property
    @pulumi.getter
    def output(self) -> Sequence[Any]:
        """
        Task output. This is ignored if submitted.
        """
        return pulumi.get(self, "output")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The state of the task. This is ignored if submitted.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> str:
        """
        Task type.
        Expected value is 'Migrate.SqlServer.AzureSqlDbMI'.
        """
        return pulumi.get(self, "task_type")

    @property
    @pulumi.getter
    def input(self) -> Optional['outputs.MigrateSqlServerSqlMITaskInputResponse']:
        """
        Task input
        """
        return pulumi.get(self, "input")


@pulumi.output_type
class MigrationEligibilityInfoResponse(dict):
    """
    Information about migration eligibility of a server object
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isEligibleForMigration":
            suggest = "is_eligible_for_migration"
        elif key == "validationMessages":
            suggest = "validation_messages"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MigrationEligibilityInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MigrationEligibilityInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MigrationEligibilityInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 is_eligible_for_migration: bool,
                 validation_messages: Sequence[str]):
        """
        Information about migration eligibility of a server object
        :param bool is_eligible_for_migration: Whether object is eligible for migration or not.
        :param Sequence[str] validation_messages: Information about eligibility failure for the server object.
        """
        pulumi.set(__self__, "is_eligible_for_migration", is_eligible_for_migration)
        pulumi.set(__self__, "validation_messages", validation_messages)

    @property
    @pulumi.getter(name="isEligibleForMigration")
    def is_eligible_for_migration(self) -> bool:
        """
        Whether object is eligible for migration or not.
        """
        return pulumi.get(self, "is_eligible_for_migration")

    @property
    @pulumi.getter(name="validationMessages")
    def validation_messages(self) -> Sequence[str]:
        """
        Information about eligibility failure for the server object.
        """
        return pulumi.get(self, "validation_messages")


@pulumi.output_type
class MigrationReportResultResponse(dict):
    """
    Migration validation report result, contains the url for downloading the generated report.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "reportUrl":
            suggest = "report_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MigrationReportResultResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MigrationReportResultResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MigrationReportResultResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: Optional[str] = None,
                 report_url: Optional[str] = None):
        """
        Migration validation report result, contains the url for downloading the generated report.
        :param str id: Migration validation result identifier
        :param str report_url: The url of the report.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if report_url is not None:
            pulumi.set(__self__, "report_url", report_url)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Migration validation result identifier
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="reportUrl")
    def report_url(self) -> Optional[str]:
        """
        The url of the report.
        """
        return pulumi.get(self, "report_url")


@pulumi.output_type
class MigrationValidationOptionsResponse(dict):
    """
    Types of validations to run after the migration
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enableDataIntegrityValidation":
            suggest = "enable_data_integrity_validation"
        elif key == "enableQueryAnalysisValidation":
            suggest = "enable_query_analysis_validation"
        elif key == "enableSchemaValidation":
            suggest = "enable_schema_validation"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MigrationValidationOptionsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MigrationValidationOptionsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MigrationValidationOptionsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable_data_integrity_validation: Optional[bool] = None,
                 enable_query_analysis_validation: Optional[bool] = None,
                 enable_schema_validation: Optional[bool] = None):
        """
        Types of validations to run after the migration
        :param bool enable_data_integrity_validation: Allows to perform a checksum based data integrity validation between source and target for the selected database / tables .
        :param bool enable_query_analysis_validation: Allows to perform a quick and intelligent query analysis by retrieving queries from the source database and executes them in the target. The result will have execution statistics for executions in source and target databases for the extracted queries.
        :param bool enable_schema_validation: Allows to compare the schema information between source and target.
        """
        if enable_data_integrity_validation is not None:
            pulumi.set(__self__, "enable_data_integrity_validation", enable_data_integrity_validation)
        if enable_query_analysis_validation is not None:
            pulumi.set(__self__, "enable_query_analysis_validation", enable_query_analysis_validation)
        if enable_schema_validation is not None:
            pulumi.set(__self__, "enable_schema_validation", enable_schema_validation)

    @property
    @pulumi.getter(name="enableDataIntegrityValidation")
    def enable_data_integrity_validation(self) -> Optional[bool]:
        """
        Allows to perform a checksum based data integrity validation between source and target for the selected database / tables .
        """
        return pulumi.get(self, "enable_data_integrity_validation")

    @property
    @pulumi.getter(name="enableQueryAnalysisValidation")
    def enable_query_analysis_validation(self) -> Optional[bool]:
        """
        Allows to perform a quick and intelligent query analysis by retrieving queries from the source database and executes them in the target. The result will have execution statistics for executions in source and target databases for the extracted queries.
        """
        return pulumi.get(self, "enable_query_analysis_validation")

    @property
    @pulumi.getter(name="enableSchemaValidation")
    def enable_schema_validation(self) -> Optional[bool]:
        """
        Allows to compare the schema information between source and target.
        """
        return pulumi.get(self, "enable_schema_validation")


@pulumi.output_type
class ODataErrorResponse(dict):
    """
    Error information in OData format.
    """
    def __init__(__self__, *,
                 code: Optional[str] = None,
                 details: Optional[Sequence['outputs.ODataErrorResponse']] = None,
                 message: Optional[str] = None):
        """
        Error information in OData format.
        :param str code: The machine-readable description of the error, such as 'InvalidRequest' or 'InternalServerError'
        :param Sequence['ODataErrorResponse'] details: Inner errors that caused this error
        :param str message: The human-readable description of the error
        """
        if code is not None:
            pulumi.set(__self__, "code", code)
        if details is not None:
            pulumi.set(__self__, "details", details)
        if message is not None:
            pulumi.set(__self__, "message", message)

    @property
    @pulumi.getter
    def code(self) -> Optional[str]:
        """
        The machine-readable description of the error, such as 'InvalidRequest' or 'InternalServerError'
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def details(self) -> Optional[Sequence['outputs.ODataErrorResponse']]:
        """
        Inner errors that caused this error
        """
        return pulumi.get(self, "details")

    @property
    @pulumi.getter
    def message(self) -> Optional[str]:
        """
        The human-readable description of the error
        """
        return pulumi.get(self, "message")


@pulumi.output_type
class ReportableExceptionResponse(dict):
    """
    Exception object for all custom exceptions
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "filePath":
            suggest = "file_path"
        elif key == "hResult":
            suggest = "h_result"
        elif key == "lineNumber":
            suggest = "line_number"
        elif key == "stackTrace":
            suggest = "stack_trace"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ReportableExceptionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ReportableExceptionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ReportableExceptionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 file_path: Optional[str] = None,
                 h_result: Optional[int] = None,
                 line_number: Optional[str] = None,
                 message: Optional[str] = None,
                 stack_trace: Optional[str] = None):
        """
        Exception object for all custom exceptions
        :param str file_path: The path to the file where exception occurred
        :param int h_result: Coded numerical value that is assigned to a specific exception
        :param str line_number: The line number where exception occurred
        :param str message: Error message
        :param str stack_trace: Stack trace
        """
        if file_path is not None:
            pulumi.set(__self__, "file_path", file_path)
        if h_result is not None:
            pulumi.set(__self__, "h_result", h_result)
        if line_number is not None:
            pulumi.set(__self__, "line_number", line_number)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if stack_trace is not None:
            pulumi.set(__self__, "stack_trace", stack_trace)

    @property
    @pulumi.getter(name="filePath")
    def file_path(self) -> Optional[str]:
        """
        The path to the file where exception occurred
        """
        return pulumi.get(self, "file_path")

    @property
    @pulumi.getter(name="hResult")
    def h_result(self) -> Optional[int]:
        """
        Coded numerical value that is assigned to a specific exception
        """
        return pulumi.get(self, "h_result")

    @property
    @pulumi.getter(name="lineNumber")
    def line_number(self) -> Optional[str]:
        """
        The line number where exception occurred
        """
        return pulumi.get(self, "line_number")

    @property
    @pulumi.getter
    def message(self) -> Optional[str]:
        """
        Error message
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter(name="stackTrace")
    def stack_trace(self) -> Optional[str]:
        """
        Stack trace
        """
        return pulumi.get(self, "stack_trace")


@pulumi.output_type
class ServiceSkuResponse(dict):
    """
    An Azure SKU instance
    """
    def __init__(__self__, *,
                 capacity: Optional[int] = None,
                 family: Optional[str] = None,
                 name: Optional[str] = None,
                 size: Optional[str] = None,
                 tier: Optional[str] = None):
        """
        An Azure SKU instance
        :param int capacity: The capacity of the SKU, if it supports scaling
        :param str family: The SKU family, used when the service has multiple performance classes within a tier, such as 'A', 'D', etc. for virtual machines
        :param str name: The unique name of the SKU, such as 'P3'
        :param str size: The size of the SKU, used when the name alone does not denote a service size or when a SKU has multiple performance classes within a family, e.g. 'A1' for virtual machines
        :param str tier: The tier of the SKU, such as 'Free', 'Basic', 'Standard', or 'Premium'
        """
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if family is not None:
            pulumi.set(__self__, "family", family)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if tier is not None:
            pulumi.set(__self__, "tier", tier)

    @property
    @pulumi.getter
    def capacity(self) -> Optional[int]:
        """
        The capacity of the SKU, if it supports scaling
        """
        return pulumi.get(self, "capacity")

    @property
    @pulumi.getter
    def family(self) -> Optional[str]:
        """
        The SKU family, used when the service has multiple performance classes within a tier, such as 'A', 'D', etc. for virtual machines
        """
        return pulumi.get(self, "family")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The unique name of the SKU, such as 'P3'
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def size(self) -> Optional[str]:
        """
        The size of the SKU, used when the name alone does not denote a service size or when a SKU has multiple performance classes within a family, e.g. 'A1' for virtual machines
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter
    def tier(self) -> Optional[str]:
        """
        The tier of the SKU, such as 'Free', 'Basic', 'Standard', or 'Premium'
        """
        return pulumi.get(self, "tier")


@pulumi.output_type
class SqlConnectionInfoResponse(dict):
    """
    Information for connecting to SQL database server
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataSource":
            suggest = "data_source"
        elif key == "additionalSettings":
            suggest = "additional_settings"
        elif key == "encryptConnection":
            suggest = "encrypt_connection"
        elif key == "trustServerCertificate":
            suggest = "trust_server_certificate"
        elif key == "userName":
            suggest = "user_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SqlConnectionInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SqlConnectionInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SqlConnectionInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_source: str,
                 type: str,
                 additional_settings: Optional[str] = None,
                 authentication: Optional[str] = None,
                 encrypt_connection: Optional[bool] = None,
                 password: Optional[str] = None,
                 trust_server_certificate: Optional[bool] = None,
                 user_name: Optional[str] = None):
        """
        Information for connecting to SQL database server
        :param str data_source: Data source in the format Protocol:MachineName\\SQLServerInstanceName,PortNumber
        :param str type: Type of connection info
               Expected value is 'SqlConnectionInfo'.
        :param str additional_settings: Additional connection settings
        :param str authentication: Authentication type to use for connection
        :param bool encrypt_connection: Whether to encrypt the connection
        :param str password: Password credential.
        :param bool trust_server_certificate: Whether to trust the server certificate
        :param str user_name: User name
        """
        pulumi.set(__self__, "data_source", data_source)
        pulumi.set(__self__, "type", 'SqlConnectionInfo')
        if additional_settings is not None:
            pulumi.set(__self__, "additional_settings", additional_settings)
        if authentication is not None:
            pulumi.set(__self__, "authentication", authentication)
        if encrypt_connection is None:
            encrypt_connection = True
        if encrypt_connection is not None:
            pulumi.set(__self__, "encrypt_connection", encrypt_connection)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if trust_server_certificate is None:
            trust_server_certificate = False
        if trust_server_certificate is not None:
            pulumi.set(__self__, "trust_server_certificate", trust_server_certificate)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)

    @property
    @pulumi.getter(name="dataSource")
    def data_source(self) -> str:
        """
        Data source in the format Protocol:MachineName\\SQLServerInstanceName,PortNumber
        """
        return pulumi.get(self, "data_source")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of connection info
        Expected value is 'SqlConnectionInfo'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="additionalSettings")
    def additional_settings(self) -> Optional[str]:
        """
        Additional connection settings
        """
        return pulumi.get(self, "additional_settings")

    @property
    @pulumi.getter
    def authentication(self) -> Optional[str]:
        """
        Authentication type to use for connection
        """
        return pulumi.get(self, "authentication")

    @property
    @pulumi.getter(name="encryptConnection")
    def encrypt_connection(self) -> Optional[bool]:
        """
        Whether to encrypt the connection
        """
        return pulumi.get(self, "encrypt_connection")

    @property
    @pulumi.getter
    def password(self) -> Optional[str]:
        """
        Password credential.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="trustServerCertificate")
    def trust_server_certificate(self) -> Optional[bool]:
        """
        Whether to trust the server certificate
        """
        return pulumi.get(self, "trust_server_certificate")

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[str]:
        """
        User name
        """
        return pulumi.get(self, "user_name")


@pulumi.output_type
class StartMigrationScenarioServerRoleResultResponse(dict):
    """
    Server role migration result
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "exceptionsAndWarnings":
            suggest = "exceptions_and_warnings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StartMigrationScenarioServerRoleResultResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StartMigrationScenarioServerRoleResultResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StartMigrationScenarioServerRoleResultResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 exceptions_and_warnings: Sequence['outputs.ReportableExceptionResponse'],
                 name: str,
                 state: str):
        """
        Server role migration result
        :param Sequence['ReportableExceptionResponse'] exceptions_and_warnings: Migration exceptions and warnings.
        :param str name: Name of server role.
        :param str state: Current state of migration
        """
        pulumi.set(__self__, "exceptions_and_warnings", exceptions_and_warnings)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="exceptionsAndWarnings")
    def exceptions_and_warnings(self) -> Sequence['outputs.ReportableExceptionResponse']:
        """
        Migration exceptions and warnings.
        """
        return pulumi.get(self, "exceptions_and_warnings")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of server role.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        Current state of migration
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class ValidateMigrationInputSqlServerSqlMITaskInputResponse(dict):
    """
    Input for task that validates migration input for SQL to Azure SQL Managed Instance
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backupBlobShare":
            suggest = "backup_blob_share"
        elif key == "selectedDatabases":
            suggest = "selected_databases"
        elif key == "targetConnectionInfo":
            suggest = "target_connection_info"
        elif key == "backupFileShare":
            suggest = "backup_file_share"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ValidateMigrationInputSqlServerSqlMITaskInputResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ValidateMigrationInputSqlServerSqlMITaskInputResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ValidateMigrationInputSqlServerSqlMITaskInputResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backup_blob_share: 'outputs.BlobShareResponse',
                 selected_databases: Sequence['outputs.MigrateSqlServerSqlMIDatabaseInputResponse'],
                 target_connection_info: 'outputs.SqlConnectionInfoResponse',
                 backup_file_share: Optional['outputs.FileShareResponse'] = None):
        """
        Input for task that validates migration input for SQL to Azure SQL Managed Instance
        :param 'BlobShareResponse' backup_blob_share: SAS URI of Azure Storage Account Container to be used for storing backup files.
        :param Sequence['MigrateSqlServerSqlMIDatabaseInputResponse'] selected_databases: Databases to migrate
        :param 'SqlConnectionInfoResponse' target_connection_info: Information for connecting to target
        :param 'FileShareResponse' backup_file_share: Backup file share information for all selected databases.
        """
        pulumi.set(__self__, "backup_blob_share", backup_blob_share)
        pulumi.set(__self__, "selected_databases", selected_databases)
        pulumi.set(__self__, "target_connection_info", target_connection_info)
        if backup_file_share is not None:
            pulumi.set(__self__, "backup_file_share", backup_file_share)

    @property
    @pulumi.getter(name="backupBlobShare")
    def backup_blob_share(self) -> 'outputs.BlobShareResponse':
        """
        SAS URI of Azure Storage Account Container to be used for storing backup files.
        """
        return pulumi.get(self, "backup_blob_share")

    @property
    @pulumi.getter(name="selectedDatabases")
    def selected_databases(self) -> Sequence['outputs.MigrateSqlServerSqlMIDatabaseInputResponse']:
        """
        Databases to migrate
        """
        return pulumi.get(self, "selected_databases")

    @property
    @pulumi.getter(name="targetConnectionInfo")
    def target_connection_info(self) -> 'outputs.SqlConnectionInfoResponse':
        """
        Information for connecting to target
        """
        return pulumi.get(self, "target_connection_info")

    @property
    @pulumi.getter(name="backupFileShare")
    def backup_file_share(self) -> Optional['outputs.FileShareResponse']:
        """
        Backup file share information for all selected databases.
        """
        return pulumi.get(self, "backup_file_share")


@pulumi.output_type
class ValidateMigrationInputSqlServerSqlMITaskOutputResponse(dict):
    """
    Output for task that validates migration input for SQL to Azure SQL Managed Instance migrations
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backupFolderErrors":
            suggest = "backup_folder_errors"
        elif key == "backupShareCredentialsErrors":
            suggest = "backup_share_credentials_errors"
        elif key == "backupStorageAccountErrors":
            suggest = "backup_storage_account_errors"
        elif key == "restoreDatabaseNameErrors":
            suggest = "restore_database_name_errors"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ValidateMigrationInputSqlServerSqlMITaskOutputResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ValidateMigrationInputSqlServerSqlMITaskOutputResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ValidateMigrationInputSqlServerSqlMITaskOutputResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backup_folder_errors: Sequence['outputs.ReportableExceptionResponse'],
                 backup_share_credentials_errors: Sequence['outputs.ReportableExceptionResponse'],
                 backup_storage_account_errors: Sequence['outputs.ReportableExceptionResponse'],
                 id: str,
                 name: str,
                 restore_database_name_errors: Sequence['outputs.ReportableExceptionResponse']):
        """
        Output for task that validates migration input for SQL to Azure SQL Managed Instance migrations
        :param Sequence['ReportableExceptionResponse'] backup_folder_errors: Errors associated with the BackupFolder path
        :param Sequence['ReportableExceptionResponse'] backup_share_credentials_errors: Errors associated with backup share user name and password credentials
        :param Sequence['ReportableExceptionResponse'] backup_storage_account_errors: Errors associated with the storage account provided.
        :param str id: Result identifier
        :param str name: Name of database
        :param Sequence['ReportableExceptionResponse'] restore_database_name_errors: Errors associated with the RestoreDatabaseName
        """
        pulumi.set(__self__, "backup_folder_errors", backup_folder_errors)
        pulumi.set(__self__, "backup_share_credentials_errors", backup_share_credentials_errors)
        pulumi.set(__self__, "backup_storage_account_errors", backup_storage_account_errors)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "restore_database_name_errors", restore_database_name_errors)

    @property
    @pulumi.getter(name="backupFolderErrors")
    def backup_folder_errors(self) -> Sequence['outputs.ReportableExceptionResponse']:
        """
        Errors associated with the BackupFolder path
        """
        return pulumi.get(self, "backup_folder_errors")

    @property
    @pulumi.getter(name="backupShareCredentialsErrors")
    def backup_share_credentials_errors(self) -> Sequence['outputs.ReportableExceptionResponse']:
        """
        Errors associated with backup share user name and password credentials
        """
        return pulumi.get(self, "backup_share_credentials_errors")

    @property
    @pulumi.getter(name="backupStorageAccountErrors")
    def backup_storage_account_errors(self) -> Sequence['outputs.ReportableExceptionResponse']:
        """
        Errors associated with the storage account provided.
        """
        return pulumi.get(self, "backup_storage_account_errors")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Result identifier
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of database
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="restoreDatabaseNameErrors")
    def restore_database_name_errors(self) -> Sequence['outputs.ReportableExceptionResponse']:
        """
        Errors associated with the RestoreDatabaseName
        """
        return pulumi.get(self, "restore_database_name_errors")


@pulumi.output_type
class ValidateMigrationInputSqlServerSqlMITaskPropertiesResponse(dict):
    """
    Properties for task that validates migration input for SQL to Azure SQL Database Managed Instance
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "taskType":
            suggest = "task_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ValidateMigrationInputSqlServerSqlMITaskPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ValidateMigrationInputSqlServerSqlMITaskPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ValidateMigrationInputSqlServerSqlMITaskPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 errors: Sequence['outputs.ODataErrorResponse'],
                 output: Sequence['outputs.ValidateMigrationInputSqlServerSqlMITaskOutputResponse'],
                 state: str,
                 task_type: str,
                 input: Optional['outputs.ValidateMigrationInputSqlServerSqlMITaskInputResponse'] = None):
        """
        Properties for task that validates migration input for SQL to Azure SQL Database Managed Instance
        :param Sequence['ODataErrorResponse'] errors: Array of errors. This is ignored if submitted.
        :param Sequence['ValidateMigrationInputSqlServerSqlMITaskOutputResponse'] output: Task output. This is ignored if submitted.
        :param str state: The state of the task. This is ignored if submitted.
        :param str task_type: Task type.
               Expected value is 'ValidateMigrationInput.SqlServer.AzureSqlDbMI'.
        :param 'ValidateMigrationInputSqlServerSqlMITaskInputResponse' input: Task input
        """
        pulumi.set(__self__, "errors", errors)
        pulumi.set(__self__, "output", output)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "task_type", 'ValidateMigrationInput.SqlServer.AzureSqlDbMI')
        if input is not None:
            pulumi.set(__self__, "input", input)

    @property
    @pulumi.getter
    def errors(self) -> Sequence['outputs.ODataErrorResponse']:
        """
        Array of errors. This is ignored if submitted.
        """
        return pulumi.get(self, "errors")

    @property
    @pulumi.getter
    def output(self) -> Sequence['outputs.ValidateMigrationInputSqlServerSqlMITaskOutputResponse']:
        """
        Task output. This is ignored if submitted.
        """
        return pulumi.get(self, "output")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The state of the task. This is ignored if submitted.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> str:
        """
        Task type.
        Expected value is 'ValidateMigrationInput.SqlServer.AzureSqlDbMI'.
        """
        return pulumi.get(self, "task_type")

    @property
    @pulumi.getter
    def input(self) -> Optional['outputs.ValidateMigrationInputSqlServerSqlMITaskInputResponse']:
        """
        Task input
        """
        return pulumi.get(self, "input")


