# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AutoShutdownProfileResponse',
    'ConnectionProfileResponse',
    'CredentialsResponse',
    'IdentityResponse',
    'ImageReferenceResponse',
    'LabNetworkProfileResponse',
    'LabPlanNetworkProfileResponse',
    'RecurrencePatternResponse',
    'RosterProfileResponse',
    'SecurityProfileResponse',
    'SkuResponse',
    'SupportInfoResponse',
    'SystemDataResponse',
    'VirtualMachineAdditionalCapabilitiesResponse',
    'VirtualMachineProfileResponse',
]

@pulumi.output_type
class AutoShutdownProfileResponse(dict):
    """
    Profile for how to handle shutting down virtual machines.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "disconnectDelay":
            suggest = "disconnect_delay"
        elif key == "idleDelay":
            suggest = "idle_delay"
        elif key == "noConnectDelay":
            suggest = "no_connect_delay"
        elif key == "shutdownOnDisconnect":
            suggest = "shutdown_on_disconnect"
        elif key == "shutdownOnIdle":
            suggest = "shutdown_on_idle"
        elif key == "shutdownWhenNotConnected":
            suggest = "shutdown_when_not_connected"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AutoShutdownProfileResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AutoShutdownProfileResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AutoShutdownProfileResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disconnect_delay: Optional[str] = None,
                 idle_delay: Optional[str] = None,
                 no_connect_delay: Optional[str] = None,
                 shutdown_on_disconnect: Optional[str] = None,
                 shutdown_on_idle: Optional[str] = None,
                 shutdown_when_not_connected: Optional[str] = None):
        """
        Profile for how to handle shutting down virtual machines.
        :param str disconnect_delay: The amount of time a VM will stay running after a user disconnects if this behavior is enabled.
        :param str idle_delay: The amount of time a VM will idle before it is shutdown if this behavior is enabled.
        :param str no_connect_delay: The amount of time a VM will stay running before it is shutdown if no connection is made and this behavior is enabled.
        :param str shutdown_on_disconnect: Whether shutdown on disconnect is enabled
        :param str shutdown_on_idle: Whether a VM will get shutdown when it has idled for a period of time.
        :param str shutdown_when_not_connected: Whether a VM will get shutdown when it hasn't been connected to after a period of time.
        """
        if disconnect_delay is not None:
            pulumi.set(__self__, "disconnect_delay", disconnect_delay)
        if idle_delay is not None:
            pulumi.set(__self__, "idle_delay", idle_delay)
        if no_connect_delay is not None:
            pulumi.set(__self__, "no_connect_delay", no_connect_delay)
        if shutdown_on_disconnect is None:
            shutdown_on_disconnect = 'Disabled'
        if shutdown_on_disconnect is not None:
            pulumi.set(__self__, "shutdown_on_disconnect", shutdown_on_disconnect)
        if shutdown_on_idle is None:
            shutdown_on_idle = 'None'
        if shutdown_on_idle is not None:
            pulumi.set(__self__, "shutdown_on_idle", shutdown_on_idle)
        if shutdown_when_not_connected is None:
            shutdown_when_not_connected = 'Disabled'
        if shutdown_when_not_connected is not None:
            pulumi.set(__self__, "shutdown_when_not_connected", shutdown_when_not_connected)

    @property
    @pulumi.getter(name="disconnectDelay")
    def disconnect_delay(self) -> Optional[str]:
        """
        The amount of time a VM will stay running after a user disconnects if this behavior is enabled.
        """
        return pulumi.get(self, "disconnect_delay")

    @property
    @pulumi.getter(name="idleDelay")
    def idle_delay(self) -> Optional[str]:
        """
        The amount of time a VM will idle before it is shutdown if this behavior is enabled.
        """
        return pulumi.get(self, "idle_delay")

    @property
    @pulumi.getter(name="noConnectDelay")
    def no_connect_delay(self) -> Optional[str]:
        """
        The amount of time a VM will stay running before it is shutdown if no connection is made and this behavior is enabled.
        """
        return pulumi.get(self, "no_connect_delay")

    @property
    @pulumi.getter(name="shutdownOnDisconnect")
    def shutdown_on_disconnect(self) -> Optional[str]:
        """
        Whether shutdown on disconnect is enabled
        """
        return pulumi.get(self, "shutdown_on_disconnect")

    @property
    @pulumi.getter(name="shutdownOnIdle")
    def shutdown_on_idle(self) -> Optional[str]:
        """
        Whether a VM will get shutdown when it has idled for a period of time.
        """
        return pulumi.get(self, "shutdown_on_idle")

    @property
    @pulumi.getter(name="shutdownWhenNotConnected")
    def shutdown_when_not_connected(self) -> Optional[str]:
        """
        Whether a VM will get shutdown when it hasn't been connected to after a period of time.
        """
        return pulumi.get(self, "shutdown_when_not_connected")


@pulumi.output_type
class ConnectionProfileResponse(dict):
    """
    Connection profile for how users connect to lab virtual machines.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientRdpAccess":
            suggest = "client_rdp_access"
        elif key == "clientSshAccess":
            suggest = "client_ssh_access"
        elif key == "webRdpAccess":
            suggest = "web_rdp_access"
        elif key == "webSshAccess":
            suggest = "web_ssh_access"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionProfileResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionProfileResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionProfileResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_rdp_access: Optional[str] = None,
                 client_ssh_access: Optional[str] = None,
                 web_rdp_access: Optional[str] = None,
                 web_ssh_access: Optional[str] = None):
        """
        Connection profile for how users connect to lab virtual machines.
        :param str client_rdp_access: The enabled access level for Client Access over RDP.
        :param str client_ssh_access: The enabled access level for Client Access over SSH.
        :param str web_rdp_access: The enabled access level for Web Access over RDP.
        :param str web_ssh_access: The enabled access level for Web Access over SSH.
        """
        if client_rdp_access is None:
            client_rdp_access = 'None'
        if client_rdp_access is not None:
            pulumi.set(__self__, "client_rdp_access", client_rdp_access)
        if client_ssh_access is None:
            client_ssh_access = 'None'
        if client_ssh_access is not None:
            pulumi.set(__self__, "client_ssh_access", client_ssh_access)
        if web_rdp_access is None:
            web_rdp_access = 'None'
        if web_rdp_access is not None:
            pulumi.set(__self__, "web_rdp_access", web_rdp_access)
        if web_ssh_access is None:
            web_ssh_access = 'None'
        if web_ssh_access is not None:
            pulumi.set(__self__, "web_ssh_access", web_ssh_access)

    @property
    @pulumi.getter(name="clientRdpAccess")
    def client_rdp_access(self) -> Optional[str]:
        """
        The enabled access level for Client Access over RDP.
        """
        return pulumi.get(self, "client_rdp_access")

    @property
    @pulumi.getter(name="clientSshAccess")
    def client_ssh_access(self) -> Optional[str]:
        """
        The enabled access level for Client Access over SSH.
        """
        return pulumi.get(self, "client_ssh_access")

    @property
    @pulumi.getter(name="webRdpAccess")
    def web_rdp_access(self) -> Optional[str]:
        """
        The enabled access level for Web Access over RDP.
        """
        return pulumi.get(self, "web_rdp_access")

    @property
    @pulumi.getter(name="webSshAccess")
    def web_ssh_access(self) -> Optional[str]:
        """
        The enabled access level for Web Access over SSH.
        """
        return pulumi.get(self, "web_ssh_access")


@pulumi.output_type
class CredentialsResponse(dict):
    """
    Credentials for a user on a lab VM.
    """
    def __init__(__self__, *,
                 username: str):
        """
        Credentials for a user on a lab VM.
        :param str username: The username to use when signing in to lab VMs.
        """
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        The username to use when signing in to lab VMs.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class IdentityResponse(dict):
    """
    Identity for the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IdentityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IdentityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IdentityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 principal_id: str,
                 tenant_id: str,
                 type: Optional[str] = None):
        """
        Identity for the resource.
        :param str principal_id: The principal ID of resource identity.
        :param str tenant_id: The tenant ID of resource.
        :param str type: The identity type.
        """
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> str:
        """
        The principal ID of resource identity.
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> str:
        """
        The tenant ID of resource.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The identity type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ImageReferenceResponse(dict):
    """
    Image reference information. Used in the virtual machine profile.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "exactVersion":
            suggest = "exact_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ImageReferenceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ImageReferenceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ImageReferenceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 exact_version: str,
                 id: Optional[str] = None,
                 offer: Optional[str] = None,
                 publisher: Optional[str] = None,
                 sku: Optional[str] = None,
                 version: Optional[str] = None):
        """
        Image reference information. Used in the virtual machine profile.
        :param str exact_version: The actual version of the image after use.
        :param str id: Image resource ID
        :param str offer: The image offer if applicable.
        :param str publisher: The image publisher
        :param str sku: The image SKU
        :param str version: The image version specified on creation.
        """
        pulumi.set(__self__, "exact_version", exact_version)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if offer is not None:
            pulumi.set(__self__, "offer", offer)
        if publisher is not None:
            pulumi.set(__self__, "publisher", publisher)
        if sku is not None:
            pulumi.set(__self__, "sku", sku)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="exactVersion")
    def exact_version(self) -> str:
        """
        The actual version of the image after use.
        """
        return pulumi.get(self, "exact_version")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Image resource ID
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def offer(self) -> Optional[str]:
        """
        The image offer if applicable.
        """
        return pulumi.get(self, "offer")

    @property
    @pulumi.getter
    def publisher(self) -> Optional[str]:
        """
        The image publisher
        """
        return pulumi.get(self, "publisher")

    @property
    @pulumi.getter
    def sku(self) -> Optional[str]:
        """
        The image SKU
        """
        return pulumi.get(self, "sku")

    @property
    @pulumi.getter
    def version(self) -> Optional[str]:
        """
        The image version specified on creation.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class LabNetworkProfileResponse(dict):
    """
    Profile for how to handle networking for Labs.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "loadBalancerId":
            suggest = "load_balancer_id"
        elif key == "publicIpId":
            suggest = "public_ip_id"
        elif key == "subnetId":
            suggest = "subnet_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LabNetworkProfileResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LabNetworkProfileResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LabNetworkProfileResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 load_balancer_id: Optional[str] = None,
                 public_ip_id: Optional[str] = None,
                 subnet_id: Optional[str] = None):
        """
        Profile for how to handle networking for Labs.
        :param str load_balancer_id: The external load balancer resource id
        :param str public_ip_id: The external public IP resource id
        :param str subnet_id: The external subnet resource id
        """
        if load_balancer_id is not None:
            pulumi.set(__self__, "load_balancer_id", load_balancer_id)
        if public_ip_id is not None:
            pulumi.set(__self__, "public_ip_id", public_ip_id)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)

    @property
    @pulumi.getter(name="loadBalancerId")
    def load_balancer_id(self) -> Optional[str]:
        """
        The external load balancer resource id
        """
        return pulumi.get(self, "load_balancer_id")

    @property
    @pulumi.getter(name="publicIpId")
    def public_ip_id(self) -> Optional[str]:
        """
        The external public IP resource id
        """
        return pulumi.get(self, "public_ip_id")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[str]:
        """
        The external subnet resource id
        """
        return pulumi.get(self, "subnet_id")


@pulumi.output_type
class LabPlanNetworkProfileResponse(dict):
    """
    Profile for how to handle networking for Lab Plans.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "subnetId":
            suggest = "subnet_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LabPlanNetworkProfileResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LabPlanNetworkProfileResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LabPlanNetworkProfileResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 subnet_id: Optional[str] = None):
        """
        Profile for how to handle networking for Lab Plans.
        :param str subnet_id: The external subnet resource id
        """
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[str]:
        """
        The external subnet resource id
        """
        return pulumi.get(self, "subnet_id")


@pulumi.output_type
class RecurrencePatternResponse(dict):
    """
    Recurrence pattern of a lab schedule.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "expirationDate":
            suggest = "expiration_date"
        elif key == "weekDays":
            suggest = "week_days"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RecurrencePatternResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RecurrencePatternResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RecurrencePatternResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 expiration_date: str,
                 frequency: str,
                 interval: Optional[int] = None,
                 week_days: Optional[Sequence[str]] = None):
        """
        Recurrence pattern of a lab schedule.
        :param str expiration_date: When the recurrence will expire. This date is inclusive.
        :param str frequency: The frequency of the recurrence.
        :param int interval: The interval to invoke the schedule on. For example, interval = 2 and RecurrenceFrequency.Daily will run every 2 days. When no interval is supplied, an interval of 1 is used.
        :param Sequence[str] week_days: The week days the schedule runs. Used for when the Frequency is set to Weekly.
        """
        pulumi.set(__self__, "expiration_date", expiration_date)
        pulumi.set(__self__, "frequency", frequency)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if week_days is not None:
            pulumi.set(__self__, "week_days", week_days)

    @property
    @pulumi.getter(name="expirationDate")
    def expiration_date(self) -> str:
        """
        When the recurrence will expire. This date is inclusive.
        """
        return pulumi.get(self, "expiration_date")

    @property
    @pulumi.getter
    def frequency(self) -> str:
        """
        The frequency of the recurrence.
        """
        return pulumi.get(self, "frequency")

    @property
    @pulumi.getter
    def interval(self) -> Optional[int]:
        """
        The interval to invoke the schedule on. For example, interval = 2 and RecurrenceFrequency.Daily will run every 2 days. When no interval is supplied, an interval of 1 is used.
        """
        return pulumi.get(self, "interval")

    @property
    @pulumi.getter(name="weekDays")
    def week_days(self) -> Optional[Sequence[str]]:
        """
        The week days the schedule runs. Used for when the Frequency is set to Weekly.
        """
        return pulumi.get(self, "week_days")


@pulumi.output_type
class RosterProfileResponse(dict):
    """
    The lab user list management profile.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "activeDirectoryGroupId":
            suggest = "active_directory_group_id"
        elif key == "lmsInstance":
            suggest = "lms_instance"
        elif key == "ltiClientId":
            suggest = "lti_client_id"
        elif key == "ltiContextId":
            suggest = "lti_context_id"
        elif key == "ltiRosterEndpoint":
            suggest = "lti_roster_endpoint"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RosterProfileResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RosterProfileResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RosterProfileResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 active_directory_group_id: Optional[str] = None,
                 lms_instance: Optional[str] = None,
                 lti_client_id: Optional[str] = None,
                 lti_context_id: Optional[str] = None,
                 lti_roster_endpoint: Optional[str] = None):
        """
        The lab user list management profile.
        :param str active_directory_group_id: The AAD group ID which this lab roster is populated from. Having this set enables AAD sync mode.
        :param str lms_instance: The base URI identifying the lms instance.
        :param str lti_client_id: The unique id of the azure lab services tool in the lms.
        :param str lti_context_id: The unique context identifier for the lab in the lms.
        :param str lti_roster_endpoint: The uri of the names and roles service endpoint on the lms for the class attached to this lab.
        """
        if active_directory_group_id is not None:
            pulumi.set(__self__, "active_directory_group_id", active_directory_group_id)
        if lms_instance is not None:
            pulumi.set(__self__, "lms_instance", lms_instance)
        if lti_client_id is not None:
            pulumi.set(__self__, "lti_client_id", lti_client_id)
        if lti_context_id is not None:
            pulumi.set(__self__, "lti_context_id", lti_context_id)
        if lti_roster_endpoint is not None:
            pulumi.set(__self__, "lti_roster_endpoint", lti_roster_endpoint)

    @property
    @pulumi.getter(name="activeDirectoryGroupId")
    def active_directory_group_id(self) -> Optional[str]:
        """
        The AAD group ID which this lab roster is populated from. Having this set enables AAD sync mode.
        """
        return pulumi.get(self, "active_directory_group_id")

    @property
    @pulumi.getter(name="lmsInstance")
    def lms_instance(self) -> Optional[str]:
        """
        The base URI identifying the lms instance.
        """
        return pulumi.get(self, "lms_instance")

    @property
    @pulumi.getter(name="ltiClientId")
    def lti_client_id(self) -> Optional[str]:
        """
        The unique id of the azure lab services tool in the lms.
        """
        return pulumi.get(self, "lti_client_id")

    @property
    @pulumi.getter(name="ltiContextId")
    def lti_context_id(self) -> Optional[str]:
        """
        The unique context identifier for the lab in the lms.
        """
        return pulumi.get(self, "lti_context_id")

    @property
    @pulumi.getter(name="ltiRosterEndpoint")
    def lti_roster_endpoint(self) -> Optional[str]:
        """
        The uri of the names and roles service endpoint on the lms for the class attached to this lab.
        """
        return pulumi.get(self, "lti_roster_endpoint")


@pulumi.output_type
class SecurityProfileResponse(dict):
    """
    The lab security profile.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "registrationCode":
            suggest = "registration_code"
        elif key == "openAccess":
            suggest = "open_access"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecurityProfileResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecurityProfileResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecurityProfileResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 registration_code: str,
                 open_access: Optional[str] = None):
        """
        The lab security profile.
        :param str registration_code: The registration code for the lab.
        :param str open_access: Whether any user or only specified users can register to a lab.
        """
        pulumi.set(__self__, "registration_code", registration_code)
        if open_access is not None:
            pulumi.set(__self__, "open_access", open_access)

    @property
    @pulumi.getter(name="registrationCode")
    def registration_code(self) -> str:
        """
        The registration code for the lab.
        """
        return pulumi.get(self, "registration_code")

    @property
    @pulumi.getter(name="openAccess")
    def open_access(self) -> Optional[str]:
        """
        Whether any user or only specified users can register to a lab.
        """
        return pulumi.get(self, "open_access")


@pulumi.output_type
class SkuResponse(dict):
    """
    The resource model definition representing SKU
    """
    def __init__(__self__, *,
                 name: str,
                 capacity: Optional[int] = None,
                 family: Optional[str] = None,
                 size: Optional[str] = None,
                 tier: Optional[str] = None):
        """
        The resource model definition representing SKU
        :param str name: The name of the SKU. Ex - P3. It is typically a letter+number code
        :param int capacity: If the SKU supports scale out/in then the capacity integer should be included. If scale out/in is not possible for the resource this may be omitted.
        :param str family: If the service has different generations of hardware, for the same SKU, then that can be captured here.
        :param str size: The SKU size. When the name field is the combination of tier and some other value, this would be the standalone code. 
        :param str tier: This field is required to be implemented by the Resource Provider if the service has more than one tier, but is not required on a PUT.
        """
        pulumi.set(__self__, "name", name)
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if family is not None:
            pulumi.set(__self__, "family", family)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if tier is not None:
            pulumi.set(__self__, "tier", tier)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the SKU. Ex - P3. It is typically a letter+number code
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def capacity(self) -> Optional[int]:
        """
        If the SKU supports scale out/in then the capacity integer should be included. If scale out/in is not possible for the resource this may be omitted.
        """
        return pulumi.get(self, "capacity")

    @property
    @pulumi.getter
    def family(self) -> Optional[str]:
        """
        If the service has different generations of hardware, for the same SKU, then that can be captured here.
        """
        return pulumi.get(self, "family")

    @property
    @pulumi.getter
    def size(self) -> Optional[str]:
        """
        The SKU size. When the name field is the combination of tier and some other value, this would be the standalone code. 
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter
    def tier(self) -> Optional[str]:
        """
        This field is required to be implemented by the Resource Provider if the service has more than one tier, but is not required on a PUT.
        """
        return pulumi.get(self, "tier")


@pulumi.output_type
class SupportInfoResponse(dict):
    """
    Support contact information and instructions.
    """
    def __init__(__self__, *,
                 email: Optional[str] = None,
                 instructions: Optional[str] = None,
                 phone: Optional[str] = None,
                 url: Optional[str] = None):
        """
        Support contact information and instructions.
        :param str email: Support contact email address.
        :param str instructions: Support instructions.
        :param str phone: Support contact phone number.
        :param str url: Support web address.
        """
        if email is not None:
            pulumi.set(__self__, "email", email)
        if instructions is not None:
            pulumi.set(__self__, "instructions", instructions)
        if phone is not None:
            pulumi.set(__self__, "phone", phone)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def email(self) -> Optional[str]:
        """
        Support contact email address.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter
    def instructions(self) -> Optional[str]:
        """
        Support instructions.
        """
        return pulumi.get(self, "instructions")

    @property
    @pulumi.getter
    def phone(self) -> Optional[str]:
        """
        Support contact phone number.
        """
        return pulumi.get(self, "phone")

    @property
    @pulumi.getter
    def url(self) -> Optional[str]:
        """
        Support web address.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class SystemDataResponse(dict):
    """
    Metadata pertaining to creation and last modification of the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdAt":
            suggest = "created_at"
        elif key == "createdBy":
            suggest = "created_by"
        elif key == "createdByType":
            suggest = "created_by_type"
        elif key == "lastModifiedAt":
            suggest = "last_modified_at"
        elif key == "lastModifiedBy":
            suggest = "last_modified_by"
        elif key == "lastModifiedByType":
            suggest = "last_modified_by_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SystemDataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_at: Optional[str] = None,
                 created_by: Optional[str] = None,
                 created_by_type: Optional[str] = None,
                 last_modified_at: Optional[str] = None,
                 last_modified_by: Optional[str] = None,
                 last_modified_by_type: Optional[str] = None):
        """
        Metadata pertaining to creation and last modification of the resource.
        :param str created_at: The timestamp of resource creation (UTC).
        :param str created_by: The identity that created the resource.
        :param str created_by_type: The type of identity that created the resource.
        :param str last_modified_at: The timestamp of resource last modification (UTC)
        :param str last_modified_by: The identity that last modified the resource.
        :param str last_modified_by_type: The type of identity that last modified the resource.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if created_by_type is not None:
            pulumi.set(__self__, "created_by_type", created_by_type)
        if last_modified_at is not None:
            pulumi.set(__self__, "last_modified_at", last_modified_at)
        if last_modified_by is not None:
            pulumi.set(__self__, "last_modified_by", last_modified_by)
        if last_modified_by_type is not None:
            pulumi.set(__self__, "last_modified_by_type", last_modified_by_type)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[str]:
        """
        The timestamp of resource creation (UTC).
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[str]:
        """
        The identity that created the resource.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="createdByType")
    def created_by_type(self) -> Optional[str]:
        """
        The type of identity that created the resource.
        """
        return pulumi.get(self, "created_by_type")

    @property
    @pulumi.getter(name="lastModifiedAt")
    def last_modified_at(self) -> Optional[str]:
        """
        The timestamp of resource last modification (UTC)
        """
        return pulumi.get(self, "last_modified_at")

    @property
    @pulumi.getter(name="lastModifiedBy")
    def last_modified_by(self) -> Optional[str]:
        """
        The identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by")

    @property
    @pulumi.getter(name="lastModifiedByType")
    def last_modified_by_type(self) -> Optional[str]:
        """
        The type of identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by_type")


@pulumi.output_type
class VirtualMachineAdditionalCapabilitiesResponse(dict):
    """
    The additional capabilities for a lab VM.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "installGpuDrivers":
            suggest = "install_gpu_drivers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineAdditionalCapabilitiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineAdditionalCapabilitiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineAdditionalCapabilitiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 install_gpu_drivers: Optional[str] = None):
        """
        The additional capabilities for a lab VM.
        :param str install_gpu_drivers: Flag to pre-install dedicated GPU drivers.
        """
        if install_gpu_drivers is None:
            install_gpu_drivers = 'Disabled'
        if install_gpu_drivers is not None:
            pulumi.set(__self__, "install_gpu_drivers", install_gpu_drivers)

    @property
    @pulumi.getter(name="installGpuDrivers")
    def install_gpu_drivers(self) -> Optional[str]:
        """
        Flag to pre-install dedicated GPU drivers.
        """
        return pulumi.get(self, "install_gpu_drivers")


@pulumi.output_type
class VirtualMachineProfileResponse(dict):
    """
    The base virtual machine configuration for a lab.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "adminUser":
            suggest = "admin_user"
        elif key == "createOption":
            suggest = "create_option"
        elif key == "imageReference":
            suggest = "image_reference"
        elif key == "osType":
            suggest = "os_type"
        elif key == "usageQuota":
            suggest = "usage_quota"
        elif key == "additionalCapabilities":
            suggest = "additional_capabilities"
        elif key == "nonAdminUser":
            suggest = "non_admin_user"
        elif key == "useSharedPassword":
            suggest = "use_shared_password"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineProfileResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineProfileResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineProfileResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 admin_user: 'outputs.CredentialsResponse',
                 create_option: str,
                 image_reference: 'outputs.ImageReferenceResponse',
                 os_type: str,
                 sku: 'outputs.SkuResponse',
                 usage_quota: str,
                 additional_capabilities: Optional['outputs.VirtualMachineAdditionalCapabilitiesResponse'] = None,
                 non_admin_user: Optional['outputs.CredentialsResponse'] = None,
                 use_shared_password: Optional[str] = None):
        """
        The base virtual machine configuration for a lab.
        :param 'CredentialsResponse' admin_user: Credentials for the admin user on the VM.
        :param str create_option: Indicates what lab virtual machines are created from.
        :param 'ImageReferenceResponse' image_reference: The image configuration for lab virtual machines.
        :param str os_type: The OS type of the image
        :param 'SkuResponse' sku: The SKU for the lab. Defines the type of virtual machines used in the lab.
        :param str usage_quota: The initial quota alloted to each lab user. Must be a time span between 0 and 9999 hours.
        :param 'VirtualMachineAdditionalCapabilitiesResponse' additional_capabilities: Additional VM capabilities.
        :param 'CredentialsResponse' non_admin_user: Credentials for the non-admin user on the VM, if one exists.
        :param str use_shared_password: Enabling this option will use the same password for all user VMs.
        """
        pulumi.set(__self__, "admin_user", admin_user)
        pulumi.set(__self__, "create_option", create_option)
        pulumi.set(__self__, "image_reference", image_reference)
        pulumi.set(__self__, "os_type", os_type)
        pulumi.set(__self__, "sku", sku)
        pulumi.set(__self__, "usage_quota", usage_quota)
        if additional_capabilities is not None:
            pulumi.set(__self__, "additional_capabilities", additional_capabilities)
        if non_admin_user is not None:
            pulumi.set(__self__, "non_admin_user", non_admin_user)
        if use_shared_password is None:
            use_shared_password = 'Disabled'
        if use_shared_password is not None:
            pulumi.set(__self__, "use_shared_password", use_shared_password)

    @property
    @pulumi.getter(name="adminUser")
    def admin_user(self) -> 'outputs.CredentialsResponse':
        """
        Credentials for the admin user on the VM.
        """
        return pulumi.get(self, "admin_user")

    @property
    @pulumi.getter(name="createOption")
    def create_option(self) -> str:
        """
        Indicates what lab virtual machines are created from.
        """
        return pulumi.get(self, "create_option")

    @property
    @pulumi.getter(name="imageReference")
    def image_reference(self) -> 'outputs.ImageReferenceResponse':
        """
        The image configuration for lab virtual machines.
        """
        return pulumi.get(self, "image_reference")

    @property
    @pulumi.getter(name="osType")
    def os_type(self) -> str:
        """
        The OS type of the image
        """
        return pulumi.get(self, "os_type")

    @property
    @pulumi.getter
    def sku(self) -> 'outputs.SkuResponse':
        """
        The SKU for the lab. Defines the type of virtual machines used in the lab.
        """
        return pulumi.get(self, "sku")

    @property
    @pulumi.getter(name="usageQuota")
    def usage_quota(self) -> str:
        """
        The initial quota alloted to each lab user. Must be a time span between 0 and 9999 hours.
        """
        return pulumi.get(self, "usage_quota")

    @property
    @pulumi.getter(name="additionalCapabilities")
    def additional_capabilities(self) -> Optional['outputs.VirtualMachineAdditionalCapabilitiesResponse']:
        """
        Additional VM capabilities.
        """
        return pulumi.get(self, "additional_capabilities")

    @property
    @pulumi.getter(name="nonAdminUser")
    def non_admin_user(self) -> Optional['outputs.CredentialsResponse']:
        """
        Credentials for the non-admin user on the VM, if one exists.
        """
        return pulumi.get(self, "non_admin_user")

    @property
    @pulumi.getter(name="useSharedPassword")
    def use_shared_password(self) -> Optional[str]:
        """
        Enabling this option will use the same password for all user VMs.
        """
        return pulumi.get(self, "use_shared_password")


