# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from ._enums import *

__all__ = [
    'AdvancedScheduleMonthlyOccurrenceArgs',
    'AdvancedScheduleArgs',
    'AzureQueryPropertiesArgs',
    'ConnectionTypeAssociationPropertyArgs',
    'ContentHashArgs',
    'ContentLinkArgs',
    'ContentSourceArgs',
    'DscConfigurationAssociationPropertyArgs',
    'DscConfigurationParameterArgs',
    'EncryptionPropertiesIdentityArgs',
    'EncryptionPropertiesArgs',
    'ErrorResponseArgs',
    'FieldDefinitionArgs',
    'IdentityArgs',
    'KeyVaultPropertiesArgs',
    'LinuxPropertiesArgs',
    'NonAzureQueryPropertiesArgs',
    'PrivateEndpointPropertyArgs',
    'PrivateLinkServiceConnectionStatePropertyArgs',
    'RunAsCredentialAssociationPropertyArgs',
    'RunbookAssociationPropertyArgs',
    'RunbookDraftArgs',
    'RunbookParameterArgs',
    'SUCSchedulePropertiesArgs',
    'ScheduleAssociationPropertyArgs',
    'SkuArgs',
    'SoftwareUpdateConfigurationTasksArgs',
    'SourceControlSecurityTokenPropertiesArgs',
    'TagSettingsPropertiesArgs',
    'TargetPropertiesArgs',
    'TaskPropertiesArgs',
    'UpdateConfigurationArgs',
    'WindowsPropertiesArgs',
]

@pulumi.input_type
class AdvancedScheduleMonthlyOccurrenceArgs:
    def __init__(__self__, *,
                 day: Optional[pulumi.Input[Union[str, 'ScheduleDay']]] = None,
                 occurrence: Optional[pulumi.Input[int]] = None):
        """
        The properties of the create advanced schedule monthly occurrence.
        :param pulumi.Input[Union[str, 'ScheduleDay']] day: Day of the occurrence. Must be one of monday, tuesday, wednesday, thursday, friday, saturday, sunday.
        :param pulumi.Input[int] occurrence: Occurrence of the week within the month. Must be between 1 and 5
        """
        if day is not None:
            pulumi.set(__self__, "day", day)
        if occurrence is not None:
            pulumi.set(__self__, "occurrence", occurrence)

    @property
    @pulumi.getter
    def day(self) -> Optional[pulumi.Input[Union[str, 'ScheduleDay']]]:
        """
        Day of the occurrence. Must be one of monday, tuesday, wednesday, thursday, friday, saturday, sunday.
        """
        return pulumi.get(self, "day")

    @day.setter
    def day(self, value: Optional[pulumi.Input[Union[str, 'ScheduleDay']]]):
        pulumi.set(self, "day", value)

    @property
    @pulumi.getter
    def occurrence(self) -> Optional[pulumi.Input[int]]:
        """
        Occurrence of the week within the month. Must be between 1 and 5
        """
        return pulumi.get(self, "occurrence")

    @occurrence.setter
    def occurrence(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "occurrence", value)


@pulumi.input_type
class AdvancedScheduleArgs:
    def __init__(__self__, *,
                 month_days: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 monthly_occurrences: Optional[pulumi.Input[Sequence[pulumi.Input['AdvancedScheduleMonthlyOccurrenceArgs']]]] = None,
                 week_days: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The properties of the create Advanced Schedule.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] month_days: Days of the month that the job should execute on. Must be between 1 and 31.
        :param pulumi.Input[Sequence[pulumi.Input['AdvancedScheduleMonthlyOccurrenceArgs']]] monthly_occurrences: Occurrences of days within a month.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] week_days: Days of the week that the job should execute on.
        """
        if month_days is not None:
            pulumi.set(__self__, "month_days", month_days)
        if monthly_occurrences is not None:
            pulumi.set(__self__, "monthly_occurrences", monthly_occurrences)
        if week_days is not None:
            pulumi.set(__self__, "week_days", week_days)

    @property
    @pulumi.getter(name="monthDays")
    def month_days(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        """
        Days of the month that the job should execute on. Must be between 1 and 31.
        """
        return pulumi.get(self, "month_days")

    @month_days.setter
    def month_days(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "month_days", value)

    @property
    @pulumi.getter(name="monthlyOccurrences")
    def monthly_occurrences(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AdvancedScheduleMonthlyOccurrenceArgs']]]]:
        """
        Occurrences of days within a month.
        """
        return pulumi.get(self, "monthly_occurrences")

    @monthly_occurrences.setter
    def monthly_occurrences(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AdvancedScheduleMonthlyOccurrenceArgs']]]]):
        pulumi.set(self, "monthly_occurrences", value)

    @property
    @pulumi.getter(name="weekDays")
    def week_days(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Days of the week that the job should execute on.
        """
        return pulumi.get(self, "week_days")

    @week_days.setter
    def week_days(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "week_days", value)


@pulumi.input_type
class AzureQueryPropertiesArgs:
    def __init__(__self__, *,
                 locations: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 scope: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tag_settings: Optional[pulumi.Input['TagSettingsPropertiesArgs']] = None):
        """
        Azure query for the update configuration.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] locations: List of locations to scope the query to.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] scope: List of Subscription or Resource Group ARM Ids.
        :param pulumi.Input['TagSettingsPropertiesArgs'] tag_settings: Tag settings for the VM.
        """
        if locations is not None:
            pulumi.set(__self__, "locations", locations)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if tag_settings is not None:
            pulumi.set(__self__, "tag_settings", tag_settings)

    @property
    @pulumi.getter
    def locations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of locations to scope the query to.
        """
        return pulumi.get(self, "locations")

    @locations.setter
    def locations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "locations", value)

    @property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of Subscription or Resource Group ARM Ids.
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "scope", value)

    @property
    @pulumi.getter(name="tagSettings")
    def tag_settings(self) -> Optional[pulumi.Input['TagSettingsPropertiesArgs']]:
        """
        Tag settings for the VM.
        """
        return pulumi.get(self, "tag_settings")

    @tag_settings.setter
    def tag_settings(self, value: Optional[pulumi.Input['TagSettingsPropertiesArgs']]):
        pulumi.set(self, "tag_settings", value)


@pulumi.input_type
class ConnectionTypeAssociationPropertyArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None):
        """
        The connection type property associated with the entity.
        :param pulumi.Input[str] name: Gets or sets the name of the connection type.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the name of the connection type.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class ContentHashArgs:
    def __init__(__self__, *,
                 algorithm: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        Definition of the runbook property type.
        :param pulumi.Input[str] algorithm: Gets or sets the content hash algorithm used to hash the content.
        :param pulumi.Input[str] value: Gets or sets expected hash value of the content.
        """
        pulumi.set(__self__, "algorithm", algorithm)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def algorithm(self) -> pulumi.Input[str]:
        """
        Gets or sets the content hash algorithm used to hash the content.
        """
        return pulumi.get(self, "algorithm")

    @algorithm.setter
    def algorithm(self, value: pulumi.Input[str]):
        pulumi.set(self, "algorithm", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        Gets or sets expected hash value of the content.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class ContentLinkArgs:
    def __init__(__self__, *,
                 content_hash: Optional[pulumi.Input['ContentHashArgs']] = None,
                 uri: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        Definition of the content link.
        :param pulumi.Input['ContentHashArgs'] content_hash: Gets or sets the hash.
        :param pulumi.Input[str] uri: Gets or sets the uri of the runbook content.
        :param pulumi.Input[str] version: Gets or sets the version of the content.
        """
        if content_hash is not None:
            pulumi.set(__self__, "content_hash", content_hash)
        if uri is not None:
            pulumi.set(__self__, "uri", uri)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="contentHash")
    def content_hash(self) -> Optional[pulumi.Input['ContentHashArgs']]:
        """
        Gets or sets the hash.
        """
        return pulumi.get(self, "content_hash")

    @content_hash.setter
    def content_hash(self, value: Optional[pulumi.Input['ContentHashArgs']]):
        pulumi.set(self, "content_hash", value)

    @property
    @pulumi.getter
    def uri(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the uri of the runbook content.
        """
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uri", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the version of the content.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class ContentSourceArgs:
    def __init__(__self__, *,
                 hash: Optional[pulumi.Input['ContentHashArgs']] = None,
                 type: Optional[pulumi.Input[Union[str, 'ContentSourceType']]] = None,
                 value: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        Definition of the content source.
        :param pulumi.Input['ContentHashArgs'] hash: Gets or sets the hash.
        :param pulumi.Input[Union[str, 'ContentSourceType']] type: Gets or sets the content source type.
        :param pulumi.Input[str] value: Gets or sets the value of the content. This is based on the content source type.
        :param pulumi.Input[str] version: Gets or sets the version of the content.
        """
        if hash is not None:
            pulumi.set(__self__, "hash", hash)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if value is not None:
            pulumi.set(__self__, "value", value)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def hash(self) -> Optional[pulumi.Input['ContentHashArgs']]:
        """
        Gets or sets the hash.
        """
        return pulumi.get(self, "hash")

    @hash.setter
    def hash(self, value: Optional[pulumi.Input['ContentHashArgs']]):
        pulumi.set(self, "hash", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[Union[str, 'ContentSourceType']]]:
        """
        Gets or sets the content source type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[Union[str, 'ContentSourceType']]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the value of the content. This is based on the content source type.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the version of the content.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class DscConfigurationAssociationPropertyArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None):
        """
        The Dsc configuration property associated with the entity.
        :param pulumi.Input[str] name: Gets or sets the name of the Dsc configuration.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the name of the Dsc configuration.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class DscConfigurationParameterArgs:
    def __init__(__self__, *,
                 default_value: Optional[pulumi.Input[str]] = None,
                 is_mandatory: Optional[pulumi.Input[bool]] = None,
                 position: Optional[pulumi.Input[int]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        Definition of the configuration parameter type.
        :param pulumi.Input[str] default_value: Gets or sets the default value of parameter.
        :param pulumi.Input[bool] is_mandatory: Gets or sets a Boolean value to indicate whether the parameter is mandatory or not.
        :param pulumi.Input[int] position: Get or sets the position of the parameter.
        :param pulumi.Input[str] type: Gets or sets the type of the parameter.
        """
        if default_value is not None:
            pulumi.set(__self__, "default_value", default_value)
        if is_mandatory is not None:
            pulumi.set(__self__, "is_mandatory", is_mandatory)
        if position is not None:
            pulumi.set(__self__, "position", position)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="defaultValue")
    def default_value(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the default value of parameter.
        """
        return pulumi.get(self, "default_value")

    @default_value.setter
    def default_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_value", value)

    @property
    @pulumi.getter(name="isMandatory")
    def is_mandatory(self) -> Optional[pulumi.Input[bool]]:
        """
        Gets or sets a Boolean value to indicate whether the parameter is mandatory or not.
        """
        return pulumi.get(self, "is_mandatory")

    @is_mandatory.setter
    def is_mandatory(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_mandatory", value)

    @property
    @pulumi.getter
    def position(self) -> Optional[pulumi.Input[int]]:
        """
        Get or sets the position of the parameter.
        """
        return pulumi.get(self, "position")

    @position.setter
    def position(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "position", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the type of the parameter.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class EncryptionPropertiesIdentityArgs:
    def __init__(__self__, *,
                 user_assigned_identity: Optional[Any] = None):
        """
        User identity used for CMK.
        :param Any user_assigned_identity: The user identity used for CMK. It will be an ARM resource id in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
        """
        if user_assigned_identity is not None:
            pulumi.set(__self__, "user_assigned_identity", user_assigned_identity)

    @property
    @pulumi.getter(name="userAssignedIdentity")
    def user_assigned_identity(self) -> Optional[Any]:
        """
        The user identity used for CMK. It will be an ARM resource id in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
        """
        return pulumi.get(self, "user_assigned_identity")

    @user_assigned_identity.setter
    def user_assigned_identity(self, value: Optional[Any]):
        pulumi.set(self, "user_assigned_identity", value)


@pulumi.input_type
class EncryptionPropertiesArgs:
    def __init__(__self__, *,
                 identity: Optional[pulumi.Input['EncryptionPropertiesIdentityArgs']] = None,
                 key_source: Optional[pulumi.Input['EncryptionKeySourceType']] = None,
                 key_vault_properties: Optional[pulumi.Input['KeyVaultPropertiesArgs']] = None):
        """
        The encryption settings for automation account
        :param pulumi.Input['EncryptionPropertiesIdentityArgs'] identity: User identity used for CMK.
        :param pulumi.Input['EncryptionKeySourceType'] key_source: Encryption Key Source
        :param pulumi.Input['KeyVaultPropertiesArgs'] key_vault_properties: Key vault properties.
        """
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if key_source is not None:
            pulumi.set(__self__, "key_source", key_source)
        if key_vault_properties is not None:
            pulumi.set(__self__, "key_vault_properties", key_vault_properties)

    @property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['EncryptionPropertiesIdentityArgs']]:
        """
        User identity used for CMK.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['EncryptionPropertiesIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @property
    @pulumi.getter(name="keySource")
    def key_source(self) -> Optional[pulumi.Input['EncryptionKeySourceType']]:
        """
        Encryption Key Source
        """
        return pulumi.get(self, "key_source")

    @key_source.setter
    def key_source(self, value: Optional[pulumi.Input['EncryptionKeySourceType']]):
        pulumi.set(self, "key_source", value)

    @property
    @pulumi.getter(name="keyVaultProperties")
    def key_vault_properties(self) -> Optional[pulumi.Input['KeyVaultPropertiesArgs']]:
        """
        Key vault properties.
        """
        return pulumi.get(self, "key_vault_properties")

    @key_vault_properties.setter
    def key_vault_properties(self, value: Optional[pulumi.Input['KeyVaultPropertiesArgs']]):
        pulumi.set(self, "key_vault_properties", value)


@pulumi.input_type
class ErrorResponseArgs:
    def __init__(__self__, *,
                 code: Optional[pulumi.Input[str]] = None,
                 message: Optional[pulumi.Input[str]] = None):
        """
        Error response of an operation failure
        :param pulumi.Input[str] code: Error code
        :param pulumi.Input[str] message: Error message indicating why the operation failed.
        """
        if code is not None:
            pulumi.set(__self__, "code", code)
        if message is not None:
            pulumi.set(__self__, "message", message)

    @property
    @pulumi.getter
    def code(self) -> Optional[pulumi.Input[str]]:
        """
        Error code
        """
        return pulumi.get(self, "code")

    @code.setter
    def code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "code", value)

    @property
    @pulumi.getter
    def message(self) -> Optional[pulumi.Input[str]]:
        """
        Error message indicating why the operation failed.
        """
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message", value)


@pulumi.input_type
class FieldDefinitionArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 is_encrypted: Optional[pulumi.Input[bool]] = None,
                 is_optional: Optional[pulumi.Input[bool]] = None):
        """
        Definition of the connection fields.
        :param pulumi.Input[str] type: Gets or sets the type of the connection field definition.
        :param pulumi.Input[bool] is_encrypted: Gets or sets the isEncrypted flag of the connection field definition.
        :param pulumi.Input[bool] is_optional: Gets or sets the isOptional flag of the connection field definition.
        """
        pulumi.set(__self__, "type", type)
        if is_encrypted is not None:
            pulumi.set(__self__, "is_encrypted", is_encrypted)
        if is_optional is not None:
            pulumi.set(__self__, "is_optional", is_optional)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Gets or sets the type of the connection field definition.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="isEncrypted")
    def is_encrypted(self) -> Optional[pulumi.Input[bool]]:
        """
        Gets or sets the isEncrypted flag of the connection field definition.
        """
        return pulumi.get(self, "is_encrypted")

    @is_encrypted.setter
    def is_encrypted(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_encrypted", value)

    @property
    @pulumi.getter(name="isOptional")
    def is_optional(self) -> Optional[pulumi.Input[bool]]:
        """
        Gets or sets the isOptional flag of the connection field definition.
        """
        return pulumi.get(self, "is_optional")

    @is_optional.setter
    def is_optional(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_optional", value)


@pulumi.input_type
class IdentityArgs:
    def __init__(__self__, *,
                 type: Optional[pulumi.Input['ResourceIdentityType']] = None,
                 user_assigned_identities: Optional[pulumi.Input[Mapping[str, Any]]] = None):
        """
        Identity for the resource.
        :param pulumi.Input['ResourceIdentityType'] type: The identity type.
        :param pulumi.Input[Mapping[str, Any]] user_assigned_identities: The list of user identities associated with the resource. The user identity dictionary key references will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
        """
        if type is not None:
            pulumi.set(__self__, "type", type)
        if user_assigned_identities is not None:
            pulumi.set(__self__, "user_assigned_identities", user_assigned_identities)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input['ResourceIdentityType']]:
        """
        The identity type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input['ResourceIdentityType']]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="userAssignedIdentities")
    def user_assigned_identities(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        The list of user identities associated with the resource. The user identity dictionary key references will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
        """
        return pulumi.get(self, "user_assigned_identities")

    @user_assigned_identities.setter
    def user_assigned_identities(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "user_assigned_identities", value)


@pulumi.input_type
class KeyVaultPropertiesArgs:
    def __init__(__self__, *,
                 key_name: Optional[pulumi.Input[str]] = None,
                 key_version: Optional[pulumi.Input[str]] = None,
                 keyvault_uri: Optional[pulumi.Input[str]] = None):
        """
        Settings concerning key vault encryption for a configuration store.
        :param pulumi.Input[str] key_name: The name of key used to encrypt data.
        :param pulumi.Input[str] key_version: The key version of the key used to encrypt data.
        :param pulumi.Input[str] keyvault_uri: The URI of the key vault key used to encrypt data.
        """
        if key_name is not None:
            pulumi.set(__self__, "key_name", key_name)
        if key_version is not None:
            pulumi.set(__self__, "key_version", key_version)
        if keyvault_uri is not None:
            pulumi.set(__self__, "keyvault_uri", keyvault_uri)

    @property
    @pulumi.getter(name="keyName")
    def key_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of key used to encrypt data.
        """
        return pulumi.get(self, "key_name")

    @key_name.setter
    def key_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_name", value)

    @property
    @pulumi.getter(name="keyVersion")
    def key_version(self) -> Optional[pulumi.Input[str]]:
        """
        The key version of the key used to encrypt data.
        """
        return pulumi.get(self, "key_version")

    @key_version.setter
    def key_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_version", value)

    @property
    @pulumi.getter(name="keyvaultUri")
    def keyvault_uri(self) -> Optional[pulumi.Input[str]]:
        """
        The URI of the key vault key used to encrypt data.
        """
        return pulumi.get(self, "keyvault_uri")

    @keyvault_uri.setter
    def keyvault_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "keyvault_uri", value)


@pulumi.input_type
class LinuxPropertiesArgs:
    def __init__(__self__, *,
                 excluded_package_name_masks: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 included_package_classifications: Optional[pulumi.Input[Union[str, 'LinuxUpdateClasses']]] = None,
                 included_package_name_masks: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 reboot_setting: Optional[pulumi.Input[str]] = None):
        """
        Linux specific update configuration.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] excluded_package_name_masks: packages excluded from the software update configuration.
        :param pulumi.Input[Union[str, 'LinuxUpdateClasses']] included_package_classifications: Update classifications included in the software update configuration.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] included_package_name_masks: packages included from the software update configuration.
        :param pulumi.Input[str] reboot_setting: Reboot setting for the software update configuration.
        """
        if excluded_package_name_masks is not None:
            pulumi.set(__self__, "excluded_package_name_masks", excluded_package_name_masks)
        if included_package_classifications is not None:
            pulumi.set(__self__, "included_package_classifications", included_package_classifications)
        if included_package_name_masks is not None:
            pulumi.set(__self__, "included_package_name_masks", included_package_name_masks)
        if reboot_setting is not None:
            pulumi.set(__self__, "reboot_setting", reboot_setting)

    @property
    @pulumi.getter(name="excludedPackageNameMasks")
    def excluded_package_name_masks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        packages excluded from the software update configuration.
        """
        return pulumi.get(self, "excluded_package_name_masks")

    @excluded_package_name_masks.setter
    def excluded_package_name_masks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "excluded_package_name_masks", value)

    @property
    @pulumi.getter(name="includedPackageClassifications")
    def included_package_classifications(self) -> Optional[pulumi.Input[Union[str, 'LinuxUpdateClasses']]]:
        """
        Update classifications included in the software update configuration.
        """
        return pulumi.get(self, "included_package_classifications")

    @included_package_classifications.setter
    def included_package_classifications(self, value: Optional[pulumi.Input[Union[str, 'LinuxUpdateClasses']]]):
        pulumi.set(self, "included_package_classifications", value)

    @property
    @pulumi.getter(name="includedPackageNameMasks")
    def included_package_name_masks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        packages included from the software update configuration.
        """
        return pulumi.get(self, "included_package_name_masks")

    @included_package_name_masks.setter
    def included_package_name_masks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "included_package_name_masks", value)

    @property
    @pulumi.getter(name="rebootSetting")
    def reboot_setting(self) -> Optional[pulumi.Input[str]]:
        """
        Reboot setting for the software update configuration.
        """
        return pulumi.get(self, "reboot_setting")

    @reboot_setting.setter
    def reboot_setting(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "reboot_setting", value)


@pulumi.input_type
class NonAzureQueryPropertiesArgs:
    def __init__(__self__, *,
                 function_alias: Optional[pulumi.Input[str]] = None,
                 workspace_id: Optional[pulumi.Input[str]] = None):
        """
        Non Azure query for the update configuration.
        :param pulumi.Input[str] function_alias: Log Analytics Saved Search name.
        :param pulumi.Input[str] workspace_id: Workspace Id for Log Analytics in which the saved Search is resided.
        """
        if function_alias is not None:
            pulumi.set(__self__, "function_alias", function_alias)
        if workspace_id is not None:
            pulumi.set(__self__, "workspace_id", workspace_id)

    @property
    @pulumi.getter(name="functionAlias")
    def function_alias(self) -> Optional[pulumi.Input[str]]:
        """
        Log Analytics Saved Search name.
        """
        return pulumi.get(self, "function_alias")

    @function_alias.setter
    def function_alias(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "function_alias", value)

    @property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> Optional[pulumi.Input[str]]:
        """
        Workspace Id for Log Analytics in which the saved Search is resided.
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "workspace_id", value)


@pulumi.input_type
class PrivateEndpointPropertyArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[str]] = None):
        """
        Private endpoint which the connection belongs to.
        :param pulumi.Input[str] id: Resource id of the private endpoint.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource id of the private endpoint.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)


@pulumi.input_type
class PrivateLinkServiceConnectionStatePropertyArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None):
        """
        Connection State of the Private Endpoint Connection.
        :param pulumi.Input[str] description: The private link service connection description.
        :param pulumi.Input[str] status: The private link service connection status.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The private link service connection description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The private link service connection status.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class RunAsCredentialAssociationPropertyArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None):
        """
        Definition of RunAs credential to use for hybrid worker.
        :param pulumi.Input[str] name: Gets or sets the name of the credential.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the name of the credential.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class RunbookAssociationPropertyArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None):
        """
        The runbook property associated with the entity.
        :param pulumi.Input[str] name: Gets or sets the name of the runbook.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the name of the runbook.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class RunbookDraftArgs:
    def __init__(__self__, *,
                 creation_time: Optional[pulumi.Input[str]] = None,
                 draft_content_link: Optional[pulumi.Input['ContentLinkArgs']] = None,
                 in_edit: Optional[pulumi.Input[bool]] = None,
                 last_modified_time: Optional[pulumi.Input[str]] = None,
                 output_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input['RunbookParameterArgs']]]] = None):
        """
        :param pulumi.Input[str] creation_time: Gets or sets the creation time of the runbook draft.
        :param pulumi.Input['ContentLinkArgs'] draft_content_link: Gets or sets the draft runbook content link.
        :param pulumi.Input[bool] in_edit: Gets or sets whether runbook is in edit mode.
        :param pulumi.Input[str] last_modified_time: Gets or sets the last modified time of the runbook draft.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] output_types: Gets or sets the runbook output types.
        :param pulumi.Input[Mapping[str, pulumi.Input['RunbookParameterArgs']]] parameters: Gets or sets the runbook draft parameters.
        """
        if creation_time is not None:
            pulumi.set(__self__, "creation_time", creation_time)
        if draft_content_link is not None:
            pulumi.set(__self__, "draft_content_link", draft_content_link)
        if in_edit is not None:
            pulumi.set(__self__, "in_edit", in_edit)
        if last_modified_time is not None:
            pulumi.set(__self__, "last_modified_time", last_modified_time)
        if output_types is not None:
            pulumi.set(__self__, "output_types", output_types)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the creation time of the runbook draft.
        """
        return pulumi.get(self, "creation_time")

    @creation_time.setter
    def creation_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "creation_time", value)

    @property
    @pulumi.getter(name="draftContentLink")
    def draft_content_link(self) -> Optional[pulumi.Input['ContentLinkArgs']]:
        """
        Gets or sets the draft runbook content link.
        """
        return pulumi.get(self, "draft_content_link")

    @draft_content_link.setter
    def draft_content_link(self, value: Optional[pulumi.Input['ContentLinkArgs']]):
        pulumi.set(self, "draft_content_link", value)

    @property
    @pulumi.getter(name="inEdit")
    def in_edit(self) -> Optional[pulumi.Input[bool]]:
        """
        Gets or sets whether runbook is in edit mode.
        """
        return pulumi.get(self, "in_edit")

    @in_edit.setter
    def in_edit(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "in_edit", value)

    @property
    @pulumi.getter(name="lastModifiedTime")
    def last_modified_time(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the last modified time of the runbook draft.
        """
        return pulumi.get(self, "last_modified_time")

    @last_modified_time.setter
    def last_modified_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_modified_time", value)

    @property
    @pulumi.getter(name="outputTypes")
    def output_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Gets or sets the runbook output types.
        """
        return pulumi.get(self, "output_types")

    @output_types.setter
    def output_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "output_types", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['RunbookParameterArgs']]]]:
        """
        Gets or sets the runbook draft parameters.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['RunbookParameterArgs']]]]):
        pulumi.set(self, "parameters", value)


@pulumi.input_type
class RunbookParameterArgs:
    def __init__(__self__, *,
                 default_value: Optional[pulumi.Input[str]] = None,
                 is_mandatory: Optional[pulumi.Input[bool]] = None,
                 position: Optional[pulumi.Input[int]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        Definition of the runbook parameter type.
        :param pulumi.Input[str] default_value: Gets or sets the default value of parameter.
        :param pulumi.Input[bool] is_mandatory: Gets or sets a Boolean value to indicate whether the parameter is mandatory or not.
        :param pulumi.Input[int] position: Get or sets the position of the parameter.
        :param pulumi.Input[str] type: Gets or sets the type of the parameter.
        """
        if default_value is not None:
            pulumi.set(__self__, "default_value", default_value)
        if is_mandatory is not None:
            pulumi.set(__self__, "is_mandatory", is_mandatory)
        if position is not None:
            pulumi.set(__self__, "position", position)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="defaultValue")
    def default_value(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the default value of parameter.
        """
        return pulumi.get(self, "default_value")

    @default_value.setter
    def default_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_value", value)

    @property
    @pulumi.getter(name="isMandatory")
    def is_mandatory(self) -> Optional[pulumi.Input[bool]]:
        """
        Gets or sets a Boolean value to indicate whether the parameter is mandatory or not.
        """
        return pulumi.get(self, "is_mandatory")

    @is_mandatory.setter
    def is_mandatory(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_mandatory", value)

    @property
    @pulumi.getter
    def position(self) -> Optional[pulumi.Input[int]]:
        """
        Get or sets the position of the parameter.
        """
        return pulumi.get(self, "position")

    @position.setter
    def position(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "position", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the type of the parameter.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class SUCSchedulePropertiesArgs:
    def __init__(__self__, *,
                 advanced_schedule: Optional[pulumi.Input['AdvancedScheduleArgs']] = None,
                 creation_time: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 expiry_time: Optional[pulumi.Input[str]] = None,
                 expiry_time_offset_minutes: Optional[pulumi.Input[float]] = None,
                 frequency: Optional[pulumi.Input[Union[str, 'ScheduleFrequency']]] = None,
                 interval: Optional[pulumi.Input[float]] = None,
                 is_enabled: Optional[pulumi.Input[bool]] = None,
                 last_modified_time: Optional[pulumi.Input[str]] = None,
                 next_run: Optional[pulumi.Input[str]] = None,
                 next_run_offset_minutes: Optional[pulumi.Input[float]] = None,
                 start_time: Optional[pulumi.Input[str]] = None,
                 time_zone: Optional[pulumi.Input[str]] = None):
        """
        Definition of schedule parameters.
        :param pulumi.Input['AdvancedScheduleArgs'] advanced_schedule: Gets or sets the advanced schedule.
        :param pulumi.Input[str] creation_time: Gets or sets the creation time.
        :param pulumi.Input[str] description: Gets or sets the description.
        :param pulumi.Input[str] expiry_time: Gets or sets the end time of the schedule.
        :param pulumi.Input[float] expiry_time_offset_minutes: Gets or sets the expiry time's offset in minutes.
        :param pulumi.Input[Union[str, 'ScheduleFrequency']] frequency: Gets or sets the frequency of the schedule.
        :param pulumi.Input[float] interval: Gets or sets the interval of the schedule.
        :param pulumi.Input[bool] is_enabled: Gets or sets a value indicating whether this schedule is enabled.
        :param pulumi.Input[str] last_modified_time: Gets or sets the last modified time.
        :param pulumi.Input[str] next_run: Gets or sets the next run time of the schedule.
        :param pulumi.Input[float] next_run_offset_minutes: Gets or sets the next run time's offset in minutes.
        :param pulumi.Input[str] start_time: Gets or sets the start time of the schedule.
        :param pulumi.Input[str] time_zone: Gets or sets the time zone of the schedule.
        """
        if advanced_schedule is not None:
            pulumi.set(__self__, "advanced_schedule", advanced_schedule)
        if creation_time is not None:
            pulumi.set(__self__, "creation_time", creation_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if expiry_time is not None:
            pulumi.set(__self__, "expiry_time", expiry_time)
        if expiry_time_offset_minutes is not None:
            pulumi.set(__self__, "expiry_time_offset_minutes", expiry_time_offset_minutes)
        if frequency is not None:
            pulumi.set(__self__, "frequency", frequency)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if is_enabled is None:
            is_enabled = False
        if is_enabled is not None:
            pulumi.set(__self__, "is_enabled", is_enabled)
        if last_modified_time is not None:
            pulumi.set(__self__, "last_modified_time", last_modified_time)
        if next_run is not None:
            pulumi.set(__self__, "next_run", next_run)
        if next_run_offset_minutes is not None:
            pulumi.set(__self__, "next_run_offset_minutes", next_run_offset_minutes)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)

    @property
    @pulumi.getter(name="advancedSchedule")
    def advanced_schedule(self) -> Optional[pulumi.Input['AdvancedScheduleArgs']]:
        """
        Gets or sets the advanced schedule.
        """
        return pulumi.get(self, "advanced_schedule")

    @advanced_schedule.setter
    def advanced_schedule(self, value: Optional[pulumi.Input['AdvancedScheduleArgs']]):
        pulumi.set(self, "advanced_schedule", value)

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the creation time.
        """
        return pulumi.get(self, "creation_time")

    @creation_time.setter
    def creation_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "creation_time", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="expiryTime")
    def expiry_time(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the end time of the schedule.
        """
        return pulumi.get(self, "expiry_time")

    @expiry_time.setter
    def expiry_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expiry_time", value)

    @property
    @pulumi.getter(name="expiryTimeOffsetMinutes")
    def expiry_time_offset_minutes(self) -> Optional[pulumi.Input[float]]:
        """
        Gets or sets the expiry time's offset in minutes.
        """
        return pulumi.get(self, "expiry_time_offset_minutes")

    @expiry_time_offset_minutes.setter
    def expiry_time_offset_minutes(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "expiry_time_offset_minutes", value)

    @property
    @pulumi.getter
    def frequency(self) -> Optional[pulumi.Input[Union[str, 'ScheduleFrequency']]]:
        """
        Gets or sets the frequency of the schedule.
        """
        return pulumi.get(self, "frequency")

    @frequency.setter
    def frequency(self, value: Optional[pulumi.Input[Union[str, 'ScheduleFrequency']]]):
        pulumi.set(self, "frequency", value)

    @property
    @pulumi.getter
    def interval(self) -> Optional[pulumi.Input[float]]:
        """
        Gets or sets the interval of the schedule.
        """
        return pulumi.get(self, "interval")

    @interval.setter
    def interval(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "interval", value)

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Gets or sets a value indicating whether this schedule is enabled.
        """
        return pulumi.get(self, "is_enabled")

    @is_enabled.setter
    def is_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_enabled", value)

    @property
    @pulumi.getter(name="lastModifiedTime")
    def last_modified_time(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the last modified time.
        """
        return pulumi.get(self, "last_modified_time")

    @last_modified_time.setter
    def last_modified_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_modified_time", value)

    @property
    @pulumi.getter(name="nextRun")
    def next_run(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the next run time of the schedule.
        """
        return pulumi.get(self, "next_run")

    @next_run.setter
    def next_run(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "next_run", value)

    @property
    @pulumi.getter(name="nextRunOffsetMinutes")
    def next_run_offset_minutes(self) -> Optional[pulumi.Input[float]]:
        """
        Gets or sets the next run time's offset in minutes.
        """
        return pulumi.get(self, "next_run_offset_minutes")

    @next_run_offset_minutes.setter
    def next_run_offset_minutes(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "next_run_offset_minutes", value)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the start time of the schedule.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "start_time", value)

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the time zone of the schedule.
        """
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_zone", value)


@pulumi.input_type
class ScheduleAssociationPropertyArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None):
        """
        The schedule property associated with the entity.
        :param pulumi.Input[str] name: Gets or sets the name of the Schedule.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the name of the Schedule.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class SkuArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[Union[str, 'SkuNameEnum']],
                 capacity: Optional[pulumi.Input[int]] = None,
                 family: Optional[pulumi.Input[str]] = None):
        """
        The account SKU.
        :param pulumi.Input[Union[str, 'SkuNameEnum']] name: Gets or sets the SKU name of the account.
        :param pulumi.Input[int] capacity: Gets or sets the SKU capacity.
        :param pulumi.Input[str] family: Gets or sets the SKU family.
        """
        pulumi.set(__self__, "name", name)
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if family is not None:
            pulumi.set(__self__, "family", family)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[Union[str, 'SkuNameEnum']]:
        """
        Gets or sets the SKU name of the account.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[Union[str, 'SkuNameEnum']]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def capacity(self) -> Optional[pulumi.Input[int]]:
        """
        Gets or sets the SKU capacity.
        """
        return pulumi.get(self, "capacity")

    @capacity.setter
    def capacity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "capacity", value)

    @property
    @pulumi.getter
    def family(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the SKU family.
        """
        return pulumi.get(self, "family")

    @family.setter
    def family(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "family", value)


@pulumi.input_type
class SoftwareUpdateConfigurationTasksArgs:
    def __init__(__self__, *,
                 post_task: Optional[pulumi.Input['TaskPropertiesArgs']] = None,
                 pre_task: Optional[pulumi.Input['TaskPropertiesArgs']] = None):
        """
        Task properties of the software update configuration.
        :param pulumi.Input['TaskPropertiesArgs'] post_task: Post task properties.
        :param pulumi.Input['TaskPropertiesArgs'] pre_task: Pre task properties.
        """
        if post_task is not None:
            pulumi.set(__self__, "post_task", post_task)
        if pre_task is not None:
            pulumi.set(__self__, "pre_task", pre_task)

    @property
    @pulumi.getter(name="postTask")
    def post_task(self) -> Optional[pulumi.Input['TaskPropertiesArgs']]:
        """
        Post task properties.
        """
        return pulumi.get(self, "post_task")

    @post_task.setter
    def post_task(self, value: Optional[pulumi.Input['TaskPropertiesArgs']]):
        pulumi.set(self, "post_task", value)

    @property
    @pulumi.getter(name="preTask")
    def pre_task(self) -> Optional[pulumi.Input['TaskPropertiesArgs']]:
        """
        Pre task properties.
        """
        return pulumi.get(self, "pre_task")

    @pre_task.setter
    def pre_task(self, value: Optional[pulumi.Input['TaskPropertiesArgs']]):
        pulumi.set(self, "pre_task", value)


@pulumi.input_type
class SourceControlSecurityTokenPropertiesArgs:
    def __init__(__self__, *,
                 access_token: Optional[pulumi.Input[str]] = None,
                 refresh_token: Optional[pulumi.Input[str]] = None,
                 token_type: Optional[pulumi.Input[Union[str, 'TokenType']]] = None):
        """
        :param pulumi.Input[str] access_token: The access token.
        :param pulumi.Input[str] refresh_token: The refresh token.
        :param pulumi.Input[Union[str, 'TokenType']] token_type: The token type. Must be either PersonalAccessToken or Oauth.
        """
        if access_token is not None:
            pulumi.set(__self__, "access_token", access_token)
        if refresh_token is not None:
            pulumi.set(__self__, "refresh_token", refresh_token)
        if token_type is not None:
            pulumi.set(__self__, "token_type", token_type)

    @property
    @pulumi.getter(name="accessToken")
    def access_token(self) -> Optional[pulumi.Input[str]]:
        """
        The access token.
        """
        return pulumi.get(self, "access_token")

    @access_token.setter
    def access_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access_token", value)

    @property
    @pulumi.getter(name="refreshToken")
    def refresh_token(self) -> Optional[pulumi.Input[str]]:
        """
        The refresh token.
        """
        return pulumi.get(self, "refresh_token")

    @refresh_token.setter
    def refresh_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "refresh_token", value)

    @property
    @pulumi.getter(name="tokenType")
    def token_type(self) -> Optional[pulumi.Input[Union[str, 'TokenType']]]:
        """
        The token type. Must be either PersonalAccessToken or Oauth.
        """
        return pulumi.get(self, "token_type")

    @token_type.setter
    def token_type(self, value: Optional[pulumi.Input[Union[str, 'TokenType']]]):
        pulumi.set(self, "token_type", value)


@pulumi.input_type
class TagSettingsPropertiesArgs:
    def __init__(__self__, *,
                 filter_operator: Optional[pulumi.Input['TagOperators']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[Sequence[pulumi.Input[str]]]]]] = None):
        """
        Tag filter information for the VM.
        :param pulumi.Input['TagOperators'] filter_operator: Filter VMs by Any or All specified tags.
        :param pulumi.Input[Mapping[str, pulumi.Input[Sequence[pulumi.Input[str]]]]] tags: Dictionary of tags with its list of values.
        """
        if filter_operator is not None:
            pulumi.set(__self__, "filter_operator", filter_operator)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="filterOperator")
    def filter_operator(self) -> Optional[pulumi.Input['TagOperators']]:
        """
        Filter VMs by Any or All specified tags.
        """
        return pulumi.get(self, "filter_operator")

    @filter_operator.setter
    def filter_operator(self, value: Optional[pulumi.Input['TagOperators']]):
        pulumi.set(self, "filter_operator", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[Sequence[pulumi.Input[str]]]]]]:
        """
        Dictionary of tags with its list of values.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[Sequence[pulumi.Input[str]]]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class TargetPropertiesArgs:
    def __init__(__self__, *,
                 azure_queries: Optional[pulumi.Input[Sequence[pulumi.Input['AzureQueryPropertiesArgs']]]] = None,
                 non_azure_queries: Optional[pulumi.Input[Sequence[pulumi.Input['NonAzureQueryPropertiesArgs']]]] = None):
        """
        Group specific to the update configuration.
        :param pulumi.Input[Sequence[pulumi.Input['AzureQueryPropertiesArgs']]] azure_queries: List of Azure queries in the software update configuration.
        :param pulumi.Input[Sequence[pulumi.Input['NonAzureQueryPropertiesArgs']]] non_azure_queries: List of non Azure queries in the software update configuration.
        """
        if azure_queries is not None:
            pulumi.set(__self__, "azure_queries", azure_queries)
        if non_azure_queries is not None:
            pulumi.set(__self__, "non_azure_queries", non_azure_queries)

    @property
    @pulumi.getter(name="azureQueries")
    def azure_queries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AzureQueryPropertiesArgs']]]]:
        """
        List of Azure queries in the software update configuration.
        """
        return pulumi.get(self, "azure_queries")

    @azure_queries.setter
    def azure_queries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AzureQueryPropertiesArgs']]]]):
        pulumi.set(self, "azure_queries", value)

    @property
    @pulumi.getter(name="nonAzureQueries")
    def non_azure_queries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NonAzureQueryPropertiesArgs']]]]:
        """
        List of non Azure queries in the software update configuration.
        """
        return pulumi.get(self, "non_azure_queries")

    @non_azure_queries.setter
    def non_azure_queries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NonAzureQueryPropertiesArgs']]]]):
        pulumi.set(self, "non_azure_queries", value)


@pulumi.input_type
class TaskPropertiesArgs:
    def __init__(__self__, *,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 source: Optional[pulumi.Input[str]] = None):
        """
        Task properties of the software update configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] parameters: Gets or sets the parameters of the task.
        :param pulumi.Input[str] source: Gets or sets the name of the runbook.
        """
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if source is not None:
            pulumi.set(__self__, "source", source)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Gets or sets the parameters of the task.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the name of the runbook.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source", value)


@pulumi.input_type
class UpdateConfigurationArgs:
    def __init__(__self__, *,
                 operating_system: pulumi.Input['OperatingSystemType'],
                 azure_virtual_machines: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 duration: Optional[pulumi.Input[str]] = None,
                 linux: Optional[pulumi.Input['LinuxPropertiesArgs']] = None,
                 non_azure_computer_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 targets: Optional[pulumi.Input['TargetPropertiesArgs']] = None,
                 windows: Optional[pulumi.Input['WindowsPropertiesArgs']] = None):
        """
        Update specific properties of the software update configuration.
        :param pulumi.Input['OperatingSystemType'] operating_system: operating system of target machines
        :param pulumi.Input[Sequence[pulumi.Input[str]]] azure_virtual_machines: List of azure resource Ids for azure virtual machines targeted by the software update configuration.
        :param pulumi.Input[str] duration: Maximum time allowed for the software update configuration run. Duration needs to be specified using the format PT[n]H[n]M[n]S as per ISO8601
        :param pulumi.Input['LinuxPropertiesArgs'] linux: Linux specific update configuration.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] non_azure_computer_names: List of names of non-azure machines targeted by the software update configuration.
        :param pulumi.Input['TargetPropertiesArgs'] targets: Group targets for the software update configuration.
        :param pulumi.Input['WindowsPropertiesArgs'] windows: Windows specific update configuration.
        """
        pulumi.set(__self__, "operating_system", operating_system)
        if azure_virtual_machines is not None:
            pulumi.set(__self__, "azure_virtual_machines", azure_virtual_machines)
        if duration is not None:
            pulumi.set(__self__, "duration", duration)
        if linux is not None:
            pulumi.set(__self__, "linux", linux)
        if non_azure_computer_names is not None:
            pulumi.set(__self__, "non_azure_computer_names", non_azure_computer_names)
        if targets is not None:
            pulumi.set(__self__, "targets", targets)
        if windows is not None:
            pulumi.set(__self__, "windows", windows)

    @property
    @pulumi.getter(name="operatingSystem")
    def operating_system(self) -> pulumi.Input['OperatingSystemType']:
        """
        operating system of target machines
        """
        return pulumi.get(self, "operating_system")

    @operating_system.setter
    def operating_system(self, value: pulumi.Input['OperatingSystemType']):
        pulumi.set(self, "operating_system", value)

    @property
    @pulumi.getter(name="azureVirtualMachines")
    def azure_virtual_machines(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of azure resource Ids for azure virtual machines targeted by the software update configuration.
        """
        return pulumi.get(self, "azure_virtual_machines")

    @azure_virtual_machines.setter
    def azure_virtual_machines(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "azure_virtual_machines", value)

    @property
    @pulumi.getter
    def duration(self) -> Optional[pulumi.Input[str]]:
        """
        Maximum time allowed for the software update configuration run. Duration needs to be specified using the format PT[n]H[n]M[n]S as per ISO8601
        """
        return pulumi.get(self, "duration")

    @duration.setter
    def duration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "duration", value)

    @property
    @pulumi.getter
    def linux(self) -> Optional[pulumi.Input['LinuxPropertiesArgs']]:
        """
        Linux specific update configuration.
        """
        return pulumi.get(self, "linux")

    @linux.setter
    def linux(self, value: Optional[pulumi.Input['LinuxPropertiesArgs']]):
        pulumi.set(self, "linux", value)

    @property
    @pulumi.getter(name="nonAzureComputerNames")
    def non_azure_computer_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of names of non-azure machines targeted by the software update configuration.
        """
        return pulumi.get(self, "non_azure_computer_names")

    @non_azure_computer_names.setter
    def non_azure_computer_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "non_azure_computer_names", value)

    @property
    @pulumi.getter
    def targets(self) -> Optional[pulumi.Input['TargetPropertiesArgs']]:
        """
        Group targets for the software update configuration.
        """
        return pulumi.get(self, "targets")

    @targets.setter
    def targets(self, value: Optional[pulumi.Input['TargetPropertiesArgs']]):
        pulumi.set(self, "targets", value)

    @property
    @pulumi.getter
    def windows(self) -> Optional[pulumi.Input['WindowsPropertiesArgs']]:
        """
        Windows specific update configuration.
        """
        return pulumi.get(self, "windows")

    @windows.setter
    def windows(self, value: Optional[pulumi.Input['WindowsPropertiesArgs']]):
        pulumi.set(self, "windows", value)


@pulumi.input_type
class WindowsPropertiesArgs:
    def __init__(__self__, *,
                 excluded_kb_numbers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 included_kb_numbers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 included_update_classifications: Optional[pulumi.Input[Union[str, 'WindowsUpdateClasses']]] = None,
                 reboot_setting: Optional[pulumi.Input[str]] = None):
        """
        Windows specific update configuration.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] excluded_kb_numbers: KB numbers excluded from the software update configuration.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] included_kb_numbers: KB numbers included from the software update configuration.
        :param pulumi.Input[Union[str, 'WindowsUpdateClasses']] included_update_classifications: Update classification included in the software update configuration. A comma separated string with required values
        :param pulumi.Input[str] reboot_setting: Reboot setting for the software update configuration.
        """
        if excluded_kb_numbers is not None:
            pulumi.set(__self__, "excluded_kb_numbers", excluded_kb_numbers)
        if included_kb_numbers is not None:
            pulumi.set(__self__, "included_kb_numbers", included_kb_numbers)
        if included_update_classifications is not None:
            pulumi.set(__self__, "included_update_classifications", included_update_classifications)
        if reboot_setting is not None:
            pulumi.set(__self__, "reboot_setting", reboot_setting)

    @property
    @pulumi.getter(name="excludedKbNumbers")
    def excluded_kb_numbers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        KB numbers excluded from the software update configuration.
        """
        return pulumi.get(self, "excluded_kb_numbers")

    @excluded_kb_numbers.setter
    def excluded_kb_numbers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "excluded_kb_numbers", value)

    @property
    @pulumi.getter(name="includedKbNumbers")
    def included_kb_numbers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        KB numbers included from the software update configuration.
        """
        return pulumi.get(self, "included_kb_numbers")

    @included_kb_numbers.setter
    def included_kb_numbers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "included_kb_numbers", value)

    @property
    @pulumi.getter(name="includedUpdateClassifications")
    def included_update_classifications(self) -> Optional[pulumi.Input[Union[str, 'WindowsUpdateClasses']]]:
        """
        Update classification included in the software update configuration. A comma separated string with required values
        """
        return pulumi.get(self, "included_update_classifications")

    @included_update_classifications.setter
    def included_update_classifications(self, value: Optional[pulumi.Input[Union[str, 'WindowsUpdateClasses']]]):
        pulumi.set(self, "included_update_classifications", value)

    @property
    @pulumi.getter(name="rebootSetting")
    def reboot_setting(self) -> Optional[pulumi.Input[str]]:
        """
        Reboot setting for the software update configuration.
        """
        return pulumi.get(self, "reboot_setting")

    @reboot_setting.setter
    def reboot_setting(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "reboot_setting", value)


