# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'ConfigDiagnosticsResponse',
    'ConfigDiagnosticsValidatorResultIssueResponse',
    'ConfigDiagnosticsValidatorResultResponse',
    'ContainerAccountResponse',
    'DomainSecuritySettingsResponse',
    'ForestTrustResponse',
    'HealthAlertResponse',
    'HealthMonitorResponse',
    'LdapsSettingsResponse',
    'MigrationProgressResponse',
    'MigrationPropertiesResponse',
    'NotificationSettingsResponse',
    'ReplicaSetResponse',
    'ResourceForestSettingsResponse',
    'SystemDataResponse',
]

@pulumi.output_type
class ConfigDiagnosticsResponse(dict):
    """
    Configuration Diagnostics
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lastExecuted":
            suggest = "last_executed"
        elif key == "validatorResults":
            suggest = "validator_results"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConfigDiagnosticsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConfigDiagnosticsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConfigDiagnosticsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 last_executed: Optional[str] = None,
                 validator_results: Optional[Sequence['outputs.ConfigDiagnosticsValidatorResultResponse']] = None):
        """
        Configuration Diagnostics
        :param str last_executed: Last domain configuration diagnostics DateTime
        :param Sequence['ConfigDiagnosticsValidatorResultResponse'] validator_results: List of Configuration Diagnostics validator results.
        """
        if last_executed is not None:
            pulumi.set(__self__, "last_executed", last_executed)
        if validator_results is not None:
            pulumi.set(__self__, "validator_results", validator_results)

    @property
    @pulumi.getter(name="lastExecuted")
    def last_executed(self) -> Optional[str]:
        """
        Last domain configuration diagnostics DateTime
        """
        return pulumi.get(self, "last_executed")

    @property
    @pulumi.getter(name="validatorResults")
    def validator_results(self) -> Optional[Sequence['outputs.ConfigDiagnosticsValidatorResultResponse']]:
        """
        List of Configuration Diagnostics validator results.
        """
        return pulumi.get(self, "validator_results")


@pulumi.output_type
class ConfigDiagnosticsValidatorResultIssueResponse(dict):
    """
    Specific issue for a particular config diagnostics validator
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "descriptionParams":
            suggest = "description_params"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConfigDiagnosticsValidatorResultIssueResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConfigDiagnosticsValidatorResultIssueResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConfigDiagnosticsValidatorResultIssueResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 description_params: Optional[Sequence[str]] = None,
                 id: Optional[str] = None):
        """
        Specific issue for a particular config diagnostics validator
        :param Sequence[str] description_params: List of domain resource property name or values used to compose a rich description.
        :param str id: Validation issue identifier.
        """
        if description_params is not None:
            pulumi.set(__self__, "description_params", description_params)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter(name="descriptionParams")
    def description_params(self) -> Optional[Sequence[str]]:
        """
        List of domain resource property name or values used to compose a rich description.
        """
        return pulumi.get(self, "description_params")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Validation issue identifier.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class ConfigDiagnosticsValidatorResultResponse(dict):
    """
    Config Diagnostics validator result data
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "replicaSetSubnetDisplayName":
            suggest = "replica_set_subnet_display_name"
        elif key == "validatorId":
            suggest = "validator_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConfigDiagnosticsValidatorResultResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConfigDiagnosticsValidatorResultResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConfigDiagnosticsValidatorResultResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 issues: Optional[Sequence['outputs.ConfigDiagnosticsValidatorResultIssueResponse']] = None,
                 replica_set_subnet_display_name: Optional[str] = None,
                 status: Optional[str] = None,
                 validator_id: Optional[str] = None):
        """
        Config Diagnostics validator result data
        :param Sequence['ConfigDiagnosticsValidatorResultIssueResponse'] issues: List of resource config validation issues.
        :param str replica_set_subnet_display_name: Replica set location and subnet name
        :param str status: Status for individual validator after running diagnostics.
        :param str validator_id: Validator identifier
        """
        if issues is not None:
            pulumi.set(__self__, "issues", issues)
        if replica_set_subnet_display_name is not None:
            pulumi.set(__self__, "replica_set_subnet_display_name", replica_set_subnet_display_name)
        if status is None:
            status = 'None'
        if status is not None:
            pulumi.set(__self__, "status", status)
        if validator_id is not None:
            pulumi.set(__self__, "validator_id", validator_id)

    @property
    @pulumi.getter
    def issues(self) -> Optional[Sequence['outputs.ConfigDiagnosticsValidatorResultIssueResponse']]:
        """
        List of resource config validation issues.
        """
        return pulumi.get(self, "issues")

    @property
    @pulumi.getter(name="replicaSetSubnetDisplayName")
    def replica_set_subnet_display_name(self) -> Optional[str]:
        """
        Replica set location and subnet name
        """
        return pulumi.get(self, "replica_set_subnet_display_name")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        Status for individual validator after running diagnostics.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="validatorId")
    def validator_id(self) -> Optional[str]:
        """
        Validator identifier
        """
        return pulumi.get(self, "validator_id")


@pulumi.output_type
class ContainerAccountResponse(dict):
    """
    Container Account Description
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accountName":
            suggest = "account_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerAccountResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerAccountResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerAccountResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 account_name: Optional[str] = None,
                 password: Optional[str] = None,
                 spn: Optional[str] = None):
        """
        Container Account Description
        :param str account_name: The account name
        :param str password: The account password
        :param str spn: The account spn
        """
        if account_name is not None:
            pulumi.set(__self__, "account_name", account_name)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if spn is not None:
            pulumi.set(__self__, "spn", spn)

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> Optional[str]:
        """
        The account name
        """
        return pulumi.get(self, "account_name")

    @property
    @pulumi.getter
    def password(self) -> Optional[str]:
        """
        The account password
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def spn(self) -> Optional[str]:
        """
        The account spn
        """
        return pulumi.get(self, "spn")


@pulumi.output_type
class DomainSecuritySettingsResponse(dict):
    """
    Domain Security Settings
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kerberosArmoring":
            suggest = "kerberos_armoring"
        elif key == "kerberosRc4Encryption":
            suggest = "kerberos_rc4_encryption"
        elif key == "ntlmV1":
            suggest = "ntlm_v1"
        elif key == "syncKerberosPasswords":
            suggest = "sync_kerberos_passwords"
        elif key == "syncNtlmPasswords":
            suggest = "sync_ntlm_passwords"
        elif key == "syncOnPremPasswords":
            suggest = "sync_on_prem_passwords"
        elif key == "tlsV1":
            suggest = "tls_v1"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainSecuritySettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainSecuritySettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainSecuritySettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kerberos_armoring: Optional[str] = None,
                 kerberos_rc4_encryption: Optional[str] = None,
                 ntlm_v1: Optional[str] = None,
                 sync_kerberos_passwords: Optional[str] = None,
                 sync_ntlm_passwords: Optional[str] = None,
                 sync_on_prem_passwords: Optional[str] = None,
                 tls_v1: Optional[str] = None):
        """
        Domain Security Settings
        :param str kerberos_armoring: A flag to determine whether or not KerberosArmoring is enabled or disabled.
        :param str kerberos_rc4_encryption: A flag to determine whether or not KerberosRc4Encryption is enabled or disabled.
        :param str ntlm_v1: A flag to determine whether or not NtlmV1 is enabled or disabled.
        :param str sync_kerberos_passwords: A flag to determine whether or not SyncKerberosPasswords is enabled or disabled.
        :param str sync_ntlm_passwords: A flag to determine whether or not SyncNtlmPasswords is enabled or disabled.
        :param str sync_on_prem_passwords: A flag to determine whether or not SyncOnPremPasswords is enabled or disabled.
        :param str tls_v1: A flag to determine whether or not TlsV1 is enabled or disabled.
        """
        if kerberos_armoring is None:
            kerberos_armoring = 'Disabled'
        if kerberos_armoring is not None:
            pulumi.set(__self__, "kerberos_armoring", kerberos_armoring)
        if kerberos_rc4_encryption is None:
            kerberos_rc4_encryption = 'Enabled'
        if kerberos_rc4_encryption is not None:
            pulumi.set(__self__, "kerberos_rc4_encryption", kerberos_rc4_encryption)
        if ntlm_v1 is None:
            ntlm_v1 = 'Enabled'
        if ntlm_v1 is not None:
            pulumi.set(__self__, "ntlm_v1", ntlm_v1)
        if sync_kerberos_passwords is None:
            sync_kerberos_passwords = 'Enabled'
        if sync_kerberos_passwords is not None:
            pulumi.set(__self__, "sync_kerberos_passwords", sync_kerberos_passwords)
        if sync_ntlm_passwords is None:
            sync_ntlm_passwords = 'Enabled'
        if sync_ntlm_passwords is not None:
            pulumi.set(__self__, "sync_ntlm_passwords", sync_ntlm_passwords)
        if sync_on_prem_passwords is None:
            sync_on_prem_passwords = 'Enabled'
        if sync_on_prem_passwords is not None:
            pulumi.set(__self__, "sync_on_prem_passwords", sync_on_prem_passwords)
        if tls_v1 is None:
            tls_v1 = 'Enabled'
        if tls_v1 is not None:
            pulumi.set(__self__, "tls_v1", tls_v1)

    @property
    @pulumi.getter(name="kerberosArmoring")
    def kerberos_armoring(self) -> Optional[str]:
        """
        A flag to determine whether or not KerberosArmoring is enabled or disabled.
        """
        return pulumi.get(self, "kerberos_armoring")

    @property
    @pulumi.getter(name="kerberosRc4Encryption")
    def kerberos_rc4_encryption(self) -> Optional[str]:
        """
        A flag to determine whether or not KerberosRc4Encryption is enabled or disabled.
        """
        return pulumi.get(self, "kerberos_rc4_encryption")

    @property
    @pulumi.getter(name="ntlmV1")
    def ntlm_v1(self) -> Optional[str]:
        """
        A flag to determine whether or not NtlmV1 is enabled or disabled.
        """
        return pulumi.get(self, "ntlm_v1")

    @property
    @pulumi.getter(name="syncKerberosPasswords")
    def sync_kerberos_passwords(self) -> Optional[str]:
        """
        A flag to determine whether or not SyncKerberosPasswords is enabled or disabled.
        """
        return pulumi.get(self, "sync_kerberos_passwords")

    @property
    @pulumi.getter(name="syncNtlmPasswords")
    def sync_ntlm_passwords(self) -> Optional[str]:
        """
        A flag to determine whether or not SyncNtlmPasswords is enabled or disabled.
        """
        return pulumi.get(self, "sync_ntlm_passwords")

    @property
    @pulumi.getter(name="syncOnPremPasswords")
    def sync_on_prem_passwords(self) -> Optional[str]:
        """
        A flag to determine whether or not SyncOnPremPasswords is enabled or disabled.
        """
        return pulumi.get(self, "sync_on_prem_passwords")

    @property
    @pulumi.getter(name="tlsV1")
    def tls_v1(self) -> Optional[str]:
        """
        A flag to determine whether or not TlsV1 is enabled or disabled.
        """
        return pulumi.get(self, "tls_v1")


@pulumi.output_type
class ForestTrustResponse(dict):
    """
    Forest Trust Setting
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "friendlyName":
            suggest = "friendly_name"
        elif key == "remoteDnsIps":
            suggest = "remote_dns_ips"
        elif key == "trustDirection":
            suggest = "trust_direction"
        elif key == "trustPassword":
            suggest = "trust_password"
        elif key == "trustedDomainFqdn":
            suggest = "trusted_domain_fqdn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ForestTrustResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ForestTrustResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ForestTrustResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 friendly_name: Optional[str] = None,
                 remote_dns_ips: Optional[str] = None,
                 trust_direction: Optional[str] = None,
                 trust_password: Optional[str] = None,
                 trusted_domain_fqdn: Optional[str] = None):
        """
        Forest Trust Setting
        :param str friendly_name: Friendly Name
        :param str remote_dns_ips: Remote Dns ips
        :param str trust_direction: Trust Direction
        :param str trust_password: Trust Password
        :param str trusted_domain_fqdn: Trusted Domain FQDN
        """
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if remote_dns_ips is not None:
            pulumi.set(__self__, "remote_dns_ips", remote_dns_ips)
        if trust_direction is not None:
            pulumi.set(__self__, "trust_direction", trust_direction)
        if trust_password is not None:
            pulumi.set(__self__, "trust_password", trust_password)
        if trusted_domain_fqdn is not None:
            pulumi.set(__self__, "trusted_domain_fqdn", trusted_domain_fqdn)

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[str]:
        """
        Friendly Name
        """
        return pulumi.get(self, "friendly_name")

    @property
    @pulumi.getter(name="remoteDnsIps")
    def remote_dns_ips(self) -> Optional[str]:
        """
        Remote Dns ips
        """
        return pulumi.get(self, "remote_dns_ips")

    @property
    @pulumi.getter(name="trustDirection")
    def trust_direction(self) -> Optional[str]:
        """
        Trust Direction
        """
        return pulumi.get(self, "trust_direction")

    @property
    @pulumi.getter(name="trustPassword")
    def trust_password(self) -> Optional[str]:
        """
        Trust Password
        """
        return pulumi.get(self, "trust_password")

    @property
    @pulumi.getter(name="trustedDomainFqdn")
    def trusted_domain_fqdn(self) -> Optional[str]:
        """
        Trusted Domain FQDN
        """
        return pulumi.get(self, "trusted_domain_fqdn")


@pulumi.output_type
class HealthAlertResponse(dict):
    """
    Health Alert Description
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lastDetected":
            suggest = "last_detected"
        elif key == "resolutionUri":
            suggest = "resolution_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HealthAlertResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HealthAlertResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HealthAlertResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: str,
                 issue: str,
                 last_detected: str,
                 name: str,
                 raised: str,
                 resolution_uri: str,
                 severity: str):
        """
        Health Alert Description
        :param str id: Health Alert Id
        :param str issue: Health Alert Issue
        :param str last_detected: Health Alert Last Detected DateTime
        :param str name: Health Alert Name
        :param str raised: Health Alert Raised DateTime
        :param str resolution_uri: Health Alert TSG Link
        :param str severity: Health Alert Severity
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "issue", issue)
        pulumi.set(__self__, "last_detected", last_detected)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "raised", raised)
        pulumi.set(__self__, "resolution_uri", resolution_uri)
        pulumi.set(__self__, "severity", severity)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Health Alert Id
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def issue(self) -> str:
        """
        Health Alert Issue
        """
        return pulumi.get(self, "issue")

    @property
    @pulumi.getter(name="lastDetected")
    def last_detected(self) -> str:
        """
        Health Alert Last Detected DateTime
        """
        return pulumi.get(self, "last_detected")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Health Alert Name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def raised(self) -> str:
        """
        Health Alert Raised DateTime
        """
        return pulumi.get(self, "raised")

    @property
    @pulumi.getter(name="resolutionUri")
    def resolution_uri(self) -> str:
        """
        Health Alert TSG Link
        """
        return pulumi.get(self, "resolution_uri")

    @property
    @pulumi.getter
    def severity(self) -> str:
        """
        Health Alert Severity
        """
        return pulumi.get(self, "severity")


@pulumi.output_type
class HealthMonitorResponse(dict):
    """
    Health Monitor Description
    """
    def __init__(__self__, *,
                 details: str,
                 id: str,
                 name: str):
        """
        Health Monitor Description
        :param str details: Health Monitor Details
        :param str id: Health Monitor Id
        :param str name: Health Monitor Name
        """
        pulumi.set(__self__, "details", details)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def details(self) -> str:
        """
        Health Monitor Details
        """
        return pulumi.get(self, "details")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Health Monitor Id
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Health Monitor Name
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class LdapsSettingsResponse(dict):
    """
    Secure LDAP Settings
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certificateNotAfter":
            suggest = "certificate_not_after"
        elif key == "certificateThumbprint":
            suggest = "certificate_thumbprint"
        elif key == "publicCertificate":
            suggest = "public_certificate"
        elif key == "externalAccess":
            suggest = "external_access"
        elif key == "pfxCertificate":
            suggest = "pfx_certificate"
        elif key == "pfxCertificatePassword":
            suggest = "pfx_certificate_password"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LdapsSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LdapsSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LdapsSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 certificate_not_after: str,
                 certificate_thumbprint: str,
                 public_certificate: str,
                 external_access: Optional[str] = None,
                 ldaps: Optional[str] = None,
                 pfx_certificate: Optional[str] = None,
                 pfx_certificate_password: Optional[str] = None):
        """
        Secure LDAP Settings
        :param str certificate_not_after: NotAfter DateTime of configure ldaps certificate.
        :param str certificate_thumbprint: Thumbprint of configure ldaps certificate.
        :param str public_certificate: Public certificate used to configure secure ldap.
        :param str external_access: A flag to determine whether or not Secure LDAP access over the internet is enabled or disabled.
        :param str ldaps: A flag to determine whether or not Secure LDAP is enabled or disabled.
        :param str pfx_certificate: The certificate required to configure Secure LDAP. The parameter passed here should be a base64encoded representation of the certificate pfx file.
        :param str pfx_certificate_password: The password to decrypt the provided Secure LDAP certificate pfx file.
        """
        pulumi.set(__self__, "certificate_not_after", certificate_not_after)
        pulumi.set(__self__, "certificate_thumbprint", certificate_thumbprint)
        pulumi.set(__self__, "public_certificate", public_certificate)
        if external_access is None:
            external_access = 'Disabled'
        if external_access is not None:
            pulumi.set(__self__, "external_access", external_access)
        if ldaps is None:
            ldaps = 'Disabled'
        if ldaps is not None:
            pulumi.set(__self__, "ldaps", ldaps)
        if pfx_certificate is not None:
            pulumi.set(__self__, "pfx_certificate", pfx_certificate)
        if pfx_certificate_password is not None:
            pulumi.set(__self__, "pfx_certificate_password", pfx_certificate_password)

    @property
    @pulumi.getter(name="certificateNotAfter")
    def certificate_not_after(self) -> str:
        """
        NotAfter DateTime of configure ldaps certificate.
        """
        return pulumi.get(self, "certificate_not_after")

    @property
    @pulumi.getter(name="certificateThumbprint")
    def certificate_thumbprint(self) -> str:
        """
        Thumbprint of configure ldaps certificate.
        """
        return pulumi.get(self, "certificate_thumbprint")

    @property
    @pulumi.getter(name="publicCertificate")
    def public_certificate(self) -> str:
        """
        Public certificate used to configure secure ldap.
        """
        return pulumi.get(self, "public_certificate")

    @property
    @pulumi.getter(name="externalAccess")
    def external_access(self) -> Optional[str]:
        """
        A flag to determine whether or not Secure LDAP access over the internet is enabled or disabled.
        """
        return pulumi.get(self, "external_access")

    @property
    @pulumi.getter
    def ldaps(self) -> Optional[str]:
        """
        A flag to determine whether or not Secure LDAP is enabled or disabled.
        """
        return pulumi.get(self, "ldaps")

    @property
    @pulumi.getter(name="pfxCertificate")
    def pfx_certificate(self) -> Optional[str]:
        """
        The certificate required to configure Secure LDAP. The parameter passed here should be a base64encoded representation of the certificate pfx file.
        """
        return pulumi.get(self, "pfx_certificate")

    @property
    @pulumi.getter(name="pfxCertificatePassword")
    def pfx_certificate_password(self) -> Optional[str]:
        """
        The password to decrypt the provided Secure LDAP certificate pfx file.
        """
        return pulumi.get(self, "pfx_certificate_password")


@pulumi.output_type
class MigrationProgressResponse(dict):
    """
    Migration Progress
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "completionPercentage":
            suggest = "completion_percentage"
        elif key == "progressMessage":
            suggest = "progress_message"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MigrationProgressResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MigrationProgressResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MigrationProgressResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 completion_percentage: Optional[float] = None,
                 progress_message: Optional[str] = None):
        """
        Migration Progress
        :param float completion_percentage: Completion Percentage
        :param str progress_message: Progress Message
        """
        if completion_percentage is not None:
            pulumi.set(__self__, "completion_percentage", completion_percentage)
        if progress_message is not None:
            pulumi.set(__self__, "progress_message", progress_message)

    @property
    @pulumi.getter(name="completionPercentage")
    def completion_percentage(self) -> Optional[float]:
        """
        Completion Percentage
        """
        return pulumi.get(self, "completion_percentage")

    @property
    @pulumi.getter(name="progressMessage")
    def progress_message(self) -> Optional[str]:
        """
        Progress Message
        """
        return pulumi.get(self, "progress_message")


@pulumi.output_type
class MigrationPropertiesResponse(dict):
    """
    Migration Properties
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "migrationProgress":
            suggest = "migration_progress"
        elif key == "oldSubnetId":
            suggest = "old_subnet_id"
        elif key == "oldVnetSiteId":
            suggest = "old_vnet_site_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MigrationPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MigrationPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MigrationPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 migration_progress: 'outputs.MigrationProgressResponse',
                 old_subnet_id: str,
                 old_vnet_site_id: str):
        """
        Migration Properties
        :param 'MigrationProgressResponse' migration_progress: Migration Progress
        :param str old_subnet_id: Old Subnet Id
        :param str old_vnet_site_id: Old Vnet Site Id
        """
        pulumi.set(__self__, "migration_progress", migration_progress)
        pulumi.set(__self__, "old_subnet_id", old_subnet_id)
        pulumi.set(__self__, "old_vnet_site_id", old_vnet_site_id)

    @property
    @pulumi.getter(name="migrationProgress")
    def migration_progress(self) -> 'outputs.MigrationProgressResponse':
        """
        Migration Progress
        """
        return pulumi.get(self, "migration_progress")

    @property
    @pulumi.getter(name="oldSubnetId")
    def old_subnet_id(self) -> str:
        """
        Old Subnet Id
        """
        return pulumi.get(self, "old_subnet_id")

    @property
    @pulumi.getter(name="oldVnetSiteId")
    def old_vnet_site_id(self) -> str:
        """
        Old Vnet Site Id
        """
        return pulumi.get(self, "old_vnet_site_id")


@pulumi.output_type
class NotificationSettingsResponse(dict):
    """
    Settings for notification
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "additionalRecipients":
            suggest = "additional_recipients"
        elif key == "notifyDcAdmins":
            suggest = "notify_dc_admins"
        elif key == "notifyGlobalAdmins":
            suggest = "notify_global_admins"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NotificationSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NotificationSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NotificationSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 additional_recipients: Optional[Sequence[str]] = None,
                 notify_dc_admins: Optional[str] = None,
                 notify_global_admins: Optional[str] = None):
        """
        Settings for notification
        :param Sequence[str] additional_recipients: The list of additional recipients
        :param str notify_dc_admins: Should domain controller admins be notified
        :param str notify_global_admins: Should global admins be notified
        """
        if additional_recipients is not None:
            pulumi.set(__self__, "additional_recipients", additional_recipients)
        if notify_dc_admins is not None:
            pulumi.set(__self__, "notify_dc_admins", notify_dc_admins)
        if notify_global_admins is not None:
            pulumi.set(__self__, "notify_global_admins", notify_global_admins)

    @property
    @pulumi.getter(name="additionalRecipients")
    def additional_recipients(self) -> Optional[Sequence[str]]:
        """
        The list of additional recipients
        """
        return pulumi.get(self, "additional_recipients")

    @property
    @pulumi.getter(name="notifyDcAdmins")
    def notify_dc_admins(self) -> Optional[str]:
        """
        Should domain controller admins be notified
        """
        return pulumi.get(self, "notify_dc_admins")

    @property
    @pulumi.getter(name="notifyGlobalAdmins")
    def notify_global_admins(self) -> Optional[str]:
        """
        Should global admins be notified
        """
        return pulumi.get(self, "notify_global_admins")


@pulumi.output_type
class ReplicaSetResponse(dict):
    """
    Replica Set Definition
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "domainControllerIpAddress":
            suggest = "domain_controller_ip_address"
        elif key == "externalAccessIpAddress":
            suggest = "external_access_ip_address"
        elif key == "healthAlerts":
            suggest = "health_alerts"
        elif key == "healthLastEvaluated":
            suggest = "health_last_evaluated"
        elif key == "healthMonitors":
            suggest = "health_monitors"
        elif key == "replicaSetId":
            suggest = "replica_set_id"
        elif key == "serviceStatus":
            suggest = "service_status"
        elif key == "vnetSiteId":
            suggest = "vnet_site_id"
        elif key == "subnetId":
            suggest = "subnet_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ReplicaSetResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ReplicaSetResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ReplicaSetResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 domain_controller_ip_address: Sequence[str],
                 external_access_ip_address: str,
                 health_alerts: Sequence['outputs.HealthAlertResponse'],
                 health_last_evaluated: str,
                 health_monitors: Sequence['outputs.HealthMonitorResponse'],
                 replica_set_id: str,
                 service_status: str,
                 vnet_site_id: str,
                 location: Optional[str] = None,
                 subnet_id: Optional[str] = None):
        """
        Replica Set Definition
        :param Sequence[str] domain_controller_ip_address: List of Domain Controller IP Address
        :param str external_access_ip_address: External access ip address.
        :param Sequence['HealthAlertResponse'] health_alerts: List of Domain Health Alerts
        :param str health_last_evaluated: Last domain evaluation run DateTime
        :param Sequence['HealthMonitorResponse'] health_monitors: List of Domain Health Monitors
        :param str replica_set_id: ReplicaSet Id
        :param str service_status: Status of Domain Service instance
        :param str vnet_site_id: Virtual network site id
        :param str location: Virtual network location
        :param str subnet_id: The name of the virtual network that Domain Services will be deployed on. The id of the subnet that Domain Services will be deployed on. /virtualNetwork/vnetName/subnets/subnetName.
        """
        pulumi.set(__self__, "domain_controller_ip_address", domain_controller_ip_address)
        pulumi.set(__self__, "external_access_ip_address", external_access_ip_address)
        pulumi.set(__self__, "health_alerts", health_alerts)
        pulumi.set(__self__, "health_last_evaluated", health_last_evaluated)
        pulumi.set(__self__, "health_monitors", health_monitors)
        pulumi.set(__self__, "replica_set_id", replica_set_id)
        pulumi.set(__self__, "service_status", service_status)
        pulumi.set(__self__, "vnet_site_id", vnet_site_id)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)

    @property
    @pulumi.getter(name="domainControllerIpAddress")
    def domain_controller_ip_address(self) -> Sequence[str]:
        """
        List of Domain Controller IP Address
        """
        return pulumi.get(self, "domain_controller_ip_address")

    @property
    @pulumi.getter(name="externalAccessIpAddress")
    def external_access_ip_address(self) -> str:
        """
        External access ip address.
        """
        return pulumi.get(self, "external_access_ip_address")

    @property
    @pulumi.getter(name="healthAlerts")
    def health_alerts(self) -> Sequence['outputs.HealthAlertResponse']:
        """
        List of Domain Health Alerts
        """
        return pulumi.get(self, "health_alerts")

    @property
    @pulumi.getter(name="healthLastEvaluated")
    def health_last_evaluated(self) -> str:
        """
        Last domain evaluation run DateTime
        """
        return pulumi.get(self, "health_last_evaluated")

    @property
    @pulumi.getter(name="healthMonitors")
    def health_monitors(self) -> Sequence['outputs.HealthMonitorResponse']:
        """
        List of Domain Health Monitors
        """
        return pulumi.get(self, "health_monitors")

    @property
    @pulumi.getter(name="replicaSetId")
    def replica_set_id(self) -> str:
        """
        ReplicaSet Id
        """
        return pulumi.get(self, "replica_set_id")

    @property
    @pulumi.getter(name="serviceStatus")
    def service_status(self) -> str:
        """
        Status of Domain Service instance
        """
        return pulumi.get(self, "service_status")

    @property
    @pulumi.getter(name="vnetSiteId")
    def vnet_site_id(self) -> str:
        """
        Virtual network site id
        """
        return pulumi.get(self, "vnet_site_id")

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        Virtual network location
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[str]:
        """
        The name of the virtual network that Domain Services will be deployed on. The id of the subnet that Domain Services will be deployed on. /virtualNetwork/vnetName/subnets/subnetName.
        """
        return pulumi.get(self, "subnet_id")


@pulumi.output_type
class ResourceForestSettingsResponse(dict):
    """
    Settings for Resource Forest
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceForest":
            suggest = "resource_forest"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceForestSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceForestSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceForestSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resource_forest: Optional[str] = None,
                 settings: Optional[Sequence['outputs.ForestTrustResponse']] = None):
        """
        Settings for Resource Forest
        :param str resource_forest: Resource Forest
        :param Sequence['ForestTrustResponse'] settings: List of settings for Resource Forest
        """
        if resource_forest is not None:
            pulumi.set(__self__, "resource_forest", resource_forest)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)

    @property
    @pulumi.getter(name="resourceForest")
    def resource_forest(self) -> Optional[str]:
        """
        Resource Forest
        """
        return pulumi.get(self, "resource_forest")

    @property
    @pulumi.getter
    def settings(self) -> Optional[Sequence['outputs.ForestTrustResponse']]:
        """
        List of settings for Resource Forest
        """
        return pulumi.get(self, "settings")


@pulumi.output_type
class SystemDataResponse(dict):
    """
    Metadata pertaining to creation and last modification of the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdAt":
            suggest = "created_at"
        elif key == "createdBy":
            suggest = "created_by"
        elif key == "createdByType":
            suggest = "created_by_type"
        elif key == "lastModifiedAt":
            suggest = "last_modified_at"
        elif key == "lastModifiedBy":
            suggest = "last_modified_by"
        elif key == "lastModifiedByType":
            suggest = "last_modified_by_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SystemDataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_at: Optional[str] = None,
                 created_by: Optional[str] = None,
                 created_by_type: Optional[str] = None,
                 last_modified_at: Optional[str] = None,
                 last_modified_by: Optional[str] = None,
                 last_modified_by_type: Optional[str] = None):
        """
        Metadata pertaining to creation and last modification of the resource.
        :param str created_at: The timestamp of resource creation (UTC).
        :param str created_by: The identity that created the resource.
        :param str created_by_type: The type of identity that created the resource.
        :param str last_modified_at: The timestamp of resource last modification (UTC)
        :param str last_modified_by: The identity that last modified the resource.
        :param str last_modified_by_type: The type of identity that last modified the resource.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if created_by_type is not None:
            pulumi.set(__self__, "created_by_type", created_by_type)
        if last_modified_at is not None:
            pulumi.set(__self__, "last_modified_at", last_modified_at)
        if last_modified_by is not None:
            pulumi.set(__self__, "last_modified_by", last_modified_by)
        if last_modified_by_type is not None:
            pulumi.set(__self__, "last_modified_by_type", last_modified_by_type)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[str]:
        """
        The timestamp of resource creation (UTC).
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[str]:
        """
        The identity that created the resource.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="createdByType")
    def created_by_type(self) -> Optional[str]:
        """
        The type of identity that created the resource.
        """
        return pulumi.get(self, "created_by_type")

    @property
    @pulumi.getter(name="lastModifiedAt")
    def last_modified_at(self) -> Optional[str]:
        """
        The timestamp of resource last modification (UTC)
        """
        return pulumi.get(self, "last_modified_at")

    @property
    @pulumi.getter(name="lastModifiedBy")
    def last_modified_by(self) -> Optional[str]:
        """
        The identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by")

    @property
    @pulumi.getter(name="lastModifiedByType")
    def last_modified_by_type(self) -> Optional[str]:
        """
        The type of identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by_type")


