# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'ErrorAdditionalInfoResponse',
    'ErrorDetailResponse',
    'HybridComputePrivateLinkScopePropertiesResponse',
    'IdentityResponse',
    'LocationDataResponse',
    'MachineExtensionInstanceViewResponse',
    'MachineExtensionInstanceViewResponseStatus',
    'MachineExtensionPropertiesResponse',
    'MachinePropertiesResponse',
    'OSProfileResponse',
    'PrivateEndpointConnectionPropertiesResponse',
    'PrivateEndpointPropertyResponse',
    'PrivateLinkServiceConnectionStatePropertyResponse',
    'SystemDataResponse',
]

@pulumi.output_type
class ErrorAdditionalInfoResponse(dict):
    """
    The resource management error additional info.
    """
    def __init__(__self__, *,
                 info: Any,
                 type: str):
        """
        The resource management error additional info.
        :param Any info: The additional info.
        :param str type: The additional info type.
        """
        pulumi.set(__self__, "info", info)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def info(self) -> Any:
        """
        The additional info.
        """
        return pulumi.get(self, "info")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The additional info type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ErrorDetailResponse(dict):
    """
    The error detail.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "additionalInfo":
            suggest = "additional_info"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ErrorDetailResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ErrorDetailResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ErrorDetailResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 additional_info: Sequence['outputs.ErrorAdditionalInfoResponse'],
                 code: str,
                 details: Sequence['outputs.ErrorDetailResponse'],
                 message: str,
                 target: str):
        """
        The error detail.
        :param Sequence['ErrorAdditionalInfoResponse'] additional_info: The error additional info.
        :param str code: The error code.
        :param Sequence['ErrorDetailResponse'] details: The error details.
        :param str message: The error message.
        :param str target: The error target.
        """
        pulumi.set(__self__, "additional_info", additional_info)
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "details", details)
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "target", target)

    @property
    @pulumi.getter(name="additionalInfo")
    def additional_info(self) -> Sequence['outputs.ErrorAdditionalInfoResponse']:
        """
        The error additional info.
        """
        return pulumi.get(self, "additional_info")

    @property
    @pulumi.getter
    def code(self) -> str:
        """
        The error code.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def details(self) -> Sequence['outputs.ErrorDetailResponse']:
        """
        The error details.
        """
        return pulumi.get(self, "details")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        The error message.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def target(self) -> str:
        """
        The error target.
        """
        return pulumi.get(self, "target")


@pulumi.output_type
class HybridComputePrivateLinkScopePropertiesResponse(dict):
    """
    Properties that define a Azure Arc PrivateLinkScope resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "privateLinkScopeId":
            suggest = "private_link_scope_id"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "publicNetworkAccess":
            suggest = "public_network_access"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HybridComputePrivateLinkScopePropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HybridComputePrivateLinkScopePropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HybridComputePrivateLinkScopePropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 private_link_scope_id: str,
                 provisioning_state: str,
                 public_network_access: Optional[str] = None):
        """
        Properties that define a Azure Arc PrivateLinkScope resource.
        :param str private_link_scope_id: The Guid id of the private link scope.
        :param str provisioning_state: Current state of this PrivateLinkScope: whether or not is has been provisioned within the resource group it is defined. Users cannot change this value but are able to read from it. Values will include Provisioning ,Succeeded, Canceled and Failed.
        :param str public_network_access: Indicates whether machines associated with the private link scope can also use public Azure Arc service endpoints.
        """
        pulumi.set(__self__, "private_link_scope_id", private_link_scope_id)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if public_network_access is not None:
            pulumi.set(__self__, "public_network_access", public_network_access)

    @property
    @pulumi.getter(name="privateLinkScopeId")
    def private_link_scope_id(self) -> str:
        """
        The Guid id of the private link scope.
        """
        return pulumi.get(self, "private_link_scope_id")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        Current state of this PrivateLinkScope: whether or not is has been provisioned within the resource group it is defined. Users cannot change this value but are able to read from it. Values will include Provisioning ,Succeeded, Canceled and Failed.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="publicNetworkAccess")
    def public_network_access(self) -> Optional[str]:
        """
        Indicates whether machines associated with the private link scope can also use public Azure Arc service endpoints.
        """
        return pulumi.get(self, "public_network_access")


@pulumi.output_type
class IdentityResponse(dict):
    """
    Identity for the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IdentityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IdentityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IdentityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 principal_id: str,
                 tenant_id: str,
                 type: Optional[str] = None):
        """
        Identity for the resource.
        :param str principal_id: The principal ID of resource identity.
        :param str tenant_id: The tenant ID of resource.
        :param str type: The identity type.
        """
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> str:
        """
        The principal ID of resource identity.
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> str:
        """
        The tenant ID of resource.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The identity type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class LocationDataResponse(dict):
    """
    Metadata pertaining to the geographic location of the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "countryOrRegion":
            suggest = "country_or_region"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LocationDataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LocationDataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LocationDataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 city: Optional[str] = None,
                 country_or_region: Optional[str] = None,
                 district: Optional[str] = None):
        """
        Metadata pertaining to the geographic location of the resource.
        :param str name: A canonical name for the geographic or physical location.
        :param str city: The city or locality where the resource is located.
        :param str country_or_region: The country or region where the resource is located
        :param str district: The district, state, or province where the resource is located.
        """
        pulumi.set(__self__, "name", name)
        if city is not None:
            pulumi.set(__self__, "city", city)
        if country_or_region is not None:
            pulumi.set(__self__, "country_or_region", country_or_region)
        if district is not None:
            pulumi.set(__self__, "district", district)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A canonical name for the geographic or physical location.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def city(self) -> Optional[str]:
        """
        The city or locality where the resource is located.
        """
        return pulumi.get(self, "city")

    @property
    @pulumi.getter(name="countryOrRegion")
    def country_or_region(self) -> Optional[str]:
        """
        The country or region where the resource is located
        """
        return pulumi.get(self, "country_or_region")

    @property
    @pulumi.getter
    def district(self) -> Optional[str]:
        """
        The district, state, or province where the resource is located.
        """
        return pulumi.get(self, "district")


@pulumi.output_type
class MachineExtensionInstanceViewResponse(dict):
    """
    Describes the Machine Extension Instance View.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "typeHandlerVersion":
            suggest = "type_handler_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MachineExtensionInstanceViewResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MachineExtensionInstanceViewResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MachineExtensionInstanceViewResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: Optional[str] = None,
                 status: Optional['outputs.MachineExtensionInstanceViewResponseStatus'] = None,
                 type: Optional[str] = None,
                 type_handler_version: Optional[str] = None):
        """
        Describes the Machine Extension Instance View.
        :param str name: The machine extension name.
        :param 'MachineExtensionInstanceViewResponseStatus' status: Instance view status.
        :param str type: Specifies the type of the extension; an example is "CustomScriptExtension".
        :param str type_handler_version: Specifies the version of the script handler.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if type_handler_version is not None:
            pulumi.set(__self__, "type_handler_version", type_handler_version)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The machine extension name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def status(self) -> Optional['outputs.MachineExtensionInstanceViewResponseStatus']:
        """
        Instance view status.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Specifies the type of the extension; an example is "CustomScriptExtension".
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="typeHandlerVersion")
    def type_handler_version(self) -> Optional[str]:
        """
        Specifies the version of the script handler.
        """
        return pulumi.get(self, "type_handler_version")


@pulumi.output_type
class MachineExtensionInstanceViewResponseStatus(dict):
    """
    Instance view status.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "displayStatus":
            suggest = "display_status"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MachineExtensionInstanceViewResponseStatus. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MachineExtensionInstanceViewResponseStatus.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MachineExtensionInstanceViewResponseStatus.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 code: Optional[str] = None,
                 display_status: Optional[str] = None,
                 level: Optional[str] = None,
                 message: Optional[str] = None,
                 time: Optional[str] = None):
        """
        Instance view status.
        :param str code: The status code.
        :param str display_status: The short localizable label for the status.
        :param str level: The level code.
        :param str message: The detailed status message, including for alerts and error messages.
        :param str time: The time of the status.
        """
        if code is not None:
            pulumi.set(__self__, "code", code)
        if display_status is not None:
            pulumi.set(__self__, "display_status", display_status)
        if level is not None:
            pulumi.set(__self__, "level", level)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if time is not None:
            pulumi.set(__self__, "time", time)

    @property
    @pulumi.getter
    def code(self) -> Optional[str]:
        """
        The status code.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter(name="displayStatus")
    def display_status(self) -> Optional[str]:
        """
        The short localizable label for the status.
        """
        return pulumi.get(self, "display_status")

    @property
    @pulumi.getter
    def level(self) -> Optional[str]:
        """
        The level code.
        """
        return pulumi.get(self, "level")

    @property
    @pulumi.getter
    def message(self) -> Optional[str]:
        """
        The detailed status message, including for alerts and error messages.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def time(self) -> Optional[str]:
        """
        The time of the status.
        """
        return pulumi.get(self, "time")


@pulumi.output_type
class MachineExtensionPropertiesResponse(dict):
    """
    Describes the properties of a Machine Extension.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "autoUpgradeMinorVersion":
            suggest = "auto_upgrade_minor_version"
        elif key == "forceUpdateTag":
            suggest = "force_update_tag"
        elif key == "instanceView":
            suggest = "instance_view"
        elif key == "protectedSettings":
            suggest = "protected_settings"
        elif key == "typeHandlerVersion":
            suggest = "type_handler_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MachineExtensionPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MachineExtensionPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MachineExtensionPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 provisioning_state: str,
                 auto_upgrade_minor_version: Optional[bool] = None,
                 force_update_tag: Optional[str] = None,
                 instance_view: Optional['outputs.MachineExtensionInstanceViewResponse'] = None,
                 protected_settings: Optional[Any] = None,
                 publisher: Optional[str] = None,
                 settings: Optional[Any] = None,
                 type: Optional[str] = None,
                 type_handler_version: Optional[str] = None):
        """
        Describes the properties of a Machine Extension.
        :param str provisioning_state: The provisioning state, which only appears in the response.
        :param bool auto_upgrade_minor_version: Indicates whether the extension should use a newer minor version if one is available at deployment time. Once deployed, however, the extension will not upgrade minor versions unless redeployed, even with this property set to true.
        :param str force_update_tag: How the extension handler should be forced to update even if the extension configuration has not changed.
        :param 'MachineExtensionInstanceViewResponse' instance_view: The machine extension instance view.
        :param Any protected_settings: The extension can contain either protectedSettings or protectedSettingsFromKeyVault or no protected settings at all.
        :param str publisher: The name of the extension handler publisher.
        :param Any settings: Json formatted public settings for the extension.
        :param str type: Specifies the type of the extension; an example is "CustomScriptExtension".
        :param str type_handler_version: Specifies the version of the script handler.
        """
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if auto_upgrade_minor_version is not None:
            pulumi.set(__self__, "auto_upgrade_minor_version", auto_upgrade_minor_version)
        if force_update_tag is not None:
            pulumi.set(__self__, "force_update_tag", force_update_tag)
        if instance_view is not None:
            pulumi.set(__self__, "instance_view", instance_view)
        if protected_settings is not None:
            pulumi.set(__self__, "protected_settings", protected_settings)
        if publisher is not None:
            pulumi.set(__self__, "publisher", publisher)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if type_handler_version is not None:
            pulumi.set(__self__, "type_handler_version", type_handler_version)

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state, which only appears in the response.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="autoUpgradeMinorVersion")
    def auto_upgrade_minor_version(self) -> Optional[bool]:
        """
        Indicates whether the extension should use a newer minor version if one is available at deployment time. Once deployed, however, the extension will not upgrade minor versions unless redeployed, even with this property set to true.
        """
        return pulumi.get(self, "auto_upgrade_minor_version")

    @property
    @pulumi.getter(name="forceUpdateTag")
    def force_update_tag(self) -> Optional[str]:
        """
        How the extension handler should be forced to update even if the extension configuration has not changed.
        """
        return pulumi.get(self, "force_update_tag")

    @property
    @pulumi.getter(name="instanceView")
    def instance_view(self) -> Optional['outputs.MachineExtensionInstanceViewResponse']:
        """
        The machine extension instance view.
        """
        return pulumi.get(self, "instance_view")

    @property
    @pulumi.getter(name="protectedSettings")
    def protected_settings(self) -> Optional[Any]:
        """
        The extension can contain either protectedSettings or protectedSettingsFromKeyVault or no protected settings at all.
        """
        return pulumi.get(self, "protected_settings")

    @property
    @pulumi.getter
    def publisher(self) -> Optional[str]:
        """
        The name of the extension handler publisher.
        """
        return pulumi.get(self, "publisher")

    @property
    @pulumi.getter
    def settings(self) -> Optional[Any]:
        """
        Json formatted public settings for the extension.
        """
        return pulumi.get(self, "settings")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Specifies the type of the extension; an example is "CustomScriptExtension".
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="typeHandlerVersion")
    def type_handler_version(self) -> Optional[str]:
        """
        Specifies the version of the script handler.
        """
        return pulumi.get(self, "type_handler_version")


@pulumi.output_type
class MachinePropertiesResponse(dict):
    """
    Describes the properties of a hybrid machine.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "adFqdn":
            suggest = "ad_fqdn"
        elif key == "agentVersion":
            suggest = "agent_version"
        elif key == "detectedProperties":
            suggest = "detected_properties"
        elif key == "displayName":
            suggest = "display_name"
        elif key == "dnsFqdn":
            suggest = "dns_fqdn"
        elif key == "domainName":
            suggest = "domain_name"
        elif key == "errorDetails":
            suggest = "error_details"
        elif key == "lastStatusChange":
            suggest = "last_status_change"
        elif key == "machineFqdn":
            suggest = "machine_fqdn"
        elif key == "osName":
            suggest = "os_name"
        elif key == "osProfile":
            suggest = "os_profile"
        elif key == "osSku":
            suggest = "os_sku"
        elif key == "osVersion":
            suggest = "os_version"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "vmUuid":
            suggest = "vm_uuid"
        elif key == "clientPublicKey":
            suggest = "client_public_key"
        elif key == "locationData":
            suggest = "location_data"
        elif key == "parentClusterResourceId":
            suggest = "parent_cluster_resource_id"
        elif key == "privateLinkScopeResourceId":
            suggest = "private_link_scope_resource_id"
        elif key == "vmId":
            suggest = "vm_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MachinePropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MachinePropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MachinePropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ad_fqdn: str,
                 agent_version: str,
                 detected_properties: Mapping[str, str],
                 display_name: str,
                 dns_fqdn: str,
                 domain_name: str,
                 error_details: Sequence['outputs.ErrorDetailResponse'],
                 last_status_change: str,
                 machine_fqdn: str,
                 os_name: str,
                 os_profile: 'outputs.OSProfileResponse',
                 os_sku: str,
                 os_version: str,
                 provisioning_state: str,
                 status: str,
                 vm_uuid: str,
                 client_public_key: Optional[str] = None,
                 extensions: Optional[Sequence['outputs.MachineExtensionInstanceViewResponse']] = None,
                 location_data: Optional['outputs.LocationDataResponse'] = None,
                 parent_cluster_resource_id: Optional[str] = None,
                 private_link_scope_resource_id: Optional[str] = None,
                 vm_id: Optional[str] = None):
        """
        Describes the properties of a hybrid machine.
        :param str ad_fqdn: Specifies the AD fully qualified display name.
        :param str agent_version: The hybrid machine agent full version.
        :param Mapping[str, str] detected_properties: Detected properties from the machine.
        :param str display_name: Specifies the hybrid machine display name.
        :param str dns_fqdn: Specifies the DNS fully qualified display name.
        :param str domain_name: Specifies the Windows domain name.
        :param Sequence['ErrorDetailResponse'] error_details: Details about the error state.
        :param str last_status_change: The time of the last status change.
        :param str machine_fqdn: Specifies the hybrid machine FQDN.
        :param str os_name: The Operating System running on the hybrid machine.
        :param 'OSProfileResponse' os_profile: Specifies the operating system settings for the hybrid machine.
        :param str os_sku: Specifies the Operating System product SKU.
        :param str os_version: The version of Operating System running on the hybrid machine.
        :param str provisioning_state: The provisioning state, which only appears in the response.
        :param str status: The status of the hybrid machine agent.
        :param str vm_uuid: Specifies the Arc Machine's unique SMBIOS ID
        :param str client_public_key: Public Key that the client provides to be used during initial resource onboarding
        :param Sequence['MachineExtensionInstanceViewResponse'] extensions: Machine Extensions information
        :param 'LocationDataResponse' location_data: Metadata pertaining to the geographic location of the resource.
        :param str parent_cluster_resource_id: The resource id of the parent cluster (Azure HCI) this machine is assigned to, if any.
        :param str private_link_scope_resource_id: The resource id of the private link scope this machine is assigned to, if any.
        :param str vm_id: Specifies the hybrid machine unique ID.
        """
        pulumi.set(__self__, "ad_fqdn", ad_fqdn)
        pulumi.set(__self__, "agent_version", agent_version)
        pulumi.set(__self__, "detected_properties", detected_properties)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "dns_fqdn", dns_fqdn)
        pulumi.set(__self__, "domain_name", domain_name)
        pulumi.set(__self__, "error_details", error_details)
        pulumi.set(__self__, "last_status_change", last_status_change)
        pulumi.set(__self__, "machine_fqdn", machine_fqdn)
        pulumi.set(__self__, "os_name", os_name)
        pulumi.set(__self__, "os_profile", os_profile)
        pulumi.set(__self__, "os_sku", os_sku)
        pulumi.set(__self__, "os_version", os_version)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "vm_uuid", vm_uuid)
        if client_public_key is not None:
            pulumi.set(__self__, "client_public_key", client_public_key)
        if extensions is not None:
            pulumi.set(__self__, "extensions", extensions)
        if location_data is not None:
            pulumi.set(__self__, "location_data", location_data)
        if parent_cluster_resource_id is not None:
            pulumi.set(__self__, "parent_cluster_resource_id", parent_cluster_resource_id)
        if private_link_scope_resource_id is not None:
            pulumi.set(__self__, "private_link_scope_resource_id", private_link_scope_resource_id)
        if vm_id is not None:
            pulumi.set(__self__, "vm_id", vm_id)

    @property
    @pulumi.getter(name="adFqdn")
    def ad_fqdn(self) -> str:
        """
        Specifies the AD fully qualified display name.
        """
        return pulumi.get(self, "ad_fqdn")

    @property
    @pulumi.getter(name="agentVersion")
    def agent_version(self) -> str:
        """
        The hybrid machine agent full version.
        """
        return pulumi.get(self, "agent_version")

    @property
    @pulumi.getter(name="detectedProperties")
    def detected_properties(self) -> Mapping[str, str]:
        """
        Detected properties from the machine.
        """
        return pulumi.get(self, "detected_properties")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        Specifies the hybrid machine display name.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="dnsFqdn")
    def dns_fqdn(self) -> str:
        """
        Specifies the DNS fully qualified display name.
        """
        return pulumi.get(self, "dns_fqdn")

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> str:
        """
        Specifies the Windows domain name.
        """
        return pulumi.get(self, "domain_name")

    @property
    @pulumi.getter(name="errorDetails")
    def error_details(self) -> Sequence['outputs.ErrorDetailResponse']:
        """
        Details about the error state.
        """
        return pulumi.get(self, "error_details")

    @property
    @pulumi.getter(name="lastStatusChange")
    def last_status_change(self) -> str:
        """
        The time of the last status change.
        """
        return pulumi.get(self, "last_status_change")

    @property
    @pulumi.getter(name="machineFqdn")
    def machine_fqdn(self) -> str:
        """
        Specifies the hybrid machine FQDN.
        """
        return pulumi.get(self, "machine_fqdn")

    @property
    @pulumi.getter(name="osName")
    def os_name(self) -> str:
        """
        The Operating System running on the hybrid machine.
        """
        return pulumi.get(self, "os_name")

    @property
    @pulumi.getter(name="osProfile")
    def os_profile(self) -> 'outputs.OSProfileResponse':
        """
        Specifies the operating system settings for the hybrid machine.
        """
        return pulumi.get(self, "os_profile")

    @property
    @pulumi.getter(name="osSku")
    def os_sku(self) -> str:
        """
        Specifies the Operating System product SKU.
        """
        return pulumi.get(self, "os_sku")

    @property
    @pulumi.getter(name="osVersion")
    def os_version(self) -> str:
        """
        The version of Operating System running on the hybrid machine.
        """
        return pulumi.get(self, "os_version")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state, which only appears in the response.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the hybrid machine agent.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="vmUuid")
    def vm_uuid(self) -> str:
        """
        Specifies the Arc Machine's unique SMBIOS ID
        """
        return pulumi.get(self, "vm_uuid")

    @property
    @pulumi.getter(name="clientPublicKey")
    def client_public_key(self) -> Optional[str]:
        """
        Public Key that the client provides to be used during initial resource onboarding
        """
        return pulumi.get(self, "client_public_key")

    @property
    @pulumi.getter
    def extensions(self) -> Optional[Sequence['outputs.MachineExtensionInstanceViewResponse']]:
        """
        Machine Extensions information
        """
        return pulumi.get(self, "extensions")

    @property
    @pulumi.getter(name="locationData")
    def location_data(self) -> Optional['outputs.LocationDataResponse']:
        """
        Metadata pertaining to the geographic location of the resource.
        """
        return pulumi.get(self, "location_data")

    @property
    @pulumi.getter(name="parentClusterResourceId")
    def parent_cluster_resource_id(self) -> Optional[str]:
        """
        The resource id of the parent cluster (Azure HCI) this machine is assigned to, if any.
        """
        return pulumi.get(self, "parent_cluster_resource_id")

    @property
    @pulumi.getter(name="privateLinkScopeResourceId")
    def private_link_scope_resource_id(self) -> Optional[str]:
        """
        The resource id of the private link scope this machine is assigned to, if any.
        """
        return pulumi.get(self, "private_link_scope_resource_id")

    @property
    @pulumi.getter(name="vmId")
    def vm_id(self) -> Optional[str]:
        """
        Specifies the hybrid machine unique ID.
        """
        return pulumi.get(self, "vm_id")


@pulumi.output_type
class OSProfileResponse(dict):
    """
    Specifies the operating system settings for the hybrid machine.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "computerName":
            suggest = "computer_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OSProfileResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OSProfileResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OSProfileResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 computer_name: str):
        """
        Specifies the operating system settings for the hybrid machine.
        :param str computer_name: Specifies the host OS name of the hybrid machine.
        """
        pulumi.set(__self__, "computer_name", computer_name)

    @property
    @pulumi.getter(name="computerName")
    def computer_name(self) -> str:
        """
        Specifies the host OS name of the hybrid machine.
        """
        return pulumi.get(self, "computer_name")


@pulumi.output_type
class PrivateEndpointConnectionPropertiesResponse(dict):
    """
    Properties of a private endpoint connection.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "privateEndpoint":
            suggest = "private_endpoint"
        elif key == "privateLinkServiceConnectionState":
            suggest = "private_link_service_connection_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrivateEndpointConnectionPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrivateEndpointConnectionPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrivateEndpointConnectionPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 provisioning_state: str,
                 private_endpoint: Optional['outputs.PrivateEndpointPropertyResponse'] = None,
                 private_link_service_connection_state: Optional['outputs.PrivateLinkServiceConnectionStatePropertyResponse'] = None):
        """
        Properties of a private endpoint connection.
        :param str provisioning_state: State of the private endpoint connection.
        :param 'PrivateEndpointPropertyResponse' private_endpoint: Private endpoint which the connection belongs to.
        :param 'PrivateLinkServiceConnectionStatePropertyResponse' private_link_service_connection_state: Connection state of the private endpoint connection.
        """
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if private_endpoint is not None:
            pulumi.set(__self__, "private_endpoint", private_endpoint)
        if private_link_service_connection_state is not None:
            pulumi.set(__self__, "private_link_service_connection_state", private_link_service_connection_state)

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        State of the private endpoint connection.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="privateEndpoint")
    def private_endpoint(self) -> Optional['outputs.PrivateEndpointPropertyResponse']:
        """
        Private endpoint which the connection belongs to.
        """
        return pulumi.get(self, "private_endpoint")

    @property
    @pulumi.getter(name="privateLinkServiceConnectionState")
    def private_link_service_connection_state(self) -> Optional['outputs.PrivateLinkServiceConnectionStatePropertyResponse']:
        """
        Connection state of the private endpoint connection.
        """
        return pulumi.get(self, "private_link_service_connection_state")


@pulumi.output_type
class PrivateEndpointPropertyResponse(dict):
    """
    Private endpoint which the connection belongs to.
    """
    def __init__(__self__, *,
                 id: Optional[str] = None):
        """
        Private endpoint which the connection belongs to.
        :param str id: Resource id of the private endpoint.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource id of the private endpoint.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class PrivateLinkServiceConnectionStatePropertyResponse(dict):
    """
    State of the private endpoint connection.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "actionsRequired":
            suggest = "actions_required"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrivateLinkServiceConnectionStatePropertyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrivateLinkServiceConnectionStatePropertyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrivateLinkServiceConnectionStatePropertyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 actions_required: str,
                 description: str,
                 status: str):
        """
        State of the private endpoint connection.
        :param str actions_required: The actions required for private link service connection.
        :param str description: The private link service connection description.
        :param str status: The private link service connection status.
        """
        pulumi.set(__self__, "actions_required", actions_required)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="actionsRequired")
    def actions_required(self) -> str:
        """
        The actions required for private link service connection.
        """
        return pulumi.get(self, "actions_required")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The private link service connection description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The private link service connection status.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class SystemDataResponse(dict):
    """
    Metadata pertaining to creation and last modification of the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdAt":
            suggest = "created_at"
        elif key == "createdBy":
            suggest = "created_by"
        elif key == "createdByType":
            suggest = "created_by_type"
        elif key == "lastModifiedAt":
            suggest = "last_modified_at"
        elif key == "lastModifiedBy":
            suggest = "last_modified_by"
        elif key == "lastModifiedByType":
            suggest = "last_modified_by_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SystemDataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_at: Optional[str] = None,
                 created_by: Optional[str] = None,
                 created_by_type: Optional[str] = None,
                 last_modified_at: Optional[str] = None,
                 last_modified_by: Optional[str] = None,
                 last_modified_by_type: Optional[str] = None):
        """
        Metadata pertaining to creation and last modification of the resource.
        :param str created_at: The timestamp of resource creation (UTC).
        :param str created_by: The identity that created the resource.
        :param str created_by_type: The type of identity that created the resource.
        :param str last_modified_at: The timestamp of resource last modification (UTC)
        :param str last_modified_by: The identity that last modified the resource.
        :param str last_modified_by_type: The type of identity that last modified the resource.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if created_by_type is not None:
            pulumi.set(__self__, "created_by_type", created_by_type)
        if last_modified_at is not None:
            pulumi.set(__self__, "last_modified_at", last_modified_at)
        if last_modified_by is not None:
            pulumi.set(__self__, "last_modified_by", last_modified_by)
        if last_modified_by_type is not None:
            pulumi.set(__self__, "last_modified_by_type", last_modified_by_type)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[str]:
        """
        The timestamp of resource creation (UTC).
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[str]:
        """
        The identity that created the resource.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="createdByType")
    def created_by_type(self) -> Optional[str]:
        """
        The type of identity that created the resource.
        """
        return pulumi.get(self, "created_by_type")

    @property
    @pulumi.getter(name="lastModifiedAt")
    def last_modified_at(self) -> Optional[str]:
        """
        The timestamp of resource last modification (UTC)
        """
        return pulumi.get(self, "last_modified_at")

    @property
    @pulumi.getter(name="lastModifiedBy")
    def last_modified_by(self) -> Optional[str]:
        """
        The identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by")

    @property
    @pulumi.getter(name="lastModifiedByType")
    def last_modified_by_type(self) -> Optional[str]:
        """
        The type of identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by_type")


