# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = [
    'ListCustomApiWsdlInterfacesResult',
    'AwaitableListCustomApiWsdlInterfacesResult',
    'list_custom_api_wsdl_interfaces',
    'list_custom_api_wsdl_interfaces_output',
]

@pulumi.output_type
class ListCustomApiWsdlInterfacesResult:
    """
    A list of custom API WSDL interfaces
    """
    def __init__(__self__, value=None):
        if value and not isinstance(value, list):
            raise TypeError("Expected argument 'value' to be a list")
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[Sequence['outputs.WsdlServiceResponse']]:
        """
        Collection of WSDL interfaces
        """
        return pulumi.get(self, "value")


class AwaitableListCustomApiWsdlInterfacesResult(ListCustomApiWsdlInterfacesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return ListCustomApiWsdlInterfacesResult(
            value=self.value)


def list_custom_api_wsdl_interfaces(content: Optional[str] = None,
                                    import_method: Optional[Union[str, 'WsdlImportMethod']] = None,
                                    location: Optional[str] = None,
                                    service: Optional[pulumi.InputType['WsdlService']] = None,
                                    subscription_id: Optional[str] = None,
                                    url: Optional[str] = None,
                                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableListCustomApiWsdlInterfacesResult:
    """
    A list of custom API WSDL interfaces


    :param str content: The WSDL content
    :param Union[str, 'WsdlImportMethod'] import_method: The WSDL import method
    :param str location: The location
    :param pulumi.InputType['WsdlService'] service: The service with name and endpoint names
    :param str subscription_id: Subscription Id
    :param str url: The WSDL URL
    """
    __args__ = dict()
    __args__['content'] = content
    __args__['importMethod'] = import_method
    __args__['location'] = location
    __args__['service'] = service
    __args__['subscriptionId'] = subscription_id
    __args__['url'] = url
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure-native:web/v20160601:listCustomApiWsdlInterfaces', __args__, opts=opts, typ=ListCustomApiWsdlInterfacesResult).value

    return AwaitableListCustomApiWsdlInterfacesResult(
        value=__ret__.value)


@_utilities.lift_output_func(list_custom_api_wsdl_interfaces)
def list_custom_api_wsdl_interfaces_output(content: Optional[pulumi.Input[Optional[str]]] = None,
                                           import_method: Optional[pulumi.Input[Optional[Union[str, 'WsdlImportMethod']]]] = None,
                                           location: Optional[pulumi.Input[str]] = None,
                                           service: Optional[pulumi.Input[Optional[pulumi.InputType['WsdlService']]]] = None,
                                           subscription_id: Optional[pulumi.Input[Optional[str]]] = None,
                                           url: Optional[pulumi.Input[Optional[str]]] = None,
                                           opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[ListCustomApiWsdlInterfacesResult]:
    """
    A list of custom API WSDL interfaces


    :param str content: The WSDL content
    :param Union[str, 'WsdlImportMethod'] import_method: The WSDL import method
    :param str location: The location
    :param pulumi.InputType['WsdlService'] service: The service with name and endpoint names
    :param str subscription_id: Subscription Id
    :param str url: The WSDL URL
    """
    ...
