# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from ._enums import *

__all__ = [
    'AddRemoveReplicaScalingMechanismArgs',
    'ApplicationScopedVolumeCreationParametersServiceFabricVolumeDiskArgs',
    'ApplicationScopedVolumeArgs',
    'AutoScalingPolicyArgs',
    'AutoScalingResourceMetricArgs',
    'AverageLoadScalingTriggerArgs',
    'AzureInternalMonitoringPipelineSinkDescriptionArgs',
    'ContainerCodePackagePropertiesArgs',
    'ContainerLabelArgs',
    'DiagnosticsDescriptionArgs',
    'DiagnosticsRefArgs',
    'EndpointPropertiesArgs',
    'EndpointRefArgs',
    'EnvironmentVariableArgs',
    'GatewayDestinationArgs',
    'HttpConfigArgs',
    'HttpHostConfigArgs',
    'HttpRouteConfigArgs',
    'HttpRouteMatchHeaderArgs',
    'HttpRouteMatchPathArgs',
    'HttpRouteMatchRuleArgs',
    'ImageRegistryCredentialArgs',
    'NetworkRefArgs',
    'NetworkResourcePropertiesArgs',
    'ReliableCollectionsRefArgs',
    'ResourceLimitsArgs',
    'ResourceRequestsArgs',
    'ResourceRequirementsArgs',
    'SecretResourcePropertiesArgs',
    'ServiceResourceDescriptionArgs',
    'SettingArgs',
    'TcpConfigArgs',
    'VolumeProviderParametersAzureFileArgs',
    'VolumeReferenceArgs',
]

@pulumi.input_type
class AddRemoveReplicaScalingMechanismArgs:
    def __init__(__self__, *,
                 kind: pulumi.Input[str],
                 max_count: pulumi.Input[int],
                 min_count: pulumi.Input[int],
                 scale_increment: pulumi.Input[int]):
        """
        Describes the horizontal auto scaling mechanism that adds or removes replicas (containers or container groups).
        :param pulumi.Input[str] kind: Enumerates the mechanisms for auto scaling.
               Expected value is 'AddRemoveReplica'.
        :param pulumi.Input[int] max_count: Maximum number of containers (scale up won't be performed above this number).
        :param pulumi.Input[int] min_count: Minimum number of containers (scale down won't be performed below this number).
        :param pulumi.Input[int] scale_increment: Each time auto scaling is performed, this number of containers will be added or removed.
        """
        pulumi.set(__self__, "kind", 'AddRemoveReplica')
        pulumi.set(__self__, "max_count", max_count)
        pulumi.set(__self__, "min_count", min_count)
        pulumi.set(__self__, "scale_increment", scale_increment)

    @property
    @pulumi.getter
    def kind(self) -> pulumi.Input[str]:
        """
        Enumerates the mechanisms for auto scaling.
        Expected value is 'AddRemoveReplica'.
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: pulumi.Input[str]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter(name="maxCount")
    def max_count(self) -> pulumi.Input[int]:
        """
        Maximum number of containers (scale up won't be performed above this number).
        """
        return pulumi.get(self, "max_count")

    @max_count.setter
    def max_count(self, value: pulumi.Input[int]):
        pulumi.set(self, "max_count", value)

    @property
    @pulumi.getter(name="minCount")
    def min_count(self) -> pulumi.Input[int]:
        """
        Minimum number of containers (scale down won't be performed below this number).
        """
        return pulumi.get(self, "min_count")

    @min_count.setter
    def min_count(self, value: pulumi.Input[int]):
        pulumi.set(self, "min_count", value)

    @property
    @pulumi.getter(name="scaleIncrement")
    def scale_increment(self) -> pulumi.Input[int]:
        """
        Each time auto scaling is performed, this number of containers will be added or removed.
        """
        return pulumi.get(self, "scale_increment")

    @scale_increment.setter
    def scale_increment(self, value: pulumi.Input[int]):
        pulumi.set(self, "scale_increment", value)


@pulumi.input_type
class ApplicationScopedVolumeCreationParametersServiceFabricVolumeDiskArgs:
    def __init__(__self__, *,
                 kind: pulumi.Input[str],
                 size_disk: pulumi.Input[Union[str, 'SizeTypes']],
                 description: Optional[pulumi.Input[str]] = None):
        """
        Describes parameters for creating application-scoped volumes provided by Service Fabric Volume Disks
        :param pulumi.Input[str] kind: Specifies the application-scoped volume kind.
               Expected value is 'ServiceFabricVolumeDisk'.
        :param pulumi.Input[Union[str, 'SizeTypes']] size_disk: Volume size
        :param pulumi.Input[str] description: User readable description of the volume.
        """
        pulumi.set(__self__, "kind", 'ServiceFabricVolumeDisk')
        pulumi.set(__self__, "size_disk", size_disk)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def kind(self) -> pulumi.Input[str]:
        """
        Specifies the application-scoped volume kind.
        Expected value is 'ServiceFabricVolumeDisk'.
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: pulumi.Input[str]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter(name="sizeDisk")
    def size_disk(self) -> pulumi.Input[Union[str, 'SizeTypes']]:
        """
        Volume size
        """
        return pulumi.get(self, "size_disk")

    @size_disk.setter
    def size_disk(self, value: pulumi.Input[Union[str, 'SizeTypes']]):
        pulumi.set(self, "size_disk", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        User readable description of the volume.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)


@pulumi.input_type
class ApplicationScopedVolumeArgs:
    def __init__(__self__, *,
                 creation_parameters: pulumi.Input['ApplicationScopedVolumeCreationParametersServiceFabricVolumeDiskArgs'],
                 destination_path: pulumi.Input[str],
                 name: pulumi.Input[str],
                 read_only: Optional[pulumi.Input[bool]] = None):
        """
        Describes a volume whose lifetime is scoped to the application's lifetime.
        :param pulumi.Input['ApplicationScopedVolumeCreationParametersServiceFabricVolumeDiskArgs'] creation_parameters: Describes parameters for creating application-scoped volumes.
        :param pulumi.Input[str] destination_path: The path within the container at which the volume should be mounted. Only valid path characters are allowed.
        :param pulumi.Input[str] name: Name of the volume being referenced.
        :param pulumi.Input[bool] read_only: The flag indicating whether the volume is read only. Default is 'false'.
        """
        pulumi.set(__self__, "creation_parameters", creation_parameters)
        pulumi.set(__self__, "destination_path", destination_path)
        pulumi.set(__self__, "name", name)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)

    @property
    @pulumi.getter(name="creationParameters")
    def creation_parameters(self) -> pulumi.Input['ApplicationScopedVolumeCreationParametersServiceFabricVolumeDiskArgs']:
        """
        Describes parameters for creating application-scoped volumes.
        """
        return pulumi.get(self, "creation_parameters")

    @creation_parameters.setter
    def creation_parameters(self, value: pulumi.Input['ApplicationScopedVolumeCreationParametersServiceFabricVolumeDiskArgs']):
        pulumi.set(self, "creation_parameters", value)

    @property
    @pulumi.getter(name="destinationPath")
    def destination_path(self) -> pulumi.Input[str]:
        """
        The path within the container at which the volume should be mounted. Only valid path characters are allowed.
        """
        return pulumi.get(self, "destination_path")

    @destination_path.setter
    def destination_path(self, value: pulumi.Input[str]):
        pulumi.set(self, "destination_path", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Name of the volume being referenced.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[pulumi.Input[bool]]:
        """
        The flag indicating whether the volume is read only. Default is 'false'.
        """
        return pulumi.get(self, "read_only")

    @read_only.setter
    def read_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "read_only", value)


@pulumi.input_type
class AutoScalingPolicyArgs:
    def __init__(__self__, *,
                 mechanism: pulumi.Input['AddRemoveReplicaScalingMechanismArgs'],
                 name: pulumi.Input[str],
                 trigger: pulumi.Input['AverageLoadScalingTriggerArgs']):
        """
        Describes the auto scaling policy
        :param pulumi.Input['AddRemoveReplicaScalingMechanismArgs'] mechanism: The mechanism that is used to scale when auto scaling operation is invoked.
        :param pulumi.Input[str] name: The name of the auto scaling policy.
        :param pulumi.Input['AverageLoadScalingTriggerArgs'] trigger: Determines when auto scaling operation will be invoked.
        """
        pulumi.set(__self__, "mechanism", mechanism)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "trigger", trigger)

    @property
    @pulumi.getter
    def mechanism(self) -> pulumi.Input['AddRemoveReplicaScalingMechanismArgs']:
        """
        The mechanism that is used to scale when auto scaling operation is invoked.
        """
        return pulumi.get(self, "mechanism")

    @mechanism.setter
    def mechanism(self, value: pulumi.Input['AddRemoveReplicaScalingMechanismArgs']):
        pulumi.set(self, "mechanism", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the auto scaling policy.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def trigger(self) -> pulumi.Input['AverageLoadScalingTriggerArgs']:
        """
        Determines when auto scaling operation will be invoked.
        """
        return pulumi.get(self, "trigger")

    @trigger.setter
    def trigger(self, value: pulumi.Input['AverageLoadScalingTriggerArgs']):
        pulumi.set(self, "trigger", value)


@pulumi.input_type
class AutoScalingResourceMetricArgs:
    def __init__(__self__, *,
                 kind: pulumi.Input[str],
                 name: pulumi.Input[Union[str, 'AutoScalingResourceMetricName']]):
        """
        Describes the resource that is used for triggering auto scaling.
        :param pulumi.Input[str] kind: Enumerates the metrics that are used for triggering auto scaling.
               Expected value is 'Resource'.
        :param pulumi.Input[Union[str, 'AutoScalingResourceMetricName']] name: Name of the resource.
        """
        pulumi.set(__self__, "kind", 'Resource')
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def kind(self) -> pulumi.Input[str]:
        """
        Enumerates the metrics that are used for triggering auto scaling.
        Expected value is 'Resource'.
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: pulumi.Input[str]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[Union[str, 'AutoScalingResourceMetricName']]:
        """
        Name of the resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[Union[str, 'AutoScalingResourceMetricName']]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class AverageLoadScalingTriggerArgs:
    def __init__(__self__, *,
                 kind: pulumi.Input[str],
                 lower_load_threshold: pulumi.Input[float],
                 metric: pulumi.Input['AutoScalingResourceMetricArgs'],
                 scale_interval_in_seconds: pulumi.Input[int],
                 upper_load_threshold: pulumi.Input[float]):
        """
        Describes the average load trigger used for auto scaling.
        :param pulumi.Input[str] kind: Enumerates the triggers for auto scaling.
               Expected value is 'AverageLoad'.
        :param pulumi.Input[float] lower_load_threshold: Lower load threshold (if average load is below this threshold, service will scale down).
        :param pulumi.Input['AutoScalingResourceMetricArgs'] metric: Description of the metric that is used for scaling.
        :param pulumi.Input[int] scale_interval_in_seconds: Scale interval that indicates how often will this trigger be checked.
        :param pulumi.Input[float] upper_load_threshold: Upper load threshold (if average load is above this threshold, service will scale up).
        """
        pulumi.set(__self__, "kind", 'AverageLoad')
        pulumi.set(__self__, "lower_load_threshold", lower_load_threshold)
        pulumi.set(__self__, "metric", metric)
        pulumi.set(__self__, "scale_interval_in_seconds", scale_interval_in_seconds)
        pulumi.set(__self__, "upper_load_threshold", upper_load_threshold)

    @property
    @pulumi.getter
    def kind(self) -> pulumi.Input[str]:
        """
        Enumerates the triggers for auto scaling.
        Expected value is 'AverageLoad'.
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: pulumi.Input[str]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter(name="lowerLoadThreshold")
    def lower_load_threshold(self) -> pulumi.Input[float]:
        """
        Lower load threshold (if average load is below this threshold, service will scale down).
        """
        return pulumi.get(self, "lower_load_threshold")

    @lower_load_threshold.setter
    def lower_load_threshold(self, value: pulumi.Input[float]):
        pulumi.set(self, "lower_load_threshold", value)

    @property
    @pulumi.getter
    def metric(self) -> pulumi.Input['AutoScalingResourceMetricArgs']:
        """
        Description of the metric that is used for scaling.
        """
        return pulumi.get(self, "metric")

    @metric.setter
    def metric(self, value: pulumi.Input['AutoScalingResourceMetricArgs']):
        pulumi.set(self, "metric", value)

    @property
    @pulumi.getter(name="scaleIntervalInSeconds")
    def scale_interval_in_seconds(self) -> pulumi.Input[int]:
        """
        Scale interval that indicates how often will this trigger be checked.
        """
        return pulumi.get(self, "scale_interval_in_seconds")

    @scale_interval_in_seconds.setter
    def scale_interval_in_seconds(self, value: pulumi.Input[int]):
        pulumi.set(self, "scale_interval_in_seconds", value)

    @property
    @pulumi.getter(name="upperLoadThreshold")
    def upper_load_threshold(self) -> pulumi.Input[float]:
        """
        Upper load threshold (if average load is above this threshold, service will scale up).
        """
        return pulumi.get(self, "upper_load_threshold")

    @upper_load_threshold.setter
    def upper_load_threshold(self, value: pulumi.Input[float]):
        pulumi.set(self, "upper_load_threshold", value)


@pulumi.input_type
class AzureInternalMonitoringPipelineSinkDescriptionArgs:
    def __init__(__self__, *,
                 kind: pulumi.Input[str],
                 account_name: Optional[pulumi.Input[str]] = None,
                 auto_key_config_url: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 fluentd_config_url: Optional[Any] = None,
                 ma_config_url: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None):
        """
        Diagnostics settings for Geneva.
        :param pulumi.Input[str] kind: The kind of DiagnosticsSink.
               Expected value is 'AzureInternalMonitoringPipeline'.
        :param pulumi.Input[str] account_name: Azure Internal monitoring pipeline account.
        :param pulumi.Input[str] auto_key_config_url: Azure Internal monitoring pipeline autokey associated with the certificate.
        :param pulumi.Input[str] description: A description of the sink.
        :param Any fluentd_config_url: Azure Internal monitoring agent fluentd configuration.
        :param pulumi.Input[str] ma_config_url: Azure Internal monitoring agent configuration.
        :param pulumi.Input[str] name: Name of the sink. This value is referenced by DiagnosticsReferenceDescription
        :param pulumi.Input[str] namespace: Azure Internal monitoring pipeline account namespace.
        """
        pulumi.set(__self__, "kind", 'AzureInternalMonitoringPipeline')
        if account_name is not None:
            pulumi.set(__self__, "account_name", account_name)
        if auto_key_config_url is not None:
            pulumi.set(__self__, "auto_key_config_url", auto_key_config_url)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if fluentd_config_url is not None:
            pulumi.set(__self__, "fluentd_config_url", fluentd_config_url)
        if ma_config_url is not None:
            pulumi.set(__self__, "ma_config_url", ma_config_url)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)

    @property
    @pulumi.getter
    def kind(self) -> pulumi.Input[str]:
        """
        The kind of DiagnosticsSink.
        Expected value is 'AzureInternalMonitoringPipeline'.
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: pulumi.Input[str]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> Optional[pulumi.Input[str]]:
        """
        Azure Internal monitoring pipeline account.
        """
        return pulumi.get(self, "account_name")

    @account_name.setter
    def account_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_name", value)

    @property
    @pulumi.getter(name="autoKeyConfigUrl")
    def auto_key_config_url(self) -> Optional[pulumi.Input[str]]:
        """
        Azure Internal monitoring pipeline autokey associated with the certificate.
        """
        return pulumi.get(self, "auto_key_config_url")

    @auto_key_config_url.setter
    def auto_key_config_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auto_key_config_url", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A description of the sink.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="fluentdConfigUrl")
    def fluentd_config_url(self) -> Optional[Any]:
        """
        Azure Internal monitoring agent fluentd configuration.
        """
        return pulumi.get(self, "fluentd_config_url")

    @fluentd_config_url.setter
    def fluentd_config_url(self, value: Optional[Any]):
        pulumi.set(self, "fluentd_config_url", value)

    @property
    @pulumi.getter(name="maConfigUrl")
    def ma_config_url(self) -> Optional[pulumi.Input[str]]:
        """
        Azure Internal monitoring agent configuration.
        """
        return pulumi.get(self, "ma_config_url")

    @ma_config_url.setter
    def ma_config_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ma_config_url", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the sink. This value is referenced by DiagnosticsReferenceDescription
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        Azure Internal monitoring pipeline account namespace.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)


@pulumi.input_type
class ContainerCodePackagePropertiesArgs:
    def __init__(__self__, *,
                 image: pulumi.Input[str],
                 name: pulumi.Input[str],
                 resources: pulumi.Input['ResourceRequirementsArgs'],
                 commands: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 diagnostics: Optional[pulumi.Input['DiagnosticsRefArgs']] = None,
                 endpoints: Optional[pulumi.Input[Sequence[pulumi.Input['EndpointPropertiesArgs']]]] = None,
                 entrypoint: Optional[pulumi.Input[str]] = None,
                 environment_variables: Optional[pulumi.Input[Sequence[pulumi.Input['EnvironmentVariableArgs']]]] = None,
                 image_registry_credential: Optional[pulumi.Input['ImageRegistryCredentialArgs']] = None,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerLabelArgs']]]] = None,
                 reliable_collections_refs: Optional[pulumi.Input[Sequence[pulumi.Input['ReliableCollectionsRefArgs']]]] = None,
                 settings: Optional[pulumi.Input[Sequence[pulumi.Input['SettingArgs']]]] = None,
                 volume_refs: Optional[pulumi.Input[Sequence[pulumi.Input['VolumeReferenceArgs']]]] = None,
                 volumes: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationScopedVolumeArgs']]]] = None):
        """
        Describes a container and its runtime properties.
        :param pulumi.Input[str] image: The Container image to use.
        :param pulumi.Input[str] name: The name of the code package.
        :param pulumi.Input['ResourceRequirementsArgs'] resources: The resources required by this container.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] commands: Command array to execute within the container in exec form.
        :param pulumi.Input['DiagnosticsRefArgs'] diagnostics: Reference to sinks in DiagnosticsDescription.
        :param pulumi.Input[Sequence[pulumi.Input['EndpointPropertiesArgs']]] endpoints: The endpoints exposed by this container.
        :param pulumi.Input[str] entrypoint: Override for the default entry point in the container.
        :param pulumi.Input[Sequence[pulumi.Input['EnvironmentVariableArgs']]] environment_variables: The environment variables to set in this container
        :param pulumi.Input['ImageRegistryCredentialArgs'] image_registry_credential: Image registry credential.
        :param pulumi.Input[Sequence[pulumi.Input['ContainerLabelArgs']]] labels: The labels to set in this container.
        :param pulumi.Input[Sequence[pulumi.Input['ReliableCollectionsRefArgs']]] reliable_collections_refs: A list of ReliableCollection resources used by this particular code package. Please refer to ReliableCollectionsRef for more details.
        :param pulumi.Input[Sequence[pulumi.Input['SettingArgs']]] settings: The settings to set in this container. The setting file path can be fetched from environment variable "Fabric_SettingPath". The path for Windows container is "C:\\\\secrets". The path for Linux container is "/var/secrets".
        :param pulumi.Input[Sequence[pulumi.Input['VolumeReferenceArgs']]] volume_refs: Volumes to be attached to the container. The lifetime of these volumes is independent of the application's lifetime.
        :param pulumi.Input[Sequence[pulumi.Input['ApplicationScopedVolumeArgs']]] volumes: Volumes to be attached to the container. The lifetime of these volumes is scoped to the application's lifetime.
        """
        pulumi.set(__self__, "image", image)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "resources", resources)
        if commands is not None:
            pulumi.set(__self__, "commands", commands)
        if diagnostics is not None:
            pulumi.set(__self__, "diagnostics", diagnostics)
        if endpoints is not None:
            pulumi.set(__self__, "endpoints", endpoints)
        if entrypoint is not None:
            pulumi.set(__self__, "entrypoint", entrypoint)
        if environment_variables is not None:
            pulumi.set(__self__, "environment_variables", environment_variables)
        if image_registry_credential is not None:
            pulumi.set(__self__, "image_registry_credential", image_registry_credential)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if reliable_collections_refs is not None:
            pulumi.set(__self__, "reliable_collections_refs", reliable_collections_refs)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)
        if volume_refs is not None:
            pulumi.set(__self__, "volume_refs", volume_refs)
        if volumes is not None:
            pulumi.set(__self__, "volumes", volumes)

    @property
    @pulumi.getter
    def image(self) -> pulumi.Input[str]:
        """
        The Container image to use.
        """
        return pulumi.get(self, "image")

    @image.setter
    def image(self, value: pulumi.Input[str]):
        pulumi.set(self, "image", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the code package.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def resources(self) -> pulumi.Input['ResourceRequirementsArgs']:
        """
        The resources required by this container.
        """
        return pulumi.get(self, "resources")

    @resources.setter
    def resources(self, value: pulumi.Input['ResourceRequirementsArgs']):
        pulumi.set(self, "resources", value)

    @property
    @pulumi.getter
    def commands(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Command array to execute within the container in exec form.
        """
        return pulumi.get(self, "commands")

    @commands.setter
    def commands(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "commands", value)

    @property
    @pulumi.getter
    def diagnostics(self) -> Optional[pulumi.Input['DiagnosticsRefArgs']]:
        """
        Reference to sinks in DiagnosticsDescription.
        """
        return pulumi.get(self, "diagnostics")

    @diagnostics.setter
    def diagnostics(self, value: Optional[pulumi.Input['DiagnosticsRefArgs']]):
        pulumi.set(self, "diagnostics", value)

    @property
    @pulumi.getter
    def endpoints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EndpointPropertiesArgs']]]]:
        """
        The endpoints exposed by this container.
        """
        return pulumi.get(self, "endpoints")

    @endpoints.setter
    def endpoints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EndpointPropertiesArgs']]]]):
        pulumi.set(self, "endpoints", value)

    @property
    @pulumi.getter
    def entrypoint(self) -> Optional[pulumi.Input[str]]:
        """
        Override for the default entry point in the container.
        """
        return pulumi.get(self, "entrypoint")

    @entrypoint.setter
    def entrypoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "entrypoint", value)

    @property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EnvironmentVariableArgs']]]]:
        """
        The environment variables to set in this container
        """
        return pulumi.get(self, "environment_variables")

    @environment_variables.setter
    def environment_variables(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EnvironmentVariableArgs']]]]):
        pulumi.set(self, "environment_variables", value)

    @property
    @pulumi.getter(name="imageRegistryCredential")
    def image_registry_credential(self) -> Optional[pulumi.Input['ImageRegistryCredentialArgs']]:
        """
        Image registry credential.
        """
        return pulumi.get(self, "image_registry_credential")

    @image_registry_credential.setter
    def image_registry_credential(self, value: Optional[pulumi.Input['ImageRegistryCredentialArgs']]):
        pulumi.set(self, "image_registry_credential", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContainerLabelArgs']]]]:
        """
        The labels to set in this container.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerLabelArgs']]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="reliableCollectionsRefs")
    def reliable_collections_refs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ReliableCollectionsRefArgs']]]]:
        """
        A list of ReliableCollection resources used by this particular code package. Please refer to ReliableCollectionsRef for more details.
        """
        return pulumi.get(self, "reliable_collections_refs")

    @reliable_collections_refs.setter
    def reliable_collections_refs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ReliableCollectionsRefArgs']]]]):
        pulumi.set(self, "reliable_collections_refs", value)

    @property
    @pulumi.getter
    def settings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SettingArgs']]]]:
        """
        The settings to set in this container. The setting file path can be fetched from environment variable "Fabric_SettingPath". The path for Windows container is "C:\\\\secrets". The path for Linux container is "/var/secrets".
        """
        return pulumi.get(self, "settings")

    @settings.setter
    def settings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SettingArgs']]]]):
        pulumi.set(self, "settings", value)

    @property
    @pulumi.getter(name="volumeRefs")
    def volume_refs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VolumeReferenceArgs']]]]:
        """
        Volumes to be attached to the container. The lifetime of these volumes is independent of the application's lifetime.
        """
        return pulumi.get(self, "volume_refs")

    @volume_refs.setter
    def volume_refs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VolumeReferenceArgs']]]]):
        pulumi.set(self, "volume_refs", value)

    @property
    @pulumi.getter
    def volumes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationScopedVolumeArgs']]]]:
        """
        Volumes to be attached to the container. The lifetime of these volumes is scoped to the application's lifetime.
        """
        return pulumi.get(self, "volumes")

    @volumes.setter
    def volumes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationScopedVolumeArgs']]]]):
        pulumi.set(self, "volumes", value)


@pulumi.input_type
class ContainerLabelArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        Describes a container label.
        :param pulumi.Input[str] name: The name of the container label.
        :param pulumi.Input[str] value: The value of the container label.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the container label.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        The value of the container label.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class DiagnosticsDescriptionArgs:
    def __init__(__self__, *,
                 default_sink_refs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 sinks: Optional[pulumi.Input[Sequence[pulumi.Input['AzureInternalMonitoringPipelineSinkDescriptionArgs']]]] = None):
        """
        Describes the diagnostics options available
        :param pulumi.Input[Sequence[pulumi.Input[str]]] default_sink_refs: The sinks to be used if diagnostics is enabled. Sink choices can be overridden at the service and code package level.
        :param pulumi.Input[bool] enabled: Status of whether or not sinks are enabled.
        :param pulumi.Input[Sequence[pulumi.Input['AzureInternalMonitoringPipelineSinkDescriptionArgs']]] sinks: List of supported sinks that can be referenced.
        """
        if default_sink_refs is not None:
            pulumi.set(__self__, "default_sink_refs", default_sink_refs)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if sinks is not None:
            pulumi.set(__self__, "sinks", sinks)

    @property
    @pulumi.getter(name="defaultSinkRefs")
    def default_sink_refs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The sinks to be used if diagnostics is enabled. Sink choices can be overridden at the service and code package level.
        """
        return pulumi.get(self, "default_sink_refs")

    @default_sink_refs.setter
    def default_sink_refs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "default_sink_refs", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Status of whether or not sinks are enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def sinks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AzureInternalMonitoringPipelineSinkDescriptionArgs']]]]:
        """
        List of supported sinks that can be referenced.
        """
        return pulumi.get(self, "sinks")

    @sinks.setter
    def sinks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AzureInternalMonitoringPipelineSinkDescriptionArgs']]]]):
        pulumi.set(self, "sinks", value)


@pulumi.input_type
class DiagnosticsRefArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 sink_refs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Reference to sinks in DiagnosticsDescription.
        :param pulumi.Input[bool] enabled: Status of whether or not sinks are enabled.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] sink_refs: List of sinks to be used if enabled. References the list of sinks in DiagnosticsDescription.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if sink_refs is not None:
            pulumi.set(__self__, "sink_refs", sink_refs)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Status of whether or not sinks are enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="sinkRefs")
    def sink_refs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of sinks to be used if enabled. References the list of sinks in DiagnosticsDescription.
        """
        return pulumi.get(self, "sink_refs")

    @sink_refs.setter
    def sink_refs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "sink_refs", value)


@pulumi.input_type
class EndpointPropertiesArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 port: Optional[pulumi.Input[int]] = None):
        """
        Describes a container endpoint.
        :param pulumi.Input[str] name: The name of the endpoint.
        :param pulumi.Input[int] port: Port used by the container.
        """
        pulumi.set(__self__, "name", name)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the endpoint.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        Port used by the container.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)


@pulumi.input_type
class EndpointRefArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None):
        """
        Describes a reference to a service endpoint.
        :param pulumi.Input[str] name: Name of the endpoint.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the endpoint.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class EnvironmentVariableArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        Describes an environment variable for the container.
        :param pulumi.Input[str] name: The name of the environment variable.
        :param pulumi.Input[str] value: The value of the environment variable.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the environment variable.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        The value of the environment variable.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class GatewayDestinationArgs:
    def __init__(__self__, *,
                 application_name: pulumi.Input[str],
                 endpoint_name: pulumi.Input[str],
                 service_name: pulumi.Input[str]):
        """
        Describes destination endpoint for routing traffic.
        :param pulumi.Input[str] application_name: Name of the service fabric Mesh application.
        :param pulumi.Input[str] endpoint_name: name of the endpoint in the service.
        :param pulumi.Input[str] service_name: service that contains the endpoint.
        """
        pulumi.set(__self__, "application_name", application_name)
        pulumi.set(__self__, "endpoint_name", endpoint_name)
        pulumi.set(__self__, "service_name", service_name)

    @property
    @pulumi.getter(name="applicationName")
    def application_name(self) -> pulumi.Input[str]:
        """
        Name of the service fabric Mesh application.
        """
        return pulumi.get(self, "application_name")

    @application_name.setter
    def application_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "application_name", value)

    @property
    @pulumi.getter(name="endpointName")
    def endpoint_name(self) -> pulumi.Input[str]:
        """
        name of the endpoint in the service.
        """
        return pulumi.get(self, "endpoint_name")

    @endpoint_name.setter
    def endpoint_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "endpoint_name", value)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Input[str]:
        """
        service that contains the endpoint.
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "service_name", value)


@pulumi.input_type
class HttpConfigArgs:
    def __init__(__self__, *,
                 hosts: pulumi.Input[Sequence[pulumi.Input['HttpHostConfigArgs']]],
                 name: pulumi.Input[str],
                 port: pulumi.Input[int]):
        """
        Describes the http configuration for external connectivity for this network.
        :param pulumi.Input[Sequence[pulumi.Input['HttpHostConfigArgs']]] hosts: description for routing.
        :param pulumi.Input[str] name: http gateway config name.
        :param pulumi.Input[int] port: Specifies the port at which the service endpoint below needs to be exposed.
        """
        pulumi.set(__self__, "hosts", hosts)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def hosts(self) -> pulumi.Input[Sequence[pulumi.Input['HttpHostConfigArgs']]]:
        """
        description for routing.
        """
        return pulumi.get(self, "hosts")

    @hosts.setter
    def hosts(self, value: pulumi.Input[Sequence[pulumi.Input['HttpHostConfigArgs']]]):
        pulumi.set(self, "hosts", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        http gateway config name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def port(self) -> pulumi.Input[int]:
        """
        Specifies the port at which the service endpoint below needs to be exposed.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: pulumi.Input[int]):
        pulumi.set(self, "port", value)


@pulumi.input_type
class HttpHostConfigArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 routes: pulumi.Input[Sequence[pulumi.Input['HttpRouteConfigArgs']]]):
        """
        Describes the hostname properties for http routing.
        :param pulumi.Input[str] name: http hostname config name.
        :param pulumi.Input[Sequence[pulumi.Input['HttpRouteConfigArgs']]] routes: Route information to use for routing. Routes are processed in the order they are specified. Specify routes that are more specific before routes that can handle general cases.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "routes", routes)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        http hostname config name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def routes(self) -> pulumi.Input[Sequence[pulumi.Input['HttpRouteConfigArgs']]]:
        """
        Route information to use for routing. Routes are processed in the order they are specified. Specify routes that are more specific before routes that can handle general cases.
        """
        return pulumi.get(self, "routes")

    @routes.setter
    def routes(self, value: pulumi.Input[Sequence[pulumi.Input['HttpRouteConfigArgs']]]):
        pulumi.set(self, "routes", value)


@pulumi.input_type
class HttpRouteConfigArgs:
    def __init__(__self__, *,
                 destination: pulumi.Input['GatewayDestinationArgs'],
                 match: pulumi.Input['HttpRouteMatchRuleArgs'],
                 name: pulumi.Input[str]):
        """
        Describes the hostname properties for http routing.
        :param pulumi.Input['GatewayDestinationArgs'] destination: Describes destination endpoint for routing traffic.
        :param pulumi.Input['HttpRouteMatchRuleArgs'] match: Describes a rule for http route matching.
        :param pulumi.Input[str] name: http route name.
        """
        pulumi.set(__self__, "destination", destination)
        pulumi.set(__self__, "match", match)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def destination(self) -> pulumi.Input['GatewayDestinationArgs']:
        """
        Describes destination endpoint for routing traffic.
        """
        return pulumi.get(self, "destination")

    @destination.setter
    def destination(self, value: pulumi.Input['GatewayDestinationArgs']):
        pulumi.set(self, "destination", value)

    @property
    @pulumi.getter
    def match(self) -> pulumi.Input['HttpRouteMatchRuleArgs']:
        """
        Describes a rule for http route matching.
        """
        return pulumi.get(self, "match")

    @match.setter
    def match(self, value: pulumi.Input['HttpRouteMatchRuleArgs']):
        pulumi.set(self, "match", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        http route name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class HttpRouteMatchHeaderArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 type: Optional[pulumi.Input[Union[str, 'HeaderMatchType']]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        Describes header information for http route matching.
        :param pulumi.Input[str] name: Name of header to match in request.
        :param pulumi.Input[Union[str, 'HeaderMatchType']] type: how to match header value
        :param pulumi.Input[str] value: Value of header to match in request.
        """
        pulumi.set(__self__, "name", name)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Name of header to match in request.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[Union[str, 'HeaderMatchType']]]:
        """
        how to match header value
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[Union[str, 'HeaderMatchType']]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        Value of header to match in request.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class HttpRouteMatchPathArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[Union[str, 'PathMatchType']],
                 value: pulumi.Input[str],
                 rewrite: Optional[pulumi.Input[str]] = None):
        """
        Path to match for routing.
        :param pulumi.Input[Union[str, 'PathMatchType']] type: how to match value in the Uri
        :param pulumi.Input[str] value: Uri path to match for request.
        :param pulumi.Input[str] rewrite: replacement string for matched part of the Uri.
        """
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)
        if rewrite is not None:
            pulumi.set(__self__, "rewrite", rewrite)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[Union[str, 'PathMatchType']]:
        """
        how to match value in the Uri
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[Union[str, 'PathMatchType']]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        Uri path to match for request.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)

    @property
    @pulumi.getter
    def rewrite(self) -> Optional[pulumi.Input[str]]:
        """
        replacement string for matched part of the Uri.
        """
        return pulumi.get(self, "rewrite")

    @rewrite.setter
    def rewrite(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "rewrite", value)


@pulumi.input_type
class HttpRouteMatchRuleArgs:
    def __init__(__self__, *,
                 path: pulumi.Input['HttpRouteMatchPathArgs'],
                 headers: Optional[pulumi.Input[Sequence[pulumi.Input['HttpRouteMatchHeaderArgs']]]] = None):
        """
        Describes a rule for http route matching.
        :param pulumi.Input['HttpRouteMatchPathArgs'] path: Path to match for routing.
        :param pulumi.Input[Sequence[pulumi.Input['HttpRouteMatchHeaderArgs']]] headers: headers and their values to match in request.
        """
        pulumi.set(__self__, "path", path)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)

    @property
    @pulumi.getter
    def path(self) -> pulumi.Input['HttpRouteMatchPathArgs']:
        """
        Path to match for routing.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: pulumi.Input['HttpRouteMatchPathArgs']):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter
    def headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['HttpRouteMatchHeaderArgs']]]]:
        """
        headers and their values to match in request.
        """
        return pulumi.get(self, "headers")

    @headers.setter
    def headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['HttpRouteMatchHeaderArgs']]]]):
        pulumi.set(self, "headers", value)


@pulumi.input_type
class ImageRegistryCredentialArgs:
    def __init__(__self__, *,
                 server: pulumi.Input[str],
                 username: pulumi.Input[str],
                 password: Optional[pulumi.Input[str]] = None):
        """
        Image registry credential.
        :param pulumi.Input[str] server: Docker image registry server, without protocol such as `http` and `https`.
        :param pulumi.Input[str] username: The username for the private registry.
        :param pulumi.Input[str] password: The password for the private registry. The password is required for create or update operations, however it is not returned in the get or list operations.
        """
        pulumi.set(__self__, "server", server)
        pulumi.set(__self__, "username", username)
        if password is not None:
            pulumi.set(__self__, "password", password)

    @property
    @pulumi.getter
    def server(self) -> pulumi.Input[str]:
        """
        Docker image registry server, without protocol such as `http` and `https`.
        """
        return pulumi.get(self, "server")

    @server.setter
    def server(self, value: pulumi.Input[str]):
        pulumi.set(self, "server", value)

    @property
    @pulumi.getter
    def username(self) -> pulumi.Input[str]:
        """
        The username for the private registry.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: pulumi.Input[str]):
        pulumi.set(self, "username", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        The password for the private registry. The password is required for create or update operations, however it is not returned in the get or list operations.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)


@pulumi.input_type
class NetworkRefArgs:
    def __init__(__self__, *,
                 endpoint_refs: Optional[pulumi.Input[Sequence[pulumi.Input['EndpointRefArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        Describes a network reference in a service.
        :param pulumi.Input[Sequence[pulumi.Input['EndpointRefArgs']]] endpoint_refs: A list of endpoints that are exposed on this network.
        :param pulumi.Input[str] name: Name of the network
        """
        if endpoint_refs is not None:
            pulumi.set(__self__, "endpoint_refs", endpoint_refs)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="endpointRefs")
    def endpoint_refs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EndpointRefArgs']]]]:
        """
        A list of endpoints that are exposed on this network.
        """
        return pulumi.get(self, "endpoint_refs")

    @endpoint_refs.setter
    def endpoint_refs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EndpointRefArgs']]]]):
        pulumi.set(self, "endpoint_refs", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the network
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class NetworkResourcePropertiesArgs:
    def __init__(__self__, *,
                 kind: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None):
        """
        Describes properties of a network resource.
        :param pulumi.Input[str] kind: The type of a Service Fabric container network.
               Expected value is 'NetworkResourceProperties'.
        :param pulumi.Input[str] description: User readable description of the network.
        """
        pulumi.set(__self__, "kind", 'NetworkResourceProperties')
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def kind(self) -> pulumi.Input[str]:
        """
        The type of a Service Fabric container network.
        Expected value is 'NetworkResourceProperties'.
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: pulumi.Input[str]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        User readable description of the network.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)


@pulumi.input_type
class ReliableCollectionsRefArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 do_not_persist_state: Optional[pulumi.Input[bool]] = None):
        """
        Specifying this parameter adds support for reliable collections
        :param pulumi.Input[str] name: Name of ReliableCollection resource. Right now it's not used and you can use any string.
        :param pulumi.Input[bool] do_not_persist_state: False (the default) if ReliableCollections state is persisted to disk as usual. True if you do not want to persist state, in which case replication is still enabled and you can use ReliableCollections as distributed cache.
        """
        pulumi.set(__self__, "name", name)
        if do_not_persist_state is not None:
            pulumi.set(__self__, "do_not_persist_state", do_not_persist_state)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Name of ReliableCollection resource. Right now it's not used and you can use any string.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="doNotPersistState")
    def do_not_persist_state(self) -> Optional[pulumi.Input[bool]]:
        """
        False (the default) if ReliableCollections state is persisted to disk as usual. True if you do not want to persist state, in which case replication is still enabled and you can use ReliableCollections as distributed cache.
        """
        return pulumi.get(self, "do_not_persist_state")

    @do_not_persist_state.setter
    def do_not_persist_state(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "do_not_persist_state", value)


@pulumi.input_type
class ResourceLimitsArgs:
    def __init__(__self__, *,
                 cpu: Optional[pulumi.Input[float]] = None,
                 memory_in_gb: Optional[pulumi.Input[float]] = None):
        """
        This type describes the resource limits for a given container. It describes the most amount of resources a container is allowed to use before being restarted.
        :param pulumi.Input[float] cpu: CPU limits in cores. At present, only full cores are supported.
        :param pulumi.Input[float] memory_in_gb: The memory limit in GB.
        """
        if cpu is not None:
            pulumi.set(__self__, "cpu", cpu)
        if memory_in_gb is not None:
            pulumi.set(__self__, "memory_in_gb", memory_in_gb)

    @property
    @pulumi.getter
    def cpu(self) -> Optional[pulumi.Input[float]]:
        """
        CPU limits in cores. At present, only full cores are supported.
        """
        return pulumi.get(self, "cpu")

    @cpu.setter
    def cpu(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "cpu", value)

    @property
    @pulumi.getter(name="memoryInGB")
    def memory_in_gb(self) -> Optional[pulumi.Input[float]]:
        """
        The memory limit in GB.
        """
        return pulumi.get(self, "memory_in_gb")

    @memory_in_gb.setter
    def memory_in_gb(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "memory_in_gb", value)


@pulumi.input_type
class ResourceRequestsArgs:
    def __init__(__self__, *,
                 cpu: pulumi.Input[float],
                 memory_in_gb: pulumi.Input[float]):
        """
        This type describes the requested resources for a given container. It describes the least amount of resources required for the container. A container can consume more than requested resources up to the specified limits before being restarted. Currently, the requested resources are treated as limits.
        :param pulumi.Input[float] cpu: Requested number of CPU cores. At present, only full cores are supported.
        :param pulumi.Input[float] memory_in_gb: The memory request in GB for this container.
        """
        pulumi.set(__self__, "cpu", cpu)
        pulumi.set(__self__, "memory_in_gb", memory_in_gb)

    @property
    @pulumi.getter
    def cpu(self) -> pulumi.Input[float]:
        """
        Requested number of CPU cores. At present, only full cores are supported.
        """
        return pulumi.get(self, "cpu")

    @cpu.setter
    def cpu(self, value: pulumi.Input[float]):
        pulumi.set(self, "cpu", value)

    @property
    @pulumi.getter(name="memoryInGB")
    def memory_in_gb(self) -> pulumi.Input[float]:
        """
        The memory request in GB for this container.
        """
        return pulumi.get(self, "memory_in_gb")

    @memory_in_gb.setter
    def memory_in_gb(self, value: pulumi.Input[float]):
        pulumi.set(self, "memory_in_gb", value)


@pulumi.input_type
class ResourceRequirementsArgs:
    def __init__(__self__, *,
                 requests: pulumi.Input['ResourceRequestsArgs'],
                 limits: Optional[pulumi.Input['ResourceLimitsArgs']] = None):
        """
        This type describes the resource requirements for a container or a service.
        :param pulumi.Input['ResourceRequestsArgs'] requests: Describes the requested resources for a given container.
        :param pulumi.Input['ResourceLimitsArgs'] limits: Describes the maximum limits on the resources for a given container.
        """
        pulumi.set(__self__, "requests", requests)
        if limits is not None:
            pulumi.set(__self__, "limits", limits)

    @property
    @pulumi.getter
    def requests(self) -> pulumi.Input['ResourceRequestsArgs']:
        """
        Describes the requested resources for a given container.
        """
        return pulumi.get(self, "requests")

    @requests.setter
    def requests(self, value: pulumi.Input['ResourceRequestsArgs']):
        pulumi.set(self, "requests", value)

    @property
    @pulumi.getter
    def limits(self) -> Optional[pulumi.Input['ResourceLimitsArgs']]:
        """
        Describes the maximum limits on the resources for a given container.
        """
        return pulumi.get(self, "limits")

    @limits.setter
    def limits(self, value: Optional[pulumi.Input['ResourceLimitsArgs']]):
        pulumi.set(self, "limits", value)


@pulumi.input_type
class SecretResourcePropertiesArgs:
    def __init__(__self__, *,
                 kind: pulumi.Input[str],
                 content_type: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None):
        """
        Describes the properties of a secret resource.
        :param pulumi.Input[str] kind: Describes the kind of secret.
               Expected value is 'SecretResourceProperties'.
        :param pulumi.Input[str] content_type: The type of the content stored in the secret value. The value of this property is opaque to Service Fabric. Once set, the value of this property cannot be changed.
        :param pulumi.Input[str] description: User readable description of the secret.
        """
        pulumi.set(__self__, "kind", 'SecretResourceProperties')
        if content_type is not None:
            pulumi.set(__self__, "content_type", content_type)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def kind(self) -> pulumi.Input[str]:
        """
        Describes the kind of secret.
        Expected value is 'SecretResourceProperties'.
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: pulumi.Input[str]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the content stored in the secret value. The value of this property is opaque to Service Fabric. Once set, the value of this property cannot be changed.
        """
        return pulumi.get(self, "content_type")

    @content_type.setter
    def content_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "content_type", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        User readable description of the secret.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)


@pulumi.input_type
class ServiceResourceDescriptionArgs:
    def __init__(__self__, *,
                 code_packages: pulumi.Input[Sequence[pulumi.Input['ContainerCodePackagePropertiesArgs']]],
                 os_type: pulumi.Input[Union[str, 'OperatingSystemType']],
                 auto_scaling_policies: Optional[pulumi.Input[Sequence[pulumi.Input['AutoScalingPolicyArgs']]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 diagnostics: Optional[pulumi.Input['DiagnosticsRefArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_refs: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkRefArgs']]]] = None,
                 replica_count: Optional[pulumi.Input[int]] = None):
        """
        This type describes a service resource.
        :param pulumi.Input[Sequence[pulumi.Input['ContainerCodePackagePropertiesArgs']]] code_packages: Describes the set of code packages that forms the service. A code package describes the container and the properties for running it. All the code packages are started together on the same host and share the same context (network, process etc.).
        :param pulumi.Input[Union[str, 'OperatingSystemType']] os_type: The operation system required by the code in service.
        :param pulumi.Input[Sequence[pulumi.Input['AutoScalingPolicyArgs']]] auto_scaling_policies: Auto scaling policies
        :param pulumi.Input[str] description: User readable description of the service.
        :param pulumi.Input['DiagnosticsRefArgs'] diagnostics: Reference to sinks in DiagnosticsDescription.
        :param pulumi.Input[str] name: The name of the resource
        :param pulumi.Input[Sequence[pulumi.Input['NetworkRefArgs']]] network_refs: The names of the private networks that this service needs to be part of.
        :param pulumi.Input[int] replica_count: The number of replicas of the service to create. Defaults to 1 if not specified.
        """
        pulumi.set(__self__, "code_packages", code_packages)
        pulumi.set(__self__, "os_type", os_type)
        if auto_scaling_policies is not None:
            pulumi.set(__self__, "auto_scaling_policies", auto_scaling_policies)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if diagnostics is not None:
            pulumi.set(__self__, "diagnostics", diagnostics)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_refs is not None:
            pulumi.set(__self__, "network_refs", network_refs)
        if replica_count is not None:
            pulumi.set(__self__, "replica_count", replica_count)

    @property
    @pulumi.getter(name="codePackages")
    def code_packages(self) -> pulumi.Input[Sequence[pulumi.Input['ContainerCodePackagePropertiesArgs']]]:
        """
        Describes the set of code packages that forms the service. A code package describes the container and the properties for running it. All the code packages are started together on the same host and share the same context (network, process etc.).
        """
        return pulumi.get(self, "code_packages")

    @code_packages.setter
    def code_packages(self, value: pulumi.Input[Sequence[pulumi.Input['ContainerCodePackagePropertiesArgs']]]):
        pulumi.set(self, "code_packages", value)

    @property
    @pulumi.getter(name="osType")
    def os_type(self) -> pulumi.Input[Union[str, 'OperatingSystemType']]:
        """
        The operation system required by the code in service.
        """
        return pulumi.get(self, "os_type")

    @os_type.setter
    def os_type(self, value: pulumi.Input[Union[str, 'OperatingSystemType']]):
        pulumi.set(self, "os_type", value)

    @property
    @pulumi.getter(name="autoScalingPolicies")
    def auto_scaling_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AutoScalingPolicyArgs']]]]:
        """
        Auto scaling policies
        """
        return pulumi.get(self, "auto_scaling_policies")

    @auto_scaling_policies.setter
    def auto_scaling_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AutoScalingPolicyArgs']]]]):
        pulumi.set(self, "auto_scaling_policies", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        User readable description of the service.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def diagnostics(self) -> Optional[pulumi.Input['DiagnosticsRefArgs']]:
        """
        Reference to sinks in DiagnosticsDescription.
        """
        return pulumi.get(self, "diagnostics")

    @diagnostics.setter
    def diagnostics(self, value: Optional[pulumi.Input['DiagnosticsRefArgs']]):
        pulumi.set(self, "diagnostics", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the resource
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkRefs")
    def network_refs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NetworkRefArgs']]]]:
        """
        The names of the private networks that this service needs to be part of.
        """
        return pulumi.get(self, "network_refs")

    @network_refs.setter
    def network_refs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkRefArgs']]]]):
        pulumi.set(self, "network_refs", value)

    @property
    @pulumi.getter(name="replicaCount")
    def replica_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of replicas of the service to create. Defaults to 1 if not specified.
        """
        return pulumi.get(self, "replica_count")

    @replica_count.setter
    def replica_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "replica_count", value)


@pulumi.input_type
class SettingArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        Describes a setting for the container. The setting file path can be fetched from environment variable "Fabric_SettingPath". The path for Windows container is "C:\\\\secrets". The path for Linux container is "/var/secrets".
        :param pulumi.Input[str] name: The name of the setting.
        :param pulumi.Input[str] value: The value of the setting.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the setting.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        The value of the setting.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class TcpConfigArgs:
    def __init__(__self__, *,
                 destination: pulumi.Input['GatewayDestinationArgs'],
                 name: pulumi.Input[str],
                 port: pulumi.Input[int]):
        """
        Describes the tcp configuration for external connectivity for this network.
        :param pulumi.Input['GatewayDestinationArgs'] destination: Describes destination endpoint for routing traffic.
        :param pulumi.Input[str] name: tcp gateway config name.
        :param pulumi.Input[int] port: Specifies the port at which the service endpoint below needs to be exposed.
        """
        pulumi.set(__self__, "destination", destination)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def destination(self) -> pulumi.Input['GatewayDestinationArgs']:
        """
        Describes destination endpoint for routing traffic.
        """
        return pulumi.get(self, "destination")

    @destination.setter
    def destination(self, value: pulumi.Input['GatewayDestinationArgs']):
        pulumi.set(self, "destination", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        tcp gateway config name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def port(self) -> pulumi.Input[int]:
        """
        Specifies the port at which the service endpoint below needs to be exposed.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: pulumi.Input[int]):
        pulumi.set(self, "port", value)


@pulumi.input_type
class VolumeProviderParametersAzureFileArgs:
    def __init__(__self__, *,
                 account_name: pulumi.Input[str],
                 share_name: pulumi.Input[str],
                 account_key: Optional[pulumi.Input[str]] = None):
        """
        This type describes a volume provided by an Azure Files file share.
        :param pulumi.Input[str] account_name: Name of the Azure storage account for the File Share.
        :param pulumi.Input[str] share_name: Name of the Azure Files file share that provides storage for the volume.
        :param pulumi.Input[str] account_key: Access key of the Azure storage account for the File Share.
        """
        pulumi.set(__self__, "account_name", account_name)
        pulumi.set(__self__, "share_name", share_name)
        if account_key is not None:
            pulumi.set(__self__, "account_key", account_key)

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> pulumi.Input[str]:
        """
        Name of the Azure storage account for the File Share.
        """
        return pulumi.get(self, "account_name")

    @account_name.setter
    def account_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "account_name", value)

    @property
    @pulumi.getter(name="shareName")
    def share_name(self) -> pulumi.Input[str]:
        """
        Name of the Azure Files file share that provides storage for the volume.
        """
        return pulumi.get(self, "share_name")

    @share_name.setter
    def share_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "share_name", value)

    @property
    @pulumi.getter(name="accountKey")
    def account_key(self) -> Optional[pulumi.Input[str]]:
        """
        Access key of the Azure storage account for the File Share.
        """
        return pulumi.get(self, "account_key")

    @account_key.setter
    def account_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_key", value)


@pulumi.input_type
class VolumeReferenceArgs:
    def __init__(__self__, *,
                 destination_path: pulumi.Input[str],
                 name: pulumi.Input[str],
                 read_only: Optional[pulumi.Input[bool]] = None):
        """
        Describes a reference to a volume resource.
        :param pulumi.Input[str] destination_path: The path within the container at which the volume should be mounted. Only valid path characters are allowed.
        :param pulumi.Input[str] name: Name of the volume being referenced.
        :param pulumi.Input[bool] read_only: The flag indicating whether the volume is read only. Default is 'false'.
        """
        pulumi.set(__self__, "destination_path", destination_path)
        pulumi.set(__self__, "name", name)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)

    @property
    @pulumi.getter(name="destinationPath")
    def destination_path(self) -> pulumi.Input[str]:
        """
        The path within the container at which the volume should be mounted. Only valid path characters are allowed.
        """
        return pulumi.get(self, "destination_path")

    @destination_path.setter
    def destination_path(self, value: pulumi.Input[str]):
        pulumi.set(self, "destination_path", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Name of the volume being referenced.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[pulumi.Input[bool]]:
        """
        The flag indicating whether the volume is read only. Default is 'false'.
        """
        return pulumi.get(self, "read_only")

    @read_only.setter
    def read_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "read_only", value)


