# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['NspAccessRuleArgs', 'NspAccessRule']

@pulumi.input_type
class NspAccessRuleArgs:
    def __init__(__self__, *,
                 network_security_perimeter_name: pulumi.Input[str],
                 profile_name: pulumi.Input[str],
                 resource_group_name: pulumi.Input[str],
                 access_rule_name: Optional[pulumi.Input[str]] = None,
                 address_prefixes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 direction: Optional[pulumi.Input[Union[str, 'AccessRuleDirection']]] = None,
                 fully_qualified_domain_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_security_perimeters: Optional[pulumi.Input[Sequence[pulumi.Input['PerimeterBasedAccessRuleArgs']]]] = None,
                 subscriptions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a NspAccessRule resource.
        :param pulumi.Input[str] network_security_perimeter_name: The name of the network security perimeter.
        :param pulumi.Input[str] profile_name: The name of the NSP profile.
        :param pulumi.Input[str] resource_group_name: The name of the resource group.
        :param pulumi.Input[str] access_rule_name: The name of the NSP access rule.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] address_prefixes: Inbound address prefixes (IPv4/IPv6)
        :param pulumi.Input[Union[str, 'AccessRuleDirection']] direction: Direction that specifies whether the access rules is inbound/outbound.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] fully_qualified_domain_names: Outbound rules fully qualified domain name format.
        :param pulumi.Input[str] id: Resource ID.
        :param pulumi.Input[str] location: Resource location.
        :param pulumi.Input[str] name: The name of the access rule that is unique within a profile. This name can be used to access the resource.
        :param pulumi.Input[Sequence[pulumi.Input['PerimeterBasedAccessRuleArgs']]] network_security_perimeters: Inbound rule specified by the perimeter id.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subscriptions: Subscription id in the ARM id format.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Resource tags.
        """
        pulumi.set(__self__, "network_security_perimeter_name", network_security_perimeter_name)
        pulumi.set(__self__, "profile_name", profile_name)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if access_rule_name is not None:
            pulumi.set(__self__, "access_rule_name", access_rule_name)
        if address_prefixes is not None:
            pulumi.set(__self__, "address_prefixes", address_prefixes)
        if direction is not None:
            pulumi.set(__self__, "direction", direction)
        if fully_qualified_domain_names is not None:
            pulumi.set(__self__, "fully_qualified_domain_names", fully_qualified_domain_names)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_security_perimeters is not None:
            pulumi.set(__self__, "network_security_perimeters", network_security_perimeters)
        if subscriptions is not None:
            pulumi.set(__self__, "subscriptions", subscriptions)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="networkSecurityPerimeterName")
    def network_security_perimeter_name(self) -> pulumi.Input[str]:
        """
        The name of the network security perimeter.
        """
        return pulumi.get(self, "network_security_perimeter_name")

    @network_security_perimeter_name.setter
    def network_security_perimeter_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "network_security_perimeter_name", value)

    @property
    @pulumi.getter(name="profileName")
    def profile_name(self) -> pulumi.Input[str]:
        """
        The name of the NSP profile.
        """
        return pulumi.get(self, "profile_name")

    @profile_name.setter
    def profile_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "profile_name", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[str]:
        """
        The name of the resource group.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="accessRuleName")
    def access_rule_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the NSP access rule.
        """
        return pulumi.get(self, "access_rule_name")

    @access_rule_name.setter
    def access_rule_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access_rule_name", value)

    @property
    @pulumi.getter(name="addressPrefixes")
    def address_prefixes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Inbound address prefixes (IPv4/IPv6)
        """
        return pulumi.get(self, "address_prefixes")

    @address_prefixes.setter
    def address_prefixes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "address_prefixes", value)

    @property
    @pulumi.getter
    def direction(self) -> Optional[pulumi.Input[Union[str, 'AccessRuleDirection']]]:
        """
        Direction that specifies whether the access rules is inbound/outbound.
        """
        return pulumi.get(self, "direction")

    @direction.setter
    def direction(self, value: Optional[pulumi.Input[Union[str, 'AccessRuleDirection']]]):
        pulumi.set(self, "direction", value)

    @property
    @pulumi.getter(name="fullyQualifiedDomainNames")
    def fully_qualified_domain_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Outbound rules fully qualified domain name format.
        """
        return pulumi.get(self, "fully_qualified_domain_names")

    @fully_qualified_domain_names.setter
    def fully_qualified_domain_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "fully_qualified_domain_names", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        Resource location.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the access rule that is unique within a profile. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkSecurityPerimeters")
    def network_security_perimeters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PerimeterBasedAccessRuleArgs']]]]:
        """
        Inbound rule specified by the perimeter id.
        """
        return pulumi.get(self, "network_security_perimeters")

    @network_security_perimeters.setter
    def network_security_perimeters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PerimeterBasedAccessRuleArgs']]]]):
        pulumi.set(self, "network_security_perimeters", value)

    @property
    @pulumi.getter
    def subscriptions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Subscription id in the ARM id format.
        """
        return pulumi.get(self, "subscriptions")

    @subscriptions.setter
    def subscriptions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "subscriptions", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Resource tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


class NspAccessRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_rule_name: Optional[pulumi.Input[str]] = None,
                 address_prefixes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 direction: Optional[pulumi.Input[Union[str, 'AccessRuleDirection']]] = None,
                 fully_qualified_domain_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_security_perimeter_name: Optional[pulumi.Input[str]] = None,
                 network_security_perimeters: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['PerimeterBasedAccessRuleArgs']]]]] = None,
                 profile_name: Optional[pulumi.Input[str]] = None,
                 resource_group_name: Optional[pulumi.Input[str]] = None,
                 subscriptions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        The NSP access rule resource

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] access_rule_name: The name of the NSP access rule.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] address_prefixes: Inbound address prefixes (IPv4/IPv6)
        :param pulumi.Input[Union[str, 'AccessRuleDirection']] direction: Direction that specifies whether the access rules is inbound/outbound.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] fully_qualified_domain_names: Outbound rules fully qualified domain name format.
        :param pulumi.Input[str] id: Resource ID.
        :param pulumi.Input[str] location: Resource location.
        :param pulumi.Input[str] name: The name of the access rule that is unique within a profile. This name can be used to access the resource.
        :param pulumi.Input[str] network_security_perimeter_name: The name of the network security perimeter.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['PerimeterBasedAccessRuleArgs']]]] network_security_perimeters: Inbound rule specified by the perimeter id.
        :param pulumi.Input[str] profile_name: The name of the NSP profile.
        :param pulumi.Input[str] resource_group_name: The name of the resource group.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subscriptions: Subscription id in the ARM id format.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Resource tags.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NspAccessRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The NSP access rule resource

        :param str resource_name: The name of the resource.
        :param NspAccessRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NspAccessRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_rule_name: Optional[pulumi.Input[str]] = None,
                 address_prefixes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 direction: Optional[pulumi.Input[Union[str, 'AccessRuleDirection']]] = None,
                 fully_qualified_domain_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_security_perimeter_name: Optional[pulumi.Input[str]] = None,
                 network_security_perimeters: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['PerimeterBasedAccessRuleArgs']]]]] = None,
                 profile_name: Optional[pulumi.Input[str]] = None,
                 resource_group_name: Optional[pulumi.Input[str]] = None,
                 subscriptions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NspAccessRuleArgs.__new__(NspAccessRuleArgs)

            __props__.__dict__["access_rule_name"] = access_rule_name
            __props__.__dict__["address_prefixes"] = address_prefixes
            __props__.__dict__["direction"] = direction
            __props__.__dict__["fully_qualified_domain_names"] = fully_qualified_domain_names
            __props__.__dict__["id"] = id
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            if network_security_perimeter_name is None and not opts.urn:
                raise TypeError("Missing required property 'network_security_perimeter_name'")
            __props__.__dict__["network_security_perimeter_name"] = network_security_perimeter_name
            __props__.__dict__["network_security_perimeters"] = network_security_perimeters
            if profile_name is None and not opts.urn:
                raise TypeError("Missing required property 'profile_name'")
            __props__.__dict__["profile_name"] = profile_name
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["subscriptions"] = subscriptions
            __props__.__dict__["tags"] = tags
            __props__.__dict__["provisioning_state"] = None
            __props__.__dict__["type"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="azure-native:network:NspAccessRule")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(NspAccessRule, __self__).__init__(
            'azure-native:network/v20210201preview:NspAccessRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'NspAccessRule':
        """
        Get an existing NspAccessRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = NspAccessRuleArgs.__new__(NspAccessRuleArgs)

        __props__.__dict__["address_prefixes"] = None
        __props__.__dict__["direction"] = None
        __props__.__dict__["fully_qualified_domain_names"] = None
        __props__.__dict__["location"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["network_security_perimeters"] = None
        __props__.__dict__["provisioning_state"] = None
        __props__.__dict__["subscriptions"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["type"] = None
        return NspAccessRule(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="addressPrefixes")
    def address_prefixes(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Inbound address prefixes (IPv4/IPv6)
        """
        return pulumi.get(self, "address_prefixes")

    @property
    @pulumi.getter
    def direction(self) -> pulumi.Output[Optional[str]]:
        """
        Direction that specifies whether the access rules is inbound/outbound.
        """
        return pulumi.get(self, "direction")

    @property
    @pulumi.getter(name="fullyQualifiedDomainNames")
    def fully_qualified_domain_names(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Outbound rules fully qualified domain name format.
        """
        return pulumi.get(self, "fully_qualified_domain_names")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[Optional[str]]:
        """
        Resource location.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Resource name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkSecurityPerimeters")
    def network_security_perimeters(self) -> pulumi.Output[Optional[Sequence['outputs.PerimeterBasedAccessRuleResponse']]]:
        """
        Inbound rule specified by the perimeter id.
        """
        return pulumi.get(self, "network_security_perimeters")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> pulumi.Output[str]:
        """
        The provisioning state of the scope assignment resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def subscriptions(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Subscription id in the ARM id format.
        """
        return pulumi.get(self, "subscriptions")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Resource tags.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        Resource type.
        """
        return pulumi.get(self, "type")

