# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'CustomerManagedKeyEncryptionPropertiesKeyEncryptionKeyIdentityArgs',
    'CustomerManagedKeyEncryptionPropertiesArgs',
    'EncryptionPropertiesArgs',
    'IdentityArgs',
]

@pulumi.input_type
class CustomerManagedKeyEncryptionPropertiesKeyEncryptionKeyIdentityArgs:
    def __init__(__self__, *,
                 identity_type: Optional[pulumi.Input['CmkIdentityType']] = None,
                 user_assigned_identity_resource_id: Optional[pulumi.Input[str]] = None):
        """
        All identity configuration for Customer-managed key settings defining which identity should be used to auth to Key Vault.
        :param pulumi.Input['CmkIdentityType'] identity_type: Values can be SystemAssigned or UserAssigned
        :param pulumi.Input[str] user_assigned_identity_resource_id: user assigned identity to use for accessing key encryption key Url. Ex: /subscriptions/fa5fc227-a624-475e-b696-cdd604c735bc/resourceGroups/<resource group>/providers/Microsoft.ManagedIdentity/userAssignedIdentities/myId. Mutually exclusive with identityType systemAssignedIdentity.
        """
        if identity_type is not None:
            pulumi.set(__self__, "identity_type", identity_type)
        if user_assigned_identity_resource_id is not None:
            pulumi.set(__self__, "user_assigned_identity_resource_id", user_assigned_identity_resource_id)

    @property
    @pulumi.getter(name="identityType")
    def identity_type(self) -> Optional[pulumi.Input['CmkIdentityType']]:
        """
        Values can be SystemAssigned or UserAssigned
        """
        return pulumi.get(self, "identity_type")

    @identity_type.setter
    def identity_type(self, value: Optional[pulumi.Input['CmkIdentityType']]):
        pulumi.set(self, "identity_type", value)

    @property
    @pulumi.getter(name="userAssignedIdentityResourceId")
    def user_assigned_identity_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        user assigned identity to use for accessing key encryption key Url. Ex: /subscriptions/fa5fc227-a624-475e-b696-cdd604c735bc/resourceGroups/<resource group>/providers/Microsoft.ManagedIdentity/userAssignedIdentities/myId. Mutually exclusive with identityType systemAssignedIdentity.
        """
        return pulumi.get(self, "user_assigned_identity_resource_id")

    @user_assigned_identity_resource_id.setter
    def user_assigned_identity_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_assigned_identity_resource_id", value)


@pulumi.input_type
class CustomerManagedKeyEncryptionPropertiesArgs:
    def __init__(__self__, *,
                 key_encryption_key_identity: Optional[pulumi.Input['CustomerManagedKeyEncryptionPropertiesKeyEncryptionKeyIdentityArgs']] = None,
                 key_encryption_key_url: Optional[pulumi.Input[str]] = None):
        """
        All Customer-managed key encryption properties for the resource.
        :param pulumi.Input['CustomerManagedKeyEncryptionPropertiesKeyEncryptionKeyIdentityArgs'] key_encryption_key_identity: All identity configuration for Customer-managed key settings defining which identity should be used to auth to Key Vault.
        :param pulumi.Input[str] key_encryption_key_url: key encryption key Url, with or without a version. Ex: https://contosovault.vault.azure.net/keys/contosokek/562a4bb76b524a1493a6afe8e536ee78 or https://contosovault.vault.azure.net/keys/contosokek. Key auto rotation is enabled by providing a key uri without version. Otherwise, customer is responsible for rotating the key. The keyEncryptionKeyIdentity(either SystemAssigned or UserAssigned) should have permission to access this key url.
        """
        if key_encryption_key_identity is not None:
            pulumi.set(__self__, "key_encryption_key_identity", key_encryption_key_identity)
        if key_encryption_key_url is not None:
            pulumi.set(__self__, "key_encryption_key_url", key_encryption_key_url)

    @property
    @pulumi.getter(name="keyEncryptionKeyIdentity")
    def key_encryption_key_identity(self) -> Optional[pulumi.Input['CustomerManagedKeyEncryptionPropertiesKeyEncryptionKeyIdentityArgs']]:
        """
        All identity configuration for Customer-managed key settings defining which identity should be used to auth to Key Vault.
        """
        return pulumi.get(self, "key_encryption_key_identity")

    @key_encryption_key_identity.setter
    def key_encryption_key_identity(self, value: Optional[pulumi.Input['CustomerManagedKeyEncryptionPropertiesKeyEncryptionKeyIdentityArgs']]):
        pulumi.set(self, "key_encryption_key_identity", value)

    @property
    @pulumi.getter(name="keyEncryptionKeyUrl")
    def key_encryption_key_url(self) -> Optional[pulumi.Input[str]]:
        """
        key encryption key Url, with or without a version. Ex: https://contosovault.vault.azure.net/keys/contosokek/562a4bb76b524a1493a6afe8e536ee78 or https://contosovault.vault.azure.net/keys/contosokek. Key auto rotation is enabled by providing a key uri without version. Otherwise, customer is responsible for rotating the key. The keyEncryptionKeyIdentity(either SystemAssigned or UserAssigned) should have permission to access this key url.
        """
        return pulumi.get(self, "key_encryption_key_url")

    @key_encryption_key_url.setter
    def key_encryption_key_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_encryption_key_url", value)


@pulumi.input_type
class EncryptionPropertiesArgs:
    def __init__(__self__, *,
                 customer_managed_key_encryption: Optional[pulumi.Input['CustomerManagedKeyEncryptionPropertiesArgs']] = None):
        """
        All encryption configuration for a resource.
        :param pulumi.Input['CustomerManagedKeyEncryptionPropertiesArgs'] customer_managed_key_encryption: All Customer-managed key encryption properties for the resource.
        """
        if customer_managed_key_encryption is not None:
            pulumi.set(__self__, "customer_managed_key_encryption", customer_managed_key_encryption)

    @property
    @pulumi.getter(name="customerManagedKeyEncryption")
    def customer_managed_key_encryption(self) -> Optional[pulumi.Input['CustomerManagedKeyEncryptionPropertiesArgs']]:
        """
        All Customer-managed key encryption properties for the resource.
        """
        return pulumi.get(self, "customer_managed_key_encryption")

    @customer_managed_key_encryption.setter
    def customer_managed_key_encryption(self, value: Optional[pulumi.Input['CustomerManagedKeyEncryptionPropertiesArgs']]):
        pulumi.set(self, "customer_managed_key_encryption", value)


@pulumi.input_type
class IdentityArgs:
    def __init__(__self__, *,
                 type: Optional[pulumi.Input['ResourceIdentityType']] = None,
                 user_assigned_identities: Optional[pulumi.Input[Mapping[str, Any]]] = None):
        """
        Identity for the resource.
        :param pulumi.Input['ResourceIdentityType'] type: The identity type.
        :param pulumi.Input[Mapping[str, Any]] user_assigned_identities: The list of user identities associated with the resource.
        """
        if type is not None:
            pulumi.set(__self__, "type", type)
        if user_assigned_identities is not None:
            pulumi.set(__self__, "user_assigned_identities", user_assigned_identities)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input['ResourceIdentityType']]:
        """
        The identity type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input['ResourceIdentityType']]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="userAssignedIdentities")
    def user_assigned_identities(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        The list of user identities associated with the resource.
        """
        return pulumi.get(self, "user_assigned_identities")

    @user_assigned_identities.setter
    def user_assigned_identities(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "user_assigned_identities", value)


