# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AssignmentPrincipalResponse',
    'CanonicalProfileDefinitionResponse',
    'CanonicalProfileDefinitionResponseProperties',
    'ConnectorMappingAvailabilityResponse',
    'ConnectorMappingCompleteOperationResponse',
    'ConnectorMappingErrorManagementResponse',
    'ConnectorMappingFormatResponse',
    'ConnectorMappingPropertiesResponse',
    'ConnectorMappingStructureResponse',
    'DataSourcePrecedenceResponse',
    'HubBillingInfoFormatResponse',
    'KpiAliasResponse',
    'KpiExtractResponse',
    'KpiGroupByMetadataResponse',
    'KpiParticipantProfilesMetadataResponse',
    'KpiThresholdsResponse',
    'ParticipantProfilePropertyReferenceResponse',
    'ParticipantPropertyReferenceResponse',
    'PredictionDistributionDefinitionResponse',
    'PredictionDistributionDefinitionResponseDistributions',
    'PredictionResponseGrades',
    'PredictionResponseMappings',
    'PredictionResponseSystemGeneratedEntities',
    'ProfileEnumValidValuesFormatResponse',
    'PropertyDefinitionResponse',
    'RelationshipLinkFieldMappingResponse',
    'RelationshipTypeFieldMappingResponse',
    'RelationshipTypeMappingResponse',
    'ResourceSetDescriptionResponse',
    'StrongIdResponse',
    'TypePropertiesMappingResponse',
]

@pulumi.output_type
class AssignmentPrincipalResponse(dict):
    """
    The AssignmentPrincipal
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "principalId":
            suggest = "principal_id"
        elif key == "principalType":
            suggest = "principal_type"
        elif key == "principalMetadata":
            suggest = "principal_metadata"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AssignmentPrincipalResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AssignmentPrincipalResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AssignmentPrincipalResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 principal_id: str,
                 principal_type: str,
                 principal_metadata: Optional[Mapping[str, str]] = None):
        """
        The AssignmentPrincipal
        :param str principal_id: The principal id being assigned to.
        :param str principal_type: The Type of the principal ID.
        :param Mapping[str, str] principal_metadata: Other metadata for the principal.
        """
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "principal_type", principal_type)
        if principal_metadata is not None:
            pulumi.set(__self__, "principal_metadata", principal_metadata)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> str:
        """
        The principal id being assigned to.
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="principalType")
    def principal_type(self) -> str:
        """
        The Type of the principal ID.
        """
        return pulumi.get(self, "principal_type")

    @property
    @pulumi.getter(name="principalMetadata")
    def principal_metadata(self) -> Optional[Mapping[str, str]]:
        """
        Other metadata for the principal.
        """
        return pulumi.get(self, "principal_metadata")


@pulumi.output_type
class CanonicalProfileDefinitionResponse(dict):
    """
    Definition of canonical profile.
    """
    def __init__(__self__, *,
                 canonical_profile_id: Optional[int] = None,
                 properties: Optional[Sequence['outputs.CanonicalProfileDefinitionResponseProperties']] = None):
        """
        Definition of canonical profile.
        :param int canonical_profile_id: Canonical profile ID.
        :param Sequence['CanonicalProfileDefinitionResponseProperties'] properties: Properties of the canonical profile.
        """
        if canonical_profile_id is not None:
            pulumi.set(__self__, "canonical_profile_id", canonical_profile_id)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter(name="canonicalProfileId")
    def canonical_profile_id(self) -> Optional[int]:
        """
        Canonical profile ID.
        """
        return pulumi.get(self, "canonical_profile_id")

    @property
    @pulumi.getter
    def properties(self) -> Optional[Sequence['outputs.CanonicalProfileDefinitionResponseProperties']]:
        """
        Properties of the canonical profile.
        """
        return pulumi.get(self, "properties")


@pulumi.output_type
class CanonicalProfileDefinitionResponseProperties(dict):
    """
    The definition of a canonical profile property.
    """
    def __init__(__self__, *,
                 profile_name: Optional[str] = None,
                 profile_property_name: Optional[str] = None,
                 rank: Optional[int] = None,
                 type: Optional[str] = None,
                 value: Optional[str] = None):
        """
        The definition of a canonical profile property.
        :param str profile_name: Profile name.
        :param str profile_property_name: Property name of profile.
        :param int rank: The rank.
        :param str type: Type of canonical property value.
        :param str value: Value of the canonical property.
        """
        if profile_name is not None:
            pulumi.set(__self__, "profile_name", profile_name)
        if profile_property_name is not None:
            pulumi.set(__self__, "profile_property_name", profile_property_name)
        if rank is not None:
            pulumi.set(__self__, "rank", rank)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="profileName")
    def profile_name(self) -> Optional[str]:
        """
        Profile name.
        """
        return pulumi.get(self, "profile_name")

    @property
    @pulumi.getter(name="profilePropertyName")
    def profile_property_name(self) -> Optional[str]:
        """
        Property name of profile.
        """
        return pulumi.get(self, "profile_property_name")

    @property
    @pulumi.getter
    def rank(self) -> Optional[int]:
        """
        The rank.
        """
        return pulumi.get(self, "rank")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Type of canonical property value.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        Value of the canonical property.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ConnectorMappingAvailabilityResponse(dict):
    """
    Connector mapping property availability.
    """
    def __init__(__self__, *,
                 interval: int,
                 frequency: Optional[str] = None):
        """
        Connector mapping property availability.
        :param int interval: The interval of the given frequency to use.
        :param str frequency: The frequency to update.
        """
        pulumi.set(__self__, "interval", interval)
        if frequency is not None:
            pulumi.set(__self__, "frequency", frequency)

    @property
    @pulumi.getter
    def interval(self) -> int:
        """
        The interval of the given frequency to use.
        """
        return pulumi.get(self, "interval")

    @property
    @pulumi.getter
    def frequency(self) -> Optional[str]:
        """
        The frequency to update.
        """
        return pulumi.get(self, "frequency")


@pulumi.output_type
class ConnectorMappingCompleteOperationResponse(dict):
    """
    The complete operation.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "completionOperationType":
            suggest = "completion_operation_type"
        elif key == "destinationFolder":
            suggest = "destination_folder"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectorMappingCompleteOperationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectorMappingCompleteOperationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectorMappingCompleteOperationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 completion_operation_type: Optional[str] = None,
                 destination_folder: Optional[str] = None):
        """
        The complete operation.
        :param str completion_operation_type: The type of completion operation.
        :param str destination_folder: The destination folder where files will be moved to once the import is done.
        """
        if completion_operation_type is not None:
            pulumi.set(__self__, "completion_operation_type", completion_operation_type)
        if destination_folder is not None:
            pulumi.set(__self__, "destination_folder", destination_folder)

    @property
    @pulumi.getter(name="completionOperationType")
    def completion_operation_type(self) -> Optional[str]:
        """
        The type of completion operation.
        """
        return pulumi.get(self, "completion_operation_type")

    @property
    @pulumi.getter(name="destinationFolder")
    def destination_folder(self) -> Optional[str]:
        """
        The destination folder where files will be moved to once the import is done.
        """
        return pulumi.get(self, "destination_folder")


@pulumi.output_type
class ConnectorMappingErrorManagementResponse(dict):
    """
    The error management.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "errorManagementType":
            suggest = "error_management_type"
        elif key == "errorLimit":
            suggest = "error_limit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectorMappingErrorManagementResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectorMappingErrorManagementResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectorMappingErrorManagementResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 error_management_type: str,
                 error_limit: Optional[int] = None):
        """
        The error management.
        :param str error_management_type: The type of error management to use for the mapping.
        :param int error_limit: The error limit allowed while importing data.
        """
        pulumi.set(__self__, "error_management_type", error_management_type)
        if error_limit is not None:
            pulumi.set(__self__, "error_limit", error_limit)

    @property
    @pulumi.getter(name="errorManagementType")
    def error_management_type(self) -> str:
        """
        The type of error management to use for the mapping.
        """
        return pulumi.get(self, "error_management_type")

    @property
    @pulumi.getter(name="errorLimit")
    def error_limit(self) -> Optional[int]:
        """
        The error limit allowed while importing data.
        """
        return pulumi.get(self, "error_limit")


@pulumi.output_type
class ConnectorMappingFormatResponse(dict):
    """
    Connector mapping property format.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "formatType":
            suggest = "format_type"
        elif key == "acceptLanguage":
            suggest = "accept_language"
        elif key == "arraySeparator":
            suggest = "array_separator"
        elif key == "columnDelimiter":
            suggest = "column_delimiter"
        elif key == "quoteCharacter":
            suggest = "quote_character"
        elif key == "quoteEscapeCharacter":
            suggest = "quote_escape_character"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectorMappingFormatResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectorMappingFormatResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectorMappingFormatResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 format_type: str,
                 accept_language: Optional[str] = None,
                 array_separator: Optional[str] = None,
                 column_delimiter: Optional[str] = None,
                 quote_character: Optional[str] = None,
                 quote_escape_character: Optional[str] = None):
        """
        Connector mapping property format.
        :param str format_type: The type mapping format.
        :param str accept_language: The oData language.
        :param str array_separator: Character separating array elements.
        :param str column_delimiter: The character that signifies a break between columns.
        :param str quote_character: Quote character, used to indicate enquoted fields.
        :param str quote_escape_character: Escape character for quotes, can be the same as the quoteCharacter.
        """
        pulumi.set(__self__, "format_type", format_type)
        if accept_language is not None:
            pulumi.set(__self__, "accept_language", accept_language)
        if array_separator is not None:
            pulumi.set(__self__, "array_separator", array_separator)
        if column_delimiter is not None:
            pulumi.set(__self__, "column_delimiter", column_delimiter)
        if quote_character is not None:
            pulumi.set(__self__, "quote_character", quote_character)
        if quote_escape_character is not None:
            pulumi.set(__self__, "quote_escape_character", quote_escape_character)

    @property
    @pulumi.getter(name="formatType")
    def format_type(self) -> str:
        """
        The type mapping format.
        """
        return pulumi.get(self, "format_type")

    @property
    @pulumi.getter(name="acceptLanguage")
    def accept_language(self) -> Optional[str]:
        """
        The oData language.
        """
        return pulumi.get(self, "accept_language")

    @property
    @pulumi.getter(name="arraySeparator")
    def array_separator(self) -> Optional[str]:
        """
        Character separating array elements.
        """
        return pulumi.get(self, "array_separator")

    @property
    @pulumi.getter(name="columnDelimiter")
    def column_delimiter(self) -> Optional[str]:
        """
        The character that signifies a break between columns.
        """
        return pulumi.get(self, "column_delimiter")

    @property
    @pulumi.getter(name="quoteCharacter")
    def quote_character(self) -> Optional[str]:
        """
        Quote character, used to indicate enquoted fields.
        """
        return pulumi.get(self, "quote_character")

    @property
    @pulumi.getter(name="quoteEscapeCharacter")
    def quote_escape_character(self) -> Optional[str]:
        """
        Escape character for quotes, can be the same as the quoteCharacter.
        """
        return pulumi.get(self, "quote_escape_character")


@pulumi.output_type
class ConnectorMappingPropertiesResponse(dict):
    """
    The connector mapping properties.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "completeOperation":
            suggest = "complete_operation"
        elif key == "errorManagement":
            suggest = "error_management"
        elif key == "fileFilter":
            suggest = "file_filter"
        elif key == "folderPath":
            suggest = "folder_path"
        elif key == "hasHeader":
            suggest = "has_header"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectorMappingPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectorMappingPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectorMappingPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 availability: 'outputs.ConnectorMappingAvailabilityResponse',
                 complete_operation: 'outputs.ConnectorMappingCompleteOperationResponse',
                 error_management: 'outputs.ConnectorMappingErrorManagementResponse',
                 format: 'outputs.ConnectorMappingFormatResponse',
                 structure: Sequence['outputs.ConnectorMappingStructureResponse'],
                 file_filter: Optional[str] = None,
                 folder_path: Optional[str] = None,
                 has_header: Optional[bool] = None):
        """
        The connector mapping properties.
        :param 'ConnectorMappingAvailabilityResponse' availability: The availability of mapping property.
        :param 'ConnectorMappingCompleteOperationResponse' complete_operation: The operation after import is done.
        :param 'ConnectorMappingErrorManagementResponse' error_management: The error management setting for the mapping.
        :param 'ConnectorMappingFormatResponse' format: The format of mapping property.
        :param Sequence['ConnectorMappingStructureResponse'] structure: Ingestion mapping information at property level.
        :param str file_filter: The file filter for the mapping.
        :param str folder_path: The folder path for the mapping.
        :param bool has_header: If the file contains a header or not.
        """
        pulumi.set(__self__, "availability", availability)
        pulumi.set(__self__, "complete_operation", complete_operation)
        pulumi.set(__self__, "error_management", error_management)
        pulumi.set(__self__, "format", format)
        pulumi.set(__self__, "structure", structure)
        if file_filter is not None:
            pulumi.set(__self__, "file_filter", file_filter)
        if folder_path is not None:
            pulumi.set(__self__, "folder_path", folder_path)
        if has_header is not None:
            pulumi.set(__self__, "has_header", has_header)

    @property
    @pulumi.getter
    def availability(self) -> 'outputs.ConnectorMappingAvailabilityResponse':
        """
        The availability of mapping property.
        """
        return pulumi.get(self, "availability")

    @property
    @pulumi.getter(name="completeOperation")
    def complete_operation(self) -> 'outputs.ConnectorMappingCompleteOperationResponse':
        """
        The operation after import is done.
        """
        return pulumi.get(self, "complete_operation")

    @property
    @pulumi.getter(name="errorManagement")
    def error_management(self) -> 'outputs.ConnectorMappingErrorManagementResponse':
        """
        The error management setting for the mapping.
        """
        return pulumi.get(self, "error_management")

    @property
    @pulumi.getter
    def format(self) -> 'outputs.ConnectorMappingFormatResponse':
        """
        The format of mapping property.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter
    def structure(self) -> Sequence['outputs.ConnectorMappingStructureResponse']:
        """
        Ingestion mapping information at property level.
        """
        return pulumi.get(self, "structure")

    @property
    @pulumi.getter(name="fileFilter")
    def file_filter(self) -> Optional[str]:
        """
        The file filter for the mapping.
        """
        return pulumi.get(self, "file_filter")

    @property
    @pulumi.getter(name="folderPath")
    def folder_path(self) -> Optional[str]:
        """
        The folder path for the mapping.
        """
        return pulumi.get(self, "folder_path")

    @property
    @pulumi.getter(name="hasHeader")
    def has_header(self) -> Optional[bool]:
        """
        If the file contains a header or not.
        """
        return pulumi.get(self, "has_header")


@pulumi.output_type
class ConnectorMappingStructureResponse(dict):
    """
    Connector mapping property structure.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "columnName":
            suggest = "column_name"
        elif key == "propertyName":
            suggest = "property_name"
        elif key == "customFormatSpecifier":
            suggest = "custom_format_specifier"
        elif key == "isEncrypted":
            suggest = "is_encrypted"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectorMappingStructureResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectorMappingStructureResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectorMappingStructureResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 column_name: str,
                 property_name: str,
                 custom_format_specifier: Optional[str] = None,
                 is_encrypted: Optional[bool] = None):
        """
        Connector mapping property structure.
        :param str column_name: The column name of the import file.
        :param str property_name: The property name of the mapping entity.
        :param str custom_format_specifier: Custom format specifier for input parsing.
        :param bool is_encrypted: Indicates if the column is encrypted.
        """
        pulumi.set(__self__, "column_name", column_name)
        pulumi.set(__self__, "property_name", property_name)
        if custom_format_specifier is not None:
            pulumi.set(__self__, "custom_format_specifier", custom_format_specifier)
        if is_encrypted is not None:
            pulumi.set(__self__, "is_encrypted", is_encrypted)

    @property
    @pulumi.getter(name="columnName")
    def column_name(self) -> str:
        """
        The column name of the import file.
        """
        return pulumi.get(self, "column_name")

    @property
    @pulumi.getter(name="propertyName")
    def property_name(self) -> str:
        """
        The property name of the mapping entity.
        """
        return pulumi.get(self, "property_name")

    @property
    @pulumi.getter(name="customFormatSpecifier")
    def custom_format_specifier(self) -> Optional[str]:
        """
        Custom format specifier for input parsing.
        """
        return pulumi.get(self, "custom_format_specifier")

    @property
    @pulumi.getter(name="isEncrypted")
    def is_encrypted(self) -> Optional[bool]:
        """
        Indicates if the column is encrypted.
        """
        return pulumi.get(self, "is_encrypted")


@pulumi.output_type
class DataSourcePrecedenceResponse(dict):
    """
    The data source precedence is a way to know the precedence of each data source.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataSourceReferenceId":
            suggest = "data_source_reference_id"
        elif key == "dataSourceType":
            suggest = "data_source_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourcePrecedenceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourcePrecedenceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourcePrecedenceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_source_reference_id: str,
                 data_source_type: str,
                 id: int,
                 name: str,
                 status: str,
                 precedence: Optional[int] = None):
        """
        The data source precedence is a way to know the precedence of each data source.
        :param str data_source_reference_id: The data source reference id.
        :param str data_source_type: The data source type.
        :param int id: The data source ID.
        :param str name: The data source name
        :param str status: The data source status.
        :param int precedence: the precedence value.
        """
        pulumi.set(__self__, "data_source_reference_id", data_source_reference_id)
        pulumi.set(__self__, "data_source_type", data_source_type)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "status", status)
        if precedence is not None:
            pulumi.set(__self__, "precedence", precedence)

    @property
    @pulumi.getter(name="dataSourceReferenceId")
    def data_source_reference_id(self) -> str:
        """
        The data source reference id.
        """
        return pulumi.get(self, "data_source_reference_id")

    @property
    @pulumi.getter(name="dataSourceType")
    def data_source_type(self) -> str:
        """
        The data source type.
        """
        return pulumi.get(self, "data_source_type")

    @property
    @pulumi.getter
    def id(self) -> int:
        """
        The data source ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The data source name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The data source status.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def precedence(self) -> Optional[int]:
        """
        the precedence value.
        """
        return pulumi.get(self, "precedence")


@pulumi.output_type
class HubBillingInfoFormatResponse(dict):
    """
    Hub billing info.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxUnits":
            suggest = "max_units"
        elif key == "minUnits":
            suggest = "min_units"
        elif key == "skuName":
            suggest = "sku_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HubBillingInfoFormatResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HubBillingInfoFormatResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HubBillingInfoFormatResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_units: Optional[int] = None,
                 min_units: Optional[int] = None,
                 sku_name: Optional[str] = None):
        """
        Hub billing info.
        :param int max_units: The maximum number of units can be used.  One unit is 10,000 Profiles and 100,000 Interactions.
        :param int min_units: The minimum number of units will be billed. One unit is 10,000 Profiles and 100,000 Interactions.
        :param str sku_name: The sku name.
        """
        if max_units is not None:
            pulumi.set(__self__, "max_units", max_units)
        if min_units is not None:
            pulumi.set(__self__, "min_units", min_units)
        if sku_name is not None:
            pulumi.set(__self__, "sku_name", sku_name)

    @property
    @pulumi.getter(name="maxUnits")
    def max_units(self) -> Optional[int]:
        """
        The maximum number of units can be used.  One unit is 10,000 Profiles and 100,000 Interactions.
        """
        return pulumi.get(self, "max_units")

    @property
    @pulumi.getter(name="minUnits")
    def min_units(self) -> Optional[int]:
        """
        The minimum number of units will be billed. One unit is 10,000 Profiles and 100,000 Interactions.
        """
        return pulumi.get(self, "min_units")

    @property
    @pulumi.getter(name="skuName")
    def sku_name(self) -> Optional[str]:
        """
        The sku name.
        """
        return pulumi.get(self, "sku_name")


@pulumi.output_type
class KpiAliasResponse(dict):
    """
    The KPI alias.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "aliasName":
            suggest = "alias_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KpiAliasResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KpiAliasResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KpiAliasResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 alias_name: str,
                 expression: str):
        """
        The KPI alias.
        :param str alias_name: KPI alias name.
        :param str expression: The expression.
        """
        pulumi.set(__self__, "alias_name", alias_name)
        pulumi.set(__self__, "expression", expression)

    @property
    @pulumi.getter(name="aliasName")
    def alias_name(self) -> str:
        """
        KPI alias name.
        """
        return pulumi.get(self, "alias_name")

    @property
    @pulumi.getter
    def expression(self) -> str:
        """
        The expression.
        """
        return pulumi.get(self, "expression")


@pulumi.output_type
class KpiExtractResponse(dict):
    """
    The KPI extract.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "extractName":
            suggest = "extract_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KpiExtractResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KpiExtractResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KpiExtractResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 expression: str,
                 extract_name: str):
        """
        The KPI extract.
        :param str expression: The expression.
        :param str extract_name: KPI extract name.
        """
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "extract_name", extract_name)

    @property
    @pulumi.getter
    def expression(self) -> str:
        """
        The expression.
        """
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter(name="extractName")
    def extract_name(self) -> str:
        """
        KPI extract name.
        """
        return pulumi.get(self, "extract_name")


@pulumi.output_type
class KpiGroupByMetadataResponse(dict):
    """
    The KPI GroupBy field metadata.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "displayName":
            suggest = "display_name"
        elif key == "fieldName":
            suggest = "field_name"
        elif key == "fieldType":
            suggest = "field_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KpiGroupByMetadataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KpiGroupByMetadataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KpiGroupByMetadataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 display_name: Optional[Mapping[str, str]] = None,
                 field_name: Optional[str] = None,
                 field_type: Optional[str] = None):
        """
        The KPI GroupBy field metadata.
        :param Mapping[str, str] display_name: The display name.
        :param str field_name: The name of the field.
        :param str field_type: The type of the field.
        """
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if field_name is not None:
            pulumi.set(__self__, "field_name", field_name)
        if field_type is not None:
            pulumi.set(__self__, "field_type", field_type)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[Mapping[str, str]]:
        """
        The display name.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="fieldName")
    def field_name(self) -> Optional[str]:
        """
        The name of the field.
        """
        return pulumi.get(self, "field_name")

    @property
    @pulumi.getter(name="fieldType")
    def field_type(self) -> Optional[str]:
        """
        The type of the field.
        """
        return pulumi.get(self, "field_type")


@pulumi.output_type
class KpiParticipantProfilesMetadataResponse(dict):
    """
    The KPI participant profile metadata.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "typeName":
            suggest = "type_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KpiParticipantProfilesMetadataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KpiParticipantProfilesMetadataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KpiParticipantProfilesMetadataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type_name: str):
        """
        The KPI participant profile metadata.
        :param str type_name: Name of the type.
        """
        pulumi.set(__self__, "type_name", type_name)

    @property
    @pulumi.getter(name="typeName")
    def type_name(self) -> str:
        """
        Name of the type.
        """
        return pulumi.get(self, "type_name")


@pulumi.output_type
class KpiThresholdsResponse(dict):
    """
    Defines the KPI Threshold limits.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "increasingKpi":
            suggest = "increasing_kpi"
        elif key == "lowerLimit":
            suggest = "lower_limit"
        elif key == "upperLimit":
            suggest = "upper_limit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KpiThresholdsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KpiThresholdsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KpiThresholdsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 increasing_kpi: bool,
                 lower_limit: float,
                 upper_limit: float):
        """
        Defines the KPI Threshold limits.
        :param bool increasing_kpi: Whether or not the KPI is an increasing KPI.
        :param float lower_limit: The lower threshold limit.
        :param float upper_limit: The upper threshold limit.
        """
        pulumi.set(__self__, "increasing_kpi", increasing_kpi)
        pulumi.set(__self__, "lower_limit", lower_limit)
        pulumi.set(__self__, "upper_limit", upper_limit)

    @property
    @pulumi.getter(name="increasingKpi")
    def increasing_kpi(self) -> bool:
        """
        Whether or not the KPI is an increasing KPI.
        """
        return pulumi.get(self, "increasing_kpi")

    @property
    @pulumi.getter(name="lowerLimit")
    def lower_limit(self) -> float:
        """
        The lower threshold limit.
        """
        return pulumi.get(self, "lower_limit")

    @property
    @pulumi.getter(name="upperLimit")
    def upper_limit(self) -> float:
        """
        The upper threshold limit.
        """
        return pulumi.get(self, "upper_limit")


@pulumi.output_type
class ParticipantProfilePropertyReferenceResponse(dict):
    """
    The participant profile property reference.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "interactionPropertyName":
            suggest = "interaction_property_name"
        elif key == "profilePropertyName":
            suggest = "profile_property_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ParticipantProfilePropertyReferenceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ParticipantProfilePropertyReferenceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ParticipantProfilePropertyReferenceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 interaction_property_name: str,
                 profile_property_name: str):
        """
        The participant profile property reference.
        :param str interaction_property_name: The source interaction property that maps to the target profile property.
        :param str profile_property_name: The target profile property that maps to the source interaction property.
        """
        pulumi.set(__self__, "interaction_property_name", interaction_property_name)
        pulumi.set(__self__, "profile_property_name", profile_property_name)

    @property
    @pulumi.getter(name="interactionPropertyName")
    def interaction_property_name(self) -> str:
        """
        The source interaction property that maps to the target profile property.
        """
        return pulumi.get(self, "interaction_property_name")

    @property
    @pulumi.getter(name="profilePropertyName")
    def profile_property_name(self) -> str:
        """
        The target profile property that maps to the source interaction property.
        """
        return pulumi.get(self, "profile_property_name")


@pulumi.output_type
class ParticipantPropertyReferenceResponse(dict):
    """
    The participant property reference.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourcePropertyName":
            suggest = "source_property_name"
        elif key == "targetPropertyName":
            suggest = "target_property_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ParticipantPropertyReferenceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ParticipantPropertyReferenceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ParticipantPropertyReferenceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 source_property_name: str,
                 target_property_name: str):
        """
        The participant property reference.
        :param str source_property_name: The source property that maps to the target property.
        :param str target_property_name: The target property that maps to the source property.
        """
        pulumi.set(__self__, "source_property_name", source_property_name)
        pulumi.set(__self__, "target_property_name", target_property_name)

    @property
    @pulumi.getter(name="sourcePropertyName")
    def source_property_name(self) -> str:
        """
        The source property that maps to the target property.
        """
        return pulumi.get(self, "source_property_name")

    @property
    @pulumi.getter(name="targetPropertyName")
    def target_property_name(self) -> str:
        """
        The target property that maps to the source property.
        """
        return pulumi.get(self, "target_property_name")


@pulumi.output_type
class PredictionDistributionDefinitionResponse(dict):
    """
    The definition of the prediction distribution.
    """
    def __init__(__self__, *,
                 distributions: Optional[Sequence['outputs.PredictionDistributionDefinitionResponseDistributions']] = None,
                 total_negatives: Optional[float] = None,
                 total_positives: Optional[float] = None):
        """
        The definition of the prediction distribution.
        :param Sequence['PredictionDistributionDefinitionResponseDistributions'] distributions: Distributions of the prediction.
        :param float total_negatives: Total negatives in the distribution.
        :param float total_positives: Total positive in the distribution.
        """
        if distributions is not None:
            pulumi.set(__self__, "distributions", distributions)
        if total_negatives is not None:
            pulumi.set(__self__, "total_negatives", total_negatives)
        if total_positives is not None:
            pulumi.set(__self__, "total_positives", total_positives)

    @property
    @pulumi.getter
    def distributions(self) -> Optional[Sequence['outputs.PredictionDistributionDefinitionResponseDistributions']]:
        """
        Distributions of the prediction.
        """
        return pulumi.get(self, "distributions")

    @property
    @pulumi.getter(name="totalNegatives")
    def total_negatives(self) -> Optional[float]:
        """
        Total negatives in the distribution.
        """
        return pulumi.get(self, "total_negatives")

    @property
    @pulumi.getter(name="totalPositives")
    def total_positives(self) -> Optional[float]:
        """
        Total positive in the distribution.
        """
        return pulumi.get(self, "total_positives")


@pulumi.output_type
class PredictionDistributionDefinitionResponseDistributions(dict):
    """
    The definition of a prediction distribution.
    """
    def __init__(__self__, *,
                 negatives: Optional[float] = None,
                 negatives_above_threshold: Optional[float] = None,
                 positives: Optional[float] = None,
                 positives_above_threshold: Optional[float] = None,
                 score_threshold: Optional[int] = None):
        """
        The definition of a prediction distribution.
        :param float negatives: Number of negatives.
        :param float negatives_above_threshold: Number of negatives above threshold.
        :param float positives: Number of positives.
        :param float positives_above_threshold: Number of positives above threshold.
        :param int score_threshold: Score threshold.
        """
        if negatives is not None:
            pulumi.set(__self__, "negatives", negatives)
        if negatives_above_threshold is not None:
            pulumi.set(__self__, "negatives_above_threshold", negatives_above_threshold)
        if positives is not None:
            pulumi.set(__self__, "positives", positives)
        if positives_above_threshold is not None:
            pulumi.set(__self__, "positives_above_threshold", positives_above_threshold)
        if score_threshold is not None:
            pulumi.set(__self__, "score_threshold", score_threshold)

    @property
    @pulumi.getter
    def negatives(self) -> Optional[float]:
        """
        Number of negatives.
        """
        return pulumi.get(self, "negatives")

    @property
    @pulumi.getter(name="negativesAboveThreshold")
    def negatives_above_threshold(self) -> Optional[float]:
        """
        Number of negatives above threshold.
        """
        return pulumi.get(self, "negatives_above_threshold")

    @property
    @pulumi.getter
    def positives(self) -> Optional[float]:
        """
        Number of positives.
        """
        return pulumi.get(self, "positives")

    @property
    @pulumi.getter(name="positivesAboveThreshold")
    def positives_above_threshold(self) -> Optional[float]:
        """
        Number of positives above threshold.
        """
        return pulumi.get(self, "positives_above_threshold")

    @property
    @pulumi.getter(name="scoreThreshold")
    def score_threshold(self) -> Optional[int]:
        """
        Score threshold.
        """
        return pulumi.get(self, "score_threshold")


@pulumi.output_type
class PredictionResponseGrades(dict):
    """
    The definition of a prediction grade.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "gradeName":
            suggest = "grade_name"
        elif key == "maxScoreThreshold":
            suggest = "max_score_threshold"
        elif key == "minScoreThreshold":
            suggest = "min_score_threshold"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PredictionResponseGrades. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PredictionResponseGrades.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PredictionResponseGrades.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 grade_name: Optional[str] = None,
                 max_score_threshold: Optional[int] = None,
                 min_score_threshold: Optional[int] = None):
        """
        The definition of a prediction grade.
        :param str grade_name: Name of the grade.
        :param int max_score_threshold: Maximum score threshold.
        :param int min_score_threshold: Minimum score threshold.
        """
        if grade_name is not None:
            pulumi.set(__self__, "grade_name", grade_name)
        if max_score_threshold is not None:
            pulumi.set(__self__, "max_score_threshold", max_score_threshold)
        if min_score_threshold is not None:
            pulumi.set(__self__, "min_score_threshold", min_score_threshold)

    @property
    @pulumi.getter(name="gradeName")
    def grade_name(self) -> Optional[str]:
        """
        Name of the grade.
        """
        return pulumi.get(self, "grade_name")

    @property
    @pulumi.getter(name="maxScoreThreshold")
    def max_score_threshold(self) -> Optional[int]:
        """
        Maximum score threshold.
        """
        return pulumi.get(self, "max_score_threshold")

    @property
    @pulumi.getter(name="minScoreThreshold")
    def min_score_threshold(self) -> Optional[int]:
        """
        Minimum score threshold.
        """
        return pulumi.get(self, "min_score_threshold")


@pulumi.output_type
class PredictionResponseMappings(dict):
    """
    Definition of the link mapping of prediction.
    """
    def __init__(__self__, *,
                 grade: str,
                 reason: str,
                 score: str):
        """
        Definition of the link mapping of prediction.
        :param str grade: The grade of the link mapping.
        :param str reason: The reason of the link mapping.
        :param str score: The score of the link mapping.
        """
        pulumi.set(__self__, "grade", grade)
        pulumi.set(__self__, "reason", reason)
        pulumi.set(__self__, "score", score)

    @property
    @pulumi.getter
    def grade(self) -> str:
        """
        The grade of the link mapping.
        """
        return pulumi.get(self, "grade")

    @property
    @pulumi.getter
    def reason(self) -> str:
        """
        The reason of the link mapping.
        """
        return pulumi.get(self, "reason")

    @property
    @pulumi.getter
    def score(self) -> str:
        """
        The score of the link mapping.
        """
        return pulumi.get(self, "score")


@pulumi.output_type
class PredictionResponseSystemGeneratedEntities(dict):
    """
    System generated entities.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "generatedInteractionTypes":
            suggest = "generated_interaction_types"
        elif key == "generatedKpis":
            suggest = "generated_kpis"
        elif key == "generatedLinks":
            suggest = "generated_links"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PredictionResponseSystemGeneratedEntities. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PredictionResponseSystemGeneratedEntities.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PredictionResponseSystemGeneratedEntities.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 generated_interaction_types: Optional[Sequence[str]] = None,
                 generated_kpis: Optional[Mapping[str, str]] = None,
                 generated_links: Optional[Sequence[str]] = None):
        """
        System generated entities.
        :param Sequence[str] generated_interaction_types: Generated interaction types.
        :param Mapping[str, str] generated_kpis: Generated KPIs.
        :param Sequence[str] generated_links: Generated links.
        """
        if generated_interaction_types is not None:
            pulumi.set(__self__, "generated_interaction_types", generated_interaction_types)
        if generated_kpis is not None:
            pulumi.set(__self__, "generated_kpis", generated_kpis)
        if generated_links is not None:
            pulumi.set(__self__, "generated_links", generated_links)

    @property
    @pulumi.getter(name="generatedInteractionTypes")
    def generated_interaction_types(self) -> Optional[Sequence[str]]:
        """
        Generated interaction types.
        """
        return pulumi.get(self, "generated_interaction_types")

    @property
    @pulumi.getter(name="generatedKpis")
    def generated_kpis(self) -> Optional[Mapping[str, str]]:
        """
        Generated KPIs.
        """
        return pulumi.get(self, "generated_kpis")

    @property
    @pulumi.getter(name="generatedLinks")
    def generated_links(self) -> Optional[Sequence[str]]:
        """
        Generated links.
        """
        return pulumi.get(self, "generated_links")


@pulumi.output_type
class ProfileEnumValidValuesFormatResponse(dict):
    """
    Valid enum values in case of an enum property.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "localizedValueNames":
            suggest = "localized_value_names"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProfileEnumValidValuesFormatResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProfileEnumValidValuesFormatResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProfileEnumValidValuesFormatResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 localized_value_names: Optional[Mapping[str, str]] = None,
                 value: Optional[int] = None):
        """
        Valid enum values in case of an enum property.
        :param Mapping[str, str] localized_value_names: Localized names of the enum member.
        :param int value: The integer value of the enum member.
        """
        if localized_value_names is not None:
            pulumi.set(__self__, "localized_value_names", localized_value_names)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="localizedValueNames")
    def localized_value_names(self) -> Optional[Mapping[str, str]]:
        """
        Localized names of the enum member.
        """
        return pulumi.get(self, "localized_value_names")

    @property
    @pulumi.getter
    def value(self) -> Optional[int]:
        """
        The integer value of the enum member.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class PropertyDefinitionResponse(dict):
    """
    Property definition.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataSourcePrecedenceRules":
            suggest = "data_source_precedence_rules"
        elif key == "fieldName":
            suggest = "field_name"
        elif key == "fieldType":
            suggest = "field_type"
        elif key == "arrayValueSeparator":
            suggest = "array_value_separator"
        elif key == "enumValidValues":
            suggest = "enum_valid_values"
        elif key == "isArray":
            suggest = "is_array"
        elif key == "isAvailableInGraph":
            suggest = "is_available_in_graph"
        elif key == "isEnum":
            suggest = "is_enum"
        elif key == "isFlagEnum":
            suggest = "is_flag_enum"
        elif key == "isImage":
            suggest = "is_image"
        elif key == "isLocalizedString":
            suggest = "is_localized_string"
        elif key == "isName":
            suggest = "is_name"
        elif key == "isRequired":
            suggest = "is_required"
        elif key == "maxLength":
            suggest = "max_length"
        elif key == "propertyId":
            suggest = "property_id"
        elif key == "schemaItemPropLink":
            suggest = "schema_item_prop_link"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PropertyDefinitionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PropertyDefinitionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PropertyDefinitionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_source_precedence_rules: Sequence['outputs.DataSourcePrecedenceResponse'],
                 field_name: str,
                 field_type: str,
                 array_value_separator: Optional[str] = None,
                 enum_valid_values: Optional[Sequence['outputs.ProfileEnumValidValuesFormatResponse']] = None,
                 is_array: Optional[bool] = None,
                 is_available_in_graph: Optional[bool] = None,
                 is_enum: Optional[bool] = None,
                 is_flag_enum: Optional[bool] = None,
                 is_image: Optional[bool] = None,
                 is_localized_string: Optional[bool] = None,
                 is_name: Optional[bool] = None,
                 is_required: Optional[bool] = None,
                 max_length: Optional[int] = None,
                 property_id: Optional[str] = None,
                 schema_item_prop_link: Optional[str] = None):
        """
        Property definition.
        :param Sequence['DataSourcePrecedenceResponse'] data_source_precedence_rules: This is specific to interactions modeled as activities. Data sources are used to determine where data is stored and also in precedence rules.
        :param str field_name: Name of the property.
        :param str field_type: Type of the property.
        :param str array_value_separator: Array value separator for properties with isArray set.
        :param Sequence['ProfileEnumValidValuesFormatResponse'] enum_valid_values: Describes valid values for an enum property.
        :param bool is_array: Indicates if the property is actually an array of the fieldType above on the data api.
        :param bool is_available_in_graph: Whether property is available in graph or not.
        :param bool is_enum: Indicates if the property is an enum.
        :param bool is_flag_enum: Indicates if the property is an flag enum.
        :param bool is_image: Whether the property is an Image.
        :param bool is_localized_string: Whether the property is a localized string.
        :param bool is_name: Whether the property is a name or a part of name.
        :param bool is_required: Whether property value is required on instances, IsRequired field only for Interaction. Profile Instance will not check for required field.
        :param int max_length: Max length of string. Used only if type is string.
        :param str property_id: The ID associated with the property.
        :param str schema_item_prop_link: URL encoded schema.org item prop link for the property.
        """
        pulumi.set(__self__, "data_source_precedence_rules", data_source_precedence_rules)
        pulumi.set(__self__, "field_name", field_name)
        pulumi.set(__self__, "field_type", field_type)
        if array_value_separator is not None:
            pulumi.set(__self__, "array_value_separator", array_value_separator)
        if enum_valid_values is not None:
            pulumi.set(__self__, "enum_valid_values", enum_valid_values)
        if is_array is not None:
            pulumi.set(__self__, "is_array", is_array)
        if is_available_in_graph is not None:
            pulumi.set(__self__, "is_available_in_graph", is_available_in_graph)
        if is_enum is not None:
            pulumi.set(__self__, "is_enum", is_enum)
        if is_flag_enum is not None:
            pulumi.set(__self__, "is_flag_enum", is_flag_enum)
        if is_image is not None:
            pulumi.set(__self__, "is_image", is_image)
        if is_localized_string is not None:
            pulumi.set(__self__, "is_localized_string", is_localized_string)
        if is_name is not None:
            pulumi.set(__self__, "is_name", is_name)
        if is_required is not None:
            pulumi.set(__self__, "is_required", is_required)
        if max_length is not None:
            pulumi.set(__self__, "max_length", max_length)
        if property_id is not None:
            pulumi.set(__self__, "property_id", property_id)
        if schema_item_prop_link is not None:
            pulumi.set(__self__, "schema_item_prop_link", schema_item_prop_link)

    @property
    @pulumi.getter(name="dataSourcePrecedenceRules")
    def data_source_precedence_rules(self) -> Sequence['outputs.DataSourcePrecedenceResponse']:
        """
        This is specific to interactions modeled as activities. Data sources are used to determine where data is stored and also in precedence rules.
        """
        return pulumi.get(self, "data_source_precedence_rules")

    @property
    @pulumi.getter(name="fieldName")
    def field_name(self) -> str:
        """
        Name of the property.
        """
        return pulumi.get(self, "field_name")

    @property
    @pulumi.getter(name="fieldType")
    def field_type(self) -> str:
        """
        Type of the property.
        """
        return pulumi.get(self, "field_type")

    @property
    @pulumi.getter(name="arrayValueSeparator")
    def array_value_separator(self) -> Optional[str]:
        """
        Array value separator for properties with isArray set.
        """
        return pulumi.get(self, "array_value_separator")

    @property
    @pulumi.getter(name="enumValidValues")
    def enum_valid_values(self) -> Optional[Sequence['outputs.ProfileEnumValidValuesFormatResponse']]:
        """
        Describes valid values for an enum property.
        """
        return pulumi.get(self, "enum_valid_values")

    @property
    @pulumi.getter(name="isArray")
    def is_array(self) -> Optional[bool]:
        """
        Indicates if the property is actually an array of the fieldType above on the data api.
        """
        return pulumi.get(self, "is_array")

    @property
    @pulumi.getter(name="isAvailableInGraph")
    def is_available_in_graph(self) -> Optional[bool]:
        """
        Whether property is available in graph or not.
        """
        return pulumi.get(self, "is_available_in_graph")

    @property
    @pulumi.getter(name="isEnum")
    def is_enum(self) -> Optional[bool]:
        """
        Indicates if the property is an enum.
        """
        return pulumi.get(self, "is_enum")

    @property
    @pulumi.getter(name="isFlagEnum")
    def is_flag_enum(self) -> Optional[bool]:
        """
        Indicates if the property is an flag enum.
        """
        return pulumi.get(self, "is_flag_enum")

    @property
    @pulumi.getter(name="isImage")
    def is_image(self) -> Optional[bool]:
        """
        Whether the property is an Image.
        """
        return pulumi.get(self, "is_image")

    @property
    @pulumi.getter(name="isLocalizedString")
    def is_localized_string(self) -> Optional[bool]:
        """
        Whether the property is a localized string.
        """
        return pulumi.get(self, "is_localized_string")

    @property
    @pulumi.getter(name="isName")
    def is_name(self) -> Optional[bool]:
        """
        Whether the property is a name or a part of name.
        """
        return pulumi.get(self, "is_name")

    @property
    @pulumi.getter(name="isRequired")
    def is_required(self) -> Optional[bool]:
        """
        Whether property value is required on instances, IsRequired field only for Interaction. Profile Instance will not check for required field.
        """
        return pulumi.get(self, "is_required")

    @property
    @pulumi.getter(name="maxLength")
    def max_length(self) -> Optional[int]:
        """
        Max length of string. Used only if type is string.
        """
        return pulumi.get(self, "max_length")

    @property
    @pulumi.getter(name="propertyId")
    def property_id(self) -> Optional[str]:
        """
        The ID associated with the property.
        """
        return pulumi.get(self, "property_id")

    @property
    @pulumi.getter(name="schemaItemPropLink")
    def schema_item_prop_link(self) -> Optional[str]:
        """
        URL encoded schema.org item prop link for the property.
        """
        return pulumi.get(self, "schema_item_prop_link")


@pulumi.output_type
class RelationshipLinkFieldMappingResponse(dict):
    """
    The fields mapping for Relationships.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "interactionFieldName":
            suggest = "interaction_field_name"
        elif key == "relationshipFieldName":
            suggest = "relationship_field_name"
        elif key == "linkType":
            suggest = "link_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RelationshipLinkFieldMappingResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RelationshipLinkFieldMappingResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RelationshipLinkFieldMappingResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 interaction_field_name: str,
                 relationship_field_name: str,
                 link_type: Optional[str] = None):
        """
        The fields mapping for Relationships.
        :param str interaction_field_name: The field name on the Interaction Type.
        :param str relationship_field_name: The field name on the Relationship metadata.
        :param str link_type: Link type.
        """
        pulumi.set(__self__, "interaction_field_name", interaction_field_name)
        pulumi.set(__self__, "relationship_field_name", relationship_field_name)
        if link_type is not None:
            pulumi.set(__self__, "link_type", link_type)

    @property
    @pulumi.getter(name="interactionFieldName")
    def interaction_field_name(self) -> str:
        """
        The field name on the Interaction Type.
        """
        return pulumi.get(self, "interaction_field_name")

    @property
    @pulumi.getter(name="relationshipFieldName")
    def relationship_field_name(self) -> str:
        """
        The field name on the Relationship metadata.
        """
        return pulumi.get(self, "relationship_field_name")

    @property
    @pulumi.getter(name="linkType")
    def link_type(self) -> Optional[str]:
        """
        Link type.
        """
        return pulumi.get(self, "link_type")


@pulumi.output_type
class RelationshipTypeFieldMappingResponse(dict):
    """
    Map a field of profile to its corresponding StrongId in Related Profile.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "profileFieldName":
            suggest = "profile_field_name"
        elif key == "relatedProfileKeyProperty":
            suggest = "related_profile_key_property"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RelationshipTypeFieldMappingResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RelationshipTypeFieldMappingResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RelationshipTypeFieldMappingResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 profile_field_name: str,
                 related_profile_key_property: str):
        """
        Map a field of profile to its corresponding StrongId in Related Profile.
        :param str profile_field_name: Specifies the fieldName in profile.
        :param str related_profile_key_property: Specifies the KeyProperty (from StrongId) of the related profile.
        """
        pulumi.set(__self__, "profile_field_name", profile_field_name)
        pulumi.set(__self__, "related_profile_key_property", related_profile_key_property)

    @property
    @pulumi.getter(name="profileFieldName")
    def profile_field_name(self) -> str:
        """
        Specifies the fieldName in profile.
        """
        return pulumi.get(self, "profile_field_name")

    @property
    @pulumi.getter(name="relatedProfileKeyProperty")
    def related_profile_key_property(self) -> str:
        """
        Specifies the KeyProperty (from StrongId) of the related profile.
        """
        return pulumi.get(self, "related_profile_key_property")


@pulumi.output_type
class RelationshipTypeMappingResponse(dict):
    """
    Maps fields in Profile to their corresponding StrongIds in Related Profile.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fieldMappings":
            suggest = "field_mappings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RelationshipTypeMappingResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RelationshipTypeMappingResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RelationshipTypeMappingResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 field_mappings: Sequence['outputs.RelationshipTypeFieldMappingResponse']):
        """
        Maps fields in Profile to their corresponding StrongIds in Related Profile.
        :param Sequence['RelationshipTypeFieldMappingResponse'] field_mappings: Maps a profile property with the StrongId of related profile. This is an array to support StrongIds that are composite key as well.
        """
        pulumi.set(__self__, "field_mappings", field_mappings)

    @property
    @pulumi.getter(name="fieldMappings")
    def field_mappings(self) -> Sequence['outputs.RelationshipTypeFieldMappingResponse']:
        """
        Maps a profile property with the StrongId of related profile. This is an array to support StrongIds that are composite key as well.
        """
        return pulumi.get(self, "field_mappings")


@pulumi.output_type
class ResourceSetDescriptionResponse(dict):
    """
    The resource set description.
    """
    def __init__(__self__, *,
                 elements: Optional[Sequence[str]] = None,
                 exceptions: Optional[Sequence[str]] = None):
        """
        The resource set description.
        :param Sequence[str] elements: The elements included in the set.
        :param Sequence[str] exceptions: The elements that are not included in the set, in case elements contains '*' indicating 'all'.
        """
        if elements is not None:
            pulumi.set(__self__, "elements", elements)
        if exceptions is not None:
            pulumi.set(__self__, "exceptions", exceptions)

    @property
    @pulumi.getter
    def elements(self) -> Optional[Sequence[str]]:
        """
        The elements included in the set.
        """
        return pulumi.get(self, "elements")

    @property
    @pulumi.getter
    def exceptions(self) -> Optional[Sequence[str]]:
        """
        The elements that are not included in the set, in case elements contains '*' indicating 'all'.
        """
        return pulumi.get(self, "exceptions")


@pulumi.output_type
class StrongIdResponse(dict):
    """
    Property/Properties which represent a unique ID.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyPropertyNames":
            suggest = "key_property_names"
        elif key == "strongIdName":
            suggest = "strong_id_name"
        elif key == "displayName":
            suggest = "display_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StrongIdResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StrongIdResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StrongIdResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_property_names: Sequence[str],
                 strong_id_name: str,
                 description: Optional[Mapping[str, str]] = None,
                 display_name: Optional[Mapping[str, str]] = None):
        """
        Property/Properties which represent a unique ID.
        :param Sequence[str] key_property_names: The properties which make up the unique ID.
        :param str strong_id_name: The Name identifying the strong ID.
        :param Mapping[str, str] description: Localized descriptions.
        :param Mapping[str, str] display_name: Localized display name.
        """
        pulumi.set(__self__, "key_property_names", key_property_names)
        pulumi.set(__self__, "strong_id_name", strong_id_name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)

    @property
    @pulumi.getter(name="keyPropertyNames")
    def key_property_names(self) -> Sequence[str]:
        """
        The properties which make up the unique ID.
        """
        return pulumi.get(self, "key_property_names")

    @property
    @pulumi.getter(name="strongIdName")
    def strong_id_name(self) -> str:
        """
        The Name identifying the strong ID.
        """
        return pulumi.get(self, "strong_id_name")

    @property
    @pulumi.getter
    def description(self) -> Optional[Mapping[str, str]]:
        """
        Localized descriptions.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[Mapping[str, str]]:
        """
        Localized display name.
        """
        return pulumi.get(self, "display_name")


@pulumi.output_type
class TypePropertiesMappingResponse(dict):
    """
    Metadata for a Link's property mapping.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourcePropertyName":
            suggest = "source_property_name"
        elif key == "targetPropertyName":
            suggest = "target_property_name"
        elif key == "linkType":
            suggest = "link_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TypePropertiesMappingResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TypePropertiesMappingResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TypePropertiesMappingResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 source_property_name: str,
                 target_property_name: str,
                 link_type: Optional[str] = None):
        """
        Metadata for a Link's property mapping.
        :param str source_property_name:  Property name on the source Entity Type.
        :param str target_property_name: Property name on the target Entity Type.
        :param str link_type: Link type.
        """
        pulumi.set(__self__, "source_property_name", source_property_name)
        pulumi.set(__self__, "target_property_name", target_property_name)
        if link_type is not None:
            pulumi.set(__self__, "link_type", link_type)

    @property
    @pulumi.getter(name="sourcePropertyName")
    def source_property_name(self) -> str:
        """
         Property name on the source Entity Type.
        """
        return pulumi.get(self, "source_property_name")

    @property
    @pulumi.getter(name="targetPropertyName")
    def target_property_name(self) -> str:
        """
        Property name on the target Entity Type.
        """
        return pulumi.get(self, "target_property_name")

    @property
    @pulumi.getter(name="linkType")
    def link_type(self) -> Optional[str]:
        """
        Link type.
        """
        return pulumi.get(self, "link_type")


