# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetAutomationResult',
    'AwaitableGetAutomationResult',
    'get_automation',
    'get_automation_output',
]

@pulumi.output_type
class GetAutomationResult:
    """
    The security automation resource.
    """
    def __init__(__self__, actions=None, description=None, etag=None, id=None, is_enabled=None, kind=None, location=None, name=None, scopes=None, sources=None, tags=None, type=None):
        if actions and not isinstance(actions, list):
            raise TypeError("Expected argument 'actions' to be a list")
        pulumi.set(__self__, "actions", actions)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if etag and not isinstance(etag, str):
            raise TypeError("Expected argument 'etag' to be a str")
        pulumi.set(__self__, "etag", etag)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_enabled and not isinstance(is_enabled, bool):
            raise TypeError("Expected argument 'is_enabled' to be a bool")
        pulumi.set(__self__, "is_enabled", is_enabled)
        if kind and not isinstance(kind, str):
            raise TypeError("Expected argument 'kind' to be a str")
        pulumi.set(__self__, "kind", kind)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if scopes and not isinstance(scopes, list):
            raise TypeError("Expected argument 'scopes' to be a list")
        pulumi.set(__self__, "scopes", scopes)
        if sources and not isinstance(sources, list):
            raise TypeError("Expected argument 'sources' to be a list")
        pulumi.set(__self__, "sources", sources)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def actions(self) -> Optional[Sequence[Any]]:
        """
        A collection of the actions which are triggered if all the configured rules evaluations, within at least one rule set, are true.
        """
        return pulumi.get(self, "actions")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The security automation description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        Entity tag is used for comparing two or more entities from the same requested resource.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Resource Id
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[bool]:
        """
        Indicates whether the security automation is enabled.
        """
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter
    def kind(self) -> Optional[str]:
        """
        Kind of the resource
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        Location where the resource is stored
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Resource name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def scopes(self) -> Optional[Sequence['outputs.AutomationScopeResponse']]:
        """
        A collection of scopes on which the security automations logic is applied. Supported scopes are the subscription itself or a resource group under that subscription. The automation will only apply on defined scopes.
        """
        return pulumi.get(self, "scopes")

    @property
    @pulumi.getter
    def sources(self) -> Optional[Sequence['outputs.AutomationSourceResponse']]:
        """
        A collection of the source event types which evaluate the security automation set of rules.
        """
        return pulumi.get(self, "sources")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        A list of key value pairs that describe the resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Resource type
        """
        return pulumi.get(self, "type")


class AwaitableGetAutomationResult(GetAutomationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAutomationResult(
            actions=self.actions,
            description=self.description,
            etag=self.etag,
            id=self.id,
            is_enabled=self.is_enabled,
            kind=self.kind,
            location=self.location,
            name=self.name,
            scopes=self.scopes,
            sources=self.sources,
            tags=self.tags,
            type=self.type)


def get_automation(automation_name: Optional[str] = None,
                   resource_group_name: Optional[str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAutomationResult:
    """
    The security automation resource.
    API Version: 2019-01-01-preview.


    :param str automation_name: The security automation name.
    :param str resource_group_name: The name of the resource group within the user's subscription. The name is case insensitive.
    """
    __args__ = dict()
    __args__['automationName'] = automation_name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure-native:security:getAutomation', __args__, opts=opts, typ=GetAutomationResult).value

    return AwaitableGetAutomationResult(
        actions=__ret__.actions,
        description=__ret__.description,
        etag=__ret__.etag,
        id=__ret__.id,
        is_enabled=__ret__.is_enabled,
        kind=__ret__.kind,
        location=__ret__.location,
        name=__ret__.name,
        scopes=__ret__.scopes,
        sources=__ret__.sources,
        tags=__ret__.tags,
        type=__ret__.type)


@_utilities.lift_output_func(get_automation)
def get_automation_output(automation_name: Optional[pulumi.Input[str]] = None,
                          resource_group_name: Optional[pulumi.Input[str]] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetAutomationResult]:
    """
    The security automation resource.
    API Version: 2019-01-01-preview.


    :param str automation_name: The security automation name.
    :param str resource_group_name: The name of the resource group within the user's subscription. The name is case insensitive.
    """
    ...
