# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetDataStoreResult',
    'AwaitableGetDataStoreResult',
    'get_data_store',
    'get_data_store_output',
]

@pulumi.output_type
class GetDataStoreResult:
    """
    Data store.
    """
    def __init__(__self__, customer_secrets=None, data_store_type_id=None, extended_properties=None, id=None, name=None, repository_id=None, state=None, type=None):
        if customer_secrets and not isinstance(customer_secrets, list):
            raise TypeError("Expected argument 'customer_secrets' to be a list")
        pulumi.set(__self__, "customer_secrets", customer_secrets)
        if data_store_type_id and not isinstance(data_store_type_id, str):
            raise TypeError("Expected argument 'data_store_type_id' to be a str")
        pulumi.set(__self__, "data_store_type_id", data_store_type_id)
        if extended_properties and not isinstance(extended_properties, dict):
            raise TypeError("Expected argument 'extended_properties' to be a dict")
        pulumi.set(__self__, "extended_properties", extended_properties)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if repository_id and not isinstance(repository_id, str):
            raise TypeError("Expected argument 'repository_id' to be a str")
        pulumi.set(__self__, "repository_id", repository_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="customerSecrets")
    def customer_secrets(self) -> Optional[Sequence['outputs.CustomerSecretResponse']]:
        """
        List of customer secrets containing a key identifier and key value. The key identifier is a way for the specific data source to understand the key. Value contains customer secret encrypted by the encryptionKeys.
        """
        return pulumi.get(self, "customer_secrets")

    @property
    @pulumi.getter(name="dataStoreTypeId")
    def data_store_type_id(self) -> str:
        """
        The arm id of the data store type.
        """
        return pulumi.get(self, "data_store_type_id")

    @property
    @pulumi.getter(name="extendedProperties")
    def extended_properties(self) -> Optional[Any]:
        """
        A generic json used differently by each data source type.
        """
        return pulumi.get(self, "extended_properties")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Id of the object.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the object.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="repositoryId")
    def repository_id(self) -> Optional[str]:
        """
        Arm Id for the manager resource to which the data source is associated. This is optional.
        """
        return pulumi.get(self, "repository_id")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        State of the data source.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of the object.
        """
        return pulumi.get(self, "type")


class AwaitableGetDataStoreResult(GetDataStoreResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDataStoreResult(
            customer_secrets=self.customer_secrets,
            data_store_type_id=self.data_store_type_id,
            extended_properties=self.extended_properties,
            id=self.id,
            name=self.name,
            repository_id=self.repository_id,
            state=self.state,
            type=self.type)


def get_data_store(data_manager_name: Optional[str] = None,
                   data_store_name: Optional[str] = None,
                   resource_group_name: Optional[str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDataStoreResult:
    """
    Data store.


    :param str data_manager_name: The name of the DataManager Resource within the specified resource group. DataManager names must be between 3 and 24 characters in length and use any alphanumeric and underscore only
    :param str data_store_name: The data store/repository name queried.
    :param str resource_group_name: The Resource Group Name
    """
    __args__ = dict()
    __args__['dataManagerName'] = data_manager_name
    __args__['dataStoreName'] = data_store_name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure-native:hybriddata/v20190601:getDataStore', __args__, opts=opts, typ=GetDataStoreResult).value

    return AwaitableGetDataStoreResult(
        customer_secrets=__ret__.customer_secrets,
        data_store_type_id=__ret__.data_store_type_id,
        extended_properties=__ret__.extended_properties,
        id=__ret__.id,
        name=__ret__.name,
        repository_id=__ret__.repository_id,
        state=__ret__.state,
        type=__ret__.type)


@_utilities.lift_output_func(get_data_store)
def get_data_store_output(data_manager_name: Optional[pulumi.Input[str]] = None,
                          data_store_name: Optional[pulumi.Input[str]] = None,
                          resource_group_name: Optional[pulumi.Input[str]] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetDataStoreResult]:
    """
    Data store.


    :param str data_manager_name: The name of the DataManager Resource within the specified resource group. DataManager names must be between 3 and 24 characters in length and use any alphanumeric and underscore only
    :param str data_store_name: The data store/repository name queried.
    :param str resource_group_name: The Resource Group Name
    """
    ...
