# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetGatewayResult',
    'AwaitableGetGatewayResult',
    'get_gateway',
    'get_gateway_output',
]

@pulumi.output_type
class GetGatewayResult:
    """
    This type describes a gateway resource.
    """
    def __init__(__self__, description=None, destination_network=None, http=None, id=None, ip_address=None, location=None, name=None, provisioning_state=None, source_network=None, status=None, status_details=None, tags=None, tcp=None, type=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if destination_network and not isinstance(destination_network, dict):
            raise TypeError("Expected argument 'destination_network' to be a dict")
        pulumi.set(__self__, "destination_network", destination_network)
        if http and not isinstance(http, list):
            raise TypeError("Expected argument 'http' to be a list")
        pulumi.set(__self__, "http", http)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ip_address and not isinstance(ip_address, str):
            raise TypeError("Expected argument 'ip_address' to be a str")
        pulumi.set(__self__, "ip_address", ip_address)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if provisioning_state and not isinstance(provisioning_state, str):
            raise TypeError("Expected argument 'provisioning_state' to be a str")
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if source_network and not isinstance(source_network, dict):
            raise TypeError("Expected argument 'source_network' to be a dict")
        pulumi.set(__self__, "source_network", source_network)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if status_details and not isinstance(status_details, str):
            raise TypeError("Expected argument 'status_details' to be a str")
        pulumi.set(__self__, "status_details", status_details)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if tcp and not isinstance(tcp, list):
            raise TypeError("Expected argument 'tcp' to be a list")
        pulumi.set(__self__, "tcp", tcp)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        User readable description of the gateway.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="destinationNetwork")
    def destination_network(self) -> 'outputs.NetworkRefResponse':
        """
        Network that the Application is using.
        """
        return pulumi.get(self, "destination_network")

    @property
    @pulumi.getter
    def http(self) -> Optional[Sequence['outputs.HttpConfigResponse']]:
        """
        Configuration for http connectivity for this gateway.
        """
        return pulumi.get(self, "http")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Fully qualified identifier for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> str:
        """
        IP address of the gateway. This is populated in the response and is ignored for incoming requests.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        The geo-location where the resource lives
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        State of the resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="sourceNetwork")
    def source_network(self) -> 'outputs.NetworkRefResponse':
        """
        Network the gateway should listen on for requests.
        """
        return pulumi.get(self, "source_network")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Status of the resource.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="statusDetails")
    def status_details(self) -> str:
        """
        Gives additional information about the current status of the gateway.
        """
        return pulumi.get(self, "status_details")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Resource tags.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def tcp(self) -> Optional[Sequence['outputs.TcpConfigResponse']]:
        """
        Configuration for tcp connectivity for this gateway.
        """
        return pulumi.get(self, "tcp")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
        """
        return pulumi.get(self, "type")


class AwaitableGetGatewayResult(GetGatewayResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetGatewayResult(
            description=self.description,
            destination_network=self.destination_network,
            http=self.http,
            id=self.id,
            ip_address=self.ip_address,
            location=self.location,
            name=self.name,
            provisioning_state=self.provisioning_state,
            source_network=self.source_network,
            status=self.status,
            status_details=self.status_details,
            tags=self.tags,
            tcp=self.tcp,
            type=self.type)


def get_gateway(gateway_resource_name: Optional[str] = None,
                resource_group_name: Optional[str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetGatewayResult:
    """
    This type describes a gateway resource.
    API Version: 2018-09-01-preview.


    :param str gateway_resource_name: The identity of the gateway.
    :param str resource_group_name: Azure resource group name
    """
    __args__ = dict()
    __args__['gatewayResourceName'] = gateway_resource_name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure-native:servicefabricmesh:getGateway', __args__, opts=opts, typ=GetGatewayResult).value

    return AwaitableGetGatewayResult(
        description=__ret__.description,
        destination_network=__ret__.destination_network,
        http=__ret__.http,
        id=__ret__.id,
        ip_address=__ret__.ip_address,
        location=__ret__.location,
        name=__ret__.name,
        provisioning_state=__ret__.provisioning_state,
        source_network=__ret__.source_network,
        status=__ret__.status,
        status_details=__ret__.status_details,
        tags=__ret__.tags,
        tcp=__ret__.tcp,
        type=__ret__.type)


@_utilities.lift_output_func(get_gateway)
def get_gateway_output(gateway_resource_name: Optional[pulumi.Input[str]] = None,
                       resource_group_name: Optional[pulumi.Input[str]] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetGatewayResult]:
    """
    This type describes a gateway resource.
    API Version: 2018-09-01-preview.


    :param str gateway_resource_name: The identity of the gateway.
    :param str resource_group_name: Azure resource group name
    """
    ...
