# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AKSResponse',
    'AKSResponseProperties',
    'BatchAIResponse',
    'BatchAIResponseProperties',
    'DataFactoryResponse',
    'ErrorDetailResponse',
    'ErrorResponseResponse',
    'HDInsightResponse',
    'HDInsightResponseProperties',
    'IdentityResponse',
    'MachineLearningServiceErrorResponse',
    'PasswordResponse',
    'RegistryListCredentialsResultResponse',
    'ScaleSettingsResponse',
    'SslConfigurationResponse',
    'SystemServiceResponse',
    'VirtualMachineResponse',
    'VirtualMachineResponseProperties',
    'VirtualMachineSshCredentialsResponse',
]

@pulumi.output_type
class AKSResponse(dict):
    """
    A Machine Learning compute based on AKS.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "computeType":
            suggest = "compute_type"
        elif key == "createdOn":
            suggest = "created_on"
        elif key == "modifiedOn":
            suggest = "modified_on"
        elif key == "provisioningErrors":
            suggest = "provisioning_errors"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "computeLocation":
            suggest = "compute_location"
        elif key == "resourceId":
            suggest = "resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AKSResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AKSResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AKSResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 compute_type: str,
                 created_on: str,
                 modified_on: str,
                 provisioning_errors: Sequence['outputs.MachineLearningServiceErrorResponse'],
                 provisioning_state: str,
                 compute_location: Optional[str] = None,
                 description: Optional[str] = None,
                 properties: Optional['outputs.AKSResponseProperties'] = None,
                 resource_id: Optional[str] = None):
        """
        A Machine Learning compute based on AKS.
        :param str compute_type: The type of compute
               Expected value is 'AKS'.
        :param str created_on: The date and time when the compute was created.
        :param str modified_on: The date and time when the compute was last modified.
        :param Sequence['MachineLearningServiceErrorResponse'] provisioning_errors: Errors during provisioning
        :param str provisioning_state: The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed.
        :param str compute_location: Location for the underlying compute
        :param str description: The description of the Machine Learning compute.
        :param 'AKSResponseProperties' properties: AKS properties
        :param str resource_id: ARM resource id of the compute
        """
        pulumi.set(__self__, "compute_type", 'AKS')
        pulumi.set(__self__, "created_on", created_on)
        pulumi.set(__self__, "modified_on", modified_on)
        pulumi.set(__self__, "provisioning_errors", provisioning_errors)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if compute_location is not None:
            pulumi.set(__self__, "compute_location", compute_location)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="computeType")
    def compute_type(self) -> str:
        """
        The type of compute
        Expected value is 'AKS'.
        """
        return pulumi.get(self, "compute_type")

    @property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> str:
        """
        The date and time when the compute was created.
        """
        return pulumi.get(self, "created_on")

    @property
    @pulumi.getter(name="modifiedOn")
    def modified_on(self) -> str:
        """
        The date and time when the compute was last modified.
        """
        return pulumi.get(self, "modified_on")

    @property
    @pulumi.getter(name="provisioningErrors")
    def provisioning_errors(self) -> Sequence['outputs.MachineLearningServiceErrorResponse']:
        """
        Errors during provisioning
        """
        return pulumi.get(self, "provisioning_errors")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="computeLocation")
    def compute_location(self) -> Optional[str]:
        """
        Location for the underlying compute
        """
        return pulumi.get(self, "compute_location")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The description of the Machine Learning compute.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def properties(self) -> Optional['outputs.AKSResponseProperties']:
        """
        AKS properties
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[str]:
        """
        ARM resource id of the compute
        """
        return pulumi.get(self, "resource_id")


@pulumi.output_type
class AKSResponseProperties(dict):
    """
    AKS properties
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "agentCount":
            suggest = "agent_count"
        elif key == "agentVMSize":
            suggest = "agent_vm_size"
        elif key == "clusterFqdn":
            suggest = "cluster_fqdn"
        elif key == "sslConfiguration":
            suggest = "ssl_configuration"
        elif key == "systemServices":
            suggest = "system_services"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AKSResponseProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AKSResponseProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AKSResponseProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 agent_count: Optional[int] = None,
                 agent_vm_size: Optional[str] = None,
                 cluster_fqdn: Optional[str] = None,
                 ssl_configuration: Optional['outputs.SslConfigurationResponse'] = None,
                 system_services: Optional[Sequence['outputs.SystemServiceResponse']] = None):
        """
        AKS properties
        :param int agent_count: Number of agents
        :param str agent_vm_size: Agent virtual machine size
        :param str cluster_fqdn: Cluster full qualified domain name
        :param 'SslConfigurationResponse' ssl_configuration: SSL configuration
        :param Sequence['SystemServiceResponse'] system_services: System services
        """
        if agent_count is not None:
            pulumi.set(__self__, "agent_count", agent_count)
        if agent_vm_size is not None:
            pulumi.set(__self__, "agent_vm_size", agent_vm_size)
        if cluster_fqdn is not None:
            pulumi.set(__self__, "cluster_fqdn", cluster_fqdn)
        if ssl_configuration is not None:
            pulumi.set(__self__, "ssl_configuration", ssl_configuration)
        if system_services is not None:
            pulumi.set(__self__, "system_services", system_services)

    @property
    @pulumi.getter(name="agentCount")
    def agent_count(self) -> Optional[int]:
        """
        Number of agents
        """
        return pulumi.get(self, "agent_count")

    @property
    @pulumi.getter(name="agentVMSize")
    def agent_vm_size(self) -> Optional[str]:
        """
        Agent virtual machine size
        """
        return pulumi.get(self, "agent_vm_size")

    @property
    @pulumi.getter(name="clusterFqdn")
    def cluster_fqdn(self) -> Optional[str]:
        """
        Cluster full qualified domain name
        """
        return pulumi.get(self, "cluster_fqdn")

    @property
    @pulumi.getter(name="sslConfiguration")
    def ssl_configuration(self) -> Optional['outputs.SslConfigurationResponse']:
        """
        SSL configuration
        """
        return pulumi.get(self, "ssl_configuration")

    @property
    @pulumi.getter(name="systemServices")
    def system_services(self) -> Optional[Sequence['outputs.SystemServiceResponse']]:
        """
        System services
        """
        return pulumi.get(self, "system_services")


@pulumi.output_type
class BatchAIResponse(dict):
    """
    A Machine Learning compute based on Azure BatchAI.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "computeType":
            suggest = "compute_type"
        elif key == "createdOn":
            suggest = "created_on"
        elif key == "modifiedOn":
            suggest = "modified_on"
        elif key == "provisioningErrors":
            suggest = "provisioning_errors"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "computeLocation":
            suggest = "compute_location"
        elif key == "resourceId":
            suggest = "resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BatchAIResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BatchAIResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BatchAIResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 compute_type: str,
                 created_on: str,
                 modified_on: str,
                 provisioning_errors: Sequence['outputs.MachineLearningServiceErrorResponse'],
                 provisioning_state: str,
                 compute_location: Optional[str] = None,
                 description: Optional[str] = None,
                 properties: Optional['outputs.BatchAIResponseProperties'] = None,
                 resource_id: Optional[str] = None):
        """
        A Machine Learning compute based on Azure BatchAI.
        :param str compute_type: The type of compute
               Expected value is 'BatchAI'.
        :param str created_on: The date and time when the compute was created.
        :param str modified_on: The date and time when the compute was last modified.
        :param Sequence['MachineLearningServiceErrorResponse'] provisioning_errors: Errors during provisioning
        :param str provisioning_state: The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed.
        :param str compute_location: Location for the underlying compute
        :param str description: The description of the Machine Learning compute.
        :param 'BatchAIResponseProperties' properties: BatchAI properties
        :param str resource_id: ARM resource id of the compute
        """
        pulumi.set(__self__, "compute_type", 'BatchAI')
        pulumi.set(__self__, "created_on", created_on)
        pulumi.set(__self__, "modified_on", modified_on)
        pulumi.set(__self__, "provisioning_errors", provisioning_errors)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if compute_location is not None:
            pulumi.set(__self__, "compute_location", compute_location)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="computeType")
    def compute_type(self) -> str:
        """
        The type of compute
        Expected value is 'BatchAI'.
        """
        return pulumi.get(self, "compute_type")

    @property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> str:
        """
        The date and time when the compute was created.
        """
        return pulumi.get(self, "created_on")

    @property
    @pulumi.getter(name="modifiedOn")
    def modified_on(self) -> str:
        """
        The date and time when the compute was last modified.
        """
        return pulumi.get(self, "modified_on")

    @property
    @pulumi.getter(name="provisioningErrors")
    def provisioning_errors(self) -> Sequence['outputs.MachineLearningServiceErrorResponse']:
        """
        Errors during provisioning
        """
        return pulumi.get(self, "provisioning_errors")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="computeLocation")
    def compute_location(self) -> Optional[str]:
        """
        Location for the underlying compute
        """
        return pulumi.get(self, "compute_location")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The description of the Machine Learning compute.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def properties(self) -> Optional['outputs.BatchAIResponseProperties']:
        """
        BatchAI properties
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[str]:
        """
        ARM resource id of the compute
        """
        return pulumi.get(self, "resource_id")


@pulumi.output_type
class BatchAIResponseProperties(dict):
    """
    BatchAI properties
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "scaleSettings":
            suggest = "scale_settings"
        elif key == "vmPriority":
            suggest = "vm_priority"
        elif key == "vmSize":
            suggest = "vm_size"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BatchAIResponseProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BatchAIResponseProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BatchAIResponseProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 scale_settings: Optional['outputs.ScaleSettingsResponse'] = None,
                 vm_priority: Optional[str] = None,
                 vm_size: Optional[str] = None):
        """
        BatchAI properties
        :param 'ScaleSettingsResponse' scale_settings: Scale settings for BatchAI
        :param str vm_priority: Virtual Machine priority
        :param str vm_size: Virtual Machine Size
        """
        if scale_settings is not None:
            pulumi.set(__self__, "scale_settings", scale_settings)
        if vm_priority is not None:
            pulumi.set(__self__, "vm_priority", vm_priority)
        if vm_size is not None:
            pulumi.set(__self__, "vm_size", vm_size)

    @property
    @pulumi.getter(name="scaleSettings")
    def scale_settings(self) -> Optional['outputs.ScaleSettingsResponse']:
        """
        Scale settings for BatchAI
        """
        return pulumi.get(self, "scale_settings")

    @property
    @pulumi.getter(name="vmPriority")
    def vm_priority(self) -> Optional[str]:
        """
        Virtual Machine priority
        """
        return pulumi.get(self, "vm_priority")

    @property
    @pulumi.getter(name="vmSize")
    def vm_size(self) -> Optional[str]:
        """
        Virtual Machine Size
        """
        return pulumi.get(self, "vm_size")


@pulumi.output_type
class DataFactoryResponse(dict):
    """
    A DataFactory compute.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "computeType":
            suggest = "compute_type"
        elif key == "createdOn":
            suggest = "created_on"
        elif key == "modifiedOn":
            suggest = "modified_on"
        elif key == "provisioningErrors":
            suggest = "provisioning_errors"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "computeLocation":
            suggest = "compute_location"
        elif key == "resourceId":
            suggest = "resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataFactoryResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataFactoryResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataFactoryResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 compute_type: str,
                 created_on: str,
                 modified_on: str,
                 provisioning_errors: Sequence['outputs.MachineLearningServiceErrorResponse'],
                 provisioning_state: str,
                 compute_location: Optional[str] = None,
                 description: Optional[str] = None,
                 resource_id: Optional[str] = None):
        """
        A DataFactory compute.
        :param str compute_type: The type of compute
               Expected value is 'DataFactory'.
        :param str created_on: The date and time when the compute was created.
        :param str modified_on: The date and time when the compute was last modified.
        :param Sequence['MachineLearningServiceErrorResponse'] provisioning_errors: Errors during provisioning
        :param str provisioning_state: The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed.
        :param str compute_location: Location for the underlying compute
        :param str description: The description of the Machine Learning compute.
        :param str resource_id: ARM resource id of the compute
        """
        pulumi.set(__self__, "compute_type", 'DataFactory')
        pulumi.set(__self__, "created_on", created_on)
        pulumi.set(__self__, "modified_on", modified_on)
        pulumi.set(__self__, "provisioning_errors", provisioning_errors)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if compute_location is not None:
            pulumi.set(__self__, "compute_location", compute_location)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="computeType")
    def compute_type(self) -> str:
        """
        The type of compute
        Expected value is 'DataFactory'.
        """
        return pulumi.get(self, "compute_type")

    @property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> str:
        """
        The date and time when the compute was created.
        """
        return pulumi.get(self, "created_on")

    @property
    @pulumi.getter(name="modifiedOn")
    def modified_on(self) -> str:
        """
        The date and time when the compute was last modified.
        """
        return pulumi.get(self, "modified_on")

    @property
    @pulumi.getter(name="provisioningErrors")
    def provisioning_errors(self) -> Sequence['outputs.MachineLearningServiceErrorResponse']:
        """
        Errors during provisioning
        """
        return pulumi.get(self, "provisioning_errors")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="computeLocation")
    def compute_location(self) -> Optional[str]:
        """
        Location for the underlying compute
        """
        return pulumi.get(self, "compute_location")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The description of the Machine Learning compute.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[str]:
        """
        ARM resource id of the compute
        """
        return pulumi.get(self, "resource_id")


@pulumi.output_type
class ErrorDetailResponse(dict):
    """
    Error detail information.
    """
    def __init__(__self__, *,
                 code: str,
                 message: str):
        """
        Error detail information.
        :param str code: Error code.
        :param str message: Error message.
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "message", message)

    @property
    @pulumi.getter
    def code(self) -> str:
        """
        Error code.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        Error message.
        """
        return pulumi.get(self, "message")


@pulumi.output_type
class ErrorResponseResponse(dict):
    """
    Error response information.
    """
    def __init__(__self__, *,
                 code: str,
                 message: str,
                 details: Optional[Sequence['outputs.ErrorDetailResponse']] = None):
        """
        Error response information.
        :param str code: Error code.
        :param str message: Error message.
        :param Sequence['ErrorDetailResponse'] details: An array of error detail objects.
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "message", message)
        if details is not None:
            pulumi.set(__self__, "details", details)

    @property
    @pulumi.getter
    def code(self) -> str:
        """
        Error code.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        Error message.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def details(self) -> Optional[Sequence['outputs.ErrorDetailResponse']]:
        """
        An array of error detail objects.
        """
        return pulumi.get(self, "details")


@pulumi.output_type
class HDInsightResponse(dict):
    """
    A HDInsight compute.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "computeType":
            suggest = "compute_type"
        elif key == "createdOn":
            suggest = "created_on"
        elif key == "modifiedOn":
            suggest = "modified_on"
        elif key == "provisioningErrors":
            suggest = "provisioning_errors"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "computeLocation":
            suggest = "compute_location"
        elif key == "resourceId":
            suggest = "resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HDInsightResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HDInsightResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HDInsightResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 compute_type: str,
                 created_on: str,
                 modified_on: str,
                 provisioning_errors: Sequence['outputs.MachineLearningServiceErrorResponse'],
                 provisioning_state: str,
                 compute_location: Optional[str] = None,
                 description: Optional[str] = None,
                 properties: Optional['outputs.HDInsightResponseProperties'] = None,
                 resource_id: Optional[str] = None):
        """
        A HDInsight compute.
        :param str compute_type: The type of compute
               Expected value is 'HDInsight'.
        :param str created_on: The date and time when the compute was created.
        :param str modified_on: The date and time when the compute was last modified.
        :param Sequence['MachineLearningServiceErrorResponse'] provisioning_errors: Errors during provisioning
        :param str provisioning_state: The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed.
        :param str compute_location: Location for the underlying compute
        :param str description: The description of the Machine Learning compute.
        :param str resource_id: ARM resource id of the compute
        """
        pulumi.set(__self__, "compute_type", 'HDInsight')
        pulumi.set(__self__, "created_on", created_on)
        pulumi.set(__self__, "modified_on", modified_on)
        pulumi.set(__self__, "provisioning_errors", provisioning_errors)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if compute_location is not None:
            pulumi.set(__self__, "compute_location", compute_location)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="computeType")
    def compute_type(self) -> str:
        """
        The type of compute
        Expected value is 'HDInsight'.
        """
        return pulumi.get(self, "compute_type")

    @property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> str:
        """
        The date and time when the compute was created.
        """
        return pulumi.get(self, "created_on")

    @property
    @pulumi.getter(name="modifiedOn")
    def modified_on(self) -> str:
        """
        The date and time when the compute was last modified.
        """
        return pulumi.get(self, "modified_on")

    @property
    @pulumi.getter(name="provisioningErrors")
    def provisioning_errors(self) -> Sequence['outputs.MachineLearningServiceErrorResponse']:
        """
        Errors during provisioning
        """
        return pulumi.get(self, "provisioning_errors")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="computeLocation")
    def compute_location(self) -> Optional[str]:
        """
        Location for the underlying compute
        """
        return pulumi.get(self, "compute_location")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The description of the Machine Learning compute.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def properties(self) -> Optional['outputs.HDInsightResponseProperties']:
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[str]:
        """
        ARM resource id of the compute
        """
        return pulumi.get(self, "resource_id")


@pulumi.output_type
class HDInsightResponseProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "administratorAccount":
            suggest = "administrator_account"
        elif key == "sshPort":
            suggest = "ssh_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HDInsightResponseProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HDInsightResponseProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HDInsightResponseProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address: Optional[str] = None,
                 administrator_account: Optional['outputs.VirtualMachineSshCredentialsResponse'] = None,
                 ssh_port: Optional[int] = None):
        """
        :param str address: Public IP address of the master node of the cluster.
        :param 'VirtualMachineSshCredentialsResponse' administrator_account: Admin credentials for master node of the cluster
        :param int ssh_port: Port open for ssh connections on the master node of the cluster.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if administrator_account is not None:
            pulumi.set(__self__, "administrator_account", administrator_account)
        if ssh_port is not None:
            pulumi.set(__self__, "ssh_port", ssh_port)

    @property
    @pulumi.getter
    def address(self) -> Optional[str]:
        """
        Public IP address of the master node of the cluster.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter(name="administratorAccount")
    def administrator_account(self) -> Optional['outputs.VirtualMachineSshCredentialsResponse']:
        """
        Admin credentials for master node of the cluster
        """
        return pulumi.get(self, "administrator_account")

    @property
    @pulumi.getter(name="sshPort")
    def ssh_port(self) -> Optional[int]:
        """
        Port open for ssh connections on the master node of the cluster.
        """
        return pulumi.get(self, "ssh_port")


@pulumi.output_type
class IdentityResponse(dict):
    """
    Identity for the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IdentityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IdentityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IdentityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 principal_id: str,
                 tenant_id: str,
                 type: Optional[str] = None):
        """
        Identity for the resource.
        :param str principal_id: The principal ID of resource identity.
        :param str tenant_id: The tenant ID of resource.
        :param str type: The identity type.
        """
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> str:
        """
        The principal ID of resource identity.
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> str:
        """
        The tenant ID of resource.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The identity type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class MachineLearningServiceErrorResponse(dict):
    """
    Wrapper for error response to follow ARM guidelines.
    """
    def __init__(__self__, *,
                 error: Optional['outputs.ErrorResponseResponse'] = None):
        """
        Wrapper for error response to follow ARM guidelines.
        :param 'ErrorResponseResponse' error: The error response.
        """
        if error is not None:
            pulumi.set(__self__, "error", error)

    @property
    @pulumi.getter
    def error(self) -> Optional['outputs.ErrorResponseResponse']:
        """
        The error response.
        """
        return pulumi.get(self, "error")


@pulumi.output_type
class PasswordResponse(dict):
    def __init__(__self__, *,
                 name: str,
                 value: str):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        return pulumi.get(self, "value")


@pulumi.output_type
class RegistryListCredentialsResultResponse(dict):
    def __init__(__self__, *,
                 location: str,
                 username: str,
                 passwords: Optional[Sequence['outputs.PasswordResponse']] = None):
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "username", username)
        if passwords is not None:
            pulumi.set(__self__, "passwords", passwords)

    @property
    @pulumi.getter
    def location(self) -> str:
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def username(self) -> str:
        return pulumi.get(self, "username")

    @property
    @pulumi.getter
    def passwords(self) -> Optional[Sequence['outputs.PasswordResponse']]:
        return pulumi.get(self, "passwords")


@pulumi.output_type
class ScaleSettingsResponse(dict):
    """
    scale settings for BatchAI Compute
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autoScaleEnabled":
            suggest = "auto_scale_enabled"
        elif key == "maxNodeCount":
            suggest = "max_node_count"
        elif key == "minNodeCount":
            suggest = "min_node_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScaleSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScaleSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScaleSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auto_scale_enabled: Optional[bool] = None,
                 max_node_count: Optional[int] = None,
                 min_node_count: Optional[int] = None):
        """
        scale settings for BatchAI Compute
        :param bool auto_scale_enabled: Enable or disable auto scale
        :param int max_node_count: Max number of nodes to use
        :param int min_node_count: Min number of nodes to use
        """
        if auto_scale_enabled is not None:
            pulumi.set(__self__, "auto_scale_enabled", auto_scale_enabled)
        if max_node_count is not None:
            pulumi.set(__self__, "max_node_count", max_node_count)
        if min_node_count is not None:
            pulumi.set(__self__, "min_node_count", min_node_count)

    @property
    @pulumi.getter(name="autoScaleEnabled")
    def auto_scale_enabled(self) -> Optional[bool]:
        """
        Enable or disable auto scale
        """
        return pulumi.get(self, "auto_scale_enabled")

    @property
    @pulumi.getter(name="maxNodeCount")
    def max_node_count(self) -> Optional[int]:
        """
        Max number of nodes to use
        """
        return pulumi.get(self, "max_node_count")

    @property
    @pulumi.getter(name="minNodeCount")
    def min_node_count(self) -> Optional[int]:
        """
        Min number of nodes to use
        """
        return pulumi.get(self, "min_node_count")


@pulumi.output_type
class SslConfigurationResponse(dict):
    """
    The SSL configuration for scoring
    """
    def __init__(__self__, *,
                 cert: Optional[str] = None,
                 cname: Optional[str] = None,
                 key: Optional[str] = None,
                 status: Optional[str] = None):
        """
        The SSL configuration for scoring
        :param str cert: Cert data
        :param str cname: CNAME of the cert
        :param str key: Key data
        :param str status: Enable or disable SSL for scoring
        """
        if cert is not None:
            pulumi.set(__self__, "cert", cert)
        if cname is not None:
            pulumi.set(__self__, "cname", cname)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def cert(self) -> Optional[str]:
        """
        Cert data
        """
        return pulumi.get(self, "cert")

    @property
    @pulumi.getter
    def cname(self) -> Optional[str]:
        """
        CNAME of the cert
        """
        return pulumi.get(self, "cname")

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        """
        Key data
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        Enable or disable SSL for scoring
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class SystemServiceResponse(dict):
    """
    A system service running on a compute.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "publicIpAddress":
            suggest = "public_ip_address"
        elif key == "systemServiceType":
            suggest = "system_service_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SystemServiceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SystemServiceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SystemServiceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 public_ip_address: str,
                 system_service_type: str,
                 version: str):
        """
        A system service running on a compute.
        :param str public_ip_address: Public IP address
        :param str system_service_type: The type of this system service.
        :param str version: The version for this type.
        """
        pulumi.set(__self__, "public_ip_address", public_ip_address)
        pulumi.set(__self__, "system_service_type", system_service_type)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="publicIpAddress")
    def public_ip_address(self) -> str:
        """
        Public IP address
        """
        return pulumi.get(self, "public_ip_address")

    @property
    @pulumi.getter(name="systemServiceType")
    def system_service_type(self) -> str:
        """
        The type of this system service.
        """
        return pulumi.get(self, "system_service_type")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        The version for this type.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class VirtualMachineResponse(dict):
    """
    A Machine Learning compute based on Azure Virtual Machines.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "computeType":
            suggest = "compute_type"
        elif key == "createdOn":
            suggest = "created_on"
        elif key == "modifiedOn":
            suggest = "modified_on"
        elif key == "provisioningErrors":
            suggest = "provisioning_errors"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "computeLocation":
            suggest = "compute_location"
        elif key == "resourceId":
            suggest = "resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 compute_type: str,
                 created_on: str,
                 modified_on: str,
                 provisioning_errors: Sequence['outputs.MachineLearningServiceErrorResponse'],
                 provisioning_state: str,
                 compute_location: Optional[str] = None,
                 description: Optional[str] = None,
                 properties: Optional['outputs.VirtualMachineResponseProperties'] = None,
                 resource_id: Optional[str] = None):
        """
        A Machine Learning compute based on Azure Virtual Machines.
        :param str compute_type: The type of compute
               Expected value is 'VirtualMachine'.
        :param str created_on: The date and time when the compute was created.
        :param str modified_on: The date and time when the compute was last modified.
        :param Sequence['MachineLearningServiceErrorResponse'] provisioning_errors: Errors during provisioning
        :param str provisioning_state: The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed.
        :param str compute_location: Location for the underlying compute
        :param str description: The description of the Machine Learning compute.
        :param str resource_id: ARM resource id of the compute
        """
        pulumi.set(__self__, "compute_type", 'VirtualMachine')
        pulumi.set(__self__, "created_on", created_on)
        pulumi.set(__self__, "modified_on", modified_on)
        pulumi.set(__self__, "provisioning_errors", provisioning_errors)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if compute_location is not None:
            pulumi.set(__self__, "compute_location", compute_location)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="computeType")
    def compute_type(self) -> str:
        """
        The type of compute
        Expected value is 'VirtualMachine'.
        """
        return pulumi.get(self, "compute_type")

    @property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> str:
        """
        The date and time when the compute was created.
        """
        return pulumi.get(self, "created_on")

    @property
    @pulumi.getter(name="modifiedOn")
    def modified_on(self) -> str:
        """
        The date and time when the compute was last modified.
        """
        return pulumi.get(self, "modified_on")

    @property
    @pulumi.getter(name="provisioningErrors")
    def provisioning_errors(self) -> Sequence['outputs.MachineLearningServiceErrorResponse']:
        """
        Errors during provisioning
        """
        return pulumi.get(self, "provisioning_errors")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="computeLocation")
    def compute_location(self) -> Optional[str]:
        """
        Location for the underlying compute
        """
        return pulumi.get(self, "compute_location")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The description of the Machine Learning compute.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def properties(self) -> Optional['outputs.VirtualMachineResponseProperties']:
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[str]:
        """
        ARM resource id of the compute
        """
        return pulumi.get(self, "resource_id")


@pulumi.output_type
class VirtualMachineResponseProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "administratorAccount":
            suggest = "administrator_account"
        elif key == "sshPort":
            suggest = "ssh_port"
        elif key == "virtualMachineSize":
            suggest = "virtual_machine_size"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineResponseProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineResponseProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineResponseProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address: Optional[str] = None,
                 administrator_account: Optional['outputs.VirtualMachineSshCredentialsResponse'] = None,
                 ssh_port: Optional[int] = None,
                 virtual_machine_size: Optional[str] = None):
        """
        :param str address: Public IP address of the virtual machine.
        :param 'VirtualMachineSshCredentialsResponse' administrator_account: Admin credentials for virtual machine
        :param int ssh_port: Port open for ssh connections.
        :param str virtual_machine_size: Virtual Machine size
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if administrator_account is not None:
            pulumi.set(__self__, "administrator_account", administrator_account)
        if ssh_port is not None:
            pulumi.set(__self__, "ssh_port", ssh_port)
        if virtual_machine_size is not None:
            pulumi.set(__self__, "virtual_machine_size", virtual_machine_size)

    @property
    @pulumi.getter
    def address(self) -> Optional[str]:
        """
        Public IP address of the virtual machine.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter(name="administratorAccount")
    def administrator_account(self) -> Optional['outputs.VirtualMachineSshCredentialsResponse']:
        """
        Admin credentials for virtual machine
        """
        return pulumi.get(self, "administrator_account")

    @property
    @pulumi.getter(name="sshPort")
    def ssh_port(self) -> Optional[int]:
        """
        Port open for ssh connections.
        """
        return pulumi.get(self, "ssh_port")

    @property
    @pulumi.getter(name="virtualMachineSize")
    def virtual_machine_size(self) -> Optional[str]:
        """
        Virtual Machine size
        """
        return pulumi.get(self, "virtual_machine_size")


@pulumi.output_type
class VirtualMachineSshCredentialsResponse(dict):
    """
    Admin credentials for virtual machine
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "privateKeyData":
            suggest = "private_key_data"
        elif key == "publicKeyData":
            suggest = "public_key_data"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineSshCredentialsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineSshCredentialsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineSshCredentialsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 password: Optional[str] = None,
                 private_key_data: Optional[str] = None,
                 public_key_data: Optional[str] = None,
                 username: Optional[str] = None):
        """
        Admin credentials for virtual machine
        :param str password: Password of admin account
        :param str private_key_data: Private key data
        :param str public_key_data: Public key data
        :param str username: Username of admin account
        """
        if password is not None:
            pulumi.set(__self__, "password", password)
        if private_key_data is not None:
            pulumi.set(__self__, "private_key_data", private_key_data)
        if public_key_data is not None:
            pulumi.set(__self__, "public_key_data", public_key_data)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def password(self) -> Optional[str]:
        """
        Password of admin account
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="privateKeyData")
    def private_key_data(self) -> Optional[str]:
        """
        Private key data
        """
        return pulumi.get(self, "private_key_data")

    @property
    @pulumi.getter(name="publicKeyData")
    def public_key_data(self) -> Optional[str]:
        """
        Public key data
        """
        return pulumi.get(self, "public_key_data")

    @property
    @pulumi.getter
    def username(self) -> Optional[str]:
        """
        Username of admin account
        """
        return pulumi.get(self, "username")


