# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetExtensionResult',
    'AwaitableGetExtensionResult',
    'get_extension',
    'get_extension_output',
]

@pulumi.output_type
class GetExtensionResult:
    """
    The Extension Instance object.
    """
    def __init__(__self__, auto_upgrade_minor_version=None, configuration_protected_settings=None, configuration_settings=None, creation_time=None, error_info=None, extension_type=None, id=None, identity=None, install_state=None, last_modified_time=None, last_status_time=None, name=None, release_train=None, scope=None, statuses=None, system_data=None, type=None, version=None):
        if auto_upgrade_minor_version and not isinstance(auto_upgrade_minor_version, bool):
            raise TypeError("Expected argument 'auto_upgrade_minor_version' to be a bool")
        pulumi.set(__self__, "auto_upgrade_minor_version", auto_upgrade_minor_version)
        if configuration_protected_settings and not isinstance(configuration_protected_settings, dict):
            raise TypeError("Expected argument 'configuration_protected_settings' to be a dict")
        pulumi.set(__self__, "configuration_protected_settings", configuration_protected_settings)
        if configuration_settings and not isinstance(configuration_settings, dict):
            raise TypeError("Expected argument 'configuration_settings' to be a dict")
        pulumi.set(__self__, "configuration_settings", configuration_settings)
        if creation_time and not isinstance(creation_time, str):
            raise TypeError("Expected argument 'creation_time' to be a str")
        pulumi.set(__self__, "creation_time", creation_time)
        if error_info and not isinstance(error_info, dict):
            raise TypeError("Expected argument 'error_info' to be a dict")
        pulumi.set(__self__, "error_info", error_info)
        if extension_type and not isinstance(extension_type, str):
            raise TypeError("Expected argument 'extension_type' to be a str")
        pulumi.set(__self__, "extension_type", extension_type)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if identity and not isinstance(identity, dict):
            raise TypeError("Expected argument 'identity' to be a dict")
        pulumi.set(__self__, "identity", identity)
        if install_state and not isinstance(install_state, str):
            raise TypeError("Expected argument 'install_state' to be a str")
        pulumi.set(__self__, "install_state", install_state)
        if last_modified_time and not isinstance(last_modified_time, str):
            raise TypeError("Expected argument 'last_modified_time' to be a str")
        pulumi.set(__self__, "last_modified_time", last_modified_time)
        if last_status_time and not isinstance(last_status_time, str):
            raise TypeError("Expected argument 'last_status_time' to be a str")
        pulumi.set(__self__, "last_status_time", last_status_time)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if release_train and not isinstance(release_train, str):
            raise TypeError("Expected argument 'release_train' to be a str")
        pulumi.set(__self__, "release_train", release_train)
        if scope and not isinstance(scope, dict):
            raise TypeError("Expected argument 'scope' to be a dict")
        pulumi.set(__self__, "scope", scope)
        if statuses and not isinstance(statuses, list):
            raise TypeError("Expected argument 'statuses' to be a list")
        pulumi.set(__self__, "statuses", statuses)
        if system_data and not isinstance(system_data, dict):
            raise TypeError("Expected argument 'system_data' to be a dict")
        pulumi.set(__self__, "system_data", system_data)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if version and not isinstance(version, str):
            raise TypeError("Expected argument 'version' to be a str")
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="autoUpgradeMinorVersion")
    def auto_upgrade_minor_version(self) -> Optional[bool]:
        """
        Flag to note if this instance participates in auto upgrade of minor version, or not.
        """
        return pulumi.get(self, "auto_upgrade_minor_version")

    @property
    @pulumi.getter(name="configurationProtectedSettings")
    def configuration_protected_settings(self) -> Optional[Mapping[str, str]]:
        """
        Configuration settings that are sensitive, as name-value pairs for configuring this instance of the extension.
        """
        return pulumi.get(self, "configuration_protected_settings")

    @property
    @pulumi.getter(name="configurationSettings")
    def configuration_settings(self) -> Optional[Mapping[str, str]]:
        """
        Configuration settings, as name-value pairs for configuring this instance of the extension.
        """
        return pulumi.get(self, "configuration_settings")

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> str:
        """
        DateLiteral (per ISO8601) noting the time the resource was created by the client (user).
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter(name="errorInfo")
    def error_info(self) -> 'outputs.ErrorDefinitionResponse':
        """
        Error information from the Agent - e.g. errors during installation.
        """
        return pulumi.get(self, "error_info")

    @property
    @pulumi.getter(name="extensionType")
    def extension_type(self) -> Optional[str]:
        """
        Type of the Extension, of which this resource is an instance of.  It must be one of the Extension Types registered with Microsoft.KubernetesConfiguration by the Extension publisher.
        """
        return pulumi.get(self, "extension_type")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Resource Id
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def identity(self) -> Optional['outputs.ConfigurationIdentityResponse']:
        """
        The identity of the configuration.
        """
        return pulumi.get(self, "identity")

    @property
    @pulumi.getter(name="installState")
    def install_state(self) -> str:
        """
        Status of installation of this instance of the extension.
        """
        return pulumi.get(self, "install_state")

    @property
    @pulumi.getter(name="lastModifiedTime")
    def last_modified_time(self) -> str:
        """
        DateLiteral (per ISO8601) noting the time the resource was modified by the client (user).
        """
        return pulumi.get(self, "last_modified_time")

    @property
    @pulumi.getter(name="lastStatusTime")
    def last_status_time(self) -> str:
        """
        DateLiteral (per ISO8601) noting the time of last status from the agent.
        """
        return pulumi.get(self, "last_status_time")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Resource name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="releaseTrain")
    def release_train(self) -> Optional[str]:
        """
        ReleaseTrain this extension instance participates in for auto-upgrade (e.g. Stable, Preview, etc.) - only if autoUpgradeMinorVersion is 'true'.
        """
        return pulumi.get(self, "release_train")

    @property
    @pulumi.getter
    def scope(self) -> Optional['outputs.ScopeResponse']:
        """
        Scope at which the extension instance is installed.
        """
        return pulumi.get(self, "scope")

    @property
    @pulumi.getter
    def statuses(self) -> Optional[Sequence['outputs.ExtensionStatusResponse']]:
        """
        Status from this instance of the extension.
        """
        return pulumi.get(self, "statuses")

    @property
    @pulumi.getter(name="systemData")
    def system_data(self) -> Optional['outputs.SystemDataResponse']:
        """
        Top level metadata https://github.com/Azure/azure-resource-manager-rpc/blob/master/v1.0/common-api-contracts.md#system-metadata-for-all-azure-resources
        """
        return pulumi.get(self, "system_data")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Resource type
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def version(self) -> Optional[str]:
        """
        Version of the extension for this extension instance, if it is 'pinned' to a specific version. autoUpgradeMinorVersion must be 'false'.
        """
        return pulumi.get(self, "version")


class AwaitableGetExtensionResult(GetExtensionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetExtensionResult(
            auto_upgrade_minor_version=self.auto_upgrade_minor_version,
            configuration_protected_settings=self.configuration_protected_settings,
            configuration_settings=self.configuration_settings,
            creation_time=self.creation_time,
            error_info=self.error_info,
            extension_type=self.extension_type,
            id=self.id,
            identity=self.identity,
            install_state=self.install_state,
            last_modified_time=self.last_modified_time,
            last_status_time=self.last_status_time,
            name=self.name,
            release_train=self.release_train,
            scope=self.scope,
            statuses=self.statuses,
            system_data=self.system_data,
            type=self.type,
            version=self.version)


def get_extension(cluster_name: Optional[str] = None,
                  cluster_resource_name: Optional[str] = None,
                  cluster_rp: Optional[str] = None,
                  extension_instance_name: Optional[str] = None,
                  resource_group_name: Optional[str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetExtensionResult:
    """
    The Extension Instance object.


    :param str cluster_name: The name of the kubernetes cluster.
    :param str cluster_resource_name: The Kubernetes cluster resource name - either managedClusters (for AKS clusters) or connectedClusters (for OnPrem K8S clusters).
    :param str cluster_rp: The Kubernetes cluster RP - either Microsoft.ContainerService (for AKS clusters) or Microsoft.Kubernetes (for OnPrem K8S clusters).
    :param str extension_instance_name: Name of an instance of the Extension.
    :param str resource_group_name: The name of the resource group.
    """
    __args__ = dict()
    __args__['clusterName'] = cluster_name
    __args__['clusterResourceName'] = cluster_resource_name
    __args__['clusterRp'] = cluster_rp
    __args__['extensionInstanceName'] = extension_instance_name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure-native:kubernetesconfiguration/v20200701preview:getExtension', __args__, opts=opts, typ=GetExtensionResult).value

    return AwaitableGetExtensionResult(
        auto_upgrade_minor_version=__ret__.auto_upgrade_minor_version,
        configuration_protected_settings=__ret__.configuration_protected_settings,
        configuration_settings=__ret__.configuration_settings,
        creation_time=__ret__.creation_time,
        error_info=__ret__.error_info,
        extension_type=__ret__.extension_type,
        id=__ret__.id,
        identity=__ret__.identity,
        install_state=__ret__.install_state,
        last_modified_time=__ret__.last_modified_time,
        last_status_time=__ret__.last_status_time,
        name=__ret__.name,
        release_train=__ret__.release_train,
        scope=__ret__.scope,
        statuses=__ret__.statuses,
        system_data=__ret__.system_data,
        type=__ret__.type,
        version=__ret__.version)


@_utilities.lift_output_func(get_extension)
def get_extension_output(cluster_name: Optional[pulumi.Input[str]] = None,
                         cluster_resource_name: Optional[pulumi.Input[str]] = None,
                         cluster_rp: Optional[pulumi.Input[str]] = None,
                         extension_instance_name: Optional[pulumi.Input[str]] = None,
                         resource_group_name: Optional[pulumi.Input[str]] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetExtensionResult]:
    """
    The Extension Instance object.


    :param str cluster_name: The name of the kubernetes cluster.
    :param str cluster_resource_name: The Kubernetes cluster resource name - either managedClusters (for AKS clusters) or connectedClusters (for OnPrem K8S clusters).
    :param str cluster_rp: The Kubernetes cluster RP - either Microsoft.ContainerService (for AKS clusters) or Microsoft.Kubernetes (for OnPrem K8S clusters).
    :param str extension_instance_name: Name of an instance of the Extension.
    :param str resource_group_name: The name of the resource group.
    """
    ...
