# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'CertificatePropertiesResponse',
    'CloudToDevicePropertiesResponse',
    'EventHubPropertiesResponse',
    'FallbackRoutePropertiesResponse',
    'FeedbackPropertiesResponse',
    'IotHubLocationDescriptionResponse',
    'IotHubPropertiesResponse',
    'IotHubPropertiesResponseDeviceStreams',
    'IotHubSkuInfoResponse',
    'IpFilterRuleResponse',
    'MessagingEndpointPropertiesResponse',
    'RoutePropertiesResponse',
    'RoutingEndpointsResponse',
    'RoutingEventHubPropertiesResponse',
    'RoutingPropertiesResponse',
    'RoutingServiceBusQueueEndpointPropertiesResponse',
    'RoutingServiceBusTopicEndpointPropertiesResponse',
    'RoutingStorageContainerPropertiesResponse',
    'SharedAccessSignatureAuthorizationRuleResponse',
    'StorageEndpointPropertiesResponse',
]

@pulumi.output_type
class CertificatePropertiesResponse(dict):
    """
    The description of an X509 CA Certificate.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isVerified":
            suggest = "is_verified"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificatePropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificatePropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificatePropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created: str,
                 expiry: str,
                 is_verified: bool,
                 subject: str,
                 thumbprint: str,
                 updated: str,
                 certificate: Optional[str] = None):
        """
        The description of an X509 CA Certificate.
        :param str created: The certificate's create date and time.
        :param str expiry: The certificate's expiration date and time.
        :param bool is_verified: Determines whether certificate has been verified.
        :param str subject: The certificate's subject name.
        :param str thumbprint: The certificate's thumbprint.
        :param str updated: The certificate's last update date and time.
        :param str certificate: The certificate content
        """
        pulumi.set(__self__, "created", created)
        pulumi.set(__self__, "expiry", expiry)
        pulumi.set(__self__, "is_verified", is_verified)
        pulumi.set(__self__, "subject", subject)
        pulumi.set(__self__, "thumbprint", thumbprint)
        pulumi.set(__self__, "updated", updated)
        if certificate is not None:
            pulumi.set(__self__, "certificate", certificate)

    @property
    @pulumi.getter
    def created(self) -> str:
        """
        The certificate's create date and time.
        """
        return pulumi.get(self, "created")

    @property
    @pulumi.getter
    def expiry(self) -> str:
        """
        The certificate's expiration date and time.
        """
        return pulumi.get(self, "expiry")

    @property
    @pulumi.getter(name="isVerified")
    def is_verified(self) -> bool:
        """
        Determines whether certificate has been verified.
        """
        return pulumi.get(self, "is_verified")

    @property
    @pulumi.getter
    def subject(self) -> str:
        """
        The certificate's subject name.
        """
        return pulumi.get(self, "subject")

    @property
    @pulumi.getter
    def thumbprint(self) -> str:
        """
        The certificate's thumbprint.
        """
        return pulumi.get(self, "thumbprint")

    @property
    @pulumi.getter
    def updated(self) -> str:
        """
        The certificate's last update date and time.
        """
        return pulumi.get(self, "updated")

    @property
    @pulumi.getter
    def certificate(self) -> Optional[str]:
        """
        The certificate content
        """
        return pulumi.get(self, "certificate")


@pulumi.output_type
class CloudToDevicePropertiesResponse(dict):
    """
    The IoT hub cloud-to-device messaging properties.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultTtlAsIso8601":
            suggest = "default_ttl_as_iso8601"
        elif key == "maxDeliveryCount":
            suggest = "max_delivery_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CloudToDevicePropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CloudToDevicePropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CloudToDevicePropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_ttl_as_iso8601: Optional[str] = None,
                 feedback: Optional['outputs.FeedbackPropertiesResponse'] = None,
                 max_delivery_count: Optional[int] = None):
        """
        The IoT hub cloud-to-device messaging properties.
        :param str default_ttl_as_iso8601: The default time to live for cloud-to-device messages in the device queue. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#cloud-to-device-messages.
        :param 'FeedbackPropertiesResponse' feedback: The properties of the feedback queue for cloud-to-device messages.
        :param int max_delivery_count: The max delivery count for cloud-to-device messages in the device queue. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#cloud-to-device-messages.
        """
        if default_ttl_as_iso8601 is not None:
            pulumi.set(__self__, "default_ttl_as_iso8601", default_ttl_as_iso8601)
        if feedback is not None:
            pulumi.set(__self__, "feedback", feedback)
        if max_delivery_count is not None:
            pulumi.set(__self__, "max_delivery_count", max_delivery_count)

    @property
    @pulumi.getter(name="defaultTtlAsIso8601")
    def default_ttl_as_iso8601(self) -> Optional[str]:
        """
        The default time to live for cloud-to-device messages in the device queue. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#cloud-to-device-messages.
        """
        return pulumi.get(self, "default_ttl_as_iso8601")

    @property
    @pulumi.getter
    def feedback(self) -> Optional['outputs.FeedbackPropertiesResponse']:
        """
        The properties of the feedback queue for cloud-to-device messages.
        """
        return pulumi.get(self, "feedback")

    @property
    @pulumi.getter(name="maxDeliveryCount")
    def max_delivery_count(self) -> Optional[int]:
        """
        The max delivery count for cloud-to-device messages in the device queue. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#cloud-to-device-messages.
        """
        return pulumi.get(self, "max_delivery_count")


@pulumi.output_type
class EventHubPropertiesResponse(dict):
    """
    The properties of the provisioned Event Hub-compatible endpoint used by the IoT hub.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "partitionIds":
            suggest = "partition_ids"
        elif key == "partitionCount":
            suggest = "partition_count"
        elif key == "retentionTimeInDays":
            suggest = "retention_time_in_days"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EventHubPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EventHubPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EventHubPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 endpoint: str,
                 partition_ids: Sequence[str],
                 path: str,
                 partition_count: Optional[int] = None,
                 retention_time_in_days: Optional[float] = None):
        """
        The properties of the provisioned Event Hub-compatible endpoint used by the IoT hub.
        :param str endpoint: The Event Hub-compatible endpoint.
        :param Sequence[str] partition_ids: The partition ids in the Event Hub-compatible endpoint.
        :param str path: The Event Hub-compatible name.
        :param int partition_count: The number of partitions for receiving device-to-cloud messages in the Event Hub-compatible endpoint. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#device-to-cloud-messages.
        :param float retention_time_in_days: The retention time for device-to-cloud messages in days. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#device-to-cloud-messages
        """
        pulumi.set(__self__, "endpoint", endpoint)
        pulumi.set(__self__, "partition_ids", partition_ids)
        pulumi.set(__self__, "path", path)
        if partition_count is not None:
            pulumi.set(__self__, "partition_count", partition_count)
        if retention_time_in_days is not None:
            pulumi.set(__self__, "retention_time_in_days", retention_time_in_days)

    @property
    @pulumi.getter
    def endpoint(self) -> str:
        """
        The Event Hub-compatible endpoint.
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter(name="partitionIds")
    def partition_ids(self) -> Sequence[str]:
        """
        The partition ids in the Event Hub-compatible endpoint.
        """
        return pulumi.get(self, "partition_ids")

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        The Event Hub-compatible name.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter(name="partitionCount")
    def partition_count(self) -> Optional[int]:
        """
        The number of partitions for receiving device-to-cloud messages in the Event Hub-compatible endpoint. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#device-to-cloud-messages.
        """
        return pulumi.get(self, "partition_count")

    @property
    @pulumi.getter(name="retentionTimeInDays")
    def retention_time_in_days(self) -> Optional[float]:
        """
        The retention time for device-to-cloud messages in days. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#device-to-cloud-messages
        """
        return pulumi.get(self, "retention_time_in_days")


@pulumi.output_type
class FallbackRoutePropertiesResponse(dict):
    """
    The properties of the fallback route. IoT Hub uses these properties when it routes messages to the fallback endpoint.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endpointNames":
            suggest = "endpoint_names"
        elif key == "isEnabled":
            suggest = "is_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FallbackRoutePropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FallbackRoutePropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FallbackRoutePropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 endpoint_names: Sequence[str],
                 is_enabled: bool,
                 source: str,
                 condition: Optional[str] = None,
                 name: Optional[str] = None):
        """
        The properties of the fallback route. IoT Hub uses these properties when it routes messages to the fallback endpoint.
        :param Sequence[str] endpoint_names: The list of endpoints to which the messages that satisfy the condition are routed to. Currently only 1 endpoint is allowed.
        :param bool is_enabled: Used to specify whether the fallback route is enabled.
        :param str source: The source to which the routing rule is to be applied to. For example, DeviceMessages
        :param str condition: The condition which is evaluated in order to apply the fallback route. If the condition is not provided it will evaluate to true by default. For grammar, See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-query-language
        :param str name: The name of the route. The name can only include alphanumeric characters, periods, underscores, hyphens, has a maximum length of 64 characters, and must be unique.
        """
        pulumi.set(__self__, "endpoint_names", endpoint_names)
        pulumi.set(__self__, "is_enabled", is_enabled)
        pulumi.set(__self__, "source", source)
        if condition is not None:
            pulumi.set(__self__, "condition", condition)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="endpointNames")
    def endpoint_names(self) -> Sequence[str]:
        """
        The list of endpoints to which the messages that satisfy the condition are routed to. Currently only 1 endpoint is allowed.
        """
        return pulumi.get(self, "endpoint_names")

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> bool:
        """
        Used to specify whether the fallback route is enabled.
        """
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter
    def source(self) -> str:
        """
        The source to which the routing rule is to be applied to. For example, DeviceMessages
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter
    def condition(self) -> Optional[str]:
        """
        The condition which is evaluated in order to apply the fallback route. If the condition is not provided it will evaluate to true by default. For grammar, See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-query-language
        """
        return pulumi.get(self, "condition")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the route. The name can only include alphanumeric characters, periods, underscores, hyphens, has a maximum length of 64 characters, and must be unique.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class FeedbackPropertiesResponse(dict):
    """
    The properties of the feedback queue for cloud-to-device messages.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lockDurationAsIso8601":
            suggest = "lock_duration_as_iso8601"
        elif key == "maxDeliveryCount":
            suggest = "max_delivery_count"
        elif key == "ttlAsIso8601":
            suggest = "ttl_as_iso8601"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FeedbackPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FeedbackPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FeedbackPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 lock_duration_as_iso8601: Optional[str] = None,
                 max_delivery_count: Optional[int] = None,
                 ttl_as_iso8601: Optional[str] = None):
        """
        The properties of the feedback queue for cloud-to-device messages.
        :param str lock_duration_as_iso8601: The lock duration for the feedback queue. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#cloud-to-device-messages.
        :param int max_delivery_count: The number of times the IoT hub attempts to deliver a message on the feedback queue. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#cloud-to-device-messages.
        :param str ttl_as_iso8601: The period of time for which a message is available to consume before it is expired by the IoT hub. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#cloud-to-device-messages.
        """
        if lock_duration_as_iso8601 is not None:
            pulumi.set(__self__, "lock_duration_as_iso8601", lock_duration_as_iso8601)
        if max_delivery_count is not None:
            pulumi.set(__self__, "max_delivery_count", max_delivery_count)
        if ttl_as_iso8601 is not None:
            pulumi.set(__self__, "ttl_as_iso8601", ttl_as_iso8601)

    @property
    @pulumi.getter(name="lockDurationAsIso8601")
    def lock_duration_as_iso8601(self) -> Optional[str]:
        """
        The lock duration for the feedback queue. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#cloud-to-device-messages.
        """
        return pulumi.get(self, "lock_duration_as_iso8601")

    @property
    @pulumi.getter(name="maxDeliveryCount")
    def max_delivery_count(self) -> Optional[int]:
        """
        The number of times the IoT hub attempts to deliver a message on the feedback queue. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#cloud-to-device-messages.
        """
        return pulumi.get(self, "max_delivery_count")

    @property
    @pulumi.getter(name="ttlAsIso8601")
    def ttl_as_iso8601(self) -> Optional[str]:
        """
        The period of time for which a message is available to consume before it is expired by the IoT hub. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#cloud-to-device-messages.
        """
        return pulumi.get(self, "ttl_as_iso8601")


@pulumi.output_type
class IotHubLocationDescriptionResponse(dict):
    """
    Public representation of one of the locations where a resource is provisioned.
    """
    def __init__(__self__, *,
                 location: Optional[str] = None,
                 role: Optional[str] = None):
        """
        Public representation of one of the locations where a resource is provisioned.
        :param str location: Azure Geo Regions
        :param str role: Specific Role assigned to this location
        """
        if location is not None:
            pulumi.set(__self__, "location", location)
        if role is not None:
            pulumi.set(__self__, "role", role)

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        Azure Geo Regions
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def role(self) -> Optional[str]:
        """
        Specific Role assigned to this location
        """
        return pulumi.get(self, "role")


@pulumi.output_type
class IotHubPropertiesResponse(dict):
    """
    The properties of an IoT hub.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hostName":
            suggest = "host_name"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "authorizationPolicies":
            suggest = "authorization_policies"
        elif key == "cloudToDevice":
            suggest = "cloud_to_device"
        elif key == "deviceStreams":
            suggest = "device_streams"
        elif key == "enableFileUploadNotifications":
            suggest = "enable_file_upload_notifications"
        elif key == "eventHubEndpoints":
            suggest = "event_hub_endpoints"
        elif key == "ipFilterRules":
            suggest = "ip_filter_rules"
        elif key == "messagingEndpoints":
            suggest = "messaging_endpoints"
        elif key == "storageEndpoints":
            suggest = "storage_endpoints"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IotHubPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IotHubPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IotHubPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 host_name: str,
                 provisioning_state: str,
                 state: str,
                 authorization_policies: Optional[Sequence['outputs.SharedAccessSignatureAuthorizationRuleResponse']] = None,
                 cloud_to_device: Optional['outputs.CloudToDevicePropertiesResponse'] = None,
                 comments: Optional[str] = None,
                 device_streams: Optional['outputs.IotHubPropertiesResponseDeviceStreams'] = None,
                 enable_file_upload_notifications: Optional[bool] = None,
                 event_hub_endpoints: Optional[Mapping[str, 'outputs.EventHubPropertiesResponse']] = None,
                 features: Optional[str] = None,
                 ip_filter_rules: Optional[Sequence['outputs.IpFilterRuleResponse']] = None,
                 locations: Optional[Sequence['outputs.IotHubLocationDescriptionResponse']] = None,
                 messaging_endpoints: Optional[Mapping[str, 'outputs.MessagingEndpointPropertiesResponse']] = None,
                 routing: Optional['outputs.RoutingPropertiesResponse'] = None,
                 storage_endpoints: Optional[Mapping[str, 'outputs.StorageEndpointPropertiesResponse']] = None):
        """
        The properties of an IoT hub.
        :param str host_name: The name of the host.
        :param str provisioning_state: The provisioning state.
        :param str state: The hub state.
        :param Sequence['SharedAccessSignatureAuthorizationRuleResponse'] authorization_policies: The shared access policies you can use to secure a connection to the IoT hub.
        :param 'CloudToDevicePropertiesResponse' cloud_to_device: The IoT hub cloud-to-device messaging properties.
        :param str comments: IoT hub comments.
        :param 'IotHubPropertiesResponseDeviceStreams' device_streams: The device streams properties of iothub.
        :param bool enable_file_upload_notifications: If True, file upload notifications are enabled.
        :param Mapping[str, 'EventHubPropertiesResponse'] event_hub_endpoints: The Event Hub-compatible endpoint properties. The only possible keys to this dictionary is events. This key has to be present in the dictionary while making create or update calls for the IoT hub.
        :param str features: The capabilities and features enabled for the IoT hub.
        :param Sequence['IpFilterRuleResponse'] ip_filter_rules: The IP filter rules.
        :param Sequence['IotHubLocationDescriptionResponse'] locations: Primary and secondary location for iot hub
        :param Mapping[str, 'MessagingEndpointPropertiesResponse'] messaging_endpoints: The messaging endpoint properties for the file upload notification queue.
        :param 'RoutingPropertiesResponse' routing: The routing related properties of the IoT hub. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging
        :param Mapping[str, 'StorageEndpointPropertiesResponse'] storage_endpoints: The list of Azure Storage endpoints where you can upload files. Currently you can configure only one Azure Storage account and that MUST have its key as $default. Specifying more than one storage account causes an error to be thrown. Not specifying a value for this property when the enableFileUploadNotifications property is set to True, causes an error to be thrown.
        """
        pulumi.set(__self__, "host_name", host_name)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "state", state)
        if authorization_policies is not None:
            pulumi.set(__self__, "authorization_policies", authorization_policies)
        if cloud_to_device is not None:
            pulumi.set(__self__, "cloud_to_device", cloud_to_device)
        if comments is not None:
            pulumi.set(__self__, "comments", comments)
        if device_streams is not None:
            pulumi.set(__self__, "device_streams", device_streams)
        if enable_file_upload_notifications is not None:
            pulumi.set(__self__, "enable_file_upload_notifications", enable_file_upload_notifications)
        if event_hub_endpoints is not None:
            pulumi.set(__self__, "event_hub_endpoints", event_hub_endpoints)
        if features is not None:
            pulumi.set(__self__, "features", features)
        if ip_filter_rules is not None:
            pulumi.set(__self__, "ip_filter_rules", ip_filter_rules)
        if locations is not None:
            pulumi.set(__self__, "locations", locations)
        if messaging_endpoints is not None:
            pulumi.set(__self__, "messaging_endpoints", messaging_endpoints)
        if routing is not None:
            pulumi.set(__self__, "routing", routing)
        if storage_endpoints is not None:
            pulumi.set(__self__, "storage_endpoints", storage_endpoints)

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> str:
        """
        The name of the host.
        """
        return pulumi.get(self, "host_name")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The hub state.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="authorizationPolicies")
    def authorization_policies(self) -> Optional[Sequence['outputs.SharedAccessSignatureAuthorizationRuleResponse']]:
        """
        The shared access policies you can use to secure a connection to the IoT hub.
        """
        return pulumi.get(self, "authorization_policies")

    @property
    @pulumi.getter(name="cloudToDevice")
    def cloud_to_device(self) -> Optional['outputs.CloudToDevicePropertiesResponse']:
        """
        The IoT hub cloud-to-device messaging properties.
        """
        return pulumi.get(self, "cloud_to_device")

    @property
    @pulumi.getter
    def comments(self) -> Optional[str]:
        """
        IoT hub comments.
        """
        return pulumi.get(self, "comments")

    @property
    @pulumi.getter(name="deviceStreams")
    def device_streams(self) -> Optional['outputs.IotHubPropertiesResponseDeviceStreams']:
        """
        The device streams properties of iothub.
        """
        return pulumi.get(self, "device_streams")

    @property
    @pulumi.getter(name="enableFileUploadNotifications")
    def enable_file_upload_notifications(self) -> Optional[bool]:
        """
        If True, file upload notifications are enabled.
        """
        return pulumi.get(self, "enable_file_upload_notifications")

    @property
    @pulumi.getter(name="eventHubEndpoints")
    def event_hub_endpoints(self) -> Optional[Mapping[str, 'outputs.EventHubPropertiesResponse']]:
        """
        The Event Hub-compatible endpoint properties. The only possible keys to this dictionary is events. This key has to be present in the dictionary while making create or update calls for the IoT hub.
        """
        return pulumi.get(self, "event_hub_endpoints")

    @property
    @pulumi.getter
    def features(self) -> Optional[str]:
        """
        The capabilities and features enabled for the IoT hub.
        """
        return pulumi.get(self, "features")

    @property
    @pulumi.getter(name="ipFilterRules")
    def ip_filter_rules(self) -> Optional[Sequence['outputs.IpFilterRuleResponse']]:
        """
        The IP filter rules.
        """
        return pulumi.get(self, "ip_filter_rules")

    @property
    @pulumi.getter
    def locations(self) -> Optional[Sequence['outputs.IotHubLocationDescriptionResponse']]:
        """
        Primary and secondary location for iot hub
        """
        return pulumi.get(self, "locations")

    @property
    @pulumi.getter(name="messagingEndpoints")
    def messaging_endpoints(self) -> Optional[Mapping[str, 'outputs.MessagingEndpointPropertiesResponse']]:
        """
        The messaging endpoint properties for the file upload notification queue.
        """
        return pulumi.get(self, "messaging_endpoints")

    @property
    @pulumi.getter
    def routing(self) -> Optional['outputs.RoutingPropertiesResponse']:
        """
        The routing related properties of the IoT hub. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging
        """
        return pulumi.get(self, "routing")

    @property
    @pulumi.getter(name="storageEndpoints")
    def storage_endpoints(self) -> Optional[Mapping[str, 'outputs.StorageEndpointPropertiesResponse']]:
        """
        The list of Azure Storage endpoints where you can upload files. Currently you can configure only one Azure Storage account and that MUST have its key as $default. Specifying more than one storage account causes an error to be thrown. Not specifying a value for this property when the enableFileUploadNotifications property is set to True, causes an error to be thrown.
        """
        return pulumi.get(self, "storage_endpoints")


@pulumi.output_type
class IotHubPropertiesResponseDeviceStreams(dict):
    """
    The device streams properties of iothub.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "streamingEndpoints":
            suggest = "streaming_endpoints"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IotHubPropertiesResponseDeviceStreams. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IotHubPropertiesResponseDeviceStreams.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IotHubPropertiesResponseDeviceStreams.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 streaming_endpoints: Optional[Sequence[str]] = None):
        """
        The device streams properties of iothub.
        :param Sequence[str] streaming_endpoints: List of Device Streams Endpoints.
        """
        if streaming_endpoints is not None:
            pulumi.set(__self__, "streaming_endpoints", streaming_endpoints)

    @property
    @pulumi.getter(name="streamingEndpoints")
    def streaming_endpoints(self) -> Optional[Sequence[str]]:
        """
        List of Device Streams Endpoints.
        """
        return pulumi.get(self, "streaming_endpoints")


@pulumi.output_type
class IotHubSkuInfoResponse(dict):
    """
    Information about the SKU of the IoT hub.
    """
    def __init__(__self__, *,
                 name: str,
                 tier: str,
                 capacity: Optional[float] = None):
        """
        Information about the SKU of the IoT hub.
        :param str name: The name of the SKU.
        :param str tier: The billing tier for the IoT hub.
        :param float capacity: The number of provisioned IoT Hub units. See: https://docs.microsoft.com/azure/azure-subscription-service-limits#iot-hub-limits.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "tier", tier)
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the SKU.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def tier(self) -> str:
        """
        The billing tier for the IoT hub.
        """
        return pulumi.get(self, "tier")

    @property
    @pulumi.getter
    def capacity(self) -> Optional[float]:
        """
        The number of provisioned IoT Hub units. See: https://docs.microsoft.com/azure/azure-subscription-service-limits#iot-hub-limits.
        """
        return pulumi.get(self, "capacity")


@pulumi.output_type
class IpFilterRuleResponse(dict):
    """
    The IP filter rules for the IoT hub.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "filterName":
            suggest = "filter_name"
        elif key == "ipMask":
            suggest = "ip_mask"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IpFilterRuleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IpFilterRuleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IpFilterRuleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action: str,
                 filter_name: str,
                 ip_mask: str):
        """
        The IP filter rules for the IoT hub.
        :param str action: The desired action for requests captured by this rule.
        :param str filter_name: The name of the IP filter rule.
        :param str ip_mask: A string that contains the IP address range in CIDR notation for the rule.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "filter_name", filter_name)
        pulumi.set(__self__, "ip_mask", ip_mask)

    @property
    @pulumi.getter
    def action(self) -> str:
        """
        The desired action for requests captured by this rule.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter(name="filterName")
    def filter_name(self) -> str:
        """
        The name of the IP filter rule.
        """
        return pulumi.get(self, "filter_name")

    @property
    @pulumi.getter(name="ipMask")
    def ip_mask(self) -> str:
        """
        A string that contains the IP address range in CIDR notation for the rule.
        """
        return pulumi.get(self, "ip_mask")


@pulumi.output_type
class MessagingEndpointPropertiesResponse(dict):
    """
    The properties of the messaging endpoints used by this IoT hub.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lockDurationAsIso8601":
            suggest = "lock_duration_as_iso8601"
        elif key == "maxDeliveryCount":
            suggest = "max_delivery_count"
        elif key == "ttlAsIso8601":
            suggest = "ttl_as_iso8601"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MessagingEndpointPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MessagingEndpointPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MessagingEndpointPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 lock_duration_as_iso8601: Optional[str] = None,
                 max_delivery_count: Optional[int] = None,
                 ttl_as_iso8601: Optional[str] = None):
        """
        The properties of the messaging endpoints used by this IoT hub.
        :param str lock_duration_as_iso8601: The lock duration. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-file-upload.
        :param int max_delivery_count: The number of times the IoT hub attempts to deliver a message. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-file-upload.
        :param str ttl_as_iso8601: The period of time for which a message is available to consume before it is expired by the IoT hub. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-file-upload.
        """
        if lock_duration_as_iso8601 is not None:
            pulumi.set(__self__, "lock_duration_as_iso8601", lock_duration_as_iso8601)
        if max_delivery_count is not None:
            pulumi.set(__self__, "max_delivery_count", max_delivery_count)
        if ttl_as_iso8601 is not None:
            pulumi.set(__self__, "ttl_as_iso8601", ttl_as_iso8601)

    @property
    @pulumi.getter(name="lockDurationAsIso8601")
    def lock_duration_as_iso8601(self) -> Optional[str]:
        """
        The lock duration. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-file-upload.
        """
        return pulumi.get(self, "lock_duration_as_iso8601")

    @property
    @pulumi.getter(name="maxDeliveryCount")
    def max_delivery_count(self) -> Optional[int]:
        """
        The number of times the IoT hub attempts to deliver a message. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-file-upload.
        """
        return pulumi.get(self, "max_delivery_count")

    @property
    @pulumi.getter(name="ttlAsIso8601")
    def ttl_as_iso8601(self) -> Optional[str]:
        """
        The period of time for which a message is available to consume before it is expired by the IoT hub. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-file-upload.
        """
        return pulumi.get(self, "ttl_as_iso8601")


@pulumi.output_type
class RoutePropertiesResponse(dict):
    """
    The properties of a routing rule that your IoT hub uses to route messages to endpoints.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endpointNames":
            suggest = "endpoint_names"
        elif key == "isEnabled":
            suggest = "is_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RoutePropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RoutePropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RoutePropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 endpoint_names: Sequence[str],
                 is_enabled: bool,
                 name: str,
                 source: str,
                 condition: Optional[str] = None):
        """
        The properties of a routing rule that your IoT hub uses to route messages to endpoints.
        :param Sequence[str] endpoint_names: The list of endpoints to which messages that satisfy the condition are routed. Currently only one endpoint is allowed.
        :param bool is_enabled: Used to specify whether a route is enabled.
        :param str name: The name of the route. The name can only include alphanumeric characters, periods, underscores, hyphens, has a maximum length of 64 characters, and must be unique.
        :param str source: The source that the routing rule is to be applied to, such as DeviceMessages.
        :param str condition: The condition that is evaluated to apply the routing rule. If no condition is provided, it evaluates to true by default. For grammar, see: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-query-language
        """
        pulumi.set(__self__, "endpoint_names", endpoint_names)
        pulumi.set(__self__, "is_enabled", is_enabled)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "source", source)
        if condition is not None:
            pulumi.set(__self__, "condition", condition)

    @property
    @pulumi.getter(name="endpointNames")
    def endpoint_names(self) -> Sequence[str]:
        """
        The list of endpoints to which messages that satisfy the condition are routed. Currently only one endpoint is allowed.
        """
        return pulumi.get(self, "endpoint_names")

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> bool:
        """
        Used to specify whether a route is enabled.
        """
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the route. The name can only include alphanumeric characters, periods, underscores, hyphens, has a maximum length of 64 characters, and must be unique.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def source(self) -> str:
        """
        The source that the routing rule is to be applied to, such as DeviceMessages.
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter
    def condition(self) -> Optional[str]:
        """
        The condition that is evaluated to apply the routing rule. If no condition is provided, it evaluates to true by default. For grammar, see: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-query-language
        """
        return pulumi.get(self, "condition")


@pulumi.output_type
class RoutingEndpointsResponse(dict):
    """
    The properties related to the custom endpoints to which your IoT hub routes messages based on the routing rules. A maximum of 10 custom endpoints are allowed across all endpoint types for paid hubs and only 1 custom endpoint is allowed across all endpoint types for free hubs.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "eventHubs":
            suggest = "event_hubs"
        elif key == "serviceBusQueues":
            suggest = "service_bus_queues"
        elif key == "serviceBusTopics":
            suggest = "service_bus_topics"
        elif key == "storageContainers":
            suggest = "storage_containers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RoutingEndpointsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RoutingEndpointsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RoutingEndpointsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 event_hubs: Optional[Sequence['outputs.RoutingEventHubPropertiesResponse']] = None,
                 service_bus_queues: Optional[Sequence['outputs.RoutingServiceBusQueueEndpointPropertiesResponse']] = None,
                 service_bus_topics: Optional[Sequence['outputs.RoutingServiceBusTopicEndpointPropertiesResponse']] = None,
                 storage_containers: Optional[Sequence['outputs.RoutingStorageContainerPropertiesResponse']] = None):
        """
        The properties related to the custom endpoints to which your IoT hub routes messages based on the routing rules. A maximum of 10 custom endpoints are allowed across all endpoint types for paid hubs and only 1 custom endpoint is allowed across all endpoint types for free hubs.
        :param Sequence['RoutingEventHubPropertiesResponse'] event_hubs: The list of Event Hubs endpoints that IoT hub routes messages to, based on the routing rules. This list does not include the built-in Event Hubs endpoint.
        :param Sequence['RoutingServiceBusQueueEndpointPropertiesResponse'] service_bus_queues: The list of Service Bus queue endpoints that IoT hub routes the messages to, based on the routing rules.
        :param Sequence['RoutingServiceBusTopicEndpointPropertiesResponse'] service_bus_topics: The list of Service Bus topic endpoints that the IoT hub routes the messages to, based on the routing rules.
        :param Sequence['RoutingStorageContainerPropertiesResponse'] storage_containers: The list of storage container endpoints that IoT hub routes messages to, based on the routing rules.
        """
        if event_hubs is not None:
            pulumi.set(__self__, "event_hubs", event_hubs)
        if service_bus_queues is not None:
            pulumi.set(__self__, "service_bus_queues", service_bus_queues)
        if service_bus_topics is not None:
            pulumi.set(__self__, "service_bus_topics", service_bus_topics)
        if storage_containers is not None:
            pulumi.set(__self__, "storage_containers", storage_containers)

    @property
    @pulumi.getter(name="eventHubs")
    def event_hubs(self) -> Optional[Sequence['outputs.RoutingEventHubPropertiesResponse']]:
        """
        The list of Event Hubs endpoints that IoT hub routes messages to, based on the routing rules. This list does not include the built-in Event Hubs endpoint.
        """
        return pulumi.get(self, "event_hubs")

    @property
    @pulumi.getter(name="serviceBusQueues")
    def service_bus_queues(self) -> Optional[Sequence['outputs.RoutingServiceBusQueueEndpointPropertiesResponse']]:
        """
        The list of Service Bus queue endpoints that IoT hub routes the messages to, based on the routing rules.
        """
        return pulumi.get(self, "service_bus_queues")

    @property
    @pulumi.getter(name="serviceBusTopics")
    def service_bus_topics(self) -> Optional[Sequence['outputs.RoutingServiceBusTopicEndpointPropertiesResponse']]:
        """
        The list of Service Bus topic endpoints that the IoT hub routes the messages to, based on the routing rules.
        """
        return pulumi.get(self, "service_bus_topics")

    @property
    @pulumi.getter(name="storageContainers")
    def storage_containers(self) -> Optional[Sequence['outputs.RoutingStorageContainerPropertiesResponse']]:
        """
        The list of storage container endpoints that IoT hub routes messages to, based on the routing rules.
        """
        return pulumi.get(self, "storage_containers")


@pulumi.output_type
class RoutingEventHubPropertiesResponse(dict):
    """
    The properties related to an event hub endpoint.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectionString":
            suggest = "connection_string"
        elif key == "resourceGroup":
            suggest = "resource_group"
        elif key == "subscriptionId":
            suggest = "subscription_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RoutingEventHubPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RoutingEventHubPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RoutingEventHubPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connection_string: str,
                 name: str,
                 resource_group: Optional[str] = None,
                 subscription_id: Optional[str] = None):
        """
        The properties related to an event hub endpoint.
        :param str connection_string: The connection string of the event hub endpoint. 
        :param str name: The name that identifies this endpoint. The name can only include alphanumeric characters, periods, underscores, hyphens and has a maximum length of 64 characters. The following names are reserved:  events, fileNotifications, $default. Endpoint names must be unique across endpoint types.
        :param str resource_group: The name of the resource group of the event hub endpoint.
        :param str subscription_id: The subscription identifier of the event hub endpoint.
        """
        pulumi.set(__self__, "connection_string", connection_string)
        pulumi.set(__self__, "name", name)
        if resource_group is not None:
            pulumi.set(__self__, "resource_group", resource_group)
        if subscription_id is not None:
            pulumi.set(__self__, "subscription_id", subscription_id)

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> str:
        """
        The connection string of the event hub endpoint. 
        """
        return pulumi.get(self, "connection_string")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name that identifies this endpoint. The name can only include alphanumeric characters, periods, underscores, hyphens and has a maximum length of 64 characters. The following names are reserved:  events, fileNotifications, $default. Endpoint names must be unique across endpoint types.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> Optional[str]:
        """
        The name of the resource group of the event hub endpoint.
        """
        return pulumi.get(self, "resource_group")

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> Optional[str]:
        """
        The subscription identifier of the event hub endpoint.
        """
        return pulumi.get(self, "subscription_id")


@pulumi.output_type
class RoutingPropertiesResponse(dict):
    """
    The routing related properties of the IoT hub. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fallbackRoute":
            suggest = "fallback_route"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RoutingPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RoutingPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RoutingPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 endpoints: Optional['outputs.RoutingEndpointsResponse'] = None,
                 fallback_route: Optional['outputs.FallbackRoutePropertiesResponse'] = None,
                 routes: Optional[Sequence['outputs.RoutePropertiesResponse']] = None):
        """
        The routing related properties of the IoT hub. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging
        :param 'RoutingEndpointsResponse' endpoints: The properties related to the custom endpoints to which your IoT hub routes messages based on the routing rules. A maximum of 10 custom endpoints are allowed across all endpoint types for paid hubs and only 1 custom endpoint is allowed across all endpoint types for free hubs.
        :param 'FallbackRoutePropertiesResponse' fallback_route: The properties of the route that is used as a fall-back route when none of the conditions specified in the 'routes' section are met. This is an optional parameter. When this property is not set, the messages which do not meet any of the conditions specified in the 'routes' section get routed to the built-in eventhub endpoint.
        :param Sequence['RoutePropertiesResponse'] routes: The list of user-provided routing rules that the IoT hub uses to route messages to built-in and custom endpoints. A maximum of 100 routing rules are allowed for paid hubs and a maximum of 5 routing rules are allowed for free hubs.
        """
        if endpoints is not None:
            pulumi.set(__self__, "endpoints", endpoints)
        if fallback_route is not None:
            pulumi.set(__self__, "fallback_route", fallback_route)
        if routes is not None:
            pulumi.set(__self__, "routes", routes)

    @property
    @pulumi.getter
    def endpoints(self) -> Optional['outputs.RoutingEndpointsResponse']:
        """
        The properties related to the custom endpoints to which your IoT hub routes messages based on the routing rules. A maximum of 10 custom endpoints are allowed across all endpoint types for paid hubs and only 1 custom endpoint is allowed across all endpoint types for free hubs.
        """
        return pulumi.get(self, "endpoints")

    @property
    @pulumi.getter(name="fallbackRoute")
    def fallback_route(self) -> Optional['outputs.FallbackRoutePropertiesResponse']:
        """
        The properties of the route that is used as a fall-back route when none of the conditions specified in the 'routes' section are met. This is an optional parameter. When this property is not set, the messages which do not meet any of the conditions specified in the 'routes' section get routed to the built-in eventhub endpoint.
        """
        return pulumi.get(self, "fallback_route")

    @property
    @pulumi.getter
    def routes(self) -> Optional[Sequence['outputs.RoutePropertiesResponse']]:
        """
        The list of user-provided routing rules that the IoT hub uses to route messages to built-in and custom endpoints. A maximum of 100 routing rules are allowed for paid hubs and a maximum of 5 routing rules are allowed for free hubs.
        """
        return pulumi.get(self, "routes")


@pulumi.output_type
class RoutingServiceBusQueueEndpointPropertiesResponse(dict):
    """
    The properties related to service bus queue endpoint types.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectionString":
            suggest = "connection_string"
        elif key == "resourceGroup":
            suggest = "resource_group"
        elif key == "subscriptionId":
            suggest = "subscription_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RoutingServiceBusQueueEndpointPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RoutingServiceBusQueueEndpointPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RoutingServiceBusQueueEndpointPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connection_string: str,
                 name: str,
                 resource_group: Optional[str] = None,
                 subscription_id: Optional[str] = None):
        """
        The properties related to service bus queue endpoint types.
        :param str connection_string: The connection string of the service bus queue endpoint.
        :param str name: The name that identifies this endpoint. The name can only include alphanumeric characters, periods, underscores, hyphens and has a maximum length of 64 characters. The following names are reserved:  events, fileNotifications, $default. Endpoint names must be unique across endpoint types. The name need not be the same as the actual queue name.
        :param str resource_group: The name of the resource group of the service bus queue endpoint.
        :param str subscription_id: The subscription identifier of the service bus queue endpoint.
        """
        pulumi.set(__self__, "connection_string", connection_string)
        pulumi.set(__self__, "name", name)
        if resource_group is not None:
            pulumi.set(__self__, "resource_group", resource_group)
        if subscription_id is not None:
            pulumi.set(__self__, "subscription_id", subscription_id)

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> str:
        """
        The connection string of the service bus queue endpoint.
        """
        return pulumi.get(self, "connection_string")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name that identifies this endpoint. The name can only include alphanumeric characters, periods, underscores, hyphens and has a maximum length of 64 characters. The following names are reserved:  events, fileNotifications, $default. Endpoint names must be unique across endpoint types. The name need not be the same as the actual queue name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> Optional[str]:
        """
        The name of the resource group of the service bus queue endpoint.
        """
        return pulumi.get(self, "resource_group")

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> Optional[str]:
        """
        The subscription identifier of the service bus queue endpoint.
        """
        return pulumi.get(self, "subscription_id")


@pulumi.output_type
class RoutingServiceBusTopicEndpointPropertiesResponse(dict):
    """
    The properties related to service bus topic endpoint types.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectionString":
            suggest = "connection_string"
        elif key == "resourceGroup":
            suggest = "resource_group"
        elif key == "subscriptionId":
            suggest = "subscription_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RoutingServiceBusTopicEndpointPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RoutingServiceBusTopicEndpointPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RoutingServiceBusTopicEndpointPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connection_string: str,
                 name: str,
                 resource_group: Optional[str] = None,
                 subscription_id: Optional[str] = None):
        """
        The properties related to service bus topic endpoint types.
        :param str connection_string: The connection string of the service bus topic endpoint.
        :param str name: The name that identifies this endpoint. The name can only include alphanumeric characters, periods, underscores, hyphens and has a maximum length of 64 characters. The following names are reserved:  events, fileNotifications, $default. Endpoint names must be unique across endpoint types.  The name need not be the same as the actual topic name.
        :param str resource_group: The name of the resource group of the service bus topic endpoint.
        :param str subscription_id: The subscription identifier of the service bus topic endpoint.
        """
        pulumi.set(__self__, "connection_string", connection_string)
        pulumi.set(__self__, "name", name)
        if resource_group is not None:
            pulumi.set(__self__, "resource_group", resource_group)
        if subscription_id is not None:
            pulumi.set(__self__, "subscription_id", subscription_id)

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> str:
        """
        The connection string of the service bus topic endpoint.
        """
        return pulumi.get(self, "connection_string")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name that identifies this endpoint. The name can only include alphanumeric characters, periods, underscores, hyphens and has a maximum length of 64 characters. The following names are reserved:  events, fileNotifications, $default. Endpoint names must be unique across endpoint types.  The name need not be the same as the actual topic name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> Optional[str]:
        """
        The name of the resource group of the service bus topic endpoint.
        """
        return pulumi.get(self, "resource_group")

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> Optional[str]:
        """
        The subscription identifier of the service bus topic endpoint.
        """
        return pulumi.get(self, "subscription_id")


@pulumi.output_type
class RoutingStorageContainerPropertiesResponse(dict):
    """
    The properties related to a storage container endpoint.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectionString":
            suggest = "connection_string"
        elif key == "containerName":
            suggest = "container_name"
        elif key == "batchFrequencyInSeconds":
            suggest = "batch_frequency_in_seconds"
        elif key == "fileNameFormat":
            suggest = "file_name_format"
        elif key == "maxChunkSizeInBytes":
            suggest = "max_chunk_size_in_bytes"
        elif key == "resourceGroup":
            suggest = "resource_group"
        elif key == "subscriptionId":
            suggest = "subscription_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RoutingStorageContainerPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RoutingStorageContainerPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RoutingStorageContainerPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connection_string: str,
                 container_name: str,
                 name: str,
                 batch_frequency_in_seconds: Optional[int] = None,
                 encoding: Optional[str] = None,
                 file_name_format: Optional[str] = None,
                 max_chunk_size_in_bytes: Optional[int] = None,
                 resource_group: Optional[str] = None,
                 subscription_id: Optional[str] = None):
        """
        The properties related to a storage container endpoint.
        :param str connection_string: The connection string of the storage account.
        :param str container_name: The name of storage container in the storage account.
        :param str name: The name that identifies this endpoint. The name can only include alphanumeric characters, periods, underscores, hyphens and has a maximum length of 64 characters. The following names are reserved:  events, fileNotifications, $default. Endpoint names must be unique across endpoint types.
        :param int batch_frequency_in_seconds: Time interval at which blobs are written to storage. Value should be between 60 and 720 seconds. Default value is 300 seconds.
        :param str encoding: Encoding that is used to serialize messages to blobs. Supported values are 'avro', 'avrodeflate', and 'JSON'. Default value is 'avro'.
        :param str file_name_format: File name format for the blob. Default format is {iothub}/{partition}/{YYYY}/{MM}/{DD}/{HH}/{mm}. All parameters are mandatory but can be reordered.
        :param int max_chunk_size_in_bytes: Maximum number of bytes for each blob written to storage. Value should be between 10485760(10MB) and 524288000(500MB). Default value is 314572800(300MB).
        :param str resource_group: The name of the resource group of the storage account.
        :param str subscription_id: The subscription identifier of the storage account.
        """
        pulumi.set(__self__, "connection_string", connection_string)
        pulumi.set(__self__, "container_name", container_name)
        pulumi.set(__self__, "name", name)
        if batch_frequency_in_seconds is not None:
            pulumi.set(__self__, "batch_frequency_in_seconds", batch_frequency_in_seconds)
        if encoding is not None:
            pulumi.set(__self__, "encoding", encoding)
        if file_name_format is not None:
            pulumi.set(__self__, "file_name_format", file_name_format)
        if max_chunk_size_in_bytes is not None:
            pulumi.set(__self__, "max_chunk_size_in_bytes", max_chunk_size_in_bytes)
        if resource_group is not None:
            pulumi.set(__self__, "resource_group", resource_group)
        if subscription_id is not None:
            pulumi.set(__self__, "subscription_id", subscription_id)

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> str:
        """
        The connection string of the storage account.
        """
        return pulumi.get(self, "connection_string")

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> str:
        """
        The name of storage container in the storage account.
        """
        return pulumi.get(self, "container_name")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name that identifies this endpoint. The name can only include alphanumeric characters, periods, underscores, hyphens and has a maximum length of 64 characters. The following names are reserved:  events, fileNotifications, $default. Endpoint names must be unique across endpoint types.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="batchFrequencyInSeconds")
    def batch_frequency_in_seconds(self) -> Optional[int]:
        """
        Time interval at which blobs are written to storage. Value should be between 60 and 720 seconds. Default value is 300 seconds.
        """
        return pulumi.get(self, "batch_frequency_in_seconds")

    @property
    @pulumi.getter
    def encoding(self) -> Optional[str]:
        """
        Encoding that is used to serialize messages to blobs. Supported values are 'avro', 'avrodeflate', and 'JSON'. Default value is 'avro'.
        """
        return pulumi.get(self, "encoding")

    @property
    @pulumi.getter(name="fileNameFormat")
    def file_name_format(self) -> Optional[str]:
        """
        File name format for the blob. Default format is {iothub}/{partition}/{YYYY}/{MM}/{DD}/{HH}/{mm}. All parameters are mandatory but can be reordered.
        """
        return pulumi.get(self, "file_name_format")

    @property
    @pulumi.getter(name="maxChunkSizeInBytes")
    def max_chunk_size_in_bytes(self) -> Optional[int]:
        """
        Maximum number of bytes for each blob written to storage. Value should be between 10485760(10MB) and 524288000(500MB). Default value is 314572800(300MB).
        """
        return pulumi.get(self, "max_chunk_size_in_bytes")

    @property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> Optional[str]:
        """
        The name of the resource group of the storage account.
        """
        return pulumi.get(self, "resource_group")

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> Optional[str]:
        """
        The subscription identifier of the storage account.
        """
        return pulumi.get(self, "subscription_id")


@pulumi.output_type
class SharedAccessSignatureAuthorizationRuleResponse(dict):
    """
    The properties of an IoT hub shared access policy.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyName":
            suggest = "key_name"
        elif key == "primaryKey":
            suggest = "primary_key"
        elif key == "secondaryKey":
            suggest = "secondary_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SharedAccessSignatureAuthorizationRuleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SharedAccessSignatureAuthorizationRuleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SharedAccessSignatureAuthorizationRuleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_name: str,
                 rights: str,
                 primary_key: Optional[str] = None,
                 secondary_key: Optional[str] = None):
        """
        The properties of an IoT hub shared access policy.
        :param str key_name: The name of the shared access policy.
        :param str rights: The permissions assigned to the shared access policy.
        :param str primary_key: The primary key.
        :param str secondary_key: The secondary key.
        """
        pulumi.set(__self__, "key_name", key_name)
        pulumi.set(__self__, "rights", rights)
        if primary_key is not None:
            pulumi.set(__self__, "primary_key", primary_key)
        if secondary_key is not None:
            pulumi.set(__self__, "secondary_key", secondary_key)

    @property
    @pulumi.getter(name="keyName")
    def key_name(self) -> str:
        """
        The name of the shared access policy.
        """
        return pulumi.get(self, "key_name")

    @property
    @pulumi.getter
    def rights(self) -> str:
        """
        The permissions assigned to the shared access policy.
        """
        return pulumi.get(self, "rights")

    @property
    @pulumi.getter(name="primaryKey")
    def primary_key(self) -> Optional[str]:
        """
        The primary key.
        """
        return pulumi.get(self, "primary_key")

    @property
    @pulumi.getter(name="secondaryKey")
    def secondary_key(self) -> Optional[str]:
        """
        The secondary key.
        """
        return pulumi.get(self, "secondary_key")


@pulumi.output_type
class StorageEndpointPropertiesResponse(dict):
    """
    The properties of the Azure Storage endpoint for file upload.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectionString":
            suggest = "connection_string"
        elif key == "containerName":
            suggest = "container_name"
        elif key == "sasTtlAsIso8601":
            suggest = "sas_ttl_as_iso8601"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StorageEndpointPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StorageEndpointPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StorageEndpointPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connection_string: str,
                 container_name: str,
                 sas_ttl_as_iso8601: Optional[str] = None):
        """
        The properties of the Azure Storage endpoint for file upload.
        :param str connection_string: The connection string for the Azure Storage account to which files are uploaded.
        :param str container_name: The name of the root container where you upload files. The container need not exist but should be creatable using the connectionString specified.
        :param str sas_ttl_as_iso8601: The period of time for which the SAS URI generated by IoT Hub for file upload is valid. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-file-upload#file-upload-notification-configuration-options.
        """
        pulumi.set(__self__, "connection_string", connection_string)
        pulumi.set(__self__, "container_name", container_name)
        if sas_ttl_as_iso8601 is not None:
            pulumi.set(__self__, "sas_ttl_as_iso8601", sas_ttl_as_iso8601)

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> str:
        """
        The connection string for the Azure Storage account to which files are uploaded.
        """
        return pulumi.get(self, "connection_string")

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> str:
        """
        The name of the root container where you upload files. The container need not exist but should be creatable using the connectionString specified.
        """
        return pulumi.get(self, "container_name")

    @property
    @pulumi.getter(name="sasTtlAsIso8601")
    def sas_ttl_as_iso8601(self) -> Optional[str]:
        """
        The period of time for which the SAS URI generated by IoT Hub for file upload is valid. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-file-upload#file-upload-notification-configuration-options.
        """
        return pulumi.get(self, "sas_ttl_as_iso8601")


