# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetAssessmentMetadataInSubscriptionResult',
    'AwaitableGetAssessmentMetadataInSubscriptionResult',
    'get_assessment_metadata_in_subscription',
    'get_assessment_metadata_in_subscription_output',
]

@pulumi.output_type
class GetAssessmentMetadataInSubscriptionResult:
    """
    Security assessment metadata response
    """
    def __init__(__self__, assessment_type=None, categories=None, description=None, display_name=None, id=None, implementation_effort=None, name=None, partner_data=None, planned_deprecation_date=None, policy_definition_id=None, preview=None, publish_dates=None, remediation_description=None, severity=None, tactics=None, techniques=None, threats=None, type=None, user_impact=None):
        if assessment_type and not isinstance(assessment_type, str):
            raise TypeError("Expected argument 'assessment_type' to be a str")
        pulumi.set(__self__, "assessment_type", assessment_type)
        if categories and not isinstance(categories, list):
            raise TypeError("Expected argument 'categories' to be a list")
        pulumi.set(__self__, "categories", categories)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if implementation_effort and not isinstance(implementation_effort, str):
            raise TypeError("Expected argument 'implementation_effort' to be a str")
        pulumi.set(__self__, "implementation_effort", implementation_effort)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if partner_data and not isinstance(partner_data, dict):
            raise TypeError("Expected argument 'partner_data' to be a dict")
        pulumi.set(__self__, "partner_data", partner_data)
        if planned_deprecation_date and not isinstance(planned_deprecation_date, str):
            raise TypeError("Expected argument 'planned_deprecation_date' to be a str")
        pulumi.set(__self__, "planned_deprecation_date", planned_deprecation_date)
        if policy_definition_id and not isinstance(policy_definition_id, str):
            raise TypeError("Expected argument 'policy_definition_id' to be a str")
        pulumi.set(__self__, "policy_definition_id", policy_definition_id)
        if preview and not isinstance(preview, bool):
            raise TypeError("Expected argument 'preview' to be a bool")
        pulumi.set(__self__, "preview", preview)
        if publish_dates and not isinstance(publish_dates, dict):
            raise TypeError("Expected argument 'publish_dates' to be a dict")
        pulumi.set(__self__, "publish_dates", publish_dates)
        if remediation_description and not isinstance(remediation_description, str):
            raise TypeError("Expected argument 'remediation_description' to be a str")
        pulumi.set(__self__, "remediation_description", remediation_description)
        if severity and not isinstance(severity, str):
            raise TypeError("Expected argument 'severity' to be a str")
        pulumi.set(__self__, "severity", severity)
        if tactics and not isinstance(tactics, list):
            raise TypeError("Expected argument 'tactics' to be a list")
        pulumi.set(__self__, "tactics", tactics)
        if techniques and not isinstance(techniques, list):
            raise TypeError("Expected argument 'techniques' to be a list")
        pulumi.set(__self__, "techniques", techniques)
        if threats and not isinstance(threats, list):
            raise TypeError("Expected argument 'threats' to be a list")
        pulumi.set(__self__, "threats", threats)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if user_impact and not isinstance(user_impact, str):
            raise TypeError("Expected argument 'user_impact' to be a str")
        pulumi.set(__self__, "user_impact", user_impact)

    @property
    @pulumi.getter(name="assessmentType")
    def assessment_type(self) -> str:
        """
        BuiltIn if the assessment based on built-in Azure Policy definition, Custom if the assessment based on custom Azure Policy definition
        """
        return pulumi.get(self, "assessment_type")

    @property
    @pulumi.getter
    def categories(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "categories")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Human readable description of the assessment
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        User friendly display name of the assessment
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Resource Id
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="implementationEffort")
    def implementation_effort(self) -> Optional[str]:
        """
        The implementation effort required to remediate this assessment
        """
        return pulumi.get(self, "implementation_effort")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Resource name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="partnerData")
    def partner_data(self) -> Optional['outputs.SecurityAssessmentMetadataPartnerDataResponse']:
        """
        Describes the partner that created the assessment
        """
        return pulumi.get(self, "partner_data")

    @property
    @pulumi.getter(name="plannedDeprecationDate")
    def planned_deprecation_date(self) -> Optional[str]:
        return pulumi.get(self, "planned_deprecation_date")

    @property
    @pulumi.getter(name="policyDefinitionId")
    def policy_definition_id(self) -> str:
        """
        Azure resource ID of the policy definition that turns this assessment calculation on
        """
        return pulumi.get(self, "policy_definition_id")

    @property
    @pulumi.getter
    def preview(self) -> Optional[bool]:
        """
        True if this assessment is in preview release status
        """
        return pulumi.get(self, "preview")

    @property
    @pulumi.getter(name="publishDates")
    def publish_dates(self) -> Optional['outputs.SecurityAssessmentMetadataPropertiesResponseResponsePublishDates']:
        return pulumi.get(self, "publish_dates")

    @property
    @pulumi.getter(name="remediationDescription")
    def remediation_description(self) -> Optional[str]:
        """
        Human readable description of what you should do to mitigate this security issue
        """
        return pulumi.get(self, "remediation_description")

    @property
    @pulumi.getter
    def severity(self) -> str:
        """
        The severity level of the assessment
        """
        return pulumi.get(self, "severity")

    @property
    @pulumi.getter
    def tactics(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "tactics")

    @property
    @pulumi.getter
    def techniques(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "techniques")

    @property
    @pulumi.getter
    def threats(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "threats")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Resource type
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="userImpact")
    def user_impact(self) -> Optional[str]:
        """
        The user impact of the assessment
        """
        return pulumi.get(self, "user_impact")


class AwaitableGetAssessmentMetadataInSubscriptionResult(GetAssessmentMetadataInSubscriptionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAssessmentMetadataInSubscriptionResult(
            assessment_type=self.assessment_type,
            categories=self.categories,
            description=self.description,
            display_name=self.display_name,
            id=self.id,
            implementation_effort=self.implementation_effort,
            name=self.name,
            partner_data=self.partner_data,
            planned_deprecation_date=self.planned_deprecation_date,
            policy_definition_id=self.policy_definition_id,
            preview=self.preview,
            publish_dates=self.publish_dates,
            remediation_description=self.remediation_description,
            severity=self.severity,
            tactics=self.tactics,
            techniques=self.techniques,
            threats=self.threats,
            type=self.type,
            user_impact=self.user_impact)


def get_assessment_metadata_in_subscription(assessment_metadata_name: Optional[str] = None,
                                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAssessmentMetadataInSubscriptionResult:
    """
    Security assessment metadata response


    :param str assessment_metadata_name: The Assessment Key - Unique key for the assessment type
    """
    __args__ = dict()
    __args__['assessmentMetadataName'] = assessment_metadata_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure-native:security/v20210601:getAssessmentMetadataInSubscription', __args__, opts=opts, typ=GetAssessmentMetadataInSubscriptionResult).value

    return AwaitableGetAssessmentMetadataInSubscriptionResult(
        assessment_type=__ret__.assessment_type,
        categories=__ret__.categories,
        description=__ret__.description,
        display_name=__ret__.display_name,
        id=__ret__.id,
        implementation_effort=__ret__.implementation_effort,
        name=__ret__.name,
        partner_data=__ret__.partner_data,
        planned_deprecation_date=__ret__.planned_deprecation_date,
        policy_definition_id=__ret__.policy_definition_id,
        preview=__ret__.preview,
        publish_dates=__ret__.publish_dates,
        remediation_description=__ret__.remediation_description,
        severity=__ret__.severity,
        tactics=__ret__.tactics,
        techniques=__ret__.techniques,
        threats=__ret__.threats,
        type=__ret__.type,
        user_impact=__ret__.user_impact)


@_utilities.lift_output_func(get_assessment_metadata_in_subscription)
def get_assessment_metadata_in_subscription_output(assessment_metadata_name: Optional[pulumi.Input[str]] = None,
                                                   opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetAssessmentMetadataInSubscriptionResult]:
    """
    Security assessment metadata response


    :param str assessment_metadata_name: The Assessment Key - Unique key for the assessment type
    """
    ...
