# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'AzureFileFilterDetailsArgs',
    'BlobFilterDetailsArgs',
    'ContactDetailsArgs',
    'DataBoxCustomerDiskJobDetailsArgs',
    'DataBoxDiskJobDetailsArgs',
    'DataBoxHeavyJobDetailsArgs',
    'DataBoxJobDetailsArgs',
    'DataExportDetailsArgs',
    'DataImportDetailsArgs',
    'EncryptionPreferencesArgs',
    'FilterFileDetailsArgs',
    'IdentityPropertiesArgs',
    'ImportDiskDetailsArgs',
    'JobDeliveryInfoArgs',
    'KeyEncryptionKeyArgs',
    'ManagedDiskDetailsArgs',
    'NotificationPreferenceArgs',
    'PackageCarrierDetailsArgs',
    'PreferencesArgs',
    'ResourceIdentityArgs',
    'ShippingAddressArgs',
    'SkuArgs',
    'StorageAccountDetailsArgs',
    'TransferAllDetailsArgs',
    'TransferConfigurationTransferAllDetailsArgs',
    'TransferConfigurationTransferFilterDetailsArgs',
    'TransferConfigurationArgs',
    'TransferFilterDetailsArgs',
    'TransportPreferencesArgs',
    'UserAssignedPropertiesArgs',
]

@pulumi.input_type
class AzureFileFilterDetailsArgs:
    def __init__(__self__, *,
                 file_path_list: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 file_prefix_list: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 file_share_list: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Filter details to transfer Azure files
        :param pulumi.Input[Sequence[pulumi.Input[str]]] file_path_list: List of full path of the files to be transferred.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] file_prefix_list: Prefix list of the Azure files to be transferred.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] file_share_list: List of file shares to be transferred.
        """
        if file_path_list is not None:
            pulumi.set(__self__, "file_path_list", file_path_list)
        if file_prefix_list is not None:
            pulumi.set(__self__, "file_prefix_list", file_prefix_list)
        if file_share_list is not None:
            pulumi.set(__self__, "file_share_list", file_share_list)

    @property
    @pulumi.getter(name="filePathList")
    def file_path_list(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of full path of the files to be transferred.
        """
        return pulumi.get(self, "file_path_list")

    @file_path_list.setter
    def file_path_list(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "file_path_list", value)

    @property
    @pulumi.getter(name="filePrefixList")
    def file_prefix_list(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Prefix list of the Azure files to be transferred.
        """
        return pulumi.get(self, "file_prefix_list")

    @file_prefix_list.setter
    def file_prefix_list(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "file_prefix_list", value)

    @property
    @pulumi.getter(name="fileShareList")
    def file_share_list(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of file shares to be transferred.
        """
        return pulumi.get(self, "file_share_list")

    @file_share_list.setter
    def file_share_list(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "file_share_list", value)


@pulumi.input_type
class BlobFilterDetailsArgs:
    def __init__(__self__, *,
                 blob_path_list: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 blob_prefix_list: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 container_list: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Filter details to transfer Azure Blobs
        :param pulumi.Input[Sequence[pulumi.Input[str]]] blob_path_list: List of full path of the blobs to be transferred.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] blob_prefix_list: Prefix list of the Azure blobs to be transferred.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] container_list: List of blob containers to be transferred.
        """
        if blob_path_list is not None:
            pulumi.set(__self__, "blob_path_list", blob_path_list)
        if blob_prefix_list is not None:
            pulumi.set(__self__, "blob_prefix_list", blob_prefix_list)
        if container_list is not None:
            pulumi.set(__self__, "container_list", container_list)

    @property
    @pulumi.getter(name="blobPathList")
    def blob_path_list(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of full path of the blobs to be transferred.
        """
        return pulumi.get(self, "blob_path_list")

    @blob_path_list.setter
    def blob_path_list(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "blob_path_list", value)

    @property
    @pulumi.getter(name="blobPrefixList")
    def blob_prefix_list(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Prefix list of the Azure blobs to be transferred.
        """
        return pulumi.get(self, "blob_prefix_list")

    @blob_prefix_list.setter
    def blob_prefix_list(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "blob_prefix_list", value)

    @property
    @pulumi.getter(name="containerList")
    def container_list(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of blob containers to be transferred.
        """
        return pulumi.get(self, "container_list")

    @container_list.setter
    def container_list(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "container_list", value)


@pulumi.input_type
class ContactDetailsArgs:
    def __init__(__self__, *,
                 contact_name: pulumi.Input[str],
                 email_list: pulumi.Input[Sequence[pulumi.Input[str]]],
                 phone: pulumi.Input[str],
                 mobile: Optional[pulumi.Input[str]] = None,
                 notification_preference: Optional[pulumi.Input[Sequence[pulumi.Input['NotificationPreferenceArgs']]]] = None,
                 phone_extension: Optional[pulumi.Input[str]] = None):
        """
        Contact Details.
        :param pulumi.Input[str] contact_name: Contact name of the person.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] email_list: List of Email-ids to be notified about job progress.
        :param pulumi.Input[str] phone: Phone number of the contact person.
        :param pulumi.Input[str] mobile: Mobile number of the contact person.
        :param pulumi.Input[Sequence[pulumi.Input['NotificationPreferenceArgs']]] notification_preference: Notification preference for a job stage.
        :param pulumi.Input[str] phone_extension: Phone extension number of the contact person.
        """
        pulumi.set(__self__, "contact_name", contact_name)
        pulumi.set(__self__, "email_list", email_list)
        pulumi.set(__self__, "phone", phone)
        if mobile is not None:
            pulumi.set(__self__, "mobile", mobile)
        if notification_preference is not None:
            pulumi.set(__self__, "notification_preference", notification_preference)
        if phone_extension is not None:
            pulumi.set(__self__, "phone_extension", phone_extension)

    @property
    @pulumi.getter(name="contactName")
    def contact_name(self) -> pulumi.Input[str]:
        """
        Contact name of the person.
        """
        return pulumi.get(self, "contact_name")

    @contact_name.setter
    def contact_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "contact_name", value)

    @property
    @pulumi.getter(name="emailList")
    def email_list(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        List of Email-ids to be notified about job progress.
        """
        return pulumi.get(self, "email_list")

    @email_list.setter
    def email_list(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "email_list", value)

    @property
    @pulumi.getter
    def phone(self) -> pulumi.Input[str]:
        """
        Phone number of the contact person.
        """
        return pulumi.get(self, "phone")

    @phone.setter
    def phone(self, value: pulumi.Input[str]):
        pulumi.set(self, "phone", value)

    @property
    @pulumi.getter
    def mobile(self) -> Optional[pulumi.Input[str]]:
        """
        Mobile number of the contact person.
        """
        return pulumi.get(self, "mobile")

    @mobile.setter
    def mobile(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mobile", value)

    @property
    @pulumi.getter(name="notificationPreference")
    def notification_preference(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NotificationPreferenceArgs']]]]:
        """
        Notification preference for a job stage.
        """
        return pulumi.get(self, "notification_preference")

    @notification_preference.setter
    def notification_preference(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NotificationPreferenceArgs']]]]):
        pulumi.set(self, "notification_preference", value)

    @property
    @pulumi.getter(name="phoneExtension")
    def phone_extension(self) -> Optional[pulumi.Input[str]]:
        """
        Phone extension number of the contact person.
        """
        return pulumi.get(self, "phone_extension")

    @phone_extension.setter
    def phone_extension(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "phone_extension", value)


@pulumi.input_type
class DataBoxCustomerDiskJobDetailsArgs:
    def __init__(__self__, *,
                 contact_details: pulumi.Input['ContactDetailsArgs'],
                 job_details_type: pulumi.Input[str],
                 return_to_customer_package_details: pulumi.Input['PackageCarrierDetailsArgs'],
                 data_export_details: Optional[pulumi.Input[Sequence[pulumi.Input['DataExportDetailsArgs']]]] = None,
                 data_import_details: Optional[pulumi.Input[Sequence[pulumi.Input['DataImportDetailsArgs']]]] = None,
                 enable_manifest_backup: Optional[pulumi.Input[bool]] = None,
                 expected_data_size_in_tera_bytes: Optional[pulumi.Input[int]] = None,
                 import_disk_details_collection: Optional[pulumi.Input[Mapping[str, pulumi.Input['ImportDiskDetailsArgs']]]] = None,
                 key_encryption_key: Optional[pulumi.Input['KeyEncryptionKeyArgs']] = None,
                 preferences: Optional[pulumi.Input['PreferencesArgs']] = None,
                 shipping_address: Optional[pulumi.Input['ShippingAddressArgs']] = None):
        """
        Customer disk job details.
        :param pulumi.Input['ContactDetailsArgs'] contact_details: Contact details for notification and shipping.
        :param pulumi.Input[str] job_details_type: Indicates the type of job details.
               Expected value is 'DataBoxCustomerDisk'.
        :param pulumi.Input['PackageCarrierDetailsArgs'] return_to_customer_package_details: Return package shipping details.
        :param pulumi.Input[Sequence[pulumi.Input['DataExportDetailsArgs']]] data_export_details: Details of the data to be exported from azure.
        :param pulumi.Input[Sequence[pulumi.Input['DataImportDetailsArgs']]] data_import_details: Details of the data to be imported into azure.
        :param pulumi.Input[bool] enable_manifest_backup: Flag to indicate if disk manifest should be backed-up in the Storage Account.
        :param pulumi.Input[int] expected_data_size_in_tera_bytes: The expected size of the data, which needs to be transferred in this job, in terabytes.
        :param pulumi.Input[Mapping[str, pulumi.Input['ImportDiskDetailsArgs']]] import_disk_details_collection: Contains the map of disk serial number to the disk details for import jobs.
        :param pulumi.Input['KeyEncryptionKeyArgs'] key_encryption_key: Details about which key encryption type is being used.
        :param pulumi.Input['PreferencesArgs'] preferences: Preferences for the order.
        :param pulumi.Input['ShippingAddressArgs'] shipping_address: Shipping address of the customer.
        """
        pulumi.set(__self__, "contact_details", contact_details)
        pulumi.set(__self__, "job_details_type", 'DataBoxCustomerDisk')
        pulumi.set(__self__, "return_to_customer_package_details", return_to_customer_package_details)
        if data_export_details is not None:
            pulumi.set(__self__, "data_export_details", data_export_details)
        if data_import_details is not None:
            pulumi.set(__self__, "data_import_details", data_import_details)
        if enable_manifest_backup is None:
            enable_manifest_backup = False
        if enable_manifest_backup is not None:
            pulumi.set(__self__, "enable_manifest_backup", enable_manifest_backup)
        if expected_data_size_in_tera_bytes is not None:
            pulumi.set(__self__, "expected_data_size_in_tera_bytes", expected_data_size_in_tera_bytes)
        if import_disk_details_collection is not None:
            pulumi.set(__self__, "import_disk_details_collection", import_disk_details_collection)
        if key_encryption_key is not None:
            pulumi.set(__self__, "key_encryption_key", key_encryption_key)
        if preferences is not None:
            pulumi.set(__self__, "preferences", preferences)
        if shipping_address is not None:
            pulumi.set(__self__, "shipping_address", shipping_address)

    @property
    @pulumi.getter(name="contactDetails")
    def contact_details(self) -> pulumi.Input['ContactDetailsArgs']:
        """
        Contact details for notification and shipping.
        """
        return pulumi.get(self, "contact_details")

    @contact_details.setter
    def contact_details(self, value: pulumi.Input['ContactDetailsArgs']):
        pulumi.set(self, "contact_details", value)

    @property
    @pulumi.getter(name="jobDetailsType")
    def job_details_type(self) -> pulumi.Input[str]:
        """
        Indicates the type of job details.
        Expected value is 'DataBoxCustomerDisk'.
        """
        return pulumi.get(self, "job_details_type")

    @job_details_type.setter
    def job_details_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "job_details_type", value)

    @property
    @pulumi.getter(name="returnToCustomerPackageDetails")
    def return_to_customer_package_details(self) -> pulumi.Input['PackageCarrierDetailsArgs']:
        """
        Return package shipping details.
        """
        return pulumi.get(self, "return_to_customer_package_details")

    @return_to_customer_package_details.setter
    def return_to_customer_package_details(self, value: pulumi.Input['PackageCarrierDetailsArgs']):
        pulumi.set(self, "return_to_customer_package_details", value)

    @property
    @pulumi.getter(name="dataExportDetails")
    def data_export_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DataExportDetailsArgs']]]]:
        """
        Details of the data to be exported from azure.
        """
        return pulumi.get(self, "data_export_details")

    @data_export_details.setter
    def data_export_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DataExportDetailsArgs']]]]):
        pulumi.set(self, "data_export_details", value)

    @property
    @pulumi.getter(name="dataImportDetails")
    def data_import_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DataImportDetailsArgs']]]]:
        """
        Details of the data to be imported into azure.
        """
        return pulumi.get(self, "data_import_details")

    @data_import_details.setter
    def data_import_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DataImportDetailsArgs']]]]):
        pulumi.set(self, "data_import_details", value)

    @property
    @pulumi.getter(name="enableManifestBackup")
    def enable_manifest_backup(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag to indicate if disk manifest should be backed-up in the Storage Account.
        """
        return pulumi.get(self, "enable_manifest_backup")

    @enable_manifest_backup.setter
    def enable_manifest_backup(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_manifest_backup", value)

    @property
    @pulumi.getter(name="expectedDataSizeInTeraBytes")
    def expected_data_size_in_tera_bytes(self) -> Optional[pulumi.Input[int]]:
        """
        The expected size of the data, which needs to be transferred in this job, in terabytes.
        """
        return pulumi.get(self, "expected_data_size_in_tera_bytes")

    @expected_data_size_in_tera_bytes.setter
    def expected_data_size_in_tera_bytes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "expected_data_size_in_tera_bytes", value)

    @property
    @pulumi.getter(name="importDiskDetailsCollection")
    def import_disk_details_collection(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['ImportDiskDetailsArgs']]]]:
        """
        Contains the map of disk serial number to the disk details for import jobs.
        """
        return pulumi.get(self, "import_disk_details_collection")

    @import_disk_details_collection.setter
    def import_disk_details_collection(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['ImportDiskDetailsArgs']]]]):
        pulumi.set(self, "import_disk_details_collection", value)

    @property
    @pulumi.getter(name="keyEncryptionKey")
    def key_encryption_key(self) -> Optional[pulumi.Input['KeyEncryptionKeyArgs']]:
        """
        Details about which key encryption type is being used.
        """
        return pulumi.get(self, "key_encryption_key")

    @key_encryption_key.setter
    def key_encryption_key(self, value: Optional[pulumi.Input['KeyEncryptionKeyArgs']]):
        pulumi.set(self, "key_encryption_key", value)

    @property
    @pulumi.getter
    def preferences(self) -> Optional[pulumi.Input['PreferencesArgs']]:
        """
        Preferences for the order.
        """
        return pulumi.get(self, "preferences")

    @preferences.setter
    def preferences(self, value: Optional[pulumi.Input['PreferencesArgs']]):
        pulumi.set(self, "preferences", value)

    @property
    @pulumi.getter(name="shippingAddress")
    def shipping_address(self) -> Optional[pulumi.Input['ShippingAddressArgs']]:
        """
        Shipping address of the customer.
        """
        return pulumi.get(self, "shipping_address")

    @shipping_address.setter
    def shipping_address(self, value: Optional[pulumi.Input['ShippingAddressArgs']]):
        pulumi.set(self, "shipping_address", value)


@pulumi.input_type
class DataBoxDiskJobDetailsArgs:
    def __init__(__self__, *,
                 contact_details: pulumi.Input['ContactDetailsArgs'],
                 job_details_type: pulumi.Input[str],
                 data_export_details: Optional[pulumi.Input[Sequence[pulumi.Input['DataExportDetailsArgs']]]] = None,
                 data_import_details: Optional[pulumi.Input[Sequence[pulumi.Input['DataImportDetailsArgs']]]] = None,
                 expected_data_size_in_tera_bytes: Optional[pulumi.Input[int]] = None,
                 key_encryption_key: Optional[pulumi.Input['KeyEncryptionKeyArgs']] = None,
                 passkey: Optional[pulumi.Input[str]] = None,
                 preferences: Optional[pulumi.Input['PreferencesArgs']] = None,
                 preferred_disks: Optional[pulumi.Input[Mapping[str, pulumi.Input[int]]]] = None,
                 shipping_address: Optional[pulumi.Input['ShippingAddressArgs']] = None):
        """
        DataBox Disk Job Details.
        :param pulumi.Input['ContactDetailsArgs'] contact_details: Contact details for notification and shipping.
        :param pulumi.Input[str] job_details_type: Indicates the type of job details.
               Expected value is 'DataBoxDisk'.
        :param pulumi.Input[Sequence[pulumi.Input['DataExportDetailsArgs']]] data_export_details: Details of the data to be exported from azure.
        :param pulumi.Input[Sequence[pulumi.Input['DataImportDetailsArgs']]] data_import_details: Details of the data to be imported into azure.
        :param pulumi.Input[int] expected_data_size_in_tera_bytes: The expected size of the data, which needs to be transferred in this job, in terabytes.
        :param pulumi.Input['KeyEncryptionKeyArgs'] key_encryption_key: Details about which key encryption type is being used.
        :param pulumi.Input[str] passkey: User entered passkey for DataBox Disk job.
        :param pulumi.Input['PreferencesArgs'] preferences: Preferences for the order.
        :param pulumi.Input[Mapping[str, pulumi.Input[int]]] preferred_disks: User preference on what size disks are needed for the job. The map is from the disk size in TB to the count. Eg. {2,5} means 5 disks of 2 TB size. Key is string but will be checked against an int.
        :param pulumi.Input['ShippingAddressArgs'] shipping_address: Shipping address of the customer.
        """
        pulumi.set(__self__, "contact_details", contact_details)
        pulumi.set(__self__, "job_details_type", 'DataBoxDisk')
        if data_export_details is not None:
            pulumi.set(__self__, "data_export_details", data_export_details)
        if data_import_details is not None:
            pulumi.set(__self__, "data_import_details", data_import_details)
        if expected_data_size_in_tera_bytes is not None:
            pulumi.set(__self__, "expected_data_size_in_tera_bytes", expected_data_size_in_tera_bytes)
        if key_encryption_key is not None:
            pulumi.set(__self__, "key_encryption_key", key_encryption_key)
        if passkey is not None:
            pulumi.set(__self__, "passkey", passkey)
        if preferences is not None:
            pulumi.set(__self__, "preferences", preferences)
        if preferred_disks is not None:
            pulumi.set(__self__, "preferred_disks", preferred_disks)
        if shipping_address is not None:
            pulumi.set(__self__, "shipping_address", shipping_address)

    @property
    @pulumi.getter(name="contactDetails")
    def contact_details(self) -> pulumi.Input['ContactDetailsArgs']:
        """
        Contact details for notification and shipping.
        """
        return pulumi.get(self, "contact_details")

    @contact_details.setter
    def contact_details(self, value: pulumi.Input['ContactDetailsArgs']):
        pulumi.set(self, "contact_details", value)

    @property
    @pulumi.getter(name="jobDetailsType")
    def job_details_type(self) -> pulumi.Input[str]:
        """
        Indicates the type of job details.
        Expected value is 'DataBoxDisk'.
        """
        return pulumi.get(self, "job_details_type")

    @job_details_type.setter
    def job_details_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "job_details_type", value)

    @property
    @pulumi.getter(name="dataExportDetails")
    def data_export_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DataExportDetailsArgs']]]]:
        """
        Details of the data to be exported from azure.
        """
        return pulumi.get(self, "data_export_details")

    @data_export_details.setter
    def data_export_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DataExportDetailsArgs']]]]):
        pulumi.set(self, "data_export_details", value)

    @property
    @pulumi.getter(name="dataImportDetails")
    def data_import_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DataImportDetailsArgs']]]]:
        """
        Details of the data to be imported into azure.
        """
        return pulumi.get(self, "data_import_details")

    @data_import_details.setter
    def data_import_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DataImportDetailsArgs']]]]):
        pulumi.set(self, "data_import_details", value)

    @property
    @pulumi.getter(name="expectedDataSizeInTeraBytes")
    def expected_data_size_in_tera_bytes(self) -> Optional[pulumi.Input[int]]:
        """
        The expected size of the data, which needs to be transferred in this job, in terabytes.
        """
        return pulumi.get(self, "expected_data_size_in_tera_bytes")

    @expected_data_size_in_tera_bytes.setter
    def expected_data_size_in_tera_bytes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "expected_data_size_in_tera_bytes", value)

    @property
    @pulumi.getter(name="keyEncryptionKey")
    def key_encryption_key(self) -> Optional[pulumi.Input['KeyEncryptionKeyArgs']]:
        """
        Details about which key encryption type is being used.
        """
        return pulumi.get(self, "key_encryption_key")

    @key_encryption_key.setter
    def key_encryption_key(self, value: Optional[pulumi.Input['KeyEncryptionKeyArgs']]):
        pulumi.set(self, "key_encryption_key", value)

    @property
    @pulumi.getter
    def passkey(self) -> Optional[pulumi.Input[str]]:
        """
        User entered passkey for DataBox Disk job.
        """
        return pulumi.get(self, "passkey")

    @passkey.setter
    def passkey(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "passkey", value)

    @property
    @pulumi.getter
    def preferences(self) -> Optional[pulumi.Input['PreferencesArgs']]:
        """
        Preferences for the order.
        """
        return pulumi.get(self, "preferences")

    @preferences.setter
    def preferences(self, value: Optional[pulumi.Input['PreferencesArgs']]):
        pulumi.set(self, "preferences", value)

    @property
    @pulumi.getter(name="preferredDisks")
    def preferred_disks(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[int]]]]:
        """
        User preference on what size disks are needed for the job. The map is from the disk size in TB to the count. Eg. {2,5} means 5 disks of 2 TB size. Key is string but will be checked against an int.
        """
        return pulumi.get(self, "preferred_disks")

    @preferred_disks.setter
    def preferred_disks(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[int]]]]):
        pulumi.set(self, "preferred_disks", value)

    @property
    @pulumi.getter(name="shippingAddress")
    def shipping_address(self) -> Optional[pulumi.Input['ShippingAddressArgs']]:
        """
        Shipping address of the customer.
        """
        return pulumi.get(self, "shipping_address")

    @shipping_address.setter
    def shipping_address(self, value: Optional[pulumi.Input['ShippingAddressArgs']]):
        pulumi.set(self, "shipping_address", value)


@pulumi.input_type
class DataBoxHeavyJobDetailsArgs:
    def __init__(__self__, *,
                 contact_details: pulumi.Input['ContactDetailsArgs'],
                 job_details_type: pulumi.Input[str],
                 data_export_details: Optional[pulumi.Input[Sequence[pulumi.Input['DataExportDetailsArgs']]]] = None,
                 data_import_details: Optional[pulumi.Input[Sequence[pulumi.Input['DataImportDetailsArgs']]]] = None,
                 device_password: Optional[pulumi.Input[str]] = None,
                 expected_data_size_in_tera_bytes: Optional[pulumi.Input[int]] = None,
                 key_encryption_key: Optional[pulumi.Input['KeyEncryptionKeyArgs']] = None,
                 preferences: Optional[pulumi.Input['PreferencesArgs']] = None,
                 shipping_address: Optional[pulumi.Input['ShippingAddressArgs']] = None):
        """
        Databox Heavy Device Job Details
        :param pulumi.Input['ContactDetailsArgs'] contact_details: Contact details for notification and shipping.
        :param pulumi.Input[str] job_details_type: Indicates the type of job details.
               Expected value is 'DataBoxHeavy'.
        :param pulumi.Input[Sequence[pulumi.Input['DataExportDetailsArgs']]] data_export_details: Details of the data to be exported from azure.
        :param pulumi.Input[Sequence[pulumi.Input['DataImportDetailsArgs']]] data_import_details: Details of the data to be imported into azure.
        :param pulumi.Input[str] device_password: Set Device password for unlocking Databox Heavy. Should not be passed for TransferType:ExportFromAzure jobs. If this is not passed, the service will generate password itself. This will not be returned in Get Call. Password Requirements :  Password must be minimum of 12 and maximum of 64 characters. Password must have at least one uppercase alphabet, one number and one special character. Password cannot have the following characters : IilLoO0 Password can have only alphabets, numbers and these characters : @#\\-$%^!+=;:_()]+
        :param pulumi.Input[int] expected_data_size_in_tera_bytes: The expected size of the data, which needs to be transferred in this job, in terabytes.
        :param pulumi.Input['KeyEncryptionKeyArgs'] key_encryption_key: Details about which key encryption type is being used.
        :param pulumi.Input['PreferencesArgs'] preferences: Preferences for the order.
        :param pulumi.Input['ShippingAddressArgs'] shipping_address: Shipping address of the customer.
        """
        pulumi.set(__self__, "contact_details", contact_details)
        pulumi.set(__self__, "job_details_type", 'DataBoxHeavy')
        if data_export_details is not None:
            pulumi.set(__self__, "data_export_details", data_export_details)
        if data_import_details is not None:
            pulumi.set(__self__, "data_import_details", data_import_details)
        if device_password is not None:
            pulumi.set(__self__, "device_password", device_password)
        if expected_data_size_in_tera_bytes is not None:
            pulumi.set(__self__, "expected_data_size_in_tera_bytes", expected_data_size_in_tera_bytes)
        if key_encryption_key is not None:
            pulumi.set(__self__, "key_encryption_key", key_encryption_key)
        if preferences is not None:
            pulumi.set(__self__, "preferences", preferences)
        if shipping_address is not None:
            pulumi.set(__self__, "shipping_address", shipping_address)

    @property
    @pulumi.getter(name="contactDetails")
    def contact_details(self) -> pulumi.Input['ContactDetailsArgs']:
        """
        Contact details for notification and shipping.
        """
        return pulumi.get(self, "contact_details")

    @contact_details.setter
    def contact_details(self, value: pulumi.Input['ContactDetailsArgs']):
        pulumi.set(self, "contact_details", value)

    @property
    @pulumi.getter(name="jobDetailsType")
    def job_details_type(self) -> pulumi.Input[str]:
        """
        Indicates the type of job details.
        Expected value is 'DataBoxHeavy'.
        """
        return pulumi.get(self, "job_details_type")

    @job_details_type.setter
    def job_details_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "job_details_type", value)

    @property
    @pulumi.getter(name="dataExportDetails")
    def data_export_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DataExportDetailsArgs']]]]:
        """
        Details of the data to be exported from azure.
        """
        return pulumi.get(self, "data_export_details")

    @data_export_details.setter
    def data_export_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DataExportDetailsArgs']]]]):
        pulumi.set(self, "data_export_details", value)

    @property
    @pulumi.getter(name="dataImportDetails")
    def data_import_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DataImportDetailsArgs']]]]:
        """
        Details of the data to be imported into azure.
        """
        return pulumi.get(self, "data_import_details")

    @data_import_details.setter
    def data_import_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DataImportDetailsArgs']]]]):
        pulumi.set(self, "data_import_details", value)

    @property
    @pulumi.getter(name="devicePassword")
    def device_password(self) -> Optional[pulumi.Input[str]]:
        """
        Set Device password for unlocking Databox Heavy. Should not be passed for TransferType:ExportFromAzure jobs. If this is not passed, the service will generate password itself. This will not be returned in Get Call. Password Requirements :  Password must be minimum of 12 and maximum of 64 characters. Password must have at least one uppercase alphabet, one number and one special character. Password cannot have the following characters : IilLoO0 Password can have only alphabets, numbers and these characters : @#\\-$%^!+=;:_()]+
        """
        return pulumi.get(self, "device_password")

    @device_password.setter
    def device_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "device_password", value)

    @property
    @pulumi.getter(name="expectedDataSizeInTeraBytes")
    def expected_data_size_in_tera_bytes(self) -> Optional[pulumi.Input[int]]:
        """
        The expected size of the data, which needs to be transferred in this job, in terabytes.
        """
        return pulumi.get(self, "expected_data_size_in_tera_bytes")

    @expected_data_size_in_tera_bytes.setter
    def expected_data_size_in_tera_bytes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "expected_data_size_in_tera_bytes", value)

    @property
    @pulumi.getter(name="keyEncryptionKey")
    def key_encryption_key(self) -> Optional[pulumi.Input['KeyEncryptionKeyArgs']]:
        """
        Details about which key encryption type is being used.
        """
        return pulumi.get(self, "key_encryption_key")

    @key_encryption_key.setter
    def key_encryption_key(self, value: Optional[pulumi.Input['KeyEncryptionKeyArgs']]):
        pulumi.set(self, "key_encryption_key", value)

    @property
    @pulumi.getter
    def preferences(self) -> Optional[pulumi.Input['PreferencesArgs']]:
        """
        Preferences for the order.
        """
        return pulumi.get(self, "preferences")

    @preferences.setter
    def preferences(self, value: Optional[pulumi.Input['PreferencesArgs']]):
        pulumi.set(self, "preferences", value)

    @property
    @pulumi.getter(name="shippingAddress")
    def shipping_address(self) -> Optional[pulumi.Input['ShippingAddressArgs']]:
        """
        Shipping address of the customer.
        """
        return pulumi.get(self, "shipping_address")

    @shipping_address.setter
    def shipping_address(self, value: Optional[pulumi.Input['ShippingAddressArgs']]):
        pulumi.set(self, "shipping_address", value)


@pulumi.input_type
class DataBoxJobDetailsArgs:
    def __init__(__self__, *,
                 contact_details: pulumi.Input['ContactDetailsArgs'],
                 job_details_type: pulumi.Input[str],
                 data_export_details: Optional[pulumi.Input[Sequence[pulumi.Input['DataExportDetailsArgs']]]] = None,
                 data_import_details: Optional[pulumi.Input[Sequence[pulumi.Input['DataImportDetailsArgs']]]] = None,
                 device_password: Optional[pulumi.Input[str]] = None,
                 expected_data_size_in_tera_bytes: Optional[pulumi.Input[int]] = None,
                 key_encryption_key: Optional[pulumi.Input['KeyEncryptionKeyArgs']] = None,
                 preferences: Optional[pulumi.Input['PreferencesArgs']] = None,
                 shipping_address: Optional[pulumi.Input['ShippingAddressArgs']] = None):
        """
        Databox Job Details
        :param pulumi.Input['ContactDetailsArgs'] contact_details: Contact details for notification and shipping.
        :param pulumi.Input[str] job_details_type: Indicates the type of job details.
               Expected value is 'DataBox'.
        :param pulumi.Input[Sequence[pulumi.Input['DataExportDetailsArgs']]] data_export_details: Details of the data to be exported from azure.
        :param pulumi.Input[Sequence[pulumi.Input['DataImportDetailsArgs']]] data_import_details: Details of the data to be imported into azure.
        :param pulumi.Input[str] device_password: Set Device password for unlocking Databox. Should not be passed for TransferType:ExportFromAzure jobs. If this is not passed, the service will generate password itself. This will not be returned in Get Call. Password Requirements :  Password must be minimum of 12 and maximum of 64 characters. Password must have at least one uppercase alphabet, one number and one special character. Password cannot have the following characters : IilLoO0 Password can have only alphabets, numbers and these characters : @#\\-$%^!+=;:_()]+
        :param pulumi.Input[int] expected_data_size_in_tera_bytes: The expected size of the data, which needs to be transferred in this job, in terabytes.
        :param pulumi.Input['KeyEncryptionKeyArgs'] key_encryption_key: Details about which key encryption type is being used.
        :param pulumi.Input['PreferencesArgs'] preferences: Preferences for the order.
        :param pulumi.Input['ShippingAddressArgs'] shipping_address: Shipping address of the customer.
        """
        pulumi.set(__self__, "contact_details", contact_details)
        pulumi.set(__self__, "job_details_type", 'DataBox')
        if data_export_details is not None:
            pulumi.set(__self__, "data_export_details", data_export_details)
        if data_import_details is not None:
            pulumi.set(__self__, "data_import_details", data_import_details)
        if device_password is not None:
            pulumi.set(__self__, "device_password", device_password)
        if expected_data_size_in_tera_bytes is not None:
            pulumi.set(__self__, "expected_data_size_in_tera_bytes", expected_data_size_in_tera_bytes)
        if key_encryption_key is not None:
            pulumi.set(__self__, "key_encryption_key", key_encryption_key)
        if preferences is not None:
            pulumi.set(__self__, "preferences", preferences)
        if shipping_address is not None:
            pulumi.set(__self__, "shipping_address", shipping_address)

    @property
    @pulumi.getter(name="contactDetails")
    def contact_details(self) -> pulumi.Input['ContactDetailsArgs']:
        """
        Contact details for notification and shipping.
        """
        return pulumi.get(self, "contact_details")

    @contact_details.setter
    def contact_details(self, value: pulumi.Input['ContactDetailsArgs']):
        pulumi.set(self, "contact_details", value)

    @property
    @pulumi.getter(name="jobDetailsType")
    def job_details_type(self) -> pulumi.Input[str]:
        """
        Indicates the type of job details.
        Expected value is 'DataBox'.
        """
        return pulumi.get(self, "job_details_type")

    @job_details_type.setter
    def job_details_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "job_details_type", value)

    @property
    @pulumi.getter(name="dataExportDetails")
    def data_export_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DataExportDetailsArgs']]]]:
        """
        Details of the data to be exported from azure.
        """
        return pulumi.get(self, "data_export_details")

    @data_export_details.setter
    def data_export_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DataExportDetailsArgs']]]]):
        pulumi.set(self, "data_export_details", value)

    @property
    @pulumi.getter(name="dataImportDetails")
    def data_import_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DataImportDetailsArgs']]]]:
        """
        Details of the data to be imported into azure.
        """
        return pulumi.get(self, "data_import_details")

    @data_import_details.setter
    def data_import_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DataImportDetailsArgs']]]]):
        pulumi.set(self, "data_import_details", value)

    @property
    @pulumi.getter(name="devicePassword")
    def device_password(self) -> Optional[pulumi.Input[str]]:
        """
        Set Device password for unlocking Databox. Should not be passed for TransferType:ExportFromAzure jobs. If this is not passed, the service will generate password itself. This will not be returned in Get Call. Password Requirements :  Password must be minimum of 12 and maximum of 64 characters. Password must have at least one uppercase alphabet, one number and one special character. Password cannot have the following characters : IilLoO0 Password can have only alphabets, numbers and these characters : @#\\-$%^!+=;:_()]+
        """
        return pulumi.get(self, "device_password")

    @device_password.setter
    def device_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "device_password", value)

    @property
    @pulumi.getter(name="expectedDataSizeInTeraBytes")
    def expected_data_size_in_tera_bytes(self) -> Optional[pulumi.Input[int]]:
        """
        The expected size of the data, which needs to be transferred in this job, in terabytes.
        """
        return pulumi.get(self, "expected_data_size_in_tera_bytes")

    @expected_data_size_in_tera_bytes.setter
    def expected_data_size_in_tera_bytes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "expected_data_size_in_tera_bytes", value)

    @property
    @pulumi.getter(name="keyEncryptionKey")
    def key_encryption_key(self) -> Optional[pulumi.Input['KeyEncryptionKeyArgs']]:
        """
        Details about which key encryption type is being used.
        """
        return pulumi.get(self, "key_encryption_key")

    @key_encryption_key.setter
    def key_encryption_key(self, value: Optional[pulumi.Input['KeyEncryptionKeyArgs']]):
        pulumi.set(self, "key_encryption_key", value)

    @property
    @pulumi.getter
    def preferences(self) -> Optional[pulumi.Input['PreferencesArgs']]:
        """
        Preferences for the order.
        """
        return pulumi.get(self, "preferences")

    @preferences.setter
    def preferences(self, value: Optional[pulumi.Input['PreferencesArgs']]):
        pulumi.set(self, "preferences", value)

    @property
    @pulumi.getter(name="shippingAddress")
    def shipping_address(self) -> Optional[pulumi.Input['ShippingAddressArgs']]:
        """
        Shipping address of the customer.
        """
        return pulumi.get(self, "shipping_address")

    @shipping_address.setter
    def shipping_address(self, value: Optional[pulumi.Input['ShippingAddressArgs']]):
        pulumi.set(self, "shipping_address", value)


@pulumi.input_type
class DataExportDetailsArgs:
    def __init__(__self__, *,
                 account_details: pulumi.Input[Union['ManagedDiskDetailsArgs', 'StorageAccountDetailsArgs']],
                 transfer_configuration: pulumi.Input['TransferConfigurationArgs'],
                 log_collection_level: Optional[pulumi.Input[Union[str, 'LogCollectionLevel']]] = None):
        """
        Details of the data to be used for exporting data from azure.
        :param pulumi.Input[Union['ManagedDiskDetailsArgs', 'StorageAccountDetailsArgs']] account_details: Account details of the data to be transferred
        :param pulumi.Input['TransferConfigurationArgs'] transfer_configuration: Configuration for the data transfer.
        :param pulumi.Input[Union[str, 'LogCollectionLevel']] log_collection_level: Level of the logs to be collected.
        """
        pulumi.set(__self__, "account_details", account_details)
        pulumi.set(__self__, "transfer_configuration", transfer_configuration)
        if log_collection_level is None:
            log_collection_level = 'Error'
        if log_collection_level is not None:
            pulumi.set(__self__, "log_collection_level", log_collection_level)

    @property
    @pulumi.getter(name="accountDetails")
    def account_details(self) -> pulumi.Input[Union['ManagedDiskDetailsArgs', 'StorageAccountDetailsArgs']]:
        """
        Account details of the data to be transferred
        """
        return pulumi.get(self, "account_details")

    @account_details.setter
    def account_details(self, value: pulumi.Input[Union['ManagedDiskDetailsArgs', 'StorageAccountDetailsArgs']]):
        pulumi.set(self, "account_details", value)

    @property
    @pulumi.getter(name="transferConfiguration")
    def transfer_configuration(self) -> pulumi.Input['TransferConfigurationArgs']:
        """
        Configuration for the data transfer.
        """
        return pulumi.get(self, "transfer_configuration")

    @transfer_configuration.setter
    def transfer_configuration(self, value: pulumi.Input['TransferConfigurationArgs']):
        pulumi.set(self, "transfer_configuration", value)

    @property
    @pulumi.getter(name="logCollectionLevel")
    def log_collection_level(self) -> Optional[pulumi.Input[Union[str, 'LogCollectionLevel']]]:
        """
        Level of the logs to be collected.
        """
        return pulumi.get(self, "log_collection_level")

    @log_collection_level.setter
    def log_collection_level(self, value: Optional[pulumi.Input[Union[str, 'LogCollectionLevel']]]):
        pulumi.set(self, "log_collection_level", value)


@pulumi.input_type
class DataImportDetailsArgs:
    def __init__(__self__, *,
                 account_details: pulumi.Input[Union['ManagedDiskDetailsArgs', 'StorageAccountDetailsArgs']],
                 log_collection_level: Optional[pulumi.Input[Union[str, 'LogCollectionLevel']]] = None):
        """
        Details of the data to be used for importing data to azure.
        :param pulumi.Input[Union['ManagedDiskDetailsArgs', 'StorageAccountDetailsArgs']] account_details: Account details of the data to be transferred
        :param pulumi.Input[Union[str, 'LogCollectionLevel']] log_collection_level: Level of the logs to be collected.
        """
        pulumi.set(__self__, "account_details", account_details)
        if log_collection_level is None:
            log_collection_level = 'Error'
        if log_collection_level is not None:
            pulumi.set(__self__, "log_collection_level", log_collection_level)

    @property
    @pulumi.getter(name="accountDetails")
    def account_details(self) -> pulumi.Input[Union['ManagedDiskDetailsArgs', 'StorageAccountDetailsArgs']]:
        """
        Account details of the data to be transferred
        """
        return pulumi.get(self, "account_details")

    @account_details.setter
    def account_details(self, value: pulumi.Input[Union['ManagedDiskDetailsArgs', 'StorageAccountDetailsArgs']]):
        pulumi.set(self, "account_details", value)

    @property
    @pulumi.getter(name="logCollectionLevel")
    def log_collection_level(self) -> Optional[pulumi.Input[Union[str, 'LogCollectionLevel']]]:
        """
        Level of the logs to be collected.
        """
        return pulumi.get(self, "log_collection_level")

    @log_collection_level.setter
    def log_collection_level(self, value: Optional[pulumi.Input[Union[str, 'LogCollectionLevel']]]):
        pulumi.set(self, "log_collection_level", value)


@pulumi.input_type
class EncryptionPreferencesArgs:
    def __init__(__self__, *,
                 double_encryption: Optional[pulumi.Input[Union[str, 'DoubleEncryption']]] = None):
        """
        Preferences related to the Encryption.
        :param pulumi.Input[Union[str, 'DoubleEncryption']] double_encryption: Defines secondary layer of software-based encryption enablement.
        """
        if double_encryption is None:
            double_encryption = 'Disabled'
        if double_encryption is not None:
            pulumi.set(__self__, "double_encryption", double_encryption)

    @property
    @pulumi.getter(name="doubleEncryption")
    def double_encryption(self) -> Optional[pulumi.Input[Union[str, 'DoubleEncryption']]]:
        """
        Defines secondary layer of software-based encryption enablement.
        """
        return pulumi.get(self, "double_encryption")

    @double_encryption.setter
    def double_encryption(self, value: Optional[pulumi.Input[Union[str, 'DoubleEncryption']]]):
        pulumi.set(self, "double_encryption", value)


@pulumi.input_type
class FilterFileDetailsArgs:
    def __init__(__self__, *,
                 filter_file_path: pulumi.Input[str],
                 filter_file_type: pulumi.Input[Union[str, 'FilterFileType']]):
        """
        Details of the filter files to be used for data transfer.
        :param pulumi.Input[str] filter_file_path: Path of the file that contains the details of all items to transfer.
        :param pulumi.Input[Union[str, 'FilterFileType']] filter_file_type: Type of the filter file.
        """
        pulumi.set(__self__, "filter_file_path", filter_file_path)
        pulumi.set(__self__, "filter_file_type", filter_file_type)

    @property
    @pulumi.getter(name="filterFilePath")
    def filter_file_path(self) -> pulumi.Input[str]:
        """
        Path of the file that contains the details of all items to transfer.
        """
        return pulumi.get(self, "filter_file_path")

    @filter_file_path.setter
    def filter_file_path(self, value: pulumi.Input[str]):
        pulumi.set(self, "filter_file_path", value)

    @property
    @pulumi.getter(name="filterFileType")
    def filter_file_type(self) -> pulumi.Input[Union[str, 'FilterFileType']]:
        """
        Type of the filter file.
        """
        return pulumi.get(self, "filter_file_type")

    @filter_file_type.setter
    def filter_file_type(self, value: pulumi.Input[Union[str, 'FilterFileType']]):
        pulumi.set(self, "filter_file_type", value)


@pulumi.input_type
class IdentityPropertiesArgs:
    def __init__(__self__, *,
                 type: Optional[pulumi.Input[str]] = None,
                 user_assigned: Optional[pulumi.Input['UserAssignedPropertiesArgs']] = None):
        """
        Managed identity properties.
        :param pulumi.Input[str] type: Managed service identity type.
        :param pulumi.Input['UserAssignedPropertiesArgs'] user_assigned: User assigned identity properties.
        """
        if type is not None:
            pulumi.set(__self__, "type", type)
        if user_assigned is not None:
            pulumi.set(__self__, "user_assigned", user_assigned)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Managed service identity type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="userAssigned")
    def user_assigned(self) -> Optional[pulumi.Input['UserAssignedPropertiesArgs']]:
        """
        User assigned identity properties.
        """
        return pulumi.get(self, "user_assigned")

    @user_assigned.setter
    def user_assigned(self, value: Optional[pulumi.Input['UserAssignedPropertiesArgs']]):
        pulumi.set(self, "user_assigned", value)


@pulumi.input_type
class ImportDiskDetailsArgs:
    def __init__(__self__, *,
                 bit_locker_key: pulumi.Input[str],
                 manifest_file: pulumi.Input[str],
                 manifest_hash: pulumi.Input[str]):
        """
        Import disk details
        :param pulumi.Input[str] bit_locker_key: BitLocker key used to encrypt the disk.
        :param pulumi.Input[str] manifest_file: The relative path of the manifest file on the disk.
        :param pulumi.Input[str] manifest_hash: The Base16-encoded MD5 hash of the manifest file on the disk.
        """
        pulumi.set(__self__, "bit_locker_key", bit_locker_key)
        pulumi.set(__self__, "manifest_file", manifest_file)
        pulumi.set(__self__, "manifest_hash", manifest_hash)

    @property
    @pulumi.getter(name="bitLockerKey")
    def bit_locker_key(self) -> pulumi.Input[str]:
        """
        BitLocker key used to encrypt the disk.
        """
        return pulumi.get(self, "bit_locker_key")

    @bit_locker_key.setter
    def bit_locker_key(self, value: pulumi.Input[str]):
        pulumi.set(self, "bit_locker_key", value)

    @property
    @pulumi.getter(name="manifestFile")
    def manifest_file(self) -> pulumi.Input[str]:
        """
        The relative path of the manifest file on the disk.
        """
        return pulumi.get(self, "manifest_file")

    @manifest_file.setter
    def manifest_file(self, value: pulumi.Input[str]):
        pulumi.set(self, "manifest_file", value)

    @property
    @pulumi.getter(name="manifestHash")
    def manifest_hash(self) -> pulumi.Input[str]:
        """
        The Base16-encoded MD5 hash of the manifest file on the disk.
        """
        return pulumi.get(self, "manifest_hash")

    @manifest_hash.setter
    def manifest_hash(self, value: pulumi.Input[str]):
        pulumi.set(self, "manifest_hash", value)


@pulumi.input_type
class JobDeliveryInfoArgs:
    def __init__(__self__, *,
                 scheduled_date_time: Optional[pulumi.Input[str]] = None):
        """
        Additional delivery info.
        :param pulumi.Input[str] scheduled_date_time: Scheduled date time.
        """
        if scheduled_date_time is not None:
            pulumi.set(__self__, "scheduled_date_time", scheduled_date_time)

    @property
    @pulumi.getter(name="scheduledDateTime")
    def scheduled_date_time(self) -> Optional[pulumi.Input[str]]:
        """
        Scheduled date time.
        """
        return pulumi.get(self, "scheduled_date_time")

    @scheduled_date_time.setter
    def scheduled_date_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scheduled_date_time", value)


@pulumi.input_type
class KeyEncryptionKeyArgs:
    def __init__(__self__, *,
                 kek_type: pulumi.Input[Union[str, 'KekType']],
                 identity_properties: Optional[pulumi.Input['IdentityPropertiesArgs']] = None,
                 kek_url: Optional[pulumi.Input[str]] = None,
                 kek_vault_resource_id: Optional[pulumi.Input[str]] = None):
        """
        Encryption key containing details about key to encrypt different keys.
        :param pulumi.Input[Union[str, 'KekType']] kek_type: Type of encryption key used for key encryption.
        :param pulumi.Input['IdentityPropertiesArgs'] identity_properties: Managed identity properties used for key encryption.
        :param pulumi.Input[str] kek_url: Key encryption key. It is required in case of Customer managed KekType.
        :param pulumi.Input[str] kek_vault_resource_id: Kek vault resource id. It is required in case of Customer managed KekType.
        """
        if kek_type is None:
            kek_type = 'MicrosoftManaged'
        pulumi.set(__self__, "kek_type", kek_type)
        if identity_properties is not None:
            pulumi.set(__self__, "identity_properties", identity_properties)
        if kek_url is not None:
            pulumi.set(__self__, "kek_url", kek_url)
        if kek_vault_resource_id is not None:
            pulumi.set(__self__, "kek_vault_resource_id", kek_vault_resource_id)

    @property
    @pulumi.getter(name="kekType")
    def kek_type(self) -> pulumi.Input[Union[str, 'KekType']]:
        """
        Type of encryption key used for key encryption.
        """
        return pulumi.get(self, "kek_type")

    @kek_type.setter
    def kek_type(self, value: pulumi.Input[Union[str, 'KekType']]):
        pulumi.set(self, "kek_type", value)

    @property
    @pulumi.getter(name="identityProperties")
    def identity_properties(self) -> Optional[pulumi.Input['IdentityPropertiesArgs']]:
        """
        Managed identity properties used for key encryption.
        """
        return pulumi.get(self, "identity_properties")

    @identity_properties.setter
    def identity_properties(self, value: Optional[pulumi.Input['IdentityPropertiesArgs']]):
        pulumi.set(self, "identity_properties", value)

    @property
    @pulumi.getter(name="kekUrl")
    def kek_url(self) -> Optional[pulumi.Input[str]]:
        """
        Key encryption key. It is required in case of Customer managed KekType.
        """
        return pulumi.get(self, "kek_url")

    @kek_url.setter
    def kek_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kek_url", value)

    @property
    @pulumi.getter(name="kekVaultResourceID")
    def kek_vault_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        Kek vault resource id. It is required in case of Customer managed KekType.
        """
        return pulumi.get(self, "kek_vault_resource_id")

    @kek_vault_resource_id.setter
    def kek_vault_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kek_vault_resource_id", value)


@pulumi.input_type
class ManagedDiskDetailsArgs:
    def __init__(__self__, *,
                 data_account_type: pulumi.Input[str],
                 resource_group_id: pulumi.Input[str],
                 staging_storage_account_id: pulumi.Input[str],
                 share_password: Optional[pulumi.Input[str]] = None):
        """
        Details of the managed disks.
        :param pulumi.Input[str] data_account_type: Account Type of the data to be transferred.
               Expected value is 'ManagedDisk'.
        :param pulumi.Input[str] resource_group_id: Resource Group Id of the compute disks.
        :param pulumi.Input[str] staging_storage_account_id: Resource Id of the storage account that can be used to copy the vhd for staging.
        :param pulumi.Input[str] share_password: Password for all the shares to be created on the device. Should not be passed for TransferType:ExportFromAzure jobs. If this is not passed, the service will generate password itself. This will not be returned in Get Call. Password Requirements :  Password must be minimum of 12 and maximum of 64 characters. Password must have at least one uppercase alphabet, one number and one special character. Password cannot have the following characters : IilLoO0 Password can have only alphabets, numbers and these characters : @#\\-$%^!+=;:_()]+
        """
        if data_account_type is None:
            data_account_type = 'StorageAccount'
        pulumi.set(__self__, "data_account_type", 'ManagedDisk')
        pulumi.set(__self__, "resource_group_id", resource_group_id)
        pulumi.set(__self__, "staging_storage_account_id", staging_storage_account_id)
        if share_password is not None:
            pulumi.set(__self__, "share_password", share_password)

    @property
    @pulumi.getter(name="dataAccountType")
    def data_account_type(self) -> pulumi.Input[str]:
        """
        Account Type of the data to be transferred.
        Expected value is 'ManagedDisk'.
        """
        return pulumi.get(self, "data_account_type")

    @data_account_type.setter
    def data_account_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "data_account_type", value)

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Input[str]:
        """
        Resource Group Id of the compute disks.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_group_id", value)

    @property
    @pulumi.getter(name="stagingStorageAccountId")
    def staging_storage_account_id(self) -> pulumi.Input[str]:
        """
        Resource Id of the storage account that can be used to copy the vhd for staging.
        """
        return pulumi.get(self, "staging_storage_account_id")

    @staging_storage_account_id.setter
    def staging_storage_account_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "staging_storage_account_id", value)

    @property
    @pulumi.getter(name="sharePassword")
    def share_password(self) -> Optional[pulumi.Input[str]]:
        """
        Password for all the shares to be created on the device. Should not be passed for TransferType:ExportFromAzure jobs. If this is not passed, the service will generate password itself. This will not be returned in Get Call. Password Requirements :  Password must be minimum of 12 and maximum of 64 characters. Password must have at least one uppercase alphabet, one number and one special character. Password cannot have the following characters : IilLoO0 Password can have only alphabets, numbers and these characters : @#\\-$%^!+=;:_()]+
        """
        return pulumi.get(self, "share_password")

    @share_password.setter
    def share_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "share_password", value)


@pulumi.input_type
class NotificationPreferenceArgs:
    def __init__(__self__, *,
                 send_notification: pulumi.Input[bool],
                 stage_name: pulumi.Input[Union[str, 'NotificationStageName']]):
        """
        Notification preference for a job stage.
        :param pulumi.Input[bool] send_notification: Notification is required or not.
        :param pulumi.Input[Union[str, 'NotificationStageName']] stage_name: Name of the stage.
        """
        if send_notification is None:
            send_notification = True
        pulumi.set(__self__, "send_notification", send_notification)
        pulumi.set(__self__, "stage_name", stage_name)

    @property
    @pulumi.getter(name="sendNotification")
    def send_notification(self) -> pulumi.Input[bool]:
        """
        Notification is required or not.
        """
        return pulumi.get(self, "send_notification")

    @send_notification.setter
    def send_notification(self, value: pulumi.Input[bool]):
        pulumi.set(self, "send_notification", value)

    @property
    @pulumi.getter(name="stageName")
    def stage_name(self) -> pulumi.Input[Union[str, 'NotificationStageName']]:
        """
        Name of the stage.
        """
        return pulumi.get(self, "stage_name")

    @stage_name.setter
    def stage_name(self, value: pulumi.Input[Union[str, 'NotificationStageName']]):
        pulumi.set(self, "stage_name", value)


@pulumi.input_type
class PackageCarrierDetailsArgs:
    def __init__(__self__, *,
                 carrier_account_number: Optional[pulumi.Input[str]] = None,
                 carrier_name: Optional[pulumi.Input[str]] = None,
                 tracking_id: Optional[pulumi.Input[str]] = None):
        """
        Package carrier details.
        :param pulumi.Input[str] carrier_account_number: Carrier Account Number of customer for customer disk.
        :param pulumi.Input[str] carrier_name: Name of the carrier.
        :param pulumi.Input[str] tracking_id: Tracking Id of shipment.
        """
        if carrier_account_number is not None:
            pulumi.set(__self__, "carrier_account_number", carrier_account_number)
        if carrier_name is not None:
            pulumi.set(__self__, "carrier_name", carrier_name)
        if tracking_id is not None:
            pulumi.set(__self__, "tracking_id", tracking_id)

    @property
    @pulumi.getter(name="carrierAccountNumber")
    def carrier_account_number(self) -> Optional[pulumi.Input[str]]:
        """
        Carrier Account Number of customer for customer disk.
        """
        return pulumi.get(self, "carrier_account_number")

    @carrier_account_number.setter
    def carrier_account_number(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "carrier_account_number", value)

    @property
    @pulumi.getter(name="carrierName")
    def carrier_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the carrier.
        """
        return pulumi.get(self, "carrier_name")

    @carrier_name.setter
    def carrier_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "carrier_name", value)

    @property
    @pulumi.getter(name="trackingId")
    def tracking_id(self) -> Optional[pulumi.Input[str]]:
        """
        Tracking Id of shipment.
        """
        return pulumi.get(self, "tracking_id")

    @tracking_id.setter
    def tracking_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tracking_id", value)


@pulumi.input_type
class PreferencesArgs:
    def __init__(__self__, *,
                 encryption_preferences: Optional[pulumi.Input['EncryptionPreferencesArgs']] = None,
                 preferred_data_center_region: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 storage_account_access_tier_preferences: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'StorageAccountAccessTier']]]]] = None,
                 transport_preferences: Optional[pulumi.Input['TransportPreferencesArgs']] = None):
        """
        Preferences related to the order
        :param pulumi.Input['EncryptionPreferencesArgs'] encryption_preferences: Preferences related to the Encryption.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] preferred_data_center_region: Preferred data center region.
        :param pulumi.Input[Sequence[pulumi.Input[Union[str, 'StorageAccountAccessTier']]]] storage_account_access_tier_preferences: Preferences related to the Access Tier of storage accounts.
        :param pulumi.Input['TransportPreferencesArgs'] transport_preferences: Preferences related to the shipment logistics of the sku.
        """
        if encryption_preferences is not None:
            pulumi.set(__self__, "encryption_preferences", encryption_preferences)
        if preferred_data_center_region is not None:
            pulumi.set(__self__, "preferred_data_center_region", preferred_data_center_region)
        if storage_account_access_tier_preferences is not None:
            pulumi.set(__self__, "storage_account_access_tier_preferences", storage_account_access_tier_preferences)
        if transport_preferences is not None:
            pulumi.set(__self__, "transport_preferences", transport_preferences)

    @property
    @pulumi.getter(name="encryptionPreferences")
    def encryption_preferences(self) -> Optional[pulumi.Input['EncryptionPreferencesArgs']]:
        """
        Preferences related to the Encryption.
        """
        return pulumi.get(self, "encryption_preferences")

    @encryption_preferences.setter
    def encryption_preferences(self, value: Optional[pulumi.Input['EncryptionPreferencesArgs']]):
        pulumi.set(self, "encryption_preferences", value)

    @property
    @pulumi.getter(name="preferredDataCenterRegion")
    def preferred_data_center_region(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Preferred data center region.
        """
        return pulumi.get(self, "preferred_data_center_region")

    @preferred_data_center_region.setter
    def preferred_data_center_region(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "preferred_data_center_region", value)

    @property
    @pulumi.getter(name="storageAccountAccessTierPreferences")
    def storage_account_access_tier_preferences(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'StorageAccountAccessTier']]]]]:
        """
        Preferences related to the Access Tier of storage accounts.
        """
        return pulumi.get(self, "storage_account_access_tier_preferences")

    @storage_account_access_tier_preferences.setter
    def storage_account_access_tier_preferences(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'StorageAccountAccessTier']]]]]):
        pulumi.set(self, "storage_account_access_tier_preferences", value)

    @property
    @pulumi.getter(name="transportPreferences")
    def transport_preferences(self) -> Optional[pulumi.Input['TransportPreferencesArgs']]:
        """
        Preferences related to the shipment logistics of the sku.
        """
        return pulumi.get(self, "transport_preferences")

    @transport_preferences.setter
    def transport_preferences(self, value: Optional[pulumi.Input['TransportPreferencesArgs']]):
        pulumi.set(self, "transport_preferences", value)


@pulumi.input_type
class ResourceIdentityArgs:
    def __init__(__self__, *,
                 type: Optional[pulumi.Input[str]] = None,
                 user_assigned_identities: Optional[pulumi.Input[Mapping[str, Any]]] = None):
        """
        Msi identity details of the resource
        :param pulumi.Input[str] type: Identity type
        :param pulumi.Input[Mapping[str, Any]] user_assigned_identities: User Assigned Identities
        """
        if type is None:
            type = 'None'
        if type is not None:
            pulumi.set(__self__, "type", type)
        if user_assigned_identities is not None:
            pulumi.set(__self__, "user_assigned_identities", user_assigned_identities)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Identity type
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="userAssignedIdentities")
    def user_assigned_identities(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        User Assigned Identities
        """
        return pulumi.get(self, "user_assigned_identities")

    @user_assigned_identities.setter
    def user_assigned_identities(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "user_assigned_identities", value)


@pulumi.input_type
class ShippingAddressArgs:
    def __init__(__self__, *,
                 country: pulumi.Input[str],
                 street_address1: pulumi.Input[str],
                 address_type: Optional[pulumi.Input[Union[str, 'AddressType']]] = None,
                 city: Optional[pulumi.Input[str]] = None,
                 company_name: Optional[pulumi.Input[str]] = None,
                 postal_code: Optional[pulumi.Input[str]] = None,
                 state_or_province: Optional[pulumi.Input[str]] = None,
                 street_address2: Optional[pulumi.Input[str]] = None,
                 street_address3: Optional[pulumi.Input[str]] = None,
                 zip_extended_code: Optional[pulumi.Input[str]] = None):
        """
        Shipping address where customer wishes to receive the device.
        :param pulumi.Input[str] country: Name of the Country.
        :param pulumi.Input[str] street_address1: Street Address line 1.
        :param pulumi.Input[Union[str, 'AddressType']] address_type: Type of address.
        :param pulumi.Input[str] city: Name of the City.
        :param pulumi.Input[str] company_name: Name of the company.
        :param pulumi.Input[str] postal_code: Postal code.
        :param pulumi.Input[str] state_or_province: Name of the State or Province.
        :param pulumi.Input[str] street_address2: Street Address line 2.
        :param pulumi.Input[str] street_address3: Street Address line 3.
        :param pulumi.Input[str] zip_extended_code: Extended Zip Code.
        """
        pulumi.set(__self__, "country", country)
        pulumi.set(__self__, "street_address1", street_address1)
        if address_type is None:
            address_type = 'None'
        if address_type is not None:
            pulumi.set(__self__, "address_type", address_type)
        if city is not None:
            pulumi.set(__self__, "city", city)
        if company_name is not None:
            pulumi.set(__self__, "company_name", company_name)
        if postal_code is not None:
            pulumi.set(__self__, "postal_code", postal_code)
        if state_or_province is not None:
            pulumi.set(__self__, "state_or_province", state_or_province)
        if street_address2 is not None:
            pulumi.set(__self__, "street_address2", street_address2)
        if street_address3 is not None:
            pulumi.set(__self__, "street_address3", street_address3)
        if zip_extended_code is not None:
            pulumi.set(__self__, "zip_extended_code", zip_extended_code)

    @property
    @pulumi.getter
    def country(self) -> pulumi.Input[str]:
        """
        Name of the Country.
        """
        return pulumi.get(self, "country")

    @country.setter
    def country(self, value: pulumi.Input[str]):
        pulumi.set(self, "country", value)

    @property
    @pulumi.getter(name="streetAddress1")
    def street_address1(self) -> pulumi.Input[str]:
        """
        Street Address line 1.
        """
        return pulumi.get(self, "street_address1")

    @street_address1.setter
    def street_address1(self, value: pulumi.Input[str]):
        pulumi.set(self, "street_address1", value)

    @property
    @pulumi.getter(name="addressType")
    def address_type(self) -> Optional[pulumi.Input[Union[str, 'AddressType']]]:
        """
        Type of address.
        """
        return pulumi.get(self, "address_type")

    @address_type.setter
    def address_type(self, value: Optional[pulumi.Input[Union[str, 'AddressType']]]):
        pulumi.set(self, "address_type", value)

    @property
    @pulumi.getter
    def city(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the City.
        """
        return pulumi.get(self, "city")

    @city.setter
    def city(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "city", value)

    @property
    @pulumi.getter(name="companyName")
    def company_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the company.
        """
        return pulumi.get(self, "company_name")

    @company_name.setter
    def company_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "company_name", value)

    @property
    @pulumi.getter(name="postalCode")
    def postal_code(self) -> Optional[pulumi.Input[str]]:
        """
        Postal code.
        """
        return pulumi.get(self, "postal_code")

    @postal_code.setter
    def postal_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "postal_code", value)

    @property
    @pulumi.getter(name="stateOrProvince")
    def state_or_province(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the State or Province.
        """
        return pulumi.get(self, "state_or_province")

    @state_or_province.setter
    def state_or_province(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state_or_province", value)

    @property
    @pulumi.getter(name="streetAddress2")
    def street_address2(self) -> Optional[pulumi.Input[str]]:
        """
        Street Address line 2.
        """
        return pulumi.get(self, "street_address2")

    @street_address2.setter
    def street_address2(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "street_address2", value)

    @property
    @pulumi.getter(name="streetAddress3")
    def street_address3(self) -> Optional[pulumi.Input[str]]:
        """
        Street Address line 3.
        """
        return pulumi.get(self, "street_address3")

    @street_address3.setter
    def street_address3(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "street_address3", value)

    @property
    @pulumi.getter(name="zipExtendedCode")
    def zip_extended_code(self) -> Optional[pulumi.Input[str]]:
        """
        Extended Zip Code.
        """
        return pulumi.get(self, "zip_extended_code")

    @zip_extended_code.setter
    def zip_extended_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zip_extended_code", value)


@pulumi.input_type
class SkuArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[Union[str, 'SkuName']],
                 display_name: Optional[pulumi.Input[str]] = None,
                 family: Optional[pulumi.Input[str]] = None):
        """
        The Sku.
        :param pulumi.Input[Union[str, 'SkuName']] name: The sku name.
        :param pulumi.Input[str] display_name: The display name of the sku.
        :param pulumi.Input[str] family: The sku family.
        """
        pulumi.set(__self__, "name", name)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if family is not None:
            pulumi.set(__self__, "family", family)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[Union[str, 'SkuName']]:
        """
        The sku name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[Union[str, 'SkuName']]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        The display name of the sku.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def family(self) -> Optional[pulumi.Input[str]]:
        """
        The sku family.
        """
        return pulumi.get(self, "family")

    @family.setter
    def family(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "family", value)


@pulumi.input_type
class StorageAccountDetailsArgs:
    def __init__(__self__, *,
                 data_account_type: pulumi.Input[str],
                 storage_account_id: pulumi.Input[str],
                 share_password: Optional[pulumi.Input[str]] = None):
        """
        Details for the storage account.
        :param pulumi.Input[str] data_account_type: Account Type of the data to be transferred.
               Expected value is 'StorageAccount'.
        :param pulumi.Input[str] storage_account_id: Storage Account Resource Id.
        :param pulumi.Input[str] share_password: Password for all the shares to be created on the device. Should not be passed for TransferType:ExportFromAzure jobs. If this is not passed, the service will generate password itself. This will not be returned in Get Call. Password Requirements :  Password must be minimum of 12 and maximum of 64 characters. Password must have at least one uppercase alphabet, one number and one special character. Password cannot have the following characters : IilLoO0 Password can have only alphabets, numbers and these characters : @#\\-$%^!+=;:_()]+
        """
        if data_account_type is None:
            data_account_type = 'StorageAccount'
        pulumi.set(__self__, "data_account_type", 'StorageAccount')
        pulumi.set(__self__, "storage_account_id", storage_account_id)
        if share_password is not None:
            pulumi.set(__self__, "share_password", share_password)

    @property
    @pulumi.getter(name="dataAccountType")
    def data_account_type(self) -> pulumi.Input[str]:
        """
        Account Type of the data to be transferred.
        Expected value is 'StorageAccount'.
        """
        return pulumi.get(self, "data_account_type")

    @data_account_type.setter
    def data_account_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "data_account_type", value)

    @property
    @pulumi.getter(name="storageAccountId")
    def storage_account_id(self) -> pulumi.Input[str]:
        """
        Storage Account Resource Id.
        """
        return pulumi.get(self, "storage_account_id")

    @storage_account_id.setter
    def storage_account_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "storage_account_id", value)

    @property
    @pulumi.getter(name="sharePassword")
    def share_password(self) -> Optional[pulumi.Input[str]]:
        """
        Password for all the shares to be created on the device. Should not be passed for TransferType:ExportFromAzure jobs. If this is not passed, the service will generate password itself. This will not be returned in Get Call. Password Requirements :  Password must be minimum of 12 and maximum of 64 characters. Password must have at least one uppercase alphabet, one number and one special character. Password cannot have the following characters : IilLoO0 Password can have only alphabets, numbers and these characters : @#\\-$%^!+=;:_()]+
        """
        return pulumi.get(self, "share_password")

    @share_password.setter
    def share_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "share_password", value)


@pulumi.input_type
class TransferAllDetailsArgs:
    def __init__(__self__, *,
                 data_account_type: pulumi.Input[Union[str, 'DataAccountType']],
                 transfer_all_blobs: Optional[pulumi.Input[bool]] = None,
                 transfer_all_files: Optional[pulumi.Input[bool]] = None):
        """
        Details to transfer all data.
        :param pulumi.Input[Union[str, 'DataAccountType']] data_account_type: Type of the account of data
        :param pulumi.Input[bool] transfer_all_blobs: To indicate if all Azure blobs have to be transferred
        :param pulumi.Input[bool] transfer_all_files: To indicate if all Azure Files have to be transferred
        """
        if data_account_type is None:
            data_account_type = 'StorageAccount'
        pulumi.set(__self__, "data_account_type", data_account_type)
        if transfer_all_blobs is not None:
            pulumi.set(__self__, "transfer_all_blobs", transfer_all_blobs)
        if transfer_all_files is not None:
            pulumi.set(__self__, "transfer_all_files", transfer_all_files)

    @property
    @pulumi.getter(name="dataAccountType")
    def data_account_type(self) -> pulumi.Input[Union[str, 'DataAccountType']]:
        """
        Type of the account of data
        """
        return pulumi.get(self, "data_account_type")

    @data_account_type.setter
    def data_account_type(self, value: pulumi.Input[Union[str, 'DataAccountType']]):
        pulumi.set(self, "data_account_type", value)

    @property
    @pulumi.getter(name="transferAllBlobs")
    def transfer_all_blobs(self) -> Optional[pulumi.Input[bool]]:
        """
        To indicate if all Azure blobs have to be transferred
        """
        return pulumi.get(self, "transfer_all_blobs")

    @transfer_all_blobs.setter
    def transfer_all_blobs(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "transfer_all_blobs", value)

    @property
    @pulumi.getter(name="transferAllFiles")
    def transfer_all_files(self) -> Optional[pulumi.Input[bool]]:
        """
        To indicate if all Azure Files have to be transferred
        """
        return pulumi.get(self, "transfer_all_files")

    @transfer_all_files.setter
    def transfer_all_files(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "transfer_all_files", value)


@pulumi.input_type
class TransferConfigurationTransferAllDetailsArgs:
    def __init__(__self__, *,
                 include: Optional[pulumi.Input['TransferAllDetailsArgs']] = None):
        """
        Map of filter type and the details to transfer all data. This field is required only if the TransferConfigurationType is given as TransferAll
        :param pulumi.Input['TransferAllDetailsArgs'] include: Details to transfer all data.
        """
        if include is not None:
            pulumi.set(__self__, "include", include)

    @property
    @pulumi.getter
    def include(self) -> Optional[pulumi.Input['TransferAllDetailsArgs']]:
        """
        Details to transfer all data.
        """
        return pulumi.get(self, "include")

    @include.setter
    def include(self, value: Optional[pulumi.Input['TransferAllDetailsArgs']]):
        pulumi.set(self, "include", value)


@pulumi.input_type
class TransferConfigurationTransferFilterDetailsArgs:
    def __init__(__self__, *,
                 include: Optional[pulumi.Input['TransferFilterDetailsArgs']] = None):
        """
        Map of filter type and the details to filter. This field is required only if the TransferConfigurationType is given as TransferUsingFilter.
        :param pulumi.Input['TransferFilterDetailsArgs'] include: Details of the filtering the transfer of data.
        """
        if include is not None:
            pulumi.set(__self__, "include", include)

    @property
    @pulumi.getter
    def include(self) -> Optional[pulumi.Input['TransferFilterDetailsArgs']]:
        """
        Details of the filtering the transfer of data.
        """
        return pulumi.get(self, "include")

    @include.setter
    def include(self, value: Optional[pulumi.Input['TransferFilterDetailsArgs']]):
        pulumi.set(self, "include", value)


@pulumi.input_type
class TransferConfigurationArgs:
    def __init__(__self__, *,
                 transfer_configuration_type: pulumi.Input[Union[str, 'TransferConfigurationType']],
                 transfer_all_details: Optional[pulumi.Input['TransferConfigurationTransferAllDetailsArgs']] = None,
                 transfer_filter_details: Optional[pulumi.Input['TransferConfigurationTransferFilterDetailsArgs']] = None):
        """
        Configuration for defining the transfer of data.
        :param pulumi.Input[Union[str, 'TransferConfigurationType']] transfer_configuration_type: Type of the configuration for transfer.
        :param pulumi.Input['TransferConfigurationTransferAllDetailsArgs'] transfer_all_details: Map of filter type and the details to transfer all data. This field is required only if the TransferConfigurationType is given as TransferAll
        :param pulumi.Input['TransferConfigurationTransferFilterDetailsArgs'] transfer_filter_details: Map of filter type and the details to filter. This field is required only if the TransferConfigurationType is given as TransferUsingFilter.
        """
        pulumi.set(__self__, "transfer_configuration_type", transfer_configuration_type)
        if transfer_all_details is not None:
            pulumi.set(__self__, "transfer_all_details", transfer_all_details)
        if transfer_filter_details is not None:
            pulumi.set(__self__, "transfer_filter_details", transfer_filter_details)

    @property
    @pulumi.getter(name="transferConfigurationType")
    def transfer_configuration_type(self) -> pulumi.Input[Union[str, 'TransferConfigurationType']]:
        """
        Type of the configuration for transfer.
        """
        return pulumi.get(self, "transfer_configuration_type")

    @transfer_configuration_type.setter
    def transfer_configuration_type(self, value: pulumi.Input[Union[str, 'TransferConfigurationType']]):
        pulumi.set(self, "transfer_configuration_type", value)

    @property
    @pulumi.getter(name="transferAllDetails")
    def transfer_all_details(self) -> Optional[pulumi.Input['TransferConfigurationTransferAllDetailsArgs']]:
        """
        Map of filter type and the details to transfer all data. This field is required only if the TransferConfigurationType is given as TransferAll
        """
        return pulumi.get(self, "transfer_all_details")

    @transfer_all_details.setter
    def transfer_all_details(self, value: Optional[pulumi.Input['TransferConfigurationTransferAllDetailsArgs']]):
        pulumi.set(self, "transfer_all_details", value)

    @property
    @pulumi.getter(name="transferFilterDetails")
    def transfer_filter_details(self) -> Optional[pulumi.Input['TransferConfigurationTransferFilterDetailsArgs']]:
        """
        Map of filter type and the details to filter. This field is required only if the TransferConfigurationType is given as TransferUsingFilter.
        """
        return pulumi.get(self, "transfer_filter_details")

    @transfer_filter_details.setter
    def transfer_filter_details(self, value: Optional[pulumi.Input['TransferConfigurationTransferFilterDetailsArgs']]):
        pulumi.set(self, "transfer_filter_details", value)


@pulumi.input_type
class TransferFilterDetailsArgs:
    def __init__(__self__, *,
                 data_account_type: pulumi.Input[Union[str, 'DataAccountType']],
                 azure_file_filter_details: Optional[pulumi.Input['AzureFileFilterDetailsArgs']] = None,
                 blob_filter_details: Optional[pulumi.Input['BlobFilterDetailsArgs']] = None,
                 filter_file_details: Optional[pulumi.Input[Sequence[pulumi.Input['FilterFileDetailsArgs']]]] = None):
        """
        Details of the filtering the transfer of data.
        :param pulumi.Input[Union[str, 'DataAccountType']] data_account_type: Type of the account of data.
        :param pulumi.Input['AzureFileFilterDetailsArgs'] azure_file_filter_details: Filter details to transfer Azure files.
        :param pulumi.Input['BlobFilterDetailsArgs'] blob_filter_details: Filter details to transfer blobs.
        :param pulumi.Input[Sequence[pulumi.Input['FilterFileDetailsArgs']]] filter_file_details: Details of the filter files to be used for data transfer.
        """
        if data_account_type is None:
            data_account_type = 'StorageAccount'
        pulumi.set(__self__, "data_account_type", data_account_type)
        if azure_file_filter_details is not None:
            pulumi.set(__self__, "azure_file_filter_details", azure_file_filter_details)
        if blob_filter_details is not None:
            pulumi.set(__self__, "blob_filter_details", blob_filter_details)
        if filter_file_details is not None:
            pulumi.set(__self__, "filter_file_details", filter_file_details)

    @property
    @pulumi.getter(name="dataAccountType")
    def data_account_type(self) -> pulumi.Input[Union[str, 'DataAccountType']]:
        """
        Type of the account of data.
        """
        return pulumi.get(self, "data_account_type")

    @data_account_type.setter
    def data_account_type(self, value: pulumi.Input[Union[str, 'DataAccountType']]):
        pulumi.set(self, "data_account_type", value)

    @property
    @pulumi.getter(name="azureFileFilterDetails")
    def azure_file_filter_details(self) -> Optional[pulumi.Input['AzureFileFilterDetailsArgs']]:
        """
        Filter details to transfer Azure files.
        """
        return pulumi.get(self, "azure_file_filter_details")

    @azure_file_filter_details.setter
    def azure_file_filter_details(self, value: Optional[pulumi.Input['AzureFileFilterDetailsArgs']]):
        pulumi.set(self, "azure_file_filter_details", value)

    @property
    @pulumi.getter(name="blobFilterDetails")
    def blob_filter_details(self) -> Optional[pulumi.Input['BlobFilterDetailsArgs']]:
        """
        Filter details to transfer blobs.
        """
        return pulumi.get(self, "blob_filter_details")

    @blob_filter_details.setter
    def blob_filter_details(self, value: Optional[pulumi.Input['BlobFilterDetailsArgs']]):
        pulumi.set(self, "blob_filter_details", value)

    @property
    @pulumi.getter(name="filterFileDetails")
    def filter_file_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FilterFileDetailsArgs']]]]:
        """
        Details of the filter files to be used for data transfer.
        """
        return pulumi.get(self, "filter_file_details")

    @filter_file_details.setter
    def filter_file_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FilterFileDetailsArgs']]]]):
        pulumi.set(self, "filter_file_details", value)


@pulumi.input_type
class TransportPreferencesArgs:
    def __init__(__self__, *,
                 preferred_shipment_type: pulumi.Input[Union[str, 'TransportShipmentTypes']]):
        """
        Preferences related to the shipment logistics of the sku
        :param pulumi.Input[Union[str, 'TransportShipmentTypes']] preferred_shipment_type: Indicates Shipment Logistics type that the customer preferred.
        """
        pulumi.set(__self__, "preferred_shipment_type", preferred_shipment_type)

    @property
    @pulumi.getter(name="preferredShipmentType")
    def preferred_shipment_type(self) -> pulumi.Input[Union[str, 'TransportShipmentTypes']]:
        """
        Indicates Shipment Logistics type that the customer preferred.
        """
        return pulumi.get(self, "preferred_shipment_type")

    @preferred_shipment_type.setter
    def preferred_shipment_type(self, value: pulumi.Input[Union[str, 'TransportShipmentTypes']]):
        pulumi.set(self, "preferred_shipment_type", value)


@pulumi.input_type
class UserAssignedPropertiesArgs:
    def __init__(__self__, *,
                 resource_id: Optional[pulumi.Input[str]] = None):
        """
        User assigned identity properties.
        :param pulumi.Input[str] resource_id: Arm resource id for user assigned identity to be used to fetch MSI token.
        """
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        Arm resource id for user assigned identity to be used to fetch MSI token.
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_id", value)


