# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = ['FleetMemberArgs', 'FleetMember']

@pulumi.input_type
class FleetMemberArgs:
    def __init__(__self__, *,
                 fleet_name: pulumi.Input[str],
                 resource_group_name: pulumi.Input[str],
                 cluster_resource_id: Optional[pulumi.Input[str]] = None,
                 fleet_member_name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a FleetMember resource.
        :param pulumi.Input[str] fleet_name: The name of the Fleet resource.
        :param pulumi.Input[str] resource_group_name: The name of the resource group. The name is case insensitive.
        :param pulumi.Input[str] cluster_resource_id: The ARM resource id of the cluster that joins the Fleet. Must be a valid Azure resource id. e.g.: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/managedClusters/{clusterName}'.
        :param pulumi.Input[str] fleet_member_name: The name of the Fleet member resource.
        """
        pulumi.set(__self__, "fleet_name", fleet_name)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if cluster_resource_id is not None:
            pulumi.set(__self__, "cluster_resource_id", cluster_resource_id)
        if fleet_member_name is not None:
            pulumi.set(__self__, "fleet_member_name", fleet_member_name)

    @property
    @pulumi.getter(name="fleetName")
    def fleet_name(self) -> pulumi.Input[str]:
        """
        The name of the Fleet resource.
        """
        return pulumi.get(self, "fleet_name")

    @fleet_name.setter
    def fleet_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "fleet_name", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[str]:
        """
        The name of the resource group. The name is case insensitive.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="clusterResourceId")
    def cluster_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ARM resource id of the cluster that joins the Fleet. Must be a valid Azure resource id. e.g.: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/managedClusters/{clusterName}'.
        """
        return pulumi.get(self, "cluster_resource_id")

    @cluster_resource_id.setter
    def cluster_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_resource_id", value)

    @property
    @pulumi.getter(name="fleetMemberName")
    def fleet_member_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Fleet member resource.
        """
        return pulumi.get(self, "fleet_member_name")

    @fleet_member_name.setter
    def fleet_member_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fleet_member_name", value)


class FleetMember(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_resource_id: Optional[pulumi.Input[str]] = None,
                 fleet_member_name: Optional[pulumi.Input[str]] = None,
                 fleet_name: Optional[pulumi.Input[str]] = None,
                 resource_group_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        A member of the Fleet. It contains a reference to an existing Kubernetes cluster on Azure.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] cluster_resource_id: The ARM resource id of the cluster that joins the Fleet. Must be a valid Azure resource id. e.g.: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/managedClusters/{clusterName}'.
        :param pulumi.Input[str] fleet_member_name: The name of the Fleet member resource.
        :param pulumi.Input[str] fleet_name: The name of the Fleet resource.
        :param pulumi.Input[str] resource_group_name: The name of the resource group. The name is case insensitive.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FleetMemberArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A member of the Fleet. It contains a reference to an existing Kubernetes cluster on Azure.

        :param str resource_name: The name of the resource.
        :param FleetMemberArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FleetMemberArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_resource_id: Optional[pulumi.Input[str]] = None,
                 fleet_member_name: Optional[pulumi.Input[str]] = None,
                 fleet_name: Optional[pulumi.Input[str]] = None,
                 resource_group_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FleetMemberArgs.__new__(FleetMemberArgs)

            __props__.__dict__["cluster_resource_id"] = cluster_resource_id
            __props__.__dict__["fleet_member_name"] = fleet_member_name
            if fleet_name is None and not opts.urn:
                raise TypeError("Missing required property 'fleet_name'")
            __props__.__dict__["fleet_name"] = fleet_name
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["etag"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["provisioning_state"] = None
            __props__.__dict__["system_data"] = None
            __props__.__dict__["type"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="azure-native:containerservice/v20220602preview:FleetMember")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(FleetMember, __self__).__init__(
            'azure-native:containerservice/v20220702preview:FleetMember',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'FleetMember':
        """
        Get an existing FleetMember resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = FleetMemberArgs.__new__(FleetMemberArgs)

        __props__.__dict__["cluster_resource_id"] = None
        __props__.__dict__["etag"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["provisioning_state"] = None
        __props__.__dict__["system_data"] = None
        __props__.__dict__["type"] = None
        return FleetMember(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="clusterResourceId")
    def cluster_resource_id(self) -> pulumi.Output[Optional[str]]:
        """
        The ARM resource id of the cluster that joins the Fleet. Must be a valid Azure resource id. e.g.: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/managedClusters/{clusterName}'.
        """
        return pulumi.get(self, "cluster_resource_id")

    @property
    @pulumi.getter
    def etag(self) -> pulumi.Output[str]:
        """
        Resource Etag.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> pulumi.Output[str]:
        """
        The provisioning state of the last accepted operation.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="systemData")
    def system_data(self) -> pulumi.Output['outputs.SystemDataResponse']:
        """
        Azure Resource Manager metadata containing createdBy and modifiedBy information.
        """
        return pulumi.get(self, "system_data")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
        """
        return pulumi.get(self, "type")

