# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'ActivityEntityQueriesPropertiesQueryDefinitionsArgs',
    'AlertDetailsOverrideArgs',
    'AlertsDataTypeOfDataConnectorArgs',
    'AvailabilityArgs',
    'AwsCloudTrailDataConnectorDataTypesLogsArgs',
    'AwsCloudTrailDataConnectorDataTypesArgs',
    'CodelessUiConnectorConfigPropertiesConnectivityCriteriaArgs',
    'CodelessUiConnectorConfigPropertiesDataTypesArgs',
    'CodelessUiConnectorConfigPropertiesGraphQueriesArgs',
    'CodelessUiConnectorConfigPropertiesInstructionStepsArgs',
    'CodelessUiConnectorConfigPropertiesSampleQueriesArgs',
    'CodelessUiConnectorConfigPropertiesArgs',
    'ContentPathMapArgs',
    'DataConnectorDataTypeCommonArgs',
    'Dynamics365DataConnectorDataTypesDynamics365CdsActivitiesArgs',
    'Dynamics365DataConnectorDataTypesArgs',
    'EntityMappingArgs',
    'EventGroupingSettingsArgs',
    'FieldMappingArgs',
    'GroupingConfigurationArgs',
    'IncidentConfigurationArgs',
    'IncidentLabelArgs',
    'IncidentOwnerInfoArgs',
    'InstructionStepsInstructionsArgs',
    'MCASDataConnectorDataTypesArgs',
    'MSTIDataConnectorDataTypesBingSafetyPhishingURLArgs',
    'MSTIDataConnectorDataTypesMicrosoftEmergingThreatFeedArgs',
    'MSTIDataConnectorDataTypesArgs',
    'MTPDataConnectorDataTypesIncidentsArgs',
    'MTPDataConnectorDataTypesArgs',
    'MetadataAuthorArgs',
    'MetadataCategoriesArgs',
    'MetadataDependenciesArgs',
    'MetadataSourceArgs',
    'MetadataSupportArgs',
    'OfficeDataConnectorDataTypesExchangeArgs',
    'OfficeDataConnectorDataTypesSharePointArgs',
    'OfficeDataConnectorDataTypesTeamsArgs',
    'OfficeDataConnectorDataTypesArgs',
    'PermissionsCustomsArgs',
    'PermissionsResourceProviderArgs',
    'PermissionsArgs',
    'RepositoryArgs',
    'RequiredPermissionsArgs',
    'TIDataConnectorDataTypesIndicatorsArgs',
    'TIDataConnectorDataTypesArgs',
    'TiTaxiiDataConnectorDataTypesTaxiiClientArgs',
    'TiTaxiiDataConnectorDataTypesArgs',
    'WatchlistUserInfoArgs',
]

@pulumi.input_type
class ActivityEntityQueriesPropertiesQueryDefinitionsArgs:
    def __init__(__self__, *,
                 query: Optional[pulumi.Input[str]] = None):
        """
        The Activity query definitions
        :param pulumi.Input[str] query: The Activity query to run on a given entity
        """
        if query is not None:
            pulumi.set(__self__, "query", query)

    @property
    @pulumi.getter
    def query(self) -> Optional[pulumi.Input[str]]:
        """
        The Activity query to run on a given entity
        """
        return pulumi.get(self, "query")

    @query.setter
    def query(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "query", value)


@pulumi.input_type
class AlertDetailsOverrideArgs:
    def __init__(__self__, *,
                 alert_description_format: Optional[pulumi.Input[str]] = None,
                 alert_display_name_format: Optional[pulumi.Input[str]] = None,
                 alert_severity_column_name: Optional[pulumi.Input[str]] = None,
                 alert_tactics_column_name: Optional[pulumi.Input[str]] = None):
        """
        Settings for how to dynamically override alert static details
        :param pulumi.Input[str] alert_description_format: the format containing columns name(s) to override the alert description
        :param pulumi.Input[str] alert_display_name_format: the format containing columns name(s) to override the alert name
        :param pulumi.Input[str] alert_severity_column_name: the column name to take the alert severity from
        :param pulumi.Input[str] alert_tactics_column_name: the column name to take the alert tactics from
        """
        if alert_description_format is not None:
            pulumi.set(__self__, "alert_description_format", alert_description_format)
        if alert_display_name_format is not None:
            pulumi.set(__self__, "alert_display_name_format", alert_display_name_format)
        if alert_severity_column_name is not None:
            pulumi.set(__self__, "alert_severity_column_name", alert_severity_column_name)
        if alert_tactics_column_name is not None:
            pulumi.set(__self__, "alert_tactics_column_name", alert_tactics_column_name)

    @property
    @pulumi.getter(name="alertDescriptionFormat")
    def alert_description_format(self) -> Optional[pulumi.Input[str]]:
        """
        the format containing columns name(s) to override the alert description
        """
        return pulumi.get(self, "alert_description_format")

    @alert_description_format.setter
    def alert_description_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "alert_description_format", value)

    @property
    @pulumi.getter(name="alertDisplayNameFormat")
    def alert_display_name_format(self) -> Optional[pulumi.Input[str]]:
        """
        the format containing columns name(s) to override the alert name
        """
        return pulumi.get(self, "alert_display_name_format")

    @alert_display_name_format.setter
    def alert_display_name_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "alert_display_name_format", value)

    @property
    @pulumi.getter(name="alertSeverityColumnName")
    def alert_severity_column_name(self) -> Optional[pulumi.Input[str]]:
        """
        the column name to take the alert severity from
        """
        return pulumi.get(self, "alert_severity_column_name")

    @alert_severity_column_name.setter
    def alert_severity_column_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "alert_severity_column_name", value)

    @property
    @pulumi.getter(name="alertTacticsColumnName")
    def alert_tactics_column_name(self) -> Optional[pulumi.Input[str]]:
        """
        the column name to take the alert tactics from
        """
        return pulumi.get(self, "alert_tactics_column_name")

    @alert_tactics_column_name.setter
    def alert_tactics_column_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "alert_tactics_column_name", value)


@pulumi.input_type
class AlertsDataTypeOfDataConnectorArgs:
    def __init__(__self__, *,
                 alerts: pulumi.Input['DataConnectorDataTypeCommonArgs']):
        """
        Alerts data type for data connectors.
        :param pulumi.Input['DataConnectorDataTypeCommonArgs'] alerts: Alerts data type connection.
        """
        pulumi.set(__self__, "alerts", alerts)

    @property
    @pulumi.getter
    def alerts(self) -> pulumi.Input['DataConnectorDataTypeCommonArgs']:
        """
        Alerts data type connection.
        """
        return pulumi.get(self, "alerts")

    @alerts.setter
    def alerts(self, value: pulumi.Input['DataConnectorDataTypeCommonArgs']):
        pulumi.set(self, "alerts", value)


@pulumi.input_type
class AvailabilityArgs:
    def __init__(__self__, *,
                 is_preview: Optional[pulumi.Input[bool]] = None,
                 status: Optional[pulumi.Input[int]] = None):
        """
        Connector Availability Status
        :param pulumi.Input[bool] is_preview: Set connector as preview
        :param pulumi.Input[int] status: The connector Availability Status
        """
        if is_preview is not None:
            pulumi.set(__self__, "is_preview", is_preview)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="isPreview")
    def is_preview(self) -> Optional[pulumi.Input[bool]]:
        """
        Set connector as preview
        """
        return pulumi.get(self, "is_preview")

    @is_preview.setter
    def is_preview(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_preview", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[int]]:
        """
        The connector Availability Status
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class AwsCloudTrailDataConnectorDataTypesLogsArgs:
    def __init__(__self__, *,
                 state: pulumi.Input[Union[str, 'DataTypeState']]):
        """
        Logs data type.
        :param pulumi.Input[Union[str, 'DataTypeState']] state: Describe whether this data type connection is enabled or not.
        """
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def state(self) -> pulumi.Input[Union[str, 'DataTypeState']]:
        """
        Describe whether this data type connection is enabled or not.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: pulumi.Input[Union[str, 'DataTypeState']]):
        pulumi.set(self, "state", value)


@pulumi.input_type
class AwsCloudTrailDataConnectorDataTypesArgs:
    def __init__(__self__, *,
                 logs: pulumi.Input['AwsCloudTrailDataConnectorDataTypesLogsArgs']):
        """
        The available data types for Amazon Web Services CloudTrail data connector.
        :param pulumi.Input['AwsCloudTrailDataConnectorDataTypesLogsArgs'] logs: Logs data type.
        """
        pulumi.set(__self__, "logs", logs)

    @property
    @pulumi.getter
    def logs(self) -> pulumi.Input['AwsCloudTrailDataConnectorDataTypesLogsArgs']:
        """
        Logs data type.
        """
        return pulumi.get(self, "logs")

    @logs.setter
    def logs(self, value: pulumi.Input['AwsCloudTrailDataConnectorDataTypesLogsArgs']):
        pulumi.set(self, "logs", value)


@pulumi.input_type
class CodelessUiConnectorConfigPropertiesConnectivityCriteriaArgs:
    def __init__(__self__, *,
                 type: Optional[pulumi.Input[Union[str, 'ConnectivityType']]] = None,
                 value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[Union[str, 'ConnectivityType']] type: type of connectivity
        :param pulumi.Input[Sequence[pulumi.Input[str]]] value: Queries for checking connectivity
        """
        if type is not None:
            pulumi.set(__self__, "type", type)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[Union[str, 'ConnectivityType']]]:
        """
        type of connectivity
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[Union[str, 'ConnectivityType']]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Queries for checking connectivity
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class CodelessUiConnectorConfigPropertiesDataTypesArgs:
    def __init__(__self__, *,
                 last_data_received_query: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] last_data_received_query: Query for indicate last data received
        :param pulumi.Input[str] name: Name of the data type to show in the graph. can be use with {{graphQueriesTableName}} placeholder
        """
        if last_data_received_query is not None:
            pulumi.set(__self__, "last_data_received_query", last_data_received_query)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="lastDataReceivedQuery")
    def last_data_received_query(self) -> Optional[pulumi.Input[str]]:
        """
        Query for indicate last data received
        """
        return pulumi.get(self, "last_data_received_query")

    @last_data_received_query.setter
    def last_data_received_query(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_data_received_query", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the data type to show in the graph. can be use with {{graphQueriesTableName}} placeholder
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class CodelessUiConnectorConfigPropertiesGraphQueriesArgs:
    def __init__(__self__, *,
                 base_query: Optional[pulumi.Input[str]] = None,
                 legend: Optional[pulumi.Input[str]] = None,
                 metric_name: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] base_query: The base query for the graph
        :param pulumi.Input[str] legend: The legend for the graph
        :param pulumi.Input[str] metric_name: the metric that the query is checking
        """
        if base_query is not None:
            pulumi.set(__self__, "base_query", base_query)
        if legend is not None:
            pulumi.set(__self__, "legend", legend)
        if metric_name is not None:
            pulumi.set(__self__, "metric_name", metric_name)

    @property
    @pulumi.getter(name="baseQuery")
    def base_query(self) -> Optional[pulumi.Input[str]]:
        """
        The base query for the graph
        """
        return pulumi.get(self, "base_query")

    @base_query.setter
    def base_query(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "base_query", value)

    @property
    @pulumi.getter
    def legend(self) -> Optional[pulumi.Input[str]]:
        """
        The legend for the graph
        """
        return pulumi.get(self, "legend")

    @legend.setter
    def legend(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "legend", value)

    @property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> Optional[pulumi.Input[str]]:
        """
        the metric that the query is checking
        """
        return pulumi.get(self, "metric_name")

    @metric_name.setter
    def metric_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "metric_name", value)


@pulumi.input_type
class CodelessUiConnectorConfigPropertiesInstructionStepsArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 instructions: Optional[pulumi.Input[Sequence[pulumi.Input['InstructionStepsInstructionsArgs']]]] = None,
                 title: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] description: Instruction step description
        :param pulumi.Input[Sequence[pulumi.Input['InstructionStepsInstructionsArgs']]] instructions: Instruction step details
        :param pulumi.Input[str] title: Instruction step title
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if instructions is not None:
            pulumi.set(__self__, "instructions", instructions)
        if title is not None:
            pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Instruction step description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def instructions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstructionStepsInstructionsArgs']]]]:
        """
        Instruction step details
        """
        return pulumi.get(self, "instructions")

    @instructions.setter
    def instructions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstructionStepsInstructionsArgs']]]]):
        pulumi.set(self, "instructions", value)

    @property
    @pulumi.getter
    def title(self) -> Optional[pulumi.Input[str]]:
        """
        Instruction step title
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "title", value)


@pulumi.input_type
class CodelessUiConnectorConfigPropertiesSampleQueriesArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 query: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] description: The sample query description
        :param pulumi.Input[str] query: the sample query
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if query is not None:
            pulumi.set(__self__, "query", query)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The sample query description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def query(self) -> Optional[pulumi.Input[str]]:
        """
        the sample query
        """
        return pulumi.get(self, "query")

    @query.setter
    def query(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "query", value)


@pulumi.input_type
class CodelessUiConnectorConfigPropertiesArgs:
    def __init__(__self__, *,
                 availability: pulumi.Input['AvailabilityArgs'],
                 connectivity_criteria: pulumi.Input[Sequence[pulumi.Input['CodelessUiConnectorConfigPropertiesConnectivityCriteriaArgs']]],
                 data_types: pulumi.Input[Sequence[pulumi.Input['CodelessUiConnectorConfigPropertiesDataTypesArgs']]],
                 description_markdown: pulumi.Input[str],
                 graph_queries: pulumi.Input[Sequence[pulumi.Input['CodelessUiConnectorConfigPropertiesGraphQueriesArgs']]],
                 graph_queries_table_name: pulumi.Input[str],
                 instruction_steps: pulumi.Input[Sequence[pulumi.Input['CodelessUiConnectorConfigPropertiesInstructionStepsArgs']]],
                 permissions: pulumi.Input['PermissionsArgs'],
                 publisher: pulumi.Input[str],
                 sample_queries: pulumi.Input[Sequence[pulumi.Input['CodelessUiConnectorConfigPropertiesSampleQueriesArgs']]],
                 title: pulumi.Input[str],
                 custom_image: Optional[pulumi.Input[str]] = None):
        """
        Config to describe the instructions blade
        :param pulumi.Input['AvailabilityArgs'] availability: Connector Availability Status
        :param pulumi.Input[Sequence[pulumi.Input['CodelessUiConnectorConfigPropertiesConnectivityCriteriaArgs']]] connectivity_criteria: Define the way the connector check connectivity
        :param pulumi.Input[Sequence[pulumi.Input['CodelessUiConnectorConfigPropertiesDataTypesArgs']]] data_types: Data types to check for last data received
        :param pulumi.Input[str] description_markdown: Connector description
        :param pulumi.Input[Sequence[pulumi.Input['CodelessUiConnectorConfigPropertiesGraphQueriesArgs']]] graph_queries: The graph query to show the current data status
        :param pulumi.Input[str] graph_queries_table_name: Name of the table the connector will insert the data to
        :param pulumi.Input[Sequence[pulumi.Input['CodelessUiConnectorConfigPropertiesInstructionStepsArgs']]] instruction_steps: Instruction steps to enable the connector
        :param pulumi.Input['PermissionsArgs'] permissions: Permissions required for the connector
        :param pulumi.Input[str] publisher: Connector publisher name
        :param pulumi.Input[Sequence[pulumi.Input['CodelessUiConnectorConfigPropertiesSampleQueriesArgs']]] sample_queries: The sample queries for the connector
        :param pulumi.Input[str] title: Connector blade title
        :param pulumi.Input[str] custom_image: An optional custom image to be used when displaying the connector within Azure Sentinel's connector's gallery
        """
        pulumi.set(__self__, "availability", availability)
        pulumi.set(__self__, "connectivity_criteria", connectivity_criteria)
        pulumi.set(__self__, "data_types", data_types)
        pulumi.set(__self__, "description_markdown", description_markdown)
        pulumi.set(__self__, "graph_queries", graph_queries)
        pulumi.set(__self__, "graph_queries_table_name", graph_queries_table_name)
        pulumi.set(__self__, "instruction_steps", instruction_steps)
        pulumi.set(__self__, "permissions", permissions)
        pulumi.set(__self__, "publisher", publisher)
        pulumi.set(__self__, "sample_queries", sample_queries)
        pulumi.set(__self__, "title", title)
        if custom_image is not None:
            pulumi.set(__self__, "custom_image", custom_image)

    @property
    @pulumi.getter
    def availability(self) -> pulumi.Input['AvailabilityArgs']:
        """
        Connector Availability Status
        """
        return pulumi.get(self, "availability")

    @availability.setter
    def availability(self, value: pulumi.Input['AvailabilityArgs']):
        pulumi.set(self, "availability", value)

    @property
    @pulumi.getter(name="connectivityCriteria")
    def connectivity_criteria(self) -> pulumi.Input[Sequence[pulumi.Input['CodelessUiConnectorConfigPropertiesConnectivityCriteriaArgs']]]:
        """
        Define the way the connector check connectivity
        """
        return pulumi.get(self, "connectivity_criteria")

    @connectivity_criteria.setter
    def connectivity_criteria(self, value: pulumi.Input[Sequence[pulumi.Input['CodelessUiConnectorConfigPropertiesConnectivityCriteriaArgs']]]):
        pulumi.set(self, "connectivity_criteria", value)

    @property
    @pulumi.getter(name="dataTypes")
    def data_types(self) -> pulumi.Input[Sequence[pulumi.Input['CodelessUiConnectorConfigPropertiesDataTypesArgs']]]:
        """
        Data types to check for last data received
        """
        return pulumi.get(self, "data_types")

    @data_types.setter
    def data_types(self, value: pulumi.Input[Sequence[pulumi.Input['CodelessUiConnectorConfigPropertiesDataTypesArgs']]]):
        pulumi.set(self, "data_types", value)

    @property
    @pulumi.getter(name="descriptionMarkdown")
    def description_markdown(self) -> pulumi.Input[str]:
        """
        Connector description
        """
        return pulumi.get(self, "description_markdown")

    @description_markdown.setter
    def description_markdown(self, value: pulumi.Input[str]):
        pulumi.set(self, "description_markdown", value)

    @property
    @pulumi.getter(name="graphQueries")
    def graph_queries(self) -> pulumi.Input[Sequence[pulumi.Input['CodelessUiConnectorConfigPropertiesGraphQueriesArgs']]]:
        """
        The graph query to show the current data status
        """
        return pulumi.get(self, "graph_queries")

    @graph_queries.setter
    def graph_queries(self, value: pulumi.Input[Sequence[pulumi.Input['CodelessUiConnectorConfigPropertiesGraphQueriesArgs']]]):
        pulumi.set(self, "graph_queries", value)

    @property
    @pulumi.getter(name="graphQueriesTableName")
    def graph_queries_table_name(self) -> pulumi.Input[str]:
        """
        Name of the table the connector will insert the data to
        """
        return pulumi.get(self, "graph_queries_table_name")

    @graph_queries_table_name.setter
    def graph_queries_table_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "graph_queries_table_name", value)

    @property
    @pulumi.getter(name="instructionSteps")
    def instruction_steps(self) -> pulumi.Input[Sequence[pulumi.Input['CodelessUiConnectorConfigPropertiesInstructionStepsArgs']]]:
        """
        Instruction steps to enable the connector
        """
        return pulumi.get(self, "instruction_steps")

    @instruction_steps.setter
    def instruction_steps(self, value: pulumi.Input[Sequence[pulumi.Input['CodelessUiConnectorConfigPropertiesInstructionStepsArgs']]]):
        pulumi.set(self, "instruction_steps", value)

    @property
    @pulumi.getter
    def permissions(self) -> pulumi.Input['PermissionsArgs']:
        """
        Permissions required for the connector
        """
        return pulumi.get(self, "permissions")

    @permissions.setter
    def permissions(self, value: pulumi.Input['PermissionsArgs']):
        pulumi.set(self, "permissions", value)

    @property
    @pulumi.getter
    def publisher(self) -> pulumi.Input[str]:
        """
        Connector publisher name
        """
        return pulumi.get(self, "publisher")

    @publisher.setter
    def publisher(self, value: pulumi.Input[str]):
        pulumi.set(self, "publisher", value)

    @property
    @pulumi.getter(name="sampleQueries")
    def sample_queries(self) -> pulumi.Input[Sequence[pulumi.Input['CodelessUiConnectorConfigPropertiesSampleQueriesArgs']]]:
        """
        The sample queries for the connector
        """
        return pulumi.get(self, "sample_queries")

    @sample_queries.setter
    def sample_queries(self, value: pulumi.Input[Sequence[pulumi.Input['CodelessUiConnectorConfigPropertiesSampleQueriesArgs']]]):
        pulumi.set(self, "sample_queries", value)

    @property
    @pulumi.getter
    def title(self) -> pulumi.Input[str]:
        """
        Connector blade title
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: pulumi.Input[str]):
        pulumi.set(self, "title", value)

    @property
    @pulumi.getter(name="customImage")
    def custom_image(self) -> Optional[pulumi.Input[str]]:
        """
        An optional custom image to be used when displaying the connector within Azure Sentinel's connector's gallery
        """
        return pulumi.get(self, "custom_image")

    @custom_image.setter
    def custom_image(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_image", value)


@pulumi.input_type
class ContentPathMapArgs:
    def __init__(__self__, *,
                 content_type: Optional[pulumi.Input[Union[str, 'ContentType']]] = None,
                 path: Optional[pulumi.Input[str]] = None):
        """
        The mapping of content type to a repo path.
        :param pulumi.Input[Union[str, 'ContentType']] content_type: Content type.
        :param pulumi.Input[str] path: The path to the content.
        """
        if content_type is not None:
            pulumi.set(__self__, "content_type", content_type)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> Optional[pulumi.Input[Union[str, 'ContentType']]]:
        """
        Content type.
        """
        return pulumi.get(self, "content_type")

    @content_type.setter
    def content_type(self, value: Optional[pulumi.Input[Union[str, 'ContentType']]]):
        pulumi.set(self, "content_type", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        The path to the content.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)


@pulumi.input_type
class DataConnectorDataTypeCommonArgs:
    def __init__(__self__, *,
                 state: pulumi.Input[Union[str, 'DataTypeState']]):
        """
        Common field for data type in data connectors.
        :param pulumi.Input[Union[str, 'DataTypeState']] state: Describe whether this data type connection is enabled or not.
        """
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def state(self) -> pulumi.Input[Union[str, 'DataTypeState']]:
        """
        Describe whether this data type connection is enabled or not.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: pulumi.Input[Union[str, 'DataTypeState']]):
        pulumi.set(self, "state", value)


@pulumi.input_type
class Dynamics365DataConnectorDataTypesDynamics365CdsActivitiesArgs:
    def __init__(__self__, *,
                 state: pulumi.Input[Union[str, 'DataTypeState']]):
        """
        Common Data Service data type connection.
        :param pulumi.Input[Union[str, 'DataTypeState']] state: Describe whether this data type connection is enabled or not.
        """
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def state(self) -> pulumi.Input[Union[str, 'DataTypeState']]:
        """
        Describe whether this data type connection is enabled or not.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: pulumi.Input[Union[str, 'DataTypeState']]):
        pulumi.set(self, "state", value)


@pulumi.input_type
class Dynamics365DataConnectorDataTypesArgs:
    def __init__(__self__, *,
                 dynamics365_cds_activities: pulumi.Input['Dynamics365DataConnectorDataTypesDynamics365CdsActivitiesArgs']):
        """
        The available data types for Dynamics365 data connector.
        :param pulumi.Input['Dynamics365DataConnectorDataTypesDynamics365CdsActivitiesArgs'] dynamics365_cds_activities: Common Data Service data type connection.
        """
        pulumi.set(__self__, "dynamics365_cds_activities", dynamics365_cds_activities)

    @property
    @pulumi.getter(name="dynamics365CdsActivities")
    def dynamics365_cds_activities(self) -> pulumi.Input['Dynamics365DataConnectorDataTypesDynamics365CdsActivitiesArgs']:
        """
        Common Data Service data type connection.
        """
        return pulumi.get(self, "dynamics365_cds_activities")

    @dynamics365_cds_activities.setter
    def dynamics365_cds_activities(self, value: pulumi.Input['Dynamics365DataConnectorDataTypesDynamics365CdsActivitiesArgs']):
        pulumi.set(self, "dynamics365_cds_activities", value)


@pulumi.input_type
class EntityMappingArgs:
    def __init__(__self__, *,
                 entity_type: Optional[pulumi.Input[Union[str, 'EntityMappingType']]] = None,
                 field_mappings: Optional[pulumi.Input[Sequence[pulumi.Input['FieldMappingArgs']]]] = None):
        """
        Single entity mapping for the alert rule
        :param pulumi.Input[Union[str, 'EntityMappingType']] entity_type: The V3 type of the mapped entity
        :param pulumi.Input[Sequence[pulumi.Input['FieldMappingArgs']]] field_mappings: array of field mappings for the given entity mapping
        """
        if entity_type is not None:
            pulumi.set(__self__, "entity_type", entity_type)
        if field_mappings is not None:
            pulumi.set(__self__, "field_mappings", field_mappings)

    @property
    @pulumi.getter(name="entityType")
    def entity_type(self) -> Optional[pulumi.Input[Union[str, 'EntityMappingType']]]:
        """
        The V3 type of the mapped entity
        """
        return pulumi.get(self, "entity_type")

    @entity_type.setter
    def entity_type(self, value: Optional[pulumi.Input[Union[str, 'EntityMappingType']]]):
        pulumi.set(self, "entity_type", value)

    @property
    @pulumi.getter(name="fieldMappings")
    def field_mappings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FieldMappingArgs']]]]:
        """
        array of field mappings for the given entity mapping
        """
        return pulumi.get(self, "field_mappings")

    @field_mappings.setter
    def field_mappings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FieldMappingArgs']]]]):
        pulumi.set(self, "field_mappings", value)


@pulumi.input_type
class EventGroupingSettingsArgs:
    def __init__(__self__, *,
                 aggregation_kind: Optional[pulumi.Input[Union[str, 'EventGroupingAggregationKind']]] = None):
        """
        Event grouping settings property bag.
        :param pulumi.Input[Union[str, 'EventGroupingAggregationKind']] aggregation_kind: The event grouping aggregation kinds
        """
        if aggregation_kind is not None:
            pulumi.set(__self__, "aggregation_kind", aggregation_kind)

    @property
    @pulumi.getter(name="aggregationKind")
    def aggregation_kind(self) -> Optional[pulumi.Input[Union[str, 'EventGroupingAggregationKind']]]:
        """
        The event grouping aggregation kinds
        """
        return pulumi.get(self, "aggregation_kind")

    @aggregation_kind.setter
    def aggregation_kind(self, value: Optional[pulumi.Input[Union[str, 'EventGroupingAggregationKind']]]):
        pulumi.set(self, "aggregation_kind", value)


@pulumi.input_type
class FieldMappingArgs:
    def __init__(__self__, *,
                 column_name: Optional[pulumi.Input[str]] = None,
                 identifier: Optional[pulumi.Input[str]] = None):
        """
        A single field mapping of the mapped entity
        :param pulumi.Input[str] column_name: the column name to be mapped to the identifier
        :param pulumi.Input[str] identifier: the V3 identifier of the entity
        """
        if column_name is not None:
            pulumi.set(__self__, "column_name", column_name)
        if identifier is not None:
            pulumi.set(__self__, "identifier", identifier)

    @property
    @pulumi.getter(name="columnName")
    def column_name(self) -> Optional[pulumi.Input[str]]:
        """
        the column name to be mapped to the identifier
        """
        return pulumi.get(self, "column_name")

    @column_name.setter
    def column_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "column_name", value)

    @property
    @pulumi.getter
    def identifier(self) -> Optional[pulumi.Input[str]]:
        """
        the V3 identifier of the entity
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "identifier", value)


@pulumi.input_type
class GroupingConfigurationArgs:
    def __init__(__self__, *,
                 enabled: pulumi.Input[bool],
                 lookback_duration: pulumi.Input[str],
                 matching_method: pulumi.Input[Union[str, 'MatchingMethod']],
                 reopen_closed_incident: pulumi.Input[bool],
                 group_by_alert_details: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'AlertDetail']]]]] = None,
                 group_by_custom_details: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 group_by_entities: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'EntityMappingType']]]]] = None):
        """
        Grouping configuration property bag.
        :param pulumi.Input[bool] enabled: Grouping enabled
        :param pulumi.Input[str] lookback_duration: Limit the group to alerts created within the lookback duration (in ISO 8601 duration format)
        :param pulumi.Input[Union[str, 'MatchingMethod']] matching_method: Grouping matching method. When method is Selected at least one of groupByEntities, groupByAlertDetails, groupByCustomDetails must be provided and not empty.
        :param pulumi.Input[bool] reopen_closed_incident: Re-open closed matching incidents
        :param pulumi.Input[Sequence[pulumi.Input[Union[str, 'AlertDetail']]]] group_by_alert_details: A list of alert details to group by (when matchingMethod is Selected)
        :param pulumi.Input[Sequence[pulumi.Input[str]]] group_by_custom_details: A list of custom details keys to group by (when matchingMethod is Selected). Only keys defined in the current alert rule may be used.
        :param pulumi.Input[Sequence[pulumi.Input[Union[str, 'EntityMappingType']]]] group_by_entities: A list of entity types to group by (when matchingMethod is Selected). Only entities defined in the current alert rule may be used.
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "lookback_duration", lookback_duration)
        pulumi.set(__self__, "matching_method", matching_method)
        pulumi.set(__self__, "reopen_closed_incident", reopen_closed_incident)
        if group_by_alert_details is not None:
            pulumi.set(__self__, "group_by_alert_details", group_by_alert_details)
        if group_by_custom_details is not None:
            pulumi.set(__self__, "group_by_custom_details", group_by_custom_details)
        if group_by_entities is not None:
            pulumi.set(__self__, "group_by_entities", group_by_entities)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[bool]:
        """
        Grouping enabled
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="lookbackDuration")
    def lookback_duration(self) -> pulumi.Input[str]:
        """
        Limit the group to alerts created within the lookback duration (in ISO 8601 duration format)
        """
        return pulumi.get(self, "lookback_duration")

    @lookback_duration.setter
    def lookback_duration(self, value: pulumi.Input[str]):
        pulumi.set(self, "lookback_duration", value)

    @property
    @pulumi.getter(name="matchingMethod")
    def matching_method(self) -> pulumi.Input[Union[str, 'MatchingMethod']]:
        """
        Grouping matching method. When method is Selected at least one of groupByEntities, groupByAlertDetails, groupByCustomDetails must be provided and not empty.
        """
        return pulumi.get(self, "matching_method")

    @matching_method.setter
    def matching_method(self, value: pulumi.Input[Union[str, 'MatchingMethod']]):
        pulumi.set(self, "matching_method", value)

    @property
    @pulumi.getter(name="reopenClosedIncident")
    def reopen_closed_incident(self) -> pulumi.Input[bool]:
        """
        Re-open closed matching incidents
        """
        return pulumi.get(self, "reopen_closed_incident")

    @reopen_closed_incident.setter
    def reopen_closed_incident(self, value: pulumi.Input[bool]):
        pulumi.set(self, "reopen_closed_incident", value)

    @property
    @pulumi.getter(name="groupByAlertDetails")
    def group_by_alert_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'AlertDetail']]]]]:
        """
        A list of alert details to group by (when matchingMethod is Selected)
        """
        return pulumi.get(self, "group_by_alert_details")

    @group_by_alert_details.setter
    def group_by_alert_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'AlertDetail']]]]]):
        pulumi.set(self, "group_by_alert_details", value)

    @property
    @pulumi.getter(name="groupByCustomDetails")
    def group_by_custom_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of custom details keys to group by (when matchingMethod is Selected). Only keys defined in the current alert rule may be used.
        """
        return pulumi.get(self, "group_by_custom_details")

    @group_by_custom_details.setter
    def group_by_custom_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "group_by_custom_details", value)

    @property
    @pulumi.getter(name="groupByEntities")
    def group_by_entities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'EntityMappingType']]]]]:
        """
        A list of entity types to group by (when matchingMethod is Selected). Only entities defined in the current alert rule may be used.
        """
        return pulumi.get(self, "group_by_entities")

    @group_by_entities.setter
    def group_by_entities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'EntityMappingType']]]]]):
        pulumi.set(self, "group_by_entities", value)


@pulumi.input_type
class IncidentConfigurationArgs:
    def __init__(__self__, *,
                 create_incident: pulumi.Input[bool],
                 grouping_configuration: Optional[pulumi.Input['GroupingConfigurationArgs']] = None):
        """
        Incident Configuration property bag.
        :param pulumi.Input[bool] create_incident: Create incidents from alerts triggered by this analytics rule
        :param pulumi.Input['GroupingConfigurationArgs'] grouping_configuration: Set how the alerts that are triggered by this analytics rule, are grouped into incidents
        """
        pulumi.set(__self__, "create_incident", create_incident)
        if grouping_configuration is not None:
            pulumi.set(__self__, "grouping_configuration", grouping_configuration)

    @property
    @pulumi.getter(name="createIncident")
    def create_incident(self) -> pulumi.Input[bool]:
        """
        Create incidents from alerts triggered by this analytics rule
        """
        return pulumi.get(self, "create_incident")

    @create_incident.setter
    def create_incident(self, value: pulumi.Input[bool]):
        pulumi.set(self, "create_incident", value)

    @property
    @pulumi.getter(name="groupingConfiguration")
    def grouping_configuration(self) -> Optional[pulumi.Input['GroupingConfigurationArgs']]:
        """
        Set how the alerts that are triggered by this analytics rule, are grouped into incidents
        """
        return pulumi.get(self, "grouping_configuration")

    @grouping_configuration.setter
    def grouping_configuration(self, value: Optional[pulumi.Input['GroupingConfigurationArgs']]):
        pulumi.set(self, "grouping_configuration", value)


@pulumi.input_type
class IncidentLabelArgs:
    def __init__(__self__, *,
                 label_name: pulumi.Input[str]):
        """
        Represents an incident label
        :param pulumi.Input[str] label_name: The name of the label
        """
        pulumi.set(__self__, "label_name", label_name)

    @property
    @pulumi.getter(name="labelName")
    def label_name(self) -> pulumi.Input[str]:
        """
        The name of the label
        """
        return pulumi.get(self, "label_name")

    @label_name.setter
    def label_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "label_name", value)


@pulumi.input_type
class IncidentOwnerInfoArgs:
    def __init__(__self__, *,
                 assigned_to: Optional[pulumi.Input[str]] = None,
                 email: Optional[pulumi.Input[str]] = None,
                 object_id: Optional[pulumi.Input[str]] = None,
                 user_principal_name: Optional[pulumi.Input[str]] = None):
        """
        Information on the user an incident is assigned to
        :param pulumi.Input[str] assigned_to: The name of the user the incident is assigned to.
        :param pulumi.Input[str] email: The email of the user the incident is assigned to.
        :param pulumi.Input[str] object_id: The object id of the user the incident is assigned to.
        :param pulumi.Input[str] user_principal_name: The user principal name of the user the incident is assigned to.
        """
        if assigned_to is not None:
            pulumi.set(__self__, "assigned_to", assigned_to)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if object_id is not None:
            pulumi.set(__self__, "object_id", object_id)
        if user_principal_name is not None:
            pulumi.set(__self__, "user_principal_name", user_principal_name)

    @property
    @pulumi.getter(name="assignedTo")
    def assigned_to(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the user the incident is assigned to.
        """
        return pulumi.get(self, "assigned_to")

    @assigned_to.setter
    def assigned_to(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "assigned_to", value)

    @property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input[str]]:
        """
        The email of the user the incident is assigned to.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "email", value)

    @property
    @pulumi.getter(name="objectId")
    def object_id(self) -> Optional[pulumi.Input[str]]:
        """
        The object id of the user the incident is assigned to.
        """
        return pulumi.get(self, "object_id")

    @object_id.setter
    def object_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "object_id", value)

    @property
    @pulumi.getter(name="userPrincipalName")
    def user_principal_name(self) -> Optional[pulumi.Input[str]]:
        """
        The user principal name of the user the incident is assigned to.
        """
        return pulumi.get(self, "user_principal_name")

    @user_principal_name.setter
    def user_principal_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_principal_name", value)


@pulumi.input_type
class InstructionStepsInstructionsArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[Union[str, 'SettingType']],
                 parameters: Optional[Any] = None):
        """
        :param pulumi.Input[Union[str, 'SettingType']] type: The kind of the setting
        :param Any parameters: The parameters for the setting
        """
        pulumi.set(__self__, "type", type)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[Union[str, 'SettingType']]:
        """
        The kind of the setting
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[Union[str, 'SettingType']]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Any]:
        """
        The parameters for the setting
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[Any]):
        pulumi.set(self, "parameters", value)


@pulumi.input_type
class MCASDataConnectorDataTypesArgs:
    def __init__(__self__, *,
                 alerts: pulumi.Input['DataConnectorDataTypeCommonArgs'],
                 discovery_logs: Optional[pulumi.Input['DataConnectorDataTypeCommonArgs']] = None):
        """
        The available data types for MCAS (Microsoft Cloud App Security) data connector.
        :param pulumi.Input['DataConnectorDataTypeCommonArgs'] alerts: Alerts data type connection.
        :param pulumi.Input['DataConnectorDataTypeCommonArgs'] discovery_logs: Discovery log data type connection.
        """
        pulumi.set(__self__, "alerts", alerts)
        if discovery_logs is not None:
            pulumi.set(__self__, "discovery_logs", discovery_logs)

    @property
    @pulumi.getter
    def alerts(self) -> pulumi.Input['DataConnectorDataTypeCommonArgs']:
        """
        Alerts data type connection.
        """
        return pulumi.get(self, "alerts")

    @alerts.setter
    def alerts(self, value: pulumi.Input['DataConnectorDataTypeCommonArgs']):
        pulumi.set(self, "alerts", value)

    @property
    @pulumi.getter(name="discoveryLogs")
    def discovery_logs(self) -> Optional[pulumi.Input['DataConnectorDataTypeCommonArgs']]:
        """
        Discovery log data type connection.
        """
        return pulumi.get(self, "discovery_logs")

    @discovery_logs.setter
    def discovery_logs(self, value: Optional[pulumi.Input['DataConnectorDataTypeCommonArgs']]):
        pulumi.set(self, "discovery_logs", value)


@pulumi.input_type
class MSTIDataConnectorDataTypesBingSafetyPhishingURLArgs:
    def __init__(__self__, *,
                 lookback_period: pulumi.Input[str],
                 state: pulumi.Input[Union[str, 'DataTypeState']]):
        """
        Data type for Microsoft Threat Intelligence Platforms data connector.
        :param pulumi.Input[str] lookback_period: lookback period
        :param pulumi.Input[Union[str, 'DataTypeState']] state: Describe whether this data type connection is enabled or not.
        """
        pulumi.set(__self__, "lookback_period", lookback_period)
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="lookbackPeriod")
    def lookback_period(self) -> pulumi.Input[str]:
        """
        lookback period
        """
        return pulumi.get(self, "lookback_period")

    @lookback_period.setter
    def lookback_period(self, value: pulumi.Input[str]):
        pulumi.set(self, "lookback_period", value)

    @property
    @pulumi.getter
    def state(self) -> pulumi.Input[Union[str, 'DataTypeState']]:
        """
        Describe whether this data type connection is enabled or not.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: pulumi.Input[Union[str, 'DataTypeState']]):
        pulumi.set(self, "state", value)


@pulumi.input_type
class MSTIDataConnectorDataTypesMicrosoftEmergingThreatFeedArgs:
    def __init__(__self__, *,
                 lookback_period: pulumi.Input[str],
                 state: pulumi.Input[Union[str, 'DataTypeState']]):
        """
        Data type for Microsoft Threat Intelligence Platforms data connector.
        :param pulumi.Input[str] lookback_period: lookback period
        :param pulumi.Input[Union[str, 'DataTypeState']] state: Describe whether this data type connection is enabled or not.
        """
        pulumi.set(__self__, "lookback_period", lookback_period)
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="lookbackPeriod")
    def lookback_period(self) -> pulumi.Input[str]:
        """
        lookback period
        """
        return pulumi.get(self, "lookback_period")

    @lookback_period.setter
    def lookback_period(self, value: pulumi.Input[str]):
        pulumi.set(self, "lookback_period", value)

    @property
    @pulumi.getter
    def state(self) -> pulumi.Input[Union[str, 'DataTypeState']]:
        """
        Describe whether this data type connection is enabled or not.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: pulumi.Input[Union[str, 'DataTypeState']]):
        pulumi.set(self, "state", value)


@pulumi.input_type
class MSTIDataConnectorDataTypesArgs:
    def __init__(__self__, *,
                 bing_safety_phishing_url: pulumi.Input['MSTIDataConnectorDataTypesBingSafetyPhishingURLArgs'],
                 microsoft_emerging_threat_feed: pulumi.Input['MSTIDataConnectorDataTypesMicrosoftEmergingThreatFeedArgs']):
        """
        The available data types for Microsoft Threat Intelligence Platforms data connector.
        :param pulumi.Input['MSTIDataConnectorDataTypesBingSafetyPhishingURLArgs'] bing_safety_phishing_url: Data type for Microsoft Threat Intelligence Platforms data connector.
        :param pulumi.Input['MSTIDataConnectorDataTypesMicrosoftEmergingThreatFeedArgs'] microsoft_emerging_threat_feed: Data type for Microsoft Threat Intelligence Platforms data connector.
        """
        pulumi.set(__self__, "bing_safety_phishing_url", bing_safety_phishing_url)
        pulumi.set(__self__, "microsoft_emerging_threat_feed", microsoft_emerging_threat_feed)

    @property
    @pulumi.getter(name="bingSafetyPhishingURL")
    def bing_safety_phishing_url(self) -> pulumi.Input['MSTIDataConnectorDataTypesBingSafetyPhishingURLArgs']:
        """
        Data type for Microsoft Threat Intelligence Platforms data connector.
        """
        return pulumi.get(self, "bing_safety_phishing_url")

    @bing_safety_phishing_url.setter
    def bing_safety_phishing_url(self, value: pulumi.Input['MSTIDataConnectorDataTypesBingSafetyPhishingURLArgs']):
        pulumi.set(self, "bing_safety_phishing_url", value)

    @property
    @pulumi.getter(name="microsoftEmergingThreatFeed")
    def microsoft_emerging_threat_feed(self) -> pulumi.Input['MSTIDataConnectorDataTypesMicrosoftEmergingThreatFeedArgs']:
        """
        Data type for Microsoft Threat Intelligence Platforms data connector.
        """
        return pulumi.get(self, "microsoft_emerging_threat_feed")

    @microsoft_emerging_threat_feed.setter
    def microsoft_emerging_threat_feed(self, value: pulumi.Input['MSTIDataConnectorDataTypesMicrosoftEmergingThreatFeedArgs']):
        pulumi.set(self, "microsoft_emerging_threat_feed", value)


@pulumi.input_type
class MTPDataConnectorDataTypesIncidentsArgs:
    def __init__(__self__, *,
                 state: pulumi.Input[Union[str, 'DataTypeState']]):
        """
        Data type for Microsoft Threat Protection Platforms data connector.
        :param pulumi.Input[Union[str, 'DataTypeState']] state: Describe whether this data type connection is enabled or not.
        """
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def state(self) -> pulumi.Input[Union[str, 'DataTypeState']]:
        """
        Describe whether this data type connection is enabled or not.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: pulumi.Input[Union[str, 'DataTypeState']]):
        pulumi.set(self, "state", value)


@pulumi.input_type
class MTPDataConnectorDataTypesArgs:
    def __init__(__self__, *,
                 incidents: pulumi.Input['MTPDataConnectorDataTypesIncidentsArgs']):
        """
        The available data types for Microsoft Threat Protection Platforms data connector.
        :param pulumi.Input['MTPDataConnectorDataTypesIncidentsArgs'] incidents: Data type for Microsoft Threat Protection Platforms data connector.
        """
        pulumi.set(__self__, "incidents", incidents)

    @property
    @pulumi.getter
    def incidents(self) -> pulumi.Input['MTPDataConnectorDataTypesIncidentsArgs']:
        """
        Data type for Microsoft Threat Protection Platforms data connector.
        """
        return pulumi.get(self, "incidents")

    @incidents.setter
    def incidents(self, value: pulumi.Input['MTPDataConnectorDataTypesIncidentsArgs']):
        pulumi.set(self, "incidents", value)


@pulumi.input_type
class MetadataAuthorArgs:
    def __init__(__self__, *,
                 email: Optional[pulumi.Input[str]] = None,
                 link: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        Publisher or creator of the content item.
        :param pulumi.Input[str] email: Email of author contact
        :param pulumi.Input[str] link: Link for author/vendor page
        :param pulumi.Input[str] name: Name of the author. Company or person.
        """
        if email is not None:
            pulumi.set(__self__, "email", email)
        if link is not None:
            pulumi.set(__self__, "link", link)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input[str]]:
        """
        Email of author contact
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "email", value)

    @property
    @pulumi.getter
    def link(self) -> Optional[pulumi.Input[str]]:
        """
        Link for author/vendor page
        """
        return pulumi.get(self, "link")

    @link.setter
    def link(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "link", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the author. Company or person.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class MetadataCategoriesArgs:
    def __init__(__self__, *,
                 domains: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 verticals: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        ies for the solution content item
        :param pulumi.Input[Sequence[pulumi.Input[str]]] domains: domain for the solution content item
        :param pulumi.Input[Sequence[pulumi.Input[str]]] verticals: Industry verticals for the solution content item
        """
        if domains is not None:
            pulumi.set(__self__, "domains", domains)
        if verticals is not None:
            pulumi.set(__self__, "verticals", verticals)

    @property
    @pulumi.getter
    def domains(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        domain for the solution content item
        """
        return pulumi.get(self, "domains")

    @domains.setter
    def domains(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "domains", value)

    @property
    @pulumi.getter
    def verticals(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Industry verticals for the solution content item
        """
        return pulumi.get(self, "verticals")

    @verticals.setter
    def verticals(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "verticals", value)


@pulumi.input_type
class MetadataDependenciesArgs:
    def __init__(__self__, *,
                 content_id: Optional[pulumi.Input[str]] = None,
                 criteria: Optional[pulumi.Input[Sequence[pulumi.Input['MetadataDependenciesArgs']]]] = None,
                 kind: Optional[pulumi.Input[Union[str, 'Kind']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 operator: Optional[pulumi.Input[Union[str, 'Operator']]] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        Dependencies for the content item, what other content items it requires to work.  Can describe more complex dependencies using a recursive/nested structure. For a single dependency an id/kind/version can be supplied or operator/criteria for complex dependencies.
        :param pulumi.Input[str] content_id: Id of the content item we depend on
        :param pulumi.Input[Sequence[pulumi.Input['MetadataDependenciesArgs']]] criteria: This is the list of dependencies we must fulfill, according to the AND/OR operator
        :param pulumi.Input[Union[str, 'Kind']] kind: Type of the content item we depend on
        :param pulumi.Input[str] name: Name of the content item
        :param pulumi.Input[Union[str, 'Operator']] operator: Operator used for list of dependencies in criteria array.
        :param pulumi.Input[str] version: Version of the the content item we depend on.  Can be blank, * or missing to indicate any version fulfills the dependency.  If version does not match our defined numeric format then an exact match is required.
        """
        if content_id is not None:
            pulumi.set(__self__, "content_id", content_id)
        if criteria is not None:
            pulumi.set(__self__, "criteria", criteria)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if operator is not None:
            pulumi.set(__self__, "operator", operator)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="contentId")
    def content_id(self) -> Optional[pulumi.Input[str]]:
        """
        Id of the content item we depend on
        """
        return pulumi.get(self, "content_id")

    @content_id.setter
    def content_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "content_id", value)

    @property
    @pulumi.getter
    def criteria(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MetadataDependenciesArgs']]]]:
        """
        This is the list of dependencies we must fulfill, according to the AND/OR operator
        """
        return pulumi.get(self, "criteria")

    @criteria.setter
    def criteria(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MetadataDependenciesArgs']]]]):
        pulumi.set(self, "criteria", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[Union[str, 'Kind']]]:
        """
        Type of the content item we depend on
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[Union[str, 'Kind']]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the content item
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def operator(self) -> Optional[pulumi.Input[Union[str, 'Operator']]]:
        """
        Operator used for list of dependencies in criteria array.
        """
        return pulumi.get(self, "operator")

    @operator.setter
    def operator(self, value: Optional[pulumi.Input[Union[str, 'Operator']]]):
        pulumi.set(self, "operator", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        Version of the the content item we depend on.  Can be blank, * or missing to indicate any version fulfills the dependency.  If version does not match our defined numeric format then an exact match is required.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class MetadataSourceArgs:
    def __init__(__self__, *,
                 kind: pulumi.Input[Union[str, 'SourceKind']],
                 name: Optional[pulumi.Input[str]] = None,
                 source_id: Optional[pulumi.Input[str]] = None):
        """
        The original source of the content item, where it comes from.
        :param pulumi.Input[Union[str, 'SourceKind']] kind: Source type of the content
        :param pulumi.Input[str] name: Name of the content source.  The repo name, solution name, LA workspace name etc.
        :param pulumi.Input[str] source_id: ID of the content source.  The solution ID, workspace ID, etc
        """
        pulumi.set(__self__, "kind", kind)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if source_id is not None:
            pulumi.set(__self__, "source_id", source_id)

    @property
    @pulumi.getter
    def kind(self) -> pulumi.Input[Union[str, 'SourceKind']]:
        """
        Source type of the content
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: pulumi.Input[Union[str, 'SourceKind']]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the content source.  The repo name, solution name, LA workspace name etc.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="sourceId")
    def source_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the content source.  The solution ID, workspace ID, etc
        """
        return pulumi.get(self, "source_id")

    @source_id.setter
    def source_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_id", value)


@pulumi.input_type
class MetadataSupportArgs:
    def __init__(__self__, *,
                 tier: pulumi.Input[Union[str, 'SupportTier']],
                 email: Optional[pulumi.Input[str]] = None,
                 link: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        Support information for the content item.
        :param pulumi.Input[Union[str, 'SupportTier']] tier: Type of support for content item
        :param pulumi.Input[str] email: Email of support contact
        :param pulumi.Input[str] link: Link for support help, like to support page to open a ticket etc.
        :param pulumi.Input[str] name: Name of the support contact. Company or person.
        """
        pulumi.set(__self__, "tier", tier)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if link is not None:
            pulumi.set(__self__, "link", link)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def tier(self) -> pulumi.Input[Union[str, 'SupportTier']]:
        """
        Type of support for content item
        """
        return pulumi.get(self, "tier")

    @tier.setter
    def tier(self, value: pulumi.Input[Union[str, 'SupportTier']]):
        pulumi.set(self, "tier", value)

    @property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input[str]]:
        """
        Email of support contact
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "email", value)

    @property
    @pulumi.getter
    def link(self) -> Optional[pulumi.Input[str]]:
        """
        Link for support help, like to support page to open a ticket etc.
        """
        return pulumi.get(self, "link")

    @link.setter
    def link(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "link", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the support contact. Company or person.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class OfficeDataConnectorDataTypesExchangeArgs:
    def __init__(__self__, *,
                 state: pulumi.Input[Union[str, 'DataTypeState']]):
        """
        Exchange data type connection.
        :param pulumi.Input[Union[str, 'DataTypeState']] state: Describe whether this data type connection is enabled or not.
        """
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def state(self) -> pulumi.Input[Union[str, 'DataTypeState']]:
        """
        Describe whether this data type connection is enabled or not.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: pulumi.Input[Union[str, 'DataTypeState']]):
        pulumi.set(self, "state", value)


@pulumi.input_type
class OfficeDataConnectorDataTypesSharePointArgs:
    def __init__(__self__, *,
                 state: pulumi.Input[Union[str, 'DataTypeState']]):
        """
        SharePoint data type connection.
        :param pulumi.Input[Union[str, 'DataTypeState']] state: Describe whether this data type connection is enabled or not.
        """
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def state(self) -> pulumi.Input[Union[str, 'DataTypeState']]:
        """
        Describe whether this data type connection is enabled or not.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: pulumi.Input[Union[str, 'DataTypeState']]):
        pulumi.set(self, "state", value)


@pulumi.input_type
class OfficeDataConnectorDataTypesTeamsArgs:
    def __init__(__self__, *,
                 state: pulumi.Input[Union[str, 'DataTypeState']]):
        """
        Teams data type connection.
        :param pulumi.Input[Union[str, 'DataTypeState']] state: Describe whether this data type connection is enabled or not.
        """
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def state(self) -> pulumi.Input[Union[str, 'DataTypeState']]:
        """
        Describe whether this data type connection is enabled or not.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: pulumi.Input[Union[str, 'DataTypeState']]):
        pulumi.set(self, "state", value)


@pulumi.input_type
class OfficeDataConnectorDataTypesArgs:
    def __init__(__self__, *,
                 exchange: pulumi.Input['OfficeDataConnectorDataTypesExchangeArgs'],
                 share_point: pulumi.Input['OfficeDataConnectorDataTypesSharePointArgs'],
                 teams: pulumi.Input['OfficeDataConnectorDataTypesTeamsArgs']):
        """
        The available data types for office data connector.
        :param pulumi.Input['OfficeDataConnectorDataTypesExchangeArgs'] exchange: Exchange data type connection.
        :param pulumi.Input['OfficeDataConnectorDataTypesSharePointArgs'] share_point: SharePoint data type connection.
        :param pulumi.Input['OfficeDataConnectorDataTypesTeamsArgs'] teams: Teams data type connection.
        """
        pulumi.set(__self__, "exchange", exchange)
        pulumi.set(__self__, "share_point", share_point)
        pulumi.set(__self__, "teams", teams)

    @property
    @pulumi.getter
    def exchange(self) -> pulumi.Input['OfficeDataConnectorDataTypesExchangeArgs']:
        """
        Exchange data type connection.
        """
        return pulumi.get(self, "exchange")

    @exchange.setter
    def exchange(self, value: pulumi.Input['OfficeDataConnectorDataTypesExchangeArgs']):
        pulumi.set(self, "exchange", value)

    @property
    @pulumi.getter(name="sharePoint")
    def share_point(self) -> pulumi.Input['OfficeDataConnectorDataTypesSharePointArgs']:
        """
        SharePoint data type connection.
        """
        return pulumi.get(self, "share_point")

    @share_point.setter
    def share_point(self, value: pulumi.Input['OfficeDataConnectorDataTypesSharePointArgs']):
        pulumi.set(self, "share_point", value)

    @property
    @pulumi.getter
    def teams(self) -> pulumi.Input['OfficeDataConnectorDataTypesTeamsArgs']:
        """
        Teams data type connection.
        """
        return pulumi.get(self, "teams")

    @teams.setter
    def teams(self, value: pulumi.Input['OfficeDataConnectorDataTypesTeamsArgs']):
        pulumi.set(self, "teams", value)


@pulumi.input_type
class PermissionsCustomsArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] description: Customs permissions description
        :param pulumi.Input[str] name: Customs permissions name
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Customs permissions description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Customs permissions name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class PermissionsResourceProviderArgs:
    def __init__(__self__, *,
                 permissions_display_text: Optional[pulumi.Input[str]] = None,
                 provider: Optional[pulumi.Input[Union[str, 'ProviderName']]] = None,
                 provider_display_name: Optional[pulumi.Input[str]] = None,
                 required_permissions: Optional[pulumi.Input['RequiredPermissionsArgs']] = None,
                 scope: Optional[pulumi.Input[Union[str, 'PermissionProviderScope']]] = None):
        """
        :param pulumi.Input[str] permissions_display_text: Permission description text
        :param pulumi.Input[Union[str, 'ProviderName']] provider: Provider name
        :param pulumi.Input[str] provider_display_name: Permission provider display name
        :param pulumi.Input['RequiredPermissionsArgs'] required_permissions: Required permissions for the connector
        :param pulumi.Input[Union[str, 'PermissionProviderScope']] scope: Permission provider scope
        """
        if permissions_display_text is not None:
            pulumi.set(__self__, "permissions_display_text", permissions_display_text)
        if provider is not None:
            pulumi.set(__self__, "provider", provider)
        if provider_display_name is not None:
            pulumi.set(__self__, "provider_display_name", provider_display_name)
        if required_permissions is not None:
            pulumi.set(__self__, "required_permissions", required_permissions)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)

    @property
    @pulumi.getter(name="permissionsDisplayText")
    def permissions_display_text(self) -> Optional[pulumi.Input[str]]:
        """
        Permission description text
        """
        return pulumi.get(self, "permissions_display_text")

    @permissions_display_text.setter
    def permissions_display_text(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "permissions_display_text", value)

    @property
    @pulumi.getter
    def provider(self) -> Optional[pulumi.Input[Union[str, 'ProviderName']]]:
        """
        Provider name
        """
        return pulumi.get(self, "provider")

    @provider.setter
    def provider(self, value: Optional[pulumi.Input[Union[str, 'ProviderName']]]):
        pulumi.set(self, "provider", value)

    @property
    @pulumi.getter(name="providerDisplayName")
    def provider_display_name(self) -> Optional[pulumi.Input[str]]:
        """
        Permission provider display name
        """
        return pulumi.get(self, "provider_display_name")

    @provider_display_name.setter
    def provider_display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "provider_display_name", value)

    @property
    @pulumi.getter(name="requiredPermissions")
    def required_permissions(self) -> Optional[pulumi.Input['RequiredPermissionsArgs']]:
        """
        Required permissions for the connector
        """
        return pulumi.get(self, "required_permissions")

    @required_permissions.setter
    def required_permissions(self, value: Optional[pulumi.Input['RequiredPermissionsArgs']]):
        pulumi.set(self, "required_permissions", value)

    @property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input[Union[str, 'PermissionProviderScope']]]:
        """
        Permission provider scope
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input[Union[str, 'PermissionProviderScope']]]):
        pulumi.set(self, "scope", value)


@pulumi.input_type
class PermissionsArgs:
    def __init__(__self__, *,
                 customs: Optional[pulumi.Input[Sequence[pulumi.Input['PermissionsCustomsArgs']]]] = None,
                 resource_provider: Optional[pulumi.Input[Sequence[pulumi.Input['PermissionsResourceProviderArgs']]]] = None):
        """
        Permissions required for the connector
        :param pulumi.Input[Sequence[pulumi.Input['PermissionsCustomsArgs']]] customs: Customs permissions required for the connector
        :param pulumi.Input[Sequence[pulumi.Input['PermissionsResourceProviderArgs']]] resource_provider: Resource provider permissions required for the connector
        """
        if customs is not None:
            pulumi.set(__self__, "customs", customs)
        if resource_provider is not None:
            pulumi.set(__self__, "resource_provider", resource_provider)

    @property
    @pulumi.getter
    def customs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PermissionsCustomsArgs']]]]:
        """
        Customs permissions required for the connector
        """
        return pulumi.get(self, "customs")

    @customs.setter
    def customs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PermissionsCustomsArgs']]]]):
        pulumi.set(self, "customs", value)

    @property
    @pulumi.getter(name="resourceProvider")
    def resource_provider(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PermissionsResourceProviderArgs']]]]:
        """
        Resource provider permissions required for the connector
        """
        return pulumi.get(self, "resource_provider")

    @resource_provider.setter
    def resource_provider(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PermissionsResourceProviderArgs']]]]):
        pulumi.set(self, "resource_provider", value)


@pulumi.input_type
class RepositoryArgs:
    def __init__(__self__, *,
                 branch: Optional[pulumi.Input[str]] = None,
                 deployment_logs_url: Optional[pulumi.Input[str]] = None,
                 display_url: Optional[pulumi.Input[str]] = None,
                 path_mapping: Optional[pulumi.Input[Sequence[pulumi.Input['ContentPathMapArgs']]]] = None,
                 url: Optional[pulumi.Input[str]] = None):
        """
        metadata of a repository.
        :param pulumi.Input[str] branch: Branch name of repository.
        :param pulumi.Input[str] deployment_logs_url: Url to access repository action logs.
        :param pulumi.Input[str] display_url: Display url of repository.
        :param pulumi.Input[Sequence[pulumi.Input['ContentPathMapArgs']]] path_mapping: Dictionary of source control content type and path mapping.
        :param pulumi.Input[str] url: Url of repository.
        """
        if branch is not None:
            pulumi.set(__self__, "branch", branch)
        if deployment_logs_url is not None:
            pulumi.set(__self__, "deployment_logs_url", deployment_logs_url)
        if display_url is not None:
            pulumi.set(__self__, "display_url", display_url)
        if path_mapping is not None:
            pulumi.set(__self__, "path_mapping", path_mapping)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def branch(self) -> Optional[pulumi.Input[str]]:
        """
        Branch name of repository.
        """
        return pulumi.get(self, "branch")

    @branch.setter
    def branch(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "branch", value)

    @property
    @pulumi.getter(name="deploymentLogsUrl")
    def deployment_logs_url(self) -> Optional[pulumi.Input[str]]:
        """
        Url to access repository action logs.
        """
        return pulumi.get(self, "deployment_logs_url")

    @deployment_logs_url.setter
    def deployment_logs_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deployment_logs_url", value)

    @property
    @pulumi.getter(name="displayUrl")
    def display_url(self) -> Optional[pulumi.Input[str]]:
        """
        Display url of repository.
        """
        return pulumi.get(self, "display_url")

    @display_url.setter
    def display_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_url", value)

    @property
    @pulumi.getter(name="pathMapping")
    def path_mapping(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContentPathMapArgs']]]]:
        """
        Dictionary of source control content type and path mapping.
        """
        return pulumi.get(self, "path_mapping")

    @path_mapping.setter
    def path_mapping(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContentPathMapArgs']]]]):
        pulumi.set(self, "path_mapping", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[str]]:
        """
        Url of repository.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url", value)


@pulumi.input_type
class RequiredPermissionsArgs:
    def __init__(__self__, *,
                 action: Optional[pulumi.Input[bool]] = None,
                 delete: Optional[pulumi.Input[bool]] = None,
                 read: Optional[pulumi.Input[bool]] = None,
                 write: Optional[pulumi.Input[bool]] = None):
        """
        Required permissions for the connector
        :param pulumi.Input[bool] action: action permission
        :param pulumi.Input[bool] delete: delete permission
        :param pulumi.Input[bool] read: read permission
        :param pulumi.Input[bool] write: write permission
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if delete is not None:
            pulumi.set(__self__, "delete", delete)
        if read is not None:
            pulumi.set(__self__, "read", read)
        if write is not None:
            pulumi.set(__self__, "write", write)

    @property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input[bool]]:
        """
        action permission
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter
    def delete(self) -> Optional[pulumi.Input[bool]]:
        """
        delete permission
        """
        return pulumi.get(self, "delete")

    @delete.setter
    def delete(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "delete", value)

    @property
    @pulumi.getter
    def read(self) -> Optional[pulumi.Input[bool]]:
        """
        read permission
        """
        return pulumi.get(self, "read")

    @read.setter
    def read(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "read", value)

    @property
    @pulumi.getter
    def write(self) -> Optional[pulumi.Input[bool]]:
        """
        write permission
        """
        return pulumi.get(self, "write")

    @write.setter
    def write(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "write", value)


@pulumi.input_type
class TIDataConnectorDataTypesIndicatorsArgs:
    def __init__(__self__, *,
                 state: pulumi.Input[Union[str, 'DataTypeState']]):
        """
        Data type for indicators connection.
        :param pulumi.Input[Union[str, 'DataTypeState']] state: Describe whether this data type connection is enabled or not.
        """
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def state(self) -> pulumi.Input[Union[str, 'DataTypeState']]:
        """
        Describe whether this data type connection is enabled or not.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: pulumi.Input[Union[str, 'DataTypeState']]):
        pulumi.set(self, "state", value)


@pulumi.input_type
class TIDataConnectorDataTypesArgs:
    def __init__(__self__, *,
                 indicators: pulumi.Input['TIDataConnectorDataTypesIndicatorsArgs']):
        """
        The available data types for TI (Threat Intelligence) data connector.
        :param pulumi.Input['TIDataConnectorDataTypesIndicatorsArgs'] indicators: Data type for indicators connection.
        """
        pulumi.set(__self__, "indicators", indicators)

    @property
    @pulumi.getter
    def indicators(self) -> pulumi.Input['TIDataConnectorDataTypesIndicatorsArgs']:
        """
        Data type for indicators connection.
        """
        return pulumi.get(self, "indicators")

    @indicators.setter
    def indicators(self, value: pulumi.Input['TIDataConnectorDataTypesIndicatorsArgs']):
        pulumi.set(self, "indicators", value)


@pulumi.input_type
class TiTaxiiDataConnectorDataTypesTaxiiClientArgs:
    def __init__(__self__, *,
                 state: pulumi.Input[Union[str, 'DataTypeState']]):
        """
        Data type for TAXII connector.
        :param pulumi.Input[Union[str, 'DataTypeState']] state: Describe whether this data type connection is enabled or not.
        """
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def state(self) -> pulumi.Input[Union[str, 'DataTypeState']]:
        """
        Describe whether this data type connection is enabled or not.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: pulumi.Input[Union[str, 'DataTypeState']]):
        pulumi.set(self, "state", value)


@pulumi.input_type
class TiTaxiiDataConnectorDataTypesArgs:
    def __init__(__self__, *,
                 taxii_client: pulumi.Input['TiTaxiiDataConnectorDataTypesTaxiiClientArgs']):
        """
        The available data types for Threat Intelligence TAXII data connector.
        :param pulumi.Input['TiTaxiiDataConnectorDataTypesTaxiiClientArgs'] taxii_client: Data type for TAXII connector.
        """
        pulumi.set(__self__, "taxii_client", taxii_client)

    @property
    @pulumi.getter(name="taxiiClient")
    def taxii_client(self) -> pulumi.Input['TiTaxiiDataConnectorDataTypesTaxiiClientArgs']:
        """
        Data type for TAXII connector.
        """
        return pulumi.get(self, "taxii_client")

    @taxii_client.setter
    def taxii_client(self, value: pulumi.Input['TiTaxiiDataConnectorDataTypesTaxiiClientArgs']):
        pulumi.set(self, "taxii_client", value)


@pulumi.input_type
class WatchlistUserInfoArgs:
    def __init__(__self__, *,
                 object_id: Optional[pulumi.Input[str]] = None):
        """
        User information that made some action
        :param pulumi.Input[str] object_id: The object id of the user.
        """
        if object_id is not None:
            pulumi.set(__self__, "object_id", object_id)

    @property
    @pulumi.getter(name="objectId")
    def object_id(self) -> Optional[pulumi.Input[str]]:
        """
        The object id of the user.
        """
        return pulumi.get(self, "object_id")

    @object_id.setter
    def object_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "object_id", value)


