# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'CertificatePropertiesResponse',
    'IotDpsPropertiesDescriptionResponse',
    'IotDpsSkuInfoResponse',
    'IotHubDefinitionDescriptionResponse',
    'SharedAccessSignatureAuthorizationRuleAccessRightsDescriptionResponse',
    'TargetIpFilterRuleResponse',
]

@pulumi.output_type
class CertificatePropertiesResponse(dict):
    """
    The description of an X509 CA Certificate.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isVerified":
            suggest = "is_verified"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificatePropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificatePropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificatePropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 certificate: str,
                 created: str,
                 expiry: str,
                 is_verified: bool,
                 subject: str,
                 thumbprint: str,
                 updated: str):
        """
        The description of an X509 CA Certificate.
        :param str certificate: base-64 representation of X509 certificate .cer file or just .pem file content.
        :param str created: The certificate's creation date and time.
        :param str expiry: The certificate's expiration date and time.
        :param bool is_verified: Determines whether certificate has been verified.
        :param str subject: The certificate's subject name.
        :param str thumbprint: The certificate's thumbprint.
        :param str updated: The certificate's last update date and time.
        """
        pulumi.set(__self__, "certificate", certificate)
        pulumi.set(__self__, "created", created)
        pulumi.set(__self__, "expiry", expiry)
        pulumi.set(__self__, "is_verified", is_verified)
        pulumi.set(__self__, "subject", subject)
        pulumi.set(__self__, "thumbprint", thumbprint)
        pulumi.set(__self__, "updated", updated)

    @property
    @pulumi.getter
    def certificate(self) -> str:
        """
        base-64 representation of X509 certificate .cer file or just .pem file content.
        """
        return pulumi.get(self, "certificate")

    @property
    @pulumi.getter
    def created(self) -> str:
        """
        The certificate's creation date and time.
        """
        return pulumi.get(self, "created")

    @property
    @pulumi.getter
    def expiry(self) -> str:
        """
        The certificate's expiration date and time.
        """
        return pulumi.get(self, "expiry")

    @property
    @pulumi.getter(name="isVerified")
    def is_verified(self) -> bool:
        """
        Determines whether certificate has been verified.
        """
        return pulumi.get(self, "is_verified")

    @property
    @pulumi.getter
    def subject(self) -> str:
        """
        The certificate's subject name.
        """
        return pulumi.get(self, "subject")

    @property
    @pulumi.getter
    def thumbprint(self) -> str:
        """
        The certificate's thumbprint.
        """
        return pulumi.get(self, "thumbprint")

    @property
    @pulumi.getter
    def updated(self) -> str:
        """
        The certificate's last update date and time.
        """
        return pulumi.get(self, "updated")


@pulumi.output_type
class IotDpsPropertiesDescriptionResponse(dict):
    """
    the service specific properties of a provisioning service, including keys, linked iot hubs, current state, and system generated properties such as hostname and idScope
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deviceProvisioningHostName":
            suggest = "device_provisioning_host_name"
        elif key == "idScope":
            suggest = "id_scope"
        elif key == "serviceOperationsHostName":
            suggest = "service_operations_host_name"
        elif key == "allocationPolicy":
            suggest = "allocation_policy"
        elif key == "authorizationPolicies":
            suggest = "authorization_policies"
        elif key == "iotHubs":
            suggest = "iot_hubs"
        elif key == "ipFilterRules":
            suggest = "ip_filter_rules"
        elif key == "provisioningState":
            suggest = "provisioning_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IotDpsPropertiesDescriptionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IotDpsPropertiesDescriptionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IotDpsPropertiesDescriptionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 device_provisioning_host_name: str,
                 id_scope: str,
                 service_operations_host_name: str,
                 allocation_policy: Optional[str] = None,
                 authorization_policies: Optional[Sequence['outputs.SharedAccessSignatureAuthorizationRuleAccessRightsDescriptionResponse']] = None,
                 iot_hubs: Optional[Sequence['outputs.IotHubDefinitionDescriptionResponse']] = None,
                 ip_filter_rules: Optional[Sequence['outputs.TargetIpFilterRuleResponse']] = None,
                 provisioning_state: Optional[str] = None,
                 state: Optional[str] = None):
        """
        the service specific properties of a provisioning service, including keys, linked iot hubs, current state, and system generated properties such as hostname and idScope
        :param str device_provisioning_host_name: Device endpoint for this provisioning service.
        :param str id_scope: Unique identifier of this provisioning service.
        :param str service_operations_host_name: Service endpoint for provisioning service.
        :param str allocation_policy: Allocation policy to be used by this provisioning service.
        :param Sequence['SharedAccessSignatureAuthorizationRuleAccessRightsDescriptionResponse'] authorization_policies: List of authorization keys for a provisioning service.
        :param Sequence['IotHubDefinitionDescriptionResponse'] iot_hubs: List of IoT hubs associated with this provisioning service.
        :param Sequence['TargetIpFilterRuleResponse'] ip_filter_rules: The IP filter rules.
        :param str provisioning_state: The ARM provisioning state of the provisioning service.
        :param str state: Current state of the provisioning service.
        """
        pulumi.set(__self__, "device_provisioning_host_name", device_provisioning_host_name)
        pulumi.set(__self__, "id_scope", id_scope)
        pulumi.set(__self__, "service_operations_host_name", service_operations_host_name)
        if allocation_policy is not None:
            pulumi.set(__self__, "allocation_policy", allocation_policy)
        if authorization_policies is not None:
            pulumi.set(__self__, "authorization_policies", authorization_policies)
        if iot_hubs is not None:
            pulumi.set(__self__, "iot_hubs", iot_hubs)
        if ip_filter_rules is not None:
            pulumi.set(__self__, "ip_filter_rules", ip_filter_rules)
        if provisioning_state is not None:
            pulumi.set(__self__, "provisioning_state", provisioning_state)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="deviceProvisioningHostName")
    def device_provisioning_host_name(self) -> str:
        """
        Device endpoint for this provisioning service.
        """
        return pulumi.get(self, "device_provisioning_host_name")

    @property
    @pulumi.getter(name="idScope")
    def id_scope(self) -> str:
        """
        Unique identifier of this provisioning service.
        """
        return pulumi.get(self, "id_scope")

    @property
    @pulumi.getter(name="serviceOperationsHostName")
    def service_operations_host_name(self) -> str:
        """
        Service endpoint for provisioning service.
        """
        return pulumi.get(self, "service_operations_host_name")

    @property
    @pulumi.getter(name="allocationPolicy")
    def allocation_policy(self) -> Optional[str]:
        """
        Allocation policy to be used by this provisioning service.
        """
        return pulumi.get(self, "allocation_policy")

    @property
    @pulumi.getter(name="authorizationPolicies")
    def authorization_policies(self) -> Optional[Sequence['outputs.SharedAccessSignatureAuthorizationRuleAccessRightsDescriptionResponse']]:
        """
        List of authorization keys for a provisioning service.
        """
        return pulumi.get(self, "authorization_policies")

    @property
    @pulumi.getter(name="iotHubs")
    def iot_hubs(self) -> Optional[Sequence['outputs.IotHubDefinitionDescriptionResponse']]:
        """
        List of IoT hubs associated with this provisioning service.
        """
        return pulumi.get(self, "iot_hubs")

    @property
    @pulumi.getter(name="ipFilterRules")
    def ip_filter_rules(self) -> Optional[Sequence['outputs.TargetIpFilterRuleResponse']]:
        """
        The IP filter rules.
        """
        return pulumi.get(self, "ip_filter_rules")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> Optional[str]:
        """
        The ARM provisioning state of the provisioning service.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        Current state of the provisioning service.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class IotDpsSkuInfoResponse(dict):
    """
    List of possible provisioning service SKUs.
    """
    def __init__(__self__, *,
                 tier: str,
                 capacity: Optional[float] = None,
                 name: Optional[str] = None):
        """
        List of possible provisioning service SKUs.
        :param str tier: Pricing tier name of the provisioning service.
        :param float capacity: The number of units to provision
        :param str name: Sku name.
        """
        pulumi.set(__self__, "tier", tier)
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def tier(self) -> str:
        """
        Pricing tier name of the provisioning service.
        """
        return pulumi.get(self, "tier")

    @property
    @pulumi.getter
    def capacity(self) -> Optional[float]:
        """
        The number of units to provision
        """
        return pulumi.get(self, "capacity")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Sku name.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class IotHubDefinitionDescriptionResponse(dict):
    """
    Description of the IoT hub.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectionString":
            suggest = "connection_string"
        elif key == "allocationWeight":
            suggest = "allocation_weight"
        elif key == "applyAllocationPolicy":
            suggest = "apply_allocation_policy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IotHubDefinitionDescriptionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IotHubDefinitionDescriptionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IotHubDefinitionDescriptionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connection_string: str,
                 location: str,
                 name: str,
                 allocation_weight: Optional[int] = None,
                 apply_allocation_policy: Optional[bool] = None):
        """
        Description of the IoT hub.
        :param str connection_string: Connection string og the IoT hub.
        :param str location: ARM region of the IoT hub.
        :param str name: Host name of the IoT hub.
        :param int allocation_weight: weight to apply for a given iot h.
        :param bool apply_allocation_policy: flag for applying allocationPolicy or not for a given iot hub.
        """
        pulumi.set(__self__, "connection_string", connection_string)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "name", name)
        if allocation_weight is not None:
            pulumi.set(__self__, "allocation_weight", allocation_weight)
        if apply_allocation_policy is not None:
            pulumi.set(__self__, "apply_allocation_policy", apply_allocation_policy)

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> str:
        """
        Connection string og the IoT hub.
        """
        return pulumi.get(self, "connection_string")

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        ARM region of the IoT hub.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Host name of the IoT hub.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="allocationWeight")
    def allocation_weight(self) -> Optional[int]:
        """
        weight to apply for a given iot h.
        """
        return pulumi.get(self, "allocation_weight")

    @property
    @pulumi.getter(name="applyAllocationPolicy")
    def apply_allocation_policy(self) -> Optional[bool]:
        """
        flag for applying allocationPolicy or not for a given iot hub.
        """
        return pulumi.get(self, "apply_allocation_policy")


@pulumi.output_type
class SharedAccessSignatureAuthorizationRuleAccessRightsDescriptionResponse(dict):
    """
    Description of the shared access key.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyName":
            suggest = "key_name"
        elif key == "primaryKey":
            suggest = "primary_key"
        elif key == "secondaryKey":
            suggest = "secondary_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SharedAccessSignatureAuthorizationRuleAccessRightsDescriptionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SharedAccessSignatureAuthorizationRuleAccessRightsDescriptionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SharedAccessSignatureAuthorizationRuleAccessRightsDescriptionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_name: str,
                 rights: str,
                 primary_key: Optional[str] = None,
                 secondary_key: Optional[str] = None):
        """
        Description of the shared access key.
        :param str key_name: Name of the key.
        :param str rights: Rights that this key has.
        :param str primary_key: Primary SAS key value.
        :param str secondary_key: Secondary SAS key value.
        """
        pulumi.set(__self__, "key_name", key_name)
        pulumi.set(__self__, "rights", rights)
        if primary_key is not None:
            pulumi.set(__self__, "primary_key", primary_key)
        if secondary_key is not None:
            pulumi.set(__self__, "secondary_key", secondary_key)

    @property
    @pulumi.getter(name="keyName")
    def key_name(self) -> str:
        """
        Name of the key.
        """
        return pulumi.get(self, "key_name")

    @property
    @pulumi.getter
    def rights(self) -> str:
        """
        Rights that this key has.
        """
        return pulumi.get(self, "rights")

    @property
    @pulumi.getter(name="primaryKey")
    def primary_key(self) -> Optional[str]:
        """
        Primary SAS key value.
        """
        return pulumi.get(self, "primary_key")

    @property
    @pulumi.getter(name="secondaryKey")
    def secondary_key(self) -> Optional[str]:
        """
        Secondary SAS key value.
        """
        return pulumi.get(self, "secondary_key")


@pulumi.output_type
class TargetIpFilterRuleResponse(dict):
    """
    The IP filter rules for the IoT dps.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "filterName":
            suggest = "filter_name"
        elif key == "ipMask":
            suggest = "ip_mask"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TargetIpFilterRuleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TargetIpFilterRuleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TargetIpFilterRuleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action: str,
                 filter_name: str,
                 ip_mask: str,
                 target: Optional[str] = None):
        """
        The IP filter rules for the IoT dps.
        :param str action: The desired action for requests captured by this rule.
        :param str filter_name: The name of the IP filter rule.
        :param str ip_mask: A string that contains the IP address range in CIDR notation for the rule.
        :param str target: Target for requests captured by this rule.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "filter_name", filter_name)
        pulumi.set(__self__, "ip_mask", ip_mask)
        if target is not None:
            pulumi.set(__self__, "target", target)

    @property
    @pulumi.getter
    def action(self) -> str:
        """
        The desired action for requests captured by this rule.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter(name="filterName")
    def filter_name(self) -> str:
        """
        The name of the IP filter rule.
        """
        return pulumi.get(self, "filter_name")

    @property
    @pulumi.getter(name="ipMask")
    def ip_mask(self) -> str:
        """
        A string that contains the IP address range in CIDR notation for the rule.
        """
        return pulumi.get(self, "ip_mask")

    @property
    @pulumi.getter
    def target(self) -> Optional[str]:
        """
        Target for requests captured by this rule.
        """
        return pulumi.get(self, "target")


