# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from ._enums import *

__all__ = [
    'ApplicationServerConfigurationArgs',
    'BackupProfileArgs',
    'CacheProfileArgs',
    'CentralServerConfigurationArgs',
    'DB2ProviderInstancePropertiesArgs',
    'DatabaseConfigurationArgs',
    'DatabaseProfileArgs',
    'DeployerVmPackagesArgs',
    'DeploymentConfigurationArgs',
    'DeploymentWithOSConfigurationArgs',
    'DiscoveryConfigurationArgs',
    'DiskInfoArgs',
    'FileshareProfileArgs',
    'HanaDbProviderInstancePropertiesArgs',
    'HighAvailabilityConfigurationArgs',
    'HighAvailabilitySoftwareConfigurationArgs',
    'ImageReferenceArgs',
    'LinuxConfigurationArgs',
    'ManagedRGConfigurationArgs',
    'MsSqlServerProviderInstancePropertiesArgs',
    'NetworkConfigurationArgs',
    'NetworkProfileArgs',
    'NodeProfileArgs',
    'OSProfileArgs',
    'OsImageProfileArgs',
    'OsSapConfigurationArgs',
    'PhpProfileArgs',
    'PhpWorkloadResourceIdentityArgs',
    'PrometheusHaClusterProviderInstancePropertiesArgs',
    'PrometheusOSProviderInstancePropertiesArgs',
    'SAPInstallWithoutOSConfigSoftwareConfigurationArgs',
    'SapNetWeaverProviderInstancePropertiesArgs',
    'SearchProfileArgs',
    'ServiceInitiatedSoftwareConfigurationArgs',
    'SingleServerConfigurationArgs',
    'SiteProfileArgs',
    'SkuArgs',
    'SshConfigurationArgs',
    'SshKeyPairArgs',
    'SshPublicKeyArgs',
    'ThreeTierConfigurationArgs',
    'UserAssignedServiceIdentityArgs',
    'UserProfileArgs',
    'VirtualMachineConfigurationArgs',
    'VmssNodesProfileArgs',
    'WindowsConfigurationArgs',
]

@pulumi.input_type
class ApplicationServerConfigurationArgs:
    def __init__(__self__, *,
                 instance_count: pulumi.Input[float],
                 subnet_id: pulumi.Input[str],
                 virtual_machine_configuration: pulumi.Input['VirtualMachineConfigurationArgs']):
        """
        Gets or sets the application server configuration.
        :param pulumi.Input[float] instance_count: The number of app server instances.
        :param pulumi.Input[str] subnet_id: The subnet id.
        :param pulumi.Input['VirtualMachineConfigurationArgs'] virtual_machine_configuration: Gets or sets the virtual machine configuration.
        """
        pulumi.set(__self__, "instance_count", instance_count)
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "virtual_machine_configuration", virtual_machine_configuration)

    @property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> pulumi.Input[float]:
        """
        The number of app server instances.
        """
        return pulumi.get(self, "instance_count")

    @instance_count.setter
    def instance_count(self, value: pulumi.Input[float]):
        pulumi.set(self, "instance_count", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Input[str]:
        """
        The subnet id.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter(name="virtualMachineConfiguration")
    def virtual_machine_configuration(self) -> pulumi.Input['VirtualMachineConfigurationArgs']:
        """
        Gets or sets the virtual machine configuration.
        """
        return pulumi.get(self, "virtual_machine_configuration")

    @virtual_machine_configuration.setter
    def virtual_machine_configuration(self, value: pulumi.Input['VirtualMachineConfigurationArgs']):
        pulumi.set(self, "virtual_machine_configuration", value)


@pulumi.input_type
class BackupProfileArgs:
    def __init__(__self__, *,
                 backup_enabled: pulumi.Input[Union[str, 'EnableBackup']]):
        """
        Backup profile
        :param pulumi.Input[Union[str, 'EnableBackup']] backup_enabled: Whether to enable Azure backup for the workload
        """
        pulumi.set(__self__, "backup_enabled", backup_enabled)

    @property
    @pulumi.getter(name="backupEnabled")
    def backup_enabled(self) -> pulumi.Input[Union[str, 'EnableBackup']]:
        """
        Whether to enable Azure backup for the workload
        """
        return pulumi.get(self, "backup_enabled")

    @backup_enabled.setter
    def backup_enabled(self, value: pulumi.Input[Union[str, 'EnableBackup']]):
        pulumi.set(self, "backup_enabled", value)


@pulumi.input_type
class CacheProfileArgs:
    def __init__(__self__, *,
                 capacity: pulumi.Input[float],
                 family: pulumi.Input[Union[str, 'RedisCacheFamily']],
                 sku_name: pulumi.Input[str],
                 name: Optional[pulumi.Input[str]] = None):
        """
        Cache profile
        :param pulumi.Input[float] capacity: Cache capacity
        :param pulumi.Input[Union[str, 'RedisCacheFamily']] family: Cache family
        :param pulumi.Input[str] sku_name: Cache SKU name
        :param pulumi.Input[str] name: Cache name
        """
        pulumi.set(__self__, "capacity", capacity)
        pulumi.set(__self__, "family", family)
        pulumi.set(__self__, "sku_name", sku_name)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def capacity(self) -> pulumi.Input[float]:
        """
        Cache capacity
        """
        return pulumi.get(self, "capacity")

    @capacity.setter
    def capacity(self, value: pulumi.Input[float]):
        pulumi.set(self, "capacity", value)

    @property
    @pulumi.getter
    def family(self) -> pulumi.Input[Union[str, 'RedisCacheFamily']]:
        """
        Cache family
        """
        return pulumi.get(self, "family")

    @family.setter
    def family(self, value: pulumi.Input[Union[str, 'RedisCacheFamily']]):
        pulumi.set(self, "family", value)

    @property
    @pulumi.getter(name="skuName")
    def sku_name(self) -> pulumi.Input[str]:
        """
        Cache SKU name
        """
        return pulumi.get(self, "sku_name")

    @sku_name.setter
    def sku_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "sku_name", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Cache name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class CentralServerConfigurationArgs:
    def __init__(__self__, *,
                 instance_count: pulumi.Input[float],
                 subnet_id: pulumi.Input[str],
                 virtual_machine_configuration: pulumi.Input['VirtualMachineConfigurationArgs']):
        """
        Gets or sets the central server configuration.
        :param pulumi.Input[float] instance_count: The number of central server VMs.
        :param pulumi.Input[str] subnet_id: The subnet id.
        :param pulumi.Input['VirtualMachineConfigurationArgs'] virtual_machine_configuration: Gets or sets the virtual machine configuration.
        """
        pulumi.set(__self__, "instance_count", instance_count)
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "virtual_machine_configuration", virtual_machine_configuration)

    @property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> pulumi.Input[float]:
        """
        The number of central server VMs.
        """
        return pulumi.get(self, "instance_count")

    @instance_count.setter
    def instance_count(self, value: pulumi.Input[float]):
        pulumi.set(self, "instance_count", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Input[str]:
        """
        The subnet id.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter(name="virtualMachineConfiguration")
    def virtual_machine_configuration(self) -> pulumi.Input['VirtualMachineConfigurationArgs']:
        """
        Gets or sets the virtual machine configuration.
        """
        return pulumi.get(self, "virtual_machine_configuration")

    @virtual_machine_configuration.setter
    def virtual_machine_configuration(self, value: pulumi.Input['VirtualMachineConfigurationArgs']):
        pulumi.set(self, "virtual_machine_configuration", value)


@pulumi.input_type
class DB2ProviderInstancePropertiesArgs:
    def __init__(__self__, *,
                 provider_type: pulumi.Input[str],
                 db_name: Optional[pulumi.Input[str]] = None,
                 db_password: Optional[pulumi.Input[str]] = None,
                 db_password_uri: Optional[pulumi.Input[str]] = None,
                 db_port: Optional[pulumi.Input[str]] = None,
                 db_username: Optional[pulumi.Input[str]] = None,
                 hostname: Optional[pulumi.Input[str]] = None,
                 sap_sid: Optional[pulumi.Input[str]] = None):
        """
        Gets or sets the DB2 provider properties.
        :param pulumi.Input[str] provider_type: The provider type. For example, the value can be SapHana.
               Expected value is 'Db2'.
        :param pulumi.Input[str] db_name: Gets or sets the db2 database name.
        :param pulumi.Input[str] db_password: Gets or sets the db2 database password.
        :param pulumi.Input[str] db_password_uri: Gets or sets the key vault URI to secret with the database password.
        :param pulumi.Input[str] db_port: Gets or sets the db2 database sql port.
        :param pulumi.Input[str] db_username: Gets or sets the db2 database user name.
        :param pulumi.Input[str] hostname: Gets or sets the target virtual machine name.
        :param pulumi.Input[str] sap_sid: Gets or sets the SAP System Identifier
        """
        pulumi.set(__self__, "provider_type", 'Db2')
        if db_name is not None:
            pulumi.set(__self__, "db_name", db_name)
        if db_password is not None:
            pulumi.set(__self__, "db_password", db_password)
        if db_password_uri is not None:
            pulumi.set(__self__, "db_password_uri", db_password_uri)
        if db_port is not None:
            pulumi.set(__self__, "db_port", db_port)
        if db_username is not None:
            pulumi.set(__self__, "db_username", db_username)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if sap_sid is not None:
            pulumi.set(__self__, "sap_sid", sap_sid)

    @property
    @pulumi.getter(name="providerType")
    def provider_type(self) -> pulumi.Input[str]:
        """
        The provider type. For example, the value can be SapHana.
        Expected value is 'Db2'.
        """
        return pulumi.get(self, "provider_type")

    @provider_type.setter
    def provider_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "provider_type", value)

    @property
    @pulumi.getter(name="dbName")
    def db_name(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the db2 database name.
        """
        return pulumi.get(self, "db_name")

    @db_name.setter
    def db_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_name", value)

    @property
    @pulumi.getter(name="dbPassword")
    def db_password(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the db2 database password.
        """
        return pulumi.get(self, "db_password")

    @db_password.setter
    def db_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_password", value)

    @property
    @pulumi.getter(name="dbPasswordUri")
    def db_password_uri(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the key vault URI to secret with the database password.
        """
        return pulumi.get(self, "db_password_uri")

    @db_password_uri.setter
    def db_password_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_password_uri", value)

    @property
    @pulumi.getter(name="dbPort")
    def db_port(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the db2 database sql port.
        """
        return pulumi.get(self, "db_port")

    @db_port.setter
    def db_port(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_port", value)

    @property
    @pulumi.getter(name="dbUsername")
    def db_username(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the db2 database user name.
        """
        return pulumi.get(self, "db_username")

    @db_username.setter
    def db_username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_username", value)

    @property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the target virtual machine name.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hostname", value)

    @property
    @pulumi.getter(name="sapSid")
    def sap_sid(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the SAP System Identifier
        """
        return pulumi.get(self, "sap_sid")

    @sap_sid.setter
    def sap_sid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sap_sid", value)


@pulumi.input_type
class DatabaseConfigurationArgs:
    def __init__(__self__, *,
                 instance_count: pulumi.Input[float],
                 subnet_id: pulumi.Input[str],
                 virtual_machine_configuration: pulumi.Input['VirtualMachineConfigurationArgs'],
                 database_type: Optional[pulumi.Input[Union[str, 'SAPDatabaseType']]] = None):
        """
        Gets or sets the database configuration.
        :param pulumi.Input[float] instance_count: The number of database VMs.
        :param pulumi.Input[str] subnet_id: The subnet id.
        :param pulumi.Input['VirtualMachineConfigurationArgs'] virtual_machine_configuration: Gets or sets the virtual machine configuration.
        :param pulumi.Input[Union[str, 'SAPDatabaseType']] database_type: The database type.
        """
        pulumi.set(__self__, "instance_count", instance_count)
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "virtual_machine_configuration", virtual_machine_configuration)
        if database_type is not None:
            pulumi.set(__self__, "database_type", database_type)

    @property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> pulumi.Input[float]:
        """
        The number of database VMs.
        """
        return pulumi.get(self, "instance_count")

    @instance_count.setter
    def instance_count(self, value: pulumi.Input[float]):
        pulumi.set(self, "instance_count", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Input[str]:
        """
        The subnet id.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter(name="virtualMachineConfiguration")
    def virtual_machine_configuration(self) -> pulumi.Input['VirtualMachineConfigurationArgs']:
        """
        Gets or sets the virtual machine configuration.
        """
        return pulumi.get(self, "virtual_machine_configuration")

    @virtual_machine_configuration.setter
    def virtual_machine_configuration(self, value: pulumi.Input['VirtualMachineConfigurationArgs']):
        pulumi.set(self, "virtual_machine_configuration", value)

    @property
    @pulumi.getter(name="databaseType")
    def database_type(self) -> Optional[pulumi.Input[Union[str, 'SAPDatabaseType']]]:
        """
        The database type.
        """
        return pulumi.get(self, "database_type")

    @database_type.setter
    def database_type(self, value: Optional[pulumi.Input[Union[str, 'SAPDatabaseType']]]):
        pulumi.set(self, "database_type", value)


@pulumi.input_type
class DatabaseProfileArgs:
    def __init__(__self__, *,
                 sku: pulumi.Input[str],
                 tier: pulumi.Input['DatabaseTier'],
                 type: pulumi.Input[Union[str, 'DatabaseType']],
                 backup_retention_days: Optional[pulumi.Input[int]] = None,
                 ha_enabled: Optional[pulumi.Input[Union[str, 'HAEnabled']]] = None,
                 server_name: Optional[pulumi.Input[str]] = None,
                 ssl_enforcement_enabled: Optional[pulumi.Input[Union[str, 'EnableSslEnforcement']]] = None,
                 storage_in_gb: Optional[pulumi.Input[float]] = None,
                 storage_iops: Optional[pulumi.Input[float]] = None,
                 storage_sku: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        Workload database profile
        :param pulumi.Input[str] sku: The name of the server SKU, e.g. Standard_D32s_v4
        :param pulumi.Input['DatabaseTier'] tier: Tier of the server SKU
        :param pulumi.Input[Union[str, 'DatabaseType']] type: Database type
        :param pulumi.Input[int] backup_retention_days: Backup retention days for the server
        :param pulumi.Input[Union[str, 'HAEnabled']] ha_enabled: Whether to enable HA for the server
        :param pulumi.Input[str] server_name: Database server name
        :param pulumi.Input[Union[str, 'EnableSslEnforcement']] ssl_enforcement_enabled: Whether to enable SSL enforcement on the database
        :param pulumi.Input[float] storage_in_gb: Database storage size in GB
        :param pulumi.Input[float] storage_iops: Storage IOPS for the server
        :param pulumi.Input[str] storage_sku: SKU name for database storage
        :param pulumi.Input[str] version: Database version
        """
        pulumi.set(__self__, "sku", sku)
        pulumi.set(__self__, "tier", tier)
        pulumi.set(__self__, "type", type)
        if backup_retention_days is not None:
            pulumi.set(__self__, "backup_retention_days", backup_retention_days)
        if ha_enabled is not None:
            pulumi.set(__self__, "ha_enabled", ha_enabled)
        if server_name is not None:
            pulumi.set(__self__, "server_name", server_name)
        if ssl_enforcement_enabled is not None:
            pulumi.set(__self__, "ssl_enforcement_enabled", ssl_enforcement_enabled)
        if storage_in_gb is not None:
            pulumi.set(__self__, "storage_in_gb", storage_in_gb)
        if storage_iops is not None:
            pulumi.set(__self__, "storage_iops", storage_iops)
        if storage_sku is not None:
            pulumi.set(__self__, "storage_sku", storage_sku)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def sku(self) -> pulumi.Input[str]:
        """
        The name of the server SKU, e.g. Standard_D32s_v4
        """
        return pulumi.get(self, "sku")

    @sku.setter
    def sku(self, value: pulumi.Input[str]):
        pulumi.set(self, "sku", value)

    @property
    @pulumi.getter
    def tier(self) -> pulumi.Input['DatabaseTier']:
        """
        Tier of the server SKU
        """
        return pulumi.get(self, "tier")

    @tier.setter
    def tier(self, value: pulumi.Input['DatabaseTier']):
        pulumi.set(self, "tier", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[Union[str, 'DatabaseType']]:
        """
        Database type
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[Union[str, 'DatabaseType']]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="backupRetentionDays")
    def backup_retention_days(self) -> Optional[pulumi.Input[int]]:
        """
        Backup retention days for the server
        """
        return pulumi.get(self, "backup_retention_days")

    @backup_retention_days.setter
    def backup_retention_days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "backup_retention_days", value)

    @property
    @pulumi.getter(name="haEnabled")
    def ha_enabled(self) -> Optional[pulumi.Input[Union[str, 'HAEnabled']]]:
        """
        Whether to enable HA for the server
        """
        return pulumi.get(self, "ha_enabled")

    @ha_enabled.setter
    def ha_enabled(self, value: Optional[pulumi.Input[Union[str, 'HAEnabled']]]):
        pulumi.set(self, "ha_enabled", value)

    @property
    @pulumi.getter(name="serverName")
    def server_name(self) -> Optional[pulumi.Input[str]]:
        """
        Database server name
        """
        return pulumi.get(self, "server_name")

    @server_name.setter
    def server_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server_name", value)

    @property
    @pulumi.getter(name="sslEnforcementEnabled")
    def ssl_enforcement_enabled(self) -> Optional[pulumi.Input[Union[str, 'EnableSslEnforcement']]]:
        """
        Whether to enable SSL enforcement on the database
        """
        return pulumi.get(self, "ssl_enforcement_enabled")

    @ssl_enforcement_enabled.setter
    def ssl_enforcement_enabled(self, value: Optional[pulumi.Input[Union[str, 'EnableSslEnforcement']]]):
        pulumi.set(self, "ssl_enforcement_enabled", value)

    @property
    @pulumi.getter(name="storageInGB")
    def storage_in_gb(self) -> Optional[pulumi.Input[float]]:
        """
        Database storage size in GB
        """
        return pulumi.get(self, "storage_in_gb")

    @storage_in_gb.setter
    def storage_in_gb(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "storage_in_gb", value)

    @property
    @pulumi.getter(name="storageIops")
    def storage_iops(self) -> Optional[pulumi.Input[float]]:
        """
        Storage IOPS for the server
        """
        return pulumi.get(self, "storage_iops")

    @storage_iops.setter
    def storage_iops(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "storage_iops", value)

    @property
    @pulumi.getter(name="storageSku")
    def storage_sku(self) -> Optional[pulumi.Input[str]]:
        """
        SKU name for database storage
        """
        return pulumi.get(self, "storage_sku")

    @storage_sku.setter
    def storage_sku(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "storage_sku", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        Database version
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class DeployerVmPackagesArgs:
    def __init__(__self__, *,
                 storage_account_id: Optional[pulumi.Input[str]] = None,
                 url: Optional[pulumi.Input[str]] = None):
        """
        Defines the url and storage account ID where deployer VM packages are uploaded
        :param pulumi.Input[str] storage_account_id: The deployer VM packages storage account id
        :param pulumi.Input[str] url: The URL to the deployer VM packages file.
        """
        if storage_account_id is not None:
            pulumi.set(__self__, "storage_account_id", storage_account_id)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter(name="storageAccountId")
    def storage_account_id(self) -> Optional[pulumi.Input[str]]:
        """
        The deployer VM packages storage account id
        """
        return pulumi.get(self, "storage_account_id")

    @storage_account_id.setter
    def storage_account_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "storage_account_id", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[str]]:
        """
        The URL to the deployer VM packages file.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url", value)


@pulumi.input_type
class DeploymentConfigurationArgs:
    def __init__(__self__, *,
                 configuration_type: pulumi.Input[str],
                 app_location: Optional[pulumi.Input[str]] = None,
                 infrastructure_configuration: Optional[pulumi.Input[Union['SingleServerConfigurationArgs', 'ThreeTierConfigurationArgs']]] = None,
                 software_configuration: Optional[pulumi.Input[Union['SAPInstallWithoutOSConfigSoftwareConfigurationArgs', 'ServiceInitiatedSoftwareConfigurationArgs']]] = None):
        """
        Deployment Configuration.
        :param pulumi.Input[str] configuration_type: The configuration Type.
               Expected value is 'Deployment'.
        :param pulumi.Input[str] app_location: The geo-location where the SAP system is to be created.
        :param pulumi.Input[Union['SingleServerConfigurationArgs', 'ThreeTierConfigurationArgs']] infrastructure_configuration: The infrastructure configuration.
        :param pulumi.Input[Union['SAPInstallWithoutOSConfigSoftwareConfigurationArgs', 'ServiceInitiatedSoftwareConfigurationArgs']] software_configuration: The software configuration.
        """
        pulumi.set(__self__, "configuration_type", 'Deployment')
        if app_location is not None:
            pulumi.set(__self__, "app_location", app_location)
        if infrastructure_configuration is not None:
            pulumi.set(__self__, "infrastructure_configuration", infrastructure_configuration)
        if software_configuration is not None:
            pulumi.set(__self__, "software_configuration", software_configuration)

    @property
    @pulumi.getter(name="configurationType")
    def configuration_type(self) -> pulumi.Input[str]:
        """
        The configuration Type.
        Expected value is 'Deployment'.
        """
        return pulumi.get(self, "configuration_type")

    @configuration_type.setter
    def configuration_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "configuration_type", value)

    @property
    @pulumi.getter(name="appLocation")
    def app_location(self) -> Optional[pulumi.Input[str]]:
        """
        The geo-location where the SAP system is to be created.
        """
        return pulumi.get(self, "app_location")

    @app_location.setter
    def app_location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app_location", value)

    @property
    @pulumi.getter(name="infrastructureConfiguration")
    def infrastructure_configuration(self) -> Optional[pulumi.Input[Union['SingleServerConfigurationArgs', 'ThreeTierConfigurationArgs']]]:
        """
        The infrastructure configuration.
        """
        return pulumi.get(self, "infrastructure_configuration")

    @infrastructure_configuration.setter
    def infrastructure_configuration(self, value: Optional[pulumi.Input[Union['SingleServerConfigurationArgs', 'ThreeTierConfigurationArgs']]]):
        pulumi.set(self, "infrastructure_configuration", value)

    @property
    @pulumi.getter(name="softwareConfiguration")
    def software_configuration(self) -> Optional[pulumi.Input[Union['SAPInstallWithoutOSConfigSoftwareConfigurationArgs', 'ServiceInitiatedSoftwareConfigurationArgs']]]:
        """
        The software configuration.
        """
        return pulumi.get(self, "software_configuration")

    @software_configuration.setter
    def software_configuration(self, value: Optional[pulumi.Input[Union['SAPInstallWithoutOSConfigSoftwareConfigurationArgs', 'ServiceInitiatedSoftwareConfigurationArgs']]]):
        pulumi.set(self, "software_configuration", value)


@pulumi.input_type
class DeploymentWithOSConfigurationArgs:
    def __init__(__self__, *,
                 configuration_type: pulumi.Input[str],
                 app_location: Optional[pulumi.Input[str]] = None,
                 infrastructure_configuration: Optional[pulumi.Input[Union['SingleServerConfigurationArgs', 'ThreeTierConfigurationArgs']]] = None,
                 os_sap_configuration: Optional[pulumi.Input['OsSapConfigurationArgs']] = None,
                 software_configuration: Optional[pulumi.Input[Union['SAPInstallWithoutOSConfigSoftwareConfigurationArgs', 'ServiceInitiatedSoftwareConfigurationArgs']]] = None):
        """
        Deployment along with OS Configuration.
        :param pulumi.Input[str] configuration_type: The configuration Type.
               Expected value is 'DeploymentWithOSConfig'.
        :param pulumi.Input[str] app_location: The geo-location where the SAP system is to be created.
        :param pulumi.Input[Union['SingleServerConfigurationArgs', 'ThreeTierConfigurationArgs']] infrastructure_configuration: The infrastructure configuration.
        :param pulumi.Input['OsSapConfigurationArgs'] os_sap_configuration: The OS and SAP configuration.
        :param pulumi.Input[Union['SAPInstallWithoutOSConfigSoftwareConfigurationArgs', 'ServiceInitiatedSoftwareConfigurationArgs']] software_configuration: The software configuration.
        """
        pulumi.set(__self__, "configuration_type", 'DeploymentWithOSConfig')
        if app_location is not None:
            pulumi.set(__self__, "app_location", app_location)
        if infrastructure_configuration is not None:
            pulumi.set(__self__, "infrastructure_configuration", infrastructure_configuration)
        if os_sap_configuration is not None:
            pulumi.set(__self__, "os_sap_configuration", os_sap_configuration)
        if software_configuration is not None:
            pulumi.set(__self__, "software_configuration", software_configuration)

    @property
    @pulumi.getter(name="configurationType")
    def configuration_type(self) -> pulumi.Input[str]:
        """
        The configuration Type.
        Expected value is 'DeploymentWithOSConfig'.
        """
        return pulumi.get(self, "configuration_type")

    @configuration_type.setter
    def configuration_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "configuration_type", value)

    @property
    @pulumi.getter(name="appLocation")
    def app_location(self) -> Optional[pulumi.Input[str]]:
        """
        The geo-location where the SAP system is to be created.
        """
        return pulumi.get(self, "app_location")

    @app_location.setter
    def app_location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app_location", value)

    @property
    @pulumi.getter(name="infrastructureConfiguration")
    def infrastructure_configuration(self) -> Optional[pulumi.Input[Union['SingleServerConfigurationArgs', 'ThreeTierConfigurationArgs']]]:
        """
        The infrastructure configuration.
        """
        return pulumi.get(self, "infrastructure_configuration")

    @infrastructure_configuration.setter
    def infrastructure_configuration(self, value: Optional[pulumi.Input[Union['SingleServerConfigurationArgs', 'ThreeTierConfigurationArgs']]]):
        pulumi.set(self, "infrastructure_configuration", value)

    @property
    @pulumi.getter(name="osSapConfiguration")
    def os_sap_configuration(self) -> Optional[pulumi.Input['OsSapConfigurationArgs']]:
        """
        The OS and SAP configuration.
        """
        return pulumi.get(self, "os_sap_configuration")

    @os_sap_configuration.setter
    def os_sap_configuration(self, value: Optional[pulumi.Input['OsSapConfigurationArgs']]):
        pulumi.set(self, "os_sap_configuration", value)

    @property
    @pulumi.getter(name="softwareConfiguration")
    def software_configuration(self) -> Optional[pulumi.Input[Union['SAPInstallWithoutOSConfigSoftwareConfigurationArgs', 'ServiceInitiatedSoftwareConfigurationArgs']]]:
        """
        The software configuration.
        """
        return pulumi.get(self, "software_configuration")

    @software_configuration.setter
    def software_configuration(self, value: Optional[pulumi.Input[Union['SAPInstallWithoutOSConfigSoftwareConfigurationArgs', 'ServiceInitiatedSoftwareConfigurationArgs']]]):
        pulumi.set(self, "software_configuration", value)


@pulumi.input_type
class DiscoveryConfigurationArgs:
    def __init__(__self__, *,
                 configuration_type: pulumi.Input[str],
                 central_server_vm_id: Optional[pulumi.Input[str]] = None):
        """
        Discovery Details.
        :param pulumi.Input[str] configuration_type: The configuration Type.
               Expected value is 'Discovery'.
        :param pulumi.Input[str] central_server_vm_id: The virtual machine ID of the Central Server.
        """
        pulumi.set(__self__, "configuration_type", 'Discovery')
        if central_server_vm_id is not None:
            pulumi.set(__self__, "central_server_vm_id", central_server_vm_id)

    @property
    @pulumi.getter(name="configurationType")
    def configuration_type(self) -> pulumi.Input[str]:
        """
        The configuration Type.
        Expected value is 'Discovery'.
        """
        return pulumi.get(self, "configuration_type")

    @configuration_type.setter
    def configuration_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "configuration_type", value)

    @property
    @pulumi.getter(name="centralServerVmId")
    def central_server_vm_id(self) -> Optional[pulumi.Input[str]]:
        """
        The virtual machine ID of the Central Server.
        """
        return pulumi.get(self, "central_server_vm_id")

    @central_server_vm_id.setter
    def central_server_vm_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "central_server_vm_id", value)


@pulumi.input_type
class DiskInfoArgs:
    def __init__(__self__, *,
                 storage_type: pulumi.Input['DiskStorageType'],
                 size_in_gb: Optional[pulumi.Input[float]] = None):
        """
        Disk resource creation details
        :param pulumi.Input['DiskStorageType'] storage_type: Storage type
        :param pulumi.Input[float] size_in_gb: Disk size in GB
        """
        pulumi.set(__self__, "storage_type", storage_type)
        if size_in_gb is not None:
            pulumi.set(__self__, "size_in_gb", size_in_gb)

    @property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> pulumi.Input['DiskStorageType']:
        """
        Storage type
        """
        return pulumi.get(self, "storage_type")

    @storage_type.setter
    def storage_type(self, value: pulumi.Input['DiskStorageType']):
        pulumi.set(self, "storage_type", value)

    @property
    @pulumi.getter(name="sizeInGB")
    def size_in_gb(self) -> Optional[pulumi.Input[float]]:
        """
        Disk size in GB
        """
        return pulumi.get(self, "size_in_gb")

    @size_in_gb.setter
    def size_in_gb(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "size_in_gb", value)


@pulumi.input_type
class FileshareProfileArgs:
    def __init__(__self__, *,
                 share_type: pulumi.Input[Union[str, 'FileShareType']],
                 storage_type: pulumi.Input[Union[str, 'FileShareStorageType']],
                 share_size_in_gb: Optional[pulumi.Input[float]] = None):
        """
        File share profile
        :param pulumi.Input[Union[str, 'FileShareType']] share_type: Share type
        :param pulumi.Input[Union[str, 'FileShareStorageType']] storage_type: File share backing storage type
        :param pulumi.Input[float] share_size_in_gb: File share size in GB
        """
        pulumi.set(__self__, "share_type", share_type)
        pulumi.set(__self__, "storage_type", storage_type)
        if share_size_in_gb is not None:
            pulumi.set(__self__, "share_size_in_gb", share_size_in_gb)

    @property
    @pulumi.getter(name="shareType")
    def share_type(self) -> pulumi.Input[Union[str, 'FileShareType']]:
        """
        Share type
        """
        return pulumi.get(self, "share_type")

    @share_type.setter
    def share_type(self, value: pulumi.Input[Union[str, 'FileShareType']]):
        pulumi.set(self, "share_type", value)

    @property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> pulumi.Input[Union[str, 'FileShareStorageType']]:
        """
        File share backing storage type
        """
        return pulumi.get(self, "storage_type")

    @storage_type.setter
    def storage_type(self, value: pulumi.Input[Union[str, 'FileShareStorageType']]):
        pulumi.set(self, "storage_type", value)

    @property
    @pulumi.getter(name="shareSizeInGB")
    def share_size_in_gb(self) -> Optional[pulumi.Input[float]]:
        """
        File share size in GB
        """
        return pulumi.get(self, "share_size_in_gb")

    @share_size_in_gb.setter
    def share_size_in_gb(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "share_size_in_gb", value)


@pulumi.input_type
class HanaDbProviderInstancePropertiesArgs:
    def __init__(__self__, *,
                 provider_type: pulumi.Input[str],
                 db_name: Optional[pulumi.Input[str]] = None,
                 db_password: Optional[pulumi.Input[str]] = None,
                 db_password_uri: Optional[pulumi.Input[str]] = None,
                 db_ssl_certificate_uri: Optional[pulumi.Input[str]] = None,
                 db_username: Optional[pulumi.Input[str]] = None,
                 hostname: Optional[pulumi.Input[str]] = None,
                 instance_number: Optional[pulumi.Input[str]] = None,
                 sql_port: Optional[pulumi.Input[str]] = None,
                 ssl_host_name_in_certificate: Optional[pulumi.Input[str]] = None):
        """
        Gets or sets the provider properties.
        :param pulumi.Input[str] provider_type: The provider type. For example, the value can be SapHana.
               Expected value is 'SapHana'.
        :param pulumi.Input[str] db_name: Gets or sets the hana database name.
        :param pulumi.Input[str] db_password: Gets or sets the database password.
        :param pulumi.Input[str] db_password_uri: Gets or sets the key vault URI to secret with the database password.
        :param pulumi.Input[str] db_ssl_certificate_uri: Gets or sets the blob URI to SSL certificate for the DB.
        :param pulumi.Input[str] db_username: Gets or sets the database user name.
        :param pulumi.Input[str] hostname: Gets or sets the target virtual machine size.
        :param pulumi.Input[str] instance_number: Gets or sets the database instance number.
        :param pulumi.Input[str] sql_port: Gets or sets the database sql port.
        :param pulumi.Input[str] ssl_host_name_in_certificate: Gets or sets the hostname(s) in the SSL certificate.
        """
        pulumi.set(__self__, "provider_type", 'SapHana')
        if db_name is not None:
            pulumi.set(__self__, "db_name", db_name)
        if db_password is not None:
            pulumi.set(__self__, "db_password", db_password)
        if db_password_uri is not None:
            pulumi.set(__self__, "db_password_uri", db_password_uri)
        if db_ssl_certificate_uri is not None:
            pulumi.set(__self__, "db_ssl_certificate_uri", db_ssl_certificate_uri)
        if db_username is not None:
            pulumi.set(__self__, "db_username", db_username)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if instance_number is not None:
            pulumi.set(__self__, "instance_number", instance_number)
        if sql_port is not None:
            pulumi.set(__self__, "sql_port", sql_port)
        if ssl_host_name_in_certificate is not None:
            pulumi.set(__self__, "ssl_host_name_in_certificate", ssl_host_name_in_certificate)

    @property
    @pulumi.getter(name="providerType")
    def provider_type(self) -> pulumi.Input[str]:
        """
        The provider type. For example, the value can be SapHana.
        Expected value is 'SapHana'.
        """
        return pulumi.get(self, "provider_type")

    @provider_type.setter
    def provider_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "provider_type", value)

    @property
    @pulumi.getter(name="dbName")
    def db_name(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the hana database name.
        """
        return pulumi.get(self, "db_name")

    @db_name.setter
    def db_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_name", value)

    @property
    @pulumi.getter(name="dbPassword")
    def db_password(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the database password.
        """
        return pulumi.get(self, "db_password")

    @db_password.setter
    def db_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_password", value)

    @property
    @pulumi.getter(name="dbPasswordUri")
    def db_password_uri(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the key vault URI to secret with the database password.
        """
        return pulumi.get(self, "db_password_uri")

    @db_password_uri.setter
    def db_password_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_password_uri", value)

    @property
    @pulumi.getter(name="dbSslCertificateUri")
    def db_ssl_certificate_uri(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the blob URI to SSL certificate for the DB.
        """
        return pulumi.get(self, "db_ssl_certificate_uri")

    @db_ssl_certificate_uri.setter
    def db_ssl_certificate_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_ssl_certificate_uri", value)

    @property
    @pulumi.getter(name="dbUsername")
    def db_username(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the database user name.
        """
        return pulumi.get(self, "db_username")

    @db_username.setter
    def db_username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_username", value)

    @property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the target virtual machine size.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hostname", value)

    @property
    @pulumi.getter(name="instanceNumber")
    def instance_number(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the database instance number.
        """
        return pulumi.get(self, "instance_number")

    @instance_number.setter
    def instance_number(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_number", value)

    @property
    @pulumi.getter(name="sqlPort")
    def sql_port(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the database sql port.
        """
        return pulumi.get(self, "sql_port")

    @sql_port.setter
    def sql_port(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sql_port", value)

    @property
    @pulumi.getter(name="sslHostNameInCertificate")
    def ssl_host_name_in_certificate(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the hostname(s) in the SSL certificate.
        """
        return pulumi.get(self, "ssl_host_name_in_certificate")

    @ssl_host_name_in_certificate.setter
    def ssl_host_name_in_certificate(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ssl_host_name_in_certificate", value)


@pulumi.input_type
class HighAvailabilityConfigurationArgs:
    def __init__(__self__, *,
                 high_availability_type: pulumi.Input[Union[str, 'SAPHighAvailabilityType']]):
        """
        Gets or sets the high availability configuration.
        :param pulumi.Input[Union[str, 'SAPHighAvailabilityType']] high_availability_type: The high availability type.
        """
        pulumi.set(__self__, "high_availability_type", high_availability_type)

    @property
    @pulumi.getter(name="highAvailabilityType")
    def high_availability_type(self) -> pulumi.Input[Union[str, 'SAPHighAvailabilityType']]:
        """
        The high availability type.
        """
        return pulumi.get(self, "high_availability_type")

    @high_availability_type.setter
    def high_availability_type(self, value: pulumi.Input[Union[str, 'SAPHighAvailabilityType']]):
        pulumi.set(self, "high_availability_type", value)


@pulumi.input_type
class HighAvailabilitySoftwareConfigurationArgs:
    def __init__(__self__, *,
                 fencing_client_id: pulumi.Input[str],
                 fencing_client_password: pulumi.Input[str]):
        """
        Gets or sets the HA software configuration.
        :param pulumi.Input[str] fencing_client_id: The fencing client id.
        :param pulumi.Input[str] fencing_client_password: The fencing client id secret/password. The secret should never expire. This will be used pacemaker to start/stop the cluster VMs.
        """
        pulumi.set(__self__, "fencing_client_id", fencing_client_id)
        pulumi.set(__self__, "fencing_client_password", fencing_client_password)

    @property
    @pulumi.getter(name="fencingClientId")
    def fencing_client_id(self) -> pulumi.Input[str]:
        """
        The fencing client id.
        """
        return pulumi.get(self, "fencing_client_id")

    @fencing_client_id.setter
    def fencing_client_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "fencing_client_id", value)

    @property
    @pulumi.getter(name="fencingClientPassword")
    def fencing_client_password(self) -> pulumi.Input[str]:
        """
        The fencing client id secret/password. The secret should never expire. This will be used pacemaker to start/stop the cluster VMs.
        """
        return pulumi.get(self, "fencing_client_password")

    @fencing_client_password.setter
    def fencing_client_password(self, value: pulumi.Input[str]):
        pulumi.set(self, "fencing_client_password", value)


@pulumi.input_type
class ImageReferenceArgs:
    def __init__(__self__, *,
                 offer: Optional[pulumi.Input[str]] = None,
                 publisher: Optional[pulumi.Input[str]] = None,
                 shared_gallery_image_id: Optional[pulumi.Input[str]] = None,
                 sku: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        Specifies information about the image to use. You can specify information about platform images, marketplace images, or virtual machine images. This element is required when you want to use a platform image, marketplace image, or virtual machine image, but is not used in other creation operations. NOTE: Image reference publisher and offer can only be set when you create the scale set.
        :param pulumi.Input[str] offer: Specifies the offer of the platform image or marketplace image used to create the virtual machine.
        :param pulumi.Input[str] publisher: The image publisher.
        :param pulumi.Input[str] shared_gallery_image_id: Specified the shared gallery image unique id for vm deployment. This can be fetched from shared gallery image GET call.
        :param pulumi.Input[str] sku: The image SKU.
        :param pulumi.Input[str] version: Specifies the version of the platform image or marketplace image used to create the virtual machine. The allowed formats are Major.Minor.Build or 'latest'. Major, Minor, and Build are decimal numbers. Specify 'latest' to use the latest version of an image available at deploy time. Even if you use 'latest', the VM image will not automatically update after deploy time even if a new version becomes available.
        """
        if offer is not None:
            pulumi.set(__self__, "offer", offer)
        if publisher is not None:
            pulumi.set(__self__, "publisher", publisher)
        if shared_gallery_image_id is not None:
            pulumi.set(__self__, "shared_gallery_image_id", shared_gallery_image_id)
        if sku is not None:
            pulumi.set(__self__, "sku", sku)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def offer(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the offer of the platform image or marketplace image used to create the virtual machine.
        """
        return pulumi.get(self, "offer")

    @offer.setter
    def offer(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "offer", value)

    @property
    @pulumi.getter
    def publisher(self) -> Optional[pulumi.Input[str]]:
        """
        The image publisher.
        """
        return pulumi.get(self, "publisher")

    @publisher.setter
    def publisher(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "publisher", value)

    @property
    @pulumi.getter(name="sharedGalleryImageId")
    def shared_gallery_image_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specified the shared gallery image unique id for vm deployment. This can be fetched from shared gallery image GET call.
        """
        return pulumi.get(self, "shared_gallery_image_id")

    @shared_gallery_image_id.setter
    def shared_gallery_image_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "shared_gallery_image_id", value)

    @property
    @pulumi.getter
    def sku(self) -> Optional[pulumi.Input[str]]:
        """
        The image SKU.
        """
        return pulumi.get(self, "sku")

    @sku.setter
    def sku(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sku", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the version of the platform image or marketplace image used to create the virtual machine. The allowed formats are Major.Minor.Build or 'latest'. Major, Minor, and Build are decimal numbers. Specify 'latest' to use the latest version of an image available at deploy time. Even if you use 'latest', the VM image will not automatically update after deploy time even if a new version becomes available.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class LinuxConfigurationArgs:
    def __init__(__self__, *,
                 os_type: pulumi.Input[str],
                 disable_password_authentication: Optional[pulumi.Input[bool]] = None,
                 ssh: Optional[pulumi.Input['SshConfigurationArgs']] = None,
                 ssh_key_pair: Optional[pulumi.Input['SshKeyPairArgs']] = None):
        """
        Specifies the Linux operating system settings on the virtual machine. <br><br>For a list of supported Linux distributions, see [Linux on Azure-Endorsed Distributions](https://docs.microsoft.com/azure/virtual-machines/linux/endorsed-distros).
        :param pulumi.Input[str] os_type: The OS Type
               Expected value is 'Linux'.
        :param pulumi.Input[bool] disable_password_authentication: Specifies whether password authentication should be disabled.
        :param pulumi.Input['SshConfigurationArgs'] ssh: Specifies the ssh key configuration for a Linux OS. (This property is deprecated, please use 'sshKeyPair' instead)
        :param pulumi.Input['SshKeyPairArgs'] ssh_key_pair: The SSH Key-pair used to authenticate with the VM's.
        """
        pulumi.set(__self__, "os_type", 'Linux')
        if disable_password_authentication is not None:
            pulumi.set(__self__, "disable_password_authentication", disable_password_authentication)
        if ssh is not None:
            pulumi.set(__self__, "ssh", ssh)
        if ssh_key_pair is not None:
            pulumi.set(__self__, "ssh_key_pair", ssh_key_pair)

    @property
    @pulumi.getter(name="osType")
    def os_type(self) -> pulumi.Input[str]:
        """
        The OS Type
        Expected value is 'Linux'.
        """
        return pulumi.get(self, "os_type")

    @os_type.setter
    def os_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "os_type", value)

    @property
    @pulumi.getter(name="disablePasswordAuthentication")
    def disable_password_authentication(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether password authentication should be disabled.
        """
        return pulumi.get(self, "disable_password_authentication")

    @disable_password_authentication.setter
    def disable_password_authentication(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_password_authentication", value)

    @property
    @pulumi.getter
    def ssh(self) -> Optional[pulumi.Input['SshConfigurationArgs']]:
        """
        Specifies the ssh key configuration for a Linux OS. (This property is deprecated, please use 'sshKeyPair' instead)
        """
        return pulumi.get(self, "ssh")

    @ssh.setter
    def ssh(self, value: Optional[pulumi.Input['SshConfigurationArgs']]):
        pulumi.set(self, "ssh", value)

    @property
    @pulumi.getter(name="sshKeyPair")
    def ssh_key_pair(self) -> Optional[pulumi.Input['SshKeyPairArgs']]:
        """
        The SSH Key-pair used to authenticate with the VM's.
        """
        return pulumi.get(self, "ssh_key_pair")

    @ssh_key_pair.setter
    def ssh_key_pair(self, value: Optional[pulumi.Input['SshKeyPairArgs']]):
        pulumi.set(self, "ssh_key_pair", value)


@pulumi.input_type
class ManagedRGConfigurationArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None):
        """
        Managed resource group configuration
        :param pulumi.Input[str] name: Managed resource group name
        """
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Managed resource group name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class MsSqlServerProviderInstancePropertiesArgs:
    def __init__(__self__, *,
                 provider_type: pulumi.Input[str],
                 db_password: Optional[pulumi.Input[str]] = None,
                 db_password_uri: Optional[pulumi.Input[str]] = None,
                 db_port: Optional[pulumi.Input[str]] = None,
                 db_username: Optional[pulumi.Input[str]] = None,
                 hostname: Optional[pulumi.Input[str]] = None,
                 sap_sid: Optional[pulumi.Input[str]] = None):
        """
        Gets or sets the SQL server provider properties.
        :param pulumi.Input[str] provider_type: The provider type. For example, the value can be SapHana.
               Expected value is 'MsSqlServer'.
        :param pulumi.Input[str] db_password: Gets or sets the database password.
        :param pulumi.Input[str] db_password_uri: Gets or sets the key vault URI to secret with the database password.
        :param pulumi.Input[str] db_port: Gets or sets the database sql port.
        :param pulumi.Input[str] db_username: Gets or sets the database user name.
        :param pulumi.Input[str] hostname: Gets or sets the SQL server host name.
        :param pulumi.Input[str] sap_sid: Gets or sets the SAP System Identifier
        """
        pulumi.set(__self__, "provider_type", 'MsSqlServer')
        if db_password is not None:
            pulumi.set(__self__, "db_password", db_password)
        if db_password_uri is not None:
            pulumi.set(__self__, "db_password_uri", db_password_uri)
        if db_port is not None:
            pulumi.set(__self__, "db_port", db_port)
        if db_username is not None:
            pulumi.set(__self__, "db_username", db_username)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if sap_sid is not None:
            pulumi.set(__self__, "sap_sid", sap_sid)

    @property
    @pulumi.getter(name="providerType")
    def provider_type(self) -> pulumi.Input[str]:
        """
        The provider type. For example, the value can be SapHana.
        Expected value is 'MsSqlServer'.
        """
        return pulumi.get(self, "provider_type")

    @provider_type.setter
    def provider_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "provider_type", value)

    @property
    @pulumi.getter(name="dbPassword")
    def db_password(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the database password.
        """
        return pulumi.get(self, "db_password")

    @db_password.setter
    def db_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_password", value)

    @property
    @pulumi.getter(name="dbPasswordUri")
    def db_password_uri(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the key vault URI to secret with the database password.
        """
        return pulumi.get(self, "db_password_uri")

    @db_password_uri.setter
    def db_password_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_password_uri", value)

    @property
    @pulumi.getter(name="dbPort")
    def db_port(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the database sql port.
        """
        return pulumi.get(self, "db_port")

    @db_port.setter
    def db_port(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_port", value)

    @property
    @pulumi.getter(name="dbUsername")
    def db_username(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the database user name.
        """
        return pulumi.get(self, "db_username")

    @db_username.setter
    def db_username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_username", value)

    @property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the SQL server host name.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hostname", value)

    @property
    @pulumi.getter(name="sapSid")
    def sap_sid(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the SAP System Identifier
        """
        return pulumi.get(self, "sap_sid")

    @sap_sid.setter
    def sap_sid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sap_sid", value)


@pulumi.input_type
class NetworkConfigurationArgs:
    def __init__(__self__, *,
                 is_secondary_ip_enabled: Optional[pulumi.Input[bool]] = None):
        """
        Defines the network configuration for SAP infrastructure
        :param pulumi.Input[bool] is_secondary_ip_enabled: Specifies whether a secondary IP address should be added to the network interface on all VMs
        """
        if is_secondary_ip_enabled is None:
            is_secondary_ip_enabled = False
        if is_secondary_ip_enabled is not None:
            pulumi.set(__self__, "is_secondary_ip_enabled", is_secondary_ip_enabled)

    @property
    @pulumi.getter(name="isSecondaryIpEnabled")
    def is_secondary_ip_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether a secondary IP address should be added to the network interface on all VMs
        """
        return pulumi.get(self, "is_secondary_ip_enabled")

    @is_secondary_ip_enabled.setter
    def is_secondary_ip_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_secondary_ip_enabled", value)


@pulumi.input_type
class NetworkProfileArgs:
    def __init__(__self__, *,
                 load_balancer_type: pulumi.Input[Union[str, 'LoadBalancerType']],
                 azure_front_door_enabled: Optional[pulumi.Input[Union[str, 'AzureFrontDoorEnabled']]] = None,
                 capacity: Optional[pulumi.Input[int]] = None,
                 load_balancer_sku: Optional[pulumi.Input[str]] = None,
                 load_balancer_tier: Optional[pulumi.Input[str]] = None):
        """
        Network profile
        :param pulumi.Input[Union[str, 'LoadBalancerType']] load_balancer_type: Load balancer type
        :param pulumi.Input[Union[str, 'AzureFrontDoorEnabled']] azure_front_door_enabled: Whether to enable Azure front door
        :param pulumi.Input[int] capacity: Capacity, applicable only for Application Gateway
        :param pulumi.Input[str] load_balancer_sku: Load balancer SKU
        :param pulumi.Input[str] load_balancer_tier: Load balancer tier
        """
        pulumi.set(__self__, "load_balancer_type", load_balancer_type)
        if azure_front_door_enabled is not None:
            pulumi.set(__self__, "azure_front_door_enabled", azure_front_door_enabled)
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if load_balancer_sku is not None:
            pulumi.set(__self__, "load_balancer_sku", load_balancer_sku)
        if load_balancer_tier is not None:
            pulumi.set(__self__, "load_balancer_tier", load_balancer_tier)

    @property
    @pulumi.getter(name="loadBalancerType")
    def load_balancer_type(self) -> pulumi.Input[Union[str, 'LoadBalancerType']]:
        """
        Load balancer type
        """
        return pulumi.get(self, "load_balancer_type")

    @load_balancer_type.setter
    def load_balancer_type(self, value: pulumi.Input[Union[str, 'LoadBalancerType']]):
        pulumi.set(self, "load_balancer_type", value)

    @property
    @pulumi.getter(name="azureFrontDoorEnabled")
    def azure_front_door_enabled(self) -> Optional[pulumi.Input[Union[str, 'AzureFrontDoorEnabled']]]:
        """
        Whether to enable Azure front door
        """
        return pulumi.get(self, "azure_front_door_enabled")

    @azure_front_door_enabled.setter
    def azure_front_door_enabled(self, value: Optional[pulumi.Input[Union[str, 'AzureFrontDoorEnabled']]]):
        pulumi.set(self, "azure_front_door_enabled", value)

    @property
    @pulumi.getter
    def capacity(self) -> Optional[pulumi.Input[int]]:
        """
        Capacity, applicable only for Application Gateway
        """
        return pulumi.get(self, "capacity")

    @capacity.setter
    def capacity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "capacity", value)

    @property
    @pulumi.getter(name="loadBalancerSku")
    def load_balancer_sku(self) -> Optional[pulumi.Input[str]]:
        """
        Load balancer SKU
        """
        return pulumi.get(self, "load_balancer_sku")

    @load_balancer_sku.setter
    def load_balancer_sku(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "load_balancer_sku", value)

    @property
    @pulumi.getter(name="loadBalancerTier")
    def load_balancer_tier(self) -> Optional[pulumi.Input[str]]:
        """
        Load balancer tier
        """
        return pulumi.get(self, "load_balancer_tier")

    @load_balancer_tier.setter
    def load_balancer_tier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "load_balancer_tier", value)


@pulumi.input_type
class NodeProfileArgs:
    def __init__(__self__, *,
                 node_sku: pulumi.Input[str],
                 os_disk: pulumi.Input['DiskInfoArgs'],
                 os_image: pulumi.Input['OsImageProfileArgs'],
                 data_disks: Optional[pulumi.Input[Sequence[pulumi.Input['DiskInfoArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        VM or VMSS node profile
        :param pulumi.Input[str] node_sku: VM SKU for node(s)
        :param pulumi.Input['DiskInfoArgs'] os_disk: OS disk details
        :param pulumi.Input['OsImageProfileArgs'] os_image: OS image used for creating the nodes
        :param pulumi.Input[Sequence[pulumi.Input['DiskInfoArgs']]] data_disks: Data disks details. This property is not in use right now
        :param pulumi.Input[str] name: VM or VMSS name
        """
        pulumi.set(__self__, "node_sku", node_sku)
        pulumi.set(__self__, "os_disk", os_disk)
        pulumi.set(__self__, "os_image", os_image)
        if data_disks is not None:
            pulumi.set(__self__, "data_disks", data_disks)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="nodeSku")
    def node_sku(self) -> pulumi.Input[str]:
        """
        VM SKU for node(s)
        """
        return pulumi.get(self, "node_sku")

    @node_sku.setter
    def node_sku(self, value: pulumi.Input[str]):
        pulumi.set(self, "node_sku", value)

    @property
    @pulumi.getter(name="osDisk")
    def os_disk(self) -> pulumi.Input['DiskInfoArgs']:
        """
        OS disk details
        """
        return pulumi.get(self, "os_disk")

    @os_disk.setter
    def os_disk(self, value: pulumi.Input['DiskInfoArgs']):
        pulumi.set(self, "os_disk", value)

    @property
    @pulumi.getter(name="osImage")
    def os_image(self) -> pulumi.Input['OsImageProfileArgs']:
        """
        OS image used for creating the nodes
        """
        return pulumi.get(self, "os_image")

    @os_image.setter
    def os_image(self, value: pulumi.Input['OsImageProfileArgs']):
        pulumi.set(self, "os_image", value)

    @property
    @pulumi.getter(name="dataDisks")
    def data_disks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DiskInfoArgs']]]]:
        """
        Data disks details. This property is not in use right now
        """
        return pulumi.get(self, "data_disks")

    @data_disks.setter
    def data_disks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DiskInfoArgs']]]]):
        pulumi.set(self, "data_disks", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        VM or VMSS name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class OSProfileArgs:
    def __init__(__self__, *,
                 admin_password: Optional[pulumi.Input[str]] = None,
                 admin_username: Optional[pulumi.Input[str]] = None,
                 os_configuration: Optional[pulumi.Input[Union['LinuxConfigurationArgs', 'WindowsConfigurationArgs']]] = None):
        """
        Specifies the operating system settings for the virtual machine. Some of the settings cannot be changed once VM is provisioned.
        :param pulumi.Input[str] admin_password: Specifies the password of the administrator account. <br><br> **Minimum-length (Windows):** 8 characters <br><br> **Minimum-length (Linux):** 6 characters <br><br> **Max-length (Windows):** 123 characters <br><br> **Max-length (Linux):** 72 characters <br><br> **Complexity requirements:** 3 out of 4 conditions below need to be fulfilled <br> Has lower characters <br>Has upper characters <br> Has a digit <br> Has a special character (Regex match [\\W_]) <br><br> **Disallowed values:** "abc@123", "P@$$w0rd", "P@ssw0rd", "P@ssword123", "Pa$$word", "pass@word1", "Password!", "Password1", "Password22", "iloveyou!" <br><br> For resetting the password, see [How to reset the Remote Desktop service or its login password in a Windows VM](https://docs.microsoft.com/troubleshoot/azure/virtual-machines/reset-rdp) <br><br> For resetting root password, see [Manage users, SSH, and check or repair disks on Azure Linux VMs using the VMAccess Extension](https://docs.microsoft.com/troubleshoot/azure/virtual-machines/troubleshoot-ssh-connection)
        :param pulumi.Input[str] admin_username: Specifies the name of the administrator account. <br><br> This property cannot be updated after the VM is created. <br><br> **Windows-only restriction:** Cannot end in "." <br><br> **Disallowed values:** "administrator", "admin", "user", "user1", "test", "user2", "test1", "user3", "admin1", "1", "123", "a", "actuser", "adm", "admin2", "aspnet", "backup", "console", "david", "guest", "john", "owner", "root", "server", "sql", "support", "support_388945a0", "sys", "test2", "test3", "user4", "user5". <br><br> **Minimum-length (Linux):** 1  character <br><br> **Max-length (Linux):** 64 characters <br><br> **Max-length (Windows):** 20 characters.
        :param pulumi.Input[Union['LinuxConfigurationArgs', 'WindowsConfigurationArgs']] os_configuration: Specifies Windows operating system settings on the virtual machine.
        """
        if admin_password is not None:
            pulumi.set(__self__, "admin_password", admin_password)
        if admin_username is not None:
            pulumi.set(__self__, "admin_username", admin_username)
        if os_configuration is not None:
            pulumi.set(__self__, "os_configuration", os_configuration)

    @property
    @pulumi.getter(name="adminPassword")
    def admin_password(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the password of the administrator account. <br><br> **Minimum-length (Windows):** 8 characters <br><br> **Minimum-length (Linux):** 6 characters <br><br> **Max-length (Windows):** 123 characters <br><br> **Max-length (Linux):** 72 characters <br><br> **Complexity requirements:** 3 out of 4 conditions below need to be fulfilled <br> Has lower characters <br>Has upper characters <br> Has a digit <br> Has a special character (Regex match [\\W_]) <br><br> **Disallowed values:** "abc@123", "P@$$w0rd", "P@ssw0rd", "P@ssword123", "Pa$$word", "pass@word1", "Password!", "Password1", "Password22", "iloveyou!" <br><br> For resetting the password, see [How to reset the Remote Desktop service or its login password in a Windows VM](https://docs.microsoft.com/troubleshoot/azure/virtual-machines/reset-rdp) <br><br> For resetting root password, see [Manage users, SSH, and check or repair disks on Azure Linux VMs using the VMAccess Extension](https://docs.microsoft.com/troubleshoot/azure/virtual-machines/troubleshoot-ssh-connection)
        """
        return pulumi.get(self, "admin_password")

    @admin_password.setter
    def admin_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "admin_password", value)

    @property
    @pulumi.getter(name="adminUsername")
    def admin_username(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the administrator account. <br><br> This property cannot be updated after the VM is created. <br><br> **Windows-only restriction:** Cannot end in "." <br><br> **Disallowed values:** "administrator", "admin", "user", "user1", "test", "user2", "test1", "user3", "admin1", "1", "123", "a", "actuser", "adm", "admin2", "aspnet", "backup", "console", "david", "guest", "john", "owner", "root", "server", "sql", "support", "support_388945a0", "sys", "test2", "test3", "user4", "user5". <br><br> **Minimum-length (Linux):** 1  character <br><br> **Max-length (Linux):** 64 characters <br><br> **Max-length (Windows):** 20 characters.
        """
        return pulumi.get(self, "admin_username")

    @admin_username.setter
    def admin_username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "admin_username", value)

    @property
    @pulumi.getter(name="osConfiguration")
    def os_configuration(self) -> Optional[pulumi.Input[Union['LinuxConfigurationArgs', 'WindowsConfigurationArgs']]]:
        """
        Specifies Windows operating system settings on the virtual machine.
        """
        return pulumi.get(self, "os_configuration")

    @os_configuration.setter
    def os_configuration(self, value: Optional[pulumi.Input[Union['LinuxConfigurationArgs', 'WindowsConfigurationArgs']]]):
        pulumi.set(self, "os_configuration", value)


@pulumi.input_type
class OsImageProfileArgs:
    def __init__(__self__, *,
                 offer: Optional[pulumi.Input[Union[str, 'OSImageOffer']]] = None,
                 publisher: Optional[pulumi.Input[Union[str, 'OSImagePublisher']]] = None,
                 sku: Optional[pulumi.Input[Union[str, 'OSImageSku']]] = None,
                 version: Optional[pulumi.Input[Union[str, 'OSImageVersion']]] = None):
        """
        OS image profile
        :param pulumi.Input[Union[str, 'OSImageOffer']] offer: OS image offer
        :param pulumi.Input[Union[str, 'OSImagePublisher']] publisher: OS image publisher
        :param pulumi.Input[Union[str, 'OSImageSku']] sku: OS image sku
        :param pulumi.Input[Union[str, 'OSImageVersion']] version: OS image version
        """
        if offer is not None:
            pulumi.set(__self__, "offer", offer)
        if publisher is not None:
            pulumi.set(__self__, "publisher", publisher)
        if sku is not None:
            pulumi.set(__self__, "sku", sku)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def offer(self) -> Optional[pulumi.Input[Union[str, 'OSImageOffer']]]:
        """
        OS image offer
        """
        return pulumi.get(self, "offer")

    @offer.setter
    def offer(self, value: Optional[pulumi.Input[Union[str, 'OSImageOffer']]]):
        pulumi.set(self, "offer", value)

    @property
    @pulumi.getter
    def publisher(self) -> Optional[pulumi.Input[Union[str, 'OSImagePublisher']]]:
        """
        OS image publisher
        """
        return pulumi.get(self, "publisher")

    @publisher.setter
    def publisher(self, value: Optional[pulumi.Input[Union[str, 'OSImagePublisher']]]):
        pulumi.set(self, "publisher", value)

    @property
    @pulumi.getter
    def sku(self) -> Optional[pulumi.Input[Union[str, 'OSImageSku']]]:
        """
        OS image sku
        """
        return pulumi.get(self, "sku")

    @sku.setter
    def sku(self, value: Optional[pulumi.Input[Union[str, 'OSImageSku']]]):
        pulumi.set(self, "sku", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[Union[str, 'OSImageVersion']]]:
        """
        OS image version
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[Union[str, 'OSImageVersion']]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class OsSapConfigurationArgs:
    def __init__(__self__, *,
                 deployer_vm_packages: Optional[pulumi.Input['DeployerVmPackagesArgs']] = None,
                 sap_fqdn: Optional[pulumi.Input[str]] = None):
        """
        Defines the OS and SAP Configurations for Deployment
        :param pulumi.Input['DeployerVmPackagesArgs'] deployer_vm_packages: The url and storage account ID where deployer VM packages are uploaded
        :param pulumi.Input[str] sap_fqdn: The FQDN to set for the SAP system
        """
        if deployer_vm_packages is not None:
            pulumi.set(__self__, "deployer_vm_packages", deployer_vm_packages)
        if sap_fqdn is not None:
            pulumi.set(__self__, "sap_fqdn", sap_fqdn)

    @property
    @pulumi.getter(name="deployerVmPackages")
    def deployer_vm_packages(self) -> Optional[pulumi.Input['DeployerVmPackagesArgs']]:
        """
        The url and storage account ID where deployer VM packages are uploaded
        """
        return pulumi.get(self, "deployer_vm_packages")

    @deployer_vm_packages.setter
    def deployer_vm_packages(self, value: Optional[pulumi.Input['DeployerVmPackagesArgs']]):
        pulumi.set(self, "deployer_vm_packages", value)

    @property
    @pulumi.getter(name="sapFqdn")
    def sap_fqdn(self) -> Optional[pulumi.Input[str]]:
        """
        The FQDN to set for the SAP system
        """
        return pulumi.get(self, "sap_fqdn")

    @sap_fqdn.setter
    def sap_fqdn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sap_fqdn", value)


@pulumi.input_type
class PhpProfileArgs:
    def __init__(__self__, *,
                 version: pulumi.Input[Union[str, 'PHPVersion']]):
        """
        PHP profile
        :param pulumi.Input[Union[str, 'PHPVersion']] version: PHP version
        """
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def version(self) -> pulumi.Input[Union[str, 'PHPVersion']]:
        """
        PHP version
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: pulumi.Input[Union[str, 'PHPVersion']]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class PhpWorkloadResourceIdentityArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[Union[str, 'ManagedServiceIdentityType']],
                 user_assigned_identities: Optional[pulumi.Input[Mapping[str, Any]]] = None):
        """
        Identity for the resource. Currently not supported
        :param pulumi.Input[Union[str, 'ManagedServiceIdentityType']] type: Type of manage identity
        :param pulumi.Input[Mapping[str, Any]] user_assigned_identities: User assigned identities dictionary
        """
        pulumi.set(__self__, "type", type)
        if user_assigned_identities is not None:
            pulumi.set(__self__, "user_assigned_identities", user_assigned_identities)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[Union[str, 'ManagedServiceIdentityType']]:
        """
        Type of manage identity
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[Union[str, 'ManagedServiceIdentityType']]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="userAssignedIdentities")
    def user_assigned_identities(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        User assigned identities dictionary
        """
        return pulumi.get(self, "user_assigned_identities")

    @user_assigned_identities.setter
    def user_assigned_identities(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "user_assigned_identities", value)


@pulumi.input_type
class PrometheusHaClusterProviderInstancePropertiesArgs:
    def __init__(__self__, *,
                 provider_type: pulumi.Input[str],
                 cluster_name: Optional[pulumi.Input[str]] = None,
                 hostname: Optional[pulumi.Input[str]] = None,
                 prometheus_url: Optional[pulumi.Input[str]] = None,
                 sid: Optional[pulumi.Input[str]] = None):
        """
        Gets or sets the PrometheusHaCluster provider properties.
        :param pulumi.Input[str] provider_type: The provider type. For example, the value can be SapHana.
               Expected value is 'PrometheusHaCluster'.
        :param pulumi.Input[str] cluster_name: Gets or sets the clusterName.
        :param pulumi.Input[str] hostname: Gets or sets the target machine name.
        :param pulumi.Input[str] prometheus_url: URL of the Node Exporter endpoint.
        :param pulumi.Input[str] sid: Gets or sets the cluster sid.
        """
        pulumi.set(__self__, "provider_type", 'PrometheusHaCluster')
        if cluster_name is not None:
            pulumi.set(__self__, "cluster_name", cluster_name)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if prometheus_url is not None:
            pulumi.set(__self__, "prometheus_url", prometheus_url)
        if sid is not None:
            pulumi.set(__self__, "sid", sid)

    @property
    @pulumi.getter(name="providerType")
    def provider_type(self) -> pulumi.Input[str]:
        """
        The provider type. For example, the value can be SapHana.
        Expected value is 'PrometheusHaCluster'.
        """
        return pulumi.get(self, "provider_type")

    @provider_type.setter
    def provider_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "provider_type", value)

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the clusterName.
        """
        return pulumi.get(self, "cluster_name")

    @cluster_name.setter
    def cluster_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_name", value)

    @property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the target machine name.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hostname", value)

    @property
    @pulumi.getter(name="prometheusUrl")
    def prometheus_url(self) -> Optional[pulumi.Input[str]]:
        """
        URL of the Node Exporter endpoint.
        """
        return pulumi.get(self, "prometheus_url")

    @prometheus_url.setter
    def prometheus_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "prometheus_url", value)

    @property
    @pulumi.getter
    def sid(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the cluster sid.
        """
        return pulumi.get(self, "sid")

    @sid.setter
    def sid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sid", value)


@pulumi.input_type
class PrometheusOSProviderInstancePropertiesArgs:
    def __init__(__self__, *,
                 provider_type: pulumi.Input[str],
                 prometheus_url: Optional[pulumi.Input[str]] = None):
        """
        Gets or sets the PrometheusOS provider properties.
        :param pulumi.Input[str] provider_type: The provider type. For example, the value can be SapHana.
               Expected value is 'PrometheusOS'.
        :param pulumi.Input[str] prometheus_url: URL of the Node Exporter endpoint
        """
        pulumi.set(__self__, "provider_type", 'PrometheusOS')
        if prometheus_url is not None:
            pulumi.set(__self__, "prometheus_url", prometheus_url)

    @property
    @pulumi.getter(name="providerType")
    def provider_type(self) -> pulumi.Input[str]:
        """
        The provider type. For example, the value can be SapHana.
        Expected value is 'PrometheusOS'.
        """
        return pulumi.get(self, "provider_type")

    @provider_type.setter
    def provider_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "provider_type", value)

    @property
    @pulumi.getter(name="prometheusUrl")
    def prometheus_url(self) -> Optional[pulumi.Input[str]]:
        """
        URL of the Node Exporter endpoint
        """
        return pulumi.get(self, "prometheus_url")

    @prometheus_url.setter
    def prometheus_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "prometheus_url", value)


@pulumi.input_type
class SAPInstallWithoutOSConfigSoftwareConfigurationArgs:
    def __init__(__self__, *,
                 bom_url: pulumi.Input[str],
                 sap_bits_storage_account_id: pulumi.Input[str],
                 software_installation_type: pulumi.Input[str],
                 software_version: pulumi.Input[str],
                 high_availability_software_configuration: Optional[pulumi.Input['HighAvailabilitySoftwareConfigurationArgs']] = None):
        """
        The SAP Software configuration Input when the software is to be installed by service without OS Configurations
        :param pulumi.Input[str] bom_url: The URL to the SAP Build of Materials(BOM) file.
        :param pulumi.Input[str] sap_bits_storage_account_id: The SAP bits storage account id.
        :param pulumi.Input[str] software_installation_type: The SAP software installation Type.
               Expected value is 'SAPInstallWithoutOSConfig'.
        :param pulumi.Input[str] software_version: The software version to install.
        :param pulumi.Input['HighAvailabilitySoftwareConfigurationArgs'] high_availability_software_configuration: Gets or sets the HA software configuration.
        """
        pulumi.set(__self__, "bom_url", bom_url)
        pulumi.set(__self__, "sap_bits_storage_account_id", sap_bits_storage_account_id)
        pulumi.set(__self__, "software_installation_type", 'SAPInstallWithoutOSConfig')
        pulumi.set(__self__, "software_version", software_version)
        if high_availability_software_configuration is not None:
            pulumi.set(__self__, "high_availability_software_configuration", high_availability_software_configuration)

    @property
    @pulumi.getter(name="bomUrl")
    def bom_url(self) -> pulumi.Input[str]:
        """
        The URL to the SAP Build of Materials(BOM) file.
        """
        return pulumi.get(self, "bom_url")

    @bom_url.setter
    def bom_url(self, value: pulumi.Input[str]):
        pulumi.set(self, "bom_url", value)

    @property
    @pulumi.getter(name="sapBitsStorageAccountId")
    def sap_bits_storage_account_id(self) -> pulumi.Input[str]:
        """
        The SAP bits storage account id.
        """
        return pulumi.get(self, "sap_bits_storage_account_id")

    @sap_bits_storage_account_id.setter
    def sap_bits_storage_account_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "sap_bits_storage_account_id", value)

    @property
    @pulumi.getter(name="softwareInstallationType")
    def software_installation_type(self) -> pulumi.Input[str]:
        """
        The SAP software installation Type.
        Expected value is 'SAPInstallWithoutOSConfig'.
        """
        return pulumi.get(self, "software_installation_type")

    @software_installation_type.setter
    def software_installation_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "software_installation_type", value)

    @property
    @pulumi.getter(name="softwareVersion")
    def software_version(self) -> pulumi.Input[str]:
        """
        The software version to install.
        """
        return pulumi.get(self, "software_version")

    @software_version.setter
    def software_version(self, value: pulumi.Input[str]):
        pulumi.set(self, "software_version", value)

    @property
    @pulumi.getter(name="highAvailabilitySoftwareConfiguration")
    def high_availability_software_configuration(self) -> Optional[pulumi.Input['HighAvailabilitySoftwareConfigurationArgs']]:
        """
        Gets or sets the HA software configuration.
        """
        return pulumi.get(self, "high_availability_software_configuration")

    @high_availability_software_configuration.setter
    def high_availability_software_configuration(self, value: Optional[pulumi.Input['HighAvailabilitySoftwareConfigurationArgs']]):
        pulumi.set(self, "high_availability_software_configuration", value)


@pulumi.input_type
class SapNetWeaverProviderInstancePropertiesArgs:
    def __init__(__self__, *,
                 provider_type: pulumi.Input[str],
                 sap_client_id: Optional[pulumi.Input[str]] = None,
                 sap_host_file_entries: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 sap_hostname: Optional[pulumi.Input[str]] = None,
                 sap_instance_nr: Optional[pulumi.Input[str]] = None,
                 sap_password: Optional[pulumi.Input[str]] = None,
                 sap_password_uri: Optional[pulumi.Input[str]] = None,
                 sap_port_number: Optional[pulumi.Input[str]] = None,
                 sap_sid: Optional[pulumi.Input[str]] = None,
                 sap_ssl_certificate_uri: Optional[pulumi.Input[str]] = None,
                 sap_username: Optional[pulumi.Input[str]] = None):
        """
        Gets or sets the provider properties.
        :param pulumi.Input[str] provider_type: The provider type. For example, the value can be SapHana.
               Expected value is 'SapNetWeaver'.
        :param pulumi.Input[str] sap_client_id: Gets or sets the SAP Client ID.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] sap_host_file_entries: Gets or sets the list of HostFile Entries
        :param pulumi.Input[str] sap_hostname: Gets or sets the target virtual machine IP Address/FQDN.
        :param pulumi.Input[str] sap_instance_nr: Gets or sets the instance number of SAP NetWeaver.
        :param pulumi.Input[str] sap_password: Sets the SAP password.
        :param pulumi.Input[str] sap_password_uri: Gets or sets the key vault URI to secret with the SAP password.
        :param pulumi.Input[str] sap_port_number: Gets or sets the SAP HTTP port number.
        :param pulumi.Input[str] sap_sid: Gets or sets the SAP System Identifier
        :param pulumi.Input[str] sap_ssl_certificate_uri: Gets or sets the blob URI to SSL certificate for the SAP system.
        :param pulumi.Input[str] sap_username: Gets or sets the SAP user name.
        """
        pulumi.set(__self__, "provider_type", 'SapNetWeaver')
        if sap_client_id is not None:
            pulumi.set(__self__, "sap_client_id", sap_client_id)
        if sap_host_file_entries is not None:
            pulumi.set(__self__, "sap_host_file_entries", sap_host_file_entries)
        if sap_hostname is not None:
            pulumi.set(__self__, "sap_hostname", sap_hostname)
        if sap_instance_nr is not None:
            pulumi.set(__self__, "sap_instance_nr", sap_instance_nr)
        if sap_password is not None:
            pulumi.set(__self__, "sap_password", sap_password)
        if sap_password_uri is not None:
            pulumi.set(__self__, "sap_password_uri", sap_password_uri)
        if sap_port_number is not None:
            pulumi.set(__self__, "sap_port_number", sap_port_number)
        if sap_sid is not None:
            pulumi.set(__self__, "sap_sid", sap_sid)
        if sap_ssl_certificate_uri is not None:
            pulumi.set(__self__, "sap_ssl_certificate_uri", sap_ssl_certificate_uri)
        if sap_username is not None:
            pulumi.set(__self__, "sap_username", sap_username)

    @property
    @pulumi.getter(name="providerType")
    def provider_type(self) -> pulumi.Input[str]:
        """
        The provider type. For example, the value can be SapHana.
        Expected value is 'SapNetWeaver'.
        """
        return pulumi.get(self, "provider_type")

    @provider_type.setter
    def provider_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "provider_type", value)

    @property
    @pulumi.getter(name="sapClientId")
    def sap_client_id(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the SAP Client ID.
        """
        return pulumi.get(self, "sap_client_id")

    @sap_client_id.setter
    def sap_client_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sap_client_id", value)

    @property
    @pulumi.getter(name="sapHostFileEntries")
    def sap_host_file_entries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Gets or sets the list of HostFile Entries
        """
        return pulumi.get(self, "sap_host_file_entries")

    @sap_host_file_entries.setter
    def sap_host_file_entries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "sap_host_file_entries", value)

    @property
    @pulumi.getter(name="sapHostname")
    def sap_hostname(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the target virtual machine IP Address/FQDN.
        """
        return pulumi.get(self, "sap_hostname")

    @sap_hostname.setter
    def sap_hostname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sap_hostname", value)

    @property
    @pulumi.getter(name="sapInstanceNr")
    def sap_instance_nr(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the instance number of SAP NetWeaver.
        """
        return pulumi.get(self, "sap_instance_nr")

    @sap_instance_nr.setter
    def sap_instance_nr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sap_instance_nr", value)

    @property
    @pulumi.getter(name="sapPassword")
    def sap_password(self) -> Optional[pulumi.Input[str]]:
        """
        Sets the SAP password.
        """
        return pulumi.get(self, "sap_password")

    @sap_password.setter
    def sap_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sap_password", value)

    @property
    @pulumi.getter(name="sapPasswordUri")
    def sap_password_uri(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the key vault URI to secret with the SAP password.
        """
        return pulumi.get(self, "sap_password_uri")

    @sap_password_uri.setter
    def sap_password_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sap_password_uri", value)

    @property
    @pulumi.getter(name="sapPortNumber")
    def sap_port_number(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the SAP HTTP port number.
        """
        return pulumi.get(self, "sap_port_number")

    @sap_port_number.setter
    def sap_port_number(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sap_port_number", value)

    @property
    @pulumi.getter(name="sapSid")
    def sap_sid(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the SAP System Identifier
        """
        return pulumi.get(self, "sap_sid")

    @sap_sid.setter
    def sap_sid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sap_sid", value)

    @property
    @pulumi.getter(name="sapSslCertificateUri")
    def sap_ssl_certificate_uri(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the blob URI to SSL certificate for the SAP system.
        """
        return pulumi.get(self, "sap_ssl_certificate_uri")

    @sap_ssl_certificate_uri.setter
    def sap_ssl_certificate_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sap_ssl_certificate_uri", value)

    @property
    @pulumi.getter(name="sapUsername")
    def sap_username(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the SAP user name.
        """
        return pulumi.get(self, "sap_username")

    @sap_username.setter
    def sap_username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sap_username", value)


@pulumi.input_type
class SearchProfileArgs:
    def __init__(__self__, *,
                 node_sku: pulumi.Input[str],
                 os_disk: pulumi.Input['DiskInfoArgs'],
                 os_image: pulumi.Input['OsImageProfileArgs'],
                 search_type: pulumi.Input[Union[str, 'SearchType']],
                 data_disks: Optional[pulumi.Input[Sequence[pulumi.Input['DiskInfoArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        Search profile
        :param pulumi.Input[str] node_sku: VM SKU for node(s)
        :param pulumi.Input['DiskInfoArgs'] os_disk: OS disk details
        :param pulumi.Input['OsImageProfileArgs'] os_image: OS image used for creating the nodes
        :param pulumi.Input[Union[str, 'SearchType']] search_type: Search type
        :param pulumi.Input[Sequence[pulumi.Input['DiskInfoArgs']]] data_disks: Data disks details. This property is not in use right now
        :param pulumi.Input[str] name: VM or VMSS name
        """
        pulumi.set(__self__, "node_sku", node_sku)
        pulumi.set(__self__, "os_disk", os_disk)
        pulumi.set(__self__, "os_image", os_image)
        pulumi.set(__self__, "search_type", search_type)
        if data_disks is not None:
            pulumi.set(__self__, "data_disks", data_disks)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="nodeSku")
    def node_sku(self) -> pulumi.Input[str]:
        """
        VM SKU for node(s)
        """
        return pulumi.get(self, "node_sku")

    @node_sku.setter
    def node_sku(self, value: pulumi.Input[str]):
        pulumi.set(self, "node_sku", value)

    @property
    @pulumi.getter(name="osDisk")
    def os_disk(self) -> pulumi.Input['DiskInfoArgs']:
        """
        OS disk details
        """
        return pulumi.get(self, "os_disk")

    @os_disk.setter
    def os_disk(self, value: pulumi.Input['DiskInfoArgs']):
        pulumi.set(self, "os_disk", value)

    @property
    @pulumi.getter(name="osImage")
    def os_image(self) -> pulumi.Input['OsImageProfileArgs']:
        """
        OS image used for creating the nodes
        """
        return pulumi.get(self, "os_image")

    @os_image.setter
    def os_image(self, value: pulumi.Input['OsImageProfileArgs']):
        pulumi.set(self, "os_image", value)

    @property
    @pulumi.getter(name="searchType")
    def search_type(self) -> pulumi.Input[Union[str, 'SearchType']]:
        """
        Search type
        """
        return pulumi.get(self, "search_type")

    @search_type.setter
    def search_type(self, value: pulumi.Input[Union[str, 'SearchType']]):
        pulumi.set(self, "search_type", value)

    @property
    @pulumi.getter(name="dataDisks")
    def data_disks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DiskInfoArgs']]]]:
        """
        Data disks details. This property is not in use right now
        """
        return pulumi.get(self, "data_disks")

    @data_disks.setter
    def data_disks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DiskInfoArgs']]]]):
        pulumi.set(self, "data_disks", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        VM or VMSS name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class ServiceInitiatedSoftwareConfigurationArgs:
    def __init__(__self__, *,
                 bom_url: pulumi.Input[str],
                 sap_bits_storage_account_id: pulumi.Input[str],
                 sap_fqdn: pulumi.Input[str],
                 software_installation_type: pulumi.Input[str],
                 software_version: pulumi.Input[str],
                 ssh_private_key: pulumi.Input[str],
                 high_availability_software_configuration: Optional[pulumi.Input['HighAvailabilitySoftwareConfigurationArgs']] = None):
        """
        The SAP Software configuration Input when the software is to be installed by service.
        :param pulumi.Input[str] bom_url: The URL to the SAP Build of Materials(BOM) file.
        :param pulumi.Input[str] sap_bits_storage_account_id: The SAP bits storage account id.
        :param pulumi.Input[str] sap_fqdn: The FQDN to set for the SAP system during install.
        :param pulumi.Input[str] software_installation_type: The SAP software installation Type.
               Expected value is 'ServiceInitiated'.
        :param pulumi.Input[str] software_version: The software version to install.
        :param pulumi.Input[str] ssh_private_key: The SSH private key.
        :param pulumi.Input['HighAvailabilitySoftwareConfigurationArgs'] high_availability_software_configuration: Gets or sets the HA software configuration.
        """
        pulumi.set(__self__, "bom_url", bom_url)
        pulumi.set(__self__, "sap_bits_storage_account_id", sap_bits_storage_account_id)
        pulumi.set(__self__, "sap_fqdn", sap_fqdn)
        pulumi.set(__self__, "software_installation_type", 'ServiceInitiated')
        pulumi.set(__self__, "software_version", software_version)
        pulumi.set(__self__, "ssh_private_key", ssh_private_key)
        if high_availability_software_configuration is not None:
            pulumi.set(__self__, "high_availability_software_configuration", high_availability_software_configuration)

    @property
    @pulumi.getter(name="bomUrl")
    def bom_url(self) -> pulumi.Input[str]:
        """
        The URL to the SAP Build of Materials(BOM) file.
        """
        return pulumi.get(self, "bom_url")

    @bom_url.setter
    def bom_url(self, value: pulumi.Input[str]):
        pulumi.set(self, "bom_url", value)

    @property
    @pulumi.getter(name="sapBitsStorageAccountId")
    def sap_bits_storage_account_id(self) -> pulumi.Input[str]:
        """
        The SAP bits storage account id.
        """
        return pulumi.get(self, "sap_bits_storage_account_id")

    @sap_bits_storage_account_id.setter
    def sap_bits_storage_account_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "sap_bits_storage_account_id", value)

    @property
    @pulumi.getter(name="sapFqdn")
    def sap_fqdn(self) -> pulumi.Input[str]:
        """
        The FQDN to set for the SAP system during install.
        """
        return pulumi.get(self, "sap_fqdn")

    @sap_fqdn.setter
    def sap_fqdn(self, value: pulumi.Input[str]):
        pulumi.set(self, "sap_fqdn", value)

    @property
    @pulumi.getter(name="softwareInstallationType")
    def software_installation_type(self) -> pulumi.Input[str]:
        """
        The SAP software installation Type.
        Expected value is 'ServiceInitiated'.
        """
        return pulumi.get(self, "software_installation_type")

    @software_installation_type.setter
    def software_installation_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "software_installation_type", value)

    @property
    @pulumi.getter(name="softwareVersion")
    def software_version(self) -> pulumi.Input[str]:
        """
        The software version to install.
        """
        return pulumi.get(self, "software_version")

    @software_version.setter
    def software_version(self, value: pulumi.Input[str]):
        pulumi.set(self, "software_version", value)

    @property
    @pulumi.getter(name="sshPrivateKey")
    def ssh_private_key(self) -> pulumi.Input[str]:
        """
        The SSH private key.
        """
        return pulumi.get(self, "ssh_private_key")

    @ssh_private_key.setter
    def ssh_private_key(self, value: pulumi.Input[str]):
        pulumi.set(self, "ssh_private_key", value)

    @property
    @pulumi.getter(name="highAvailabilitySoftwareConfiguration")
    def high_availability_software_configuration(self) -> Optional[pulumi.Input['HighAvailabilitySoftwareConfigurationArgs']]:
        """
        Gets or sets the HA software configuration.
        """
        return pulumi.get(self, "high_availability_software_configuration")

    @high_availability_software_configuration.setter
    def high_availability_software_configuration(self, value: Optional[pulumi.Input['HighAvailabilitySoftwareConfigurationArgs']]):
        pulumi.set(self, "high_availability_software_configuration", value)


@pulumi.input_type
class SingleServerConfigurationArgs:
    def __init__(__self__, *,
                 app_resource_group: pulumi.Input[str],
                 deployment_type: pulumi.Input[str],
                 subnet_id: pulumi.Input[str],
                 virtual_machine_configuration: pulumi.Input['VirtualMachineConfigurationArgs'],
                 database_type: Optional[pulumi.Input[Union[str, 'SAPDatabaseType']]] = None,
                 network_configuration: Optional[pulumi.Input['NetworkConfigurationArgs']] = None):
        """
        Gets or sets the single server configuration.
        :param pulumi.Input[str] app_resource_group: The application resource group where SAP system resources will be deployed.
        :param pulumi.Input[str] deployment_type: The deployment Type.
               Expected value is 'SingleServer'.
        :param pulumi.Input[str] subnet_id: The subnet id.
        :param pulumi.Input['VirtualMachineConfigurationArgs'] virtual_machine_configuration: Gets or sets the virtual machine configuration.
        :param pulumi.Input[Union[str, 'SAPDatabaseType']] database_type: The database type.
        :param pulumi.Input['NetworkConfigurationArgs'] network_configuration: Network configuration for the server
        """
        pulumi.set(__self__, "app_resource_group", app_resource_group)
        pulumi.set(__self__, "deployment_type", 'SingleServer')
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "virtual_machine_configuration", virtual_machine_configuration)
        if database_type is not None:
            pulumi.set(__self__, "database_type", database_type)
        if network_configuration is not None:
            pulumi.set(__self__, "network_configuration", network_configuration)

    @property
    @pulumi.getter(name="appResourceGroup")
    def app_resource_group(self) -> pulumi.Input[str]:
        """
        The application resource group where SAP system resources will be deployed.
        """
        return pulumi.get(self, "app_resource_group")

    @app_resource_group.setter
    def app_resource_group(self, value: pulumi.Input[str]):
        pulumi.set(self, "app_resource_group", value)

    @property
    @pulumi.getter(name="deploymentType")
    def deployment_type(self) -> pulumi.Input[str]:
        """
        The deployment Type.
        Expected value is 'SingleServer'.
        """
        return pulumi.get(self, "deployment_type")

    @deployment_type.setter
    def deployment_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "deployment_type", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Input[str]:
        """
        The subnet id.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter(name="virtualMachineConfiguration")
    def virtual_machine_configuration(self) -> pulumi.Input['VirtualMachineConfigurationArgs']:
        """
        Gets or sets the virtual machine configuration.
        """
        return pulumi.get(self, "virtual_machine_configuration")

    @virtual_machine_configuration.setter
    def virtual_machine_configuration(self, value: pulumi.Input['VirtualMachineConfigurationArgs']):
        pulumi.set(self, "virtual_machine_configuration", value)

    @property
    @pulumi.getter(name="databaseType")
    def database_type(self) -> Optional[pulumi.Input[Union[str, 'SAPDatabaseType']]]:
        """
        The database type.
        """
        return pulumi.get(self, "database_type")

    @database_type.setter
    def database_type(self, value: Optional[pulumi.Input[Union[str, 'SAPDatabaseType']]]):
        pulumi.set(self, "database_type", value)

    @property
    @pulumi.getter(name="networkConfiguration")
    def network_configuration(self) -> Optional[pulumi.Input['NetworkConfigurationArgs']]:
        """
        Network configuration for the server
        """
        return pulumi.get(self, "network_configuration")

    @network_configuration.setter
    def network_configuration(self, value: Optional[pulumi.Input['NetworkConfigurationArgs']]):
        pulumi.set(self, "network_configuration", value)


@pulumi.input_type
class SiteProfileArgs:
    def __init__(__self__, *,
                 domain_name: Optional[pulumi.Input[str]] = None):
        """
        Workload website profile
        :param pulumi.Input[str] domain_name: Domain name for the application site URL
        """
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[pulumi.Input[str]]:
        """
        Domain name for the application site URL
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain_name", value)


@pulumi.input_type
class SkuArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 capacity: Optional[pulumi.Input[int]] = None,
                 family: Optional[pulumi.Input[str]] = None,
                 size: Optional[pulumi.Input[str]] = None,
                 tier: Optional[pulumi.Input['SkuTier']] = None):
        """
        The resource model definition representing SKU
        :param pulumi.Input[str] name: The name of the SKU. Ex - P3. It is typically a letter+number code
        :param pulumi.Input[int] capacity: If the SKU supports scale out/in then the capacity integer should be included. If scale out/in is not possible for the resource this may be omitted.
        :param pulumi.Input[str] family: If the service has different generations of hardware, for the same SKU, then that can be captured here.
        :param pulumi.Input[str] size: The SKU size. When the name field is the combination of tier and some other value, this would be the standalone code. 
        :param pulumi.Input['SkuTier'] tier: This field is required to be implemented by the Resource Provider if the service has more than one tier, but is not required on a PUT.
        """
        pulumi.set(__self__, "name", name)
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if family is not None:
            pulumi.set(__self__, "family", family)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if tier is not None:
            pulumi.set(__self__, "tier", tier)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the SKU. Ex - P3. It is typically a letter+number code
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def capacity(self) -> Optional[pulumi.Input[int]]:
        """
        If the SKU supports scale out/in then the capacity integer should be included. If scale out/in is not possible for the resource this may be omitted.
        """
        return pulumi.get(self, "capacity")

    @capacity.setter
    def capacity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "capacity", value)

    @property
    @pulumi.getter
    def family(self) -> Optional[pulumi.Input[str]]:
        """
        If the service has different generations of hardware, for the same SKU, then that can be captured here.
        """
        return pulumi.get(self, "family")

    @family.setter
    def family(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "family", value)

    @property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[str]]:
        """
        The SKU size. When the name field is the combination of tier and some other value, this would be the standalone code. 
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter
    def tier(self) -> Optional[pulumi.Input['SkuTier']]:
        """
        This field is required to be implemented by the Resource Provider if the service has more than one tier, but is not required on a PUT.
        """
        return pulumi.get(self, "tier")

    @tier.setter
    def tier(self, value: Optional[pulumi.Input['SkuTier']]):
        pulumi.set(self, "tier", value)


@pulumi.input_type
class SshConfigurationArgs:
    def __init__(__self__, *,
                 public_keys: Optional[pulumi.Input[Sequence[pulumi.Input['SshPublicKeyArgs']]]] = None):
        """
        SSH configuration for Linux based VMs running on Azure
        :param pulumi.Input[Sequence[pulumi.Input['SshPublicKeyArgs']]] public_keys: The list of SSH public keys used to authenticate with linux based VMs.
        """
        if public_keys is not None:
            pulumi.set(__self__, "public_keys", public_keys)

    @property
    @pulumi.getter(name="publicKeys")
    def public_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SshPublicKeyArgs']]]]:
        """
        The list of SSH public keys used to authenticate with linux based VMs.
        """
        return pulumi.get(self, "public_keys")

    @public_keys.setter
    def public_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SshPublicKeyArgs']]]]):
        pulumi.set(self, "public_keys", value)


@pulumi.input_type
class SshKeyPairArgs:
    def __init__(__self__, *,
                 private_key: Optional[pulumi.Input[str]] = None,
                 public_key: Optional[pulumi.Input[str]] = None):
        """
        The SSH Key-pair used to authenticate with the VM. The key needs to be at least 2048-bit and in ssh-rsa format. <br><br> For creating ssh keys, see [Create SSH keys on Linux and Mac for Linux VMs in Azure](https://docs.microsoft.com/azure/virtual-machines/linux/create-ssh-keys-detailed).
        :param pulumi.Input[str] private_key: SSH private key.
        :param pulumi.Input[str] public_key: SSH public key
        """
        if private_key is not None:
            pulumi.set(__self__, "private_key", private_key)
        if public_key is not None:
            pulumi.set(__self__, "public_key", public_key)

    @property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> Optional[pulumi.Input[str]]:
        """
        SSH private key.
        """
        return pulumi.get(self, "private_key")

    @private_key.setter
    def private_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_key", value)

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[pulumi.Input[str]]:
        """
        SSH public key
        """
        return pulumi.get(self, "public_key")

    @public_key.setter
    def public_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "public_key", value)


@pulumi.input_type
class SshPublicKeyArgs:
    def __init__(__self__, *,
                 key_data: Optional[pulumi.Input[str]] = None):
        """
        Contains information about SSH certificate public key and the path on the Linux VM where the public key is placed.
        :param pulumi.Input[str] key_data: SSH public key certificate used to authenticate with the VM through ssh. The key needs to be at least 2048-bit and in ssh-rsa format. <br><br> For creating ssh keys, see [Create SSH keys on Linux and Mac for Linux VMs in Azure](https://docs.microsoft.com/azure/virtual-machines/linux/create-ssh-keys-detailed).
        """
        if key_data is not None:
            pulumi.set(__self__, "key_data", key_data)

    @property
    @pulumi.getter(name="keyData")
    def key_data(self) -> Optional[pulumi.Input[str]]:
        """
        SSH public key certificate used to authenticate with the VM through ssh. The key needs to be at least 2048-bit and in ssh-rsa format. <br><br> For creating ssh keys, see [Create SSH keys on Linux and Mac for Linux VMs in Azure](https://docs.microsoft.com/azure/virtual-machines/linux/create-ssh-keys-detailed).
        """
        return pulumi.get(self, "key_data")

    @key_data.setter
    def key_data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_data", value)


@pulumi.input_type
class ThreeTierConfigurationArgs:
    def __init__(__self__, *,
                 app_resource_group: pulumi.Input[str],
                 application_server: pulumi.Input['ApplicationServerConfigurationArgs'],
                 central_server: pulumi.Input['CentralServerConfigurationArgs'],
                 database_server: pulumi.Input['DatabaseConfigurationArgs'],
                 deployment_type: pulumi.Input[str],
                 high_availability_config: Optional[pulumi.Input['HighAvailabilityConfigurationArgs']] = None,
                 network_configuration: Optional[pulumi.Input['NetworkConfigurationArgs']] = None):
        """
        Gets or sets the three tier SAP configuration.
        :param pulumi.Input[str] app_resource_group: The application resource group where SAP system resources will be deployed.
        :param pulumi.Input['ApplicationServerConfigurationArgs'] application_server: The application server configuration.
        :param pulumi.Input['CentralServerConfigurationArgs'] central_server: The central server configuration.
        :param pulumi.Input['DatabaseConfigurationArgs'] database_server: The database configuration.
        :param pulumi.Input[str] deployment_type: The deployment Type.
               Expected value is 'ThreeTier'.
        :param pulumi.Input['HighAvailabilityConfigurationArgs'] high_availability_config: The high availability configuration.
        :param pulumi.Input['NetworkConfigurationArgs'] network_configuration: Network configuration common to all servers
        """
        pulumi.set(__self__, "app_resource_group", app_resource_group)
        pulumi.set(__self__, "application_server", application_server)
        pulumi.set(__self__, "central_server", central_server)
        pulumi.set(__self__, "database_server", database_server)
        pulumi.set(__self__, "deployment_type", 'ThreeTier')
        if high_availability_config is not None:
            pulumi.set(__self__, "high_availability_config", high_availability_config)
        if network_configuration is not None:
            pulumi.set(__self__, "network_configuration", network_configuration)

    @property
    @pulumi.getter(name="appResourceGroup")
    def app_resource_group(self) -> pulumi.Input[str]:
        """
        The application resource group where SAP system resources will be deployed.
        """
        return pulumi.get(self, "app_resource_group")

    @app_resource_group.setter
    def app_resource_group(self, value: pulumi.Input[str]):
        pulumi.set(self, "app_resource_group", value)

    @property
    @pulumi.getter(name="applicationServer")
    def application_server(self) -> pulumi.Input['ApplicationServerConfigurationArgs']:
        """
        The application server configuration.
        """
        return pulumi.get(self, "application_server")

    @application_server.setter
    def application_server(self, value: pulumi.Input['ApplicationServerConfigurationArgs']):
        pulumi.set(self, "application_server", value)

    @property
    @pulumi.getter(name="centralServer")
    def central_server(self) -> pulumi.Input['CentralServerConfigurationArgs']:
        """
        The central server configuration.
        """
        return pulumi.get(self, "central_server")

    @central_server.setter
    def central_server(self, value: pulumi.Input['CentralServerConfigurationArgs']):
        pulumi.set(self, "central_server", value)

    @property
    @pulumi.getter(name="databaseServer")
    def database_server(self) -> pulumi.Input['DatabaseConfigurationArgs']:
        """
        The database configuration.
        """
        return pulumi.get(self, "database_server")

    @database_server.setter
    def database_server(self, value: pulumi.Input['DatabaseConfigurationArgs']):
        pulumi.set(self, "database_server", value)

    @property
    @pulumi.getter(name="deploymentType")
    def deployment_type(self) -> pulumi.Input[str]:
        """
        The deployment Type.
        Expected value is 'ThreeTier'.
        """
        return pulumi.get(self, "deployment_type")

    @deployment_type.setter
    def deployment_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "deployment_type", value)

    @property
    @pulumi.getter(name="highAvailabilityConfig")
    def high_availability_config(self) -> Optional[pulumi.Input['HighAvailabilityConfigurationArgs']]:
        """
        The high availability configuration.
        """
        return pulumi.get(self, "high_availability_config")

    @high_availability_config.setter
    def high_availability_config(self, value: Optional[pulumi.Input['HighAvailabilityConfigurationArgs']]):
        pulumi.set(self, "high_availability_config", value)

    @property
    @pulumi.getter(name="networkConfiguration")
    def network_configuration(self) -> Optional[pulumi.Input['NetworkConfigurationArgs']]:
        """
        Network configuration common to all servers
        """
        return pulumi.get(self, "network_configuration")

    @network_configuration.setter
    def network_configuration(self, value: Optional[pulumi.Input['NetworkConfigurationArgs']]):
        pulumi.set(self, "network_configuration", value)


@pulumi.input_type
class UserAssignedServiceIdentityArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[Union[str, 'ManagedServiceIdentityType']],
                 user_assigned_identities: Optional[pulumi.Input[Mapping[str, Any]]] = None):
        """
        Managed service identity (user assigned identities)
        :param pulumi.Input[Union[str, 'ManagedServiceIdentityType']] type: Type of manage identity
        :param pulumi.Input[Mapping[str, Any]] user_assigned_identities: User assigned identities dictionary
        """
        pulumi.set(__self__, "type", type)
        if user_assigned_identities is not None:
            pulumi.set(__self__, "user_assigned_identities", user_assigned_identities)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[Union[str, 'ManagedServiceIdentityType']]:
        """
        Type of manage identity
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[Union[str, 'ManagedServiceIdentityType']]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="userAssignedIdentities")
    def user_assigned_identities(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        User assigned identities dictionary
        """
        return pulumi.get(self, "user_assigned_identities")

    @user_assigned_identities.setter
    def user_assigned_identities(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "user_assigned_identities", value)


@pulumi.input_type
class UserProfileArgs:
    def __init__(__self__, *,
                 ssh_public_key: pulumi.Input[str],
                 user_name: pulumi.Input[str]):
        """
        User profile to configure on a compute resources such as VM, VMSS
        :param pulumi.Input[str] ssh_public_key: SSH public key data
        :param pulumi.Input[str] user_name: User name
        """
        pulumi.set(__self__, "ssh_public_key", ssh_public_key)
        pulumi.set(__self__, "user_name", user_name)

    @property
    @pulumi.getter(name="sshPublicKey")
    def ssh_public_key(self) -> pulumi.Input[str]:
        """
        SSH public key data
        """
        return pulumi.get(self, "ssh_public_key")

    @ssh_public_key.setter
    def ssh_public_key(self, value: pulumi.Input[str]):
        pulumi.set(self, "ssh_public_key", value)

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> pulumi.Input[str]:
        """
        User name
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "user_name", value)


@pulumi.input_type
class VirtualMachineConfigurationArgs:
    def __init__(__self__, *,
                 image_reference: pulumi.Input['ImageReferenceArgs'],
                 os_profile: pulumi.Input['OSProfileArgs'],
                 vm_size: pulumi.Input[str]):
        """
        Defines the virtual machine configuration.
        :param pulumi.Input['ImageReferenceArgs'] image_reference: The image reference.
        :param pulumi.Input['OSProfileArgs'] os_profile: The OS profile.
        :param pulumi.Input[str] vm_size: The virtual machine size.
        """
        pulumi.set(__self__, "image_reference", image_reference)
        pulumi.set(__self__, "os_profile", os_profile)
        pulumi.set(__self__, "vm_size", vm_size)

    @property
    @pulumi.getter(name="imageReference")
    def image_reference(self) -> pulumi.Input['ImageReferenceArgs']:
        """
        The image reference.
        """
        return pulumi.get(self, "image_reference")

    @image_reference.setter
    def image_reference(self, value: pulumi.Input['ImageReferenceArgs']):
        pulumi.set(self, "image_reference", value)

    @property
    @pulumi.getter(name="osProfile")
    def os_profile(self) -> pulumi.Input['OSProfileArgs']:
        """
        The OS profile.
        """
        return pulumi.get(self, "os_profile")

    @os_profile.setter
    def os_profile(self, value: pulumi.Input['OSProfileArgs']):
        pulumi.set(self, "os_profile", value)

    @property
    @pulumi.getter(name="vmSize")
    def vm_size(self) -> pulumi.Input[str]:
        """
        The virtual machine size.
        """
        return pulumi.get(self, "vm_size")

    @vm_size.setter
    def vm_size(self, value: pulumi.Input[str]):
        pulumi.set(self, "vm_size", value)


@pulumi.input_type
class VmssNodesProfileArgs:
    def __init__(__self__, *,
                 node_sku: pulumi.Input[str],
                 os_disk: pulumi.Input['DiskInfoArgs'],
                 os_image: pulumi.Input['OsImageProfileArgs'],
                 auto_scale_max_count: Optional[pulumi.Input[int]] = None,
                 auto_scale_min_count: Optional[pulumi.Input[int]] = None,
                 data_disks: Optional[pulumi.Input[Sequence[pulumi.Input['DiskInfoArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        VMSS profile
        :param pulumi.Input[str] node_sku: VM SKU for node(s)
        :param pulumi.Input['DiskInfoArgs'] os_disk: OS disk details
        :param pulumi.Input['OsImageProfileArgs'] os_image: OS image used for creating the nodes
        :param pulumi.Input[int] auto_scale_max_count: Maximum number of nodes for autoscale
        :param pulumi.Input[int] auto_scale_min_count: Minimum number of nodes for autoscale
        :param pulumi.Input[Sequence[pulumi.Input['DiskInfoArgs']]] data_disks: Data disks details. This property is not in use right now
        :param pulumi.Input[str] name: VM or VMSS name
        """
        pulumi.set(__self__, "node_sku", node_sku)
        pulumi.set(__self__, "os_disk", os_disk)
        pulumi.set(__self__, "os_image", os_image)
        if auto_scale_max_count is not None:
            pulumi.set(__self__, "auto_scale_max_count", auto_scale_max_count)
        if auto_scale_min_count is not None:
            pulumi.set(__self__, "auto_scale_min_count", auto_scale_min_count)
        if data_disks is not None:
            pulumi.set(__self__, "data_disks", data_disks)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="nodeSku")
    def node_sku(self) -> pulumi.Input[str]:
        """
        VM SKU for node(s)
        """
        return pulumi.get(self, "node_sku")

    @node_sku.setter
    def node_sku(self, value: pulumi.Input[str]):
        pulumi.set(self, "node_sku", value)

    @property
    @pulumi.getter(name="osDisk")
    def os_disk(self) -> pulumi.Input['DiskInfoArgs']:
        """
        OS disk details
        """
        return pulumi.get(self, "os_disk")

    @os_disk.setter
    def os_disk(self, value: pulumi.Input['DiskInfoArgs']):
        pulumi.set(self, "os_disk", value)

    @property
    @pulumi.getter(name="osImage")
    def os_image(self) -> pulumi.Input['OsImageProfileArgs']:
        """
        OS image used for creating the nodes
        """
        return pulumi.get(self, "os_image")

    @os_image.setter
    def os_image(self, value: pulumi.Input['OsImageProfileArgs']):
        pulumi.set(self, "os_image", value)

    @property
    @pulumi.getter(name="autoScaleMaxCount")
    def auto_scale_max_count(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum number of nodes for autoscale
        """
        return pulumi.get(self, "auto_scale_max_count")

    @auto_scale_max_count.setter
    def auto_scale_max_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "auto_scale_max_count", value)

    @property
    @pulumi.getter(name="autoScaleMinCount")
    def auto_scale_min_count(self) -> Optional[pulumi.Input[int]]:
        """
        Minimum number of nodes for autoscale
        """
        return pulumi.get(self, "auto_scale_min_count")

    @auto_scale_min_count.setter
    def auto_scale_min_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "auto_scale_min_count", value)

    @property
    @pulumi.getter(name="dataDisks")
    def data_disks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DiskInfoArgs']]]]:
        """
        Data disks details. This property is not in use right now
        """
        return pulumi.get(self, "data_disks")

    @data_disks.setter
    def data_disks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DiskInfoArgs']]]]):
        pulumi.set(self, "data_disks", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        VM or VMSS name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class WindowsConfigurationArgs:
    def __init__(__self__, *,
                 os_type: pulumi.Input[str]):
        """
        Specifies Windows operating system settings on the virtual machine.
        :param pulumi.Input[str] os_type: The OS Type
               Expected value is 'Windows'.
        """
        pulumi.set(__self__, "os_type", 'Windows')

    @property
    @pulumi.getter(name="osType")
    def os_type(self) -> pulumi.Input[str]:
        """
        The OS Type
        Expected value is 'Windows'.
        """
        return pulumi.get(self, "os_type")

    @os_type.setter
    def os_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "os_type", value)


