# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AkamaiAccessControlResponse',
    'AkamaiSignatureHeaderAuthenticationKeyResponse',
    'ArmStreamingEndpointCurrentSkuResponse',
    'CrossSiteAccessPoliciesResponse',
    'HlsResponse',
    'IPAccessControlResponse',
    'IPRangeResponse',
    'LiveEventEncodingResponse',
    'LiveEventEndpointResponse',
    'LiveEventInputAccessControlResponse',
    'LiveEventInputResponse',
    'LiveEventInputTrackSelectionResponse',
    'LiveEventOutputTranscriptionTrackResponse',
    'LiveEventPreviewAccessControlResponse',
    'LiveEventPreviewResponse',
    'LiveEventTranscriptionResponse',
    'StreamingEndpointAccessControlResponse',
    'SystemDataResponse',
]

@pulumi.output_type
class AkamaiAccessControlResponse(dict):
    """
    Akamai access control
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "akamaiSignatureHeaderAuthenticationKeyList":
            suggest = "akamai_signature_header_authentication_key_list"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AkamaiAccessControlResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AkamaiAccessControlResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AkamaiAccessControlResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 akamai_signature_header_authentication_key_list: Optional[Sequence['outputs.AkamaiSignatureHeaderAuthenticationKeyResponse']] = None):
        """
        Akamai access control
        :param Sequence['AkamaiSignatureHeaderAuthenticationKeyResponse'] akamai_signature_header_authentication_key_list: authentication key list
        """
        if akamai_signature_header_authentication_key_list is not None:
            pulumi.set(__self__, "akamai_signature_header_authentication_key_list", akamai_signature_header_authentication_key_list)

    @property
    @pulumi.getter(name="akamaiSignatureHeaderAuthenticationKeyList")
    def akamai_signature_header_authentication_key_list(self) -> Optional[Sequence['outputs.AkamaiSignatureHeaderAuthenticationKeyResponse']]:
        """
        authentication key list
        """
        return pulumi.get(self, "akamai_signature_header_authentication_key_list")


@pulumi.output_type
class AkamaiSignatureHeaderAuthenticationKeyResponse(dict):
    """
    Akamai Signature Header authentication key.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "base64Key":
            suggest = "base64_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AkamaiSignatureHeaderAuthenticationKeyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AkamaiSignatureHeaderAuthenticationKeyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AkamaiSignatureHeaderAuthenticationKeyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 base64_key: Optional[str] = None,
                 expiration: Optional[str] = None,
                 identifier: Optional[str] = None):
        """
        Akamai Signature Header authentication key.
        :param str base64_key: authentication key
        :param str expiration: The expiration time of the authentication key.
        :param str identifier: identifier of the key
        """
        if base64_key is not None:
            pulumi.set(__self__, "base64_key", base64_key)
        if expiration is not None:
            pulumi.set(__self__, "expiration", expiration)
        if identifier is not None:
            pulumi.set(__self__, "identifier", identifier)

    @property
    @pulumi.getter(name="base64Key")
    def base64_key(self) -> Optional[str]:
        """
        authentication key
        """
        return pulumi.get(self, "base64_key")

    @property
    @pulumi.getter
    def expiration(self) -> Optional[str]:
        """
        The expiration time of the authentication key.
        """
        return pulumi.get(self, "expiration")

    @property
    @pulumi.getter
    def identifier(self) -> Optional[str]:
        """
        identifier of the key
        """
        return pulumi.get(self, "identifier")


@pulumi.output_type
class ArmStreamingEndpointCurrentSkuResponse(dict):
    """
    The streaming endpoint current sku.
    """
    def __init__(__self__, *,
                 name: str,
                 capacity: Optional[int] = None):
        """
        The streaming endpoint current sku.
        :param str name: The streaming endpoint sku name.
        :param int capacity: The streaming endpoint sku capacity.
        """
        pulumi.set(__self__, "name", name)
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The streaming endpoint sku name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def capacity(self) -> Optional[int]:
        """
        The streaming endpoint sku capacity.
        """
        return pulumi.get(self, "capacity")


@pulumi.output_type
class CrossSiteAccessPoliciesResponse(dict):
    """
    The client access policy.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientAccessPolicy":
            suggest = "client_access_policy"
        elif key == "crossDomainPolicy":
            suggest = "cross_domain_policy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CrossSiteAccessPoliciesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CrossSiteAccessPoliciesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CrossSiteAccessPoliciesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_access_policy: Optional[str] = None,
                 cross_domain_policy: Optional[str] = None):
        """
        The client access policy.
        :param str client_access_policy: The content of clientaccesspolicy.xml used by Silverlight.
        :param str cross_domain_policy: The content of crossdomain.xml used by Silverlight.
        """
        if client_access_policy is not None:
            pulumi.set(__self__, "client_access_policy", client_access_policy)
        if cross_domain_policy is not None:
            pulumi.set(__self__, "cross_domain_policy", cross_domain_policy)

    @property
    @pulumi.getter(name="clientAccessPolicy")
    def client_access_policy(self) -> Optional[str]:
        """
        The content of clientaccesspolicy.xml used by Silverlight.
        """
        return pulumi.get(self, "client_access_policy")

    @property
    @pulumi.getter(name="crossDomainPolicy")
    def cross_domain_policy(self) -> Optional[str]:
        """
        The content of crossdomain.xml used by Silverlight.
        """
        return pulumi.get(self, "cross_domain_policy")


@pulumi.output_type
class HlsResponse(dict):
    """
    HTTP Live Streaming (HLS) packing setting for the live output.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fragmentsPerTsSegment":
            suggest = "fragments_per_ts_segment"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HlsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HlsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HlsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fragments_per_ts_segment: Optional[int] = None):
        """
        HTTP Live Streaming (HLS) packing setting for the live output.
        :param int fragments_per_ts_segment: The number of fragments in an HTTP Live Streaming (HLS) TS segment in the output of the live event. This value does not affect the packing ratio for HLS CMAF output.
        """
        if fragments_per_ts_segment is not None:
            pulumi.set(__self__, "fragments_per_ts_segment", fragments_per_ts_segment)

    @property
    @pulumi.getter(name="fragmentsPerTsSegment")
    def fragments_per_ts_segment(self) -> Optional[int]:
        """
        The number of fragments in an HTTP Live Streaming (HLS) TS segment in the output of the live event. This value does not affect the packing ratio for HLS CMAF output.
        """
        return pulumi.get(self, "fragments_per_ts_segment")


@pulumi.output_type
class IPAccessControlResponse(dict):
    """
    The IP access control.
    """
    def __init__(__self__, *,
                 allow: Optional[Sequence['outputs.IPRangeResponse']] = None):
        """
        The IP access control.
        :param Sequence['IPRangeResponse'] allow: The IP allow list.
        """
        if allow is not None:
            pulumi.set(__self__, "allow", allow)

    @property
    @pulumi.getter
    def allow(self) -> Optional[Sequence['outputs.IPRangeResponse']]:
        """
        The IP allow list.
        """
        return pulumi.get(self, "allow")


@pulumi.output_type
class IPRangeResponse(dict):
    """
    The IP address range in the CIDR scheme.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "subnetPrefixLength":
            suggest = "subnet_prefix_length"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IPRangeResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IPRangeResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IPRangeResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address: Optional[str] = None,
                 name: Optional[str] = None,
                 subnet_prefix_length: Optional[int] = None):
        """
        The IP address range in the CIDR scheme.
        :param str address: The IP address.
        :param str name: The friendly name for the IP address range.
        :param int subnet_prefix_length: The subnet mask prefix length (see CIDR notation).
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if subnet_prefix_length is not None:
            pulumi.set(__self__, "subnet_prefix_length", subnet_prefix_length)

    @property
    @pulumi.getter
    def address(self) -> Optional[str]:
        """
        The IP address.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The friendly name for the IP address range.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="subnetPrefixLength")
    def subnet_prefix_length(self) -> Optional[int]:
        """
        The subnet mask prefix length (see CIDR notation).
        """
        return pulumi.get(self, "subnet_prefix_length")


@pulumi.output_type
class LiveEventEncodingResponse(dict):
    """
    Specifies the live event type and optional encoding settings for encoding live events.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "encodingType":
            suggest = "encoding_type"
        elif key == "keyFrameInterval":
            suggest = "key_frame_interval"
        elif key == "presetName":
            suggest = "preset_name"
        elif key == "stretchMode":
            suggest = "stretch_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LiveEventEncodingResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LiveEventEncodingResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LiveEventEncodingResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 encoding_type: Optional[str] = None,
                 key_frame_interval: Optional[str] = None,
                 preset_name: Optional[str] = None,
                 stretch_mode: Optional[str] = None):
        """
        Specifies the live event type and optional encoding settings for encoding live events.
        :param str encoding_type: Live event type. When encodingType is set to PassthroughBasic or PassthroughStandard, the service simply passes through the incoming video and audio layer(s) to the output. When encodingType is set to Standard or Premium1080p, a live encoder transcodes the incoming stream into multiple bitrates or layers. See https://go.microsoft.com/fwlink/?linkid=2095101 for more information. This property cannot be modified after the live event is created.
        :param str key_frame_interval: Use an ISO 8601 time value between 0.5 to 20 seconds to specify the output fragment length for the video and audio tracks of an encoding live event. For example, use PT2S to indicate 2 seconds. For the video track it also defines the key frame interval, or the length of a GoP (group of pictures).   If this value is not set for an encoding live event, the fragment duration defaults to 2 seconds. The value cannot be set for pass-through live events.
        :param str preset_name: The optional encoding preset name, used when encodingType is not None. This value is specified at creation time and cannot be updated. If the encodingType is set to Standard, then the default preset name is ‘Default720p’. Else if the encodingType is set to Premium1080p, the default preset is ‘Default1080p’.
        :param str stretch_mode: Specifies how the input video will be resized to fit the desired output resolution(s). Default is None
        """
        if encoding_type is not None:
            pulumi.set(__self__, "encoding_type", encoding_type)
        if key_frame_interval is not None:
            pulumi.set(__self__, "key_frame_interval", key_frame_interval)
        if preset_name is not None:
            pulumi.set(__self__, "preset_name", preset_name)
        if stretch_mode is not None:
            pulumi.set(__self__, "stretch_mode", stretch_mode)

    @property
    @pulumi.getter(name="encodingType")
    def encoding_type(self) -> Optional[str]:
        """
        Live event type. When encodingType is set to PassthroughBasic or PassthroughStandard, the service simply passes through the incoming video and audio layer(s) to the output. When encodingType is set to Standard or Premium1080p, a live encoder transcodes the incoming stream into multiple bitrates or layers. See https://go.microsoft.com/fwlink/?linkid=2095101 for more information. This property cannot be modified after the live event is created.
        """
        return pulumi.get(self, "encoding_type")

    @property
    @pulumi.getter(name="keyFrameInterval")
    def key_frame_interval(self) -> Optional[str]:
        """
        Use an ISO 8601 time value between 0.5 to 20 seconds to specify the output fragment length for the video and audio tracks of an encoding live event. For example, use PT2S to indicate 2 seconds. For the video track it also defines the key frame interval, or the length of a GoP (group of pictures).   If this value is not set for an encoding live event, the fragment duration defaults to 2 seconds. The value cannot be set for pass-through live events.
        """
        return pulumi.get(self, "key_frame_interval")

    @property
    @pulumi.getter(name="presetName")
    def preset_name(self) -> Optional[str]:
        """
        The optional encoding preset name, used when encodingType is not None. This value is specified at creation time and cannot be updated. If the encodingType is set to Standard, then the default preset name is ‘Default720p’. Else if the encodingType is set to Premium1080p, the default preset is ‘Default1080p’.
        """
        return pulumi.get(self, "preset_name")

    @property
    @pulumi.getter(name="stretchMode")
    def stretch_mode(self) -> Optional[str]:
        """
        Specifies how the input video will be resized to fit the desired output resolution(s). Default is None
        """
        return pulumi.get(self, "stretch_mode")


@pulumi.output_type
class LiveEventEndpointResponse(dict):
    """
    The live event endpoint.
    """
    def __init__(__self__, *,
                 protocol: Optional[str] = None,
                 url: Optional[str] = None):
        """
        The live event endpoint.
        :param str protocol: The endpoint protocol.
        :param str url: The endpoint URL.
        """
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[str]:
        """
        The endpoint protocol.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter
    def url(self) -> Optional[str]:
        """
        The endpoint URL.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class LiveEventInputAccessControlResponse(dict):
    """
    The IP access control for live event input.
    """
    def __init__(__self__, *,
                 ip: Optional['outputs.IPAccessControlResponse'] = None):
        """
        The IP access control for live event input.
        :param 'IPAccessControlResponse' ip: The IP access control properties.
        """
        if ip is not None:
            pulumi.set(__self__, "ip", ip)

    @property
    @pulumi.getter
    def ip(self) -> Optional['outputs.IPAccessControlResponse']:
        """
        The IP access control properties.
        """
        return pulumi.get(self, "ip")


@pulumi.output_type
class LiveEventInputResponse(dict):
    """
    The live event input.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "streamingProtocol":
            suggest = "streaming_protocol"
        elif key == "accessControl":
            suggest = "access_control"
        elif key == "accessToken":
            suggest = "access_token"
        elif key == "keyFrameIntervalDuration":
            suggest = "key_frame_interval_duration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LiveEventInputResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LiveEventInputResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LiveEventInputResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 streaming_protocol: str,
                 access_control: Optional['outputs.LiveEventInputAccessControlResponse'] = None,
                 access_token: Optional[str] = None,
                 endpoints: Optional[Sequence['outputs.LiveEventEndpointResponse']] = None,
                 key_frame_interval_duration: Optional[str] = None):
        """
        The live event input.
        :param str streaming_protocol: The input protocol for the live event. This is specified at creation time and cannot be updated.
        :param 'LiveEventInputAccessControlResponse' access_control: Access control for live event input.
        :param str access_token: A UUID in string form to uniquely identify the stream. This can be specified at creation time but cannot be updated. If omitted, the service will generate a unique value.
        :param Sequence['LiveEventEndpointResponse'] endpoints: The input endpoints for the live event.
        :param str key_frame_interval_duration: ISO 8601 time duration of the key frame interval duration of the input. This value sets the EXT-X-TARGETDURATION property in the HLS output. For example, use PT2S to indicate 2 seconds. Leave the value empty for encoding live events.
        """
        pulumi.set(__self__, "streaming_protocol", streaming_protocol)
        if access_control is not None:
            pulumi.set(__self__, "access_control", access_control)
        if access_token is not None:
            pulumi.set(__self__, "access_token", access_token)
        if endpoints is not None:
            pulumi.set(__self__, "endpoints", endpoints)
        if key_frame_interval_duration is not None:
            pulumi.set(__self__, "key_frame_interval_duration", key_frame_interval_duration)

    @property
    @pulumi.getter(name="streamingProtocol")
    def streaming_protocol(self) -> str:
        """
        The input protocol for the live event. This is specified at creation time and cannot be updated.
        """
        return pulumi.get(self, "streaming_protocol")

    @property
    @pulumi.getter(name="accessControl")
    def access_control(self) -> Optional['outputs.LiveEventInputAccessControlResponse']:
        """
        Access control for live event input.
        """
        return pulumi.get(self, "access_control")

    @property
    @pulumi.getter(name="accessToken")
    def access_token(self) -> Optional[str]:
        """
        A UUID in string form to uniquely identify the stream. This can be specified at creation time but cannot be updated. If omitted, the service will generate a unique value.
        """
        return pulumi.get(self, "access_token")

    @property
    @pulumi.getter
    def endpoints(self) -> Optional[Sequence['outputs.LiveEventEndpointResponse']]:
        """
        The input endpoints for the live event.
        """
        return pulumi.get(self, "endpoints")

    @property
    @pulumi.getter(name="keyFrameIntervalDuration")
    def key_frame_interval_duration(self) -> Optional[str]:
        """
        ISO 8601 time duration of the key frame interval duration of the input. This value sets the EXT-X-TARGETDURATION property in the HLS output. For example, use PT2S to indicate 2 seconds. Leave the value empty for encoding live events.
        """
        return pulumi.get(self, "key_frame_interval_duration")


@pulumi.output_type
class LiveEventInputTrackSelectionResponse(dict):
    """
    A track selection condition. This property is reserved for future use, any value set on this property will be ignored.
    """
    def __init__(__self__, *,
                 operation: Optional[str] = None,
                 property: Optional[str] = None,
                 value: Optional[str] = None):
        """
        A track selection condition. This property is reserved for future use, any value set on this property will be ignored.
        :param str operation: Comparing operation. This property is reserved for future use, any value set on this property will be ignored.
        :param str property: Property name to select. This property is reserved for future use, any value set on this property will be ignored.
        :param str value: Property value to select. This property is reserved for future use, any value set on this property will be ignored.
        """
        if operation is not None:
            pulumi.set(__self__, "operation", operation)
        if property is not None:
            pulumi.set(__self__, "property", property)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def operation(self) -> Optional[str]:
        """
        Comparing operation. This property is reserved for future use, any value set on this property will be ignored.
        """
        return pulumi.get(self, "operation")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        Property value to select. This property is reserved for future use, any value set on this property will be ignored.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter
    def property(self) -> Optional[str]:
        """
        Property name to select. This property is reserved for future use, any value set on this property will be ignored.
        """
        return pulumi.get(self, "property")


@pulumi.output_type
class LiveEventOutputTranscriptionTrackResponse(dict):
    """
    Describes a transcription track in the output of a live event, generated using speech-to-text transcription. This property is reserved for future use, any value set on this property will be ignored.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "trackName":
            suggest = "track_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LiveEventOutputTranscriptionTrackResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LiveEventOutputTranscriptionTrackResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LiveEventOutputTranscriptionTrackResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 track_name: str):
        """
        Describes a transcription track in the output of a live event, generated using speech-to-text transcription. This property is reserved for future use, any value set on this property will be ignored.
        :param str track_name: The output track name. This property is reserved for future use, any value set on this property will be ignored.
        """
        pulumi.set(__self__, "track_name", track_name)

    @property
    @pulumi.getter(name="trackName")
    def track_name(self) -> str:
        """
        The output track name. This property is reserved for future use, any value set on this property will be ignored.
        """
        return pulumi.get(self, "track_name")


@pulumi.output_type
class LiveEventPreviewAccessControlResponse(dict):
    """
    The IP access control for the live event preview endpoint.
    """
    def __init__(__self__, *,
                 ip: Optional['outputs.IPAccessControlResponse'] = None):
        """
        The IP access control for the live event preview endpoint.
        :param 'IPAccessControlResponse' ip: The IP access control properties.
        """
        if ip is not None:
            pulumi.set(__self__, "ip", ip)

    @property
    @pulumi.getter
    def ip(self) -> Optional['outputs.IPAccessControlResponse']:
        """
        The IP access control properties.
        """
        return pulumi.get(self, "ip")


@pulumi.output_type
class LiveEventPreviewResponse(dict):
    """
    Live event preview settings.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessControl":
            suggest = "access_control"
        elif key == "alternativeMediaId":
            suggest = "alternative_media_id"
        elif key == "previewLocator":
            suggest = "preview_locator"
        elif key == "streamingPolicyName":
            suggest = "streaming_policy_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LiveEventPreviewResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LiveEventPreviewResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LiveEventPreviewResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_control: Optional['outputs.LiveEventPreviewAccessControlResponse'] = None,
                 alternative_media_id: Optional[str] = None,
                 endpoints: Optional[Sequence['outputs.LiveEventEndpointResponse']] = None,
                 preview_locator: Optional[str] = None,
                 streaming_policy_name: Optional[str] = None):
        """
        Live event preview settings.
        :param 'LiveEventPreviewAccessControlResponse' access_control: The access control for live event preview.
        :param str alternative_media_id: An alternative media identifier associated with the streaming locator created for the preview. This value is specified at creation time and cannot be updated. The identifier can be used in the CustomLicenseAcquisitionUrlTemplate or the CustomKeyAcquisitionUrlTemplate of the StreamingPolicy specified in the StreamingPolicyName field.
        :param Sequence['LiveEventEndpointResponse'] endpoints: The endpoints for preview. Do not share the preview URL with the live event audience.
        :param str preview_locator: The identifier of the preview locator in Guid format. Specifying this at creation time allows the caller to know the preview locator url before the event is created. If omitted, the service will generate a random identifier. This value cannot be updated once the live event is created.
        :param str streaming_policy_name: The name of streaming policy used for the live event preview. This value is specified at creation time and cannot be updated.
        """
        if access_control is not None:
            pulumi.set(__self__, "access_control", access_control)
        if alternative_media_id is not None:
            pulumi.set(__self__, "alternative_media_id", alternative_media_id)
        if endpoints is not None:
            pulumi.set(__self__, "endpoints", endpoints)
        if preview_locator is not None:
            pulumi.set(__self__, "preview_locator", preview_locator)
        if streaming_policy_name is not None:
            pulumi.set(__self__, "streaming_policy_name", streaming_policy_name)

    @property
    @pulumi.getter(name="accessControl")
    def access_control(self) -> Optional['outputs.LiveEventPreviewAccessControlResponse']:
        """
        The access control for live event preview.
        """
        return pulumi.get(self, "access_control")

    @property
    @pulumi.getter(name="alternativeMediaId")
    def alternative_media_id(self) -> Optional[str]:
        """
        An alternative media identifier associated with the streaming locator created for the preview. This value is specified at creation time and cannot be updated. The identifier can be used in the CustomLicenseAcquisitionUrlTemplate or the CustomKeyAcquisitionUrlTemplate of the StreamingPolicy specified in the StreamingPolicyName field.
        """
        return pulumi.get(self, "alternative_media_id")

    @property
    @pulumi.getter
    def endpoints(self) -> Optional[Sequence['outputs.LiveEventEndpointResponse']]:
        """
        The endpoints for preview. Do not share the preview URL with the live event audience.
        """
        return pulumi.get(self, "endpoints")

    @property
    @pulumi.getter(name="previewLocator")
    def preview_locator(self) -> Optional[str]:
        """
        The identifier of the preview locator in Guid format. Specifying this at creation time allows the caller to know the preview locator url before the event is created. If omitted, the service will generate a random identifier. This value cannot be updated once the live event is created.
        """
        return pulumi.get(self, "preview_locator")

    @property
    @pulumi.getter(name="streamingPolicyName")
    def streaming_policy_name(self) -> Optional[str]:
        """
        The name of streaming policy used for the live event preview. This value is specified at creation time and cannot be updated.
        """
        return pulumi.get(self, "streaming_policy_name")


@pulumi.output_type
class LiveEventTranscriptionResponse(dict):
    """
    Describes the transcription tracks in the output of a live event, generated using speech-to-text transcription. This property is reserved for future use, any value set on this property will be ignored.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "inputTrackSelection":
            suggest = "input_track_selection"
        elif key == "outputTranscriptionTrack":
            suggest = "output_transcription_track"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LiveEventTranscriptionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LiveEventTranscriptionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LiveEventTranscriptionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 input_track_selection: Optional[Sequence['outputs.LiveEventInputTrackSelectionResponse']] = None,
                 language: Optional[str] = None,
                 output_transcription_track: Optional['outputs.LiveEventOutputTranscriptionTrackResponse'] = None):
        """
        Describes the transcription tracks in the output of a live event, generated using speech-to-text transcription. This property is reserved for future use, any value set on this property will be ignored.
        :param Sequence['LiveEventInputTrackSelectionResponse'] input_track_selection: Provides a mechanism to select the audio track in the input live feed, to which speech-to-text transcription is applied. This property is reserved for future use, any value set on this property will be ignored.
        :param str language: Specifies the language (locale) to be used for speech-to-text transcription – it should match the spoken language in the audio track. The value should be in BCP-47 format (e.g: 'en-US'). See https://go.microsoft.com/fwlink/?linkid=2133742 for more information about the live transcription feature and the list of supported languages.
        :param 'LiveEventOutputTranscriptionTrackResponse' output_transcription_track: Describes a transcription track in the output of a live event, generated using speech-to-text transcription. This property is reserved for future use, any value set on this property will be ignored.
        """
        if input_track_selection is not None:
            pulumi.set(__self__, "input_track_selection", input_track_selection)
        if language is not None:
            pulumi.set(__self__, "language", language)
        if output_transcription_track is not None:
            pulumi.set(__self__, "output_transcription_track", output_transcription_track)

    @property
    @pulumi.getter(name="inputTrackSelection")
    def input_track_selection(self) -> Optional[Sequence['outputs.LiveEventInputTrackSelectionResponse']]:
        """
        Provides a mechanism to select the audio track in the input live feed, to which speech-to-text transcription is applied. This property is reserved for future use, any value set on this property will be ignored.
        """
        return pulumi.get(self, "input_track_selection")

    @property
    @pulumi.getter
    def language(self) -> Optional[str]:
        """
        Specifies the language (locale) to be used for speech-to-text transcription – it should match the spoken language in the audio track. The value should be in BCP-47 format (e.g: 'en-US'). See https://go.microsoft.com/fwlink/?linkid=2133742 for more information about the live transcription feature and the list of supported languages.
        """
        return pulumi.get(self, "language")

    @property
    @pulumi.getter(name="outputTranscriptionTrack")
    def output_transcription_track(self) -> Optional['outputs.LiveEventOutputTranscriptionTrackResponse']:
        """
        Describes a transcription track in the output of a live event, generated using speech-to-text transcription. This property is reserved for future use, any value set on this property will be ignored.
        """
        return pulumi.get(self, "output_transcription_track")


@pulumi.output_type
class StreamingEndpointAccessControlResponse(dict):
    """
    Streaming endpoint access control definition.
    """
    def __init__(__self__, *,
                 akamai: Optional['outputs.AkamaiAccessControlResponse'] = None,
                 ip: Optional['outputs.IPAccessControlResponse'] = None):
        """
        Streaming endpoint access control definition.
        :param 'AkamaiAccessControlResponse' akamai: The access control of Akamai
        :param 'IPAccessControlResponse' ip: The IP access control of the streaming endpoint.
        """
        if akamai is not None:
            pulumi.set(__self__, "akamai", akamai)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)

    @property
    @pulumi.getter
    def akamai(self) -> Optional['outputs.AkamaiAccessControlResponse']:
        """
        The access control of Akamai
        """
        return pulumi.get(self, "akamai")

    @property
    @pulumi.getter
    def ip(self) -> Optional['outputs.IPAccessControlResponse']:
        """
        The IP access control of the streaming endpoint.
        """
        return pulumi.get(self, "ip")


@pulumi.output_type
class SystemDataResponse(dict):
    """
    Metadata pertaining to creation and last modification of the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdAt":
            suggest = "created_at"
        elif key == "createdBy":
            suggest = "created_by"
        elif key == "createdByType":
            suggest = "created_by_type"
        elif key == "lastModifiedAt":
            suggest = "last_modified_at"
        elif key == "lastModifiedBy":
            suggest = "last_modified_by"
        elif key == "lastModifiedByType":
            suggest = "last_modified_by_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SystemDataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_at: Optional[str] = None,
                 created_by: Optional[str] = None,
                 created_by_type: Optional[str] = None,
                 last_modified_at: Optional[str] = None,
                 last_modified_by: Optional[str] = None,
                 last_modified_by_type: Optional[str] = None):
        """
        Metadata pertaining to creation and last modification of the resource.
        :param str created_at: The timestamp of resource creation (UTC).
        :param str created_by: The identity that created the resource.
        :param str created_by_type: The type of identity that created the resource.
        :param str last_modified_at: The timestamp of resource last modification (UTC)
        :param str last_modified_by: The identity that last modified the resource.
        :param str last_modified_by_type: The type of identity that last modified the resource.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if created_by_type is not None:
            pulumi.set(__self__, "created_by_type", created_by_type)
        if last_modified_at is not None:
            pulumi.set(__self__, "last_modified_at", last_modified_at)
        if last_modified_by is not None:
            pulumi.set(__self__, "last_modified_by", last_modified_by)
        if last_modified_by_type is not None:
            pulumi.set(__self__, "last_modified_by_type", last_modified_by_type)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[str]:
        """
        The timestamp of resource creation (UTC).
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[str]:
        """
        The identity that created the resource.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="createdByType")
    def created_by_type(self) -> Optional[str]:
        """
        The type of identity that created the resource.
        """
        return pulumi.get(self, "created_by_type")

    @property
    @pulumi.getter(name="lastModifiedAt")
    def last_modified_at(self) -> Optional[str]:
        """
        The timestamp of resource last modification (UTC)
        """
        return pulumi.get(self, "last_modified_at")

    @property
    @pulumi.getter(name="lastModifiedBy")
    def last_modified_by(self) -> Optional[str]:
        """
        The identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by")

    @property
    @pulumi.getter(name="lastModifiedByType")
    def last_modified_by_type(self) -> Optional[str]:
        """
        The type of identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by_type")


