# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._inputs import *

__all__ = ['HybridRunbookWorkerGroupArgs', 'HybridRunbookWorkerGroup']

@pulumi.input_type
class HybridRunbookWorkerGroupArgs:
    def __init__(__self__, *,
                 automation_account_name: pulumi.Input[str],
                 resource_group_name: pulumi.Input[str],
                 credential: Optional[pulumi.Input['RunAsCredentialAssociationPropertyArgs']] = None,
                 hybrid_runbook_worker_group_name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a HybridRunbookWorkerGroup resource.
        :param pulumi.Input[str] automation_account_name: The name of the automation account.
        :param pulumi.Input[str] resource_group_name: Name of an Azure Resource group.
        :param pulumi.Input['RunAsCredentialAssociationPropertyArgs'] credential: Sets the credential of a worker group.
        :param pulumi.Input[str] hybrid_runbook_worker_group_name: The hybrid runbook worker group name
        """
        pulumi.set(__self__, "automation_account_name", automation_account_name)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if credential is not None:
            pulumi.set(__self__, "credential", credential)
        if hybrid_runbook_worker_group_name is not None:
            pulumi.set(__self__, "hybrid_runbook_worker_group_name", hybrid_runbook_worker_group_name)

    @property
    @pulumi.getter(name="automationAccountName")
    def automation_account_name(self) -> pulumi.Input[str]:
        """
        The name of the automation account.
        """
        return pulumi.get(self, "automation_account_name")

    @automation_account_name.setter
    def automation_account_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "automation_account_name", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[str]:
        """
        Name of an Azure Resource group.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter
    def credential(self) -> Optional[pulumi.Input['RunAsCredentialAssociationPropertyArgs']]:
        """
        Sets the credential of a worker group.
        """
        return pulumi.get(self, "credential")

    @credential.setter
    def credential(self, value: Optional[pulumi.Input['RunAsCredentialAssociationPropertyArgs']]):
        pulumi.set(self, "credential", value)

    @property
    @pulumi.getter(name="hybridRunbookWorkerGroupName")
    def hybrid_runbook_worker_group_name(self) -> Optional[pulumi.Input[str]]:
        """
        The hybrid runbook worker group name
        """
        return pulumi.get(self, "hybrid_runbook_worker_group_name")

    @hybrid_runbook_worker_group_name.setter
    def hybrid_runbook_worker_group_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hybrid_runbook_worker_group_name", value)


class HybridRunbookWorkerGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 automation_account_name: Optional[pulumi.Input[str]] = None,
                 credential: Optional[pulumi.Input[pulumi.InputType['RunAsCredentialAssociationPropertyArgs']]] = None,
                 hybrid_runbook_worker_group_name: Optional[pulumi.Input[str]] = None,
                 resource_group_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Definition of hybrid runbook worker group.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] automation_account_name: The name of the automation account.
        :param pulumi.Input[pulumi.InputType['RunAsCredentialAssociationPropertyArgs']] credential: Sets the credential of a worker group.
        :param pulumi.Input[str] hybrid_runbook_worker_group_name: The hybrid runbook worker group name
        :param pulumi.Input[str] resource_group_name: Name of an Azure Resource group.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: HybridRunbookWorkerGroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Definition of hybrid runbook worker group.

        :param str resource_name: The name of the resource.
        :param HybridRunbookWorkerGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(HybridRunbookWorkerGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 automation_account_name: Optional[pulumi.Input[str]] = None,
                 credential: Optional[pulumi.Input[pulumi.InputType['RunAsCredentialAssociationPropertyArgs']]] = None,
                 hybrid_runbook_worker_group_name: Optional[pulumi.Input[str]] = None,
                 resource_group_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = HybridRunbookWorkerGroupArgs.__new__(HybridRunbookWorkerGroupArgs)

            if automation_account_name is None and not opts.urn:
                raise TypeError("Missing required property 'automation_account_name'")
            __props__.__dict__["automation_account_name"] = automation_account_name
            __props__.__dict__["credential"] = credential
            __props__.__dict__["hybrid_runbook_worker_group_name"] = hybrid_runbook_worker_group_name
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["group_type"] = None
            __props__.__dict__["hybrid_runbook_workers"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["system_data"] = None
            __props__.__dict__["type"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="azure-native:automation:HybridRunbookWorkerGroup"), pulumi.Alias(type_="azure-native:automation/v20220222:HybridRunbookWorkerGroup")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(HybridRunbookWorkerGroup, __self__).__init__(
            'azure-native:automation/v20210622:HybridRunbookWorkerGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'HybridRunbookWorkerGroup':
        """
        Get an existing HybridRunbookWorkerGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = HybridRunbookWorkerGroupArgs.__new__(HybridRunbookWorkerGroupArgs)

        __props__.__dict__["credential"] = None
        __props__.__dict__["group_type"] = None
        __props__.__dict__["hybrid_runbook_workers"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["system_data"] = None
        __props__.__dict__["type"] = None
        return HybridRunbookWorkerGroup(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def credential(self) -> pulumi.Output[Optional['outputs.RunAsCredentialAssociationPropertyResponse']]:
        """
        Sets the credential of a worker group.
        """
        return pulumi.get(self, "credential")

    @property
    @pulumi.getter(name="groupType")
    def group_type(self) -> pulumi.Output[Optional[str]]:
        """
        Type of the HybridWorkerGroup.
        """
        return pulumi.get(self, "group_type")

    @property
    @pulumi.getter(name="hybridRunbookWorkers")
    def hybrid_runbook_workers(self) -> pulumi.Output[Optional[Sequence['outputs.HybridRunbookWorkerLegacyResponse']]]:
        """
        Gets or sets the list of hybrid runbook workers.
        """
        return pulumi.get(self, "hybrid_runbook_workers")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[Optional[str]]:
        """
        Gets or sets the name of the group.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="systemData")
    def system_data(self) -> pulumi.Output['outputs.SystemDataResponse']:
        """
        Resource system metadata.
        """
        return pulumi.get(self, "system_data")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The type of the resource.
        """
        return pulumi.get(self, "type")

