# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetHybridRunbookWorkerGroupResult',
    'AwaitableGetHybridRunbookWorkerGroupResult',
    'get_hybrid_runbook_worker_group',
    'get_hybrid_runbook_worker_group_output',
]

@pulumi.output_type
class GetHybridRunbookWorkerGroupResult:
    """
    Definition of hybrid runbook worker group.
    """
    def __init__(__self__, credential=None, group_type=None, hybrid_runbook_workers=None, id=None, name=None, system_data=None, type=None):
        if credential and not isinstance(credential, dict):
            raise TypeError("Expected argument 'credential' to be a dict")
        pulumi.set(__self__, "credential", credential)
        if group_type and not isinstance(group_type, str):
            raise TypeError("Expected argument 'group_type' to be a str")
        pulumi.set(__self__, "group_type", group_type)
        if hybrid_runbook_workers and not isinstance(hybrid_runbook_workers, list):
            raise TypeError("Expected argument 'hybrid_runbook_workers' to be a list")
        pulumi.set(__self__, "hybrid_runbook_workers", hybrid_runbook_workers)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if system_data and not isinstance(system_data, dict):
            raise TypeError("Expected argument 'system_data' to be a dict")
        pulumi.set(__self__, "system_data", system_data)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def credential(self) -> Optional['outputs.RunAsCredentialAssociationPropertyResponse']:
        """
        Sets the credential of a worker group.
        """
        return pulumi.get(self, "credential")

    @property
    @pulumi.getter(name="groupType")
    def group_type(self) -> Optional[str]:
        """
        Type of the HybridWorkerGroup.
        """
        return pulumi.get(self, "group_type")

    @property
    @pulumi.getter(name="hybridRunbookWorkers")
    def hybrid_runbook_workers(self) -> Optional[Sequence['outputs.HybridRunbookWorkerLegacyResponse']]:
        """
        Gets or sets the list of hybrid runbook workers.
        """
        return pulumi.get(self, "hybrid_runbook_workers")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Gets or sets the id of the resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Gets or sets the name of the group.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="systemData")
    def system_data(self) -> 'outputs.SystemDataResponse':
        """
        Resource system metadata.
        """
        return pulumi.get(self, "system_data")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the resource.
        """
        return pulumi.get(self, "type")


class AwaitableGetHybridRunbookWorkerGroupResult(GetHybridRunbookWorkerGroupResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetHybridRunbookWorkerGroupResult(
            credential=self.credential,
            group_type=self.group_type,
            hybrid_runbook_workers=self.hybrid_runbook_workers,
            id=self.id,
            name=self.name,
            system_data=self.system_data,
            type=self.type)


def get_hybrid_runbook_worker_group(automation_account_name: Optional[str] = None,
                                    hybrid_runbook_worker_group_name: Optional[str] = None,
                                    resource_group_name: Optional[str] = None,
                                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetHybridRunbookWorkerGroupResult:
    """
    Definition of hybrid runbook worker group.
    API Version: 2021-06-22.


    :param str automation_account_name: The name of the automation account.
    :param str hybrid_runbook_worker_group_name: The hybrid runbook worker group name
    :param str resource_group_name: Name of an Azure Resource group.
    """
    __args__ = dict()
    __args__['automationAccountName'] = automation_account_name
    __args__['hybridRunbookWorkerGroupName'] = hybrid_runbook_worker_group_name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure-native:automation:getHybridRunbookWorkerGroup', __args__, opts=opts, typ=GetHybridRunbookWorkerGroupResult).value

    return AwaitableGetHybridRunbookWorkerGroupResult(
        credential=__ret__.credential,
        group_type=__ret__.group_type,
        hybrid_runbook_workers=__ret__.hybrid_runbook_workers,
        id=__ret__.id,
        name=__ret__.name,
        system_data=__ret__.system_data,
        type=__ret__.type)


@_utilities.lift_output_func(get_hybrid_runbook_worker_group)
def get_hybrid_runbook_worker_group_output(automation_account_name: Optional[pulumi.Input[str]] = None,
                                           hybrid_runbook_worker_group_name: Optional[pulumi.Input[str]] = None,
                                           resource_group_name: Optional[pulumi.Input[str]] = None,
                                           opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetHybridRunbookWorkerGroupResult]:
    """
    Definition of hybrid runbook worker group.
    API Version: 2021-06-22.


    :param str automation_account_name: The name of the automation account.
    :param str hybrid_runbook_worker_group_name: The hybrid runbook worker group name
    :param str resource_group_name: Name of an Azure Resource group.
    """
    ...
