# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'DatabaseVulnerabilityAssessmentRuleBaselineItemArgs',
    'ElasticPoolPerDatabaseSettingsArgs',
    'InstanceFailoverGroupReadOnlyEndpointArgs',
    'InstanceFailoverGroupReadWriteEndpointArgs',
    'ManagedInstancePairInfoArgs',
    'PartnerRegionInfoArgs',
    'SkuArgs',
    'VulnerabilityAssessmentRecurringScansPropertiesArgs',
]

@pulumi.input_type
class DatabaseVulnerabilityAssessmentRuleBaselineItemArgs:
    def __init__(__self__, *,
                 result: pulumi.Input[Sequence[pulumi.Input[str]]]):
        """
        Properties for an Azure SQL Database Vulnerability Assessment rule baseline's result.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] result: The rule baseline result
        """
        pulumi.set(__self__, "result", result)

    @property
    @pulumi.getter
    def result(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The rule baseline result
        """
        return pulumi.get(self, "result")

    @result.setter
    def result(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "result", value)


@pulumi.input_type
class ElasticPoolPerDatabaseSettingsArgs:
    def __init__(__self__, *,
                 max_capacity: Optional[pulumi.Input[float]] = None,
                 min_capacity: Optional[pulumi.Input[float]] = None):
        """
        Per database settings of an elastic pool.
        :param pulumi.Input[float] max_capacity: The maximum capacity any one database can consume.
        :param pulumi.Input[float] min_capacity: The minimum capacity all databases are guaranteed.
        """
        if max_capacity is not None:
            pulumi.set(__self__, "max_capacity", max_capacity)
        if min_capacity is not None:
            pulumi.set(__self__, "min_capacity", min_capacity)

    @property
    @pulumi.getter(name="maxCapacity")
    def max_capacity(self) -> Optional[pulumi.Input[float]]:
        """
        The maximum capacity any one database can consume.
        """
        return pulumi.get(self, "max_capacity")

    @max_capacity.setter
    def max_capacity(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "max_capacity", value)

    @property
    @pulumi.getter(name="minCapacity")
    def min_capacity(self) -> Optional[pulumi.Input[float]]:
        """
        The minimum capacity all databases are guaranteed.
        """
        return pulumi.get(self, "min_capacity")

    @min_capacity.setter
    def min_capacity(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "min_capacity", value)


@pulumi.input_type
class InstanceFailoverGroupReadOnlyEndpointArgs:
    def __init__(__self__, *,
                 failover_policy: Optional[pulumi.Input[Union[str, 'ReadOnlyEndpointFailoverPolicy']]] = None):
        """
        Read-only endpoint of the failover group instance.
        :param pulumi.Input[Union[str, 'ReadOnlyEndpointFailoverPolicy']] failover_policy: Failover policy of the read-only endpoint for the failover group.
        """
        if failover_policy is not None:
            pulumi.set(__self__, "failover_policy", failover_policy)

    @property
    @pulumi.getter(name="failoverPolicy")
    def failover_policy(self) -> Optional[pulumi.Input[Union[str, 'ReadOnlyEndpointFailoverPolicy']]]:
        """
        Failover policy of the read-only endpoint for the failover group.
        """
        return pulumi.get(self, "failover_policy")

    @failover_policy.setter
    def failover_policy(self, value: Optional[pulumi.Input[Union[str, 'ReadOnlyEndpointFailoverPolicy']]]):
        pulumi.set(self, "failover_policy", value)


@pulumi.input_type
class InstanceFailoverGroupReadWriteEndpointArgs:
    def __init__(__self__, *,
                 failover_policy: pulumi.Input[Union[str, 'ReadWriteEndpointFailoverPolicy']],
                 failover_with_data_loss_grace_period_minutes: Optional[pulumi.Input[int]] = None):
        """
        Read-write endpoint of the failover group instance.
        :param pulumi.Input[Union[str, 'ReadWriteEndpointFailoverPolicy']] failover_policy: Failover policy of the read-write endpoint for the failover group. If failoverPolicy is Automatic then failoverWithDataLossGracePeriodMinutes is required.
        :param pulumi.Input[int] failover_with_data_loss_grace_period_minutes: Grace period before failover with data loss is attempted for the read-write endpoint. If failoverPolicy is Automatic then failoverWithDataLossGracePeriodMinutes is required.
        """
        pulumi.set(__self__, "failover_policy", failover_policy)
        if failover_with_data_loss_grace_period_minutes is not None:
            pulumi.set(__self__, "failover_with_data_loss_grace_period_minutes", failover_with_data_loss_grace_period_minutes)

    @property
    @pulumi.getter(name="failoverPolicy")
    def failover_policy(self) -> pulumi.Input[Union[str, 'ReadWriteEndpointFailoverPolicy']]:
        """
        Failover policy of the read-write endpoint for the failover group. If failoverPolicy is Automatic then failoverWithDataLossGracePeriodMinutes is required.
        """
        return pulumi.get(self, "failover_policy")

    @failover_policy.setter
    def failover_policy(self, value: pulumi.Input[Union[str, 'ReadWriteEndpointFailoverPolicy']]):
        pulumi.set(self, "failover_policy", value)

    @property
    @pulumi.getter(name="failoverWithDataLossGracePeriodMinutes")
    def failover_with_data_loss_grace_period_minutes(self) -> Optional[pulumi.Input[int]]:
        """
        Grace period before failover with data loss is attempted for the read-write endpoint. If failoverPolicy is Automatic then failoverWithDataLossGracePeriodMinutes is required.
        """
        return pulumi.get(self, "failover_with_data_loss_grace_period_minutes")

    @failover_with_data_loss_grace_period_minutes.setter
    def failover_with_data_loss_grace_period_minutes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "failover_with_data_loss_grace_period_minutes", value)


@pulumi.input_type
class ManagedInstancePairInfoArgs:
    def __init__(__self__, *,
                 partner_managed_instance_id: Optional[pulumi.Input[str]] = None,
                 primary_managed_instance_id: Optional[pulumi.Input[str]] = None):
        """
        Pairs of Managed Instances in the failover group.
        :param pulumi.Input[str] partner_managed_instance_id: Id of Partner Managed Instance in pair.
        :param pulumi.Input[str] primary_managed_instance_id: Id of Primary Managed Instance in pair.
        """
        if partner_managed_instance_id is not None:
            pulumi.set(__self__, "partner_managed_instance_id", partner_managed_instance_id)
        if primary_managed_instance_id is not None:
            pulumi.set(__self__, "primary_managed_instance_id", primary_managed_instance_id)

    @property
    @pulumi.getter(name="partnerManagedInstanceId")
    def partner_managed_instance_id(self) -> Optional[pulumi.Input[str]]:
        """
        Id of Partner Managed Instance in pair.
        """
        return pulumi.get(self, "partner_managed_instance_id")

    @partner_managed_instance_id.setter
    def partner_managed_instance_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "partner_managed_instance_id", value)

    @property
    @pulumi.getter(name="primaryManagedInstanceId")
    def primary_managed_instance_id(self) -> Optional[pulumi.Input[str]]:
        """
        Id of Primary Managed Instance in pair.
        """
        return pulumi.get(self, "primary_managed_instance_id")

    @primary_managed_instance_id.setter
    def primary_managed_instance_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "primary_managed_instance_id", value)


@pulumi.input_type
class PartnerRegionInfoArgs:
    def __init__(__self__, *,
                 location: Optional[pulumi.Input[str]] = None):
        """
        Partner region information for the failover group.
        :param pulumi.Input[str] location: Geo location of the partner managed instances.
        """
        if location is not None:
            pulumi.set(__self__, "location", location)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        Geo location of the partner managed instances.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)


@pulumi.input_type
class SkuArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 capacity: Optional[pulumi.Input[int]] = None,
                 family: Optional[pulumi.Input[str]] = None,
                 size: Optional[pulumi.Input[str]] = None,
                 tier: Optional[pulumi.Input[str]] = None):
        """
        An ARM Resource SKU.
        :param pulumi.Input[str] name: The name of the SKU, typically, a letter + Number code, e.g. P3.
        :param pulumi.Input[int] capacity: Capacity of the particular SKU.
        :param pulumi.Input[str] family: If the service has different generations of hardware, for the same SKU, then that can be captured here.
        :param pulumi.Input[str] size: Size of the particular SKU
        :param pulumi.Input[str] tier: The tier or edition of the particular SKU, e.g. Basic, Premium.
        """
        pulumi.set(__self__, "name", name)
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if family is not None:
            pulumi.set(__self__, "family", family)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if tier is not None:
            pulumi.set(__self__, "tier", tier)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the SKU, typically, a letter + Number code, e.g. P3.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def capacity(self) -> Optional[pulumi.Input[int]]:
        """
        Capacity of the particular SKU.
        """
        return pulumi.get(self, "capacity")

    @capacity.setter
    def capacity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "capacity", value)

    @property
    @pulumi.getter
    def family(self) -> Optional[pulumi.Input[str]]:
        """
        If the service has different generations of hardware, for the same SKU, then that can be captured here.
        """
        return pulumi.get(self, "family")

    @family.setter
    def family(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "family", value)

    @property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[str]]:
        """
        Size of the particular SKU
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter
    def tier(self) -> Optional[pulumi.Input[str]]:
        """
        The tier or edition of the particular SKU, e.g. Basic, Premium.
        """
        return pulumi.get(self, "tier")

    @tier.setter
    def tier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tier", value)


@pulumi.input_type
class VulnerabilityAssessmentRecurringScansPropertiesArgs:
    def __init__(__self__, *,
                 email_subscription_admins: Optional[pulumi.Input[bool]] = None,
                 emails: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 is_enabled: Optional[pulumi.Input[bool]] = None):
        """
        Properties of a Vulnerability Assessment recurring scans.
        :param pulumi.Input[bool] email_subscription_admins: Specifies that the schedule scan notification will be is sent to the subscription administrators.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] emails: Specifies an array of e-mail addresses to which the scan notification is sent.
        :param pulumi.Input[bool] is_enabled: Recurring scans state.
        """
        if email_subscription_admins is None:
            email_subscription_admins = True
        if email_subscription_admins is not None:
            pulumi.set(__self__, "email_subscription_admins", email_subscription_admins)
        if emails is not None:
            pulumi.set(__self__, "emails", emails)
        if is_enabled is not None:
            pulumi.set(__self__, "is_enabled", is_enabled)

    @property
    @pulumi.getter(name="emailSubscriptionAdmins")
    def email_subscription_admins(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies that the schedule scan notification will be is sent to the subscription administrators.
        """
        return pulumi.get(self, "email_subscription_admins")

    @email_subscription_admins.setter
    def email_subscription_admins(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "email_subscription_admins", value)

    @property
    @pulumi.getter
    def emails(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies an array of e-mail addresses to which the scan notification is sent.
        """
        return pulumi.get(self, "emails")

    @emails.setter
    def emails(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "emails", value)

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Recurring scans state.
        """
        return pulumi.get(self, "is_enabled")

    @is_enabled.setter
    def is_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_enabled", value)


