# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities

__all__ = [
    'GetFederatedIdentityCredentialResult',
    'AwaitableGetFederatedIdentityCredentialResult',
    'get_federated_identity_credential',
    'get_federated_identity_credential_output',
]

@pulumi.output_type
class GetFederatedIdentityCredentialResult:
    """
    Describes a federated identity credential.
    """
    def __init__(__self__, audiences=None, id=None, issuer=None, name=None, subject=None, type=None):
        if audiences and not isinstance(audiences, list):
            raise TypeError("Expected argument 'audiences' to be a list")
        pulumi.set(__self__, "audiences", audiences)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if issuer and not isinstance(issuer, str):
            raise TypeError("Expected argument 'issuer' to be a str")
        pulumi.set(__self__, "issuer", issuer)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if subject and not isinstance(subject, str):
            raise TypeError("Expected argument 'subject' to be a str")
        pulumi.set(__self__, "subject", subject)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def audiences(self) -> Sequence[str]:
        """
        The list of audiences that can appear in the issued token.
        """
        return pulumi.get(self, "audiences")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def issuer(self) -> str:
        """
        The URL of the issuer to be trusted.
        """
        return pulumi.get(self, "issuer")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def subject(self) -> str:
        """
        The identifier of the external identity.
        """
        return pulumi.get(self, "subject")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
        """
        return pulumi.get(self, "type")


class AwaitableGetFederatedIdentityCredentialResult(GetFederatedIdentityCredentialResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFederatedIdentityCredentialResult(
            audiences=self.audiences,
            id=self.id,
            issuer=self.issuer,
            name=self.name,
            subject=self.subject,
            type=self.type)


def get_federated_identity_credential(federated_identity_credential_resource_name: Optional[str] = None,
                                      resource_group_name: Optional[str] = None,
                                      resource_name: Optional[str] = None,
                                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFederatedIdentityCredentialResult:
    """
    Describes a federated identity credential.


    :param str federated_identity_credential_resource_name: The name of the federated identity credential resource.
    :param str resource_group_name: The name of the Resource Group to which the identity belongs.
    :param str resource_name: The name of the identity resource.
    """
    __args__ = dict()
    __args__['federatedIdentityCredentialResourceName'] = federated_identity_credential_resource_name
    __args__['resourceGroupName'] = resource_group_name
    __args__['resourceName'] = resource_name
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('azure-native:managedidentity/v20220131preview:getFederatedIdentityCredential', __args__, opts=opts, typ=GetFederatedIdentityCredentialResult).value

    return AwaitableGetFederatedIdentityCredentialResult(
        audiences=__ret__.audiences,
        id=__ret__.id,
        issuer=__ret__.issuer,
        name=__ret__.name,
        subject=__ret__.subject,
        type=__ret__.type)


@_utilities.lift_output_func(get_federated_identity_credential)
def get_federated_identity_credential_output(federated_identity_credential_resource_name: Optional[pulumi.Input[str]] = None,
                                             resource_group_name: Optional[pulumi.Input[str]] = None,
                                             resource_name: Optional[pulumi.Input[str]] = None,
                                             opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetFederatedIdentityCredentialResult]:
    """
    Describes a federated identity credential.


    :param str federated_identity_credential_resource_name: The name of the federated identity credential resource.
    :param str resource_group_name: The name of the Resource Group to which the identity belongs.
    :param str resource_name: The name of the identity resource.
    """
    ...
