# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AccessReviewHistoryInstanceResponse',
    'AccessReviewInstanceResponse',
    'AccessReviewReviewerResponse',
    'AccessReviewScopeResponse',
    'ApprovalSettingsResponse',
    'ApprovalStageResponse',
    'IdentityResponse',
    'ManagementLockOwnerResponse',
    'NonComplianceMessageResponse',
    'ParameterDefinitionsValueResponse',
    'ParameterDefinitionsValueResponseMetadata',
    'ParameterValuesValueResponse',
    'PermissionResponse',
    'PolicyAssignmentPropertiesResponse',
    'PolicyAssignmentPropertiesResponsePolicy',
    'PolicyAssignmentPropertiesResponseRoleDefinition',
    'PolicyAssignmentPropertiesResponseScope',
    'PolicyDefinitionGroupResponse',
    'PolicyDefinitionReferenceResponse',
    'PrincipalResponse',
    'PrivateLinkAssociationPropertiesExpandedResponse',
    'ResourceManagementPrivateLinkEndpointConnectionsResponse',
    'RoleManagementPolicyApprovalRuleResponse',
    'RoleManagementPolicyAuthenticationContextRuleResponse',
    'RoleManagementPolicyEnablementRuleResponse',
    'RoleManagementPolicyExpirationRuleResponse',
    'RoleManagementPolicyNotificationRuleResponse',
    'RoleManagementPolicyRuleTargetResponse',
    'SystemDataResponse',
    'UserSetResponse',
]

@pulumi.output_type
class AccessReviewHistoryInstanceResponse(dict):
    """
    Access Review History Definition Instance.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "downloadUri":
            suggest = "download_uri"
        elif key == "displayName":
            suggest = "display_name"
        elif key == "fulfilledDateTime":
            suggest = "fulfilled_date_time"
        elif key == "reviewHistoryPeriodEndDateTime":
            suggest = "review_history_period_end_date_time"
        elif key == "reviewHistoryPeriodStartDateTime":
            suggest = "review_history_period_start_date_time"
        elif key == "runDateTime":
            suggest = "run_date_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccessReviewHistoryInstanceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccessReviewHistoryInstanceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccessReviewHistoryInstanceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 download_uri: str,
                 id: str,
                 name: str,
                 status: str,
                 type: str,
                 display_name: Optional[str] = None,
                 expiration: Optional[str] = None,
                 fulfilled_date_time: Optional[str] = None,
                 review_history_period_end_date_time: Optional[str] = None,
                 review_history_period_start_date_time: Optional[str] = None,
                 run_date_time: Optional[str] = None):
        """
        Access Review History Definition Instance.
        :param str download_uri: Uri which can be used to retrieve review history data. To generate this Uri, generateDownloadUri() must be called for a specific accessReviewHistoryDefinitionInstance. The link expires after a 24 hour period. Callers can see the expiration date time by looking at the 'se' parameter in the generated uri.
        :param str id: The access review history definition instance id.
        :param str name: The access review history definition instance unique id.
        :param str status: Status of the requested review history instance data. This is either requested, in-progress, done or error. The state transitions are as follows - Requested -> InProgress -> Done -> Expired
        :param str type: The resource type.
        :param str display_name: The display name for the parent history definition.
        :param str expiration: Date time when history data report expires and the associated data is deleted.
        :param str fulfilled_date_time: Date time when the history data report is scheduled to be generated.
        :param str review_history_period_end_date_time: Date time used when selecting review data, all reviews included in data end on or before this date. For use only with one-time/non-recurring reports.
        :param str review_history_period_start_date_time: Date time used when selecting review data, all reviews included in data start on or after this date. For use only with one-time/non-recurring reports.
        :param str run_date_time: Date time when the history data report is scheduled to be generated.
        """
        pulumi.set(__self__, "download_uri", download_uri)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "type", type)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if expiration is not None:
            pulumi.set(__self__, "expiration", expiration)
        if fulfilled_date_time is not None:
            pulumi.set(__self__, "fulfilled_date_time", fulfilled_date_time)
        if review_history_period_end_date_time is not None:
            pulumi.set(__self__, "review_history_period_end_date_time", review_history_period_end_date_time)
        if review_history_period_start_date_time is not None:
            pulumi.set(__self__, "review_history_period_start_date_time", review_history_period_start_date_time)
        if run_date_time is not None:
            pulumi.set(__self__, "run_date_time", run_date_time)

    @property
    @pulumi.getter(name="downloadUri")
    def download_uri(self) -> str:
        """
        Uri which can be used to retrieve review history data. To generate this Uri, generateDownloadUri() must be called for a specific accessReviewHistoryDefinitionInstance. The link expires after a 24 hour period. Callers can see the expiration date time by looking at the 'se' parameter in the generated uri.
        """
        return pulumi.get(self, "download_uri")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The access review history definition instance id.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The access review history definition instance unique id.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Status of the requested review history instance data. This is either requested, in-progress, done or error. The state transitions are as follows - Requested -> InProgress -> Done -> Expired
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The resource type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        The display name for the parent history definition.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def expiration(self) -> Optional[str]:
        """
        Date time when history data report expires and the associated data is deleted.
        """
        return pulumi.get(self, "expiration")

    @property
    @pulumi.getter(name="fulfilledDateTime")
    def fulfilled_date_time(self) -> Optional[str]:
        """
        Date time when the history data report is scheduled to be generated.
        """
        return pulumi.get(self, "fulfilled_date_time")

    @property
    @pulumi.getter(name="reviewHistoryPeriodEndDateTime")
    def review_history_period_end_date_time(self) -> Optional[str]:
        """
        Date time used when selecting review data, all reviews included in data end on or before this date. For use only with one-time/non-recurring reports.
        """
        return pulumi.get(self, "review_history_period_end_date_time")

    @property
    @pulumi.getter(name="reviewHistoryPeriodStartDateTime")
    def review_history_period_start_date_time(self) -> Optional[str]:
        """
        Date time used when selecting review data, all reviews included in data start on or after this date. For use only with one-time/non-recurring reports.
        """
        return pulumi.get(self, "review_history_period_start_date_time")

    @property
    @pulumi.getter(name="runDateTime")
    def run_date_time(self) -> Optional[str]:
        """
        Date time when the history data report is scheduled to be generated.
        """
        return pulumi.get(self, "run_date_time")


@pulumi.output_type
class AccessReviewInstanceResponse(dict):
    """
    Access Review Instance.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "reviewersType":
            suggest = "reviewers_type"
        elif key == "backupReviewers":
            suggest = "backup_reviewers"
        elif key == "endDateTime":
            suggest = "end_date_time"
        elif key == "startDateTime":
            suggest = "start_date_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccessReviewInstanceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccessReviewInstanceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccessReviewInstanceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: str,
                 name: str,
                 reviewers_type: str,
                 status: str,
                 type: str,
                 backup_reviewers: Optional[Sequence['outputs.AccessReviewReviewerResponse']] = None,
                 end_date_time: Optional[str] = None,
                 reviewers: Optional[Sequence['outputs.AccessReviewReviewerResponse']] = None,
                 start_date_time: Optional[str] = None):
        """
        Access Review Instance.
        :param str id: The access review instance id.
        :param str name: The access review instance name.
        :param str reviewers_type: This field specifies the type of reviewers for a review. Usually for a review, reviewers are explicitly assigned. However, in some cases, the reviewers may not be assigned and instead be chosen dynamically. For example managers review or self review.
        :param str status: This read-only field specifies the status of an access review instance.
        :param str type: The resource type.
        :param Sequence['AccessReviewReviewerResponse'] backup_reviewers: This is the collection of backup reviewers.
        :param str end_date_time: The DateTime when the review instance is scheduled to end.
        :param Sequence['AccessReviewReviewerResponse'] reviewers: This is the collection of reviewers.
        :param str start_date_time: The DateTime when the review instance is scheduled to be start.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "reviewers_type", reviewers_type)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "type", type)
        if backup_reviewers is not None:
            pulumi.set(__self__, "backup_reviewers", backup_reviewers)
        if end_date_time is not None:
            pulumi.set(__self__, "end_date_time", end_date_time)
        if reviewers is not None:
            pulumi.set(__self__, "reviewers", reviewers)
        if start_date_time is not None:
            pulumi.set(__self__, "start_date_time", start_date_time)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The access review instance id.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The access review instance name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="reviewersType")
    def reviewers_type(self) -> str:
        """
        This field specifies the type of reviewers for a review. Usually for a review, reviewers are explicitly assigned. However, in some cases, the reviewers may not be assigned and instead be chosen dynamically. For example managers review or self review.
        """
        return pulumi.get(self, "reviewers_type")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        This read-only field specifies the status of an access review instance.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The resource type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="backupReviewers")
    def backup_reviewers(self) -> Optional[Sequence['outputs.AccessReviewReviewerResponse']]:
        """
        This is the collection of backup reviewers.
        """
        return pulumi.get(self, "backup_reviewers")

    @property
    @pulumi.getter(name="endDateTime")
    def end_date_time(self) -> Optional[str]:
        """
        The DateTime when the review instance is scheduled to end.
        """
        return pulumi.get(self, "end_date_time")

    @property
    @pulumi.getter
    def reviewers(self) -> Optional[Sequence['outputs.AccessReviewReviewerResponse']]:
        """
        This is the collection of reviewers.
        """
        return pulumi.get(self, "reviewers")

    @property
    @pulumi.getter(name="startDateTime")
    def start_date_time(self) -> Optional[str]:
        """
        The DateTime when the review instance is scheduled to be start.
        """
        return pulumi.get(self, "start_date_time")


@pulumi.output_type
class AccessReviewReviewerResponse(dict):
    """
    Descriptor for what needs to be reviewed
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "principalType":
            suggest = "principal_type"
        elif key == "principalId":
            suggest = "principal_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccessReviewReviewerResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccessReviewReviewerResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccessReviewReviewerResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 principal_type: str,
                 principal_id: Optional[str] = None):
        """
        Descriptor for what needs to be reviewed
        :param str principal_type: The identity type : user/servicePrincipal
        :param str principal_id: The id of the reviewer(user/servicePrincipal)
        """
        pulumi.set(__self__, "principal_type", principal_type)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)

    @property
    @pulumi.getter(name="principalType")
    def principal_type(self) -> str:
        """
        The identity type : user/servicePrincipal
        """
        return pulumi.get(self, "principal_type")

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[str]:
        """
        The id of the reviewer(user/servicePrincipal)
        """
        return pulumi.get(self, "principal_id")


@pulumi.output_type
class AccessReviewScopeResponse(dict):
    """
    Descriptor for what needs to be reviewed
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "assignmentState":
            suggest = "assignment_state"
        elif key == "principalType":
            suggest = "principal_type"
        elif key == "resourceId":
            suggest = "resource_id"
        elif key == "roleDefinitionId":
            suggest = "role_definition_id"
        elif key == "excludeResourceId":
            suggest = "exclude_resource_id"
        elif key == "excludeRoleDefinitionId":
            suggest = "exclude_role_definition_id"
        elif key == "expandNestedMemberships":
            suggest = "expand_nested_memberships"
        elif key == "inactiveDuration":
            suggest = "inactive_duration"
        elif key == "includeAccessBelowResource":
            suggest = "include_access_below_resource"
        elif key == "includeInheritedAccess":
            suggest = "include_inherited_access"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccessReviewScopeResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccessReviewScopeResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccessReviewScopeResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 assignment_state: str,
                 principal_type: str,
                 resource_id: str,
                 role_definition_id: str,
                 exclude_resource_id: Optional[str] = None,
                 exclude_role_definition_id: Optional[str] = None,
                 expand_nested_memberships: Optional[bool] = None,
                 inactive_duration: Optional[str] = None,
                 include_access_below_resource: Optional[bool] = None,
                 include_inherited_access: Optional[bool] = None):
        """
        Descriptor for what needs to be reviewed
        :param str assignment_state: The role assignment state eligible/active to review
        :param str principal_type: The identity type user/servicePrincipal to review
        :param str resource_id: ResourceId in which this review is getting created
        :param str role_definition_id: This is used to indicate the role being reviewed
        :param str exclude_resource_id: This is used to indicate the resource id(s) to exclude
        :param str exclude_role_definition_id: This is used to indicate the role definition id(s) to exclude
        :param bool expand_nested_memberships: Flag to indicate whether to expand nested memberships or not.
        :param str inactive_duration: Duration users are inactive for. The value should be in ISO  8601 format (http://en.wikipedia.org/wiki/ISO_8601#Durations).This code can be used to convert TimeSpan to a valid interval string: XmlConvert.ToString(new TimeSpan(hours, minutes, seconds))
        :param bool include_access_below_resource: Flag to indicate whether to expand nested memberships or not.
        :param bool include_inherited_access: Flag to indicate whether to expand nested memberships or not.
        """
        pulumi.set(__self__, "assignment_state", assignment_state)
        pulumi.set(__self__, "principal_type", principal_type)
        pulumi.set(__self__, "resource_id", resource_id)
        pulumi.set(__self__, "role_definition_id", role_definition_id)
        if exclude_resource_id is not None:
            pulumi.set(__self__, "exclude_resource_id", exclude_resource_id)
        if exclude_role_definition_id is not None:
            pulumi.set(__self__, "exclude_role_definition_id", exclude_role_definition_id)
        if expand_nested_memberships is not None:
            pulumi.set(__self__, "expand_nested_memberships", expand_nested_memberships)
        if inactive_duration is not None:
            pulumi.set(__self__, "inactive_duration", inactive_duration)
        if include_access_below_resource is not None:
            pulumi.set(__self__, "include_access_below_resource", include_access_below_resource)
        if include_inherited_access is not None:
            pulumi.set(__self__, "include_inherited_access", include_inherited_access)

    @property
    @pulumi.getter(name="assignmentState")
    def assignment_state(self) -> str:
        """
        The role assignment state eligible/active to review
        """
        return pulumi.get(self, "assignment_state")

    @property
    @pulumi.getter(name="principalType")
    def principal_type(self) -> str:
        """
        The identity type user/servicePrincipal to review
        """
        return pulumi.get(self, "principal_type")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> str:
        """
        ResourceId in which this review is getting created
        """
        return pulumi.get(self, "resource_id")

    @property
    @pulumi.getter(name="roleDefinitionId")
    def role_definition_id(self) -> str:
        """
        This is used to indicate the role being reviewed
        """
        return pulumi.get(self, "role_definition_id")

    @property
    @pulumi.getter(name="excludeResourceId")
    def exclude_resource_id(self) -> Optional[str]:
        """
        This is used to indicate the resource id(s) to exclude
        """
        return pulumi.get(self, "exclude_resource_id")

    @property
    @pulumi.getter(name="excludeRoleDefinitionId")
    def exclude_role_definition_id(self) -> Optional[str]:
        """
        This is used to indicate the role definition id(s) to exclude
        """
        return pulumi.get(self, "exclude_role_definition_id")

    @property
    @pulumi.getter(name="expandNestedMemberships")
    def expand_nested_memberships(self) -> Optional[bool]:
        """
        Flag to indicate whether to expand nested memberships or not.
        """
        return pulumi.get(self, "expand_nested_memberships")

    @property
    @pulumi.getter(name="inactiveDuration")
    def inactive_duration(self) -> Optional[str]:
        """
        Duration users are inactive for. The value should be in ISO  8601 format (http://en.wikipedia.org/wiki/ISO_8601#Durations).This code can be used to convert TimeSpan to a valid interval string: XmlConvert.ToString(new TimeSpan(hours, minutes, seconds))
        """
        return pulumi.get(self, "inactive_duration")

    @property
    @pulumi.getter(name="includeAccessBelowResource")
    def include_access_below_resource(self) -> Optional[bool]:
        """
        Flag to indicate whether to expand nested memberships or not.
        """
        return pulumi.get(self, "include_access_below_resource")

    @property
    @pulumi.getter(name="includeInheritedAccess")
    def include_inherited_access(self) -> Optional[bool]:
        """
        Flag to indicate whether to expand nested memberships or not.
        """
        return pulumi.get(self, "include_inherited_access")


@pulumi.output_type
class ApprovalSettingsResponse(dict):
    """
    The approval settings.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "approvalMode":
            suggest = "approval_mode"
        elif key == "approvalStages":
            suggest = "approval_stages"
        elif key == "isApprovalRequired":
            suggest = "is_approval_required"
        elif key == "isApprovalRequiredForExtension":
            suggest = "is_approval_required_for_extension"
        elif key == "isRequestorJustificationRequired":
            suggest = "is_requestor_justification_required"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApprovalSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApprovalSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApprovalSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 approval_mode: Optional[str] = None,
                 approval_stages: Optional[Sequence['outputs.ApprovalStageResponse']] = None,
                 is_approval_required: Optional[bool] = None,
                 is_approval_required_for_extension: Optional[bool] = None,
                 is_requestor_justification_required: Optional[bool] = None):
        """
        The approval settings.
        :param str approval_mode: The type of rule
        :param Sequence['ApprovalStageResponse'] approval_stages: The approval stages of the request.
        :param bool is_approval_required: Determines whether approval is required or not.
        :param bool is_approval_required_for_extension: Determines whether approval is required for assignment extension.
        :param bool is_requestor_justification_required: Determine whether requestor justification is required.
        """
        if approval_mode is not None:
            pulumi.set(__self__, "approval_mode", approval_mode)
        if approval_stages is not None:
            pulumi.set(__self__, "approval_stages", approval_stages)
        if is_approval_required is not None:
            pulumi.set(__self__, "is_approval_required", is_approval_required)
        if is_approval_required_for_extension is not None:
            pulumi.set(__self__, "is_approval_required_for_extension", is_approval_required_for_extension)
        if is_requestor_justification_required is not None:
            pulumi.set(__self__, "is_requestor_justification_required", is_requestor_justification_required)

    @property
    @pulumi.getter(name="approvalMode")
    def approval_mode(self) -> Optional[str]:
        """
        The type of rule
        """
        return pulumi.get(self, "approval_mode")

    @property
    @pulumi.getter(name="approvalStages")
    def approval_stages(self) -> Optional[Sequence['outputs.ApprovalStageResponse']]:
        """
        The approval stages of the request.
        """
        return pulumi.get(self, "approval_stages")

    @property
    @pulumi.getter(name="isApprovalRequired")
    def is_approval_required(self) -> Optional[bool]:
        """
        Determines whether approval is required or not.
        """
        return pulumi.get(self, "is_approval_required")

    @property
    @pulumi.getter(name="isApprovalRequiredForExtension")
    def is_approval_required_for_extension(self) -> Optional[bool]:
        """
        Determines whether approval is required for assignment extension.
        """
        return pulumi.get(self, "is_approval_required_for_extension")

    @property
    @pulumi.getter(name="isRequestorJustificationRequired")
    def is_requestor_justification_required(self) -> Optional[bool]:
        """
        Determine whether requestor justification is required.
        """
        return pulumi.get(self, "is_requestor_justification_required")


@pulumi.output_type
class ApprovalStageResponse(dict):
    """
    The approval stage.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "approvalStageTimeOutInDays":
            suggest = "approval_stage_time_out_in_days"
        elif key == "escalationApprovers":
            suggest = "escalation_approvers"
        elif key == "escalationTimeInMinutes":
            suggest = "escalation_time_in_minutes"
        elif key == "isApproverJustificationRequired":
            suggest = "is_approver_justification_required"
        elif key == "isEscalationEnabled":
            suggest = "is_escalation_enabled"
        elif key == "primaryApprovers":
            suggest = "primary_approvers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApprovalStageResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApprovalStageResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApprovalStageResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 approval_stage_time_out_in_days: Optional[int] = None,
                 escalation_approvers: Optional[Sequence['outputs.UserSetResponse']] = None,
                 escalation_time_in_minutes: Optional[int] = None,
                 is_approver_justification_required: Optional[bool] = None,
                 is_escalation_enabled: Optional[bool] = None,
                 primary_approvers: Optional[Sequence['outputs.UserSetResponse']] = None):
        """
        The approval stage.
        :param int approval_stage_time_out_in_days: The time in days when approval request would be timed out
        :param Sequence['UserSetResponse'] escalation_approvers: The escalation approver of the request.
        :param int escalation_time_in_minutes: The time in minutes when the approval request would be escalated if the primary approver does not approve
        :param bool is_approver_justification_required: Determines whether approver need to provide justification for his decision.
        :param bool is_escalation_enabled: The value determine whether escalation feature is enabled.
        :param Sequence['UserSetResponse'] primary_approvers: The primary approver of the request.
        """
        if approval_stage_time_out_in_days is not None:
            pulumi.set(__self__, "approval_stage_time_out_in_days", approval_stage_time_out_in_days)
        if escalation_approvers is not None:
            pulumi.set(__self__, "escalation_approvers", escalation_approvers)
        if escalation_time_in_minutes is not None:
            pulumi.set(__self__, "escalation_time_in_minutes", escalation_time_in_minutes)
        if is_approver_justification_required is not None:
            pulumi.set(__self__, "is_approver_justification_required", is_approver_justification_required)
        if is_escalation_enabled is not None:
            pulumi.set(__self__, "is_escalation_enabled", is_escalation_enabled)
        if primary_approvers is not None:
            pulumi.set(__self__, "primary_approvers", primary_approvers)

    @property
    @pulumi.getter(name="approvalStageTimeOutInDays")
    def approval_stage_time_out_in_days(self) -> Optional[int]:
        """
        The time in days when approval request would be timed out
        """
        return pulumi.get(self, "approval_stage_time_out_in_days")

    @property
    @pulumi.getter(name="escalationApprovers")
    def escalation_approvers(self) -> Optional[Sequence['outputs.UserSetResponse']]:
        """
        The escalation approver of the request.
        """
        return pulumi.get(self, "escalation_approvers")

    @property
    @pulumi.getter(name="escalationTimeInMinutes")
    def escalation_time_in_minutes(self) -> Optional[int]:
        """
        The time in minutes when the approval request would be escalated if the primary approver does not approve
        """
        return pulumi.get(self, "escalation_time_in_minutes")

    @property
    @pulumi.getter(name="isApproverJustificationRequired")
    def is_approver_justification_required(self) -> Optional[bool]:
        """
        Determines whether approver need to provide justification for his decision.
        """
        return pulumi.get(self, "is_approver_justification_required")

    @property
    @pulumi.getter(name="isEscalationEnabled")
    def is_escalation_enabled(self) -> Optional[bool]:
        """
        The value determine whether escalation feature is enabled.
        """
        return pulumi.get(self, "is_escalation_enabled")

    @property
    @pulumi.getter(name="primaryApprovers")
    def primary_approvers(self) -> Optional[Sequence['outputs.UserSetResponse']]:
        """
        The primary approver of the request.
        """
        return pulumi.get(self, "primary_approvers")


@pulumi.output_type
class IdentityResponse(dict):
    """
    Identity for the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IdentityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IdentityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IdentityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 principal_id: str,
                 tenant_id: str,
                 type: Optional[str] = None):
        """
        Identity for the resource.
        :param str principal_id: The principal ID of the resource identity.
        :param str tenant_id: The tenant ID of the resource identity.
        :param str type: The identity type. This is the only required field when adding a system assigned identity to a resource.
        """
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> str:
        """
        The principal ID of the resource identity.
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> str:
        """
        The tenant ID of the resource identity.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The identity type. This is the only required field when adding a system assigned identity to a resource.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ManagementLockOwnerResponse(dict):
    """
    Lock owner properties.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "applicationId":
            suggest = "application_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagementLockOwnerResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagementLockOwnerResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagementLockOwnerResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 application_id: Optional[str] = None):
        """
        Lock owner properties.
        :param str application_id: The application ID of the lock owner.
        """
        if application_id is not None:
            pulumi.set(__self__, "application_id", application_id)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> Optional[str]:
        """
        The application ID of the lock owner.
        """
        return pulumi.get(self, "application_id")


@pulumi.output_type
class NonComplianceMessageResponse(dict):
    """
    A message that describes why a resource is non-compliant with the policy. This is shown in 'deny' error messages and on resource's non-compliant compliance results.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "policyDefinitionReferenceId":
            suggest = "policy_definition_reference_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NonComplianceMessageResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NonComplianceMessageResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NonComplianceMessageResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 message: str,
                 policy_definition_reference_id: Optional[str] = None):
        """
        A message that describes why a resource is non-compliant with the policy. This is shown in 'deny' error messages and on resource's non-compliant compliance results.
        :param str message: A message that describes why a resource is non-compliant with the policy. This is shown in 'deny' error messages and on resource's non-compliant compliance results.
        :param str policy_definition_reference_id: The policy definition reference ID within a policy set definition the message is intended for. This is only applicable if the policy assignment assigns a policy set definition. If this is not provided the message applies to all policies assigned by this policy assignment.
        """
        pulumi.set(__self__, "message", message)
        if policy_definition_reference_id is not None:
            pulumi.set(__self__, "policy_definition_reference_id", policy_definition_reference_id)

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        A message that describes why a resource is non-compliant with the policy. This is shown in 'deny' error messages and on resource's non-compliant compliance results.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter(name="policyDefinitionReferenceId")
    def policy_definition_reference_id(self) -> Optional[str]:
        """
        The policy definition reference ID within a policy set definition the message is intended for. This is only applicable if the policy assignment assigns a policy set definition. If this is not provided the message applies to all policies assigned by this policy assignment.
        """
        return pulumi.get(self, "policy_definition_reference_id")


@pulumi.output_type
class ParameterDefinitionsValueResponse(dict):
    """
    The definition of a parameter that can be provided to the policy.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedValues":
            suggest = "allowed_values"
        elif key == "defaultValue":
            suggest = "default_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ParameterDefinitionsValueResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ParameterDefinitionsValueResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ParameterDefinitionsValueResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_values: Optional[Sequence[Any]] = None,
                 default_value: Optional[Any] = None,
                 metadata: Optional['outputs.ParameterDefinitionsValueResponseMetadata'] = None,
                 type: Optional[str] = None):
        """
        The definition of a parameter that can be provided to the policy.
        :param Sequence[Any] allowed_values: The allowed values for the parameter.
        :param Any default_value: The default value for the parameter if no value is provided.
        :param 'ParameterDefinitionsValueResponseMetadata' metadata: General metadata for the parameter.
        :param str type: The data type of the parameter.
        """
        if allowed_values is not None:
            pulumi.set(__self__, "allowed_values", allowed_values)
        if default_value is not None:
            pulumi.set(__self__, "default_value", default_value)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="allowedValues")
    def allowed_values(self) -> Optional[Sequence[Any]]:
        """
        The allowed values for the parameter.
        """
        return pulumi.get(self, "allowed_values")

    @property
    @pulumi.getter(name="defaultValue")
    def default_value(self) -> Optional[Any]:
        """
        The default value for the parameter if no value is provided.
        """
        return pulumi.get(self, "default_value")

    @property
    @pulumi.getter
    def metadata(self) -> Optional['outputs.ParameterDefinitionsValueResponseMetadata']:
        """
        General metadata for the parameter.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The data type of the parameter.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ParameterDefinitionsValueResponseMetadata(dict):
    """
    General metadata for the parameter.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "assignPermissions":
            suggest = "assign_permissions"
        elif key == "displayName":
            suggest = "display_name"
        elif key == "strongType":
            suggest = "strong_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ParameterDefinitionsValueResponseMetadata. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ParameterDefinitionsValueResponseMetadata.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ParameterDefinitionsValueResponseMetadata.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 assign_permissions: Optional[bool] = None,
                 description: Optional[str] = None,
                 display_name: Optional[str] = None,
                 strong_type: Optional[str] = None):
        """
        General metadata for the parameter.
        :param bool assign_permissions: Set to true to have Azure portal create role assignments on the resource ID or resource scope value of this parameter during policy assignment. This property is useful in case you wish to assign permissions outside the assignment scope.
        :param str description: The description of the parameter.
        :param str display_name: The display name for the parameter.
        :param str strong_type: Used when assigning the policy definition through the portal. Provides a context aware list of values for the user to choose from.
        """
        if assign_permissions is not None:
            pulumi.set(__self__, "assign_permissions", assign_permissions)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if strong_type is not None:
            pulumi.set(__self__, "strong_type", strong_type)

    @property
    @pulumi.getter(name="assignPermissions")
    def assign_permissions(self) -> Optional[bool]:
        """
        Set to true to have Azure portal create role assignments on the resource ID or resource scope value of this parameter during policy assignment. This property is useful in case you wish to assign permissions outside the assignment scope.
        """
        return pulumi.get(self, "assign_permissions")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The description of the parameter.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        The display name for the parameter.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="strongType")
    def strong_type(self) -> Optional[str]:
        """
        Used when assigning the policy definition through the portal. Provides a context aware list of values for the user to choose from.
        """
        return pulumi.get(self, "strong_type")


@pulumi.output_type
class ParameterValuesValueResponse(dict):
    """
    The value of a parameter.
    """
    def __init__(__self__, *,
                 value: Optional[Any] = None):
        """
        The value of a parameter.
        :param Any value: The value of the parameter.
        """
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[Any]:
        """
        The value of the parameter.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class PermissionResponse(dict):
    """
    Role definition permissions.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataActions":
            suggest = "data_actions"
        elif key == "notActions":
            suggest = "not_actions"
        elif key == "notDataActions":
            suggest = "not_data_actions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PermissionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PermissionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PermissionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 actions: Optional[Sequence[str]] = None,
                 data_actions: Optional[Sequence[str]] = None,
                 not_actions: Optional[Sequence[str]] = None,
                 not_data_actions: Optional[Sequence[str]] = None):
        """
        Role definition permissions.
        :param Sequence[str] actions: Allowed actions.
        :param Sequence[str] data_actions: Allowed Data actions.
        :param Sequence[str] not_actions: Denied actions.
        :param Sequence[str] not_data_actions: Denied Data actions.
        """
        if actions is not None:
            pulumi.set(__self__, "actions", actions)
        if data_actions is not None:
            pulumi.set(__self__, "data_actions", data_actions)
        if not_actions is not None:
            pulumi.set(__self__, "not_actions", not_actions)
        if not_data_actions is not None:
            pulumi.set(__self__, "not_data_actions", not_data_actions)

    @property
    @pulumi.getter
    def actions(self) -> Optional[Sequence[str]]:
        """
        Allowed actions.
        """
        return pulumi.get(self, "actions")

    @property
    @pulumi.getter(name="dataActions")
    def data_actions(self) -> Optional[Sequence[str]]:
        """
        Allowed Data actions.
        """
        return pulumi.get(self, "data_actions")

    @property
    @pulumi.getter(name="notActions")
    def not_actions(self) -> Optional[Sequence[str]]:
        """
        Denied actions.
        """
        return pulumi.get(self, "not_actions")

    @property
    @pulumi.getter(name="notDataActions")
    def not_data_actions(self) -> Optional[Sequence[str]]:
        """
        Denied Data actions.
        """
        return pulumi.get(self, "not_data_actions")


@pulumi.output_type
class PolicyAssignmentPropertiesResponse(dict):
    """
    Expanded info of resource scope, role definition and policy
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "roleDefinition":
            suggest = "role_definition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PolicyAssignmentPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PolicyAssignmentPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PolicyAssignmentPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 policy: Optional['outputs.PolicyAssignmentPropertiesResponsePolicy'] = None,
                 role_definition: Optional['outputs.PolicyAssignmentPropertiesResponseRoleDefinition'] = None,
                 scope: Optional['outputs.PolicyAssignmentPropertiesResponseScope'] = None):
        """
        Expanded info of resource scope, role definition and policy
        :param 'PolicyAssignmentPropertiesResponsePolicy' policy: Details of the policy
        :param 'PolicyAssignmentPropertiesResponseRoleDefinition' role_definition: Details of role definition
        :param 'PolicyAssignmentPropertiesResponseScope' scope: Details of the resource scope
        """
        if policy is not None:
            pulumi.set(__self__, "policy", policy)
        if role_definition is not None:
            pulumi.set(__self__, "role_definition", role_definition)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)

    @property
    @pulumi.getter
    def policy(self) -> Optional['outputs.PolicyAssignmentPropertiesResponsePolicy']:
        """
        Details of the policy
        """
        return pulumi.get(self, "policy")

    @property
    @pulumi.getter(name="roleDefinition")
    def role_definition(self) -> Optional['outputs.PolicyAssignmentPropertiesResponseRoleDefinition']:
        """
        Details of role definition
        """
        return pulumi.get(self, "role_definition")

    @property
    @pulumi.getter
    def scope(self) -> Optional['outputs.PolicyAssignmentPropertiesResponseScope']:
        """
        Details of the resource scope
        """
        return pulumi.get(self, "scope")


@pulumi.output_type
class PolicyAssignmentPropertiesResponsePolicy(dict):
    """
    Details of the policy
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lastModifiedBy":
            suggest = "last_modified_by"
        elif key == "lastModifiedDateTime":
            suggest = "last_modified_date_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PolicyAssignmentPropertiesResponsePolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PolicyAssignmentPropertiesResponsePolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PolicyAssignmentPropertiesResponsePolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 last_modified_by: 'outputs.PrincipalResponse',
                 id: Optional[str] = None,
                 last_modified_date_time: Optional[str] = None):
        """
        Details of the policy
        :param 'PrincipalResponse' last_modified_by: The name of the entity last modified it
        :param str id: Id of the policy
        :param str last_modified_date_time: The last modified date time.
        """
        pulumi.set(__self__, "last_modified_by", last_modified_by)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if last_modified_date_time is not None:
            pulumi.set(__self__, "last_modified_date_time", last_modified_date_time)

    @property
    @pulumi.getter(name="lastModifiedBy")
    def last_modified_by(self) -> 'outputs.PrincipalResponse':
        """
        The name of the entity last modified it
        """
        return pulumi.get(self, "last_modified_by")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Id of the policy
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lastModifiedDateTime")
    def last_modified_date_time(self) -> Optional[str]:
        """
        The last modified date time.
        """
        return pulumi.get(self, "last_modified_date_time")


@pulumi.output_type
class PolicyAssignmentPropertiesResponseRoleDefinition(dict):
    """
    Details of role definition
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "displayName":
            suggest = "display_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PolicyAssignmentPropertiesResponseRoleDefinition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PolicyAssignmentPropertiesResponseRoleDefinition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PolicyAssignmentPropertiesResponseRoleDefinition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 display_name: Optional[str] = None,
                 id: Optional[str] = None,
                 type: Optional[str] = None):
        """
        Details of role definition
        :param str display_name: Display name of the role definition
        :param str id: Id of the role definition
        :param str type: Type of the role definition
        """
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        Display name of the role definition
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Id of the role definition
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Type of the role definition
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class PolicyAssignmentPropertiesResponseScope(dict):
    """
    Details of the resource scope
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "displayName":
            suggest = "display_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PolicyAssignmentPropertiesResponseScope. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PolicyAssignmentPropertiesResponseScope.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PolicyAssignmentPropertiesResponseScope.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 display_name: Optional[str] = None,
                 id: Optional[str] = None,
                 type: Optional[str] = None):
        """
        Details of the resource scope
        :param str display_name: Display name of the resource
        :param str id: Scope id of the resource
        :param str type: Type of the resource
        """
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        Display name of the resource
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Scope id of the resource
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Type of the resource
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class PolicyDefinitionGroupResponse(dict):
    """
    The policy definition group.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "additionalMetadataId":
            suggest = "additional_metadata_id"
        elif key == "displayName":
            suggest = "display_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PolicyDefinitionGroupResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PolicyDefinitionGroupResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PolicyDefinitionGroupResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 additional_metadata_id: Optional[str] = None,
                 category: Optional[str] = None,
                 description: Optional[str] = None,
                 display_name: Optional[str] = None):
        """
        The policy definition group.
        :param str name: The name of the group.
        :param str additional_metadata_id: A resource ID of a resource that contains additional metadata about the group.
        :param str category: The group's category.
        :param str description: The group's description.
        :param str display_name: The group's display name.
        """
        pulumi.set(__self__, "name", name)
        if additional_metadata_id is not None:
            pulumi.set(__self__, "additional_metadata_id", additional_metadata_id)
        if category is not None:
            pulumi.set(__self__, "category", category)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the group.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="additionalMetadataId")
    def additional_metadata_id(self) -> Optional[str]:
        """
        A resource ID of a resource that contains additional metadata about the group.
        """
        return pulumi.get(self, "additional_metadata_id")

    @property
    @pulumi.getter
    def category(self) -> Optional[str]:
        """
        The group's category.
        """
        return pulumi.get(self, "category")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The group's description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        The group's display name.
        """
        return pulumi.get(self, "display_name")


@pulumi.output_type
class PolicyDefinitionReferenceResponse(dict):
    """
    The policy definition reference.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "policyDefinitionId":
            suggest = "policy_definition_id"
        elif key == "groupNames":
            suggest = "group_names"
        elif key == "policyDefinitionReferenceId":
            suggest = "policy_definition_reference_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PolicyDefinitionReferenceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PolicyDefinitionReferenceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PolicyDefinitionReferenceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 policy_definition_id: str,
                 group_names: Optional[Sequence[str]] = None,
                 parameters: Optional[Mapping[str, 'outputs.ParameterValuesValueResponse']] = None,
                 policy_definition_reference_id: Optional[str] = None):
        """
        The policy definition reference.
        :param str policy_definition_id: The ID of the policy definition or policy set definition.
        :param Sequence[str] group_names: The name of the groups that this policy definition reference belongs to.
        :param Mapping[str, 'ParameterValuesValueResponse'] parameters: The parameter values for the referenced policy rule. The keys are the parameter names.
        :param str policy_definition_reference_id: A unique id (within the policy set definition) for this policy definition reference.
        """
        pulumi.set(__self__, "policy_definition_id", policy_definition_id)
        if group_names is not None:
            pulumi.set(__self__, "group_names", group_names)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if policy_definition_reference_id is not None:
            pulumi.set(__self__, "policy_definition_reference_id", policy_definition_reference_id)

    @property
    @pulumi.getter(name="policyDefinitionId")
    def policy_definition_id(self) -> str:
        """
        The ID of the policy definition or policy set definition.
        """
        return pulumi.get(self, "policy_definition_id")

    @property
    @pulumi.getter(name="groupNames")
    def group_names(self) -> Optional[Sequence[str]]:
        """
        The name of the groups that this policy definition reference belongs to.
        """
        return pulumi.get(self, "group_names")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, 'outputs.ParameterValuesValueResponse']]:
        """
        The parameter values for the referenced policy rule. The keys are the parameter names.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter(name="policyDefinitionReferenceId")
    def policy_definition_reference_id(self) -> Optional[str]:
        """
        A unique id (within the policy set definition) for this policy definition reference.
        """
        return pulumi.get(self, "policy_definition_reference_id")


@pulumi.output_type
class PrincipalResponse(dict):
    """
    The name of the entity last modified it
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "displayName":
            suggest = "display_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrincipalResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrincipalResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrincipalResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 display_name: Optional[str] = None,
                 email: Optional[str] = None,
                 id: Optional[str] = None,
                 type: Optional[str] = None):
        """
        The name of the entity last modified it
        :param str display_name: The name of the principal made changes
        :param str email: Email of principal
        :param str id: The id of the principal made changes
        :param str type: Type of principal such as user , group etc
        """
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        The name of the principal made changes
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def email(self) -> Optional[str]:
        """
        Email of principal
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The id of the principal made changes
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Type of principal such as user , group etc
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class PrivateLinkAssociationPropertiesExpandedResponse(dict):
    """
    Private Link Association Properties.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "privateLink":
            suggest = "private_link"
        elif key == "publicNetworkAccess":
            suggest = "public_network_access"
        elif key == "tenantID":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrivateLinkAssociationPropertiesExpandedResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrivateLinkAssociationPropertiesExpandedResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrivateLinkAssociationPropertiesExpandedResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 private_link: Optional[str] = None,
                 public_network_access: Optional[str] = None,
                 scope: Optional[str] = None,
                 tenant_id: Optional[str] = None):
        """
        Private Link Association Properties.
        :param str private_link: The rmpl Resource ID.
        :param str scope: The scope of the private link association.
        :param str tenant_id: The TenantID.
        """
        if private_link is not None:
            pulumi.set(__self__, "private_link", private_link)
        if public_network_access is not None:
            pulumi.set(__self__, "public_network_access", public_network_access)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter(name="privateLink")
    def private_link(self) -> Optional[str]:
        """
        The rmpl Resource ID.
        """
        return pulumi.get(self, "private_link")

    @property
    @pulumi.getter(name="publicNetworkAccess")
    def public_network_access(self) -> Optional[str]:
        return pulumi.get(self, "public_network_access")

    @property
    @pulumi.getter
    def scope(self) -> Optional[str]:
        """
        The scope of the private link association.
        """
        return pulumi.get(self, "scope")

    @property
    @pulumi.getter(name="tenantID")
    def tenant_id(self) -> Optional[str]:
        """
        The TenantID.
        """
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class ResourceManagementPrivateLinkEndpointConnectionsResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "privateEndpointConnections":
            suggest = "private_endpoint_connections"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceManagementPrivateLinkEndpointConnectionsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceManagementPrivateLinkEndpointConnectionsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceManagementPrivateLinkEndpointConnectionsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 private_endpoint_connections: Optional[Sequence[str]] = None):
        """
        :param Sequence[str] private_endpoint_connections: The private endpoint connections.
        """
        if private_endpoint_connections is not None:
            pulumi.set(__self__, "private_endpoint_connections", private_endpoint_connections)

    @property
    @pulumi.getter(name="privateEndpointConnections")
    def private_endpoint_connections(self) -> Optional[Sequence[str]]:
        """
        The private endpoint connections.
        """
        return pulumi.get(self, "private_endpoint_connections")


@pulumi.output_type
class RoleManagementPolicyApprovalRuleResponse(dict):
    """
    The role management policy approval rule.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ruleType":
            suggest = "rule_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RoleManagementPolicyApprovalRuleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RoleManagementPolicyApprovalRuleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RoleManagementPolicyApprovalRuleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 rule_type: str,
                 id: Optional[str] = None,
                 setting: Optional['outputs.ApprovalSettingsResponse'] = None,
                 target: Optional['outputs.RoleManagementPolicyRuleTargetResponse'] = None):
        """
        The role management policy approval rule.
        :param str rule_type: The type of rule
               Expected value is 'RoleManagementPolicyApprovalRule'.
        :param str id: The id of the rule.
        :param 'ApprovalSettingsResponse' setting: The approval setting
        :param 'RoleManagementPolicyRuleTargetResponse' target: The target of the current rule.
        """
        pulumi.set(__self__, "rule_type", 'RoleManagementPolicyApprovalRule')
        if id is not None:
            pulumi.set(__self__, "id", id)
        if setting is not None:
            pulumi.set(__self__, "setting", setting)
        if target is not None:
            pulumi.set(__self__, "target", target)

    @property
    @pulumi.getter(name="ruleType")
    def rule_type(self) -> str:
        """
        The type of rule
        Expected value is 'RoleManagementPolicyApprovalRule'.
        """
        return pulumi.get(self, "rule_type")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The id of the rule.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def setting(self) -> Optional['outputs.ApprovalSettingsResponse']:
        """
        The approval setting
        """
        return pulumi.get(self, "setting")

    @property
    @pulumi.getter
    def target(self) -> Optional['outputs.RoleManagementPolicyRuleTargetResponse']:
        """
        The target of the current rule.
        """
        return pulumi.get(self, "target")


@pulumi.output_type
class RoleManagementPolicyAuthenticationContextRuleResponse(dict):
    """
    The role management policy authentication context rule.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ruleType":
            suggest = "rule_type"
        elif key == "claimValue":
            suggest = "claim_value"
        elif key == "isEnabled":
            suggest = "is_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RoleManagementPolicyAuthenticationContextRuleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RoleManagementPolicyAuthenticationContextRuleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RoleManagementPolicyAuthenticationContextRuleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 rule_type: str,
                 claim_value: Optional[str] = None,
                 id: Optional[str] = None,
                 is_enabled: Optional[bool] = None,
                 target: Optional['outputs.RoleManagementPolicyRuleTargetResponse'] = None):
        """
        The role management policy authentication context rule.
        :param str rule_type: The type of rule
               Expected value is 'RoleManagementPolicyAuthenticationContextRule'.
        :param str claim_value: The claim value.
        :param str id: The id of the rule.
        :param bool is_enabled: The value indicating if rule is enabled.
        :param 'RoleManagementPolicyRuleTargetResponse' target: The target of the current rule.
        """
        pulumi.set(__self__, "rule_type", 'RoleManagementPolicyAuthenticationContextRule')
        if claim_value is not None:
            pulumi.set(__self__, "claim_value", claim_value)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if is_enabled is not None:
            pulumi.set(__self__, "is_enabled", is_enabled)
        if target is not None:
            pulumi.set(__self__, "target", target)

    @property
    @pulumi.getter(name="ruleType")
    def rule_type(self) -> str:
        """
        The type of rule
        Expected value is 'RoleManagementPolicyAuthenticationContextRule'.
        """
        return pulumi.get(self, "rule_type")

    @property
    @pulumi.getter(name="claimValue")
    def claim_value(self) -> Optional[str]:
        """
        The claim value.
        """
        return pulumi.get(self, "claim_value")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The id of the rule.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[bool]:
        """
        The value indicating if rule is enabled.
        """
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter
    def target(self) -> Optional['outputs.RoleManagementPolicyRuleTargetResponse']:
        """
        The target of the current rule.
        """
        return pulumi.get(self, "target")


@pulumi.output_type
class RoleManagementPolicyEnablementRuleResponse(dict):
    """
    The role management policy enablement rule.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ruleType":
            suggest = "rule_type"
        elif key == "enabledRules":
            suggest = "enabled_rules"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RoleManagementPolicyEnablementRuleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RoleManagementPolicyEnablementRuleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RoleManagementPolicyEnablementRuleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 rule_type: str,
                 enabled_rules: Optional[Sequence[str]] = None,
                 id: Optional[str] = None,
                 target: Optional['outputs.RoleManagementPolicyRuleTargetResponse'] = None):
        """
        The role management policy enablement rule.
        :param str rule_type: The type of rule
               Expected value is 'RoleManagementPolicyEnablementRule'.
        :param Sequence[str] enabled_rules: The list of enabled rules.
        :param str id: The id of the rule.
        :param 'RoleManagementPolicyRuleTargetResponse' target: The target of the current rule.
        """
        pulumi.set(__self__, "rule_type", 'RoleManagementPolicyEnablementRule')
        if enabled_rules is not None:
            pulumi.set(__self__, "enabled_rules", enabled_rules)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if target is not None:
            pulumi.set(__self__, "target", target)

    @property
    @pulumi.getter(name="ruleType")
    def rule_type(self) -> str:
        """
        The type of rule
        Expected value is 'RoleManagementPolicyEnablementRule'.
        """
        return pulumi.get(self, "rule_type")

    @property
    @pulumi.getter(name="enabledRules")
    def enabled_rules(self) -> Optional[Sequence[str]]:
        """
        The list of enabled rules.
        """
        return pulumi.get(self, "enabled_rules")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The id of the rule.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def target(self) -> Optional['outputs.RoleManagementPolicyRuleTargetResponse']:
        """
        The target of the current rule.
        """
        return pulumi.get(self, "target")


@pulumi.output_type
class RoleManagementPolicyExpirationRuleResponse(dict):
    """
    The role management policy expiration rule.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ruleType":
            suggest = "rule_type"
        elif key == "isExpirationRequired":
            suggest = "is_expiration_required"
        elif key == "maximumDuration":
            suggest = "maximum_duration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RoleManagementPolicyExpirationRuleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RoleManagementPolicyExpirationRuleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RoleManagementPolicyExpirationRuleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 rule_type: str,
                 id: Optional[str] = None,
                 is_expiration_required: Optional[bool] = None,
                 maximum_duration: Optional[str] = None,
                 target: Optional['outputs.RoleManagementPolicyRuleTargetResponse'] = None):
        """
        The role management policy expiration rule.
        :param str rule_type: The type of rule
               Expected value is 'RoleManagementPolicyExpirationRule'.
        :param str id: The id of the rule.
        :param bool is_expiration_required: The value indicating whether expiration is required.
        :param str maximum_duration: The maximum duration of expiration in timespan.
        :param 'RoleManagementPolicyRuleTargetResponse' target: The target of the current rule.
        """
        pulumi.set(__self__, "rule_type", 'RoleManagementPolicyExpirationRule')
        if id is not None:
            pulumi.set(__self__, "id", id)
        if is_expiration_required is not None:
            pulumi.set(__self__, "is_expiration_required", is_expiration_required)
        if maximum_duration is not None:
            pulumi.set(__self__, "maximum_duration", maximum_duration)
        if target is not None:
            pulumi.set(__self__, "target", target)

    @property
    @pulumi.getter(name="ruleType")
    def rule_type(self) -> str:
        """
        The type of rule
        Expected value is 'RoleManagementPolicyExpirationRule'.
        """
        return pulumi.get(self, "rule_type")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The id of the rule.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isExpirationRequired")
    def is_expiration_required(self) -> Optional[bool]:
        """
        The value indicating whether expiration is required.
        """
        return pulumi.get(self, "is_expiration_required")

    @property
    @pulumi.getter(name="maximumDuration")
    def maximum_duration(self) -> Optional[str]:
        """
        The maximum duration of expiration in timespan.
        """
        return pulumi.get(self, "maximum_duration")

    @property
    @pulumi.getter
    def target(self) -> Optional['outputs.RoleManagementPolicyRuleTargetResponse']:
        """
        The target of the current rule.
        """
        return pulumi.get(self, "target")


@pulumi.output_type
class RoleManagementPolicyNotificationRuleResponse(dict):
    """
    The role management policy notification rule.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ruleType":
            suggest = "rule_type"
        elif key == "isDefaultRecipientsEnabled":
            suggest = "is_default_recipients_enabled"
        elif key == "notificationLevel":
            suggest = "notification_level"
        elif key == "notificationRecipients":
            suggest = "notification_recipients"
        elif key == "notificationType":
            suggest = "notification_type"
        elif key == "recipientType":
            suggest = "recipient_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RoleManagementPolicyNotificationRuleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RoleManagementPolicyNotificationRuleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RoleManagementPolicyNotificationRuleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 rule_type: str,
                 id: Optional[str] = None,
                 is_default_recipients_enabled: Optional[bool] = None,
                 notification_level: Optional[str] = None,
                 notification_recipients: Optional[Sequence[str]] = None,
                 notification_type: Optional[str] = None,
                 recipient_type: Optional[str] = None,
                 target: Optional['outputs.RoleManagementPolicyRuleTargetResponse'] = None):
        """
        The role management policy notification rule.
        :param str rule_type: The type of rule
               Expected value is 'RoleManagementPolicyNotificationRule'.
        :param str id: The id of the rule.
        :param bool is_default_recipients_enabled: Determines if the notification will be sent to the recipient type specified in the policy rule.
        :param str notification_level: The notification level.
        :param Sequence[str] notification_recipients: The list of notification recipients.
        :param str notification_type: The type of notification.
        :param str recipient_type: The recipient type.
        :param 'RoleManagementPolicyRuleTargetResponse' target: The target of the current rule.
        """
        pulumi.set(__self__, "rule_type", 'RoleManagementPolicyNotificationRule')
        if id is not None:
            pulumi.set(__self__, "id", id)
        if is_default_recipients_enabled is not None:
            pulumi.set(__self__, "is_default_recipients_enabled", is_default_recipients_enabled)
        if notification_level is not None:
            pulumi.set(__self__, "notification_level", notification_level)
        if notification_recipients is not None:
            pulumi.set(__self__, "notification_recipients", notification_recipients)
        if notification_type is not None:
            pulumi.set(__self__, "notification_type", notification_type)
        if recipient_type is not None:
            pulumi.set(__self__, "recipient_type", recipient_type)
        if target is not None:
            pulumi.set(__self__, "target", target)

    @property
    @pulumi.getter(name="ruleType")
    def rule_type(self) -> str:
        """
        The type of rule
        Expected value is 'RoleManagementPolicyNotificationRule'.
        """
        return pulumi.get(self, "rule_type")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The id of the rule.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isDefaultRecipientsEnabled")
    def is_default_recipients_enabled(self) -> Optional[bool]:
        """
        Determines if the notification will be sent to the recipient type specified in the policy rule.
        """
        return pulumi.get(self, "is_default_recipients_enabled")

    @property
    @pulumi.getter(name="notificationLevel")
    def notification_level(self) -> Optional[str]:
        """
        The notification level.
        """
        return pulumi.get(self, "notification_level")

    @property
    @pulumi.getter(name="notificationRecipients")
    def notification_recipients(self) -> Optional[Sequence[str]]:
        """
        The list of notification recipients.
        """
        return pulumi.get(self, "notification_recipients")

    @property
    @pulumi.getter(name="notificationType")
    def notification_type(self) -> Optional[str]:
        """
        The type of notification.
        """
        return pulumi.get(self, "notification_type")

    @property
    @pulumi.getter(name="recipientType")
    def recipient_type(self) -> Optional[str]:
        """
        The recipient type.
        """
        return pulumi.get(self, "recipient_type")

    @property
    @pulumi.getter
    def target(self) -> Optional['outputs.RoleManagementPolicyRuleTargetResponse']:
        """
        The target of the current rule.
        """
        return pulumi.get(self, "target")


@pulumi.output_type
class RoleManagementPolicyRuleTargetResponse(dict):
    """
    The role management policy rule target.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enforcedSettings":
            suggest = "enforced_settings"
        elif key == "inheritableSettings":
            suggest = "inheritable_settings"
        elif key == "targetObjects":
            suggest = "target_objects"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RoleManagementPolicyRuleTargetResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RoleManagementPolicyRuleTargetResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RoleManagementPolicyRuleTargetResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 caller: Optional[str] = None,
                 enforced_settings: Optional[Sequence[str]] = None,
                 inheritable_settings: Optional[Sequence[str]] = None,
                 level: Optional[str] = None,
                 operations: Optional[Sequence[str]] = None,
                 target_objects: Optional[Sequence[str]] = None):
        """
        The role management policy rule target.
        :param str caller: The caller of the setting.
        :param Sequence[str] enforced_settings: The list of enforced settings.
        :param Sequence[str] inheritable_settings: The list of inheritable settings.
        :param str level: The assignment level to which rule is applied.
        :param Sequence[str] operations: The type of operation.
        :param Sequence[str] target_objects: The list of target objects.
        """
        if caller is not None:
            pulumi.set(__self__, "caller", caller)
        if enforced_settings is not None:
            pulumi.set(__self__, "enforced_settings", enforced_settings)
        if inheritable_settings is not None:
            pulumi.set(__self__, "inheritable_settings", inheritable_settings)
        if level is not None:
            pulumi.set(__self__, "level", level)
        if operations is not None:
            pulumi.set(__self__, "operations", operations)
        if target_objects is not None:
            pulumi.set(__self__, "target_objects", target_objects)

    @property
    @pulumi.getter
    def caller(self) -> Optional[str]:
        """
        The caller of the setting.
        """
        return pulumi.get(self, "caller")

    @property
    @pulumi.getter(name="enforcedSettings")
    def enforced_settings(self) -> Optional[Sequence[str]]:
        """
        The list of enforced settings.
        """
        return pulumi.get(self, "enforced_settings")

    @property
    @pulumi.getter(name="inheritableSettings")
    def inheritable_settings(self) -> Optional[Sequence[str]]:
        """
        The list of inheritable settings.
        """
        return pulumi.get(self, "inheritable_settings")

    @property
    @pulumi.getter
    def level(self) -> Optional[str]:
        """
        The assignment level to which rule is applied.
        """
        return pulumi.get(self, "level")

    @property
    @pulumi.getter
    def operations(self) -> Optional[Sequence[str]]:
        """
        The type of operation.
        """
        return pulumi.get(self, "operations")

    @property
    @pulumi.getter(name="targetObjects")
    def target_objects(self) -> Optional[Sequence[str]]:
        """
        The list of target objects.
        """
        return pulumi.get(self, "target_objects")


@pulumi.output_type
class SystemDataResponse(dict):
    """
    Metadata pertaining to creation and last modification of the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdAt":
            suggest = "created_at"
        elif key == "createdBy":
            suggest = "created_by"
        elif key == "createdByType":
            suggest = "created_by_type"
        elif key == "lastModifiedAt":
            suggest = "last_modified_at"
        elif key == "lastModifiedBy":
            suggest = "last_modified_by"
        elif key == "lastModifiedByType":
            suggest = "last_modified_by_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SystemDataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_at: Optional[str] = None,
                 created_by: Optional[str] = None,
                 created_by_type: Optional[str] = None,
                 last_modified_at: Optional[str] = None,
                 last_modified_by: Optional[str] = None,
                 last_modified_by_type: Optional[str] = None):
        """
        Metadata pertaining to creation and last modification of the resource.
        :param str created_at: The timestamp of resource creation (UTC).
        :param str created_by: The identity that created the resource.
        :param str created_by_type: The type of identity that created the resource.
        :param str last_modified_at: The timestamp of resource last modification (UTC)
        :param str last_modified_by: The identity that last modified the resource.
        :param str last_modified_by_type: The type of identity that last modified the resource.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if created_by_type is not None:
            pulumi.set(__self__, "created_by_type", created_by_type)
        if last_modified_at is not None:
            pulumi.set(__self__, "last_modified_at", last_modified_at)
        if last_modified_by is not None:
            pulumi.set(__self__, "last_modified_by", last_modified_by)
        if last_modified_by_type is not None:
            pulumi.set(__self__, "last_modified_by_type", last_modified_by_type)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[str]:
        """
        The timestamp of resource creation (UTC).
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[str]:
        """
        The identity that created the resource.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="createdByType")
    def created_by_type(self) -> Optional[str]:
        """
        The type of identity that created the resource.
        """
        return pulumi.get(self, "created_by_type")

    @property
    @pulumi.getter(name="lastModifiedAt")
    def last_modified_at(self) -> Optional[str]:
        """
        The timestamp of resource last modification (UTC)
        """
        return pulumi.get(self, "last_modified_at")

    @property
    @pulumi.getter(name="lastModifiedBy")
    def last_modified_by(self) -> Optional[str]:
        """
        The identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by")

    @property
    @pulumi.getter(name="lastModifiedByType")
    def last_modified_by_type(self) -> Optional[str]:
        """
        The type of identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by_type")


@pulumi.output_type
class UserSetResponse(dict):
    """
    The detail of a user.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isBackup":
            suggest = "is_backup"
        elif key == "userType":
            suggest = "user_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserSetResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserSetResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserSetResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 description: Optional[str] = None,
                 id: Optional[str] = None,
                 is_backup: Optional[bool] = None,
                 user_type: Optional[str] = None):
        """
        The detail of a user.
        :param str description: The description of the user.
        :param str id: The object id of the user.
        :param bool is_backup: The value indicating whether the user is a backup fallback approver
        :param str user_type: The type of user.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if is_backup is not None:
            pulumi.set(__self__, "is_backup", is_backup)
        if user_type is not None:
            pulumi.set(__self__, "user_type", user_type)

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The description of the user.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The object id of the user.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isBackup")
    def is_backup(self) -> Optional[bool]:
        """
        The value indicating whether the user is a backup fallback approver
        """
        return pulumi.get(self, "is_backup")

    @property
    @pulumi.getter(name="userType")
    def user_type(self) -> Optional[str]:
        """
        The type of user.
        """
        return pulumi.get(self, "user_type")


