# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'SecretAuthInfoArgs',
    'SecretStoreArgs',
    'ServicePrincipalCertificateAuthInfoArgs',
    'ServicePrincipalSecretAuthInfoArgs',
    'SystemAssignedIdentityAuthInfoArgs',
    'UserAssignedIdentityAuthInfoArgs',
    'VNetSolutionArgs',
]

@pulumi.input_type
class SecretAuthInfoArgs:
    def __init__(__self__, *,
                 auth_type: pulumi.Input[str],
                 name: Optional[pulumi.Input[str]] = None,
                 secret: Optional[pulumi.Input[str]] = None):
        """
        The authentication info when authType is secret
        :param pulumi.Input[str] auth_type: The authentication type.
               Expected value is 'secret'.
        :param pulumi.Input[str] name: Username or account name for secret auth.
        :param pulumi.Input[str] secret: Password or account key for secret auth.
        """
        pulumi.set(__self__, "auth_type", 'secret')
        if name is not None:
            pulumi.set(__self__, "name", name)
        if secret is not None:
            pulumi.set(__self__, "secret", secret)

    @property
    @pulumi.getter(name="authType")
    def auth_type(self) -> pulumi.Input[str]:
        """
        The authentication type.
        Expected value is 'secret'.
        """
        return pulumi.get(self, "auth_type")

    @auth_type.setter
    def auth_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "auth_type", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Username or account name for secret auth.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def secret(self) -> Optional[pulumi.Input[str]]:
        """
        Password or account key for secret auth.
        """
        return pulumi.get(self, "secret")

    @secret.setter
    def secret(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secret", value)


@pulumi.input_type
class SecretStoreArgs:
    def __init__(__self__, *,
                 key_vault_id: Optional[pulumi.Input[str]] = None):
        """
        An option to store secret value in secure place
        :param pulumi.Input[str] key_vault_id: The key vault id to store secret
        """
        if key_vault_id is not None:
            pulumi.set(__self__, "key_vault_id", key_vault_id)

    @property
    @pulumi.getter(name="keyVaultId")
    def key_vault_id(self) -> Optional[pulumi.Input[str]]:
        """
        The key vault id to store secret
        """
        return pulumi.get(self, "key_vault_id")

    @key_vault_id.setter
    def key_vault_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_vault_id", value)


@pulumi.input_type
class ServicePrincipalCertificateAuthInfoArgs:
    def __init__(__self__, *,
                 auth_type: pulumi.Input[str],
                 certificate: pulumi.Input[str],
                 client_id: pulumi.Input[str],
                 principal_id: pulumi.Input[str]):
        """
        The authentication info when authType is servicePrincipal certificate
        :param pulumi.Input[str] auth_type: The authentication type.
               Expected value is 'servicePrincipalCertificate'.
        :param pulumi.Input[str] certificate: ServicePrincipal certificate for servicePrincipal auth.
        :param pulumi.Input[str] client_id: Application clientId for servicePrincipal auth.
        :param pulumi.Input[str] principal_id: Principal Id for servicePrincipal auth.
        """
        pulumi.set(__self__, "auth_type", 'servicePrincipalCertificate')
        pulumi.set(__self__, "certificate", certificate)
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "principal_id", principal_id)

    @property
    @pulumi.getter(name="authType")
    def auth_type(self) -> pulumi.Input[str]:
        """
        The authentication type.
        Expected value is 'servicePrincipalCertificate'.
        """
        return pulumi.get(self, "auth_type")

    @auth_type.setter
    def auth_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "auth_type", value)

    @property
    @pulumi.getter
    def certificate(self) -> pulumi.Input[str]:
        """
        ServicePrincipal certificate for servicePrincipal auth.
        """
        return pulumi.get(self, "certificate")

    @certificate.setter
    def certificate(self, value: pulumi.Input[str]):
        pulumi.set(self, "certificate", value)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> pulumi.Input[str]:
        """
        Application clientId for servicePrincipal auth.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> pulumi.Input[str]:
        """
        Principal Id for servicePrincipal auth.
        """
        return pulumi.get(self, "principal_id")

    @principal_id.setter
    def principal_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "principal_id", value)


@pulumi.input_type
class ServicePrincipalSecretAuthInfoArgs:
    def __init__(__self__, *,
                 auth_type: pulumi.Input[str],
                 client_id: pulumi.Input[str],
                 principal_id: pulumi.Input[str],
                 secret: pulumi.Input[str]):
        """
        The authentication info when authType is servicePrincipal secret
        :param pulumi.Input[str] auth_type: The authentication type.
               Expected value is 'servicePrincipalSecret'.
        :param pulumi.Input[str] client_id: ServicePrincipal application clientId for servicePrincipal auth.
        :param pulumi.Input[str] principal_id: Principal Id for servicePrincipal auth.
        :param pulumi.Input[str] secret: Secret for servicePrincipal auth.
        """
        pulumi.set(__self__, "auth_type", 'servicePrincipalSecret')
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "secret", secret)

    @property
    @pulumi.getter(name="authType")
    def auth_type(self) -> pulumi.Input[str]:
        """
        The authentication type.
        Expected value is 'servicePrincipalSecret'.
        """
        return pulumi.get(self, "auth_type")

    @auth_type.setter
    def auth_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "auth_type", value)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> pulumi.Input[str]:
        """
        ServicePrincipal application clientId for servicePrincipal auth.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> pulumi.Input[str]:
        """
        Principal Id for servicePrincipal auth.
        """
        return pulumi.get(self, "principal_id")

    @principal_id.setter
    def principal_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "principal_id", value)

    @property
    @pulumi.getter
    def secret(self) -> pulumi.Input[str]:
        """
        Secret for servicePrincipal auth.
        """
        return pulumi.get(self, "secret")

    @secret.setter
    def secret(self, value: pulumi.Input[str]):
        pulumi.set(self, "secret", value)


@pulumi.input_type
class SystemAssignedIdentityAuthInfoArgs:
    def __init__(__self__, *,
                 auth_type: pulumi.Input[str]):
        """
        The authentication info when authType is systemAssignedIdentity
        :param pulumi.Input[str] auth_type: The authentication type.
               Expected value is 'systemAssignedIdentity'.
        """
        pulumi.set(__self__, "auth_type", 'systemAssignedIdentity')

    @property
    @pulumi.getter(name="authType")
    def auth_type(self) -> pulumi.Input[str]:
        """
        The authentication type.
        Expected value is 'systemAssignedIdentity'.
        """
        return pulumi.get(self, "auth_type")

    @auth_type.setter
    def auth_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "auth_type", value)


@pulumi.input_type
class UserAssignedIdentityAuthInfoArgs:
    def __init__(__self__, *,
                 auth_type: pulumi.Input[str],
                 client_id: pulumi.Input[str],
                 subscription_id: pulumi.Input[str]):
        """
        The authentication info when authType is userAssignedIdentity
        :param pulumi.Input[str] auth_type: The authentication type.
               Expected value is 'userAssignedIdentity'.
        :param pulumi.Input[str] client_id: Client Id for userAssignedIdentity.
        :param pulumi.Input[str] subscription_id: Subscription id for userAssignedIdentity.
        """
        pulumi.set(__self__, "auth_type", 'userAssignedIdentity')
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "subscription_id", subscription_id)

    @property
    @pulumi.getter(name="authType")
    def auth_type(self) -> pulumi.Input[str]:
        """
        The authentication type.
        Expected value is 'userAssignedIdentity'.
        """
        return pulumi.get(self, "auth_type")

    @auth_type.setter
    def auth_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "auth_type", value)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> pulumi.Input[str]:
        """
        Client Id for userAssignedIdentity.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> pulumi.Input[str]:
        """
        Subscription id for userAssignedIdentity.
        """
        return pulumi.get(self, "subscription_id")

    @subscription_id.setter
    def subscription_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "subscription_id", value)


@pulumi.input_type
class VNetSolutionArgs:
    def __init__(__self__, *,
                 type: Optional[pulumi.Input[Union[str, 'VNetSolutionType']]] = None):
        """
        The VNet solution for linker
        :param pulumi.Input[Union[str, 'VNetSolutionType']] type: Type of VNet solution.
        """
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[Union[str, 'VNetSolutionType']]]:
        """
        Type of VNet solution.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[Union[str, 'VNetSolutionType']]]):
        pulumi.set(self, "type", value)


