# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'Sku',
    'Storage',
]

@pulumi.input_type
class Sku:
    def __init__(__self__, *,
                 name: str,
                 tier: Union[str, 'SkuTier']):
        """
        Sku information related properties of a server.
        :param str name: The name of the sku, typically, tier + family + cores, e.g. Standard_D4s_v3.
        :param Union[str, 'SkuTier'] tier: The tier of the particular SKU, e.g. Burstable.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "tier", tier)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the sku, typically, tier + family + cores, e.g. Standard_D4s_v3.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tier(self) -> Union[str, 'SkuTier']:
        """
        The tier of the particular SKU, e.g. Burstable.
        """
        return pulumi.get(self, "tier")

    @tier.setter
    def tier(self, value: Union[str, 'SkuTier']):
        pulumi.set(self, "tier", value)


@pulumi.input_type
class Storage:
    def __init__(__self__, *,
                 storage_size_gb: Optional[int] = None):
        """
        Storage properties of a server
        :param int storage_size_gb: Max storage allowed for a server.
        """
        if storage_size_gb is not None:
            pulumi.set(__self__, "storage_size_gb", storage_size_gb)

    @property
    @pulumi.getter(name="storageSizeGB")
    def storage_size_gb(self) -> Optional[int]:
        """
        Max storage allowed for a server.
        """
        return pulumi.get(self, "storage_size_gb")

    @storage_size_gb.setter
    def storage_size_gb(self, value: Optional[int]):
        pulumi.set(self, "storage_size_gb", value)


